/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.util;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import java.util.List;
import java.util.regex.Pattern;

public class RepositoryLabelIDHelper {
    protected static final Pattern RESOURCE_ID_INVALID_CHAR = Pattern.compile("[^\\p{L}\\p{N}]");
    protected static final String RESOURCE_ID_CHAR_REPLACEMENT = "_";

    public static String generateIdBasedOnLabel(RepositoryService repository, String parentFolder, String label) {
        String id;
        String inputLabel;
        String string = inputLabel = label == null ? "" : label.trim();
        if ("".equals(inputLabel)) {
            return "";
        }
        FilterCriteria criteria = FilterCriteria.createFilter();
        criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)parentFolder));
        List listOfResources = repository.loadResourcesList(null, criteria);
        List repoFolderList = repository.getSubFolders(null, parentFolder);
        listOfResources.addAll(repoFolderList);
        String newId = id = RESOURCE_ID_INVALID_CHAR.matcher(inputLabel).replaceAll(RESOURCE_ID_CHAR_REPLACEMENT);
        boolean doesInternalNameExist = true;
        int i = 0;
        while (doesInternalNameExist) {
            doesInternalNameExist = false;
            for (int j = 0; j < listOfResources.size(); ++j) {
                String curInternalName = ((Resource)listOfResources.get(j)).getName();
                if (curInternalName == null) {
                    curInternalName = "";
                }
                if (!curInternalName.equalsIgnoreCase(newId)) continue;
                doesInternalNameExist = true;
                break;
            }
            if (!doesInternalNameExist) continue;
            newId = id + RESOURCE_ID_CHAR_REPLACEMENT + ++i;
        }
        return newId;
    }
}

