/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;

public class RepoFileResource
extends RepoResource {
    private static final Log log = LogFactory.getLog(RepoFileResource.class);
    private String fileType;
    private Blob data;
    private RepoFileResource reference;

    public Blob getData() {
        return this.data;
    }

    public void setData(Blob data) {
        this.data = data;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String type) {
        this.fileType = type;
    }

    public String getFinalFileType() {
        RepoFileResource res = this;
        while (res.isFileReference()) {
            res = res.getReference();
        }
        return res.getFileType();
    }

    public boolean isFileReference() {
        return this.getReference() != null;
    }

    public RepoFileResource getReference() {
        return this.reference;
    }

    public void setReference(RepoFileResource reference) {
        this.reference = reference;
    }

    protected Class getClientItf() {
        return FileResource.class;
    }

    protected void copyTo(Resource clientRes, ResourceFactory resourceFactory) {
        super.copyTo(clientRes, resourceFactory);
        FileResource fileRes = (FileResource)clientRes;
        if (this.isFileReference()) {
            RepoFileResource ref = this.getReference();
            fileRes.setFileType(null);
            fileRes.setData(null);
            fileRes.setReferenceURI(ref.getResourceURI());
        } else {
            fileRes.setFileType(this.getFileType());
            if (this.hasClientOption("fullData")) {
                this.copyDataTo(fileRes);
            } else {
                fileRes.setData(null);
            }
            fileRes.setReferenceURI(null);
        }
    }

    protected void copyDataTo(FileResource fileRes) {
        Blob blob = this.getData();
        if (blob == null) {
            fileRes.setData(null);
        } else {
            try {
                fileRes.readData(blob.getBinaryStream());
            }
            catch (SQLException e) {
                log.error((Object)("Error while reading data blob of \"" + this.getResourceURI() + "\""), (Throwable)e);
                throw new JSExceptionWrapper((Exception)e);
            }
        }
    }

    public FileResourceData copyData() {
        try {
            if (this.isFileReference()) {
                String quotedResourceURI = "\"" + this.getResourceURI() + "\"";
                throw new JSException("jsexception.file.resource.is.reference", new Object[]{quotedResourceURI});
            }
            Blob blob = this.getData();
            FileResourceData resData = blob == null ? new FileResourceData((byte[])null) : new FileResourceData(blob.getBinaryStream());
            return resData;
        }
        catch (SQLException e) {
            log.error((Object)("Error while reading data blob of \"" + this.getResourceURI() + "\""), (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    protected void copyDataFrom(FileResource dataRes) {
        if (dataRes.isReference()) {
            this.setData(null);
        } else if (dataRes.hasData()) {
            byte[] clientData = dataRes.getData();
            Blob blob = Hibernate.createBlob((byte[])clientData);
            this.setData(blob);
        }
    }

    protected void copyFrom(Resource clientRes, ReferenceResolver referenceResolver) {
        super.copyFrom(clientRes, referenceResolver);
        FileResource dataRes = (FileResource)clientRes;
        if (dataRes.isReference()) {
            this.setFileType(null);
            this.setData(null);
            RepoFileResource externalReference = (RepoFileResource)referenceResolver.getExternalReference(dataRes.getReferenceURI(), RepoFileResource.class);
            if (dataRes.getFileType() != null && !dataRes.getFileType().equals(externalReference.getFinalFileType())) {
                throw new JSException("jsexception.file.resource.no.match.type", new Object[]{dataRes.getFileType(), externalReference.getFileType()});
            }
            this.setReference(externalReference);
        } else {
            this.setFileType(dataRes.getFileType());
            this.copyDataFrom(dataRes);
            this.setReference(null);
        }
    }
}

