/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.CustomReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.CustomDataSourceValidator;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.CustomReportDataSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.util.JRProperties;

public class CustomDataSourceDefinition
implements Serializable {
    public static final String PARAM_NAME = "name";
    public static final String PARAM_LABEL = "label";
    public static final String PARAM_DEFAULT = "default";
    public static final String PARAM_HIDDEN = "hidden";
    private transient CustomReportDataSourceServiceFactory factory;
    private String name;
    private String serviceClassName;
    private CustomDataSourceValidator validator;
    private List propertyDefinitions;
    private Map queryExecuterMap;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFactory(CustomReportDataSourceServiceFactory factory) {
        this.factory = factory;
        factory.addDefinition(this);
    }

    public CustomReportDataSourceServiceFactory getFactory() {
        return this.factory;
    }

    public void setServiceClassName(String serviceClassName) {
        this.serviceClassName = serviceClassName;
    }

    public String getServiceClassName() {
        return this.serviceClassName;
    }

    public void setValidator(CustomDataSourceValidator validator) {
        this.validator = validator;
    }

    public CustomDataSourceValidator getValidator() {
        return this.validator;
    }

    public void setPropertyDefinitions(List propertyDefinitions) {
        this.propertyDefinitions = new ArrayList();
        for (Map pd : propertyDefinitions) {
            HashMap<String, String> newPd = new HashMap<String, String>(pd);
            newPd.put(PARAM_LABEL, this.getParameterLabelName((String)newPd.get(PARAM_NAME)));
            this.propertyDefinitions.add(newPd);
        }
    }

    public List getPropertyDefinitions() {
        return this.propertyDefinitions;
    }

    public String getLabelName() {
        return this.name + ".name";
    }

    public String getParameterLabelName(String paramName) {
        return this.name + ".properties." + paramName;
    }

    public List getEditablePropertyDefinitions() {
        ArrayList list = new ArrayList(this.propertyDefinitions);
        Iterator pdi = list.iterator();
        while (pdi.hasNext()) {
            Map pd = (Map)pdi.next();
            String hidden = (String)pd.get(PARAM_HIDDEN);
            if (!Boolean.parseBoolean(hidden)) continue;
            pdi.remove();
        }
        return list;
    }

    public Map getQueryExecuterMap() {
        return this.queryExecuterMap;
    }

    public void setQueryExecuterMap(Map queryExecuterMap) {
        this.queryExecuterMap = queryExecuterMap;
        if (queryExecuterMap == null) {
            return;
        }
        for (String lang : queryExecuterMap.keySet()) {
            String qefClassName = (String)queryExecuterMap.get(lang);
            JRProperties.setProperty((String)("net.sf.jasperreports.query.executer.factory." + lang), (String)qefClassName);
        }
    }

    public void setDefaultValues(CustomReportDataSource cds, boolean includeHidden) {
        if (cds.getPropertyMap() == null) {
            cds.setPropertyMap(new HashMap());
        }
        for (Map pd : this.propertyDefinitions) {
            String value;
            String name = (String)pd.get(PARAM_NAME);
            Object def = pd.get(PARAM_DEFAULT);
            String hidden = (String)pd.get(PARAM_HIDDEN);
            if (Boolean.parseBoolean(hidden) && !includeHidden || (value = (String)cds.getPropertyMap().get(name)) != null) continue;
            if (def == null) {
                def = "";
            }
            cds.getPropertyMap().put(name, def);
        }
    }
}

