/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.util.CharacterEncodingProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.HyperlinkParameterFormatter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseReportExecutionHyperlinkProducerFactory
implements Serializable {
    protected static final Log log = LogFactory.getLog(BaseReportExecutionHyperlinkProducerFactory.class);
    private HyperlinkParameterFormatter dateFormatter;
    private CharacterEncodingProvider encodingProvider;
    private String flowControllerMapping;
    private String reportExecutionFlowId;
    private String hyperlinkParameterReportUnit;
    private String urlParameterReportUnit;
    private String defaultOutputChannel;
    private String hyperlinkParameterOutputChannel;
    private String urlParameterOutputChannel;
    private String hyperlinkParameterPageIndex;
    private String urlParameterPageIndex;
    private String hyperlinkParameterAnchor;
    private String urlParameterAnchor;

    public HyperlinkParameterFormatter getDateFormatter() {
        return this.dateFormatter;
    }

    public void setDateFormatter(HyperlinkParameterFormatter dateFormatter) {
        this.dateFormatter = dateFormatter;
    }

    public String getFlowControllerMapping() {
        return this.flowControllerMapping;
    }

    public void setFlowControllerMapping(String flowControllerMapping) {
        this.flowControllerMapping = flowControllerMapping;
    }

    public String getReportExecutionFlowId() {
        return this.reportExecutionFlowId;
    }

    public void setReportExecutionFlowId(String reportExecutionFlowId) {
        this.reportExecutionFlowId = reportExecutionFlowId;
    }

    public String getHyperlinkParameterReportUnit() {
        return this.hyperlinkParameterReportUnit;
    }

    public void setHyperlinkParameterReportUnit(String hyperlinkParameterReportUnitURI) {
        this.hyperlinkParameterReportUnit = hyperlinkParameterReportUnitURI;
    }

    public String getUrlParameterReportUnit() {
        return this.urlParameterReportUnit;
    }

    public void setUrlParameterReportUnit(String urlParameterReportUnitURI) {
        this.urlParameterReportUnit = urlParameterReportUnitURI;
    }

    public String getDefaultOutputChannel() {
        return this.defaultOutputChannel;
    }

    public void setDefaultOutputChannel(String defaultOutputChannel) {
        this.defaultOutputChannel = defaultOutputChannel;
    }

    public String getHyperlinkParameterOutputChannel() {
        return this.hyperlinkParameterOutputChannel;
    }

    public void setHyperlinkParameterOutputChannel(String hyperlinkParameterOutputChannel) {
        this.hyperlinkParameterOutputChannel = hyperlinkParameterOutputChannel;
    }

    public String getUrlParameterOutputChannel() {
        return this.urlParameterOutputChannel;
    }

    public void setUrlParameterOutputChannel(String urlParameterOutputChannel) {
        this.urlParameterOutputChannel = urlParameterOutputChannel;
    }

    public CharacterEncodingProvider getEncodingProvider() {
        return this.encodingProvider;
    }

    public void setEncodingProvider(CharacterEncodingProvider encodingProvider) {
        this.encodingProvider = encodingProvider;
    }

    public String getHyperlinkParameterPageIndex() {
        return this.hyperlinkParameterPageIndex;
    }

    public void setHyperlinkParameterPageIndex(String hyperlinkParameterPageIndex) {
        this.hyperlinkParameterPageIndex = hyperlinkParameterPageIndex;
    }

    public String getUrlParameterPageIndex() {
        return this.urlParameterPageIndex;
    }

    public void setUrlParameterPageIndex(String urlParameterPageIndex) {
        this.urlParameterPageIndex = urlParameterPageIndex;
    }

    public String getHyperlinkParameterAnchor() {
        return this.hyperlinkParameterAnchor;
    }

    public void setHyperlinkParameterAnchor(String hyperlinkParameterAnchor) {
        this.hyperlinkParameterAnchor = hyperlinkParameterAnchor;
    }

    public String getUrlParameterAnchor() {
        return this.urlParameterAnchor;
    }

    public void setUrlParameterAnchor(String urlParameterAnchor) {
        this.urlParameterAnchor = urlParameterAnchor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class BaseHyperlinkProducer
    implements JRHyperlinkProducer,
    Serializable {
        public String getHyperlink(JRPrintHyperlink hyperlink) {
            StringBuffer sb = new StringBuffer();
            this.appendHyperlinkStart(hyperlink, sb);
            sb.append(BaseReportExecutionHyperlinkProducerFactory.this.getFlowControllerMapping());
            sb.append("?_flowId=");
            sb.append(BaseReportExecutionHyperlinkProducerFactory.this.getReportExecutionFlowId());
            JRPrintHyperlinkParameters parameters = hyperlink.getHyperlinkParameters();
            if (parameters != null) {
                this.appendParameters(sb, parameters);
            }
            this.appendAdditionalParameters(hyperlink, sb);
            return sb.toString();
        }

        protected void appendParameters(StringBuffer sb, JRPrintHyperlinkParameters parameters) {
            boolean outputChannelSet = false;
            for (JRPrintHyperlinkParameter parameter : parameters.getParameters()) {
                if (parameter.getName().equals(BaseReportExecutionHyperlinkProducerFactory.this.getHyperlinkParameterReportUnit())) {
                    String paramReportURI = this.getParameterReportURI((String)parameter.getValue());
                    this.appendParameter(sb, BaseReportExecutionHyperlinkProducerFactory.this.getUrlParameterReportUnit(), paramReportURI);
                    continue;
                }
                if (parameter.getName().equals(BaseReportExecutionHyperlinkProducerFactory.this.getHyperlinkParameterOutputChannel())) {
                    this.appendParameter(sb, BaseReportExecutionHyperlinkProducerFactory.this.getUrlParameterOutputChannel(), (String)parameter.getValue());
                    outputChannelSet = true;
                    continue;
                }
                if (parameter.getName().equals(BaseReportExecutionHyperlinkProducerFactory.this.getHyperlinkParameterPageIndex())) {
                    this.appendParameter(sb, BaseReportExecutionHyperlinkProducerFactory.this.getUrlParameterPageIndex(), parameter);
                    continue;
                }
                if (parameter.getName().equals(BaseReportExecutionHyperlinkProducerFactory.this.getHyperlinkParameterAnchor())) {
                    this.appendParameter(sb, BaseReportExecutionHyperlinkProducerFactory.this.getUrlParameterAnchor(), (String)parameter.getValue());
                    continue;
                }
                this.appendParameter(sb, parameter);
            }
            if (!outputChannelSet && BaseReportExecutionHyperlinkProducerFactory.this.getDefaultOutputChannel() != null) {
                this.appendParameter(sb, BaseReportExecutionHyperlinkProducerFactory.this.getUrlParameterOutputChannel(), BaseReportExecutionHyperlinkProducerFactory.this.getDefaultOutputChannel());
            }
        }

        protected String getParameterReportURI(String reportURI) {
            return reportURI;
        }

        protected String encode(String text) {
            try {
                String encoding = BaseReportExecutionHyperlinkProducerFactory.this.getEncodingProvider().getCharacterEncoding();
                return URLEncoder.encode(text, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
        }

        protected void appendParameter(StringBuffer sb, JRPrintHyperlinkParameter parameter) {
            this.appendParameter(sb, parameter.getName(), parameter);
        }

        protected void appendParameter(StringBuffer sb, String paramName, JRPrintHyperlinkParameter parameter) {
            String valueClassName = parameter.getValueClass();
            Class valueClass = this.loadClass(valueClassName);
            Object value = parameter.getValue();
            if (valueClass.isArray()) {
                if (value != null) {
                    this.appendMultiParameter(sb, paramName, (Iterator<?>)new ArrayIterator(value));
                }
            } else if (Collection.class.isAssignableFrom(valueClass)) {
                if (value != null) {
                    this.appendMultiParameter(sb, paramName, ((Collection)value).iterator());
                }
            } else {
                this.appendSingleParameter(sb, paramName, valueClass, value);
            }
        }

        protected void appendMultiParameter(StringBuffer sb, String paramName, Iterator<?> values) {
            while (values.hasNext()) {
                Object value = values.next();
                Class valueClass = value == null ? String.class : value.getClass();
                this.appendSingleParameter(sb, paramName, valueClass, value);
            }
        }

        protected void appendSingleParameter(StringBuffer sb, String paramName, Class<?> valueClass, Object value) {
            if (valueClass.equals(String.class)) {
                this.appendParameter(sb, paramName, (String)value);
            } else if (valueClass.equals(Boolean.class)) {
                if (value != null && ((Boolean)value).booleanValue()) {
                    this.appendParameter(sb, paramName, "true");
                }
            } else if (Number.class.isAssignableFrom(valueClass)) {
                if (value != null) {
                    this.appendParameter(sb, paramName, value.toString());
                }
            } else if (Date.class.isAssignableFrom(valueClass)) {
                if (value != null) {
                    String formattedValue = BaseReportExecutionHyperlinkProducerFactory.this.getDateFormatter().format(value);
                    this.appendParameter(sb, paramName, formattedValue);
                }
            } else {
                log.warn((Object)("Unknown hyperlink parameter type " + valueClass));
            }
        }

        protected Class loadClass(String valueClassName) {
            try {
                return Class.forName(valueClassName);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Parameter class \"" + valueClassName + "\" not found"), (Throwable)e);
                throw new JSExceptionWrapper((Exception)e);
            }
        }

        protected final void appendParameter(StringBuffer sb, String name, String value) {
            sb.append('&');
            sb.append(this.encode(name));
            if (value != null) {
                sb.append('=');
                sb.append(this.encode(value));
            }
        }

        protected abstract void appendHyperlinkStart(JRPrintHyperlink var1, StringBuffer var2);

        protected abstract void appendAdditionalParameters(JRPrintHyperlink var1, StringBuffer var2);
    }
}

