/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.ConfigUtils;
import org.springframework.security.ui.logout.SecurityContextLogoutHandler;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class LogoutBeanDefinitionParser
implements BeanDefinitionParser {
    static final String ATT_LOGOUT_SUCCESS_URL = "logout-success-url";
    static final String DEF_LOGOUT_SUCCESS_URL = "/";
    static final String ATT_INVALIDATE_SESSION = "invalidate-session";
    static final String DEF_INVALIDATE_SESSION = "true";
    static final String ATT_LOGOUT_URL = "logout-url";
    static final String DEF_LOGOUT_URL = "/j_spring_security_logout";
    String rememberMeServices;
    static /* synthetic */ Class class$org$springframework$security$ui$logout$LogoutFilter;

    public LogoutBeanDefinitionParser(String rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String logoutUrl = null;
        String logoutSuccessUrl = null;
        String invalidateSession = null;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$security$ui$logout$LogoutFilter == null ? (class$org$springframework$security$ui$logout$LogoutFilter = LogoutBeanDefinitionParser.class$("org.springframework.security.ui.logout.LogoutFilter")) : class$org$springframework$security$ui$logout$LogoutFilter));
        if (element != null) {
            Object source = parserContext.extractSource((Object)element);
            builder.setSource(source);
            logoutUrl = element.getAttribute(ATT_LOGOUT_URL);
            ConfigUtils.validateHttpRedirect(logoutUrl, parserContext, source);
            logoutSuccessUrl = element.getAttribute(ATT_LOGOUT_SUCCESS_URL);
            ConfigUtils.validateHttpRedirect(logoutSuccessUrl, parserContext, source);
            invalidateSession = element.getAttribute(ATT_INVALIDATE_SESSION);
        }
        if (!StringUtils.hasText(logoutUrl)) {
            logoutUrl = DEF_LOGOUT_URL;
        }
        builder.addPropertyValue("filterProcessesUrl", (Object)logoutUrl);
        if (!StringUtils.hasText(logoutSuccessUrl)) {
            logoutSuccessUrl = DEF_LOGOUT_SUCCESS_URL;
        }
        builder.addConstructorArg((Object)logoutSuccessUrl);
        if (!StringUtils.hasText(invalidateSession)) {
            invalidateSession = DEF_INVALIDATE_SESSION;
        }
        ManagedList handlers = new ManagedList();
        SecurityContextLogoutHandler sclh = new SecurityContextLogoutHandler();
        if (DEF_INVALIDATE_SESSION.equals(invalidateSession)) {
            sclh.setInvalidateHttpSession(true);
        } else {
            sclh.setInvalidateHttpSession(false);
        }
        handlers.add(sclh);
        if (this.rememberMeServices != null) {
            handlers.add(new RuntimeBeanReference(this.rememberMeServices));
        }
        builder.addConstructorArg((Object)handlers);
        parserContext.getRegistry().registerBeanDefinition("_logoutFilter", (BeanDefinition)builder.getBeanDefinition());
        ConfigUtils.addHttpFilter(parserContext, (BeanMetadataElement)new RuntimeBeanReference("_logoutFilter"));
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

