/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxCellHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxSheetRelsHelper;
import net.sf.jasperreports.engine.util.FileBufferedWriter;
import net.sf.jasperreports.engine.util.JRProperties;

public class XlsxSheetHelper
extends BaseHelper {
    private int rowIndex;
    private FileBufferedWriter colsWriter = new FileBufferedWriter();
    private FileBufferedWriter mergedCellsWriter = new FileBufferedWriter();
    private FileBufferedWriter hyperlinksWriter = new FileBufferedWriter();
    private boolean isCollapseRowSpan;
    private XlsxSheetRelsHelper sheetRelsHelper;

    public XlsxSheetHelper(Writer writer, XlsxSheetRelsHelper sheetRelsHelper, boolean isCollapseRowSpan) {
        super(writer);
        this.sheetRelsHelper = sheetRelsHelper;
        this.isCollapseRowSpan = isCollapseRowSpan;
    }

    public void exportHeader() {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write("<worksheet\n");
        this.write(" xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\"\n");
        this.write(" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">\n");
        this.write("<dimension ref=\"A1\"/><sheetViews><sheetView workbookViewId=\"0\"/></sheetViews>\n");
        this.write("<sheetFormatPr defaultRowHeight=\"15\"/>\n");
    }

    public void exportHeader(int rowFreeze, int columnFreeze, JasperPrint jasperPrint) {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write("<worksheet\n");
        this.write(" xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\"\n");
        this.write(" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">\n");
        this.write("<dimension ref=\"A1\"/><sheetViews><sheetView workbookViewId=\"0\"");
        if (rowFreeze > 0 || columnFreeze > 0) {
            this.write(">\n<pane xSplit=\"" + columnFreeze + "\" ySplit=\"" + rowFreeze + "\"");
            String columnName = JRProperties.getProperty(jasperPrint, "net.sf.jasperreports.export.xls.freeze.column") == null ? "A" : JRProperties.getProperty(jasperPrint, "net.sf.jasperreports.export.xls.freeze.column");
            this.write(" topLeftCell=\"" + columnName + Math.min(65536, rowFreeze + 1) + "\"");
            this.write(" activePane=\"bottomRight\" state=\"frozen\"/>\n");
            this.write("<selection pane=\"topRight\"/>\n");
            this.write("<selection pane=\"bottomLeft\"/>\n");
            this.write("<selection pane=\"bottomRight\"/>\n");
            this.write("</sheetView>\n</sheetViews>\n");
        } else {
            this.write("/></sheetViews>\n");
        }
        this.write("<sheetFormatPr defaultRowHeight=\"15\"/>\n");
    }

    public void exportFooter(int index, JasperPrint jasperPrint, boolean isIgnorePageMargins) {
        if (this.rowIndex > 0) {
            this.write("</row>\n");
        } else {
            if (!this.colsWriter.isEmpty()) {
                this.write("<cols>\n");
                this.colsWriter.writeData(this.writer);
                this.write("</cols>\n");
            }
            this.write("<sheetData>\n");
        }
        this.write("</sheetData>\n");
        if (!this.mergedCellsWriter.isEmpty()) {
            this.write("<mergeCells>\n");
            this.mergedCellsWriter.writeData(this.writer);
            this.write("</mergeCells>\n");
        }
        if (!this.hyperlinksWriter.isEmpty()) {
            this.write("<hyperlinks>\n");
            this.hyperlinksWriter.writeData(this.writer);
            this.write("</hyperlinks>\n");
        }
        this.write("<pageMargins left=\"");
        this.write(String.valueOf(jasperPrint.getLeftMargin() == null ? (double)0.7f : LengthUtil.inchNoRound(isIgnorePageMargins ? 0.0 : (double)jasperPrint.getLeftMargin().intValue())));
        this.write("\" right=\"");
        this.write(String.valueOf(jasperPrint.getRightMargin() == null ? (double)0.7f : LengthUtil.inchNoRound(isIgnorePageMargins ? 0.0 : (double)jasperPrint.getRightMargin().intValue())));
        this.write("\" top=\"");
        this.write(String.valueOf(jasperPrint.getTopMargin() == null ? 0.75 : LengthUtil.inchNoRound(isIgnorePageMargins ? 0.0 : (double)jasperPrint.getTopMargin().intValue())));
        this.write("\" bottom=\"");
        this.write(String.valueOf(jasperPrint.getBottomMargin() == null ? 0.75 : LengthUtil.inchNoRound(isIgnorePageMargins ? 0.0 : (double)jasperPrint.getBottomMargin().intValue())));
        this.write("\" header=\"0.0\" footer=\"0.0\"/>\n");
        if (jasperPrint.getOrientationValue() != null) {
            this.write("<pageSetup orientation=\"" + jasperPrint.getOrientationValue().getName().toLowerCase() + "\"/>\n");
        }
        this.write("<drawing r:id=\"rIdDr" + index + "\"/></worksheet>");
    }

    public void exportColumn(int colIndex, int colWidth) {
        try {
            this.colsWriter.write("<col min=\"" + (colIndex + 1) + "\" max=\"" + (colIndex + 1) + "\" customWidth=\"1\" width=\"" + 3.0f * (float)colWidth / 18.0f + "\"/>\n");
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void exportRow(int rowHeight) {
        if (this.rowIndex > 0) {
            this.write("</row>\n");
        } else {
            if (!this.colsWriter.isEmpty()) {
                this.write("<cols>\n");
                this.colsWriter.writeData(this.writer);
                this.write("</cols>\n");
            }
            this.write("<sheetData>\n");
        }
        ++this.rowIndex;
        this.write("<row r=\"" + this.rowIndex + "\" customHeight=\"1\" ht=\"" + rowHeight + "\">\n");
    }

    public void exportMergedCells(int row, int col, int rowSpan, int colSpan) {
        int n = rowSpan = this.isCollapseRowSpan ? 1 : rowSpan;
        if (rowSpan > 1 || colSpan > 1) {
            String ref = XlsxCellHelper.getColumIndexLetter(col) + (row + 1) + ":" + XlsxCellHelper.getColumIndexLetter(col + colSpan - 1) + (row + rowSpan);
            try {
                this.mergedCellsWriter.write("<mergeCell ref=\"" + ref + "\"/>\n");
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
    }

    public void exportHyperlink(int row, int col, String href) {
        String ref = XlsxCellHelper.getColumIndexLetter(col) + (row + 1);
        try {
            this.hyperlinksWriter.write("<hyperlink ref=\"" + ref + "\" r:id=\"rIdLnk" + this.sheetRelsHelper.getHyperlink(href) + "\"/>\n");
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }
}

