/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.RepositorySecurityChecker;
import com.jaspersoft.jasperserver.api.metadata.user.service.ObjectPermissionService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.search.common.ResourceDetails;
import com.jaspersoft.jasperserver.search.common.SchedulingChecker;
import com.jaspersoft.jasperserver.search.service.ChildrenLoaderService;
import com.jaspersoft.jasperserver.search.service.ResourceService;
import com.jaspersoft.jasperserver.search.service.impl.BaseService;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceServiceImpl
extends BaseService
implements ResourceService {
    private static final Log log = LogFactory.getLog(ResourceServiceImpl.class);
    private RepositorySecurityChecker securityChecker;
    protected ObjectPermissionService permissionService;
    private SchedulingChecker schedulingChecker;
    private Map<String, ChildrenLoaderService> childrenLoaders;
    private List<String> deleteOrder;

    @Override
    public ResourceDetails update(String uri, String label, String description) {
        String parentUri = uri.substring(0, uri.lastIndexOf("/"));
        FilterCriteria criteria = FilterCriteria.createFilter();
        criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)parentUri));
        Resource resource = this.repositoryService.getResource(null, uri);
        if (!label.equals(resource.getLabel()) || !description.equals(resource.getDescription())) {
            resource.setLabel(label);
            resource.setDescription(description);
            this.repositoryService.saveResource(null, resource);
        }
        return this.getResourceDetails(this.repositoryService.getResource(null, uri));
    }

    @Override
    public void delete(List<Resource> resources) {
        Collections.sort(resources, new Comparator<Resource>(){

            @Override
            public int compare(Resource o1, Resource o2) {
                int index2;
                int index1 = ResourceServiceImpl.this.deleteOrder.indexOf(o1.getResourceType());
                return index1 < (index2 = ResourceServiceImpl.this.deleteOrder.indexOf(o2.getResourceType())) ? -1 : (index1 == index2 ? 0 : 1);
            }
        });
        for (Resource resource : resources) {
            this.repositoryService.deleteResource(null, resource.getURIString());
        }
    }

    @Override
    public void copy(Set<String> resourceUris, String destinationFolderUri) {
        Map<String, Resource> resourceMap = this.getResourceMap(resourceUris);
        if (!this.isLabelsUnique(resourceMap) || this.isObjectsLabelsExist(destinationFolderUri, this.getLabels(resourceMap))) {
            throw new JSException("jsexception.search.duplicate.label", new Object[]{"", destinationFolderUri});
        }
        while (this.getResourcesWithUniqueName(resourceMap).size() > 0) {
            Map<String, Resource> resources = this.getResourcesWithUniqueName(resourceMap);
            Set<String> uris = resources.keySet();
            this.repositoryService.copyResources(null, uris.toArray(new String[uris.size()]), destinationFolderUri);
            for (String key : resources.keySet()) {
                resourceMap.remove(key);
            }
        }
    }

    private Set<String> getLabels(Map<String, Resource> resourceMap) {
        HashSet<String> result = new HashSet<String>();
        for (Resource resource : resourceMap.values()) {
            result.add(resource.getLabel());
        }
        return result;
    }

    @Override
    public void move(Set<String> resourceUris, String destinationFolderUri) {
        Map<String, Resource> resourceMap = this.getResourceMap(resourceUris);
        if (!this.isLabelsUnique(resourceMap) || this.isObjectsLabelsExist(destinationFolderUri, this.getLabels(resourceMap))) {
            throw new JSException("jsexception.search.duplicate.label", new Object[]{"", destinationFolderUri});
        }
        if (resourceMap.size() != this.getResourcesWithUniqueName(resourceMap).size()) {
            throw new JSException("jsexception.search.duplicate.name", new Object[]{"", destinationFolderUri});
        }
        for (String uri : resourceMap.keySet()) {
            this.repositoryService.moveResource(null, uri, destinationFolderUri);
        }
    }

    @Override
    public ResourceDetails getResourceDetails(Resource resource) {
        ResourceDetails resourceDetails = new ResourceDetails(resource);
        if (this.securityChecker != null) {
            resourceDetails.setReadable(true);
            resourceDetails.setEditable(this.securityChecker.isEditable(resource));
            resourceDetails.setRemovable(this.securityChecker.isRemovable(resource));
            resourceDetails.setAdministrable(this.permissionService.isObjectAdministrable(null, (Object)resource));
            resourceDetails.setScheduled(this.schedulingChecker.isScheduled(null, resource));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Repository security checker is null!");
        }
        if (this.schedulingChecker != null) {
            resourceDetails.setScheduled(this.schedulingChecker.isScheduled(null, resource));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Scheduling checker is null!");
        }
        ChildrenLoaderService childrenLoaderService = this.childrenLoaders.get(resource.getResourceType());
        if (childrenLoaderService != null) {
            resourceDetails.setHasChildren(childrenLoaderService.hasChildren(resourceDetails.getURIString()));
        } else {
            resourceDetails.setHasChildren(false);
        }
        return resourceDetails;
    }

    public void setSecurityChecker(RepositorySecurityChecker securityChecker) {
        this.securityChecker = securityChecker;
    }

    public void setDeleteOrder(List<String> deleteOrder) {
        this.deleteOrder = deleteOrder;
    }

    public void setPermissionService(ObjectPermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setSchedulingChecker(SchedulingChecker schedulingChecker) {
        this.schedulingChecker = schedulingChecker;
    }

    public void setChildrenLoaders(Map<String, ChildrenLoaderService> childrenLoaders) {
        this.childrenLoaders = childrenLoaders;
    }
}

