/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.search.SearchCriteriaFactory;
import com.jaspersoft.jasperserver.api.search.SearchFilter;
import com.jaspersoft.jasperserver.api.search.SearchSorter;
import com.jaspersoft.jasperserver.api.search.TransformerFactory;
import com.jaspersoft.jasperserver.search.common.ResourceDetails;
import com.jaspersoft.jasperserver.search.service.ChildrenLoaderService;
import com.jaspersoft.jasperserver.search.service.RepositorySearchService;
import com.jaspersoft.jasperserver.search.service.ResourceService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositorySearchServiceImpl
implements RepositorySearchService {
    private RepositoryService repositoryService;
    private ResourceService resourceService;
    private TransformerFactory transformerFactory;
    private Map<String, ChildrenLoaderService> childrenLoaders;

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    @Override
    public List<ResourceDetails> getResults(ExecutionContext context, SearchCriteriaFactory searchCriteriaFactory, List<SearchFilter> filters, SearchSorter sorter, int current, int max) {
        List resources = this.repositoryService.getResources(context, searchCriteriaFactory, filters, sorter, this.transformerFactory, current, max);
        return this.getResourceDetailsList(resources);
    }

    @Override
    public int getResultsCount(ExecutionContext context, SearchCriteriaFactory searchCriteriaFactory, List<SearchFilter> filters, SearchSorter sorter) {
        return this.repositoryService.getResourcesCount(context, searchCriteriaFactory, filters, sorter, this.transformerFactory);
    }

    @Override
    public List<ResourceDetails> getResourceChildren(String type, String resourceUri) {
        ChildrenLoaderService childrenLoaderService = this.childrenLoaders.get(type);
        if (childrenLoaderService != null) {
            return this.getResourceDetailsList(childrenLoaderService.getChildren(resourceUri));
        }
        return Collections.emptyList();
    }

    private List<ResourceDetails> getResourceDetailsList(List<ResourceLookup> resources) {
        ArrayList<ResourceDetails> list = new ArrayList<ResourceDetails>();
        for (ResourceLookup resource : resources) {
            ResourceDetails resourceDetails = this.resourceService.getResourceDetails((Resource)resource);
            list.add(resourceDetails);
        }
        return list;
    }

    public void setChildrenLoaders(Map<String, ChildrenLoaderService> childrenLoaders) {
        this.childrenLoaders = childrenLoaders;
    }
}

