/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedGenericMethodBinding
extends ParameterizedMethodBinding
implements Substitution {
    public TypeBinding[] typeArguments;
    private LookupEnvironment environment;
    public boolean inferredReturnType;
    public boolean wasInferred;
    public boolean isRaw;
    public MethodBinding tiebreakMethod;
    public boolean isUnchecked;

    public static MethodBinding computeCompatibleMethod(MethodBinding originalMethod, TypeBinding[] arguments, Scope scope, InvocationSite invocationSite) {
        ParameterizedGenericMethodBinding methodSubstitute;
        TypeVariableBinding[] typeVariables = originalMethod.typeVariables;
        TypeBinding[] substitutes = invocationSite.genericTypeArguments();
        if (substitutes != null) {
            if (substitutes.length != typeVariables.length) {
                return new ProblemMethodBinding(originalMethod, originalMethod.selector, substitutes, 11);
            }
            methodSubstitute = new ParameterizedGenericMethodBinding(originalMethod, substitutes, scope.environment());
        } else {
            TypeBinding[] parameters = originalMethod.parameters;
            int varLength = typeVariables.length;
            HashMap<TypeVariableBinding, TypeBinding[][]> collectedSubstitutes = new HashMap<TypeVariableBinding, TypeBinding[][]>(varLength);
            int i = 0;
            while (i < varLength) {
                collectedSubstitutes.put(typeVariables[i], new TypeBinding[3][]);
                ++i;
            }
            substitutes = new TypeBinding[varLength];
            methodSubstitute = ParameterizedGenericMethodBinding.inferFromArgumentTypes(scope, originalMethod, arguments, parameters, collectedSubstitutes, substitutes);
            if (methodSubstitute == null) {
                return null;
            }
            if (ParameterizedGenericMethodBinding.hasUnresolvedTypeArgument(substitutes)) {
                TypeBinding upperBound;
                TypeBinding expectedType = null;
                if (invocationSite instanceof MessageSend) {
                    MessageSend message = (MessageSend)invocationSite;
                    expectedType = message.expectedType;
                }
                TypeBinding substitutedReturnType = methodSubstitute.returnType;
                switch (substitutedReturnType.kind()) {
                    case 4100: {
                        upperBound = Scope.substitute((Substitution)methodSubstitute, ((TypeVariableBinding)substitutedReturnType).upperBound());
                        break;
                    }
                    case 132: {
                        if (substitutedReturnType == VoidBinding) {
                            upperBound = null;
                            break;
                        }
                    }
                    default: {
                        upperBound = scope.getJavaLangObject();
                    }
                }
                if (expectedType == null || upperBound != null && upperBound.isCompatibleWith(expectedType)) {
                    expectedType = upperBound;
                }
                if ((methodSubstitute = methodSubstitute.inferFromExpectedType(scope, expectedType, collectedSubstitutes, substitutes)) == null) {
                    return null;
                }
            }
        }
        if (!methodSubstitute.isRaw) {
            int i = 0;
            int length = typeVariables.length;
            while (i < length) {
                TypeVariableBinding typeVariable = typeVariables[i];
                TypeBinding substitute = methodSubstitute.typeArguments[i];
                switch (typeVariable.boundCheck(methodSubstitute, substitute)) {
                    case 2: {
                        return new ProblemMethodBinding(methodSubstitute, originalMethod.selector, new TypeBinding[]{substitute, typeVariables[i]}, 10);
                    }
                    case 1: {
                        methodSubstitute.isUnchecked = true;
                    }
                }
                ++i;
            }
        }
        return methodSubstitute;
    }

    private static boolean hasUnresolvedTypeArgument(TypeBinding[] substitutes) {
        int i = 0;
        int varLength = substitutes.length;
        while (i < varLength) {
            if (substitutes[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static ParameterizedGenericMethodBinding inferFromArgumentTypes(Scope scope, MethodBinding originalMethod, TypeBinding[] arguments, TypeBinding[] parameters, Map collectedSubstitutes, TypeBinding[] substitutes) {
        int paramLength;
        if (originalMethod.isVarargs()) {
            paramLength = parameters.length;
            int minArgLength = paramLength - 1;
            int argLength = arguments.length;
            int i = 0;
            while (i < minArgLength) {
                parameters[i].collectSubstitutes(scope, arguments[i], collectedSubstitutes, 1);
                ++i;
            }
            if (minArgLength < argLength) {
                TypeBinding varargType = parameters[minArgLength];
                TypeBinding lastArgument = arguments[minArgLength];
                if (paramLength != argLength || lastArgument != NullBinding && (lastArgument.dimensions() == 0 || lastArgument.leafComponentType().isBaseType() != varargType.leafComponentType().isBaseType())) {
                    varargType = ((ArrayBinding)varargType).elementsType();
                }
                int i2 = minArgLength;
                while (i2 < argLength) {
                    varargType.collectSubstitutes(scope, arguments[i2], collectedSubstitutes, 1);
                    ++i2;
                }
            }
        } else {
            paramLength = parameters.length;
            int i = 0;
            while (i < paramLength) {
                parameters[i].collectSubstitutes(scope, arguments[i], collectedSubstitutes, 1);
                ++i;
            }
        }
        TypeVariableBinding[] originalVariables = originalMethod.typeVariables;
        int varLength = originalVariables.length;
        if ((substitutes = ParameterizedGenericMethodBinding.resolveSubstituteConstraints(scope, originalVariables, substitutes, false, collectedSubstitutes)) == null) {
            return null;
        }
        if (substitutes.length == 0) {
            return new ParameterizedGenericMethodBinding(originalMethod, null, scope.environment());
        }
        TypeBinding[] resolvedSubstitutes = substitutes;
        int i = 0;
        while (i < varLength) {
            if (substitutes[i] == null) {
                if (resolvedSubstitutes == substitutes) {
                    resolvedSubstitutes = new TypeBinding[varLength];
                    System.arraycopy(substitutes, 0, resolvedSubstitutes, 0, i);
                }
                resolvedSubstitutes[i] = originalVariables[i];
            } else if (resolvedSubstitutes != substitutes) {
                resolvedSubstitutes[i] = substitutes[i];
            }
            ++i;
        }
        return new ParameterizedGenericMethodBinding(originalMethod, resolvedSubstitutes, scope.environment());
    }

    private static TypeBinding[] resolveSubstituteConstraints(Scope scope, TypeVariableBinding[] typeVariables, TypeBinding[] substitutes, boolean considerEXTENDSConstraints, Map collectedSubstitutes) {
        TypeBinding[] bounds;
        TypeBinding[][] variableSubstitutes;
        TypeBinding substitute;
        TypeVariableBinding current;
        if (collectedSubstitutes.isEmpty()) {
            return NoTypes;
        }
        int varLength = typeVariables.length;
        int i = 0;
        while (i < varLength) {
            TypeBinding[] equalSubstitutes;
            current = typeVariables[i];
            substitute = substitutes[i];
            if (substitute == null && (equalSubstitutes = (variableSubstitutes = (TypeBinding[][])collectedSubstitutes.get(current))[0]) != null) {
                int j = 0;
                int equalLength = equalSubstitutes.length;
                block1: while (j < equalLength) {
                    TypeBinding equalSubstitute = equalSubstitutes[j];
                    if (equalSubstitute != null) {
                        if (equalSubstitute == current) {
                            int k = j + 1;
                            while (k < equalLength) {
                                equalSubstitute = equalSubstitutes[k];
                                if (equalSubstitute != current && equalSubstitute != null) {
                                    substitutes[i] = equalSubstitute;
                                    break block1;
                                }
                                ++k;
                            }
                            substitutes[i] = current;
                            break;
                        }
                        substitutes[i] = equalSubstitute;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (ParameterizedGenericMethodBinding.hasUnresolvedTypeArgument(substitutes)) {
            i = 0;
            while (i < varLength) {
                current = typeVariables[i];
                substitute = substitutes[i];
                if (substitute == null && (bounds = (variableSubstitutes = (TypeBinding[][])collectedSubstitutes.get(current))[2]) != null) {
                    TypeBinding mostSpecificSubstitute = scope.lowerUpperBound(bounds);
                    if (mostSpecificSubstitute == null) {
                        return null;
                    }
                    if (mostSpecificSubstitute != VoidBinding) {
                        substitutes[i] = mostSpecificSubstitute;
                    }
                }
                ++i;
            }
        }
        if (considerEXTENDSConstraints && ParameterizedGenericMethodBinding.hasUnresolvedTypeArgument(substitutes)) {
            i = 0;
            while (i < varLength) {
                current = typeVariables[i];
                substitute = substitutes[i];
                if (substitute == null && (bounds = (variableSubstitutes = (TypeBinding[][])collectedSubstitutes.get(current))[1]) != null) {
                    TypeBinding[] glb = Scope.greaterLowerBound(bounds);
                    TypeBinding mostSpecificSubstitute = null;
                    if (glb != null) {
                        mostSpecificSubstitute = glb[0];
                    }
                    if (mostSpecificSubstitute != null) {
                        substitutes[i] = mostSpecificSubstitute;
                    }
                }
                ++i;
            }
        }
        return substitutes;
    }

    public ParameterizedGenericMethodBinding(MethodBinding originalMethod, RawTypeBinding rawType, LookupEnvironment environment) {
        TypeVariableBinding[] originalVariables = originalMethod.typeVariables;
        int length = originalVariables.length;
        TypeBinding[] rawArguments = new TypeBinding[length];
        int i = 0;
        while (i < length) {
            rawArguments[i] = originalVariables[i].upperBound();
            ++i;
        }
        this.isRaw = true;
        this.isUnchecked = false;
        this.environment = environment;
        this.modifiers = originalMethod.modifiers;
        this.selector = originalMethod.selector;
        this.declaringClass = rawType == null ? originalMethod.declaringClass : rawType;
        this.typeVariables = NoTypeVariables;
        this.typeArguments = rawArguments;
        this.originalMethod = originalMethod;
        boolean ignoreRawTypeSubstitution = rawType == null || originalMethod.isStatic();
        this.parameters = Scope.substitute((Substitution)this, ignoreRawTypeSubstitution ? originalMethod.parameters : Scope.substitute((Substitution)rawType, originalMethod.parameters));
        this.thrownExceptions = Scope.substitute((Substitution)this, ignoreRawTypeSubstitution ? originalMethod.thrownExceptions : Scope.substitute((Substitution)rawType, originalMethod.thrownExceptions));
        this.returnType = Scope.substitute((Substitution)this, ignoreRawTypeSubstitution ? originalMethod.returnType : Scope.substitute((Substitution)rawType, originalMethod.returnType));
        this.wasInferred = false;
    }

    public ParameterizedGenericMethodBinding(MethodBinding originalMethod, TypeBinding[] typeArguments, LookupEnvironment environment) {
        this.environment = environment;
        this.modifiers = originalMethod.modifiers;
        this.selector = originalMethod.selector;
        this.declaringClass = originalMethod.declaringClass;
        this.typeVariables = NoTypeVariables;
        this.typeArguments = typeArguments;
        this.isRaw = false;
        this.isUnchecked = false;
        this.originalMethod = originalMethod;
        this.parameters = Scope.substitute((Substitution)this, originalMethod.parameters);
        this.thrownExceptions = Scope.substitute((Substitution)this, originalMethod.thrownExceptions);
        this.returnType = Scope.substitute((Substitution)this, originalMethod.returnType);
        this.wasInferred = true;
    }

    public char[] computeUniqueKey(boolean isLeaf) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.originalMethod.computeUniqueKey(false));
        buffer.append('%');
        buffer.append('<');
        if (!this.isRaw) {
            int length = this.typeArguments.length;
            int i = 0;
            while (i < length) {
                TypeBinding typeArgument = this.typeArguments[i];
                buffer.append(typeArgument.computeUniqueKey(false));
                ++i;
            }
        }
        buffer.append('>');
        int resultLength = buffer.length();
        char[] result = new char[resultLength];
        buffer.getChars(0, resultLength, result, 0);
        return result;
    }

    public LookupEnvironment environment() {
        return this.environment;
    }

    public boolean hasSubstitutedParameters() {
        if (this.wasInferred) {
            return this.originalMethod.hasSubstitutedParameters();
        }
        return super.hasSubstitutedParameters();
    }

    public boolean hasSubstitutedReturnType() {
        if (this.inferredReturnType) {
            return this.originalMethod.hasSubstitutedReturnType();
        }
        return super.hasSubstitutedReturnType();
    }

    private ParameterizedGenericMethodBinding inferFromExpectedType(Scope scope, TypeBinding expectedType, Map collectedSubstitutes, TypeBinding[] substitutes) {
        TypeVariableBinding[] originalVariables = this.originalMethod.typeVariables;
        int varLength = originalVariables.length;
        if (expectedType != null) {
            this.returnType.collectSubstitutes(scope, expectedType, collectedSubstitutes, 2);
        }
        int i = 0;
        while (i < varLength) {
            TypeVariableBinding originalVariable = originalVariables[i];
            TypeBinding argument = this.typeArguments[i];
            if (originalVariable.firstBound == originalVariable.superclass) {
                Scope.substitute((Substitution)this, originalVariable.firstBound).collectSubstitutes(scope, argument, collectedSubstitutes, 1);
            }
            int j = 0;
            int max = originalVariable.superInterfaces.length;
            while (j < max) {
                Scope.substitute((Substitution)this, originalVariable.superInterfaces[j]).collectSubstitutes(scope, argument, collectedSubstitutes, 1);
                ++j;
            }
            ++i;
        }
        if ((substitutes = ParameterizedGenericMethodBinding.resolveSubstituteConstraints(scope, originalVariables, substitutes, true, collectedSubstitutes)) == null) {
            return null;
        }
        if (substitutes.length == 0) {
            this.isRaw = true;
            this.isUnchecked = false;
            i = 0;
            while (i < varLength) {
                this.typeArguments[i] = originalVariables[i].upperBound();
                ++i;
            }
        } else {
            i = 0;
            while (i < varLength) {
                TypeBinding substitute = substitutes[i];
                this.typeArguments[i] = substitute != null ? substitutes[i] : originalVariables[i].upperBound();
                ++i;
            }
        }
        TypeBinding oldReturnType = this.returnType;
        this.returnType = Scope.substitute((Substitution)this, this.returnType);
        this.inferredReturnType = this.returnType != oldReturnType;
        this.parameters = Scope.substitute((Substitution)this, this.parameters);
        this.thrownExceptions = Scope.substitute((Substitution)this, this.thrownExceptions);
        return this;
    }

    public boolean isRawSubstitution() {
        return this.isRaw;
    }

    public TypeBinding substitute(TypeVariableBinding originalVariable) {
        TypeVariableBinding[] variables = this.originalMethod.typeVariables;
        int length = variables.length;
        if (originalVariable.rank < length && variables[originalVariable.rank] == originalVariable) {
            return this.typeArguments[originalVariable.rank];
        }
        if (!this.isStatic() && this.declaringClass instanceof Substitution) {
            return ((Substitution)((Object)this.declaringClass)).substitute(originalVariable);
        }
        return originalVariable;
    }

    public MethodBinding tiebreakMethod() {
        if (this.tiebreakMethod == null) {
            this.tiebreakMethod = this.isRaw ? this : new ParameterizedGenericMethodBinding(this.originalMethod, null, this.environment);
        }
        return this.tiebreakMethod;
    }
}

