/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.war.util;

import java.util.List;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: MatcherObjectSelector.java 19932 2010-12-11 15:24:29Z tmatyashovsky $
 */
public class MatcherObjectSelector<C, R> implements ObjectSelector<C, R> {

	public static class Entry<C, R> {
		private ObjectMatcher<C> matcher;
		private R object;
		
		public ObjectMatcher<C> getMatcher() {
			return matcher;
		}
		
		public void setMatcher(ObjectMatcher<C> matcher) {
			this.matcher = matcher;
		}

		public R getObject() {
			return object;
		}

		public void setObject(R object) {
			this.object = object;
		}
	}
	
	private List<Entry<C, R>> entries;
	
	public R select(C criteria) {
		R selected = null;
		if (entries != null && !entries.isEmpty()) {
			for (Entry<C, R> entry : entries) {
				if (entry.getMatcher().matches(criteria)) {
					selected = entry.getObject();
					break;
				}
			}
		}
		return selected;
	}

	public List<Entry<C, R>> getEntries() {
		return entries;
	}

	public void setEntries(List<Entry<C, R>> entries) {
		this.entries = entries;
	}

}
