/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.war.action;

import java.io.IOException;
import java.util.Map;

import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.webflow.context.servlet.ServletExternalContext;

import net.sf.jasperreports.engine.JRException;

import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.core.collection.AttributeMap;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.ExportParameters;


/**
 * @author Teodor Danciu (teodord@users.sourceforge.net)
 * @version $Id: ReportRtfExporter.java 9885 2007-09-03 16:39:13Z lucian $
 */
public class ReportSwfExporter extends AbstractReportExporter 
{

	public Event export(RequestContext context) throws IOException, JRException 
	{
		ServletExternalContext servletContext = (ServletExternalContext) context.getExternalContext();
		HttpServletRequest request = (HttpServletRequest) servletContext.getNativeRequest();
		HttpServletResponse response = (HttpServletResponse) servletContext.getNativeResponse();
		
		AttributeMap flowAttrs = context.getFlowScope();
		String jasperPrintName = flowAttrs.getRequiredString(getFlowAttributeJasperPrintName());

		try
		{
			RequestDispatcher reqdis = request.getRequestDispatcher("WEB-INF/jsp/modules/exporters/swfExport.jsp");
			request.setAttribute("jasperPrintName", jasperPrintName);
			reqdis.forward(request, response);
		}
		catch(Exception e)	
		{
			throw new JRException(e);
		}
		
		return success();
	}

	public void export(RequestContext context, ExecutionContext executionContext, String reportUnitURI, Map baseParameters) throws JRException
	{
		return;//FIXME refactor this to extract some other common exporter interface
	}

	protected String getContentType(RequestContext context) {
		return null;
	}

	protected void setAdditionalResponseHeaders(RequestContext context, HttpServletResponse response) {
		super.setAdditionalResponseHeaders(context, response);
	}
	
	/**
	 * @return Returns the exportParameters.
	 */
	public ExportParameters getExportParameters(RequestContext context) {
		return null;
	}
	
}
