/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.util.test;

import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: DummySecurityContextProvider.java 19930 2010-12-11 15:17:19Z tmatyashovsky $
 */
public class DummySecurityContextProvider implements SecurityContextProvider {

	private String dummyUsername;
	private UserAuthorityService userAuthorityService;

	public String getDummyUsername() {
		return dummyUsername;
	}

	public void setDummyUsername(String dummyUsername) {
		this.dummyUsername = dummyUsername;
	}
	
	public String getContextUsername() {
		return getDummyUsername();
	}

	public User getContextUser() {
		String username = getContextUsername();
		if (username == null) {
			return null;
		}
		return getUserAuthorityService().getUser(null, username);
	}

	public void setAuthenticatedUser(String username) {
		// TODO Auto-generated method stub
		
	}

	public void revertAuthenticatedUser() {
		// TODO Auto-generated method stub
		
	}

	public UserAuthorityService getUserAuthorityService() {
		return userAuthorityService;
	}

	public void setUserAuthorityService(UserAuthorityService userAuthorityService) {
		this.userAuthorityService = userAuthorityService;
	}

}
