/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.util.test;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;

import javax.naming.NamingException;

import org.springframework.test.AbstractDependencyInjectionSpringContextTests;

import com.jaspersoft.jasperserver.export.CommandBean;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.export.ParametersImpl;


/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: BaseExportTestCase.java 19930 2010-12-11 15:17:19Z tmatyashovsky $
 */
public abstract class BaseExportTestCase extends BaseJasperServerTest {

	protected static final String TEST_BASE_DIR = "target";

	protected static final String EXPORT_COMMAND_BEAN_NAME = "exportCommandBean";
	protected static final String IMPORT_COMMAND_BEAN_NAME = "importCommandBean";

	protected static final String PARAM_EXPORT_DIR = "output-dir";
	protected static final String PARAM_EXPORT_URIS = "uris";
	protected static final String PARAM_EXPORT_REPORT_JOB_URIS = "report-jobs";
	protected static final String PARAM_EXPORT_USERS = "users";
	protected static final String PARAM_EXPORT_ROLES = "roles";

	protected static final String PARAM_IMPORT_DIR = "input-dir";
	protected static final String PARAM_IMPORT_ZIP = "input-zip";
	protected static final String PARAM_IMPORT_PREPEND_PATH = "prepend-path";

	protected static final String FILE_SEPARATOR = System.getProperty("file.separator");
	protected static final Random random = new Random(System.currentTimeMillis());

	private List exportFolders = new ArrayList();

	public BaseExportTestCase() {
		super();

		setAutowireMode(AUTOWIRE_BY_NAME);
	}

	public BaseExportTestCase(String name) {
		super(name);

		setAutowireMode(AUTOWIRE_BY_NAME);
	}


	protected Object getBean(String beanName) {
		return applicationContext.getBean(beanName);
	}

	public void onSetUp() throws Exception {
		exportFolders.clear();
		basicAuthSetup();
	}

	public void onTearDown() throws Exception {
		deleteExportFolders();
	}

	protected void deleteExportFolders() {
		for (Iterator it = exportFolders.iterator(); it.hasNext();) {
			String folder = (String) it.next();
			deleteFolder(new File(folder));
		}
	}

	protected void deleteFolder(File folder) {
		if (folder.exists() && folder.isDirectory()) {
			File[] subFiles = folder.listFiles();
			if (subFiles != null) {
				for (int i = 0; i < subFiles.length; i++) {
					File subFile = subFiles[i];
					if (subFile.isFile()) {
						subFile.delete();
					} else if (subFile.isDirectory()) {
						deleteFolder(subFile);
					}
				}
			}

			folder.delete();
		}
	}

	protected String createExportDir() {
		String dir = TEST_BASE_DIR + FILE_SEPARATOR + "export_" + random.nextInt();
		exportFolders.add(dir);
		return dir;
	}

	protected void performExport(Parameters params) {
		CommandBean exporter = (CommandBean) getBean(EXPORT_COMMAND_BEAN_NAME);
		exporter.process(params);
	}

	protected void performImport(Parameters params) {
		CommandBean importer = (CommandBean) getBean(IMPORT_COMMAND_BEAN_NAME);
		importer.process(params);
	}

	protected Parameters createParameters() {
		return new ParametersImpl();
	}

}
