/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.Iterator;
import java.util.Map;
import mondrian.rolap.CellKey;
import mondrian.rolap.agg.Aggregation;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DenseSegmentDataset
implements SegmentDataset {
    private final Segment segment;
    protected final int[] axisMultipliers;

    DenseSegmentDataset(Segment segment) {
        this.segment = segment;
        this.axisMultipliers = this.computeAxisMultipliers();
    }

    private int[] computeAxisMultipliers() {
        int[] axisMultipliers = new int[this.segment.axes.length];
        int multiplier = 1;
        for (int i = this.segment.axes.length - 1; i >= 0; --i) {
            Aggregation.Axis axis = this.segment.axes[i];
            axisMultipliers[i] = multiplier;
            multiplier *= axis.getKeys().length;
        }
        return axisMultipliers;
    }

    protected abstract int size();

    @Override
    public final double getBytes() {
        return this.size() * 12;
    }

    @Override
    public Iterator<Map.Entry<CellKey, Object>> iterator() {
        return new DenseSegmentDatasetIterator();
    }

    protected abstract Object getObject(int var1);

    private boolean contains(Object[] keys) {
        return this.getOffset(keys) >= 0;
    }

    private Object get(Object[] keys) {
        int offset = this.getOffset(keys);
        return keys[offset];
    }

    private void put(Object[] keys, Object value) {
        int offset = this.getOffset(keys);
        keys[offset] = value;
    }

    protected final int getOffset(int[] keys) {
        return CellKey.Generator.getOffset(keys, this.axisMultipliers);
    }

    protected final int getOffset(Object[] keys) {
        int offset = 0;
        block0: for (int i = 0; i < keys.length; ++i) {
            Aggregation.Axis axis = this.segment.axes[i];
            Comparable<?>[] ks = axis.getKeys();
            int axisLength = ks.length;
            offset *= axisLength;
            Object value = keys[i];
            for (int j = 0; j < axisLength; ++j) {
                if (!ks[j].equals(value)) continue;
                offset += j;
                continue block0;
            }
            return -1;
        }
        return offset;
    }

    @Override
    public Object getObject(CellKey pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(CellKey pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(CellKey pos) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DenseSegmentDatasetIterator
    implements Iterator<Map.Entry<CellKey, Object>>,
    Map.Entry<CellKey, Object> {
        private int i = -1;
        private final int[] ordinals;

        DenseSegmentDatasetIterator() {
            this.ordinals = new int[((DenseSegmentDataset)DenseSegmentDataset.this).segment.axes.length];
            this.ordinals[this.ordinals.length - 1] = -1;
        }

        @Override
        public boolean hasNext() {
            return this.i < DenseSegmentDataset.this.size() - 1;
        }

        @Override
        public Map.Entry<CellKey, Object> next() {
            ++this.i;
            for (int k = this.ordinals.length - 1; k >= 0; --k) {
                if (this.ordinals[k] < ((DenseSegmentDataset)DenseSegmentDataset.this).segment.axes[k].getKeys().length - 1) {
                    int n = k;
                    this.ordinals[n] = this.ordinals[n] + 1;
                    break;
                }
                this.ordinals[k] = 0;
            }
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CellKey getKey() {
            return CellKey.Generator.newCellKey(this.ordinals);
        }

        @Override
        public Object getValue() {
            return DenseSegmentDataset.this.getObject(this.i);
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

