/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.component;

import com.jaspersoft.jasperserver.api.JSException;
import com.tonbeller.wcf.component.Renderable;
import com.tonbeller.wcf.component.RendererParameters;
import com.tonbeller.wcf.component.RoleExprHolder;
import com.tonbeller.wcf.component.Visible;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.expr.ExprUtils;
import com.tonbeller.wcf.token.RequestToken;
import com.tonbeller.wcf.utils.DomUtils;
import com.tonbeller.wcf.utils.XmlUtils;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RendererTag
extends TagSupport {
    String xslUri;
    boolean xslCache = true;
    String ref;
    Map parameters = new HashMap();
    private static Logger logger = Logger.getLogger(RendererTag.class);

    void addParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public int doStartTag() throws JspException {
        this.parameters.putAll(RendererParameters.getParameterMap((HttpServletRequest)this.pageContext.getRequest()));
        return 1;
    }

    public int doEndTag() throws JspException {
        logger.info((Object)("enter " + this.ref));
        try {
            String roleExpr;
            RequestContext context = RequestContext.instance();
            Object x = context.getModelReference(this.getRef());
            if (x == null) {
                throw new JspException("component \"" + this.getRef() + "\" not found");
            }
            if (!(x instanceof Renderable)) {
                throw new JspException("component \"" + this.getRef() + "\" is not Renderable: " + x.getClass());
            }
            Renderable comp = (Renderable)x;
            if (comp instanceof Visible && !((Visible)((Object)comp)).isVisible()) {
                return 6;
            }
            if (comp instanceof RoleExprHolder && !context.isUserInRole(roleExpr = ((RoleExprHolder)((Object)comp)).getRoleExpr())) {
                return 6;
            }
            this.createPredefinedParameters(context);
            Transformer transformer = XmlUtils.getTransformer(this.pageContext.getSession(), this.xslUri, this.xslCache);
            this.setXslParameters(context, transformer);
            Document document = comp.render(context);
            this.setXmlParameters(document);
            DOMSource source = new DOMSource(document);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            transformer.transform(source, result);
            sw.flush();
            this.pageContext.getOut().write(sw.toString());
            this.parameters.clear();
            logger.info((Object)("leave " + this.ref));
            return 6;
        }
        catch (Exception e) {
            logger.error((Object)("trouble rendering " + this.getRef()), (Throwable)e);
            throw new JspException(e.toString(), (Throwable)e);
        }
        catch (Error e) {
            logger.error((Object)("Error occurred " + this.getRef()), (Throwable)e);
            throw new JSException("jsexception.error.occurred", (Throwable)e);
        }
    }

    protected void setXmlParameters(Document document) {
        Element root = document.getDocumentElement();
        if (root != null && "xform".equals(root.getNodeName())) {
            this.setXmlParameters(document.getChildNodes());
        }
    }

    protected void setXmlParameters(NodeList list) {
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1) continue;
            Element x = (Element)list.item(i);
            if ("param".equals(x.getNodeName())) {
                String paramName = x.getAttribute("name");
                String attrName = x.getAttribute("attr");
                String value = (String)this.parameters.get(paramName);
                Element parent = (Element)x.getParentNode();
                if (value == null || value.length() == 0) {
                    DomUtils.removeAttribute(parent, attrName);
                    continue;
                }
                parent.setAttribute(attrName, value);
                continue;
            }
            this.setXmlParameters(x.getChildNodes());
        }
    }

    void setXslParameters(RequestContext context, Transformer transformer) {
        for (String name : this.parameters.keySet()) {
            Object value = this.parameters.get(name);
            transformer.setParameter(name, value);
        }
    }

    private void createPredefinedParameters(RequestContext context) throws MalformedURLException {
        RequestToken tok;
        String renderId = this.getId();
        if (renderId == null || renderId.length() == 0) {
            renderId = ExprUtils.getBeanName(this.getRef());
        }
        this.parameters.put("renderId", renderId);
        this.parameters.put("context", context.getRequest().getContextPath());
        this.parameters.put("contextUrl", this.createContextURLValue(context));
        if (context.getSession() != null && (tok = RequestToken.instance(context.getSession())) != null) {
            this.parameters.put("token", tok.getHttpParameterName() + "=" + tok.getToken());
        }
    }

    private String createContextURLValue(RequestContext context) throws MalformedURLException {
        if (context.getRequest() == null || context.getRequest().getRequestURL() == null) {
            return "UNDEFINED";
        }
        URL url = new URL(context.getRequest().getRequestURL().toString());
        StringBuffer c = new StringBuffer();
        c.append(url.getProtocol());
        c.append("://");
        c.append(url.getHost());
        if (url.getPort() != 80) {
            c.append(":");
            c.append(url.getPort());
        }
        c.append(context.getRequest().getContextPath());
        return c.toString();
    }

    public String getRef() {
        return this.ref;
    }

    public boolean isXslCache() {
        return this.xslCache;
    }

    public String getXslUri() {
        return this.xslUri;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public void setXslCache(boolean xslCache) {
        this.xslCache = xslCache;
    }

    public void setXslUri(String xslUri) {
        this.xslUri = xslUri;
    }
}

