/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.BufferedBlob;
import com.ingres.gcf.util.ByteBuffer;
import com.ingres.gcf.util.SqlByte;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.SqlLongByte;
import com.ingres.gcf.util.SqlStream;
import com.ingres.gcf.util.SqlVarByte;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;

public class SqlLongByteCache
extends SqlData {
    private ByteBuffer buffer = null;
    private int segSize = 8192;

    public SqlLongByteCache() {
        super(true);
    }

    public SqlLongByteCache(int n) {
        super(true);
        this.segSize = n;
    }

    public void setNull() {
        super.setNull();
        this.buffer = null;
    }

    public String toString() {
        return "SqlCache: " + (this.buffer == null ? "NULL" : this.buffer.toString());
    }

    public void set(InputStream inputStream) throws SqlEx {
        if (inputStream == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.buffer = new ByteBuffer(this.segSize, inputStream);
        }
    }

    public void set(SqlByte sqlByte) throws SqlEx {
        if (sqlByte == null || sqlByte.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            sqlByte.extend();
            this.buffer = new ByteBuffer(this.segSize, sqlByte.value, 0, sqlByte.length);
        }
    }

    public void set(SqlVarByte sqlVarByte) throws SqlEx {
        if (sqlVarByte == null || sqlVarByte.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.buffer = new ByteBuffer(this.segSize, sqlVarByte.value, 0, sqlVarByte.length);
        }
    }

    public InputStream get() throws SqlEx {
        return this.buffer.getIS();
    }

    public void get(OutputStream outputStream) throws SqlEx {
        this.buffer.read(outputStream);
    }

    public void setString(String string) throws SqlEx {
        if (string == null) {
            this.setNull();
        } else {
            this.setBytes(string.getBytes());
        }
    }

    public void setBytes(byte[] byArray) throws SqlEx {
        if (byArray == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.buffer = new ByteBuffer(this.segSize, byArray, 0, byArray.length);
        }
    }

    public void setBinaryStream(InputStream inputStream) throws SqlEx {
        if (inputStream == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.buffer = new ByteBuffer(this.segSize, inputStream);
        }
    }

    public String getString() throws SqlEx {
        byte[] byArray = this.getBytes();
        return SqlVarByte.bin2str(byArray, 0, byArray.length);
    }

    public String getString(int n) throws SqlEx {
        byte[] byArray = this.getBytes(n);
        return SqlVarByte.bin2str(byArray, 0, byArray.length);
    }

    public byte[] getBytes() throws SqlEx {
        return this.getBytes(Integer.MAX_VALUE);
    }

    public byte[] getBytes(int n) throws SqlEx {
        n = (int)Math.min((long)n, this.buffer.length());
        byte[] byArray = new byte[n];
        this.buffer.read(0L, byArray, 0, n);
        return byArray;
    }

    public InputStream getBinaryStream() throws SqlEx {
        return this.buffer.getIS();
    }

    public InputStream getAsciiStream() throws SqlEx {
        return SqlStream.getAsciiIS(SqlLongByte.byteIS2hexRdr(this.buffer.getIS()));
    }

    public InputStream getUnicodeStream() throws SqlEx {
        return SqlStream.getUnicodeIS(SqlLongByte.byteIS2hexRdr(this.buffer.getIS()));
    }

    public Reader getCharacterStream() throws SqlEx {
        return SqlLongByte.byteIS2hexRdr(this.buffer.getIS());
    }

    public Blob getBlob() throws SqlEx {
        return new BufferedBlob(this.buffer);
    }

    public Object getObject() throws SqlEx {
        return this.getBytes();
    }

    public Object getObject(int n) throws SqlEx {
        return this.getBytes(n);
    }
}

