/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.BufferedBlob;
import com.ingres.gcf.util.SqlByte;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.SqlStream;
import com.ingres.gcf.util.SqlVarByte;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;

public class SqlLongByte
extends SqlStream {
    public SqlLongByte() {
    }

    public SqlLongByte(SqlStream.StreamListener streamListener) {
        super(streamListener);
    }

    public void set(InputStream inputStream) throws SqlEx {
        this.setStream(inputStream);
    }

    public void set(SqlByte sqlByte) throws SqlEx {
        if (sqlByte == null || sqlByte.isNull()) {
            this.setNull();
        } else {
            sqlByte.extend();
            this.setStream(SqlLongByte.getBinary(sqlByte.value, 0, sqlByte.length));
        }
    }

    public void set(SqlVarByte sqlVarByte) throws SqlEx {
        if (sqlVarByte == null || sqlVarByte.isNull()) {
            this.setNull();
        } else {
            this.setStream(SqlLongByte.getBinary(sqlVarByte.value, 0, sqlVarByte.length));
        }
    }

    public InputStream get() throws SqlEx {
        return (InputStream)this.getStream();
    }

    public void get(OutputStream outputStream) throws SqlEx {
        SqlLongByte.copyIs2Os((InputStream)this.getStream(), outputStream);
    }

    public void setString(String string) throws SqlEx {
        if (string == null) {
            this.setNull();
        } else {
            this.setBytes(string.getBytes());
        }
    }

    public void setBytes(byte[] byArray) throws SqlEx {
        if (byArray == null) {
            this.setNull();
        } else {
            this.setStream(SqlLongByte.getBinary(byArray, 0, byArray.length));
        }
    }

    public void setBinaryStream(InputStream inputStream) throws SqlEx {
        this.setStream(inputStream);
    }

    public String getString() throws SqlEx {
        byte[] byArray = SqlLongByte.strm2array(this.getBinary());
        return SqlVarByte.bin2str(byArray, 0, byArray.length);
    }

    public String getString(int n) throws SqlEx {
        byte[] byArray = SqlLongByte.strm2array(this.getBinary(), n);
        return SqlVarByte.bin2str(byArray, 0, byArray.length);
    }

    public byte[] getBytes() throws SqlEx {
        return SqlLongByte.strm2array(this.getBinary());
    }

    public byte[] getBytes(int n) throws SqlEx {
        return SqlLongByte.strm2array(this.getBinary(), n);
    }

    public InputStream getBinaryStream() throws SqlEx {
        return this.getBinary();
    }

    public InputStream getAsciiStream() throws SqlEx {
        return this.getAscii();
    }

    public InputStream getUnicodeStream() throws SqlEx {
        return this.getUnicode();
    }

    public Reader getCharacterStream() throws SqlEx {
        return this.getCharacter();
    }

    public Blob getBlob() throws SqlEx {
        return new BufferedBlob(this.getBinary());
    }

    public Object getObject() throws SqlEx {
        return this.getBytes();
    }

    public Object getObject(int n) throws SqlEx {
        return this.getBytes(n);
    }

    protected Reader cnvtIS2Rdr(InputStream inputStream) throws SqlEx {
        return new BinIS2HexRdr(inputStream);
    }

    public static Reader byteIS2hexRdr(InputStream inputStream) {
        return new BinIS2HexRdr(inputStream);
    }

    public static byte[] strm2array(InputStream inputStream) throws SqlEx {
        byte[] byArray = new byte[8192];
        byte[] byArray2 = new byte[]{};
        try {
            int n;
            while ((n = inputStream.read(byArray, 0, byArray.length)) >= 0) {
                if (n <= 0) continue;
                byte[] byArray3 = new byte[byArray2.length + n];
                if (byArray2.length > 0) {
                    System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                }
                System.arraycopy(byArray, 0, byArray3, byArray2.length, n);
                byArray2 = byArray3;
            }
        }
        catch (IOException iOException) {
            throw SqlEx.get(ERR_GC4007_BLOB_IO);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return byArray2;
    }

    public static byte[] strm2array(InputStream inputStream, int n) throws SqlEx {
        byte[] byArray = new byte[8192];
        byte[] byArray2 = new byte[]{};
        try {
            int n2;
            while (byArray2.length < n && (n2 = inputStream.read(byArray, 0, byArray.length)) >= 0) {
                n2 = Math.min(n2, n - byArray2.length);
                byte[] byArray3 = new byte[byArray2.length + n2];
                if (byArray2.length > 0) {
                    System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                }
                if (n2 > 0) {
                    System.arraycopy(byArray, 0, byArray3, byArray2.length, n2);
                }
                byArray2 = byArray3;
            }
        }
        catch (IOException iOException) {
            throw SqlEx.get(ERR_GC4007_BLOB_IO);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return byArray2;
    }

    private static class BinIS2HexRdr
    extends Reader {
        private InputStream stream = null;
        private char next = '\u0000';
        private boolean avail = false;

        public BinIS2HexRdr(InputStream inputStream) {
            this.stream = inputStream;
        }

        public synchronized int read() throws IOException {
            int n;
            if (this.avail) {
                this.avail = false;
                return this.next;
            }
            int n2 = this.stream.read();
            if (n2 == -1) {
                return -1;
            }
            String string = Integer.toHexString(n2 & 0xFF);
            if (string.length() == 1) {
                n = 48;
                this.next = string.charAt(0);
            } else {
                n = string.charAt(0);
                this.next = string.charAt(1);
            }
            this.avail = true;
            return n;
        }

        public int read(char[] cArray) throws IOException {
            return this.read(cArray, 0, cArray.length);
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = n + n2;
            int n4 = n;
            while (n < n3) {
                int n5 = this.read();
                if (n5 == -1) {
                    if (n != n4) break;
                    return -1;
                }
                cArray[n++] = (char)n5;
            }
            return n - n4;
        }

        public long skip(long l) throws IOException {
            long l2 = l;
            while (l > 0L && this.read() != -1) {
                --l;
            }
            return l2 - l;
        }

        public void close() throws IOException {
            this.stream.close();
        }
    }
}

