/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvConst;
import com.ingres.gcf.jdbc.ProcInfo;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlEx;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;

class SqlParse
implements DrvConst,
DbmsConst,
GcfErr {
    public static final int QT_UNKNOWN = 0;
    public static final int QT_SELECT = 1;
    public static final int QT_DELETE = 2;
    public static final int QT_UPDATE = 3;
    public static final int QT_PROCEDURE = 4;
    public static final int QT_NATIVE_PROC = 5;
    private static final int UNKNOWN = -1;
    private static final int EOF = -2;
    private static final int STRING = 1;
    private static final int IDENT = 2;
    private static final int NUMBER = 3;
    private static final int PUNCT = 4;
    private static final int ESCAPE = 5;
    private static final int P_LPAREN = 10;
    private static final int P_RPAREN = 11;
    private static final int P_LBRACE = 12;
    private static final int P_RBRACE = 13;
    private static final int P_COMMA = 14;
    private static final int P_QMARK = 15;
    private static final int P_EQUAL = 16;
    private static final int P_PLUS = 17;
    private static final int P_MINUS = 18;
    private static final int P_PERIOD = 19;
    private static final int NUM_INT = 0;
    private static final int NUM_DEC = 1;
    private static final int NUM_FLT = 2;
    private static final int KW_CALLPROC = 0;
    private static final int KW_CURRENT = 1;
    private static final int KW_DELETE = 2;
    private static final int KW_EXECUTE = 3;
    private static final int KW_FOR = 4;
    private static final int KW_FROM = 5;
    private static final int KW_INTO = 6;
    private static final int KW_OF = 7;
    private static final int KW_PROCEDURE = 8;
    private static final int KW_READONLY = 9;
    private static final int KW_SELECT = 10;
    private static final int KW_SESSION = 11;
    private static final int KW_UPDATE = 12;
    private static final int KW_WHERE = 13;
    private static final String[] keywords = new String[]{"CALLPROC", "CURRENT", "DELETE", "EXECUTE", "FOR", "FROM", "INTO", "OF", "PROCEDURE", "READONLY", "SELECT", "SESSION", "UPDATE", "WHERE"};
    private static final int ESC_CALL = 0;
    private static final int ESC_DATE = 1;
    private static final int ESC_ESC = 2;
    private static final int ESC_FUNC = 3;
    private static final int ESC_OJ = 4;
    private static final int ESC_TIME = 5;
    private static final int ESC_STAMP = 6;
    private static final String[] esc_seq = new String[]{"CALL", "D", "ESCAPE", "FN", "OJ", "T", "TS"};
    private static final int FUNC_ABS = 0;
    private static final int FUNC_ATAN = 1;
    private static final int FUNC_CONCAT = 2;
    private static final int FUNC_CNVRT = 3;
    private static final int FUNC_COS = 4;
    private static final int FUNC_CDATE = 5;
    private static final int FUNC_ANSICD = 6;
    private static final int FUNC_ANSICT = 7;
    private static final int FUNC_ANSICS = 8;
    private static final int FUNC_CTIME = 9;
    private static final int FUNC_DB = 10;
    private static final int FUNC_DOW = 11;
    private static final int FUNC_EXP = 12;
    private static final int FUNC_IFNULL = 13;
    private static final int FUNC_LCASE = 14;
    private static final int FUNC_LEFT = 15;
    private static final int FUNC_LENGTH = 16;
    private static final int FUNC_LOG = 17;
    private static final int FUNC_MOD = 18;
    private static final int FUNC_NOW = 19;
    private static final int FUNC_POWER = 20;
    private static final int FUNC_RIGHT = 21;
    private static final int FUNC_RTRIM = 22;
    private static final int FUNC_SIN = 23;
    private static final int FUNC_SNDEX = 24;
    private static final int FUNC_SQRT = 25;
    private static final int FUNC_UCASE = 26;
    private static final int FUNC_USER = 27;
    private static final String[] esc_func = new String[]{"ABS", "ATAN", "CONCAT", "CONVERT", "COS", "CURDATE", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURTIME", "DATABASE", "DAYNAME", "EXP", "IFNULL", "LCASE", "LEFT", "LENGTH", "LOG", "MOD", "NOW", "POWER", "RIGHT", "RTRIM", "SIN", "SOUNDEX", "SQRT", "UCASE", "USER"};
    private static final String[] func_xlat = new String[]{"ABS", "ATAN", "CONCAT", "CONVERT", "COS", "?", "?", "?", "?", "?", "DBMSINFO('DATABASE')", "DOW", "EXP", "IFNULL", "LOWERCASE", "LEFT", "LENGTH", "LOG", "MOD", "?", "POWER", "RIGHT", "TRIM", "SIN", "SOUNDEX", "SQRT", "UPPERCASE", "USER"};
    private static final Hashtable types = new Hashtable();
    private static final String FUNC_IDATE_CONST = "date('today')";
    private static final String FUNC_ITIME_CONST = "date('now')";
    private static final String FUNC_ISTAMP_CONST = "date('now')";
    private static final String FUNC_ADATE_CONST = "CURRENT_DATE";
    private static final String FUNC_ATIME_CONST = "CURRENT_TIME";
    private static final String FUNC_ASTAMP_CONST = "CURRENT_TIMESTAMP";
    private static final String FUNC_IDATE_PREFIX = "date('";
    private static final String FUNC_IDATE_SUFFIX = "')";
    private static final String FUNC_ADATE_PREFIX = "DATE'";
    private static final String FUNC_ADATE_SUFFIX = "'";
    private static final String FUNC_TIME_PREFIX = "TIME'";
    private static final String FUNC_TIME_SUFFIX = "'";
    private static final String FUNC_STAMP_PREFIX = "TIMESTAMP'";
    private static final String FUNC_STAMP_SUFFIX = "'";
    private DrvConn conn = null;
    private boolean use_gmt = false;
    private boolean ansi_date_syntax = false;
    private String sql = null;
    private char[] text = null;
    private int txt_len;
    private boolean transformed = false;
    private int token_beg = 0;
    private int token_end = 0;
    private boolean nested = false;
    private int query_type = -1;
    private boolean procedure_return = false;
    private String cursor = null;
    private String table_name = null;
    private boolean for_update = false;
    private boolean for_readonly = false;

    public static Enumeration getConvertTypes() {
        return types.keys();
    }

    public static String getNumFuncs() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < esc_func.length; ++i) {
            switch (i) {
                case 0: 
                case 1: 
                case 4: 
                case 12: 
                case 17: 
                case 18: 
                case 20: 
                case 23: 
                case 25: {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(esc_func[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String getStrFuncs() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < esc_func.length; ++i) {
            switch (i) {
                case 2: 
                case 14: 
                case 15: 
                case 16: 
                case 21: 
                case 22: 
                case 24: 
                case 26: {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(esc_func[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String getTdtFuncs() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < esc_func.length; ++i) {
            switch (i) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 19: {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(esc_func[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String getSysFuncs() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < esc_func.length; ++i) {
            switch (i) {
                case 10: 
                case 13: 
                case 27: {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(esc_func[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public SqlParse(String string, DrvConn drvConn) {
        this.sql = string;
        this.conn = drvConn;
        this.ansi_date_syntax = drvConn.sqlLevel >= 910;
        this.use_gmt = drvConn.timeLiteralsInGMT();
        this.text = string.toCharArray();
        this.txt_len = this.text.length;
    }

    public int getQueryType() throws SqlEx {
        if (this.query_type == -1) {
            this.token_end = 0;
            this.token_beg = 0;
            this.query_type = 0;
            switch (this.nextToken(false)) {
                case 10: {
                    this.query_type = 1;
                    break;
                }
                case 2: {
                    switch (SqlParse.keyword(this.text, this.token_beg, this.token_end, keywords)) {
                        case 10: {
                            this.query_type = 1;
                            break;
                        }
                        case 2: {
                            this.query_type = 2;
                            break;
                        }
                        case 12: {
                            this.query_type = 3;
                            break;
                        }
                        case 0: {
                            this.query_type = 5;
                            break;
                        }
                        case 3: {
                            if (this.nextToken(false) != 2 || SqlParse.keyword(this.text, this.token_beg, this.token_end, keywords) != 8) break;
                            this.query_type = 5;
                        }
                    }
                    break;
                }
                case 12: {
                    int n = this.nextToken(false);
                    if (n == 15) {
                        if (this.nextToken(false) != 16) break;
                        this.procedure_return = true;
                        n = this.nextToken(false);
                    }
                    if (n == 2 && SqlParse.keyword(this.text, this.token_beg, this.token_end, esc_seq) == 0) {
                        this.query_type = 4;
                        break;
                    }
                    this.procedure_return = false;
                }
            }
        }
        return this.query_type;
    }

    public String getCursorName() throws SqlEx {
        if (this.cursor != null) {
            return this.cursor;
        }
        if (this.query_type == -1) {
            this.getQueryType();
        }
        if (this.query_type == 2 || this.query_type == 3) {
            int n;
            int n2 = 0;
            this.token_end = 0;
            this.token_beg = 0;
            while ((n = this.nextToken(false)) != -2) {
                if (n == 2 && SqlParse.keyword(this.text, this.token_beg, this.token_end, keywords) == 13) {
                    int n3 = n2;
                    if (this.nextToken(false) == 2 && SqlParse.keyword(this.text, this.token_beg, this.token_end, keywords) == 1 && this.nextToken(false) == 2 && SqlParse.keyword(this.text, this.token_beg, this.token_end, keywords) == 7 && this.nextToken(false) == 2) {
                        int n4 = this.token_beg;
                        int n5 = this.token_end;
                        if (this.nextToken(false) == -2) {
                            this.cursor = new String(this.text, n4, n5 - n4);
                            this.txt_len = n3;
                            this.transformed = true;
                            break;
                        }
                    }
                }
                n2 = this.token_end;
            }
            if (this.cursor == null) {
                this.query_type = 0;
            }
        }
        return this.cursor;
    }

    public String getTableName() {
        return this.table_name;
    }

    public int getConcurrency() {
        int n = this.for_readonly ? 0 : (this.for_update ? 1 : -1);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String parseSQL(boolean bl) throws SqlEx {
        int n;
        StringBuffer stringBuffer = null;
        if (this.query_type == -1) {
            this.getQueryType();
        }
        this.token_end = 0;
        this.token_beg = 0;
        int n2 = 0;
        block23: while ((n = this.nextToken(bl)) != -2) {
            switch (n) {
                case 2: {
                    block4 : switch (SqlParse.keyword(this.text, this.token_beg, this.token_end, keywords)) {
                        case 10: {
                            int n3 = this.token_end;
                            if (this.nextToken(false) != 2 || SqlParse.keyword(this.text, this.token_beg, this.token_end, keywords) != 4 || this.nextToken(false) != 2) {
                                this.token_beg = this.token_end = n3;
                                continue block23;
                            }
                            switch (SqlParse.keyword(this.text, this.token_beg, this.token_end, keywords)) {
                                case 9: {
                                    stringBuffer = this.append_text(this.text, this.txt_len, n2, n3, stringBuffer);
                                    n2 = this.token_end;
                                    this.for_readonly = true;
                                    break;
                                }
                                case 12: {
                                    stringBuffer = this.append_text(this.text, this.txt_len, n2, n3, stringBuffer);
                                    n2 = this.token_end;
                                    if (this.for_update) break block4;
                                    this.token_beg = this.token_end = stringBuffer.length();
                                    stringBuffer = this.append_text(this.text, this.txt_len, n2, this.txt_len, stringBuffer);
                                    stringBuffer.append(" for update");
                                    this.save_text(stringBuffer);
                                    n2 = 0;
                                    this.transformed = true;
                                    this.for_update = true;
                                    break;
                                }
                                default: {
                                    this.token_beg = this.token_end = n3;
                                    break;
                                }
                            }
                            continue block23;
                        }
                        case 4: {
                            if (this.query_type != 1) continue block23;
                            int n4 = this.token_beg;
                            int n3 = this.token_end;
                            n = this.nextToken(false);
                            if (n != 2) break;
                            switch (SqlParse.keyword(this.text, this.token_beg, this.token_end, keywords)) {
                                case 9: {
                                    stringBuffer = this.append_text(this.text, this.txt_len, n2, n4, stringBuffer);
                                    n2 = this.token_end;
                                    this.for_readonly = true;
                                    continue block23;
                                }
                                case 12: {
                                    this.for_update = true;
                                    continue block23;
                                }
                            }
                            this.token_beg = this.token_end = n3;
                            continue block23;
                        }
                        case 5: {
                            if (this.query_type != 1) break;
                            if (this.table_name != null) continue block23;
                            int n4 = this.token_beg;
                            int n3 = this.token_end;
                            switch (this.nextToken(false)) {
                                case 1: 
                                case 2: {
                                    n4 = this.token_beg;
                                    n3 = this.token_end;
                                    if (this.nextToken(false) == 19) {
                                        switch (this.nextToken(false)) {
                                            case 1: 
                                            case 2: {
                                                n3 = this.token_end;
                                                break;
                                            }
                                        }
                                    }
                                    this.table_name = new String(this.text, n4, n3 - n4);
                                    break;
                                }
                            }
                            this.token_beg = n4;
                            this.token_end = n3;
                        }
                    }
                    continue block23;
                }
                case 5: {
                    if (!bl) break;
                    stringBuffer = this.append_text(this.text, this.txt_len, n2, this.token_beg, stringBuffer);
                    n2 = this.token_end;
                    this.parseESC(this.token_beg, n2, this.nested, stringBuffer);
                    this.token_beg = this.token_end = n2;
                    continue block23;
                }
            }
        }
        if (stringBuffer != null && n2 > 0) {
            stringBuffer = this.append_text(this.text, this.txt_len, n2, this.txt_len, stringBuffer);
            this.save_text(stringBuffer);
            this.transformed = true;
        }
        if (this.transformed) {
            this.sql = new String(this.text, 0, this.txt_len);
            this.transformed = false;
        }
        return this.sql;
    }

    public void parseCall(ProcInfo procInfo) throws SqlEx {
        int n;
        block35: {
            this.query_type = -1;
            this.getQueryType();
            if (this.query_type != 4 && this.query_type != 5 || this.nextToken(false) != 2) {
                throw SqlEx.get(ERR_GC4014_CALL_SYNTAX);
            }
            String string = new String(this.text, this.token_beg, this.token_end - this.token_beg);
            n = this.nextToken(false);
            if (n == 19) {
                if (this.nextToken(false) != 2) {
                    throw SqlEx.get(ERR_GC4014_CALL_SYNTAX);
                }
                procInfo.setSchema(string);
                string = new String(this.text, this.token_beg, this.token_end - this.token_beg);
                n = this.nextToken(false);
            }
            procInfo.setName(string);
            if (n != 10) break block35;
            int n2 = 0;
            n = this.nextToken(false);
            block20: while (n != -2) {
                block36: {
                    block1 : switch (n) {
                        case 11: {
                            procInfo.setParam(n2, 0, null);
                            break block20;
                        }
                        case 14: {
                            procInfo.setParam(n2, 0, null);
                            break block36;
                        }
                        case 15: {
                            procInfo.setParam(n2, 1, null);
                            break;
                        }
                        case 1: {
                            procInfo.setParam(n2, 2, new String(this.text, this.token_beg + 1, this.token_end - this.token_beg - 2));
                            break;
                        }
                        case 3: 
                        case 17: 
                        case 18: 
                        case 19: {
                            int n3;
                            try {
                                Number number;
                                n3 = this.parseNumeric(this.token_beg);
                                String string2 = new String(this.text, this.token_beg, this.token_end - this.token_beg);
                                switch (n3) {
                                    case 0: {
                                        n3 = 4;
                                        number = new Integer(string2);
                                        break;
                                    }
                                    case 1: {
                                        n3 = 5;
                                        number = new BigDecimal(string2);
                                        break;
                                    }
                                    case 2: {
                                        n3 = 6;
                                        number = new Double(string2);
                                        break;
                                    }
                                    default: {
                                        throw new NumberFormatException();
                                    }
                                }
                                procInfo.setParam(n2, n3, number);
                                break;
                            }
                            catch (Exception exception) {
                                throw SqlEx.get(ERR_GC4014_CALL_SYNTAX);
                            }
                        }
                        case 2: {
                            int n3 = this.token_end;
                            int n4 = this.token_beg;
                            switch (this.nextToken(false)) {
                                case 19: {
                                    if (SqlParse.keyword(this.text, n4, n3, keywords) == 11 && this.nextToken(false) == 2) {
                                        procInfo.setParam(n2, 7, new String(this.text, this.token_beg, this.token_end - this.token_beg));
                                        break block1;
                                    }
                                    throw SqlEx.get(ERR_GC4014_CALL_SYNTAX);
                                }
                                case 1: {
                                    if (n3 - n4 == 1 && (this.text[n4] == 'X' || this.text[n4] == 'x')) {
                                        procInfo.setParam(n2, 3, this.hex2bin(this.text, this.token_beg + 1, this.token_end - this.token_beg - 2));
                                        break block1;
                                    }
                                    throw SqlEx.get(ERR_GC4014_CALL_SYNTAX);
                                }
                                case 16: {
                                    procInfo.setParamName(n2, new String(this.text, n4, n3 - n4));
                                    --n2;
                                    break block36;
                                }
                                default: {
                                    throw SqlEx.get(ERR_GC4014_CALL_SYNTAX);
                                }
                            }
                        }
                        default: {
                            throw SqlEx.get(ERR_GC4014_CALL_SYNTAX);
                        }
                    }
                    n = this.nextToken(false);
                    if (n == 11) break;
                    if (n != 14) {
                        throw SqlEx.get(ERR_GC4014_CALL_SYNTAX);
                    }
                }
                ++n2;
                n = this.nextToken(false);
            }
            if (n == 11) {
                n = this.nextToken(false);
            } else {
                throw SqlEx.get(ERR_GC4014_CALL_SYNTAX);
            }
        }
        if (this.query_type == 4) {
            if (n != 13 || this.nextToken(false) != -2) {
                throw SqlEx.get(ERR_GC4014_CALL_SYNTAX);
            }
        } else if (n != -2) {
            if (n == 2 && SqlParse.keyword(this.text, this.token_beg, this.token_end, keywords) == 6 && this.nextToken(false) == 15 && this.nextToken(false) == -2) {
                this.procedure_return = true;
            } else {
                throw SqlEx.get(ERR_GC4014_CALL_SYNTAX);
            }
        }
        procInfo.setReturn(this.procedure_return);
    }

    private int parseNumeric(int n) throws SqlEx {
        int n2 = -1;
        this.token_end = this.token_beg = n;
        int n3 = this.nextToken(false);
        n = this.token_beg;
        int n4 = this.token_end;
        if (n3 == 17 || n3 == 18) {
            n3 = this.nextToken(false);
        }
        if (n3 == 3) {
            n4 = this.token_end;
            n2 = 0;
            n3 = this.nextToken(false);
        }
        if (n3 == 19) {
            n4 = this.token_end;
            n3 = this.nextToken(false);
            if (n3 == 3) {
                n4 = this.token_end;
                n2 = 1;
                n3 = this.nextToken(false);
            } else if (n2 == 0) {
                n2 = 1;
            }
        }
        if (!(n2 != 0 && n2 != 1 || n3 != 2 || this.text[this.token_beg] != 'e' && this.text[this.token_beg] != 'E')) {
            this.token_end = this.token_beg + 1;
            n3 = this.nextToken(false);
            if (n3 == 17 || n3 == 18) {
                n3 = this.nextToken(false);
            }
            if (n3 == 3) {
                n4 = this.token_end;
                n2 = 2;
            }
        }
        this.token_beg = n;
        this.token_end = n4;
        return n2;
    }

    private void parseESC(int n, int n2, boolean bl, StringBuffer stringBuffer) throws SqlEx {
        int n3;
        this.token_beg = this.token_end = n + 1;
        int n4 = this.nextToken(false);
        if (n4 != 2 || (n3 = SqlParse.keyword(this.text, this.token_beg, this.token_end, esc_seq)) == -1) {
            stringBuffer.append('{');
            this.append_escape(n + 1, n2 - 1, bl, stringBuffer);
            stringBuffer.append('}');
            return;
        }
        block0 : switch (n3) {
            case 1: 
            case 5: 
            case 6: {
                n4 = this.nextToken(false);
                if (n4 != 1) {
                    this.append_escape(this.token_beg, n2 - 1, bl, stringBuffer);
                    break;
                }
                String string = new String(this.text, this.token_beg + 1, this.token_end - this.token_beg - 2);
                if (string.length() == 0) {
                    stringBuffer.append(FUNC_IDATE_PREFIX);
                    stringBuffer.append(FUNC_IDATE_SUFFIX);
                    break;
                }
                switch (n3) {
                    case 1: {
                        Date date = Date.valueOf(string);
                        if (this.ansi_date_syntax) {
                            stringBuffer.append(FUNC_ADATE_PREFIX);
                            stringBuffer.append(SqlDates.formatDate((java.util.Date)date, false));
                            stringBuffer.append("'");
                            break block0;
                        }
                        stringBuffer.append(FUNC_IDATE_PREFIX);
                        stringBuffer.append(SqlDates.formatDateLit((java.util.Date)date, false));
                        stringBuffer.append(FUNC_IDATE_SUFFIX);
                        break block0;
                    }
                    case 5: {
                        Time time = Time.valueOf(string);
                        if (this.ansi_date_syntax) {
                            stringBuffer.append(FUNC_TIME_PREFIX);
                            stringBuffer.append(SqlDates.formatTime((java.util.Date)time, false));
                            if (!this.conn.osql_dates) {
                                stringBuffer.append(SqlDates.formatTZ(System.currentTimeMillis()));
                            }
                            stringBuffer.append("'");
                            break block0;
                        }
                        stringBuffer.append(FUNC_IDATE_PREFIX);
                        stringBuffer.append(SqlDates.formatTimestampLit((java.util.Date)time, this.use_gmt));
                        stringBuffer.append(FUNC_IDATE_SUFFIX);
                        break block0;
                    }
                    case 6: {
                        Timestamp timestamp = Timestamp.valueOf(string);
                        int n5 = timestamp.getNanos();
                        if (this.ansi_date_syntax) {
                            stringBuffer.append(FUNC_STAMP_PREFIX);
                            stringBuffer.append(SqlDates.formatTimestamp((java.util.Date)timestamp, false));
                            if (n5 != 0) {
                                stringBuffer.append(SqlDates.formatFrac(n5));
                            }
                            if (!this.conn.osql_dates) {
                                stringBuffer.append(SqlDates.formatTZ(timestamp));
                            }
                            stringBuffer.append("'");
                            break block0;
                        }
                        stringBuffer.append(FUNC_IDATE_PREFIX);
                        stringBuffer.append(SqlDates.formatTimestampLit((java.util.Date)timestamp, this.use_gmt));
                        stringBuffer.append(FUNC_IDATE_SUFFIX);
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                n4 = this.nextToken(false);
                if (n4 != 2 || (n3 = SqlParse.keyword(this.text, this.token_beg, this.token_end, esc_func)) == -1) {
                    this.append_escape(this.token_beg, n2 - 1, bl, stringBuffer);
                    break;
                }
                switch (n3) {
                    case 10: {
                        stringBuffer.append(func_xlat[n3]);
                        break block0;
                    }
                    case 3: {
                        this.parseConvert(this.token_beg, n2 - 1, bl, stringBuffer);
                        break block0;
                    }
                    case 5: 
                    case 6: {
                        if (!this.conn.is_gmt) {
                            stringBuffer.append(this.ansi_date_syntax ? FUNC_ADATE_CONST : FUNC_IDATE_CONST);
                            break block0;
                        }
                        if (this.ansi_date_syntax) {
                            stringBuffer.append(FUNC_ADATE_PREFIX);
                            stringBuffer.append(SqlDates.formatDate(new java.util.Date(), false));
                            stringBuffer.append("'");
                            break block0;
                        }
                        stringBuffer.append(FUNC_IDATE_PREFIX);
                        stringBuffer.append(SqlDates.formatDateLit(new java.util.Date(), false));
                        stringBuffer.append(FUNC_IDATE_SUFFIX);
                        break block0;
                    }
                    case 7: 
                    case 9: {
                        if (!this.conn.is_gmt) {
                            stringBuffer.append(this.ansi_date_syntax ? FUNC_ATIME_CONST : "date('now')");
                            break block0;
                        }
                        if (this.ansi_date_syntax) {
                            java.util.Date date = new java.util.Date();
                            stringBuffer.append(FUNC_TIME_PREFIX);
                            stringBuffer.append(SqlDates.formatTime(date, false));
                            if (!this.conn.osql_dates) {
                                stringBuffer.append(SqlDates.formatTZ(System.currentTimeMillis()));
                            }
                            stringBuffer.append("'");
                            break block0;
                        }
                        stringBuffer.append(FUNC_IDATE_PREFIX);
                        stringBuffer.append(SqlDates.formatTimestampLit(new java.util.Date(), this.use_gmt));
                        stringBuffer.append(FUNC_IDATE_SUFFIX);
                        break block0;
                    }
                    case 8: 
                    case 19: {
                        if (!this.conn.is_gmt) {
                            stringBuffer.append(this.ansi_date_syntax ? FUNC_ASTAMP_CONST : "date('now')");
                            break block0;
                        }
                        if (this.ansi_date_syntax) {
                            java.util.Date date = new java.util.Date();
                            stringBuffer.append(FUNC_STAMP_PREFIX);
                            stringBuffer.append(SqlDates.formatTimestamp(date, false));
                            if (!this.conn.osql_dates) {
                                stringBuffer.append(SqlDates.formatTZ(date));
                            }
                            stringBuffer.append("'");
                            break block0;
                        }
                        stringBuffer.append(FUNC_IDATE_PREFIX);
                        stringBuffer.append(SqlDates.formatTimestampLit(new java.util.Date(), this.use_gmt));
                        stringBuffer.append(FUNC_IDATE_SUFFIX);
                        break block0;
                    }
                    case 27: {
                        stringBuffer.append(func_xlat[n3]);
                        break block0;
                    }
                }
                stringBuffer.append(func_xlat[n3]);
                this.append_escape(this.token_end, n2 - 1, bl, stringBuffer);
                break;
            }
            case 2: {
                this.append_escape(n + 1, n2 - 1, bl, stringBuffer);
                break;
            }
            case 4: {
                this.nextToken(false);
                this.append_escape(this.token_beg, n2 - 1, bl, stringBuffer);
                break;
            }
            default: {
                stringBuffer.append('{');
                this.append_escape(n + 1, n2 - 1, bl, stringBuffer);
                stringBuffer.append('}');
            }
        }
    }

    private void parseConvert(int n, int n2, boolean bl, StringBuffer stringBuffer) throws SqlEx {
        boolean bl2 = false;
        this.token_beg = this.token_end = n;
        int n3 = this.nextToken(false);
        if (n3 == 2 && (n3 = this.nextToken(false)) == 10) {
            int n4 = this.token_end;
            this.token_beg = this.token_end = n2;
            n3 = this.prevToken();
            if (n3 == 11 && (n3 = this.prevToken()) == 2) {
                String string = new String(this.text, this.token_beg, this.token_end - this.token_beg);
                if ((string = (String)types.get(string.toUpperCase())) != null && (n3 = this.prevToken()) == 14) {
                    stringBuffer.append(string);
                    stringBuffer.append('(');
                    this.append_escape(n4, this.token_beg, bl, stringBuffer);
                    stringBuffer.append(')');
                    bl2 = true;
                }
            }
        }
        if (!bl2) {
            this.append_escape(n, n2, bl, stringBuffer);
        }
    }

    private void append_escape(int n, int n2, boolean bl, StringBuffer stringBuffer) throws SqlEx {
        if (!bl) {
            stringBuffer.append(this.text, n, n2 - n);
        } else {
            int n3;
            int n4 = this.txt_len;
            this.txt_len = n2;
            this.token_beg = this.token_end = n;
            while ((n3 = this.nextToken(true)) != -2) {
                if (n3 != 5) continue;
                if (this.token_beg > n) {
                    stringBuffer.append(this.text, n, this.token_beg - n);
                }
                n = this.token_end;
                this.parseESC(this.token_beg, n, this.nested, stringBuffer);
                this.token_beg = this.token_end = n;
            }
            if (n < n2) {
                stringBuffer.append(this.text, n, n2 - n);
            }
            this.txt_len = n4;
        }
    }

    private StringBuffer append_text(char[] cArray, int n, int n2, int n3, StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(n);
        }
        if (n3 > n2) {
            stringBuffer.append(cArray, n2, n3 - n2);
        }
        return stringBuffer;
    }

    private void save_text(StringBuffer stringBuffer) {
        if (stringBuffer.length() > this.text.length) {
            this.text = new char[stringBuffer.length()];
        }
        this.txt_len = stringBuffer.length();
        stringBuffer.getChars(0, this.txt_len, this.text, 0);
        stringBuffer.setLength(0);
    }

    private byte[] hex2bin(char[] cArray, int n, int n2) throws SqlEx {
        byte[] byArray = new byte[n2 / 2];
        try {
            int n3 = 0;
            while (n3 < byArray.length) {
                byArray[n3] = (byte)Short.parseShort(new String(cArray, n, 2), 16);
                ++n3;
                n += 2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC4014_CALL_SYNTAX);
        }
        return byArray;
    }

    private int nextToken(boolean bl) throws SqlEx {
        int n;
        while (this.token_end < this.txt_len && Character.isWhitespace(this.text[this.token_end])) {
            ++this.token_end;
        }
        this.token_beg = this.token_end;
        if (this.token_end >= this.txt_len) {
            return -2;
        }
        this.token_end = this.token_beg + 1;
        char c = this.text[this.token_beg];
        switch (c) {
            case '(': {
                n = 10;
                break;
            }
            case ')': {
                n = 11;
                break;
            }
            case ',': {
                n = 14;
                break;
            }
            case '?': {
                n = 15;
                break;
            }
            case '=': {
                n = 16;
                break;
            }
            case '+': {
                n = 17;
                break;
            }
            case '-': {
                n = 18;
                break;
            }
            case '.': {
                n = 19;
                break;
            }
            case '}': {
                n = 13;
                break;
            }
            case '{': {
                if (!bl) {
                    n = 12;
                    break;
                }
                this.token_end = this.match(this.text, this.token_beg, this.txt_len, '}') + 1;
                n = 5;
                break;
            }
            case '\"': 
            case '\'': {
                this.token_end = this.match(this.text, this.token_beg, this.txt_len, c) + 1;
                n = 1;
                break;
            }
            default: {
                if (SqlParse.isIdentChar(c)) {
                    n = 2;
                    while (this.token_end < this.txt_len && (SqlParse.isIdentChar(c = this.text[this.token_end]) || Character.isDigit(c))) {
                        ++this.token_end;
                    }
                    break;
                }
                if (Character.isDigit(c)) {
                    n = 3;
                    while (this.token_end < this.txt_len && Character.isDigit(this.text[this.token_end])) {
                        ++this.token_end;
                    }
                    break;
                }
                n = 4;
            }
        }
        return n;
    }

    private int prevToken() throws SqlEx {
        int n;
        while (--this.token_beg >= 0 && Character.isWhitespace(this.text[this.token_beg])) {
        }
        if (this.token_beg < 0) {
            this.token_beg = 0;
            this.token_end = 0;
            return -2;
        }
        this.token_end = this.token_beg + 1;
        char c = this.text[this.token_beg];
        switch (c) {
            case '(': {
                n = 10;
                break;
            }
            case ')': {
                n = 11;
                break;
            }
            case '{': {
                n = 12;
                break;
            }
            case '}': {
                n = 13;
                break;
            }
            case ',': {
                n = 14;
                break;
            }
            case '?': {
                n = 15;
                break;
            }
            case '=': {
                n = 16;
                break;
            }
            case '+': {
                n = 17;
                break;
            }
            case '-': {
                n = 18;
                break;
            }
            case '.': {
                n = 19;
                break;
            }
            default: {
                if (SqlParse.isIdentChar(c)) {
                    n = 2;
                    while (this.token_beg > 0 && (SqlParse.isIdentChar(c = this.text[this.token_beg - 1]) || Character.isDigit(c))) {
                        --this.token_beg;
                    }
                    break;
                }
                if (Character.isDigit(c)) {
                    n = 3;
                    while (this.token_beg > 0 && Character.isDigit(this.text[this.token_beg - 1])) {
                        --this.token_beg;
                    }
                    break;
                }
                n = 4;
            }
        }
        return n;
    }

    private int match(char[] cArray, int n, int n2, char c) throws SqlEx {
        char c2 = this.text[n];
        int n3 = 0;
        this.nested = false;
        while (++n < n2) {
            char c3 = this.text[n];
            if (c3 == c) {
                if (n3 > 0) {
                    --n3;
                    continue;
                }
                return n;
            }
            if (c3 != c2) continue;
            ++n3;
            this.nested = true;
        }
        throw SqlEx.get(ERR_GC4013_UNMATCHED);
    }

    private static int keyword(char[] cArray, int n, int n2, String[] stringArray) {
        int n3 = n2 - n;
        for (int i = 0; i < stringArray.length; ++i) {
            int n4;
            if (n3 != stringArray[i].length()) continue;
            for (n4 = 0; n4 < n3 && stringArray[i].charAt(n4) == Character.toUpperCase(cArray[n + n4]); ++n4) {
            }
            if (n4 != n3) continue;
            return i;
        }
        return -1;
    }

    private static boolean isIdentChar(char c) {
        return Character.isLetter(c) || c == '_' || c == '$' || c == '@' || c == '#';
    }

    static {
        types.put("BINARY", "BYTE");
        types.put("CHAR", "CHAR");
        types.put("DECIMAL", "DECIMAL");
        types.put("DOUBLE", "FLOAT8");
        types.put("FLOAT", "FLOAT8");
        types.put("INTEGER", "INT4");
        types.put("LONGVARBINARY", "LONG_BYTE");
        types.put("LONGVARCHAR", "LONG_VARCHAR");
        types.put("NUMERIC", "DECIMAL");
        types.put("REAL", "FLOAT4");
        types.put("SMALLINT", "INT2");
        types.put("TIMESTAMP", "DATE");
        types.put("TINYINT", "INT1");
        types.put("VARBINARY", "VARBYTE");
        types.put("VARCHAR", "VARCHAR");
    }
}

