/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvClob;
import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvConst;
import com.ingres.gcf.jdbc.DrvLOB;
import com.ingres.gcf.jdbc.DrvNlob;
import com.ingres.gcf.jdbc.DrvTrace;
import com.ingres.gcf.util.BufferedClob;
import com.ingres.gcf.util.SqlEx;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class JdbcClob
implements Clob,
DrvConst {
    private Clob clob = null;
    private int segSize = 8192;
    private DrvTrace trace = null;
    private String title = null;

    JdbcClob(DrvClob drvClob, DrvTrace drvTrace) {
        this.clob = drvClob;
        this.trace = drvTrace;
        this.title = drvTrace.getTraceName() + "-Clob[LOC:" + drvClob.toString() + "]";
    }

    JdbcClob(DrvClob drvClob, int n, DrvTrace drvTrace) {
        this(drvClob, drvTrace);
        this.segSize = n;
    }

    JdbcClob(DrvNlob drvNlob, DrvTrace drvTrace) {
        this.clob = drvNlob;
        this.trace = drvTrace;
        this.title = drvTrace.getTraceName() + "-Clob[LOC:" + drvNlob.toString() + "]";
    }

    JdbcClob(DrvNlob drvNlob, int n, DrvTrace drvTrace) {
        this(drvNlob, drvTrace);
        this.segSize = n;
    }

    public String toString() {
        return this.title;
    }

    boolean isValidLocator(DrvConn drvConn) {
        return this.clob instanceof DrvLOB ? ((DrvLOB)((Object)this.clob)).hasSameDomain(drvConn) : false;
    }

    DrvLOB getLOB() {
        return this.clob instanceof DrvLOB ? (DrvLOB)((Object)this.clob) : null;
    }

    public long length() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".length()");
        }
        long l = this.clob.length();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".length: " + l);
        }
        return l;
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getAsciiStream()");
        }
        return this.clob.getAsciiStream();
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCharacterStream()");
        }
        return this.clob.getCharacterStream();
    }

    public String getSubString(long l, int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSubString(" + l + "," + n + ")");
        }
        String string = this.clob.getSubString(l, n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSubString:" + string.length() + " characters");
        }
        return string;
    }

    public long position(String string, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".position(" + l + ")");
        }
        long l2 = this.clob.position(string, l);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".position: " + l2);
        }
        return l2;
    }

    public long position(Clob clob, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".position(" + clob + "," + l + ")");
        }
        if (clob == null) {
            throw new NullPointerException();
        }
        if (clob instanceof JdbcClob) {
            clob = ((JdbcClob)clob).clob;
        }
        long l2 = this.clob.position(clob, l);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".position: " + l2);
        }
        return l2;
    }

    public int setString(long l, String string) throws SQLException {
        return this.setString(l, string, 0, string.length());
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setString(" + l + "," + n2 + ")");
        }
        this.prepareToUpdate();
        int n3 = this.clob.setString(l, string, n, n2);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setString: " + n3);
        }
        return n3;
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setAsciiStream(" + l + ")");
        }
        this.prepareToUpdate();
        return this.clob.setAsciiStream(l);
    }

    public Writer setCharacterStream(long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setCharacterStream(" + l + ")");
        }
        this.prepareToUpdate();
        return this.clob.setCharacterStream(l);
    }

    public void truncate(long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".truncate(" + l + ")");
        }
        this.prepareToUpdate();
        this.clob.truncate(l);
    }

    private void prepareToUpdate() throws SqlEx {
        if (this.clob instanceof DrvClob) {
            this.clob = new BufferedClob(this.segSize, ((DrvClob)this.clob).get());
            this.title = this.trace.getTraceName() + "-Clob[cache]";
        } else if (this.clob instanceof DrvNlob) {
            this.clob = new BufferedClob(this.segSize, ((DrvNlob)this.clob).get());
            this.title = this.trace.getTraceName() + "-Clob[cache]";
        }
    }
}

