/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.dam;

import com.ingres.gcf.dam.MsgConst;
import com.ingres.gcf.dam.TlConst;
import com.ingres.gcf.util.CharSet;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.TraceLog;
import com.ingres.gcf.util.Tracing;
import java.net.InetAddress;
import java.net.Socket;

class MsgIo
implements GcfErr,
TlConst,
MsgConst {
    public static final String DAM_ML_TRACE_ID = "msg";
    protected Socket socket = null;
    protected CharSet char_set = null;
    protected byte msg_proto_lvl = 1;
    protected byte tl_proto_lvl = 1;
    protected String title = null;
    protected Tracing trace;
    private int conn_id = connections++;
    private static int connections = 0;

    protected MsgIo(String string, TraceLog traceLog) throws SqlEx {
        InetAddress[] inetAddressArray;
        this.trace = new Tracing(traceLog, DAM_ML_TRACE_ID);
        this.title = "MsgIo[" + this.conn_id + "]";
        int n = 0;
        int n2 = 0;
        Exception exception = null;
        if (this.trace.enabled(2)) {
            this.trace.write(this.title + ": opening network connection");
        }
        try {
            String string2 = this.getHost(string);
            n = this.getPort(string);
            inetAddressArray = InetAddress.getAllByName(string2);
        }
        catch (SqlEx sqlEx) {
            throw sqlEx;
        }
        catch (Exception exception2) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": connection error - " + exception2.getMessage());
            }
            throw SqlEx.get(ERR_GC4001_CONNECT_ERR, exception2);
        }
        for (n2 = 0; n2 < inetAddressArray.length; ++n2) {
            try {
                if (this.trace.enabled(3)) {
                    this.trace.write(this.title + ": " + string + " -> " + inetAddressArray[n2] + "," + n);
                }
                this.socket = new Socket(inetAddressArray[n2], n);
                break;
            }
            catch (Exception exception3) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": connection failed to address[" + n2 + "]=" + inetAddressArray[n2] + " - " + exception3.getMessage());
                }
                exception = exception3;
                try {
                    this.socket.close();
                }
                catch (Exception exception4) {
                    // empty catch block
                }
                continue;
            }
        }
        if (n2 == inetAddressArray.length) {
            this.trace.write(this.title + ": connection error - all addresses failed");
            throw SqlEx.get(ERR_GC4001_CONNECT_ERR, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        if (this.socket != null) {
            if (this.trace.enabled(2)) {
                this.trace.write(this.title + ": closing network connection");
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.socket = null;
            }
        }
    }

    protected void disconnect() {
        this.close();
    }

    public void abort() {
        this.close();
    }

    public boolean isClosed() {
        return this.socket == null;
    }

    public boolean isLocal() {
        return this.socket == null ? false : this.socket.getInetAddress().equals(this.socket.getLocalAddress());
    }

    public int connID() {
        return this.conn_id;
    }

    public String getRemoteHost() {
        String string;
        try {
            string = this.socket.getInetAddress().getHostName();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public String getRemoteAddr() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public String getLocalHost() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public String getLocalAddr() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public byte setProtocolLevel(byte by) {
        byte by2 = this.msg_proto_lvl;
        this.msg_proto_lvl = by;
        return by2;
    }

    public CharSet getCharSet() {
        return this.char_set;
    }

    public void setCharSet(CharSet charSet) {
        this.char_set = charSet;
    }

    private String getHost(String string) throws SqlEx {
        int n;
        int n2 = 0;
        if (string.startsWith("[")) {
            n2 = 1;
            n = string.indexOf(93);
            if (n < 0) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": right bracket ']' missing at end of IPv6 @ in '" + string + "'");
                }
                throw SqlEx.get(ERR_GC4000_BAD_URL);
            }
        } else {
            n = string.indexOf(58);
        }
        return n < 0 ? string : string.substring(n2, n);
    }

    private int getPort(String string) throws SqlEx {
        int n;
        if (string.startsWith("[")) {
            n = string.indexOf("]:");
            if (n >= 0) {
                ++n;
            }
        } else {
            n = string.indexOf(58, 0);
        }
        if (n < 0 || string.length() <= ++n) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": port number missing '" + string + "'");
            }
            throw SqlEx.get(ERR_GC4000_BAD_URL);
        }
        String string2 = string.substring(n);
        int n2 = this.translatePortID(string2);
        if (n2 < 0) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": invalid port '" + string2 + "'");
            }
            throw SqlEx.get(ERR_GC4000_BAD_URL);
        }
        return n2;
    }

    private int translatePortID(String string) {
        int n;
        if (string.length() == 2 || string.length() == 3) {
            char c;
            char c2 = string.charAt(0);
            char c3 = string.charAt(1);
            char c4 = c = string.length() == 3 ? (char)string.charAt(2) : (char)'0';
            if (Character.isLetter(c2) && Character.isLetterOrDigit(c3) && Character.isDigit(c)) {
                c2 = Character.toUpperCase(c2);
                c3 = Character.toUpperCase(c3);
                return 0x4000 | (c2 & 0x1F) << 9 | (c3 & 0x3F) << 3 | c & 7;
            }
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }
}

