/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.dam;

import com.ingres.gcf.dam.InBuff;
import com.ingres.gcf.dam.MsgConst;
import com.ingres.gcf.dam.MsgOut;
import com.ingres.gcf.dam.TlConst;
import com.ingres.gcf.util.ByteArray;
import com.ingres.gcf.util.CharArray;
import com.ingres.gcf.util.CharSet;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.IdMap;
import com.ingres.gcf.util.IngresDate;
import com.ingres.gcf.util.SqlBigInt;
import com.ingres.gcf.util.SqlByte;
import com.ingres.gcf.util.SqlChar;
import com.ingres.gcf.util.SqlDate;
import com.ingres.gcf.util.SqlDecimal;
import com.ingres.gcf.util.SqlDouble;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.SqlInt;
import com.ingres.gcf.util.SqlLoc;
import com.ingres.gcf.util.SqlLongByte;
import com.ingres.gcf.util.SqlLongByteCache;
import com.ingres.gcf.util.SqlLongChar;
import com.ingres.gcf.util.SqlLongCharCache;
import com.ingres.gcf.util.SqlLongNChar;
import com.ingres.gcf.util.SqlLongNCharCache;
import com.ingres.gcf.util.SqlNChar;
import com.ingres.gcf.util.SqlNVarChar;
import com.ingres.gcf.util.SqlNull;
import com.ingres.gcf.util.SqlReal;
import com.ingres.gcf.util.SqlSmallInt;
import com.ingres.gcf.util.SqlStream;
import com.ingres.gcf.util.SqlTime;
import com.ingres.gcf.util.SqlTimestamp;
import com.ingres.gcf.util.SqlTinyInt;
import com.ingres.gcf.util.SqlVarByte;
import com.ingres.gcf.util.SqlVarChar;
import com.ingres.gcf.util.Trace;
import com.ingres.gcf.util.TraceLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

class MsgIn
extends MsgOut
implements TlConst,
MsgConst,
GcfErr {
    private InBuff in;
    private byte in_msg_id;
    private short in_msg_len;
    private byte in_msg_flg;
    private static String empty = "";

    protected MsgIn(String string, byte[][] byArray, TraceLog traceLog) throws SqlEx {
        int n;
        block55: {
            String string2;
            block54: {
                super(string, byArray[0], traceLog);
                this.in = null;
                this.in_msg_id = 0;
                this.in_msg_len = 0;
                this.in_msg_flg = 0;
                this.title = "MsgIn[" + this.connID() + "]";
                byArray[0] = null;
                try {
                    this.in = new InBuff(this.socket.getInputStream(), this.connID(), 1024, traceLog);
                }
                catch (Exception exception) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.title + ": error creating input buffer: " + exception.getMessage());
                    }
                    this.disconnect();
                    throw SqlEx.get(ERR_GC4001_CONNECT_ERR, exception);
                }
                string2 = null;
                int n2 = -1;
                n = 10;
                try {
                    if (this.trace.enabled(3)) {
                        this.trace.write(this.title + ": confirm TL connect");
                    }
                    short s = this.in.receive();
                    switch (s) {
                        case 17219: {
                            break;
                        }
                        case 21060: {
                            this.serverDisconnect();
                            break;
                        }
                        default: {
                            if (this.trace.enabled(1)) {
                                this.trace.write(this.title + ": invalid TL CC packet ID " + s);
                            }
                            throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
                        }
                    }
                    block32: while (this.in.avail() >= 2) {
                        byte by = this.in.readByte();
                        short s2 = (short)(this.in.readByte() & 0xFF);
                        if (s2 == 255) {
                            if (this.in.avail() >= 2) {
                                s2 = this.in.readShort();
                            } else {
                                throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
                            }
                        }
                        if (this.in.avail() < s2) {
                            throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
                        }
                        block9 : switch (by) {
                            case 1: {
                                if (s2 == 1) {
                                    this.tl_proto_lvl = this.in.readByte();
                                    break;
                                }
                                throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
                            }
                            case 2: {
                                switch (s2) {
                                    case 1: {
                                        n = this.in.readByte();
                                        break block9;
                                    }
                                    case 2: {
                                        n = this.in.readShort();
                                        break block9;
                                    }
                                    case 4: {
                                        n = this.in.readInt();
                                        break block9;
                                    }
                                }
                                throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
                            }
                            case 4: {
                                byte[] byArray2 = new byte[s2];
                                if (this.in.readBytes(byArray2, 0, s2) == s2) {
                                    try {
                                        string2 = new String(byArray2, "US-ASCII");
                                        break;
                                    }
                                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                                        throw SqlEx.get(ERR_GC401E_CHAR_ENCODE);
                                    }
                                }
                                throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
                            }
                            case 5: {
                                if (this.tl_proto_lvl < 2) {
                                    throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
                                }
                                switch (s2) {
                                    case 1: {
                                        n2 = this.in.readByte();
                                        break block9;
                                    }
                                    case 2: {
                                        n2 = this.in.readShort();
                                        break block9;
                                    }
                                    case 4: {
                                        n2 = this.in.readInt();
                                        break block9;
                                    }
                                }
                                throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
                            }
                            case 3: {
                                byArray[0] = new byte[s2];
                                if (this.in.readBytes(byArray[0], 0, s2) == s2) continue block32;
                                throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
                            }
                            case 6: {
                                if (s2 == 4 && this.in.readInt() == 0x4C4D4D44) continue block32;
                                throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
                            }
                            default: {
                                if (this.trace.enabled(1)) {
                                    this.trace.write(this.title + ": Bad TL CC param ID: " + by);
                                }
                                throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
                            }
                        }
                    }
                    if (this.in.avail() > 0) {
                        throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
                    }
                    if (this.tl_proto_lvl < 1 || this.tl_proto_lvl > 2 || n < 10 || n > 15) {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.title + ": invalid TL parameter: protocol " + this.tl_proto_lvl + ", size " + n);
                        }
                        throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
                    }
                }
                catch (SqlEx sqlEx) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.title + ": error negotiating parameters");
                    }
                    this.disconnect();
                    throw sqlEx;
                }
                if (n2 >= 0) {
                    try {
                        this.char_set = CharSet.getCharSet(n2);
                    }
                    catch (Exception exception) {
                        if (!this.trace.enabled(1)) break block54;
                        this.trace.write(this.title + ": unknown character-set: " + n2);
                    }
                }
            }
            if (this.char_set == null && string2 != null) {
                try {
                    this.char_set = CharSet.getCharSet(string2);
                }
                catch (Exception exception) {
                    if (!this.trace.enabled(1)) break block55;
                    this.trace.write(this.title + ": unknown character-set: " + string2);
                }
            }
        }
        if (n != 10) {
            this.setBuffSize(1 << n);
        }
        this.setIoProtoLvl(this.tl_proto_lvl);
        if (this.trace.enabled(2)) {
            this.trace.write(this.title + ": TL connection opened");
        }
        if (this.trace.enabled(3)) {
            this.trace.write("    TL protocol level : " + this.tl_proto_lvl);
            this.trace.write("    TL buffer size    : " + (1 << n));
            this.trace.write("    Character encoding: " + this.char_set);
        }
        if (byArray[0] == null) {
            byArray[0] = new byte[0];
        }
    }

    protected void disconnect() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.disconnect();
    }

    protected void close() {
        block9: {
            super.close();
            try {
                if (this.trace.enabled(3)) {
                    this.trace.write(this.title + ": confirm TL disconnect");
                }
                block6: while (true) {
                    switch (this.in.receive()) {
                        case 17220: {
                            break block6;
                        }
                        case 21060: {
                            this.serverDisconnect();
                        }
                        default: {
                            continue block6;
                        }
                    }
                    break;
                }
                if (this.trace.enabled(2)) {
                    this.trace.write(this.title + ": TL connection closed");
                }
            }
            catch (SqlEx sqlEx) {
                if (!this.trace.enabled(2)) break block9;
                this.trace.write(this.title + ": TL connection aborted");
            }
        }
    }

    protected void setBuffSize(int n) {
        this.in.setBuffSize(n);
        super.setBuffSize(n);
    }

    protected void setIoProtoLvl(byte by) {
        this.in.setProtoLvl(by);
        super.setIoProtoLvl(by);
    }

    private void serverDisconnect() throws SqlEx {
        if (this.in.avail() >= 2) {
            byte by = this.in.readByte();
            byte by2 = this.in.readByte();
            if (by == 1 && this.in.avail() >= by2) {
                int n;
                switch (by2) {
                    case 1: {
                        n = this.in.readByte();
                        break;
                    }
                    case 2: {
                        n = this.in.readShort();
                        break;
                    }
                    case 4: {
                        n = this.in.readInt();
                        break;
                    }
                    default: {
                        n = 802824;
                    }
                }
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": server abort 0x" + Integer.toHexString(n));
                }
                SqlEx sqlEx = SqlEx.get(ERR_GC4008_SERVER_ABORT);
                throw new SqlEx(sqlEx.getMessage(), sqlEx.getSQLState(), n);
            }
        }
        if (this.trace.enabled(1)) {
            this.trace.write(this.title + ": server abort");
        }
        throw SqlEx.get(ERR_GC4008_SERVER_ABORT);
    }

    public byte receive() throws SqlEx {
        if (this.trace.enabled(3)) {
            this.trace.write(this.title + ": check TL data");
        }
        block6: while (this.in.avail() < 8) {
            try {
                if (this.in.avail() > 0) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.title + ": invalid header length " + this.in.avail() + " bytes");
                    }
                    throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
                }
                short s = this.in.receive();
                switch (s) {
                    case 21572: {
                        continue block6;
                    }
                    case 21060: {
                        this.serverDisconnect();
                        continue block6;
                    }
                }
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": invalid TL packet ID 0x" + Integer.toHexString(s));
                }
                throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
            }
            catch (SqlEx sqlEx) {
                this.disconnect();
                throw sqlEx;
            }
        }
        int n = this.in.readInt();
        if (this.msg_proto_lvl < 3 && n != 1128416330 || this.msg_proto_lvl >= 3 && n != 0x4C4D4D44) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": invalid header ID 0x" + Integer.toHexString(n));
            }
            this.disconnect();
            throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
        }
        this.in_msg_len = this.in.readShort();
        this.in_msg_id = this.in.readByte();
        this.in_msg_flg = this.in.readByte();
        if (this.trace.enabled(2)) {
            this.trace.write(this.title + ": received message " + IdMap.map(this.in_msg_id, MsgConst.msgMap) + " length " + this.in_msg_len + ((this.in_msg_flg & 1) == 0 ? "" : " EOD") + ((this.in_msg_flg & 2) == 0 ? "" : " EOG"));
        }
        return this.in_msg_id;
    }

    public boolean moreData() throws SqlEx {
        byte by = this.in_msg_id;
        while (this.in_msg_len <= 0 && (this.in_msg_flg & 1) == 0) {
            if (this.receive() == by) continue;
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": invalid message continuation " + by + " to " + this.in_msg_id);
            }
            this.disconnect();
            throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
        }
        return this.in_msg_len > 0;
    }

    public boolean moreMessages() {
        return (this.in_msg_flg & 2) == 0;
    }

    public int skip(int n) throws SqlEx {
        int n2 = 0;
        if (this.trace.enabled(4)) {
            this.trace.write(this.title + ": skipping " + n + " bytes");
        }
        while (n > 0) {
            this.need(n, false);
            int n3 = Math.min(this.in_msg_len, n);
            n3 = this.in.skip(n3);
            n -= n3;
            this.in_msg_len = (short)(this.in_msg_len - n3);
            n2 += n3;
        }
        return n2;
    }

    public byte readByte() throws SqlEx {
        this.need(1, true);
        this.in_msg_len = (short)(this.in_msg_len - 1);
        return this.in.readByte();
    }

    public short readShort() throws SqlEx {
        this.need(2, true);
        this.in_msg_len = (short)(this.in_msg_len - 2);
        return this.in.readShort();
    }

    public int readInt() throws SqlEx {
        this.need(4, true);
        this.in_msg_len = (short)(this.in_msg_len - 4);
        return this.in.readInt();
    }

    public long readLong() throws SqlEx {
        this.need(8, true);
        this.in_msg_len = (short)(this.in_msg_len - 8);
        return this.in.readLong();
    }

    public float readFloat() throws SqlEx {
        this.need(6, true);
        this.in_msg_len = (short)(this.in_msg_len - 6);
        return this.in.readFloat();
    }

    public double readDouble() throws SqlEx {
        this.need(10, true);
        this.in_msg_len = (short)(this.in_msg_len - 10);
        return this.in.readDouble();
    }

    public byte[] readBytes() throws SqlEx {
        return this.readBytes(this.readShort());
    }

    public byte[] readBytes(int n) throws SqlEx {
        byte[] byArray = new byte[n];
        this.readBytes(byArray, 0, n);
        return byArray;
    }

    public int readBytes(byte[] byArray, int n, int n2) throws SqlEx {
        int n3 = n2;
        while (n2 > 0) {
            this.need(n2, false);
            int n4 = Math.min(this.in_msg_len, n2);
            n4 = this.in.readBytes(byArray, n, n4);
            n += n4;
            n2 -= n4;
            this.in_msg_len = (short)(this.in_msg_len - n4);
        }
        return n3 - n2;
    }

    public int readBytes(ByteArray byteArray, int n) throws SqlEx {
        int n2 = n;
        while (n > 0) {
            this.need(n, false);
            int n3 = Math.min(this.in_msg_len, n);
            n3 = this.in.readBytes(byteArray, n3);
            n -= n3;
            this.in_msg_len = (short)(this.in_msg_len - n3);
        }
        return n2 - n;
    }

    public String readString() throws SqlEx {
        return this.readString(this.readShort());
    }

    public String readString(int n) throws SqlEx {
        String string;
        if (n <= this.in_msg_len) {
            if (n <= 0) {
                string = empty;
            } else {
                string = this.in.readString(n, this.char_set);
                this.in_msg_len = (short)(this.in_msg_len - n);
            }
        } else {
            byte[] byArray = this.readBytes(n);
            try {
                string = this.char_set.getString(byArray);
            }
            catch (Exception exception) {
                throw SqlEx.get(ERR_GC401E_CHAR_ENCODE);
            }
        }
        return string;
    }

    public String readUCS2() throws SqlEx {
        return this.readUCS2(this.readShort());
    }

    public String readUCS2(short n) throws SqlEx {
        if (n < 1) {
            return empty;
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)this.readShort();
        }
        return new String(cArray);
    }

    public int readUCS2(CharArray charArray, int n) throws SqlEx {
        for (int i = n; i > 0; --i) {
            charArray.put((char)this.readShort());
        }
        return n;
    }

    public InputStream readByteStream() throws SqlEx {
        return new ByteSegIS(this, this.trace, this.in_msg_id);
    }

    public InputStream readByteStream(InputStream inputStream) throws SqlEx {
        if (inputStream != null && inputStream instanceof ByteSegIS) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((ByteSegIS)inputStream).begin(this.in_msg_id);
        } else {
            inputStream = new ByteSegIS(this, this.trace, this.in_msg_id);
        }
        return inputStream;
    }

    public Reader readUCS2Reader() throws SqlEx {
        return new Ucs2SegRdr(this, this.trace, this.in_msg_id);
    }

    public Reader readUCS2Reader(Reader reader) throws SqlEx {
        if (reader != null && reader instanceof Ucs2SegRdr) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((Ucs2SegRdr)reader).begin(this.in_msg_id);
        } else {
            reader = new Ucs2SegRdr(this, this.trace, this.in_msg_id);
        }
        return reader;
    }

    public void readSqlData(SqlNull sqlNull) throws SqlEx {
        if (this.readSqlDataIndicator()) {
            throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
        }
        sqlNull.setNull();
    }

    public void readSqlData(SqlTinyInt sqlTinyInt) throws SqlEx {
        if (this.readSqlDataIndicator()) {
            sqlTinyInt.set(this.readByte());
        } else {
            sqlTinyInt.setNull();
        }
    }

    public void readSqlData(SqlSmallInt sqlSmallInt) throws SqlEx {
        if (this.readSqlDataIndicator()) {
            sqlSmallInt.set(this.readShort());
        } else {
            sqlSmallInt.setNull();
        }
    }

    public void readSqlData(SqlInt sqlInt) throws SqlEx {
        if (this.readSqlDataIndicator()) {
            sqlInt.set(this.readInt());
        } else {
            sqlInt.setNull();
        }
    }

    public void readSqlData(SqlBigInt sqlBigInt) throws SqlEx {
        if (this.readSqlDataIndicator()) {
            sqlBigInt.set(this.readLong());
        } else {
            sqlBigInt.setNull();
        }
    }

    public void readSqlData(SqlReal sqlReal) throws SqlEx {
        if (this.readSqlDataIndicator()) {
            sqlReal.set(this.readFloat());
        } else {
            sqlReal.setNull();
        }
    }

    public void readSqlData(SqlDouble sqlDouble) throws SqlEx {
        if (this.readSqlDataIndicator()) {
            sqlDouble.set(this.readDouble());
        } else {
            sqlDouble.setNull();
        }
    }

    public void readSqlData(SqlDecimal sqlDecimal) throws SqlEx {
        if (this.readSqlDataIndicator()) {
            sqlDecimal.set(this.readString());
        } else {
            sqlDecimal.setNull();
        }
    }

    public void readSqlData(SqlDate sqlDate) throws SqlEx {
        if (this.readSqlDataIndicator()) {
            sqlDate.set(this.readString());
        } else {
            sqlDate.setNull();
        }
    }

    public void readSqlData(SqlTime sqlTime) throws SqlEx {
        if (this.readSqlDataIndicator()) {
            sqlTime.set(this.readString());
        } else {
            sqlTime.setNull();
        }
    }

    public void readSqlData(SqlTimestamp sqlTimestamp) throws SqlEx {
        if (this.readSqlDataIndicator()) {
            sqlTimestamp.set(this.readString());
        } else {
            sqlTimestamp.setNull();
        }
    }

    public void readSqlData(IngresDate ingresDate) throws SqlEx {
        if (this.readSqlDataIndicator()) {
            ingresDate.set(this.readString());
        } else {
            ingresDate.setNull();
        }
    }

    public void readSqlData(SqlByte sqlByte) throws SqlEx {
        if (!this.readSqlDataIndicator()) {
            sqlByte.setNull();
        } else {
            int n = sqlByte.limit();
            sqlByte.clear();
            this.readBytes(sqlByte, n);
        }
    }

    public void readSqlData(SqlVarByte sqlVarByte) throws SqlEx {
        if (!this.readSqlDataIndicator()) {
            sqlVarByte.setNull();
        } else {
            short s = this.readShort();
            sqlVarByte.clear();
            sqlVarByte.ensureCapacity(s);
            this.readBytes(sqlVarByte, s);
        }
    }

    public void readSqlData(SqlChar sqlChar) throws SqlEx {
        if (!this.readSqlDataIndicator()) {
            sqlChar.setNull();
        } else {
            int n = sqlChar.limit();
            sqlChar.clear();
            this.readBytes(sqlChar, n);
        }
    }

    public void readSqlData(SqlVarChar sqlVarChar) throws SqlEx {
        if (!this.readSqlDataIndicator()) {
            sqlVarChar.setNull();
        } else {
            short s = this.readShort();
            sqlVarChar.clear();
            sqlVarChar.ensureCapacity(s);
            this.readBytes(sqlVarChar, s);
        }
    }

    public void readSqlData(SqlNChar sqlNChar) throws SqlEx {
        if (!this.readSqlDataIndicator()) {
            sqlNChar.setNull();
        } else {
            int n = sqlNChar.limit();
            sqlNChar.clear();
            this.readUCS2(sqlNChar, n);
        }
    }

    public void readSqlData(SqlNVarChar sqlNVarChar) throws SqlEx {
        if (!this.readSqlDataIndicator()) {
            sqlNVarChar.setNull();
        } else {
            short s = this.readShort();
            sqlNVarChar.clear();
            sqlNVarChar.ensureCapacity(s);
            this.readUCS2(sqlNVarChar, s);
        }
    }

    public void readSqlData(SqlLoc sqlLoc) throws SqlEx {
        if (this.readSqlDataIndicator()) {
            sqlLoc.set(this.readInt());
        } else {
            sqlLoc.setNull();
        }
    }

    public void readSqlData(SqlLongByte sqlLongByte) throws SqlEx {
        if (this.readSqlDataIndicator()) {
            sqlLongByte.set(this.readByteStream());
        } else {
            sqlLongByte.setNull();
        }
    }

    public void readSqlData(SqlLongByteCache sqlLongByteCache) throws SqlEx {
        if (this.readSqlDataIndicator()) {
            sqlLongByteCache.set(this.readByteStream());
        } else {
            sqlLongByteCache.setNull();
        }
    }

    public void readSqlData(SqlLongChar sqlLongChar) throws SqlEx {
        if (this.readSqlDataIndicator()) {
            sqlLongChar.set(this.readByteStream());
        } else {
            sqlLongChar.setNull();
        }
    }

    public void readSqlData(SqlLongCharCache sqlLongCharCache) throws SqlEx {
        if (this.readSqlDataIndicator()) {
            sqlLongCharCache.set(this.readByteStream());
        } else {
            sqlLongCharCache.setNull();
        }
    }

    public void readSqlData(SqlLongNChar sqlLongNChar) throws SqlEx {
        if (this.readSqlDataIndicator()) {
            sqlLongNChar.set(this.readUCS2Reader());
        } else {
            sqlLongNChar.setNull();
        }
    }

    public void readSqlData(SqlLongNCharCache sqlLongNCharCache) throws SqlEx {
        if (this.readSqlDataIndicator()) {
            sqlLongNCharCache.set(this.readUCS2Reader());
        } else {
            sqlLongNCharCache.setNull();
        }
    }

    private boolean readSqlDataIndicator() throws SqlEx {
        return this.readByte() != 0;
    }

    private void need(int n, boolean bl) throws SqlEx {
        byte by = this.in_msg_id;
        while (n > this.in_msg_len) {
            if (this.in_msg_len > 0) {
                if (!bl) break;
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": atomic value split (" + this.in_msg_len + "," + n + ")");
                }
                this.disconnect();
                throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
            }
            if (this.moreData()) continue;
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": unexpected end-of-data");
            }
            this.disconnect();
            throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
        }
    }

    private static class Ucs2SegRdr
    extends Reader
    implements SqlStream.StreamSource {
        private String title;
        private Trace trace;
        private MsgIn msg_in;
        private byte msg_id = (byte)-1;
        private boolean end_of_data = true;
        private short seg_len = 0;
        private char[] ca = new char[1];
        private SqlStream.StreamListener listener = null;
        private SqlStream stream = null;

        public Ucs2SegRdr(MsgIn msgIn, Trace trace, byte by) {
            this.msg_in = msgIn;
            this.trace = trace;
            this.msg_id = by;
            this.end_of_data = false;
            this.title = "Ucs2SegRdr[" + msgIn.connID() + "]";
            if (trace.enabled(3)) {
                trace.write(this.title + " new CLOB");
            }
        }

        public void begin(byte by) {
            this.msg_id = by;
            this.end_of_data = false;
            this.seg_len = 0;
            this.listener = null;
            this.stream = null;
            if (this.trace.enabled(3)) {
                this.trace.write(this.title + " begin CLOB");
            }
        }

        public void addStreamListener(SqlStream.StreamListener streamListener, SqlStream sqlStream) {
            this.listener = streamListener;
            this.stream = sqlStream;
        }

        public int read() throws IOException {
            int n = this.read(this.ca, 0, 1);
            return n == 1 ? this.ca[0] & 0xFFFF : -1;
        }

        public int read(char[] cArray) throws IOException {
            return this.read(cArray, 0, cArray.length);
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            if (this.trace.enabled(4)) {
                this.trace.write(this.title + ".read(" + n2 + ")");
            }
            try {
                while (n2 > 0 && !this.end_of_data && (this.seg_len > 0 || this.next())) {
                    int n4 = Math.min(n2, this.seg_len);
                    int n5 = n + n4;
                    while (n < n5) {
                        cArray[n] = (char)this.msg_in.readShort();
                        ++n;
                    }
                    if (this.trace.enabled(5)) {
                        this.trace.write(this.title + ": read " + n4 + " UCS2 chars");
                    }
                    this.seg_len = (short)(this.seg_len - (short)n4);
                    n2 -= n4;
                    n3 += n4;
                }
            }
            catch (SqlEx sqlEx) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": error reading data");
                    sqlEx.trace(this.trace);
                }
                throw new IOException(sqlEx.getMessage());
            }
            if (this.trace.enabled(4)) {
                this.trace.write(this.title + ".read: " + n3 + (this.end_of_data ? " [EOD]" : ""));
            }
            return n3 > 0 ? n3 : (this.end_of_data ? -1 : 0);
        }

        public long skip(long l) throws IOException {
            long l2 = 0L;
            if (this.trace.enabled(4)) {
                this.trace.write(this.title + ".skip(" + l + ")");
            }
            try {
                while (l > 0L && !this.end_of_data && (this.seg_len > 0 || this.next())) {
                    int n = this.seg_len;
                    if ((long)n > l) {
                        n = (int)l;
                    }
                    n = this.msg_in.skip(n * 2) / 2;
                    if (this.trace.enabled(5)) {
                        this.trace.write(this.title + ": skip " + n + " UCS2 chars");
                    }
                    this.seg_len = (short)(this.seg_len - (short)n);
                    l -= (long)n;
                    l2 += (long)n;
                }
            }
            catch (SqlEx sqlEx) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": error skipping data");
                    sqlEx.trace(this.trace);
                }
                throw new IOException(sqlEx.getMessage());
            }
            if (this.trace.enabled(4)) {
                this.trace.write(this.title + ".skip: " + l2 + (this.end_of_data ? " [EOD]" : ""));
            }
            return l2;
        }

        public boolean ready() throws IOException {
            return this.seg_len > 0;
        }

        public void close() throws IOException {
            while (!this.end_of_data) {
                this.next();
            }
        }

        private boolean next() throws IOException {
            try {
                while (this.seg_len > 0) {
                    if (this.trace.enabled(4)) {
                        this.trace.write(this.title + ": skipping " + this.seg_len);
                    }
                    this.seg_len = (short)(this.seg_len - (short)this.msg_in.skip(this.seg_len * 2) / 2);
                }
                if (!this.msg_in.moreData() && this.msg_in.receive() != this.msg_id) {
                    if (this.trace.enabled(3)) {
                        this.trace.write(this.title + ": truncated!");
                    }
                    this.endStream();
                    throw new IOException("CLOB data stream truncated!");
                }
                this.seg_len = this.msg_in.readShort();
                if (this.seg_len == 0) {
                    if (this.trace.enabled(3)) {
                        this.trace.write(this.title + ": end CLOB");
                    }
                    this.endStream();
                } else if (this.trace.enabled(4)) {
                    this.trace.write(this.title + ": CLOB segment length " + this.seg_len);
                }
            }
            catch (SqlEx sqlEx) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": error reading next segment");
                    sqlEx.trace(this.trace);
                }
                throw new IOException(sqlEx.getMessage());
            }
            return !this.end_of_data;
        }

        private void endStream() {
            if (!this.end_of_data) {
                this.end_of_data = true;
                this.seg_len = 0;
                this.msg_id = (byte)-1;
                if (this.listener != null) {
                    if (this.trace.enabled(5)) {
                        this.trace.write(this.title + ": stream closure event notification");
                    }
                    this.listener.streamClosed(this.stream);
                }
            }
        }
    }

    private static class ByteSegIS
    extends InputStream
    implements SqlStream.StreamSource {
        private String title;
        private Trace trace;
        private MsgIn msg_in;
        private byte msg_id = (byte)-1;
        private boolean end_of_data = true;
        private short seg_len = 0;
        private byte[] ba = new byte[1];
        private SqlStream.StreamListener listener = null;
        private SqlStream stream = null;

        public ByteSegIS(MsgIn msgIn, Trace trace, byte by) {
            this.msg_in = msgIn;
            this.trace = trace;
            this.msg_id = by;
            this.end_of_data = false;
            this.title = "ByteSegIS[" + msgIn.connID() + "]";
            if (trace.enabled(3)) {
                trace.write(this.title + ": new BLOB");
            }
        }

        public void begin(byte by) {
            this.msg_id = by;
            this.end_of_data = false;
            this.seg_len = 0;
            this.listener = null;
            this.stream = null;
            if (this.trace.enabled(3)) {
                this.trace.write(this.title + ": begin BLOB");
            }
        }

        public void addStreamListener(SqlStream.StreamListener streamListener, SqlStream sqlStream) {
            this.listener = streamListener;
            this.stream = sqlStream;
        }

        public int read() throws IOException {
            int n = this.read(this.ba, 0, 1);
            return n == 1 ? this.ba[0] & 0xFF : -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            if (this.trace.enabled(4)) {
                this.trace.write(this.title + ".read(" + n2 + ")");
            }
            try {
                while (n2 > 0 && !this.end_of_data && (this.seg_len > 0 || this.next())) {
                    int n4 = Math.min(n2, this.seg_len);
                    n4 = this.msg_in.readBytes(byArray, n, n4);
                    if (this.trace.enabled(5)) {
                        this.trace.write(this.title + ": read " + n4 + " bytes");
                    }
                    n += n4;
                    n2 -= n4;
                    this.seg_len = (short)(this.seg_len - (short)n4);
                    n3 += n4;
                }
            }
            catch (SqlEx sqlEx) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": error reading data");
                    sqlEx.trace(this.trace);
                }
                throw new IOException(sqlEx.getMessage());
            }
            if (this.trace.enabled(4)) {
                this.trace.write(this.title + ".read: " + n3 + (this.end_of_data ? " [EOD]" : ""));
            }
            return n3 > 0 ? n3 : (this.end_of_data ? -1 : 0);
        }

        public long skip(long l) throws IOException {
            long l2 = 0L;
            if (this.trace.enabled(4)) {
                this.trace.write(this.title + ".skip(" + l + ")");
            }
            try {
                while (l > 0L && !this.end_of_data && (this.seg_len > 0 || this.next())) {
                    int n = this.seg_len;
                    if ((long)n > l) {
                        n = (int)l;
                    }
                    n = this.msg_in.skip(n);
                    if (this.trace.enabled(5)) {
                        this.trace.write(this.title + ": skip " + n + " bytes");
                    }
                    l -= (long)n;
                    this.seg_len = (short)(this.seg_len - (short)n);
                    l2 += (long)n;
                }
            }
            catch (SqlEx sqlEx) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": error skipping data");
                    sqlEx.trace(this.trace);
                }
                throw new IOException(sqlEx.getMessage());
            }
            if (this.trace.enabled(4)) {
                this.trace.write(this.title + ".skip: " + l2 + (this.end_of_data ? " [EOD]" : ""));
            }
            return l2;
        }

        public int available() throws IOException {
            return this.seg_len;
        }

        public void close() throws IOException {
            while (!this.end_of_data) {
                this.next();
            }
        }

        private boolean next() throws IOException {
            try {
                while (this.seg_len > 0) {
                    if (this.trace.enabled(4)) {
                        this.trace.write(this.title + ": skipping " + this.seg_len);
                    }
                    this.seg_len = (short)(this.seg_len - (short)this.msg_in.skip(this.seg_len));
                }
                if (!this.msg_in.moreData() && this.msg_in.receive() != this.msg_id) {
                    if (this.trace.enabled(3)) {
                        this.trace.write(this.title + ": truncated!");
                    }
                    this.endStream();
                    throw new IOException("BLOB data stream truncated!");
                }
                this.seg_len = this.msg_in.readShort();
                if (this.seg_len == 0) {
                    if (this.trace.enabled(3)) {
                        this.trace.write(this.title + ": end BLOB");
                    }
                    this.endStream();
                } else if (this.trace.enabled(4)) {
                    this.trace.write(this.title + ": BLOB segment length " + this.seg_len);
                }
            }
            catch (SqlEx sqlEx) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": error reading next segment");
                    sqlEx.trace(this.trace);
                }
                throw new IOException(sqlEx.getMessage());
            }
            return !this.end_of_data;
        }

        private void endStream() {
            if (!this.end_of_data) {
                this.end_of_data = true;
                this.seg_len = 0;
                this.msg_id = (byte)-1;
                if (this.listener != null) {
                    if (this.trace.enabled(5)) {
                        this.trace.write(this.title + ": stream closure event notification");
                    }
                    this.listener.streamClosed(this.stream);
                }
            }
        }
    }
}

