--
-- PostgreSQL database dump
--

SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: -
--

COMMENT ON SCHEMA public IS 'Standard public schema';

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: accounts; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE accounts (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    assigned_user_id character varying(36),
    created_by character varying(36),
    name character varying(150),
    parent_id character varying(36),
    account_type character varying(25),
    industry character varying(25),
    annual_revenue character varying(25),
    phone_fax character varying(25),
    billing_address_street character varying(150),
    billing_address_city character varying(100),
    billing_address_state character varying(100),
    billing_address_postalcode character varying(20),
    billing_address_country character varying(100),
    description text,
    rating character varying(25),
    phone_office character varying(25),
    phone_alternate character varying(25),
    email1 character varying(100),
    email2 character varying(100),
    website character varying(255),
    ownership character varying(100),
    employees character varying(10),
    sic_code character varying(10),
    ticker_symbol character varying(10),
    shipping_address_street character varying(150),
    shipping_address_city character varying(100),
    shipping_address_state character varying(100),
    shipping_address_postalcode character varying(20),
    shipping_address_country character varying(100),
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: accounts_audit; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE accounts_audit (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    parent_id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_created timestamp without time zone,
    created_by character varying(36),
    field_name character varying(100),
    data_type character varying(100),
    before_value_string character varying(255),
    after_value_string character varying(255),
    before_value_text text,
    after_value_text text
);


--
-- Name: accounts_bugs; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE accounts_bugs (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    account_id character(36),
    bug_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: accounts_cases; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE accounts_cases (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    account_id character(36),
    case_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: accounts_contacts; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE accounts_contacts (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    contact_id character(36),
    account_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: accounts_opportunities; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE accounts_opportunities (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    opportunity_id character(36),
    account_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: bugs; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE bugs (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    bug_number bigint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    assigned_user_id character varying(36),
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    name character varying(255),
    status character varying(25),
    priority character varying(25),
    description text,
    created_by character varying(36),
    resolution character varying(255),
    "release" character varying(255),
    "type" character varying(255),
    fixed_in_release character varying(255),
    work_log text,
    source character varying(255),
    product_category character varying(255)
);


--
-- Name: bugs_audit; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE bugs_audit (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    parent_id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_created timestamp without time zone,
    created_by character varying(36),
    field_name character varying(100),
    data_type character varying(100),
    before_value_string character varying(255),
    after_value_string character varying(255),
    before_value_text text,
    after_value_text text
);


--
-- Name: calls; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE calls (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    assigned_user_id character varying(36),
    modified_user_id character varying(36),
    created_by character varying(36),
    name character varying(50),
    duration_hours character(2),
    duration_minutes character(2),
    date_start date,
    time_start time without time zone,
    date_end date,
    parent_type character varying(25),
    status character varying(25),
    direction character varying(25),
    parent_id character varying(36),
    description text,
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    reminder_time integer DEFAULT (-1),
    outlook_id character varying(255)
);


--
-- Name: calls_contacts; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE calls_contacts (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    call_id character(36),
    contact_id character(36),
    required character(1) DEFAULT '1'::bpchar,
    accept_status character(25) DEFAULT 'none'::bpchar,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: calls_users; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE calls_users (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    call_id character(36),
    user_id character(36),
    required character(1) DEFAULT '1'::bpchar,
    accept_status character(25) DEFAULT 'none'::bpchar,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: campaigns; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE campaigns (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    tracker_key bigint NOT NULL,
    tracker_count bigint DEFAULT (0)::bigint,
    name character varying(50),
    refer_url character varying(255) DEFAULT 'http://'::character varying,
    tracker_text character varying(255),
    date_entered timestamp without time zone,
    date_modified timestamp without time zone,
    modified_user_id character varying(36),
    assigned_user_id character varying(36),
    created_by character varying(36),
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    start_date date,
    end_date date,
    status character varying(25),
    budget double precision,
    expected_cost double precision,
    actual_cost double precision,
    expected_revenue double precision,
    campaign_type character varying(25),
    objective text,
    content text
);


--
-- Name: campaigns_audit; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE campaigns_audit (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    parent_id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_created timestamp without time zone,
    created_by character varying(36),
    field_name character varying(100),
    data_type character varying(100),
    before_value_string character varying(255),
    after_value_string character varying(255),
    before_value_text text,
    after_value_text text
);


--
-- Name: cases; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cases (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    case_number bigint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    assigned_user_id character varying(36),
    created_by character varying(36),
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    name character varying(255),
    account_name character varying(100),
    account_id character varying(36),
    status character varying(25),
    priority character varying(25),
    description text,
    resolution text
);


--
-- Name: cases_audit; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cases_audit (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    parent_id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_created timestamp without time zone,
    created_by character varying(36),
    field_name character varying(100),
    data_type character varying(100),
    before_value_string character varying(255),
    after_value_string character varying(255),
    before_value_text text,
    after_value_text text
);


--
-- Name: cases_bugs; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE cases_bugs (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    case_id character(36),
    bug_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: config; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE config (
    category character varying(32) DEFAULT ''::character varying NOT NULL,
    name character varying(32) DEFAULT ''::character varying NOT NULL,
    value text
);


--
-- Name: contacts; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE contacts (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    assigned_user_id character varying(36),
    created_by character varying(36),
    salutation character varying(5),
    first_name character varying(100),
    last_name character varying(100),
    lead_source character varying(100),
    title character varying(25),
    department character varying(100),
    reports_to_id character varying(36),
    birthdate date,
    do_not_call character(3) DEFAULT '0'::bpchar,
    phone_home character varying(25),
    phone_mobile character varying(25),
    phone_work character varying(25),
    phone_other character varying(25),
    phone_fax character varying(25),
    email1 character varying(100),
    email2 character varying(100),
    assistant character varying(75),
    assistant_phone character varying(25),
    email_opt_out character(3) DEFAULT '0'::bpchar,
    primary_address_street character varying(150),
    primary_address_city character varying(100),
    primary_address_state character varying(100),
    primary_address_postalcode character varying(20),
    primary_address_country character varying(100),
    alt_address_street character varying(150),
    alt_address_city character varying(100),
    alt_address_state character varying(100),
    alt_address_postalcode character varying(20),
    alt_address_country character varying(100),
    description text,
    portal_name character varying(255),
    portal_active smallint DEFAULT (0)::smallint NOT NULL,
    portal_app character varying(255),
    invalid_email smallint DEFAULT (0)::smallint
);


--
-- Name: contacts_audit; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE contacts_audit (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    parent_id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_created timestamp without time zone,
    created_by character varying(36),
    field_name character varying(100),
    data_type character varying(100),
    before_value_string character varying(255),
    after_value_string character varying(255),
    before_value_text text,
    after_value_text text
);


--
-- Name: contacts_bugs; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE contacts_bugs (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    contact_id character(36),
    bug_id character(36),
    contact_role character(50),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: contacts_cases; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE contacts_cases (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    contact_id character(36),
    case_id character(36),
    contact_role character(50),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: contacts_users; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE contacts_users (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    contact_id character(36),
    user_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: currencies; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE currencies (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    name character(36) DEFAULT ''::bpchar NOT NULL,
    symbol character(36) DEFAULT ''::bpchar NOT NULL,
    iso4217 character(3) DEFAULT ''::bpchar NOT NULL,
    conversion_rate double precision DEFAULT (0)::double precision NOT NULL,
    status character(25),
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    created_by character(36) DEFAULT ''::bpchar NOT NULL
);


--
-- Name: custom_fields; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE custom_fields (
    bean_id character(36) DEFAULT ''::bpchar,
    set_num bigint DEFAULT (0)::bigint,
    field0 character(255) DEFAULT ''::bpchar,
    field1 character(255) DEFAULT ''::bpchar,
    field2 character(255) DEFAULT ''::bpchar,
    field3 character(255) DEFAULT ''::bpchar,
    field4 character(255) DEFAULT ''::bpchar,
    field5 character(255) DEFAULT ''::bpchar,
    field6 character(255) DEFAULT ''::bpchar,
    field7 character(255) DEFAULT ''::bpchar,
    field8 character(255) DEFAULT ''::bpchar,
    field9 character(255) DEFAULT ''::bpchar,
    deleted smallint DEFAULT (0)::smallint
);


--
-- Name: document_revisions; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE document_revisions (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    change_log character varying(255),
    document_id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone,
    created_by character varying(36),
    filename character varying(255) DEFAULT ''::character varying NOT NULL,
    file_ext character varying(25),
    file_mime_type character varying(100),
    revision character varying(25),
    deleted smallint DEFAULT (0)::smallint,
    date_modified timestamp without time zone
);


--
-- Name: documents; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE documents (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    document_name character varying(255) DEFAULT ''::character varying NOT NULL,
    active_date date,
    exp_date date,
    description text,
    category_id character varying(25),
    subcategory_id character varying(25),
    status_id character varying(25),
    date_entered timestamp without time zone,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint,
    modified_user_id character varying(36),
    created_by character varying(36),
    document_revision_id character varying(36)
);


--
-- Name: email_marketing; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE email_marketing (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36),
    created_by character varying(36),
    name character varying(255),
    from_addr character varying(100),
    from_name character varying(100),
    date_start date,
    time_start time without time zone,
    template_id character varying(36) DEFAULT ''::character varying NOT NULL,
    campaign_id character varying(36) DEFAULT ''::character varying NOT NULL
);


--
-- Name: email_templates; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE email_templates (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36),
    created_by character varying(36),
    published character(3),
    name character varying(255),
    description text,
    subject character varying(255),
    body text,
    body_html text,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: emailman; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE emailman (
    date_entered timestamp without time zone,
    date_modified timestamp without time zone,
    user_id character varying(36),
    template_id character varying(36),
    from_email character varying(255),
    from_name character varying(255),
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    module_id character varying(36),
    campaign_id character varying(36),
    marketing_id character varying(36),
    list_id character varying(36),
    module character varying(100),
    send_date_time timestamp without time zone,
    modified_user_id character varying(36),
    invalid_email smallint DEFAULT (0)::smallint,
    in_queue smallint DEFAULT (0)::smallint,
    in_queue_date timestamp without time zone,
    send_attempts bigint DEFAULT (0)::bigint,
    deleted smallint DEFAULT (0)::smallint,
    user_name character varying(255),
    campaign_name character varying(50),
    to_contact character varying(255),
    to_prospect character varying(255),
    to_lead character varying(255),
    contact_email character varying(100),
    prospect_email character varying(100),
    lead_email character varying(100)
);


--
-- Name: emailman_sent; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE emailman_sent (
    date_entered timestamp without time zone,
    date_modified timestamp without time zone,
    user_id character varying(36),
    template_id character varying(36),
    from_email character varying(255),
    from_name character varying(255),
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    module_id character varying(36),
    campaign_id character varying(36),
    marketing_id character varying(36),
    list_id character varying(36),
    module character varying(100),
    send_date_time timestamp without time zone,
    modified_user_id character varying(36),
    invalid_email smallint DEFAULT (0)::smallint,
    in_queue smallint DEFAULT (0)::smallint,
    in_queue_date timestamp without time zone,
    send_attempts bigint DEFAULT (0)::bigint,
    deleted smallint DEFAULT (0)::smallint,
    user_name character varying(255),
    campaign_name character varying(50),
    to_contact character varying(255),
    to_prospect character varying(255),
    to_lead character varying(255),
    contact_email character varying(100),
    prospect_email character varying(100),
    lead_email character varying(100)
);


--
-- Name: emails; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE emails (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    assigned_user_id character varying(36),
    modified_user_id character varying(36),
    created_by character varying(36),
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    date_start date,
    time_start time without time zone,
    parent_type character varying(25),
    parent_id character varying(36),
    description text,
    description_html text,
    from_addr character varying(100),
    from_name character varying(100),
    to_addrs text,
    cc_addrs text,
    bcc_addrs text,
    to_addrs_ids text,
    to_addrs_names text,
    to_addrs_emails text,
    cc_addrs_ids text,
    cc_addrs_names text,
    cc_addrs_emails text,
    bcc_addrs_ids text,
    bcc_addrs_names text,
    bcc_addrs_emails text,
    "type" character varying(25),
    status character varying(25),
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: emails_accounts; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE emails_accounts (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    email_id character(36),
    account_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: emails_cases; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE emails_cases (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    email_id character(36),
    case_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: emails_contacts; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE emails_contacts (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    email_id character(36),
    contact_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: emails_opportunities; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE emails_opportunities (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    email_id character(36),
    opportunity_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: emails_users; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE emails_users (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    email_id character(36),
    user_id character(36),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: feeds; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE feeds (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    assigned_user_id character varying(36),
    created_by character varying(36),
    title character varying(100),
    description text,
    url character varying(255)
);


--
-- Name: fields_meta_data; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE fields_meta_data (
    id character varying(255) DEFAULT ''::character varying NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    label character varying(255) DEFAULT ''::character varying NOT NULL,
    custom_module character varying(255) DEFAULT ''::character varying,
    data_type character varying(255) DEFAULT ''::character varying NOT NULL,
    max_size bigint DEFAULT (0)::bigint,
    required_option character varying(255) DEFAULT ''::character varying,
    default_value character varying(255) DEFAULT ''::character varying,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint,
    audited smallint DEFAULT (0)::smallint,
    ext1 character varying(255) DEFAULT '0'::character varying,
    ext2 character varying(255) DEFAULT '0'::character varying,
    ext3 character varying(255) DEFAULT '0'::character varying
);


--
-- Name: files; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE files (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    name character varying(36),
    content bytea,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    assigned_user_id character varying(36)
);


--
-- Name: iframes; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE iframes (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    name character(255) DEFAULT ''::bpchar NOT NULL,
    url character(255) DEFAULT ''::bpchar NOT NULL,
    "type" character(255) DEFAULT ''::bpchar NOT NULL,
    placement character(255) DEFAULT ''::bpchar NOT NULL,
    status smallint DEFAULT (0)::smallint NOT NULL,
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    created_by character(36) DEFAULT ''::bpchar NOT NULL
);


--
-- Name: import_maps; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE import_maps (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    name character varying(36) DEFAULT ''::character varying NOT NULL,
    source character varying(36) DEFAULT ''::character varying NOT NULL,
    module character varying(36) DEFAULT ''::character varying NOT NULL,
    content bytea,
    has_header smallint DEFAULT (1)::smallint NOT NULL,
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    assigned_user_id character varying(36),
    is_published character(3) DEFAULT 'no'::bpchar NOT NULL
);


--
-- Name: leads; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE leads (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    converted smallint DEFAULT (0)::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    assigned_user_id character varying(36),
    created_by character varying(36),
    salutation character varying(5),
    first_name character varying(25),
    last_name character varying(25),
    title character varying(100),
    refered_by character varying(100),
    lead_source character varying(100),
    lead_source_description text,
    status character varying(100),
    status_description text,
    department character varying(100),
    reports_to_id character varying(36),
    do_not_call character(3) DEFAULT '0'::bpchar,
    phone_home character varying(25),
    phone_mobile character varying(25),
    phone_work character varying(25),
    phone_other character varying(25),
    phone_fax character varying(25),
    email1 character varying(100),
    email2 character varying(100),
    email_opt_out character(3) DEFAULT '0'::bpchar,
    primary_address_street character varying(150),
    primary_address_city character varying(100),
    primary_address_state character varying(100),
    primary_address_postalcode character varying(20),
    primary_address_country character varying(100),
    alt_address_street character varying(150),
    alt_address_city character varying(100),
    alt_address_state character varying(100),
    alt_address_postalcode character varying(20),
    alt_address_country character varying(100),
    description text,
    account_name character varying(150),
    account_description text,
    contact_id character varying(36),
    account_id character varying(36),
    opportunity_id character varying(36),
    opportunity_name character varying(255),
    opportunity_amount character varying(50),
    portal_name character varying(255),
    portal_app character varying(255),
    invalid_email smallint DEFAULT (0)::smallint
);


--
-- Name: leads_audit; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE leads_audit (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    parent_id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_created timestamp without time zone,
    created_by character varying(36),
    field_name character varying(100),
    data_type character varying(100),
    before_value_string character varying(255),
    after_value_string character varying(255),
    before_value_text text,
    after_value_text text
);


--
-- Name: meetings; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE meetings (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    assigned_user_id character varying(36),
    modified_user_id character varying(36),
    created_by character varying(36),
    name character varying(50),
    "location" character varying(50),
    duration_hours character(2),
    duration_minutes character(2),
    date_start date,
    time_start time without time zone,
    date_end date,
    parent_type character varying(25),
    status character varying(25),
    parent_id character varying(36),
    description text,
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    reminder_time bigint DEFAULT (- (1)::bigint),
    outlook_id character varying(255)
);


--
-- Name: meetings_contacts; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE meetings_contacts (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    meeting_id character(36),
    contact_id character(36),
    required character(1) DEFAULT '1'::bpchar,
    accept_status character(25) DEFAULT 'none'::bpchar,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: meetings_users; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE meetings_users (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    meeting_id character(36),
    user_id character(36),
    required character(1) DEFAULT '1'::bpchar,
    accept_status character(25) DEFAULT 'none'::bpchar,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: mond_customer; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE mond_customer (
    customer_id bigint,
    account_num bigint,
    lname character varying(30),
    fname character varying(30),
    mi character varying(30),
    address1 character varying(30),
    address2 character varying(30),
    address3 character varying(30),
    address4 character varying(30),
    city character varying(30),
    state_province character varying(30),
    postal_code character varying(30),
    country character varying(30),
    customer_region_id bigint,
    phone1 character varying(30),
    phone2 character varying(30),
    birthdate date,
    marital_status character varying(30),
    yearly_income character varying(30),
    gender character varying(30),
    total_children bigint,
    num_children_at_home bigint,
    education character varying(30),
    date_accnt_opened date,
    member_card character varying(30),
    occupation character varying(30),
    houseowner character varying(30),
    num_cars_owned bigint
);


--
-- Name: notes; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE notes (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36),
    created_by character varying(36),
    name character varying(255),
    filename character varying(255),
    file_mime_type character varying(100),
    parent_type character varying(25),
    parent_id character varying(36),
    contact_id character varying(36),
    portal_flag smallint DEFAULT (0)::smallint NOT NULL,
    description text,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: opportunities; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE opportunities (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    assigned_user_id character varying(36),
    created_by character varying(36),
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    name character varying(50),
    opportunity_type character varying(255),
    lead_source character varying(50),
    amount double precision,
    amount_backup character varying(25),
    amount_usdollar double precision,
    currency_id character varying(36),
    date_closed date,
    next_step character varying(100),
    sales_stage character varying(25),
    probability double precision,
    description text
);


--
-- Name: opportunities_audit; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE opportunities_audit (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    parent_id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_created timestamp without time zone,
    created_by character varying(36),
    field_name character varying(100),
    data_type character varying(100),
    before_value_string character varying(255),
    after_value_string character varying(255),
    before_value_text text,
    after_value_text text
);


--
-- Name: opportunities_contacts; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE opportunities_contacts (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    contact_id character(36),
    opportunity_id character(36),
    contact_role character(50),
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: orders; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE orders (
    orderid integer,
    customerid character varying(5),
    employeeid integer,
    orderdate timestamp without time zone,
    requireddate timestamp without time zone,
    shippeddate timestamp without time zone,
    shipvia integer,
    freight numeric,
    shipname character varying(255),
    shipaddress character varying(255),
    shipcity character varying(100),
    shipregion character varying(100),
    shippostalcode character varying(20),
    shipcountry character varying(100)
);


--
-- Name: project; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE project (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    assigned_user_id character varying(36),
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    created_by character varying(36),
    name character varying(50) DEFAULT ''::character varying NOT NULL,
    description text,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: project_relation; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE project_relation (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    project_id character varying(36) DEFAULT ''::character varying NOT NULL,
    relation_id character varying(36) DEFAULT ''::character varying NOT NULL,
    relation_type character varying(255) DEFAULT ''::character varying NOT NULL,
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL
);


--
-- Name: project_task; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE project_task (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    assigned_user_id character varying(36),
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    created_by character varying(36),
    name character varying(50) DEFAULT ''::character varying NOT NULL,
    status character varying(255),
    date_due date,
    time_due time without time zone,
    date_start date,
    time_start time without time zone,
    parent_id character varying(36) DEFAULT ''::character varying NOT NULL,
    priority character varying(255),
    description text,
    order_number bigint DEFAULT (1)::bigint,
    task_number bigint,
    depends_on_id character varying(36),
    milestone_flag character varying(255),
    estimated_effort bigint,
    actual_effort bigint,
    utilization bigint DEFAULT (100)::bigint,
    percent_complete bigint DEFAULT (0)::bigint,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: project_task_audit; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE project_task_audit (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    parent_id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_created timestamp without time zone,
    created_by character varying(36),
    field_name character varying(100),
    data_type character varying(100),
    before_value_string character varying(255),
    after_value_string character varying(255),
    before_value_text text,
    after_value_text text
);


--
-- Name: prospect_list_campaigns; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE prospect_list_campaigns (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    prospect_list_id character(36) DEFAULT ''::bpchar,
    campaign_id character(36) DEFAULT ''::bpchar,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint
);


--
-- Name: prospect_lists; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE prospect_lists (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    name character varying(50),
    date_entered timestamp without time zone,
    date_modified timestamp without time zone,
    modified_user_id character varying(36),
    assigned_user_id character varying(36),
    created_by character varying(36),
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    description text
);


--
-- Name: prospect_lists_prospects; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE prospect_lists_prospects (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    prospect_list_id character(36) DEFAULT ''::bpchar,
    prospect_id character(36) DEFAULT ''::bpchar,
    contact_id character(36) DEFAULT ''::bpchar,
    lead_id character(36) DEFAULT ''::bpchar,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint
);


--
-- Name: prospects; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE prospects (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    tracker_key bigint NOT NULL,
    deleted smallint DEFAULT (0)::smallint,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    assigned_user_id character varying(36),
    created_by character varying(36),
    salutation character varying(5),
    first_name character varying(100),
    last_name character varying(100),
    title character varying(25),
    department character varying(255),
    birthdate date,
    do_not_call character(3) DEFAULT '0'::bpchar,
    phone_home character varying(25),
    phone_mobile character varying(25),
    phone_work character varying(25),
    phone_other character varying(25),
    phone_fax character varying(25),
    email1 character varying(100),
    email2 character varying(100),
    assistant character varying(75),
    assistant_phone character varying(25),
    email_opt_out character(3) DEFAULT '0'::bpchar,
    primary_address_street character varying(150),
    primary_address_city character varying(100),
    primary_address_state character varying(100),
    primary_address_postalcode character varying(20),
    primary_address_country character varying(100),
    alt_address_street character varying(150),
    alt_address_city character varying(100),
    alt_address_state character varying(100),
    alt_address_postalcode character varying(20),
    alt_address_country character varying(100),
    description text,
    invalid_email smallint DEFAULT (0)::smallint
);


--
-- Name: relationships; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE relationships (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    relationship_name character varying(150) DEFAULT ''::character varying NOT NULL,
    lhs_module character varying(100) DEFAULT ''::character varying NOT NULL,
    lhs_table character varying(64) DEFAULT ''::character varying NOT NULL,
    lhs_key character varying(64) DEFAULT ''::character varying NOT NULL,
    rhs_module character varying(100) DEFAULT ''::character varying NOT NULL,
    rhs_table character varying(64) DEFAULT ''::character varying NOT NULL,
    rhs_key character varying(64) DEFAULT ''::character varying NOT NULL,
    join_table character varying(64),
    join_key_lhs character varying(64),
    join_key_rhs character varying(64),
    relationship_type character varying(64),
    relationship_role_column character varying(64),
    relationship_role_column_value character varying(15),
    reverse smallint DEFAULT (0)::smallint,
    deleted smallint DEFAULT (0)::smallint
);


--
-- Name: releases; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE releases (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    created_by character varying(36),
    name character varying(50) DEFAULT ''::character varying NOT NULL,
    list_order integer,
    status character varying(25)
);


--
-- Name: roles; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE roles (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    created_by character varying(36),
    name character varying(150),
    description text,
    modules text,
    deleted smallint DEFAULT (0)::smallint
);


--
-- Name: roles_modules; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE roles_modules (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    role_id character(36) DEFAULT ''::bpchar,
    module_id character(36) DEFAULT ''::bpchar,
    allow smallint DEFAULT (0)::smallint,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint
);


--
-- Name: roles_users; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE roles_users (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    role_id character(36) DEFAULT ''::bpchar,
    user_id character(36) DEFAULT ''::bpchar,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint
);


--
-- Name: sales_account; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE sales_account (
    id bigint NOT NULL,
    account_name character varying(150),
    account_type character varying(25),
    industry character varying(25)
);


--
-- Name: sales_date_of_close; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE sales_date_of_close (
    id bigint NOT NULL,
    close_year smallint,
    close_quarter_in_year smallint,
    close_quarter_name character varying(5),
    close_month smallint,
    close_month_name character varying(10),
    close_week_in_year bigint,
    close_week_in_month bigint
);


--
-- Name: sales_date_of_start; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE sales_date_of_start (
    id bigint NOT NULL,
    start_year smallint,
    start_quarter_in_year smallint,
    start_quarter_name character varying(5),
    start_month smallint,
    start_month_name character varying(10),
    start_week_in_year smallint,
    start_week_in_month smallint
);


--
-- Name: sales_fact; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE sales_fact (
    id bigint NOT NULL,
    sales_date_of_close_id bigint,
    sales_date_of_start_id bigint,
    sales_person_id bigint,
    sales_account_id bigint,
    sales_location_id bigint,
    sales_state_id bigint,
    amount bigint,
    time_to_close bigint,
    probability bigint
);


--
-- Name: sales_location; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE sales_location (
    id bigint NOT NULL,
    zipcode character varying(20),
    city character varying(100),
    state character varying(100),
    country character varying(100)
);


--
-- Name: sales_person; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE sales_person (
    id bigint NOT NULL,
    first_name character varying(30),
    last_name character varying(30),
    full_name character varying(60),
    manager_id bigint
);


--
-- Name: sales_state; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE sales_state (
    id bigint NOT NULL,
    sales_state character varying(25)
);


--
-- Name: tasks; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE tasks (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    assigned_user_id character varying(36),
    modified_user_id character varying(36),
    created_by character varying(36),
    name character varying(50),
    status character varying(25),
    date_due_flag character varying(5) DEFAULT 'on'::character varying,
    date_due date,
    time_due time without time zone,
    date_start_flag character varying(5) DEFAULT 'on'::character varying,
    date_start date,
    time_start time without time zone,
    parent_type character varying(25),
    parent_id character varying(36),
    contact_id character varying(36),
    priority character varying(25),
    description text,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: tracker; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE tracker (
    id bigint NOT NULL,
    user_id character(36),
    module_name character(25),
    item_id character(36),
    item_summary character(255),
    date_modified timestamp without time zone
);


--
-- Name: upgrade_history; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE upgrade_history (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    filename character varying(255) DEFAULT ''::character varying NOT NULL,
    md5sum character varying(32) DEFAULT ''::character varying NOT NULL,
    "type" character varying(30) DEFAULT ''::character varying NOT NULL,
    status character varying(50) DEFAULT ''::character varying NOT NULL,
    version character varying(10) DEFAULT ''::character varying NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL
);


--
-- Name: users; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE users (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    user_name character varying(20),
    user_password character varying(30),
    user_hash character varying(32),
    first_name character varying(30),
    last_name character varying(30),
    reports_to_id character varying(36),
    is_admin character(3) DEFAULT '0'::bpchar,
    receive_notifications character(1) DEFAULT '1'::bpchar,
    description text,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character varying(36),
    created_by character varying(36),
    title character varying(50),
    department character varying(50),
    phone_home character varying(50),
    phone_mobile character varying(50),
    phone_work character varying(50),
    phone_other character varying(50),
    phone_fax character varying(50),
    email1 character varying(100),
    email2 character varying(100),
    status character varying(25),
    address_street character varying(150),
    address_city character varying(100),
    address_state character varying(100),
    address_country character varying(25),
    address_postalcode character varying(9),
    user_preferences text,
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    portal_only smallint DEFAULT (0)::smallint,
    employee_status character varying(25),
    messenger_id character varying(25),
    messenger_type character varying(25)
);


--
-- Name: users_feeds; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE users_feeds (
    user_id character(36) DEFAULT ''::bpchar NOT NULL,
    feed_id character(36) DEFAULT ''::bpchar NOT NULL,
    rank bigint DEFAULT (0)::bigint NOT NULL,
    date_modified timestamp without time zone,
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: users_last_import; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE users_last_import (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    assigned_user_id character(36),
    bean_type character(36),
    bean_id character(36),
    deleted smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: vcals; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE vcals (
    id character varying(36) DEFAULT ''::character varying NOT NULL,
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    date_entered timestamp without time zone,
    date_modified timestamp without time zone,
    user_id character varying(36) DEFAULT ''::character varying NOT NULL,
    "type" character varying(25),
    source character varying(25),
    content text
);


--
-- Name: versions; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE versions (
    id character(36) DEFAULT ''::bpchar NOT NULL,
    deleted smallint DEFAULT (0)::smallint NOT NULL,
    date_entered timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    date_modified timestamp without time zone DEFAULT '1970-01-01 00:00:00'::timestamp without time zone NOT NULL,
    modified_user_id character(36) DEFAULT ''::bpchar NOT NULL,
    created_by character(36),
    name character(255) DEFAULT ''::bpchar NOT NULL,
    file_version character(255) DEFAULT ''::bpchar NOT NULL,
    db_version character(255) DEFAULT ''::bpchar NOT NULL
);


--
-- Name: bugs_bug_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE bugs_bug_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: bugs_bug_number_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE bugs_bug_number_seq OWNED BY bugs.bug_number;


--
-- Name: bugs_bug_number_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('bugs_bug_number_seq', 1, false);


--
-- Name: campaigns_tracker_key_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE campaigns_tracker_key_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: campaigns_tracker_key_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE campaigns_tracker_key_seq OWNED BY campaigns.tracker_key;


--
-- Name: campaigns_tracker_key_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('campaigns_tracker_key_seq', 1, false);


--
-- Name: cases_case_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cases_case_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: cases_case_number_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE cases_case_number_seq OWNED BY cases.case_number;


--
-- Name: cases_case_number_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cases_case_number_seq', 1, false);


--
-- Name: prospects_tracker_key_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE prospects_tracker_key_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: prospects_tracker_key_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE prospects_tracker_key_seq OWNED BY prospects.tracker_key;


--
-- Name: prospects_tracker_key_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('prospects_tracker_key_seq', 1, false);


--
-- Name: sales_account_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE sales_account_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: sales_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE sales_account_id_seq OWNED BY sales_account.id;


--
-- Name: sales_account_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('sales_account_id_seq', 1, false);


--
-- Name: sales_date_of_close_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE sales_date_of_close_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: sales_date_of_close_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE sales_date_of_close_id_seq OWNED BY sales_date_of_close.id;


--
-- Name: sales_date_of_close_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('sales_date_of_close_id_seq', 1, false);


--
-- Name: sales_date_of_start_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE sales_date_of_start_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: sales_date_of_start_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE sales_date_of_start_id_seq OWNED BY sales_date_of_start.id;


--
-- Name: sales_date_of_start_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('sales_date_of_start_id_seq', 1, false);


--
-- Name: sales_fact_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE sales_fact_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: sales_fact_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE sales_fact_id_seq OWNED BY sales_fact.id;


--
-- Name: sales_fact_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('sales_fact_id_seq', 1, false);


--
-- Name: sales_location_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE sales_location_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: sales_location_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE sales_location_id_seq OWNED BY sales_location.id;


--
-- Name: sales_location_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('sales_location_id_seq', 1, false);


--
-- Name: sales_person_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE sales_person_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: sales_person_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE sales_person_id_seq OWNED BY sales_person.id;


--
-- Name: sales_person_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('sales_person_id_seq', 1, false);


--
-- Name: sales_state_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE sales_state_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: sales_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE sales_state_id_seq OWNED BY sales_state.id;


--
-- Name: sales_state_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('sales_state_id_seq', 1, false);


--
-- Name: tracker_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tracker_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: tracker_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tracker_id_seq OWNED BY tracker.id;


--
-- Name: tracker_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tracker_id_seq', 1, false);


--
-- Name: bug_number; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE bugs ALTER COLUMN bug_number SET DEFAULT nextval('bugs_bug_number_seq'::regclass);


--
-- Name: tracker_key; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE campaigns ALTER COLUMN tracker_key SET DEFAULT nextval('campaigns_tracker_key_seq'::regclass);


--
-- Name: case_number; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE cases ALTER COLUMN case_number SET DEFAULT nextval('cases_case_number_seq'::regclass);


--
-- Name: tracker_key; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE prospects ALTER COLUMN tracker_key SET DEFAULT nextval('prospects_tracker_key_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE sales_account ALTER COLUMN id SET DEFAULT nextval('sales_account_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE sales_date_of_close ALTER COLUMN id SET DEFAULT nextval('sales_date_of_close_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE sales_date_of_start ALTER COLUMN id SET DEFAULT nextval('sales_date_of_start_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE sales_fact ALTER COLUMN id SET DEFAULT nextval('sales_fact_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE sales_location ALTER COLUMN id SET DEFAULT nextval('sales_location_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE sales_person ALTER COLUMN id SET DEFAULT nextval('sales_person_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE sales_state ALTER COLUMN id SET DEFAULT nextval('sales_state_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE tracker ALTER COLUMN id SET DEFAULT nextval('tracker_id_seq'::regclass);


--
-- Data for Name: accounts; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO accounts VALUES ('a69dae1f-b2ee-1257-3895-438dfb8ea964', '2005-11-30 19:19:03', '2005-11-30 19:19:03', '1', 'beth_id', '1', 'Alpha-Murraiin Communications, Inc', NULL, 'Manufacturing', 'Communications', NULL, NULL, '5423 Camby Rd.', 'La Mesa', 'CA', '35890', 'USA', NULL, NULL, '612-555-4878', NULL, NULL, NULL, 'www.alpha-murraiincommunications,inc.com', NULL, NULL, NULL, NULL, '5423 Camby Rd.', 'La Mesa', 'CA', '35890', 'USA', 0);
INSERT INTO accounts VALUES ('e908e57d-18d3-5ffa-f6f4-438dfb104441', '2005-11-30 19:19:03', '2005-11-30 19:19:03', '1', 'sarah_id', '1', 'N & W Creek Transportation Corp', NULL, 'Distribution', 'Transportation', NULL, NULL, '1792 Belmont Rd.', 'Chula Vista', 'CA', '40520', 'USA', NULL, NULL, '555-555-2714', NULL, NULL, NULL, 'www.nwcreektransportationcorp.com', NULL, NULL, NULL, NULL, '1792 Belmont Rd.', 'Chula Vista', 'CA', '40520', 'USA', 0);
INSERT INTO accounts VALUES ('18ae2ab5-0bfd-980d-2519-438dfbda705b', '2005-11-30 19:19:04', '2005-11-30 19:19:04', '1', 'matt_id', '1', 'Creek-Medina Engineering Partners', NULL, 'Supply', 'Engineering', NULL, NULL, '3796 Keller Ridge', 'Mexico City', 'Mexico', '59554', 'Mexico', NULL, NULL, '343-555-9778', NULL, NULL, NULL, 'www.creek-medinaengineeringpartners.com', NULL, NULL, NULL, NULL, '3796 Keller Ridge', 'Mexico City', 'Mexico', '59554', 'Mexico', 0);
INSERT INTO accounts VALUES ('419aa1b7-1392-c018-5c08-438dfb43dd59', '2005-11-30 19:19:04', '2005-11-30 19:19:04', '1', 'sarah_id', '1', 'O & D Rutledge Communications Associates', NULL, 'Distribution', 'Communications', NULL, NULL, '3074 Ardith Drive', 'Lincoln Acres', 'CA', '30346', 'USA', NULL, NULL, '659-555-3160', NULL, NULL, NULL, 'www.odrutledgecommunicationsassociates.com', NULL, NULL, NULL, NULL, '3074 Ardith Drive', 'Lincoln Acres', 'CA', '30346', 'USA', 0);
INSERT INTO accounts VALUES ('67c3c020-4ffe-b315-284a-438dfb4cd6d8', '2005-11-30 19:19:04', '2005-11-30 19:19:04', '1', 'sally_id', '1', 'Rutledge-Cavestany Transportation Company', NULL, 'Consulting', 'Transportation', NULL, NULL, '7987 Seawind Dr.', 'Oak Bay', 'BC', '15542', 'Canada', NULL, NULL, '471-555-8853', NULL, NULL, NULL, 'www.rutledge-cavestanytransportationcompany.com', NULL, NULL, NULL, NULL, '7987 Seawind Dr.', 'Oak Bay', 'BC', '15542', 'Canada', 0);
INSERT INTO accounts VALUES ('8f2b0a70-46e7-f25a-7dcc-438dfbc8112e', '2005-11-30 19:19:04', '2005-11-30 19:19:04', '1', 'sally_id', '1', 'M & Y Planck Communications, Ltd', NULL, 'Supply', 'Communications', NULL, NULL, '4864 San Carlos', 'Camacho', 'Zacatecas', '77787', 'Mexico', NULL, NULL, '698-555-7603', NULL, NULL, NULL, 'www.myplanckcommunications,ltd.com', NULL, NULL, NULL, NULL, '4864 San Carlos', 'Camacho', 'Zacatecas', '77787', 'Mexico', 0);
INSERT INTO accounts VALUES ('b560e2dc-22bd-6582-bc09-438dfb8ffc59', '2005-11-30 19:19:04', '2005-11-30 19:19:04', '1', 'beth_id', '1', 'Planck-Marshall Communications Associates', NULL, 'Consulting', 'Communications', NULL, NULL, '2687 Ridge Road', 'Arcadia', 'CA', '28530', 'USA', NULL, NULL, '771-555-6581', NULL, NULL, NULL, 'www.planck-marshallcommunicationsassociates.com', NULL, NULL, NULL, NULL, '2687 Ridge Road', 'Arcadia', 'CA', '28530', 'USA', 0);
INSERT INTO accounts VALUES ('dc2a7c81-a009-cace-2d18-438dfbabf3d5', '2005-11-30 19:19:04', '2005-11-30 19:19:04', '1', 'max_id', '1', 'B & D Wolter Machinery Partners', NULL, 'Consulting', 'Machinery', NULL, NULL, '2473 Orchard Way', 'Altadena', 'CA', '49680', 'USA', NULL, NULL, '121-555-3960', NULL, NULL, NULL, 'www.bdwoltermachinerypartners.com', NULL, NULL, NULL, NULL, '2473 Orchard Way', 'Altadena', 'CA', '49680', 'USA', 0);
INSERT INTO accounts VALUES ('e2060a5d-c072-69b9-fea6-438dfb520511', '2005-11-30 19:19:05', '2005-11-30 19:19:05', '1', 'sarah_id', '1', 'Wolter-Collins Construction Partners', NULL, 'Manufacturing', 'Construction', NULL, NULL, '551 Rainier Dr', 'Oakland', 'CA', '21486', 'USA', NULL, NULL, '217-555-1567', NULL, NULL, NULL, 'www.wolter-collinsconstructionpartners.com', NULL, NULL, NULL, NULL, '551 Rainier Dr', 'Oakland', 'CA', '21486', 'USA', 0);
INSERT INTO accounts VALUES ('33919037-63ff-98f9-4447-438dfb5acbdb', '2005-11-30 19:19:05', '2005-11-30 19:19:05', '1', 'kristen_id', '1', 'H & E Baker Machinery Group', NULL, 'Supply', 'Machinery', NULL, NULL, '591 Merriewood Drive', 'Spring Valley', 'CA', '88762', 'USA', NULL, NULL, '617-555-7972', NULL, NULL, NULL, 'www.hebakermachinerygroup.com', NULL, NULL, NULL, NULL, '591 Merriewood Drive', 'Spring Valley', 'CA', '88762', 'USA', 0);
INSERT INTO accounts VALUES ('60413755-db82-584c-101d-438dfb6380b1', '2005-11-30 19:19:05', '2005-11-30 19:19:05', '1', 'beth_id', '1', 'Baker-Castillo Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '1579 Plaza Rosa', 'Renton', 'WA', '71442', 'USA', NULL, NULL, '975-555-7865', NULL, NULL, NULL, 'www.baker-castilloelectronicsholdings.com', NULL, NULL, NULL, NULL, '1579 Plaza Rosa', 'Renton', 'WA', '71442', 'USA', 0);
INSERT INTO accounts VALUES ('8c9f383e-c1b7-70f8-3208-438dfbc39940', '2005-11-30 19:19:05', '2005-11-30 19:19:05', '1', 'max_id', '1', 'X & M Borges Construction Corp', NULL, 'Manufacturing', 'Construction', NULL, NULL, '1873 Lyon Circle', 'Bellingham', 'WA', '78588', 'USA', NULL, NULL, '610-555-6158', NULL, NULL, NULL, 'www.xmborgesconstructioncorp.com', NULL, NULL, NULL, NULL, '1873 Lyon Circle', 'Bellingham', 'WA', '78588', 'USA', 0);
INSERT INTO accounts VALUES ('b6bcb002-7146-374e-0f62-438dfb1ecc89', '2005-11-30 19:19:05', '2005-11-30 19:19:05', '1', 'sally_id', '1', 'Borges-Wyro Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '3114 Notre Dame Ave.', 'La Jolla', 'CA', '27430', 'USA', NULL, NULL, '444-555-1517', NULL, NULL, NULL, 'www.borges-wyrotelecommunications,ltd.com', NULL, NULL, NULL, NULL, '3114 Notre Dame Ave.', 'La Jolla', 'CA', '27430', 'USA', 0);
INSERT INTO accounts VALUES ('de8788ae-186e-8976-b01a-438dfb2b8a05', '2005-11-30 19:19:05', '2005-11-30 19:19:05', '1', 'chris_id', '1', 'I & M Wyllie Transportation, Ltd', NULL, 'Supply', 'Transportation', NULL, NULL, '6318 Marclair Dr.', 'Santa Fe', 'DF', '99737', 'Mexico', NULL, NULL, '102-555-7439', NULL, NULL, NULL, 'www.imwyllietransportation,ltd.com', NULL, NULL, NULL, NULL, '6318 Marclair Dr.', 'Santa Fe', 'DF', '99737', 'Mexico', 0);
INSERT INTO accounts VALUES ('fab50378-1552-a629-0700-438dfb1e3c07', '2005-11-30 19:19:06', '2005-11-30 19:19:06', '1', 'will_id', '1', 'Wyllie-Conley Electronics Corp', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '7814 Milburn Dr.', 'Haney', 'BC', '65710', 'Canada', NULL, NULL, '506-555-4589', NULL, NULL, NULL, 'www.wyllie-conleyelectronicscorp.com', NULL, NULL, NULL, NULL, '7814 Milburn Dr.', 'Haney', 'BC', '65710', 'Canada', 0);
INSERT INTO accounts VALUES ('382799fa-9f4d-a2a0-f436-438dfb2ab9e1', '2005-11-30 19:19:06', '2005-11-30 19:19:06', '1', 'kristen_id', '1', 'H & Y Bernard Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '3928 San Francisco', 'Burbank', 'CA', '51809', 'USA', NULL, NULL, '425-555-3796', NULL, NULL, NULL, 'www.hybernardengineering,inc.com', NULL, NULL, NULL, NULL, '3928 San Francisco', 'Burbank', 'CA', '51809', 'USA', 0);
INSERT INTO accounts VALUES ('611c2870-5b76-3473-fa0e-438dfb4778a4', '2005-11-30 19:19:06', '2005-11-30 19:19:06', '1', 'jaime_id', '1', 'Bernard-Macaluso Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '5678 McElroy Court', 'Anacortes', 'WA', '58052', 'USA', NULL, NULL, '852-555-8574', NULL, NULL, NULL, 'www.bernard-macalusotelecommunications,ltd.com', NULL, NULL, NULL, NULL, '5678 McElroy Court', 'Anacortes', 'WA', '58052', 'USA', 0);
INSERT INTO accounts VALUES ('87f2d1aa-1a8f-51ed-b562-438dfbf8e1f7', '2005-11-30 19:19:06', '2005-11-30 19:19:06', '1', 'sally_id', '1', 'D & A Wood Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '2046 Las Palmas', 'Everett', 'WA', '88974', 'USA', NULL, NULL, '794-555-6410', NULL, NULL, NULL, 'www.dawoodmachinerygroup.com', NULL, NULL, NULL, NULL, '2046 Las Palmas', 'Everett', 'WA', '88974', 'USA', 0);
INSERT INTO accounts VALUES ('aed2dd85-41f1-3abb-02f3-438dfbd64a1b', '2005-11-30 19:19:06', '2005-11-30 19:19:06', '1', 'max_id', '1', 'Wood-Armstrong Construction Associates', NULL, 'Consulting', 'Construction', NULL, NULL, '608 Lincoln Dr.', 'Oak Bay', 'BC', '90098', 'Canada', NULL, NULL, '583-555-4474', NULL, NULL, NULL, 'www.wood-armstrongconstructionassociates.com', NULL, NULL, NULL, NULL, '608 Lincoln Dr.', 'Oak Bay', 'BC', '90098', 'Canada', 0);
INSERT INTO accounts VALUES ('d5b953e2-7668-721f-21cc-438dfbf0b385', '2005-11-30 19:19:06', '2005-11-30 19:19:06', '1', 'max_id', '1', 'D & Z Goldey Electronics, Ltd', NULL, 'Consulting', 'Electronics', NULL, NULL, '7230 Berrellesa Street', 'Milwaukie', 'OR', '78800', 'USA', NULL, NULL, '548-555-9939', NULL, NULL, NULL, 'www.dzgoldeyelectronics,ltd.com', NULL, NULL, NULL, NULL, '7230 Berrellesa Street', 'Milwaukie', 'OR', '78800', 'USA', 0);
INSERT INTO accounts VALUES ('c08208ee-c631-2468-f4ef-438dfbb1f92c', '2005-11-30 19:19:07', '2005-11-30 19:19:07', '1', 'kristen_id', '1', 'Goldey-Nickell Engineering Corp', NULL, 'Consulting', 'Engineering', NULL, NULL, '2144 San Rafael', 'Concord', 'CA', '63996', 'USA', NULL, NULL, '598-555-1289', NULL, NULL, NULL, 'www.goldey-nickellengineeringcorp.com', NULL, NULL, NULL, NULL, '2144 San Rafael', 'Concord', 'CA', '63996', 'USA', 0);
INSERT INTO accounts VALUES ('3624c5a8-5dcf-8f66-f9a1-438dfb26f2da', '2005-11-30 19:19:07', '2005-11-30 19:19:07', '1', 'will_id', '1', 'Q & Q Long Telecommunications Associates', NULL, 'Supply', 'Telecommunications', NULL, NULL, '1676 Greer Ave.', 'Ladner', 'BC', '99949', 'Canada', NULL, NULL, '937-555-2299', NULL, NULL, NULL, 'www.qqlongtelecommunicationsassociates.com', NULL, NULL, NULL, NULL, '1676 Greer Ave.', 'Ladner', 'BC', '99949', 'Canada', 0);
INSERT INTO accounts VALUES ('5fd3e853-98f8-6dbf-208c-438dfb9d5c69', '2005-11-30 19:19:07', '2005-11-30 19:19:07', '1', 'max_id', '1', 'Long-Solimena Engineering Company', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '6843 San Simeon Dr.', 'Santa Cruz', 'CA', '51307', 'USA', NULL, NULL, '111-555-1278', NULL, NULL, NULL, 'www.long-solimenaengineeringcompany.com', NULL, NULL, NULL, NULL, '6843 San Simeon Dr.', 'Santa Cruz', 'CA', '51307', 'USA', 0);
INSERT INTO accounts VALUES ('8e54f9ad-8ffe-e5ca-b871-438dfb253fb7', '2005-11-30 19:19:07', '2005-11-30 19:19:07', '1', 'matt_id', '1', 'Y & R Muenich Machinery, Inc', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '6629 Polson Circle', 'La Mesa', 'CA', '53422', 'USA', NULL, NULL, '361-555-7656', NULL, NULL, NULL, 'www.yrmuenichmachinery,inc.com', NULL, NULL, NULL, NULL, '6629 Polson Circle', 'La Mesa', 'CA', '53422', 'USA', 0);
INSERT INTO accounts VALUES ('b97ff471-9ee3-0e12-2dd9-438dfb9b36e0', '2005-11-30 19:19:07', '2005-11-30 19:19:07', '1', 'sarah_id', '1', 'Muenich-Young Engineering, Inc', NULL, 'Manufacturing', 'Engineering', NULL, NULL, 'Rt. 470 Box A', 'Merida', 'Yucatan', '69940', 'Mexico', NULL, NULL, '457-555-5263', NULL, NULL, NULL, 'www.muenich-youngengineering,inc.com', NULL, NULL, NULL, NULL, 'Rt. 470 Box A', 'Merida', 'Yucatan', '69940', 'Mexico', 0);
INSERT INTO accounts VALUES ('e153589f-133b-e390-b669-438dfb24cd9f', '2005-11-30 19:19:07', '2005-11-30 19:19:07', '1', 'kristen_id', '1', 'E & F Arnold Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '7403 N. Broadway', 'Oregon City', 'OR', '38217', 'USA', NULL, NULL, '969-555-4928', NULL, NULL, NULL, 'www.efarnoldmachinery,ltd.com', NULL, NULL, NULL, NULL, '7403 N. Broadway', 'Oregon City', 'OR', '38217', 'USA', 0);
INSERT INTO accounts VALUES ('12ca7ab1-220a-4af9-99ba-438dfbe5571c', '2005-11-30 19:19:08', '2005-11-30 19:19:08', '1', 'chris_id', '1', 'Arnold-Cooper Transportation Holdings', NULL, 'Distribution', 'Transportation', NULL, NULL, '5734 Ashford Court', 'Seattle', 'WA', '93604', 'USA', NULL, NULL, '188-555-1163', NULL, NULL, NULL, 'www.arnold-coopertransportationholdings.com', NULL, NULL, NULL, NULL, '5734 Ashford Court', 'Seattle', 'WA', '93604', 'USA', 0);
INSERT INTO accounts VALUES ('3a942d15-be46-e733-9cd3-438dfbb71e24', '2005-11-30 19:19:08', '2005-11-30 19:19:08', '1', 'will_id', '1', 'N & O Petty Electronics, Inc', NULL, 'Supply', 'Electronics', NULL, NULL, '8684 Military East', 'Arcadia', 'CA', '28043', 'USA', NULL, NULL, '722-555-8456', NULL, NULL, NULL, 'www.nopettyelectronics,inc.com', NULL, NULL, NULL, NULL, '8684 Military East', 'Arcadia', 'CA', '28043', 'USA', 0);
INSERT INTO accounts VALUES ('68b936e6-d166-104a-f3f3-438dfb9a2b2a', '2005-11-30 19:19:08', '2005-11-30 19:19:08', '1', 'kristen_id', '1', 'Petty-Olguin Machinery Group', NULL, 'Distribution', 'Machinery', NULL, NULL, '7270 Pepperidge Way', 'Lebanon', 'OR', '49592', 'USA', NULL, NULL, '203-555-6978', NULL, NULL, NULL, 'www.petty-olguinmachinerygroup.com', NULL, NULL, NULL, NULL, '7270 Pepperidge Way', 'Lebanon', 'OR', '49592', 'USA', 0);
INSERT INTO accounts VALUES ('92b622ce-8026-54c4-bb92-438dfbea0f65', '2005-11-30 19:19:08', '2005-11-30 19:19:08', '1', 'beth_id', '1', 'U & W Burchett Construction Corp', NULL, 'Supply', 'Construction', NULL, NULL, '475 Santa Maria', 'Santa Cruz', 'CA', '49192', 'USA', NULL, NULL, '761-555-3899', NULL, NULL, NULL, 'www.uwburchettconstructioncorp.com', NULL, NULL, NULL, NULL, '475 Santa Maria', 'Santa Cruz', 'CA', '49192', 'USA', 0);
INSERT INTO accounts VALUES ('ba692bd5-98cb-195e-3509-438dfb8e7448', '2005-11-30 19:19:08', '2005-11-30 19:19:08', '1', 'max_id', '1', 'Burchett-Bechard Electronics Company', NULL, 'Consulting', 'Electronics', NULL, NULL, '1970 Napa Ct.', 'W. Linn', 'OR', '36903', 'USA', NULL, NULL, '616-555-6966', NULL, NULL, NULL, 'www.burchett-bechardelectronicscompany.com', NULL, NULL, NULL, NULL, '1970 Napa Ct.', 'W. Linn', 'OR', '36903', 'USA', 0);
INSERT INTO accounts VALUES ('df9d2e47-e4af-a4cd-f57f-438dfb4ad6c4', '2005-11-30 19:19:08', '2005-11-30 19:19:08', '1', 'chris_id', '1', 'M & K Carter Telecommunications, Ltd', NULL, 'Supply', 'Telecommunications', NULL, NULL, '8084 Cardiff Drive', 'San Andres', 'DF', '94169', 'Mexico', NULL, NULL, '535-555-6174', NULL, NULL, NULL, 'www.mkcartertelecommunications,ltd.com', NULL, NULL, NULL, NULL, '8084 Cardiff Drive', 'San Andres', 'DF', '94169', 'Mexico', 0);
INSERT INTO accounts VALUES ('15e6d611-0ff0-efa3-2a08-438dfb32d02d', '2005-11-30 19:19:09', '2005-11-30 19:19:09', '1', 'sarah_id', '1', 'Carter-Sharp Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '9833 Mt. Dias Blv.', 'Burbank', 'CA', '48042', 'USA', NULL, NULL, '962-555-1952', NULL, NULL, NULL, 'www.carter-sharpmachinery,ltd.com', NULL, NULL, NULL, NULL, '9833 Mt. Dias Blv.', 'Burbank', 'CA', '48042', 'USA', 0);
INSERT INTO accounts VALUES ('3b8554f2-e220-4e32-b135-438dfb52f9fe', '2005-11-30 19:19:09', '2005-11-30 19:19:09', '1', 'beth_id', '1', 'L & E Brunner Communications Partners', NULL, 'Distribution', 'Communications', NULL, NULL, '6202 Seeno St.', 'Bellflower', 'CA', '52673', 'USA', NULL, NULL, '904-555-8788', NULL, NULL, NULL, 'www.lebrunnercommunicationspartners.com', NULL, NULL, NULL, NULL, '6202 Seeno St.', 'Bellflower', 'CA', '52673', 'USA', 0);
INSERT INTO accounts VALUES ('62e7c87a-db38-c12d-27c1-438dfb76bf23', '2005-11-30 19:19:09', '2005-11-30 19:19:09', '1', 'sally_id', '1', 'Brunner-Staton Construction Holdings', NULL, 'Consulting', 'Construction', NULL, NULL, '862 The Alameda', 'Renton', 'WA', '71706', 'USA', NULL, NULL, '693-555-6852', NULL, NULL, NULL, 'www.brunner-statonconstructionholdings.com', NULL, NULL, NULL, NULL, '862 The Alameda', 'Renton', 'WA', '71706', 'USA', 0);
INSERT INTO accounts VALUES ('9483cdff-0afc-bc72-342c-438dfb495915', '2005-11-30 19:19:09', '2005-11-30 19:19:09', '1', 'kristen_id', '1', 'W & N Sims Telecommunications Partners', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '7484 Roundtree Drive', 'Mill Valley', 'CA', '68791', 'USA', NULL, NULL, '658-555-3316', NULL, NULL, NULL, 'www.wnsimstelecommunicationspartners.com', NULL, NULL, NULL, NULL, '7484 Roundtree Drive', 'Mill Valley', 'CA', '68791', 'USA', 0);
INSERT INTO accounts VALUES ('b9b66e60-dbc2-97f8-d5b4-438dfbb7431d', '2005-11-30 19:19:09', '2005-11-30 19:19:09', '1', 'sally_id', '1', 'Sims-De Carlo Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '5053 Loftus Road', 'Oak Bay', 'BC', '53986', 'Canada', NULL, NULL, '708-555-3666', NULL, NULL, NULL, 'www.sims-decarlotransportationholdings.com', NULL, NULL, NULL, NULL, '5053 Loftus Road', 'Oak Bay', 'BC', '53986', 'Canada', 0);
INSERT INTO accounts VALUES ('e1e7c4e5-7e25-6799-eb9a-438dfba51d7f', '2005-11-30 19:19:09', '2005-11-30 19:19:09', '1', 'beth_id', '1', 'V & A Williams Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '1930 Almondwood Drive', 'Camacho', 'Zacatecas', '89939', 'Mexico', NULL, NULL, '696-555-7759', NULL, NULL, NULL, 'www.vawilliamstransportationcorp.com', NULL, NULL, NULL, NULL, '1930 Almondwood Drive', 'Camacho', 'Zacatecas', '89939', 'Mexico', 0);
INSERT INTO accounts VALUES ('19c8dab9-5903-3485-5d78-438dfb4125b3', '2005-11-30 19:19:10', '2005-11-30 19:19:10', '1', 'max_id', '1', 'Williams-Burke Communications Corp', NULL, 'Consulting', 'Communications', NULL, NULL, '9752 Jeanne Circle', 'Arcadia', 'CA', '41297', 'USA', NULL, NULL, '770-555-6738', NULL, NULL, NULL, 'www.williams-burkecommunicationscorp.com', NULL, NULL, NULL, NULL, '9752 Jeanne Circle', 'Arcadia', 'CA', '41297', 'USA', 0);
INSERT INTO accounts VALUES ('44496c8b-c971-3912-ef47-438dfb05614b', '2005-11-30 19:19:10', '2005-11-30 19:19:10', '1', 'sally_id', '1', 'T & A Osborn Electronics, Inc', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '9539 Glenside Dr', 'Altadena', 'CA', '43412', 'USA', NULL, NULL, '119-555-4116', NULL, NULL, NULL, 'www.taosbornelectronics,inc.com', NULL, NULL, NULL, NULL, '9539 Glenside Dr', 'Altadena', 'CA', '43412', 'USA', 0);
INSERT INTO accounts VALUES ('69df481f-8899-8333-3d9c-438dfbae3e94', '2005-11-30 19:19:10', '2005-11-30 19:19:10', '1', 'matt_id', '1', 'Osborn-Binai Construction Associates', NULL, 'Manufacturing', 'Construction', NULL, NULL, '7616 Honey Court', 'Oakland', 'CA', '33639', 'USA', NULL, NULL, '216-555-1723', NULL, NULL, NULL, 'www.osborn-binaiconstructionassociates.com', NULL, NULL, NULL, NULL, '7616 Honey Court', 'Oakland', 'CA', '33639', 'USA', 0);
INSERT INTO accounts VALUES ('9bf12bea-3d89-2b67-a279-438dfb7f1aa9', '2005-11-30 19:19:10', '2005-11-30 19:19:10', '1', 'chris_id', '1', 'D & D Lozada Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '7657 H St.', 'Tixapan', 'DF', '19185', 'Mexico', NULL, NULL, '727-555-1388', NULL, NULL, NULL, 'www.ddlozadaelectronicsholdings.com', NULL, NULL, NULL, NULL, '7657 H St.', 'Tixapan', 'DF', '19185', 'Mexico', 0);
INSERT INTO accounts VALUES ('c5fb833d-150f-99a6-9946-438dfb94f2c5', '2005-11-30 19:19:10', '2005-11-30 19:19:10', '1', 'sarah_id', '1', 'Lozada-Tays Machinery, Inc', NULL, 'Distribution', 'Machinery', NULL, NULL, '5988 Red Leaf', 'Oak Bay', 'BC', '83595', 'Canada', NULL, NULL, '298-555-3541', NULL, NULL, NULL, 'www.lozada-taysmachinery,inc.com', NULL, NULL, NULL, NULL, '5988 Red Leaf', 'Oak Bay', 'BC', '83595', 'Canada', 0);
INSERT INTO accounts VALUES ('24360cfc-2889-5353-2998-438dfbffd419', '2005-11-30 19:19:11', '2005-11-30 19:19:11', '1', 'sally_id', '1', 'I & V Thorton Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '8938 West Hookston Road', 'Metchosin', 'BC', '18033', 'Canada', NULL, NULL, '832-555-1834', NULL, NULL, NULL, 'www.ivthortonengineering,inc.com', NULL, NULL, NULL, NULL, '8938 West Hookston Road', 'Metchosin', 'BC', '18033', 'Canada', 0);
INSERT INTO accounts VALUES ('28a3374d-7edd-e1ae-8b82-438dfbb1ba4b', '2005-11-30 19:19:11', '2005-11-30 19:19:11', '1', 'beth_id', '1', 'Thorton-Dumin Construction, Ltd', NULL, 'Manufacturing', 'Construction', NULL, NULL, '181 Gainsborough Drive', 'Grossmont', 'CA', '39583', 'USA', NULL, NULL, '313-555-9355', NULL, NULL, NULL, 'www.thorton-duminconstruction,ltd.com', NULL, NULL, NULL, NULL, '181 Gainsborough Drive', 'Grossmont', 'CA', '39583', 'USA', 0);
INSERT INTO accounts VALUES ('5a6c2cce-c982-432d-802f-438dfbaa1b2d', '2005-11-30 19:19:11', '2005-11-30 19:19:11', '1', 'matt_id', '1', 'K & R Chin Communications Group', NULL, 'Consulting', 'Communications', NULL, NULL, '3385 Crestview Drive', 'Imperial Beach', 'CA', '39182', 'USA', NULL, NULL, '871-555-6277', NULL, NULL, NULL, 'www.krchincommunicationsgroup.com', NULL, NULL, NULL, NULL, '3385 Crestview Drive', 'Imperial Beach', 'CA', '39182', 'USA', 0);
INSERT INTO accounts VALUES ('7fb9aa29-6e36-4329-96a0-438dfbe17998', '2005-11-30 19:19:11', '2005-11-30 19:19:11', '1', 'jaime_id', '1', 'Chin-Lovell Engineering Associates', NULL, 'Distribution', 'Engineering', NULL, NULL, '6912 Laguna St.', 'San Andres', 'DF', '26893', 'Mexico', NULL, NULL, '375-555-3427', NULL, NULL, NULL, 'www.chin-lovellengineeringassociates.com', NULL, NULL, NULL, NULL, '6912 Laguna St.', 'San Andres', 'DF', '26893', 'Mexico', 0);
INSERT INTO accounts VALUES ('a5207af5-eba0-4a11-4fec-438dfb66e63f', '2005-11-30 19:19:11', '2005-11-30 19:19:11', '1', 'max_id', '1', 'B & P Ratcliff Telecommunications Holdings', NULL, 'Distribution', 'Telecommunications', NULL, NULL, '371 Ahneita Dr.', 'Oakland', 'CA', '65362', 'USA', NULL, NULL, '294-555-2634', NULL, NULL, NULL, 'www.bpratclifftelecommunicationsholdings.com', NULL, NULL, NULL, NULL, '371 Ahneita Dr.', 'Oakland', 'CA', '65362', 'USA', 0);
INSERT INTO accounts VALUES ('ca77a3a6-1980-87ca-3936-438dfbc5ed9a', '2005-11-30 19:19:11', '2005-11-30 19:19:11', '1', 'kristen_id', '1', 'Ratcliff-Moss Electronics, Ltd', NULL, 'Distribution', 'Electronics', NULL, NULL, '4776 Kentucky Drive', 'Burnaby', 'BC', '70204', 'Canada', NULL, NULL, '721-555-7412', NULL, NULL, NULL, 'www.ratcliff-mosselectronics,ltd.com', NULL, NULL, NULL, NULL, '4776 Kentucky Drive', 'Burnaby', 'BC', '70204', 'Canada', 0);
INSERT INTO accounts VALUES ('301d0472-13ab-06ea-b8ea-438dfbbf5d2b', '2005-11-30 19:19:12', '2005-11-30 19:19:12', '1', 'chris_id', '1', 'Q & P Anderson Telecommunications Company', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, '1145 Paraiso Ct.', 'Langley', 'BC', '74834', 'Canada', NULL, NULL, '663-555-5248', NULL, NULL, NULL, 'www.qpandersontelecommunicationscompany.com', NULL, NULL, NULL, NULL, '1145 Paraiso Ct.', 'Langley', 'BC', '74834', 'Canada', 0);
INSERT INTO accounts VALUES ('2fe59fe0-21e0-b9aa-f06e-438dfbf94248', '2005-11-30 19:19:12', '2005-11-30 19:19:12', '1', 'beth_id', '1', 'Anderson-Everson Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '3148 Rose Street', 'Tacoma', 'WA', '93868', 'USA', NULL, NULL, '451-555-3312', NULL, NULL, NULL, 'www.anderson-eversontransportationholdings.com', NULL, NULL, NULL, NULL, '3148 Rose Street', 'Tacoma', 'WA', '93868', 'USA', 0);
INSERT INTO accounts VALUES ('5bcee21d-2f47-8266-e876-438dfb7e8edd', '2005-11-30 19:19:12', '2005-11-30 19:19:12', '1', 'kristen_id', '1', 'G & N Borden Communications Group', NULL, 'Supply', 'Communications', NULL, NULL, '2427 Notre Dame Ave.', 'Santa Monica', 'CA', '64660', 'USA', NULL, NULL, '656-555-3434', NULL, NULL, NULL, 'www.gnbordencommunicationsgroup.com', NULL, NULL, NULL, NULL, '2427 Notre Dame Ave.', 'Santa Monica', 'CA', '64660', 'USA', 0);
INSERT INTO accounts VALUES ('812f72fc-ab3e-476d-9117-438dfb874384', '2005-11-30 19:19:12', '2005-11-30 19:19:12', '1', 'kristen_id', '1', 'Borden-Willson Construction Partners', NULL, 'Distribution', 'Construction', NULL, NULL, '7340 Green St.', 'Tlaxiaco', 'Oaxaca', '49856', 'Mexico', NULL, NULL, '467-555-9127', NULL, NULL, NULL, 'www.borden-willsonconstructionpartners.com', NULL, NULL, NULL, NULL, '7340 Green St.', 'Tlaxiaco', 'Oaxaca', '49856', 'Mexico', 0);
INSERT INTO accounts VALUES ('c2f7eed0-8116-30ea-954e-438dfb1eabdb', '2005-11-30 19:19:12', '2005-11-30 19:19:12', '1', 'kristen_id', '1', 'H & Y Harris Electronics, Ltd', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '6872 Thornwood Dr.', 'Beaverton', 'OR', '85809', 'USA', NULL, NULL, '814-555-9899', NULL, NULL, NULL, 'www.hyharriselectronics,ltd.com', NULL, NULL, NULL, NULL, '6872 Thornwood Dr.', 'Beaverton', 'OR', '85809', 'USA', 0);
INSERT INTO accounts VALUES ('ec7d9ee2-985e-832d-246a-438dfb43d183', '2005-11-30 19:19:12', '2005-11-30 19:19:12', '1', 'chris_id', '1', 'Harris-Contreras Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '2040 Encino Drive', 'Metchosin', 'BC', '37167', 'Canada', NULL, NULL, '648-555-5221', NULL, NULL, NULL, 'www.harris-contrerastransportationholdings.com', NULL, NULL, NULL, NULL, '2040 Encino Drive', 'Metchosin', 'BC', '37167', 'Canada', 0);
INSERT INTO accounts VALUES ('25d33195-1843-27b2-f5df-438dfbbd4332', '2005-11-30 19:19:13', '2005-11-30 19:19:13', '1', 'sarah_id', '1', 'O & K Pusedu Transportation Corp', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '1826 Corte Del Sol', 'Metchosin', 'BC', '39282', 'Canada', NULL, NULL, '898-555-2599', NULL, NULL, NULL, 'www.okpusedutransportationcorp.com', NULL, NULL, NULL, NULL, '1826 Corte Del Sol', 'Metchosin', 'BC', '39282', 'Canada', 0);
INSERT INTO accounts VALUES ('5a9ce64f-76c1-d0b3-0321-438dfb8cf7b6', '2005-11-30 19:19:13', '2005-11-30 19:19:13', '1', 'beth_id', '1', 'Pusedu-Stedman Construction Partners', NULL, 'Consulting', 'Construction', NULL, NULL, '9903 East Leland', 'Westminster', 'BC', '55800', 'Canada', NULL, NULL, '994-555-9206', NULL, NULL, NULL, 'www.pusedu-stedmanconstructionpartners.com', NULL, NULL, NULL, NULL, '9903 East Leland', 'Westminster', 'BC', '55800', 'Canada', 0);
INSERT INTO accounts VALUES ('7ff64e0f-4980-e147-e646-438dfb3c2560', '2005-11-30 19:19:13', '2005-11-30 19:19:13', '1', 'sally_id', '1', 'D & D Zocchi Transportation, Ltd', NULL, 'Distribution', 'Transportation', NULL, NULL, '9943 Stonehedge Dr.', 'Hidalgo', 'Zacatecas', '24077', 'Mexico', NULL, NULL, '606-555-8871', NULL, NULL, NULL, 'www.ddzocchitransportation,ltd.com', NULL, NULL, NULL, NULL, '9943 Stonehedge Dr.', 'Hidalgo', 'Zacatecas', '24077', 'Mexico', 0);
INSERT INTO accounts VALUES ('a57a0171-598b-52c1-a44f-438dfbac3293', '2005-11-30 19:19:13', '2005-11-30 19:19:13', '1', 'kristen_id', '1', 'Zocchi-Walsh Machinery, Inc', NULL, 'Consulting', 'Machinery', NULL, NULL, '931 Corte De Luna', 'Los Angeles', 'CA', '79465', 'USA', NULL, NULL, '725-555-5106', NULL, NULL, NULL, 'www.zocchi-walshmachinery,inc.com', NULL, NULL, NULL, NULL, '931 Corte De Luna', 'Los Angeles', 'CA', '79465', 'USA', 0);
INSERT INTO accounts VALUES ('cad65136-9e79-c945-107b-438dfb8b41de', '2005-11-30 19:19:13', '2005-11-30 19:19:13', '1', 'beth_id', '1', 'E & M Renfro Electronics Company', NULL, 'Supply', 'Electronics', NULL, NULL, '1226 Shoenic', 'Coronado', 'CA', '13903', 'USA', NULL, NULL, '360-555-3399', NULL, NULL, NULL, 'www.emrenfroelectronicscompany.com', NULL, NULL, NULL, NULL, '1226 Shoenic', 'Coronado', 'CA', '13903', 'USA', 0);
INSERT INTO accounts VALUES ('f09a17fa-2820-2d97-db3c-438dfbf7e7e5', '2005-11-30 19:19:13', '2005-11-30 19:19:13', '1', 'matt_id', '1', 'Renfro-Brockett Engineering, Ltd', NULL, 'Distribution', 'Engineering', NULL, NULL, '2467 Clearland Circle', 'La Cruz', 'Sinaloa', '61745', 'Mexico', NULL, NULL, '741-555-1921', NULL, NULL, NULL, 'www.renfro-brockettengineering,ltd.com', NULL, NULL, NULL, NULL, '2467 Clearland Circle', 'La Cruz', 'Sinaloa', '61745', 'Mexico', 0);
INSERT INTO accounts VALUES ('221acfb4-1667-5126-232f-438dfb9ae6c1', '2005-11-30 19:19:14', '2005-11-30 19:19:14', '1', 'matt_id', '1', 'R & Z Anderson Communications, Inc', NULL, 'Distribution', 'Communications', NULL, NULL, '5671 Bel Air Dr.', 'Shawnee', 'BC', '35052', 'Canada', NULL, NULL, '398-555-7842', NULL, NULL, NULL, 'www.rzandersoncommunications,inc.com', NULL, NULL, NULL, NULL, '5671 Bel Air Dr.', 'Shawnee', 'BC', '35052', 'Canada', 0);
INSERT INTO accounts VALUES ('49d9b236-ff3a-4340-f619-438dfb42fdf8', '2005-11-30 19:19:14', '2005-11-30 19:19:14', '1', 'chris_id', '1', 'Anderson-Gomez Machinery Partners', NULL, 'Supply', 'Machinery', NULL, NULL, '7166 Brock Lane', 'Yakima', 'WA', '49055', 'USA', NULL, NULL, '802-555-4992', NULL, NULL, NULL, 'www.anderson-gomezmachinerypartners.com', NULL, NULL, NULL, NULL, '7166 Brock Lane', 'Yakima', 'WA', '49055', 'USA', 0);
INSERT INTO accounts VALUES ('6fc8c6a5-7400-9855-fac4-438dfb37774c', '2005-11-30 19:19:14', '2005-11-30 19:19:14', '1', 'sarah_id', '1', 'J & K Walker Communications Corp', NULL, 'Supply', 'Communications', NULL, NULL, '3281 Hillview Dr.', 'Ballard', 'WA', '87524', 'USA', NULL, NULL, '722-555-4199', NULL, NULL, NULL, 'www.jkwalkercommunicationscorp.com', NULL, NULL, NULL, NULL, '3281 Hillview Dr.', 'Ballard', 'WA', '87524', 'USA', 0);
INSERT INTO accounts VALUES ('953f26e5-ef03-73a5-2912-438dfbf3e02e', '2005-11-30 19:19:14', '2005-11-30 19:19:14', '1', 'sally_id', '1', 'Walker-Jones Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '5030 Blue Ridge Dr.', 'Lynnwood', 'WA', '35227', 'USA', NULL, NULL, '248-555-8978', NULL, NULL, NULL, 'www.walker-jonesconstruction,ltd.com', NULL, NULL, NULL, NULL, '5030 Blue Ridge Dr.', 'Lynnwood', 'WA', '35227', 'USA', 0);
INSERT INTO accounts VALUES ('baa2d9d1-3d4d-1de9-fdf3-438dfba9a8e5', '2005-11-30 19:19:14', '2005-11-30 19:19:14', '1', 'max_id', '1', 'W & W Winfrey Electronics Associates', NULL, 'Supply', 'Electronics', NULL, NULL, '1399 Firestone Drive', 'Port Orchard', 'WA', '66150', 'USA', NULL, NULL, '191-555-6813', NULL, NULL, NULL, 'www.wwwinfreyelectronicsassociates.com', NULL, NULL, NULL, NULL, '1399 Firestone Drive', 'Port Orchard', 'WA', '66150', 'USA', 0);
INSERT INTO accounts VALUES ('eea76ad0-2d41-1f9b-c178-438dfb4344f9', '2005-11-30 19:19:14', '2005-11-30 19:19:14', '1', 'max_id', '1', 'Winfrey-Brown Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '6058 Hill Street', 'Downey', 'CA', '85184', 'USA', NULL, NULL, '569-555-5452', NULL, NULL, NULL, 'www.winfrey-brownmachinerygroup.com', NULL, NULL, NULL, NULL, '6058 Hill Street', 'Downey', 'CA', '85184', 'USA', 0);
INSERT INTO accounts VALUES ('1fe57f85-843a-c2da-ce4a-438dfbdca0ec', '2005-11-30 19:19:15', '2005-11-30 19:19:15', '1', 'beth_id', '1', 'D & G Touchstone Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '2681 Eagle Peak', 'Salem', 'OR', '55976', 'USA', NULL, NULL, '774-555-5574', NULL, NULL, NULL, 'www.dgtouchstonetransportation,inc.com', NULL, NULL, NULL, NULL, '2681 Eagle Peak', 'Salem', 'OR', '55976', 'USA', 0);
INSERT INTO accounts VALUES ('4ab5174a-cfe1-ac9d-33d7-438dfb1ba854', '2005-11-30 19:19:15', '2005-11-30 19:19:15', '1', 'matt_id', '1', 'Touchstone-Bakhtyari Engineering, Ltd', NULL, 'Supply', 'Engineering', NULL, NULL, '7594 Alexander Pl.', 'Tacoma', 'WA', '41172', 'USA', NULL, NULL, '585-555-2267', NULL, NULL, NULL, 'www.touchstone-bakhtyariengineering,ltd.com', NULL, NULL, NULL, NULL, '7594 Alexander Pl.', 'Tacoma', 'WA', '41172', 'USA', 0);
INSERT INTO accounts VALUES ('71d45061-e051-80ff-387f-438dfbcf7868', '2005-11-30 19:19:15', '2005-11-30 19:19:15', '1', 'jaime_id', '1', 'Z & L Glass Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '7126 Edie Ct.', 'Lemon Grove', 'CA', '77125', 'USA', NULL, NULL, '812-555-1017', NULL, NULL, NULL, 'www.zlglassconstruction,ltd.com', NULL, NULL, NULL, NULL, '7126 Edie Ct.', 'Lemon Grove', 'CA', '77125', 'USA', 0);
INSERT INTO accounts VALUES ('9831fcba-daad-6531-f7d9-438dfb452a61', '2005-11-30 19:19:15', '2005-11-30 19:19:15', '1', 'will_id', '1', 'Glass-Cohen Transportation Group', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '2294 West 39th St.', 'Milwaukie', 'OR', '28482', 'USA', NULL, NULL, '646-555-5338', NULL, NULL, NULL, 'www.glass-cohentransportationgroup.com', NULL, NULL, NULL, NULL, '2294 West 39th St.', 'Milwaukie', 'OR', '28482', 'USA', 0);
INSERT INTO accounts VALUES ('bd7a6aa6-59fa-3349-782d-438dfb6a361a', '2005-11-30 19:19:15', '2005-11-30 19:19:15', '1', 'max_id', '1', 'V & P Kharman Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '2080 Sycamore Drive', 'Richmond', 'CA', '30597', 'USA', NULL, NULL, '896-555-2717', NULL, NULL, NULL, 'www.vpkharmantransportationcorp.com', NULL, NULL, NULL, NULL, '2080 Sycamore Drive', 'Richmond', 'CA', '30597', 'USA', 0);
INSERT INTO accounts VALUES ('e3d36dd6-a3ec-ca32-8f00-438dfbf01d62', '2005-11-30 19:19:15', '2005-11-30 19:19:15', '1', 'will_id', '1', 'Kharman-Kirschner Telecommunications, Inc', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '158 Walnut Ave', 'Arcadia', 'CA', '47116', 'USA', NULL, NULL, '331-555-3981', NULL, NULL, NULL, 'www.kharman-kirschnertelecommunications,inc.com', NULL, NULL, NULL, NULL, '158 Walnut Ave', 'Arcadia', 'CA', '47116', 'USA', 0);
INSERT INTO accounts VALUES ('16270908-902d-5444-bdd2-438dfb677e78', '2005-11-30 19:19:16', '2005-11-30 19:19:16', '1', 'matt_id', '1', 'F & X Burger Communications Partners', NULL, 'Consulting', 'Communications', NULL, NULL, '2854 Magda Way', 'Haney', 'BC', '88099', 'Canada', NULL, NULL, '604-555-8988', NULL, NULL, NULL, 'www.fxburgercommunicationspartners.com', NULL, NULL, NULL, NULL, '2854 Magda Way', 'Haney', 'BC', '88099', 'Canada', 0);
INSERT INTO accounts VALUES ('3f6d17ff-3b92-d8ce-b733-438dfb08d42a', '2005-11-30 19:19:16', '2005-11-30 19:19:16', '1', 'sally_id', '1', 'Burger-Blau Communications Holdings', NULL, 'Distribution', 'Communications', NULL, NULL, '1185 Dallis Drive', 'Novato', 'CA', '70780', 'USA', NULL, NULL, '723-555-5224', NULL, NULL, NULL, 'www.burger-blaucommunicationsholdings.com', NULL, NULL, NULL, NULL, '1185 Dallis Drive', 'Novato', 'CA', '70780', 'USA', 0);
INSERT INTO accounts VALUES ('672ce9a6-eabc-8209-5417-438dfbe5cda1', '2005-11-30 19:19:16', '2005-11-30 19:19:16', '1', 'sarah_id', '1', 'S & X Derby Engineering Partners', NULL, 'Distribution', 'Engineering', NULL, NULL, '8154 Via Mexico', 'Bremerton', 'WA', '52198', 'USA', NULL, NULL, '358-555-3517', NULL, NULL, NULL, 'www.sxderbyengineeringpartners.com', NULL, NULL, NULL, NULL, '8154 Via Mexico', 'Bremerton', 'WA', '52198', 'USA', 0);
INSERT INTO accounts VALUES ('8dbf7451-dc4a-3634-8099-438dfb762ae2', '2005-11-30 19:19:16', '2005-11-30 19:19:16', '1', 'sarah_id', '1', 'Derby-Thomson Transportation, Inc', NULL, 'Supply', 'Transportation', NULL, NULL, '6740 Jalisco', 'N. Vancouver', 'BC', '26768', 'Canada', NULL, NULL, '739-555-2038', NULL, NULL, NULL, 'www.derby-thomsontransportation,inc.com', NULL, NULL, NULL, NULL, '6740 Jalisco', 'N. Vancouver', 'BC', '26768', 'Canada', 0);
INSERT INTO accounts VALUES ('b48abc38-b9e5-f7a7-1a0a-438dfb92bcf3', '2005-11-30 19:19:16', '2005-11-30 19:19:16', '1', 'sarah_id', '1', 'H & N Walton Machinery Corp', NULL, 'Supply', 'Machinery', NULL, NULL, '2601 Cambridge Drive', 'Milwaukie', 'OR', '26367', 'USA', NULL, NULL, '396-555-7960', NULL, NULL, NULL, 'www.hnwaltonmachinerycorp.com', NULL, NULL, NULL, NULL, '2601 Cambridge Drive', 'Milwaukie', 'OR', '26367', 'USA', 0);
INSERT INTO accounts VALUES ('da0b3314-1bd1-f760-47f1-438dfba1b415', '2005-11-30 19:19:16', '2005-11-30 19:19:16', '1', 'will_id', '1', 'Walton-Meastas Machinery Associates', NULL, 'Supply', 'Machinery', NULL, NULL, '4096 San Remo', 'Woodland Hills', 'CA', '14079', 'USA', NULL, NULL, '912-555-7369', NULL, NULL, NULL, 'www.walton-meastasmachineryassociates.com', NULL, NULL, NULL, NULL, '4096 San Remo', 'Woodland Hills', 'CA', '14079', 'USA', 0);
INSERT INTO accounts VALUES ('115922df-1ff1-d274-144c-438dfb73dc42', '2005-11-30 19:19:17', '2005-11-30 19:19:17', '1', 'max_id', '1', 'G & W Kouba Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '7554 Lakeview Pl.', 'Sooke', 'BC', '78839', 'Canada', NULL, NULL, '832-555-6577', NULL, NULL, NULL, 'www.gwkoubatransportation,inc.com', NULL, NULL, NULL, NULL, '7554 Lakeview Pl.', 'Sooke', 'BC', '78839', 'Canada', 0);
INSERT INTO accounts VALUES ('389b7a9d-973c-9771-632a-438dfb1fddfc', '2005-11-30 19:19:17', '2005-11-30 19:19:17', '1', 'matt_id', '1', 'Kouba-Clark Machinery Corp', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '1960 Via Catanzaro', 'Long Beach', 'CA', '32712', 'USA', NULL, NULL, '597-555-6013', NULL, NULL, NULL, 'www.kouba-clarkmachinerycorp.com', NULL, NULL, NULL, NULL, '1960 Via Catanzaro', 'Long Beach', 'CA', '32712', 'USA', 0);
INSERT INTO accounts VALUES ('63f1f0f0-6489-f61f-9a36-438dfb750c25', '2005-11-30 19:19:17', '2005-11-30 19:19:17', '1', 'beth_id', '1', 'V & B Munn Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '5672 Hale Dr.', 'Arcadia', 'CA', '61730', 'USA', NULL, NULL, '540-555-3848', NULL, NULL, NULL, 'www.vbmunntransportationholdings.com', NULL, NULL, NULL, NULL, '5672 Hale Dr.', 'Arcadia', 'CA', '61730', 'USA', 0);
INSERT INTO accounts VALUES ('8945a4f8-4927-b6da-7fbc-438dfb9c24e5', '2005-11-30 19:19:17', '2005-11-30 19:19:17', '1', 'beth_id', '1', 'Munn-Goldberg Construction Company', NULL, 'Consulting', 'Construction', NULL, NULL, '332 Laguna Niguel', 'Woodburn', 'OR', '80763', 'USA', NULL, NULL, '989-555-7255', NULL, NULL, NULL, 'www.munn-goldbergconstructioncompany.com', NULL, NULL, NULL, NULL, '332 Laguna Niguel', 'Woodburn', 'OR', '80763', 'USA', 0);
INSERT INTO accounts VALUES ('b23360b3-d90f-0bf2-6864-438dfba63bde', '2005-11-30 19:19:17', '2005-11-30 19:19:17', '1', 'max_id', '1', 'C & A Magenheim Engineering Group', NULL, 'Supply', 'Engineering', NULL, NULL, '6954 Garcia Ranch Road', 'Vancouver', 'BC', '77848', 'Canada', NULL, NULL, '293-555-7377', NULL, NULL, NULL, 'www.camagenheimengineeringgroup.com', NULL, NULL, NULL, NULL, '6954 Garcia Ranch Road', 'Vancouver', 'BC', '77848', 'Canada', 0);
INSERT INTO accounts VALUES ('d97458bd-138c-6ccd-14c1-438dfb875b17', '2005-11-30 19:19:17', '2005-11-30 19:19:17', '1', 'kristen_id', '1', 'Magenheim-Hance Construction, Ltd', NULL, 'Consulting', 'Construction', NULL, NULL, '4523 Via Cortez', 'Tlaxiaco', 'Oaxaca', '63043', 'Mexico', NULL, NULL, '471-555-9125', NULL, NULL, NULL, 'www.magenheim-hanceconstruction,ltd.com', NULL, NULL, NULL, NULL, '4523 Via Cortez', 'Tlaxiaco', 'Oaxaca', '63043', 'Mexico', 0);
INSERT INTO accounts VALUES ('cdb7018f-2af9-c5c5-bc5a-438dfbeabc25', '2005-11-30 19:19:18', '2005-11-30 19:19:18', '1', 'chris_id', '1', 'U & S Mehlert Transportation, Inc', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '1400 Gibrix Drive', 'Beaverton', 'OR', '98996', 'USA', NULL, NULL, '698-555-7875', NULL, NULL, NULL, 'www.usmehlerttransportation,inc.com', NULL, NULL, NULL, NULL, '1400 Gibrix Drive', 'Beaverton', 'OR', '98996', 'USA', 0);
INSERT INTO accounts VALUES ('34b7fcff-4ff6-4547-cc7f-438dfb271457', '2005-11-30 19:19:18', '2005-11-30 19:19:18', '1', 'will_id', '1', 'Mehlert-Duran Construction Group', NULL, 'Distribution', 'Construction', NULL, NULL, '9222 Roseann Drive', 'Richmond', 'BC', '50354', 'Canada', NULL, NULL, '532-555-3196', NULL, NULL, NULL, 'www.mehlert-duranconstructiongroup.com', NULL, NULL, NULL, NULL, '9222 Roseann Drive', 'Richmond', 'BC', '50354', 'Canada', 0);
INSERT INTO accounts VALUES ('6243d450-6220-61bb-adf6-438dfb62abb7', '2005-11-30 19:19:18', '2005-11-30 19:19:18', '1', 'sarah_id', '1', 'N & W Earley Transportation Corp', NULL, 'Distribution', 'Transportation', NULL, NULL, '9009 W 46th St', 'Richmond', 'BC', '52469', 'Canada', NULL, NULL, '121-555-4232', NULL, NULL, NULL, 'www.nwearleytransportationcorp.com', NULL, NULL, NULL, NULL, '9009 W 46th St', 'Richmond', 'BC', '52469', 'Canada', 0);
INSERT INTO accounts VALUES ('8bfc78c0-4447-55f8-cdcf-438dfb161815', '2005-11-30 19:19:18', '2005-11-30 19:19:18', '1', 'matt_id', '1', 'Earley-Horne Engineering Partners', NULL, 'Supply', 'Engineering', NULL, NULL, '7086 O St.', 'Port Orchard', 'WA', '42696', 'USA', NULL, NULL, '217-555-1839', NULL, NULL, NULL, 'www.earley-horneengineeringpartners.com', NULL, NULL, NULL, NULL, '7086 O St.', 'Port Orchard', 'WA', '42696', 'USA', 0);
INSERT INTO accounts VALUES ('b3a58eda-3bc0-5d5d-8ca5-438dfbaadf87', '2005-11-30 19:19:18', '2005-11-30 19:19:18', '1', 'sarah_id', '1', 'O & D Hunt Communications Associates', NULL, 'Distribution', 'Communications', NULL, NULL, '7127 Morengo Court', 'San Jose', 'CA', '10972', 'USA', NULL, NULL, '490-555-6846', NULL, NULL, NULL, 'www.odhuntcommunicationsassociates.com', NULL, NULL, NULL, NULL, '7127 Morengo Court', 'San Jose', 'CA', '10972', 'USA', 0);
INSERT INTO accounts VALUES ('dd8ee07f-61bd-30be-d935-438dfb426550', '2005-11-30 19:19:18', '2005-11-30 19:19:18', '1', 'sally_id', '1', 'Hunt-Allen Transportation Company', NULL, 'Consulting', 'Transportation', NULL, NULL, '5458 Encino Drive', 'N. Vancouver', 'BC', '92652', 'Canada', NULL, NULL, '848-555-6739', NULL, NULL, NULL, 'www.hunt-allentransportationcompany.com', NULL, NULL, NULL, NULL, '5458 Encino Drive', 'N. Vancouver', 'BC', '92652', 'Canada', 0);
INSERT INTO accounts VALUES ('114ec48e-57e4-c5c2-6507-438dfb9ef25b', '2005-11-30 19:19:19', '2005-11-30 19:19:19', '1', 'sally_id', '1', 'M & Y Bruno Communications, Ltd', NULL, 'Supply', 'Communications', NULL, NULL, '8408 Via Del Sol', 'Langford', 'BC', '99797', 'Canada', NULL, NULL, '244-555-1375', NULL, NULL, NULL, 'www.mybrunocommunications,ltd.com', NULL, NULL, NULL, NULL, '8408 Via Del Sol', 'Langford', 'BC', '99797', 'Canada', 0);
INSERT INTO accounts VALUES ('3981b1f2-08e7-abb6-7b8e-438dfb4658ac', '2005-11-30 19:19:19', '2005-11-30 19:19:19', '1', 'beth_id', '1', 'Bruno-Bowers Communications Associates', NULL, 'Consulting', 'Communications', NULL, NULL, '9650 Valley View Road', 'Acapulco', 'Guerrero', '48640', 'Mexico', NULL, NULL, '737-555-2156', NULL, NULL, NULL, 'www.bruno-bowerscommunicationsassociates.com', NULL, NULL, NULL, NULL, '9650 Valley View Road', 'Acapulco', 'Guerrero', '48640', 'Mexico', 0);
INSERT INTO accounts VALUES ('63857cd3-6d3f-f409-fc9e-438dfb3001c1', '2005-11-30 19:19:19', '2005-11-30 19:19:19', '1', 'max_id', '1', 'B & D Gonzales Machinery Partners', NULL, 'Consulting', 'Machinery', NULL, NULL, '2855 Playa', 'Hidalgo', 'Zacatecas', '48239', 'Mexico', NULL, NULL, '394-555-8077', NULL, NULL, NULL, 'www.bdgonzalesmachinerypartners.com', NULL, NULL, NULL, NULL, '2855 Playa', 'Hidalgo', 'Zacatecas', '48239', 'Mexico', 0);
INSERT INTO accounts VALUES ('9052e8c4-579b-4c67-d96e-438dfbe34bfd', '2005-11-30 19:19:19', '2005-11-30 19:19:19', '1', 'sarah_id', '1', 'Gonzales-Valdez Construction Partners', NULL, 'Manufacturing', 'Construction', NULL, NULL, '4350 Mota Dr.', 'National City', 'CA', '35950', 'USA', NULL, NULL, '137-555-8885', NULL, NULL, NULL, 'www.gonzales-valdezconstructionpartners.com', NULL, NULL, NULL, NULL, '4350 Mota Dr.', 'National City', 'CA', '35950', 'USA', 0);
INSERT INTO accounts VALUES ('b852c1cb-196b-7ad1-9184-438dfbc4807b', '2005-11-30 19:19:19', '2005-11-30 19:19:19', '1', 'kristen_id', '1', 'H & E Stewart Machinery Group', NULL, 'Supply', 'Machinery', NULL, NULL, '7808 Brown St.', 'Long Beach', 'CA', '74419', 'USA', NULL, NULL, '717-555-4435', NULL, NULL, NULL, 'www.hestewartmachinerygroup.com', NULL, NULL, NULL, NULL, '7808 Brown St.', 'Long Beach', 'CA', '74419', 'USA', 0);
INSERT INTO accounts VALUES ('e0deb83a-33bc-8a70-50a3-438dfbf1a6a6', '2005-11-30 19:19:19', '2005-11-30 19:19:19', '1', 'beth_id', '1', 'Stewart-Velasquez Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '2214 Solano', 'Cliffside', 'BC', '54584', 'Canada', NULL, NULL, '483-555-3870', NULL, NULL, NULL, 'www.stewart-velasquezelectronicsholdings.com', NULL, NULL, NULL, NULL, '2214 Solano', 'Cliffside', 'BC', '54584', 'Canada', 0);
INSERT INTO accounts VALUES ('12198b06-7362-bee7-e01a-438dfbd300d2', '2005-11-30 19:19:20', '2005-11-30 19:19:20', '1', 'max_id', '1', 'X & M Dubois Construction Corp', NULL, 'Manufacturing', 'Construction', NULL, NULL, '8582 San Jose Ave.', 'Shawnee', 'BC', '59214', 'Canada', NULL, NULL, '425-555-1706', NULL, NULL, NULL, 'www.xmduboisconstructioncorp.com', NULL, NULL, NULL, NULL, '8582 San Jose Ave.', 'Shawnee', 'BC', '59214', 'Canada', 0);
INSERT INTO accounts VALUES ('3d3f5fec-1a99-37c2-6014-438dfbb1a5c1', '2005-11-30 19:19:20', '2005-11-30 19:19:20', '1', 'sally_id', '1', 'Dubois-Maestas Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '3241 Brock Lane', 'Newton', 'BC', '76633', 'Canada', NULL, NULL, '214-555-8770', NULL, NULL, NULL, 'www.dubois-maestastelecommunications,ltd.com', NULL, NULL, NULL, NULL, '3241 Brock Lane', 'Newton', 'BC', '76633', 'Canada', 0);
INSERT INTO accounts VALUES ('64ec2f2b-40b0-800b-58d6-438dfb65cc42', '2005-11-30 19:19:20', '2005-11-30 19:19:20', '1', 'chris_id', '1', 'I & M Underwood Transportation, Ltd', NULL, 'Supply', 'Transportation', NULL, NULL, '9863 Ridge Place', 'West Covina', 'CA', '47425', 'USA', NULL, NULL, '179-555-5235', NULL, NULL, NULL, 'www.imunderwoodtransportation,ltd.com', NULL, NULL, NULL, NULL, '9863 Ridge Place', 'West Covina', 'CA', '47425', 'USA', 0);
INSERT INTO accounts VALUES ('92f1a02c-7979-d266-3394-438dfbc063ae', '2005-11-30 19:19:20', '2005-11-30 19:19:20', '1', 'will_id', '1', 'Underwood-Strain Electronics Corp', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '4777 Rockne Drive', 'Palo Alto', 'CA', '32621', 'USA', NULL, NULL, '890-555-1927', NULL, NULL, NULL, 'www.underwood-strainelectronicscorp.com', NULL, NULL, NULL, NULL, '4777 Rockne Drive', 'Palo Alto', 'CA', '32621', 'USA', 0);
INSERT INTO accounts VALUES ('be69c39d-736a-d99a-4197-438dfb894cfb', '2005-11-30 19:19:20', '2005-11-30 19:19:20', '1', 'kristen_id', '1', 'H & Y Azari Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '4310 Kenston Dr.', 'Santa Monica', 'CA', '68574', 'USA', NULL, NULL, '217-555-9677', NULL, NULL, NULL, 'www.hyazariengineering,inc.com', NULL, NULL, NULL, NULL, '4310 Kenston Dr.', 'Santa Monica', 'CA', '68574', 'USA', 0);
INSERT INTO accounts VALUES ('e6c97f92-50da-b9e5-7b28-438dfb52a851', '2005-11-30 19:19:20', '2005-11-30 19:19:20', '1', 'jaime_id', '1', 'Azari-Dabit Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '9476 Hill Top Rd.', 'Sooke', 'BC', '19932', 'Canada', NULL, NULL, '291-555-8656', NULL, NULL, NULL, 'www.azari-dabittelecommunications,ltd.com', NULL, NULL, NULL, NULL, '9476 Hill Top Rd.', 'Sooke', 'BC', '19932', 'Canada', 0);
INSERT INTO accounts VALUES ('1e493e94-354d-d36a-f996-438dfb1616f5', '2005-11-30 19:19:21', '2005-11-30 19:19:21', '1', 'sally_id', '1', 'D & A Carmona Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '9263 Mt. McKinley Ct.', 'Sooke', 'BC', '22047', 'Canada', NULL, NULL, '541-555-6035', NULL, NULL, NULL, 'www.dacarmonamachinerygroup.com', NULL, NULL, NULL, NULL, '9263 Mt. McKinley Ct.', 'Sooke', 'BC', '22047', 'Canada', 0);
INSERT INTO accounts VALUES ('491c4d19-fbdd-d1dd-89a2-438dfb782d21', '2005-11-30 19:19:21', '2005-11-30 19:19:21', '1', 'max_id', '1', 'Carmona-Saxton Construction Associates', NULL, 'Consulting', 'Construction', NULL, NULL, '620 Woodside Ct.', 'Altadena', 'CA', '38565', 'USA', NULL, NULL, '330-555-4138', NULL, NULL, NULL, 'www.carmona-saxtonconstructionassociates.com', NULL, NULL, NULL, NULL, '620 Woodside Ct.', 'Altadena', 'CA', '38565', 'USA', 0);
INSERT INTO accounts VALUES ('75f3c5be-eb04-4dcb-14ce-438dfb5a878c', '2005-11-30 19:19:21', '2005-11-30 19:19:21', '1', 'max_id', '1', 'D & Z McLaughlin Electronics, Ltd', NULL, 'Consulting', 'Electronics', NULL, NULL, '661 Miller Ave.', 'Burnaby', 'BC', '68422', 'Canada', NULL, NULL, '602-555-9145', NULL, NULL, NULL, 'www.dzmclaughlinelectronics,ltd.com', NULL, NULL, NULL, NULL, '661 Miller Ave.', 'Burnaby', 'BC', '68422', 'Canada', 0);
INSERT INTO accounts VALUES ('9b726ecd-688f-c61a-a444-438dfb218fd1', '2005-11-30 19:19:21', '2005-11-30 19:19:21', '1', 'kristen_id', '1', 'McLaughlin-Eyster Engineering Corp', NULL, 'Consulting', 'Engineering', NULL, NULL, '1648 Eastgate Lane', 'Albany', 'OR', '62230', 'USA', NULL, NULL, '960-555-9038', NULL, NULL, NULL, 'www.mclaughlin-eysterengineeringcorp.com', NULL, NULL, NULL, NULL, '1648 Eastgate Lane', 'Albany', 'OR', '62230', 'USA', 0);
INSERT INTO accounts VALUES ('c8bc538e-0714-e8c1-94bb-438dfb137c7a', '2005-11-30 19:19:21', '2005-11-30 19:19:21', '1', 'will_id', '1', 'Q & Q Henry Telecommunications Associates', NULL, 'Supply', 'Telecommunications', NULL, NULL, '4598 Manila Avenue', 'Bremerton', 'WA', '95667', 'USA', NULL, NULL, '356-555-3673', NULL, NULL, NULL, 'www.qqhenrytelecommunicationsassociates.com', NULL, NULL, NULL, NULL, '4598 Manila Avenue', 'Bremerton', 'WA', '95667', 'USA', 0);
INSERT INTO accounts VALUES ('59fb0e8f-dc34-a05a-0f81-438dfba3c7a8', '2005-11-30 19:19:22', '2005-11-30 19:19:22', '1', 'max_id', '1', 'Henry-Barros Engineering Company', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '3183 Trasher Road', 'N. Vancouver', 'BC', '18218', 'Canada', NULL, NULL, '737-555-2195', NULL, NULL, NULL, 'www.henry-barrosengineeringcompany.com', NULL, NULL, NULL, NULL, '3183 Trasher Road', 'N. Vancouver', 'BC', '18218', 'Canada', 0);
INSERT INTO accounts VALUES ('3389b370-a721-0e58-e2b2-438dfbcbdd37', '2005-11-30 19:19:22', '2005-11-30 19:19:22', '1', 'matt_id', '1', 'Y & R Groome Machinery, Inc', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '6387 Scenic Avenue', 'Milwaukie', 'OR', '17817', 'USA', NULL, NULL, '634-555-2773', NULL, NULL, NULL, 'www.yrgroomemachinery,inc.com', NULL, NULL, NULL, NULL, '6387 Scenic Avenue', 'Milwaukie', 'OR', '17817', 'USA', 0);
INSERT INTO accounts VALUES ('5b65bb26-ee94-0741-e6d7-438dfb27d784', '2005-11-30 19:19:22', '2005-11-30 19:19:22', '1', 'sarah_id', '1', 'Groome-Hill Engineering, Inc', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '7883 Mitchell Canyon Court', 'Santa Monica', 'CA', '55288', 'USA', NULL, NULL, '137-555-8923', NULL, NULL, NULL, 'www.groome-hillengineering,inc.com', NULL, NULL, NULL, NULL, '7883 Mitchell Canyon Court', 'Santa Monica', 'CA', '55288', 'USA', 0);
INSERT INTO accounts VALUES ('8c5d0a27-943d-83f0-15a5-438dfba33bc3', '2005-11-30 19:19:22', '2005-11-30 19:19:22', '1', 'kristen_id', '1', 'E & F Williams Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '3997 Via De Luna', 'Walla Walla', 'WA', '70289', 'USA', NULL, NULL, '718-555-4473', NULL, NULL, NULL, 'www.efwilliamsmachinery,ltd.com', NULL, NULL, NULL, NULL, '3997 Via De Luna', 'Walla Walla', 'WA', '70289', 'USA', 0);
INSERT INTO accounts VALUES ('b9492cd8-4a97-892c-c9c3-438dfb201fab', '2005-11-30 19:19:22', '2005-11-30 19:19:22', '1', 'chris_id', '1', 'Williams-Masters Transportation Holdings', NULL, 'Distribution', 'Transportation', NULL, NULL, '5747 Shirley Drive', 'Richmond', 'CA', '24162', 'USA', NULL, NULL, '483-555-3909', NULL, NULL, NULL, 'www.williams-masterstransportationholdings.com', NULL, NULL, NULL, NULL, '5747 Shirley Drive', 'Richmond', 'CA', '24162', 'USA', 0);
INSERT INTO accounts VALUES ('df0f0986-f65e-d456-1351-438dfb44de21', '2005-11-30 19:19:22', '2005-11-30 19:19:22', '1', 'will_id', '1', 'N & O Brady, Jr. Electronics, Inc', NULL, 'Supply', 'Electronics', NULL, NULL, '2115 Pasado', 'Oakland', 'CA', '55084', 'USA', NULL, NULL, '426-555-1745', NULL, NULL, NULL, 'www.nobrady,jrelectronics,inc.com', NULL, NULL, NULL, NULL, '2115 Pasado', 'Oakland', 'CA', '55084', 'USA', 0);
INSERT INTO accounts VALUES ('145df113-5365-45fa-ebe7-438dfbbd5844', '2005-11-30 19:19:23', '2005-11-30 19:19:23', '1', 'kristen_id', '1', 'Brady, Jr.-Gray Machinery Group', NULL, 'Distribution', 'Machinery', NULL, NULL, '6774 Bonanza', 'Bellflower', 'CA', '20209', 'USA', NULL, NULL, '214-555-8809', NULL, NULL, NULL, 'www.brady,jr-graymachinerygroup.com', NULL, NULL, NULL, NULL, '6774 Bonanza', 'Bellflower', 'CA', '20209', 'USA', 0);
INSERT INTO accounts VALUES ('47f16a6f-0237-ee14-c676-438dfb83235d', '2005-11-30 19:19:23', '2005-11-30 19:19:23', '1', 'beth_id', '1', 'U & W Fielder Construction Corp', NULL, 'Supply', 'Construction', NULL, NULL, '3397 Rancho View Drive', 'Ballard', 'WA', '90000', 'USA', NULL, NULL, '179-555-5273', NULL, NULL, NULL, 'www.uwfielderconstructioncorp.com', NULL, NULL, NULL, NULL, '3397 Rancho View Drive', 'Ballard', 'WA', '90000', 'USA', 0);
INSERT INTO accounts VALUES ('756fbb6a-6aa6-3de0-15da-438dfbe81403', '2005-11-30 19:19:23', '2005-11-30 19:19:23', '1', 'max_id', '1', 'Fielder-Finnell Electronics Company', NULL, 'Consulting', 'Electronics', NULL, NULL, '8310 Ridge Circle', 'Everett', 'WA', '75196', 'USA', NULL, NULL, '103-555-4226', NULL, NULL, NULL, 'www.fielder-finnellelectronicscompany.com', NULL, NULL, NULL, NULL, '8310 Ridge Circle', 'Everett', 'WA', '75196', 'USA', 0);
INSERT INTO accounts VALUES ('a306a41f-d08d-9f88-7e78-438dfbb3dbf4', '2005-11-30 19:19:23', '2005-11-30 19:19:23', '1', 'chris_id', '1', 'M & K Schuetz Telecommunications, Ltd', NULL, 'Supply', 'Telecommunications', NULL, NULL, '7842 Ygnacio Valley Road', 'Salem', 'OR', '12150', 'USA', NULL, NULL, '330-555-2976', NULL, NULL, NULL, 'www.mkschuetztelecommunications,ltd.com', NULL, NULL, NULL, NULL, '7842 Ygnacio Valley Road', 'Salem', 'OR', '12150', 'USA', 0);
INSERT INTO accounts VALUES ('d0aa1c58-ab79-3669-d1e3-438dfb7eb918', '2005-11-30 19:19:23', '2005-11-30 19:19:23', '1', 'sarah_id', '1', 'Schuetz-Runyon Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '5666 Hazelnut Lane', 'Concord', 'CA', '62507', 'USA', NULL, NULL, '403-555-1955', NULL, NULL, NULL, 'www.schuetz-runyonmachinery,ltd.com', NULL, NULL, NULL, NULL, '5666 Hazelnut Lane', 'Concord', 'CA', '62507', 'USA', 0);
INSERT INTO accounts VALUES ('61c904f0-7a9d-bd79-1c3c-438dfb588f82', '2005-11-30 19:19:24', '2005-11-30 19:19:24', '1', 'beth_id', '1', 'L & E Potter Communications Partners', NULL, 'Distribution', 'Communications', NULL, NULL, '5452 Corte Gilberto', 'Concord', 'CA', '64622', 'USA', NULL, NULL, '653-555-8333', NULL, NULL, NULL, 'www.lepottercommunicationspartners.com', NULL, NULL, NULL, NULL, '5452 Corte Gilberto', 'Concord', 'CA', '64622', 'USA', 0);
INSERT INTO accounts VALUES ('2b9828bf-e533-2198-b512-438dfb8d5bce', '2005-11-30 19:19:24', '2005-11-30 19:19:24', '1', 'sally_id', '1', 'Potter-Smith Construction Holdings', NULL, 'Consulting', 'Construction', NULL, NULL, '874 Olivera Road', 'La Jolla', 'CA', '54848', 'USA', NULL, NULL, '749-555-5940', NULL, NULL, NULL, 'www.potter-smithconstructionholdings.com', NULL, NULL, NULL, NULL, '874 Olivera Road', 'La Jolla', 'CA', '54848', 'USA', 0);
INSERT INTO accounts VALUES ('5348b563-0622-42d3-71ba-438dfb807b3f', '2005-11-30 19:19:24', '2005-11-30 19:19:24', '1', 'kristen_id', '1', 'W & N Brumagen Telecommunications Partners', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '3570 Court Lane', 'Cliffside', 'BC', '23125', 'Canada', NULL, NULL, '122-555-1947', NULL, NULL, NULL, 'www.wnbrumagentelecommunicationspartners.com', NULL, NULL, NULL, NULL, '3570 Court Lane', 'Cliffside', 'BC', '23125', 'Canada', 0);
INSERT INTO accounts VALUES ('860964ee-8fd8-a620-ec96-438dfbf111c3', '2005-11-30 19:19:24', '2005-11-30 19:19:24', '1', 'sally_id', '1', 'Brumagen-Hamilton Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '1902 Santa Cruz', 'Burbank', 'CA', '58058', 'USA', NULL, NULL, '480-555-1840', NULL, NULL, NULL, 'www.brumagen-hamiltontransportationholdings.com', NULL, NULL, NULL, NULL, '1902 Santa Cruz', 'Burbank', 'CA', '58058', 'USA', 0);
INSERT INTO accounts VALUES ('ab505e26-a5cc-8535-2e96-438dfb5e4452', '2005-11-30 19:19:24', '2005-11-30 19:19:24', '1', 'beth_id', '1', 'V & A J Wilbert Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '4852 Chaparral Court', 'Spokane', 'WA', '39243', 'USA', NULL, NULL, '115-555-9133', NULL, NULL, NULL, 'www.vajwilberttransportationcorp.com', NULL, NULL, NULL, NULL, '4852 Chaparral Court', 'Spokane', 'WA', '39243', 'USA', 0);
INSERT INTO accounts VALUES ('d53a7082-2cca-4184-26df-438dfb8a9e29', '2005-11-30 19:19:24', '2005-11-30 19:19:24', '1', 'max_id', '1', 'J Wilbert-Ingram Communications Corp', NULL, 'Consulting', 'Communications', NULL, NULL, '6093 Midway Ct.', 'Tixapan', 'DF', '60792', 'Mexico', NULL, NULL, '257-555-3997', NULL, NULL, NULL, 'www.jwilbert-ingramcommunicationscorp.com', NULL, NULL, NULL, NULL, '6093 Midway Ct.', 'Tixapan', 'DF', '60792', 'Mexico', 0);
INSERT INTO accounts VALUES ('683501c7-529b-869a-5687-438dfb04ab8b', '2005-11-30 19:19:25', '2005-11-30 19:19:25', '1', 'sally_id', '1', 'T & A Haddix Electronics, Inc', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '9297 Kenston Dr.', 'Lynnwood', 'WA', '60392', 'USA', NULL, NULL, '153-555-4576', NULL, NULL, NULL, 'www.tahaddixelectronics,inc.com', NULL, NULL, NULL, NULL, '9297 Kenston Dr.', 'Lynnwood', 'WA', '60392', 'USA', 0);
INSERT INTO accounts VALUES ('2c46c77e-e5a7-5cc1-6df7-438dfb2e201c', '2005-11-30 19:19:25', '2005-11-30 19:19:25', '1', 'matt_id', '1', 'Haddix-Thomas Construction Associates', NULL, 'Manufacturing', 'Construction', NULL, NULL, '793 Crawford Street', 'Newport Beach', 'CA', '48103', 'USA', NULL, NULL, '557-555-1726', NULL, NULL, NULL, 'www.haddix-thomasconstructionassociates.com', NULL, NULL, NULL, NULL, '793 Crawford Street', 'Newport Beach', 'CA', '48103', 'USA', 0);
INSERT INTO accounts VALUES ('589ab56c-b842-1e39-fa69-438dfb3c55d5', '2005-11-30 19:19:25', '2005-11-30 19:19:25', '1', 'chris_id', '1', 'D & D Wilson Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '4251 San Onofre Court', 'Oak Bay', 'BC', '13864', 'Canada', NULL, NULL, '238-555-6276', NULL, NULL, NULL, 'www.ddwilsonelectronicsholdings.com', NULL, NULL, NULL, NULL, '4251 San Onofre Court', 'Oak Bay', 'BC', '13864', 'Canada', 0);
INSERT INTO accounts VALUES ('7e48a579-8198-83c2-3e93-438dfbb37fa2', '2005-11-30 19:19:25', '2005-11-30 19:19:25', '1', 'sarah_id', '1', 'Wilson-Stovall Machinery, Inc', NULL, 'Distribution', 'Machinery', NULL, NULL, '8656 Lakespring Place', 'Coronado', 'CA', '66736', 'USA', NULL, NULL, '593-555-6287', NULL, NULL, NULL, 'www.wilson-stovallmachinery,inc.com', NULL, NULL, NULL, NULL, '8656 Lakespring Place', 'Coronado', 'CA', '66736', 'USA', 0);
INSERT INTO accounts VALUES ('a3ae5ce7-97f3-0767-2c32-438dfb67ba2f', '2005-11-30 19:19:25', '2005-11-30 19:19:25', '1', 'sally_id', '1', 'I & V Russell Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '5025 Holiday Hills', 'La Mesa', 'CA', '71367', 'USA', NULL, NULL, '536-555-4122', NULL, NULL, NULL, 'www.ivrussellengineering,inc.com', NULL, NULL, NULL, NULL, '5025 Holiday Hills', 'La Mesa', 'CA', '71367', 'USA', 0);
INSERT INTO accounts VALUES ('d3341561-6269-a089-3222-438dfbd74426', '2005-11-30 19:19:25', '2005-11-30 19:19:25', '1', 'beth_id', '1', 'Russell-Doose Construction, Ltd', NULL, 'Manufacturing', 'Construction', NULL, NULL, '7028 San Gabriel Dr.', 'Santa Anita', 'DF', '90401', 'Mexico', NULL, NULL, '324-555-2187', NULL, NULL, NULL, 'www.russell-dooseconstruction,ltd.com', NULL, NULL, NULL, NULL, '7028 San Gabriel Dr.', 'Santa Anita', 'DF', '90401', 'Mexico', 0);
INSERT INTO accounts VALUES ('99540248-a633-5eab-e014-438dfbbb6d0d', '2005-11-30 19:19:26', '2005-11-30 19:19:26', '1', 'matt_id', '1', 'K & R Morreale Communications Group', NULL, 'Consulting', 'Communications', NULL, NULL, '6307 Grenadine Way', 'Renton', 'WA', '84255', 'USA', NULL, NULL, '289-555-7651', NULL, NULL, NULL, 'www.krmorrealecommunicationsgroup.com', NULL, NULL, NULL, NULL, '6307 Grenadine Way', 'Renton', 'WA', '84255', 'USA', 0);
INSERT INTO accounts VALUES ('3e8c7862-6b2a-0824-ec19-438dfb18f048', '2005-11-30 19:19:26', '2005-11-30 19:19:26', '1', 'jaime_id', '1', 'Morreale-Rupert Engineering Associates', NULL, 'Distribution', 'Engineering', NULL, NULL, '1220 Bradford Way', 'Glendale', 'CA', '69451', 'USA', NULL, NULL, '101-555-4344', NULL, NULL, NULL, 'www.morreale-rupertengineeringassociates.com', NULL, NULL, NULL, NULL, '1220 Bradford Way', 'Glendale', 'CA', '69451', 'USA', 0);
INSERT INTO accounts VALUES ('6b74ee4d-f2e1-c581-dd78-438dfb730c7e', '2005-11-30 19:19:26', '2005-11-30 19:19:26', '1', 'max_id', '1', 'B & P Pierson Telecommunications Holdings', NULL, 'Distribution', 'Telecommunications', NULL, NULL, '1999 Orangewood Court', 'Westminster', 'BC', '32697', 'Canada', NULL, NULL, '328-555-3094', NULL, NULL, NULL, 'www.bppiersontelecommunicationsholdings.com', NULL, NULL, NULL, NULL, '1999 Orangewood Court', 'Westminster', 'BC', '32697', 'Canada', 0);
INSERT INTO accounts VALUES ('9b5b10ca-e088-dfb3-7bd6-438dfb9f4ae9', '2005-11-30 19:19:26', '2005-11-30 19:19:26', '1', 'kristen_id', '1', 'Pierson-Nickels Electronics, Ltd', NULL, 'Distribution', 'Electronics', NULL, NULL, '9821 Juniper Drive', 'Victoria', 'BC', '56762', 'Canada', NULL, NULL, '401-555-2072', NULL, NULL, NULL, 'www.pierson-nickelselectronics,ltd.com', NULL, NULL, NULL, NULL, '9821 Juniper Drive', 'Victoria', 'BC', '56762', 'Canada', 0);
INSERT INTO accounts VALUES ('cb6a9a32-58b5-580b-d07f-438dfb32eafe', '2005-11-30 19:19:26', '2005-11-30 19:19:26', '1', 'chris_id', '1', 'Q & P Neuhauser Telecommunications Company', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, '9608 Grammercy Lane', 'Victoria', 'BC', '58876', 'Canada', NULL, NULL, '651-555-8451', NULL, NULL, NULL, 'www.qpneuhausertelecommunicationscompany.com', NULL, NULL, NULL, NULL, '9608 Grammercy Lane', 'Victoria', 'BC', '58876', 'Canada', 0);
INSERT INTO accounts VALUES ('1221a978-b701-cc79-29b4-438dfb27ec07', '2005-11-30 19:19:27', '2005-11-30 19:19:27', '1', 'beth_id', '1', 'Neuhauser-Coke Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '7685 Imperial Dr', 'Sooke', 'BC', '75395', 'Canada', NULL, NULL, '747-555-6058', NULL, NULL, NULL, 'www.neuhauser-coketransportationholdings.com', NULL, NULL, NULL, NULL, '7685 Imperial Dr', 'Sooke', 'BC', '75395', 'Canada', 0);
INSERT INTO accounts VALUES ('42b754c8-dfad-6eaf-cbe5-438dfb050c30', '2005-11-30 19:19:27', '2005-11-30 19:19:27', '1', 'kristen_id', '1', 'G & N Scarbrough Communications Group', NULL, 'Supply', 'Communications', NULL, NULL, '7726 Driftwood Drive', 'Kirkland', 'WA', '43672', 'USA', NULL, NULL, '120-555-2065', NULL, NULL, NULL, 'www.gnscarbroughcommunicationsgroup.com', NULL, NULL, NULL, NULL, '7726 Driftwood Drive', 'Kirkland', 'WA', '43672', 'USA', 0);
INSERT INTO accounts VALUES ('6aa69a70-12fe-e914-688b-438dfb971562', '2005-11-30 19:19:27', '2005-11-30 19:19:27', '1', 'kristen_id', '1', 'Scarbrough-Martensen Construction Partners', NULL, 'Distribution', 'Construction', NULL, NULL, '8713 Yosemite Ct.', 'Chula Vista', 'CA', '26352', 'USA', NULL, NULL, '478-555-1958', NULL, NULL, NULL, 'www.scarbrough-martensenconstructionpartners.com', NULL, NULL, NULL, NULL, '8713 Yosemite Ct.', 'Chula Vista', 'CA', '26352', 'USA', 0);
INSERT INTO accounts VALUES ('a0e7ad4b-b177-b914-da9c-438dfbda815f', '2005-11-30 19:19:27', '2005-11-30 19:19:27', '1', 'kristen_id', '1', 'H & Y McCormick Electronics, Ltd', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '9008 Creekside Drive', 'Seattle', 'WA', '33498', 'USA', NULL, NULL, '113-555-9251', NULL, NULL, NULL, 'www.hymccormickelectronics,ltd.com', NULL, NULL, NULL, NULL, '9008 Creekside Drive', 'Seattle', 'WA', '33498', 'USA', 0);
INSERT INTO accounts VALUES ('c6632abb-10b1-66c3-3525-438dfb4119f5', '2005-11-30 19:19:27', '2005-11-30 19:19:27', '1', 'chris_id', '1', 'McCormick-Sparacino Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '250 Geary Ct.', 'San Jose', 'CA', '81339', 'USA', NULL, NULL, '606-555-1032', NULL, NULL, NULL, 'www.mccormick-sparacinotransportationholdings.com', NULL, NULL, NULL, NULL, '250 Geary Ct.', 'San Jose', 'CA', '81339', 'USA', 0);
INSERT INTO accounts VALUES ('f1b68c60-fd88-d531-9e4c-438dfb9d470d', '2005-11-30 19:19:27', '2005-11-30 19:19:27', '1', 'sarah_id', '1', 'O & K Racette Transportation Corp', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '3454 D Bel Air Drive', 'Ballard', 'WA', '54647', 'USA', NULL, NULL, '263-555-6954', NULL, NULL, NULL, 'www.okracettetransportationcorp.com', NULL, NULL, NULL, NULL, '3454 D Bel Air Drive', 'Ballard', 'WA', '54647', 'USA', 0);
INSERT INTO accounts VALUES ('28f75af4-5123-7550-243f-438dfb8ddf01', '2005-11-30 19:19:28', '2005-11-30 19:19:28', '1', 'beth_id', '1', 'Racette-Thompson Construction Partners', NULL, 'Consulting', 'Construction', NULL, NULL, '4949 Dutch Slough Rd', 'Guadalajara', 'Jalisco', '68650', 'Mexico', NULL, NULL, '667-555-4104', NULL, NULL, NULL, 'www.racette-thompsonconstructionpartners.com', NULL, NULL, NULL, NULL, '4949 Dutch Slough Rd', 'Guadalajara', 'Jalisco', '68650', 'Mexico', 0);
INSERT INTO accounts VALUES ('51066781-1ec3-3fe8-7322-438dfbd99b65', '2005-11-30 19:19:28', '2005-11-30 19:19:28', '1', 'sally_id', '1', 'D & D Warren Transportation, Ltd', NULL, 'Distribution', 'Transportation', NULL, NULL, '1064 Slavio', 'Lebanon', 'OR', '81192', 'USA', NULL, NULL, '587-555-3311', NULL, NULL, NULL, 'www.ddwarrentransportation,ltd.com', NULL, NULL, NULL, NULL, '1064 Slavio', 'Lebanon', 'OR', '81192', 'USA', 0);
INSERT INTO accounts VALUES ('827f20ff-6ccb-df5c-4492-438dfb56d80b', '2005-11-30 19:19:28', '2005-11-30 19:19:28', '1', 'kristen_id', '1', 'Warren-Chow-Wang Machinery, Inc', NULL, 'Consulting', 'Machinery', NULL, NULL, '2813 Dew Drop Circle', 'Port Hammond', 'BC', '60991', 'Canada', NULL, NULL, '113-555-8089', NULL, NULL, NULL, 'www.warren-chow-wangmachinery,inc.com', NULL, NULL, NULL, NULL, '2813 Dew Drop Circle', 'Port Hammond', 'BC', '60991', 'Canada', 0);
INSERT INTO accounts VALUES ('ae0caf82-6b91-edcd-ac34-438dfbcae84b', '2005-11-30 19:19:28', '2005-11-30 19:19:28', '1', 'beth_id', '1', 'E & M Wood Electronics Company', NULL, 'Supply', 'Electronics', NULL, NULL, '9181 La Vista Circle', 'Sooke', 'BC', '91914', 'Canada', NULL, NULL, '956-555-5925', NULL, NULL, NULL, 'www.emwoodelectronicscompany.com', NULL, NULL, NULL, NULL, '9181 La Vista Circle', 'Sooke', 'BC', '91914', 'Canada', 0);
INSERT INTO accounts VALUES ('d97a4b11-78d3-b9d3-7024-438dfbf6028a', '2005-11-30 19:19:28', '2005-11-30 19:19:28', '1', 'matt_id', '1', 'Wood-Morgan Engineering, Ltd', NULL, 'Distribution', 'Engineering', NULL, NULL, '3841 Silver Oaks Place', 'La Mesa', 'CA', '11949', 'USA', NULL, NULL, '744-555-3989', NULL, NULL, NULL, 'www.wood-morganengineering,ltd.com', NULL, NULL, NULL, NULL, '3841 Silver Oaks Place', 'La Mesa', 'CA', '11949', 'USA', 0);
INSERT INTO accounts VALUES ('16eb4b2a-a495-ed33-7f2c-438dfb73ede3', '2005-11-30 19:19:29', '2005-11-30 19:19:29', '1', 'matt_id', '1', 'R & Z Boje Communications, Inc', NULL, 'Distribution', 'Communications', NULL, NULL, '463 H Stagecoach Rd.', 'Tacoma', 'WA', '81740', 'USA', NULL, NULL, '709-555-9453', NULL, NULL, NULL, 'www.rzbojecommunications,inc.com', NULL, NULL, NULL, NULL, '463 H Stagecoach Rd.', 'Tacoma', 'WA', '81740', 'USA', 0);
INSERT INTO accounts VALUES ('4ad0c452-7b48-f49a-70a1-438dfb731561', '2005-11-30 19:19:29', '2005-11-30 19:19:29', '1', 'chris_id', '1', 'Boje-Tsujimoto Machinery Partners', NULL, 'Supply', 'Machinery', NULL, NULL, '5376 Catanzaro Way', 'Milwaukie', 'OR', '12447', 'USA', NULL, NULL, '760-555-9804', NULL, NULL, NULL, 'www.boje-tsujimotomachinerypartners.com', NULL, NULL, NULL, NULL, '5376 Catanzaro Way', 'Milwaukie', 'OR', '12447', 'USA', 0);
INSERT INTO accounts VALUES ('709024ac-3d9e-e75a-0885-438dfb820403', '2005-11-30 19:19:29', '2005-11-30 19:19:29', '1', 'sarah_id', '1', 'J & K Bouton Communications Corp', NULL, 'Supply', 'Communications', NULL, NULL, '4909 Poco Lane', 'Renton', 'WA', '48400', 'USA', NULL, NULL, '748-555-4896', NULL, NULL, NULL, 'www.jkboutoncommunicationscorp.com', NULL, NULL, NULL, NULL, '4909 Poco Lane', 'Renton', 'WA', '48400', 'USA', 0);
INSERT INTO accounts VALUES ('9c5ee206-33e1-c7be-2e44-438dfbcfc3a3', '2005-11-30 19:19:29', '2005-11-30 19:19:29', '1', 'sally_id', '1', 'Bouton-Gras Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '77 Birchwood', 'Grossmont', 'CA', '98756', 'USA', NULL, NULL, '821-555-3875', NULL, NULL, NULL, 'www.bouton-grasconstruction,ltd.com', NULL, NULL, NULL, NULL, '77 Birchwood', 'Grossmont', 'CA', '98756', 'USA', 0);
INSERT INTO accounts VALUES ('c80dea92-93bd-414c-7d12-438dfbe287a0', '2005-11-30 19:19:29', '2005-11-30 19:19:29', '1', 'max_id', '1', 'W & W Solano Electronics Associates', NULL, 'Supply', 'Electronics', NULL, NULL, '9862 Ahneita Dr.', 'Ladner', 'BC', '18729', 'Canada', NULL, NULL, '171-555-1254', NULL, NULL, NULL, 'www.wwsolanoelectronicsassociates.com', NULL, NULL, NULL, NULL, '9862 Ahneita Dr.', 'Ladner', 'BC', '18729', 'Canada', 0);
INSERT INTO accounts VALUES ('cadd0934-23c0-fc21-697f-438dfbfc60c0', '2005-11-30 19:19:30', '2005-11-30 19:19:30', '1', 'max_id', '1', 'Solano-Armstrong Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '7939 Bayview Court', 'Los Angeles', 'CA', '18391', 'USA', NULL, NULL, '267-555-7861', NULL, NULL, NULL, 'www.solano-armstrongmachinerygroup.com', NULL, NULL, NULL, NULL, '7939 Bayview Court', 'Los Angeles', 'CA', '18391', 'USA', 0);
INSERT INTO accounts VALUES ('322e401c-c694-0233-da27-438dfb2436c5', '2005-11-30 19:19:30', '2005-11-30 19:19:30', '1', 'beth_id', '1', 'D & G Aldred Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '636 Vine Hill Way', 'Coronado', 'CA', '85666', 'USA', NULL, NULL, '466-555-8179', NULL, NULL, NULL, 'www.dgaldredtransportation,inc.com', NULL, NULL, NULL, NULL, '636 Vine Hill Way', 'Coronado', 'CA', '85666', 'USA', 0);
INSERT INTO accounts VALUES ('6052c1a5-b3da-6061-5b1a-438dfbf123ea', '2005-11-30 19:19:30', '2005-11-30 19:19:30', '1', 'matt_id', '1', 'Aldred-Jorgenson Engineering, Ltd', NULL, 'Supply', 'Engineering', NULL, NULL, '8967 Hamilton Ave.', 'Milwaukie', 'OR', '42055', 'USA', NULL, NULL, '585-555-4415', NULL, NULL, NULL, 'www.aldred-jorgensonengineering,ltd.com', NULL, NULL, NULL, NULL, '8967 Hamilton Ave.', 'Milwaukie', 'OR', '42055', 'USA', 0);
INSERT INTO accounts VALUES ('85ee0e3f-0406-f066-bfe7-438dfb3e0803', '2005-11-30 19:19:30', '2005-11-30 19:19:30', '1', 'jaime_id', '1', 'Z & L Turner Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '1918 Terra Granada', 'Oak Bay', 'BC', '75493', 'Canada', NULL, NULL, '220-555-2708', NULL, NULL, NULL, 'www.zlturnerconstruction,ltd.com', NULL, NULL, NULL, NULL, '1918 Terra Granada', 'Oak Bay', 'BC', '75493', 'Canada', 0);
INSERT INTO accounts VALUES ('b2bfa84e-a0ac-6463-92be-438dfbaed94a', '2005-11-30 19:19:30', '2005-11-30 19:19:30', '1', 'will_id', '1', 'Turner-Zakerski Transportation Group', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '504 O St.', 'Lemon Grove', 'CA', '97042', 'USA', NULL, NULL, '601-555-1229', NULL, NULL, NULL, 'www.turner-zakerskitransportationgroup.com', NULL, NULL, NULL, NULL, '504 O St.', 'Lemon Grove', 'CA', '97042', 'USA', 0);
INSERT INTO accounts VALUES ('d84cc26b-f46c-10fd-4f62-438dfb4edfa7', '2005-11-30 19:19:30', '2005-11-30 19:19:30', '1', 'max_id', '1', 'V & P Carlson Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '3708 Montana', 'Walla Walla', 'WA', '96641', 'USA', NULL, NULL, '259-555-7150', NULL, NULL, NULL, 'www.vpcarlsontransportationcorp.com', NULL, NULL, NULL, NULL, '3708 Montana', 'Walla Walla', 'WA', '96641', 'USA', 0);
INSERT INTO accounts VALUES ('1ef0046a-4960-119d-3483-438dfb613ed1', '2005-11-30 19:19:31', '2005-11-30 19:19:31', '1', 'will_id', '1', 'Carlson-Symons Telecommunications, Inc', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '5203 Virginia Lane', 'Lebanon', 'OR', '84353', 'USA', NULL, NULL, '662-555-4300', NULL, NULL, NULL, 'www.carlson-symonstelecommunications,inc.com', NULL, NULL, NULL, NULL, '5203 Virginia Lane', 'Lebanon', 'OR', '84353', 'USA', 0);
INSERT INTO accounts VALUES ('54cfcff9-db3f-3b0d-be97-438dfbe302c0', '2005-11-30 19:19:31', '2005-11-30 19:19:31', '1', 'matt_id', '1', 'F & X Reynolds Communications Partners', NULL, 'Consulting', 'Communications', NULL, NULL, '1318 Lasalle Street', 'Los Angeles', 'CA', '50114', 'USA', NULL, NULL, '582-555-3508', NULL, NULL, NULL, 'www.fxreynoldscommunicationspartners.com', NULL, NULL, NULL, NULL, '1318 Lasalle Street', 'Los Angeles', 'CA', '50114', 'USA', 0);
INSERT INTO accounts VALUES ('8327ec22-ad12-cd30-c238-438dfb0571e1', '2005-11-30 19:19:31', '2005-11-30 19:19:31', '1', 'sally_id', '1', 'Reynolds-Ibsen Communications Holdings', NULL, 'Distribution', 'Communications', NULL, NULL, '3067 Maya', 'Downey', 'CA', '39870', 'USA', NULL, NULL, '108-555-8286', NULL, NULL, NULL, 'www.reynolds-ibsencommunicationsholdings.com', NULL, NULL, NULL, NULL, '3067 Maya', 'Downey', 'CA', '39870', 'USA', 0);
INSERT INTO accounts VALUES ('afc2a69b-8290-5e45-403f-438dfbb1b556', '2005-11-30 19:19:31', '2005-11-30 19:19:31', '1', 'sarah_id', '1', 'S & X Ciochon Engineering Partners', NULL, 'Distribution', 'Engineering', NULL, NULL, '9435 Breck Court', 'West Covina', 'CA', '86178', 'USA', NULL, NULL, '951-555-6122', NULL, NULL, NULL, 'www.sxciochonengineeringpartners.com', NULL, NULL, NULL, NULL, '9435 Breck Court', 'West Covina', 'CA', '86178', 'USA', 0);
INSERT INTO accounts VALUES ('d5753872-c4a2-ab13-81c2-438dfbae0c3a', '2005-11-30 19:19:31', '2005-11-30 19:19:31', '1', 'sarah_id', '1', 'Ciochon-Berger Transportation, Inc', NULL, 'Supply', 'Transportation', NULL, NULL, '4095 Cooper Dr.', 'Bellingham', 'WA', '27651', 'USA', NULL, NULL, '739-555-4186', NULL, NULL, NULL, 'www.ciochon-bergertransportation,inc.com', NULL, NULL, NULL, NULL, '4095 Cooper Dr.', 'Bellingham', 'WA', '27651', 'USA', 0);
INSERT INTO accounts VALUES ('1c670ba7-7180-c746-7a2e-438dfb331ea2', '2005-11-30 19:19:32', '2005-11-30 19:19:32', '1', 'sarah_id', '1', 'H & N Bayol Machinery Corp', NULL, 'Supply', 'Machinery', NULL, NULL, '5242 Marvelle Ln.', 'San Carlos', 'CA', '24735', 'USA', NULL, NULL, '704-555-9650', NULL, NULL, NULL, 'www.hnbayolmachinerycorp.com', NULL, NULL, NULL, NULL, '5242 Marvelle Ln.', 'San Carlos', 'CA', '24735', 'USA', 0);
INSERT INTO accounts VALUES ('52c17774-4f45-6c9b-31b1-438dfb100ff3', '2005-11-30 19:19:32', '2005-11-30 19:19:32', '1', 'will_id', '1', 'Bayol-Thumann Machinery Associates', NULL, 'Supply', 'Machinery', NULL, NULL, '2812 East Lake Court', 'Metchosin', 'BC', '99312', 'Canada', NULL, NULL, '755-555-1000', NULL, NULL, NULL, 'www.bayol-thumannmachineryassociates.com', NULL, NULL, NULL, NULL, '2812 East Lake Court', 'Metchosin', 'BC', '99312', 'Canada', 0);
INSERT INTO accounts VALUES ('78c4ec52-4f79-ce55-3a17-438dfb858894', '2005-11-30 19:19:32', '2005-11-30 19:19:32', '1', 'max_id', '1', 'G & W Jones Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '9687 Shakespeare Drive', 'Concord', 'CA', '44269', 'USA', NULL, NULL, '855-555-7353', NULL, NULL, NULL, 'www.gwjonestransportation,inc.com', NULL, NULL, NULL, NULL, '9687 Shakespeare Drive', 'Concord', 'CA', '44269', 'USA', 0);
INSERT INTO accounts VALUES ('ad155aa3-a8e4-85f8-3f49-438dfb1b1044', '2005-11-30 19:19:32', '2005-11-30 19:19:32', '1', 'matt_id', '1', 'Jones-Bury Machinery Corp', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '7511 Cooper Dr.', 'Corvallis', 'OR', '94626', 'USA', NULL, NULL, '928-555-6332', NULL, NULL, NULL, 'www.jones-burymachinerycorp.com', NULL, NULL, NULL, NULL, '7511 Cooper Dr.', 'Corvallis', 'OR', '94626', 'USA', 0);
INSERT INTO accounts VALUES ('db14c64c-910d-69f7-4363-438dfb060df3', '2005-11-30 19:19:32', '2005-11-30 19:19:32', '1', 'beth_id', '1', 'V & B Bevan Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '7297 Rosalinda', 'Woodburn', 'OR', '96741', 'USA', NULL, NULL, '278-555-3710', NULL, NULL, NULL, 'www.vbbevantransportationholdings.com', NULL, NULL, NULL, NULL, '7297 Rosalinda', 'Woodburn', 'OR', '96741', 'USA', 0);
INSERT INTO accounts VALUES ('e0b30a6a-2d97-08a9-b773-438dfb91ae00', '2005-11-30 19:19:33', '2005-11-30 19:19:33', '1', 'beth_id', '1', 'Bevan-Monarco Construction Company', NULL, 'Consulting', 'Construction', NULL, NULL, '5375 Clearland Circle', 'Lakewood', 'CA', '86967', 'USA', NULL, NULL, '374-555-1317', NULL, NULL, NULL, 'www.bevan-monarcoconstructioncompany.com', NULL, NULL, NULL, NULL, '5375 Clearland Circle', 'Lakewood', 'CA', '86967', 'USA', 0);
INSERT INTO accounts VALUES ('44499ff2-512d-c664-957c-438dfbce7e97', '2005-11-30 19:19:33', '2005-11-30 19:19:33', '1', 'max_id', '1', 'C & A Zingarelli Engineering Group', NULL, 'Supply', 'Engineering', NULL, NULL, '5415 San Gabriel Dr.', 'Seattle', 'WA', '55244', 'USA', NULL, NULL, '886-555-9982', NULL, NULL, NULL, 'www.cazingarelliengineeringgroup.com', NULL, NULL, NULL, NULL, '5415 San Gabriel Dr.', 'Seattle', 'WA', '55244', 'USA', 0);
INSERT INTO accounts VALUES ('73f7b9c1-cae3-d662-c9aa-438dfb346e05', '2005-11-30 19:19:33', '2005-11-30 19:19:33', '1', 'kristen_id', '1', 'Zingarelli-Valentine Construction, Ltd', NULL, 'Consulting', 'Construction', NULL, NULL, '3747 Likins Avenue', 'Bremerton', 'WA', '37925', 'USA', NULL, NULL, '105-555-6217', NULL, NULL, NULL, 'www.zingarelli-valentineconstruction,ltd.com', NULL, NULL, NULL, NULL, '3747 Likins Avenue', 'Bremerton', 'WA', '37925', 'USA', 0);
INSERT INTO accounts VALUES ('a15828e0-e941-7e5e-6f3f-438dfb062b99', '2005-11-30 19:19:33', '2005-11-30 19:19:33', '1', 'chris_id', '1', 'U & S Scheulen Transportation, Inc', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '6697 Ridge Park Drive', 'Everett', 'WA', '71362', 'USA', NULL, NULL, '640-555-4510', NULL, NULL, NULL, 'www.usscheulentransportation,inc.com', NULL, NULL, NULL, NULL, '6697 Ridge Park Drive', 'Everett', 'WA', '71362', 'USA', 0);
INSERT INTO accounts VALUES ('d6531f8e-d33a-e2e4-7955-438dfb4d05f0', '2005-11-30 19:19:33', '2005-11-30 19:19:33', '1', 'will_id', '1', 'Scheulen-Koon Construction Group', NULL, 'Distribution', 'Construction', NULL, NULL, '7938 Blue Ridge', 'Langford', 'BC', '92912', 'Canada', NULL, NULL, '121-555-3032', NULL, NULL, NULL, 'www.scheulen-koonconstructiongroup.com', NULL, NULL, NULL, NULL, '7938 Blue Ridge', 'Langford', 'BC', '92912', 'Canada', 0);
INSERT INTO accounts VALUES ('7ade03c1-f61f-b9f9-aa17-438dfb9a7bab', '2005-11-30 19:19:34', '2005-11-30 19:19:34', '1', 'sarah_id', '1', 'N & W Amole Transportation Corp', NULL, 'Distribution', 'Transportation', NULL, NULL, '1143 Julpum Loop', 'Oak Bay', 'BC', '92511', 'Canada', NULL, NULL, '678-555-8953', NULL, NULL, NULL, 'www.nwamoletransportationcorp.com', NULL, NULL, NULL, NULL, '1143 Julpum Loop', 'Oak Bay', 'BC', '92511', 'Canada', 0);
INSERT INTO accounts VALUES ('356ecfc0-140f-77b6-2121-438dfbc3c55d', '2005-11-30 19:19:34', '2005-11-30 19:19:34', '1', 'matt_id', '1', 'Amole-Hill Engineering Partners', NULL, 'Supply', 'Engineering', NULL, NULL, '2639 Anchor Court', 'Edmonds', 'WA', '80222', 'USA', NULL, NULL, '182-555-6103', NULL, NULL, NULL, 'www.amole-hillengineeringpartners.com', NULL, NULL, NULL, NULL, '2639 Anchor Court', 'Edmonds', 'WA', '80222', 'USA', 0);
INSERT INTO accounts VALUES ('5d13a786-5be5-de7f-dd0c-438dfbf14353', '2005-11-30 19:19:34', '2005-11-30 19:19:34', '1', 'sarah_id', '1', 'O & D Tate Communications Associates', NULL, 'Distribution', 'Communications', NULL, NULL, '6097 Mt. McKinley Ct.', 'Imperial Beach', 'CA', '19692', 'USA', NULL, NULL, '102-555-5310', NULL, NULL, NULL, 'www.odtatecommunicationsassociates.com', NULL, NULL, NULL, NULL, '6097 Mt. McKinley Ct.', 'Imperial Beach', 'CA', '19692', 'USA', 0);
INSERT INTO accounts VALUES ('82d95c21-6a10-9582-5b3d-438dfbf0a156', '2005-11-30 19:19:34', '2005-11-30 19:19:34', '1', 'sally_id', '1', 'Tate-Schnurr Transportation Company', NULL, 'Consulting', 'Transportation', NULL, NULL, '502 Alexander Pl.', 'Woodburn', 'OR', '98856', 'USA', NULL, NULL, '528-555-1089', NULL, NULL, NULL, 'www.tate-schnurrtransportationcompany.com', NULL, NULL, NULL, NULL, '502 Alexander Pl.', 'Woodburn', 'OR', '98856', 'USA', 0);
INSERT INTO accounts VALUES ('c0f35cdd-896f-1ffe-f8f0-438dfb2e3c96', '2005-11-30 19:19:34', '2005-11-30 19:19:34', '1', 'sally_id', '1', 'M & Y Sutton Communications, Ltd', NULL, 'Supply', 'Communications', NULL, NULL, '6870 D Bel Air Drive', 'Albany', 'OR', '44872', 'USA', NULL, NULL, '836-555-3980', NULL, NULL, NULL, 'www.mysuttoncommunications,ltd.com', NULL, NULL, NULL, NULL, '6870 D Bel Air Drive', 'Albany', 'OR', '44872', 'USA', 0);
INSERT INTO accounts VALUES ('137e9f95-f313-8360-f71c-438dfb599270', '2005-11-30 19:19:35', '2005-11-30 19:19:35', '1', 'beth_id', '1', 'Sutton-Mlincek Communications Associates', NULL, 'Consulting', 'Communications', NULL, NULL, '8874 Folson Drive', 'Metchosin', 'BC', '23521', 'Canada', NULL, NULL, '625-555-2044', NULL, NULL, NULL, 'www.sutton-mlincekcommunicationsassociates.com', NULL, NULL, NULL, NULL, '8874 Folson Drive', 'Metchosin', 'BC', '23521', 'Canada', 0);
INSERT INTO accounts VALUES ('548525fc-1d16-2812-5072-438dfbaafd50', '2005-11-30 19:19:35', '2005-11-30 19:19:35', '1', 'max_id', '1', 'B & D Tucker Machinery Partners', NULL, 'Consulting', 'Machinery', NULL, NULL, '8152 Claudia Dr.', 'Corvallis', 'OR', '93312', 'USA', NULL, NULL, '829-555-2166', NULL, NULL, NULL, 'www.bdtuckermachinerypartners.com', NULL, NULL, NULL, NULL, '8152 Claudia Dr.', 'Corvallis', 'OR', '93312', 'USA', 0);
INSERT INTO accounts VALUES ('7a3171f6-d717-19aa-5933-438dfbda3f5d', '2005-11-30 19:19:35', '2005-11-30 19:19:35', '1', 'sarah_id', '1', 'Tucker-Forham Construction Partners', NULL, 'Manufacturing', 'Construction', NULL, NULL, '3066 Wallace Dr.', 'Arcadia', 'CA', '78508', 'USA', NULL, NULL, '641-555-7858', NULL, NULL, NULL, 'www.tucker-forhamconstructionpartners.com', NULL, NULL, NULL, NULL, '3066 Wallace Dr.', 'Arcadia', 'CA', '78508', 'USA', 0);
INSERT INTO accounts VALUES ('a818e283-96a4-aa8c-37d5-438dfb366d30', '2005-11-30 19:19:35', '2005-11-30 19:19:35', '1', 'kristen_id', '1', 'H & E Malik Machinery Group', NULL, 'Supply', 'Machinery', NULL, NULL, '2598 La Vista Circle', 'Spokane', 'WA', '15462', 'USA', NULL, NULL, '868-555-6608', NULL, NULL, NULL, 'www.hemalikmachinerygroup.com', NULL, NULL, NULL, NULL, '2598 La Vista Circle', 'Spokane', 'WA', '15462', 'USA', 0);
INSERT INTO accounts VALUES ('cd8af16b-58ec-668e-e936-438dfb0fdf00', '2005-11-30 19:19:35', '2005-11-30 19:19:35', '1', 'beth_id', '1', 'Malik-Eldridge Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '7765 Sunsine Drive', 'Los Angeles', 'CA', '11910', 'USA', NULL, NULL, '702-555-1930', NULL, NULL, NULL, 'www.malik-eldridgeelectronicsholdings.com', NULL, NULL, NULL, NULL, '7765 Sunsine Drive', 'Los Angeles', 'CA', '11910', 'USA', 0);
INSERT INTO accounts VALUES ('ffe80125-9dcf-c8d9-f1a0-438dfbc2a96a', '2005-11-30 19:19:36', '2005-11-30 19:19:36', '1', 'max_id', '1', 'X & M Anderson Construction Corp', NULL, 'Manufacturing', 'Construction', NULL, NULL, '7551 Santa Lucia', 'Mexico City', 'Mexico', '14025', 'Mexico', NULL, NULL, '952-555-8308', NULL, NULL, NULL, 'www.xmandersonconstructioncorp.com', NULL, NULL, NULL, NULL, '7551 Santa Lucia', 'Mexico City', 'Mexico', '14025', 'Mexico', 0);
INSERT INTO accounts VALUES ('48da9622-e1a0-fbf9-fd6e-438dfb5e0199', '2005-11-30 19:19:36', '2005-11-30 19:19:36', '1', 'sally_id', '1', 'Anderson-Sosa Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '5629 San Francisco', 'N. Vancouver', 'BC', '30543', 'Canada', NULL, NULL, '148-555-5915', NULL, NULL, NULL, 'www.anderson-sosatelecommunications,ltd.com', NULL, NULL, NULL, NULL, '5629 San Francisco', 'N. Vancouver', 'BC', '30543', 'Canada', 0);
INSERT INTO accounts VALUES ('6ea42746-6034-fd93-ae2b-438dfb7d7116', '2005-11-30 19:19:36', '2005-11-30 19:19:36', '1', 'chris_id', '1', 'I & M Mann Transportation, Ltd', NULL, 'Supply', 'Transportation', NULL, NULL, '5669 Ironwood Way', 'Daly City', 'CA', '97819', 'USA', NULL, NULL, '660-555-5580', NULL, NULL, NULL, 'www.immanntransportation,ltd.com', NULL, NULL, NULL, NULL, '5669 Ironwood Way', 'Daly City', 'CA', '97819', 'USA', 0);
INSERT INTO accounts VALUES ('9460b401-d542-7d9e-8055-438dfbe5fc59', '2005-11-30 19:19:36', '2005-11-30 19:19:36', '1', 'will_id', '1', 'Mann-Prater Electronics Corp', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '6657 Camino Solano', 'National City', 'CA', '54207', 'USA', NULL, NULL, '779-555-1815', NULL, NULL, NULL, 'www.mann-praterelectronicscorp.com', NULL, NULL, NULL, NULL, '6657 Camino Solano', 'National City', 'CA', '54207', 'USA', 0);
INSERT INTO accounts VALUES ('bb03cc1d-1a07-9134-d717-438dfb09a7da', '2005-11-30 19:19:36', '2005-11-30 19:19:36', '1', 'kristen_id', '1', 'H & Y Ansaldo Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '6951 Harmony Way', 'Imperial Beach', 'CA', '87645', 'USA', NULL, NULL, '413-555-9108', NULL, NULL, NULL, 'www.hyansaldoengineering,inc.com', NULL, NULL, NULL, NULL, '6951 Harmony Way', 'Imperial Beach', 'CA', '87645', 'USA', 0);
INSERT INTO accounts VALUES ('e0f0dce7-0249-715a-aa3a-438dfbb404f3', '2005-11-30 19:19:36', '2005-11-30 19:19:36', '1', 'jaime_id', '1', 'Ansaldo-Caijem Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '8192 Seagull Court', 'Richmond', 'CA', '36487', 'USA', NULL, NULL, '794-555-7630', NULL, NULL, NULL, 'www.ansaldo-caijemtelecommunications,ltd.com', NULL, NULL, NULL, NULL, '8192 Seagull Court', 'Richmond', 'CA', '36487', 'USA', 0);
INSERT INTO accounts VALUES ('12b61455-359d-ef18-61dc-438dfbc36256', '2005-11-30 19:19:37', '2005-11-30 19:19:37', '1', 'sally_id', '1', 'D & A Yates Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '1397 Paraiso Ct.', 'Los Angeles', 'CA', '97953', 'USA', NULL, NULL, '564-555-6811', NULL, NULL, NULL, 'www.dayatesmachinerygroup.com', NULL, NULL, NULL, NULL, '1397 Paraiso Ct.', 'Los Angeles', 'CA', '97953', 'USA', 0);
INSERT INTO accounts VALUES ('38e21953-c4b9-e613-7092-438dfbd0c194', '2005-11-30 19:19:37', '2005-11-30 19:19:37', '1', 'max_id', '1', 'Yates-Turner Construction Associates', NULL, 'Consulting', 'Construction', NULL, NULL, '2893 Vera', 'Santa Fe', 'DF', '23798', 'Mexico', NULL, NULL, '968-555-3961', NULL, NULL, NULL, 'www.yates-turnerconstructionassociates.com', NULL, NULL, NULL, NULL, '2893 Vera', 'Santa Fe', 'DF', '23798', 'Mexico', 0);
INSERT INTO accounts VALUES ('60684d96-aa4c-400a-3f4a-438dfbba21ee', '2005-11-30 19:19:37', '2005-11-30 19:19:37', '1', 'max_id', '1', 'D & Z Fulcher Electronics, Ltd', NULL, 'Consulting', 'Electronics', NULL, NULL, '9006 Woodside Way', 'Santa Cruz', 'CA', '62266', 'USA', NULL, NULL, '887-555-3168', NULL, NULL, NULL, 'www.dzfulcherelectronics,ltd.com', NULL, NULL, NULL, NULL, '9006 Woodside Way', 'Santa Cruz', 'CA', '62266', 'USA', 0);
INSERT INTO accounts VALUES ('86803808-fbc6-9eb8-e332-438dfbc84e4d', '2005-11-30 19:19:37', '2005-11-30 19:19:37', '1', 'kristen_id', '1', 'Fulcher-Berg Engineering Corp', NULL, 'Consulting', 'Engineering', NULL, NULL, '757 Pine Creek Way', 'Newton', 'BC', '16139', 'Canada', NULL, NULL, '414-555-7947', NULL, NULL, NULL, 'www.fulcher-bergengineeringcorp.com', NULL, NULL, NULL, NULL, '757 Pine Creek Way', 'Newton', 'BC', '16139', 'Canada', 0);
INSERT INTO accounts VALUES ('ad550398-ed33-33b0-506e-438dfba55edc', '2005-11-30 19:19:37', '2005-11-30 19:19:37', '1', 'will_id', '1', 'Q & Q Lopez Telecommunications Associates', NULL, 'Supply', 'Telecommunications', NULL, NULL, '8370 Acardia Pl.', 'N. Vancouver', 'BC', '47062', 'Canada', NULL, NULL, '356-555-5782', NULL, NULL, NULL, 'www.qqlopeztelecommunicationsassociates.com', NULL, NULL, NULL, NULL, '8370 Acardia Pl.', 'N. Vancouver', 'BC', '47062', 'Canada', 0);
INSERT INTO accounts VALUES ('d2f41bc7-cf41-86c8-a468-438dfbebc670', '2005-11-30 19:19:37', '2005-11-30 19:19:37', '1', 'max_id', '1', 'Lopez-Valdivia Engineering Company', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '3030 Blackburn Ct.', 'San Diego', 'CA', '66096', 'USA', NULL, NULL, '145-555-3847', NULL, NULL, NULL, 'www.lopez-valdiviaengineeringcompany.com', NULL, NULL, NULL, NULL, '3030 Blackburn Ct.', 'San Diego', 'CA', '66096', 'USA', 0);
INSERT INTO accounts VALUES ('6dbd0bad-3095-cceb-6509-438dfbcbadc8', '2005-11-30 19:19:38', '2005-11-30 19:19:38', '1', 'matt_id', '1', 'Y & R Cardoza Machinery, Inc', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '9652 Los Angeles', 'Sedro Woolley', 'WA', '36888', 'USA', NULL, NULL, '349-555-3968', NULL, NULL, NULL, 'www.yrcardozamachinery,inc.com', NULL, NULL, NULL, NULL, '9652 Los Angeles', 'Sedro Woolley', 'WA', '36888', 'USA', 0);
INSERT INTO accounts VALUES ('30074748-1f3c-ffca-1f92-438dfbcdf41b', '2005-11-30 19:19:38', '2005-11-30 19:19:38', '1', 'sarah_id', '1', 'Cardoza-Hall Engineering, Inc', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '4566 La Jolla', 'La Jolla', 'CA', '22084', 'USA', NULL, NULL, '160-555-9661', NULL, NULL, NULL, 'www.cardoza-hallengineering,inc.com', NULL, NULL, NULL, NULL, '4566 La Jolla', 'La Jolla', 'CA', '22084', 'USA', 0);
INSERT INTO accounts VALUES ('57cab759-6c7e-8167-0136-438dfb48df83', '2005-11-30 19:19:38', '2005-11-30 19:19:38', '1', 'kristen_id', '1', 'E & F Minarick Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '4098 Woodcrest Dr.', 'Woodburn', 'OR', '58037', 'USA', NULL, NULL, '387-555-8411', NULL, NULL, NULL, 'www.efminarickmachinery,ltd.com', NULL, NULL, NULL, NULL, '4098 Woodcrest Dr.', 'Woodburn', 'OR', '58037', 'USA', 0);
INSERT INTO accounts VALUES ('7f5e48b7-8871-f3e9-716b-438dfb8e9e06', '2005-11-30 19:19:38', '2005-11-30 19:19:38', '1', 'chris_id', '1', 'Minarick-Los Olmos Transportation Holdings', NULL, 'Distribution', 'Transportation', NULL, NULL, '9265 La Paz', 'Imperial Beach', 'CA', '93945', 'USA', NULL, NULL, '222-555-3732', NULL, NULL, NULL, 'www.minarick-losolmostransportationholdings.com', NULL, NULL, NULL, NULL, '9265 La Paz', 'Imperial Beach', 'CA', '93945', 'USA', 0);
INSERT INTO accounts VALUES ('a4f68013-8e21-9e4d-982d-438dfb76cef9', '2005-11-30 19:19:38', '2005-11-30 19:19:38', '1', 'will_id', '1', 'N & O Garner Electronics, Inc', NULL, 'Supply', 'Electronics', NULL, NULL, '9052 Montgomery Avenue', 'Burnaby', 'BC', '84216', 'Canada', NULL, NULL, '472-555-1111', NULL, NULL, NULL, 'www.nogarnerelectronics,inc.com', NULL, NULL, NULL, NULL, '9052 Montgomery Avenue', 'Burnaby', 'BC', '84216', 'Canada', 0);
INSERT INTO accounts VALUES ('cc8c4b85-7a41-ee9c-5ae8-438dfb628795', '2005-11-30 19:19:38', '2005-11-30 19:19:38', '1', 'kristen_id', '1', 'Garner-Leong Machinery Group', NULL, 'Distribution', 'Machinery', NULL, NULL, '7129 Oakmead', 'Santa Anita', 'DF', '17364', 'Mexico', NULL, NULL, '807-555-2375', NULL, NULL, NULL, 'www.garner-leongmachinerygroup.com', NULL, NULL, NULL, NULL, '7129 Oakmead', 'Santa Anita', 'DF', '17364', 'Mexico', 0);
INSERT INTO accounts VALUES ('f3562fb8-e19d-3c2f-fd04-438dfb709397', '2005-11-30 19:19:39', '2005-11-30 19:19:39', '1', 'beth_id', '1', 'U & W Tate Construction Corp', NULL, 'Supply', 'Construction', NULL, NULL, '9825 Coralie Drive', 'Novato', 'CA', '42719', 'USA', NULL, NULL, '770-555-7957', NULL, NULL, NULL, 'www.uwtateconstructioncorp.com', NULL, NULL, NULL, NULL, '9825 Coralie Drive', 'Novato', 'CA', '42719', 'USA', 0);
INSERT INTO accounts VALUES ('27473bd7-d8cf-18f8-b2a9-438dfb78c444', '2005-11-30 19:19:39', '2005-11-30 19:19:39', '1', 'max_id', '1', 'Tate-Watson Electronics Company', NULL, 'Consulting', 'Electronics', NULL, NULL, '8157 W. Buchanan', 'Woodland Hills', 'CA', '25400', 'USA', NULL, NULL, '889-555-4193', NULL, NULL, NULL, 'www.tate-watsonelectronicscompany.com', NULL, NULL, NULL, NULL, '8157 W. Buchanan', 'Woodland Hills', 'CA', '25400', 'USA', 0);
INSERT INTO accounts VALUES ('4f0dc9e4-5602-a885-ae9f-438dfb9fb925', '2005-11-30 19:19:39', '2005-11-30 19:19:39', '1', 'chris_id', '1', 'M & K Frank Telecommunications, Ltd', NULL, 'Supply', 'Telecommunications', NULL, NULL, '1108 Catcus Court', 'Ladner', 'BC', '58838', 'Canada', NULL, NULL, '523-555-2486', NULL, NULL, NULL, 'www.mkfranktelecommunications,ltd.com', NULL, NULL, NULL, NULL, '1108 Catcus Court', 'Ladner', 'BC', '58838', 'Canada', 0);
INSERT INTO accounts VALUES ('778c9cdd-ed31-1220-9535-438dfb496070', '2005-11-30 19:19:39', '2005-11-30 19:19:39', '1', 'sarah_id', '1', 'Frank-Wood Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '9693 Mellowood Street', 'National City', 'CA', '80387', 'USA', NULL, NULL, '904-555-1007', NULL, NULL, NULL, 'www.frank-woodmachinery,ltd.com', NULL, NULL, NULL, NULL, '9693 Mellowood Street', 'National City', 'CA', '80387', 'USA', 0);
INSERT INTO accounts VALUES ('9f58bfc7-c032-ea8c-7741-438dfbe5ff07', '2005-11-30 19:19:39', '2005-11-30 19:19:39', '1', 'beth_id', '1', 'L & E Baird Communications Partners', NULL, 'Distribution', 'Communications', NULL, NULL, '5553 Kahrs Avenue', 'Olympia', 'WA', '79986', 'USA', NULL, NULL, '562-555-6929', NULL, NULL, NULL, 'www.lebairdcommunicationspartners.com', NULL, NULL, NULL, NULL, '5553 Kahrs Avenue', 'Olympia', 'WA', '79986', 'USA', 0);
INSERT INTO accounts VALUES ('c6c2c945-7272-8204-87b6-438dfb21706e', '2005-11-30 19:19:39', '2005-11-30 19:19:39', '1', 'sally_id', '1', 'Baird-Jans Construction Holdings', NULL, 'Consulting', 'Construction', NULL, NULL, '7048 Laurel', 'Woodburn', 'OR', '67698', 'USA', NULL, NULL, '966-555-4079', NULL, NULL, NULL, 'www.baird-jansconstructionholdings.com', NULL, NULL, NULL, NULL, '7048 Laurel', 'Woodburn', 'OR', '67698', 'USA', 0);
INSERT INTO accounts VALUES ('ec3a8159-35a1-1e25-873d-438dfbd93199', '2005-11-30 19:19:39', '2005-11-30 19:19:39', '1', 'kristen_id', '1', 'W & N Garrison Telecommunications Partners', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '507 Sahara Drive', 'Santa Anita', 'DF', '33459', 'Mexico', NULL, NULL, '885-555-3286', NULL, NULL, NULL, 'www.wngarrisontelecommunicationspartners.com', NULL, NULL, NULL, NULL, '507 Sahara Drive', 'Santa Anita', 'DF', '33459', 'Mexico', 0);
INSERT INTO accounts VALUES ('1f2fea14-abc1-3aec-e784-438dfbc6c413', '2005-11-30 19:19:40', '2005-11-30 19:19:40', '1', 'sally_id', '1', 'Garrison-Zeller Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '4912 La Vuelta', 'Bellflower', 'CA', '86331', 'USA', NULL, NULL, '651-555-2722', NULL, NULL, NULL, 'www.garrison-zellertransportationholdings.com', NULL, NULL, NULL, NULL, '4912 La Vuelta', 'Bellflower', 'CA', '86331', 'USA', 0);
INSERT INTO accounts VALUES ('46b00b5a-2979-a81d-21df-438dfb0ce21a', '2005-11-30 19:19:40', '2005-11-30 19:19:40', '1', 'beth_id', '1', 'V & A Ace Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '8624 Pepperidge Way', 'Torrance', 'CA', '90961', 'USA', NULL, NULL, '593-555-9557', NULL, NULL, NULL, 'www.vaacetransportationcorp.com', NULL, NULL, NULL, NULL, '8624 Pepperidge Way', 'Torrance', 'CA', '90961', 'USA', 0);
INSERT INTO accounts VALUES ('71de7f65-fbfc-1247-48be-438dfbda2ea9', '2005-11-30 19:19:40', '2005-11-30 19:19:40', '1', 'max_id', '1', 'Ace-Trujillo Communications Corp', NULL, 'Consulting', 'Communications', NULL, NULL, '3284 S. Bascom Avenue', 'Lynnwood', 'WA', '10996', 'USA', NULL, NULL, '143-555-3964', NULL, NULL, NULL, 'www.ace-trujillocommunicationscorp.com', NULL, NULL, NULL, NULL, '3284 S. Bascom Avenue', 'Lynnwood', 'WA', '10996', 'USA', 0);
INSERT INTO accounts VALUES ('98399ae4-48ae-3a6e-a6b8-438dfbfc3d10', '2005-11-30 19:19:40', '2005-11-30 19:19:40', '1', 'sally_id', '1', 'T & A McCown Electronics, Inc', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '9906 Oak Grove Road', 'Lemon Grove', 'CA', '80803', 'USA', NULL, NULL, '347-555-4086', NULL, NULL, NULL, 'www.tamccownelectronics,inc.com', NULL, NULL, NULL, NULL, '9906 Oak Grove Road', 'Lemon Grove', 'CA', '80803', 'USA', 0);
INSERT INTO accounts VALUES ('c3a340bf-1fb0-bf23-45b4-438dfbb2bf1b', '2005-11-30 19:19:40', '2005-11-30 19:19:40', '1', 'matt_id', '1', 'McCown-Miller Construction Associates', NULL, 'Manufacturing', 'Construction', NULL, NULL, '7476 Halfmoon Court', 'Sooke', 'BC', '92275', 'Canada', NULL, NULL, '158-555-9779', NULL, NULL, NULL, 'www.mccown-millerconstructionassociates.com', NULL, NULL, NULL, NULL, '7476 Halfmoon Court', 'Sooke', 'BC', '92275', 'Canada', 0);
INSERT INTO accounts VALUES ('e92944ca-2169-831d-2241-438dfbe14f3f', '2005-11-30 19:19:40', '2005-11-30 19:19:40', '1', 'chris_id', '1', 'D & D Hollar Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '4352 Olive Ave.', 'La Cruz', 'Sinaloa', '29229', 'Mexico', NULL, NULL, '385-555-8529', NULL, NULL, NULL, 'www.ddhollarelectronicsholdings.com', NULL, NULL, NULL, NULL, '4352 Olive Ave.', 'La Cruz', 'Sinaloa', '29229', 'Mexico', 0);
INSERT INTO accounts VALUES ('1cd83a84-d536-65ee-1375-438dfb2acfab', '2005-11-30 19:19:41', '2005-11-30 19:19:41', '1', 'sarah_id', '1', 'Hollar-Wallin Machinery, Inc', NULL, 'Distribution', 'Machinery', NULL, NULL, '2176 Apollo Way', 'Beaverton', 'OR', '79586', 'USA', NULL, NULL, '334-555-6031', NULL, NULL, NULL, 'www.hollar-wallinmachinery,inc.com', NULL, NULL, NULL, NULL, '2176 Apollo Way', 'Beaverton', 'OR', '79586', 'USA', 0);
INSERT INTO accounts VALUES ('4a646280-fdc3-79e8-9a02-438dfbaa84e7', '2005-11-30 19:19:41', '2005-11-30 19:19:41', '1', 'sally_id', '1', 'I & V Bruha Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '1962 Cunha Ct.', 'W. Linn', 'OR', '27502', 'USA', NULL, NULL, '823-555-7067', NULL, NULL, NULL, 'www.ivbruhaengineering,inc.com', NULL, NULL, NULL, NULL, '1962 Cunha Ct.', 'W. Linn', 'OR', '27502', 'USA', 0);
INSERT INTO accounts VALUES ('705ef7a4-43a2-08a0-db33-438dfb3485bf', '2005-11-30 19:19:41', '2005-11-30 19:19:41', '1', 'beth_id', '1', 'Bruha-Suggs Construction, Ltd', NULL, 'Manufacturing', 'Construction', NULL, NULL, '40 Ellis St.', 'Burbank', 'CA', '17728', 'USA', NULL, NULL, '919-555-4674', NULL, NULL, NULL, 'www.bruha-suggsconstruction,ltd.com', NULL, NULL, NULL, NULL, '40 Ellis St.', 'Burbank', 'CA', '17728', 'USA', 0);
INSERT INTO accounts VALUES ('96149ed6-290f-78d3-3cf6-438dfb61ae08', '2005-11-30 19:19:41', '2005-11-30 19:19:41', '1', 'matt_id', '1', 'K & R Turner Communications Group', NULL, 'Consulting', 'Communications', NULL, NULL, '80 Sunview Terrace', 'El Cajon', 'CA', '85004', 'USA', NULL, NULL, '292-555-9681', NULL, NULL, NULL, 'www.krturnercommunicationsgroup.com', NULL, NULL, NULL, NULL, '80 Sunview Terrace', 'El Cajon', 'CA', '85004', 'USA', 0);
INSERT INTO accounts VALUES ('bded92e7-965b-d779-89ec-438dfb22fbcf', '2005-11-30 19:19:41', '2005-11-30 19:19:41', '1', 'jaime_id', '1', 'Turner-Griffin Engineering Associates', NULL, 'Distribution', 'Engineering', NULL, NULL, '8411 Mt. Olivet Place', 'Renton', 'WA', '67685', 'USA', NULL, NULL, '650-555-9574', NULL, NULL, NULL, 'www.turner-griffinengineeringassociates.com', NULL, NULL, NULL, NULL, '8411 Mt. Olivet Place', 'Renton', 'WA', '67685', 'USA', 0);
INSERT INTO accounts VALUES ('e84468c7-d9e4-070d-54f8-438dfb7ff11f', '2005-11-30 19:19:41', '2005-11-30 19:19:41', '1', 'max_id', '1', 'B & P Guardamondo Telecommunications Holdings', NULL, 'Distribution', 'Telecommunications', NULL, NULL, '1362 Somerset Place', 'Bellingham', 'WA', '74830', 'USA', NULL, NULL, '946-555-4209', NULL, NULL, NULL, 'www.bpguardamondotelecommunicationsholdings.com', NULL, NULL, NULL, NULL, '1362 Somerset Place', 'Bellingham', 'WA', '74830', 'USA', 0);
INSERT INTO accounts VALUES ('2148f18f-2408-a1cc-ebc2-438dfb9238fa', '2005-11-30 19:19:42', '2005-11-30 19:19:42', '1', 'kristen_id', '1', 'Guardamondo-West Electronics, Ltd', NULL, 'Distribution', 'Electronics', NULL, NULL, '2603 Condor Place', 'Oak Bay', 'BC', '23672', 'Canada', NULL, NULL, '427-555-2731', NULL, NULL, NULL, 'www.guardamondo-westelectronics,ltd.com', NULL, NULL, NULL, NULL, '2603 Condor Place', 'Oak Bay', 'BC', '23672', 'Canada', 0);
INSERT INTO accounts VALUES ('46efaf6b-79d7-7108-b557-438dfb599391', '2005-11-30 19:19:42', '2005-11-30 19:19:42', '1', 'chris_id', '1', 'Q & P Welsh Telecommunications Company', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, 'P.O. Box 1742', 'Ladner', 'BC', '23272', 'Canada', NULL, NULL, '984-555-8652', NULL, NULL, NULL, 'www.qpwelshtelecommunicationscompany.com', NULL, NULL, NULL, NULL, 'P.O. Box 1742', 'Ladner', 'BC', '23272', 'Canada', 0);
INSERT INTO accounts VALUES ('70f9bcc1-a6cd-16ca-6188-438dfbfe26e2', '2005-11-30 19:19:42', '2005-11-30 19:19:42', '1', 'beth_id', '1', 'Welsh-McCollum Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '3238 Laguna Circle', 'Sedro Woolley', 'WA', '10983', 'USA', NULL, NULL, '727-555-9460', NULL, NULL, NULL, 'www.welsh-mccollumtransportationholdings.com', NULL, NULL, NULL, NULL, '3238 Laguna Circle', 'Sedro Woolley', 'WA', '10983', 'USA', 0);
INSERT INTO accounts VALUES ('970db1ca-bbc5-1bed-58bc-438dfbc02ed0', '2005-11-30 19:19:42', '2005-11-30 19:19:42', '1', 'kristen_id', '1', 'G & N Cramer Communications Group', NULL, 'Supply', 'Communications', NULL, NULL, '6696 Adria Drive', 'La Mesa', 'CA', '49452', 'USA', NULL, NULL, '408-555-5009', NULL, NULL, NULL, 'www.gncramercommunicationsgroup.com', NULL, NULL, NULL, NULL, '6696 Adria Drive', 'La Mesa', 'CA', '49452', 'USA', 0);
INSERT INTO accounts VALUES ('bf504165-a219-0727-b299-438dfbe18890', '2005-11-30 19:19:42', '2005-11-30 19:19:42', '1', 'kristen_id', '1', 'Cramer-Fike Construction Partners', NULL, 'Distribution', 'Construction', NULL, NULL, '1102 Ravenwood', 'W. Linn', 'OR', '29617', 'USA', NULL, NULL, '173-555-4445', NULL, NULL, NULL, 'www.cramer-fikeconstructionpartners.com', NULL, NULL, NULL, NULL, '1102 Ravenwood', 'W. Linn', 'OR', '29617', 'USA', 0);
INSERT INTO accounts VALUES ('ed7e2b76-7300-b676-c21c-438dfb5370f0', '2005-11-30 19:19:42', '2005-11-30 19:19:42', '1', 'kristen_id', '1', 'H & Y Adair Electronics, Ltd', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '7469 Paraiso Ct.', 'Oregon City', 'OR', '34247', 'USA', NULL, NULL, '116-555-2281', NULL, NULL, NULL, 'www.hyadairelectronics,ltd.com', NULL, NULL, NULL, NULL, '7469 Paraiso Ct.', 'Oregon City', 'OR', '34247', 'USA', 0);
INSERT INTO accounts VALUES ('1ee0a704-d3ac-255b-e28a-438dfb6778bf', '2005-11-30 19:19:43', '2005-11-30 19:19:43', '1', 'chris_id', '1', 'Adair-Kolosso Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '2129 Acacia Drive', 'Royal Oak', 'BC', '53281', 'Canada', NULL, NULL, '255-555-6263', NULL, NULL, NULL, 'www.adair-kolossotransportationholdings.com', NULL, NULL, NULL, NULL, '2129 Acacia Drive', 'Royal Oak', 'BC', '53281', 'Canada', 0);
INSERT INTO accounts VALUES ('4f5a2e60-a328-2863-508c-438dfbf96b08', '2005-11-30 19:19:43', '2005-11-30 19:19:43', '1', 'sarah_id', '1', 'O & K Carpenter Transportation Corp', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '8751 Norse Drive', 'Milwaukie', 'OR', '24073', 'USA', NULL, NULL, '220-555-2727', NULL, NULL, NULL, 'www.okcarpentertransportationcorp.com', NULL, NULL, NULL, NULL, '8751 Norse Drive', 'Milwaukie', 'OR', '24073', 'USA', 0);
INSERT INTO accounts VALUES ('74ea30bd-bfd6-50c7-f602-438dfbb9b15b', '2005-11-30 19:19:43', '2005-11-30 19:19:43', '1', 'beth_id', '1', 'Carpenter-Watkins Construction Partners', NULL, 'Consulting', 'Construction', NULL, NULL, '3665 Oak Creek Ct.', 'Concord', 'CA', '92694', 'USA', NULL, NULL, '932-555-8420', NULL, NULL, NULL, 'www.carpenter-watkinsconstructionpartners.com', NULL, NULL, NULL, NULL, '3665 Oak Creek Ct.', 'Concord', 'CA', '92694', 'USA', 0);
INSERT INTO accounts VALUES ('9db6a39c-455b-fadf-14fc-438dfbc0db37', '2005-11-30 19:19:43', '2005-11-30 19:19:43', '1', 'sally_id', '1', 'D & D Barrera Transportation, Ltd', NULL, 'Distribution', 'Transportation', NULL, NULL, '3197 Thornhill Place', 'Glendale', 'CA', '45222', 'USA', NULL, NULL, '259-555-7170', NULL, NULL, NULL, 'www.ddbarreratransportation,ltd.com', NULL, NULL, NULL, NULL, '3197 Thornhill Place', 'Glendale', 'CA', '45222', 'USA', 0);
INSERT INTO accounts VALUES ('c3079592-c5b0-337e-fb81-438dfb1f4d67', '2005-11-30 19:19:43', '2005-11-30 19:19:43', '1', 'kristen_id', '1', 'Barrera-Price Machinery, Inc', NULL, 'Consulting', 'Machinery', NULL, NULL, '8364 Encinal Place', 'San Andres', 'DF', '95578', 'Mexico', NULL, NULL, '332-555-6148', NULL, NULL, NULL, 'www.barrera-pricemachinery,inc.com', NULL, NULL, NULL, NULL, '8364 Encinal Place', 'San Andres', 'DF', '95578', 'Mexico', 0);
INSERT INTO accounts VALUES ('ec2865f0-7fd3-5787-0dd7-438dfb089a43', '2005-11-30 19:19:43', '2005-11-30 19:19:43', '1', 'beth_id', '1', 'E & M Rosemont Electronics Company', NULL, 'Supply', 'Electronics', NULL, NULL, '8150 Las Trampas', 'San Andres', 'DF', '97693', 'Mexico', NULL, NULL, '582-555-3527', NULL, NULL, NULL, 'www.emrosemontelectronicscompany.com', NULL, NULL, NULL, NULL, '8150 Las Trampas', 'San Andres', 'DF', '97693', 'Mexico', 0);
INSERT INTO accounts VALUES ('1f0b26f0-8865-637a-d591-438dfb700fb6', '2005-11-30 19:19:44', '2005-11-30 19:19:44', '1', 'matt_id', '1', 'Rosemont-McMenama Engineering, Ltd', NULL, 'Distribution', 'Engineering', NULL, NULL, '6228 Meadowbrook Dr.', 'Burnaby', 'BC', '15628', 'Canada', NULL, NULL, '678-555-1134', NULL, NULL, NULL, 'www.rosemont-mcmenamaengineering,ltd.com', NULL, NULL, NULL, NULL, '6228 Meadowbrook Dr.', 'Burnaby', 'BC', '15628', 'Canada', 0);
INSERT INTO accounts VALUES ('4e6a1409-2212-5aed-c99a-438dfbc0fb95', '2005-11-30 19:19:44', '2005-11-30 19:19:44', '1', 'matt_id', '1', 'R & Z Lyons Communications, Inc', NULL, 'Distribution', 'Communications', NULL, NULL, '6268 Breck Court', 'Merida', 'Yucatan', '82904', 'Mexico', NULL, NULL, '951-555-6141', NULL, NULL, NULL, 'www.rzlyonscommunications,inc.com', NULL, NULL, NULL, NULL, '6268 Breck Court', 'Merida', 'Yucatan', '82904', 'Mexico', 0);
INSERT INTO accounts VALUES ('7c317fbb-51fd-244f-8ff5-438dfbda1e29', '2005-11-30 19:19:44', '2005-11-30 19:19:44', '1', 'chris_id', '1', 'Lyons-Sandy Kurtz Machinery Partners', NULL, 'Supply', 'Machinery', NULL, NULL, '7256 St. Paul Circle', 'Vancouver', 'BC', '39293', 'Canada', NULL, NULL, '409-555-6034', NULL, NULL, NULL, 'www.lyons-sandykurtzmachinerypartners.com', NULL, NULL, NULL, NULL, '7256 St. Paul Circle', 'Vancouver', 'BC', '39293', 'Canada', 0);
INSERT INTO accounts VALUES ('a1c6dd10-a511-f5a4-587a-438dfbdf1f11', '2005-11-30 19:19:44', '2005-11-30 19:19:44', '1', 'sarah_id', '1', 'J & K Santry Communications Corp', NULL, 'Supply', 'Communications', NULL, NULL, '207 Barquentine Court', 'Lincoln Acres', 'CA', '72730', 'USA', NULL, NULL, '705-555-9670', NULL, NULL, NULL, 'www.jksantrycommunicationscorp.com', NULL, NULL, NULL, NULL, '207 Barquentine Court', 'Lincoln Acres', 'CA', '72730', 'USA', 0);
INSERT INTO accounts VALUES ('c71a05f0-4fb4-6db9-4c75-438dfbe2017c', '2005-11-30 19:19:44', '2005-11-30 19:19:44', '1', 'sally_id', '1', 'Santry-Quigle Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '8791 La Cadena', 'Tlaxiaco', 'Oaxaca', '94279', 'Mexico', NULL, NULL, '186-555-8191', NULL, NULL, NULL, 'www.santry-quigleconstruction,ltd.com', NULL, NULL, NULL, NULL, '8791 La Cadena', 'Tlaxiaco', 'Oaxaca', '94279', 'Mexico', 0);
INSERT INTO accounts VALUES ('f042e492-e8d1-80fc-4ec4-438dfbd0ae07', '2005-11-30 19:19:44', '2005-11-30 19:19:44', '1', 'max_id', '1', 'W & W Christensen Electronics Associates', NULL, 'Supply', 'Electronics', NULL, NULL, '1996 Glenhaven Ave South', 'Tixapan', 'DF', '93879', 'Mexico', NULL, NULL, '982-555-8770', NULL, NULL, NULL, 'www.wwchristensenelectronicsassociates.com', NULL, NULL, NULL, NULL, '1996 Glenhaven Ave South', 'Tixapan', 'DF', '93879', 'Mexico', 0);
INSERT INTO accounts VALUES ('2563e2bf-1a07-5db9-d427-438dfbc75f46', '2005-11-30 19:19:45', '2005-11-30 19:19:45', '1', 'max_id', '1', 'Christensen-Mercurio Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '3492 Broadway Street', 'Richmond', 'BC', '81590', 'Canada', NULL, NULL, '837-555-2837', NULL, NULL, NULL, 'www.christensen-mercuriomachinerygroup.com', NULL, NULL, NULL, NULL, '3492 Broadway Street', 'Richmond', 'BC', '81590', 'Canada', 0);
INSERT INTO accounts VALUES ('50f7b948-3a23-e5b5-1e66-438dfb163203', '2005-11-30 19:19:45', '2005-11-30 19:19:45', '1', 'beth_id', '1', 'D & G McGrath Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '9605 Pheasant Circle', 'Lake Oswego', 'OR', '47352', 'USA', NULL, NULL, '518-555-7387', NULL, NULL, NULL, 'www.dgmcgrathtransportation,inc.com', NULL, NULL, NULL, NULL, '9605 Pheasant Circle', 'Lake Oswego', 'OR', '47352', 'USA', 0);
INSERT INTO accounts VALUES ('76982213-4d75-c8e7-b5ca-438dfb2db90c', '2005-11-30 19:19:45', '2005-11-30 19:19:45', '1', 'matt_id', '1', 'McGrath-Wright Engineering, Ltd', NULL, 'Supply', 'Engineering', NULL, NULL, '1356 Grove Way', 'La Mesa', 'CA', '12255', 'USA', NULL, NULL, '283-555-6823', NULL, NULL, NULL, 'www.mcgrath-wrightengineering,ltd.com', NULL, NULL, NULL, NULL, '1356 Grove Way', 'La Mesa', 'CA', '12255', 'USA', 0);
INSERT INTO accounts VALUES ('a7309360-0640-95cc-2e64-438dfb01fb7d', '2005-11-30 19:19:45', '2005-11-30 19:19:45', '1', 'jaime_id', '1', 'Z & L Skuce Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '7723 Firestone Drive', 'Chula Vista', 'CA', '32147', 'USA', NULL, NULL, '226-555-4659', NULL, NULL, NULL, 'www.zlskuceconstruction,ltd.com', NULL, NULL, NULL, NULL, '7723 Firestone Drive', 'Chula Vista', 'CA', '32147', 'USA', 0);
INSERT INTO accounts VALUES ('e1df2c79-f019-b562-ec1f-438dfb43bacd', '2005-11-30 19:19:45', '2005-11-30 19:19:45', '1', 'will_id', '1', 'Skuce-Coleman Transportation Group', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '2383 Pepper Drive', 'Daly City', 'CA', '51181', 'USA', NULL, NULL, '914-555-2723', NULL, NULL, NULL, 'www.skuce-colemantransportationgroup.com', NULL, NULL, NULL, NULL, '2383 Pepper Drive', 'Daly City', 'CA', '51181', 'USA', 0);
INSERT INTO accounts VALUES ('1dd34cd8-e05b-bba4-9f20-438dfb753fea', '2005-11-30 19:19:46', '2005-11-30 19:19:46', '1', 'max_id', '1', 'V & P Barnes Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '9005 Eagle Ct.', 'Metchosin', 'BC', '21973', 'Canada', NULL, NULL, '879-555-8187', NULL, NULL, NULL, 'www.vpbarnestransportationcorp.com', NULL, NULL, NULL, NULL, '9005 Eagle Ct.', 'Metchosin', 'BC', '21973', 'Canada', 0);
INSERT INTO accounts VALUES ('50d94809-19f5-1791-2a4f-438dfb6fe4b3', '2005-11-30 19:19:46', '2005-11-30 19:19:46', '1', 'will_id', '1', 'Barnes-Camille Telecommunications, Inc', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '3919 El Pintado Road', 'Torrance', 'CA', '71696', 'USA', NULL, NULL, '691-555-4880', NULL, NULL, NULL, 'www.barnes-camilletelecommunications,inc.com', NULL, NULL, NULL, NULL, '3919 El Pintado Road', 'Torrance', 'CA', '71696', 'USA', 0);
INSERT INTO accounts VALUES ('8c588605-d9c6-92bf-0f2a-438dfbca1c6e', '2005-11-30 19:19:46', '2005-11-30 19:19:46', '1', 'matt_id', '1', 'F & X Allenbach Communications Partners', NULL, 'Consulting', 'Communications', NULL, NULL, '3451 Meier Road', 'Haney', 'BC', '43122', 'Canada', NULL, NULL, '918-555-3630', NULL, NULL, NULL, 'www.fxallenbachcommunicationspartners.com', NULL, NULL, NULL, NULL, '3451 Meier Road', 'Haney', 'BC', '43122', 'Canada', 0);
INSERT INTO accounts VALUES ('cd68ff34-a6d3-4cea-0c89-438dfb0002b9', '2005-11-30 19:19:46', '2005-11-30 19:19:46', '1', 'sally_id', '1', 'Allenbach-Smith Communications Holdings', NULL, 'Distribution', 'Communications', NULL, NULL, '1275 West Street', 'National City', 'CA', '93479', 'USA', NULL, NULL, '991-555-2609', NULL, NULL, NULL, 'www.allenbach-smithcommunicationsholdings.com', NULL, NULL, NULL, NULL, '1275 West Street', 'National City', 'CA', '93479', 'USA', 0);
INSERT INTO accounts VALUES ('14fd4f32-ae52-11da-ea20-438dfb1a3b6f', '2005-11-30 19:19:47', '2005-11-30 19:19:47', '1', 'sarah_id', '1', 'S & X Minker Engineering Partners', NULL, 'Distribution', 'Engineering', NULL, NULL, '1061 Buskrik Avenue', 'Coronado', 'CA', '95593', 'USA', NULL, NULL, '341-555-8987', NULL, NULL, NULL, 'www.sxminkerengineeringpartners.com', NULL, NULL, NULL, NULL, '1061 Buskrik Avenue', 'Coronado', 'CA', '95593', 'USA', 0);
INSERT INTO accounts VALUES ('45680339-ff5e-a956-fa01-438dfb131b0c', '2005-11-30 19:19:47', '2005-11-30 19:19:47', '1', 'sarah_id', '1', 'Minker-Jimenez Transportation, Inc', NULL, 'Supply', 'Transportation', NULL, NULL, '6482 Colt Ct.', 'Cliffside', 'BC', '11498', 'Canada', NULL, NULL, '437-555-6594', NULL, NULL, NULL, 'www.minker-jimeneztransportation,inc.com', NULL, NULL, NULL, NULL, '6482 Colt Ct.', 'Cliffside', 'BC', '11498', 'Canada', 0);
INSERT INTO accounts VALUES ('789c02cf-28d5-d394-dac6-438dfb023cce', '2005-11-30 19:19:47', '2005-11-30 19:19:47', '1', 'sarah_id', '1', 'H & N Malaby Machinery Corp', NULL, 'Supply', 'Machinery', NULL, NULL, '9178 Sand Pointe Lane', 'W. Linn', 'OR', '78774', 'USA', NULL, NULL, '710-555-2601', NULL, NULL, NULL, 'www.hnmalabymachinerycorp.com', NULL, NULL, NULL, NULL, '9178 Sand Pointe Lane', 'W. Linn', 'OR', '78774', 'USA', 0);
INSERT INTO accounts VALUES ('a95b68c7-137b-66ca-1967-438dfbbf8f6a', '2005-11-30 19:19:47', '2005-11-30 19:19:47', '1', 'will_id', '1', 'Malaby-Caldwell Machinery Associates', NULL, 'Supply', 'Machinery', NULL, NULL, '8756 Nottingham Pl.', 'Spring Valley', 'CA', '61454', 'USA', NULL, NULL, '168-555-2494', NULL, NULL, NULL, 'www.malaby-caldwellmachineryassociates.com', NULL, NULL, NULL, NULL, '8756 Nottingham Pl.', 'Spring Valley', 'CA', '61454', 'USA', 0);
INSERT INTO accounts VALUES ('d9601cf0-443a-526d-c1af-438dfb6e61f2', '2005-11-30 19:19:47', '2005-11-30 19:19:47', '1', 'max_id', '1', 'G & W Tinder Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '1707 Summerfield Drive', 'Westminster', 'BC', '94892', 'Canada', NULL, NULL, '154-555-6705', NULL, NULL, NULL, 'www.gwtindertransportation,inc.com', NULL, NULL, NULL, NULL, '1707 Summerfield Drive', 'Westminster', 'BC', '94892', 'Canada', 0);
INSERT INTO accounts VALUES ('282c22f3-be7c-9755-4791-438dfbf88660', '2005-11-30 19:19:48', '2005-11-30 19:19:48', '1', 'matt_id', '1', 'Tinder-Kropff Machinery Corp', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '2948 Dayton Court', 'Guadalajara', 'Jalisco', '17442', 'Mexico', NULL, NULL, '296-555-1569', NULL, NULL, NULL, 'www.tinder-kropffmachinerycorp.com', NULL, NULL, NULL, NULL, '2948 Dayton Court', 'Guadalajara', 'Jalisco', '17442', 'Mexico', 0);
INSERT INTO accounts VALUES ('5b21281d-97c7-e2c9-e9bc-438dfb5d341e', '2005-11-30 19:19:48', '2005-11-30 19:19:48', '1', 'beth_id', '1', 'V & B Worsham Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '6152 Buckingham Dr.', 'Sedro Woolley', 'WA', '17042', 'USA', NULL, NULL, '192-555-2147', NULL, NULL, NULL, 'www.vbworshamtransportationholdings.com', NULL, NULL, NULL, NULL, '6152 Buckingham Dr.', 'Sedro Woolley', 'WA', '17042', 'USA', 0);
INSERT INTO accounts VALUES ('91dfc12a-3ad7-1830-ec75-438dfbd5a084', '2005-11-30 19:19:48', '2005-11-30 19:19:48', '1', 'beth_id', '1', 'Worsham-Bernal Construction Company', NULL, 'Consulting', 'Construction', NULL, NULL, '7647 Valencia Place', 'Lake Oswego', 'OR', '4753', 'USA', NULL, NULL, '596-555-8297', NULL, NULL, NULL, 'www.worsham-bernalconstructioncompany.com', NULL, NULL, NULL, NULL, '7647 Valencia Place', 'Lake Oswego', 'OR', '4753', 'USA', 0);
INSERT INTO accounts VALUES ('c1d693f0-0e67-c6e7-1b94-438dfb1fb102', '2005-11-30 19:19:48', '2005-11-30 19:19:48', '1', 'max_id', '1', 'C & A Zimmerman Engineering Group', NULL, 'Supply', 'Engineering', NULL, NULL, '1107 La Corte Bonita', 'Cliffside', 'BC', '69514', 'Canada', NULL, NULL, '276-555-3847', NULL, NULL, NULL, 'www.cazimmermanengineeringgroup.com', NULL, NULL, NULL, NULL, '1107 La Corte Bonita', 'Cliffside', 'BC', '69514', 'Canada', 0);
INSERT INTO accounts VALUES ('f1d85360-594a-7da8-d4d5-438dfb1d0846', '2005-11-30 19:19:48', '2005-11-30 19:19:48', '1', 'kristen_id', '1', 'Zimmerman-Evans Construction, Ltd', NULL, 'Consulting', 'Construction', NULL, NULL, '5511 Cape Cod Way', 'Altadena', 'CA', '23387', 'USA', NULL, NULL, '942-555-3283', NULL, NULL, NULL, 'www.zimmerman-evansconstruction,ltd.com', NULL, NULL, NULL, NULL, '5511 Cape Cod Way', 'Altadena', 'CA', '23387', 'USA', 0);
INSERT INTO accounts VALUES ('3b4f6477-a81d-c6ed-1cac-438dfb238ccf', '2005-11-30 19:19:49', '2005-11-30 19:19:49', '1', 'chris_id', '1', 'U & S Bowman Transportation, Inc', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '1880 Birchwood', 'San Gabriel', 'CA', '28017', 'USA', NULL, NULL, '884-555-1119', NULL, NULL, NULL, 'www.usbowmantransportation,inc.com', NULL, NULL, NULL, NULL, '1880 Birchwood', 'San Gabriel', 'CA', '28017', 'USA', 0);
INSERT INTO accounts VALUES ('6e233c2a-56ac-7b5b-7651-438dfb8fcb9e', '2005-11-30 19:19:49', '2005-11-30 19:19:49', '1', 'will_id', '1', 'Bowman-Coleman Construction Group', NULL, 'Distribution', 'Construction', NULL, NULL, '3883 Kirkwood Dr', 'Novato', 'CA', '47051', 'USA', NULL, NULL, '673-555-8183', NULL, NULL, NULL, 'www.bowman-colemanconstructiongroup.com', NULL, NULL, NULL, NULL, '3883 Kirkwood Dr', 'Novato', 'CA', '47051', 'USA', 0);
INSERT INTO accounts VALUES ('ac75ac3d-99ba-4688-6ab1-438dfbcae3c6', '2005-11-30 19:19:49', '2005-11-30 19:19:49', '1', 'sarah_id', '1', 'N & W Chrisulis Transportation Corp', NULL, 'Distribution', 'Transportation', NULL, NULL, '3162 Asilomaar Dr', 'San Diego', 'CA', '17843', 'USA', NULL, NULL, '638-555-4647', NULL, NULL, NULL, 'www.nwchrisulistransportationcorp.com', NULL, NULL, NULL, NULL, '3162 Asilomaar Dr', 'San Diego', 'CA', '17843', 'USA', 0);
INSERT INTO accounts VALUES ('f154f522-1cdd-fdd4-ef3d-438dfb9d46f1', '2005-11-30 19:19:49', '2005-11-30 19:19:49', '1', 'matt_id', '1', 'Chrisulis-Whitcomb Engineering Partners', NULL, 'Supply', 'Engineering', NULL, NULL, '8075 Shangri-la Rd.', 'Ladner', 'BC', '30396', 'Canada', NULL, NULL, '449-555-1340', NULL, NULL, NULL, 'www.chrisulis-whitcombengineeringpartners.com', NULL, NULL, NULL, NULL, '8075 Shangri-la Rd.', 'Ladner', 'BC', '30396', 'Canada', 0);
INSERT INTO accounts VALUES ('3bc87d3b-43cb-efdf-efd1-438dfbcb8a22', '2005-11-30 19:19:50', '2005-11-30 19:19:50', '1', 'sarah_id', '1', 'O & D Turcios Communications Associates', NULL, 'Distribution', 'Communications', NULL, NULL, '4951 G Street', 'Hidalgo', 'Zacatecas', '65284', 'Mexico', NULL, NULL, '676-555-9090', NULL, NULL, NULL, 'www.odturcioscommunicationsassociates.com', NULL, NULL, NULL, NULL, '4951 G Street', 'Hidalgo', 'Zacatecas', '65284', 'Mexico', 0);
INSERT INTO accounts VALUES ('6ee7d92a-216a-95bc-3cbb-438dfb280b1c', '2005-11-30 19:19:50', '2005-11-30 19:19:50', '1', 'sally_id', '1', 'Turcios-Confetti Transportation Company', NULL, 'Consulting', 'Transportation', NULL, NULL, '2775 Robinson Ave.', 'Long Beach', 'CA', '89348', 'USA', NULL, NULL, '750-555-8069', NULL, NULL, NULL, 'www.turcios-confettitransportationcompany.com', NULL, NULL, NULL, NULL, '2775 Robinson Ave.', 'Long Beach', 'CA', '89348', 'USA', 0);
INSERT INTO accounts VALUES ('a63a0010-23ef-efac-92d7-438dfb61e338', '2005-11-30 19:19:50', '2005-11-30 19:19:50', '1', 'sally_id', '1', 'M & Y Takemura Communications, Ltd', NULL, 'Supply', 'Communications', NULL, NULL, '2561 Palm St.', 'Albany', 'OR', '91463', 'USA', NULL, NULL, '290-555-7190', NULL, NULL, NULL, 'www.mytakemuracommunications,ltd.com', NULL, NULL, NULL, NULL, '2561 Palm St.', 'Albany', 'OR', '91463', 'USA', 0);
INSERT INTO accounts VALUES ('dd602b0b-cf10-4d7b-a6dc-438dfb4b4355', '2005-11-30 19:19:50', '2005-11-30 19:19:50', '1', 'beth_id', '1', 'Takemura-Campbell Communications Associates', NULL, 'Consulting', 'Communications', NULL, NULL, '639 La Corte Bonita', 'Torrance', 'CA', '89834', 'USA', NULL, NULL, '386-555-4797', NULL, NULL, NULL, 'www.takemura-campbellcommunicationsassociates.com', NULL, NULL, NULL, NULL, '639 La Corte Bonita', 'Torrance', 'CA', '89834', 'USA', 0);
INSERT INTO accounts VALUES ('2129c10e-0acb-645f-11b5-438dfb42e470', '2005-11-30 19:19:51', '2005-11-30 19:19:51', '1', 'max_id', '1', 'B & D Smith Machinery Partners', NULL, 'Consulting', 'Machinery', NULL, NULL, '679 Minert Rd.', 'Ballard', 'WA', '20735', 'USA', NULL, NULL, '659-555-9804', NULL, NULL, NULL, 'www.bdsmithmachinerypartners.com', NULL, NULL, NULL, NULL, '679 Minert Rd.', 'Ballard', 'WA', '20735', 'USA', 0);
INSERT INTO accounts VALUES ('54f75fe1-4a08-d273-3e6c-438dfbebf9b1', '2005-11-30 19:19:51', '2005-11-30 19:19:51', '1', 'sarah_id', '1', 'Smith-Vuong Construction Partners', NULL, 'Manufacturing', 'Construction', NULL, NULL, '1666 Edward Avenue', 'Bellingham', 'WA', '34155', 'USA', NULL, NULL, '117-555-9697', NULL, NULL, NULL, 'www.smith-vuongconstructionpartners.com', NULL, NULL, NULL, NULL, '1666 Edward Avenue', 'Bellingham', 'WA', '34155', 'USA', 0);
INSERT INTO accounts VALUES ('8c9213bf-2128-c0bb-fd39-438dfb6b788b', '2005-11-30 19:19:51', '2005-11-30 19:19:51', '1', 'kristen_id', '1', 'H & E Abbott Machinery Group', NULL, 'Supply', 'Machinery', NULL, NULL, '1961 Marfargoa Drive', 'Edmonds', 'WA', '10561', 'USA', NULL, NULL, '652-555-7990', NULL, NULL, NULL, 'www.heabbottmachinerygroup.com', NULL, NULL, NULL, NULL, '1961 Marfargoa Drive', 'Edmonds', 'WA', '10561', 'USA', 0);
INSERT INTO accounts VALUES ('c41cc4a0-ff49-fd83-b6d0-438dfbeffe1c', '2005-11-30 19:19:51', '2005-11-30 19:19:51', '1', 'beth_id', '1', 'Abbott-Liff Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '3202 Jalisco', 'Cliffside', 'BC', '58402', 'Canada', NULL, NULL, '133-555-6511', NULL, NULL, NULL, 'www.abbott-liffelectronicsholdings.com', NULL, NULL, NULL, NULL, '3202 Jalisco', 'Cliffside', 'BC', '58402', 'Canada', 0);
INSERT INTO accounts VALUES ('f6870d09-d6c5-0cde-9d5c-438dfb898ff7', '2005-11-30 19:19:52', '2005-11-30 19:19:52', '1', 'max_id', '1', 'X & M Steinberg Construction Corp', NULL, 'Manufacturing', 'Construction', NULL, NULL, '6406 Marlesta Rd.', 'Lebanon', 'OR', '31710', 'USA', NULL, NULL, '690-555-3433', NULL, NULL, NULL, 'www.xmsteinbergconstructioncorp.com', NULL, NULL, NULL, NULL, '6406 Marlesta Rd.', 'Lebanon', 'OR', '31710', 'USA', 0);
INSERT INTO accounts VALUES ('51850727-7a19-5744-1bc2-438dfbc55957', '2005-11-30 19:19:52', '2005-11-30 19:19:52', '1', 'sally_id', '1', 'Steinberg-Megel Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '7901 Moccasin Ct.', 'Bellflower', 'CA', '45713', 'USA', NULL, NULL, '194-555-9583', NULL, NULL, NULL, 'www.steinberg-megeltelecommunications,ltd.com', NULL, NULL, NULL, NULL, '7901 Moccasin Ct.', 'Bellflower', 'CA', '45713', 'USA', 0);
INSERT INTO accounts VALUES ('89f05f1d-00d1-f9ad-ed10-438dfbfa7346', '2005-11-30 19:19:52', '2005-11-30 19:19:52', '1', 'chris_id', '1', 'I & M Styles Transportation, Ltd', NULL, 'Supply', 'Transportation', NULL, NULL, '4016 Boyd', 'Spring Valley', 'CA', '84181', 'USA', NULL, NULL, '113-555-8790', NULL, NULL, NULL, 'www.imstylestransportation,ltd.com', NULL, NULL, NULL, NULL, '4016 Boyd', 'Spring Valley', 'CA', '84181', 'USA', 0);
INSERT INTO accounts VALUES ('c2ca1db8-72b2-aab3-1671-438dfb5b7b18', '2005-11-30 19:19:52', '2005-11-30 19:19:52', '1', 'will_id', '1', 'Styles-Head Electronics Corp', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '5765 Mellowood St.', 'Novato', 'CA', '38054', 'USA', NULL, NULL, '540-555-4568', NULL, NULL, NULL, 'www.styles-headelectronicscorp.com', NULL, NULL, NULL, NULL, '5765 Mellowood St.', 'Novato', 'CA', '38054', 'USA', 0);
INSERT INTO accounts VALUES ('f2d60744-2eaf-0fad-53fc-438dfb112702', '2005-11-30 19:19:53', '2005-11-30 19:19:53', '1', 'kristen_id', '1', 'H & Y Story Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '2134 Royal Links Ct', 'San Carlos', 'CA', '68977', 'USA', NULL, NULL, '482-555-2404', NULL, NULL, NULL, 'www.hystoryengineering,inc.com', NULL, NULL, NULL, NULL, '2134 Royal Links Ct', 'San Carlos', 'CA', '68977', 'USA', 0);
INSERT INTO accounts VALUES ('376bf639-52df-9ade-ba53-438dfba662ea', '2005-11-30 19:19:53', '2005-11-30 19:19:53', '1', 'jaime_id', '1', 'Story-Boone Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '6793 Bonifacio St.', 'Woodland Hills', 'CA', '88011', 'USA', NULL, NULL, '271-555-9468', NULL, NULL, NULL, 'www.story-boonetelecommunications,ltd.com', NULL, NULL, NULL, NULL, '6793 Bonifacio St.', 'Woodland Hills', 'CA', '88011', 'USA', 0);
INSERT INTO accounts VALUES ('7ad7b724-722c-afde-9e26-438dfb765b79', '2005-11-30 19:19:53', '2005-11-30 19:19:53', '1', 'sally_id', '1', 'D & A Mccoy Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '3416 Ravenwood Drive', 'Camacho', 'Zacatecas', '58803', 'Mexico', NULL, NULL, '587-555-2850', NULL, NULL, NULL, 'www.damccoymachinerygroup.com', NULL, NULL, NULL, NULL, '3416 Ravenwood Drive', 'Camacho', 'Zacatecas', '58803', 'Mexico', 0);
INSERT INTO accounts VALUES ('ab3f11d0-c24f-2a9c-84d1-438dfb1185e4', '2005-11-30 19:19:53', '2005-11-30 19:19:53', '1', 'max_id', '1', 'Mccoy-Tuck Construction Associates', NULL, 'Consulting', 'Construction', NULL, NULL, '8329 La Vuelta', 'Arcadia', 'CA', '43999', 'USA', NULL, NULL, '638-555-3200', NULL, NULL, NULL, 'www.mccoy-tuckconstructionassociates.com', NULL, NULL, NULL, NULL, '8329 La Vuelta', 'Arcadia', 'CA', '43999', 'USA', 0);
INSERT INTO accounts VALUES ('db69fc79-b660-0433-6cd8-438dfb76b979', '2005-11-30 19:19:53', '2005-11-30 19:19:53', '1', 'max_id', '1', 'D & Z Sincich Electronics, Ltd', NULL, 'Consulting', 'Electronics', NULL, NULL, '7861 Yosemite Dr.', 'Downey', 'CA', '79952', 'USA', NULL, NULL, '626-555-7293', NULL, NULL, NULL, 'www.dzsincichelectronics,ltd.com', NULL, NULL, NULL, NULL, '7861 Yosemite Dr.', 'Downey', 'CA', '79952', 'USA', 0);
INSERT INTO accounts VALUES ('1fde64a0-ec9f-2527-1ea6-438dfb8a5d08', '2005-11-30 19:19:54', '2005-11-30 19:19:54', '1', 'kristen_id', '1', 'Sincich-Jameson Engineering Corp', NULL, 'Consulting', 'Engineering', NULL, NULL, '3029 Heather Leaf Ln.', 'Los Angeles', 'CA', '31309', 'USA', NULL, NULL, '699-555-6272', NULL, NULL, NULL, 'www.sincich-jamesonengineeringcorp.com', NULL, NULL, NULL, NULL, '3029 Heather Leaf Ln.', 'Los Angeles', 'CA', '31309', 'USA', 0);
INSERT INTO accounts VALUES ('6c7b6081-0197-c017-49df-438dfb374396', '2005-11-30 19:19:54', '2005-11-30 19:19:54', '1', 'will_id', '1', 'Q & Q Sanchez Telecommunications Associates', NULL, 'Supply', 'Telecommunications', NULL, NULL, '2815 La Vuelta', 'Everett', 'WA', '33424', 'USA', NULL, NULL, '949-555-3650', NULL, NULL, NULL, 'www.qqsancheztelecommunicationsassociates.com', NULL, NULL, NULL, NULL, '2815 La Vuelta', 'Everett', 'WA', '33424', 'USA', 0);
INSERT INTO accounts VALUES ('9d57fdf9-bb75-7a8e-43a4-438dfb49fa3f', '2005-11-30 19:19:54', '2005-11-30 19:19:54', '1', 'max_id', '1', 'Sanchez-Parks Engineering Company', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '5581 Stanford Street', 'N. Vancouver', 'BC', '49943', 'Canada', NULL, NULL, '145-555-1257', NULL, NULL, NULL, 'www.sanchez-parksengineeringcompany.com', NULL, NULL, NULL, NULL, '5581 Stanford Street', 'N. Vancouver', 'BC', '49943', 'Canada', 0);
INSERT INTO accounts VALUES ('dadf62da-b669-bdae-9db7-438dfbf0a9cf', '2005-11-30 19:19:54', '2005-11-30 19:19:54', '1', 'matt_id', '1', 'Y & R Vij Machinery, Inc', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '8277 Pinole Valley Rd.', 'Daly City', 'CA', '18219', 'USA', NULL, NULL, '657-555-9922', NULL, NULL, NULL, 'www.yrvijmachinery,inc.com', NULL, NULL, NULL, NULL, '8277 Pinole Valley Rd.', 'Daly City', 'CA', '18219', 'USA', 0);
INSERT INTO accounts VALUES ('1f8456e5-21d4-6023-8d8b-438dfb7d19c8', '2005-11-30 19:19:55', '2005-11-30 19:19:55', '1', 'sarah_id', '1', 'Vij-Zugschwert Engineering, Inc', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '6608 Calle Verde Dr.', 'Walla Walla', 'WA', '98284', 'USA', NULL, NULL, '776-555-6157', NULL, NULL, NULL, 'www.vij-zugschwertengineering,inc.com', NULL, NULL, NULL, NULL, '6608 Calle Verde Dr.', 'Walla Walla', 'WA', '98284', 'USA', 0);
INSERT INTO accounts VALUES ('525a01b5-ce2d-6203-5892-438dfb7d2dcd', '2005-11-30 19:19:55', '2005-11-30 19:19:55', '1', 'kristen_id', '1', 'E & F Adams Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '9558 Orchard View Ave.', 'Imperial Beach', 'CA', '32723', 'USA', NULL, NULL, '411-555-4450', NULL, NULL, NULL, 'www.efadamsmachinery,ltd.com', NULL, NULL, NULL, NULL, '9558 Orchard View Ave.', 'Imperial Beach', 'CA', '32723', 'USA', 0);
INSERT INTO accounts VALUES ('8d1a8e12-42ae-5f8b-99ed-438dfbfefb98', '2005-11-30 19:19:55', '2005-11-30 19:19:55', '1', 'chris_id', '1', 'Adams-Steen Transportation Holdings', NULL, 'Distribution', 'Transportation', NULL, NULL, '8144 Ryan Court', 'Richmond', 'CA', '54272', 'USA', NULL, NULL, '791-555-2972', NULL, NULL, NULL, 'www.adams-steentransportationholdings.com', NULL, NULL, NULL, NULL, '8144 Ryan Court', 'Richmond', 'CA', '54272', 'USA', 0);
INSERT INTO accounts VALUES ('be84eeb2-3179-bc9f-19bb-438dfba25b6b', '2005-11-30 19:19:55', '2005-11-30 19:19:55', '1', 'will_id', '1', 'N & O Baker Electronics, Inc', NULL, 'Supply', 'Electronics', NULL, NULL, '1349 Palm Ave.', 'Los Angeles', 'CA', '53872', 'USA', NULL, NULL, '449-555-8893', NULL, NULL, NULL, 'www.nobakerelectronics,inc.com', NULL, NULL, NULL, NULL, '1349 Palm Ave.', 'Los Angeles', 'CA', '53872', 'USA', 0);
INSERT INTO accounts VALUES ('efbc0b52-f58c-a29d-5701-438dfb69e717', '2005-11-30 19:19:55', '2005-11-30 19:19:55', '1', 'kristen_id', '1', 'Baker-Pearl Machinery Group', NULL, 'Distribution', 'Machinery', NULL, NULL, '2844 Plymouth Drive', 'Newton', 'BC', '41583', 'Canada', NULL, NULL, '853-555-6043', NULL, NULL, NULL, 'www.baker-pearlmachinerygroup.com', NULL, NULL, NULL, NULL, '2844 Plymouth Drive', 'Newton', 'BC', '41583', 'Canada', 0);
INSERT INTO accounts VALUES ('491bb8cb-9fa3-e979-3d0e-438dfb23148f', '2005-11-30 19:19:56', '2005-11-30 19:19:56', '1', 'beth_id', '1', 'U & W Roundtree Construction Corp', NULL, 'Supply', 'Construction', NULL, NULL, '8958 Las Palmas', 'Merida', 'Yucatan', '73444', 'Mexico', NULL, NULL, '772-555-5250', NULL, NULL, NULL, 'www.uwroundtreeconstructioncorp.com', NULL, NULL, NULL, NULL, '8958 Las Palmas', 'Merida', 'Yucatan', '73444', 'Mexico', 0);
INSERT INTO accounts VALUES ('98e876e2-cf6d-9fcc-6d59-438dfb12781a', '2005-11-30 19:19:56', '2005-11-30 19:19:56', '1', 'max_id', '1', 'Roundtree-Bollin Electronics Company', NULL, 'Consulting', 'Electronics', NULL, NULL, '708 Bonifacio', 'Ladner', 'BC', '60216', 'Canada', NULL, NULL, '426-555-2426', NULL, NULL, NULL, 'www.roundtree-bollinelectronicscompany.com', NULL, NULL, NULL, NULL, '708 Bonifacio', 'Ladner', 'BC', '60216', 'Canada', 0);
INSERT INTO accounts VALUES ('c9f9a26d-7f8a-ada3-5257-438dfbcd245e', '2005-11-30 19:19:56', '2005-11-30 19:19:56', '1', 'chris_id', '1', 'M & K Hopkins Telecommunications, Ltd', NULL, 'Supply', 'Telecommunications', NULL, NULL, '7076 Terry Lynn Lane', 'Port Hammond', 'BC', '64846', 'Canada', NULL, NULL, '368-555-9262', NULL, NULL, NULL, 'www.mkhopkinstelecommunications,ltd.com', NULL, NULL, NULL, NULL, '7076 Terry Lynn Lane', 'Port Hammond', 'BC', '64846', 'Canada', 0);
INSERT INTO accounts VALUES ('5e3b05ab-1491-e073-63e8-438dfb5de624', '2005-11-30 19:19:57', '2005-11-30 19:19:57', '1', 'sarah_id', '1', 'Hopkins-Vicknair Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '1736 Windsor Drive', 'Coronado', 'CA', '83880', 'USA', NULL, NULL, '156-555-7326', NULL, NULL, NULL, 'www.hopkins-vicknairmachinery,ltd.com', NULL, NULL, NULL, NULL, '1736 Windsor Drive', 'Coronado', 'CA', '83880', 'USA', 0);
INSERT INTO accounts VALUES ('4969f1d8-0c9d-788f-62f6-438dfb89a07c', '2005-11-30 19:19:57', '2005-11-30 19:19:57', '1', 'beth_id', '1', 'L & E McPhearson Communications Partners', NULL, 'Distribution', 'Communications', NULL, NULL, '8358 St. Helena Drive', 'Marysville', 'WA', '80965', 'USA', NULL, NULL, '122-555-3790', NULL, NULL, NULL, 'www.lemcphearsoncommunicationspartners.com', NULL, NULL, NULL, NULL, '8358 St. Helena Drive', 'Marysville', 'WA', '80965', 'USA', 0);
INSERT INTO accounts VALUES ('85d65ddd-8632-09d9-f47f-438dfb6f4e9c', '2005-11-30 19:19:57', '2005-11-30 19:19:57', '1', 'sally_id', '1', 'McPhearson-Albright Construction Holdings', NULL, 'Consulting', 'Construction', NULL, NULL, '5927 Mt. Hood Circle', 'Fremont', 'CA', '66160', 'USA', NULL, NULL, '172-555-4141', NULL, NULL, NULL, 'www.mcphearson-albrightconstructionholdings.com', NULL, NULL, NULL, NULL, '5927 Mt. Hood Circle', 'Fremont', 'CA', '66160', 'USA', 0);
INSERT INTO accounts VALUES ('c031e40c-7c5d-6e0b-1185-438dfb943437', '2005-11-30 19:19:57', '2005-11-30 19:19:57', '1', 'kristen_id', '1', 'W & N Thomas Telecommunications Partners', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '2804 Boxer Blvd.', 'Albany', 'OR', '31145', 'USA', NULL, NULL, '160-555-8233', NULL, NULL, NULL, 'www.wnthomastelecommunicationspartners.com', NULL, NULL, NULL, NULL, '2804 Boxer Blvd.', 'Albany', 'OR', '31145', 'USA', 0);
INSERT INTO accounts VALUES ('fd9f0714-4cc5-16de-882f-438dfbb90a2d', '2005-11-30 19:19:58', '2005-11-30 19:19:58', '1', 'sally_id', '1', 'Thomas-Perko Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '628 Marina Lakes Drive', 'Langley', 'BC', '53471', 'Canada', NULL, NULL, '233-555-7212', NULL, NULL, NULL, 'www.thomas-perkotransportationholdings.com', NULL, NULL, NULL, NULL, '628 Marina Lakes Drive', 'Langley', 'BC', '53471', 'Canada', 0);
INSERT INTO accounts VALUES ('58469e50-1f41-538f-1887-438dfbf47114', '2005-11-30 19:19:58', '2005-11-30 19:19:58', '1', 'beth_id', '1', 'V & A McCarty Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '414 Joseph Ave', 'Langley', 'BC', '55586', 'Canada', NULL, NULL, '483-555-4590', NULL, NULL, NULL, 'www.vamccartytransportationcorp.com', NULL, NULL, NULL, NULL, '414 Joseph Ave', 'Langley', 'BC', '55586', 'Canada', 0);
INSERT INTO accounts VALUES ('88a915af-39ff-75b6-8493-438dfb8c230c', '2005-11-30 19:19:58', '2005-11-30 19:19:58', '1', 'max_id', '1', 'McCarty-Bent Communications Corp', NULL, 'Consulting', 'Communications', NULL, NULL, '8490 Longbrood Way', 'Sedro Woolley', 'WA', '45813', 'USA', NULL, NULL, '579-555-2198', NULL, NULL, NULL, 'www.mccarty-bentcommunicationscorp.com', NULL, NULL, NULL, NULL, '8490 Longbrood Way', 'Sedro Woolley', 'WA', '45813', 'USA', 0);
INSERT INTO accounts VALUES ('cd6049bd-74fc-b5d1-5eb3-438dfbd81e96', '2005-11-30 19:19:58', '2005-11-30 19:19:58', '1', 'sally_id', '1', 'T & A Chambers Electronics, Inc', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '8531 Bayter Court', 'Burlingame', 'CA', '14089', 'USA', NULL, NULL, '191-555-1862', NULL, NULL, NULL, 'www.tachamberselectronics,inc.com', NULL, NULL, NULL, NULL, '8531 Bayter Court', 'Burlingame', 'CA', '14089', 'USA', 0);
INSERT INTO accounts VALUES ('1e347806-aeec-67b7-cab2-438dfb351dff', '2005-11-30 19:19:59', '2005-11-30 19:19:59', '1', 'matt_id', '1', 'Chambers-Bellifa Construction Associates', NULL, 'Manufacturing', 'Construction', NULL, NULL, '6863 Shakespeare Dr', 'Sooke', 'BC', '87695', 'Canada', NULL, NULL, '310-555-7098', NULL, NULL, NULL, 'www.chambers-bellifaconstructionassociates.com', NULL, NULL, NULL, NULL, '6863 Shakespeare Dr', 'Sooke', 'BC', '87695', 'Canada', 0);
INSERT INTO accounts VALUES ('4e66e474-6dde-7f87-b0d7-438dfb216074', '2005-11-30 19:19:59', '2005-11-30 19:19:59', '1', 'chris_id', '1', 'D & D Johnson Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '9813 Morgan Terr. Rd', 'San Andres', 'DF', '22133', 'Mexico', NULL, NULL, '845-555-5391', NULL, NULL, NULL, 'www.ddjohnsonelectronicsholdings.com', NULL, NULL, NULL, NULL, '9813 Morgan Terr. Rd', 'San Andres', 'DF', '22133', 'Mexico', 0);
INSERT INTO accounts VALUES ('9626413b-867f-30ae-432f-438dfbf756c4', '2005-11-30 19:19:59', '2005-11-30 19:19:59', '1', 'sarah_id', '1', 'Johnson-Vrins Machinery, Inc', NULL, 'Distribution', 'Machinery', NULL, NULL, '1055 Horseshoe Road', 'Pomona', 'CA', '43683', 'USA', NULL, NULL, '677-555-9829', NULL, NULL, NULL, 'www.johnson-vrinsmachinery,inc.com', NULL, NULL, NULL, NULL, '1055 Horseshoe Road', 'Pomona', 'CA', '43683', 'USA', 0);
INSERT INTO accounts VALUES ('c64c35eb-a23d-9f87-b108-438dfb9c6d90', '2005-11-30 19:19:59', '2005-11-30 19:19:59', '1', 'sally_id', '1', 'I & V Mcdonald Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '4259 Fenway', 'Downey', 'CA', '43282', 'USA', NULL, NULL, '335-555-6751', NULL, NULL, NULL, 'www.ivmcdonaldengineering,inc.com', NULL, NULL, NULL, NULL, '4259 Fenway', 'Downey', 'CA', '43282', 'USA', 0);
INSERT INTO accounts VALUES ('246c06f3-95cd-ae33-9d0c-438dfb0edc32', '2005-11-30 19:20:00', '2005-11-30 19:20:00', '1', 'beth_id', '1', 'Mcdonald-Weldon Construction, Ltd', NULL, 'Manufacturing', 'Construction', NULL, NULL, '5754 Glenhaven Ave', 'Palo Alto', 'CA', '30993', 'USA', NULL, NULL, '738-555-3901', NULL, NULL, NULL, 'www.mcdonald-weldonconstruction,ltd.com', NULL, NULL, NULL, NULL, '5754 Glenhaven Ave', 'Palo Alto', 'CA', '30993', 'USA', 0);
INSERT INTO accounts VALUES ('60a548ab-9be6-abaf-60b7-438dfb019948', '2005-11-30 19:20:00', '2005-11-30 19:20:00', '1', 'matt_id', '1', 'K & R Choin Communications Group', NULL, 'Consulting', 'Communications', NULL, NULL, '9212 Tupelo Drive', 'Everett', 'WA', '69462', 'USA', NULL, NULL, '658-555-3108', NULL, NULL, NULL, 'www.krchoincommunicationsgroup.com', NULL, NULL, NULL, NULL, '9212 Tupelo Drive', 'Everett', 'WA', '69462', 'USA', 0);
INSERT INTO accounts VALUES ('a68c98c0-4ad9-f9d5-763e-438dfb7b0059', '2005-11-30 19:20:00', '2005-11-30 19:20:00', '1', 'jaime_id', '1', 'Choin-Crow Engineering Associates', NULL, 'Distribution', 'Engineering', NULL, NULL, '3618 Galveston Ct', 'Acapulco', 'Guerrero', '49627', 'Mexico', NULL, NULL, '184-555-7886', NULL, NULL, NULL, 'www.choin-crowengineeringassociates.com', NULL, NULL, NULL, NULL, '3618 Galveston Ct', 'Acapulco', 'Guerrero', '49627', 'Mexico', 0);
INSERT INTO accounts VALUES ('e1980070-bbae-c220-1f68-438dfb8a1752', '2005-11-30 19:20:00', '2005-11-30 19:20:00', '1', 'max_id', '1', 'B & P Avalos Telecommunications Holdings', NULL, 'Distribution', 'Telecommunications', NULL, NULL, '9986 El Pintado', 'Tlaxiaco', 'Oaxaca', '54257', 'Mexico', NULL, NULL, '127-555-5722', NULL, NULL, NULL, 'www.bpavalostelecommunicationsholdings.com', NULL, NULL, NULL, NULL, '9986 El Pintado', 'Tlaxiaco', 'Oaxaca', '54257', 'Mexico', 0);
INSERT INTO accounts VALUES ('2895b03d-cb51-0cd3-9430-438dfb1b06da', '2005-11-30 19:20:01', '2005-11-30 19:20:01', '1', 'kristen_id', '1', 'Avalos-Jacobsen Electronics, Ltd', NULL, 'Distribution', 'Electronics', NULL, NULL, '1990 Guadalajara', 'Redmond', 'WA', '73291', 'USA', NULL, NULL, '815-555-3786', NULL, NULL, NULL, 'www.avalos-jacobsenelectronics,ltd.com', NULL, NULL, NULL, NULL, '1990 Guadalajara', 'Redmond', 'WA', '73291', 'USA', 0);
INSERT INTO accounts VALUES ('66d00a03-e597-5517-a003-438dfb44736f', '2005-11-30 19:20:01', '2005-11-30 19:20:01', '1', 'chris_id', '1', 'Q & P Castro Telecommunications Company', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, '2515 Live Oak', 'Haney', 'BC', '44083', 'Canada', NULL, NULL, '120-555-3908', NULL, NULL, NULL, 'www.qpcastrotelecommunicationscompany.com', NULL, NULL, NULL, NULL, '2515 Live Oak', 'Haney', 'BC', '44083', 'Canada', 0);
INSERT INTO accounts VALUES ('a2776c86-3e80-10f5-2de4-438dfb23244f', '2005-11-30 19:20:01', '2005-11-30 19:20:01', '1', 'beth_id', '1', 'Castro-Caldwell Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '7427 Grove Way', 'Burien', 'WA', '29279', 'USA', NULL, NULL, '831-555-9601', NULL, NULL, NULL, 'www.castro-caldwelltransportationholdings.com', NULL, NULL, NULL, NULL, '7427 Grove Way', 'Burien', 'WA', '29279', 'USA', 0);
INSERT INTO accounts VALUES ('e9530c09-f5de-20b4-af8d-438dfb19709c', '2005-11-30 19:20:01', '2005-11-30 19:20:01', '1', 'kristen_id', '1', 'G & N Reed Communications Group', NULL, 'Supply', 'Communications', NULL, NULL, '6960 Trees Drive', 'Mexico City', 'Mexico', '65232', 'Mexico', NULL, NULL, '158-555-8351', NULL, NULL, NULL, 'www.gnreedcommunicationsgroup.com', NULL, NULL, NULL, NULL, '6960 Trees Drive', 'Mexico City', 'Mexico', '65232', 'Mexico', 0);
INSERT INTO accounts VALUES ('3be5af30-4e43-3bb3-ea0e-438dfb1db842', '2005-11-30 19:20:02', '2005-11-30 19:20:02', '1', 'kristen_id', '1', 'Reed-Kelley Construction Partners', NULL, 'Distribution', 'Construction', NULL, NULL, '2128 Evelyn Court', 'Merida', 'Yucatan', '16590', 'Mexico', NULL, NULL, '892-555-3672', NULL, NULL, NULL, 'www.reed-kelleyconstructionpartners.com', NULL, NULL, NULL, NULL, '2128 Evelyn Court', 'Merida', 'Yucatan', '16590', 'Mexico', 0);
INSERT INTO accounts VALUES ('7a40535d-16bc-7148-7e8e-438dfbd13045', '2005-11-30 19:20:02', '2005-11-30 19:20:02', '1', 'kristen_id', '1', 'H & Y Taylor Electronics, Ltd', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '1914 Creekside Dr.', 'Hidalgo', 'Zacatecas', '18704', 'Mexico', NULL, NULL, '242-555-1051', NULL, NULL, NULL, 'www.hytaylorelectronics,ltd.com', NULL, NULL, NULL, NULL, '1914 Creekside Dr.', 'Hidalgo', 'Zacatecas', '18704', 'Mexico', 0);
INSERT INTO accounts VALUES ('c1dfef1c-954e-f743-4420-438dfbf77140', '2005-11-30 19:20:02', '2005-11-30 19:20:02', '1', 'chris_id', '1', 'Taylor-Robinson Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '9991 El Pintado Road', 'Lemon Grove', 'CA', '35223', 'USA', NULL, NULL, '689-555-4575', NULL, NULL, NULL, 'www.taylor-robinsontransportationholdings.com', NULL, NULL, NULL, NULL, '9991 El Pintado Road', 'Lemon Grove', 'CA', '35223', 'USA', 0);
INSERT INTO accounts VALUES ('f204b148-7344-8404-effe-438dfbd36480', '2005-11-30 19:20:02', '2005-11-30 19:20:02', '1', 'sarah_id', '1', 'O & K Thomsen Transportation Corp', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '32 Sun View Terrace', 'Ladner', 'BC', '35005', 'Canada', NULL, NULL, '301-555-4240', NULL, NULL, NULL, 'www.okthomsentransportationcorp.com', NULL, NULL, NULL, NULL, '32 Sun View Terrace', 'Ladner', 'BC', '35005', 'Canada', 0);
INSERT INTO accounts VALUES ('39b65b2c-1c46-a998-60d5-438dfbbf9075', '2005-11-30 19:20:03', '2005-11-30 19:20:03', '1', 'beth_id', '1', 'Thomsen-Baldwin Construction Partners', NULL, 'Consulting', 'Construction', NULL, NULL, '1019 Mt. Davidson Court', 'Burien', 'WA', '10857', 'USA', NULL, NULL, '420-555-9475', NULL, NULL, NULL, 'www.thomsen-baldwinconstructionpartners.com', NULL, NULL, NULL, NULL, '1019 Mt. Davidson Court', 'Burien', 'WA', '10857', 'USA', 0);
INSERT INTO accounts VALUES ('8464a7b2-7bd4-225d-f11c-438dfb5e239a', '2005-11-30 19:20:03', '2005-11-30 19:20:03', '1', 'sally_id', '1', 'D & D Yuhasz Transportation, Ltd', NULL, 'Distribution', 'Transportation', NULL, NULL, '1314 Skyline Dr.', 'Anacortes', 'WA', '44295', 'USA', NULL, NULL, '955-555-7768', NULL, NULL, NULL, 'www.ddyuhasztransportation,ltd.com', NULL, NULL, NULL, NULL, '1314 Skyline Dr.', 'Anacortes', 'WA', '44295', 'USA', 0);
INSERT INTO accounts VALUES ('c0c97998-e5de-2fc8-e002-438dfb6708a1', '2005-11-30 19:20:03', '2005-11-30 19:20:03', '1', 'kristen_id', '1', 'Yuhasz-Carmody Machinery, Inc', NULL, 'Consulting', 'Machinery', NULL, NULL, '2555 Via Rosa', 'Royal Oak', 'BC', '92137', 'Canada', NULL, NULL, '436-555-6290', NULL, NULL, NULL, 'www.yuhasz-carmodymachinery,inc.com', NULL, NULL, NULL, NULL, '2555 Via Rosa', 'Royal Oak', 'BC', '92137', 'Canada', 0);
INSERT INTO accounts VALUES ('f0d414d6-6382-fbfc-3b0b-438dfbb822cd', '2005-11-30 19:20:03', '2005-11-30 19:20:03', '1', 'beth_id', '1', 'E & M Gonzales Electronics Company', NULL, 'Supply', 'Electronics', NULL, NULL, '5759 Benton Street', 'Oregon City', 'OR', '65444', 'USA', NULL, NULL, '993-555-3211', NULL, NULL, NULL, 'www.emgonzaleselectronicscompany.com', NULL, NULL, NULL, NULL, '5759 Benton Street', 'Oregon City', 'OR', '65444', 'USA', 0);
INSERT INTO accounts VALUES ('391d6e11-d566-07fe-aeda-438dfb5a9a5a', '2005-11-30 19:20:04', '2005-11-30 19:20:04', '1', 'matt_id', '1', 'Gonzales-Allen Engineering, Ltd', NULL, 'Distribution', 'Engineering', NULL, NULL, '7254 Buchanan Road', 'San Gabriel', 'CA', '79447', 'USA', NULL, NULL, '497-555-9361', NULL, NULL, NULL, 'www.gonzales-allenengineering,ltd.com', NULL, NULL, NULL, NULL, '7254 Buchanan Road', 'San Gabriel', 'CA', '79447', 'USA', 0);
INSERT INTO accounts VALUES ('912be22c-c54f-1a32-4057-438dfb5574c0', '2005-11-30 19:20:04', '2005-11-30 19:20:04', '1', 'matt_id', '1', 'R & Z Caprio Communications, Inc', NULL, 'Distribution', 'Communications', NULL, NULL, '3369 Houston Ct.', 'Westminster', 'BC', '18917', 'Canada', NULL, NULL, '417-555-8568', NULL, NULL, NULL, 'www.rzcapriocommunications,inc.com', NULL, NULL, NULL, NULL, '3369 Houston Ct.', 'Westminster', 'BC', '18917', 'Canada', 0);
INSERT INTO accounts VALUES ('dd28e11e-db7f-ffe0-d6e7-438dfb1adce2', '2005-11-30 19:20:04', '2005-11-30 19:20:04', '1', 'chris_id', '1', 'Caprio-Slaven Machinery Partners', NULL, 'Supply', 'Machinery', NULL, NULL, '5118 Boxwood Dr.', 'Mill Valley', 'CA', '71789', 'USA', NULL, NULL, '843-555-4347', NULL, NULL, NULL, 'www.caprio-slavenmachinerypartners.com', NULL, NULL, NULL, NULL, '5118 Boxwood Dr.', 'Mill Valley', 'CA', '71789', 'USA', 0);
INSERT INTO accounts VALUES ('191db721-4fb7-9a81-3a97-438dfbabdcca', '2005-11-30 19:20:05', '2005-11-30 19:20:05', '1', 'sarah_id', '1', 'J & K Ortiz Communications Corp', NULL, 'Supply', 'Communications', NULL, NULL, '1487 Franklin Canyon Road', 'Palo Alto', 'CA', '37125', 'USA', NULL, NULL, '786-555-2182', NULL, NULL, NULL, 'www.jkortizcommunicationscorp.com', NULL, NULL, NULL, NULL, '1487 Franklin Canyon Road', 'Palo Alto', 'CA', '37125', 'USA', 0);
INSERT INTO accounts VALUES ('58a9b8fd-972b-dd40-72fe-438dfbdd00cf', '2005-11-30 19:20:05', '2005-11-30 19:20:05', '1', 'sally_id', '1', 'Ortiz-Beaver Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '6146 Holland Drive', 'Newport Beach', 'CA', '22746', 'USA', NULL, NULL, '574-555-9247', NULL, NULL, NULL, 'www.ortiz-beaverconstruction,ltd.com', NULL, NULL, NULL, NULL, '6146 Holland Drive', 'Newport Beach', 'CA', '22746', 'USA', 0);
INSERT INTO accounts VALUES ('88e66abc-394e-4d0d-77c4-438dfb3b182d', '2005-11-30 19:20:05', '2005-11-30 19:20:05', '1', 'max_id', '1', 'W & W Rhodes Electronics Associates', NULL, 'Supply', 'Electronics', NULL, NULL, '2769 Edward Ave.', 'Orizaba', 'Veracruz', '92537', 'Mexico', NULL, NULL, '778-555-9368', NULL, NULL, NULL, 'www.wwrhodeselectronicsassociates.com', NULL, NULL, NULL, NULL, '2769 Edward Ave.', 'Orizaba', 'Veracruz', '92537', 'Mexico', 0);
INSERT INTO accounts VALUES ('d1bbf5c1-4c4e-b625-4cfc-438dfb623284', '2005-11-30 19:20:05', '2005-11-30 19:20:05', '1', 'max_id', '1', 'Rhodes-Kaffer Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '7682 Alta Vista', 'Tacoma', 'WA', '77733', 'USA', NULL, NULL, '590-555-6061', NULL, NULL, NULL, 'www.rhodes-kaffermachinerygroup.com', NULL, NULL, NULL, NULL, '7682 Alta Vista', 'Tacoma', 'WA', '77733', 'USA', 0);
INSERT INTO accounts VALUES ('412850a2-6620-056b-3a1c-438dfbaddca9', '2005-11-30 19:20:06', '2005-11-30 19:20:06', '1', 'beth_id', '1', 'D & G Bales Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '7214 Elliott Dr', 'Bellflower', 'CA', '14687', 'USA', NULL, NULL, '271-555-1649', NULL, NULL, NULL, 'www.dgbalestransportation,inc.com', NULL, NULL, NULL, NULL, '7214 Elliott Dr', 'Bellflower', 'CA', '14687', 'USA', 0);
INSERT INTO accounts VALUES ('8d39787d-9fe3-5566-b19b-438dfb80bd18', '2005-11-30 19:20:06', '2005-11-30 19:20:06', '1', 'matt_id', '1', 'Bales-Stotka Engineering, Ltd', NULL, 'Supply', 'Engineering', NULL, NULL, '2382 Wibur Ave.', 'Santa Anita', 'DF', '65044', 'Mexico', NULL, NULL, '105-555-5971', NULL, NULL, NULL, 'www.bales-stotkaengineering,ltd.com', NULL, NULL, NULL, NULL, '2382 Wibur Ave.', 'Santa Anita', 'DF', '65044', 'Mexico', 0);
INSERT INTO accounts VALUES ('ca3c55ee-b53c-f2b2-84e7-438dfb0c8d0c', '2005-11-30 19:20:06', '2005-11-30 19:20:06', '1', 'jaime_id', '1', 'Z & L Maynard Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '2168 Terra Calitina', 'Bellingham', 'WA', '67158', 'USA', NULL, NULL, '355-555-3349', NULL, NULL, NULL, 'www.zlmaynardconstruction,ltd.com', NULL, NULL, NULL, NULL, '2168 Terra Calitina', 'Bellingham', 'WA', '67158', 'USA', 0);
INSERT INTO accounts VALUES ('62a10f63-f686-2144-15ac-438dfbead4e8', '2005-11-30 19:20:07', '2005-11-30 19:20:07', '1', 'will_id', '1', 'Maynard-Tuell Transportation Group', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '246 Weatherly Way', 'Langley', 'BC', '83677', 'Canada', NULL, NULL, '690-555-4614', NULL, NULL, NULL, 'www.maynard-tuelltransportationgroup.com', NULL, NULL, NULL, NULL, '246 Weatherly Way', 'Langley', 'BC', '83677', 'Canada', 0);
INSERT INTO accounts VALUES ('43859232-da58-37c0-179b-438dfbdfa7d4', '2005-11-30 19:20:07', '2005-11-30 19:20:07', '1', 'max_id', '1', 'V & P Burnett Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '2942 Marina Road', 'Acapulco', 'Guerrero', '25662', 'Mexico', NULL, NULL, '963-555-9621', NULL, NULL, NULL, 'www.vpburnetttransportationcorp.com', NULL, NULL, NULL, NULL, '2942 Marina Road', 'Acapulco', 'Guerrero', '25662', 'Mexico', 0);
INSERT INTO accounts VALUES ('90c164b4-f97d-611f-6846-438dfbe89579', '2005-11-30 19:20:07', '2005-11-30 19:20:07', '1', 'will_id', '1', 'Burnett-Haugh Telecommunications, Inc', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '1273 Deetmeadow Way', 'Olympia', 'WA', '83425', 'USA', NULL, NULL, '182-555-5856', NULL, NULL, NULL, 'www.burnett-haughtelecommunications,inc.com', NULL, NULL, NULL, NULL, '1273 Deetmeadow Way', 'Olympia', 'WA', '83425', 'USA', 0);
INSERT INTO accounts VALUES ('cfdf028a-db96-990d-3366-438dfb009b2b', '2005-11-30 19:20:07', '2005-11-30 19:20:07', '1', 'matt_id', '1', 'F & X Moberly Communications Partners', NULL, 'Consulting', 'Communications', NULL, NULL, '4223 Las Trampas Road', 'La Mesa', 'CA', '93185', 'USA', NULL, NULL, '716-555-4149', NULL, NULL, NULL, 'www.fxmoberlycommunicationspartners.com', NULL, NULL, NULL, NULL, '4223 Las Trampas Road', 'La Mesa', 'CA', '93185', 'USA', 0);
INSERT INTO accounts VALUES ('1a26322a-9d2e-13b9-edbd-438dfbdfd6c3', '2005-11-30 19:20:08', '2005-11-30 19:20:08', '1', 'sally_id', '1', 'Moberly-Meyer Communications Holdings', NULL, 'Distribution', 'Communications', NULL, NULL, '2809 Via Montana', 'Colma', 'CA', '30868', 'USA', NULL, NULL, '197-555-2671', NULL, NULL, NULL, 'www.moberly-meyercommunicationsholdings.com', NULL, NULL, NULL, NULL, '2809 Via Montana', 'Colma', 'CA', '30868', 'USA', 0);
INSERT INTO accounts VALUES ('5b9936b0-c7c4-0429-bab3-438dfbf4127a', '2005-11-30 19:20:08', '2005-11-30 19:20:08', '1', 'sarah_id', '1', 'S & X Orona Engineering Partners', NULL, 'Distribution', 'Engineering', NULL, NULL, '8669 Rotherham Dr.', 'Santa Anita', 'DF', '30467', 'Mexico', NULL, NULL, '755-555-8592', NULL, NULL, NULL, 'www.sxoronaengineeringpartners.com', NULL, NULL, NULL, NULL, '8669 Rotherham Dr.', 'Santa Anita', 'DF', '30467', 'Mexico', 0);
INSERT INTO accounts VALUES ('a7df6541-fb86-851e-c556-438dfbffa507', '2005-11-30 19:20:08', '2005-11-30 19:20:08', '1', 'sarah_id', '1', 'Orona-Warmack Transportation, Inc', NULL, 'Supply', 'Transportation', NULL, NULL, '165 Schenone Court', 'Burnaby', 'BC', '18178', 'Canada', NULL, NULL, '259-555-5742', NULL, NULL, NULL, 'www.orona-warmacktransportation,inc.com', NULL, NULL, NULL, NULL, '165 Schenone Court', 'Burnaby', 'BC', '18178', 'Canada', 0);
INSERT INTO accounts VALUES ('e65b04ee-2054-ba82-f056-438dfb5fe583', '2005-11-30 19:20:08', '2005-11-30 19:20:08', '1', 'sarah_id', '1', 'H & N Wall Machinery Corp', NULL, 'Supply', 'Machinery', NULL, NULL, '3623 Barquentine Court', 'Salem', 'OR', '82939', 'USA', NULL, NULL, '178-555-4949', NULL, NULL, NULL, 'www.hnwallmachinerycorp.com', NULL, NULL, NULL, NULL, '3623 Barquentine Court', 'Salem', 'OR', '82939', 'USA', 0);
INSERT INTO accounts VALUES ('3d82526a-12c1-e7eb-ff5a-438dfb9a0629', '2005-11-30 19:20:09', '2005-11-30 19:20:09', '1', 'will_id', '1', 'Wall-Appelbaum Machinery Associates', NULL, 'Supply', 'Machinery', NULL, NULL, '3963 Greentree Drive', 'Bellingham', 'WA', '36812', 'USA', NULL, NULL, '844-555-4385', NULL, NULL, NULL, 'www.wall-appelbaummachineryassociates.com', NULL, NULL, NULL, NULL, '3963 Greentree Drive', 'Bellingham', 'WA', '36812', 'USA', 0);
INSERT INTO accounts VALUES ('705a8f06-80bf-e78d-8582-438dfb58ec6a', '2005-11-30 19:20:09', '2005-11-30 19:20:09', '1', 'max_id', '1', 'G & W Kung Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '7675 Moss Hollow Court', 'Sedro Woolley', 'WA', '41442', 'USA', NULL, NULL, '898-555-4481', NULL, NULL, NULL, 'www.gwkungtransportation,inc.com', NULL, NULL, NULL, NULL, '7675 Moss Hollow Court', 'Sedro Woolley', 'WA', '41442', 'USA', 0);
INSERT INTO accounts VALUES ('af9c9eae-cfca-0408-c4f2-438dfb55cd6b', '2005-11-30 19:20:09', '2005-11-30 19:20:09', '1', 'matt_id', '1', 'Kung-Wilson Machinery Corp', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '2335 Peabody Road', 'Guadalajara', 'Jalisco', '60476', 'Mexico', NULL, NULL, '448-555-7888', NULL, NULL, NULL, 'www.kung-wilsonmachinerycorp.com', NULL, NULL, NULL, NULL, '2335 Peabody Road', 'Guadalajara', 'Jalisco', '60476', 'Mexico', 0);
INSERT INTO accounts VALUES ('df919b50-360a-55f5-6f51-438dfb61a3ac', '2005-11-30 19:20:09', '2005-11-30 19:20:09', '1', 'beth_id', '1', 'V & B Tuffield Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '8957 Maureen Circle', 'Long Beach', 'CA', '57560', 'USA', NULL, NULL, '652-555-8009', NULL, NULL, NULL, 'www.vbtuffieldtransportationholdings.com', NULL, NULL, NULL, NULL, '8957 Maureen Circle', 'Long Beach', 'CA', '57560', 'USA', 0);
INSERT INTO accounts VALUES ('37091701-70fe-f2c1-dc2c-438dfb343ec7', '2005-11-30 19:20:10', '2005-11-30 19:20:10', '1', 'beth_id', '1', 'Tuffield-Ping Construction Company', NULL, 'Consulting', 'Construction', NULL, NULL, '6526 Edie Ct.', 'Tlaxiaco', 'Oaxaca', '42756', 'Mexico', NULL, NULL, '463-555-4702', NULL, NULL, NULL, 'www.tuffield-pingconstructioncompany.com', NULL, NULL, NULL, NULL, '6526 Edie Ct.', 'Tlaxiaco', 'Oaxaca', '42756', 'Mexico', 0);
INSERT INTO accounts VALUES ('69aeff99-9dc1-cf5e-5779-438dfb158510', '2005-11-30 19:20:10', '2005-11-30 19:20:10', '1', 'max_id', '1', 'C & A Shepard Engineering Group', NULL, 'Supply', 'Engineering', NULL, NULL, '3403 Meadowbrook', 'W. Linn', 'OR', '78709', 'USA', NULL, NULL, '690-555-3452', NULL, NULL, NULL, 'www.cashepardengineeringgroup.com', NULL, NULL, NULL, NULL, '3403 Meadowbrook', 'W. Linn', 'OR', '78709', 'USA', 0);
INSERT INTO accounts VALUES ('b6263370-2b26-8342-4c87-438dfbf377b4', '2005-11-30 19:20:10', '2005-11-30 19:20:10', '1', 'kristen_id', '1', 'Shepard-Bailey Construction, Ltd', NULL, 'Consulting', 'Construction', NULL, NULL, '1227 Wesley Court', 'Richmond', 'BC', '30067', 'Canada', NULL, NULL, '525-555-7773', NULL, NULL, NULL, 'www.shepard-baileyconstruction,ltd.com', NULL, NULL, NULL, NULL, '1227 Wesley Court', 'Richmond', 'BC', '30067', 'Canada', 0);
INSERT INTO accounts VALUES ('8740019a-9ecc-2677-dbde-438dfb926b5d', '2005-11-30 19:20:11', '2005-11-30 19:20:11', '1', 'chris_id', '1', 'U & S Chestnut Transportation, Inc', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '1013 Buchanan Rd', 'Yakima', 'WA', '32182', 'USA', NULL, NULL, '114-555-8809', NULL, NULL, NULL, 'www.uschestnuttransportation,inc.com', NULL, NULL, NULL, NULL, '1013 Buchanan Rd', 'Yakima', 'WA', '32182', 'USA', 0);
INSERT INTO accounts VALUES ('307f2672-8234-c472-39de-438dfb0be0c0', '2005-11-30 19:20:11', '2005-11-30 19:20:11', '1', 'will_id', '1', 'Chestnut-Toone Construction Group', NULL, 'Distribution', 'Construction', NULL, NULL, '9090 Cristobal', 'Bremerton', 'WA', '22408', 'USA', NULL, NULL, '210-555-6416', NULL, NULL, NULL, 'www.chestnut-tooneconstructiongroup.com', NULL, NULL, NULL, NULL, '9090 Cristobal', 'Bremerton', 'WA', '22408', 'USA', 0);
INSERT INTO accounts VALUES ('636d2d7c-fcec-c46a-5aaa-438dfb56c263', '2005-11-30 19:20:11', '2005-11-30 19:20:11', '1', 'sarah_id', '1', 'N & W Armstrong Transportation Corp', NULL, 'Distribution', 'Transportation', NULL, NULL, '9130 San Ramon Road', 'Mill Valley', 'CA', '89684', 'USA', NULL, NULL, '483-555-2423', NULL, NULL, NULL, 'www.nwarmstrongtransportationcorp.com', NULL, NULL, NULL, NULL, '9130 San Ramon Road', 'Mill Valley', 'CA', '89684', 'USA', 0);
INSERT INTO accounts VALUES ('939e5fc5-2c88-2dc4-65fa-438dfbaaebd7', '2005-11-30 19:20:11', '2005-11-30 19:20:11', '1', 'matt_id', '1', 'Armstrong-Billstrom Engineering Partners', NULL, 'Supply', 'Engineering', NULL, NULL, '7462 Linden Land', 'Ladner', 'BC', '72364', 'Canada', NULL, NULL, '841-555-2316', NULL, NULL, NULL, 'www.armstrong-billstromengineeringpartners.com', NULL, NULL, NULL, NULL, '7462 Linden Land', 'Ladner', 'BC', '72364', 'Canada', 0);
INSERT INTO accounts VALUES ('d2700f13-40f4-fa17-c102-438dfb8eb5fb', '2005-11-30 19:20:11', '2005-11-30 19:20:11', '1', 'sarah_id', '1', 'O & D Stotka Communications Associates', NULL, 'Distribution', 'Communications', NULL, NULL, '413 Rishell Ct', 'Sooke', 'BC', '31770', 'Canada', NULL, NULL, '236-555-5952', NULL, NULL, NULL, 'www.odstotkacommunicationsassociates.com', NULL, NULL, NULL, NULL, '413 Rishell Ct', 'Sooke', 'BC', '31770', 'Canada', 0);
INSERT INTO accounts VALUES ('1d176643-bb13-0844-e661-438dfbdeeee9', '2005-11-30 19:20:12', '2005-11-30 19:20:12', '1', 'sally_id', '1', 'Stotka-Johnson Transportation Company', NULL, 'Consulting', 'Transportation', NULL, NULL, '1654 Bonari Court', 'Imperial Beach', 'CA', '79612', 'USA', NULL, NULL, '617-555-4473', NULL, NULL, NULL, 'www.stotka-johnsontransportationcompany.com', NULL, NULL, NULL, NULL, '1654 Bonari Court', 'Imperial Beach', 'CA', '79612', 'USA', 0);
INSERT INTO accounts VALUES ('4d4c92dd-bc58-f5c2-c506-438dfb7d4aa7', '2005-11-30 19:20:12', '2005-11-30 19:20:12', '1', 'sally_id', '1', 'M & Y Lepro Communications, Ltd', NULL, 'Supply', 'Communications', NULL, NULL, '4858 Shannon Lane', 'La Mesa', 'CA', '79211', 'USA', NULL, NULL, '275-555-1395', NULL, NULL, NULL, 'www.myleprocommunications,ltd.com', NULL, NULL, NULL, NULL, '4858 Shannon Lane', 'La Mesa', 'CA', '79211', 'USA', 0);
INSERT INTO accounts VALUES ('c157e248-0269-e45d-ce5a-438dfbb14bbf', '2005-11-30 19:20:12', '2005-11-30 19:20:12', '1', 'beth_id', '1', 'Lepro-Elliott Communications Associates', NULL, 'Consulting', 'Communications', NULL, NULL, '6353 Dan Ysidro Court', 'Milwaukie', 'OR', '66922', 'USA', NULL, NULL, '608-555-2777', NULL, NULL, NULL, 'www.lepro-elliottcommunicationsassociates.com', NULL, NULL, NULL, NULL, '6353 Dan Ysidro Court', 'Milwaukie', 'OR', '66922', 'USA', 0);
INSERT INTO accounts VALUES ('f19298b8-0362-dd24-7cd1-438dfb8403b7', '2005-11-30 19:20:12', '2005-11-30 19:20:12', '1', 'max_id', '1', 'B & D Steelman Machinery Partners', NULL, 'Consulting', 'Machinery', NULL, NULL, '9811 Toledo', 'Shawnee', 'BC', '63923', 'Canada', NULL, NULL, '288-555-7327', NULL, NULL, NULL, 'www.bdsteelmanmachinerypartners.com', NULL, NULL, NULL, NULL, '9811 Toledo', 'Shawnee', 'BC', '63923', 'Canada', 0);
INSERT INTO accounts VALUES ('4c92556d-a6b7-3fc2-8318-438dfbed4088', '2005-11-30 19:20:13', '2005-11-30 19:20:13', '1', 'sarah_id', '1', 'Steelman-Adams Construction Partners', NULL, 'Manufacturing', 'Construction', NULL, NULL, '4217 Almond Avenue', 'San Gabriel', 'CA', '85556', 'USA', NULL, NULL, '954-555-6763', NULL, NULL, NULL, 'www.steelman-adamsconstructionpartners.com', NULL, NULL, NULL, NULL, '4217 Almond Avenue', 'San Gabriel', 'CA', '85556', 'USA', 0);
INSERT INTO accounts VALUES ('9d8a587a-f26d-a658-2757-438dfb8d237a', '2005-11-30 19:20:13', '2005-11-30 19:20:13', '1', 'kristen_id', '1', 'H & E Poorbaugh Machinery Group', NULL, 'Supply', 'Machinery', NULL, NULL, '586 Willow Pass Dr.', 'Glendale', 'CA', '90186', 'USA', NULL, NULL, '896-555-4598', NULL, NULL, NULL, 'www.hepoorbaughmachinerygroup.com', NULL, NULL, NULL, NULL, '586 Willow Pass Dr.', 'Glendale', 'CA', '90186', 'USA', 0);
INSERT INTO accounts VALUES ('dced35ed-f75f-5e3e-dedb-438dfbe4f662', '2005-11-30 19:20:13', '2005-11-30 19:20:13', '1', 'beth_id', '1', 'Poorbaugh-Hasty Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '5245 Fraga Court', 'Burlingame', 'CA', '10221', 'USA', NULL, NULL, '685-555-2663', NULL, NULL, NULL, 'www.poorbaugh-hastyelectronicsholdings.com', NULL, NULL, NULL, NULL, '5245 Fraga Court', 'Burlingame', 'CA', '10221', 'USA', 0);
INSERT INTO accounts VALUES ('280cf96b-2ef7-a0e2-9ab9-438dfb06bd21', '2005-11-30 19:20:14', '2005-11-30 19:20:14', '1', 'max_id', '1', 'X & M Betsekas Construction Corp', NULL, 'Manufacturing', 'Construction', NULL, NULL, '1867 Seville', 'National City', 'CA', '80012', 'USA', NULL, NULL, '650-555-8127', NULL, NULL, NULL, 'www.xmbetsekasconstructioncorp.com', NULL, NULL, NULL, NULL, '1867 Seville', 'National City', 'CA', '80012', 'USA', 0);
INSERT INTO accounts VALUES ('6aa8e39e-3814-a431-1d7a-438dfb051697', '2005-11-30 19:20:14', '2005-11-30 19:20:14', '1', 'sally_id', '1', 'Betsekas-Ziegler Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '6780 Ware Ct.', 'Port Hammond', 'BC', '65208', 'Canada', NULL, NULL, '461-555-4820', NULL, NULL, NULL, 'www.betsekas-zieglertelecommunications,ltd.com', NULL, NULL, NULL, NULL, '6780 Ware Ct.', 'Port Hammond', 'BC', '65208', 'Canada', 0);
INSERT INTO accounts VALUES ('aa65a929-1b0f-5205-f01d-438dfbabde1f', '2005-11-30 19:20:14', '2005-11-30 19:20:14', '1', 'chris_id', '1', 'I & M Weyerhaeuser Transportation, Ltd', NULL, 'Supply', 'Transportation', NULL, NULL, '6313 Collins Drive', 'Shawnee', 'BC', '21626', 'Canada', NULL, NULL, '688-555-3570', NULL, NULL, NULL, 'www.imweyerhaeusertransportation,ltd.com', NULL, NULL, NULL, NULL, '6313 Collins Drive', 'Shawnee', 'BC', '21626', 'Canada', 0);
INSERT INTO accounts VALUES ('ef3e5cbd-082e-12a9-b6b3-438dfb549e04', '2005-11-30 19:20:14', '2005-11-30 19:20:14', '1', 'will_id', '1', 'Weyerhaeuser-Robinson Electronics Corp', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '1481 Near Ct.', 'Altadena', 'CA', '52519', 'USA', NULL, NULL, '762-555-2548', NULL, NULL, NULL, 'www.weyerhaeuser-robinsonelectronicscorp.com', NULL, NULL, NULL, NULL, '1481 Near Ct.', 'Altadena', 'CA', '52519', 'USA', 0);
INSERT INTO accounts VALUES ('4aa6de52-213e-66a8-a9ef-438dfbe96c48', '2005-11-30 19:20:15', '2005-11-30 19:20:15', '1', 'kristen_id', '1', 'H & Y Brunner Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '1267 Scenic Drive', 'Santa Monica', 'CA', '54634', 'USA', NULL, NULL, '111-555-8927', NULL, NULL, NULL, 'www.hybrunnerengineering,inc.com', NULL, NULL, NULL, NULL, '1267 Scenic Drive', 'Santa Monica', 'CA', '54634', 'USA', 0);
INSERT INTO accounts VALUES ('7d4ff985-e769-bde9-54a0-438dfbe394fc', '2005-11-30 19:20:15', '2005-11-30 19:20:15', '1', 'jaime_id', '1', 'Brunner-Frazier Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '9344 Stony Hill Circle', 'Berkeley', 'CA', '71152', 'USA', NULL, NULL, '208-555-6534', NULL, NULL, NULL, 'www.brunner-fraziertelecommunications,ltd.com', NULL, NULL, NULL, NULL, '9344 Stony Hill Circle', 'Berkeley', 'CA', '71152', 'USA', 0);
INSERT INTO accounts VALUES ('bdb03d9e-227d-740c-2453-438dfb39ede5', '2005-11-30 19:20:15', '2005-11-30 19:20:15', '1', 'sally_id', '1', 'D & A Rector Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '9384 Jamie Way', 'Bellingham', 'WA', '39429', 'USA', NULL, NULL, '480-555-2541', NULL, NULL, NULL, 'www.darectormachinerygroup.com', NULL, NULL, NULL, NULL, '9384 Jamie Way', 'Bellingham', 'WA', '39429', 'USA', 0);
INSERT INTO accounts VALUES ('95da0641-a17b-2468-6737-438dfb77838f', '2005-11-30 19:20:16', '2005-11-30 19:20:16', '1', 'max_id', '1', 'Rector-Caldwell Construction Associates', NULL, 'Consulting', 'Construction', NULL, NULL, '372 Canyon Creek Drive', 'Corvallis', 'OR', '94816', 'USA', NULL, NULL, '951-555-4694', NULL, NULL, NULL, 'www.rector-caldwellconstructionassociates.com', NULL, NULL, NULL, NULL, '372 Canyon Creek Drive', 'Corvallis', 'OR', '94816', 'USA', 0);
INSERT INTO accounts VALUES ('49cd8ee8-2e63-ccc6-dd57-438dfb23cf46', '2005-11-30 19:20:16', '2005-11-30 19:20:16', '1', 'max_id', '1', 'D & Z Gonzales Electronics, Ltd', NULL, 'Consulting', 'Electronics', NULL, NULL, '3322 Haven Hill Drive', 'Lynnwood', 'WA', '29255', 'USA', NULL, NULL, '346-555-8329', NULL, NULL, NULL, 'www.dzgonzaleselectronics,ltd.com', NULL, NULL, NULL, NULL, '3322 Haven Hill Drive', 'Lynnwood', 'WA', '29255', 'USA', 0);
INSERT INTO accounts VALUES ('8c800256-b9ab-a248-e02d-438dfbd84b4d', '2005-11-30 19:20:16', '2005-11-30 19:20:16', '1', 'kristen_id', '1', 'Gonzales-Monitor Engineering Corp', NULL, 'Consulting', 'Engineering', NULL, NULL, '1908 San Jose Ave', 'Newton', 'BC', '43020', 'Canada', NULL, NULL, '727-555-6851', NULL, NULL, NULL, 'www.gonzales-monitorengineeringcorp.com', NULL, NULL, NULL, NULL, '1908 San Jose Ave', 'Newton', 'BC', '43020', 'Canada', 0);
INSERT INTO accounts VALUES ('e4282cb7-d56c-84e1-9a0a-438dfb324698', '2005-11-30 19:20:16', '2005-11-30 19:20:16', '1', 'will_id', '1', 'Q & Q Lewin Telecommunications Associates', NULL, 'Supply', 'Telecommunications', NULL, NULL, '6358 Parkview Court', 'Lake Oswego', 'OR', '42620', 'USA', NULL, NULL, '624-555-7430', NULL, NULL, NULL, 'www.qqlewintelecommunicationsassociates.com', NULL, NULL, NULL, NULL, '6358 Parkview Court', 'Lake Oswego', 'OR', '42620', 'USA', 0);
INSERT INTO accounts VALUES ('30530ae1-f3c5-51c9-6bb5-438dfbf62530', '2005-11-30 19:20:17', '2005-11-30 19:20:17', '1', 'max_id', '1', 'Lewin-Desalvo Engineering Company', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '7853 Millfield Place', 'Beverly Hills', 'CA', '30331', 'USA', NULL, NULL, '127-555-4580', NULL, NULL, NULL, 'www.lewin-desalvoengineeringcompany.com', NULL, NULL, NULL, NULL, '7853 Millfield Place', 'Beverly Hills', 'CA', '30331', 'USA', 0);
INSERT INTO accounts VALUES ('630977b0-f0a1-66db-a51c-438dfb6d313e', '2005-11-30 19:20:17', '2005-11-30 19:20:17', '1', 'matt_id', '1', 'Y & R Alpuerto Machinery, Inc', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '3968 Bonifacio', 'Spokane', 'WA', '95091', 'USA', NULL, NULL, '708-555-9130', NULL, NULL, NULL, 'www.yralpuertomachinery,inc.com', NULL, NULL, NULL, NULL, '3968 Bonifacio', 'Spokane', 'WA', '95091', 'USA', 0);
INSERT INTO accounts VALUES ('a39a808f-5cb3-4fa1-2d14-438dfb97989f', '2005-11-30 19:20:17', '2005-11-30 19:20:17', '1', 'sarah_id', '1', 'Alpuerto-Marshall Engineering, Inc', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '5717 Shenandoah Drive', 'Fremont', 'CA', '48964', 'USA', NULL, NULL, '474-555-8565', NULL, NULL, NULL, 'www.alpuerto-marshallengineering,inc.com', NULL, NULL, NULL, NULL, '5717 Shenandoah Drive', 'Fremont', 'CA', '48964', 'USA', 0);
INSERT INTO accounts VALUES ('e4bb31e7-68c8-772c-5580-438dfbf622ca', '2005-11-30 19:20:17', '2005-11-30 19:20:17', '1', 'kristen_id', '1', 'E & F Bockenkamp Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '2086 Rotherham Dr.', 'Berkeley', 'CA', '79887', 'USA', NULL, NULL, '416-555-6401', NULL, NULL, NULL, 'www.efbockenkampmachinery,ltd.com', NULL, NULL, NULL, NULL, '2086 Rotherham Dr.', 'Berkeley', 'CA', '79887', 'USA', 0);
INSERT INTO accounts VALUES ('20ad4cbc-4aac-69b7-27ae-438dfbaeadaa', '2005-11-30 19:20:18', '2005-11-30 19:20:18', '1', 'chris_id', '1', 'Bockenkamp-Kesterson Transportation Holdings', NULL, 'Distribution', 'Transportation', NULL, NULL, '6745 Blue Ridge Drive', 'Glendale', 'CA', '98921', 'USA', NULL, NULL, '204-555-4465', NULL, NULL, NULL, 'www.bockenkamp-kestersontransportationholdings.com', NULL, NULL, NULL, NULL, '6745 Blue Ridge Drive', 'Glendale', 'CA', '98921', 'USA', 0);
INSERT INTO accounts VALUES ('64502d84-68d6-ce4d-623a-438dfbb101e9', '2005-11-30 19:20:18', '2005-11-30 19:20:18', '1', 'will_id', '1', 'N & O Alexander Electronics, Inc', NULL, 'Supply', 'Electronics', NULL, NULL, '3368 Rainier Dr.', 'Richmond', 'BC', '69713', 'Canada', NULL, NULL, '757-555-1584', NULL, NULL, NULL, 'www.noalexanderelectronics,inc.com', NULL, NULL, NULL, NULL, '3368 Rainier Dr.', 'Richmond', 'BC', '69713', 'Canada', 0);
INSERT INTO accounts VALUES ('94506f88-0bce-f500-e91b-438dfbe09d5f', '2005-11-30 19:20:18', '2005-11-30 19:20:18', '1', 'kristen_id', '1', 'Alexander-Mendoza Machinery Group', NULL, 'Distribution', 'Machinery', NULL, NULL, '8281 Rhoda Way', 'Novato', 'CA', '54909', 'USA', NULL, NULL, '569-555-7276', NULL, NULL, NULL, 'www.alexander-mendozamachinerygroup.com', NULL, NULL, NULL, NULL, '8281 Rhoda Way', 'Novato', 'CA', '54909', 'USA', 0);
INSERT INTO accounts VALUES ('c475e259-7fe9-ced2-f61e-438dfbd84283', '2005-11-30 19:20:18', '2005-11-30 19:20:18', '1', 'beth_id', '1', 'U & W Herrick Construction Corp', NULL, 'Supply', 'Construction', NULL, NULL, '7813 Worth Ct.', 'Anacortes', 'WA', '90861', 'USA', NULL, NULL, '796-555-6026', NULL, NULL, NULL, 'www.uwherrickconstructioncorp.com', NULL, NULL, NULL, NULL, '7813 Worth Ct.', 'Anacortes', 'WA', '90861', 'USA', 0);
INSERT INTO accounts VALUES ('3315c5b9-9f44-b13d-4d3b-438dfbe40400', '2005-11-30 19:20:19', '2005-11-30 19:20:19', '1', 'max_id', '1', 'Herrick-McCoy Electronics Company', NULL, 'Consulting', 'Electronics', NULL, NULL, '5636 Barcelona', 'Langford', 'BC', '42219', 'Canada', NULL, NULL, '869-555-5005', NULL, NULL, NULL, 'www.herrick-mccoyelectronicscompany.com', NULL, NULL, NULL, NULL, '5636 Barcelona', 'Langford', 'BC', '42219', 'Canada', 0);
INSERT INTO accounts VALUES ('65d977a9-17fe-c0fa-cc57-438dfb92ee04', '2005-11-30 19:20:19', '2005-11-30 19:20:19', '1', 'chris_id', '1', 'M & K Thoreson Telecommunications, Ltd', NULL, 'Supply', 'Telecommunications', NULL, NULL, '5423 Morengo Ct.', 'Langford', 'BC', '44334', 'Canada', NULL, NULL, '219-555-2384', NULL, NULL, NULL, 'www.mkthoresontelecommunications,ltd.com', NULL, NULL, NULL, NULL, '5423 Morengo Ct.', 'Langford', 'BC', '44334', 'Canada', 0);
INSERT INTO accounts VALUES ('c9c19848-f085-7289-cff0-438dfb5659f1', '2005-11-30 19:20:19', '2005-11-30 19:20:19', '1', 'sarah_id', '1', 'Thoreson-Snowden Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '845 Olive Ave', 'Walla Walla', 'WA', '34561', 'USA', NULL, NULL, '315-555-8991', NULL, NULL, NULL, 'www.thoreson-snowdenmachinery,ltd.com', NULL, NULL, NULL, NULL, '845 Olive Ave', 'Walla Walla', 'WA', '34561', 'USA', 0);
INSERT INTO accounts VALUES ('18de4a65-6937-d606-bf3e-438dfbdc97bf', '2005-11-30 19:20:20', '2005-11-30 19:20:20', '1', 'beth_id', '1', 'L & E Blanton Communications Partners', NULL, 'Distribution', 'Communications', NULL, NULL, '3541 Corte Poquito', 'Arcadia', 'CA', '28375', 'USA', NULL, NULL, '588-555-4998', NULL, NULL, NULL, 'www.leblantoncommunicationspartners.com', NULL, NULL, NULL, NULL, '3541 Corte Poquito', 'Arcadia', 'CA', '28375', 'USA', 0);
INSERT INTO accounts VALUES ('5e1adbb5-73de-84e8-26d6-438dfbbe13ac', '2005-11-30 19:20:20', '2005-11-30 19:20:20', '1', 'sally_id', '1', 'Blanton-Gibbens Construction Holdings', NULL, 'Consulting', 'Construction', NULL, NULL, '1872 Walnut Avenue', 'Santa Fe', 'DF', '84517', 'Mexico', NULL, NULL, '946-555-4891', NULL, NULL, NULL, 'www.blanton-gibbensconstructionholdings.com', NULL, NULL, NULL, NULL, '1872 Walnut Avenue', 'Santa Fe', 'DF', '84517', 'Mexico', 0);
INSERT INTO accounts VALUES ('a0b1e6ca-bb6b-5303-162b-438dfb6373d7', '2005-11-30 19:20:20', '2005-11-30 19:20:20', '1', 'kristen_id', '1', 'W & N Alcorn Telecommunications Partners', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '4822 Center Street', 'Fremont', 'CA', '18956', 'USA', NULL, NULL, '580-555-3184', NULL, NULL, NULL, 'www.wnalcorntelecommunicationspartners.com', NULL, NULL, NULL, NULL, '4822 Center Street', 'Fremont', 'CA', '18956', 'USA', 0);
INSERT INTO accounts VALUES ('d1c8692a-5f60-1701-28b1-438dfb4a89c1', '2005-11-30 19:20:20', '2005-11-30 19:20:20', '1', 'sally_id', '1', 'Alcorn-Miller Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '6064 Madrid', 'Bellflower', 'CA', '40505', 'USA', NULL, NULL, '722-555-7048', NULL, NULL, NULL, 'www.alcorn-millertransportationholdings.com', NULL, NULL, NULL, NULL, '6064 Madrid', 'Bellflower', 'CA', '40505', 'USA', 0);
INSERT INTO accounts VALUES ('31d5cda5-dbe3-02ac-0040-438dfb087ca2', '2005-11-30 19:20:21', '2005-11-30 19:20:21', '1', 'beth_id', '1', 'V & A Campen Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '9268 Keller Ridge', 'Salem', 'OR', '90784', 'USA', NULL, NULL, '619-555-7627', NULL, NULL, NULL, 'www.vacampentransportationcorp.com', NULL, NULL, NULL, NULL, '9268 Keller Ridge', 'Salem', 'OR', '90784', 'USA', 0);
INSERT INTO accounts VALUES ('64f5db21-f2f2-bf69-83b7-438dfb107f3a', '2005-11-30 19:20:21', '2005-11-30 19:20:21', '1', 'max_id', '1', 'Campen-Coffman Communications Corp', NULL, 'Consulting', 'Communications', NULL, NULL, '764 Nahua', 'San Diego', 'CA', '78495', 'USA', NULL, NULL, '123-555-4777', NULL, NULL, NULL, 'www.campen-coffmancommunicationscorp.com', NULL, NULL, NULL, NULL, '764 Nahua', 'San Diego', 'CA', '78495', 'USA', 0);
INSERT INTO accounts VALUES ('9536b4e9-efc3-f6dc-4b08-438dfb49736d', '2005-11-30 19:20:21', '2005-11-30 19:20:21', '1', 'sally_id', '1', 'T & A Bustamante Electronics, Inc', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '4222 San Jose Dr.', 'Concord', 'CA', '44256', 'USA', NULL, NULL, '815-555-2586', NULL, NULL, NULL, 'www.tabustamanteelectronics,inc.com', NULL, NULL, NULL, NULL, '4222 San Jose Dr.', 'Concord', 'CA', '44256', 'USA', 0);
INSERT INTO accounts VALUES ('2ae53d7c-3815-fef1-3da2-438dfbbcfc11', '2005-11-30 19:20:22', '2005-11-30 19:20:22', '1', 'matt_id', '1', 'Bustamante-Eldridge Construction Associates', NULL, 'Manufacturing', 'Construction', NULL, NULL, '8627 Laguna Street', 'San Diego', 'CA', '97128', 'USA', NULL, NULL, '581-555-2022', NULL, NULL, NULL, 'www.bustamante-eldridgeconstructionassociates.com', NULL, NULL, NULL, NULL, '8627 Laguna Street', 'San Diego', 'CA', '97128', 'USA', 0);
INSERT INTO accounts VALUES ('82b6361d-819d-b3df-d2f3-438dfb0fa311', '2005-11-30 19:20:22', '2005-11-30 19:20:22', '1', 'chris_id', '1', 'D & D Sipsy Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '4996 Hillview Drive', 'National City', 'CA', '27594', 'USA', NULL, NULL, '523-555-8858', NULL, NULL, NULL, 'www.ddsipsyelectronicsholdings.com', NULL, NULL, NULL, NULL, '4996 Hillview Drive', 'National City', 'CA', '27594', 'USA', 0);
INSERT INTO accounts VALUES ('c4d987ed-850f-a5ef-ee3a-438dfb9f0548', '2005-11-30 19:20:22', '2005-11-30 19:20:22', '1', 'sarah_id', '1', 'Sipsy-Weimer Machinery, Inc', NULL, 'Distribution', 'Machinery', NULL, NULL, '6999 Salem St.', 'San Andres', 'DF', '21793', 'Mexico', NULL, NULL, '312-555-6922', NULL, NULL, NULL, 'www.sipsy-weimermachinery,inc.com', NULL, NULL, NULL, NULL, '6999 Salem St.', 'San Andres', 'DF', '21793', 'Mexico', 0);
INSERT INTO accounts VALUES ('1aae0f4c-9c38-0feb-9cb6-438dfb5fcc71', '2005-11-30 19:20:23', '2005-11-30 19:20:23', '1', 'sally_id', '1', 'I & V Irwin Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '6277 Greenview Court', 'Lebanon', 'OR', '91585', 'USA', NULL, NULL, '277-555-3386', NULL, NULL, NULL, 'www.ivirwinengineering,inc.com', NULL, NULL, NULL, NULL, '6277 Greenview Court', 'Lebanon', 'OR', '91585', 'USA', 0);
INSERT INTO accounts VALUES ('31d3ed19-3822-88c6-3ac7-438dfbffa1a3', '2005-11-30 19:20:23', '2005-11-30 19:20:23', '1', 'beth_id', '1', 'Irwin-Son Construction, Ltd', NULL, 'Manufacturing', 'Construction', NULL, NULL, '1191 Boxwood Dr.', 'Burbank', 'CA', '76780', 'USA', NULL, NULL, '988-555-9079', NULL, NULL, NULL, 'www.irwin-sonconstruction,ltd.com', NULL, NULL, NULL, NULL, '1191 Boxwood Dr.', 'Burbank', 'CA', '76780', 'USA', 0);
INSERT INTO accounts VALUES ('ae14f6ad-94c0-eab8-56ce-438dfb978df8', '2005-11-30 19:20:23', '2005-11-30 19:20:23', '1', 'matt_id', '1', 'K & R Brandon Communications Group', NULL, 'Consulting', 'Communications', NULL, NULL, '8067 Olympic Drive', 'Yakima', 'WA', '40026', 'USA', NULL, NULL, '315-555-7829', NULL, NULL, NULL, 'www.krbrandoncommunicationsgroup.com', NULL, NULL, NULL, NULL, '8067 Olympic Drive', 'Yakima', 'WA', '40026', 'USA', 0);
INSERT INTO accounts VALUES ('de18c543-c83a-7128-8ede-438dfb90ca7d', '2005-11-30 19:20:23', '2005-11-30 19:20:23', '1', 'jaime_id', '1', 'Brandon-Quintana Engineering Associates', NULL, 'Distribution', 'Engineering', NULL, NULL, '5890 Ardith Drive', 'Vancouver', 'BC', '64091', 'Canada', NULL, NULL, '389-555-6808', NULL, NULL, NULL, 'www.brandon-quintanaengineeringassociates.com', NULL, NULL, NULL, NULL, '5890 Ardith Drive', 'Vancouver', 'BC', '64091', 'Canada', 0);
INSERT INTO accounts VALUES ('2c6dc705-ce38-9d87-f23e-438dfbcebbbd', '2005-11-30 19:20:24', '2005-11-30 19:20:24', '1', 'max_id', '1', 'B & P Colon Telecommunications Holdings', NULL, 'Distribution', 'Telecommunications', NULL, NULL, '5677 William Reed Dr.', 'Guadalajara', 'Jalisco', '66206', 'Mexico', NULL, NULL, '639-555-4186', NULL, NULL, NULL, 'www.bpcolontelecommunicationsholdings.com', NULL, NULL, NULL, NULL, '5677 William Reed Dr.', 'Guadalajara', 'Jalisco', '66206', 'Mexico', 0);
INSERT INTO accounts VALUES ('848b2f3c-fbf2-8431-09c3-438dfb544d45', '2005-11-30 19:20:24', '2005-11-30 19:20:24', '1', 'kristen_id', '1', 'Colon-Barlow Electronics, Ltd', NULL, 'Distribution', 'Electronics', NULL, NULL, '3754 Alray Drive', 'Oak Bay', 'BC', '82725', 'Canada', NULL, NULL, '735-555-1793', NULL, NULL, NULL, 'www.colon-barlowelectronics,ltd.com', NULL, NULL, NULL, NULL, '3754 Alray Drive', 'Oak Bay', 'BC', '82725', 'Canada', 0);
INSERT INTO accounts VALUES ('c760e512-ab2c-a35d-da62-438dfbac82ea', '2005-11-30 19:20:24', '2005-11-30 19:20:24', '1', 'chris_id', '1', 'Q & P Adina Telecommunications Company', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, '3795 Tabora Drive', 'Woodland Hills', 'CA', '51001', 'USA', NULL, NULL, '108-555-6800', NULL, NULL, NULL, 'www.qpadinatelecommunicationscompany.com', NULL, NULL, NULL, NULL, '3795 Tabora Drive', 'Woodland Hills', 'CA', '51001', 'USA', 0);
INSERT INTO accounts VALUES ('4e4bde3d-2e6a-1c54-2813-438dfb4f48f4', '2005-11-30 19:20:25', '2005-11-30 19:20:25', '1', 'beth_id', '1', 'Adina-Bohling Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '4782 Mt. Whitney Dr.', 'Bellflower', 'CA', '33682', 'USA', NULL, NULL, '831-555-2749', NULL, NULL, NULL, 'www.adina-bohlingtransportationholdings.com', NULL, NULL, NULL, NULL, '4782 Mt. Whitney Dr.', 'Bellflower', 'CA', '33682', 'USA', 0);
INSERT INTO accounts VALUES ('a6a62cfb-3bac-4a41-fae6-438dfb577838', '2005-11-30 19:20:25', '2005-11-30 19:20:25', '1', 'kristen_id', '1', 'G & N Wheeler Communications Group', NULL, 'Supply', 'Communications', NULL, NULL, '2258 Pablo Neruda', 'West Covina', 'CA', '40827', 'USA', NULL, NULL, '466-555-1042', NULL, NULL, NULL, 'www.gnwheelercommunicationsgroup.com', NULL, NULL, NULL, NULL, '2258 Pablo Neruda', 'West Covina', 'CA', '40827', 'USA', 0);
INSERT INTO accounts VALUES ('e9da28ed-3d11-c2aa-fa97-438dfbeea08e', '2005-11-30 19:20:25', '2005-11-30 19:20:25', '1', 'kristen_id', '1', 'Wheeler-Swearengin Construction Partners', NULL, 'Distribution', 'Construction', NULL, NULL, '3499 Parkway Drive', 'Everett', 'WA', '88669', 'USA', NULL, NULL, '847-555-8563', NULL, NULL, NULL, 'www.wheeler-swearenginconstructionpartners.com', NULL, NULL, NULL, NULL, '3499 Parkway Drive', 'Everett', 'WA', '88669', 'USA', 0);
INSERT INTO accounts VALUES ('4cc8b395-11af-cd01-257d-438dfbf89cc3', '2005-11-30 19:20:26', '2005-11-30 19:20:26', '1', 'kristen_id', '1', 'H & Y Givens Electronics, Ltd', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '6703 Milburn Dr.', 'Santa Monica', 'CA', '61976', 'USA', NULL, NULL, '505-555-5484', NULL, NULL, NULL, 'www.hygivenselectronics,ltd.com', NULL, NULL, NULL, NULL, '6703 Milburn Dr.', 'Santa Monica', 'CA', '61976', 'USA', 0);
INSERT INTO accounts VALUES ('92a2d19a-54ee-f1fa-987c-438dfb0290ca', '2005-11-30 19:20:26', '2005-11-30 19:20:26', '1', 'chris_id', '1', 'Givens-Beanston Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '8198 Mt. Whitney Dr.', 'La Jolla', 'CA', '92873', 'USA', NULL, NULL, '908-555-2634', NULL, NULL, NULL, 'www.givens-beanstontransportationholdings.com', NULL, NULL, NULL, NULL, '8198 Mt. Whitney Dr.', 'La Jolla', 'CA', '92873', 'USA', 0);
INSERT INTO accounts VALUES ('d6108839-dd16-d342-237b-438dfbe20b60', '2005-11-30 19:20:26', '2005-11-30 19:20:26', '1', 'sarah_id', '1', 'O & K Bruno Transportation Corp', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '4313 Camby Rd.', 'Sooke', 'BC', '32342', 'Canada', NULL, NULL, '828-555-1842', NULL, NULL, NULL, 'www.okbrunotransportationcorp.com', NULL, NULL, NULL, NULL, '4313 Camby Rd.', 'Sooke', 'BC', '32342', 'Canada', 0);
INSERT INTO accounts VALUES ('4bdffe67-f195-8ae3-ec7b-438dfb881f4c', '2005-11-30 19:20:27', '2005-11-30 19:20:27', '1', 'beth_id', '1', 'Bruno-Berger Construction Partners', NULL, 'Consulting', 'Construction', NULL, NULL, '6062 Mota Dr.', 'Redmond', 'WA', '85214', 'USA', NULL, NULL, '354-555-6620', NULL, NULL, NULL, 'www.bruno-bergerconstructionpartners.com', NULL, NULL, NULL, NULL, '6062 Mota Dr.', 'Redmond', 'WA', '85214', 'USA', 0);
INSERT INTO accounts VALUES ('a54321d1-cbd4-e430-5d40-438dfb8d8fbe', '2005-11-30 19:20:27', '2005-11-30 19:20:27', '1', 'sally_id', '1', 'D & D Sultan Transportation, Ltd', NULL, 'Distribution', 'Transportation', NULL, NULL, '2431 Santa Lucia Dr.', 'Portland', 'OR', '17137', 'USA', NULL, NULL, '297-555-4456', NULL, NULL, NULL, 'www.ddsultantransportation,ltd.com', NULL, NULL, NULL, NULL, '2431 Santa Lucia Dr.', 'Portland', 'OR', '17137', 'USA', 0);
INSERT INTO accounts VALUES ('e93ec2cb-fca3-0b23-7ca7-438dfb73696d', '2005-11-30 19:20:27', '2005-11-30 19:20:27', '1', 'kristen_id', '1', 'Sultan-Svoboda Machinery, Inc', NULL, 'Consulting', 'Machinery', NULL, NULL, '7090 C. Mount Hood', 'Santa Cruz', 'CA', '36171', 'USA', NULL, NULL, '985-555-2520', NULL, NULL, NULL, 'www.sultan-svobodamachinery,inc.com', NULL, NULL, NULL, NULL, '7090 C. Mount Hood', 'Santa Cruz', 'CA', '36171', 'USA', 0);
INSERT INTO accounts VALUES ('2584d7e2-acb7-6248-5eae-438dfb125d89', '2005-11-30 19:20:28', '2005-11-30 19:20:28', '1', 'beth_id', '1', 'E & M Tullao Electronics Company', NULL, 'Supply', 'Electronics', NULL, NULL, '3713 Rollingwood Dr.', 'Vancouver', 'BC', '69633', 'Canada', NULL, NULL, '950-555-7984', NULL, NULL, NULL, 'www.emtullaoelectronicscompany.com', NULL, NULL, NULL, NULL, '3713 Rollingwood Dr.', 'Vancouver', 'BC', '69633', 'Canada', 0);
INSERT INTO accounts VALUES ('55d98ba6-62a7-fd7f-d743-438dfb8a5931', '2005-11-30 19:20:28', '2005-11-30 19:20:28', '1', 'matt_id', '1', 'Tullao-Hernandez Engineering, Ltd', NULL, 'Distribution', 'Engineering', NULL, NULL, '8626 Lillian Dr', 'Langley', 'BC', '91158', 'Canada', NULL, NULL, '101-555-8334', NULL, NULL, NULL, 'www.tullao-hernandezengineering,ltd.com', NULL, NULL, NULL, NULL, '8626 Lillian Dr', 'Langley', 'BC', '91158', 'Canada', 0);
INSERT INTO accounts VALUES ('b019d8c4-37b1-28cc-e7ab-438dfb2fef9e', '2005-11-30 19:20:28', '2005-11-30 19:20:28', '1', 'matt_id', '1', 'R & Z Wilkie Communications, Inc', NULL, 'Distribution', 'Communications', NULL, NULL, '8158 Ahwanee Lane', 'Langford', 'BC', '28112', 'Canada', NULL, NULL, '989-555-3427', NULL, NULL, NULL, 'www.rzwilkiecommunications,inc.com', NULL, NULL, NULL, NULL, '8158 Ahwanee Lane', 'Langford', 'BC', '28112', 'Canada', 0);
INSERT INTO accounts VALUES ('ec000cbb-56ab-f5c9-f878-438dfb94f5b0', '2005-11-30 19:20:29', '2005-11-30 19:20:29', '1', 'chris_id', '1', 'Wilkie-Lunt Machinery Partners', NULL, 'Supply', 'Machinery', NULL, NULL, '3326 Indianhead Ct.', 'West Covina', 'CA', '78469', 'USA', NULL, NULL, '274-555-4666', NULL, NULL, NULL, 'www.wilkie-luntmachinerypartners.com', NULL, NULL, NULL, NULL, '3326 Indianhead Ct.', 'West Covina', 'CA', '78469', 'USA', 0);
INSERT INTO accounts VALUES ('43f6b34a-7012-acf9-e2e2-438dfb8bbb40', '2005-11-30 19:20:29', '2005-11-30 19:20:29', '1', 'sarah_id', '1', 'J & K Fulton Communications Corp', NULL, 'Supply', 'Communications', NULL, NULL, '3112 Gilardy Dr.', 'Tlaxiaco', 'Oaxaca', '80584', 'Mexico', NULL, NULL, '524-555-2044', NULL, NULL, NULL, 'www.jkfultoncommunicationscorp.com', NULL, NULL, NULL, NULL, '3112 Gilardy Dr.', 'Tlaxiaco', 'Oaxaca', '80584', 'Mexico', 0);
INSERT INTO accounts VALUES ('8a83320a-d876-f677-8963-438dfb6c10c8', '2005-11-30 19:20:29', '2005-11-30 19:20:29', '1', 'sally_id', '1', 'Fulton-Dillon Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '1190 Hill Top Rd.', 'Concord', 'CA', '97102', 'USA', NULL, NULL, '620-555-8651', NULL, NULL, NULL, 'www.fulton-dillonconstruction,ltd.com', NULL, NULL, NULL, NULL, '1190 Hill Top Rd.', 'Concord', 'CA', '97102', 'USA', 0);
INSERT INTO accounts VALUES ('284809c7-3b5b-e686-f4e7-438dfbfa5eed', '2005-11-30 19:20:30', '2005-11-30 19:20:30', '1', 'max_id', '1', 'W & W Miller Electronics Associates', NULL, 'Supply', 'Electronics', NULL, NULL, '3886 Delta View Ln.', 'Walla Walla', 'WA', '65379', 'USA', NULL, NULL, '232-555-8316', NULL, NULL, NULL, 'www.wwmillerelectronicsassociates.com', NULL, NULL, NULL, NULL, '3886 Delta View Ln.', 'Walla Walla', 'WA', '65379', 'USA', 0);
INSERT INTO accounts VALUES ('5de035e3-561e-2abc-3a8a-438dfb857c6a', '2005-11-30 19:20:30', '2005-11-30 19:20:30', '1', 'max_id', '1', 'Miller-Stern Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '2217 Pueblo Dr.', 'Oakland', 'CA', '21767', 'USA', NULL, NULL, '351-555-4551', NULL, NULL, NULL, 'www.miller-sternmachinerygroup.com', NULL, NULL, NULL, NULL, '2217 Pueblo Dr.', 'Oakland', 'CA', '21767', 'USA', 0);
INSERT INTO accounts VALUES ('cb2da29e-414f-84e2-3742-438dfb1177a4', '2005-11-30 19:20:30', '2005-11-30 19:20:30', '1', 'beth_id', '1', 'D & G Suffin Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '5167 Condor Place', 'Albany', 'OR', '55205', 'USA', NULL, NULL, '886-555-2844', NULL, NULL, NULL, 'www.dgsuffintransportation,inc.com', NULL, NULL, NULL, NULL, '5167 Condor Place', 'Albany', 'OR', '55205', 'USA', 0);
INSERT INTO accounts VALUES ('73890092-16e9-601a-454c-438dfbd6bb8d', '2005-11-30 19:20:31', '2005-11-30 19:20:31', '1', 'matt_id', '1', 'Suffin-Cleary Engineering, Ltd', NULL, 'Supply', 'Engineering', NULL, NULL, '3753 Forest Way', 'Burnaby', 'BC', '76754', 'Canada', NULL, NULL, '367-555-1366', NULL, NULL, NULL, 'www.suffin-clearyengineering,ltd.com', NULL, NULL, NULL, NULL, '3753 Forest Way', 'Burnaby', 'BC', '76754', 'Canada', 0);
INSERT INTO accounts VALUES ('77c31c1a-fc84-7181-bb1a-438dfb1947e8', '2005-11-30 19:20:31', '2005-11-30 19:20:31', '1', 'jaime_id', '1', 'Z & L Homax Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '6957 Corte Poquito', 'West Covina', 'CA', '76354', 'USA', NULL, NULL, '924-555-7287', NULL, NULL, NULL, 'www.zlhomaxconstruction,ltd.com', NULL, NULL, NULL, NULL, '6957 Corte Poquito', 'West Covina', 'CA', '76354', 'USA', 0);
INSERT INTO accounts VALUES ('a8030d8c-eb1a-0cd0-6a78-438dfb9da2b9', '2005-11-30 19:20:31', '2005-11-30 19:20:31', '1', 'will_id', '1', 'Homax-Adams Transportation Group', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '8452 Dewing Avenue', 'San Carlos', 'CA', '64065', 'USA', NULL, NULL, '428-555-4437', NULL, NULL, NULL, 'www.homax-adamstransportationgroup.com', NULL, NULL, NULL, NULL, '8452 Dewing Avenue', 'San Carlos', 'CA', '64065', 'USA', 0);
INSERT INTO accounts VALUES ('d5990adb-7e13-c998-591a-438dfb469076', '2005-11-30 19:20:32', '2005-11-30 19:20:32', '1', 'max_id', '1', 'V & P Zubaty Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '4567 Shannon Lane', 'Edmonds', 'WA', '81086', 'USA', NULL, NULL, '348-555-3644', NULL, NULL, NULL, 'www.vpzubatytransportationcorp.com', NULL, NULL, NULL, NULL, '4567 Shannon Lane', 'Edmonds', 'WA', '81086', 'USA', 0);
INSERT INTO accounts VALUES ('3d8a4e68-3a64-5257-f4e8-438dfb6e96f3', '2005-11-30 19:20:32', '2005-11-30 19:20:32', '1', 'will_id', '1', 'Zubaty-Khan Telecommunications, Inc', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '6316 Damascus Loop', 'Tlaxiaco', 'Oaxaca', '34959', 'Mexico', NULL, NULL, '774-555-8423', NULL, NULL, NULL, 'www.zubaty-khantelecommunications,inc.com', NULL, NULL, NULL, NULL, '6316 Damascus Loop', 'Tlaxiaco', 'Oaxaca', '34959', 'Mexico', 0);
INSERT INTO accounts VALUES ('7020cebe-a450-fe7d-c86f-438dfb1e6ee0', '2005-11-30 19:20:32', '2005-11-30 19:20:32', '1', 'matt_id', '1', 'F & X Brinkd Communications Partners', NULL, 'Consulting', 'Communications', NULL, NULL, '2685 Keith Court', 'Colma', 'CA', '39589', 'USA', NULL, NULL, '717-555-6258', NULL, NULL, NULL, 'www.fxbrinkdcommunicationspartners.com', NULL, NULL, NULL, NULL, '2685 Keith Court', 'Colma', 'CA', '39589', 'USA', 0);
INSERT INTO accounts VALUES ('b6e5a19f-c8e7-6e3b-ae0e-438dfb226928', '2005-11-30 19:20:32', '2005-11-30 19:20:32', '1', 'sally_id', '1', 'Brinkd-Clark Communications Holdings', NULL, 'Distribution', 'Communications', NULL, NULL, '7344 Maureen Lane', 'Altadena', 'CA', '58623', 'USA', NULL, NULL, '195-555-4898', NULL, NULL, NULL, 'www.brinkd-clarkcommunicationsholdings.com', NULL, NULL, NULL, NULL, '7344 Maureen Lane', 'Altadena', 'CA', '58623', 'USA', 0);
INSERT INTO accounts VALUES ('6278c3f9-a220-9270-5af6-438dfb72491b', '2005-11-30 19:20:33', '2005-11-30 19:20:33', '1', 'sarah_id', '1', 'S & X Dennis Engineering Partners', NULL, 'Distribution', 'Engineering', NULL, NULL, '3967 High Street', 'Spokane', 'WA', '55707', 'USA', NULL, NULL, '160-555-1362', NULL, NULL, NULL, 'www.sxdennisengineeringpartners.com', NULL, NULL, NULL, NULL, '3967 High Street', 'Spokane', 'WA', '55707', 'USA', 0);
INSERT INTO accounts VALUES ('d9482781-428b-2a2d-fcf8-438dfb95822e', '2005-11-30 19:20:33', '2005-11-30 19:20:33', '1', 'sarah_id', '1', 'Dennis-Brumfield Transportation, Inc', NULL, 'Supply', 'Transportation', NULL, NULL, '1536 Camino Verde Ct.', 'San Jose', 'CA', '40903', 'USA', NULL, NULL, '211-555-1712', NULL, NULL, NULL, 'www.dennis-brumfieldtransportation,inc.com', NULL, NULL, NULL, NULL, '1536 Camino Verde Ct.', 'San Jose', 'CA', '40903', 'USA', 0);
INSERT INTO accounts VALUES ('58317a7d-2ddc-3c98-219b-438dfb5f9207', '2005-11-30 19:20:34', '2005-11-30 19:20:34', '1', 'sarah_id', '1', 'H & N Sanchez Machinery Corp', NULL, 'Supply', 'Machinery', NULL, NULL, '8412 Jorge', 'Lynnwood', 'WA', '76856', 'USA', NULL, NULL, '199-555-5805', NULL, NULL, NULL, 'www.hnsanchezmachinerycorp.com', NULL, NULL, NULL, NULL, '8412 Jorge', 'Lynnwood', 'WA', '76856', 'USA', 0);
INSERT INTO accounts VALUES ('8c34dea4-f951-5167-dbd9-438dfbe8ee7a', '2005-11-30 19:20:34', '2005-11-30 19:20:34', '1', 'will_id', '1', 'Sanchez-Suess Machinery Associates', NULL, 'Supply', 'Machinery', NULL, NULL, '6235 Bayview Cr', 'Oak Bay', 'BC', '28214', 'Canada', NULL, NULL, '272-555-4783', NULL, NULL, NULL, 'www.sanchez-suessmachineryassociates.com', NULL, NULL, NULL, NULL, '6235 Bayview Cr', 'Oak Bay', 'BC', '28214', 'Canada', 0);
INSERT INTO accounts VALUES ('9a350d13-6edf-b916-ec0b-438dfb2a07af', '2005-11-30 19:20:35', '2005-11-30 19:20:35', '1', 'max_id', '1', 'G & W Trach Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '6022 La Salle Ct.', 'Oak Bay', 'BC', '30329', 'Canada', NULL, NULL, '522-555-2162', NULL, NULL, NULL, 'www.gwtrachtransportation,inc.com', NULL, NULL, NULL, NULL, '6022 La Salle Ct.', 'Oak Bay', 'BC', '30329', 'Canada', 0);
INSERT INTO accounts VALUES ('86de1521-2c63-1031-db6e-438dfb2ead4e', '2005-11-30 19:20:35', '2005-11-30 19:20:35', '1', 'matt_id', '1', 'Trach-White Machinery Corp', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '5346 Clayburn Road', 'Olympia', 'WA', '20555', 'USA', NULL, NULL, '618-555-8769', NULL, NULL, NULL, 'www.trach-whitemachinerycorp.com', NULL, NULL, NULL, NULL, '5346 Clayburn Road', 'Olympia', 'WA', '20555', 'USA', 0);
INSERT INTO accounts VALUES ('dbdbd11a-09c0-9969-15bd-438dfbe7c1c9', '2005-11-30 19:20:35', '2005-11-30 19:20:35', '1', 'beth_id', '1', 'V & B Brian Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '5386 Salvio St.', 'Long Beach', 'CA', '87831', 'USA', NULL, NULL, '230-555-8433', NULL, NULL, NULL, 'www.vbbriantransportationholdings.com', NULL, NULL, NULL, NULL, '5386 Salvio St.', 'Long Beach', 'CA', '87831', 'USA', 0);
INSERT INTO accounts VALUES ('59934fb2-8e1b-67b2-22ba-438dfb7f0116', '2005-11-30 19:20:36', '2005-11-30 19:20:36', '1', 'beth_id', '1', 'Brian-Trujillo Construction Company', NULL, 'Consulting', 'Construction', NULL, NULL, '3718 Loma Linda', 'Shawnee', 'BC', '70511', 'Canada', NULL, NULL, '349-555-4669', NULL, NULL, NULL, 'www.brian-trujilloconstructioncompany.com', NULL, NULL, NULL, NULL, '3718 Loma Linda', 'Shawnee', 'BC', '70511', 'Canada', 0);
INSERT INTO accounts VALUES ('b81a5d60-1cc1-f5d2-cc0d-438dfb7e8cf4', '2005-11-30 19:20:36', '2005-11-30 19:20:36', '1', 'max_id', '1', 'C & A Alameda Engineering Group', NULL, 'Supply', 'Engineering', NULL, NULL, '6668 Mazatlan', 'Mexico City', 'Mexico', '49504', 'Mexico', NULL, NULL, '884-555-2962', NULL, NULL, NULL, 'www.caalamedaengineeringgroup.com', NULL, NULL, NULL, NULL, '6668 Mazatlan', 'Mexico City', 'Mexico', '49504', 'Mexico', 0);
INSERT INTO accounts VALUES ('e8246f0b-bbcf-612a-b608-438dfb437293', '2005-11-30 19:20:36', '2005-11-30 19:20:36', '1', 'kristen_id', '1', 'Alameda-Fox Construction, Ltd', NULL, 'Consulting', 'Construction', NULL, NULL, '7909 Yorba Linda', 'Salem', 'OR', '26499', 'USA', NULL, NULL, '365-555-1483', NULL, NULL, NULL, 'www.alameda-foxconstruction,ltd.com', NULL, NULL, NULL, NULL, '7909 Yorba Linda', 'Salem', 'OR', '26499', 'USA', 0);
INSERT INTO accounts VALUES ('39eccd8b-876e-5ed7-ac0e-438dfbc35d74', '2005-11-30 19:20:37', '2005-11-30 19:20:37', '1', 'chris_id', '1', 'U & S Gallagher Transportation, Inc', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '1114 R St.', 'Ballard', 'WA', '26099', 'USA', NULL, NULL, '922-555-7405', NULL, NULL, NULL, 'www.usgallaghertransportation,inc.com', NULL, NULL, NULL, NULL, '1114 R St.', 'Ballard', 'WA', '26099', 'USA', 0);
INSERT INTO accounts VALUES ('6ce495ca-809d-4c8c-9bec-438dfb099655', '2005-11-30 19:20:37', '2005-11-30 19:20:37', '1', 'will_id', '1', 'Gallagher-Myer Construction Group', NULL, 'Distribution', 'Construction', NULL, NULL, '2609 Amarillo', 'Guadalajara', 'Jalisco', '13810', 'Mexico', NULL, NULL, '426-555-4555', NULL, NULL, NULL, 'www.gallagher-myerconstructiongroup.com', NULL, NULL, NULL, NULL, '2609 Amarillo', 'Guadalajara', 'Jalisco', '13810', 'Mexico', 0);
INSERT INTO accounts VALUES ('b329a1fc-7bcf-8d63-4257-438dfbf15f68', '2005-11-30 19:20:37', '2005-11-30 19:20:37', '1', 'sarah_id', '1', 'N & W Byrnes Transportation Corp', NULL, 'Distribution', 'Transportation', NULL, NULL, '6067 Mt. Diablo St.', 'Torrance', 'CA', '44494', 'USA', NULL, NULL, '460-555-5943', NULL, NULL, NULL, 'www.nwbyrnestransportationcorp.com', NULL, NULL, NULL, NULL, '6067 Mt. Diablo St.', 'Torrance', 'CA', '44494', 'USA', 0);
INSERT INTO accounts VALUES ('e339f5c5-b133-c664-9d25-438dfb5a24c6', '2005-11-30 19:20:37', '2005-11-30 19:20:37', '1', 'matt_id', '1', 'Byrnes-Ryan Engineering Partners', NULL, 'Supply', 'Engineering', NULL, NULL, '473 Akyn Rock Drive', 'Guadalajara', 'Jalisco', '24659', 'Mexico', NULL, NULL, '887-555-1721', NULL, NULL, NULL, 'www.byrnes-ryanengineeringpartners.com', NULL, NULL, NULL, NULL, '473 Akyn Rock Drive', 'Guadalajara', 'Jalisco', '24659', 'Mexico', 0);
INSERT INTO accounts VALUES ('1fed618e-f94a-e3c4-374d-438dfb59d0df', '2005-11-30 19:20:38', '2005-11-30 19:20:38', '1', 'sarah_id', '1', 'O & D Chand Communications Associates', NULL, 'Distribution', 'Communications', NULL, NULL, '6841 Curletto Dr.', 'Victoria', 'BC', '29290', 'Canada', NULL, NULL, '829-555-8557', NULL, NULL, NULL, 'www.odchandcommunicationsassociates.com', NULL, NULL, NULL, NULL, '6841 Curletto Dr.', 'Victoria', 'BC', '29290', 'Canada', 0);
INSERT INTO accounts VALUES ('7f50d6b5-430d-df28-c8a6-438dfb84bffa', '2005-11-30 19:20:38', '2005-11-30 19:20:38', '1', 'sally_id', '1', 'Chand-Vanderkamp Transportation Company', NULL, 'Consulting', 'Transportation', NULL, NULL, '8844 Fitzpatrick Drive', 'Cliffside', 'BC', '48324', 'Canada', NULL, NULL, '618-555-6621', NULL, NULL, NULL, 'www.chand-vanderkamptransportationcompany.com', NULL, NULL, NULL, NULL, '8844 Fitzpatrick Drive', 'Cliffside', 'BC', '48324', 'Canada', 0);
INSERT INTO accounts VALUES ('c5bdbb77-f107-f5c8-e8b9-438dfb7acc06', '2005-11-30 19:20:38', '2005-11-30 19:20:38', '1', 'sally_id', '1', 'M & Y Carroll Communications, Ltd', NULL, 'Supply', 'Communications', NULL, NULL, '8122 Cincerto Circle', 'Woodburn', 'OR', '19116', 'USA', NULL, NULL, '822-555-6743', NULL, NULL, NULL, 'www.mycarrollcommunications,ltd.com', NULL, NULL, NULL, NULL, '8122 Cincerto Circle', 'Woodburn', 'OR', '19116', 'USA', 0);
INSERT INTO accounts VALUES ('19000da7-6ebc-31b9-14ae-438dfb8689ca', '2005-11-30 19:20:39', '2005-11-30 19:20:39', '1', 'beth_id', '1', 'Carroll-Contreras Communications Associates', NULL, 'Consulting', 'Communications', NULL, NULL, '3036 W. Cypress Road', 'Altadena', 'CA', '43124', 'USA', NULL, NULL, '633-555-3436', NULL, NULL, NULL, 'www.carroll-contrerascommunicationsassociates.com', NULL, NULL, NULL, NULL, '3036 W. Cypress Road', 'Altadena', 'CA', '43124', 'USA', 0);
INSERT INTO accounts VALUES ('31f324b0-84e2-e496-0b6d-438dfb467fdd', '2005-11-30 19:20:39', '2005-11-30 19:20:39', '1', 'max_id', '1', 'B & D Cantoni Machinery Partners', NULL, 'Consulting', 'Machinery', NULL, NULL, '2569 La Orinda Pl.', 'Puyallup', 'WA', '40265', 'USA', NULL, NULL, '860-555-2186', NULL, NULL, NULL, 'www.bdcantonimachinerypartners.com', NULL, NULL, NULL, NULL, '2569 La Orinda Pl.', 'Puyallup', 'WA', '40265', 'USA', 0);
INSERT INTO accounts VALUES ('6509922d-d234-5fb0-6ac8-438dfb659f47', '2005-11-30 19:20:39', '2005-11-30 19:20:39', '1', 'sarah_id', '1', 'Cantoni-Reed Construction Partners', NULL, 'Manufacturing', 'Construction', NULL, NULL, '7736 Sunnybrook Drive', 'Mexico City', 'Mexico', '90621', 'Mexico', NULL, NULL, '695-555-6507', NULL, NULL, NULL, 'www.cantoni-reedconstructionpartners.com', NULL, NULL, NULL, NULL, '7736 Sunnybrook Drive', 'Mexico City', 'Mexico', '90621', 'Mexico', 0);
INSERT INTO accounts VALUES ('95054470-16de-54b4-32e6-438dfbac2b9e', '2005-11-30 19:20:39', '2005-11-30 19:20:39', '1', 'kristen_id', '1', 'H & E Peterson Machinery Group', NULL, 'Supply', 'Machinery', NULL, NULL, '7522 Santa Ana Drive', 'Mexico City', 'Mexico', '92736', 'Mexico', NULL, NULL, '945-555-3885', NULL, NULL, NULL, 'www.hepetersonmachinerygroup.com', NULL, NULL, NULL, NULL, '7522 Santa Ana Drive', 'Mexico City', 'Mexico', '92736', 'Mexico', 0);
INSERT INTO accounts VALUES ('dc18087d-3c5a-3a97-250b-438dfbe74cbd', '2005-11-30 19:20:39', '2005-11-30 19:20:39', '1', 'beth_id', '1', 'Peterson-Osborn Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '5600 Star Tree Court', 'Ladner', 'BC', '10256', 'Canada', NULL, NULL, '141-555-1493', NULL, NULL, NULL, 'www.peterson-osbornelectronicsholdings.com', NULL, NULL, NULL, NULL, '5600 Star Tree Court', 'Ladner', 'BC', '10256', 'Canada', 0);
INSERT INTO accounts VALUES ('17f0e87c-b18d-de19-c127-438dfb484b0e', '2005-11-30 19:20:40', '2005-11-30 19:20:40', '1', 'max_id', '1', 'X & M Graham. Construction Corp', NULL, 'Manufacturing', 'Construction', NULL, NULL, '5640 Indianhead Way', 'Tlaxiaco', 'Oaxaca', '77531', 'Mexico', NULL, NULL, '653-555-1157', NULL, NULL, NULL, 'www.xmgrahamconstructioncorp.com', NULL, NULL, NULL, NULL, '5640 Indianhead Way', 'Tlaxiaco', 'Oaxaca', '77531', 'Mexico', 0);
INSERT INTO accounts VALUES ('4866d31a-888a-51cf-a799-438dfb30643e', '2005-11-30 19:20:40', '2005-11-30 19:20:40', '1', 'sally_id', '1', 'Graham.-Shaddy Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '6627 Camelback Ct.', 'Coronado', 'CA', '33920', 'USA', NULL, NULL, '771-555-6393', NULL, NULL, NULL, 'www.graham-shaddytelecommunications,ltd.com', NULL, NULL, NULL, NULL, '6627 Camelback Ct.', 'Coronado', 'CA', '33920', 'USA', 0);
INSERT INTO accounts VALUES ('7b321c4c-7815-b632-cf04-438dfb64fe0b', '2005-11-30 19:20:40', '2005-11-30 19:20:40', '1', 'chris_id', '1', 'I & M Haemon Transportation, Ltd', NULL, 'Supply', 'Transportation', NULL, NULL, '6922 Hamlet', 'Tacoma', 'WA', '67358', 'USA', NULL, NULL, '996-555-5260', NULL, NULL, NULL, 'www.imhaemontransportation,ltd.com', NULL, NULL, NULL, NULL, '6922 Hamlet', 'Tacoma', 'WA', '67358', 'USA', 0);
INSERT INTO accounts VALUES ('ac3d7e95-9f69-ad88-3bc8-438dfbb70424', '2005-11-30 19:20:40', '2005-11-30 19:20:40', '1', 'will_id', '1', 'Haemon-Krow Electronics Corp', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '8163 S. Forest Hill', 'Shawnee', 'BC', '16200', 'Canada', NULL, NULL, '477-555-3782', NULL, NULL, NULL, 'www.haemon-krowelectronicscorp.com', NULL, NULL, NULL, NULL, '8163 S. Forest Hill', 'Shawnee', 'BC', '16200', 'Canada', 0);
INSERT INTO accounts VALUES ('ddf0b38e-97d5-ad1c-f916-438dfbd7d9e8', '2005-11-30 19:20:40', '2005-11-30 19:20:40', '1', 'kristen_id', '1', 'H & Y Belli Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '1368 Palms Drive', 'Renton', 'WA', '88506', 'USA', NULL, NULL, '135-555-9703', NULL, NULL, NULL, 'www.hybelliengineering,inc.com', NULL, NULL, NULL, NULL, '1368 Palms Drive', 'Renton', 'WA', '88506', 'USA', 0);
INSERT INTO accounts VALUES ('1aab927c-fd16-de4f-4b33-438dfb6f7451', '2005-11-30 19:20:41', '2005-11-30 19:20:41', '1', 'jaime_id', '1', 'Belli-Porter Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '2863 Polk Street', 'Torrance', 'CA', '35114', 'USA', NULL, NULL, '539-555-6853', NULL, NULL, NULL, 'www.belli-portertelecommunications,ltd.com', NULL, NULL, NULL, NULL, '2863 Polk Street', 'Torrance', 'CA', '35114', 'USA', 0);
INSERT INTO accounts VALUES ('4c0b8c40-4533-109f-aeda-438dfb6379ec', '2005-11-30 19:20:41', '2005-11-30 19:20:41', '1', 'sally_id', '1', 'D & A Lesko Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '8977 Woodhaven Lane', 'Ladner', 'BC', '41979', 'Canada', NULL, NULL, '458-555-6060', NULL, NULL, NULL, 'www.daleskomachinerygroup.com', NULL, NULL, NULL, NULL, '8977 Woodhaven Lane', 'Ladner', 'BC', '41979', 'Canada', 0);
INSERT INTO accounts VALUES ('7e9f6827-6e0c-f188-75c5-438dfb8b79a9', '2005-11-30 19:20:41', '2005-11-30 19:20:41', '1', 'max_id', '1', 'Lesko-Worland Construction Associates', NULL, 'Consulting', 'Construction', NULL, NULL, '727 Pheasant Ct.', 'Burlingame', 'CA', '20239', 'USA', NULL, NULL, '885-555-1839', NULL, NULL, NULL, 'www.lesko-worlandconstructionassociates.com', NULL, NULL, NULL, NULL, '727 Pheasant Ct.', 'Burlingame', 'CA', '20239', 'USA', 0);
INSERT INTO accounts VALUES ('af8dce10-c2b1-ef6e-6bf1-438dfb1fe0ae', '2005-11-30 19:20:41', '2005-11-30 19:20:41', '1', 'max_id', '1', 'D & Z Torre Electronics, Ltd', NULL, 'Consulting', 'Electronics', NULL, NULL, '7095 Thames Drive', 'Concord', 'CA', '51162', 'USA', NULL, NULL, '827-555-8675', NULL, NULL, NULL, 'www.dztorreelectronics,ltd.com', NULL, NULL, NULL, NULL, '7095 Thames Drive', 'Concord', 'CA', '51162', 'USA', 0);
INSERT INTO accounts VALUES ('e1416852-2539-0461-eb2f-438dfb5f540b', '2005-11-30 19:20:41', '2005-11-30 19:20:41', '1', 'kristen_id', '1', 'Torre-Ramos Engineering Corp', NULL, 'Consulting', 'Engineering', NULL, NULL, '1755 Winton Drive', 'Lake Oswego', 'OR', '70195', 'USA', NULL, NULL, '616-555-6739', NULL, NULL, NULL, 'www.torre-ramosengineeringcorp.com', NULL, NULL, NULL, NULL, '1755 Winton Drive', 'Lake Oswego', 'OR', '70195', 'USA', 0);
INSERT INTO accounts VALUES ('1d41932b-182f-9f4d-af30-438dfb9faa94', '2005-11-30 19:20:42', '2005-11-30 19:20:42', '1', 'will_id', '1', 'Q & Q Christie Telecommunications Associates', NULL, 'Supply', 'Telecommunications', NULL, NULL, '8377 St. Raphael Drive', 'La Cruz', 'Sinaloa', '40988', 'Mexico', NULL, NULL, '820-555-6860', NULL, NULL, NULL, 'www.qqchristietelecommunicationsassociates.com', NULL, NULL, NULL, NULL, '8377 St. Raphael Drive', 'La Cruz', 'Sinaloa', '40988', 'Mexico', 0);
INSERT INTO accounts VALUES ('4e9f154d-16b4-238c-5348-438dfb689c29', '2005-11-30 19:20:42', '2005-11-30 19:20:42', '1', 'max_id', '1', 'Christie-Zocchi Engineering Company', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '3290 Las Palmas', 'Yakima', 'WA', '26183', 'USA', NULL, NULL, '631-555-3553', NULL, NULL, NULL, 'www.christie-zocchiengineeringcompany.com', NULL, NULL, NULL, NULL, '3290 Las Palmas', 'Yakima', 'WA', '26183', 'USA', 0);
INSERT INTO accounts VALUES ('8266a8e4-ad91-3ae3-cbae-438dfbb6b5c1', '2005-11-30 19:20:42', '2005-11-30 19:20:42', '1', 'matt_id', '1', 'Y & R Altamirano Machinery, Inc', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '8757 Keith Court', 'Seattle', 'WA', '62136', 'USA', NULL, NULL, '858-555-2303', NULL, NULL, NULL, 'www.yraltamiranomachinery,inc.com', NULL, NULL, NULL, NULL, '8757 Keith Court', 'Seattle', 'WA', '62136', 'USA', 0);
INSERT INTO accounts VALUES ('b65cd00d-729a-34b7-35ed-438dfb9a9bc9', '2005-11-30 19:20:42', '2005-11-30 19:20:42', '1', 'sarah_id', '1', 'Altamirano-Benson Engineering, Inc', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '3925 Boyd', 'Corvallis', 'OR', '13494', 'USA', NULL, NULL, '692-555-6625', NULL, NULL, NULL, 'www.altamirano-bensonengineering,inc.com', NULL, NULL, NULL, NULL, '3925 Boyd', 'Corvallis', 'OR', '13494', 'USA', 0);
INSERT INTO accounts VALUES ('e7af64ad-bd00-43de-eae6-438dfba53d59', '2005-11-30 19:20:42', '2005-11-30 19:20:42', '1', 'kristen_id', '1', 'E & F Deborde Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '3711 Amargosa Drive', 'Glendale', 'CA', '15609', 'USA', NULL, NULL, '155-555-6263', NULL, NULL, NULL, 'www.efdebordemachinery,ltd.com', NULL, NULL, NULL, NULL, '3711 Amargosa Drive', 'Glendale', 'CA', '15609', 'USA', 0);
INSERT INTO accounts VALUES ('25741180-9b0a-6d59-d2a5-438dfb18643c', '2005-11-30 19:20:43', '2005-11-30 19:20:43', '1', 'chris_id', '1', 'Deborde-Calone Transportation Holdings', NULL, 'Distribution', 'Transportation', NULL, NULL, '1789 Birchwood Dr.', 'Corvallis', 'OR', '32128', 'USA', NULL, NULL, '490-555-7528', NULL, NULL, NULL, 'www.deborde-calonetransportationholdings.com', NULL, NULL, NULL, NULL, '1789 Birchwood Dr.', 'Corvallis', 'OR', '32128', 'USA', 0);
INSERT INTO accounts VALUES ('56062170-fdae-2ecd-1d09-438dfb6bc554', '2005-11-30 19:20:43', '2005-11-30 19:20:43', '1', 'will_id', '1', 'N & O Pompa Electronics, Inc', NULL, 'Supply', 'Electronics', NULL, NULL, '4485 Pheasant Court', 'Guadalajara', 'Jalisco', '73111', 'Mexico', NULL, NULL, '763-555-3535', NULL, NULL, NULL, 'www.nopompaelectronics,inc.com', NULL, NULL, NULL, NULL, '4485 Pheasant Court', 'Guadalajara', 'Jalisco', '73111', 'Mexico', 0);
INSERT INTO accounts VALUES ('8a826d91-bce7-285c-8ab8-438dfb3f96e0', '2005-11-30 19:20:43', '2005-11-30 19:20:43', '1', 'kristen_id', '1', 'Pompa-Traube Machinery Group', NULL, 'Distribution', 'Machinery', NULL, NULL, '2816 Hemlock Drive', 'Pomona', 'CA', '55792', 'USA', NULL, NULL, '882-555-8770', NULL, NULL, NULL, 'www.pompa-traubemachinerygroup.com', NULL, NULL, NULL, NULL, '2816 Hemlock Drive', 'Pomona', 'CA', '55792', 'USA', 0);
INSERT INTO accounts VALUES ('bc63a675-5703-c072-d39c-438dfb5cbdbb', '2005-11-30 19:20:43', '2005-11-30 19:20:43', '1', 'beth_id', '1', 'U & W Sloan Construction Corp', NULL, 'Supply', 'Construction', NULL, NULL, '5767 Oakmead', 'Newton', 'BC', '89229', 'Canada', NULL, NULL, '516-555-7063', NULL, NULL, NULL, 'www.uwsloanconstructioncorp.com', NULL, NULL, NULL, NULL, '5767 Oakmead', 'Newton', 'BC', '89229', 'Canada', 0);
INSERT INTO accounts VALUES ('eec2024f-aca5-cc51-a9f0-438dfb18062e', '2005-11-30 19:20:43', '2005-11-30 19:20:43', '1', 'max_id', '1', 'Sloan-Villa Electronics Company', NULL, 'Consulting', 'Electronics', NULL, NULL, '4352 Acardia Pl.', 'Coronado', 'CA', '11780', 'USA', NULL, NULL, '897-555-5585', NULL, NULL, NULL, 'www.sloan-villaelectronicscompany.com', NULL, NULL, NULL, NULL, '4352 Acardia Pl.', 'Coronado', 'CA', '11780', 'USA', 0);
INSERT INTO accounts VALUES ('2eba6615-e135-9bb5-71b8-438dfb829629', '2005-11-30 19:20:44', '2005-11-30 19:20:44', '1', 'chris_id', '1', 'M & K Herman Telecommunications, Ltd', NULL, 'Supply', 'Telecommunications', NULL, NULL, '213 Valencia Place', 'Tacoma', 'WA', '11379', 'USA', NULL, NULL, '555-555-2506', NULL, NULL, NULL, 'www.mkhermantelecommunications,ltd.com', NULL, NULL, NULL, NULL, '213 Valencia Place', 'Tacoma', 'WA', '11379', 'USA', 0);
INSERT INTO accounts VALUES ('616b518a-544d-0883-cdd8-438dfbe9c092', '2005-11-30 19:20:44', '2005-11-30 19:20:44', '1', 'sarah_id', '1', 'Herman-Roberts Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '1708 Weaver Lane', 'Oregon City', 'OR', '98089', 'USA', NULL, NULL, '958-555-8656', NULL, NULL, NULL, 'www.herman-robertsmachinery,ltd.com', NULL, NULL, NULL, NULL, '1708 Weaver Lane', 'Oregon City', 'OR', '98089', 'USA', 0);
INSERT INTO accounts VALUES ('95ab83f6-5009-5c0f-41d7-438dfb8a0468', '2005-11-30 19:20:44', '2005-11-30 19:20:44', '1', 'beth_id', '1', 'L & E Mc Clane Communications Partners', NULL, 'Distribution', 'Communications', NULL, NULL, '5166 D Kiska Ct.', 'Tixapan', 'DF', '63851', 'Mexico', NULL, NULL, '878-555-7863', NULL, NULL, NULL, 'www.lemcclanecommunicationspartners.com', NULL, NULL, NULL, NULL, '5166 D Kiska Ct.', 'Tixapan', 'DF', '63851', 'Mexico', 0);
INSERT INTO accounts VALUES ('c7fcc12b-5997-5960-ccc8-438dfbacf96f', '2005-11-30 19:20:44', '2005-11-30 19:20:44', '1', 'sally_id', '1', 'Mc Clane-Maxham Construction Holdings', NULL, 'Consulting', 'Construction', NULL, NULL, '9571 Live Oak Dr.', 'Glendale', 'CA', '17724', 'USA', NULL, NULL, '644-555-7299', NULL, NULL, NULL, 'www.mcclane-maxhamconstructionholdings.com', NULL, NULL, NULL, NULL, '9571 Live Oak Dr.', 'Glendale', 'CA', '17724', 'USA', 0);
INSERT INTO accounts VALUES ('3c910d7e-5182-9ac0-8ee3-438dfb494aa7', '2005-11-30 19:20:45', '2005-11-30 19:20:45', '1', 'kristen_id', '1', 'W & N Sullivan Telecommunications Partners', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '3284 Bynum Way', 'Lakewood', 'CA', '16185', 'USA', NULL, NULL, '586-555-5135', NULL, NULL, NULL, 'www.wnsullivantelecommunicationspartners.com', NULL, NULL, NULL, NULL, '3284 Bynum Way', 'Lakewood', 'CA', '16185', 'USA', 0);
INSERT INTO accounts VALUES ('3b0dc215-af7c-b404-0e73-438dfba6265a', '2005-11-30 19:20:45', '2005-11-30 19:20:45', '1', 'sally_id', '1', 'Sullivan-Watada Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '7943 Cunha Ct.', 'Burien', 'WA', '35219', 'USA', NULL, NULL, '135-555-8542', NULL, NULL, NULL, 'www.sullivan-watadatransportationholdings.com', NULL, NULL, NULL, NULL, '7943 Cunha Ct.', 'Burien', 'WA', '35219', 'USA', 0);
INSERT INTO accounts VALUES ('6dd767e8-13fc-8646-d64e-438dfba52ba4', '2005-11-30 19:20:45', '2005-11-30 19:20:45', '1', 'beth_id', '1', 'V & A Rhiger Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '4566 Bermad Drive', 'La Mesa', 'CA', '32303', 'USA', NULL, NULL, '930-555-9238', NULL, NULL, NULL, 'www.varhigertransportationcorp.com', NULL, NULL, NULL, NULL, '4566 Bermad Drive', 'La Mesa', 'CA', '32303', 'USA', 0);
INSERT INTO accounts VALUES ('aaade8ed-539e-25a3-a313-438dfbe29b87', '2005-11-30 19:20:45', '2005-11-30 19:20:45', '1', 'max_id', '1', 'Rhiger-Finley Communications Corp', NULL, 'Consulting', 'Communications', NULL, NULL, '2135 St. Paul Way', 'Kirkland', 'WA', '17499', 'USA', NULL, NULL, '741-555-5931', NULL, NULL, NULL, 'www.rhiger-finleycommunicationscorp.com', NULL, NULL, NULL, NULL, '2135 St. Paul Way', 'Kirkland', 'WA', '17499', 'USA', 0);
INSERT INTO accounts VALUES ('dd4dfabf-5d83-b24d-63ea-438dfb8bcb28', '2005-11-30 19:20:45', '2005-11-30 19:20:45', '1', 'sally_id', '1', 'T & A Winter Electronics, Inc', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '9011 Blackburn Ct.', 'Oak Bay', 'BC', '53452', 'Canada', NULL, NULL, '968-555-4681', NULL, NULL, NULL, 'www.tawinterelectronics,inc.com', NULL, NULL, NULL, NULL, '9011 Blackburn Ct.', 'Oak Bay', 'BC', '53452', 'Canada', 0);
INSERT INTO accounts VALUES ('1c212a84-fd58-399f-3cbb-438dfb20ae5f', '2005-11-30 19:20:46', '2005-11-30 19:20:46', '1', 'matt_id', '1', 'Winter-Adams Construction Associates', NULL, 'Manufacturing', 'Construction', NULL, NULL, '6835 Lynwood Drive', 'Spring Valley', 'CA', '48094', 'USA', NULL, NULL, '802-555-9002', NULL, NULL, NULL, 'www.winter-adamsconstructionassociates.com', NULL, NULL, NULL, NULL, '6835 Lynwood Drive', 'Spring Valley', 'CA', '48094', 'USA', 0);
INSERT INTO accounts VALUES ('4c8fc584-f156-c149-1e8e-438dfbbb63e7', '2005-11-30 19:20:46', '2005-11-30 19:20:46', '1', 'chris_id', '1', 'D & D Tench Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '6621 Polaris Dr.', 'Imperial Beach', 'CA', '69245', 'USA', NULL, NULL, '391-555-1038', NULL, NULL, NULL, 'www.ddtenchelectronicsholdings.com', NULL, NULL, NULL, NULL, '6621 Polaris Dr.', 'Imperial Beach', 'CA', '69245', 'USA', 0);
INSERT INTO accounts VALUES ('8a931919-f2df-13cb-44c5-438dfbd0a58a', '2005-11-30 19:20:46', '2005-11-30 19:20:46', '1', 'sarah_id', '1', 'Tench-Brink Machinery, Inc', NULL, 'Distribution', 'Machinery', NULL, NULL, '4698 Royal Oak Rd.', 'San Francisco', 'CA', '96150', 'USA', NULL, NULL, '488-555-7645', NULL, NULL, NULL, 'www.tench-brinkmachinery,inc.com', NULL, NULL, NULL, NULL, '4698 Royal Oak Rd.', 'San Francisco', 'CA', '96150', 'USA', 0);
INSERT INTO accounts VALUES ('bdc79323-8fd7-f491-7b9b-438dfb8c1b5f', '2005-11-30 19:20:46', '2005-11-30 19:20:46', '1', 'sally_id', '1', 'I & V Reynolds Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '4739 Garden Ave.', 'Lebanon', 'OR', '64427', 'USA', NULL, NULL, '760-555-3652', NULL, NULL, NULL, 'www.ivreynoldsengineering,inc.com', NULL, NULL, NULL, NULL, '4739 Garden Ave.', 'Lebanon', 'OR', '64427', 'USA', 0);
INSERT INTO accounts VALUES ('edf9127b-11b7-2911-1c06-438dfb43ff50', '2005-11-30 19:20:46', '2005-11-30 19:20:46', '1', 'beth_id', '1', 'Reynolds-Posner Construction, Ltd', NULL, 'Manufacturing', 'Construction', NULL, NULL, '3071 Asilomar', 'Issaquah', 'WA', '47107', 'USA', NULL, NULL, '218-555-3545', NULL, NULL, NULL, 'www.reynolds-posnerconstruction,ltd.com', NULL, NULL, NULL, NULL, '3071 Asilomar', 'Issaquah', 'WA', '47107', 'USA', 0);
INSERT INTO accounts VALUES ('323ee655-3eae-bfe1-9233-438dfbe035b6', '2005-11-30 19:20:47', '2005-11-30 19:20:47', '1', 'matt_id', '1', 'K & R Hapke Communications Group', NULL, 'Consulting', 'Communications', NULL, NULL, '6021 Ellis St.', 'Merida', 'Yucatan', '54253', 'Mexico', NULL, NULL, '514-555-7181', NULL, NULL, NULL, 'www.krhapkecommunicationsgroup.com', NULL, NULL, NULL, NULL, '6021 Ellis St.', 'Merida', 'Yucatan', '54253', 'Mexico', 0);
INSERT INTO accounts VALUES ('6932c080-9997-6e24-8e32-438dfbf0bc6c', '2005-11-30 19:20:47', '2005-11-30 19:20:47', '1', 'jaime_id', '1', 'Hapke-Huff Engineering Associates', NULL, 'Distribution', 'Engineering', NULL, NULL, '7262 Pepperidge Way', 'Beverly Hills', 'CA', '30955', 'USA', NULL, NULL, '895-555-5702', NULL, NULL, NULL, 'www.hapke-huffengineeringassociates.com', NULL, NULL, NULL, NULL, '7262 Pepperidge Way', 'Beverly Hills', 'CA', '30955', 'USA', 0);
INSERT INTO accounts VALUES ('a11333b2-e34a-7cee-19ff-438dfb1bb3f0', '2005-11-30 19:20:47', '2005-11-30 19:20:47', '1', 'max_id', '1', 'B & P Brown Telecommunications Holdings', NULL, 'Distribution', 'Telecommunications', NULL, NULL, '467 Moccasin Ct.', 'San Carlos', 'CA', '26954', 'USA', NULL, NULL, '552-555-2624', NULL, NULL, NULL, 'www.bpbrowntelecommunicationsholdings.com', NULL, NULL, NULL, NULL, '467 Moccasin Ct.', 'San Carlos', 'CA', '26954', 'USA', 0);
INSERT INTO accounts VALUES ('d94554c7-4b9d-50c9-98e2-438dfbe8a5f8', '2005-11-30 19:20:47', '2005-11-30 19:20:47', '1', 'kristen_id', '1', 'Brown-Giglio Electronics, Ltd', NULL, 'Distribution', 'Electronics', NULL, NULL, '1962 Geary Road', 'Acapulco', 'Guerrero', '89405', 'Mexico', NULL, NULL, '295-555-3431', NULL, NULL, NULL, 'www.brown-giglioelectronics,ltd.com', NULL, NULL, NULL, NULL, '1962 Geary Road', 'Acapulco', 'Guerrero', '89405', 'Mexico', 0);
INSERT INTO accounts VALUES ('19d5e398-425e-558e-6d74-438dfbf0fe26', '2005-11-30 19:20:48', '2005-11-30 19:20:48', '1', 'chris_id', '1', 'Q & P Sherwood Telecommunications Company', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, '5420 Thornwood Drive', 'Beaverton', 'OR', '28874', 'USA', NULL, NULL, '876-555-7981', NULL, NULL, NULL, 'www.qpsherwoodtelecommunicationscompany.com', NULL, NULL, NULL, NULL, '5420 Thornwood Drive', 'Beaverton', 'OR', '28874', 'USA', 0);
INSERT INTO accounts VALUES ('4af89ff2-afdd-3782-61e3-438dfbb82b14', '2005-11-30 19:20:48', '2005-11-30 19:20:48', '1', 'beth_id', '1', 'Sherwood-Becker Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '9825 Mt. Dell Drive', 'Acapulco', 'Guerrero', '90392', 'Mexico', NULL, NULL, '761-555-9439', NULL, NULL, NULL, 'www.sherwood-beckertransportationholdings.com', NULL, NULL, NULL, NULL, '9825 Mt. Dell Drive', 'Acapulco', 'Guerrero', '90392', 'Mexico', 0);
INSERT INTO accounts VALUES ('88ac74b1-6800-3777-713b-438dfbe7d7a8', '2005-11-30 19:20:48', '2005-11-30 19:20:48', '1', 'kristen_id', '1', 'G & N Tedford Communications Group', NULL, 'Supply', 'Communications', NULL, NULL, '6194 Via Maria', 'Daly City', 'CA', '13669', 'USA', NULL, NULL, '704-555-7275', NULL, NULL, NULL, 'www.gntedfordcommunicationsgroup.com', NULL, NULL, NULL, NULL, '6194 Via Maria', 'Daly City', 'CA', '13669', 'USA', 0);
INSERT INTO accounts VALUES ('c09a5ab8-54e1-6916-f816-438dfb8d3205', '2005-11-30 19:20:48', '2005-11-30 19:20:48', '1', 'kristen_id', '1', 'Tedford-Roy Construction Partners', NULL, 'Distribution', 'Construction', NULL, NULL, '2100 Grant Street', 'Ballard', 'WA', '57381', 'USA', NULL, NULL, '492-555-5339', NULL, NULL, NULL, 'www.tedford-royconstructionpartners.com', NULL, NULL, NULL, NULL, '2100 Grant Street', 'Ballard', 'WA', '57381', 'USA', 0);
INSERT INTO accounts VALUES ('f0c43a56-a365-6fd7-e4c6-438dfbc330f8', '2005-11-30 19:20:48', '2005-11-30 19:20:48', '1', 'kristen_id', '1', 'H & Y Holloway Electronics, Ltd', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '8722 Norcross Lane', 'Haney', 'BC', '28173', 'Canada', NULL, NULL, '457-555-1803', NULL, NULL, NULL, 'www.hyhollowayelectronics,ltd.com', NULL, NULL, NULL, NULL, '8722 Norcross Lane', 'Haney', 'BC', '28173', 'Canada', 0);
INSERT INTO accounts VALUES ('34cd4a83-471e-2d8e-17c2-438dfb89a26b', '2005-11-30 19:20:49', '2005-11-30 19:20:49', '1', 'chris_id', '1', 'Holloway-Trau Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '3635 N Ridgewood Drive', 'Lynnwood', 'WA', '13369', 'USA', NULL, NULL, '269-555-7496', NULL, NULL, NULL, 'www.holloway-trautransportationholdings.com', NULL, NULL, NULL, NULL, '3635 N Ridgewood Drive', 'Lynnwood', 'WA', '13369', 'USA', 0);
INSERT INTO accounts VALUES ('6b96215c-a64e-cccb-ca71-438dfbec8fc2', '2005-11-30 19:20:49', '2005-11-30 19:20:49', '1', 'sarah_id', '1', 'O & K Carnes Transportation Corp', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '3168 Thames Drive', 'Marysville', 'WA', '49322', 'USA', NULL, NULL, '496-555-6246', NULL, NULL, NULL, 'www.okcarnestransportationcorp.com', NULL, NULL, NULL, NULL, '3168 Thames Drive', 'Marysville', 'WA', '49322', 'USA', 0);
INSERT INTO accounts VALUES ('9fa1f669-d722-eea7-c612-438dfbbc06c9', '2005-11-30 19:20:49', '2005-11-30 19:20:49', '1', 'beth_id', '1', 'Carnes-Potts Construction Partners', NULL, 'Consulting', 'Construction', NULL, NULL, '8335 Elm Rd.', 'Camacho', 'Zacatecas', '99678', 'Mexico', NULL, NULL, '569-555-5225', NULL, NULL, NULL, 'www.carnes-pottsconstructionpartners.com', NULL, NULL, NULL, NULL, '8335 Elm Rd.', 'Camacho', 'Zacatecas', '99678', 'Mexico', 0);
INSERT INTO accounts VALUES ('d000e617-e866-9135-c35f-438dfbda2b06', '2005-11-30 19:20:49', '2005-11-30 19:20:49', '1', 'sally_id', '1', 'D & D Kozlowski Transportation, Ltd', NULL, 'Distribution', 'Transportation', NULL, NULL, '8121 Larkin Dr.', 'Merida', 'Yucatan', '27943', 'Mexico', NULL, NULL, '819-555-2604', NULL, NULL, NULL, 'www.ddkozlowskitransportation,ltd.com', NULL, NULL, NULL, NULL, '8121 Larkin Dr.', 'Merida', 'Yucatan', '27943', 'Mexico', 0);
INSERT INTO accounts VALUES ('bf7005c7-6394-b116-8ea2-438dfb69e18a', '2005-11-30 19:20:50', '2005-11-30 19:20:50', '1', 'kristen_id', '1', 'Kozlowski-Looney Machinery, Inc', NULL, 'Consulting', 'Machinery', NULL, NULL, '6199 McElroy', 'Chula Vista', 'CA', '19313', 'USA', NULL, NULL, '915-555-9211', NULL, NULL, NULL, 'www.kozlowski-looneymachinery,inc.com', NULL, NULL, NULL, NULL, '6199 McElroy', 'Chula Vista', 'CA', '19313', 'USA', 0);
INSERT INTO accounts VALUES ('3c4f1718-d156-88b2-4920-438dfb205760', '2005-11-30 19:20:50', '2005-11-30 19:20:50', '1', 'beth_id', '1', 'E & M Magenheimer Electronics Company', NULL, 'Supply', 'Electronics', NULL, NULL, '6239 Boyd Road', 'Bellflower', 'CA', '86589', 'USA', NULL, NULL, '288-555-5218', NULL, NULL, NULL, 'www.emmagenheimerelectronicscompany.com', NULL, NULL, NULL, NULL, '6239 Boyd Road', 'Bellflower', 'CA', '86589', 'USA', 0);
INSERT INTO accounts VALUES ('73770f6d-157a-09f1-0350-438dfbdb2bd9', '2005-11-30 19:20:50', '2005-11-30 19:20:50', '1', 'matt_id', '1', 'Magenheimer-Hofsetz Engineering, Ltd', NULL, 'Distribution', 'Engineering', NULL, NULL, '7226 Casa Real', 'La Jolla', 'CA', '42977', 'USA', NULL, NULL, '646-555-5111', NULL, NULL, NULL, 'www.magenheimer-hofsetzengineering,ltd.com', NULL, NULL, NULL, NULL, '7226 Casa Real', 'La Jolla', 'CA', '42977', 'USA', 0);
INSERT INTO accounts VALUES ('a34bb829-3373-27a1-0852-438dfb57c8d1', '2005-11-30 19:20:50', '2005-11-30 19:20:50', '1', 'matt_id', '1', 'R & Z Gilliat Communications, Inc', NULL, 'Distribution', 'Communications', NULL, NULL, '177 Bancroft Road', 'Marysville', 'WA', '76415', 'USA', NULL, NULL, '408-555-4801', NULL, NULL, NULL, 'www.rzgilliatcommunications,inc.com', NULL, NULL, NULL, NULL, '177 Bancroft Road', 'Marysville', 'WA', '76415', 'USA', 0);
INSERT INTO accounts VALUES ('d7fbdc0c-ec20-226e-1b68-438dfb1700d6', '2005-11-30 19:20:50', '2005-11-30 19:20:50', '1', 'chris_id', '1', 'Gilliat-Wojcik Machinery Partners', NULL, 'Supply', 'Machinery', NULL, NULL, '8762 Kiska Court', 'Cliffside', 'BC', '97964', 'Canada', NULL, NULL, '789-555-3323', NULL, NULL, NULL, 'www.gilliat-wojcikmachinerypartners.com', NULL, NULL, NULL, NULL, '8762 Kiska Court', 'Cliffside', 'BC', '97964', 'Canada', 0);
INSERT INTO accounts VALUES ('2b9482ec-3479-9c0a-6fb0-438dfb0980cf', '2005-11-30 19:20:51', '2005-11-30 19:20:51', '1', 'sarah_id', '1', 'J & K Wolf Communications Corp', NULL, 'Supply', 'Communications', NULL, NULL, '1967 Glen Court', 'Albany', 'OR', '97563', 'USA', NULL, NULL, '685-555-3902', NULL, NULL, NULL, 'www.jkwolfcommunicationscorp.com', NULL, NULL, NULL, NULL, '1967 Glen Court', 'Albany', 'OR', '97563', 'USA', 0);
INSERT INTO accounts VALUES ('60f8c2a9-16bb-3bac-e879-438dfbc87f71', '2005-11-30 19:20:51', '2005-11-30 19:20:51', '1', 'sally_id', '1', 'Wolf-Whitworth Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '3462 Briarcliff Ct.', 'Bellflower', 'CA', '85275', 'USA', NULL, NULL, '189-555-1051', NULL, NULL, NULL, 'www.wolf-whitworthconstruction,ltd.com', NULL, NULL, NULL, NULL, '3462 Briarcliff Ct.', 'Bellflower', 'CA', '85275', 'USA', 0);
INSERT INTO accounts VALUES ('98802778-d9c9-d247-7742-438dfb5a8bc0', '2005-11-30 19:20:51', '2005-11-30 19:20:51', '1', 'max_id', '1', 'W & W Thames Electronics Associates', NULL, 'Supply', 'Electronics', NULL, NULL, '9576 Pepperidge Place', 'Langley', 'BC', '51036', 'Canada', NULL, NULL, '769-555-5601', NULL, NULL, NULL, 'www.wwthameselectronicsassociates.com', NULL, NULL, NULL, NULL, '9576 Pepperidge Place', 'Langley', 'BC', '51036', 'Canada', 0);
INSERT INTO accounts VALUES ('d2ba75be-3c40-9b5e-ca6b-438dfb2ef23f', '2005-11-30 19:20:51', '2005-11-30 19:20:51', '1', 'max_id', '1', 'Thames-Rusek Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '1326 Greenwood Place', 'Palo Alto', 'CA', '49095', 'USA', NULL, NULL, '535-555-5037', NULL, NULL, NULL, 'www.thames-rusekmachinerygroup.com', NULL, NULL, NULL, NULL, '1326 Greenwood Place', 'Palo Alto', 'CA', '49095', 'USA', 0);
INSERT INTO accounts VALUES ('1921d5d5-eb23-46e8-25cc-438dfbe3305f', '2005-11-30 19:20:52', '2005-11-30 19:20:52', '1', 'beth_id', '1', 'D & G Justice Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '7694 Furness Street', 'Burlingame', 'CA', '35831', 'USA', NULL, NULL, '477-555-2873', NULL, NULL, NULL, 'www.dgjusticetransportation,inc.com', NULL, NULL, NULL, NULL, '7694 Furness Street', 'Burlingame', 'CA', '35831', 'USA', 0);
INSERT INTO accounts VALUES ('5e4affc3-fc43-dcb3-8da1-438dfb03c50e', '2005-11-30 19:20:52', '2005-11-30 19:20:52', '1', 'matt_id', '1', 'Justice-Conner Engineering, Ltd', NULL, 'Supply', 'Engineering', NULL, NULL, '2354 Pear Dr.', 'Pomona', 'CA', '53540', 'USA', NULL, NULL, '266-555-9937', NULL, NULL, NULL, 'www.justice-connerengineering,ltd.com', NULL, NULL, NULL, NULL, '2354 Pear Dr.', 'Pomona', 'CA', '53540', 'USA', 0);
INSERT INTO accounts VALUES ('90e70ca7-9327-00ec-c1b3-438dfbfecb31', '2005-11-30 19:20:52', '2005-11-30 19:20:52', '1', 'jaime_id', '1', 'Z & L Bauer Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '8976 E Leland', 'Camacho', 'Zacatecas', '24333', 'Mexico', NULL, NULL, '231-555-6401', NULL, NULL, NULL, 'www.zlbauerconstruction,ltd.com', NULL, NULL, NULL, NULL, '8976 E Leland', 'Camacho', 'Zacatecas', '24333', 'Mexico', 0);
INSERT INTO accounts VALUES ('c0f2ee49-be18-e1a1-9b12-438dfb9b29aa', '2005-11-30 19:20:52', '2005-11-30 19:20:52', '1', 'will_id', '1', 'Bauer-Collins Transportation Group', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '3890 El Camino Drive', 'Spokane', 'WA', '95286', 'USA', NULL, NULL, '942-555-3094', NULL, NULL, NULL, 'www.bauer-collinstransportationgroup.com', NULL, NULL, NULL, NULL, '3890 El Camino Drive', 'Spokane', 'WA', '95286', 'USA', 0);
INSERT INTO accounts VALUES ('23710ff1-e84e-783e-5daa-438dfbc1324c', '2005-11-30 19:20:53', '2005-11-30 19:20:53', '1', 'max_id', '1', 'V & P Smith Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '3422 Meadowvale Court', 'El Cajon', 'CA', '45481', 'USA', NULL, NULL, '269-555-1844', NULL, NULL, NULL, 'www.vpsmithtransportationcorp.com', NULL, NULL, NULL, NULL, '3422 Meadowvale Court', 'El Cajon', 'CA', '45481', 'USA', 0);
INSERT INTO accounts VALUES ('44024f5a-5c41-6d76-f423-438dfb832b76', '2005-11-30 19:20:53', '2005-11-30 19:20:53', '1', 'will_id', '1', 'Smith-Yasi Telecommunications, Inc', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '1245 West Hookston Road', 'San Jose', 'CA', '95838', 'USA', NULL, NULL, '343-555-9823', NULL, NULL, NULL, 'www.smith-yasitelecommunications,inc.com', NULL, NULL, NULL, NULL, '1245 West Hookston Road', 'San Jose', 'CA', '95838', 'USA', 0);
INSERT INTO accounts VALUES ('81f45e11-9a91-753e-cb49-438dfbfd7fd5', '2005-11-30 19:20:53', '2005-11-30 19:20:53', '1', 'matt_id', '1', 'F & X Bowman Communications Partners', NULL, 'Consulting', 'Communications', NULL, NULL, '1032 Buena Vista', 'San Jose', 'CA', '97953', 'USA', NULL, NULL, '593-555-7201', NULL, NULL, NULL, 'www.fxbowmancommunicationspartners.com', NULL, NULL, NULL, NULL, '1032 Buena Vista', 'San Jose', 'CA', '97953', 'USA', 0);
INSERT INTO accounts VALUES ('b7dec629-ebe9-301f-a9fe-438dfbd70e2a', '2005-11-30 19:20:53', '2005-11-30 19:20:53', '1', 'sally_id', '1', 'Bowman-Germanson Communications Holdings', NULL, 'Distribution', 'Communications', NULL, NULL, '6453 Coggins Drive', 'San Jose', 'CA', '88180', 'USA', NULL, NULL, '801-555-7068', NULL, NULL, NULL, 'www.bowman-germansoncommunicationsholdings.com', NULL, NULL, NULL, NULL, '6453 Coggins Drive', 'San Jose', 'CA', '88180', 'USA', 0);
INSERT INTO accounts VALUES ('eed243f1-48d1-3ecd-3487-438dfbc741f0', '2005-11-30 19:20:53', '2005-11-30 19:20:53', '1', 'sarah_id', '1', 'S & X Smith Engineering Partners', NULL, 'Distribution', 'Engineering', NULL, NULL, '9149 San Simeon Drive', 'San Francisco', 'CA', '56456', 'USA', NULL, NULL, '174-555-3075', NULL, NULL, NULL, 'www.sxsmithengineeringpartners.com', NULL, NULL, NULL, NULL, '9149 San Simeon Drive', 'San Francisco', 'CA', '56456', 'USA', 0);
INSERT INTO accounts VALUES ('2a91d192-9acb-1d12-fd0a-438dfb1cb462', '2005-11-30 19:20:54', '2005-11-30 19:20:54', '1', 'sarah_id', '1', 'Smith-Serventi Transportation, Inc', NULL, 'Supply', 'Transportation', NULL, NULL, '7480 Linton Terr', 'Newport Beach', 'CA', '39137', 'USA', NULL, NULL, '532-555-2968', NULL, NULL, NULL, 'www.smith-serventitransportation,inc.com', NULL, NULL, NULL, NULL, '7480 Linton Terr', 'Newport Beach', 'CA', '39137', 'USA', 0);
INSERT INTO accounts VALUES ('60e4ebb5-c76b-436e-9306-438dfbbc3373', '2005-11-30 19:20:54', '2005-11-30 19:20:54', '1', 'sarah_id', '1', 'H & N Chapla Machinery Corp', NULL, 'Supply', 'Machinery', NULL, NULL, '431 Riverside Drive', 'Haney', 'BC', '72574', 'Canada', NULL, NULL, '166-555-1261', NULL, NULL, NULL, 'www.hnchaplamachinerycorp.com', NULL, NULL, NULL, NULL, '431 Riverside Drive', 'Haney', 'BC', '72574', 'Canada', 0);
INSERT INTO accounts VALUES ('9999812c-f78f-cb3a-bdfc-438dfb6a834c', '2005-11-30 19:20:54', '2005-11-30 19:20:54', '1', 'will_id', '1', 'Chapla-Cameron Machinery Associates', NULL, 'Supply', 'Machinery', NULL, NULL, '1673 Buena Vista', 'Victoria', 'BC', '94124', 'Canada', NULL, NULL, '308-555-5125', NULL, NULL, NULL, 'www.chapla-cameronmachineryassociates.com', NULL, NULL, NULL, NULL, '1673 Buena Vista', 'Victoria', 'BC', '94124', 'Canada', 0);
INSERT INTO accounts VALUES ('cfca9f5e-a1b3-1d21-df6a-438dfb36eadf', '2005-11-30 19:20:54', '2005-11-30 19:20:54', '1', 'max_id', '1', 'G & W Zgeirmann Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '4877 Zona Rosa', 'Marysville', 'WA', '93723', 'USA', NULL, NULL, '205-555-5704', NULL, NULL, NULL, 'www.gwzgeirmanntransportation,inc.com', NULL, NULL, NULL, NULL, '4877 Zona Rosa', 'Marysville', 'WA', '93723', 'USA', 0);
INSERT INTO accounts VALUES ('1864a1cc-60b1-c48b-8f71-438dfba9ba59', '2005-11-30 19:20:55', '2005-11-30 19:20:55', '1', 'matt_id', '1', 'Zgeirmann-Mondragon Machinery Corp', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '1061 Delta Fair Blvd.', 'Milwaukie', 'OR', '81434', 'USA', NULL, NULL, '609-555-2854', NULL, NULL, NULL, 'www.zgeirmann-mondragonmachinerycorp.com', NULL, NULL, NULL, NULL, '1061 Delta Fair Blvd.', 'Milwaukie', 'OR', '81434', 'USA', 0);
INSERT INTO accounts VALUES ('4884f8c8-1b4a-ca44-502d-438dfb71f043', '2005-11-30 19:20:55', '2005-11-30 19:20:55', '1', 'beth_id', '1', 'V & B Allison Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '4519 Sequoia Drive', 'Shawnee', 'BC', '47196', 'Canada', NULL, NULL, '289-555-7404', NULL, NULL, NULL, 'www.vballisontransportationholdings.com', NULL, NULL, NULL, NULL, '4519 Sequoia Drive', 'Shawnee', 'BC', '47196', 'Canada', 0);
INSERT INTO accounts VALUES ('7b494b9c-bfe6-5125-3139-438dfb7f4b61', '2005-11-30 19:20:55', '2005-11-30 19:20:55', '1', 'beth_id', '1', 'Allison-Vargas Construction Company', NULL, 'Consulting', 'Construction', NULL, NULL, '8924 Lindley Ct.', 'San Gabriel', 'CA', '10695', 'USA', NULL, NULL, '955-555-6840', NULL, NULL, NULL, 'www.allison-vargasconstructioncompany.com', NULL, NULL, NULL, NULL, '8924 Lindley Ct.', 'San Gabriel', 'CA', '10695', 'USA', 0);
INSERT INTO accounts VALUES ('b26eaa78-b909-c1d6-f477-438dfb12c935', '2005-11-30 19:20:55', '2005-11-30 19:20:55', '1', 'max_id', '1', 'C & A Vlass Engineering Group', NULL, 'Supply', 'Engineering', NULL, NULL, '5293 Juliet Court', 'Glendale', 'CA', '56995', 'USA', NULL, NULL, '897-555-4676', NULL, NULL, NULL, 'www.cavlassengineeringgroup.com', NULL, NULL, NULL, NULL, '5293 Juliet Court', 'Glendale', 'CA', '56995', 'USA', 0);
INSERT INTO accounts VALUES ('304e07d6-fd21-1d2a-d905-438dfb7015ac', '2005-11-30 19:20:56', '2005-11-30 19:20:56', '1', 'kristen_id', '1', 'Vlass-Gonzalez Construction, Ltd', NULL, 'Consulting', 'Construction', NULL, NULL, '7296 Seawind Dr.', 'Burlingame', 'CA', '69533', 'USA', NULL, NULL, '686-555-2740', NULL, NULL, NULL, 'www.vlass-gonzalezconstruction,ltd.com', NULL, NULL, NULL, NULL, '7296 Seawind Dr.', 'Burlingame', 'CA', '69533', 'USA', 0);
INSERT INTO accounts VALUES ('3364987a-77b9-8587-0419-438dfb4161c6', '2005-11-30 19:20:56', '2005-11-30 19:20:56', '1', 'chris_id', '1', 'U & S Ison Transportation, Inc', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '6574 Hemlock Ave.', 'National City', 'CA', '40325', 'USA', NULL, NULL, '651-555-8204', NULL, NULL, NULL, 'www.usisontransportation,inc.com', NULL, NULL, NULL, NULL, '6574 Hemlock Ave.', 'National City', 'CA', '40325', 'USA', 0);
INSERT INTO accounts VALUES ('751f74c6-e766-4a2d-c618-438dfb884964', '2005-11-30 19:20:56', '2005-11-30 19:20:56', '1', 'will_id', '1', 'Ison-Trent Construction Group', NULL, 'Distribution', 'Construction', NULL, NULL, '1488 Cambelback Place', 'Pomona', 'CA', '25521', 'USA', NULL, NULL, '152-555-5472', NULL, NULL, NULL, 'www.ison-trentconstructiongroup.com', NULL, NULL, NULL, NULL, '1488 Cambelback Place', 'Pomona', 'CA', '25521', 'USA', 0);
INSERT INTO accounts VALUES ('a93e924a-538b-1601-ae87-438dfb8fc4a2', '2005-11-30 19:20:56', '2005-11-30 19:20:56', '1', 'sarah_id', '1', 'N & W Vaca Transportation Corp', NULL, 'Distribution', 'Transportation', NULL, NULL, '8364 Pepper Drive', 'N. Vancouver', 'BC', '87766', 'Canada', NULL, NULL, '379-555-4222', NULL, NULL, NULL, 'www.nwvacatransportationcorp.com', NULL, NULL, NULL, NULL, '8364 Pepper Drive', 'N. Vancouver', 'BC', '87766', 'Canada', 0);
INSERT INTO accounts VALUES ('e0737887-c5f3-a1a5-e608-438dfbd3315c', '2005-11-30 19:20:56', '2005-11-30 19:20:56', '1', 'matt_id', '1', 'Vaca-Arbelaez Engineering Partners', NULL, 'Supply', 'Engineering', NULL, NULL, '6187 Barquentine Court', 'Chula Vista', 'CA', '12832', 'USA', NULL, NULL, '453-555-3200', NULL, NULL, NULL, 'www.vaca-arbelaezengineeringpartners.com', NULL, NULL, NULL, NULL, '6187 Barquentine Court', 'Chula Vista', 'CA', '12832', 'USA', 0);
INSERT INTO accounts VALUES ('2374b87b-5ad6-737a-8950-438dfbdc4ec4', '2005-11-30 19:20:57', '2005-11-30 19:20:57', '1', 'sarah_id', '1', 'O & D Lee Communications Associates', NULL, 'Distribution', 'Communications', NULL, NULL, '5974 N St.', 'Lemon Grove', 'CA', '14947', 'USA', NULL, NULL, '703-555-9579', NULL, NULL, NULL, 'www.odleecommunicationsassociates.com', NULL, NULL, NULL, NULL, '5974 N St.', 'Lemon Grove', 'CA', '14947', 'USA', 0);
INSERT INTO accounts VALUES ('622a9551-b8cc-1eb3-5ebb-438dfb0eab51', '2005-11-30 19:20:57', '2005-11-30 19:20:57', '1', 'sally_id', '1', 'Lee-Maes Transportation Company', NULL, 'Consulting', 'Transportation', NULL, NULL, '4051 Athene Drive', 'Tixapan', 'DF', '31465', 'Mexico', NULL, NULL, '799-555-7186', NULL, NULL, NULL, 'www.lee-maestransportationcompany.com', NULL, NULL, NULL, NULL, '4051 Athene Drive', 'Tixapan', 'DF', '31465', 'Mexico', 0);
INSERT INTO accounts VALUES ('9c2c6aa1-824f-f9af-7ecb-438dfb6c1188', '2005-11-30 19:20:57', '2005-11-30 19:20:57', '1', 'sally_id', '1', 'M & Y Antrim Communications, Ltd', NULL, 'Supply', 'Communications', NULL, NULL, '4092 Tupelp Drive', 'Woodburn', 'OR', '98741', 'USA', NULL, NULL, '172-555-3193', NULL, NULL, NULL, 'www.myantrimcommunications,ltd.com', NULL, NULL, NULL, NULL, '4092 Tupelp Drive', 'Woodburn', 'OR', '98741', 'USA', 0);
INSERT INTO accounts VALUES ('cc69d83e-11f0-f3e0-d42d-438dfb68d005', '2005-11-30 19:20:57', '2005-11-30 19:20:57', '1', 'beth_id', '1', 'Antrim-Friedland Communications Associates', NULL, 'Consulting', 'Communications', NULL, NULL, '5079 Notre Dame Avenue', 'Redmond', 'WA', '81421', 'USA', NULL, NULL, '530-555-3086', NULL, NULL, NULL, 'www.antrim-friedlandcommunicationsassociates.com', NULL, NULL, NULL, NULL, '5079 Notre Dame Avenue', 'Redmond', 'WA', '81421', 'USA', 0);
INSERT INTO accounts VALUES ('fff9081b-2d2c-ae3f-faaa-438dfb9df93d', '2005-11-30 19:20:58', '2005-11-30 19:20:58', '1', 'max_id', '1', 'B & D Strange Machinery Partners', NULL, 'Consulting', 'Machinery', NULL, NULL, '5373 Summerfield Dr', 'Orizaba', 'Veracruz', '88567', 'Mexico', NULL, NULL, '164-555-1379', NULL, NULL, NULL, 'www.bdstrangemachinerypartners.com', NULL, NULL, NULL, NULL, '5373 Summerfield Dr', 'Orizaba', 'Veracruz', '88567', 'Mexico', 0);
INSERT INTO accounts VALUES ('4fbfef86-ea7d-b3c8-2a7a-438dfb305253', '2005-11-30 19:20:58', '2005-11-30 19:20:58', '1', 'sarah_id', '1', 'Strange-Richter Construction Partners', NULL, 'Manufacturing', 'Construction', NULL, NULL, '6615 Winterglenn Way', 'Redwood City', 'CA', '37409', 'USA', NULL, NULL, '545-555-8901', NULL, NULL, NULL, 'www.strange-richterconstructionpartners.com', NULL, NULL, NULL, NULL, '6615 Winterglenn Way', 'Redwood City', 'CA', '37409', 'USA', 0);
INSERT INTO accounts VALUES ('8a43b583-3f48-a059-3087-438dfbd5f54f', '2005-11-30 19:20:58', '2005-11-30 19:20:58', '1', 'kristen_id', '1', 'H & E Amland Machinery Group', NULL, 'Supply', 'Machinery', NULL, NULL, '9819 Sunsine Drive', 'Chula Vista', 'CA', '10717', 'USA', NULL, NULL, '203-555-5822', NULL, NULL, NULL, 'www.heamlandmachinerygroup.com', NULL, NULL, NULL, NULL, '9819 Sunsine Drive', 'Chula Vista', 'CA', '10717', 'USA', 0);
INSERT INTO accounts VALUES ('baaaecde-dd04-9723-7b93-438dfba458e3', '2005-11-30 19:20:58', '2005-11-30 19:20:58', '1', 'beth_id', '1', 'Amland-Albury Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '1315 Union St', 'Shawnee', 'BC', '24720', 'Canada', NULL, NULL, '606-555-2972', NULL, NULL, NULL, 'www.amland-alburyelectronicsholdings.com', NULL, NULL, NULL, NULL, '1315 Union St', 'Shawnee', 'BC', '24720', 'Canada', 0);
INSERT INTO accounts VALUES ('f30c7cf7-c0c7-0ddb-9e80-438dfbd3a059', '2005-11-30 19:20:58', '2005-11-30 19:20:58', '1', 'max_id', '1', 'X & M Richmeier Construction Corp', NULL, 'Manufacturing', 'Construction', NULL, NULL, '7429 La Cadena', 'Milwaukie', 'OR', '63188', 'USA', NULL, NULL, '526-555-2179', NULL, NULL, NULL, 'www.xmrichmeierconstructioncorp.com', NULL, NULL, NULL, NULL, '7429 La Cadena', 'Milwaukie', 'OR', '63188', 'USA', 0);
INSERT INTO accounts VALUES ('504421d1-6b83-2d46-28f1-438dfb176619', '2005-11-30 19:20:59', '2005-11-30 19:20:59', '1', 'sally_id', '1', 'Richmeier-Jacobson Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '9178 Thornhill Place', 'Westminster', 'BC', '17061', 'Canada', NULL, NULL, '165-555-9217', NULL, NULL, NULL, 'www.richmeier-jacobsontelecommunications,ltd.com', NULL, NULL, NULL, NULL, '9178 Thornhill Place', 'Westminster', 'BC', '17061', 'Canada', 0);
INSERT INTO accounts VALUES ('849ff02a-a41e-a831-1c4a-438dfb9ac9c5', '2005-11-30 19:20:59', '2005-11-30 19:20:59', '1', 'chris_id', '1', 'I & M Bartness Transportation, Ltd', NULL, 'Supply', 'Transportation', NULL, NULL, '5547 Montoya', 'Tixapan', 'DF', '47984', 'Mexico', NULL, NULL, '107-555-7053', NULL, NULL, NULL, 'www.imbartnesstransportation,ltd.com', NULL, NULL, NULL, NULL, '5547 Montoya', 'Tixapan', 'DF', '47984', 'Mexico', 0);
INSERT INTO accounts VALUES ('c6407d2b-037b-c156-ea7a-438dfba2d249', '2005-11-30 19:20:59', '2005-11-30 19:20:59', '1', 'will_id', '1', 'Bartness-Cobb Electronics Corp', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '206 Kirkwood Ct.', 'Grossmont', 'CA', '67018', 'USA', NULL, NULL, '796-555-5117', NULL, NULL, NULL, 'www.bartness-cobbelectronicscorp.com', NULL, NULL, NULL, NULL, '206 Kirkwood Ct.', 'Grossmont', 'CA', '67018', 'USA', 0);
INSERT INTO accounts VALUES ('36a40b1b-cb67-ceb4-0533-438dfb7d0963', '2005-11-30 19:21:00', '2005-11-30 19:21:00', '1', 'kristen_id', '1', 'H & Y Lique Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '6828 Ashwood Drive', 'Richmond', 'BC', '38225', 'Canada', NULL, NULL, '761-555-1582', NULL, NULL, NULL, 'www.hyliqueengineering,inc.com', NULL, NULL, NULL, NULL, '6828 Ashwood Drive', 'Richmond', 'BC', '38225', 'Canada', 0);
INSERT INTO accounts VALUES ('45a5a513-0d9b-aadb-5c29-438dfb1fdc19', '2005-11-30 19:21:00', '2005-11-30 19:21:00', '1', 'jaime_id', '1', 'Lique-Bernacchi Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '1742 Shakespeare Drive', 'Albany', 'OR', '23421', 'USA', NULL, NULL, '811-555-1932', NULL, NULL, NULL, 'www.lique-bernacchitelecommunications,ltd.com', NULL, NULL, NULL, NULL, '1742 Shakespeare Drive', 'Albany', 'OR', '23421', 'USA', 0);
INSERT INTO accounts VALUES ('80a8a566-3f2a-194b-646c-438dfbc93925', '2005-11-30 19:21:00', '2005-11-30 19:21:00', '1', 'sally_id', '1', 'D & A Zubaty Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '1274 Frisbie Ct.', 'Anacortes', 'WA', '59374', 'USA', NULL, NULL, '799-555-6024', NULL, NULL, NULL, 'www.dazubatymachinerygroup.com', NULL, NULL, NULL, NULL, '1274 Frisbie Ct.', 'Anacortes', 'WA', '59374', 'USA', 0);
INSERT INTO accounts VALUES ('ca42a368-c80b-7cca-5596-438dfb51d67e', '2005-11-30 19:21:00', '2005-11-30 19:21:00', '1', 'max_id', '1', 'Zubaty-Hunter Construction Associates', NULL, 'Consulting', 'Construction', NULL, NULL, '6441 Roberta Avenue', 'Salem', 'OR', '10732', 'USA', NULL, NULL, '872-555-5003', NULL, NULL, NULL, 'www.zubaty-hunterconstructionassociates.com', NULL, NULL, NULL, NULL, '6441 Roberta Avenue', 'Salem', 'OR', '10732', 'USA', 0);
INSERT INTO accounts VALUES ('ebf1026b-33e5-900d-f7b2-438dfb8a68cd', '2005-11-30 19:21:01', '2005-11-30 19:21:01', '1', 'max_id', '1', 'D & Z Vonholt Electronics, Ltd', NULL, 'Consulting', 'Electronics', NULL, NULL, '6228 Palm Avenue', 'Langford', 'BC', '12847', 'Canada', NULL, NULL, '222-555-2382', NULL, NULL, NULL, 'www.dzvonholtelectronics,ltd.com', NULL, NULL, NULL, NULL, '6228 Palm Avenue', 'Langford', 'BC', '12847', 'Canada', 0);
INSERT INTO accounts VALUES ('3efe2b3e-0a4a-c3fe-aef8-438dfbad5ee3', '2005-11-30 19:21:01', '2005-11-30 19:21:01', '1', 'kristen_id', '1', 'Vonholt-Holmes Engineering Corp', NULL, 'Consulting', 'Engineering', NULL, NULL, '4305 Madrid', 'National City', 'CA', '29365', 'USA', NULL, NULL, '319-555-8989', NULL, NULL, NULL, 'www.vonholt-holmesengineeringcorp.com', NULL, NULL, NULL, NULL, '4305 Madrid', 'National City', 'CA', '29365', 'USA', 0);
INSERT INTO accounts VALUES ('838163c6-4c13-957a-1afb-438dfb2ca106', '2005-11-30 19:21:01', '2005-11-30 19:21:01', '1', 'will_id', '1', 'Q & Q Drury Telecommunications Associates', NULL, 'Supply', 'Telecommunications', NULL, NULL, '7001 Mills Dr.', 'Arcadia', 'CA', '96641', 'USA', NULL, NULL, '830-555-8653', NULL, NULL, NULL, 'www.qqdrurytelecommunicationsassociates.com', NULL, NULL, NULL, NULL, '7001 Mills Dr.', 'Arcadia', 'CA', '96641', 'USA', 0);
INSERT INTO accounts VALUES ('c5459906-c7f9-27ca-7cde-438dfb77de9a', '2005-11-30 19:21:01', '2005-11-30 19:21:01', '1', 'max_id', '1', 'Drury-Watts Engineering Company', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '5333 Adria Drive', 'San Francisco', 'CA', '53029', 'USA', NULL, NULL, '949-555-4889', NULL, NULL, NULL, 'www.drury-wattsengineeringcompany.com', NULL, NULL, NULL, NULL, '5333 Adria Drive', 'San Francisco', 'CA', '53029', 'USA', 0);
INSERT INTO accounts VALUES ('a0b7065e-075b-3b0f-c2bc-438dfb008e30', '2005-11-30 19:21:02', '2005-11-30 19:21:02', '1', 'matt_id', '1', 'Y & R Short Machinery, Inc', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '9529 Oonegal Court', 'Richmond', 'CA', '86467', 'USA', NULL, NULL, '584-555-3182', NULL, NULL, NULL, 'www.yrshortmachinery,inc.com', NULL, NULL, NULL, NULL, '9529 Oonegal Court', 'Richmond', 'CA', '86467', 'USA', 0);
INSERT INTO accounts VALUES ('5e74135e-b955-5ffd-8f0c-438dfbe44b00', '2005-11-30 19:21:02', '2005-11-30 19:21:02', '1', 'sarah_id', '1', 'Short-Mc Guigan Engineering, Inc', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '8115 Royal Links Ct', 'Lakewood', 'CA', '90175', 'USA', NULL, NULL, '965-555-1703', NULL, NULL, NULL, 'www.short-mcguiganengineering,inc.com', NULL, NULL, NULL, NULL, '8115 Royal Links Ct', 'Lakewood', 'CA', '90175', 'USA', 0);
INSERT INTO accounts VALUES ('9a12f641-08dd-f9b2-2def-438dfb694df6', '2005-11-30 19:21:02', '2005-11-30 19:21:02', '1', 'kristen_id', '1', 'E & F Wollesen Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '1320 Pacheco St', 'W. Linn', 'OR', '86173', 'USA', NULL, NULL, '976-555-4463', NULL, NULL, NULL, 'www.efwollesenmachinery,ltd.com', NULL, NULL, NULL, NULL, '1320 Pacheco St', 'W. Linn', 'OR', '86173', 'USA', 0);
INSERT INTO accounts VALUES ('dc83dcc0-d01b-8c04-b643-438dfb9f335e', '2005-11-30 19:21:02', '2005-11-30 19:21:02', '1', 'chris_id', '1', 'Wollesen-Lee Transportation Holdings', NULL, 'Distribution', 'Transportation', NULL, NULL, '2815 Piper Ridge Court', 'Altadena', 'CA', '95327', 'USA', NULL, NULL, '480-555-1613', NULL, NULL, NULL, 'www.wollesen-leetransportationholdings.com', NULL, NULL, NULL, NULL, '2815 Piper Ridge Court', 'Altadena', 'CA', '95327', 'USA', 0);
INSERT INTO accounts VALUES ('340cc499-cd7d-5941-40ff-438dfb26c7a9', '2005-11-30 19:21:03', '2005-11-30 19:21:03', '1', 'will_id', '1', 'N & O Gimmi Electronics, Inc', NULL, 'Supply', 'Electronics', NULL, NULL, '8929 Dayton Court', 'Yakima', 'WA', '61088', 'USA', NULL, NULL, '400-555-9820', NULL, NULL, NULL, 'www.nogimmielectronics,inc.com', NULL, NULL, NULL, NULL, '8929 Dayton Court', 'Yakima', 'WA', '61088', 'USA', 0);
INSERT INTO accounts VALUES ('70cfedfa-30fa-5e8d-9c2e-438dfb7dccac', '2005-11-30 19:21:03', '2005-11-30 19:21:03', '1', 'kristen_id', '1', 'Gimmi-Pugh Machinery Group', NULL, 'Distribution', 'Machinery', NULL, NULL, '679 Pepperidge Way', 'Berkeley', 'CA', '14962', 'USA', NULL, NULL, '826-555-5598', NULL, NULL, NULL, 'www.gimmi-pughmachinerygroup.com', NULL, NULL, NULL, NULL, '679 Pepperidge Way', 'Berkeley', 'CA', '14962', 'USA', 0);
INSERT INTO accounts VALUES ('a0cea6f1-a86f-cfcd-4a58-438dfbb32474', '2005-11-30 19:21:03', '2005-11-30 19:21:03', '1', 'beth_id', '1', 'U & W Bennetts Construction Corp', NULL, 'Supply', 'Construction', NULL, NULL, '7047 Terra Granda', 'San Jose', 'CA', '19592', 'USA', NULL, NULL, '768-555-3434', NULL, NULL, NULL, 'www.uwbennettsconstructioncorp.com', NULL, NULL, NULL, NULL, '7047 Terra Granda', 'San Jose', 'CA', '19592', 'USA', 0);
INSERT INTO accounts VALUES ('e42c1718-a0c6-c10a-160f-438dfbe77501', '2005-11-30 19:21:03', '2005-11-30 19:21:03', '1', 'max_id', '1', 'Bennetts-Woodard Electronics Company', NULL, 'Consulting', 'Electronics', NULL, NULL, '1707 Willowwood Ct.', 'Torrance', 'CA', '38626', 'USA', NULL, NULL, '557-555-1499', NULL, NULL, NULL, 'www.bennetts-woodardelectronicscompany.com', NULL, NULL, NULL, NULL, '1707 Willowwood Ct.', 'Torrance', 'CA', '38626', 'USA', 0);
INSERT INTO accounts VALUES ('20292e58-c2b9-29de-299f-438dfb4dc874', '2005-11-30 19:21:04', '2005-11-30 19:21:04', '1', 'chris_id', '1', 'M & K Manzanares Telecommunications, Ltd', NULL, 'Supply', 'Telecommunications', NULL, NULL, '8328 San Francisco', 'Portland', 'OR', '35710', 'USA', NULL, NULL, '522-555-6963', NULL, NULL, NULL, 'www.mkmanzanarestelecommunications,ltd.com', NULL, NULL, NULL, NULL, '8328 San Francisco', 'Portland', 'OR', '35710', 'USA', 0);
INSERT INTO accounts VALUES ('70266a53-82a3-acff-f7db-438dfb24a59f', '2005-11-30 19:21:04', '2005-11-30 19:21:04', '1', 'sarah_id', '1', 'Manzanares-Stotler Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '5898 Mt. Dell', 'Marysville', 'WA', '90383', 'USA', NULL, NULL, '573-555-7313', NULL, NULL, NULL, 'www.manzanares-stotlermachinery,ltd.com', NULL, NULL, NULL, NULL, '5898 Mt. Dell', 'Marysville', 'WA', '90383', 'USA', 0);
INSERT INTO accounts VALUES ('a9f8b729-dd46-fa62-6e96-438dfb37f4cb', '2005-11-30 19:21:04', '2005-11-30 19:21:04', '1', 'beth_id', '1', 'L & E Peoples Communications Partners', NULL, 'Distribution', 'Communications', NULL, NULL, '2775 Bonifacio Street', 'La Mesa', 'CA', '27337', 'USA', NULL, NULL, '561-555-2406', NULL, NULL, NULL, 'www.lepeoplescommunicationspartners.com', NULL, NULL, NULL, NULL, '2775 Bonifacio Street', 'La Mesa', 'CA', '27337', 'USA', 0);
INSERT INTO accounts VALUES ('e4773e57-f838-8bf1-f04a-438dfbc86a47', '2005-11-30 19:21:04', '2005-11-30 19:21:04', '1', 'sally_id', '1', 'Peoples-Choi Construction Holdings', NULL, 'Consulting', 'Construction', NULL, NULL, '598 Marfargoa Drive', 'Fremont', 'CA', '77694', 'USA', NULL, NULL, '634-555-1384', NULL, NULL, NULL, 'www.peoples-choiconstructionholdings.com', NULL, NULL, NULL, NULL, '598 Marfargoa Drive', 'Fremont', 'CA', '77694', 'USA', 0);
INSERT INTO accounts VALUES ('2a41280f-1e6d-838e-c46f-438dfbb2e0d6', '2005-11-30 19:21:05', '2005-11-30 19:21:05', '1', 'kristen_id', '1', 'W & N Quintana Telecommunications Partners', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '385 Joan Ave', 'Fremont', 'CA', '79809', 'USA', NULL, NULL, '884-555-7763', NULL, NULL, NULL, 'www.wnquintanatelecommunicationspartners.com', NULL, NULL, NULL, NULL, '385 Joan Ave', 'Fremont', 'CA', '79809', 'USA', 0);
INSERT INTO accounts VALUES ('71fc22f1-cb94-037b-8b25-438dfba9f9e3', '2005-11-30 19:21:05', '2005-11-30 19:21:05', '1', 'sally_id', '1', 'Quintana-Bright Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '8461 Lodge Drive', 'Issaquah', 'WA', '70035', 'USA', NULL, NULL, '980-555-5370', NULL, NULL, NULL, 'www.quintana-brighttransportationholdings.com', NULL, NULL, NULL, NULL, '8461 Lodge Drive', 'Issaquah', 'WA', '70035', 'USA', 0);
INSERT INTO accounts VALUES ('c082f0d9-9511-ddc3-a24f-438dfbe61104', '2005-11-30 19:21:05', '2005-11-30 19:21:05', '1', 'beth_id', '1', 'V & A Rodgers Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '8502 Bates Court', 'Hidalgo', 'Zacatecas', '38312', 'Mexico', NULL, NULL, '943-555-1952', NULL, NULL, NULL, 'www.varodgerstransportationcorp.com', NULL, NULL, NULL, NULL, '8502 Bates Court', 'Hidalgo', 'Zacatecas', '38312', 'Mexico', 0);
INSERT INTO accounts VALUES ('10c132e5-9074-b5c9-335c-438dfbfba202', '2005-11-30 19:21:06', '2005-11-30 19:21:06', '1', 'max_id', '1', 'Rodgers-Gates Communications Corp', NULL, 'Consulting', 'Communications', NULL, NULL, '6833 Filomena', 'Edmonds', 'WA', '20992', 'USA', NULL, NULL, '162-555-7187', NULL, NULL, NULL, 'www.rodgers-gatescommunicationscorp.com', NULL, NULL, NULL, NULL, '6833 Filomena', 'Edmonds', 'WA', '20992', 'USA', 0);
INSERT INTO accounts VALUES ('6006ab36-84f7-f994-0326-438dfbce1f60', '2005-11-30 19:21:06', '2005-11-30 19:21:06', '1', 'sally_id', '1', 'T & A Watkins Electronics, Inc', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '9783 Amaranth Way', 'Walla Walla', 'WA', '54430', 'USA', NULL, NULL, '697-555-5480', NULL, NULL, NULL, 'www.tawatkinselectronics,inc.com', NULL, NULL, NULL, NULL, '9783 Amaranth Way', 'Walla Walla', 'WA', '54430', 'USA', 0);
INSERT INTO accounts VALUES ('9d1f300c-ec5a-6b7f-640f-438dfbca0fd9', '2005-11-30 19:21:06', '2005-11-30 19:21:06', '1', 'matt_id', '1', 'Watkins-Christensen Construction Associates', NULL, 'Manufacturing', 'Construction', NULL, NULL, '1025 Holly Oak Drive', 'Santa Fe', 'DF', '75979', 'Mexico', NULL, NULL, '178-555-4002', NULL, NULL, NULL, 'www.watkins-christensenconstructionassociates.com', NULL, NULL, NULL, NULL, '1025 Holly Oak Drive', 'Santa Fe', 'DF', '75979', 'Mexico', 0);
INSERT INTO accounts VALUES ('e25563d8-e9ae-59c1-b16d-438dfb5bac3d', '2005-11-30 19:21:06', '2005-11-30 19:21:06', '1', 'chris_id', '1', 'D & D Banks Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '4230 Falcon Place', 'San Andres', 'DF', '75579', 'Mexico', NULL, NULL, '735-555-9923', NULL, NULL, NULL, 'www.ddbankselectronicsholdings.com', NULL, NULL, NULL, NULL, '4230 Falcon Place', 'San Andres', 'DF', '75579', 'Mexico', 0);
INSERT INTO accounts VALUES ('1e5d7290-9444-62ce-93c4-438dfbebbee8', '2005-11-30 19:21:07', '2005-11-30 19:21:07', '1', 'sarah_id', '1', 'Banks-Carlisle Machinery, Inc', NULL, 'Distribution', 'Machinery', NULL, NULL, '5725 Glazier Drive', 'Yakima', 'WA', '63290', 'USA', NULL, NULL, '239-555-7073', NULL, NULL, NULL, 'www.banks-carlislemachinery,inc.com', NULL, NULL, NULL, NULL, '5725 Glazier Drive', 'Yakima', 'WA', '63290', 'USA', 0);
INSERT INTO accounts VALUES ('59596161-ecce-4e01-e4c0-438dfb4ff125', '2005-11-30 19:21:07', '2005-11-30 19:21:07', '1', 'sally_id', '1', 'I & V Tramel Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '9183 Via Del Sol', 'Issaquah', 'WA', '27592', 'USA', NULL, NULL, '158-555-6280', NULL, NULL, NULL, 'www.ivtramelengineering,inc.com', NULL, NULL, NULL, NULL, '9183 Via Del Sol', 'Issaquah', 'WA', '27592', 'USA', 0);
INSERT INTO accounts VALUES ('96e57544-3ad1-9a36-ef96-438dfbec0b11', '2005-11-30 19:21:07', '2005-11-30 19:21:07', '1', 'beth_id', '1', 'Tramel-Curry Construction, Ltd', NULL, 'Manufacturing', 'Construction', NULL, NULL, '3589 G Street', 'Bremerton', 'WA', '81923', 'USA', NULL, NULL, '585-555-2059', NULL, NULL, NULL, 'www.tramel-curryconstruction,ltd.com', NULL, NULL, NULL, NULL, '3589 G Street', 'Bremerton', 'WA', '81923', 'USA', 0);
INSERT INTO accounts VALUES ('dd3d85cb-9c27-8d9d-8db5-438dfb85537a', '2005-11-30 19:21:07', '2005-11-30 19:21:07', '1', 'matt_id', '1', 'K & R Haines Communications Group', NULL, 'Consulting', 'Communications', NULL, NULL, '9956 McNeil Place', 'Bellingham', 'WA', '86554', 'USA', NULL, NULL, '527-555-8894', NULL, NULL, NULL, 'www.krhainescommunicationsgroup.com', NULL, NULL, NULL, NULL, '9956 McNeil Place', 'Bellingham', 'WA', '86554', 'USA', 0);
INSERT INTO accounts VALUES ('2eeaa483-0194-67e8-5bdd-438dfbb60ccb', '2005-11-30 19:21:08', '2005-11-30 19:21:08', '1', 'jaime_id', '1', 'Haines-Campbell Engineering Associates', NULL, 'Distribution', 'Engineering', NULL, NULL, '1961 Oak Grove Road', 'Beaverton', 'OR', '65893', 'USA', NULL, NULL, '316-555-6959', NULL, NULL, NULL, 'www.haines-campbellengineeringassociates.com', NULL, NULL, NULL, NULL, '1961 Oak Grove Road', 'Beaverton', 'OR', '65893', 'USA', 0);
INSERT INTO accounts VALUES ('5f0d7f18-38a2-12a5-4db4-438dfbfbd6eb', '2005-11-30 19:21:08', '2005-11-30 19:21:08', '1', 'max_id', '1', 'B & P Whitney Telecommunications Holdings', NULL, 'Distribution', 'Telecommunications', NULL, NULL, '1239 Linnet Court', 'La Jolla', 'CA', '76380', 'USA', NULL, NULL, '520-555-7080', NULL, NULL, NULL, 'www.bpwhitneytelecommunicationsholdings.com', NULL, NULL, NULL, NULL, '1239 Linnet Court', 'La Jolla', 'CA', '76380', 'USA', 0);
INSERT INTO accounts VALUES ('9d8bc0c6-b3c1-e81d-f394-438dfb41fcd4', '2005-11-30 19:21:08', '2005-11-30 19:21:08', '1', 'kristen_id', '1', 'Whitney-Mitchell Electronics, Ltd', NULL, 'Distribution', 'Electronics', NULL, NULL, '6152 Del Mar Ave', 'Imperial Beach', 'CA', '61576', 'USA', NULL, NULL, '331-555-3773', NULL, NULL, NULL, 'www.whitney-mitchellelectronics,ltd.com', NULL, NULL, NULL, NULL, '6152 Del Mar Ave', 'Imperial Beach', 'CA', '61576', 'USA', 0);
INSERT INTO accounts VALUES ('e488e549-954c-86df-9e80-438dfb10a6fa', '2005-11-30 19:21:08', '2005-11-30 19:21:08', '1', 'chris_id', '1', 'Q & P Dodd Telecommunications Company', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, '5684 San Marino Ct.', 'Burnaby', 'BC', '96204', 'Canada', NULL, NULL, '910-555-8441', NULL, NULL, NULL, 'www.qpdoddtelecommunicationscompany.com', NULL, NULL, NULL, NULL, '5684 San Marino Ct.', 'Burnaby', 'BC', '96204', 'Canada', 0);
INSERT INTO accounts VALUES ('20b432f7-cf4d-dd8d-0341-438dfbd532ba', '2005-11-30 19:21:09', '2005-11-30 19:21:09', '1', 'beth_id', '1', 'Dodd-Cereghino Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '852 Santa Maria', 'Coronado', 'CA', '47561', 'USA', NULL, NULL, '744-555-3762', NULL, NULL, NULL, 'www.dodd-cereghinotransportationholdings.com', NULL, NULL, NULL, NULL, '852 Santa Maria', 'Coronado', 'CA', '47561', 'USA', 0);
INSERT INTO accounts VALUES ('5c4866c0-bccc-d7c9-6ac5-438dfbc9d570', '2005-11-30 19:21:09', '2005-11-30 19:21:09', '1', 'kristen_id', '1', 'G & N Meyer Communications Group', NULL, 'Supply', 'Communications', NULL, NULL, '639 Bermad Drive', 'San Diego', 'CA', '49676', 'USA', NULL, NULL, '994-555-1140', NULL, NULL, NULL, 'www.gnmeyercommunicationsgroup.com', NULL, NULL, NULL, NULL, '639 Bermad Drive', 'San Diego', 'CA', '49676', 'USA', 0);
INSERT INTO accounts VALUES ('9aadf826-537d-c6b7-e7fe-438dfba9881c', '2005-11-30 19:21:09', '2005-11-30 19:21:09', '1', 'kristen_id', '1', 'Meyer-Stevens Construction Partners', NULL, 'Distribution', 'Construction', NULL, NULL, '4650 Carlos Dr.', 'Langford', 'BC', '66195', 'Canada', NULL, NULL, '190-555-7747', NULL, NULL, NULL, 'www.meyer-stevensconstructionpartners.com', NULL, NULL, NULL, NULL, '4650 Carlos Dr.', 'Langford', 'BC', '66195', 'Canada', 0);
INSERT INTO accounts VALUES ('caa4c6ab-ab71-ffb2-ac83-438dfb3457da', '2005-11-30 19:21:09', '2005-11-30 19:21:09', '1', 'kristen_id', '1', 'H & Y Campbell Electronics, Ltd', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '4691 Frisbie Court', 'Berkeley', 'CA', '34472', 'USA', NULL, NULL, '702-555-7412', NULL, NULL, NULL, 'www.hycampbellelectronics,ltd.com', NULL, NULL, NULL, NULL, '4691 Frisbie Court', 'Berkeley', 'CA', '34472', 'USA', 0);
INSERT INTO accounts VALUES ('1d98d9e0-4058-aede-3d44-438dfb44af49', '2005-11-30 19:21:10', '2005-11-30 19:21:10', '1', 'chris_id', '1', 'Campbell-Walker Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '5678 Arlington Way', 'Imperial Beach', 'CA', '89859', 'USA', NULL, NULL, '821-555-3648', NULL, NULL, NULL, 'www.campbell-walkertransportationholdings.com', NULL, NULL, NULL, NULL, '5678 Arlington Way', 'Imperial Beach', 'CA', '89859', 'USA', 0);
INSERT INTO accounts VALUES ('736eaf1d-739b-8fbe-46dc-438dfba914ad', '2005-11-30 19:21:10', '2005-11-30 19:21:10', '1', 'sarah_id', '1', 'O & K Pasumansky Transportation Corp', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '5972 El Pintado Road', 'Redmond', 'WA', '24298', 'USA', NULL, NULL, '456-555-1940', NULL, NULL, NULL, 'www.okpasumanskytransportationcorp.com', NULL, NULL, NULL, NULL, '5972 El Pintado Road', 'Redmond', 'WA', '24298', 'USA', 0);
INSERT INTO accounts VALUES ('a3a0858e-b3f3-2557-b597-438dfbf596b3', '2005-11-30 19:21:10', '2005-11-30 19:21:10', '1', 'beth_id', '1', 'Pasumansky-Whitney Construction Partners', NULL, 'Consulting', 'Construction', NULL, NULL, '7214 Peachwillow', 'Santa Cruz', 'CA', '72139', 'USA', NULL, NULL, '836-555-9462', NULL, NULL, NULL, 'www.pasumansky-whitneyconstructionpartners.com', NULL, NULL, NULL, NULL, '7214 Peachwillow', 'Santa Cruz', 'CA', '72139', 'USA', 0);
INSERT INTO accounts VALUES ('dfcc7856-219e-f4ee-968c-438dfb5374f7', '2005-11-30 19:21:10', '2005-11-30 19:21:10', '1', 'sally_id', '1', 'D & D Saunders Transportation, Ltd', NULL, 'Distribution', 'Transportation', NULL, NULL, '419 Mills Dr.', 'Coronado', 'CA', '45447', 'USA', NULL, NULL, '494-555-6383', NULL, NULL, NULL, 'www.ddsaunderstransportation,ltd.com', NULL, NULL, NULL, NULL, '419 Mills Dr.', 'Coronado', 'CA', '45447', 'USA', 0);
INSERT INTO accounts VALUES ('4d4fb109-a147-164a-7078-438dfb21dc20', '2005-11-30 19:21:11', '2005-11-30 19:21:11', '1', 'kristen_id', '1', 'Saunders-Vandenouer Machinery, Inc', NULL, 'Consulting', 'Machinery', NULL, NULL, '1914 N Lucile Lane', 'Royal Oak', 'BC', '59450', 'Canada', NULL, NULL, '898-555-3533', NULL, NULL, NULL, 'www.saunders-vandenouermachinery,inc.com', NULL, NULL, NULL, NULL, '1914 N Lucile Lane', 'Royal Oak', 'BC', '59450', 'Canada', 0);
INSERT INTO accounts VALUES ('82991196-40ca-6cef-1cac-438dfb08f497', '2005-11-30 19:21:11', '2005-11-30 19:21:11', '1', 'beth_id', '1', 'E & M Vincenzi Electronics Company', NULL, 'Supply', 'Electronics', NULL, NULL, '8028 39th Avenue', 'Daly City', 'CA', '97918', 'USA', NULL, NULL, '817-555-2740', NULL, NULL, NULL, 'www.emvincenzielectronicscompany.com', NULL, NULL, NULL, NULL, '8028 39th Avenue', 'Daly City', 'CA', '97918', 'USA', 0);
INSERT INTO accounts VALUES ('bffce1e9-399b-b344-74da-438dfb464f30', '2005-11-30 19:21:11', '2005-11-30 19:21:11', '1', 'matt_id', '1', 'Vincenzi-Herring Engineering, Ltd', NULL, 'Distribution', 'Engineering', NULL, NULL, '9777 Mozden Lane', 'Puyallup', 'WA', '51791', 'USA', NULL, NULL, '344-555-7519', NULL, NULL, NULL, 'www.vincenzi-herringengineering,ltd.com', NULL, NULL, NULL, NULL, '9777 Mozden Lane', 'Puyallup', 'WA', '51791', 'USA', 0);
INSERT INTO accounts VALUES ('98860e21-aa2a-ef96-d003-438dfb2d8436', '2005-11-30 19:21:12', '2005-11-30 19:21:12', '1', 'matt_id', '1', 'R & Z Garza Communications, Inc', NULL, 'Distribution', 'Communications', NULL, NULL, '6146 Schenone Court', 'Yakima', 'WA', '82714', 'USA', NULL, NULL, '286-555-5355', NULL, NULL, NULL, 'www.rzgarzacommunications,inc.com', NULL, NULL, NULL, NULL, '6146 Schenone Court', 'Yakima', 'WA', '82714', 'USA', 0);
INSERT INTO accounts VALUES ('3b36216f-a3db-a148-b194-438dfbe17840', '2005-11-30 19:21:12', '2005-11-30 19:21:12', '1', 'chris_id', '1', 'Garza-Westover Machinery Partners', NULL, 'Supply', 'Machinery', NULL, NULL, '805 Willow Lane', 'Palo Alto', 'CA', '2748', 'USA', NULL, NULL, '426-555-9336', NULL, NULL, NULL, 'www.garza-westovermachinerypartners.com', NULL, NULL, NULL, NULL, '805 Willow Lane', 'Palo Alto', 'CA', '2748', 'USA', 0);
INSERT INTO accounts VALUES ('7b28da71-732a-623c-77fa-438dfbe91aa6', '2005-11-30 19:21:12', '2005-11-30 19:21:12', '1', 'sarah_id', '1', 'J & K Hagemann Communications Corp', NULL, 'Supply', 'Communications', NULL, NULL, '7427 Terra Catalina', 'Victoria', 'BC', '72540', 'Canada', NULL, NULL, '630-555-9458', NULL, NULL, NULL, 'www.jkhagemanncommunicationscorp.com', NULL, NULL, NULL, NULL, '7427 Terra Catalina', 'Victoria', 'BC', '72540', 'Canada', 0);
INSERT INTO accounts VALUES ('ab43ac14-4019-51f9-3490-438dfb6e12de', '2005-11-30 19:21:12', '2005-11-30 19:21:12', '1', 'sally_id', '1', 'Hagemann-Vasquez Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '2341 Lindley Ct', 'Beaverton', 'OR', '57735', 'USA', NULL, NULL, '441-555-6151', NULL, NULL, NULL, 'www.hagemann-vasquezconstruction,ltd.com', NULL, NULL, NULL, NULL, '2341 Lindley Ct', 'Beaverton', 'OR', '57735', 'USA', 0);
INSERT INTO accounts VALUES ('db489ef6-f6ae-6e3b-3b6e-438dfb73fda3', '2005-11-30 19:21:12', '2005-11-30 19:21:12', '1', 'max_id', '1', 'W & W McCarthy Electronics Associates', NULL, 'Supply', 'Electronics', NULL, NULL, '1874 Royal Links Circle', 'Cliffside', 'BC', '93688', 'Canada', NULL, NULL, '668-555-4901', NULL, NULL, NULL, 'www.wwmccarthyelectronicsassociates.com', NULL, NULL, NULL, NULL, '1874 Royal Links Circle', 'Cliffside', 'BC', '93688', 'Canada', 0);
INSERT INTO accounts VALUES ('30921930-dd76-d74b-03d3-438dfbf185c3', '2005-11-30 19:21:13', '2005-11-30 19:21:13', '1', 'max_id', '1', 'McCarthy-Bacalzo Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '7040 Isabel Dr.', 'Beverly Hills', 'CA', '89846', 'USA', NULL, NULL, '503-555-9222', NULL, NULL, NULL, 'www.mccarthy-bacalzomachinerygroup.com', NULL, NULL, NULL, NULL, '7040 Isabel Dr.', 'Beverly Hills', 'CA', '89846', 'USA', 0);
INSERT INTO accounts VALUES ('70b79b91-4836-3308-36aa-438dfbae2531', '2005-11-30 19:21:13', '2005-11-30 19:21:13', '1', 'beth_id', '1', 'D & G Berch Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '6827 Glazier Dr.', 'Seattle', 'WA', '91961', 'USA', NULL, NULL, '753-555-6601', NULL, NULL, NULL, 'www.dgberchtransportation,inc.com', NULL, NULL, NULL, NULL, '6827 Glazier Dr.', 'Seattle', 'WA', '91961', 'USA', 0);
INSERT INTO accounts VALUES ('a1390532-2bad-f7be-a025-438dfbc3db6b', '2005-11-30 19:21:13', '2005-11-30 19:21:13', '1', 'matt_id', '1', 'Berch-Taylor Engineering, Ltd', NULL, 'Supply', 'Engineering', NULL, NULL, '4904 Hillview Drive', 'La Jolla', 'CA', '94813', 'USA', NULL, NULL, '188-555-7865', NULL, NULL, NULL, 'www.berch-taylorengineering,ltd.com', NULL, NULL, NULL, NULL, '4904 Hillview Drive', 'La Jolla', 'CA', '94813', 'USA', 0);
INSERT INTO accounts VALUES ('d18b839f-0374-3a4d-c8ae-438dfbcca296', '2005-11-30 19:21:13', '2005-11-30 19:21:13', '1', 'jaime_id', '1', 'Z & L Whipple Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '7600 Yosemite Circle', 'Lynnwood', 'WA', '50464', 'USA', NULL, NULL, '461-555-3872', NULL, NULL, NULL, 'www.zlwhippleconstruction,ltd.com', NULL, NULL, NULL, NULL, '7600 Yosemite Circle', 'Lynnwood', 'WA', '50464', 'USA', 0);
INSERT INTO accounts VALUES ('1acbfe30-7ed3-8742-d41e-438dfb7fffd7', '2005-11-30 19:21:14', '2005-11-30 19:21:14', '1', 'will_id', '1', 'Whipple-Laursen Transportation Group', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '5932 Rainier Dr.', 'Hidalgo', 'Zacatecas', '33145', 'Mexico', NULL, NULL, '580-555-9108', NULL, NULL, NULL, 'www.whipple-laursentransportationgroup.com', NULL, NULL, NULL, NULL, '5932 Rainier Dr.', 'Hidalgo', 'Zacatecas', '33145', 'Mexico', 0);
INSERT INTO accounts VALUES ('7536903c-aee1-3994-51db-438dfbe974a6', '2005-11-30 19:21:14', '2005-11-30 19:21:14', '1', 'max_id', '1', 'V & P Olguin Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '8882 Weatherly Way', 'Newport Beach', 'CA', '66582', 'USA', NULL, NULL, '214-555-7401', NULL, NULL, NULL, 'www.vpolguintransportationcorp.com', NULL, NULL, NULL, NULL, '8882 Weatherly Way', 'Newport Beach', 'CA', '66582', 'USA', 0);
INSERT INTO accounts VALUES ('a586a963-8c8d-444d-ef96-438dfbb7ec6f', '2005-11-30 19:21:14', '2005-11-30 19:21:14', '1', 'will_id', '1', 'Olguin-Ayers Telecommunications, Inc', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '7468 Franklin Canyon Road', 'Sedro Woolley', 'WA', '88132', 'USA', NULL, NULL, '595-555-5922', NULL, NULL, NULL, 'www.olguin-ayerstelecommunications,inc.com', NULL, NULL, NULL, NULL, '7468 Franklin Canyon Road', 'Sedro Woolley', 'WA', '88132', 'USA', 0);
INSERT INTO accounts VALUES ('d5cef91d-7579-2bf5-e1da-438dfb9c1f01', '2005-11-30 19:21:14', '2005-11-30 19:21:14', '1', 'matt_id', '1', 'F & X Kotc Communications Partners', NULL, 'Consulting', 'Communications', NULL, NULL, '3328 Via Cortez', 'Long Beach', 'CA', '87731', 'USA', NULL, NULL, '253-555-2843', NULL, NULL, NULL, 'www.fxkotccommunicationspartners.com', NULL, NULL, NULL, NULL, '3328 Via Cortez', 'Long Beach', 'CA', '87731', 'USA', 0);
INSERT INTO accounts VALUES ('3a1d8224-f228-2a6f-0875-438dfbcf8793', '2005-11-30 19:21:15', '2005-11-30 19:21:15', '1', 'sally_id', '1', 'Kotc-Coriell Communications Holdings', NULL, 'Distribution', 'Communications', NULL, NULL, '4824 Discovery Bay', 'Beverly Hills', 'CA', '75442', 'USA', NULL, NULL, '783-555-1391', NULL, NULL, NULL, 'www.kotc-coriellcommunicationsholdings.com', NULL, NULL, NULL, NULL, '4824 Discovery Bay', 'Beverly Hills', 'CA', '75442', 'USA', 0);
INSERT INTO accounts VALUES ('6d303905-f4e0-640c-af5a-438dfb307c0f', '2005-11-30 19:21:15', '2005-11-30 19:21:15', '1', 'sarah_id', '1', 'S & X Warthen Engineering Partners', NULL, 'Distribution', 'Engineering', NULL, NULL, '8282 Meadowbrook Court', 'Puyallup', 'WA', '41204', 'USA', NULL, NULL, '703-555-9598', NULL, NULL, NULL, 'www.sxwarthenengineeringpartners.com', NULL, NULL, NULL, NULL, '8282 Meadowbrook Court', 'Puyallup', 'WA', '41204', 'USA', 0);
INSERT INTO accounts VALUES ('e17a0d13-3963-7868-ca52-438dfbd6d960', '2005-11-30 19:21:15', '2005-11-30 19:21:15', '1', 'sarah_id', '1', 'Warthen-Johnson Transportation, Inc', NULL, 'Supply', 'Transportation', NULL, NULL, '2687 Gilberto', 'La Jolla', 'CA', '94076', 'USA', NULL, NULL, '468-555-9034', NULL, NULL, NULL, 'www.warthen-johnsontransportation,inc.com', NULL, NULL, NULL, NULL, '2687 Gilberto', 'La Jolla', 'CA', '94076', 'USA', 0);
INSERT INTO accounts VALUES ('1daf85c8-6874-a17b-17cb-438dfb55a65f', '2005-11-30 19:21:16', '2005-11-30 19:21:16', '1', 'sarah_id', '1', 'H & N Huckaby Machinery Corp', NULL, 'Supply', 'Machinery', NULL, NULL, '6400 Kenwal Rd.', 'Richmond', 'CA', '98706', 'USA', NULL, NULL, '411-555-6870', NULL, NULL, NULL, 'www.hnhuckabymachinerycorp.com', NULL, NULL, NULL, NULL, '6400 Kenwal Rd.', 'Richmond', 'CA', '98706', 'USA', 0);
INSERT INTO accounts VALUES ('69ac166c-2b09-54c5-e12e-438dfb58be75', '2005-11-30 19:21:16', '2005-11-30 19:21:16', '1', 'will_id', '1', 'Huckaby-Gustafson Machinery Associates', NULL, 'Supply', 'Machinery', NULL, NULL, '1060 McElroy Court', 'Burbank', 'CA', '18741', 'USA', NULL, NULL, '860-555-1277', NULL, NULL, NULL, 'www.huckaby-gustafsonmachineryassociates.com', NULL, NULL, NULL, NULL, '1060 McElroy Court', 'Burbank', 'CA', '18741', 'USA', 0);
INSERT INTO accounts VALUES ('c64ca1f4-971c-ba58-e3a6-438dfbe4e18a', '2005-11-30 19:21:16', '2005-11-30 19:21:16', '1', 'max_id', '1', 'G & W Thompson Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '7681 Hillcrest', 'Port Hammond', 'BC', '15825', 'Canada', NULL, NULL, '164-555-1398', NULL, NULL, NULL, 'www.gwthompsontransportation,inc.com', NULL, NULL, NULL, NULL, '7681 Hillcrest', 'Port Hammond', 'BC', '15825', 'Canada', 0);
INSERT INTO accounts VALUES ('2e151528-0941-acdb-9162-438dfb4fb878', '2005-11-30 19:21:17', '2005-11-30 19:21:17', '1', 'matt_id', '1', 'Thompson-Hendricks Machinery Corp', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '5251 Canyon Road', 'Anacortes', 'WA', '10214', 'USA', NULL, NULL, '876-555-7091', NULL, NULL, NULL, 'www.thompson-hendricksmachinerycorp.com', NULL, NULL, NULL, NULL, '5251 Canyon Road', 'Anacortes', 'WA', '10214', 'USA', 0);
INSERT INTO accounts VALUES ('7d77c5de-1ccb-a31f-2fa0-438dfb56e39b', '2005-11-30 19:21:17', '2005-11-30 19:21:17', '1', 'beth_id', '1', 'V & B Black Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '2128 Holland Drive.', 'Coronado', 'CA', '36974', 'USA', NULL, NULL, '203-555-5841', NULL, NULL, NULL, 'www.vbblacktransportationholdings.com', NULL, NULL, NULL, NULL, '2128 Holland Drive.', 'Coronado', 'CA', '36974', 'USA', 0);
INSERT INTO accounts VALUES ('ca27de55-8edd-4ee9-e5ac-438dfbd89907', '2005-11-30 19:21:17', '2005-11-30 19:21:17', '1', 'beth_id', '1', 'Black-Vansant Construction Company', NULL, 'Consulting', 'Construction', NULL, NULL, '1314 Westover Dr.', 'Daly City', 'CA', '87331', 'USA', NULL, NULL, '937-555-1162', NULL, NULL, NULL, 'www.black-vansantconstructioncompany.com', NULL, NULL, NULL, NULL, '1314 Westover Dr.', 'Daly City', 'CA', '87331', 'USA', 0);
INSERT INTO accounts VALUES ('60b70a54-714f-be7a-4b60-438dfb818721', '2005-11-30 19:21:18', '2005-11-30 19:21:18', '1', 'max_id', '1', 'C & A Bentley Engineering Group', NULL, 'Supply', 'Engineering', NULL, NULL, '1101 C Street', 'Daly City', 'CA', '87541', 'USA', NULL, NULL, '526-555-2198', NULL, NULL, NULL, 'www.cabentleyengineeringgroup.com', NULL, NULL, NULL, NULL, '1101 C Street', 'Daly City', 'CA', '87541', 'USA', 0);
INSERT INTO accounts VALUES ('4493f50e-b438-9309-7460-438dfbd1e55a', '2005-11-30 19:21:18', '2005-11-30 19:21:18', '1', 'kristen_id', '1', 'Bentley-Ritacco Construction, Ltd', NULL, 'Consulting', 'Construction', NULL, NULL, '9177 Concord Royale', 'Grossmont', 'CA', '77767', 'USA', NULL, NULL, '622-555-8806', NULL, NULL, NULL, 'www.bentley-ritaccoconstruction,ltd.com', NULL, NULL, NULL, NULL, '9177 Concord Royale', 'Grossmont', 'CA', '77767', 'USA', 0);
INSERT INTO accounts VALUES ('7785d491-20b6-5a33-d7f5-438dfbbcdfe4', '2005-11-30 19:21:18', '2005-11-30 19:21:18', '1', 'chris_id', '1', 'U & S Theisen Transportation, Inc', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '9218 Sanford St.', 'Walla Walla', 'WA', '46044', 'USA', NULL, NULL, '895-555-4813', NULL, NULL, NULL, 'www.ustheisentransportation,inc.com', NULL, NULL, NULL, NULL, '9218 Sanford St.', 'Walla Walla', 'WA', '46044', 'USA', 0);
INSERT INTO accounts VALUES ('b72ef6a5-a70e-7e32-7555-438dfb48175a', '2005-11-30 19:21:18', '2005-11-30 19:21:18', '1', 'will_id', '1', 'Theisen-Berger Construction Group', NULL, 'Distribution', 'Construction', NULL, NULL, '7549 Longview Rd.', 'Mill Valley', 'CA', '28725', 'USA', NULL, NULL, '702-555-1702', NULL, NULL, NULL, 'www.theisen-bergerconstructiongroup.com', NULL, NULL, NULL, NULL, '7549 Longview Rd.', 'Mill Valley', 'CA', '28725', 'USA', 0);
INSERT INTO accounts VALUES ('1226c48a-8e8a-48fd-168f-438dfbbc24a6', '2005-11-30 19:21:19', '2005-11-30 19:21:19', '1', 'sarah_id', '1', 'N & W Koski Transportation Corp', NULL, 'Distribution', 'Transportation', NULL, NULL, '500 Rockledge Lane', 'Tacoma', 'WA', '35870', 'USA', NULL, NULL, '997-555-5337', NULL, NULL, NULL, 'www.nwkoskitransportationcorp.com', NULL, NULL, NULL, NULL, '500 Rockledge Lane', 'Tacoma', 'WA', '35870', 'USA', 0);
INSERT INTO accounts VALUES ('51069b30-5071-f6e7-81d6-438dfbfac69a', '2005-11-30 19:21:19', '2005-11-30 19:21:19', '1', 'matt_id', '1', 'Koski-Fitzgerald Engineering Partners', NULL, 'Supply', 'Engineering', NULL, NULL, '1742 Breck Court', 'Shawnee', 'BC', '83711', 'Canada', NULL, NULL, '478-555-3859', NULL, NULL, NULL, 'www.koski-fitzgeraldengineeringpartners.com', NULL, NULL, NULL, NULL, '1742 Breck Court', 'Shawnee', 'BC', '83711', 'Canada', 0);
INSERT INTO accounts VALUES ('a169e42d-a69b-b039-6170-438dfbd9dd1b', '2005-11-30 19:21:19', '2005-11-30 19:21:19', '1', 'sarah_id', '1', 'O & D Camacho Communications Associates', NULL, 'Distribution', 'Communications', NULL, NULL, '4946 Abbey Court', 'Langford', 'BC', '83311', 'Canada', NULL, NULL, '136-555-9780', NULL, NULL, NULL, 'www.odcamachocommunicationsassociates.com', NULL, NULL, NULL, NULL, '4946 Abbey Court', 'Langford', 'BC', '83311', 'Canada', 0);
INSERT INTO accounts VALUES ('d1c588fa-0835-de12-f760-438dfb25122d', '2005-11-30 19:21:19', '2005-11-30 19:21:19', '1', 'sally_id', '1', 'Camacho-Alvarado Transportation Company', NULL, 'Consulting', 'Transportation', NULL, NULL, '6441 Via Santa Fe', 'Puyallup', 'WA', '71022', 'USA', NULL, NULL, '779-555-1588', NULL, NULL, NULL, 'www.camacho-alvaradotransportationcompany.com', NULL, NULL, NULL, NULL, '6441 Via Santa Fe', 'Puyallup', 'WA', '71022', 'USA', 0);
INSERT INTO accounts VALUES ('1463cd37-29f8-b0f2-4514-438dfb7af5ba', '2005-11-30 19:21:20', '2005-11-30 19:21:20', '1', 'sally_id', '1', 'M & Y Brummer Communications, Ltd', NULL, 'Supply', 'Communications', NULL, NULL, '9899 Geary Court', 'Grossmont', 'CA', '10492', 'USA', NULL, NULL, '459-555-6138', NULL, NULL, NULL, 'www.mybrummercommunications,ltd.com', NULL, NULL, NULL, NULL, '9899 Geary Court', 'Grossmont', 'CA', '10492', 'USA', 0);
INSERT INTO accounts VALUES ('4488073d-4339-fb11-e278-438dfb45d751', '2005-11-30 19:21:20', '2005-11-30 19:21:20', '1', 'beth_id', '1', 'Brummer-Pinkston Communications Associates', NULL, 'Consulting', 'Communications', NULL, NULL, '4305 Amanda Circle', 'Lebanon', 'OR', '89656', 'USA', NULL, NULL, '225-555-5573', NULL, NULL, NULL, 'www.brummer-pinkstoncommunicationsassociates.com', NULL, NULL, NULL, NULL, '4305 Amanda Circle', 'Lebanon', 'OR', '89656', 'USA', 0);
INSERT INTO accounts VALUES ('86b427e1-a1dd-4d58-d470-438dfbdd6dfd', '2005-11-30 19:21:20', '2005-11-30 19:21:20', '1', 'max_id', '1', 'B & D Spivey Machinery Partners', NULL, 'Consulting', 'Machinery', NULL, NULL, '674 Woodchuck Pl.', 'Burien', 'WA', '94286', 'USA', NULL, NULL, '167-555-3409', NULL, NULL, NULL, 'www.bdspiveymachinerypartners.com', NULL, NULL, NULL, NULL, '674 Woodchuck Pl.', 'Burien', 'WA', '94286', 'USA', 0);
INSERT INTO accounts VALUES ('e4ce44fa-216f-d1c7-e9ef-438dfbb2cc13', '2005-11-30 19:21:20', '2005-11-30 19:21:20', '1', 'sarah_id', '1', 'Spivey-Whiting Construction Partners', NULL, 'Manufacturing', 'Construction', NULL, NULL, '5333 Garaventa Drive', 'Lake Oswego', 'OR', '14321', 'USA', NULL, NULL, '855-555-1473', NULL, NULL, NULL, 'www.spivey-whitingconstructionpartners.com', NULL, NULL, NULL, NULL, '5333 Garaventa Drive', 'Lake Oswego', 'OR', '14321', 'USA', 0);
INSERT INTO accounts VALUES ('30243b86-0c2f-4cd9-cf98-438dfb7a611e', '2005-11-30 19:21:21', '2005-11-30 19:21:21', '1', 'kristen_id', '1', 'H & E Espinoza Machinery Group', NULL, 'Supply', 'Machinery', NULL, NULL, '1955 Wallace Dr.', 'La Cruz', 'Sinaloa', '84112', 'Mexico', NULL, NULL, '821-555-6938', NULL, NULL, NULL, 'www.heespinozamachinerygroup.com', NULL, NULL, NULL, NULL, '1955 Wallace Dr.', 'La Cruz', 'Sinaloa', '84112', 'Mexico', 0);
INSERT INTO accounts VALUES ('7282206d-2097-c88f-cc36-438dfb4272e6', '2005-11-30 19:21:21', '2005-11-30 19:21:21', '1', 'beth_id', '1', 'Espinoza-Robinett Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '6868 West', 'Lincoln Acres', 'CA', '69308', 'USA', NULL, NULL, '632-555-3630', NULL, NULL, NULL, 'www.espinoza-robinettelectronicsholdings.com', NULL, NULL, NULL, NULL, '6868 West', 'Lincoln Acres', 'CA', '69308', 'USA', 0);
INSERT INTO accounts VALUES ('b269cbcc-3523-84cd-76a1-438dfb8cca3e', '2005-11-30 19:21:21', '2005-11-30 19:21:21', '1', 'max_id', '1', 'X & M Lundahl Construction Corp', NULL, 'Manufacturing', 'Construction', NULL, NULL, '6401 Cook Street', 'Seattle', 'WA', '62625', 'USA', NULL, NULL, '859-555-2380', NULL, NULL, NULL, 'www.xmlundahlconstructioncorp.com', NULL, NULL, NULL, NULL, '6401 Cook Street', 'Seattle', 'WA', '62625', 'USA', 0);
INSERT INTO accounts VALUES ('db29071d-ab61-8267-207d-438dfbd07e1f', '2005-11-30 19:21:22', '2005-11-30 19:21:22', '1', 'sally_id', '1', 'Lundahl-Demicell Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '1569 Norse Drive', 'Corvallis', 'OR', '56618', 'USA', NULL, NULL, '932-555-1359', NULL, NULL, NULL, 'www.lundahl-demicelltelecommunications,ltd.com', NULL, NULL, NULL, NULL, '1569 Norse Drive', 'Corvallis', 'OR', '56618', 'USA', 0);
INSERT INTO accounts VALUES ('52e4fd3b-926a-77bb-c6ba-438dfbe5a927', '2005-11-30 19:21:22', '2005-11-30 19:21:22', '1', 'chris_id', '1', 'I & M Rousey Transportation, Ltd', NULL, 'Supply', 'Transportation', NULL, NULL, '1355 Sequoia Drive', 'Guadalajara', 'Jalisco', '78856', 'Mexico', NULL, NULL, '634-555-4655', NULL, NULL, NULL, 'www.imrouseytransportation,ltd.com', NULL, NULL, NULL, NULL, '1355 Sequoia Drive', 'Guadalajara', 'Jalisco', '78856', 'Mexico', 0);
INSERT INTO accounts VALUES ('861f83dc-68b6-733b-cbce-438dfb2b868a', '2005-11-30 19:21:22', '2005-11-30 19:21:22', '1', 'will_id', '1', 'Rousey-Marcovecchio Electronics Corp', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '9431 Sun View Terrace', 'Port Hammond', 'BC', '95375', 'Canada', NULL, NULL, '730-555-2262', NULL, NULL, NULL, 'www.rousey-marcovecchioelectronicscorp.com', NULL, NULL, NULL, NULL, '9431 Sun View Terrace', 'Port Hammond', 'BC', '95375', 'Canada', 0);
INSERT INTO accounts VALUES ('c661b334-bf51-1dde-62bf-438dfbf2442c', '2005-11-30 19:21:22', '2005-11-30 19:21:22', '1', 'kristen_id', '1', 'H & Y Evans Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '9472 Juliet Court', 'Colma', 'CA', '63651', 'USA', NULL, NULL, '102-555-7269', NULL, NULL, NULL, 'www.hyevansengineering,inc.com', NULL, NULL, NULL, NULL, '9472 Juliet Court', 'Colma', 'CA', '63651', 'USA', 0);
INSERT INTO accounts VALUES ('12814883-6201-bc73-1589-438dfbe68b5d', '2005-11-30 19:21:23', '2005-11-30 19:21:23', '1', 'jaime_id', '1', 'Evans-Storjohann Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '460 Carzino Ct', 'La Mesa', 'CA', '20040', 'USA', NULL, NULL, '460-555-7162', NULL, NULL, NULL, 'www.evans-storjohanntelecommunications,ltd.com', NULL, NULL, NULL, NULL, '460 Carzino Ct', 'La Mesa', 'CA', '20040', 'USA', 0);
INSERT INTO accounts VALUES ('68359cf5-c82c-2694-bcf9-438dfbe295ac', '2005-11-30 19:21:23', '2005-11-30 19:21:23', '1', 'sally_id', '1', 'D & A Maccietto Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '3410 Hemlock Ave.', 'El Cajon', 'CA', '53478', 'USA', NULL, NULL, '756-555-1798', NULL, NULL, NULL, 'www.damacciettomachinerygroup.com', NULL, NULL, NULL, NULL, '3410 Hemlock Ave.', 'El Cajon', 'CA', '53478', 'USA', 0);
INSERT INTO accounts VALUES ('a2f0f610-c757-4a3d-0e53-438dfb0662eb', '2005-11-30 19:21:23', '2005-11-30 19:21:23', '1', 'max_id', '1', 'Maccietto-Buskirk Construction Associates', NULL, 'Consulting', 'Construction', NULL, NULL, '1996 Sand Pointe Lane', 'Oakland', 'CA', '75027', 'USA', NULL, NULL, '237-555-9319', NULL, NULL, NULL, 'www.maccietto-buskirkconstructionassociates.com', NULL, NULL, NULL, NULL, '1996 Sand Pointe Lane', 'Oakland', 'CA', '75027', 'USA', 0);
INSERT INTO accounts VALUES ('d6b280a6-e776-1416-4a2f-438dfbc155a4', '2005-11-30 19:21:23', '2005-11-30 19:21:23', '1', 'max_id', '1', 'D & Z Kesslep Electronics, Ltd', NULL, 'Consulting', 'Electronics', NULL, NULL, '5200 Pennsylvania Blvd', 'Vancouver', 'BC', '74626', 'Canada', NULL, NULL, '134-555-9898', NULL, NULL, NULL, 'www.dzkesslepelectronics,ltd.com', NULL, NULL, NULL, NULL, '5200 Pennsylvania Blvd', 'Vancouver', 'BC', '74626', 'Canada', 0);
INSERT INTO accounts VALUES ('1620dad8-2eb7-e7e0-cc51-438dfb06f565', '2005-11-30 19:21:24', '2005-11-30 19:21:24', '1', 'kristen_id', '1', 'Kesslep-Schultz Engineering Corp', NULL, 'Consulting', 'Engineering', NULL, NULL, '6695 Kathleen Drive', 'N. Vancouver', 'BC', '62338', 'Canada', NULL, NULL, '537-555-7048', NULL, NULL, NULL, 'www.kesslep-schultzengineeringcorp.com', NULL, NULL, NULL, NULL, '6695 Kathleen Drive', 'N. Vancouver', 'BC', '62338', 'Canada', 0);
INSERT INTO accounts VALUES ('4ca2c4b2-a7ad-2dd5-c8ce-438dfbacc559', '2005-11-30 19:21:24', '2005-11-30 19:21:24', '1', 'will_id', '1', 'Q & Q Bergin Telecommunications Associates', NULL, 'Supply', 'Telecommunications', NULL, NULL, '2810 Guadalupe', 'Acapulco', 'Guerrero', '28099', 'Mexico', NULL, NULL, '218-555-2598', NULL, NULL, NULL, 'www.qqbergintelecommunicationsassociates.com', NULL, NULL, NULL, NULL, '2810 Guadalupe', 'Acapulco', 'Guerrero', '28099', 'Mexico', 0);
INSERT INTO accounts VALUES ('94a3441e-a450-ea5a-d820-438dfb458713', '2005-11-30 19:21:24', '2005-11-30 19:21:24', '1', 'max_id', '1', 'Bergin-Steel Engineering Company', NULL, 'Manufacturing', 'Engineering', NULL, NULL, 'P.O. Box 4559', 'Edmonds', 'WA', '80971', 'USA', NULL, NULL, '883-555-2034', NULL, NULL, NULL, 'www.bergin-steelengineeringcompany.com', NULL, NULL, NULL, NULL, 'P.O. Box 4559', 'Edmonds', 'WA', '80971', 'USA', 0);
INSERT INTO accounts VALUES ('d882d439-557f-3c8a-2b84-438dfb8fb443', '2005-11-30 19:21:24', '2005-11-30 19:21:24', '1', 'matt_id', '1', 'Y & R Marple Machinery, Inc', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '928 Old Mountain View Dr.', 'Olympia', 'WA', '12894', 'USA', NULL, NULL, '826-555-8869', NULL, NULL, NULL, 'www.yrmarplemachinery,inc.com', NULL, NULL, NULL, NULL, '928 Old Mountain View Dr.', 'Olympia', 'WA', '12894', 'USA', 0);
INSERT INTO accounts VALUES ('27d80dd7-5709-0d55-bc59-438dfb2ecf77', '2005-11-30 19:21:25', '2005-11-30 19:21:25', '1', 'sarah_id', '1', 'Marple-Evans Engineering, Inc', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '5587 D St.', 'Cliffside', 'BC', '31928', 'Canada', NULL, NULL, '614-555-6934', NULL, NULL, NULL, 'www.marple-evansengineering,inc.com', NULL, NULL, NULL, NULL, '5587 D St.', 'Cliffside', 'BC', '31928', 'Canada', 0);
INSERT INTO accounts VALUES ('6bdb4764-4c85-d993-60a3-438dfbd78877', '2005-11-30 19:21:25', '2005-11-30 19:21:25', '1', 'kristen_id', '1', 'E & F Bruner Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '6111 Guadalajara', 'Oregon City', 'OR', '27206', 'USA', NULL, NULL, '579-555-3398', NULL, NULL, NULL, 'www.efbrunermachinery,ltd.com', NULL, NULL, NULL, NULL, '6111 Guadalajara', 'Oregon City', 'OR', '27206', 'USA', 0);
INSERT INTO accounts VALUES ('b0e04bdb-7d18-6594-1161-438dfbdd2db8', '2005-11-30 19:21:25', '2005-11-30 19:21:25', '1', 'chris_id', '1', 'Bruner-Troyer Transportation Holdings', NULL, 'Distribution', 'Transportation', NULL, NULL, '1025 R St.', 'Kirkland', 'WA', '86915', 'USA', NULL, NULL, '742-555-6008', NULL, NULL, NULL, 'www.bruner-troyertransportationholdings.com', NULL, NULL, NULL, NULL, '1025 R St.', 'Kirkland', 'WA', '86915', 'USA', 0);
INSERT INTO accounts VALUES ('f36732ff-d18a-33cf-cdef-438dfb50e080', '2005-11-30 19:21:25', '2005-11-30 19:21:25', '1', 'will_id', '1', 'N & O Sandidge Electronics, Inc', NULL, 'Supply', 'Electronics', NULL, NULL, '557 Diver Way', 'Royal Oak', 'BC', '23869', 'Canada', NULL, NULL, '969-555-4758', NULL, NULL, NULL, 'www.nosandidgeelectronics,inc.com', NULL, NULL, NULL, NULL, '557 Diver Way', 'Royal Oak', 'BC', '23869', 'Canada', 0);
INSERT INTO accounts VALUES ('52bed83a-38fc-b11f-f87f-438dfb98b92e', '2005-11-30 19:21:26', '2005-11-30 19:21:26', '1', 'kristen_id', '1', 'Sandidge-Skonnard Machinery Group', NULL, 'Distribution', 'Machinery', NULL, NULL, '8380 Paso Del Rio Court', 'Spring Valley', 'CA', '74226', 'USA', NULL, NULL, '142-555-3737', NULL, NULL, NULL, 'www.sandidge-skonnardmachinerygroup.com', NULL, NULL, NULL, NULL, '8380 Paso Del Rio Court', 'Spring Valley', 'CA', '74226', 'USA', 0);
INSERT INTO accounts VALUES ('86d3263a-ebb4-fe6c-af85-438dfb92f6e9', '2005-11-30 19:21:26', '2005-11-30 19:21:26', '1', 'beth_id', '1', 'U & W Beck Construction Corp', NULL, 'Supply', 'Construction', NULL, NULL, '8166 Starflower Dr', 'Spring Valley', 'CA', '76341', 'USA', NULL, NULL, '392-555-1115', NULL, NULL, NULL, 'www.uwbeckconstructioncorp.com', NULL, NULL, NULL, NULL, '8166 Starflower Dr', 'Spring Valley', 'CA', '76341', 'USA', 0);
INSERT INTO accounts VALUES ('c899fe71-1c72-cefa-3506-438dfbf06cbb', '2005-11-30 19:21:26', '2005-11-30 19:21:26', '1', 'max_id', '1', 'Beck-Abel Electronics Company', NULL, 'Consulting', 'Electronics', NULL, NULL, '3588 Vancouver Way', 'San Francisco', 'CA', '64952', 'USA', NULL, NULL, '488-555-7722', NULL, NULL, NULL, 'www.beck-abelelectronicscompany.com', NULL, NULL, NULL, NULL, '3588 Vancouver Way', 'San Francisco', 'CA', '64952', 'USA', 0);
INSERT INTO accounts VALUES ('3848e594-7629-8173-06a8-438dfbd07afa', '2005-11-30 19:21:27', '2005-11-30 19:21:27', '1', 'chris_id', '1', 'M & K Miller Telecommunications, Ltd', NULL, 'Supply', 'Telecommunications', NULL, NULL, '6284 Levee Rd.', 'Lebanon', 'OR', '33229', 'USA', NULL, NULL, '761-555-3729', NULL, NULL, NULL, 'www.mkmillertelecommunications,ltd.com', NULL, NULL, NULL, NULL, '6284 Levee Rd.', 'Lebanon', 'OR', '33229', 'USA', 0);
INSERT INTO accounts VALUES ('7cb73f6a-5de6-f957-936b-438dfb2ab8cb', '2005-11-30 19:21:27', '2005-11-30 19:21:27', '1', 'sarah_id', '1', 'Miller-Walker Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '4616 Cordova Way', 'Portland', 'OR', '15910', 'USA', NULL, NULL, '219-555-3622', NULL, NULL, NULL, 'www.miller-walkermachinery,ltd.com', NULL, NULL, NULL, NULL, '4616 Cordova Way', 'Portland', 'OR', '15910', 'USA', 0);
INSERT INTO accounts VALUES ('ad0c8ac5-b1f9-9dcd-ca34-438dfb04c1a8', '2005-11-30 19:21:27', '2005-11-30 19:21:27', '1', 'beth_id', '1', 'L & E Brooks Communications Partners', NULL, 'Distribution', 'Communications', NULL, NULL, '7566 Keller Ridge Dr.', 'Bellflower', 'CA', '49347', 'USA', NULL, NULL, '754-555-1915', NULL, NULL, NULL, 'www.lebrookscommunicationspartners.com', NULL, NULL, NULL, NULL, '7566 Keller Ridge Dr.', 'Bellflower', 'CA', '49347', 'USA', 0);
INSERT INTO accounts VALUES ('c98d0766-adf0-5ff8-63d0-438dfb9a8e9e', '2005-11-30 19:21:28', '2005-11-30 19:21:28', '1', 'sally_id', '1', 'Brooks-Logan Construction Holdings', NULL, 'Consulting', 'Construction', NULL, NULL, '8807 Soto St.', 'Bremerton', 'WA', '70897', 'USA', NULL, NULL, '896-555-5779', NULL, NULL, NULL, 'www.brooks-loganconstructionholdings.com', NULL, NULL, NULL, NULL, '8807 Soto St.', 'Bremerton', 'WA', '70897', 'USA', 0);
INSERT INTO accounts VALUES ('3ce7d434-1d87-d2ac-cb37-438dfb6eaebb', '2005-11-30 19:21:28', '2005-11-30 19:21:28', '1', 'kristen_id', '1', 'W & N Several Telecommunications Partners', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '2012 Reisling Court', 'San Carlos', 'CA', '70496', 'USA', NULL, NULL, '792-555-6358', NULL, NULL, NULL, 'www.wnseveraltelecommunicationspartners.com', NULL, NULL, NULL, NULL, '2012 Reisling Court', 'San Carlos', 'CA', '70496', 'USA', 0);
INSERT INTO accounts VALUES ('6d531631-8b4e-ed30-477f-438dfb9e4024', '2005-11-30 19:21:28', '2005-11-30 19:21:28', '1', 'sally_id', '1', 'Several-Thomas Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '3507 Limeridge Drive', 'Acapulco', 'Guerrero', '58207', 'Mexico', NULL, NULL, '296-555-3508', NULL, NULL, NULL, 'www.several-thomastransportationholdings.com', NULL, NULL, NULL, NULL, '3507 Limeridge Drive', 'Acapulco', 'Guerrero', '58207', 'Mexico', 0);
INSERT INTO accounts VALUES ('b3341af8-246f-e384-a007-438dfbc474a3', '2005-11-30 19:21:28', '2005-11-30 19:21:28', '1', 'beth_id', '1', 'V & A Vessa Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '6965 Appalachian Drive', 'Beaverton', 'OR', '23969', 'USA', NULL, NULL, '877-555-8058', NULL, NULL, NULL, 'www.vavessatransportationcorp.com', NULL, NULL, NULL, NULL, '6965 Appalachian Drive', 'Beaverton', 'OR', '23969', 'USA', 0);
INSERT INTO accounts VALUES ('13116248-d871-2b8d-45af-438dfb8b4196', '2005-11-30 19:21:29', '2005-11-30 19:21:29', '1', 'max_id', '1', 'Vessa-Tran Communications Corp', NULL, 'Consulting', 'Communications', NULL, NULL, '1371 Rogers Ave', 'Imperial Beach', 'CA', '76841', 'USA', NULL, NULL, '993-555-4411', NULL, NULL, NULL, 'www.vessa-trancommunicationscorp.com', NULL, NULL, NULL, NULL, '1371 Rogers Ave', 'Imperial Beach', 'CA', '76841', 'USA', 0);
INSERT INTO accounts VALUES ('5602b4b8-2825-616c-26d1-438dfb0c802e', '2005-11-30 19:21:29', '2005-11-30 19:21:29', '1', 'sally_id', '1', 'T & A Crow Electronics, Inc', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '7739 Pineknoll', 'Newport Beach', 'CA', '81471', 'USA', NULL, NULL, '936-555-2247', NULL, NULL, NULL, 'www.tacrowelectronics,inc.com', NULL, NULL, NULL, NULL, '7739 Pineknoll', 'Newport Beach', 'CA', '81471', 'USA', 0);
INSERT INTO accounts VALUES ('9aecd983-eb46-0d41-825d-438dfb1bcc5c', '2005-11-30 19:21:29', '2005-11-30 19:21:29', '1', 'matt_id', '1', 'Crow-Sims Construction Associates', NULL, 'Manufacturing', 'Construction', NULL, NULL, '9742 Anderson Way', 'Long Beach', 'CA', '15065', 'USA', NULL, NULL, '724-555-9311', NULL, NULL, NULL, 'www.crow-simsconstructionassociates.com', NULL, NULL, NULL, NULL, '9742 Anderson Way', 'Long Beach', 'CA', '15065', 'USA', 0);
INSERT INTO accounts VALUES ('cb4e19da-1b76-52ef-4756-438dfb152979', '2005-11-30 19:21:29', '2005-11-30 19:21:29', '1', 'chris_id', '1', 'D & D Tatman Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '9021 Onley Dr', 'Chula Vista', 'CA', '71297', 'USA', NULL, NULL, '689-555-5775', NULL, NULL, NULL, 'www.ddtatmanelectronicsholdings.com', NULL, NULL, NULL, NULL, '9021 Onley Dr', 'Chula Vista', 'CA', '71297', 'USA', 0);
INSERT INTO accounts VALUES ('198c4b42-3db0-a532-fe75-438dfb4ed4c3', '2005-11-30 19:21:30', '2005-11-30 19:21:30', '1', 'sarah_id', '1', 'Tatman-Nelsen Machinery, Inc', NULL, 'Distribution', 'Machinery', NULL, NULL, '3935 Hawkins Street', 'Langford', 'BC', '56493', 'Canada', NULL, NULL, '501-555-2468', NULL, NULL, NULL, 'www.tatman-nelsenmachinery,inc.com', NULL, NULL, NULL, NULL, '3935 Hawkins Street', 'Langford', 'BC', '56493', 'Canada', 0);
INSERT INTO accounts VALUES ('721ccb5b-ba24-966e-5cbd-438dfb4043f6', '2005-11-30 19:21:30', '2005-11-30 19:21:30', '1', 'sally_id', '1', 'I & V Cole Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '811 Via Cordona', 'Daly City', 'CA', '19739', 'USA', NULL, NULL, '728-555-1218', NULL, NULL, NULL, 'www.ivcoleengineering,inc.com', NULL, NULL, NULL, NULL, '811 Via Cordona', 'Daly City', 'CA', '19739', 'USA', 0);
INSERT INTO accounts VALUES ('c70c9652-fb23-1d97-2bcf-438dfbb6fe01', '2005-11-30 19:21:30', '2005-11-30 19:21:30', '1', 'beth_id', '1', 'Cole-Huntsman Construction, Ltd', NULL, 'Manufacturing', 'Construction', NULL, NULL, '8634 Forte Way', 'Glendale', 'CA', '43804', 'USA', NULL, NULL, '801-555-9197', NULL, NULL, NULL, 'www.cole-huntsmanconstruction,ltd.com', NULL, NULL, NULL, NULL, '8634 Forte Way', 'Glendale', 'CA', '43804', 'USA', 0);
INSERT INTO accounts VALUES ('33aa0685-459e-a142-1291-438dfba1fba4', '2005-11-30 19:21:31', '2005-11-30 19:21:31', '1', 'matt_id', '1', 'K & R Arakawa Communications Group', NULL, 'Consulting', 'Communications', NULL, NULL, '8420 Dayton Court', 'Glendale', 'CA', '45919', 'USA', NULL, NULL, '151-555-6575', NULL, NULL, NULL, 'www.krarakawacommunicationsgroup.com', NULL, NULL, NULL, NULL, '8420 Dayton Court', 'Glendale', 'CA', '45919', 'USA', 0);
INSERT INTO accounts VALUES ('337bdd25-c908-7d88-d70e-438dfb6d5a65', '2005-11-30 19:21:31', '2005-11-30 19:21:31', '1', 'jaime_id', '1', 'Arakawa-Steuber Engineering Associates', NULL, 'Distribution', 'Engineering', NULL, NULL, '6498 Pasa Del Rio', 'Palo Alto', 'CA', '62437', 'USA', NULL, NULL, '247-555-4183', NULL, NULL, NULL, 'www.arakawa-steuberengineeringassociates.com', NULL, NULL, NULL, NULL, '6498 Pasa Del Rio', 'Palo Alto', 'CA', '62437', 'USA', 0);
INSERT INTO accounts VALUES ('9e9d1ad7-e038-da60-b03f-438dfbb22801', '2005-11-30 19:21:31', '2005-11-30 19:21:31', '1', 'max_id', '1', 'B & P Cox Telecommunications Holdings', NULL, 'Distribution', 'Telecommunications', NULL, NULL, '6538 Camelback Road', 'Los Angeles', 'CA', '55681', 'USA', NULL, NULL, '520-555-9190', NULL, NULL, NULL, 'www.bpcoxtelecommunicationsholdings.com', NULL, NULL, NULL, NULL, '6538 Camelback Road', 'Los Angeles', 'CA', '55681', 'USA', 0);
INSERT INTO accounts VALUES ('5b3205e4-12a6-dee0-efd5-438dfb40c431', '2005-11-30 19:21:32', '2005-11-30 19:21:32', '1', 'kristen_id', '1', 'Cox-Jacobs Electronics, Ltd', NULL, 'Distribution', 'Electronics', NULL, NULL, '7525 Sutcliffe Pl.', 'Pomona', 'CA', '38362', 'USA', NULL, NULL, '878-555-9083', NULL, NULL, NULL, 'www.cox-jacobselectronics,ltd.com', NULL, NULL, NULL, NULL, '7525 Sutcliffe Pl.', 'Pomona', 'CA', '38362', 'USA', 0);
INSERT INTO accounts VALUES ('48baf602-37b8-7988-804f-438dfb47231a', '2005-11-30 19:21:32', '2005-11-30 19:21:32', '1', 'chris_id', '1', 'Q & P Barley Telecommunications Company', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, '7820 Blackridge Drive', 'W. Linn', 'OR', '45507', 'USA', NULL, NULL, '513-555-7376', NULL, NULL, NULL, 'www.qpbarleytelecommunicationscompany.com', NULL, NULL, NULL, NULL, '7820 Blackridge Drive', 'W. Linn', 'OR', '45507', 'USA', 0);
INSERT INTO accounts VALUES ('8ef3c7cf-ee6c-1e89-f6c4-438dfb171221', '2005-11-30 19:21:32', '2005-11-30 19:21:32', '1', 'beth_id', '1', 'Barley-Alvaro Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '9061 Isabel', 'Spokane', 'WA', '93349', 'USA', NULL, NULL, '894-555-5897', NULL, NULL, NULL, 'www.barley-alvarotransportationholdings.com', NULL, NULL, NULL, NULL, '9061 Isabel', 'Spokane', 'WA', '93349', 'USA', 0);
INSERT INTO accounts VALUES ('d2373f7e-3be1-ac95-0bbd-438dfb96caeb', '2005-11-30 19:21:32', '2005-11-30 19:21:32', '1', 'kristen_id', '1', 'G & N Waters Communications Group', NULL, 'Supply', 'Communications', NULL, NULL, '2266 Bonifacio Street', 'Woodburn', 'OR', '66656', 'USA', NULL, NULL, '666-555-4999', NULL, NULL, NULL, 'www.gnwaterscommunicationsgroup.com', NULL, NULL, NULL, NULL, '2266 Bonifacio Street', 'Woodburn', 'OR', '66656', 'USA', 0);
INSERT INTO accounts VALUES ('34777a04-8cf2-130c-c206-438dfb71857f', '2005-11-30 19:21:33', '2005-11-30 19:21:33', '1', 'kristen_id', '1', 'Waters-Jarvis Construction Partners', NULL, 'Distribution', 'Construction', NULL, NULL, '3761 Cancroft Road', 'San Gabriel', 'CA', '80659', 'USA', NULL, NULL, '170-555-2149', NULL, NULL, NULL, 'www.waters-jarvisconstructionpartners.com', NULL, NULL, NULL, NULL, '3761 Cancroft Road', 'San Gabriel', 'CA', '80659', 'USA', 0);
INSERT INTO accounts VALUES ('64db3226-ae3d-4e8a-5749-438dfb42ff39', '2005-11-30 19:21:33', '2005-11-30 19:21:33', '1', 'kristen_id', '1', 'H & Y Styles Electronics, Ltd', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '9875 Prestwick Court', 'Lemon Grove', 'CA', '20129', 'USA', NULL, NULL, '989-555-1356', NULL, NULL, NULL, 'www.hystyleselectronics,ltd.com', NULL, NULL, NULL, NULL, '9875 Prestwick Court', 'Lemon Grove', 'CA', '20129', 'USA', 0);
INSERT INTO accounts VALUES ('97bd6b61-bc71-d178-5a95-438dfb05fd04', '2005-11-30 19:21:33', '2005-11-30 19:21:33', '1', 'chris_id', '1', 'Styles-Glenn Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '1625 Buckingham Dr.', 'San Jose', 'CA', '73001', 'USA', NULL, NULL, '516-555-6135', NULL, NULL, NULL, 'www.styles-glenntransportationholdings.com', NULL, NULL, NULL, NULL, '1625 Buckingham Dr.', 'San Jose', 'CA', '73001', 'USA', 0);
INSERT INTO accounts VALUES ('c8efe193-131a-8773-9b67-438dfbcae321', '2005-11-30 19:21:33', '2005-11-30 19:21:33', '1', 'sarah_id', '1', 'O & K Smith Transportation Corp', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '2519 Gill Ct.', 'Palo Alto', 'CA', '49244', 'USA', NULL, NULL, '458-555-3971', NULL, NULL, NULL, 'www.oksmithtransportationcorp.com', NULL, NULL, NULL, NULL, '2519 Gill Ct.', 'Palo Alto', 'CA', '49244', 'USA', 0);
INSERT INTO accounts VALUES ('18cf8c9b-25fd-9b30-f993-438dfb879e80', '2005-11-30 19:21:34', '2005-11-30 19:21:34', '1', 'beth_id', '1', 'Smith-Duff Construction Partners', NULL, 'Consulting', 'Construction', NULL, NULL, '7178 Cancroft Road', 'Newport Beach', 'CA', '23958', 'USA', NULL, NULL, '247-555-2035', NULL, NULL, NULL, 'www.smith-duffconstructionpartners.com', NULL, NULL, NULL, NULL, '7178 Cancroft Road', 'Newport Beach', 'CA', '23958', 'USA', 0);
INSERT INTO accounts VALUES ('48f9d0d4-e10b-53cd-1a0b-438dfbb23a4d', '2005-11-30 19:21:34', '2005-11-30 19:21:34', '1', 'sally_id', '1', 'D & D Lucero Transportation, Ltd', NULL, 'Distribution', 'Transportation', NULL, NULL, '3801 Roundhouse Place', 'Orizaba', 'Veracruz', '93749', 'Mexico', NULL, NULL, '212-555-7499', NULL, NULL, NULL, 'www.ddlucerotransportation,ltd.com', NULL, NULL, NULL, NULL, '3801 Roundhouse Place', 'Orizaba', 'Veracruz', '93749', 'Mexico', 0);
INSERT INTO accounts VALUES ('8f7f554f-8242-46f3-6454-438dfb8ee5fe', '2005-11-30 19:21:34', '2005-11-30 19:21:34', '1', 'kristen_id', '1', 'Lucero-Burton Machinery, Inc', NULL, 'Consulting', 'Machinery', NULL, NULL, '8713 Live Oak Avenue', 'Vancouver', 'BC', '78945', 'Canada', NULL, NULL, '262-555-7849', NULL, NULL, NULL, 'www.lucero-burtonmachinery,inc.com', NULL, NULL, NULL, NULL, '8713 Live Oak Avenue', 'Vancouver', 'BC', '78945', 'Canada', 0);
INSERT INTO accounts VALUES ('e7ab3484-832b-285b-9e13-438dfbc947f0', '2005-11-30 19:21:34', '2005-11-30 19:21:34', '1', 'beth_id', '1', 'E & M Consentino Electronics Company', NULL, 'Supply', 'Electronics', NULL, NULL, '8246 Via Del Sol', 'Chula Vista', 'CA', '15899', 'USA', NULL, NULL, '250-555-2942', NULL, NULL, NULL, 'www.emconsentinoelectronicscompany.com', NULL, NULL, NULL, NULL, '8246 Via Del Sol', 'Chula Vista', 'CA', '15899', 'USA', 0);
INSERT INTO accounts VALUES ('2399516f-d014-ece7-7267-438dfb20a957', '2005-11-30 19:21:35', '2005-11-30 19:21:35', '1', 'matt_id', '1', 'Consentino-Lutes Engineering, Ltd', NULL, 'Distribution', 'Engineering', NULL, NULL, '3414 Jason Court', 'Milwaukie', 'OR', '66256', 'USA', NULL, NULL, '324-555-1921', NULL, NULL, NULL, 'www.consentino-lutesengineering,ltd.com', NULL, NULL, NULL, NULL, '3414 Jason Court', 'Milwaukie', 'OR', '66256', 'USA', 0);
INSERT INTO accounts VALUES ('7f281512-f478-c01d-bd68-438dfb8e94ef', '2005-11-30 19:21:35', '2005-11-30 19:21:35', '1', 'matt_id', '1', 'R & Z Ecoffey Communications, Inc', NULL, 'Distribution', 'Communications', NULL, NULL, '3200 Glenmount Drive', 'Berkeley', 'CA', '68370', 'USA', NULL, NULL, '574-555-8299', NULL, NULL, NULL, 'www.rzecoffeycommunications,inc.com', NULL, NULL, NULL, NULL, '3200 Glenmount Drive', 'Berkeley', 'CA', '68370', 'USA', 0);
INSERT INTO accounts VALUES ('d7b2d1e3-13e2-0239-45f8-438dfb71d950', '2005-11-30 19:21:35', '2005-11-30 19:21:35', '1', 'chris_id', '1', 'Ecoffey-Swint Machinery Partners', NULL, 'Supply', 'Machinery', NULL, NULL, '1278 Holly Oak Drive', 'San Gabriel', 'CA', '84889', 'USA', NULL, NULL, '670-555-5906', NULL, NULL, NULL, 'www.ecoffey-swintmachinerypartners.com', NULL, NULL, NULL, NULL, '1278 Holly Oak Drive', 'San Gabriel', 'CA', '84889', 'USA', 0);
INSERT INTO accounts VALUES ('13732b70-8431-4e65-826e-438dfbc8b6b9', '2005-11-30 19:21:36', '2005-11-30 19:21:36', '1', 'sarah_id', '1', 'J & K Slattengren Communications Corp', NULL, 'Supply', 'Communications', NULL, NULL, '3974 Diver Way', 'Lakewood', 'CA', '53166', 'USA', NULL, NULL, '872-555-6146', NULL, NULL, NULL, 'www.jkslattengrencommunicationscorp.com', NULL, NULL, NULL, NULL, '3974 Diver Way', 'Lakewood', 'CA', '53166', 'USA', 0);
INSERT INTO accounts VALUES ('6c574e51-9fc9-902c-bb97-438dfb3d4859', '2005-11-30 19:21:36', '2005-11-30 19:21:36', '1', 'sally_id', '1', 'Slattengren-Heymsfield Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '2305 Ravenwood Drive', 'Victoria', 'BC', '28062', 'Canada', NULL, NULL, '991-555-2381', NULL, NULL, NULL, 'www.slattengren-heymsfieldconstruction,ltd.com', NULL, NULL, NULL, NULL, '2305 Ravenwood Drive', 'Victoria', 'BC', '28062', 'Canada', 0);
INSERT INTO accounts VALUES ('c76da14e-ad51-81c1-dc28-438dfb72b7c5', '2005-11-30 19:21:36', '2005-11-30 19:21:36', '1', 'max_id', '1', 'W & W Whitehead Electronics Associates', NULL, 'Supply', 'Electronics', NULL, NULL, '5255 Corte Valencia', 'Santa Cruz', 'CA', '61500', 'USA', NULL, NULL, '625-555-9674', NULL, NULL, NULL, 'www.wwwhiteheadelectronicsassociates.com', NULL, NULL, NULL, NULL, '5255 Corte Valencia', 'Santa Cruz', 'CA', '61500', 'USA', 0);
INSERT INTO accounts VALUES ('3644006f-4f8d-5c21-276a-438dfb9dcb96', '2005-11-30 19:21:37', '2005-11-30 19:21:37', '1', 'max_id', '1', 'Whitehead-Roy Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '3841 Frisbie Ct', 'Pomona', 'CA', '83049', 'USA', NULL, NULL, '106-555-8196', NULL, NULL, NULL, 'www.whitehead-roymachinerygroup.com', NULL, NULL, NULL, NULL, '3841 Frisbie Ct', 'Pomona', 'CA', '83049', 'USA', 0);
INSERT INTO accounts VALUES ('4812da65-b53f-1751-8610-438dfbb4962b', '2005-11-30 19:21:37', '2005-11-30 19:21:37', '1', 'beth_id', '1', 'D & G Burkhardt Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '7045 Creekside Drive', 'La Cruz', 'Sinaloa', '82649', 'Mexico', NULL, NULL, '664-555-5117', NULL, NULL, NULL, 'www.dgburkhardttransportation,inc.com', NULL, NULL, NULL, NULL, '7045 Creekside Drive', 'La Cruz', 'Sinaloa', '82649', 'Mexico', 0);
INSERT INTO accounts VALUES ('a5388d7b-fcfd-a575-9e4d-438dfb967005', '2005-11-30 19:21:37', '2005-11-30 19:21:37', '1', 'matt_id', '1', 'Burkhardt-Whitney Engineering, Ltd', NULL, 'Supply', 'Engineering', NULL, NULL, '8540 Donegal Road', 'Chula Vista', 'CA', '70360', 'USA', NULL, NULL, '168-555-2267', NULL, NULL, NULL, 'www.burkhardt-whitneyengineering,ltd.com', NULL, NULL, NULL, NULL, '8540 Donegal Road', 'Chula Vista', 'CA', '70360', 'USA', 0);
INSERT INTO accounts VALUES ('c1400045-4d2d-7fdf-4a95-438dfbbc7abf', '2005-11-30 19:21:38', '2005-11-30 19:21:38', '1', 'jaime_id', '1', 'Z & L Wisnewski Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '4655 Shuey Ave', 'San Gabriel', 'CA', '36121', 'USA', NULL, NULL, '987-555-1474', NULL, NULL, NULL, 'www.zlwisnewskiconstruction,ltd.com', NULL, NULL, NULL, NULL, '4655 Shuey Ave', 'San Gabriel', 'CA', '36121', 'USA', 0);
INSERT INTO accounts VALUES ('3d28e556-d760-cce4-1c6e-438dfb740e75', '2005-11-30 19:21:38', '2005-11-30 19:21:38', '1', 'will_id', '1', 'Wisnewski-Burkhardt Transportation Group', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '6404 Del Mar Ave', 'Tixapan', 'DF', '88993', 'Mexico', NULL, NULL, '514-555-6252', NULL, NULL, NULL, 'www.wisnewski-burkhardttransportationgroup.com', NULL, NULL, NULL, NULL, '6404 Del Mar Ave', 'Tixapan', 'DF', '88993', 'Mexico', 0);
INSERT INTO accounts VALUES ('6ea925d0-f283-ae03-e457-438dfbf5c7c2', '2005-11-30 19:21:38', '2005-11-30 19:21:38', '1', 'max_id', '1', 'V & P Mcanich Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '2773 Kirkwood Dr', 'San Francisco', 'CA', '93623', 'USA', NULL, NULL, '456-555-4088', NULL, NULL, NULL, 'www.vpmcanichtransportationcorp.com', NULL, NULL, NULL, NULL, '2773 Kirkwood Dr', 'San Francisco', 'CA', '93623', 'USA', 0);
INSERT INTO accounts VALUES ('b7f0204d-c5da-0bac-fb1f-438dfbab43a1', '2005-11-30 19:21:38', '2005-11-30 19:21:38', '1', 'will_id', '1', 'Mcanich-Browning Telecommunications, Inc', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '7432 Corte Valencia', 'Redmond', 'WA', '13658', 'USA', NULL, NULL, '245-555-2152', NULL, NULL, NULL, 'www.mcanich-browningtelecommunications,inc.com', NULL, NULL, NULL, NULL, '7432 Corte Valencia', 'Redmond', 'WA', '13658', 'USA', 0);
INSERT INTO accounts VALUES ('34348439-2f14-69b5-9373-438dfb8feeee', '2005-11-30 19:21:39', '2005-11-30 19:21:39', '1', 'matt_id', '1', 'F & X Wellington Communications Partners', NULL, 'Consulting', 'Communications', NULL, NULL, '4055 Hitchcock', 'Burnaby', 'BC', '10743', 'Canada', NULL, NULL, '210-555-7617', NULL, NULL, NULL, 'www.fxwellingtoncommunicationspartners.com', NULL, NULL, NULL, NULL, '4055 Hitchcock', 'Burnaby', 'BC', '10743', 'Canada', 0);
INSERT INTO accounts VALUES ('647cf0ab-fc93-d5d6-357f-438dfb507848', '2005-11-30 19:21:39', '2005-11-30 19:21:39', '1', 'sally_id', '1', 'Wellington-Bacugalupi Communications Holdings', NULL, 'Distribution', 'Communications', NULL, NULL, '1624 Carlisle Way', 'Redwood City', 'CA', '94937', 'USA', NULL, NULL, '260-555-7967', NULL, NULL, NULL, 'www.wellington-bacugalupicommunicationsholdings.com', NULL, NULL, NULL, NULL, '1624 Carlisle Way', 'Redwood City', 'CA', '94937', 'USA', 0);
INSERT INTO accounts VALUES ('c1c8000d-1b0e-79b7-b29a-438dfb14fa50', '2005-11-30 19:21:39', '2005-11-30 19:21:39', '1', 'sarah_id', '1', 'S & X Rizzi Engineering Partners', NULL, 'Distribution', 'Engineering', NULL, NULL, '8500 Pinehurst Court', 'Everett', 'WA', '31891', 'USA', NULL, NULL, '248-555-3060', NULL, NULL, NULL, 'www.sxrizziengineeringpartners.com', NULL, NULL, NULL, NULL, '8500 Pinehurst Court', 'Everett', 'WA', '31891', 'USA', 0);
INSERT INTO accounts VALUES ('135ff079-16c6-0b0b-4f55-438dfbf9fbef', '2005-11-30 19:21:40', '2005-11-30 19:21:40', '1', 'sarah_id', '1', 'Rizzi-Sotelo Transportation, Inc', NULL, 'Supply', 'Transportation', NULL, NULL, '6323 Benedict Court', 'Lincoln Acres', 'CA', '82248', 'USA', NULL, NULL, '434-555-4298', NULL, NULL, NULL, 'www.rizzi-sotelotransportation,inc.com', NULL, NULL, NULL, NULL, '6323 Benedict Court', 'Lincoln Acres', 'CA', '82248', 'USA', 0);
INSERT INTO accounts VALUES ('6e8e2660-d6e8-bb25-5cf3-438dfb4910ff', '2005-11-30 19:21:40', '2005-11-30 19:21:40', '1', 'sarah_id', '1', 'H & N Stanley Machinery Corp', NULL, 'Supply', 'Machinery', NULL, NULL, '6110 Price Lane', 'Lincoln Acres', 'CA', '84363', 'USA', NULL, NULL, '684-555-1677', NULL, NULL, NULL, 'www.hnstanleymachinerycorp.com', NULL, NULL, NULL, NULL, '6110 Price Lane', 'Lincoln Acres', 'CA', '84363', 'USA', 0);
INSERT INTO accounts VALUES ('cc37afac-d26c-7be4-dac5-438dfb6cf69d', '2005-11-30 19:21:40', '2005-11-30 19:21:40', '1', 'will_id', '1', 'Stanley-Markwood Machinery Associates', NULL, 'Supply', 'Machinery', NULL, NULL, '4187 Banbury Loop', 'Metchosin', 'BC', '74590', 'Canada', NULL, NULL, '780-555-8284', NULL, NULL, NULL, 'www.stanley-markwoodmachineryassociates.com', NULL, NULL, NULL, NULL, '4187 Banbury Loop', 'Metchosin', 'BC', '74590', 'Canada', 0);
INSERT INTO accounts VALUES ('8512079f-f956-4a23-8a37-438dfbb02101', '2005-11-30 19:21:41', '2005-11-30 19:21:41', '1', 'max_id', '1', 'G & W Valentine Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '4228 Pacheco St.', 'Beaverton', 'OR', '42866', 'USA', NULL, NULL, '392-555-7948', NULL, NULL, NULL, 'www.gwvalentinetransportation,inc.com', NULL, NULL, NULL, NULL, '4228 Pacheco St.', 'Beaverton', 'OR', '42866', 'USA', 0);
INSERT INTO accounts VALUES ('38843ba3-2413-4dcb-c56d-438dfbb925ee', '2005-11-30 19:21:41', '2005-11-30 19:21:41', '1', 'matt_id', '1', 'Valentine-Reams Machinery Corp', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '2559 Gumwood', 'Grossmont', 'CA', '25547', 'USA', NULL, NULL, '511-555-4184', NULL, NULL, NULL, 'www.valentine-reamsmachinerycorp.com', NULL, NULL, NULL, NULL, '2559 Gumwood', 'Grossmont', 'CA', '25547', 'USA', 0);
INSERT INTO accounts VALUES ('68dd5109-aad1-d62f-b4ac-438dfb484563', '2005-11-30 19:21:41', '2005-11-30 19:21:41', '1', 'beth_id', '1', 'V & B Long Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '5509 Newcastle Road', 'Portland', 'OR', '83372', 'USA', NULL, NULL, '145-555-2477', NULL, NULL, NULL, 'www.vblongtransportationholdings.com', NULL, NULL, NULL, NULL, '5509 Newcastle Road', 'Portland', 'OR', '83372', 'USA', 0);
INSERT INTO accounts VALUES ('f355358b-92a4-c9c0-9890-438dfb4cbd09', '2005-11-30 19:21:41', '2005-11-30 19:21:41', '1', 'beth_id', '1', 'Long-Olenzek Construction Company', NULL, 'Consulting', 'Construction', NULL, NULL, '6751 Yosemite Ct.', 'Burlingame', 'CA', '59223', 'USA', NULL, NULL, '526-555-9998', NULL, NULL, NULL, 'www.long-olenzekconstructioncompany.com', NULL, NULL, NULL, NULL, '6751 Yosemite Ct.', 'Burlingame', 'CA', '59223', 'USA', 0);
INSERT INTO accounts VALUES ('45676a3b-9212-eee8-5971-438dfb7f3881', '2005-11-30 19:21:42', '2005-11-30 19:21:42', '1', 'max_id', '1', 'C & A Valerio Engineering Group', NULL, 'Supply', 'Engineering', NULL, NULL, '9955 Terra Granada', 'San Jose', 'CA', '55213', 'USA', NULL, NULL, '184-555-6920', NULL, NULL, NULL, 'www.cavalerioengineeringgroup.com', NULL, NULL, NULL, NULL, '9955 Terra Granada', 'San Jose', 'CA', '55213', 'USA', 0);
INSERT INTO accounts VALUES ('785db1b9-b296-52c9-900a-438dfbeaeace', '2005-11-30 19:21:42', '2005-11-30 19:21:42', '1', 'kristen_id', '1', 'Valerio-Ahlering Construction, Ltd', NULL, 'Consulting', 'Construction', NULL, NULL, '1451 Victory Lane', 'Salem', 'OR', '92232', 'USA', NULL, NULL, '587-555-4069', NULL, NULL, NULL, 'www.valerio-ahleringconstruction,ltd.com', NULL, NULL, NULL, NULL, '1451 Victory Lane', 'Salem', 'OR', '92232', 'USA', 0);
INSERT INTO accounts VALUES ('eb362250-759c-9ba0-ae66-438dfb65e251', '2005-11-30 19:21:42', '2005-11-30 19:21:42', '1', 'chris_id', '1', 'U & S Burke Transportation, Inc', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '8811 Lombardy Lane', 'Kirkland', 'WA', '31701', 'USA', NULL, NULL, '507-555-3277', NULL, NULL, NULL, 'www.usburketransportation,inc.com', NULL, NULL, NULL, NULL, '8811 Lombardy Lane', 'Kirkland', 'WA', '31701', 'USA', 0);
INSERT INTO accounts VALUES ('27795a7a-69be-075d-3a2b-438dfb625195', '2005-11-30 19:21:43', '2005-11-30 19:21:43', '1', 'will_id', '1', 'Burke-Bates Construction Group', NULL, 'Distribution', 'Construction', NULL, NULL, '3217 Elm St', 'National City', 'CA', '11866', 'USA', NULL, NULL, '934-555-8055', NULL, NULL, NULL, 'www.burke-batesconstructiongroup.com', NULL, NULL, NULL, NULL, '3217 Elm St', 'National City', 'CA', '11866', 'USA', 0);
INSERT INTO accounts VALUES ('87412abc-b1d1-2243-4493-438dfb1387a5', '2005-11-30 19:21:43', '2005-11-30 19:21:43', '1', 'sarah_id', '1', 'N & W White Transportation Corp', NULL, 'Distribution', 'Transportation', NULL, NULL, '9584 Logan Ct', 'Lemon Grove', 'CA', '16496', 'USA', NULL, NULL, '876-555-5891', NULL, NULL, NULL, 'www.nwwhitetransportationcorp.com', NULL, NULL, NULL, NULL, '9584 Logan Ct', 'Lemon Grove', 'CA', '16496', 'USA', 0);
INSERT INTO accounts VALUES ('b7a00e4f-c220-5842-62dd-438dfb9c5da2', '2005-11-30 19:21:43', '2005-11-30 19:21:43', '1', 'matt_id', '1', 'White-Simpson Engineering Partners', NULL, 'Supply', 'Engineering', NULL, NULL, '1589 Mt. Tamalpais Place', 'San Francisco', 'CA', '35530', 'USA', NULL, NULL, '664-555-3955', NULL, NULL, NULL, 'www.white-simpsonengineeringpartners.com', NULL, NULL, NULL, NULL, '1589 Mt. Tamalpais Place', 'San Francisco', 'CA', '35530', 'USA', 0);
INSERT INTO accounts VALUES ('abf606cb-985d-df3b-31d3-438dfb244337', '2005-11-30 19:21:44', '2005-11-30 19:21:44', '1', 'sarah_id', '1', 'O & D Jones Communications Associates', NULL, 'Distribution', 'Communications', NULL, NULL, '867 La Orinda Place', 'Lincoln Acres', 'CA', '63222', 'USA', NULL, NULL, '334-555-9132', NULL, NULL, NULL, 'www.odjonescommunicationsassociates.com', NULL, NULL, NULL, NULL, '867 La Orinda Place', 'Lincoln Acres', 'CA', '63222', 'USA', 0);
INSERT INTO accounts VALUES ('3b08a4cf-21d7-9a7b-a902-438dfb3bb829', '2005-11-30 19:21:44', '2005-11-30 19:21:44', '1', 'sally_id', '1', 'Jones-Casts Transportation Company', NULL, 'Consulting', 'Transportation', NULL, NULL, '5780 Conifer Terrace', 'Royal Oak', 'BC', '90517', 'Canada', NULL, NULL, '146-555-5825', NULL, NULL, NULL, 'www.jones-caststransportationcompany.com', NULL, NULL, NULL, NULL, '5780 Conifer Terrace', 'Royal Oak', 'BC', '90517', 'Canada', 0);
INSERT INTO accounts VALUES ('9b38016e-c8c4-fd77-e640-438dfba26384', '2005-11-30 19:21:44', '2005-11-30 19:21:44', '1', 'sally_id', '1', 'M & Y Browqett Communications, Ltd', NULL, 'Supply', 'Communications', NULL, NULL, '5312 Riverwood Circle', 'Acapulco', 'Guerrero', '27471', 'Mexico', NULL, NULL, '373-555-4575', NULL, NULL, NULL, 'www.mybrowqettcommunications,ltd.com', NULL, NULL, NULL, NULL, '5312 Riverwood Circle', 'Acapulco', 'Guerrero', '27471', 'Mexico', 0);
INSERT INTO accounts VALUES ('cb9c933f-85ae-e605-63f7-438dfbe24a0b', '2005-11-30 19:21:44', '2005-11-30 19:21:44', '1', 'beth_id', '1', 'Browqett-Kartz Communications Associates', NULL, 'Consulting', 'Communications', NULL, NULL, '480 C Kenwal Rd', 'Arcadia', 'CA', '77828', 'USA', NULL, NULL, '207-555-8896', NULL, NULL, NULL, 'www.browqett-kartzcommunicationsassociates.com', NULL, NULL, NULL, NULL, '480 C Kenwal Rd', 'Arcadia', 'CA', '77828', 'USA', 0);
INSERT INTO accounts VALUES ('79380c9a-6503-7414-02f4-438dfbd217e4', '2005-11-30 19:21:45', '2005-11-30 19:21:45', '1', 'max_id', '1', 'B & D Wold Machinery Partners', NULL, 'Consulting', 'Machinery', NULL, NULL, '267 Aspen Drive', 'Arcadia', 'CA', '79943', 'USA', NULL, NULL, '457-555-6275', NULL, NULL, NULL, 'www.bdwoldmachinerypartners.com', NULL, NULL, NULL, NULL, '267 Aspen Drive', 'Arcadia', 'CA', '79943', 'USA', 0);
INSERT INTO accounts VALUES ('37b7f271-1f25-cd1f-44bc-438dfbf47e45', '2005-11-30 19:21:45', '2005-11-30 19:21:45', '1', 'sarah_id', '1', 'Wold-French Construction Partners', NULL, 'Manufacturing', 'Construction', NULL, NULL, '8343 Briowes Valley Rd', 'Mill Valley', 'CA', '96461', 'USA', NULL, NULL, '553-555-3882', NULL, NULL, NULL, 'www.wold-frenchconstructionpartners.com', NULL, NULL, NULL, NULL, '8343 Briowes Valley Rd', 'Mill Valley', 'CA', '96461', 'USA', 0);
INSERT INTO accounts VALUES ('af580786-dc85-f4b7-3643-438dfb894439', '2005-11-30 19:21:45', '2005-11-30 19:21:45', '1', 'kristen_id', '1', 'H & E Pederson Machinery Group', NULL, 'Supply', 'Machinery', NULL, NULL, '8384 Potomac Drive', 'Sedro Woolley', 'WA', '64738', 'USA', NULL, NULL, '165-555-3546', NULL, NULL, NULL, 'www.hepedersonmachinerygroup.com', NULL, NULL, NULL, NULL, '8384 Potomac Drive', 'Sedro Woolley', 'WA', '64738', 'USA', 0);
INSERT INTO accounts VALUES ('3124580f-664b-4103-ef3e-438dfb1904b1', '2005-11-30 19:21:46', '2005-11-30 19:21:46', '1', 'beth_id', '1', 'Pederson-Renn Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '9371 Corte Del Sol', 'Downey', 'CA', '21127', 'USA', NULL, NULL, '284-555-8782', NULL, NULL, NULL, 'www.pederson-rennelectronicsholdings.com', NULL, NULL, NULL, NULL, '9371 Corte Del Sol', 'Downey', 'CA', '21127', 'USA', 0);
INSERT INTO accounts VALUES ('6196bb05-c4fe-c086-55ca-438dfbe61361', '2005-11-30 19:21:46', '2005-11-30 19:21:46', '1', 'max_id', '1', 'X & M Catalano Construction Corp', NULL, 'Manufacturing', 'Construction', NULL, NULL, '9665 Pamploma Ct.', 'Kirkland', 'WA', '54564', 'USA', NULL, NULL, '819-555-7075', NULL, NULL, NULL, 'www.xmcatalanoconstructioncorp.com', NULL, NULL, NULL, NULL, '9665 Pamploma Ct.', 'Kirkland', 'WA', '54564', 'USA', 0);
INSERT INTO accounts VALUES ('94482729-93a9-c5c2-ac96-438dfb62fd32', '2005-11-30 19:21:46', '2005-11-30 19:21:46', '1', 'sally_id', '1', 'Catalano-Coleman Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '907 Ameno Road', 'Tacoma', 'WA', '46592', 'USA', NULL, NULL, '300-555-5596', NULL, NULL, NULL, 'www.catalano-colemantelecommunications,ltd.com', NULL, NULL, NULL, NULL, '907 Ameno Road', 'Tacoma', 'WA', '46592', 'USA', 0);
INSERT INTO accounts VALUES ('f34f0288-6e50-49a1-3087-438dfb21818a', '2005-11-30 19:21:46', '2005-11-30 19:21:46', '1', 'chris_id', '1', 'I & M Hurkett Transportation, Ltd', NULL, 'Supply', 'Transportation', NULL, NULL, '4111 Vista Diablo', 'San Gabriel', 'CA', '19899', 'USA', NULL, NULL, '857-555-2517', NULL, NULL, NULL, 'www.imhurketttransportation,ltd.com', NULL, NULL, NULL, NULL, '4111 Vista Diablo', 'San Gabriel', 'CA', '19899', 'USA', 0);
INSERT INTO accounts VALUES ('46af97b1-278e-a1b7-6f9a-438dfb57c0ec', '2005-11-30 19:21:47', '2005-11-30 19:21:47', '1', 'will_id', '1', 'Hurkett-Pettengill Electronics Corp', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '5607 Willow Creek Ct.', 'Berkeley', 'CA', '33902', 'USA', NULL, NULL, '361-555-8667', NULL, NULL, NULL, 'www.hurkett-pettengillelectronicscorp.com', NULL, NULL, NULL, NULL, '5607 Willow Creek Ct.', 'Berkeley', 'CA', '33902', 'USA', 0);
INSERT INTO accounts VALUES ('91606de9-ecc7-35f6-9f44-438dfb189f7d', '2005-11-30 19:21:47', '2005-11-30 19:21:47', '1', 'kristen_id', '1', 'H & Y Elson Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '1721 Dianda', 'Walla Walla', 'WA', '72371', 'USA', NULL, NULL, '393-555-1135', NULL, NULL, NULL, 'www.hyelsonengineering,inc.com', NULL, NULL, NULL, NULL, '1721 Dianda', 'Walla Walla', 'WA', '72371', 'USA', 0);
INSERT INTO accounts VALUES ('d95a7a99-170c-499e-428e-438dfb361dce', '2005-11-30 19:21:47', '2005-11-30 19:21:47', '1', 'jaime_id', '1', 'Elson-Hirota Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '3471 West Ste. Michelle', 'Richmond', 'CA', '26244', 'USA', NULL, NULL, '819-555-5913', NULL, NULL, NULL, 'www.elson-hirotatelecommunications,ltd.com', NULL, NULL, NULL, NULL, '3471 West Ste. Michelle', 'Richmond', 'CA', '26244', 'USA', 0);
INSERT INTO accounts VALUES ('7427f840-c2c9-d834-f101-438dfb56c870', '2005-11-30 19:21:48', '2005-11-30 19:21:48', '1', 'sally_id', '1', 'D & A Blasingame Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '9838 Carob Way', 'Mill Valley', 'CA', '57166', 'USA', NULL, NULL, '762-555-3749', NULL, NULL, NULL, 'www.dablasingamemachinerygroup.com', NULL, NULL, NULL, NULL, '9838 Carob Way', 'Mill Valley', 'CA', '57166', 'USA', 0);
INSERT INTO accounts VALUES ('a6d286c3-ebd0-936e-7eda-438dfbc6f7fe', '2005-11-30 19:21:48', '2005-11-30 19:21:48', '1', 'max_id', '1', 'Blasingame-Blackwell Construction Associates', NULL, 'Consulting', 'Construction', NULL, NULL, '4498 Dennis Circle', 'Lakewood', 'CA', '76200', 'USA', NULL, NULL, '550-555-1813', NULL, NULL, NULL, 'www.blasingame-blackwellconstructionassociates.com', NULL, NULL, NULL, NULL, '4498 Dennis Circle', 'Lakewood', 'CA', '76200', 'USA', 0);
INSERT INTO accounts VALUES ('d8298c3a-2e00-563b-0bae-438dfb77a99a', '2005-11-30 19:21:48', '2005-11-30 19:21:48', '1', 'max_id', '1', 'D & Z Moya Electronics, Ltd', NULL, 'Consulting', 'Electronics', NULL, NULL, '1121 Boynton Avenue', 'Issaquah', 'WA', '46992', 'USA', NULL, NULL, '754-555-1935', NULL, NULL, NULL, 'www.dzmoyaelectronics,ltd.com', NULL, NULL, NULL, NULL, '1121 Boynton Avenue', 'Issaquah', 'WA', '46992', 'USA', 0);
INSERT INTO accounts VALUES ('2e58254c-eae7-84c9-3019-438dfba6f7c4', '2005-11-30 19:21:49', '2005-11-30 19:21:49', '1', 'kristen_id', '1', 'Moya-Chesnut Engineering Corp', NULL, 'Consulting', 'Engineering', NULL, NULL, '6034 Sunset Circle', 'Marysville', 'WA', '32188', 'USA', NULL, NULL, '566-555-7627', NULL, NULL, NULL, 'www.moya-chesnutengineeringcorp.com', NULL, NULL, NULL, NULL, '6034 Sunset Circle', 'Marysville', 'WA', '32188', 'USA', 0);
INSERT INTO accounts VALUES ('79453030-58ba-a4c2-fb42-438dfb5babf3', '2005-11-30 19:21:49', '2005-11-30 19:21:49', '1', 'will_id', '1', 'Q & Q Ortiz Telecommunications Associates', NULL, 'Supply', 'Telecommunications', NULL, NULL, '5566 Brook Way', 'Lincoln Acres', 'CA', '68141', 'USA', NULL, NULL, '793-555-6377', NULL, NULL, NULL, 'www.qqortiztelecommunicationsassociates.com', NULL, NULL, NULL, NULL, '5566 Brook Way', 'Lincoln Acres', 'CA', '68141', 'USA', 0);
INSERT INTO accounts VALUES ('c16881fb-499b-da86-1ad4-438dfb189086', '2005-11-30 19:21:49', '2005-11-30 19:21:49', '1', 'max_id', '1', 'Ortiz-Tearpak Engineering Company', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '734 Selena Court', 'Woodland Hills', 'CA', '19499', 'USA', NULL, NULL, '627-555-1699', NULL, NULL, NULL, 'www.ortiz-tearpakengineeringcompany.com', NULL, NULL, NULL, NULL, '734 Selena Court', 'Woodland Hills', 'CA', '19499', 'USA', 0);
INSERT INTO accounts VALUES ('f18bc447-43c2-7a4c-76a4-438dfb3b6210', '2005-11-30 19:21:49', '2005-11-30 19:21:49', '1', 'matt_id', '1', 'Y & R Hall Machinery, Inc', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '521 Red Leaf Way', 'La Jolla', 'CA', '21614', 'USA', NULL, NULL, '877-555-8077', NULL, NULL, NULL, 'www.yrhallmachinery,inc.com', NULL, NULL, NULL, NULL, '521 Red Leaf Way', 'La Jolla', 'CA', '21614', 'USA', 0);
INSERT INTO accounts VALUES ('2d6eeb58-8ed8-ffa5-00c1-438dfb302163', '2005-11-30 19:21:50', '2005-11-30 19:21:50', '1', 'sarah_id', '1', 'Hall-Narberes Engineering, Inc', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '8597 Sandra', 'Long Beach', 'CA', '38132', 'USA', NULL, NULL, '312-555-9342', NULL, NULL, NULL, 'www.hall-narberesengineering,inc.com', NULL, NULL, NULL, NULL, '8597 Sandra', 'Long Beach', 'CA', '38132', 'USA', 0);
INSERT INTO accounts VALUES ('aa07e3e9-14d4-7ea5-0364-438dfb423b85', '2005-11-30 19:21:50', '2005-11-30 19:21:50', '1', 'kristen_id', '1', 'E & F Weber Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '1294 Golden Rain Road', 'Richmond', 'BC', '79116', 'Canada', NULL, NULL, '585-555-5349', NULL, NULL, NULL, 'www.efwebermachinery,ltd.com', NULL, NULL, NULL, NULL, '1294 Golden Rain Road', 'Richmond', 'BC', '79116', 'Canada', 0);
INSERT INTO accounts VALUES ('dc32d1a7-baa7-4ddc-ad19-438dfb2b4fd8', '2005-11-30 19:21:50', '2005-11-30 19:21:50', '1', 'chris_id', '1', 'Weber-Kabbes Transportation Holdings', NULL, 'Distribution', 'Transportation', NULL, NULL, '2904 Bay View Drive', 'Santa Cruz', 'CA', '61796', 'USA', NULL, NULL, '704-555-1584', NULL, NULL, NULL, 'www.weber-kabbestransportationholdings.com', NULL, NULL, NULL, NULL, '2904 Bay View Drive', 'Santa Cruz', 'CA', '61796', 'USA', 0);
INSERT INTO accounts VALUES ('4bd4969c-6b43-e0dc-efc5-438dfbfebe9b', '2005-11-30 19:21:51', '2005-11-30 19:21:51', '1', 'will_id', '1', 'N & O Townsend Electronics, Inc', NULL, 'Supply', 'Electronics', NULL, NULL, '5854 Onley Dr', 'Burien', 'WA', '95234', 'USA', NULL, NULL, '339-555-8877', NULL, NULL, NULL, 'www.notownsendelectronics,inc.com', NULL, NULL, NULL, NULL, '5854 Onley Dr', 'Burien', 'WA', '95234', 'USA', 0);
INSERT INTO accounts VALUES ('8020ee80-2bc1-61ee-2d0c-438dfb47ffc7', '2005-11-30 19:21:51', '2005-11-30 19:21:51', '1', 'kristen_id', '1', 'Townsend-Rockne Machinery Group', NULL, 'Distribution', 'Machinery', NULL, NULL, '4440 Algiers Drive', 'Downey', 'CA', '42752', 'USA', NULL, NULL, '418-555-7736', NULL, NULL, NULL, 'www.townsend-rocknemachinerygroup.com', NULL, NULL, NULL, NULL, '4440 Algiers Drive', 'Downey', 'CA', '42752', 'USA', 0);
INSERT INTO accounts VALUES ('b15df275-d23f-d4e7-5c0b-438dfb6f426e', '2005-11-30 19:21:51', '2005-11-30 19:21:51', '1', 'beth_id', '1', 'U & W Heaney Construction Corp', NULL, 'Supply', 'Construction', NULL, NULL, '301 Sandy Ln.', 'Merida', 'Yucatan', '42351', 'Mexico', NULL, NULL, '975-555-4658', NULL, NULL, NULL, 'www.uwheaneyconstructioncorp.com', NULL, NULL, NULL, NULL, '301 Sandy Ln.', 'Merida', 'Yucatan', '42351', 'Mexico', 0);
INSERT INTO accounts VALUES ('76fd063d-d3b5-5a36-cc8e-438dfbea1f29', '2005-11-30 19:21:52', '2005-11-30 19:21:52', '1', 'max_id', '1', 'Heaney-Karavites Electronics Company', NULL, 'Consulting', 'Electronics', NULL, NULL, '1796 Westbury Dr.', 'Lincoln Acres', 'CA', '30062', 'USA', NULL, NULL, '479-555-1808', NULL, NULL, NULL, 'www.heaney-karaviteselectronicscompany.com', NULL, NULL, NULL, NULL, '1796 Westbury Dr.', 'Lincoln Acres', 'CA', '30062', 'USA', 0);
INSERT INTO accounts VALUES ('509dc2bc-855f-8229-e87d-438dfb3ee35f', '2005-11-30 19:21:52', '2005-11-30 19:21:52', '1', 'chris_id', '1', 'M & K Carreras Telecommunications, Ltd', NULL, 'Supply', 'Telecommunications', NULL, NULL, '5254 Daylight Place', 'Santa Monica', 'CA', '94823', 'USA', NULL, NULL, '398-555-1015', NULL, NULL, NULL, 'www.mkcarrerastelecommunications,ltd.com', NULL, NULL, NULL, NULL, '5254 Daylight Place', 'Santa Monica', 'CA', '94823', 'USA', 0);
INSERT INTO accounts VALUES ('9cde617d-0978-99e0-4aae-438dfbc944bf', '2005-11-30 19:21:52', '2005-11-30 19:21:52', '1', 'sarah_id', '1', 'Carreras-Mendiola Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '9659 Walnut Blvd', 'Metchosin', 'BC', '48696', 'Canada', NULL, NULL, '164-555-9451', NULL, NULL, NULL, 'www.carreras-mendiolamachinery,ltd.com', NULL, NULL, NULL, NULL, '9659 Walnut Blvd', 'Metchosin', 'BC', '48696', 'Canada', 0);
INSERT INTO accounts VALUES ('b26006b3-c1e1-78bf-41e3-438dfbb3abc9', '2005-11-30 19:21:53', '2005-11-30 19:21:53', '1', 'beth_id', '1', 'L & E Trolen Communications Partners', NULL, 'Distribution', 'Communications', NULL, NULL, '3372 Via Cordona', 'Tixapan', 'DF', '53326', 'Mexico', NULL, NULL, '106-555-7287', NULL, NULL, NULL, 'www.letrolencommunicationspartners.com', NULL, NULL, NULL, NULL, '3372 Via Cordona', 'Tixapan', 'DF', '53326', 'Mexico', 0);
INSERT INTO accounts VALUES ('3b976dba-9c67-c85c-1b46-438dfb6e2b10', '2005-11-30 19:21:53', '2005-11-30 19:21:53', '1', 'sally_id', '1', 'Trolen-Vernon Construction Holdings', NULL, 'Consulting', 'Construction', NULL, NULL, '8031 Danesta Dr.', 'Grossmont', 'CA', '72360', 'USA', NULL, NULL, '556-555-1693', NULL, NULL, NULL, 'www.trolen-vernonconstructionholdings.com', NULL, NULL, NULL, NULL, '8031 Danesta Dr.', 'Grossmont', 'CA', '72360', 'USA', 0);
INSERT INTO accounts VALUES ('87997809-5094-024a-2814-438dfbaf7d3e', '2005-11-30 19:21:53', '2005-11-30 19:21:53', '1', 'kristen_id', '1', 'W & N Lynn Telecommunications Partners', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '4654 Blackridge Drive', 'Pomona', 'CA', '69444', 'USA', NULL, NULL, '760-555-1815', NULL, NULL, NULL, 'www.wnlynntelecommunicationspartners.com', NULL, NULL, NULL, NULL, '4654 Blackridge Drive', 'Pomona', 'CA', '69444', 'USA', 0);
INSERT INTO accounts VALUES ('b7f3e4ed-f834-8e31-5f4d-438dfb359ed2', '2005-11-30 19:21:53', '2005-11-30 19:21:53', '1', 'sally_id', '1', 'Lynn-Cavendish Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '2223 Stillwater Court', 'Burlingame', 'CA', '54640', 'USA', NULL, NULL, '571-555-7508', NULL, NULL, NULL, 'www.lynn-cavendishtransportationholdings.com', NULL, NULL, NULL, NULL, '2223 Stillwater Court', 'Burlingame', 'CA', '54640', 'USA', 0);
INSERT INTO accounts VALUES ('e8e59f02-1eed-27d0-6d7e-438dfba9d868', '2005-11-30 19:21:53', '2005-11-30 19:21:53', '1', 'beth_id', '1', 'V & A Baltazar Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '9099 Bonifacio St', 'Anacortes', 'WA', '90593', 'USA', NULL, NULL, '798-555-6258', NULL, NULL, NULL, 'www.vabaltazartransportationcorp.com', NULL, NULL, NULL, NULL, '9099 Bonifacio St', 'Anacortes', 'WA', '90593', 'USA', 0);
INSERT INTO accounts VALUES ('71c71ca8-8151-f6db-5da4-438dfb255755', '2005-11-30 19:21:54', '2005-11-30 19:21:54', '1', 'max_id', '1', 'Baltazar-Higgs Communications Corp', NULL, 'Consulting', 'Communications', NULL, NULL, '6922 Estudello', 'Cliffside', 'BC', '41951', 'Canada', NULL, NULL, '633-555-1579', NULL, NULL, NULL, 'www.baltazar-higgscommunicationscorp.com', NULL, NULL, NULL, NULL, '6922 Estudello', 'Cliffside', 'BC', '41951', 'Canada', 0);
INSERT INTO accounts VALUES ('a4a3717a-c2d5-691b-c4e2-438dfbb87573', '2005-11-30 19:21:54', '2005-11-30 19:21:54', '1', 'sally_id', '1', 'T & A Demott Jr Electronics, Inc', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '6709 Prestwick Ave', 'Langford', 'BC', '44066', 'Canada', NULL, NULL, '222-555-2615', NULL, NULL, NULL, 'www.tademottjrelectronics,inc.com', NULL, NULL, NULL, NULL, '6709 Prestwick Ave', 'Langford', 'BC', '44066', 'Canada', 0);
INSERT INTO accounts VALUES ('eeaabf09-d964-c5dc-639d-438dfbccad87', '2005-11-30 19:21:54', '2005-11-30 19:21:54', '1', 'matt_id', '1', 'Demott Jr-Carmichael Construction Associates', NULL, 'Manufacturing', 'Construction', NULL, NULL, '4786 Salvio St.', 'Yakima', 'WA', '34292', 'USA', NULL, NULL, '318-555-9222', NULL, NULL, NULL, 'www.demottjr-carmichaelconstructionassociates.com', NULL, NULL, NULL, NULL, '4786 Salvio St.', 'Yakima', 'WA', '34292', 'USA', 0);
INSERT INTO accounts VALUES ('449cf514-d107-bf13-e22d-438dfb6346c5', '2005-11-30 19:21:55', '2005-11-30 19:21:55', '1', 'chris_id', '1', 'D & D Montera Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '4827 Gilardy Drive', 'Milwaukie', 'OR', '25692', 'USA', NULL, NULL, '703-555-7489', NULL, NULL, NULL, 'www.ddmonteraelectronicsholdings.com', NULL, NULL, NULL, NULL, '4827 Gilardy Drive', 'Milwaukie', 'OR', '25692', 'USA', 0);
INSERT INTO accounts VALUES ('9160e67c-7f47-05f8-1b62-438dfbb654a6', '2005-11-30 19:21:55', '2005-11-30 19:21:55', '1', 'sarah_id', '1', 'Montera-Ciochon Machinery, Inc', NULL, 'Distribution', 'Machinery', NULL, NULL, '3158 B Avenue I', 'Imperial Beach', 'CA', '84248', 'USA', NULL, NULL, '161-555-7382', NULL, NULL, NULL, 'www.montera-ciochonmachinery,inc.com', NULL, NULL, NULL, NULL, '3158 B Avenue I', 'Imperial Beach', 'CA', '84248', 'USA', 0);
INSERT INTO accounts VALUES ('35b9c4e3-e670-d12b-dc94-438dfb3c3e70', '2005-11-30 19:21:56', '2005-11-30 19:21:56', '1', 'sally_id', '1', 'I & V Anderson Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '6108 Estudello St.', 'Ballard', 'WA', '91394', 'USA', NULL, NULL, '456-555-2018', NULL, NULL, NULL, 'www.ivandersonengineering,inc.com', NULL, NULL, NULL, NULL, '6108 Estudello St.', 'Ballard', 'WA', '91394', 'USA', 0);
INSERT INTO accounts VALUES ('660a9106-4c87-1508-c45b-438dfb157396', '2005-11-30 19:21:56', '2005-11-30 19:21:56', '1', 'beth_id', '1', 'Anderson-Allen Construction, Ltd', NULL, 'Manufacturing', 'Construction', NULL, NULL, '7350 Pinon', 'Santa Cruz', 'CA', '40236', 'USA', NULL, NULL, '837-555-9539', NULL, NULL, NULL, 'www.anderson-allenconstruction,ltd.com', NULL, NULL, NULL, NULL, '7350 Pinon', 'Santa Cruz', 'CA', '40236', 'USA', 0);
INSERT INTO accounts VALUES ('b2fe2a8c-729b-82ff-875d-438dfb786209', '2005-11-30 19:21:56', '2005-11-30 19:21:56', '1', 'matt_id', '1', 'K & R Bidelman Communications Group', NULL, 'Consulting', 'Communications', NULL, NULL, '555 Moretti Drive', 'Oakland', 'CA', '32052', 'USA', NULL, NULL, '495-555-6460', NULL, NULL, NULL, 'www.krbidelmancommunicationsgroup.com', NULL, NULL, NULL, NULL, '555 Moretti Drive', 'Oakland', 'CA', '32052', 'USA', 0);
INSERT INTO accounts VALUES ('23b45f1c-189f-1aff-e722-438dfbd23fb4', '2005-11-30 19:21:57', '2005-11-30 19:21:57', '1', 'jaime_id', '1', 'Bidelman-Gee Engineering Associates', NULL, 'Distribution', 'Engineering', NULL, NULL, '2050 Glazier Dr', 'Issaquah', 'WA', '19763', 'USA', NULL, NULL, '238-555-7268', NULL, NULL, NULL, 'www.bidelman-geeengineeringassociates.com', NULL, NULL, NULL, NULL, '2050 Glazier Dr', 'Issaquah', 'WA', '19763', 'USA', 0);
INSERT INTO accounts VALUES ('a594ad62-21e6-fe38-3ac1-438dfb6ab474', '2005-11-30 19:21:57', '2005-11-30 19:21:57', '1', 'max_id', '1', 'B & P Breer Telecommunications Holdings', NULL, 'Distribution', 'Telecommunications', NULL, NULL, '5508 Trembath Court', 'West Covina', 'CA', '58231', 'USA', NULL, NULL, '818-555-2818', NULL, NULL, NULL, 'www.bpbreertelecommunicationsholdings.com', NULL, NULL, NULL, NULL, '5508 Trembath Court', 'West Covina', 'CA', '58231', 'USA', 0);
INSERT INTO accounts VALUES ('f054b6dd-897a-65d2-95ef-438dfb80f3f6', '2005-11-30 19:21:57', '2005-11-30 19:21:57', '1', 'kristen_id', '1', 'Breer-Barrera Electronics, Ltd', NULL, 'Distribution', 'Electronics', NULL, NULL, '9913 Mt. Whitney Way', 'San Diego', 'CA', '38396', 'USA', NULL, NULL, '584-555-2254', NULL, NULL, NULL, 'www.breer-barreraelectronics,ltd.com', NULL, NULL, NULL, NULL, '9913 Mt. Whitney Way', 'San Diego', 'CA', '38396', 'USA', 0);
INSERT INTO accounts VALUES ('2c8ed1d1-6cc4-05df-84d8-438dfbb6eb82', '2005-11-30 19:21:58', '2005-11-30 19:21:58', '1', 'chris_id', '1', 'Q & P Banack Telecommunications Company', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, '6282 McNeil Place', 'National City', 'CA', '43027', 'USA', NULL, NULL, '526-555-9089', NULL, NULL, NULL, 'www.qpbanacktelecommunicationscompany.com', NULL, NULL, NULL, NULL, '6282 McNeil Place', 'National City', 'CA', '43027', 'USA', 0);
INSERT INTO accounts VALUES ('60211e94-e474-918e-8c77-438dfb92d148', '2005-11-30 19:21:58', '2005-11-30 19:21:58', '1', 'beth_id', '1', 'Banack-Dean Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '941 Tosco Way', 'Tixapan', 'DF', '62060', 'Mexico', NULL, NULL, '315-555-7154', NULL, NULL, NULL, 'www.banack-deantransportationholdings.com', NULL, NULL, NULL, NULL, '941 Tosco Way', 'Tixapan', 'DF', '62060', 'Mexico', 0);
INSERT INTO accounts VALUES ('95939537-69ed-0569-349e-438dfb51b14d', '2005-11-30 19:21:58', '2005-11-30 19:21:58', '1', 'kristen_id', '1', 'G & N Thompson Communications Group', NULL, 'Supply', 'Communications', NULL, NULL, '7563 Florencia', 'Lebanon', 'OR', '32853', 'USA', NULL, NULL, '280-555-3618', NULL, NULL, NULL, 'www.gnthompsoncommunicationsgroup.com', NULL, NULL, NULL, NULL, '7563 Florencia', 'Lebanon', 'OR', '32853', 'USA', 0);
INSERT INTO accounts VALUES ('22fda997-049c-6ff8-d2ac-438dfb8b8fe1', '2005-11-30 19:21:59', '2005-11-30 19:21:59', '1', 'kristen_id', '1', 'Thompson-Stevens Construction Partners', NULL, 'Distribution', 'Construction', NULL, NULL, '2477 MacAlven Drive', 'Burbank', 'CA', '18048', 'USA', NULL, NULL, '991-555-9310', NULL, NULL, NULL, 'www.thompson-stevensconstructionpartners.com', NULL, NULL, NULL, NULL, '2477 MacAlven Drive', 'Burbank', 'CA', '18048', 'USA', 0);
INSERT INTO accounts VALUES ('530cf751-bc28-78f8-9727-438dfbc5fce0', '2005-11-30 19:21:59', '2005-11-30 19:21:59', '1', 'kristen_id', '1', 'H & Y Davis Electronics, Ltd', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '2009 San Marino', 'Orizaba', 'Veracruz', '54001', 'Mexico', NULL, NULL, '908-555-8635', NULL, NULL, NULL, 'www.hydaviselectronics,ltd.com', NULL, NULL, NULL, NULL, '2009 San Marino', 'Orizaba', 'Veracruz', '54001', 'Mexico', 0);
INSERT INTO accounts VALUES ('8606d7b7-fb12-5bc8-fcc8-438dfb8c13a6', '2005-11-30 19:21:59', '2005-11-30 19:21:59', '1', 'chris_id', '1', 'Davis-Westgaard Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '7176 Chatworth', 'Bremerton', 'WA', '53592', 'USA', NULL, NULL, '982-555-7614', NULL, NULL, NULL, 'www.davis-westgaardtransportationholdings.com', NULL, NULL, NULL, NULL, '7176 Chatworth', 'Bremerton', 'WA', '53592', 'USA', 0);
INSERT INTO accounts VALUES ('ec620ae9-1b97-e528-2707-438dfb142f20', '2005-11-30 19:21:59', '2005-11-30 19:21:59', '1', 'sarah_id', '1', 'O & K Agcaoili Transportation Corp', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '6963 Grand View Avenue', 'Bremerton', 'WA', '74743', 'USA', NULL, NULL, '332-555-4993', NULL, NULL, NULL, 'www.okagcaoilitransportationcorp.com', NULL, NULL, NULL, NULL, '6963 Grand View Avenue', 'Bremerton', 'WA', '74743', 'USA', 0);
INSERT INTO accounts VALUES ('44567144-d98c-55ff-600a-438dfb9b05e7', '2005-11-30 19:22:00', '2005-11-30 19:22:00', '1', 'beth_id', '1', 'Agcaoili-Sabella Construction Partners', NULL, 'Consulting', 'Construction', NULL, NULL, '8942 Sierra Road', 'Woodland Hills', 'CA', '23993', 'USA', NULL, NULL, '428-555-2600', NULL, NULL, NULL, 'www.agcaoili-sabellaconstructionpartners.com', NULL, NULL, NULL, NULL, '8942 Sierra Road', 'Woodland Hills', 'CA', '23993', 'USA', 0);
INSERT INTO accounts VALUES ('ad9d4f16-4948-5b22-c2a5-438dfb42471c', '2005-11-30 19:22:00', '2005-11-30 19:22:00', '1', 'sally_id', '1', 'D & D Vanderlinden Transportation, Ltd', NULL, 'Distribution', 'Transportation', NULL, NULL, '8983 Haynes Court', 'Metchosin', 'BC', '91268', 'Canada', NULL, NULL, '701-555-7607', NULL, NULL, NULL, 'www.ddvanderlindentransportation,ltd.com', NULL, NULL, NULL, NULL, '8983 Haynes Court', 'Metchosin', 'BC', '91268', 'Canada', 0);
INSERT INTO accounts VALUES ('ddbbf86c-83d1-1323-7353-438dfb2cde8e', '2005-11-30 19:22:00', '2005-11-30 19:22:00', '1', 'kristen_id', '1', 'Vanderlinden-Virden Machinery, Inc', NULL, 'Consulting', 'Machinery', NULL, NULL, '9970 Loma Linda', 'Edmonds', 'WA', '47657', 'USA', NULL, NULL, '159-555-7500', NULL, NULL, NULL, 'www.vanderlinden-virdenmachinery,inc.com', NULL, NULL, NULL, NULL, '9970 Loma Linda', 'Edmonds', 'WA', '47657', 'USA', 0);
INSERT INTO accounts VALUES ('50f592cd-46e8-38ec-8bc4-438dfb69255a', '2005-11-30 19:22:01', '2005-11-30 19:22:01', '1', 'beth_id', '1', 'E & M Spencer Electronics Company', NULL, 'Supply', 'Electronics', NULL, NULL, '2921 Glen Wood Drive', 'Walla Walla', 'WA', '81094', 'USA', NULL, NULL, '454-555-2135', NULL, NULL, NULL, 'www.emspencerelectronicscompany.com', NULL, NULL, NULL, NULL, '2921 Glen Wood Drive', 'Walla Walla', 'WA', '81094', 'USA', 0);
INSERT INTO accounts VALUES ('83ebac8d-3061-b06e-e9c2-438dfbc1c1b7', '2005-11-30 19:22:01', '2005-11-30 19:22:01', '1', 'matt_id', '1', 'Spencer-Castellucio Engineering, Ltd', NULL, 'Distribution', 'Engineering', NULL, NULL, '1506 River Rock Lane', 'Santa Anita', 'DF', '36454', 'Mexico', NULL, NULL, '835-555-9657', NULL, NULL, NULL, 'www.spencer-castellucioengineering,ltd.com', NULL, NULL, NULL, NULL, '1506 River Rock Lane', 'Santa Anita', 'DF', '36454', 'Mexico', 0);
INSERT INTO accounts VALUES ('cfae570c-8617-1ed0-9552-438dfbbed9a1', '2005-11-30 19:22:01', '2005-11-30 19:22:01', '1', 'matt_id', '1', 'R & Z Zugelder Communications, Inc', NULL, 'Distribution', 'Communications', NULL, NULL, '4710 Northridge Drive', 'Port Orchard', 'WA', '53924', 'USA', NULL, NULL, '732-555-1236', NULL, NULL, NULL, 'www.rzzugeldercommunications,inc.com', NULL, NULL, NULL, NULL, '4710 Northridge Drive', 'Port Orchard', 'WA', '53924', 'USA', 0);
INSERT INTO accounts VALUES ('bd2e0f70-1ee0-114b-6b3f-438dfb7beaca', '2005-11-30 19:22:02', '2005-11-30 19:22:02', '1', 'chris_id', '1', 'Zugelder-Malmendier Machinery Partners', NULL, 'Supply', 'Machinery', NULL, NULL, '6206 Heavenly Drive', 'West Covina', 'CA', '41635', 'USA', NULL, NULL, '236-555-7386', NULL, NULL, NULL, 'www.zugelder-malmendiermachinerypartners.com', NULL, NULL, NULL, NULL, '6206 Heavenly Drive', 'West Covina', 'CA', '41635', 'USA', 0);
INSERT INTO accounts VALUES ('73d068dc-4ebc-f503-320a-438dfbbe3b7e', '2005-11-30 19:22:02', '2005-11-30 19:22:02', '1', 'sarah_id', '1', 'J & K Farrell Communications Corp', NULL, 'Supply', 'Communications', NULL, NULL, '2320 Wee Donegal', 'Royal Oak', 'BC', '73962', 'Canada', NULL, NULL, '816-555-2935', NULL, NULL, NULL, 'www.jkfarrellcommunicationscorp.com', NULL, NULL, NULL, NULL, '2320 Wee Donegal', 'Royal Oak', 'BC', '73962', 'Canada', 0);
INSERT INTO accounts VALUES ('c25cd6b3-3646-b570-d9c9-438dfb849f55', '2005-11-30 19:22:02', '2005-11-30 19:22:02', '1', 'sally_id', '1', 'Farrell-Ault Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '4070 Orange Street', 'Beverly Hills', 'CA', '60268', 'USA', NULL, NULL, '582-555-2371', NULL, NULL, NULL, 'www.farrell-aultconstruction,ltd.com', NULL, NULL, NULL, NULL, '4070 Orange Street', 'Beverly Hills', 'CA', '60268', 'USA', 0);
INSERT INTO accounts VALUES ('1a933345-5bdc-a589-eb6d-438dfbf1c77c', '2005-11-30 19:22:03', '2005-11-30 19:22:03', '1', 'max_id', '1', 'W & W Highfill Electronics Associates', NULL, 'Supply', 'Electronics', NULL, NULL, '438 Mt. Etna', 'Santa Monica', 'CA', '91190', 'USA', NULL, NULL, '875-555-6124', NULL, NULL, NULL, 'www.wwhighfillelectronicsassociates.com', NULL, NULL, NULL, NULL, '438 Mt. Etna', 'Santa Monica', 'CA', '91190', 'USA', 0);
INSERT INTO accounts VALUES ('4ab47181-24ce-f863-8995-438dfb35ea06', '2005-11-30 19:22:03', '2005-11-30 19:22:03', '1', 'max_id', '1', 'Highfill-Waggoner Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '5097 Waterfall Way', 'San Francisco', 'CA', '11225', 'USA', NULL, NULL, '664-555-4189', NULL, NULL, NULL, 'www.highfill-waggonermachinerygroup.com', NULL, NULL, NULL, NULL, '5097 Waterfall Way', 'San Francisco', 'CA', '11225', 'USA', 0);
INSERT INTO accounts VALUES ('9ad78299-6c72-66e4-74d1-438dfb8d9bcb', '2005-11-30 19:22:03', '2005-11-30 19:22:03', '1', 'beth_id', '1', 'D & G Estes Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '1720 Medburn St', 'Burien', 'WA', '81017', 'USA', NULL, NULL, '629-555-9653', NULL, NULL, NULL, 'www.dgestestransportation,inc.com', NULL, NULL, NULL, NULL, '1720 Medburn St', 'Burien', 'WA', '81017', 'USA', 0);
INSERT INTO accounts VALUES ('e85ffc5b-c699-2dbd-c014-438dfbaf09a1', '2005-11-30 19:22:03', '2005-11-30 19:22:03', '1', 'matt_id', '1', 'Estes-Jarmillo Engineering, Ltd', NULL, 'Supply', 'Engineering', NULL, NULL, '6633 Military East', 'Camacho', 'Zacatecas', '66212', 'Mexico', NULL, NULL, '440-555-6346', NULL, NULL, NULL, 'www.estes-jarmilloengineering,ltd.com', NULL, NULL, NULL, NULL, '6633 Military East', 'Camacho', 'Zacatecas', '66212', 'Mexico', 0);
INSERT INTO accounts VALUES ('5f03bf7a-fd7e-e9a7-db69-438dfba8a354', '2005-11-30 19:22:04', '2005-11-30 19:22:04', '1', 'jaime_id', '1', 'Z & L Steele Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '6165 Silverwood Drive', 'Kirkland', 'WA', '31667', 'USA', NULL, NULL, '667-555-5096', NULL, NULL, NULL, 'www.zlsteeleconstruction,ltd.com', NULL, NULL, NULL, NULL, '6165 Silverwood Drive', 'Kirkland', 'WA', '31667', 'USA', 0);
INSERT INTO accounts VALUES ('af8cf563-7e1e-cbda-c837-438dfba030fb', '2005-11-30 19:22:04', '2005-11-30 19:22:04', '1', 'will_id', '1', 'Steele-Thompson Transportation Group', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '3989 Crestwood Circle', 'Spokane', 'WA', '53523', 'USA', NULL, NULL, '741-555-4074', NULL, NULL, NULL, 'www.steele-thompsontransportationgroup.com', NULL, NULL, NULL, NULL, '3989 Crestwood Circle', 'Spokane', 'WA', '53523', 'USA', 0);
INSERT INTO accounts VALUES ('98c806a1-600c-08bb-697c-438dfbc8eb58', '2005-11-30 19:22:05', '2005-11-30 19:22:05', '1', 'max_id', '1', 'V & P Howard Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '3775 Hilltop Dr.', 'Puyallup', 'WA', '55638', 'USA', NULL, NULL, '990-555-1453', NULL, NULL, NULL, 'www.vphowardtransportationcorp.com', NULL, NULL, NULL, NULL, '3775 Hilltop Dr.', 'Puyallup', 'WA', '55638', 'USA', 0);
INSERT INTO accounts VALUES ('571ba74f-afdf-9159-0899-438dfb3eb14d', '2005-11-30 19:22:05', '2005-11-30 19:22:05', '1', 'will_id', '1', 'Howard-Elliott Telecommunications, Inc', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '9196 Landana Dr.', 'Renton', 'WA', '45864', 'USA', NULL, NULL, '187-555-8060', NULL, NULL, NULL, 'www.howard-elliotttelecommunications,inc.com', NULL, NULL, NULL, NULL, '9196 Landana Dr.', 'Renton', 'WA', '45864', 'USA', 0);
INSERT INTO accounts VALUES ('e0418399-719d-3607-9e7f-438dfb72fae9', '2005-11-30 19:22:05', '2005-11-30 19:22:05', '1', 'matt_id', '1', 'F & X Kobylinski Communications Partners', NULL, 'Consulting', 'Communications', NULL, NULL, '1893 Argyll Ave.', 'Berkeley', 'CA', '14141', 'USA', NULL, NULL, '459-555-4067', NULL, NULL, NULL, 'www.fxkobylinskicommunicationspartners.com', NULL, NULL, NULL, NULL, '1893 Argyll Ave.', 'Berkeley', 'CA', '14141', 'USA', 0);
INSERT INTO accounts VALUES ('92ab49c9-ee9b-e5d2-43d8-438dfb969816', '2005-11-30 19:22:06', '2005-11-30 19:22:06', '1', 'sally_id', '1', 'Kobylinski-Verdad Communications Holdings', NULL, 'Distribution', 'Communications', NULL, NULL, '225 San Miguel Rd.', 'Haney', 'BC', '95821', 'Canada', NULL, NULL, '817-555-3960', NULL, NULL, NULL, 'www.kobylinski-verdadcommunicationsholdings.com', NULL, NULL, NULL, NULL, '225 San Miguel Rd.', 'Haney', 'BC', '95821', 'Canada', 0);
INSERT INTO accounts VALUES ('df7de535-ff70-7af4-cb91-438dfbc9af09', '2005-11-30 19:22:06', '2005-11-30 19:22:06', '1', 'sarah_id', '1', 'S & X Browning Engineering Partners', NULL, 'Distribution', 'Engineering', NULL, NULL, '3175 Olivera Rd.', 'Redmond', 'WA', '30259', 'USA', NULL, NULL, '452-555-2253', NULL, NULL, NULL, 'www.sxbrowningengineeringpartners.com', NULL, NULL, NULL, NULL, '3175 Olivera Rd.', 'Redmond', 'WA', '30259', 'USA', 0);
INSERT INTO accounts VALUES ('1bb1c78c-3ccd-b176-be2b-438dfb317c0e', '2005-11-30 19:22:07', '2005-11-30 19:22:07', '1', 'sarah_id', '1', 'Browning-Lyeba Transportation, Inc', NULL, 'Supply', 'Transportation', NULL, NULL, '4416 Harvard Drive', 'Santa Cruz', 'CA', '51809', 'USA', NULL, NULL, '594-555-6117', NULL, NULL, NULL, 'www.browning-lyebatransportation,inc.com', NULL, NULL, NULL, NULL, '4416 Harvard Drive', 'Santa Cruz', 'CA', '51809', 'USA', 0);
INSERT INTO accounts VALUES ('a5b8eb90-51f1-e1ff-ad22-438dfb208ceb', '2005-11-30 19:22:07', '2005-11-30 19:22:07', '1', 'sarah_id', '1', 'H & N Handley Machinery Corp', NULL, 'Supply', 'Machinery', NULL, NULL, '7620 Del Vista', 'Coronado', 'CA', '51408', 'USA', NULL, NULL, '491-555-6696', NULL, NULL, NULL, 'www.hnhandleymachinerycorp.com', NULL, NULL, NULL, NULL, '7620 Del Vista', 'Coronado', 'CA', '51408', 'USA', 0);
INSERT INTO accounts VALUES ('f2df2e86-0c13-c5ba-c500-438dfb56c033', '2005-11-30 19:22:07', '2005-11-30 19:22:07', '1', 'will_id', '1', 'Handley-Meyerhoff Machinery Associates', NULL, 'Supply', 'Machinery', NULL, NULL, '9115 Arthur Rd.', 'Fremont', 'CA', '66587', 'USA', NULL, NULL, '348-555-9684', NULL, NULL, NULL, 'www.handley-meyerhoffmachineryassociates.com', NULL, NULL, NULL, NULL, '9115 Arthur Rd.', 'Fremont', 'CA', '66587', 'USA', 0);
INSERT INTO accounts VALUES ('4c13abc6-b8e1-c1ae-8ba7-438dfb9ec64a', '2005-11-30 19:22:08', '2005-11-30 19:22:08', '1', 'max_id', '1', 'G & W Vigil Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '2574 Napa', 'Renton', 'WA', '71418', 'USA', NULL, NULL, '929-555-5234', NULL, NULL, NULL, 'www.gwvigiltransportation,inc.com', NULL, NULL, NULL, NULL, '2574 Napa', 'Renton', 'WA', '71418', 'USA', 0);
INSERT INTO accounts VALUES ('9c1b9f81-bfac-e57b-5ffe-438dfb441499', '2005-11-30 19:22:08', '2005-11-30 19:22:08', '1', 'matt_id', '1', 'Vigil-Gash Machinery Corp', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '6979 Euclid Ave.', 'Ballard', 'WA', '25291', 'USA', NULL, NULL, '694-555-4670', NULL, NULL, NULL, 'www.vigil-gashmachinerycorp.com', NULL, NULL, NULL, NULL, '6979 Euclid Ave.', 'Ballard', 'WA', '25291', 'USA', 0);
INSERT INTO accounts VALUES ('cc387178-6c46-a15a-2fe6-438dfb374c74', '2005-11-30 19:22:08', '2005-11-30 19:22:08', '1', 'beth_id', '1', 'V & B Greer Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '3348 Del Vista Court', 'Salem', 'OR', '29922', 'USA', NULL, NULL, '637-555-2505', NULL, NULL, NULL, 'www.vbgreertransportationholdings.com', NULL, NULL, NULL, NULL, '3348 Del Vista Court', 'Salem', 'OR', '29922', 'USA', 0);
INSERT INTO accounts VALUES ('268fd281-bad6-2ceb-8bbc-438dfb22fc8c', '2005-11-30 19:22:09', '2005-11-30 19:22:09', '1', 'beth_id', '1', 'Greer-Benson Construction Company', NULL, 'Consulting', 'Construction', NULL, NULL, '5351 N. Civic Dr.', 'Lemon Grove', 'CA', '48956', 'USA', NULL, NULL, '425-555-9570', NULL, NULL, NULL, 'www.greer-bensonconstructioncompany.com', NULL, NULL, NULL, NULL, '5351 N. Civic Dr.', 'Lemon Grove', 'CA', '48956', 'USA', 0);
INSERT INTO accounts VALUES ('94982e2e-3f66-9441-e92b-438dfbddd2e5', '2005-11-30 19:22:09', '2005-11-30 19:22:09', '1', 'max_id', '1', 'C & A Mitzner Engineering Group', NULL, 'Supply', 'Engineering', NULL, NULL, '4630 Concord Blvd.', 'Olympia', 'WA', '19748', 'USA', NULL, NULL, '390-555-6034', NULL, NULL, NULL, 'www.camitznerengineeringgroup.com', NULL, NULL, NULL, NULL, '4630 Concord Blvd.', 'Olympia', 'WA', '19748', 'USA', 0);
INSERT INTO accounts VALUES ('c4aedb48-1af4-dc3f-f3c7-438dfb1a48c0', '2005-11-30 19:22:09', '2005-11-30 19:22:09', '1', 'kristen_id', '1', 'Mitzner-Brooks Construction, Ltd', NULL, 'Consulting', 'Construction', NULL, NULL, '9543 West I St.', 'Beaverton', 'OR', '49447', 'USA', NULL, NULL, '202-555-2727', NULL, NULL, NULL, 'www.mitzner-brooksconstruction,ltd.com', NULL, NULL, NULL, NULL, '9543 West I St.', 'Beaverton', 'OR', '49447', 'USA', 0);
INSERT INTO accounts VALUES ('1e63f0f0-a1bb-ec9b-b3b8-438dfbc720ee', '2005-11-30 19:22:10', '2005-11-30 19:22:10', '1', 'chris_id', '1', 'U & S Hass Transportation, Inc', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '8452 Pine Hollow Rd.', 'Cliffside', 'BC', '67189', 'Canada', NULL, NULL, '429-555-1477', NULL, NULL, NULL, 'www.ushasstransportation,inc.com', NULL, NULL, NULL, NULL, '8452 Pine Hollow Rd.', 'Cliffside', 'BC', '67189', 'Canada', 0);
INSERT INTO accounts VALUES ('aa8b2195-f958-e7d7-9ddb-438dfb8ebf80', '2005-11-30 19:22:10', '2005-11-30 19:22:10', '1', 'will_id', '1', 'Hass-Netz Construction Group', NULL, 'Distribution', 'Construction', NULL, NULL, '6275 Bel Air Drive', 'Redmond', 'WA', '91253', 'USA', NULL, NULL, '502-555-9455', NULL, NULL, NULL, 'www.hass-netzconstructiongroup.com', NULL, NULL, NULL, NULL, '6275 Bel Air Drive', 'Redmond', 'WA', '91253', 'USA', 0);
INSERT INTO accounts VALUES ('daaf0fbd-ade6-d9bd-38ce-438dfbb8b158', '2005-11-30 19:22:10', '2005-11-30 19:22:10', '1', 'sarah_id', '1', 'N & W Hill Transportation Corp', NULL, 'Distribution', 'Transportation', NULL, NULL, '6062 Sudan Loop', 'Seattle', 'WA', '93368', 'USA', NULL, NULL, '752-555-6834', NULL, NULL, NULL, 'www.nwhilltransportationcorp.com', NULL, NULL, NULL, NULL, '6062 Sudan Loop', 'Seattle', 'WA', '93368', 'USA', 0);
INSERT INTO accounts VALUES ('16ede1f8-2014-d5da-74e5-438dfba39ec3', '2005-11-30 19:22:11', '2005-11-30 19:22:11', '1', 'matt_id', '1', 'Hill-Drury Engineering Partners', NULL, 'Supply', 'Engineering', NULL, NULL, '4139 Bailey Road', 'Vancouver', 'BC', '10888', 'Canada', NULL, NULL, '848-555-4441', NULL, NULL, NULL, 'www.hill-druryengineeringpartners.com', NULL, NULL, NULL, NULL, '4139 Bailey Road', 'Vancouver', 'BC', '10888', 'Canada', 0);
INSERT INTO accounts VALUES ('863ce0cb-c3b2-a2e2-3c24-438dfb60a8fd', '2005-11-30 19:22:11', '2005-11-30 19:22:11', '1', 'sarah_id', '1', 'O & D White Communications Associates', NULL, 'Distribution', 'Communications', NULL, NULL, '4180 Valley Manor', 'Lynnwood', 'WA', '78163', 'USA', NULL, NULL, '221-555-9448', NULL, NULL, NULL, 'www.odwhitecommunicationsassociates.com', NULL, NULL, NULL, NULL, '4180 Valley Manor', 'Lynnwood', 'WA', '78163', 'USA', 0);
INSERT INTO accounts VALUES ('1d21fa61-f1ec-b3c3-108d-438dfbc1ba7c', '2005-11-30 19:22:12', '2005-11-30 19:22:12', '1', 'sally_id', '1', 'White-Kahl Transportation Company', NULL, 'Consulting', 'Transportation', NULL, NULL, '5167 Oakmead', 'Hidalgo', 'Zacatecas', '60844', 'Mexico', NULL, NULL, '579-555-9341', NULL, NULL, NULL, 'www.white-kahltransportationcompany.com', NULL, NULL, NULL, NULL, '5167 Oakmead', 'Hidalgo', 'Zacatecas', '60844', 'Mexico', 0);
INSERT INTO accounts VALUES ('4d1789b7-3e5c-005c-5bc6-438dfb48ed0c', '2005-11-30 19:22:12', '2005-11-30 19:22:12', '1', 'sally_id', '1', 'M & Y Aguilar Communications, Ltd', NULL, 'Supply', 'Communications', NULL, NULL, '5461 Sunview Terrace', 'Lebanon', 'OR', '67990', 'USA', NULL, NULL, '565-555-4551', NULL, NULL, NULL, 'www.myaguilarcommunications,ltd.com', NULL, NULL, NULL, NULL, '5461 Sunview Terrace', 'Lebanon', 'OR', '67990', 'USA', 0);
INSERT INTO accounts VALUES ('9ef17cae-5cff-52f2-b8f6-438dfb8a9336', '2005-11-30 19:22:12', '2005-11-30 19:22:12', '1', 'beth_id', '1', 'Aguilar-Vanderbout Communications Associates', NULL, 'Consulting', 'Communications', NULL, NULL, '6702 Woodsworth Lane', 'Haney', 'BC', '16832', 'Canada', NULL, NULL, '946-555-3073', NULL, NULL, NULL, 'www.aguilar-vanderboutcommunicationsassociates.com', NULL, NULL, NULL, NULL, '6702 Woodsworth Lane', 'Haney', 'BC', '16832', 'Canada', 0);
INSERT INTO accounts VALUES ('cf131d8b-9fe6-7663-f52f-438dfb9b02c6', '2005-11-30 19:22:12', '2005-11-30 19:22:12', '1', 'max_id', '1', 'B & D Visser Machinery Partners', NULL, 'Consulting', 'Machinery', NULL, NULL, '9907 Via Appia', 'Pomona', 'CA', '89138', 'USA', NULL, NULL, '603-555-8994', NULL, NULL, NULL, 'www.bdvissermachinerypartners.com', NULL, NULL, NULL, NULL, '9907 Via Appia', 'Pomona', 'CA', '89138', 'USA', 0);
INSERT INTO accounts VALUES ('29836014-3a39-deac-1cd1-438dfbac8ab2', '2005-11-30 19:22:13', '2005-11-30 19:22:13', '1', 'sarah_id', '1', 'Visser-Sanchez Construction Partners', NULL, 'Manufacturing', 'Construction', NULL, NULL, '1403 McMillan Ave.', 'Redwood City', 'CA', '41438', 'USA', NULL, NULL, '107-555-6144', NULL, NULL, NULL, 'www.visser-sanchezconstructionpartners.com', NULL, NULL, NULL, NULL, '1403 McMillan Ave.', 'Redwood City', 'CA', '41438', 'USA', 0);
INSERT INTO accounts VALUES ('5998aee4-86a3-263e-e38c-438dfb952cd8', '2005-11-30 19:22:13', '2005-11-30 19:22:13', '1', 'kristen_id', '1', 'H & E Spicer Machinery Group', NULL, 'Supply', 'Machinery', NULL, NULL, '7516 Laguna Street', 'Vancouver', 'BC', '93580', 'Canada', NULL, NULL, '926-555-5351', NULL, NULL, NULL, 'www.hespicermachinerygroup.com', NULL, NULL, NULL, NULL, '7516 Laguna Street', 'Vancouver', 'BC', '93580', 'Canada', 0);
INSERT INTO accounts VALUES ('ab04e4f7-4808-7a3a-9d6a-438dfb8750ef', '2005-11-30 19:22:13', '2005-11-30 19:22:13', '1', 'beth_id', '1', 'Spicer-Medina Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '9266 Trees Drive', 'Daly City', 'CA', '47453', 'USA', NULL, NULL, '453-555-1130', NULL, NULL, NULL, 'www.spicer-medinaelectronicsholdings.com', NULL, NULL, NULL, NULL, '9266 Trees Drive', 'Daly City', 'CA', '47453', 'USA', 0);
INSERT INTO accounts VALUES ('dc9c513e-6661-d1ce-f317-438dfb5c6d58', '2005-11-30 19:22:13', '2005-11-30 19:22:13', '1', 'max_id', '1', 'X & M Young Construction Corp', NULL, 'Manufacturing', 'Construction', NULL, NULL, '5634 Blue Ridge Drive', 'La Jolla', 'CA', '78376', 'USA', NULL, NULL, '395-555-7966', NULL, NULL, NULL, 'www.xmyoungconstructioncorp.com', NULL, NULL, NULL, NULL, '5634 Blue Ridge Drive', 'La Jolla', 'CA', '78376', 'USA', 0);
INSERT INTO accounts VALUES ('571e34d2-5904-1c4e-fb8e-438dfbddf351', '2005-11-30 19:22:14', '2005-11-30 19:22:14', '1', 'sally_id', '1', 'Young-Krupka Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '294 La Vuelta', 'Arcadia', 'CA', '97410', 'USA', NULL, NULL, '184-555-6030', NULL, NULL, NULL, 'www.young-krupkatelecommunications,ltd.com', NULL, NULL, NULL, NULL, '294 La Vuelta', 'Arcadia', 'CA', '97410', 'USA', 0);
INSERT INTO accounts VALUES ('8a079568-e82a-9f09-d3d4-438dfb37c239', '2005-11-30 19:22:14', '2005-11-30 19:22:14', '1', 'chris_id', '1', 'I & M Buensalido Transportation, Ltd', NULL, 'Supply', 'Transportation', NULL, NULL, '6916 Azores', 'Grossmont', 'CA', '68202', 'USA', NULL, NULL, '149-555-2494', NULL, NULL, NULL, 'www.imbuensalidotransportation,ltd.com', NULL, NULL, NULL, NULL, '6916 Azores', 'Grossmont', 'CA', '68202', 'USA', 0);
INSERT INTO accounts VALUES ('d94d9c49-9e7e-6f02-e077-438dfb93f40f', '2005-11-30 19:22:14', '2005-11-30 19:22:14', '1', 'will_id', '1', 'Buensalido-Donovan Electronics Corp', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '1830 Shore Rd.', 'San Andres', 'DF', '53398', 'Mexico', NULL, NULL, '199-555-2844', NULL, NULL, NULL, 'www.buensalido-donovanelectronicscorp.com', NULL, NULL, NULL, NULL, '1830 Shore Rd.', 'San Andres', 'DF', '53398', 'Mexico', 0);
INSERT INTO accounts VALUES ('1567c52a-c9fa-8585-e646-438dfb66bda9', '2005-11-30 19:22:15', '2005-11-30 19:22:15', '1', 'kristen_id', '1', 'H & Y Smith Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '1362 Geary Road', 'Victoria', 'BC', '89351', 'Canada', NULL, NULL, '188-555-6937', NULL, NULL, NULL, 'www.hysmithengineering,inc.com', NULL, NULL, NULL, NULL, '1362 Geary Road', 'Victoria', 'BC', '89351', 'Canada', 0);
INSERT INTO accounts VALUES ('460a8351-5516-8efa-cc7e-438dfb3ec28b', '2005-11-30 19:22:15', '2005-11-30 19:22:15', '1', 'jaime_id', '1', 'Smith-Gentile Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '6529 Buena Vista', 'Downey', 'CA', '40708', 'USA', NULL, NULL, '261-555-5916', NULL, NULL, NULL, 'www.smith-gentiletelecommunications,ltd.com', NULL, NULL, NULL, NULL, '6529 Buena Vista', 'Downey', 'CA', '40708', 'USA', 0);
INSERT INTO accounts VALUES ('7668abc9-efc4-f8c6-4968-438dfb4d1ecc', '2005-11-30 19:22:15', '2005-11-30 19:22:15', '1', 'sally_id', '1', 'D & A Tancredy Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '6316 Parkway Drive', 'San Carlos', 'CA', '42823', 'USA', NULL, NULL, '638-555-4692', NULL, NULL, NULL, 'www.datancredymachinerygroup.com', NULL, NULL, NULL, NULL, '6316 Parkway Drive', 'San Carlos', 'CA', '42823', 'USA', 0);
INSERT INTO accounts VALUES ('c8788aba-6a1e-c258-caf7-438dfb46e44a', '2005-11-30 19:22:15', '2005-11-30 19:22:15', '1', 'max_id', '1', 'Tancredy-Wilson Construction Associates', NULL, 'Consulting', 'Construction', NULL, NULL, '4393 Ridge Road', 'Newport Beach', 'CA', '59342', 'USA', NULL, NULL, '734-555-2299', NULL, NULL, NULL, 'www.tancredy-wilsonconstructionassociates.com', NULL, NULL, NULL, NULL, '4393 Ridge Road', 'Newport Beach', 'CA', '59342', 'USA', 0);
INSERT INTO accounts VALUES ('477701eb-6645-9ccb-33d7-438dfb7ba579', '2005-11-30 19:22:16', '2005-11-30 19:22:16', '1', 'max_id', '1', 'D & Z Leri Electronics, Ltd', NULL, 'Consulting', 'Electronics', NULL, NULL, '7089 Monti Circle', 'Sooke', 'BC', '27618', 'Canada', NULL, NULL, '346-555-1963', NULL, NULL, NULL, 'www.dzlerielectronics,ltd.com', NULL, NULL, NULL, NULL, '7089 Monti Circle', 'Sooke', 'BC', '27618', 'Canada', 0);
INSERT INTO accounts VALUES ('543e70ac-6e33-8917-5565-438dfb360fb5', '2005-11-30 19:22:16', '2005-11-30 19:22:16', '1', 'kristen_id', '1', 'Leri-Carr Engineering Corp', NULL, 'Consulting', 'Engineering', NULL, NULL, '5421 Almond Avenue', 'Arcadia', 'CA', '83006', 'USA', NULL, NULL, '465-555-7199', NULL, NULL, NULL, 'www.leri-carrengineeringcorp.com', NULL, NULL, NULL, NULL, '5421 Almond Avenue', 'Arcadia', 'CA', '83006', 'USA', 0);
INSERT INTO accounts VALUES ('e75c3ecb-99f2-dadf-5d15-438dfbf076d3', '2005-11-30 19:22:16', '2005-11-30 19:22:16', '1', 'will_id', '1', 'Q & Q Zobairi Telecommunications Associates', NULL, 'Supply', 'Telecommunications', NULL, NULL, '8371 Marlesta Rd', 'Olympia', 'WA', '17445', 'USA', NULL, NULL, '999-555-5492', NULL, NULL, NULL, 'www.qqzobairitelecommunicationsassociates.com', NULL, NULL, NULL, NULL, '8371 Marlesta Rd', 'Olympia', 'WA', '17445', 'USA', 0);
INSERT INTO accounts VALUES ('443cbfd7-d176-1227-049b-438dfb1483d1', '2005-11-30 19:22:17', '2005-11-30 19:22:17', '1', 'max_id', '1', 'Zobairi-Zimmerman Engineering Company', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '6957 Olivewood Ct.', 'Shawnee', 'BC', '38994', 'Canada', NULL, NULL, '480-555-4013', NULL, NULL, NULL, 'www.zobairi-zimmermanengineeringcompany.com', NULL, NULL, NULL, NULL, '6957 Olivewood Ct.', 'Shawnee', 'BC', '38994', 'Canada', 0);
INSERT INTO accounts VALUES ('981fe79f-b6ca-8f21-c19c-438dfb4c4ebe', '2005-11-30 19:22:17', '2005-11-30 19:22:17', '1', 'matt_id', '1', 'Y & R Sherfy Machinery, Inc', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '162 Maureen Lane', 'Burien', 'WA', '38593', 'USA', NULL, NULL, '138-555-9935', NULL, NULL, NULL, 'www.yrsherfymachinery,inc.com', NULL, NULL, NULL, NULL, '162 Maureen Lane', 'Burien', 'WA', '38593', 'USA', 0);
INSERT INTO accounts VALUES ('e969de4c-f3b5-0f2e-b5ac-438dfbeb1d30', '2005-11-30 19:22:17', '2005-11-30 19:22:17', '1', 'sarah_id', '1', 'Sherfy-Behnke Engineering, Inc', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '1657 Morengo Ct.', 'Torrance', 'CA', '26305', 'USA', NULL, NULL, '541-555-7085', NULL, NULL, NULL, 'www.sherfy-behnkeengineering,inc.com', NULL, NULL, NULL, NULL, '1657 Morengo Ct.', 'Torrance', 'CA', '26305', 'USA', 0);
INSERT INTO accounts VALUES ('26d4ce17-e466-3006-20f2-438dfb6b462a', '2005-11-30 19:22:18', '2005-11-30 19:22:18', '1', 'kristen_id', '1', 'E & F Tu Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '7770 Brodia Court', 'N. Vancouver', 'BC', '91065', 'Canada', NULL, NULL, '461-555-6292', NULL, NULL, NULL, 'www.eftumachinery,ltd.com', NULL, NULL, NULL, NULL, '7770 Brodia Court', 'N. Vancouver', 'BC', '91065', 'Canada', 0);
INSERT INTO accounts VALUES ('579dad95-4140-81fe-b554-438dfb1a04c7', '2005-11-30 19:22:18', '2005-11-30 19:22:18', '1', 'chris_id', '1', 'Tu-Harris Transportation Holdings', NULL, 'Distribution', 'Transportation', NULL, NULL, '9520 Milburn Dr.', 'San Carlos', 'CA', '37444', 'USA', NULL, NULL, '888-555-2070', NULL, NULL, NULL, 'www.tu-harristransportationholdings.com', NULL, NULL, NULL, NULL, '9520 Milburn Dr.', 'San Carlos', 'CA', '37444', 'USA', 0);
INSERT INTO accounts VALUES ('8a6dd188-d156-8ec3-3281-438dfba5aeaf', '2005-11-30 19:22:18', '2005-11-30 19:22:18', '1', 'will_id', '1', 'N & O Faubert Electronics, Inc', NULL, 'Supply', 'Electronics', NULL, NULL, '5888 Salem St.', 'Concord', 'CA', '42074', 'USA', NULL, NULL, '830-555-8906', NULL, NULL, NULL, 'www.nofaubertelectronics,inc.com', NULL, NULL, NULL, NULL, '5888 Salem St.', 'Concord', 'CA', '42074', 'USA', 0);
INSERT INTO accounts VALUES ('ba82c3c4-e4ec-b757-fa28-438dfbd013aa', '2005-11-30 19:22:18', '2005-11-30 19:22:18', '1', 'kristen_id', '1', 'Faubert-Bonilla Machinery Group', NULL, 'Distribution', 'Machinery', NULL, NULL, '548 Stony Hill Circle', 'Lake Oswego', 'OR', '61108', 'USA', NULL, NULL, '618-555-6970', NULL, NULL, NULL, 'www.faubert-bonillamachinerygroup.com', NULL, NULL, NULL, NULL, '548 Stony Hill Circle', 'Lake Oswego', 'OR', '61108', 'USA', 0);
INSERT INTO accounts VALUES ('17d4f4fb-a181-0c9b-821a-438dfbffc092', '2005-11-30 19:22:19', '2005-11-30 19:22:19', '1', 'beth_id', '1', 'U & W Hirschboeck Construction Corp', NULL, 'Supply', 'Construction', NULL, NULL, '1073 Bonnie Lane', 'La Cruz', 'Sinaloa', '58192', 'Mexico', NULL, NULL, '935-555-9352', NULL, NULL, NULL, 'www.uwhirschboeckconstructioncorp.com', NULL, NULL, NULL, NULL, '1073 Bonnie Lane', 'La Cruz', 'Sinaloa', '58192', 'Mexico', 0);
INSERT INTO accounts VALUES ('69938c8b-9b0b-4890-abe3-438dfb85413f', '2005-11-30 19:22:19', '2005-11-30 19:22:19', '1', 'max_id', '1', 'Hirschboeck-VanHarn Electronics Company', NULL, 'Consulting', 'Electronics', NULL, NULL, '8641 Summitview Dr.', 'Orizaba', 'Veracruz', '43388', 'Mexico', NULL, NULL, '985-555-9702', NULL, NULL, NULL, 'www.hirschboeck-vanharnelectronicscompany.com', NULL, NULL, NULL, NULL, '8641 Summitview Dr.', 'Orizaba', 'Veracruz', '43388', 'Mexico', 0);
INSERT INTO accounts VALUES ('a3e600ee-970a-cee2-8b37-438dfbca1077', '2005-11-30 19:22:20', '2005-11-30 19:22:20', '1', 'chris_id', '1', 'M & K Steffen Telecommunications, Ltd', NULL, 'Supply', 'Telecommunications', NULL, NULL, '5518 San Rafael', 'West Covina', 'CA', '79341', 'USA', NULL, NULL, '973-555-4795', NULL, NULL, NULL, 'www.mksteffentelecommunications,ltd.com', NULL, NULL, NULL, NULL, '5518 San Rafael', 'West Covina', 'CA', '79341', 'USA', 0);
INSERT INTO accounts VALUES ('9f11ccea-052b-e25c-6624-438dfb271b6e', '2005-11-30 19:22:20', '2005-11-30 19:22:20', '1', 'sarah_id', '1', 'Steffen-Flynn Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '3342 Sea Point Way', 'Tacoma', 'WA', '30699', 'USA', NULL, NULL, '146-555-3773', NULL, NULL, NULL, 'www.steffen-flynnmachinery,ltd.com', NULL, NULL, NULL, NULL, '3342 Sea Point Way', 'Tacoma', 'WA', '30699', 'USA', 0);
INSERT INTO accounts VALUES ('efe77bde-c437-665f-9060-438dfb780bc9', '2005-11-30 19:22:20', '2005-11-30 19:22:20', '1', 'beth_id', '1', 'L & E Richardson Communications Partners', NULL, 'Distribution', 'Communications', NULL, NULL, '3128 Ramsey Circle', 'Edmonds', 'WA', '32814', 'USA', NULL, NULL, '396-555-1152', NULL, NULL, NULL, 'www.lerichardsoncommunicationspartners.com', NULL, NULL, NULL, NULL, '3128 Ramsey Circle', 'Edmonds', 'WA', '32814', 'USA', 0);
INSERT INTO accounts VALUES ('6e0daa10-3e3b-58ad-c869-438dfbfedbd4', '2005-11-30 19:22:21', '2005-11-30 19:22:21', '1', 'sally_id', '1', 'Richardson-Brew Construction Holdings', NULL, 'Consulting', 'Construction', NULL, NULL, '1206 San Simeon Drive', 'Corvallis', 'OR', '23040', 'USA', NULL, NULL, '493-555-7759', NULL, NULL, NULL, 'www.richardson-brewconstructionholdings.com', NULL, NULL, NULL, NULL, '1206 San Simeon Drive', 'Corvallis', 'OR', '23040', 'USA', 0);
INSERT INTO accounts VALUES ('a0b9b02e-61de-5f22-07ed-438dfb253137', '2005-11-30 19:22:21', '2005-11-30 19:22:21', '1', 'kristen_id', '1', 'W & N Cook Telecommunications Partners', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '1246 Glenside Ct.', 'La Jolla', 'CA', '90316', 'USA', NULL, NULL, '104-555-7423', NULL, NULL, NULL, 'www.wncooktelecommunicationspartners.com', NULL, NULL, NULL, NULL, '1246 Glenside Ct.', 'La Jolla', 'CA', '90316', 'USA', 0);
INSERT INTO accounts VALUES ('f1d43701-d60b-cd1a-e59e-438dfbc6cdb6', '2005-11-30 19:22:21', '2005-11-30 19:22:21', '1', 'sally_id', '1', 'Cook-Thompson Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '9577 Santa Fe', 'Richmond', 'BC', '72996', 'Canada', NULL, NULL, '223-555-3659', NULL, NULL, NULL, 'www.cook-thompsontransportationholdings.com', NULL, NULL, NULL, NULL, '9577 Santa Fe', 'Richmond', 'BC', '72996', 'Canada', 0);
INSERT INTO accounts VALUES ('2dcaf8ac-1e3b-52e5-2f79-438dfb2abe72', '2005-11-30 19:22:22', '2005-11-30 19:22:22', '1', 'beth_id', '1', 'V & A Gentry Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '2528 Fall Creek Road', 'Newton', 'BC', '74354', 'Canada', NULL, NULL, '758-555-1952', NULL, NULL, NULL, 'www.vagentrytransportationcorp.com', NULL, NULL, NULL, NULL, '2528 Fall Creek Road', 'Newton', 'BC', '74354', 'Canada', 0);
INSERT INTO accounts VALUES ('5df5e2e9-5db1-4193-bd90-438dfb97c738', '2005-11-30 19:22:22', '2005-11-30 19:22:22', '1', 'max_id', '1', 'Gentry-Heckman Communications Corp', NULL, 'Consulting', 'Communications', NULL, NULL, '3769 Loma Linda', 'Coronado', 'CA', '28984', 'USA', NULL, NULL, '239-555-9473', NULL, NULL, NULL, 'www.gentry-heckmancommunicationscorp.com', NULL, NULL, NULL, NULL, '3769 Loma Linda', 'Coronado', 'CA', '28984', 'USA', 0);
INSERT INTO accounts VALUES ('d36355c8-e0d2-1427-3d27-438dfb8d905d', '2005-11-30 19:22:22', '2005-11-30 19:22:22', '1', 'sally_id', '1', 'T & A Reasoner Electronics, Inc', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '6973 Mt. Hood Circle', 'Vancouver', 'BC', '28584', 'Canada', NULL, NULL, '797-555-6395', NULL, NULL, NULL, 'www.tareasonerelectronics,inc.com', NULL, NULL, NULL, NULL, '6973 Mt. Hood Circle', 'Vancouver', 'BC', '28584', 'Canada', 0);
INSERT INTO accounts VALUES ('fa620e7e-59f5-1a0c-c09c-438dfb095eb5', '2005-11-30 19:22:23', '2005-11-30 19:22:23', '1', 'matt_id', '1', 'Reasoner-Wheeler Construction Associates', NULL, 'Manufacturing', 'Construction', NULL, NULL, '8468 Buena Vista', 'N. Vancouver', 'BC', '16295', 'Canada', NULL, NULL, '300-555-3545', NULL, NULL, NULL, 'www.reasoner-wheelerconstructionassociates.com', NULL, NULL, NULL, NULL, '8468 Buena Vista', 'N. Vancouver', 'BC', '16295', 'Canada', 0);
INSERT INTO accounts VALUES ('3fe3554d-2b2d-aea4-8ef6-438dfb9dcb8f', '2005-11-30 19:22:23', '2005-11-30 19:22:23', '1', 'chris_id', '1', 'D & D Weller Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '1927 Chablis Court', 'Acapulco', 'Guerrero', '54763', 'Mexico', NULL, NULL, '220-555-2752', NULL, NULL, NULL, 'www.ddwellerelectronicsholdings.com', NULL, NULL, NULL, NULL, '1927 Chablis Court', 'Acapulco', 'Guerrero', '54763', 'Mexico', 0);
INSERT INTO accounts VALUES ('703c1b7e-8570-46c2-7f7c-438dfbf84b5f', '2005-11-30 19:22:23', '2005-11-30 19:22:23', '1', 'sarah_id', '1', 'Weller-Bloomberg Machinery, Inc', NULL, 'Distribution', 'Machinery', NULL, NULL, '6332 N. Thompson Rd', 'Grossmont', 'CA', '34929', 'USA', NULL, NULL, '998-555-4448', NULL, NULL, NULL, 'www.weller-bloombergmachinery,inc.com', NULL, NULL, NULL, NULL, '6332 N. Thompson Rd', 'Grossmont', 'CA', '34929', 'USA', 0);
INSERT INTO accounts VALUES ('e6576172-75fb-f3d3-7b86-438dfb157db9', '2005-11-30 19:22:23', '2005-11-30 19:22:23', '1', 'sally_id', '1', 'I & V Netz Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '2701 Sierra Rd', 'Redmond', 'WA', '62621', 'USA', NULL, NULL, '940-555-2284', NULL, NULL, NULL, 'www.ivnetzengineering,inc.com', NULL, NULL, NULL, NULL, '2701 Sierra Rd', 'Redmond', 'WA', '62621', 'USA', 0);
INSERT INTO accounts VALUES ('66fa9906-6c40-fdf0-a2e1-438dfbfe512b', '2005-11-30 19:22:24', '2005-11-30 19:22:24', '1', 'beth_id', '1', 'Netz-Green Construction, Ltd', NULL, 'Manufacturing', 'Construction', NULL, NULL, '4704 Tustin Court', 'National City', 'CA', '81655', 'USA', NULL, NULL, '728-555-9348', NULL, NULL, NULL, 'www.netz-greenconstruction,ltd.com', NULL, NULL, NULL, NULL, '4704 Tustin Court', 'National City', 'CA', '81655', 'USA', 0);
INSERT INTO accounts VALUES ('9a1f12a5-9343-222f-e3e6-438dfb777755', '2005-11-30 19:22:24', '2005-11-30 19:22:24', '1', 'matt_id', '1', 'K & R Bobbitt Communications Group', NULL, 'Consulting', 'Communications', NULL, NULL, '3982 San Michele Drive', 'Marysville', 'WA', '52447', 'USA', NULL, NULL, '933-555-9469', NULL, NULL, NULL, 'www.krbobbittcommunicationsgroup.com', NULL, NULL, NULL, NULL, '3982 San Michele Drive', 'Marysville', 'WA', '52447', 'USA', 0);
INSERT INTO accounts VALUES ('cad99cf8-0af8-2048-a57a-438dfbdb0c2a', '2005-11-30 19:22:24', '2005-11-30 19:22:24', '1', 'jaime_id', '1', 'Bobbitt-Boston Engineering Associates', NULL, 'Distribution', 'Engineering', NULL, NULL, '8895 Margo Dr.', 'Kirkland', 'WA', '37643', 'USA', NULL, NULL, '744-555-6162', NULL, NULL, NULL, 'www.bobbitt-bostonengineeringassociates.com', NULL, NULL, NULL, NULL, '8895 Margo Dr.', 'Kirkland', 'WA', '37643', 'USA', 0);
INSERT INTO accounts VALUES ('28db0226-8ff5-a194-6afd-438dfbd26c02', '2005-11-30 19:22:25', '2005-11-30 19:22:25', '1', 'max_id', '1', 'B & P Barry Telecommunications Holdings', NULL, 'Distribution', 'Telecommunications', NULL, NULL, '8428 Appia Court', 'Royal Oak', 'BC', '73596', 'Canada', NULL, NULL, '971-555-4912', NULL, NULL, NULL, 'www.bpbarrytelecommunicationsholdings.com', NULL, NULL, NULL, NULL, '8428 Appia Court', 'Royal Oak', 'BC', '73596', 'Canada', 0);
INSERT INTO accounts VALUES ('58e70e90-21d7-2d97-f046-438dfb7c28a5', '2005-11-30 19:22:25', '2005-11-30 19:22:25', '1', 'kristen_id', '1', 'Barry-Chang Electronics, Ltd', NULL, 'Distribution', 'Electronics', NULL, NULL, '3596 Kingsford Dr.', 'Spring Valley', 'CA', '24954', 'USA', NULL, NULL, '805-555-9234', NULL, NULL, NULL, 'www.barry-changelectronics,ltd.com', NULL, NULL, NULL, NULL, '3596 Kingsford Dr.', 'Spring Valley', 'CA', '24954', 'USA', 0);
INSERT INTO accounts VALUES ('f1f9a52c-3d9f-93d1-3fec-438dfbc77c32', '2005-11-30 19:22:25', '2005-11-30 19:22:25', '1', 'chris_id', '1', 'Q & P Carreras Telecommunications Company', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, '3382 Greer Ave', 'Spring Valley', 'CA', '27069', 'USA', NULL, NULL, '155-555-6612', NULL, NULL, NULL, 'www.qpcarrerastelecommunicationscompany.com', NULL, NULL, NULL, NULL, '3382 Greer Ave', 'Spring Valley', 'CA', '27069', 'USA', 0);
INSERT INTO accounts VALUES ('508543b2-9c94-99cb-e595-438dfb2abb6d', '2005-11-30 19:22:26', '2005-11-30 19:22:26', '1', 'beth_id', '1', 'Carreras-Burtis Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '1460 Jasper Court', 'San Francisco', 'CA', '43587', 'USA', NULL, NULL, '251-555-4219', NULL, NULL, NULL, 'www.carreras-burtistransportationholdings.com', NULL, NULL, NULL, NULL, '1460 Jasper Court', 'San Francisco', 'CA', '43587', 'USA', 0);
INSERT INTO accounts VALUES ('c7d12a8d-0403-3ab7-a0e3-438dfb2d63d6', '2005-11-30 19:22:26', '2005-11-30 19:22:26', '1', 'kristen_id', '1', 'G & N Sanders Communications Group', NULL, 'Supply', 'Communications', NULL, NULL, '1500 Grant Street', 'Burlingame', 'CA', '11864', 'USA', NULL, NULL, '763-555-3884', NULL, NULL, NULL, 'www.gnsanderscommunicationsgroup.com', NULL, NULL, NULL, NULL, '1500 Grant Street', 'Burlingame', 'CA', '11864', 'USA', 0);
INSERT INTO accounts VALUES ('40300bde-e741-a773-4a15-438dfbeee35a', '2005-11-30 19:22:27', '2005-11-30 19:22:27', '1', 'kristen_id', '1', 'Sanders-Steinberg Construction Partners', NULL, 'Distribution', 'Construction', NULL, NULL, '2487 Riverside Drive', 'Portland', 'OR', '67251', 'USA', NULL, NULL, '882-555-9119', NULL, NULL, NULL, 'www.sanders-steinbergconstructionpartners.com', NULL, NULL, NULL, NULL, '2487 Riverside Drive', 'Portland', 'OR', '67251', 'USA', 0);
INSERT INTO accounts VALUES ('347267d1-c06e-b7b5-fa65-438dfb8e8dd4', '2005-11-30 19:22:27', '2005-11-30 19:22:27', '1', 'kristen_id', '1', 'H & Y Viellieux Electronics, Ltd', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '2782 San Simeon', 'Camacho', 'Zacatecas', '16902', 'Mexico', NULL, NULL, '517-555-7412', NULL, NULL, NULL, 'www.hyviellieuxelectronics,ltd.com', NULL, NULL, NULL, NULL, '2782 San Simeon', 'Camacho', 'Zacatecas', '16902', 'Mexico', 0);
INSERT INTO accounts VALUES ('d7b82553-166f-c86f-4feb-438dfba34ec5', '2005-11-30 19:22:27', '2005-11-30 19:22:27', '1', 'chris_id', '1', 'Viellieux-Baugh Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '4023 Glen Court', 'Long Beach', 'CA', '49531', 'USA', NULL, NULL, '898-555-5934', NULL, NULL, NULL, 'www.viellieux-baughtransportationholdings.com', NULL, NULL, NULL, NULL, '4023 Glen Court', 'Long Beach', 'CA', '49531', 'USA', 0);
INSERT INTO accounts VALUES ('7be641b1-ecdd-a545-3bbf-438dfb50769a', '2005-11-30 19:22:28', '2005-11-30 19:22:28', '1', 'sarah_id', '1', 'O & K Mullins Transportation Corp', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '7227 Serafina', 'Downey', 'CA', '22839', 'USA', NULL, NULL, '904-555-8851', NULL, NULL, NULL, 'www.okmullinstransportationcorp.com', NULL, NULL, NULL, NULL, '7227 Serafina', 'Downey', 'CA', '22839', 'USA', 0);
INSERT INTO accounts VALUES ('22f4419a-563a-4a6f-ab54-438dfba24b49', '2005-11-30 19:22:29', '2005-11-30 19:22:29', '1', 'beth_id', '1', 'Mullins-Maes Construction Partners', NULL, 'Consulting', 'Construction', NULL, NULL, '8722 East View Place', 'Palo Alto', 'CA', '36842', 'USA', NULL, NULL, '408-555-6001', NULL, NULL, NULL, 'www.mullins-maesconstructionpartners.com', NULL, NULL, NULL, NULL, '8722 East View Place', 'Palo Alto', 'CA', '36842', 'USA', 0);
INSERT INTO accounts VALUES ('76e613b6-66dc-da59-7dc3-438dfb4fff7a', '2005-11-30 19:22:29', '2005-11-30 19:22:29', '1', 'sally_id', '1', 'D & D Trujillo Transportation, Ltd', NULL, 'Distribution', 'Transportation', NULL, NULL, '4837 Mohr Lane', 'Everett', 'WA', '75310', 'USA', NULL, NULL, '327-555-5209', NULL, NULL, NULL, 'www.ddtrujillotransportation,ltd.com', NULL, NULL, NULL, NULL, '4837 Mohr Lane', 'Everett', 'WA', '75310', 'USA', 0);
INSERT INTO accounts VALUES ('cc7d000d-19c9-bb48-44fe-438dfbef8917', '2005-11-30 19:22:29', '2005-11-30 19:22:29', '1', 'kristen_id', '1', 'Trujillo-Barrington Machinery, Inc', NULL, 'Consulting', 'Machinery', NULL, NULL, '9865 Montana', 'Acapulco', 'Guerrero', '29184', 'Mexico', NULL, NULL, '754-555-9987', NULL, NULL, NULL, 'www.trujillo-barringtonmachinery,inc.com', NULL, NULL, NULL, NULL, '9865 Montana', 'Acapulco', 'Guerrero', '29184', 'Mexico', 0);
INSERT INTO accounts VALUES ('dcb5074e-614a-78ef-f0ab-438dfbd631ff', '2005-11-30 19:22:30', '2005-11-30 19:22:30', '1', 'beth_id', '1', 'E & M Zuluaga Electronics Company', NULL, 'Supply', 'Electronics', NULL, NULL, '6233 Serpentine', 'Tlaxiaco', 'Oaxaca', '79373', 'Mexico', NULL, NULL, '696-555-7823', NULL, NULL, NULL, 'www.emzuluagaelectronicscompany.com', NULL, NULL, NULL, NULL, '6233 Serpentine', 'Tlaxiaco', 'Oaxaca', '79373', 'Mexico', 0);
INSERT INTO accounts VALUES ('89475c72-6b72-9ca4-52f2-438dfbd736d1', '2005-11-30 19:22:30', '2005-11-30 19:22:30', '1', 'matt_id', '1', 'Zuluaga-Abo Engineering, Ltd', NULL, 'Distribution', 'Engineering', NULL, NULL, '893 Thornwood Drive', 'Long Beach', 'CA', '26971', 'USA', NULL, NULL, '485-555-5887', NULL, NULL, NULL, 'www.zuluaga-aboengineering,ltd.com', NULL, NULL, NULL, NULL, '893 Thornwood Drive', 'Long Beach', 'CA', '26971', 'USA', 0);
INSERT INTO accounts VALUES ('baa43c5d-69de-a271-0c25-438dfb74fea8', '2005-11-30 19:22:30', '2005-11-30 19:22:30', '1', 'matt_id', '1', 'R & Z Azzolino Communications, Inc', NULL, 'Distribution', 'Communications', NULL, NULL, '7515 Royal Oak Rd.', 'Chula Vista', 'CA', '96762', 'USA', NULL, NULL, '689-555-6009', NULL, NULL, NULL, 'www.rzazzolinocommunications,inc.com', NULL, NULL, NULL, NULL, '7515 Royal Oak Rd.', 'Chula Vista', 'CA', '96762', 'USA', 0);
INSERT INTO accounts VALUES ('ec1efaef-ce0d-bb93-ebfe-438dfb73d939', '2005-11-30 19:22:30', '2005-11-30 19:22:30', '1', 'chris_id', '1', 'Azzolino-Archuleta Machinery Partners', NULL, 'Supply', 'Machinery', NULL, NULL, '2429 Longview Road', 'Burien', 'WA', '81958', 'USA', NULL, NULL, '500-555-2702', NULL, NULL, NULL, 'www.azzolino-archuletamachinerypartners.com', NULL, NULL, NULL, NULL, '2429 Longview Road', 'Burien', 'WA', '81958', 'USA', 0);
INSERT INTO accounts VALUES ('ba751781-d364-4a0d-5de6-438dfb165ad5', '2005-11-30 19:22:31', '2005-11-30 19:22:31', '1', 'sarah_id', '1', 'J & K Campos Communications Corp', NULL, 'Supply', 'Communications', NULL, NULL, '1961 Sahara Drive', 'Mexico City', 'Mexico', '18912', 'Mexico', NULL, NULL, '727-555-1452', NULL, NULL, NULL, 'www.jkcamposcommunicationscorp.com', NULL, NULL, NULL, NULL, '1961 Sahara Drive', 'Mexico City', 'Mexico', '18912', 'Mexico', 0);
INSERT INTO accounts VALUES ('f1cfb3dd-1cb4-eeb4-60f4-438dfb0c1b12', '2005-11-30 19:22:31', '2005-11-30 19:22:31', '1', 'sally_id', '1', 'Campos-Unfried Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '7128 Joan Ave.', 'Glendale', 'CA', '69269', 'USA', NULL, NULL, '561-555-5773', NULL, NULL, NULL, 'www.campos-unfriedconstruction,ltd.com', NULL, NULL, NULL, NULL, '7128 Joan Ave.', 'Glendale', 'CA', '69269', 'USA', 0);
INSERT INTO accounts VALUES ('77504603-324f-a0d3-a501-438dfbdf4697', '2005-11-30 19:22:32', '2005-11-30 19:22:32', '1', 'max_id', '1', 'W & W Bozeman Electronics Associates', NULL, 'Supply', 'Electronics', NULL, NULL, '6915 Golden Leaf Way', 'Hidalgo', 'Zacatecas', '71384', 'Mexico', NULL, NULL, '811-555-3151', NULL, NULL, NULL, 'www.wwbozemanelectronicsassociates.com', NULL, NULL, NULL, NULL, '6915 Golden Leaf Way', 'Hidalgo', 'Zacatecas', '71384', 'Mexico', 0);
INSERT INTO accounts VALUES ('aa1defb3-634a-3879-f66d-438dfb8513c3', '2005-11-30 19:22:32', '2005-11-30 19:22:32', '1', 'max_id', '1', 'Bozeman-Kassab Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '4992 Yorba Linda', 'Palo Alto', 'CA', '87902', 'USA', NULL, NULL, '247-555-4416', NULL, NULL, NULL, 'www.bozeman-kassabmachinerygroup.com', NULL, NULL, NULL, NULL, '4992 Yorba Linda', 'Palo Alto', 'CA', '87902', 'USA', 0);
INSERT INTO accounts VALUES ('2dfe29c0-10b8-8b37-ef7c-438dfb8c33e1', '2005-11-30 19:22:33', '2005-11-30 19:22:33', '1', 'beth_id', '1', 'D & G Enlow Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '7688 P St.', 'Marysville', 'WA', '29887', 'USA', NULL, NULL, '632-555-2683', NULL, NULL, NULL, 'www.dgenlowtransportation,inc.com', NULL, NULL, NULL, NULL, '7688 P St.', 'Marysville', 'WA', '29887', 'USA', 0);
INSERT INTO accounts VALUES ('82c2ab66-d0ac-9766-3603-438dfb6fd1f5', '2005-11-30 19:22:33', '2005-11-30 19:22:33', '1', 'matt_id', '1', 'Enlow-Lee Engineering, Ltd', NULL, 'Supply', 'Engineering', NULL, NULL, '6020 Regency Dr.', 'Concord', 'CA', '12567', 'USA', NULL, NULL, '751-555-7918', NULL, NULL, NULL, 'www.enlow-leeengineering,ltd.com', NULL, NULL, NULL, NULL, '6020 Regency Dr.', 'Concord', 'CA', '12567', 'USA', 0);
INSERT INTO accounts VALUES ('d99ac000-1591-f7d4-645b-438dfb9c52a9', '2005-11-30 19:22:33', '2005-11-30 19:22:33', '1', 'jaime_id', '1', 'Z & L Skapinok Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '8970 West 39th St', 'Anacortes', 'WA', '46005', 'USA', NULL, NULL, '385-555-6211', NULL, NULL, NULL, 'www.zlskapinokconstruction,ltd.com', NULL, NULL, NULL, NULL, '8970 West 39th St', 'Anacortes', 'WA', '46005', 'USA', 0);
INSERT INTO accounts VALUES ('39f27a0e-0400-fa81-07dd-438dfb57ce13', '2005-11-30 19:22:34', '2005-11-30 19:22:34', '1', 'will_id', '1', 'Skapinok-Marsden Transportation Group', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '7556 Garcia Ranch Road', 'Royal Oak', 'BC', '67554', 'Canada', NULL, NULL, '766-555-4733', NULL, NULL, NULL, 'www.skapinok-marsdentransportationgroup.com', NULL, NULL, NULL, NULL, '7556 Garcia Ranch Road', 'Royal Oak', 'BC', '67554', 'Canada', 0);
INSERT INTO accounts VALUES ('6ad22ccc-c235-de00-80c7-438dfbeb8caf', '2005-11-30 19:22:34', '2005-11-30 19:22:34', '1', 'max_id', '1', 'V & P Campbell Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '3416 Cunha Ct', 'Oregon City', 'OR', '67154', 'USA', NULL, NULL, '424-555-1654', NULL, NULL, NULL, 'www.vpcampbelltransportationcorp.com', NULL, NULL, NULL, NULL, '3416 Cunha Ct', 'Oregon City', 'OR', '67154', 'USA', 0);
INSERT INTO accounts VALUES ('e69e09bd-23e8-b36b-3e3a-438dfbb1062d', '2005-11-30 19:22:34', '2005-11-30 19:22:34', '1', 'will_id', '1', 'Campbell-Roberts Telecommunications, Inc', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '4911 Dubhe Court', 'San Gabriel', 'CA', '54865', 'USA', NULL, NULL, '827-555-7804', NULL, NULL, NULL, 'www.campbell-robertstelecommunications,inc.com', NULL, NULL, NULL, NULL, '4911 Dubhe Court', 'San Gabriel', 'CA', '54865', 'USA', 0);
INSERT INTO accounts VALUES ('6b7e6016-b265-3ba5-ff42-438dfb51a9ed', '2005-11-30 19:22:35', '2005-11-30 19:22:35', '1', 'matt_id', '1', 'F & X Larkin Communications Partners', NULL, 'Consulting', 'Communications', NULL, NULL, '8370 Merced Circle', 'Westminster', 'BC', '20626', 'Canada', NULL, NULL, '747-555-7011', NULL, NULL, NULL, 'www.fxlarkincommunicationspartners.com', NULL, NULL, NULL, NULL, '8370 Merced Circle', 'Westminster', 'BC', '20626', 'Canada', 0);
INSERT INTO accounts VALUES ('c2bb3f7c-9af5-a61f-a3e2-438dfb7727a9', '2005-11-30 19:22:35', '2005-11-30 19:22:35', '1', 'sally_id', '1', 'Larkin-Bitler Communications Holdings', NULL, 'Distribution', 'Communications', NULL, NULL, '2775 Delta View Ln.', 'Mill Valley', 'CA', '73498', 'USA', NULL, NULL, '513-555-6447', NULL, NULL, NULL, 'www.larkin-bitlercommunicationsholdings.com', NULL, NULL, NULL, NULL, '2775 Delta View Ln.', 'Mill Valley', 'CA', '73498', 'USA', 0);
INSERT INTO accounts VALUES ('239a9544-7bdd-167e-07bd-438dfb299c59', '2005-11-30 19:22:36', '2005-11-30 19:22:36', '1', 'sarah_id', '1', 'S & X Allen Engineering Partners', NULL, 'Distribution', 'Engineering', NULL, NULL, '6488 Dublin Blvd.', 'Palo Alto', 'CA', '78129', 'USA', NULL, NULL, '455-555-4283', NULL, NULL, NULL, 'www.sxallenengineeringpartners.com', NULL, NULL, NULL, NULL, '6488 Dublin Blvd.', 'Palo Alto', 'CA', '78129', 'USA', 0);
INSERT INTO accounts VALUES ('78ff9990-540c-dd40-27c5-438dfb183793', '2005-11-30 19:22:36', '2005-11-30 19:22:36', '1', 'sarah_id', '1', 'Allen-Worth Transportation, Inc', NULL, 'Supply', 'Transportation', NULL, NULL, '1147 Mellowood Street', 'Newport Beach', 'CA', '95548', 'USA', NULL, NULL, '904-555-7690', NULL, NULL, NULL, 'www.allen-worthtransportation,inc.com', NULL, NULL, NULL, NULL, '1147 Mellowood Street', 'Newport Beach', 'CA', '95548', 'USA', 0);
INSERT INTO accounts VALUES ('d0923769-e322-cf84-3521-438dfb84c9ca', '2005-11-30 19:22:36', '2005-11-30 19:22:36', '1', 'sarah_id', '1', 'H & N Mauro Machinery Corp', NULL, 'Supply', 'Machinery', NULL, NULL, '7769 Holton Court', 'Cliffside', 'BC', '92632', 'Canada', NULL, NULL, '209-555-7811', NULL, NULL, NULL, 'www.hnmauromachinerycorp.com', NULL, NULL, NULL, NULL, '7769 Holton Court', 'Cliffside', 'BC', '92632', 'Canada', 0);
INSERT INTO accounts VALUES ('31737d1f-1289-7fcd-5d14-438dfbd580bb', '2005-11-30 19:22:37', '2005-11-30 19:22:37', '1', 'will_id', '1', 'Mauro-Stroh Machinery Associates', NULL, 'Supply', 'Machinery', NULL, NULL, '5339 Cashew Street', 'Tacoma', 'WA', '77828', 'USA', NULL, NULL, '920-555-4504', NULL, NULL, NULL, 'www.mauro-strohmachineryassociates.com', NULL, NULL, NULL, NULL, '5339 Cashew Street', 'Tacoma', 'WA', '77828', 'USA', 0);
INSERT INTO accounts VALUES ('895cc6e7-0091-44a7-21a6-438dfb1d162e', '2005-11-30 19:22:37', '2005-11-30 19:22:37', '1', 'max_id', '1', 'G & W Theriault Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '2215 La Corte Bonita', 'Chula Vista', 'CA', '14782', 'USA', NULL, NULL, '247-555-3254', NULL, NULL, NULL, 'www.gwtheriaulttransportation,inc.com', NULL, NULL, NULL, NULL, '2215 La Corte Bonita', 'Chula Vista', 'CA', '14782', 'USA', 0);
INSERT INTO accounts VALUES ('343b349e-f4d2-005d-0269-438dfbc49cbb', '2005-11-30 19:22:38', '2005-11-30 19:22:38', '1', 'matt_id', '1', 'Theriault-Ketterman Machinery Corp', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '39 Southbrook Drive', 'Tixapan', 'DF', '65138', 'Mexico', NULL, NULL, '671-555-8150', NULL, NULL, NULL, 'www.theriault-kettermanmachinerycorp.com', NULL, NULL, NULL, NULL, '39 Southbrook Drive', 'Tixapan', 'DF', '65138', 'Mexico', 0);
INSERT INTO accounts VALUES ('867109fb-918b-35a3-7cfd-438dfb68d6ff', '2005-11-30 19:22:39', '2005-11-30 19:22:39', '1', 'beth_id', '1', 'V & B Beavers Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '9824 San Rafael', 'Tixapan', 'DF', '67253', 'Mexico', NULL, NULL, '260-555-9186', NULL, NULL, NULL, 'www.vbbeaverstransportationholdings.com', NULL, NULL, NULL, NULL, '9824 San Rafael', 'Tixapan', 'DF', '67253', 'Mexico', 0);
INSERT INTO accounts VALUES ('3931744b-5e96-d2da-5dd2-438dfb47595f', '2005-11-30 19:22:39', '2005-11-30 19:22:39', '1', 'beth_id', '1', 'Beavers-Dephillipo Construction Company', NULL, 'Consulting', 'Construction', NULL, NULL, '7902 Bates Court', 'Haney', 'BC', '57480', 'Canada', NULL, NULL, '357-555-6794', NULL, NULL, NULL, 'www.beavers-dephillipoconstructioncompany.com', NULL, NULL, NULL, NULL, '7902 Bates Court', 'Haney', 'BC', '57480', 'Canada', 0);
INSERT INTO accounts VALUES ('9257041c-6deb-f667-eccd-438dfbc973ff', '2005-11-30 19:22:39', '2005-11-30 19:22:39', '1', 'max_id', '1', 'C & A Orando Engineering Group', NULL, 'Supply', 'Engineering', NULL, NULL, '7942 Palms', 'Lakewood', 'CA', '25757', 'USA', NULL, NULL, '629-555-2801', NULL, NULL, NULL, 'www.caorandoengineeringgroup.com', NULL, NULL, NULL, NULL, '7942 Palms', 'Lakewood', 'CA', '25757', 'USA', 0);
INSERT INTO accounts VALUES ('19132155-4eaa-cd95-cb9f-438dfc5af020', '2005-11-30 19:22:40', '2005-11-30 19:22:40', '1', 'kristen_id', '1', 'Orando-Troxell Construction, Ltd', NULL, 'Consulting', 'Construction', NULL, NULL, '6274 San Antonio', 'Victoria', 'BC', '84372', 'Canada', NULL, NULL, '987-555-2694', NULL, NULL, NULL, 'www.orando-troxellconstruction,ltd.com', NULL, NULL, NULL, NULL, '6274 San Antonio', 'Victoria', 'BC', '84372', 'Canada', 0);
INSERT INTO accounts VALUES ('e1806030-63f9-3872-1154-438dfce4e5b8', '2005-11-30 19:22:40', '2005-11-30 19:22:40', '1', 'chris_id', '1', 'U & S Gabbard Transportation, Inc', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '9224 Nob Hill Drive', 'La Mesa', 'CA', '15583', 'USA', NULL, NULL, '383-555-6329', NULL, NULL, NULL, 'www.usgabbardtransportation,inc.com', NULL, NULL, NULL, NULL, '9224 Nob Hill Drive', 'La Mesa', 'CA', '15583', 'USA', 0);
INSERT INTO accounts VALUES ('692d3a91-9858-15f9-05e2-438dfc10aa6e', '2005-11-30 19:22:41', '2005-11-30 19:22:41', '1', 'will_id', '1', 'Gabbard-Lebaron Construction Group', NULL, 'Distribution', 'Construction', NULL, NULL, '466 E St.', 'Colma', 'CA', '63424', 'USA', NULL, NULL, '764-555-4851', NULL, NULL, NULL, 'www.gabbard-lebaronconstructiongroup.com', NULL, NULL, NULL, NULL, '466 E St.', 'Colma', 'CA', '63424', 'USA', 0);
INSERT INTO accounts VALUES ('9c4c03e1-b5b6-b2e3-ef3a-438dfc80f2ff', '2005-11-30 19:22:41', '2005-11-30 19:22:41', '1', 'sarah_id', '1', 'N & W Hill Transportation Corp', NULL, 'Distribution', 'Transportation', NULL, NULL, '7572 Easley Drive', 'Acapulco', 'Guerrero', '63024', 'Mexico', NULL, NULL, '422-555-1772', NULL, NULL, NULL, 'www.nwhilltransportationcorp.com', NULL, NULL, NULL, NULL, '7572 Easley Drive', 'Acapulco', 'Guerrero', '63024', 'Mexico', 0);
INSERT INTO accounts VALUES ('23c14364-2b8a-f05a-56c3-438dfc3bd2c7', '2005-11-30 19:22:42', '2005-11-30 19:22:42', '1', 'matt_id', '1', 'Hill-Butcher Engineering Partners', NULL, 'Supply', 'Engineering', NULL, NULL, '9067 Argonne Drive', 'Lemon Grove', 'CA', '50735', 'USA', NULL, NULL, '164-555-2579', NULL, NULL, NULL, 'www.hill-butcherengineeringpartners.com', NULL, NULL, NULL, NULL, '9067 Argonne Drive', 'Lemon Grove', 'CA', '50735', 'USA', 0);
INSERT INTO accounts VALUES ('79b00146-200c-599b-f545-438dfce60df3', '2005-11-30 19:22:42', '2005-11-30 19:22:42', '1', 'sarah_id', '1', 'O & D Taurman Communications Associates', NULL, 'Distribution', 'Communications', NULL, NULL, '2526 N Willow Glen Court', 'Arcadia', 'CA', '89203', 'USA', NULL, NULL, '745-555-7129', NULL, NULL, NULL, 'www.odtaurmancommunicationsassociates.com', NULL, NULL, NULL, NULL, '2526 N Willow Glen Court', 'Arcadia', 'CA', '89203', 'USA', 0);
INSERT INTO accounts VALUES ('aca283ec-2e56-abb8-9776-438dfc574914', '2005-11-30 19:22:42', '2005-11-30 19:22:42', '1', 'sally_id', '1', 'Taurman-Rachak Transportation Company', NULL, 'Consulting', 'Transportation', NULL, NULL, '6931 Erie Dr.', 'San Andres', 'DF', '69368', 'Mexico', NULL, NULL, '510-555-6565', NULL, NULL, NULL, 'www.taurman-rachaktransportationcompany.com', NULL, NULL, NULL, NULL, '6931 Erie Dr.', 'San Andres', 'DF', '69368', 'Mexico', 0);
INSERT INTO accounts VALUES ('e8a00854-eae8-47ff-d743-438dfc6b7863', '2005-11-30 19:22:43', '2005-11-30 19:22:43', '1', 'sally_id', '1', 'M & Y Caro Communications, Ltd', NULL, 'Supply', 'Communications', NULL, NULL, '3300 Country View Lane', 'Santa Fe', 'DF', '73998', 'Mexico', NULL, NULL, '453-555-4401', NULL, NULL, NULL, 'www.mycarocommunications,ltd.com', NULL, NULL, NULL, NULL, '3300 Country View Lane', 'Santa Fe', 'DF', '73998', 'Mexico', 0);
INSERT INTO accounts VALUES ('64c05cfe-ac02-e2d8-12bc-438dfc8b0aaf', '2005-11-30 19:22:43', '2005-11-30 19:22:43', '1', 'beth_id', '1', 'Caro-Robertson Communications Associates', NULL, 'Consulting', 'Communications', NULL, NULL, '7959 Mt. Wilson Way', 'Port Hammond', 'BC', '93032', 'Canada', NULL, NULL, '353-555-4725', NULL, NULL, NULL, 'www.caro-robertsoncommunicationsassociates.com', NULL, NULL, NULL, NULL, '7959 Mt. Wilson Way', 'Port Hammond', 'BC', '93032', 'Canada', 0);
INSERT INTO accounts VALUES ('97ac316a-488e-ce89-1fc8-438dfcaec675', '2005-11-30 19:22:43', '2005-11-30 19:22:43', '1', 'max_id', '1', 'B & D Potter Machinery Partners', NULL, 'Consulting', 'Machinery', NULL, NULL, '4581 Coggins Drive', 'Port Orchard', 'WA', '99162', 'USA', NULL, NULL, '319-555-1189', NULL, NULL, NULL, 'www.bdpottermachinerypartners.com', NULL, NULL, NULL, NULL, '4581 Coggins Drive', 'Port Orchard', 'WA', '99162', 'USA', 0);
INSERT INTO accounts VALUES ('20de29e6-39cc-7c65-c97a-438dfceb2640', '2005-11-30 19:22:44', '2005-11-30 19:22:44', '1', 'sarah_id', '1', 'Potter-Holmes Construction Partners', NULL, 'Manufacturing', 'Construction', NULL, NULL, '9494 Buena Vista', 'Downey', 'CA', '94110', 'USA', NULL, NULL, '130-555-6882', NULL, NULL, NULL, 'www.potter-holmesconstructionpartners.com', NULL, NULL, NULL, NULL, '9494 Buena Vista', 'Downey', 'CA', '94110', 'USA', 0);
INSERT INTO accounts VALUES ('52d5aba1-bdec-b7ce-1ae1-438dfcf4428b', '2005-11-30 19:22:44', '2005-11-30 19:22:44', '1', 'kristen_id', '1', 'H & E Crouch Machinery Group', NULL, 'Supply', 'Machinery', NULL, NULL, '9027 Lancelot Dr', 'W. Linn', 'OR', '31064', 'USA', NULL, NULL, '357-555-5632', NULL, NULL, NULL, 'www.hecrouchmachinerygroup.com', NULL, NULL, NULL, NULL, '9027 Lancelot Dr', 'W. Linn', 'OR', '31064', 'USA', 0);
INSERT INTO accounts VALUES ('adff7314-4992-f2b0-e2b0-438dfc5eb6ad', '2005-11-30 19:22:44', '2005-11-30 19:22:44', '1', 'beth_id', '1', 'Crouch-Henderson Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '4195 San Paolo', 'Lincoln Acres', 'CA', '81421', 'USA', NULL, NULL, '430-555-4611', NULL, NULL, NULL, 'www.crouch-hendersonelectronicsholdings.com', NULL, NULL, NULL, NULL, '4195 San Paolo', 'Lincoln Acres', 'CA', '81421', 'USA', 0);
INSERT INTO accounts VALUES ('df394a46-8924-6ce8-24e4-438dfcc0045c', '2005-11-30 19:22:44', '2005-11-30 19:22:44', '1', 'max_id', '1', 'X & M Witte Construction Corp', NULL, 'Manufacturing', 'Construction', NULL, NULL, '3981 Augustine Drive', 'National City', 'CA', '83536', 'USA', NULL, NULL, '680-555-1989', NULL, NULL, NULL, 'www.xmwitteconstructioncorp.com', NULL, NULL, NULL, NULL, '3981 Augustine Drive', 'National City', 'CA', '83536', 'USA', 0);
INSERT INTO accounts VALUES ('69f6e1fb-cf31-0283-314d-438dfc773540', '2005-11-30 19:22:45', '2005-11-30 19:22:45', '1', 'sally_id', '1', 'Witte-Bauer Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '2059 Brookdale Dr', 'Metchosin', 'BC', '10562', 'Canada', NULL, NULL, '776-555-8596', NULL, NULL, NULL, 'www.witte-bauertelecommunications,ltd.com', NULL, NULL, NULL, NULL, '2059 Brookdale Dr', 'Metchosin', 'BC', '10562', 'Canada', 0);
INSERT INTO accounts VALUES ('c4ea893c-9696-f55c-d060-438dfc022203', '2005-11-30 19:22:45', '2005-11-30 19:22:45', '1', 'chris_id', '1', 'I & M Thompson Transportation, Ltd', NULL, 'Supply', 'Transportation', NULL, NULL, '2099 San Jose', 'Mill Valley', 'CA', '68331', 'USA', NULL, NULL, '149-555-4603', NULL, NULL, NULL, 'www.imthompsontransportation,ltd.com', NULL, NULL, NULL, NULL, '2099 San Jose', 'Mill Valley', 'CA', '68331', 'USA', 0);
INSERT INTO accounts VALUES ('4e7fb6cc-21c4-f851-9763-438dfcbeec1d', '2005-11-30 19:22:46', '2005-11-30 19:22:46', '1', 'will_id', '1', 'Thompson-Sturgel Electronics Corp', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '3086 Indigo Ct', 'El Cajon', 'CA', '24720', 'USA', NULL, NULL, '507-555-4496', NULL, NULL, NULL, 'www.thompson-sturgelelectronicscorp.com', NULL, NULL, NULL, NULL, '3086 Indigo Ct', 'El Cajon', 'CA', '24720', 'USA', 0);
INSERT INTO accounts VALUES ('7ed9e009-9cd7-4eac-0a05-438dfcb6bd57', '2005-11-30 19:22:46', '2005-11-30 19:22:46', '1', 'kristen_id', '1', 'H & Y Gambao Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '6036 Park Glenn', 'Issaquah', 'WA', '58157', 'USA', NULL, NULL, '803-555-8132', NULL, NULL, NULL, 'www.hygambaoengineering,inc.com', NULL, NULL, NULL, NULL, '6036 Park Glenn', 'Issaquah', 'WA', '58157', 'USA', 0);
INSERT INTO accounts VALUES ('d890703c-8f14-175c-2d29-438dfc486f5d', '2005-11-30 19:22:46', '2005-11-30 19:22:46', '1', 'jaime_id', '1', 'Gambao-Snow Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '4622 Andrea Lane', 'Novato', 'CA', '79707', 'USA', NULL, NULL, '284-555-6653', NULL, NULL, NULL, 'www.gambao-snowtelecommunications,ltd.com', NULL, NULL, NULL, NULL, '4622 Andrea Lane', 'Novato', 'CA', '79707', 'USA', 0);
INSERT INTO accounts VALUES ('62ca07a3-8432-3273-b5d3-438dfc2ffcd4', '2005-11-30 19:22:47', '2005-11-30 19:22:47', '1', 'sally_id', '1', 'D & A Vaughn Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '7826 W. Hookston Road', 'Lincoln Acres', 'CA', '79306', 'USA', NULL, NULL, '180-555-7232', NULL, NULL, NULL, 'www.davaughnmachinerygroup.com', NULL, NULL, NULL, NULL, '7826 W. Hookston Road', 'Lincoln Acres', 'CA', '79306', 'USA', 0);
INSERT INTO accounts VALUES ('bd1e34d7-2283-d1fb-ea70-438dfc3d837c', '2005-11-30 19:22:47', '2005-11-30 19:22:47', '1', 'max_id', '1', 'Vaughn-Baccus Construction Associates', NULL, 'Consulting', 'Construction', NULL, NULL, '9321 Quiet Place Drive', 'Langford', 'BC', '67017', 'Canada', NULL, NULL, '584-555-4382', NULL, NULL, NULL, 'www.vaughn-baccusconstructionassociates.com', NULL, NULL, NULL, NULL, '9321 Quiet Place Drive', 'Langford', 'BC', '67017', 'Canada', 0);
INSERT INTO accounts VALUES ('47ce2c70-6514-da71-de9d-438dfc189dc3', '2005-11-30 19:22:48', '2005-11-30 19:22:48', '1', 'max_id', '1', 'D & Z Smith Electronics, Ltd', NULL, 'Consulting', 'Electronics', NULL, NULL, '5436 Via Del Sol', 'La Jolla', 'CA', '32779', 'USA', NULL, NULL, '857-555-9428', NULL, NULL, NULL, 'www.dzsmithelectronics,ltd.com', NULL, NULL, NULL, NULL, '5436 Via Del Sol', 'La Jolla', 'CA', '32779', 'USA', 0);
INSERT INTO accounts VALUES ('a26b4d1a-8d73-2beb-6552-438dfc7b122d', '2005-11-30 19:22:48', '2005-11-30 19:22:48', '1', 'kristen_id', '1', 'Smith-Potter Engineering Corp', NULL, 'Consulting', 'Engineering', NULL, NULL, '7185 Westcliffe Place', 'San Gabriel', 'CA', '85651', 'USA', NULL, NULL, '623-555-8863', NULL, NULL, NULL, 'www.smith-potterengineeringcorp.com', NULL, NULL, NULL, NULL, '7185 Westcliffe Place', 'San Gabriel', 'CA', '85651', 'USA', 0);
INSERT INTO accounts VALUES ('d2a10099-e3ec-17a9-b47c-438dfc811b36', '2005-11-30 19:22:48', '2005-11-30 19:22:48', '1', 'will_id', '1', 'Q & Q Gerber Telecommunications Associates', NULL, 'Supply', 'Telecommunications', NULL, NULL, '3554 Trinity Ave', 'Glendale', 'CA', '17574', 'USA', NULL, NULL, '565-555-6699', NULL, NULL, NULL, 'www.qqgerbertelecommunicationsassociates.com', NULL, NULL, NULL, NULL, '3554 Trinity Ave', 'Glendale', 'CA', '17574', 'USA', 0);
INSERT INTO accounts VALUES ('5da2f2ef-631b-b399-81ec-438dfc34c906', '2005-11-30 19:22:49', '2005-11-30 19:22:49', '1', 'max_id', '1', 'Gerber-Vanderslice Engineering Company', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '8213 Dianda Dr', 'Lebanon', 'OR', '36608', 'USA', NULL, NULL, '354-555-4763', NULL, NULL, NULL, 'www.gerber-vandersliceengineeringcompany.com', NULL, NULL, NULL, NULL, '8213 Dianda Dr', 'Lebanon', 'OR', '36608', 'USA', 0);
INSERT INTO accounts VALUES ('e085ffea-a012-5b9a-928e-438dfca18c8b', '2005-11-30 19:22:49', '2005-11-30 19:22:49', '1', 'matt_id', '1', 'Y & R Wood Machinery, Inc', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '4836 Stratton Circle', 'Oakland', 'CA', '80107', 'USA', NULL, NULL, '319-555-1228', NULL, NULL, NULL, 'www.yrwoodmachinery,inc.com', NULL, NULL, NULL, NULL, '4836 Stratton Circle', 'Oakland', 'CA', '80107', 'USA', 0);
INSERT INTO accounts VALUES ('445d98cb-2bb6-5a5a-7e25-438dfce95daf', '2005-11-30 19:22:50', '2005-11-30 19:22:50', '1', 'sarah_id', '1', 'Wood-Bostwick Engineering, Inc', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '9748 Sutherland Dr', 'Port Hammond', 'BC', '65303', 'Canada', NULL, NULL, '130-555-6920', NULL, NULL, NULL, 'www.wood-bostwickengineering,inc.com', NULL, NULL, NULL, NULL, '9748 Sutherland Dr', 'Port Hammond', 'BC', '65303', 'Canada', 0);
INSERT INTO accounts VALUES ('9f3832b4-60be-268b-9145-438dfc8b7a6e', '2005-11-30 19:22:50', '2005-11-30 19:22:50', '1', 'kristen_id', '1', 'E & F Corcoran Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '9281 Brushcreek Dr', 'Merida', 'Yucatan', '22572', 'Mexico', NULL, NULL, '357-555-5670', NULL, NULL, NULL, 'www.efcorcoranmachinery,ltd.com', NULL, NULL, NULL, NULL, '9281 Brushcreek Dr', 'Merida', 'Yucatan', '22572', 'Mexico', 0);
INSERT INTO accounts VALUES ('31a30751-21d5-38ab-56e8-438dfc995474', '2005-11-30 19:22:51', '2005-11-30 19:22:51', '1', 'chris_id', '1', 'Corcoran-Good Transportation Holdings', NULL, 'Distribution', 'Transportation', NULL, NULL, '7104 May Way', 'Altadena', 'CA', '52614', 'USA', NULL, NULL, '431-555-4649', NULL, NULL, NULL, 'www.corcoran-goodtransportationholdings.com', NULL, NULL, NULL, NULL, '7104 May Way', 'Altadena', 'CA', '52614', 'USA', 0);
INSERT INTO accounts VALUES ('3348b98e-721d-c914-852f-438dfc65c395', '2005-11-30 19:22:51', '2005-11-30 19:22:51', '1', 'will_id', '1', 'N & O Grosvenor Electronics, Inc', NULL, 'Supply', 'Electronics', NULL, NULL, '6891 Relis Valley Road', 'Santa Monica', 'CA', '54729', 'USA', NULL, NULL, '681-555-2028', NULL, NULL, NULL, 'www.nogrosvenorelectronics,inc.com', NULL, NULL, NULL, NULL, '6891 Relis Valley Road', 'Santa Monica', 'CA', '54729', 'USA', 0);
INSERT INTO accounts VALUES ('b654628e-362d-8623-200b-438dfc160cb2', '2005-11-30 19:22:51', '2005-11-30 19:22:51', '1', 'kristen_id', '1', 'Grosvenor-Smrha Machinery Group', NULL, 'Distribution', 'Machinery', NULL, NULL, '2313 Santa Cruz Drive', 'Berkeley', 'CA', '44955', 'USA', NULL, NULL, '777-555-8635', NULL, NULL, NULL, 'www.grosvenor-smrhamachinerygroup.com', NULL, NULL, NULL, NULL, '2313 Santa Cruz Drive', 'Berkeley', 'CA', '44955', 'USA', 0);
INSERT INTO accounts VALUES ('6ae0a1e2-cece-b38d-237a-438dfc684d06', '2005-11-30 19:22:52', '2005-11-30 19:22:52', '1', 'beth_id', '1', 'U & W Wright Construction Corp', NULL, 'Supply', 'Construction', NULL, NULL, '5009 Grasswood Circle', 'Lemon Grove', 'CA', '13232', 'USA', NULL, NULL, '262-555-6902', NULL, NULL, NULL, 'www.uwwrightconstructioncorp.com', NULL, NULL, NULL, NULL, '5009 Grasswood Circle', 'Lemon Grove', 'CA', '13232', 'USA', 0);
INSERT INTO accounts VALUES ('c61b206d-2e30-b36f-eed5-438dfc73c046', '2005-11-30 19:22:52', '2005-11-30 19:22:52', '1', 'max_id', '1', 'Wright-Kalman Electronics Company', NULL, 'Consulting', 'Electronics', NULL, NULL, '3340 Baywood Drive', 'Corvallis', 'OR', '94911', 'USA', NULL, NULL, '620-555-6795', NULL, NULL, NULL, 'www.wright-kalmanelectronicscompany.com', NULL, NULL, NULL, NULL, '3340 Baywood Drive', 'Corvallis', 'OR', '94911', 'USA', 0);
INSERT INTO accounts VALUES ('2ad884a9-8705-3671-3b1b-438dfcf263fa', '2005-11-30 19:22:53', '2005-11-30 19:22:53', '1', 'chris_id', '1', 'M & K Ponce Telecommunications, Ltd', NULL, 'Supply', 'Telecommunications', NULL, NULL, '7537 Kaski Lane', 'Cliffside', 'BC', '29350', 'Canada', NULL, NULL, '255-555-5088', NULL, NULL, NULL, 'www.mkponcetelecommunications,ltd.com', NULL, NULL, NULL, NULL, '7537 Kaski Lane', 'Cliffside', 'BC', '29350', 'Canada', 0);
INSERT INTO accounts VALUES ('5b392773-b350-e644-1e5f-438dfc976788', '2005-11-30 19:22:53', '2005-11-30 19:22:53', '1', 'sarah_id', '1', 'Ponce-Borrelli Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '8778 So. Silver Spring', 'El Cajon', 'CA', '50899', 'USA', NULL, NULL, '396-555-8952', NULL, NULL, NULL, 'www.ponce-borrellimachinery,ltd.com', NULL, NULL, NULL, NULL, '8778 So. Silver Spring', 'El Cajon', 'CA', '50899', 'USA', 0);
INSERT INTO accounts VALUES ('b6f3e8a1-3732-6193-0153-438dfc83d486', '2005-11-30 19:22:53', '2005-11-30 19:22:53', '1', 'beth_id', '1', 'L & E Gillmore Communications Partners', NULL, 'Distribution', 'Communications', NULL, NULL, '1983 Santa Cruz', 'Burnaby', 'BC', '50499', 'Canada', NULL, NULL, '293-555-9531', NULL, NULL, NULL, 'www.legillmorecommunicationspartners.com', NULL, NULL, NULL, NULL, '1983 Santa Cruz', 'Burnaby', 'BC', '50499', 'Canada', 0);
INSERT INTO accounts VALUES ('1ba04981-4ef6-6ed0-8e17-438dfc1eb2f6', '2005-11-30 19:22:54', '2005-11-30 19:22:54', '1', 'sally_id', '1', 'Gillmore-Mixon Construction Holdings', NULL, 'Consulting', 'Construction', NULL, NULL, '3478 Liana Lane', 'Bremerton', 'WA', '38210', 'USA', NULL, NULL, '697-555-6680', NULL, NULL, NULL, 'www.gillmore-mixonconstructionholdings.com', NULL, NULL, NULL, NULL, '3478 Liana Lane', 'Bremerton', 'WA', '38210', 'USA', 0);
INSERT INTO accounts VALUES ('7492d5ae-dfba-6e60-5f6b-438dfc9ebfe6', '2005-11-30 19:22:54', '2005-11-30 19:22:54', '1', 'kristen_id', '1', 'W & N Tommerup Telecommunications Partners', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '6936 Andrews Drive', 'San Diego', 'CA', '39712', 'USA', NULL, NULL, '377-555-2230', NULL, NULL, NULL, 'www.wntommeruptelecommunicationspartners.com', NULL, NULL, NULL, NULL, '6936 Andrews Drive', 'San Diego', 'CA', '39712', 'USA', 0);
INSERT INTO accounts VALUES ('2ea7c9d3-0784-d9b9-2a4b-438dfcf8c620', '2005-11-30 19:22:55', '2005-11-30 19:22:55', '1', 'sally_id', '1', 'Tommerup-Martinez Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '1342 Isla Bonita', 'Woodland Hills', 'CA', '56843', 'USA', NULL, NULL, '143-555-1666', NULL, NULL, NULL, 'www.tommerup-martineztransportationholdings.com', NULL, NULL, NULL, NULL, '1342 Isla Bonita', 'Woodland Hills', 'CA', '56843', 'USA', 0);
INSERT INTO accounts VALUES ('88142010-9a16-7fad-97d5-438dfc2da9d0', '2005-11-30 19:22:55', '2005-11-30 19:22:55', '1', 'beth_id', '1', 'V & A Glancy Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '7710 Pine St', 'Milwaukie', 'OR', '61474', 'USA', NULL, NULL, '985-555-8502', NULL, NULL, NULL, 'www.vaglancytransportationcorp.com', NULL, NULL, NULL, NULL, '7710 Pine St', 'Milwaukie', 'OR', '61474', 'USA', 0);
INSERT INTO accounts VALUES ('bad8904a-8332-da27-a94c-438dfcaefdb0', '2005-11-30 19:22:55', '2005-11-30 19:22:55', '1', 'max_id', '1', 'Glancy-Cappa Communications Corp', NULL, 'Consulting', 'Communications', NULL, NULL, '9713 Amhurst Way', 'Glendale', 'CA', '80508', 'USA', NULL, NULL, '774-555-6566', NULL, NULL, NULL, 'www.glancy-cappacommunicationscorp.com', NULL, NULL, NULL, NULL, '9713 Amhurst Way', 'Glendale', 'CA', '80508', 'USA', 0);
INSERT INTO accounts VALUES ('7285b03b-f984-af24-7766-438dfc2d4fd1', '2005-11-30 19:22:56', '2005-11-30 19:22:56', '1', 'sally_id', '1', 'T & A Netz Electronics, Inc', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '8991 Olivera', 'Redmond', 'WA', '51300', 'USA', NULL, NULL, '739-555-3030', NULL, NULL, NULL, 'www.tanetzelectronics,inc.com', NULL, NULL, NULL, NULL, '8991 Olivera', 'Redmond', 'WA', '51300', 'USA', 0);
INSERT INTO accounts VALUES ('ce702aea-7cc2-7743-d67d-438dfc418801', '2005-11-30 19:22:56', '2005-11-30 19:22:56', '1', 'matt_id', '1', 'Netz-Blanc Construction Associates', NULL, 'Manufacturing', 'Construction', NULL, NULL, '3905 Harvard Drive', 'Santa Anita', 'DF', '81296', 'Mexico', NULL, NULL, '550-555-8723', NULL, NULL, NULL, 'www.netz-blancconstructionassociates.com', NULL, NULL, NULL, NULL, '3905 Harvard Drive', 'Santa Anita', 'DF', '81296', 'Mexico', 0);
INSERT INTO accounts VALUES ('5d7daa65-e669-d1cc-a6fa-438dfc8de07d', '2005-11-30 19:22:57', '2005-11-30 19:22:57', '1', 'chris_id', '1', 'D & D Collins Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '782 Veale Avenue', 'Oakland', 'CA', '44542', 'USA', NULL, NULL, '243-555-3528', NULL, NULL, NULL, 'www.ddcollinselectronicsholdings.com', NULL, NULL, NULL, NULL, '782 Veale Avenue', 'Oakland', 'CA', '44542', 'USA', 0);
INSERT INTO accounts VALUES ('ba5dd704-982d-5927-37a6-438dfc7f3e9b', '2005-11-30 19:22:57', '2005-11-30 19:22:57', '1', 'sarah_id', '1', 'Collins-Scroggins Machinery, Inc', NULL, 'Distribution', 'Machinery', NULL, NULL, '8605 Flamingo Dr', 'Metchosin', 'BC', '68606', 'Canada', NULL, NULL, '316-555-2507', NULL, NULL, NULL, 'www.collins-scrogginsmachinery,inc.com', NULL, NULL, NULL, NULL, '8605 Flamingo Dr', 'Metchosin', 'BC', '68606', 'Canada', 0);
INSERT INTO accounts VALUES ('4a1ee6a0-25ee-6a7a-f7a5-438dfc317653', '2005-11-30 19:22:58', '2005-11-30 19:22:58', '1', 'sally_id', '1', 'I & V Marsh Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '8391 Olivera', 'Metchosin', 'BC', '70721', 'Canada', NULL, NULL, '566-555-8885', NULL, NULL, NULL, 'www.ivmarshengineering,inc.com', NULL, NULL, NULL, NULL, '8391 Olivera', 'Metchosin', 'BC', '70721', 'Canada', 0);
INSERT INTO accounts VALUES ('d1ddc9ee-af9d-f257-89be-438dfcdc46fc', '2005-11-30 19:22:58', '2005-11-30 19:22:58', '1', 'beth_id', '1', 'Marsh-Robinson Construction, Ltd', NULL, 'Manufacturing', 'Construction', NULL, NULL, '6469 Ethan Ct', 'Richmond', 'BC', '87240', 'Canada', NULL, NULL, '662-555-6493', NULL, NULL, NULL, 'www.marsh-robinsonconstruction,ltd.com', NULL, NULL, NULL, NULL, '6469 Ethan Ct', 'Richmond', 'BC', '87240', 'Canada', 0);
INSERT INTO accounts VALUES ('f5da0877-97a9-1cc3-c0ad-438dfca40468', '2005-11-30 19:22:59', '2005-11-30 19:22:59', '1', 'matt_id', '1', 'K & R Cox Communications Group', NULL, 'Consulting', 'Communications', NULL, NULL, '6509 California Street', 'Burbank', 'CA', '55517', 'USA', NULL, NULL, '935-555-2500', NULL, NULL, NULL, 'www.krcoxcommunicationsgroup.com', NULL, NULL, NULL, NULL, '6509 California Street', 'Burbank', 'CA', '55517', 'USA', 0);
INSERT INTO accounts VALUES ('40f5032c-52e9-76ab-c376-438dfc53b0e6', '2005-11-30 19:22:59', '2005-11-30 19:22:59', '1', 'jaime_id', '1', 'Cox-Clare Engineering Associates', NULL, 'Distribution', 'Engineering', NULL, NULL, '7496 Sunset Meadows', 'Los Angeles', 'CA', '38197', 'USA', NULL, NULL, '393-555-2393', NULL, NULL, NULL, 'www.cox-clareengineeringassociates.com', NULL, NULL, NULL, NULL, '7496 Sunset Meadows', 'Los Angeles', 'CA', '38197', 'USA', 0);
INSERT INTO accounts VALUES ('9f4db6ad-aeb6-b920-a4d0-438dfccfb949', '2005-11-30 19:22:59', '2005-11-30 19:22:59', '1', 'max_id', '1', 'B & P Barnurn Telecommunications Holdings', NULL, 'Distribution', 'Telecommunications', NULL, NULL, '7791 Black Pine Lane', 'Coronado', 'CA', '45343', 'USA', NULL, NULL, '928-555-9686', NULL, NULL, NULL, 'www.bpbarnurntelecommunicationsholdings.com', NULL, NULL, NULL, NULL, '7791 Black Pine Lane', 'Coronado', 'CA', '45343', 'USA', 0);
INSERT INTO accounts VALUES ('6c780887-b1a5-0c37-cb6c-438dfce0f0d3', '2005-11-30 19:23:00', '2005-11-30 19:23:00', '1', 'kristen_id', '1', 'Barnurn-Chrisman Electronics, Ltd', NULL, 'Distribution', 'Electronics', NULL, NULL, '9032 Santa Fe', 'La Cruz', 'Sinaloa', '93184', 'Mexico', NULL, NULL, '409-555-8207', NULL, NULL, NULL, 'www.barnurn-chrismanelectronics,ltd.com', NULL, NULL, NULL, NULL, '9032 Santa Fe', 'La Cruz', 'Sinaloa', '93184', 'Mexico', 0);
INSERT INTO accounts VALUES ('6947c741-d69a-c50a-32c6-438dfcfba4b1', '2005-11-30 19:23:00', '2005-11-30 19:23:00', '1', 'chris_id', '1', 'Q & P Taryle Telecommunications Company', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, '2237 Boca Raton Court', 'Shawnee', 'BC', '66491', 'Canada', NULL, NULL, '966-555-5128', NULL, NULL, NULL, 'www.qptaryletelecommunicationscompany.com', NULL, NULL, NULL, NULL, '2237 Boca Raton Court', 'Shawnee', 'BC', '66491', 'Canada', 0);
INSERT INTO accounts VALUES ('f1013808-d829-d48e-3273-438dfc5b4db7', '2005-11-30 19:23:00', '2005-11-30 19:23:00', '1', 'beth_id', '1', 'Taryle-Spencer Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '3732 Camino Norte', 'Yakima', 'WA', '80495', 'USA', NULL, NULL, '470-555-2278', NULL, NULL, NULL, 'www.taryle-spencertransportationholdings.com', NULL, NULL, NULL, NULL, '3732 Camino Norte', 'Yakima', 'WA', '80495', 'USA', 0);
INSERT INTO accounts VALUES ('ae8527b5-109f-deea-06e4-438dfcc22740', '2005-11-30 19:23:01', '2005-11-30 19:23:01', '1', 'kristen_id', '1', 'G & N Tribble Communications Group', NULL, 'Supply', 'Communications', NULL, NULL, '9846 Powell Drive', 'Long Beach', 'CA', '19964', 'USA', NULL, NULL, '390-555-1486', NULL, NULL, NULL, 'www.gntribblecommunicationsgroup.com', NULL, NULL, NULL, NULL, '9846 Powell Drive', 'Long Beach', 'CA', '19964', 'USA', 0);
INSERT INTO accounts VALUES ('15219ad3-ea69-968a-df11-438dfcfc7a29', '2005-11-30 19:23:02', '2005-11-30 19:23:02', '1', 'kristen_id', '1', 'Tribble-Skapinok Construction Partners', NULL, 'Distribution', 'Construction', NULL, NULL, '1596 Bryce Dr', 'Lynnwood', 'WA', '72836', 'USA', NULL, NULL, '816-555-6264', NULL, NULL, NULL, 'www.tribble-skapinokconstructionpartners.com', NULL, NULL, NULL, NULL, '1596 Bryce Dr', 'Lynnwood', 'WA', '72836', 'USA', 0);
INSERT INTO accounts VALUES ('45b906e0-9cb3-4c7a-df6f-438dfc9be258', '2005-11-30 19:23:02', '2005-11-30 19:23:02', '1', 'kristen_id', '1', 'H & Y Belleci Electronics, Ltd', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '7964 Gentrytown Drive', 'Port Orchard', 'WA', '47592', 'USA', NULL, NULL, '871-555-6360', NULL, NULL, NULL, 'www.hybellecielectronics,ltd.com', NULL, NULL, NULL, NULL, '7964 Gentrytown Drive', 'Port Orchard', 'WA', '47592', 'USA', 0);
INSERT INTO accounts VALUES ('75dbb3c5-710a-b367-717c-438dfcc55f67', '2005-11-30 19:23:02', '2005-11-30 19:23:02', '1', 'chris_id', '1', 'Belleci-Armstrong Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '2624 Pome Court', 'Santa Anita', 'DF', '23793', 'Mexico', NULL, NULL, '659-555-4424', NULL, NULL, NULL, 'www.belleci-armstrongtransportationholdings.com', NULL, NULL, NULL, NULL, '2624 Pome Court', 'Santa Anita', 'DF', '23793', 'Mexico', 0);
INSERT INTO accounts VALUES ('a8db442f-b908-57c2-4caf-438dfcd5c45b', '2005-11-30 19:23:02', '2005-11-30 19:23:02', '1', 'sarah_id', '1', 'O & K Koeber Transportation Corp', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '9245 Escobar', 'Burien', 'WA', '93584', 'USA', NULL, NULL, '624-555-9888', NULL, NULL, NULL, 'www.okkoebertransportationcorp.com', NULL, NULL, NULL, NULL, '9245 Escobar', 'Burien', 'WA', '93584', 'USA', 0);
INSERT INTO accounts VALUES ('d8fd3433-b8b5-9a6a-8f33-438dfcce7e1e', '2005-11-30 19:23:02', '2005-11-30 19:23:02', '1', 'beth_id', '1', 'Koeber-Wagner Construction Partners', NULL, 'Consulting', 'Construction', NULL, NULL, '4159 Apple Drive', 'Bellflower', 'CA', '78780', 'USA', NULL, NULL, '675-555-1238', NULL, NULL, NULL, 'www.koeber-wagnerconstructionpartners.com', NULL, NULL, NULL, NULL, '4159 Apple Drive', 'Bellflower', 'CA', '78780', 'USA', 0);
INSERT INTO accounts VALUES ('14c49ab1-5c89-20b7-c3cd-438dfc37065c', '2005-11-30 19:23:03', '2005-11-30 19:23:03', '1', 'sally_id', '1', 'D & D Noice Transportation, Ltd', NULL, 'Distribution', 'Transportation', NULL, NULL, '3692 Morales', 'Kirkland', 'WA', '13829', 'USA', NULL, NULL, '663-555-5331', NULL, NULL, NULL, 'www.ddnoicetransportation,ltd.com', NULL, NULL, NULL, NULL, '3692 Morales', 'Kirkland', 'WA', '13829', 'USA', 0);
INSERT INTO accounts VALUES ('4529b043-8473-f470-da4b-438dfc4ff3d2', '2005-11-30 19:23:03', '2005-11-30 19:23:03', '1', 'kristen_id', '1', 'Noice-Lindall Machinery, Inc', NULL, 'Consulting', 'Machinery', NULL, NULL, '8859 Wood Ranch Circle', 'San Diego', 'CA', '64186', 'USA', NULL, NULL, '736-555-4310', NULL, NULL, NULL, 'www.noice-lindallmachinery,inc.com', NULL, NULL, NULL, NULL, '8859 Wood Ranch Circle', 'San Diego', 'CA', '64186', 'USA', 0);
INSERT INTO accounts VALUES ('cdedf12f-00c6-96ab-ead9-438dfc45f071', '2005-11-30 19:23:03', '2005-11-30 19:23:03', '1', 'beth_id', '1', 'E & M Noakes Electronics Company', NULL, 'Supply', 'Electronics', NULL, NULL, '5826 Norman Avenue', 'Puyallup', 'WA', '66301', 'USA', NULL, NULL, '986-555-1688', NULL, NULL, NULL, 'www.emnoakeselectronicscompany.com', NULL, NULL, NULL, NULL, '5826 Norman Avenue', 'Puyallup', 'WA', '66301', 'USA', 0);
INSERT INTO accounts VALUES ('601fcce4-b0ac-96c8-317e-438dfccc081c', '2005-11-30 19:23:04', '2005-11-30 19:23:04', '1', 'matt_id', '1', 'Noakes-Mc Nair Engineering, Ltd', NULL, 'Distribution', 'Engineering', NULL, NULL, '3904 Piedra Drive', 'Sooke', 'BC', '82820', 'Canada', NULL, NULL, '182-555-8295', NULL, NULL, NULL, 'www.noakes-mcnairengineering,ltd.com', NULL, NULL, NULL, NULL, '3904 Piedra Drive', 'Sooke', 'BC', '82820', 'Canada', 0);
INSERT INTO accounts VALUES ('ea0fe542-2c78-f2f9-e743-438dfc119cf8', '2005-11-30 19:23:04', '2005-11-30 19:23:04', '1', 'matt_id', '1', 'R & Z Ceballos Communications, Inc', NULL, 'Distribution', 'Communications', NULL, NULL, '6600 Maricopa', 'Richmond', 'CA', '51096', 'USA', NULL, NULL, '694-555-7960', NULL, NULL, NULL, 'www.rzceballoscommunications,inc.com', NULL, NULL, NULL, NULL, '6600 Maricopa', 'Richmond', 'CA', '51096', 'USA', 0);
INSERT INTO accounts VALUES ('515ebf84-c673-1c9c-f5fc-438dfc99ece3', '2005-11-30 19:23:05', '2005-11-30 19:23:05', '1', 'chris_id', '1', 'Ceballos-Landrum Machinery Partners', NULL, 'Supply', 'Machinery', NULL, NULL, '4932 La Jolla', 'Haney', 'BC', '74852', 'Canada', NULL, NULL, '813-555-4195', NULL, NULL, NULL, 'www.ceballos-landrummachinerypartners.com', NULL, NULL, NULL, NULL, '4932 La Jolla', 'Haney', 'BC', '74852', 'Canada', 0);
INSERT INTO accounts VALUES ('db95808c-1342-bf59-0da1-438dfcf16624', '2005-11-30 19:23:05', '2005-11-30 19:23:05', '1', 'sarah_id', '1', 'J & K Netz Communications Corp', NULL, 'Supply', 'Communications', NULL, NULL, '7882 Las Lomas Way', 'Redmond', 'WA', '40922', 'USA', NULL, NULL, '448-555-2488', NULL, NULL, NULL, 'www.jknetzcommunicationscorp.com', NULL, NULL, NULL, NULL, '7882 Las Lomas Way', 'Redmond', 'WA', '40922', 'USA', 0);
INSERT INTO accounts VALUES ('432ef0db-2c18-bb20-548f-438dfccc8682', '2005-11-30 19:23:06', '2005-11-30 19:23:06', '1', 'sally_id', '1', 'Netz-Amyotte Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '6467 Buena Vista', 'San Jose', 'CA', '62472', 'USA', NULL, NULL, '829-555-1010', NULL, NULL, NULL, 'www.netz-amyotteconstruction,ltd.com', NULL, NULL, NULL, NULL, '6467 Buena Vista', 'San Jose', 'CA', '62472', 'USA', 0);
INSERT INTO accounts VALUES ('609003bf-2a08-438b-2cdc-438dfca0b6a1', '2005-11-30 19:23:07', '2005-11-30 19:23:07', '1', 'max_id', '1', 'W & W Watson Electronics Associates', NULL, 'Supply', 'Electronics', NULL, NULL, '9671 Leewood Place', 'San Diego', 'CA', '62071', 'USA', NULL, NULL, '486-555-6931', NULL, NULL, NULL, 'www.wwwatsonelectronicsassociates.com', NULL, NULL, NULL, NULL, '9671 Leewood Place', 'San Diego', 'CA', '62071', 'USA', 0);
INSERT INTO accounts VALUES ('6204bccd-609d-2069-13ee-438dfc168e35', '2005-11-30 19:23:07', '2005-11-30 19:23:07', '1', 'max_id', '1', 'Watson-Waddle Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '1168 Escobar', 'Woodland Hills', 'CA', '49782', 'USA', NULL, NULL, '580-555-4656', NULL, NULL, NULL, 'www.watson-waddlemachinerygroup.com', NULL, NULL, NULL, NULL, '1168 Escobar', 'Woodland Hills', 'CA', '49782', 'USA', 0);
INSERT INTO accounts VALUES ('94e43fe9-95af-d874-e9fc-438dfcf5d51c', '2005-11-30 19:23:07', '2005-11-30 19:23:07', '1', 'beth_id', '1', 'D & G Shintani Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '7281 Barberry Court', 'Sooke', 'BC', '15544', 'Canada', NULL, NULL, '500-555-3863', NULL, NULL, NULL, 'www.dgshintanitransportation,inc.com', NULL, NULL, NULL, NULL, '7281 Barberry Court', 'Sooke', 'BC', '15544', 'Canada', 0);
INSERT INTO accounts VALUES ('c594dad7-18a9-dfa1-5f69-438dfca073ba', '2005-11-30 19:23:07', '2005-11-30 19:23:07', '1', 'matt_id', '1', 'Shintani-Chavez Engineering, Ltd', NULL, 'Supply', 'Engineering', NULL, NULL, '9030 Louisiana Dr.', 'Long Beach', 'CA', '68416', 'USA', NULL, NULL, '926-555-8642', NULL, NULL, NULL, 'www.shintani-chavezengineering,ltd.com', NULL, NULL, NULL, NULL, '9030 Louisiana Dr.', 'Long Beach', 'CA', '68416', 'USA', 0);
INSERT INTO accounts VALUES ('1988011e-1fb0-7f64-6f56-438dfca9f939', '2005-11-30 19:23:08', '2005-11-30 19:23:08', '1', 'jaime_id', '1', 'Z & L Wilson Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '5399 Red Maple Ct.', 'Arcadia', 'CA', '73046', 'USA', NULL, NULL, '869-555-6477', NULL, NULL, NULL, 'www.zlwilsonconstruction,ltd.com', NULL, NULL, NULL, NULL, '5399 Red Maple Ct.', 'Arcadia', 'CA', '73046', 'USA', 0);
INSERT INTO accounts VALUES ('32300f8e-5ff9-1d8d-0510-438dfc3e860f', '2005-11-30 19:23:08', '2005-11-30 19:23:08', '1', 'will_id', '1', 'Wilson-Gill Transportation Group', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '59 Sharon Place', 'Woodburn', 'OR', '92080', 'USA', NULL, NULL, '657-555-4542', NULL, NULL, NULL, 'www.wilson-gilltransportationgroup.com', NULL, NULL, NULL, NULL, '59 Sharon Place', 'Woodburn', 'OR', '92080', 'USA', 0);
INSERT INTO accounts VALUES ('8e8513ea-8926-9895-3afd-438dfcf13b88', '2005-11-30 19:23:08', '2005-11-30 19:23:08', '1', 'max_id', '1', 'V & P Smallwood Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '6681 Pestana Way', 'Fremont', 'CA', '89164', 'USA', NULL, NULL, '622-555-1006', NULL, NULL, NULL, 'www.vpsmallwoodtransportationcorp.com', NULL, NULL, NULL, NULL, '6681 Pestana Way', 'Fremont', 'CA', '89164', 'USA', 0);
INSERT INTO accounts VALUES ('ed96efc5-56ff-f8c8-b303-438dfcf7a76b', '2005-11-30 19:23:08', '2005-11-30 19:23:08', '1', 'will_id', '1', 'Smallwood-Chavez Telecommunications, Inc', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '4250 Huston Rd', 'Langley', 'BC', '74360', 'Canada', NULL, NULL, '673-555-1356', NULL, NULL, NULL, 'www.smallwood-chaveztelecommunications,inc.com', NULL, NULL, NULL, NULL, '4250 Huston Rd', 'Langley', 'BC', '74360', 'Canada', 0);
INSERT INTO accounts VALUES ('4206630a-0fc2-0692-269f-438dfc3dce7a', '2005-11-30 19:23:09', '2005-11-30 19:23:09', '1', 'matt_id', '1', 'F & X Blackburn Communications Partners', NULL, 'Consulting', 'Communications', NULL, NULL, '1127 Wellington Avenue', 'Salem', 'OR', '35991', 'USA', NULL, NULL, '661-555-5449', NULL, NULL, NULL, 'www.fxblackburncommunicationspartners.com', NULL, NULL, NULL, NULL, '1127 Wellington Avenue', 'Salem', 'OR', '35991', 'USA', 0);
INSERT INTO accounts VALUES ('cde328fd-1085-f663-68a5-438dfcfb2788', '2005-11-30 19:23:09', '2005-11-30 19:23:09', '1', 'sally_id', '1', 'Blackburn-Abston Communications Holdings', NULL, 'Distribution', 'Communications', NULL, NULL, '8950 Glenwood Dr.', 'Concord', 'CA', '86348', 'USA', NULL, NULL, '734-555-4427', NULL, NULL, NULL, 'www.blackburn-abstoncommunicationsholdings.com', NULL, NULL, NULL, NULL, '8950 Glenwood Dr.', 'Concord', 'CA', '86348', 'USA', 0);
INSERT INTO accounts VALUES ('90a85cb5-09ae-3944-73d3-438dfc1ece40', '2005-11-30 19:23:10', '2005-11-30 19:23:10', '1', 'sarah_id', '1', 'S & X Blauvelt Engineering Partners', NULL, 'Distribution', 'Engineering', NULL, NULL, '8736 E. 62nd Street', 'Concord', 'CA', '88463', 'USA', NULL, NULL, '984-555-1806', NULL, NULL, NULL, 'www.sxblauveltengineeringpartners.com', NULL, NULL, NULL, NULL, '8736 E. 62nd Street', 'Concord', 'CA', '88463', 'USA', 0);
INSERT INTO accounts VALUES ('efdf250d-2235-3922-c847-438dfc7f2648', '2005-11-30 19:23:10', '2005-11-30 19:23:10', '1', 'sarah_id', '1', 'Blauvelt-Wardley Transportation, Inc', NULL, 'Supply', 'Transportation', NULL, NULL, '6814 Gatewood Court', 'La Jolla', 'CA', '78689', 'USA', NULL, NULL, '180-555-8413', NULL, NULL, NULL, 'www.blauvelt-wardleytransportation,inc.com', NULL, NULL, NULL, NULL, '6814 Gatewood Court', 'La Jolla', 'CA', '78689', 'USA', 0);
INSERT INTO accounts VALUES ('5897fd94-0082-4b99-926d-438dfceb8b63', '2005-11-30 19:23:11', '2005-11-30 19:23:11', '1', 'sarah_id', '1', 'H & N Durocher Machinery Corp', NULL, 'Supply', 'Machinery', NULL, NULL, '6854 Veale Ave.', 'Cliffside', 'BC', '46966', 'Canada', NULL, NULL, '692-555-8077', NULL, NULL, NULL, 'www.hndurochermachinerycorp.com', NULL, NULL, NULL, NULL, '6854 Veale Ave.', 'Cliffside', 'BC', '46966', 'Canada', 0);
INSERT INTO accounts VALUES ('4c9833d0-3c0d-cc22-667e-438dfc2cbfe0', '2005-11-30 19:23:12', '2005-11-30 19:23:12', '1', 'will_id', '1', 'Durocher-Terbush Machinery Associates', NULL, 'Supply', 'Machinery', NULL, NULL, '5186 Oeffler Ln.', 'Beaverton', 'OR', '29647', 'USA', NULL, NULL, '931-555-6336', NULL, NULL, NULL, 'www.durocher-terbushmachineryassociates.com', NULL, NULL, NULL, NULL, '5186 Oeffler Ln.', 'Beaverton', 'OR', '29647', 'USA', 0);
INSERT INTO accounts VALUES ('7e29ad13-68e1-2c33-12ac-438dfcaf4ea1', '2005-11-30 19:23:12', '2005-11-30 19:23:12', '1', 'max_id', '1', 'G & W Poisson Transportation, Inc', NULL, 'Distribution', 'Transportation', NULL, NULL, '8136 Guadalajara', 'Lebanon', 'OR', '63084', 'USA', NULL, NULL, '566-555-4629', NULL, NULL, NULL, 'www.gwpoissontransportation,inc.com', NULL, NULL, NULL, NULL, '8136 Guadalajara', 'Lebanon', 'OR', '63084', 'USA', 0);
INSERT INTO accounts VALUES ('df27c279-dd8b-4906-18d8-438dfc536de4', '2005-11-30 19:23:12', '2005-11-30 19:23:12', '1', 'matt_id', '1', 'Poisson-Cosby Machinery Corp', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '9377 Detroit Ave', 'Haney', 'BC', '84634', 'Canada', NULL, NULL, '947-555-3150', NULL, NULL, NULL, 'www.poisson-cosbymachinerycorp.com', NULL, NULL, NULL, NULL, '9377 Detroit Ave', 'Haney', 'BC', '84634', 'Canada', 0);
INSERT INTO accounts VALUES ('76d00a10-3ef0-9a5f-1f68-438dfc28d168', '2005-11-30 19:23:13', '2005-11-30 19:23:13', '1', 'beth_id', '1', 'V & B Oss Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '2582 California Street', 'Richmond', 'BC', '84233', 'Canada', NULL, NULL, '604-555-9071', NULL, NULL, NULL, 'www.vbosstransportationholdings.com', NULL, NULL, NULL, NULL, '2582 California Street', 'Richmond', 'BC', '84233', 'Canada', 0);
INSERT INTO accounts VALUES ('aad102f0-6ca6-3b3a-d374-438dfc18d752', '2005-11-30 19:23:13', '2005-11-30 19:23:13', '1', 'beth_id', '1', 'Oss-Smith Construction Company', NULL, 'Consulting', 'Construction', NULL, NULL, '4077 Chinquapin Ct', 'Burien', 'WA', '71944', 'USA', NULL, NULL, '108-555-6221', NULL, NULL, NULL, 'www.oss-smithconstructioncompany.com', NULL, NULL, NULL, NULL, '4077 Chinquapin Ct', 'Burien', 'WA', '71944', 'USA', 0);
INSERT INTO accounts VALUES ('14dd4d0a-360d-88c6-bed5-438dfc462ea2', '2005-11-30 19:23:14', '2005-11-30 19:23:14', '1', 'max_id', '1', 'C & A Christensen Engineering Group', NULL, 'Supply', 'Engineering', NULL, NULL, '7535 Roanoke Drive', 'Vancouver', 'BC', '11414', 'Canada', NULL, NULL, '927-555-5429', NULL, NULL, NULL, 'www.cachristensenengineeringgroup.com', NULL, NULL, NULL, NULL, '7535 Roanoke Drive', 'Vancouver', 'BC', '11414', 'Canada', 0);
INSERT INTO accounts VALUES ('72627cba-1687-f765-d88c-438dfc2f7978', '2005-11-30 19:23:14', '2005-11-30 19:23:14', '1', 'kristen_id', '1', 'Christensen-Pectol Construction, Ltd', NULL, 'Consulting', 'Construction', NULL, NULL, '1941 Hacienda', 'West Covina', 'CA', '90578', 'USA', NULL, NULL, '454-555-1207', NULL, NULL, NULL, 'www.christensen-pectolconstruction,ltd.com', NULL, NULL, NULL, NULL, '1941 Hacienda', 'West Covina', 'CA', '90578', 'USA', 0);
INSERT INTO accounts VALUES ('d3431f37-fcc8-2405-eb66-438dfc52eb4c', '2005-11-30 19:23:14', '2005-11-30 19:23:14', '1', 'chris_id', '1', 'U & S Baker Transportation, Inc', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '8309 Colonial Way', 'Woodland Hills', 'CA', '95208', 'USA', NULL, NULL, '396-555-8043', NULL, NULL, NULL, 'www.usbakertransportation,inc.com', NULL, NULL, NULL, NULL, '8309 Colonial Way', 'Woodland Hills', 'CA', '95208', 'USA', 0);
INSERT INTO accounts VALUES ('6b1fb4fa-6cb6-8534-d59c-438dfc75d9be', '2005-11-30 19:23:15', '2005-11-30 19:23:15', '1', 'will_id', '1', 'Baker-Finke Construction Group', NULL, 'Distribution', 'Construction', NULL, NULL, '313 Ladera', 'San Gabriel', 'CA', '15243', 'USA', NULL, NULL, '185-555-6107', NULL, NULL, NULL, 'www.baker-finkeconstructiongroup.com', NULL, NULL, NULL, NULL, '313 Ladera', 'San Gabriel', 'CA', '15243', 'USA', 0);
INSERT INTO accounts VALUES ('cb4e8fc7-f8f0-e1a2-d80b-438dfc2e57c1', '2005-11-30 19:23:15', '2005-11-30 19:23:15', '1', 'sarah_id', '1', 'N & W Beutel Transportation Corp', NULL, 'Distribution', 'Transportation', NULL, NULL, '9590 Galloway Dr', 'Grossmont', 'CA', '85034', 'USA', NULL, NULL, '389-555-6229', NULL, NULL, NULL, 'www.nwbeuteltransportationcorp.com', NULL, NULL, NULL, NULL, '9590 Galloway Dr', 'Grossmont', 'CA', '85034', 'USA', 0);
INSERT INTO accounts VALUES ('914ccf1c-bf0a-f7ed-58c5-438dfca75a45', '2005-11-30 19:23:16', '2005-11-30 19:23:16', '1', 'matt_id', '1', 'Beutel-Duvalle Engineering Partners', NULL, 'Supply', 'Engineering', NULL, NULL, '5751 Concord Place', 'San Andres', 'DF', '70230', 'Mexico', NULL, NULL, '200-555-2921', NULL, NULL, NULL, 'www.beutel-duvalleengineeringpartners.com', NULL, NULL, NULL, NULL, '5751 Concord Place', 'San Andres', 'DF', '70230', 'Mexico', 0);
INSERT INTO accounts VALUES ('f1baec4e-7c74-c96a-68a3-438dfc8cb99b', '2005-11-30 19:23:16', '2005-11-30 19:23:16', '1', 'sarah_id', '1', 'O & D Sloper Communications Associates', NULL, 'Distribution', 'Communications', NULL, NULL, '5283 Rishell Ct.', 'Richmond', 'CA', '71842', 'USA', NULL, NULL, '427-555-1672', NULL, NULL, NULL, 'www.odslopercommunicationsassociates.com', NULL, NULL, NULL, NULL, '5283 Rishell Ct.', 'Richmond', 'CA', '71842', 'USA', 0);
INSERT INTO accounts VALUES ('bab27711-9702-e9e0-da79-438dfcc3aa62', '2005-11-30 19:23:17', '2005-11-30 19:23:17', '1', 'sally_id', '1', 'Sloper-Weinzimmer Transportation Company', NULL, 'Consulting', 'Transportation', NULL, NULL, '451 Buskirk Ave.', 'Downey', 'CA', '20172', 'USA', NULL, NULL, '852-555-6568', NULL, NULL, NULL, 'www.sloper-weinzimmertransportationcompany.com', NULL, NULL, NULL, NULL, '451 Buskirk Ave.', 'Downey', 'CA', '20172', 'USA', 0);
INSERT INTO accounts VALUES ('eae78d25-3a40-ec1c-c24d-438dfc8f5eb2', '2005-11-30 19:23:17', '2005-11-30 19:23:17', '1', 'sally_id', '1', 'M & Y Moore Communications, Ltd', NULL, 'Supply', 'Communications', NULL, NULL, '237 Ashley Way', 'Ballard', 'WA', '41322', 'USA', NULL, NULL, '202-555-3946', NULL, NULL, NULL, 'www.mymoorecommunications,ltd.com', NULL, NULL, NULL, NULL, '237 Ashley Way', 'Ballard', 'WA', '41322', 'USA', 0);
INSERT INTO accounts VALUES ('2748039e-54c4-cb87-e152-438dfc2b0d6f', '2005-11-30 19:23:18', '2005-11-30 19:23:18', '1', 'beth_id', '1', 'Moore-Chaw Communications Associates', NULL, 'Consulting', 'Communications', NULL, NULL, '8314 Brandywine Way', 'San Diego', 'CA', '20650', 'USA', NULL, NULL, '298-555-1553', NULL, NULL, NULL, 'www.moore-chawcommunicationsassociates.com', NULL, NULL, NULL, NULL, '8314 Brandywine Way', 'San Diego', 'CA', '20650', 'USA', 0);
INSERT INTO accounts VALUES ('57ad5a94-8201-6bc2-5ae4-438dfc415be8', '2005-11-30 19:23:18', '2005-11-30 19:23:18', '1', 'max_id', '1', 'B & D Reitzel Machinery Partners', NULL, 'Consulting', 'Machinery', NULL, NULL, '8354 Ponderosa Drive', 'Santa Monica', 'CA', '87926', 'USA', NULL, NULL, '810-555-1218', NULL, NULL, NULL, 'www.bdreitzelmachinerypartners.com', NULL, NULL, NULL, NULL, '8354 Ponderosa Drive', 'Santa Monica', 'CA', '87926', 'USA', 0);
INSERT INTO accounts VALUES ('883c8ad1-e540-4dd6-ccb1-438dfc95b2c7', '2005-11-30 19:23:18', '2005-11-30 19:23:18', '1', 'sarah_id', '1', 'Reitzel-Horbach Construction Partners', NULL, 'Manufacturing', 'Construction', NULL, NULL, '9341 Horseshoe Circle', 'Camacho', 'Zacatecas', '44314', 'Mexico', NULL, NULL, '929-555-6453', NULL, NULL, NULL, 'www.reitzel-horbachconstructionpartners.com', NULL, NULL, NULL, NULL, '9341 Horseshoe Circle', 'Camacho', 'Zacatecas', '44314', 'Mexico', 0);
INSERT INTO accounts VALUES ('bba46bbd-e936-368b-f563-438dfc060181', '2005-11-30 19:23:18', '2005-11-30 19:23:18', '1', 'kristen_id', '1', 'H & E Knobel Machinery Group', NULL, 'Supply', 'Machinery', NULL, NULL, '9636 Palisade Court', 'Colma', 'CA', '77752', 'USA', NULL, NULL, '564-555-4746', NULL, NULL, NULL, 'www.heknobelmachinerygroup.com', NULL, NULL, NULL, NULL, '9636 Palisade Court', 'Colma', 'CA', '77752', 'USA', 0);
INSERT INTO accounts VALUES ('ebe2430a-1961-633a-a68d-438dfc818e50', '2005-11-30 19:23:18', '2005-11-30 19:23:18', '1', 'beth_id', '1', 'Knobel-Hope Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '878 Amador Ct', 'Burbank', 'CA', '26594', 'USA', NULL, NULL, '944-555-3268', NULL, NULL, NULL, 'www.knobel-hopeelectronicsholdings.com', NULL, NULL, NULL, NULL, '878 Amador Ct', 'Burbank', 'CA', '26594', 'USA', 0);
INSERT INTO accounts VALUES ('281a7cd0-fb77-6171-1a50-438dfc3c109a', '2005-11-30 19:23:19', '2005-11-30 19:23:19', '1', 'max_id', '1', 'X & M Fisher Construction Corp', NULL, 'Manufacturing', 'Construction', NULL, NULL, '4082 Virginia Hills', 'Issaquah', 'WA', '98901', 'USA', NULL, NULL, '602-555-9189', NULL, NULL, NULL, 'www.xmfisherconstructioncorp.com', NULL, NULL, NULL, NULL, '4082 Virginia Hills', 'Issaquah', 'WA', '98901', 'USA', 0);
INSERT INTO accounts VALUES ('5926592f-9977-2855-c423-438dfcd03f4c', '2005-11-30 19:23:19', '2005-11-30 19:23:19', '1', 'sally_id', '1', 'Fisher-Dabit Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '5577 Laredo', 'Vancouver', 'BC', '13905', 'Canada', NULL, NULL, '106-555-6339', NULL, NULL, NULL, 'www.fisher-dabittelecommunications,ltd.com', NULL, NULL, NULL, NULL, '5577 Laredo', 'Vancouver', 'BC', '13905', 'Canada', 0);
INSERT INTO accounts VALUES ('8a3f3731-8ac9-e132-840e-438dfc018323', '2005-11-30 19:23:19', '2005-11-30 19:23:19', '1', 'chris_id', '1', 'I & M Turner Transportation, Ltd', NULL, 'Supply', 'Transportation', NULL, NULL, '1692 Detroit Ave', 'San Carlos', 'CA', '52373', 'USA', NULL, NULL, '925-555-5546', NULL, NULL, NULL, 'www.imturnertransportation,ltd.com', NULL, NULL, NULL, NULL, '1692 Detroit Ave', 'San Carlos', 'CA', '52373', 'USA', 0);
INSERT INTO accounts VALUES ('bf2aa340-1a5b-b67c-5244-438dfcb55652', '2005-11-30 19:23:19', '2005-11-30 19:23:19', '1', 'will_id', '1', 'Turner-Clark Electronics Corp', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '3441 Wellington Ct.', 'Oak Bay', 'BC', '62463', 'Canada', NULL, NULL, '452-555-1325', NULL, NULL, NULL, 'www.turner-clarkelectronicscorp.com', NULL, NULL, NULL, NULL, '3441 Wellington Ct.', 'Oak Bay', 'BC', '62463', 'Canada', 0);
INSERT INTO accounts VALUES ('f2b6de7a-dfb9-1f15-8d7a-438dfcedbe55', '2005-11-30 19:23:19', '2005-11-30 19:23:19', '1', 'kristen_id', '1', 'H & Y Schimanski Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '9809 Cardinet Drive', 'Langford', 'BC', '37169', 'Canada', NULL, NULL, '394-555-8160', NULL, NULL, NULL, 'www.hyschimanskiengineering,inc.com', NULL, NULL, NULL, NULL, '9809 Cardinet Drive', 'Langford', 'BC', '37169', 'Canada', 0);
INSERT INTO accounts VALUES ('2f4ab363-a0e3-ee3e-0807-438dfcef783d', '2005-11-30 19:23:20', '2005-11-30 19:23:20', '1', 'jaime_id', '1', 'Schimanski-Alumbaugh Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '4469 Dellwood Court', 'Lemon Grove', 'CA', '56203', 'USA', NULL, NULL, '183-555-6225', NULL, NULL, NULL, 'www.schimanski-alumbaughtelecommunications,ltd.com', NULL, NULL, NULL, NULL, '4469 Dellwood Court', 'Lemon Grove', 'CA', '56203', 'USA', 0);
INSERT INTO accounts VALUES ('5f78a5ac-c8e4-d74e-de14-438dfc4ba53c', '2005-11-30 19:23:20', '2005-11-30 19:23:20', '1', 'sally_id', '1', 'D & A Benson Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '1092 Boxer Blvd', 'Port Hammond', 'BC', '26995', 'Canada', NULL, NULL, '499-555-8606', NULL, NULL, NULL, 'www.dabensonmachinerygroup.com', NULL, NULL, NULL, NULL, '1092 Boxer Blvd', 'Port Hammond', 'BC', '26995', 'Canada', 0);
INSERT INTO accounts VALUES ('90f58c4a-8556-0ec0-c999-438dfcb4680a', '2005-11-30 19:23:20', '2005-11-30 19:23:20', '1', 'max_id', '1', 'Benson-Rusch Construction Associates', NULL, 'Consulting', 'Construction', NULL, NULL, '6005 Sun View Drive', 'Arcadia', 'CA', '12191', 'USA', NULL, NULL, '310-555-5299', NULL, NULL, NULL, 'www.benson-ruschconstructionassociates.com', NULL, NULL, NULL, NULL, '6005 Sun View Drive', 'Arcadia', 'CA', '12191', 'USA', 0);
INSERT INTO accounts VALUES ('c6ab6a84-2c1d-6ee1-fb84-438dfc7a9b31', '2005-11-30 19:23:20', '2005-11-30 19:23:20', '1', 'max_id', '1', 'D & Z Cocadiz Electronics, Ltd', NULL, 'Consulting', 'Electronics', NULL, NULL, '5537 Broadway', 'Spokane', 'WA', '48144', 'USA', NULL, NULL, '537-555-4049', NULL, NULL, NULL, 'www.dzcocadizelectronics,ltd.com', NULL, NULL, NULL, NULL, '5537 Broadway', 'Spokane', 'WA', '48144', 'USA', 0);
INSERT INTO accounts VALUES ('5db004c3-0bc7-0f1f-0333-438dfc1dd327', '2005-11-30 19:23:21', '2005-11-30 19:23:21', '1', 'kristen_id', '1', 'Cocadiz-Mcgough Engineering Corp', NULL, 'Consulting', 'Engineering', NULL, NULL, '705 Seaview Avenue', 'Colma', 'CA', '98500', 'USA', NULL, NULL, '372-555-8370', NULL, NULL, NULL, 'www.cocadiz-mcgoughengineeringcorp.com', NULL, NULL, NULL, NULL, '705 Seaview Avenue', 'Colma', 'CA', '98500', 'USA', 0);
INSERT INTO accounts VALUES ('37ed14c6-a48d-5a88-32de-438dfc344b87', '2005-11-30 19:23:21', '2005-11-30 19:23:21', '1', 'will_id', '1', 'Q & Q King Telecommunications Associates', NULL, 'Supply', 'Telecommunications', NULL, NULL, '491 Cali', 'Mexico City', 'Mexico', '26294', 'Mexico', NULL, NULL, '622-555-5749', NULL, NULL, NULL, 'www.qqkingtelecommunicationsassociates.com', NULL, NULL, NULL, NULL, '491 Cali', 'Mexico City', 'Mexico', '26294', 'Mexico', 0);
INSERT INTO accounts VALUES ('6be54043-f48f-b735-139f-438dfc1c2fc2', '2005-11-30 19:23:21', '2005-11-30 19:23:21', '1', 'max_id', '1', 'King-Smith Engineering Company', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '8568 San Vincente Drive', 'Seattle', 'WA', '42812', 'USA', NULL, NULL, '957-555-7013', NULL, NULL, NULL, 'www.king-smithengineeringcompany.com', NULL, NULL, NULL, NULL, '8568 San Vincente Drive', 'Seattle', 'WA', '42812', 'USA', 0);
INSERT INTO accounts VALUES ('a0bfb889-e57c-c6b1-4a16-438dfc2ce66f', '2005-11-30 19:23:21', '2005-11-30 19:23:21', '1', 'matt_id', '1', 'Y & R Campbell Machinery, Inc', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '1265 Gloria Terr.', 'West Covina', 'CA', '83796', 'USA', NULL, NULL, '330-555-3020', NULL, NULL, NULL, 'www.yrcampbellmachinery,inc.com', NULL, NULL, NULL, NULL, '1265 Gloria Terr.', 'West Covina', 'CA', '83796', 'USA', 0);
INSERT INTO accounts VALUES ('d09daf64-3366-7d89-d80e-438dfc78fd52', '2005-11-30 19:23:21', '2005-11-30 19:23:21', '1', 'sarah_id', '1', 'Campbell-Watson Engineering, Inc', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '9595 Barbie Dr.', 'National City', 'CA', '66476', 'USA', NULL, NULL, '449-555-8256', NULL, NULL, NULL, 'www.campbell-watsonengineering,inc.com', NULL, NULL, NULL, NULL, '9595 Barbie Dr.', 'National City', 'CA', '66476', 'USA', 0);
INSERT INTO accounts VALUES ('10c85c97-4838-66f7-ca9c-438dfc62b69d', '2005-11-30 19:23:22', '2005-11-30 19:23:22', '1', 'kristen_id', '1', 'E & F Anderson Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '2546 Fawn Glen Circle', 'Burlingame', 'CA', '99914', 'USA', NULL, NULL, '983-555-6549', NULL, NULL, NULL, 'www.efandersonmachinery,ltd.com', NULL, NULL, NULL, NULL, '2546 Fawn Glen Circle', 'Burlingame', 'CA', '99914', 'USA', 0);
INSERT INTO accounts VALUES ('47b2de2c-877f-5ea3-3e3c-438dfc69b421', '2005-11-30 19:23:22', '2005-11-30 19:23:22', '1', 'chris_id', '1', 'Anderson-Duncan Transportation Holdings', NULL, 'Distribution', 'Transportation', NULL, NULL, '1132 Plymouth Dr.', 'Lake Oswego', 'OR', '22464', 'USA', NULL, NULL, '464-555-5070', NULL, NULL, NULL, 'www.anderson-duncantransportationholdings.com', NULL, NULL, NULL, NULL, '1132 Plymouth Dr.', 'Lake Oswego', 'OR', '22464', 'USA', 0);
INSERT INTO accounts VALUES ('7a0f3a9f-919d-93ac-64d4-438dfc575d2d', '2005-11-30 19:23:22', '2005-11-30 19:23:22', '1', 'will_id', '1', 'N & O Wilson Electronics, Inc', NULL, 'Supply', 'Electronics', NULL, NULL, '6992 Mt. Whitney Way', 'Colma', 'CA', '22064', 'USA', NULL, NULL, '122-555-1992', NULL, NULL, NULL, 'www.nowilsonelectronics,inc.com', NULL, NULL, NULL, NULL, '6992 Mt. Whitney Way', 'Colma', 'CA', '22064', 'USA', 0);
INSERT INTO accounts VALUES ('ad4d52a7-b4f6-2449-85c1-438dfccbc0eb', '2005-11-30 19:23:22', '2005-11-30 19:23:22', '1', 'kristen_id', '1', 'Wilson-Morrow Machinery Group', NULL, 'Distribution', 'Machinery', NULL, NULL, '8487 Amador', 'El Cajon', 'CA', '97753', 'USA', NULL, NULL, '526-555-8142', NULL, NULL, NULL, 'www.wilson-morrowmachinerygroup.com', NULL, NULL, NULL, NULL, '8487 Amador', 'El Cajon', 'CA', '97753', 'USA', 0);
INSERT INTO accounts VALUES ('dfb5d15e-4d90-008a-c4a0-438dfc1e6796', '2005-11-30 19:23:22', '2005-11-30 19:23:22', '1', 'beth_id', '1', 'U & W Wall Construction Corp', NULL, 'Supply', 'Construction', NULL, NULL, '1946 Valley Crest Drive', 'Seattle', 'WA', '74535', 'USA', NULL, NULL, '135-555-7924', NULL, NULL, NULL, 'www.uwwallconstructioncorp.com', NULL, NULL, NULL, NULL, '1946 Valley Crest Drive', 'Seattle', 'WA', '74535', 'USA', 0);
INSERT INTO accounts VALUES ('1e2e0eaf-a436-2e2f-079a-438dfcc978c2', '2005-11-30 19:23:23', '2005-11-30 19:23:23', '1', 'max_id', '1', 'Wall-Clendenen Electronics Company', NULL, 'Consulting', 'Electronics', NULL, NULL, '6351 22nd Ave.', 'Renton', 'WA', '28408', 'USA', NULL, NULL, '801-555-7360', NULL, NULL, NULL, 'www.wall-clendenenelectronicscompany.com', NULL, NULL, NULL, NULL, '6351 22nd Ave.', 'Renton', 'WA', '28408', 'USA', 0);
INSERT INTO accounts VALUES ('511417c9-515a-5271-83cd-438dfc3602b3', '2005-11-30 19:23:23', '2005-11-30 19:23:23', '1', 'chris_id', '1', 'M & K Willeford Telecommunications, Ltd', NULL, 'Supply', 'Telecommunications', NULL, NULL, '5998 Hilltop Road', 'Lynnwood', 'WA', '33039', 'USA', NULL, NULL, '743-555-5195', NULL, NULL, NULL, 'www.mkwillefordtelecommunications,ltd.com', NULL, NULL, NULL, NULL, '5998 Hilltop Road', 'Lynnwood', 'WA', '33039', 'USA', 0);
INSERT INTO accounts VALUES ('81739667-916f-2f70-f9b6-438dfcef40da', '2005-11-30 19:23:23', '2005-11-30 19:23:23', '1', 'sarah_id', '1', 'Willeford-Nutter Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '658 Liscome Way', 'Haney', 'BC', '52073', 'Canada', NULL, NULL, '293-555-8602', NULL, NULL, NULL, 'www.willeford-nuttermachinery,ltd.com', NULL, NULL, NULL, NULL, '658 Liscome Way', 'Haney', 'BC', '52073', 'Canada', 0);
INSERT INTO accounts VALUES ('b458bb25-107a-9c13-28cb-438dfce22eb8', '2005-11-30 19:23:23', '2005-11-30 19:23:23', '1', 'beth_id', '1', 'L & E Case Communications Partners', NULL, 'Distribution', 'Communications', NULL, NULL, '7280 Greendell Pl', 'Tlaxiaco', 'Oaxaca', '49157', 'Mexico', NULL, NULL, '497-555-8724', NULL, NULL, NULL, 'www.lecasecommunicationspartners.com', NULL, NULL, NULL, NULL, '7280 Greendell Pl', 'Tlaxiaco', 'Oaxaca', '49157', 'Mexico', 0);
INSERT INTO accounts VALUES ('ea48fde4-32a8-c93f-deb5-438dfce647a7', '2005-11-30 19:23:23', '2005-11-30 19:23:23', '1', 'sally_id', '1', 'Case-Terry Construction Holdings', NULL, 'Consulting', 'Construction', NULL, NULL, '4849 Bovlevard', 'La Mesa', 'CA', '34353', 'USA', NULL, NULL, '308-555-5417', NULL, NULL, NULL, 'www.case-terryconstructionholdings.com', NULL, NULL, NULL, NULL, '4849 Bovlevard', 'La Mesa', 'CA', '34353', 'USA', 0);
INSERT INTO accounts VALUES ('2f17041d-6ce9-52da-f900-438dfc42caf8', '2005-11-30 19:23:24', '2005-11-30 19:23:24', '1', 'kristen_id', '1', 'W & N Cabrera Telecommunications Partners', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '1726 Hacienda', 'Beverly Hills', 'CA', '70306', 'USA', NULL, NULL, '535-555-4167', NULL, NULL, NULL, 'www.wncabreratelecommunicationspartners.com', NULL, NULL, NULL, NULL, '1726 Hacienda', 'Beverly Hills', 'CA', '70306', 'USA', 0);
INSERT INTO accounts VALUES ('62385afb-c905-f7a8-2a44-438dfca04f24', '2005-11-30 19:23:24', '2005-11-30 19:23:24', '1', 'sally_id', '1', 'Cabrera-Bunosky Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '9549 Sandra Circle', 'Albany', 'OR', '21663', 'USA', NULL, NULL, '370-555-8488', NULL, NULL, NULL, 'www.cabrera-bunoskytransportationholdings.com', NULL, NULL, NULL, NULL, '9549 Sandra Circle', 'Albany', 'OR', '21663', 'USA', 0);
INSERT INTO accounts VALUES ('958696f6-dd18-293d-8b6a-438dfc8aed00', '2005-11-30 19:23:24', '2005-11-30 19:23:24', '1', 'beth_id', '1', 'V & A Burke Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '9335 Wilke Drive', 'Albany', 'OR', '23778', 'USA', NULL, NULL, '859-555-9524', NULL, NULL, NULL, 'www.vaburketransportationcorp.com', NULL, NULL, NULL, NULL, '9335 Wilke Drive', 'Albany', 'OR', '23778', 'USA', 0);
INSERT INTO accounts VALUES ('cb5c47a5-1b26-9d7e-13d6-438dfc4e1bd3', '2005-11-30 19:23:24', '2005-11-30 19:23:24', '1', 'max_id', '1', 'Burke-Lindsay Telecommunications Partners', NULL, 'Supply', 'Telecommunications', NULL, NULL, '7413 Alpine Drive', 'Torrance', 'CA', '67914', 'USA', NULL, NULL, '955-555-7131', NULL, NULL, NULL, 'www.burke-lindsaytelecommunicationspartners.com', NULL, NULL, NULL, NULL, '7413 Alpine Drive', 'Torrance', 'CA', '67914', 'USA', 0);
INSERT INTO accounts VALUES ('75e50a23-9265-c54c-8b4e-438dfcd2223b', '2005-11-30 19:23:25', '2005-11-30 19:23:25', '1', 'will_id', '1', 'L & N Murphy Electronics Company', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '4304 Hieber Drive', 'Ballard', 'WA', '75883', 'USA', NULL, NULL, '327-555-3138', NULL, NULL, NULL, 'www.lnmurphyelectronicscompany.com', NULL, NULL, NULL, NULL, '4304 Hieber Drive', 'Ballard', 'WA', '75883', 'USA', 0);
INSERT INTO accounts VALUES ('388be0fd-b842-efd0-f18e-438dfc552b9e', '2005-11-30 19:23:25', '2005-11-30 19:23:25', '1', 'matt_id', '1', 'Murphy-Sweet Telecommunications Corp', NULL, 'Supply', 'Telecommunications', NULL, NULL, '673 Noah Court', 'Port Orchard', 'WA', '26604', 'USA', NULL, NULL, '686-555-3031', NULL, NULL, NULL, 'www.murphy-sweettelecommunicationscorp.com', NULL, NULL, NULL, NULL, '673 Noah Court', 'Port Orchard', 'WA', '26604', 'USA', 0);
INSERT INTO accounts VALUES ('7157d805-6abe-331a-5fb9-438dfc620237', '2005-11-30 19:23:25', '2005-11-30 19:23:25', '1', 'chris_id', '1', 'D & D Jantzer Electronics Holdings', NULL, 'Supply', 'Electronics', NULL, NULL, '2676 Premier Pl.', 'Ladner', 'BC', '45638', 'Canada', NULL, NULL, '196-555-8847', NULL, NULL, NULL, 'www.ddjantzerelectronicsholdings.com', NULL, NULL, NULL, NULL, '2676 Premier Pl.', 'Ladner', 'BC', '45638', 'Canada', 0);
INSERT INTO accounts VALUES ('a5742340-8530-36ea-0b70-438dfc49fba9', '2005-11-30 19:23:25', '2005-11-30 19:23:25', '1', 'sarah_id', '1', 'Jantzer-Dittmar Machinery, Inc', NULL, 'Distribution', 'Machinery', NULL, NULL, '1955 Montgomery Ave', 'National City', 'CA', '16430', 'USA', NULL, NULL, '577-555-7369', NULL, NULL, NULL, 'www.jantzer-dittmarmachinery,inc.com', NULL, NULL, NULL, NULL, '1955 Montgomery Ave', 'National City', 'CA', '16430', 'USA', 0);
INSERT INTO accounts VALUES ('d69a09f2-05b3-787c-3830-438dfcf05a6f', '2005-11-30 19:23:25', '2005-11-30 19:23:25', '1', 'sally_id', '1', 'I & V Gutirrez Engineering, Inc', NULL, 'Distribution', 'Engineering', NULL, NULL, '6868 Firestone', 'Victoria', 'BC', '1626', 'Canada', NULL, NULL, '234-555-4290', NULL, NULL, NULL, 'www.ivgutirrezengineering,inc.com', NULL, NULL, NULL, NULL, '6868 Firestone', 'Victoria', 'BC', '1626', 'Canada', 0);
INSERT INTO accounts VALUES ('179e125d-284a-d3b2-0038-438dfcf93aaa', '2005-11-30 19:23:26', '2005-11-30 19:23:26', '1', 'beth_id', '1', 'Gutirrez-Carol Construction, Ltd', NULL, 'Manufacturing', 'Construction', NULL, NULL, '6400 St. John Lane', 'Port Hammond', 'BC', '37579', 'Canada', NULL, NULL, '877-555-5098', NULL, NULL, NULL, 'www.gutirrez-carolconstruction,ltd.com', NULL, NULL, NULL, NULL, '6400 St. John Lane', 'Port Hammond', 'BC', '37579', 'Canada', 0);
INSERT INTO accounts VALUES ('495768d6-47f1-1b9f-577a-438dfc1aac48', '2005-11-30 19:23:26', '2005-11-30 19:23:26', '1', 'matt_id', '1', 'K & R Holmes Communications Group', NULL, 'Consulting', 'Communications', NULL, NULL, '1568 Delta Fair Blvd.', 'La Cruz', 'Sinaloa', '87935', 'Mexico', NULL, NULL, '558-555-9647', NULL, NULL, NULL, 'www.krholmescommunicationsgroup.com', NULL, NULL, NULL, NULL, '1568 Delta Fair Blvd.', 'La Cruz', 'Sinaloa', '87935', 'Mexico', 0);
INSERT INTO accounts VALUES ('7e3eb19c-1d64-396b-5c09-438dfcb45107', '2005-11-30 19:23:26', '2005-11-30 19:23:26', '1', 'jaime_id', '1', 'Holmes-Chandler Engineering Associates', NULL, 'Distribution', 'Engineering', NULL, NULL, '1354 Catalpa Court', 'Tacoma', 'WA', '90050', 'USA', NULL, NULL, '323-555-9083', NULL, NULL, NULL, 'www.holmes-chandlerengineeringassociates.com', NULL, NULL, NULL, NULL, '1354 Catalpa Court', 'Tacoma', 'WA', '90050', 'USA', 0);
INSERT INTO accounts VALUES ('b566c7ed-03b1-4b94-b3c0-438dfc90b079', '2005-11-30 19:23:26', '2005-11-30 19:23:26', '1', 'max_id', '1', 'B & P Burkett Telecommunications Holdings', NULL, 'Distribution', 'Telecommunications', NULL, NULL, '9431 D Bel Air Dr.', 'Puyallup', 'WA', '75702', 'USA', NULL, NULL, '266-555-6919', NULL, NULL, NULL, 'www.bpburketttelecommunicationsholdings.com', NULL, NULL, NULL, NULL, '9431 D Bel Air Dr.', 'Puyallup', 'WA', '75702', 'USA', 0);
INSERT INTO accounts VALUES ('edb6480f-7a94-ab84-d7f7-438dfc6d05e7', '2005-11-30 19:23:26', '2005-11-30 19:23:26', '1', 'will_id', '1', 'Burkett-Drake Engineering Partners', NULL, 'Consulting', 'Engineering', NULL, NULL, '9471 Shelly Dr.', 'Bremerton', 'WA', '74846', 'USA', NULL, NULL, '954-555-4983', NULL, NULL, NULL, 'www.burkett-drakeengineeringpartners.com', NULL, NULL, NULL, NULL, '9471 Shelly Dr.', 'Bremerton', 'WA', '74846', 'USA', 0);
INSERT INTO accounts VALUES ('2ade2bad-f421-e522-0893-438dfc6f9001', '2005-11-30 19:23:27', '2005-11-30 19:23:27', '1', 'chris_id', '1', 'Q & P Barber Telecommunications Company', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, '1706 Vallejo', 'Palo Alto', 'CA', '31234', 'USA', NULL, NULL, '919-555-1447', NULL, NULL, NULL, 'www.qpbarbertelecommunicationscompany.com', NULL, NULL, NULL, NULL, '1706 Vallejo', 'Palo Alto', 'CA', '31234', 'USA', 0);
INSERT INTO accounts VALUES ('63ac9d63-cef0-cc86-3eb8-438dfc83a95f', '2005-11-30 19:23:27', '2005-11-30 19:23:27', '1', 'sally_id', '1', 'Barber-Richendollar Electronics Group', NULL, 'Consulting', 'Electronics', NULL, NULL, '2000 Thornwood Dr.', 'Portland', 'OR', '64672', 'USA', NULL, NULL, '731-555-7140', NULL, NULL, NULL, 'www.barber-richendollarelectronicsgroup.com', NULL, NULL, NULL, NULL, '2000 Thornwood Dr.', 'Portland', 'OR', '64672', 'USA', 0);
INSERT INTO accounts VALUES ('9b204880-a0ef-5c4d-4be0-438dfc20677e', '2005-11-30 19:23:27', '2005-11-30 19:23:27', '1', 'kristen_id', '1', 'A & X Caravello Engineering, Inc', NULL, 'Supply', 'Engineering', NULL, NULL, '3241 Dutch Slough Rd.', 'Tlaxiaco', 'Oaxaca', '13514', 'Mexico', NULL, NULL, '958-555-5890', NULL, NULL, NULL, 'www.axcaravelloengineering,inc.com', NULL, NULL, NULL, NULL, '3241 Dutch Slough Rd.', 'Tlaxiaco', 'Oaxaca', '13514', 'Mexico', 0);
INSERT INTO accounts VALUES ('cfe9578f-3e6b-aa60-aa17-438dfc0054b8', '2005-11-30 19:23:27', '2005-11-30 19:23:27', '1', 'kristen_id', '1', 'Caravello-Paulson Construction Partners', NULL, 'Distribution', 'Construction', NULL, NULL, '6445 Cashew Street', 'Marysville', 'WA', '85821', 'USA', NULL, NULL, '497-555-9924', NULL, NULL, NULL, 'www.caravello-paulsonconstructionpartners.com', NULL, NULL, NULL, NULL, '6445 Cashew Street', 'Marysville', 'WA', '85821', 'USA', 0);
INSERT INTO accounts VALUES ('bfe90793-7042-b281-a29b-438dfcd94a83', '2005-11-30 19:23:28', '2005-11-30 19:23:28', '1', 'kristen_id', '1', 'H & Y Trujillo Electronics, Ltd', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '7941 Cristobal', 'Grossmont', 'CA', '23887', 'USA', NULL, NULL, '747-555-7303', NULL, NULL, NULL, 'www.hytrujilloelectronics,ltd.com', NULL, NULL, NULL, NULL, '7941 Cristobal', 'Grossmont', 'CA', '23887', 'USA', 0);
INSERT INTO accounts VALUES ('3c5230ab-6269-a413-a1da-438dfce24849', '2005-11-30 19:23:28', '2005-11-30 19:23:28', '1', 'chris_id', '1', 'Trujillo-Barajas Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '4055 Leonard Ct.', 'Guadalajara', 'Jalisco', '62356', 'Mexico', NULL, NULL, '843-555-4910', NULL, NULL, NULL, 'www.trujillo-barajastransportationholdings.com', NULL, NULL, NULL, NULL, '4055 Leonard Ct.', 'Guadalajara', 'Jalisco', '62356', 'Mexico', 0);
INSERT INTO accounts VALUES ('75fbe8a1-0cc5-7f5f-3f5d-438dfcba3444', '2005-11-30 19:23:28', '2005-11-30 19:23:28', '1', 'sarah_id', '1', 'O & K Ealey Transportation Corp', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '5805 Churchill Dr.', 'Concord', 'CA', '16229', 'USA', NULL, NULL, '216-555-9917', NULL, NULL, NULL, 'www.okealeytransportationcorp.com', NULL, NULL, NULL, NULL, '5805 Churchill Dr.', 'Concord', 'CA', '16229', 'USA', 0);
INSERT INTO accounts VALUES ('a8be972a-939a-3dca-b61a-438dfc6effc4', '2005-11-30 19:23:28', '2005-11-30 19:23:28', '1', 'beth_id', '1', 'Ealey-Pigman Construction Partners', NULL, 'Consulting', 'Construction', NULL, NULL, '2173 Heartwood Drive', 'Orizaba', 'Veracruz', '47151', 'Mexico', NULL, NULL, '574-555-9810', NULL, NULL, NULL, 'www.ealey-pigmanconstructionpartners.com', NULL, NULL, NULL, NULL, '2173 Heartwood Drive', 'Orizaba', 'Veracruz', '47151', 'Mexico', 0);
INSERT INTO accounts VALUES ('d8ad2277-df7d-f46f-f387-438dfc9fc67c', '2005-11-30 19:23:28', '2005-11-30 19:23:28', '1', 'sally_id', '1', 'D & D Minniear Transportation, Ltd', NULL, 'Distribution', 'Transportation', NULL, NULL, '6832 Le Jean Way', 'La Cruz', 'Sinaloa', '66185', 'Mexico', NULL, NULL, '869-555-4445', NULL, NULL, NULL, 'www.ddminnieartransportation,ltd.com', NULL, NULL, NULL, NULL, '6832 Le Jean Way', 'La Cruz', 'Sinaloa', '66185', 'Mexico', 0);
INSERT INTO accounts VALUES ('1f2068b3-8dfd-886c-701a-438dfc9c060b', '2005-11-30 19:23:29', '2005-11-30 19:23:29', '1', 'beth_id', '1', 'Minniear-Robinson Communications Group', NULL, 'Supply', 'Communications', NULL, NULL, '3455 Mexico', 'Altadena', 'CA', '36977', 'USA', NULL, NULL, '350-555-2967', NULL, NULL, NULL, 'www.minniear-robinsoncommunicationsgroup.com', NULL, NULL, NULL, NULL, '3455 Mexico', 'Altadena', 'CA', '36977', 'USA', 0);
INSERT INTO accounts VALUES ('54a0d864-0354-75f6-828b-438dfce8bd19', '2005-11-30 19:23:29', '2005-11-30 19:23:29', '1', 'beth_id', '1', 'E & M Steger Electronics Company', NULL, 'Supply', 'Electronics', NULL, NULL, '8368 Birchwood', 'Seattle', 'WA', '22173', 'USA', NULL, NULL, '247-555-3546', NULL, NULL, NULL, 'www.emstegerelectronicscompany.com', NULL, NULL, NULL, NULL, '8368 Birchwood', 'Seattle', 'WA', '22173', 'USA', 0);
INSERT INTO accounts VALUES ('94e3b641-f6ba-cc12-a786-438dfcc4dc4a', '2005-11-30 19:23:29', '2005-11-30 19:23:29', '1', 'matt_id', '1', 'Steger-Lindsey Engineering, Ltd', NULL, 'Distribution', 'Engineering', NULL, NULL, '7900 Grammercy Lane', 'Mexico City', 'Mexico', '58126', 'Mexico', NULL, NULL, '651-555-9696', NULL, NULL, NULL, 'www.steger-lindseyengineering,ltd.com', NULL, NULL, NULL, NULL, '7900 Grammercy Lane', 'Mexico City', 'Mexico', '58126', 'Mexico', 0);
INSERT INTO accounts VALUES ('c79ec9db-7704-6f87-c385-438dfc36b819', '2005-11-30 19:23:29', '2005-11-30 19:23:29', '1', 'matt_id', '1', 'R & Z Larson Communications, Inc', NULL, 'Distribution', 'Communications', NULL, NULL, '3068 Altura', 'Palo Alto', 'CA', '94832', 'USA', NULL, NULL, '331-555-5245', NULL, NULL, NULL, 'www.rzlarsoncommunications,inc.com', NULL, NULL, NULL, NULL, '3068 Altura', 'Palo Alto', 'CA', '94832', 'USA', 0);
INSERT INTO accounts VALUES ('492a0d69-45ec-0626-ad08-438dfc957527', '2005-11-30 19:23:30', '2005-11-30 19:23:30', '1', 'sally_id', '1', 'Larson-Heyer Electronics Associates', NULL, 'Consulting', 'Electronics', NULL, NULL, '2855 West F St.', 'Ladner', 'BC', '11598', 'Canada', NULL, NULL, '997-555-4681', NULL, NULL, NULL, 'www.larson-heyerelectronicsassociates.com', NULL, NULL, NULL, NULL, '2855 West F St.', 'Ladner', 'BC', '11598', 'Canada', 0);
INSERT INTO accounts VALUES ('405a1f89-b637-f966-5355-438dfc8e0091', '2005-11-30 19:23:30', '2005-11-30 19:23:30', '1', 'sarah_id', '1', 'J & K Clifford Communications Corp', NULL, 'Supply', 'Communications', NULL, NULL, '932 Acardia Pl.', 'Oak Bay', 'BC', '28117', 'Canada', NULL, NULL, '939-555-2517', NULL, NULL, NULL, 'www.jkcliffordcommunicationscorp.com', NULL, NULL, NULL, NULL, '932 Acardia Pl.', 'Oak Bay', 'BC', '28117', 'Canada', 0);
INSERT INTO accounts VALUES ('7072fe03-b8b5-5554-6d14-438dfc2f5a34', '2005-11-30 19:23:30', '2005-11-30 19:23:30', '1', 'sally_id', '1', 'Clifford-Smith Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '3628 Mt. McKinley Ct.', 'National City', 'CA', '69101', 'USA', NULL, NULL, '728-555-9581', NULL, NULL, NULL, 'www.clifford-smithconstruction,ltd.com', NULL, NULL, NULL, NULL, '3628 Mt. McKinley Ct.', 'National City', 'CA', '69101', 'USA', 0);
INSERT INTO accounts VALUES ('a902c86d-af73-bb58-03d8-438dfce6da2a', '2005-11-30 19:23:30', '2005-11-30 19:23:30', '1', 'matt_id', '1', 'G & Q Todd Transportation Company', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '1960 Fernando Court', 'Ladner', 'BC', '51781', 'Canada', NULL, NULL, '805-555-8305', NULL, NULL, NULL, 'www.gqtoddtransportationcompany.com', NULL, NULL, NULL, NULL, '1960 Fernando Court', 'Ladner', 'BC', '51781', 'Canada', 0);
INSERT INTO accounts VALUES ('d90e7371-642f-b58a-283a-438dfcf43684', '2005-11-30 19:23:30', '2005-11-30 19:23:30', '1', 'max_id', '1', 'Todd-Batouche Machinery Group', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '4910 Melinda Court', 'Long Beach', 'CA', '85219', 'USA', NULL, NULL, '616-555-4998', NULL, NULL, NULL, 'www.todd-batouchemachinerygroup.com', NULL, NULL, NULL, NULL, '4910 Melinda Court', 'Long Beach', 'CA', '85219', 'USA', 0);
INSERT INTO accounts VALUES ('26bc2c8a-cf99-5250-f0aa-438dfc686818', '2005-11-30 19:23:31', '2005-11-30 19:23:31', '1', 'sally_id', '1', 'L & D Marple Electronics Corp', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '3495 Virginia Lane', 'Tacoma', 'WA', '77693', 'USA', NULL, NULL, '843-555-3748', NULL, NULL, NULL, 'www.ldmarpleelectronicscorp.com', NULL, NULL, NULL, NULL, '3495 Virginia Lane', 'Tacoma', 'WA', '77693', 'USA', 0);
INSERT INTO accounts VALUES ('573647e1-999c-69cf-2397-438dfc17623f', '2005-11-30 19:23:31', '2005-11-30 19:23:31', '1', 'matt_id', '1', 'Marple-Griffin Engineering, Ltd', NULL, 'Supply', 'Engineering', NULL, NULL, '9355 Slavio', 'Santa Anita', 'DF', '51879', 'Mexico', NULL, NULL, '917-555-2727', NULL, NULL, NULL, 'www.marple-griffinengineering,ltd.com', NULL, NULL, NULL, NULL, '9355 Slavio', 'Santa Anita', 'DF', '51879', 'Mexico', 0);
INSERT INTO accounts VALUES ('877eb60b-134a-f479-802c-438dfc448522', '2005-11-30 19:23:31', '2005-11-30 19:23:31', '1', 'jaime_id', '1', 'Z & L Carrington Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '851 Summerfield Drive', 'Santa Anita', 'DF', '39590', 'Mexico', NULL, NULL, '267-555-9105', NULL, NULL, NULL, 'www.zlcarringtonconstruction,ltd.com', NULL, NULL, NULL, NULL, '851 Summerfield Drive', 'Santa Anita', 'DF', '39590', 'Mexico', 0);
INSERT INTO accounts VALUES ('c66b15b6-1295-c446-8285-438dfc13ef91', '2005-11-30 19:23:31', '2005-11-30 19:23:31', '1', 'will_id', '1', 'Carrington-Vigil Transportation Group', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '4309 Cambridge Drive', 'Langley', 'BC', '53512', 'Canada', NULL, NULL, '363-555-6712', NULL, NULL, NULL, 'www.carrington-vigiltransportationgroup.com', NULL, NULL, NULL, NULL, '4309 Cambridge Drive', 'Langley', 'BC', '53512', 'Canada', 0);
INSERT INTO accounts VALUES ('15876252-21f9-8801-edf5-438dfc514ffd', '2005-11-30 19:23:32', '2005-11-30 19:23:32', '1', 'max_id', '1', 'V & P Gonzales Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '8714 St. Paul Way', 'Torrance', 'CA', '58223', 'USA', NULL, NULL, '636-555-2719', NULL, NULL, NULL, 'www.vpgonzalestransportationcorp.com', NULL, NULL, NULL, NULL, '8714 St. Paul Way', 'Torrance', 'CA', '58223', 'USA', 0);
INSERT INTO accounts VALUES ('52649e63-6cbc-9626-db97-438dfcc96538', '2005-11-30 19:23:32', '2005-11-30 19:23:32', '1', 'will_id', '1', 'Gonzales-Starr Telecommunications, Inc', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '2427 Arnold Dr', 'Victoria', 'BC', '62853', 'Canada', NULL, NULL, '994-555-2613', NULL, NULL, NULL, 'www.gonzales-starrtelecommunications,inc.com', NULL, NULL, NULL, NULL, '2427 Arnold Dr', 'Victoria', 'BC', '62853', 'Canada', 0);
INSERT INTO accounts VALUES ('8931952d-ca9b-aaef-d3bf-438dfc559055', '2005-11-30 19:23:32', '2005-11-30 19:23:32', '1', 'matt_id', '1', 'F & X Murphy Communications Partners', NULL, 'Consulting', 'Communications', NULL, NULL, '7086 C Wharton Way', 'Santa Cruz', 'CA', '81887', 'USA', NULL, NULL, '628-555-9905', NULL, NULL, NULL, 'www.fxmurphycommunicationspartners.com', NULL, NULL, NULL, NULL, '7086 C Wharton Way', 'Santa Cruz', 'CA', '81887', 'USA', 0);
INSERT INTO accounts VALUES ('bbf35b4f-d530-f5ec-3f2a-438dfc01924c', '2005-11-30 19:23:32', '2005-11-30 19:23:32', '1', 'sally_id', '1', 'Murphy-Rinks Communications Holdings', NULL, 'Distribution', 'Communications', NULL, NULL, '890 Ridgeview Dr', 'Pomona', 'CA', '78972', 'USA', NULL, NULL, '770-555-4769', NULL, NULL, NULL, 'www.murphy-rinkscommunicationsholdings.com', NULL, NULL, NULL, NULL, '890 Ridgeview Dr', 'Pomona', 'CA', '78972', 'USA', 0);
INSERT INTO accounts VALUES ('53e902c2-1531-2e88-6849-438dfcf7e277', '2005-11-30 19:23:33', '2005-11-30 19:23:33', '1', 'sarah_id', '1', 'S & X Kroes Engineering Partners', NULL, 'Distribution', 'Engineering', NULL, NULL, '8459 Patricia', 'La Cruz', 'Sinaloa', '64167', 'Mexico', NULL, NULL, '667-555-5348', NULL, NULL, NULL, 'www.sxkroesengineeringpartners.com', NULL, NULL, NULL, NULL, '8459 Patricia', 'La Cruz', 'Sinaloa', '64167', 'Mexico', 0);
INSERT INTO accounts VALUES ('3571dd34-b4e1-d163-6193-438dfc2a52df', '2005-11-30 19:23:33', '2005-11-30 19:23:33', '1', 'sarah_id', '1', 'Kroes-Shafer Transportation, Inc', NULL, 'Supply', 'Transportation', NULL, NULL, '5336 Roberts Ct', 'Chula Vista', 'CA', '11212', 'USA', NULL, NULL, '171-555-2498', NULL, NULL, NULL, 'www.kroes-shafertransportation,inc.com', NULL, NULL, NULL, NULL, '5336 Roberts Ct', 'Chula Vista', 'CA', '11212', 'USA', 0);
INSERT INTO accounts VALUES ('65b6ae82-e853-4b4a-907a-438dfc41e4ea', '2005-11-30 19:23:33', '2005-11-30 19:23:33', '1', 'sarah_id', '1', 'H & N Price Machinery Corp', NULL, 'Supply', 'Machinery', NULL, NULL, '3159 C Wharton Way', 'Spring Valley', 'CA', '51478', 'USA', NULL, NULL, '441-555-7623', NULL, NULL, NULL, 'www.hnpricemachinerycorp.com', NULL, NULL, NULL, NULL, '3159 C Wharton Way', 'Spring Valley', 'CA', '51478', 'USA', 0);
INSERT INTO accounts VALUES ('ad7eebc8-9008-48aa-8999-438dfc2bd7db', '2005-11-30 19:23:33', '2005-11-30 19:23:33', '1', 'max_id', '1', 'Price-Driscoll Telecommunications Partners', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '2946 Frayne Ct', 'Corvallis', 'OR', '53593', 'USA', NULL, NULL, '207-555-7059', NULL, NULL, NULL, 'www.price-driscolltelecommunicationspartners.com', NULL, NULL, NULL, NULL, '2946 Frayne Ct', 'Corvallis', 'OR', '53593', 'USA', 0);
INSERT INTO accounts VALUES ('dddc337f-cd80-2112-6c27-438dfcd65851', '2005-11-30 19:23:33', '2005-11-30 19:23:33', '1', 'sally_id', '1', 'C & Z Morris Communications Associates', NULL, 'Manufacturing', 'Communications', NULL, NULL, '1023 Hawkins Street', 'Lebanon', 'OR', '43819', 'USA', NULL, NULL, '149-555-4894', NULL, NULL, NULL, 'www.czmorriscommunicationsassociates.com', NULL, NULL, NULL, NULL, '1023 Hawkins Street', 'Lebanon', 'OR', '43819', 'USA', 0);
INSERT INTO accounts VALUES ('19ffc069-9d38-b1b6-1dae-438dfcbadb5a', '2005-11-30 19:23:34', '2005-11-30 19:23:34', '1', 'beth_id', '1', 'Morris-Price Electronics Holdings', NULL, 'Distribution', 'Electronics', NULL, NULL, '1064 William Way', 'Woodland Hills', 'CA', '12096', 'USA', NULL, NULL, '838-555-2959', NULL, NULL, NULL, 'www.morris-priceelectronicsholdings.com', NULL, NULL, NULL, NULL, '1064 William Way', 'Woodland Hills', 'CA', '12096', 'USA', 0);
INSERT INTO accounts VALUES ('4abce901-f399-395c-cfc1-438dfc680d17', '2005-11-30 19:23:34', '2005-11-30 19:23:34', '1', 'will_id', '1', 'G & H Marez Transportation, Inc', NULL, 'Supply', 'Transportation', NULL, NULL, '9394 Piper Ridge Court', 'Camacho', 'Zacatecas', '93776', 'Mexico', NULL, NULL, '803-555-8423', NULL, NULL, NULL, 'www.ghmareztransportation,inc.com', NULL, NULL, NULL, NULL, '9394 Piper Ridge Court', 'Camacho', 'Zacatecas', '93776', 'Mexico', 0);
INSERT INTO accounts VALUES ('89aa25e0-abb7-8da8-5f7c-438dfcc93527', '2005-11-30 19:23:34', '2005-11-30 19:23:34', '1', 'jaime_id', '1', 'Marez-Wachterman Transportation Company', NULL, 'Consulting', 'Transportation', NULL, NULL, '2345 Yorba Linda', 'Coronado', 'CA', '99306', 'USA', NULL, NULL, '614-555-5116', NULL, NULL, NULL, 'www.marez-wachtermantransportationcompany.com', NULL, NULL, NULL, NULL, '2345 Yorba Linda', 'Coronado', 'CA', '99306', 'USA', 0);
INSERT INTO accounts VALUES ('c42d53c8-319a-14cb-031b-438dfc639b30', '2005-11-30 19:23:34', '2005-11-30 19:23:34', '1', 'sarah_id', '1', 'X & W Usnick Machinery Group', NULL, 'Supply', 'Machinery', NULL, NULL, '3586 Everett Court', 'Redwood City', 'CA', '48149', 'USA', NULL, NULL, '841-555-3866', NULL, NULL, NULL, 'www.xwusnickmachinerygroup.com', NULL, NULL, NULL, NULL, '3586 Everett Court', 'Redwood City', 'CA', '48149', 'USA', 0);
INSERT INTO accounts VALUES ('f8ae0395-a072-805c-afa3-438dfc1b9db1', '2005-11-30 19:23:35', '2005-11-30 19:23:35', '1', 'will_id', '1', 'Usnick-Brown Communications, Inc', NULL, 'Manufacturing', 'Communications', NULL, NULL, '6790 Loma Linda', 'Oregon City', 'OR', '47748', 'USA', NULL, NULL, '915-555-2844', NULL, NULL, NULL, 'www.usnick-browncommunications,inc.com', NULL, NULL, NULL, NULL, '6790 Loma Linda', 'Oregon City', 'OR', '47748', 'USA', 0);
INSERT INTO accounts VALUES ('5597c255-2788-329c-788b-438dfc89c0d8', '2005-11-30 19:23:35', '2005-11-30 19:23:35', '1', 'sally_id', '1', 'D & H Galich Engineering Group', NULL, 'Distribution', 'Engineering', NULL, NULL, '8286 Willow St.', 'Oregon City', 'OR', '35460', 'USA', NULL, NULL, '264-555-9223', NULL, NULL, NULL, 'www.dhgalichengineeringgroup.com', NULL, NULL, NULL, NULL, '8286 Willow St.', 'Oregon City', 'OR', '35460', 'USA', 0);
INSERT INTO accounts VALUES ('9562372a-7c6b-0f03-5180-438dfc684ff2', '2005-11-30 19:23:35', '2005-11-30 19:23:35', '1', 'sally_id', '1', 'Galich-Watson Construction, Ltd', NULL, 'Consulting', 'Construction', NULL, NULL, '1745 Marina Hill Pkwy.', 'Glendale', 'CA', '73928', 'USA', NULL, NULL, '361-555-6830', NULL, NULL, NULL, 'www.galich-watsonconstruction,ltd.com', NULL, NULL, NULL, NULL, '1745 Marina Hill Pkwy.', 'Glendale', 'CA', '73928', 'USA', 0);
INSERT INTO accounts VALUES ('d78273c2-d1a4-c2e1-cb4c-438dfc1d695e', '2005-11-30 19:23:35', '2005-11-30 19:23:35', '1', 'chris_id', '1', 'K & I Ardell Machinery Corp', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '6150 San Antonio', 'Grossmont', 'CA', '54093', 'USA', NULL, NULL, '633-555-2837', NULL, NULL, NULL, 'www.kiardellmachinerycorp.com', NULL, NULL, NULL, NULL, '6150 San Antonio', 'Grossmont', 'CA', '54093', 'USA', 0);
INSERT INTO accounts VALUES ('2337d344-998b-9825-9a1d-438dfc6dafc6', '2005-11-30 19:23:36', '2005-11-30 19:23:36', '1', 'sarah_id', '1', 'Ardell-Nakauchi Electronics, Inc', NULL, 'Distribution', 'Electronics', NULL, NULL, '2518 Cashew Street', 'Lynnwood', 'WA', '58723', 'USA', NULL, NULL, '991-555-2730', NULL, NULL, NULL, 'www.ardell-nakauchielectronics,inc.com', NULL, NULL, NULL, NULL, '2518 Cashew Street', 'Lynnwood', 'WA', '58723', 'USA', 0);
INSERT INTO accounts VALUES ('5377769e-2add-65c8-fae0-438dfc5634c3', '2005-11-30 19:23:36', '2005-11-30 19:23:36', '1', 'chris_id', '1', 'A & L Powers Engineering, Inc', NULL, 'Consulting', 'Engineering', NULL, NULL, '7177 Santa Rosa', 'Haney', 'BC', '77757', 'Canada', NULL, NULL, '738-555-3283', NULL, NULL, NULL, 'www.alpowersengineering,inc.com', NULL, NULL, NULL, NULL, '7177 Santa Rosa', 'Haney', 'BC', '77757', 'Canada', 0);
INSERT INTO accounts VALUES ('83588aa9-47a5-ea7e-f3fe-438dfc246337', '2005-11-30 19:23:36', '2005-11-30 19:23:36', '1', 'sally_id', '1', 'Powers-Amburgey Construction, Ltd', NULL, 'Consulting', 'Construction', NULL, NULL, '3800 Breck Court', 'Victoria', 'BC', '48549', 'Canada', NULL, NULL, '219-555-1804', NULL, NULL, NULL, 'www.powers-amburgeyconstruction,ltd.com', NULL, NULL, NULL, NULL, '3800 Breck Court', 'Victoria', 'BC', '48549', 'Canada', 0);
INSERT INTO accounts VALUES ('b625d5bb-cd93-43e5-6e8b-438dfc2936c1', '2005-11-30 19:23:36', '2005-11-30 19:23:36', '1', 'beth_id', '1', 'U & D Johnston Communications, Ltd', NULL, 'Manufacturing', 'Communications', NULL, NULL, '8713 Buchanan Street', 'Marysville', 'WA', '33745', 'USA', NULL, NULL, '777-555-7726', NULL, NULL, NULL, 'www.udjohnstoncommunications,ltd.com', NULL, NULL, NULL, NULL, '8713 Buchanan Street', 'Marysville', 'WA', '33745', 'USA', 0);
INSERT INTO accounts VALUES ('ee8bad1c-a0dc-5296-19c3-438dfc606916', '2005-11-30 19:23:36', '2005-11-30 19:23:36', '1', 'matt_id', '1', 'Johnston-Hager Engineering Associates', NULL, 'Supply', 'Engineering', NULL, NULL, '8245 Heartwood Drive', 'W. Linn', 'OR', '69698', 'USA', NULL, NULL, '281-555-4876', NULL, NULL, NULL, 'www.johnston-hagerengineeringassociates.com', NULL, NULL, NULL, NULL, '8245 Heartwood Drive', 'W. Linn', 'OR', '69698', 'USA', 0);
INSERT INTO accounts VALUES ('32dbd4f6-fc0a-ee15-c211-438dfc5792cf', '2005-11-30 19:23:37', '2005-11-30 19:23:37', '1', 'max_id', '1', 'C & R Posey Engineering Partners', NULL, 'Supply', 'Engineering', NULL, NULL, '3413 Sequoia Woods Pl.', 'Merida', 'Yucatan', '21056', 'Mexico', NULL, NULL, '200-555-4083', NULL, NULL, NULL, 'www.crposeyengineeringpartners.com', NULL, NULL, NULL, NULL, '3413 Sequoia Woods Pl.', 'Merida', 'Yucatan', '21056', 'Mexico', 0);
INSERT INTO accounts VALUES ('7a09f220-a444-3557-babd-438dfc835374', '2005-11-30 19:23:37', '2005-11-30 19:23:37', '1', 'max_id', '1', 'Posey-Dimon Engineering Company', NULL, 'Consulting', 'Engineering', NULL, NULL, '3200 Wren Ave.', 'San Gabriel', 'CA', '23171', 'USA', NULL, NULL, '627-555-8861', NULL, NULL, NULL, 'www.posey-dimonengineeringcompany.com', NULL, NULL, NULL, NULL, '3200 Wren Ave.', 'San Gabriel', 'CA', '23171', 'USA', 0);
INSERT INTO accounts VALUES ('b6fee153-e674-0ce9-1876-438dfcd49190', '2005-11-30 19:23:37', '2005-11-30 19:23:37', '1', 'sarah_id', '1', 'X & N Williams Construction Corp', NULL, 'Consulting', 'Construction', NULL, NULL, '1277 Argenta Dr.', 'Glendale', 'CA', '39689', 'USA', NULL, NULL, '569-555-6697', NULL, NULL, NULL, 'www.xnwilliamsconstructioncorp.com', NULL, NULL, NULL, NULL, '1277 Argenta Dr.', 'Glendale', 'CA', '39689', 'USA', 0);
INSERT INTO accounts VALUES ('f0c98417-28e4-750f-3158-438dfc753a4a', '2005-11-30 19:23:37', '2005-11-30 19:23:37', '1', 'kristen_id', '1', 'Williams-Fien Machinery Group', NULL, 'Supply', 'Machinery', NULL, NULL, '1318 Nottingham Pl.', 'Lebanon', 'OR', '79662', 'USA', NULL, NULL, '357-555-4761', NULL, NULL, NULL, 'www.williams-fienmachinerygroup.com', NULL, NULL, NULL, NULL, '1318 Nottingham Pl.', 'Lebanon', 'OR', '79662', 'USA', 0);
INSERT INTO accounts VALUES ('3f3906cd-9417-2089-b784-438dfcbfcc98', '2005-11-30 19:23:38', '2005-11-30 19:23:38', '1', 'max_id', '1', 'A & U Stalker Telecommunications, Inc', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, '2305 Glazier Drive', 'Mill Valley', 'CA', '94451', 'USA', NULL, NULL, '323-555-1226', NULL, NULL, NULL, 'www.austalkertelecommunications,inc.com', NULL, NULL, NULL, NULL, '2305 Glazier Drive', 'Mill Valley', 'CA', '94451', 'USA', 0);
INSERT INTO accounts VALUES ('70a2eb1b-e3e3-24ea-79db-438dfcfd0cac', '2005-11-30 19:23:38', '2005-11-30 19:23:38', '1', 'beth_id', '1', 'Stalker-Fan Telecommunications Group', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, '6501 Mr. Wilson Way', 'Redmond', 'WA', '42882', 'USA', NULL, NULL, '373-555-1576', NULL, NULL, NULL, 'www.stalker-fantelecommunicationsgroup.com', NULL, NULL, NULL, NULL, '6501 Mr. Wilson Way', 'Redmond', 'WA', '42882', 'USA', 0);
INSERT INTO accounts VALUES ('ad779176-e6f2-3a2a-7988-438dfca1fc7f', '2005-11-30 19:23:38', '2005-11-30 19:23:38', '1', 'sally_id', '1', 'C & Z Kamas Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '5087 Bella Avenue', 'Camacho', 'Zacatecas', '64431', 'Mexico', NULL, NULL, '361-555-5669', NULL, NULL, NULL, 'www.czkamastelecommunications,ltd.com', NULL, NULL, NULL, NULL, '5087 Bella Avenue', 'Camacho', 'Zacatecas', '64431', 'Mexico', 0);
INSERT INTO accounts VALUES ('e6794b89-cc73-f353-e58d-438dfc4ade8c', '2005-11-30 19:23:38', '2005-11-30 19:23:38', '1', 'will_id', '1', 'Kamas-Barr Construction Group', NULL, 'Distribution', 'Construction', NULL, NULL, '8291 Woodland Drive', 'Anacortes', 'WA', '64031', 'USA', NULL, NULL, '434-555-4647', NULL, NULL, NULL, 'www.kamas-barrconstructiongroup.com', NULL, NULL, NULL, NULL, '8291 Woodland Drive', 'Anacortes', 'WA', '64031', 'USA', 0);
INSERT INTO accounts VALUES ('22a32b5c-d5be-2c77-7d86-438dfc775cd6', '2005-11-30 19:23:39', '2005-11-30 19:23:39', '1', 'sarah_id', '1', 'E & Q Petranoff Engineering, Ltd', NULL, 'Supply', 'Engineering', NULL, NULL, '9786 Roundtree Court', 'Altadena', 'CA', '51742', 'USA', NULL, NULL, '684-555-2026', NULL, NULL, NULL, 'www.eqpetranoffengineering,ltd.com', NULL, NULL, NULL, NULL, '9786 Roundtree Court', 'Altadena', 'CA', '51742', 'USA', 0);
INSERT INTO accounts VALUES ('65157916-93a9-67e5-d373-438dfc35ed6b', '2005-11-30 19:23:39', '2005-11-30 19:23:39', '1', 'sally_id', '1', 'Petranoff-ONeill Engineering Holdings', NULL, 'Supply', 'Engineering', NULL, NULL, '5901 F Mt Hood Circle', 'Tixapan', 'DF', '17504', 'Mexico', NULL, NULL, '229-555-5629', NULL, NULL, NULL, 'www.petranoff-oneillengineeringholdings.com', NULL, NULL, NULL, NULL, '5901 F Mt Hood Circle', 'Tixapan', 'DF', '17504', 'Mexico', 0);
INSERT INTO accounts VALUES ('a7b39e5d-493c-5021-3027-438dfcce30dd', '2005-11-30 19:23:39', '2005-11-30 19:23:39', '1', 'sally_id', '1', 'J & C McDonald Telecommunications Associates', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '7650 Northridge Drive', 'Palo Alto', 'CA', '70376', 'USA', NULL, NULL, '741-555-5294', NULL, NULL, NULL, 'www.jcmcdonaldtelecommunicationsassociates.com', NULL, NULL, NULL, NULL, '7650 Northridge Drive', 'Palo Alto', 'CA', '70376', 'USA', 0);
INSERT INTO accounts VALUES ('d7a3fd9c-3715-e6f2-2e8b-438dfc374d45', '2005-11-30 19:23:39', '2005-11-30 19:23:39', '1', 'max_id', '1', 'McDonald-Walter Electronics Holdings', NULL, 'Distribution', 'Electronics', NULL, NULL, '4019 Weaver Lane', 'Port Hammond', 'BC', '22992', 'Canada', NULL, NULL, '860-555-1529', NULL, NULL, NULL, 'www.mcdonald-walterelectronicsholdings.com', NULL, NULL, NULL, NULL, '4019 Weaver Lane', 'Port Hammond', 'BC', '22992', 'Canada', 0);
INSERT INTO accounts VALUES ('1cea29e6-0f31-0943-b9ab-438dfc45d065', '2005-11-30 19:23:40', '2005-11-30 19:23:40', '1', 'max_id', '1', 'F & P McGuin Communications, Inc', NULL, 'Consulting', 'Communications', NULL, NULL, '8678 Estudillo Street', 'Orizaba', 'Veracruz', '21333', 'Mexico', NULL, NULL, '494-555-8822', NULL, NULL, NULL, 'www.fpmcguincommunications,inc.com', NULL, NULL, NULL, NULL, '8678 Estudillo Street', 'Orizaba', 'Veracruz', '21333', 'Mexico', 0);
INSERT INTO accounts VALUES ('6a0493ef-90c2-3391-e434-438dfc67e7f3', '2005-11-30 19:23:40', '2005-11-30 19:23:40', '1', 'jaime_id', '1', 'McGuin-Amper Engineering, Inc', NULL, 'Consulting', 'Engineering', NULL, NULL, '5300 Turrin Dr.', 'Redwood City', 'CA', '91124', 'USA', NULL, NULL, '875-555-7344', NULL, NULL, NULL, 'www.mcguin-amperengineering,inc.com', NULL, NULL, NULL, NULL, '5300 Turrin Dr.', 'Redwood City', 'CA', '91124', 'USA', 0);
INSERT INTO accounts VALUES ('a672e98c-171b-2ec5-7d03-438dfc20800e', '2005-11-30 19:23:40', '2005-11-30 19:23:40', '1', 'max_id', '1', 'F & M Hansen Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '214 Via Del Sol', 'Chula Vista', 'CA', '76320', 'USA', NULL, NULL, '533-555-4265', NULL, NULL, NULL, 'www.fmhansentransportationcorp.com', NULL, NULL, NULL, NULL, '214 Via Del Sol', 'Chula Vista', 'CA', '76320', 'USA', 0);
INSERT INTO accounts VALUES ('e9bbdad1-2981-a54e-4e5b-438dfc08455d', '2005-11-30 19:23:40', '2005-11-30 19:23:40', '1', 'will_id', '1', 'Hansen-Craycraft Transportation Corp', NULL, 'Distribution', 'Transportation', NULL, NULL, '9746 Vallejo', 'Shawnee', 'BC', '13274', 'Canada', NULL, NULL, '937-555-1415', NULL, NULL, NULL, 'www.hansen-craycrafttransportationcorp.com', NULL, NULL, NULL, NULL, '9746 Vallejo', 'Shawnee', 'BC', '13274', 'Canada', 0);
INSERT INTO accounts VALUES ('2f921331-569e-4ebf-b85f-438dfc2a8506', '2005-11-30 19:23:41', '2005-11-30 19:23:41', '1', 'jaime_id', '1', 'O & C Johnson Construction, Inc', NULL, 'Distribution', 'Construction', NULL, NULL, '7569 Mt. Everest Court', 'Berkeley', 'CA', '63631', 'USA', NULL, NULL, '856-555-9622', NULL, NULL, NULL, 'www.ocjohnsonconstruction,inc.com', NULL, NULL, NULL, NULL, '7569 Mt. Everest Court', 'Berkeley', 'CA', '63631', 'USA', 0);
INSERT INTO accounts VALUES ('69c01b1b-cc6d-c6ba-7d82-438dfcb29df2', '2005-11-30 19:23:41', '2005-11-30 19:23:41', '1', 'sally_id', '1', 'Johnson-Marlowe Telecommunications Group', NULL, 'Distribution', 'Telecommunications', NULL, NULL, '7355 San Benito', 'Westminster', 'BC', '65745', 'Canada', NULL, NULL, '383-555-5401', NULL, NULL, NULL, 'www.johnson-marlowetelecommunicationsgroup.com', NULL, NULL, NULL, NULL, '7355 San Benito', 'Westminster', 'BC', '65745', 'Canada', 0);
INSERT INTO accounts VALUES ('a6a6780e-665a-b236-013e-438dfcb9b481', '2005-11-30 19:23:41', '2005-11-30 19:23:41', '1', 'sarah_id', '1', 'O & F Ortiz Engineering, Inc', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '2777 Spring Hill Drive', 'Haney', 'BC', '29680', 'Canada', NULL, NULL, '325-555-3236', NULL, NULL, NULL, 'www.ofortizengineering,inc.com', NULL, NULL, NULL, NULL, '2777 Spring Hill Drive', 'Haney', 'BC', '29680', 'Canada', 0);
INSERT INTO accounts VALUES ('e0bf6505-a4cb-5da4-ff16-438dfc3160c7', '2005-11-30 19:23:41', '2005-11-30 19:23:41', '1', 'beth_id', '1', 'Ortiz-Michaels Transportation Corp', NULL, 'Distribution', 'Transportation', NULL, NULL, '5473 Hillridge Way', 'Los Angeles', 'CA', '96956', 'USA', NULL, NULL, '114-555-1301', NULL, NULL, NULL, 'www.ortiz-michaelstransportationcorp.com', NULL, NULL, NULL, NULL, '5473 Hillridge Way', 'Los Angeles', 'CA', '96956', 'USA', 0);
INSERT INTO accounts VALUES ('1cc1c1ae-8282-a9b8-0990-438dfc21f836', '2005-11-30 19:23:42', '2005-11-30 19:23:42', '1', 'chris_id', '1', 'I & U Obaugh Transportation Holdings', NULL, 'Distribution', 'Transportation', NULL, NULL, '3805 BrushCreek Court', 'Port Orchard', 'WA', '79636', 'USA', NULL, NULL, '979-555-6765', NULL, NULL, NULL, 'www.iuobaughtransportationholdings.com', NULL, NULL, NULL, NULL, '3805 BrushCreek Court', 'Port Orchard', 'WA', '79636', 'USA', 0);
INSERT INTO accounts VALUES ('61281b35-9522-a961-b110-438dfc96ffd5', '2005-11-30 19:23:42', '2005-11-30 19:23:42', '1', 'will_id', '1', 'Obaugh-Hammons Electronics, Inc', NULL, 'Supply', 'Electronics', NULL, NULL, '6755 Green View Court', 'Albany', 'OR', '14075', 'USA', NULL, NULL, '480-555-4033', NULL, NULL, NULL, 'www.obaugh-hammonselectronics,inc.com', NULL, NULL, NULL, NULL, '6755 Green View Court', 'Albany', 'OR', '14075', 'USA', 0);
INSERT INTO accounts VALUES ('9b8d325f-2245-2777-7458-438dfcf98dff', '2005-11-30 19:23:42', '2005-11-30 19:23:42', '1', 'kristen_id', '1', 'I & G Curl Machinery Group', NULL, 'Distribution', 'Machinery', NULL, NULL, '7996 Ronda Ct.', 'Santa Anita', 'DF', '35624', 'Mexico', NULL, NULL, '468-555-8125', NULL, NULL, NULL, 'www.igcurlmachinerygroup.com', NULL, NULL, NULL, NULL, '7996 Ronda Ct.', 'Santa Anita', 'DF', '35624', 'Mexico', 0);
INSERT INTO accounts VALUES ('e2a26fcb-15b9-e3f4-5278-438dfcd05868', '2005-11-30 19:23:42', '2005-11-30 19:23:42', '1', 'beth_id', '1', 'Curl-Heth Construction Corp', NULL, 'Supply', 'Construction', NULL, NULL, '1201 Olive Hill', 'Salem', 'OR', '35224', 'USA', NULL, NULL, '542-555-7104', NULL, NULL, NULL, 'www.curl-hethconstructioncorp.com', NULL, NULL, NULL, NULL, '1201 Olive Hill', 'Salem', 'OR', '35224', 'USA', 0);
INSERT INTO accounts VALUES ('1ec4e7bb-052b-c1a8-6d80-438dfc3ef908', '2005-11-30 19:23:43', '2005-11-30 19:23:43', '1', 'beth_id', '1', 'D & E Salazar Telecommunications, Inc', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, '2697 Hobby Court', 'Salem', 'OR', '22935', 'USA', NULL, NULL, '792-555-4482', NULL, NULL, NULL, 'www.desalazartelecommunications,inc.com', NULL, NULL, NULL, NULL, '2697 Hobby Court', 'Salem', 'OR', '22935', 'USA', 0);
INSERT INTO accounts VALUES ('78f888c0-fbe2-aa7e-16ba-438dfceac795', '2005-11-30 19:23:43', '2005-11-30 19:23:43', '1', 'chris_id', '1', 'Salazar-Reardon Telecommunications, Ltd', NULL, 'Supply', 'Telecommunications', NULL, NULL, '6155 Wilbur Drive', 'National City', 'CA', '87695', 'USA', NULL, NULL, '888-555-2090', NULL, NULL, NULL, 'www.salazar-reardontelecommunications,ltd.com', NULL, NULL, NULL, NULL, '6155 Wilbur Drive', 'National City', 'CA', '87695', 'USA', 0);
INSERT INTO accounts VALUES ('b7b06c1d-d4d2-7a12-0c06-438dfc86b73a', '2005-11-30 19:23:43', '2005-11-30 19:23:43', '1', 'sarah_id', '1', 'T & P Chenault Engineering, Inc', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '561 Park Glenn', 'Sedro Woolley', 'WA', '41568', 'USA', NULL, NULL, '500-555-1754', NULL, NULL, NULL, 'www.tpchenaultengineering,inc.com', NULL, NULL, NULL, NULL, '561 Park Glenn', 'Sedro Woolley', 'WA', '41568', 'USA', 0);
INSERT INTO accounts VALUES ('e85850ac-0a63-0b69-a9b1-438dfca59923', '2005-11-30 19:23:43', '2005-11-30 19:23:43', '1', 'beth_id', '1', 'Chenault-Edwards Communications Partners', NULL, 'Distribution', 'Communications', NULL, NULL, '6928 N. th Street', 'Tlaxiaco', 'Oaxaca', '46198', 'Mexico', NULL, NULL, '619-555-6990', NULL, NULL, NULL, 'www.chenault-edwardscommunicationspartners.com', NULL, NULL, NULL, NULL, '6928 N. th Street', 'Tlaxiaco', 'Oaxaca', '46198', 'Mexico', 0);
INSERT INTO accounts VALUES ('3a070ce3-f7cd-617d-d237-438dfc16a689', '2005-11-30 19:23:44', '2005-11-30 19:23:44', '1', 'jaime_id', '1', 'R & Y Sowards Machinery Associates', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '8932 Westwood Way', 'Richmond', 'CA', '65232', 'USA', NULL, NULL, '253-555-5282', NULL, NULL, NULL, 'www.rysowardsmachineryassociates.com', NULL, NULL, NULL, NULL, '8932 Westwood Way', 'Richmond', 'CA', '65232', 'USA', 0);
INSERT INTO accounts VALUES ('6a7528ab-6435-5063-cfd9-438dfce53729', '2005-11-30 19:23:44', '2005-11-30 19:23:44', '1', 'kristen_id', '1', 'Sowards-James Telecommunications Partners', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '8210 Mines Road', 'Lakewood', 'CA', '36024', 'USA', NULL, NULL, '634-555-3804', NULL, NULL, NULL, 'www.sowards-jamestelecommunicationspartners.com', NULL, NULL, NULL, NULL, '8210 Mines Road', 'Lakewood', 'CA', '36024', 'USA', 0);
INSERT INTO accounts VALUES ('9af11752-a9fe-aecb-fab7-438dfc778a8b', '2005-11-30 19:23:44', '2005-11-30 19:23:44', '1', 'sally_id', '1', 'D & T Coy Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '3124 Fall Creek', 'San Gabriel', 'CA', '21220', 'USA', NULL, NULL, '292-555-9725', NULL, NULL, NULL, 'www.dtcoytransportationholdings.com', NULL, NULL, NULL, NULL, '3124 Fall Creek', 'San Gabriel', 'CA', '21220', 'USA', 0);
INSERT INTO accounts VALUES ('cdaa34ca-831d-c9d6-c0e5-438dfc14756d', '2005-11-30 19:23:44', '2005-11-30 19:23:44', '1', 'will_id', '1', 'Coy-Putinas Engineering Associates', NULL, 'Distribution', 'Engineering', NULL, NULL, '5935 Isabel', 'Berkeley', 'CA', '83465', 'USA', NULL, NULL, '695-555-6875', NULL, NULL, NULL, 'www.coy-putinasengineeringassociates.com', NULL, NULL, NULL, NULL, '5935 Isabel', 'Berkeley', 'CA', '83465', 'USA', 0);
INSERT INTO accounts VALUES ('14b514b2-e83e-11d1-1217-438dfc8c5156', '2005-11-30 19:23:45', '2005-11-30 19:23:45', '1', 'chris_id', '1', 'O & A Jasper Engineering Corp', NULL, 'Supply', 'Engineering', NULL, NULL, '3758 Springwood Way', 'Lynnwood', 'WA', '85311', 'USA', NULL, NULL, '615-555-6083', NULL, NULL, NULL, 'www.oajasperengineeringcorp.com', NULL, NULL, NULL, NULL, '3758 Springwood Way', 'Lynnwood', 'WA', '85311', 'USA', 0);
INSERT INTO accounts VALUES ('50293355-7599-eea7-5a72-438dfcfaa9d6', '2005-11-30 19:23:45', '2005-11-30 19:23:45', '1', 'will_id', '1', 'Jasper-Morris Machinery Holdings', NULL, 'Distribution', 'Machinery', NULL, NULL, '3545 Rotherham Dr.', 'Milwaukie', 'OR', '10646', 'USA', NULL, NULL, '493-555-7778', NULL, NULL, NULL, 'www.jasper-morrismachineryholdings.com', NULL, NULL, NULL, NULL, '3545 Rotherham Dr.', 'Milwaukie', 'OR', '10646', 'USA', 0);
INSERT INTO accounts VALUES ('8c41aa8f-d82c-2dd1-6752-438dfc68590b', '2005-11-30 19:23:45', '2005-11-30 19:23:45', '1', 'chris_id', '1', 'J & B Laudenslager Telecommunications Company', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '1622 Silver Oaks Place', 'Beaverton', 'OR', '71965', 'USA', NULL, NULL, '435-555-5614', NULL, NULL, NULL, 'www.jblaudenslagertelecommunicationscompany.com', NULL, NULL, NULL, NULL, '1622 Silver Oaks Place', 'Beaverton', 'OR', '71965', 'USA', 0);
INSERT INTO accounts VALUES ('ca6288e8-018b-a6bb-6c4f-438dfc1d6b02', '2005-11-30 19:23:45', '2005-11-30 19:23:45', '1', 'matt_id', '1', 'Laudenslager-Dominica Telecommunications Group', NULL, 'Supply', 'Telecommunications', NULL, NULL, '1663 Park Glen Court', 'Lakewood', 'CA', '40241', 'USA', NULL, NULL, '224-555-3678', NULL, NULL, NULL, 'www.laudenslager-dominicatelecommunicationsgroup.com', NULL, NULL, NULL, NULL, '1663 Park Glen Court', 'Lakewood', 'CA', '40241', 'USA', 0);
INSERT INTO accounts VALUES ('1d240a24-733d-3ab7-64c1-438dfc3357a2', '2005-11-30 19:23:46', '2005-11-30 19:23:46', '1', 'matt_id', '1', 'G & Q Brandberry Engineering Corp', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '2650 Hamlet', 'Portland', 'OR', '22922', 'USA', NULL, NULL, '428-555-3800', NULL, NULL, NULL, 'www.gqbrandberryengineeringcorp.com', NULL, NULL, NULL, NULL, '2650 Hamlet', 'Portland', 'OR', '22922', 'USA', 0);
INSERT INTO accounts VALUES ('4d633ea8-f28f-16a7-fbbd-438dfcce24b5', '2005-11-30 19:23:46', '2005-11-30 19:23:46', '1', 'matt_id', '1', 'Brandberry-Henderson Electronics Group', NULL, 'Consulting', 'Electronics', NULL, NULL, '2944 North Main St.', 'Los Angeles', 'CA', '30067', 'USA', NULL, NULL, '239-555-9493', NULL, NULL, NULL, 'www.brandberry-hendersonelectronicsgroup.com', NULL, NULL, NULL, NULL, '2944 North Main St.', 'Los Angeles', 'CA', '30067', 'USA', 0);
INSERT INTO accounts VALUES ('954bd18b-4cad-5731-0c27-438dfc7a98e1', '2005-11-30 19:23:46', '2005-11-30 19:23:46', '1', 'jaime_id', '1', 'S & Y Williamson Electronics Holdings', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '4185 River Ash Court', 'San Jose', 'CA', '77909', 'USA', NULL, NULL, '466-555-8243', NULL, NULL, NULL, 'www.sywilliamsonelectronicsholdings.com', NULL, NULL, NULL, NULL, '4185 River Ash Court', 'San Jose', 'CA', '77909', 'USA', 0);
INSERT INTO accounts VALUES ('c7ee6c19-78aa-9877-288e-438dfc64ad91', '2005-11-30 19:23:46', '2005-11-30 19:23:46', '1', 'chris_id', '1', 'Williamson-Goodwater Construction, Ltd', NULL, 'Distribution', 'Construction', NULL, NULL, '7390 Notre Dame Avenue', 'Kirkland', 'WA', '51216', 'USA', NULL, NULL, '301-555-3564', NULL, NULL, NULL, 'www.williamson-goodwaterconstruction,ltd.com', NULL, NULL, NULL, NULL, '7390 Notre Dame Avenue', 'Kirkland', 'WA', '51216', 'USA', 0);
INSERT INTO accounts VALUES ('fcc0072c-570b-aa7a-0a10-438dfca14c06', '2005-11-30 19:23:47', '2005-11-30 19:23:47', '1', 'chris_id', '1', 'C & Y Tomlinson Machinery Partners', NULL, 'Supply', 'Machinery', NULL, NULL, '8885 Partridge Dr.', 'Woodland Hills', 'CA', '65219', 'USA', NULL, NULL, '550-555-9943', NULL, NULL, NULL, 'www.cytomlinsonmachinerypartners.com', NULL, NULL, NULL, NULL, '8885 Partridge Dr.', 'Woodland Hills', 'CA', '65219', 'USA', 0);
INSERT INTO accounts VALUES ('4002a8d9-2b45-20ad-7490-438dfcd3c7b9', '2005-11-30 19:23:47', '2005-11-30 19:23:47', '1', 'jaime_id', '1', 'Tomlinson-Springate Machinery, Ltd', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '4999 Corte Segunda', 'Santa Monica', 'CA', '46893', 'USA', NULL, NULL, '647-555-7550', NULL, NULL, NULL, 'www.tomlinson-springatemachinery,ltd.com', NULL, NULL, NULL, NULL, '4999 Corte Segunda', 'Santa Monica', 'CA', '46893', 'USA', 0);
INSERT INTO accounts VALUES ('704e62a8-3a73-3800-3d63-438dfc87d2ce', '2005-11-30 19:23:47', '2005-11-30 19:23:47', '1', 'beth_id', '1', 'P & J Delhay Telecommunications, Ltd', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, '6749 Orchid Ct.', 'Westminster', 'BC', '57561', 'Canada', NULL, NULL, '258-555-7214', NULL, NULL, NULL, 'www.pjdelhaytelecommunications,ltd.com', NULL, NULL, NULL, NULL, '6749 Orchid Ct.', 'Westminster', 'BC', '57561', 'Canada', 0);
INSERT INTO accounts VALUES ('af242932-aa0d-8446-5bea-438dfcc32b6c', '2005-11-30 19:23:47', '2005-11-30 19:23:47', '1', 'will_id', '1', 'Delhay-Petrick Transportation Associates', NULL, 'Supply', 'Transportation', NULL, NULL, '3117 Storey Lane', 'Woodburn', 'OR', '88483', 'USA', NULL, NULL, '377-555-3450', NULL, NULL, NULL, 'www.delhay-petricktransportationassociates.com', NULL, NULL, NULL, NULL, '3117 Storey Lane', 'Woodburn', 'OR', '88483', 'USA', 0);
INSERT INTO accounts VALUES ('eb81ef28-ed52-2cdd-0492-438dfcb8efaf', '2005-11-30 19:23:47', '2005-11-30 19:23:47', '1', 'chris_id', '1', 'B & Y Maestas Engineering Holdings', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '7776 Cordoba Way', 'Burien', 'WA', '85181', 'USA', NULL, NULL, '912-555-1743', NULL, NULL, NULL, 'www.bymaestasengineeringholdings.com', NULL, NULL, NULL, NULL, '7776 Cordoba Way', 'Burien', 'WA', '85181', 'USA', 0);
INSERT INTO accounts VALUES ('278d5dfa-a9bd-1405-8b20-438dfcf24c04', '2005-11-30 19:23:48', '2005-11-30 19:23:48', '1', 'sally_id', '1', 'Maestas-Balchuck Electronics Associates', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '4399 Shuey Ave', 'Newton', 'BC', '78309', 'Canada', NULL, NULL, '744-555-6182', NULL, NULL, NULL, 'www.maestas-balchuckelectronicsassociates.com', NULL, NULL, NULL, NULL, '4399 Shuey Ave', 'Newton', 'BC', '78309', 'Canada', 0);
INSERT INTO accounts VALUES ('893518ed-1f3c-bf65-29d9-438dfc2bba65', '2005-11-30 19:23:48', '2005-11-30 19:23:48', '1', 'jaime_id', '1', 'B & X Waller Electronics, Inc', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '9312 Corte Del Sol', 'Shawnee', 'BC', '63505', 'Canada', NULL, NULL, '402-555-3103', NULL, NULL, NULL, 'www.bxwallerelectronics,inc.com', NULL, NULL, NULL, NULL, '9312 Corte Del Sol', 'Shawnee', 'BC', '63505', 'Canada', 0);
INSERT INTO accounts VALUES ('c8881c14-f62e-59f6-9d97-438dfcd0c92a', '2005-11-30 19:23:48', '2005-11-30 19:23:48', '1', 'kristen_id', '1', 'Waller-Barney Communications, Inc', NULL, 'Manufacturing', 'Communications', NULL, NULL, '8844 Bel Aire Drive', 'Yakima', 'WA', '99458', 'USA', NULL, NULL, '806-555-9253', NULL, NULL, NULL, 'www.waller-barneycommunications,inc.com', NULL, NULL, NULL, NULL, '8844 Bel Aire Drive', 'Yakima', 'WA', '99458', 'USA', 0);
INSERT INTO accounts VALUES ('112a9128-7496-d4c3-c741-438dfc78433a', '2005-11-30 19:23:49', '2005-11-30 19:23:49', '1', 'will_id', '1', 'H & G Gerber Machinery Corp', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '4012 Lime Ridge Drive', 'Ballard', 'WA', '50816', 'USA', NULL, NULL, '725-555-8460', NULL, NULL, NULL, 'www.hggerbermachinerycorp.com', NULL, NULL, NULL, NULL, '4012 Lime Ridge Drive', 'Ballard', 'WA', '50816', 'USA', 0);
INSERT INTO accounts VALUES ('41489b20-3b66-0f87-0ed8-438dfcba09b7', '2005-11-30 19:23:49', '2005-11-30 19:23:49', '1', 'kristen_id', '1', 'Gerber-Grayson Electronics Corp', NULL, 'Supply', 'Electronics', NULL, NULL, '3799 Hilton Way', 'Lynnwood', 'WA', '51026', 'USA', NULL, NULL, '252-555-4238', NULL, NULL, NULL, 'www.gerber-graysonelectronicscorp.com', NULL, NULL, NULL, NULL, '3799 Hilton Way', 'Lynnwood', 'WA', '51026', 'USA', 0);
INSERT INTO accounts VALUES ('8c4df6e9-bf3c-6c7f-d616-438dfcdc2492', '2005-11-30 19:23:49', '2005-11-30 19:23:49', '1', 'kristen_id', '1', 'X & V Purcell Communications Partners', NULL, 'Consulting', 'Communications', NULL, NULL, '1876 Lanitos Ct.', 'Bellingham', 'WA', '67544', 'USA', NULL, NULL, '194-555-2074', NULL, NULL, NULL, 'www.xvpurcellcommunicationspartners.com', NULL, NULL, NULL, NULL, '1876 Lanitos Ct.', 'Bellingham', 'WA', '67544', 'USA', 0);
INSERT INTO accounts VALUES ('cd076a95-a03a-8166-54fe-438dfcdae315', '2005-11-30 19:23:49', '2005-11-30 19:23:49', '1', 'beth_id', '1', 'Purcell-Eurich Construction Group', NULL, 'Manufacturing', 'Construction', NULL, NULL, '4572 Fitzpatrick Drive', 'Ladner', 'BC', '35821', 'Canada', NULL, NULL, '882-555-9139', NULL, NULL, NULL, 'www.purcell-eurichconstructiongroup.com', NULL, NULL, NULL, NULL, '4572 Fitzpatrick Drive', 'Ladner', 'BC', '35821', 'Canada', 0);
INSERT INTO accounts VALUES ('1820ef8f-c74c-624d-e2d1-438dfc773520', '2005-11-30 19:23:50', '2005-11-30 19:23:50', '1', 'beth_id', '1', 'W & A Pierson Construction Company', NULL, 'Supply', 'Construction', NULL, NULL, '2904 San Simeon Ct.', 'Pomona', 'CA', '91208', 'USA', NULL, NULL, '187-555-9260', NULL, NULL, NULL, 'www.wapiersonconstructioncompany.com', NULL, NULL, NULL, NULL, '2904 San Simeon Ct.', 'Pomona', 'CA', '91208', 'USA', 0);
INSERT INTO accounts VALUES ('63d3a33d-c0b8-3e5e-6424-438dfca3b887', '2005-11-30 19:23:50', '2005-11-30 19:23:50', '1', 'will_id', '1', 'Pierson-Jones Engineering Corp', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '5854 Eagle Way', 'Chula Vista', 'CA', '25647', 'USA', NULL, NULL, '898-555-5953', NULL, NULL, NULL, 'www.pierson-jonesengineeringcorp.com', NULL, NULL, NULL, NULL, '5854 Eagle Way', 'Chula Vista', 'CA', '25647', 'USA', 0);
INSERT INTO accounts VALUES ('9563448c-792e-d962-288f-438dfc98c60f', '2005-11-30 19:23:50', '2005-11-30 19:23:50', '1', 'matt_id', '1', 'G & T Beatty Engineering, Ltd', NULL, 'Distribution', 'Engineering', NULL, NULL, '4440 Hawes Street', 'Altadena', 'CA', '47196', 'USA', NULL, NULL, '225-555-4703', NULL, NULL, NULL, 'www.gtbeattyengineering,ltd.com', NULL, NULL, NULL, NULL, '4440 Hawes Street', 'Altadena', 'CA', '47196', 'USA', 0);
INSERT INTO accounts VALUES ('e27af1d7-4419-a694-0b12-438dfc6adf35', '2005-11-30 19:23:50', '2005-11-30 19:23:50', '1', 'kristen_id', '1', 'Beatty-McNight Machinery Company', NULL, 'Distribution', 'Machinery', NULL, NULL, '7644 Corte Segunda', 'Langford', 'BC', '46796', 'Canada', NULL, NULL, '959-555-9024', NULL, NULL, NULL, 'www.beatty-mcnightmachinerycompany.com', NULL, NULL, NULL, NULL, '7644 Corte Segunda', 'Langford', 'BC', '46796', 'Canada', 0);
INSERT INTO accounts VALUES ('2bc0a270-26fc-7ae9-9313-438dfcf04250', '2005-11-30 19:23:51', '2005-11-30 19:23:51', '1', 'chris_id', '1', 'E & C Isaacs Machinery Partners', NULL, 'Supply', 'Machinery', NULL, NULL, '386 Kelly', 'Renton', 'WA', '34507', 'USA', NULL, NULL, '309-555-6403', NULL, NULL, NULL, 'www.ecisaacsmachinerypartners.com', NULL, NULL, NULL, NULL, '386 Kelly', 'Renton', 'WA', '34507', 'USA', 0);
INSERT INTO accounts VALUES ('5bf631be-1622-a5e9-1a8d-438dfcff57b6', '2005-11-30 19:23:51', '2005-11-30 19:23:51', '1', 'sally_id', '1', 'Isaacs-Yonce Engineering Corp', NULL, 'Consulting', 'Engineering', NULL, NULL, '6500 S St.', 'Walla Walla', 'WA', '99268', 'USA', NULL, NULL, '644-555-7667', NULL, NULL, NULL, 'www.isaacs-yonceengineeringcorp.com', NULL, NULL, NULL, NULL, '6500 S St.', 'Walla Walla', 'WA', '99268', 'USA', 0);
INSERT INTO accounts VALUES ('aa0b180a-0efd-40d1-5435-438dfc48d2de', '2005-11-30 19:23:51', '2005-11-30 19:23:51', '1', 'sally_id', '1', 'S & Y Foster Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '8249 La Jolla', 'Oakland', 'CA', '53141', 'USA', NULL, NULL, '144-555-5072', NULL, NULL, NULL, 'www.syfosterconstruction,ltd.com', NULL, NULL, NULL, NULL, '8249 La Jolla', 'Oakland', 'CA', '53141', 'USA', 0);
INSERT INTO accounts VALUES ('1408024c-90ca-89db-f420-438dfc69555c', '2005-11-30 19:23:52', '2005-11-30 19:23:52', '1', 'matt_id', '1', 'Foster-Reed Transportation Company', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '4618 Olive Hill', 'Newton', 'BC', '57771', 'Canada', NULL, NULL, '263-555-1308', NULL, NULL, NULL, 'www.foster-reedtransportationcompany.com', NULL, NULL, NULL, NULL, '4618 Olive Hill', 'Newton', 'BC', '57771', 'Canada', 0);
INSERT INTO accounts VALUES ('5aa4340e-d0ac-4dbe-2eda-438dfc2ffaca', '2005-11-30 19:23:52', '2005-11-30 19:23:52', '1', 'sally_id', '1', 'V & B Kwiatkowski Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '9277 Ridgewood Court', 'Issaquah', 'WA', '76805', 'USA', NULL, NULL, '798-555-8600', NULL, NULL, NULL, 'www.vbkwiatkowskimachinery,ltd.com', NULL, NULL, NULL, NULL, '9277 Ridgewood Court', 'Issaquah', 'WA', '76805', 'USA', 0);
INSERT INTO accounts VALUES ('996773d8-7459-442b-e781-438dfc17a340', '2005-11-30 19:23:52', '2005-11-30 19:23:52', '1', 'sally_id', '1', 'Kwiatkowski-Vann Electronics Corp', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '5899 Mt. Wilson Place', 'Novato', 'CA', '73889', 'USA', NULL, NULL, '279-555-7122', NULL, NULL, NULL, 'www.kwiatkowski-vannelectronicscorp.com', NULL, NULL, NULL, NULL, '5899 Mt. Wilson Place', 'Novato', 'CA', '73889', 'USA', 0);
INSERT INTO accounts VALUES ('cc6b9706-5113-ca5b-cb3b-438dfc78598d', '2005-11-30 19:23:52', '2005-11-30 19:23:52', '1', 'matt_id', '1', 'X & V Smith Construction, Ltd', NULL, 'Consulting', 'Construction', NULL, NULL, '3469 Gill Ct.', 'Lincoln Acres', 'CA', '59085', 'USA', NULL, NULL, '836-555-4043', NULL, NULL, NULL, 'www.xvsmithconstruction,ltd.com', NULL, NULL, NULL, NULL, '3469 Gill Ct.', 'Lincoln Acres', 'CA', '59085', 'USA', 0);
INSERT INTO accounts VALUES ('88570831-b950-4b7e-6cd1-438dfc241b2e', '2005-11-30 19:23:53', '2005-11-30 19:23:53', '1', 'will_id', '1', 'Smith-Hensley Electronics Company', NULL, 'Consulting', 'Electronics', NULL, NULL, '346 Sutcliffe Pl.', 'Langford', 'BC', '95038', 'Canada', NULL, NULL, '340-555-1193', NULL, NULL, NULL, 'www.smith-hensleyelectronicscompany.com', NULL, NULL, NULL, NULL, '346 Sutcliffe Pl.', 'Langford', 'BC', '95038', 'Canada', 0);
INSERT INTO accounts VALUES ('390ee98e-8b3c-5965-e4fd-438dfc1c6eaa', '2005-11-30 19:23:53', '2005-11-30 19:23:53', '1', 'sarah_id', '1', 'X & C Owens Transportation, Ltd', NULL, 'Distribution', 'Transportation', NULL, NULL, '8168 Eaker Way', 'La Jolla', 'CA', '63289', 'USA', NULL, NULL, '259-555-9401', NULL, NULL, NULL, 'www.xcowenstransportation,ltd.com', NULL, NULL, NULL, NULL, '8168 Eaker Way', 'La Jolla', 'CA', '63289', 'USA', 0);
INSERT INTO accounts VALUES ('778b80e7-794c-0a12-6f96-438dfc41229c', '2005-11-30 19:23:53', '2005-11-30 19:23:53', '1', 'kristen_id', '1', 'Owens-Castillo Engineering Associates', NULL, 'Distribution', 'Engineering', NULL, NULL, '7955 Cleveland Rd.', 'Walla Walla', 'WA', '65403', 'USA', NULL, NULL, '925-555-8836', NULL, NULL, NULL, 'www.owens-castilloengineeringassociates.com', NULL, NULL, NULL, NULL, '7955 Cleveland Rd.', 'Walla Walla', 'WA', '65403', 'USA', 0);
INSERT INTO accounts VALUES ('b8db6e77-2347-fbbf-e50e-438dfc33ba76', '2005-11-30 19:23:53', '2005-11-30 19:23:53', '1', 'chris_id', '1', 'J & F Munoz Electronics Corp', NULL, 'Consulting', 'Electronics', NULL, NULL, '6032 Delta Road', 'Richmond', 'BC', '55630', 'Canada', NULL, NULL, '867-555-6672', NULL, NULL, NULL, 'www.jfmunozelectronicscorp.com', NULL, NULL, NULL, NULL, '6032 Delta Road', 'Richmond', 'BC', '55630', 'Canada', 0);
INSERT INTO accounts VALUES ('118c01c7-38b6-1470-71ce-438dfc47cedc', '2005-11-30 19:23:54', '2005-11-30 19:23:54', '1', 'sarah_id', '1', 'Munoz-Lightfoot Engineering Group', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '6073 San Francisco', 'Santa Anita', 'DF', '23907', 'Mexico', NULL, NULL, '417-555-1079', NULL, NULL, NULL, 'www.munoz-lightfootengineeringgroup.com', NULL, NULL, NULL, NULL, '6073 San Francisco', 'Santa Anita', 'DF', '23907', 'Mexico', 0);
INSERT INTO accounts VALUES ('501fc4d0-306b-3755-b0e4-438dfc055616', '2005-11-30 19:23:54', '2005-11-30 19:23:54', '1', 'max_id', '1', 'Y & B Simmons Communications Partners', NULL, 'Manufacturing', 'Communications', NULL, NULL, '4404 Mildred Avenue', 'Redwood City', 'CA', '65871', 'USA', NULL, NULL, '621-555-1201', NULL, NULL, NULL, 'www.ybsimmonscommunicationspartners.com', NULL, NULL, NULL, NULL, '4404 Mildred Avenue', 'Redwood City', 'CA', '65871', 'USA', 0);
INSERT INTO accounts VALUES ('8f64ce1e-2846-22cf-52b1-438dfc1e4865', '2005-11-30 19:23:54', '2005-11-30 19:23:54', '1', 'sarah_id', '1', 'Simmons-Hays Engineering Partners', NULL, 'Distribution', 'Engineering', NULL, NULL, '7354 Scottsdale Rd', 'Merida', 'Yucatan', '40025', 'Mexico', NULL, NULL, '432-555-6893', NULL, NULL, NULL, 'www.simmons-haysengineeringpartners.com', NULL, NULL, NULL, NULL, '7354 Scottsdale Rd', 'Merida', 'Yucatan', '40025', 'Mexico', 0);
INSERT INTO accounts VALUES ('d0f6f8f3-3f8d-6ac9-07a2-438dfca4d5a3', '2005-11-30 19:23:54', '2005-11-30 19:23:54', '1', 'sarah_id', '1', 'L & O Auintana Machinery Group', NULL, 'Consulting', 'Machinery', NULL, NULL, '8595 Central Avenue', 'Shawnee', 'BC', '61574', 'Canada', NULL, NULL, '113-555-2482', NULL, NULL, NULL, 'www.loauintanamachinerygroup.com', NULL, NULL, NULL, NULL, '8595 Central Avenue', 'Shawnee', 'BC', '61574', 'Canada', 0);
INSERT INTO accounts VALUES ('d844099c-3218-4a53-04fd-438dfcf7fe24', '2005-11-30 19:23:55', '2005-11-30 19:23:55', '1', 'sarah_id', '1', 'Auintana-Flanigan Machinery Corp', NULL, 'Supply', 'Machinery', NULL, NULL, '1800 B Eagle Peak Rd.', 'Ballard', 'WA', '61174', 'USA', NULL, NULL, '848-555-6803', NULL, NULL, NULL, 'www.auintana-flaniganmachinerycorp.com', NULL, NULL, NULL, NULL, '1800 B Eagle Peak Rd.', 'Ballard', 'WA', '61174', 'USA', 0);
INSERT INTO accounts VALUES ('4cc59be8-6a2b-045e-fffa-438dfcb7ecd1', '2005-11-30 19:23:55', '2005-11-30 19:23:55', '1', 'beth_id', '1', 'J & R Shanklin Construction Group', NULL, 'Distribution', 'Construction', NULL, NULL, '3296 Sinaloa', 'Ballard', 'WA', '48885', 'USA', NULL, NULL, '437-555-7839', NULL, NULL, NULL, 'www.jrshanklinconstructiongroup.com', NULL, NULL, NULL, NULL, '3296 Sinaloa', 'Ballard', 'WA', '48885', 'USA', 0);
INSERT INTO accounts VALUES ('7e36e18a-2a32-95e6-141d-438dfc516b2e', '2005-11-30 19:23:55', '2005-11-30 19:23:55', '1', 'sally_id', '1', 'Shanklin-Lewis Communications Associates', NULL, 'Manufacturing', 'Communications', NULL, NULL, '6754 Pamploma Ct.', 'San Diego', 'CA', '87353', 'USA', NULL, NULL, '533-555-5446', NULL, NULL, NULL, 'www.shanklin-lewiscommunicationsassociates.com', NULL, NULL, NULL, NULL, '6754 Pamploma Ct.', 'San Diego', 'CA', '87353', 'USA', 0);
INSERT INTO accounts VALUES ('b165ae47-2fc0-be05-a089-438dfc950f45', '2005-11-30 19:23:55', '2005-11-30 19:23:55', '1', 'beth_id', '1', 'I & O King Electronics Holdings', NULL, 'Distribution', 'Electronics', NULL, NULL, '1160 Bella Avenue', 'Port Orchard', 'WA', '67518', 'USA', NULL, NULL, '806-555-1453', NULL, NULL, NULL, 'www.iokingelectronicsholdings.com', NULL, NULL, NULL, NULL, '1160 Bella Avenue', 'Port Orchard', 'WA', '67518', 'USA', 0);
INSERT INTO accounts VALUES ('1a2b5888-e59b-c7cd-18f1-438dfc046cd4', '2005-11-30 19:23:56', '2005-11-30 19:23:56', '1', 'beth_id', '1', 'King-Frongillo Transportation Holdings', NULL, 'Supply', 'Transportation', NULL, NULL, '7527 Eola', 'Camacho', 'Zacatecas', '72149', 'Mexico', NULL, NULL, '264-555-1346', NULL, NULL, NULL, 'www.king-frongillotransportationholdings.com', NULL, NULL, NULL, NULL, '7527 Eola', 'Camacho', 'Zacatecas', '72149', 'Mexico', 0);
INSERT INTO accounts VALUES ('598d45b0-cf4d-be31-0b37-438dfcaf36de', '2005-11-30 19:23:56', '2005-11-30 19:23:56', '1', 'beth_id', '1', 'P & N Stallings Construction Company', NULL, 'Consulting', 'Construction', NULL, NULL, '9531 Harrison Street', 'Colma', 'CA', '91182', 'USA', NULL, NULL, '559-555-4982', NULL, NULL, NULL, 'www.pnstallingsconstructioncompany.com', NULL, NULL, NULL, NULL, '9531 Harrison Street', 'Colma', 'CA', '91182', 'USA', 0);
INSERT INTO accounts VALUES ('ba2d0e92-2b82-c7a0-aefc-438dfc5bbc75', '2005-11-30 19:23:56', '2005-11-30 19:23:56', '1', 'max_id', '1', 'Stallings-Yoshimura Engineering Group', NULL, 'Supply', 'Engineering', NULL, NULL, '8809 Diablo View Road', 'Burbank', 'CA', '61975', 'USA', NULL, NULL, '940-555-3503', NULL, NULL, NULL, 'www.stallings-yoshimuraengineeringgroup.com', NULL, NULL, NULL, NULL, '8809 Diablo View Road', 'Burbank', 'CA', '61975', 'USA', 0);
INSERT INTO accounts VALUES ('2414a861-856d-d2e2-bf08-438dfc9407bf', '2005-11-30 19:23:57', '2005-11-30 19:23:57', '1', 'kristen_id', '1', 'W & Y Rowland Construction, Ltd', NULL, 'Consulting', 'Construction', NULL, NULL, '3723 Mt. Sequoia Ct.', 'Santa Monica', 'CA', '47170', 'USA', NULL, NULL, '598-555-9424', NULL, NULL, NULL, 'www.wyrowlandconstruction,ltd.com', NULL, NULL, NULL, NULL, '3723 Mt. Sequoia Ct.', 'Santa Monica', 'CA', '47170', 'USA', 0);
INSERT INTO accounts VALUES ('638ef092-a33f-0e0c-ebc2-438dfc121ac0', '2005-11-30 19:23:57', '2005-11-30 19:23:57', '1', 'kristen_id', '1', 'Rowland-Balleo Machinery, Inc', NULL, 'Distribution', 'Machinery', NULL, NULL, '3255 Marsh Elder', 'La Jolla', 'CA', '83123', 'USA', NULL, NULL, '340-555-1232', NULL, NULL, NULL, 'www.rowland-balleomachinery,inc.com', NULL, NULL, NULL, NULL, '3255 Marsh Elder', 'La Jolla', 'CA', '83123', 'USA', 0);
INSERT INTO accounts VALUES ('a5efc69d-86e3-c51d-1f94-438dfc385db9', '2005-11-30 19:23:57', '2005-11-30 19:23:57', '1', 'chris_id', '1', 'Z & N Maggard Communications Partners', NULL, 'Manufacturing', 'Communications', NULL, NULL, '8422 W. Holly Drive', 'Renton', 'WA', '85740', 'USA', NULL, NULL, '921-555-5782', NULL, NULL, NULL, 'www.znmaggardcommunicationspartners.com', NULL, NULL, NULL, NULL, '8422 W. Holly Drive', 'Renton', 'WA', '85740', 'USA', 0);
INSERT INTO accounts VALUES ('d6020c11-a159-8e9a-a1d7-438dfc1b496a', '2005-11-30 19:23:57', '2005-11-30 19:23:57', '1', 'matt_id', '1', 'Maggard-Bezic Electronics Associates', NULL, 'Consulting', 'Electronics', NULL, NULL, '2898 Forest Way', 'Redmond', 'WA', '87855', 'USA', NULL, NULL, '687-555-5217', NULL, NULL, NULL, 'www.maggard-bezicelectronicsassociates.com', NULL, NULL, NULL, NULL, '2898 Forest Way', 'Redmond', 'WA', '87855', 'USA', 0);
INSERT INTO accounts VALUES ('1237d33b-03c3-419a-73ea-438dfcbee32d', '2005-11-30 19:23:58', '2005-11-30 19:23:58', '1', 'matt_id', '1', 'H & S Staley Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '975 Harris Circle', 'Lake Oswego', 'OR', '53753', 'USA', NULL, NULL, '980-555-8971', NULL, NULL, NULL, 'www.hsstaleytelecommunications,ltd.com', NULL, NULL, NULL, NULL, '975 Harris Circle', 'Lake Oswego', 'OR', '53753', 'USA', 0);
INSERT INTO accounts VALUES ('428a4aeb-d8e7-e5f8-f4d6-438dfc715771', '2005-11-30 19:23:58', '2005-11-30 19:23:58', '1', 'max_id', '1', 'Staley-Lipford Engineering, Ltd', NULL, 'Supply', 'Engineering', NULL, NULL, '1016 Whyte Park Avenue', 'Burbank', 'CA', '72651', 'USA', NULL, NULL, '769-555-7035', NULL, NULL, NULL, 'www.staley-lipfordengineering,ltd.com', NULL, NULL, NULL, NULL, '1016 Whyte Park Avenue', 'Burbank', 'CA', '72651', 'USA', 0);
INSERT INTO accounts VALUES ('a29bdad9-c920-afe4-d906-438dfcf200d1', '2005-11-30 19:23:58', '2005-11-30 19:23:58', '1', 'sarah_id', '1', 'M & R Winternitz Electronics Holdings', NULL, 'Distribution', 'Electronics', NULL, NULL, '2003 Pinecrest Dr.', 'Redmond', 'WA', '29039', 'USA', NULL, NULL, '734-555-3499', NULL, NULL, NULL, 'www.mrwinternitzelectronicsholdings.com', NULL, NULL, NULL, NULL, '2003 Pinecrest Dr.', 'Redmond', 'WA', '29039', 'USA', 0);
INSERT INTO accounts VALUES ('d57a05ea-6231-9c57-f684-438dfc0ece79', '2005-11-30 19:23:58', '2005-11-30 19:23:58', '1', 'matt_id', '1', 'Winternitz-Burns Engineering Associates', NULL, 'Supply', 'Engineering', NULL, NULL, '2297 Via Valencia', 'Santa Anita', 'DF', '62477', 'Mexico', NULL, NULL, '545-555-9192', NULL, NULL, NULL, 'www.winternitz-burnsengineeringassociates.com', NULL, NULL, NULL, NULL, '2297 Via Valencia', 'Santa Anita', 'DF', '62477', 'Mexico', 0);
INSERT INTO accounts VALUES ('11a182e9-8983-9899-e85b-438dfcae42d2', '2005-11-30 19:23:59', '2005-11-30 19:23:59', '1', 'max_id', '1', 'C & R Cruz Engineering Partners', NULL, 'Supply', 'Engineering', NULL, NULL, '3538 Esperanza Drive', 'Coronado', 'CA', '11319', 'USA', NULL, NULL, '772-555-7942', NULL, NULL, NULL, 'www.crcruzengineeringpartners.com', NULL, NULL, NULL, NULL, '3538 Esperanza Drive', 'Coronado', 'CA', '11319', 'USA', 0);
INSERT INTO accounts VALUES ('421d206d-afa1-4024-ff07-438dfc380941', '2005-11-30 19:23:59', '2005-11-30 19:23:59', '1', 'max_id', '1', 'Cruz-Geiermann Engineering Company', NULL, 'Consulting', 'Engineering', NULL, NULL, '6742 Cleaveland Road', 'West Covina', 'CA', '83626', 'USA', NULL, NULL, '845-555-6921', NULL, NULL, NULL, 'www.cruz-geiermannengineeringcompany.com', NULL, NULL, NULL, NULL, '6742 Cleaveland Road', 'West Covina', 'CA', '83626', 'USA', 0);
INSERT INTO accounts VALUES ('a5ff1c0f-fcab-e1db-053a-438dfc953533', '2005-11-30 19:23:59', '2005-11-30 19:23:59', '1', 'sarah_id', '1', 'X & N Eichorn Construction Corp', NULL, 'Consulting', 'Construction', NULL, NULL, '8238 D Kiska Ct.', 'Newport Beach', 'CA', '97629', 'USA', NULL, NULL, '195-555-4299', NULL, NULL, NULL, 'www.xneichornconstructioncorp.com', NULL, NULL, NULL, NULL, '8238 D Kiska Ct.', 'Newport Beach', 'CA', '97629', 'USA', 0);
INSERT INTO accounts VALUES ('d63223ae-3fcd-0bbd-c6e9-438dfc2b5132', '2005-11-30 19:23:59', '2005-11-30 19:23:59', '1', 'kristen_id', '1', 'Eichorn-Belsey Machinery Group', NULL, 'Supply', 'Machinery', NULL, NULL, '4352 Marclair Dr.', 'Concord', 'CA', '37098', 'USA', NULL, NULL, '292-555-1906', NULL, NULL, NULL, 'www.eichorn-belseymachinerygroup.com', NULL, NULL, NULL, NULL, '4352 Marclair Dr.', 'Concord', 'CA', '37098', 'USA', 0);
INSERT INTO accounts VALUES ('1291fd0e-0b21-b243-e90a-438dfcc8a6d4', '2005-11-30 19:24:00', '2005-11-30 19:24:00', '1', 'max_id', '1', 'A & U Jaramillo Telecommunications, Inc', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, '6102 Corte Poquito', 'Walla Walla', 'WA', '89970', 'USA', NULL, NULL, '564-555-6913', NULL, NULL, NULL, 'www.aujaramillotelecommunications,inc.com', NULL, NULL, NULL, NULL, '6102 Corte Poquito', 'Walla Walla', 'WA', '89970', 'USA', 0);
INSERT INTO accounts VALUES ('53b25086-df00-b865-87bf-438dfc2e9e2a', '2005-11-30 19:24:00', '2005-11-30 19:24:00', '1', 'beth_id', '1', 'Jaramillo-Compagno Telecommunications Group', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, '2470 Indianhead Circle', 'W. Linn', 'OR', '21894', 'USA', NULL, NULL, '922-555-6806', NULL, NULL, NULL, 'www.jaramillo-compagnotelecommunicationsgroup.com', NULL, NULL, NULL, NULL, '2470 Indianhead Circle', 'W. Linn', 'OR', '21894', 'USA', 0);
INSERT INTO accounts VALUES ('84a158a8-9b77-8763-f48e-438dfc86a84a', '2005-11-30 19:24:00', '2005-11-30 19:24:00', '1', 'sally_id', '1', 'C & Z Souza Telecommunications, Ltd', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '7129 Corte Bonita', 'Albany', 'OR', '40927', 'USA', NULL, NULL, '318-555-1442', NULL, NULL, NULL, 'www.czsouzatelecommunications,ltd.com', NULL, NULL, NULL, NULL, '7129 Corte Bonita', 'Albany', 'OR', '40927', 'USA', 0);
INSERT INTO accounts VALUES ('d8db292d-d903-51c1-7629-438dfc04dae1', '2005-11-30 19:24:00', '2005-11-30 19:24:00', '1', 'will_id', '1', 'Souza-Quick Construction Group', NULL, 'Distribution', 'Construction', NULL, NULL, '3752 Hamilton Ct', 'Burnaby', 'BC', '11720', 'Canada', NULL, NULL, '699-555-8963', NULL, NULL, NULL, 'www.souza-quickconstructiongroup.com', NULL, NULL, NULL, NULL, '3752 Hamilton Ct', 'Burnaby', 'BC', '11720', 'Canada', 0);
INSERT INTO accounts VALUES ('46c1629b-ff53-12b7-de33-438dfc79acc0', '2005-11-30 19:24:01', '2005-11-30 19:24:01', '1', 'sarah_id', '1', 'E & Q Curtsinger Engineering, Ltd', NULL, 'Supply', 'Engineering', NULL, NULL, '8665 Brown Street', 'West Covina', 'CA', '95914', 'USA', NULL, NULL, '947-555-6459', NULL, NULL, NULL, 'www.eqcurtsingerengineering,ltd.com', NULL, NULL, NULL, NULL, '8665 Brown Street', 'West Covina', 'CA', '95914', 'USA', 0);
INSERT INTO accounts VALUES ('7720b17b-d7d0-e845-e74d-438dfccdb560', '2005-11-30 19:24:01', '2005-11-30 19:24:01', '1', 'sally_id', '1', 'Curtsinger-Swartwood Engineering Holdings', NULL, 'Supply', 'Engineering', NULL, NULL, '8197 Haviland Place', 'Puyallup', 'WA', '25084', 'USA', NULL, NULL, '450-555-3609', NULL, NULL, NULL, 'www.curtsinger-swartwoodengineeringholdings.com', NULL, NULL, NULL, NULL, '8197 Haviland Place', 'Puyallup', 'WA', '25084', 'USA', 0);
INSERT INTO accounts VALUES ('bcdea145-1765-f3d6-1f3f-438dfc89a81b', '2005-11-30 19:24:01', '2005-11-30 19:24:01', '1', 'sally_id', '1', 'J & C Anderson Telecommunications Associates', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '3365 Atherton Circle', 'Grossmont', 'CA', '75441', 'USA', NULL, NULL, '131-555-8159', NULL, NULL, NULL, 'www.jcandersontelecommunicationsassociates.com', NULL, NULL, NULL, NULL, '3365 Atherton Circle', 'Grossmont', 'CA', '75441', 'USA', 0);
INSERT INTO accounts VALUES ('f8fd0b41-cad8-e5ba-85c9-438dfc45bf5c', '2005-11-30 19:24:02', '2005-11-30 19:24:02', '1', 'max_id', '1', 'Anderson-Cutwright Electronics Holdings', NULL, 'Distribution', 'Electronics', NULL, NULL, '3152 Woodcrest Drive', 'Lebanon', 'OR', '77556', 'USA', NULL, NULL, '797-555-7595', NULL, NULL, NULL, 'www.anderson-cutwrightelectronicsholdings.com', NULL, NULL, NULL, NULL, '3152 Woodcrest Drive', 'Lebanon', 'OR', '77556', 'USA', 0);
INSERT INTO accounts VALUES ('5478ecd4-649f-5f03-7ef5-438dfc409603', '2005-11-30 19:24:02', '2005-11-30 19:24:02', '1', 'max_id', '1', 'F & P Bishop Communications, Inc', NULL, 'Consulting', 'Communications', NULL, NULL, '1229 Apollo Way', 'Lynnwood', 'WA', '94074', 'USA', NULL, NULL, '739-555-5431', NULL, NULL, NULL, 'www.fpbishopcommunications,inc.com', NULL, NULL, NULL, NULL, '1229 Apollo Way', 'Lynnwood', 'WA', '94074', 'USA', 0);
INSERT INTO accounts VALUES ('9743fa19-2c3a-af48-3303-438dfc988c03', '2005-11-30 19:24:02', '2005-11-30 19:24:02', '1', 'jaime_id', '1', 'Bishop-Ciruli Engineering, Inc', NULL, 'Consulting', 'Engineering', NULL, NULL, '3925 North 39th Street', 'Haney', 'BC', '36059', 'Canada', NULL, NULL, '527-555-3495', NULL, NULL, NULL, 'www.bishop-ciruliengineering,inc.com', NULL, NULL, NULL, NULL, '3925 North 39th Street', 'Haney', 'BC', '36059', 'Canada', 0);
INSERT INTO accounts VALUES ('aac40ead-acb0-b31d-1133-438dfc9a4799', '2005-11-30 19:24:03', '2005-11-30 19:24:03', '1', 'max_id', '1', 'F & M Detwiler Transportation Corp', NULL, 'Consulting', 'Transportation', NULL, NULL, '2257 Gibrix Drive', 'Downey', 'CA', '18740', 'USA', NULL, NULL, '493-555-8959', NULL, NULL, NULL, 'www.fmdetwilertransportationcorp.com', NULL, NULL, NULL, NULL, '2257 Gibrix Drive', 'Downey', 'CA', '18740', 'USA', 0);
INSERT INTO accounts VALUES ('6ffaba8d-eb1f-c28b-8644-438dfcbea0e4', '2005-11-30 19:24:03', '2005-11-30 19:24:03', '1', 'will_id', '1', 'Detwiler-Biltoft Transportation Corp', NULL, 'Distribution', 'Transportation', NULL, NULL, '5207 Mota Dr.', 'Lincoln Acres', 'CA', '52177', 'USA', NULL, NULL, '304-555-5652', NULL, NULL, NULL, 'www.detwiler-biltofttransportationcorp.com', NULL, NULL, NULL, NULL, '5207 Mota Dr.', 'Lincoln Acres', 'CA', '52177', 'USA', 0);
INSERT INTO accounts VALUES ('a13886ab-0e56-9291-0447-438dfc4546dd', '2005-11-30 19:24:03', '2005-11-30 19:24:03', '1', 'jaime_id', '1', 'O & C Younce Construction, Inc', NULL, 'Distribution', 'Construction', NULL, NULL, '3792 Westwood Ct.', 'Beverly Hills', 'CA', '73727', 'USA', NULL, NULL, '531-555-4402', NULL, NULL, NULL, 'www.ocyounceconstruction,inc.com', NULL, NULL, NULL, NULL, '3792 Westwood Ct.', 'Beverly Hills', 'CA', '73727', 'USA', 0);
INSERT INTO accounts VALUES ('2ca40a4f-c1a5-8085-4cbf-438dfcd9c2a9', '2005-11-30 19:24:04', '2005-11-30 19:24:04', '1', 'sally_id', '1', 'Younce-Pirnie Telecommunications Group', NULL, 'Distribution', 'Telecommunications', NULL, NULL, '9652 Steven Drive', 'Corvallis', 'OR', '73326', 'USA', NULL, NULL, '604-555-3381', NULL, NULL, NULL, 'www.younce-pirnietelecommunicationsgroup.com', NULL, NULL, NULL, NULL, '9652 Steven Drive', 'Corvallis', 'OR', '73326', 'USA', 0);
INSERT INTO accounts VALUES ('33126c17-e9a1-4bd9-a94f-438dfc78c4ee', '2005-11-30 19:24:04', '2005-11-30 19:24:04', '1', 'sarah_id', '1', 'O & F Doolittle Engineering, Inc', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '1148 Thornwood Drive', 'Corvallis', 'OR', '61037', 'USA', NULL, NULL, '854-555-9759', NULL, NULL, NULL, 'www.ofdoolittleengineering,inc.com', NULL, NULL, NULL, NULL, '1148 Thornwood Drive', 'Corvallis', 'OR', '61037', 'USA', 0);
INSERT INTO accounts VALUES ('86d63404-ca50-c4d2-1038-438dfc0d2ce3', '2005-11-30 19:24:04', '2005-11-30 19:24:04', '1', 'beth_id', '1', 'Doolittle-Burnham Transportation Corp', NULL, 'Distribution', 'Transportation', NULL, NULL, '4606 Charmttone Court', 'Torrance', 'CA', '26799', 'USA', NULL, NULL, '950-555-7366', NULL, NULL, NULL, 'www.doolittle-burnhamtransportationcorp.com', NULL, NULL, NULL, NULL, '4606 Charmttone Court', 'Torrance', 'CA', '26799', 'USA', 0);
INSERT INTO accounts VALUES ('cc3411e6-b2f4-24e2-08cd-438dfcde2680', '2005-11-30 19:24:04', '2005-11-30 19:24:04', '1', 'chris_id', '1', 'I & U Stand Transportation Holdings', NULL, 'Distribution', 'Transportation', NULL, NULL, '9011 Tabora Drive', 'Redmond', 'WA', '79671', 'USA', NULL, NULL, '323-555-3373', NULL, NULL, NULL, 'www.iustandtransportationholdings.com', NULL, NULL, NULL, NULL, '9011 Tabora Drive', 'Redmond', 'WA', '79671', 'USA', 0);
INSERT INTO accounts VALUES ('85840e37-3aaa-7bc1-b257-438dfc9b70fe', '2005-11-30 19:24:05', '2005-11-30 19:24:05', '1', 'will_id', '1', 'Stand-Backlin Electronics, Inc', NULL, 'Supply', 'Electronics', NULL, NULL, '3971 Confir Court', 'La Mesa', 'CA', '84301', 'USA', NULL, NULL, '132-555-9184', NULL, NULL, NULL, 'www.stand-backlinelectronics,inc.com', NULL, NULL, NULL, NULL, '3971 Confir Court', 'La Mesa', 'CA', '84301', 'USA', 0);
INSERT INTO accounts VALUES ('386ecec0-8eb5-ce3c-0c4d-438dfc08982a', '2005-11-30 19:24:05', '2005-11-30 19:24:05', '1', 'kristen_id', '1', 'I & G Sharp Machinery Group', NULL, 'Distribution', 'Machinery', NULL, NULL, '8629 English Court', 'Redwood City', 'CA', '43364', 'USA', NULL, NULL, '667-555-7477', NULL, NULL, NULL, 'www.igsharpmachinerygroup.com', NULL, NULL, NULL, NULL, '8629 English Court', 'Redwood City', 'CA', '43364', 'USA', 0);
INSERT INTO accounts VALUES ('7b1a3ffe-b883-9f36-d29d-438dfc6a9109', '2005-11-30 19:24:05', '2005-11-30 19:24:05', '1', 'beth_id', '1', 'Sharp-Torres Construction Corp', NULL, 'Supply', 'Construction', NULL, NULL, '5252 Santa Fe', 'W. Linn', 'OR', '14203', 'USA', NULL, NULL, '809-555-2341', NULL, NULL, NULL, 'www.sharp-torresconstructioncorp.com', NULL, NULL, NULL, NULL, '5252 Santa Fe', 'W. Linn', 'OR', '14203', 'USA', 0);
INSERT INTO accounts VALUES ('e4c2a7f1-29e7-e674-dfda-438dfccc2bc2', '2005-11-30 19:24:05', '2005-11-30 19:24:05', '1', 'beth_id', '1', 'D & E Sall Telecommunications, Inc', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, '2822 Valmar Dr', 'Fremont', 'CA', '13323', 'USA', NULL, NULL, '706-555-2920', NULL, NULL, NULL, 'www.desalltelecommunications,inc.com', NULL, NULL, NULL, NULL, '2822 Valmar Dr', 'Fremont', 'CA', '13323', 'USA', 0);
INSERT INTO accounts VALUES ('20eb8a51-b7ce-0529-75b1-438dfc371e81', '2005-11-30 19:24:06', '2005-11-30 19:24:06', '1', 'chris_id', '1', 'Sall-Scott Telecommunications, Ltd', NULL, 'Supply', 'Telecommunications', NULL, NULL, '9697 Central Ave', 'Seattle', 'WA', '49276', 'USA', NULL, NULL, '209-555-9070', NULL, NULL, NULL, 'www.sall-scotttelecommunications,ltd.com', NULL, NULL, NULL, NULL, '9697 Central Ave', 'Seattle', 'WA', '49276', 'USA', 0);
INSERT INTO accounts VALUES ('514fcdd2-d85d-1a7d-7f1d-438dfc1bfc2b', '2005-11-30 19:24:06', '2005-11-30 19:24:06', '1', 'sarah_id', '1', 'T & P Zablah Engineering, Inc', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '7521 Mount Aire Parkway', 'Torrance', 'CA', '99633', 'USA', NULL, NULL, '790-555-4619', NULL, NULL, NULL, 'www.tpzablahengineering,inc.com', NULL, NULL, NULL, NULL, '7521 Mount Aire Parkway', 'Torrance', 'CA', '99633', 'USA', 0);
INSERT INTO accounts VALUES ('818ba130-82a0-510e-243c-438dfcadc657', '2005-11-30 19:24:06', '2005-11-30 19:24:06', '1', 'beth_id', '1', 'Zablah-Verity Communications Partners', NULL, 'Distribution', 'Communications', NULL, NULL, '7307 Corte Segundo', 'Guadalajara', 'Jalisco', '27493', 'Mexico', NULL, NULL, '555-555-4055', NULL, NULL, NULL, 'www.zablah-veritycommunicationspartners.com', NULL, NULL, NULL, NULL, '7307 Corte Segundo', 'Guadalajara', 'Jalisco', '27493', 'Mexico', 0);
INSERT INTO accounts VALUES ('d967f00f-b4fb-546a-e2cd-438dfc51e139', '2005-11-30 19:24:06', '2005-11-30 19:24:06', '1', 'jaime_id', '1', 'R & Y Pope Machinery Associates', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '5385 Sony Hill Circle', 'Victoria', 'BC', '91975', 'Canada', NULL, NULL, '498-555-1891', NULL, NULL, NULL, 'www.rypopemachineryassociates.com', NULL, NULL, NULL, NULL, '5385 Sony Hill Circle', 'Victoria', 'BC', '91975', 'Canada', 0);
INSERT INTO accounts VALUES ('159db820-3506-22d0-baae-438dfc9d48c0', '2005-11-30 19:24:07', '2005-11-30 19:24:07', '1', 'kristen_id', '1', 'Pope-Harriman Telecommunications Partners', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '5425 Highland Circle', 'Cliffside', 'BC', '60251', 'Canada', NULL, NULL, '286-555-8955', NULL, NULL, NULL, 'www.pope-harrimantelecommunicationspartners.com', NULL, NULL, NULL, NULL, '5425 Highland Circle', 'Cliffside', 'BC', '60251', 'Canada', 0);
INSERT INTO accounts VALUES ('6b413b0a-a8f4-82f5-bdd6-438dfc03fea7', '2005-11-30 19:24:07', '2005-11-30 19:24:07', '1', 'sally_id', '1', 'D & T Bowen Transportation Holdings', NULL, 'Consulting', 'Transportation', NULL, NULL, '3757 Brook Hollow Ct', 'Woodburn', 'OR', '42932', 'USA', NULL, NULL, '251-555-5419', NULL, NULL, NULL, 'www.dtbowentransportationholdings.com', NULL, NULL, NULL, NULL, '3757 Brook Hollow Ct', 'Woodburn', 'OR', '42932', 'USA', 0);
INSERT INTO accounts VALUES ('9c278db4-ede9-c13a-af84-438dfcd5ae49', '2005-11-30 19:24:07', '2005-11-30 19:24:07', '1', 'will_id', '1', 'Bowen-Pochert Engineering Associates', NULL, 'Distribution', 'Engineering', NULL, NULL, '6707 Grand View Avenue', 'Altadena', 'CA', '50077', 'USA', NULL, NULL, '963-555-2112', NULL, NULL, NULL, 'www.bowen-pochertengineeringassociates.com', NULL, NULL, NULL, NULL, '6707 Grand View Avenue', 'Altadena', 'CA', '50077', 'USA', 0);
INSERT INTO accounts VALUES ('a410043f-7a9a-f5fe-d34c-438dfc51da32', '2005-11-30 19:24:08', '2005-11-30 19:24:08', '1', 'chris_id', '1', 'O & A Stone Engineering Corp', NULL, 'Supply', 'Engineering', NULL, NULL, '7948 Roehlidge Lane', 'Puyallup', 'WA', '97919', 'USA', NULL, NULL, '290-555-9862', NULL, NULL, NULL, 'www.oastoneengineeringcorp.com', NULL, NULL, NULL, NULL, '7948 Roehlidge Lane', 'Puyallup', 'WA', '97919', 'USA', 0);
INSERT INTO accounts VALUES ('439df1d9-a1d2-938f-fcbc-438dfcc0b382', '2005-11-30 19:24:08', '2005-11-30 19:24:08', '1', 'will_id', '1', 'Stone-Lippman Machinery Holdings', NULL, 'Distribution', 'Machinery', NULL, NULL, '1153 Loma Linda', 'Mexico City', 'Mexico', '97518', 'Mexico', NULL, NULL, '483-555-1864', NULL, NULL, NULL, 'www.stone-lippmanmachineryholdings.com', NULL, NULL, NULL, NULL, '1153 Loma Linda', 'Mexico City', 'Mexico', '97518', 'Mexico', 0);
INSERT INTO accounts VALUES ('9a01d899-3cd3-82bc-4879-438dfc4aa427', '2005-11-30 19:24:08', '2005-11-30 19:24:08', '1', 'chris_id', '1', 'J & B Heiser Telecommunications Company', NULL, 'Consulting', 'Telecommunications', NULL, NULL, '2648 Hillcrest', 'El Cajon', 'CA', '85229', 'USA', NULL, NULL, '733-555-8242', NULL, NULL, NULL, 'www.jbheisertelecommunicationscompany.com', NULL, NULL, NULL, NULL, '2648 Hillcrest', 'El Cajon', 'CA', '85229', 'USA', 0);
INSERT INTO accounts VALUES ('13b9ce8d-5a7f-dc60-5f5d-438dfc417588', '2005-11-30 19:24:09', '2005-11-30 19:24:09', '1', 'matt_id', '1', 'Heiser-Craig Telecommunications Group', NULL, 'Supply', 'Telecommunications', NULL, NULL, '6107 Westwood Dr', 'Mexico City', 'Mexico', '24699', 'Mexico', NULL, NULL, '829-555-5849', NULL, NULL, NULL, 'www.heiser-craigtelecommunicationsgroup.com', NULL, NULL, NULL, NULL, '6107 Westwood Dr', 'Mexico City', 'Mexico', '24699', 'Mexico', 0);
INSERT INTO accounts VALUES ('451eba4c-ebbc-e355-a55d-438dfc6dd0bf', '2005-11-30 19:24:09', '2005-11-30 19:24:09', '1', 'matt_id', '1', 'G & Q Castano Engineering Corp', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '512 Palms Dr', 'Renton', 'WA', '48644', 'USA', NULL, NULL, '202-555-1856', NULL, NULL, NULL, 'www.gqcastanoengineeringcorp.com', NULL, NULL, NULL, NULL, '512 Palms Dr', 'Renton', 'WA', '48644', 'USA', 0);
INSERT INTO accounts VALUES ('b4f569b4-c6a8-b257-fcb4-438dfcbcb5f0', '2005-11-30 19:24:09', '2005-11-30 19:24:09', '1', 'matt_id', '1', 'Castano-Caudill Electronics Group', NULL, 'Consulting', 'Electronics', NULL, NULL, '6880 N Lucile Lane', 'Salem', 'OR', '94943', 'USA', NULL, NULL, '560-555-1749', NULL, NULL, NULL, 'www.castano-caudillelectronicsgroup.com', NULL, NULL, NULL, NULL, '6880 N Lucile Lane', 'Salem', 'OR', '94943', 'USA', 0);
INSERT INTO accounts VALUES ('e5ff98ed-075f-7aa5-56fa-438dfc049120', '2005-11-30 19:24:09', '2005-11-30 19:24:09', '1', 'jaime_id', '1', 'S & Y Romero Electronics Holdings', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '1540 Westbury Dr', 'Acapulco', 'Guerrero', '28528', 'Mexico', NULL, NULL, '195-555-9042', NULL, NULL, NULL, 'www.syromeroelectronicsholdings.com', NULL, NULL, NULL, NULL, '1540 Westbury Dr', 'Acapulco', 'Guerrero', '28528', 'Mexico', 0);
INSERT INTO accounts VALUES ('361fafb3-51ba-58de-391b-438dfc2a0aec', '2005-11-30 19:24:10', '2005-11-30 19:24:10', '1', 'chris_id', '1', 'Romero-Hicks Construction, Ltd', NULL, 'Distribution', 'Construction', NULL, NULL, '8162 Milden Road', 'Santa Monica', 'CA', '98319', 'USA', NULL, NULL, '576-555-7564', NULL, NULL, NULL, 'www.romero-hicksconstruction,ltd.com', NULL, NULL, NULL, NULL, '8162 Milden Road', 'Santa Monica', 'CA', '98319', 'USA', 0);
INSERT INTO accounts VALUES ('79e65b4a-b856-c71a-19a1-438dfc5344ec', '2005-11-30 19:24:10', '2005-11-30 19:24:10', '1', 'chris_id', '1', 'C & Y Difatta Machinery Partners', NULL, 'Supply', 'Machinery', NULL, NULL, '3076 Monti Dr', 'Grossmont', 'CA', '77346', 'USA', NULL, NULL, '233-555-4485', NULL, NULL, NULL, 'www.cydifattamachinerypartners.com', NULL, NULL, NULL, NULL, '3076 Monti Dr', 'Grossmont', 'CA', '77346', 'USA', 0);
INSERT INTO accounts VALUES ('c1abebb3-fd9d-f3f4-8bc6-438dfc756f30', '2005-11-30 19:24:10', '2005-11-30 19:24:10', '1', 'jaime_id', '1', 'Difatta-Schaidt Machinery, Ltd', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '2608 Southhampton Road', 'Santa Fe', 'DF', '14300', 'Mexico', NULL, NULL, '637-555-1635', NULL, NULL, NULL, 'www.difatta-schaidtmachinery,ltd.com', NULL, NULL, NULL, NULL, '2608 Southhampton Road', 'Santa Fe', 'DF', '14300', 'Mexico', 0);
INSERT INTO accounts VALUES ('f21a7b1f-7757-acc5-7e52-438dfcb88dc0', '2005-11-30 19:24:10', '2005-11-30 19:24:10', '1', 'beth_id', '1', 'P & J Brush Telecommunications, Ltd', NULL, 'Manufacturing', 'Telecommunications', NULL, NULL, '7775 San Ysidro Court', 'Oregon City', 'OR', '64656', 'USA', NULL, NULL, '556-555-9842', NULL, NULL, NULL, 'www.pjbrushtelecommunications,ltd.com', NULL, NULL, NULL, NULL, '7775 San Ysidro Court', 'Oregon City', 'OR', '64656', 'USA', 0);
INSERT INTO accounts VALUES ('698916c3-7e8c-21c5-1f38-438dfc3931c8', '2005-11-30 19:24:11', '2005-11-30 19:24:11', '1', 'will_id', '1', 'Brush-Cambra Transportation Associates', NULL, 'Supply', 'Transportation', NULL, NULL, '7561 Humphrey Drive', 'Newton', 'BC', '66771', 'Canada', NULL, NULL, '983-555-5621', NULL, NULL, NULL, 'www.brush-cambratransportationassociates.com', NULL, NULL, NULL, NULL, '7561 Humphrey Drive', 'Newton', 'BC', '66771', 'Canada', 0);
INSERT INTO accounts VALUES ('99edc13c-8d09-83c1-83b2-438dfc899358', '2005-11-30 19:24:11', '2005-11-30 19:24:11', '1', 'chris_id', '1', 'B & Y Mills Engineering Holdings', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '5639 Lee Lane', 'N. Vancouver', 'BC', '83290', 'Canada', NULL, NULL, '925-555-3456', NULL, NULL, NULL, 'www.bymillsengineeringholdings.com', NULL, NULL, NULL, NULL, '5639 Lee Lane', 'N. Vancouver', 'BC', '83290', 'Canada', 0);
INSERT INTO accounts VALUES ('ccda2c25-4079-1062-d2c6-438dfc514858', '2005-11-30 19:24:11', '2005-11-30 19:24:11', '1', 'sally_id', '1', 'Mills-Reed Electronics Associates', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '5679 Atrice Lane', 'San Diego', 'CA', '51567', 'USA', NULL, NULL, '714-555-1521', NULL, NULL, NULL, 'www.mills-reedelectronicsassociates.com', NULL, NULL, NULL, NULL, '5679 Atrice Lane', 'San Diego', 'CA', '51567', 'USA', 0);
INSERT INTO accounts VALUES ('310c5866-e450-bfc4-afcc-438dfc5e80b4', '2005-11-30 19:24:12', '2005-11-30 19:24:12', '1', 'jaime_id', '1', 'B & X Rybolt Electronics, Inc', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '2602 Hale Dr', 'Burlingame', 'CA', '79553', 'USA', NULL, NULL, '369-555-7560', NULL, NULL, NULL, 'www.bxryboltelectronics,inc.com', NULL, NULL, NULL, NULL, '2602 Hale Dr', 'Burlingame', 'CA', '79553', 'USA', 0);
INSERT INTO accounts VALUES ('61688ffe-959a-5488-a5b9-438dfc944381', '2005-11-30 19:24:12', '2005-11-30 19:24:12', '1', 'kristen_id', '1', 'Rybolt-Staton Communications, Inc', NULL, 'Manufacturing', 'Communications', NULL, NULL, '5552 Nob Hill Drive', 'Orizaba', 'Veracruz', '41393', 'Mexico', NULL, NULL, '420-555-7910', NULL, NULL, NULL, 'www.rybolt-statoncommunications,inc.com', NULL, NULL, NULL, NULL, '5552 Nob Hill Drive', 'Orizaba', 'Veracruz', '41393', 'Mexico', 0);
INSERT INTO accounts VALUES ('916437d4-a690-4aea-354a-438dfca40de6', '2005-11-30 19:24:12', '2005-11-30 19:24:12', '1', 'will_id', '1', 'H & G Van Antwerp Machinery Corp', NULL, 'Manufacturing', 'Machinery', NULL, NULL, '4137 E St.', 'Colma', 'CA', '62942', 'USA', NULL, NULL, '408-555-3003', NULL, NULL, NULL, 'www.hgvanantwerpmachinerycorp.com', NULL, NULL, NULL, NULL, '4137 E St.', 'Colma', 'CA', '62942', 'USA', 0);
INSERT INTO accounts VALUES ('c4c60cc4-e0e3-66ee-43ed-438dfc2a8f86', '2005-11-30 19:24:12', '2005-11-30 19:24:12', '1', 'kristen_id', '1', 'Van Antwerp-Springer Electronics Corp', NULL, 'Supply', 'Electronics', NULL, NULL, '7341 46th St.', 'Tacoma', 'WA', '62542', 'USA', NULL, NULL, '481-555-1981', NULL, NULL, NULL, 'www.vanantwerp-springerelectronicscorp.com', NULL, NULL, NULL, NULL, '7341 46th St.', 'Tacoma', 'WA', '62542', 'USA', 0);
INSERT INTO accounts VALUES ('2968bc75-db89-7fcb-56f8-438dfcf65bda', '2005-11-30 19:24:13', '2005-11-30 19:24:13', '1', 'kristen_id', '1', 'X & V Thorne Communications Partners', NULL, 'Consulting', 'Communications', NULL, NULL, '8837 Paris Lane', 'Bellflower', 'CA', '50253', 'USA', NULL, NULL, '731-555-8360', NULL, NULL, NULL, 'www.xvthornecommunicationspartners.com', NULL, NULL, NULL, NULL, '8837 Paris Lane', 'Bellflower', 'CA', '50253', 'USA', 0);
INSERT INTO accounts VALUES ('6e579ced-dff1-b00e-054c-438dfcb0a2bf', '2005-11-30 19:24:13', '2005-11-30 19:24:13', '1', 'beth_id', '1', 'Thorne-Surniak Construction Group', NULL, 'Manufacturing', 'Construction', NULL, NULL, '4951 Coralie Drive', 'Albany', 'OR', '16014', 'USA', NULL, NULL, '827-555-5967', NULL, NULL, NULL, 'www.thorne-surniakconstructiongroup.com', NULL, NULL, NULL, NULL, '4951 Coralie Drive', 'Albany', 'OR', '16014', 'USA', 0);
INSERT INTO accounts VALUES ('f3fa2d58-c633-1382-097e-438dfce35be4', '2005-11-30 19:24:13', '2005-11-30 19:24:13', '1', 'beth_id', '1', 'W & A Short Construction Company', NULL, 'Supply', 'Construction', NULL, NULL, '6701 Valencia Place', 'Guadalajara', 'Jalisco', '68886', 'Mexico', NULL, NULL, '439-555-5631', NULL, NULL, NULL, 'www.washortconstructioncompany.com', NULL, NULL, NULL, NULL, '6701 Valencia Place', 'Guadalajara', 'Jalisco', '68886', 'Mexico', 0);
INSERT INTO accounts VALUES ('30363e25-8393-14c0-d0de-438dfc6cd1fe', '2005-11-30 19:24:14', '2005-11-30 19:24:14', '1', 'will_id', '1', 'Short-Swesey Engineering Corp', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '3069 Yolanda', 'Woodland Hills', 'CA', '99808', 'USA', NULL, NULL, '558-555-1867', NULL, NULL, NULL, 'www.short-sweseyengineeringcorp.com', NULL, NULL, NULL, NULL, '3069 Yolanda', 'Woodland Hills', 'CA', '99808', 'USA', 0);
INSERT INTO accounts VALUES ('60a1fa34-84d7-e72b-2fbd-438dfc23de44', '2005-11-30 19:24:14', '2005-11-30 19:24:14', '1', 'matt_id', '1', 'G & T Carlson Engineering, Ltd', NULL, 'Distribution', 'Engineering', NULL, NULL, '7728 Condor Place', 'Ladner', 'BC', '19843', 'Canada', NULL, NULL, '193-555-9160', NULL, NULL, NULL, 'www.gtcarlsonengineering,ltd.com', NULL, NULL, NULL, NULL, '7728 Condor Place', 'Ladner', 'BC', '19843', 'Canada', 0);
INSERT INTO accounts VALUES ('be2f892b-c4e9-bc8c-5209-438dfcf7aa79', '2005-11-30 19:24:14', '2005-11-30 19:24:14', '1', 'kristen_id', '1', 'Carlson-Margolis Machinery Company', NULL, 'Distribution', 'Machinery', NULL, NULL, '4351 Shenandoah Dr.', 'National City', 'CA', '15313', 'USA', NULL, NULL, '573-555-7681', NULL, NULL, NULL, 'www.carlson-margolismachinerycompany.com', NULL, NULL, NULL, NULL, '4351 Shenandoah Dr.', 'National City', 'CA', '15313', 'USA', 0);
INSERT INTO accounts VALUES ('3be4c4aa-56e8-3702-fcfd-438dfc276ebc', '2005-11-30 19:24:15', '2005-11-30 19:24:15', '1', 'chris_id', '1', 'E & C Bowen Machinery Partners', NULL, 'Supply', 'Machinery', NULL, NULL, '9264 Slavio', 'Olympia', 'WA', '99508', 'USA', NULL, NULL, '231-555-4603', NULL, NULL, NULL, 'www.ecbowenmachinerypartners.com', NULL, NULL, NULL, NULL, '9264 Slavio', 'Olympia', 'WA', '99508', 'USA', 0);
INSERT INTO accounts VALUES ('6e20cb65-1e32-a00f-8b24-438dfc59657c', '2005-11-30 19:24:15', '2005-11-30 19:24:15', '1', 'sally_id', '1', 'Bowen-Murphy Engineering Corp', NULL, 'Consulting', 'Engineering', NULL, NULL, '8796 Bayview Court', 'Woodburn', 'OR', '36462', 'USA', NULL, NULL, '635-555-1753', NULL, NULL, NULL, 'www.bowen-murphyengineeringcorp.com', NULL, NULL, NULL, NULL, '8796 Bayview Court', 'Woodburn', 'OR', '36462', 'USA', 0);
INSERT INTO accounts VALUES ('b7bf4834-8d96-03b7-3bbe-438dfcae3cd2', '2005-11-30 19:24:15', '2005-11-30 19:24:15', '1', 'sally_id', '1', 'S & Y Miller Construction, Ltd', NULL, 'Supply', 'Construction', NULL, NULL, '6620 Leonard Ct.', 'Chula Vista', 'CA', '86818', 'USA', NULL, NULL, '666-555-3220', NULL, NULL, NULL, 'www.symillerconstruction,ltd.com', NULL, NULL, NULL, NULL, '6620 Leonard Ct.', 'Chula Vista', 'CA', '86818', 'USA', 0);
INSERT INTO accounts VALUES ('e95db6e7-ddc6-81a1-45d6-438dfc91048c', '2005-11-30 19:24:15', '2005-11-30 19:24:15', '1', 'matt_id', '1', 'Miller-Abravaya Transportation Company', NULL, 'Manufacturing', 'Transportation', NULL, NULL, '6406 Pepperidge Way', 'Oregon City', 'OR', '88933', 'USA', NULL, NULL, '193-555-7998', NULL, NULL, NULL, 'www.miller-abravayatransportationcompany.com', NULL, NULL, NULL, NULL, '6406 Pepperidge Way', 'Oregon City', 'OR', '88933', 'USA', 0);
INSERT INTO accounts VALUES ('51155650-c6fd-ca1e-6a67-438dfc197159', '2005-11-30 19:24:16', '2005-11-30 19:24:16', '1', 'sally_id', '1', 'V & B Hazlip Machinery, Ltd', NULL, 'Consulting', 'Machinery', NULL, NULL, '1828 Robinson Ave.', 'Albany', 'OR', '79160', 'USA', NULL, NULL, '135-555-5834', NULL, NULL, NULL, 'www.vbhazlipmachinery,ltd.com', NULL, NULL, NULL, NULL, '1828 Robinson Ave.', 'Albany', 'OR', '79160', 'USA', 0);
INSERT INTO accounts VALUES ('c5bfba5d-771e-4caa-ef86-438dfc5b8d25', '2005-11-30 19:24:16', '2005-11-30 19:24:16', '1', 'sally_id', '1', 'Hazlip-Carter Electronics Corp', NULL, 'Manufacturing', 'Electronics', NULL, NULL, '4524 Ferndale Lane', 'Yakima', 'WA', '47436', 'USA', NULL, NULL, '824-555-3898', NULL, NULL, NULL, 'www.hazlip-carterelectronicscorp.com', NULL, NULL, NULL, NULL, '4524 Ferndale Lane', 'Yakima', 'WA', '47436', 'USA', 0);
INSERT INTO accounts VALUES ('20100cbc-1024-71ea-4c44-438dfc40c76b', '2005-11-30 19:24:17', '2005-11-30 19:24:17', '1', 'matt_id', '1', 'X & V Slusher Construction, Ltd', NULL, 'Consulting', 'Construction', NULL, NULL, '2856 Amargosa Drive', 'Glendale', 'CA', '30117', 'USA', NULL, NULL, '789-555-9362', NULL, NULL, NULL, 'www.xvslusherconstruction,ltd.com', NULL, NULL, NULL, NULL, '2856 Amargosa Drive', 'Glendale', 'CA', '30117', 'USA', 0);
INSERT INTO accounts VALUES ('884c44e1-66a1-d00a-3fb0-438dfca704ba', '2005-11-30 19:24:17', '2005-11-30 19:24:17', '1', 'will_id', '1', 'Slusher-Nzwonkwelle Electronics Company', NULL, 'Consulting', 'Electronics', NULL, NULL, '5806 Dutch Slough Rd', 'Victoria', 'BC', '63555', 'Canada', NULL, NULL, '839-555-9713', NULL, NULL, NULL, 'www.slusher-nzwonkwelleelectronicscompany.com', NULL, NULL, NULL, NULL, '5806 Dutch Slough Rd', 'Victoria', 'BC', '63555', 'Canada', 0);
INSERT INTO accounts VALUES ('bb9a2963-700d-a74e-65e3-438dfccc85f8', '2005-11-30 19:24:17', '2005-11-30 19:24:17', '1', 'sarah_id', '1', 'X & C McCain Transportation, Ltd', NULL, 'Distribution', 'Transportation', NULL, NULL, '7047 Pacheco St', 'Burlingame', 'CA', '85104', 'USA', NULL, NULL, '828-555-4805', NULL, NULL, NULL, 'www.xcmccaintransportation,ltd.com', NULL, NULL, NULL, NULL, '7047 Pacheco St', 'Burlingame', 'CA', '85104', 'USA', 0);
INSERT INTO accounts VALUES ('38fcbc18-f72b-fbe8-81bb-438dfc45196a', '2005-11-30 19:24:18', '2005-11-30 19:24:18', '1', 'kristen_id', '1', 'McCain-Daly Engineering Associates', NULL, 'Distribution', 'Engineering', NULL, NULL, '252 Meadowbrook Drive', 'W. Linn', 'OR', '84703', 'USA', NULL, NULL, '901-555-3784', NULL, NULL, NULL, 'www.mccain-dalyengineeringassociates.com', NULL, NULL, NULL, NULL, '252 Meadowbrook Drive', 'W. Linn', 'OR', '84703', 'USA', 0);
INSERT INTO accounts VALUES ('6958a392-e1fd-f1b0-a66a-438dfc52fe10', '2005-11-30 19:24:18', '2005-11-30 19:24:18', '1', 'chris_id', '1', 'J & F LaTulippe Electronics Corp', NULL, 'Consulting', 'Electronics', NULL, NULL, '1747 Corte Segundo', 'W. Linn', 'OR', '72415', 'USA', NULL, NULL, '251-555-1162', NULL, NULL, NULL, 'www.jflatulippeelectronicscorp.com', NULL, NULL, NULL, NULL, '1747 Corte Segundo', 'W. Linn', 'OR', '72415', 'USA', 0);
INSERT INTO accounts VALUES ('99f44c3f-87e7-9558-992e-438dfc055159', '2005-11-30 19:24:18', '2005-11-30 19:24:18', '1', 'sarah_id', '1', 'LaTulippe-Lewis Engineering Group', NULL, 'Manufacturing', 'Engineering', NULL, NULL, '5205 Sunview Terrace', 'Burbank', 'CA', '38176', 'USA', NULL, NULL, '347-555-7770', NULL, NULL, NULL, 'www.latulippe-lewisengineeringgroup.com', NULL, NULL, NULL, NULL, '5205 Sunview Terrace', 'Burbank', 'CA', '38176', 'USA', 0);
INSERT INTO accounts VALUES ('30885088-ff80-58e7-e745-438dfcbcf297', '2005-11-30 19:24:19', '2005-11-30 19:24:19', '1', 'max_id', '1', 'Y & B Bomar Communications Partners', NULL, 'Manufacturing', 'Communications', NULL, NULL, '9610 Moccasin Ct', 'Spring Valley', 'CA', '91048', 'USA', NULL, NULL, '859-555-7434', NULL, NULL, NULL, 'www.ybbomarcommunicationspartners.com', NULL, NULL, NULL, NULL, '9610 Moccasin Ct', 'Spring Valley', 'CA', '91048', 'USA', 0);
INSERT INTO accounts VALUES ('8cde5ad7-4cd2-4365-1771-438dfcf53c75', '2005-11-30 19:24:19', '2005-11-30 19:24:19', '1', 'sarah_id', '1', 'Bomar-Renfro Engineering Partners', NULL, 'Distribution', 'Engineering', NULL, NULL, '5979 Lynwood Drive', 'Renton', 'WA', '95678', 'USA', NULL, NULL, '444-555-8725', NULL, NULL, NULL, 'www.bomar-renfroengineeringpartners.com', NULL, NULL, NULL, NULL, '5979 Lynwood Drive', 'Renton', 'WA', '95678', 'USA', 0);
INSERT INTO accounts VALUES ('c0a21503-5f76-f00e-48d9-438dfc082df1', '2005-11-30 19:24:19', '2005-11-30 19:24:19', '1', 'sarah_id', '1', 'L & O Wheeler Machinery Group', NULL, 'Consulting', 'Machinery', NULL, NULL, '9228 Via Del Sol', 'Imperial Beach', 'CA', '14388', 'USA', NULL, NULL, '978-555-7018', NULL, NULL, NULL, 'www.lowheelermachinerygroup.com', NULL, NULL, NULL, NULL, '9228 Via Del Sol', 'Imperial Beach', 'CA', '14388', 'USA', 0);
INSERT INTO accounts VALUES ('299f8caa-246a-2d76-cc17-438dfce96996', '2005-11-30 19:24:20', '2005-11-30 19:24:20', '1', 'sarah_id', '1', 'Wheeler-Irvin Machinery Corp', NULL, 'Supply', 'Machinery', NULL, NULL, '8507 Mt. Palomar Pl.', 'Richmond', 'CA', '84180', 'USA', NULL, NULL, '459-555-5539', NULL, NULL, NULL, 'www.wheeler-irvinmachinerycorp.com', NULL, NULL, NULL, NULL, '8507 Mt. Palomar Pl.', 'Richmond', 'CA', '84180', 'USA', 0);
INSERT INTO accounts VALUES ('5bac5a31-8b26-551c-115a-438dfc10fa26', '2005-11-30 19:24:20', '2005-11-30 19:24:20', '1', 'beth_id', '1', 'J & R Green Construction Group', NULL, 'Distribution', 'Construction', NULL, NULL, '3421 Gehringer Drive', 'Daly City', 'CA', '69375', 'USA', NULL, NULL, '117-555-2460', NULL, NULL, NULL, 'www.jrgreenconstructiongroup.com', NULL, NULL, NULL, NULL, '3421 Gehringer Drive', 'Daly City', 'CA', '69375', 'USA', 0);
INSERT INTO accounts VALUES ('d3364601-0197-635a-5243-438dfc4ccd2b', '2005-11-30 19:24:20', '2005-11-30 19:24:20', '1', 'sally_id', '1', 'Green-Stanford Communications Associates', NULL, 'Manufacturing', 'Communications', NULL, NULL, '298 Sunnybrook Drive', 'Spring Valley', 'CA', '32621', 'USA', NULL, NULL, '520-555-8610', NULL, NULL, NULL, 'www.green-stanfordcommunicationsassociates.com', NULL, NULL, NULL, NULL, '298 Sunnybrook Drive', 'Spring Valley', 'CA', '32621', 'USA', 0);
INSERT INTO accounts VALUES ('3c85e9b6-2a9c-6ac1-8654-438dfc6d6a4c', '2005-11-30 19:24:21', '2005-11-30 19:24:21', '1', 'beth_id', '1', 'I & O Ritchie Electronics Holdings', NULL, 'Distribution', 'Electronics', NULL, NULL, '8120 E Leland', 'Glendale', 'CA', '56686', 'USA', NULL, NULL, '440-555-7818', NULL, NULL, NULL, 'www.ioritchieelectronicsholdings.com', NULL, NULL, NULL, NULL, '8120 E Leland', 'Glendale', 'CA', '56686', 'USA', 0);


--
-- Data for Name: accounts_audit; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: accounts_bugs; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: accounts_cases; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: accounts_contacts; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO accounts_contacts VALUES ('bcc46e10-d7e9-d54a-b1e9-438dfbc4bafd', 'bb802563-dbfd-2639-c9fa-438dfb9199b8', 'a69dae1f-b2ee-1257-3895-438dfb8ea964', '2005-11-30 19:19:03', 0);
INSERT INTO accounts_contacts VALUES ('9d9606a9-1fc4-7d42-4e6e-438dfb950e23', '8a210ac7-7523-9b8b-9faf-438dfb909a0c', 'e908e57d-18d3-5ffa-f6f4-438dfb104441', '2005-11-30 19:19:04', 0);
INSERT INTO accounts_contacts VALUES ('324e0c33-84d7-0609-a430-438dfb988a45', '31136eba-e3e3-4b7d-3ee7-438dfb56849d', '18ae2ab5-0bfd-980d-2519-438dfbda705b', '2005-11-30 19:19:04', 0);
INSERT INTO accounts_contacts VALUES ('5a6c8178-5f91-a152-8970-438dfb064ce0', '593728c4-4173-b0bc-e23c-438dfb39cc6b', '419aa1b7-1392-c018-5c08-438dfb43dd59', '2005-11-30 19:19:04', 0);
INSERT INTO accounts_contacts VALUES ('81166bad-cb61-ae5b-81b2-438dfb139c59', '7fd06dbb-9d41-5f4b-cb9e-438dfb066e1e', '67c3c020-4ffe-b315-284a-438dfb4cd6d8', '2005-11-30 19:19:04', 0);
INSERT INTO accounts_contacts VALUES ('a7d00f36-bf00-5c69-ad61-438dfbf1d770', 'a692eb2a-7fc3-554a-075e-438dfb3defbe', '8f2b0a70-46e7-f25a-7dcc-438dfbc8112e', '2005-11-30 19:19:04', 0);
INSERT INTO accounts_contacts VALUES ('cedeb064-367d-59b3-c112-438dfb292f76', 'cdabe509-e99f-10e6-b850-438dfb4e77ab', 'b560e2dc-22bd-6582-bc09-438dfb8ffc59', '2005-11-30 19:19:04', 0);
INSERT INTO accounts_contacts VALUES ('c7a00076-0816-63c4-e4b6-438dfb4c40b9', 'f3bb465d-7373-1199-fa96-438dfbe70098', 'dc2a7c81-a009-cace-2d18-438dfbabf3d5', '2005-11-30 19:19:05', 0);
INSERT INTO accounts_contacts VALUES ('262647ca-c0d3-d64c-0791-438dfbbc9ae8', '24c17224-e34f-666a-932a-438dfb286732', 'e2060a5d-c072-69b9-fea6-438dfb520511', '2005-11-30 19:19:05', 0);
INSERT INTO accounts_contacts VALUES ('4f82c315-d7e7-aab4-43d5-438dfbccc7ea', '4e46bc60-41f5-8793-ca11-438dfbd64e39', '33919037-63ff-98f9-4447-438dfb5acbdb', '2005-11-30 19:19:05', 0);
INSERT INTO accounts_contacts VALUES ('7f302615-7ac7-7530-834b-438dfbb42516', '7dfe3255-e3f2-9e59-541e-438dfb0d18ac', '60413755-db82-584c-101d-438dfb6380b1', '2005-11-30 19:19:05', 0);
INSERT INTO accounts_contacts VALUES ('a95486fc-a28f-3dee-4da5-438dfb530385', 'a6d648b2-0dd7-53e4-66b3-438dfb723a8e', '8c9f383e-c1b7-70f8-3208-438dfbc39940', '2005-11-30 19:19:05', 0);
INSERT INTO accounts_contacts VALUES ('d1240ba7-7f7a-3f51-1462-438dfb4714be', 'cfee4945-1054-87f6-6095-438dfb82d731', 'b6bcb002-7146-374e-0f62-438dfb1ecc89', '2005-11-30 19:19:05', 0);
INSERT INTO accounts_contacts VALUES ('24c50e7d-2e98-8203-5fcd-438dfb47c5a0', '11470142-1c2d-3484-7f80-438dfbf9e224', 'de8788ae-186e-8976-b01a-438dfb2b8a05', '2005-11-30 19:19:06', 0);
INSERT INTO accounts_contacts VALUES ('2a966d8c-bbac-6ded-0043-438dfb082fc0', '27e9e8b5-778c-2a97-170b-438dfb5bad1d', 'fab50378-1552-a629-0700-438dfb1e3c07', '2005-11-30 19:19:06', 0);
INSERT INTO accounts_contacts VALUES ('53be3826-3622-e334-5ea0-438dfb5450b9', '528b3285-5137-27d8-2239-438dfbcf86ca', '382799fa-9f4d-a2a0-f436-438dfb2ab9e1', '2005-11-30 19:19:06', 0);
INSERT INTO accounts_contacts VALUES ('7a8bb56c-83c1-1524-6ab1-438dfb7617d6', '79480537-6a23-807b-b5ce-438dfb7e0125', '611c2870-5b76-3473-fa0e-438dfb4778a4', '2005-11-30 19:19:06', 0);
INSERT INTO accounts_contacts VALUES ('a1837003-451e-d1bf-a131-438dfbaa80a3', 'a04eef15-2fc8-b045-118a-438dfbe190c3', '87f2d1aa-1a8f-51ed-b562-438dfbf8e1f7', '2005-11-30 19:19:06', 0);
INSERT INTO accounts_contacts VALUES ('c8606997-ee9b-9b94-d55a-438dfb6df507', 'c7209bc9-cdf1-b2c0-04ad-438dfb7c971c', 'aed2dd85-41f1-3abb-02f3-438dfbd64a1b', '2005-11-30 19:19:06', 0);
INSERT INTO accounts_contacts VALUES ('f2add063-984a-4537-f513-438dfb31e90e', 'f17b0a36-dd67-e34a-8a26-438dfbda57ee', 'd5b953e2-7668-721f-21cc-438dfbf0b385', '2005-11-30 19:19:06', 0);
INSERT INTO accounts_contacts VALUES ('27f6c014-0298-db7c-3470-438dfb75a34a', '263e527e-1f82-b638-e106-438dfbf79c91', 'c08208ee-c631-2468-f4ef-438dfbb1f92c', '2005-11-30 19:19:07', 0);
INSERT INTO accounts_contacts VALUES ('52532d35-0ac2-f1ab-aa8c-438dfb59dac1', '5117a2b0-5b05-93a4-94c8-438dfbdcbc82', '3624c5a8-5dcf-8f66-f9a1-438dfb26f2da', '2005-11-30 19:19:07', 0);
INSERT INTO accounts_contacts VALUES ('80d5b3a5-c5cf-7aba-67ca-438dfbdf81e8', '7f9fefd7-0145-8f48-d5c6-438dfb2bbaaa', '5fd3e853-98f8-6dbf-208c-438dfb9d5c69', '2005-11-30 19:19:07', 0);
INSERT INTO accounts_contacts VALUES ('ac139f3d-92e6-cc95-2c34-438dfb627c96', 'aadc4d2a-0ef2-3c65-f9e6-438dfbee0156', '8e54f9ad-8ffe-e5ca-b871-438dfb253fb7', '2005-11-30 19:19:07', 0);
INSERT INTO accounts_contacts VALUES ('d3680dde-9a93-abfa-4245-438dfbe25ec4', 'd2334399-c473-72ad-76d9-438dfbeabbbb', 'b97ff471-9ee3-0e12-2dd9-438dfb9b36e0', '2005-11-30 19:19:07', 0);
INSERT INTO accounts_contacts VALUES ('54630b78-230d-176e-c475-438dfb9b2f4a', '40d00a43-15bc-4b70-eab0-438dfbca436f', 'e153589f-133b-e390-b669-438dfb24cd9f', '2005-11-30 19:19:08', 0);
INSERT INTO accounts_contacts VALUES ('2d08765e-5bdc-3f6d-e3d2-438dfbe07bda', '2bd53b60-4e28-1041-8100-438dfbe53e5f', '12ca7ab1-220a-4af9-99ba-438dfbe5571c', '2005-11-30 19:19:08', 0);
INSERT INTO accounts_contacts VALUES ('5b5ebdc1-de75-14c6-d397-438dfb1c5ab4', '5a16f961-a57e-941d-d844-438dfb7cd674', '3a942d15-be46-e733-9cd3-438dfbb71e24', '2005-11-30 19:19:08', 0);
INSERT INTO accounts_contacts VALUES ('8555b2be-2fe7-3ee9-e172-438dfb671ee0', '841d9d0a-6f2b-d9f1-dc34-438dfbbae76a', '68b936e6-d166-104a-f3f3-438dfb9a2b2a', '2005-11-30 19:19:08', 0);
INSERT INTO accounts_contacts VALUES ('acff0470-8d47-6030-dd6d-438dfb38a92a', 'abcb8cfb-43c9-366c-c9b9-438dfb73e4fb', '92b622ce-8026-54c4-bb92-438dfbea0f65', '2005-11-30 19:19:08', 0);
INSERT INTO accounts_contacts VALUES ('d23e192f-dc1c-60ef-04f1-438dfb2b657b', 'd108fe2d-0635-8e6d-574e-438dfb6d7216', 'ba692bd5-98cb-195e-3509-438dfb8e7448', '2005-11-30 19:19:08', 0);
INSERT INTO accounts_contacts VALUES ('87870893-f6a1-8ac3-9df8-438dfbd582fa', '72fd0dd7-9020-07ef-1d6f-438dfb5c8d5b', 'df9d2e47-e4af-a4cd-f57f-438dfb4ad6c4', '2005-11-30 19:19:09', 0);
INSERT INTO accounts_contacts VALUES ('2e03a29d-d01b-6dfa-a3f6-438dfbc38ba1', '2cc82984-4a85-76a0-43fe-438dfb2c8d15', '15e6d611-0ff0-efa3-2a08-438dfb32d02d', '2005-11-30 19:19:09', 0);
INSERT INTO accounts_contacts VALUES ('55928a58-1e2a-824f-9175-438dfb4fff71', '545cb14d-527a-645f-0a1d-438dfb86862c', '3b8554f2-e220-4e32-b135-438dfb52f9fe', '2005-11-30 19:19:09', 0);
INSERT INTO accounts_contacts VALUES ('8059e18e-86a0-fe81-0721-438dfb9120a8', '7f113cac-cb20-909d-2bd0-438dfb985833', '62e7c87a-db38-c12d-27c1-438dfb76bf23', '2005-11-30 19:19:09', 0);
INSERT INTO accounts_contacts VALUES ('ac659755-8689-8ff1-d4d8-438dfbd3dc30', 'ab2285a7-3eda-6915-0890-438dfbed0ec1', '9483cdff-0afc-bc72-342c-438dfb495915', '2005-11-30 19:19:09', 0);
INSERT INTO accounts_contacts VALUES ('d46e6732-0a8e-e789-371a-438dfb46ba81', 'd33b6eed-2503-1999-4f16-438dfbb86cdd', 'b9b66e60-dbc2-97f8-d5b4-438dfbb7431d', '2005-11-30 19:19:09', 0);
INSERT INTO accounts_contacts VALUES ('928e07ed-a39b-a4b1-1970-438dfb04154f', '7f380294-4d5a-2418-326a-438dfb97479e', 'e1e7c4e5-7e25-6799-eb9a-438dfba51d7f', '2005-11-30 19:19:10', 0);
INSERT INTO accounts_contacts VALUES ('34e58380-5d23-3179-8b01-438dfb881691', '339ff6ca-8783-9684-0457-438dfb07d717', '19c8dab9-5903-3485-5d78-438dfb4125b3', '2005-11-30 19:19:10', 0);
INSERT INTO accounts_contacts VALUES ('5c5ecc07-1541-6b9a-1588-438dfbf2e139', '5b28b2bc-d4c4-7422-3742-438dfb9f0d53', '44496c8b-c971-3912-ef47-438dfb05614b', '2005-11-30 19:19:10', 0);
INSERT INTO accounts_contacts VALUES ('87f372ff-7ec9-fc59-c55a-438dfbc4dcce', '86aff25f-1d29-195a-2da1-438dfbb2f27b', '69df481f-8899-8333-3d9c-438dfbae3e94', '2005-11-30 19:19:10', 0);
INSERT INTO accounts_contacts VALUES ('b8371b91-c0d5-1e66-9f53-438dfba27235', 'b6f9c204-ce8b-02a7-f6c5-438dfb56b420', '9bf12bea-3d89-2b67-a279-438dfb7f1aa9', '2005-11-30 19:19:10', 0);
INSERT INTO accounts_contacts VALUES ('e21f1859-01ab-69a4-adf7-438dfb12d7d5', 'e0e009ad-28b2-adb4-af1a-438dfb913008', 'c5fb833d-150f-99a6-9946-438dfb94f2c5', '2005-11-30 19:19:10', 0);
INSERT INTO accounts_contacts VALUES ('1afa1fd5-70ae-80e8-f28c-438dfb7a8d32', '19bf50f3-ca1e-78ee-7776-438dfb6d64a3', '24360cfc-2889-5353-2998-438dfbffd419', '2005-11-30 19:19:11', 0);
INSERT INTO accounts_contacts VALUES ('4cec690c-b00b-f0bd-4871-438dfb1088ee', '4bad5d02-7445-fbca-999f-438dfbfbf5ac', '28a3374d-7edd-e1ae-8b82-438dfbb1ba4b', '2005-11-30 19:19:11', 0);
INSERT INTO accounts_contacts VALUES ('725b00f1-00fc-96ab-34c0-438dfb1b04e5', '7119c042-2d7c-dc23-73a5-438dfb65becd', '5a6c2cce-c982-432d-802f-438dfbaa1b2d', '2005-11-30 19:19:11', 0);
INSERT INTO accounts_contacts VALUES ('97afc566-acf9-5c1e-b47b-438dfbc60f82', '967ad106-7163-d1de-cf04-438dfbfde97e', '7fb9aa29-6e36-4329-96a0-438dfbe17998', '2005-11-30 19:19:11', 0);
INSERT INTO accounts_contacts VALUES ('bcfc2199-439f-6b16-f4e7-438dfb399e35', 'bbc58875-cf6e-fc85-ce58-438dfb8d6e65', 'a5207af5-eba0-4a11-4fec-438dfb66e63f', '2005-11-30 19:19:11', 0);
INSERT INTO accounts_contacts VALUES ('e9bf4362-ae1f-a130-348c-438dfb8c4bda', 'e87e2072-12dc-87ca-0617-438dfbf93677', 'ca77a3a6-1980-87ca-3936-438dfbc5ed9a', '2005-11-30 19:19:11', 0);
INSERT INTO accounts_contacts VALUES ('225f3423-45b0-e87c-a82e-438dfbbf2d35', '2120606a-0955-480b-e6d2-438dfbf02c42', '301d0472-13ab-06ea-b8ea-438dfbbf5d2b', '2005-11-30 19:19:12', 0);
INSERT INTO accounts_contacts VALUES ('4decf75a-8ec0-df6a-a6fd-438dfbce3e09', '4ca7b843-1a0c-c8bd-41e8-438dfbb96e5c', '2fe59fe0-21e0-b9aa-f06e-438dfbf94248', '2005-11-30 19:19:12', 0);
INSERT INTO accounts_contacts VALUES ('73b654e8-421c-be11-78a0-438dfbc7829d', '727bdc86-cc15-4887-fdb2-438dfb20aa21', '5bcee21d-2f47-8266-e876-438dfb7e8edd', '2005-11-30 19:19:12', 0);
INSERT INTO accounts_contacts VALUES ('b58f7c45-6365-0868-c2ba-438dfb5ba6b5', 'b45957c0-0e7b-291e-5060-438dfb010d39', '812f72fc-ab3e-476d-9117-438dfb874384', '2005-11-30 19:19:12', 0);
INSERT INTO accounts_contacts VALUES ('df28163b-1cde-f92d-3266-438dfbc29050', 'ddf44cdd-dfa0-5804-4e7e-438dfb952497', 'c2f7eed0-8116-30ea-954e-438dfb1eabdb', '2005-11-30 19:19:12', 0);
INSERT INTO accounts_contacts VALUES ('17be147a-22bf-0874-af36-438dfb467b8f', '167e9a40-babb-5fcf-c7e0-438dfb37c1e5', 'ec7d9ee2-985e-832d-246a-438dfb43d183', '2005-11-30 19:19:13', 0);
INSERT INTO accounts_contacts VALUES ('4d0cee57-4721-a2e3-64f5-438dfb526dc9', '4bc6d3c1-0ba1-e888-e3dd-438dfbabe3bc', '25d33195-1843-27b2-f5df-438dfbbd4332', '2005-11-30 19:19:13', 0);
INSERT INTO accounts_contacts VALUES ('7294b8c1-73a6-e91c-25e0-438dfb52953f', '715a1c89-9563-a49c-0f74-438dfb5a299d', '5a9ce64f-76c1-d0b3-0321-438dfb8cf7b6', '2005-11-30 19:19:13', 0);
INSERT INTO accounts_contacts VALUES ('97f3088d-41b4-79bb-f11d-438dfbf6446a', '96b732db-0f25-0950-9b2a-438dfbdb2a24', '7ff64e0f-4980-e147-e646-438dfb3c2560', '2005-11-30 19:19:13', 0);
INSERT INTO accounts_contacts VALUES ('bd672e97-3998-e327-2019-438dfbacbf4a', 'bc254bfc-e799-a53e-be8c-438dfb96079c', 'a57a0171-598b-52c1-a44f-438dfbac3293', '2005-11-30 19:19:13', 0);
INSERT INTO accounts_contacts VALUES ('e33d9850-dff8-551f-97e7-438dfb3143f9', 'e1f907ff-1787-dd63-1859-438dfb648808', 'cad65136-9e79-c945-107b-438dfb8b41de', '2005-11-30 19:19:13', 0);
INSERT INTO accounts_contacts VALUES ('14a58411-61f6-9603-d402-438dfbacc912', '136de141-adcd-f7be-6797-438dfb2318c2', 'f09a17fa-2820-2d97-db3c-438dfbf7e7e5', '2005-11-30 19:19:14', 0);
INSERT INTO accounts_contacts VALUES ('3a803c64-637e-c1f5-6ebc-438dfba8ddc6', '39451f50-83c1-64a8-7ff5-438dfb004619', '221acfb4-1667-5126-232f-438dfb9ae6c1', '2005-11-30 19:19:14', 0);
INSERT INTO accounts_contacts VALUES ('625e612d-9906-3be7-f406-438dfb971286', '6125f6b6-47d4-c462-48a6-438dfb395c33', '49d9b236-ff3a-4340-f619-438dfb42fdf8', '2005-11-30 19:19:14', 0);
INSERT INTO accounts_contacts VALUES ('87aa201f-bd65-db39-e11f-438dfbb26439', '866fb183-32a3-55f7-5dc2-438dfb9d6362', '6fc8c6a5-7400-9855-fac4-438dfb37774c', '2005-11-30 19:19:14', 0);
INSERT INTO accounts_contacts VALUES ('ad28e389-a93f-5833-a328-438dfbc3830c', 'abeb7043-fc40-2f0c-61b9-438dfbd2767e', '953f26e5-ef03-73a5-2912-438dfbf3e02e', '2005-11-30 19:19:14', 0);
INSERT INTO accounts_contacts VALUES ('d487ebba-dd7b-b60a-7430-438dfb55500a', 'd349c763-90df-0b27-5d66-438dfb9513ae', 'baa2d9d1-3d4d-1de9-fdf3-438dfba9a8e5', '2005-11-30 19:19:14', 0);
INSERT INTO accounts_contacts VALUES ('1268f26d-f7c3-ff1b-89a2-438dfb6db6f5', '1136b8ac-1c42-0198-2f40-438dfb039aa7', 'eea76ad0-2d41-1f9b-c178-438dfb4344f9', '2005-11-30 19:19:15', 0);
INSERT INTO accounts_contacts VALUES ('3a771b48-0e69-e3ed-798b-438dfbfb9a26', '393d943f-cdbe-a0af-ffbc-438dfb4eb54e', '1fe57f85-843a-c2da-ce4a-438dfbdca0ec', '2005-11-30 19:19:15', 0);
INSERT INTO accounts_contacts VALUES ('645ecb7d-4730-7d0f-693b-438dfb0698f8', '63287cc0-1fd3-bfe3-b51a-438dfbfea241', '4ab5174a-cfe1-ac9d-33d7-438dfb1ba854', '2005-11-30 19:19:15', 0);
INSERT INTO accounts_contacts VALUES ('8aadad52-4bfd-a042-ceb3-438dfbfd49b1', '89732904-ca5f-122d-243a-438dfb172253', '71d45061-e051-80ff-387f-438dfbcf7868', '2005-11-30 19:19:15', 0);
INSERT INTO accounts_contacts VALUES ('b008c118-5fa2-7399-0f85-438dfb623d58', 'aece530f-a91b-b630-76e5-438dfb297598', '9831fcba-daad-6531-f7d9-438dfb452a61', '2005-11-30 19:19:15', 0);
INSERT INTO accounts_contacts VALUES ('d66d056a-9946-1272-a156-438dfbfb6707', 'd536a8dc-d8a9-3b88-7827-438dfb1c3a18', 'bd7a6aa6-59fa-3349-782d-438dfb6a361a', '2005-11-30 19:19:15', 0);
INSERT INTO accounts_contacts VALUES ('8b140c87-c81b-0201-5107-438dfbe5f3dc', '770a06b0-150e-497b-792f-438dfb2ff161', 'e3d36dd6-a3ec-ca32-8f00-438dfbf01d62', '2005-11-30 19:19:16', 0);
INSERT INTO accounts_contacts VALUES ('31f4152d-cccb-c2c0-024a-438dfb3f2ac3', '2f899226-e94a-e050-e252-438dfb4b3a5f', '16270908-902d-5444-bdd2-438dfb677e78', '2005-11-30 19:19:16', 0);
INSERT INTO accounts_contacts VALUES ('59b958cd-4ab2-b8ef-ba39-438dfb3e5b2e', '5865e81d-ecbf-6298-ed52-438dfbcedb7e', '3f6d17ff-3b92-d8ce-b733-438dfb08d42a', '2005-11-30 19:19:16', 0);
INSERT INTO accounts_contacts VALUES ('804c1a2d-6b4c-f611-fd54-438dfba1b885', '7f15ddfe-549f-620f-86f8-438dfb9d4720', '672ce9a6-eabc-8209-5417-438dfbe5cda1', '2005-11-30 19:19:16', 0);
INSERT INTO accounts_contacts VALUES ('a71c75de-25e8-5dc3-d17c-438dfb39bbeb', 'a5e3e96c-95c7-7450-db68-438dfb54b406', '8dbf7451-dc4a-3634-8099-438dfb762ae2', '2005-11-30 19:19:16', 0);
INSERT INTO accounts_contacts VALUES ('cc7ca02f-f288-203e-60bd-438dfbcddc20', 'cb3f0df6-d3b0-b003-9454-438dfb5e01d2', 'b48abc38-b9e5-f7a7-1a0a-438dfb92bcf3', '2005-11-30 19:19:16', 0);
INSERT INTO accounts_contacts VALUES ('3c2a048d-8340-4713-f3be-438dfbebcb10', '27940605-6e82-fbe4-5532-438dfbf29045', 'da0b3314-1bd1-f760-47f1-438dfba1b415', '2005-11-30 19:19:17', 0);
INSERT INTO accounts_contacts VALUES ('2b02d865-0df8-846a-2d3c-438dfb48414a', '29a01cb7-7a4e-4edd-e402-438dfb4ca729', '115922df-1ff1-d274-144c-438dfb73dc42', '2005-11-30 19:19:17', 0);
INSERT INTO accounts_contacts VALUES ('55d5f0d3-5fbc-f5c2-d435-438dfbbd7869', '54919bc9-5eb4-1211-79ce-438dfb77bcf5', '389b7a9d-973c-9771-632a-438dfb1fddfc', '2005-11-30 19:19:17', 0);
INSERT INTO accounts_contacts VALUES ('7bd40531-c034-38f1-5169-438dfbd5d057', '7a98c258-e4e1-0520-d532-438dfb94e823', '63f1f0f0-6489-f61f-9a36-438dfb750c25', '2005-11-30 19:19:17', 0);
INSERT INTO accounts_contacts VALUES ('a4c55156-02e9-1989-ffbd-438dfbbbbf19', 'a385df8d-6c2d-7325-f66f-438dfb3c415a', '8945a4f8-4927-b6da-7fbc-438dfb9c24e5', '2005-11-30 19:19:17', 0);
INSERT INTO accounts_contacts VALUES ('cbeefa00-14a5-8ff0-b52e-438dfbc251bb', 'caafd3ec-ffe6-dfd3-3eb7-438dfb39be07', 'b23360b3-d90f-0bf2-6864-438dfba63bde', '2005-11-30 19:19:17', 0);
INSERT INTO accounts_contacts VALUES ('f377dc70-a78c-36f5-90a1-438dfb3ac503', 'f23304bf-4215-df4f-fb8a-438dfba9f91e', 'd97458bd-138c-6ccd-14c1-438dfb875b17', '2005-11-30 19:19:18', 0);
INSERT INTO accounts_contacts VALUES ('26cdcb85-db79-5ffb-a761-438dfb74f5c2', '258a5f07-360a-c8cd-11cf-438dfbca3689', 'cdb7018f-2af9-c5c5-bc5a-438dfbeabc25', '2005-11-30 19:19:18', 0);
INSERT INTO accounts_contacts VALUES ('54beb679-cada-c4ec-dfea-438dfbfe2c0e', '537446e4-5d04-ab85-2893-438dfb18bd39', '34b7fcff-4ff6-4547-cc7f-438dfb271457', '2005-11-30 19:19:18', 0);
INSERT INTO accounts_contacts VALUES ('7e78bacd-4c55-04ff-2d5f-438dfb4b8639', '790410a3-d5bf-e225-36f4-438dfb428365', '6243d450-6220-61bb-adf6-438dfb62abb7', '2005-11-30 19:19:18', 0);
INSERT INTO accounts_contacts VALUES ('a638b36a-79e7-ca34-ac9b-438dfb3b8702', 'a4fc684e-0745-5d43-5b95-438dfb537c7e', '8bfc78c0-4447-55f8-cdcf-438dfb161815', '2005-11-30 19:19:18', 0);
INSERT INTO accounts_contacts VALUES ('d006f9b3-6c6a-53b8-5ef4-438dfb6ec445', 'ceced487-1e05-7d48-1c43-438dfb3c95b3', 'b3a58eda-3bc0-5d5d-8ca5-438dfbaadf87', '2005-11-30 19:19:18', 0);
INSERT INTO accounts_contacts VALUES ('3c850bd2-55c3-be29-555f-438dfb6c0a87', '283a0cfb-8d13-3443-aa4b-438dfbd40bbd', 'dd8ee07f-61bd-30be-d935-438dfb426550', '2005-11-30 19:19:19', 0);
INSERT INTO accounts_contacts VALUES ('2bd2d962-6ffb-548c-6b1b-438dfbddfbba', '2a76b7db-d29e-fc19-3e66-438dfb1a9ce7', '114ec48e-57e4-c5c2-6507-438dfb9ef25b', '2005-11-30 19:19:19', 0);
INSERT INTO accounts_contacts VALUES ('55cdebed-412f-2988-5fed-438dfb5a8dce', '5499f38d-2452-480f-6a82-438dfb4339a5', '3981b1f2-08e7-abb6-7b8e-438dfb4658ac', '2005-11-30 19:19:19', 0);
INSERT INTO accounts_contacts VALUES ('82e2bed1-899c-1f49-54a2-438dfb1e130a', '819ebf07-9068-2265-3739-438dfb26ddf0', '63857cd3-6d3f-f409-fc9e-438dfb3001c1', '2005-11-30 19:19:19', 0);
INSERT INTO accounts_contacts VALUES ('aacd3e10-ab11-ef65-621c-438dfb09fcbb', 'a993780c-29e0-14c5-6c37-438dfbb7f3f3', '9052e8c4-579b-4c67-d96e-438dfbe34bfd', '2005-11-30 19:19:19', 0);
INSERT INTO accounts_contacts VALUES ('d2eddc01-79be-6942-725d-438dfbe24e05', 'd1b4f9da-9474-2dd4-dfac-438dfb1cf765', 'b852c1cb-196b-7ad1-9184-438dfbc4807b', '2005-11-30 19:19:19', 0);
INSERT INTO accounts_contacts VALUES ('4a40097b-f549-13bf-f545-438dfbb315c8', '35c50219-a425-8f43-7566-438dfb064e4e', 'e0deb83a-33bc-8a70-50a3-438dfbf1a6a6', '2005-11-30 19:19:20', 0);
INSERT INTO accounts_contacts VALUES ('2fc065a1-ccbf-49ab-6273-438dfbcc4694', '2e865eed-39a2-3987-e5a5-438dfbf2b70a', '12198b06-7362-bee7-e01a-438dfbd300d2', '2005-11-30 19:19:20', 0);
INSERT INTO accounts_contacts VALUES ('5769543c-d74d-9722-6beb-438dfbfbbbbe', '562d1f1b-5752-11b7-9725-438dfbbdf622', '3d3f5fec-1a99-37c2-6014-438dfbb1a5c1', '2005-11-30 19:19:20', 0);
INSERT INTO accounts_contacts VALUES ('857d4c4c-4c36-2d76-bbad-438dfb204ccd', '8443046f-b16a-c222-cc34-438dfb8fb06a', '64ec2f2b-40b0-800b-58d6-438dfb65cc42', '2005-11-30 19:19:20', 0);
INSERT INTO accounts_contacts VALUES ('b0d7c3b3-ce5c-4f5d-79ac-438dfbf6b7bd', 'af9c21d4-befe-7b2a-7274-438dfbf8cd23', '92f1a02c-7979-d266-3394-438dfbc063ae', '2005-11-30 19:19:20', 0);
INSERT INTO accounts_contacts VALUES ('d951a950-9af3-1be9-002b-438dfbe57081', 'd8170029-51c7-b9cb-235c-438dfb16119b', 'be69c39d-736a-d99a-4197-438dfb894cfb', '2005-11-30 19:19:20', 0);
INSERT INTO accounts_contacts VALUES ('10dc5c87-a273-0375-28dd-438dfb3ece62', 'f9fe06d7-6202-eff3-9f14-438dfb23e331', 'e6c97f92-50da-b9e5-7b28-438dfb52a851', '2005-11-30 19:19:21', 0);
INSERT INTO accounts_contacts VALUES ('39a07596-243e-2d50-908a-438dfbf42d3b', '3868028a-ef4e-3ada-3656-438dfb00b42a', '1e493e94-354d-d36a-f996-438dfb1616f5', '2005-11-30 19:19:21', 0);
INSERT INTO accounts_contacts VALUES ('67bc22ea-fcda-1a5f-ffe9-438dfbb7b94e', '6680952f-19e8-4e10-c31f-438dfb881bbd', '491c4d19-fbdd-d1dd-89a2-438dfb782d21', '2005-11-30 19:19:21', 0);
INSERT INTO accounts_contacts VALUES ('8dfee87d-b01d-f54b-d6a9-438dfbecaf14', '8cc0df97-5709-0de6-ab07-438dfb74e0a8', '75f3c5be-eb04-4dcb-14ce-438dfb5a878c', '2005-11-30 19:19:21', 0);
INSERT INTO accounts_contacts VALUES ('bad6f60d-de49-0a03-efa2-438dfb249cca', 'b996df6d-c8b8-f88b-023b-438dfb45858f', '9b726ecd-688f-c61a-a444-438dfb218fd1', '2005-11-30 19:19:21', 0);
INSERT INTO accounts_contacts VALUES ('ebc9bfc4-4251-858b-fc58-438dfbe903a8', 'ea824454-efb2-4aa6-e266-438dfb61a3d5', 'c8bc538e-0714-e8c1-94bb-438dfb137c7a', '2005-11-30 19:19:21', 0);
INSERT INTO accounts_contacts VALUES ('2576006d-16fd-2a01-38b0-438dfb093301', '2439132d-ba73-53f7-fba3-438dfb23a83a', '59fb0e8f-dc34-a05a-0f81-438dfba3c7a8', '2005-11-30 19:19:22', 0);
INSERT INTO accounts_contacts VALUES ('4dcad69a-bc55-64bc-a433-438dfb44dae2', '4c93e3f6-28e3-2838-eeab-438dfb5e2821', '3389b370-a721-0e58-e2b2-438dfbcbdd37', '2005-11-30 19:19:22', 0);
INSERT INTO accounts_contacts VALUES ('7edd5895-da98-7ade-f9e0-438dfb01e121', '7d9ae852-f52b-1b75-9770-438dfbf00f09', '5b65bb26-ee94-0741-e6d7-438dfb27d784', '2005-11-30 19:19:22', 0);
INSERT INTO accounts_contacts VALUES ('abd829f0-9dce-4171-fe27-438dfb553a5e', 'aa9b82c4-08a3-6f6d-c188-438dfb094e89', '8c5d0a27-943d-83f0-15a5-438dfba33bc3', '2005-11-30 19:19:22', 0);
INSERT INTO accounts_contacts VALUES ('d158c5c6-f256-a590-85d5-438dfb763b92', 'd01be770-137d-17c8-638f-438dfb46290d', 'b9492cd8-4a97-892c-c9c3-438dfb201fab', '2005-11-30 19:19:22', 0);
INSERT INTO accounts_contacts VALUES ('6d7c0a26-d25b-0e76-fc6a-438dfb597f49', '59a502e3-2284-31a8-19ed-438dfb279276', 'df0f0986-f65e-d456-1351-438dfb44de21', '2005-11-30 19:19:23', 0);
INSERT INTO accounts_contacts VALUES ('3847971d-d444-bbc5-1fbc-438dfbfc0262', '37013eaa-abec-2a6c-5a24-438dfb08bf58', '145df113-5365-45fa-ebe7-438dfbbd5844', '2005-11-30 19:19:23', 0);
INSERT INTO accounts_contacts VALUES ('67fd8c53-b495-0c57-43ea-438dfb5d6157', '66ba4a7c-c25a-1980-fa88-438dfbab3062', '47f16a6f-0237-ee14-c676-438dfb83235d', '2005-11-30 19:19:23', 0);
INSERT INTO accounts_contacts VALUES ('957d29c0-3754-3686-4825-438dfb945ee7', '9441d611-d85e-30f2-681b-438dfb92a448', '756fbb6a-6aa6-3de0-15da-438dfbe81403', '2005-11-30 19:19:23', 0);
INSERT INTO accounts_contacts VALUES ('c33ad68e-d2fb-622e-f71e-438dfbef0fc4', 'c1ee8e98-ab9e-ed88-8805-438dfbf902fc', 'a306a41f-d08d-9f88-7e78-438dfbb3dbf4', '2005-11-30 19:19:23', 0);
INSERT INTO accounts_contacts VALUES ('ecc68d52-3b05-f8b9-3519-438dfb81c1e4', 'eb8eb435-7a45-006f-1e55-438dfbd3ab4c', 'd0aa1c58-ab79-3669-d1e3-438dfb7eb918', '2005-11-30 19:19:23', 0);
INSERT INTO accounts_contacts VALUES ('1e1f7dae-69a2-cfbb-c10a-438dfba55ae0', '1cda71ed-f945-6d54-8521-438dfb8d3a30', '61c904f0-7a9d-bd79-1c3c-438dfb588f82', '2005-11-30 19:19:24', 0);
INSERT INTO accounts_contacts VALUES ('45b415f0-81e2-f89c-d538-438dfbb8846e', '427c41d3-cdce-dabf-ac7d-438dfb5750ba', '2b9828bf-e533-2198-b512-438dfb8d5bce', '2005-11-30 19:19:24', 0);
INSERT INTO accounts_contacts VALUES ('788f9d49-f59b-68aa-7c31-438dfb7dfbae', '77566d1b-0ec6-1ca5-6f04-438dfb102ed6', '5348b563-0622-42d3-71ba-438dfb807b3f', '2005-11-30 19:19:24', 0);
INSERT INTO accounts_contacts VALUES ('9dfa7402-d4c8-d121-9b26-438dfb275a60', '9cbb9c04-c760-bcdd-5da9-438dfbf6c5dd', '860964ee-8fd8-a620-ec96-438dfbf111c3', '2005-11-30 19:19:24', 0);
INSERT INTO accounts_contacts VALUES ('c7cd376a-3a60-9c45-f951-438dfb9603e2', 'c6960b1c-72f0-fcf7-d688-438dfbe5a54f', 'ab505e26-a5cc-8535-2e96-438dfb5e4452', '2005-11-30 19:19:24', 0);
INSERT INTO accounts_contacts VALUES ('ed2049ab-a5b1-dcff-334e-438dfb93c9a3', 'ebe6e0fc-13c7-17fa-d77c-438dfb78437e', 'd53a7082-2cca-4184-26df-438dfb8a9e29', '2005-11-30 19:19:24', 0);
INSERT INTO accounts_contacts VALUES ('1ed939c3-b7ef-4c75-aa74-438dfbcb7009', '1d80898a-13ea-e09d-0b6d-438dfb309291', '683501c7-529b-869a-5687-438dfb04ab8b', '2005-11-30 19:19:25', 0);
INSERT INTO accounts_contacts VALUES ('4b05ee03-aa35-a78b-be49-438dfb3c065d', '49c61ee7-e45d-58cd-9208-438dfb5baaec', '2c46c77e-e5a7-5cc1-6df7-438dfb2e201c', '2005-11-30 19:19:25', 0);
INSERT INTO accounts_contacts VALUES ('70dcc157-4463-3d89-b5a3-438dfb4547ec', '6fa0db29-6446-b169-acb0-438dfbe72f12', '589ab56c-b842-1e39-fa69-438dfb3c55d5', '2005-11-30 19:19:25', 0);
INSERT INTO accounts_contacts VALUES ('96462aa0-7662-66dd-dea6-438dfbaa6630', '950f70ad-2c1b-f21f-5d9d-438dfb367669', '7e48a579-8198-83c2-3e93-438dfbb37fa2', '2005-11-30 19:19:25', 0);
INSERT INTO accounts_contacts VALUES ('c5aa498a-4cf0-faed-ce60-438dfb6ddf79', 'ba84e8f6-5b81-1190-256d-438dfb8113ee', 'a3ae5ce7-97f3-0767-2c32-438dfb67ba2f', '2005-11-30 19:19:25', 0);
INSERT INTO accounts_contacts VALUES ('f0472471-79e2-ec14-5b12-438dfbb1d330', 'ef0cd81b-ba24-743a-cc7b-438dfbb90482', 'd3341561-6269-a089-3222-438dfbd74426', '2005-11-30 19:19:25', 0);
INSERT INTO accounts_contacts VALUES ('3108ad6b-0d02-5639-d201-438dfb5eb06b', '2fbede29-f88d-0084-733c-438dfbc5e779', '99540248-a633-5eab-e014-438dfbbb6d0d', '2005-11-30 19:19:26', 0);
INSERT INTO accounts_contacts VALUES ('5dfb9f5c-eda6-8dde-37a3-438dfb5a33c5', '5cbf8d1f-4b07-3656-5c3c-438dfb057c9e', '3e8c7862-6b2a-0824-ec19-438dfb18f048', '2005-11-30 19:19:26', 0);
INSERT INTO accounts_contacts VALUES ('8ddc0942-3b23-e7a8-1de1-438dfb53527c', '8c95d8fc-6990-8abc-b3bc-438dfbdcdaa9', '6b74ee4d-f2e1-c581-dd78-438dfb730c7e', '2005-11-30 19:19:26', 0);
INSERT INTO accounts_contacts VALUES ('bde9b3b3-4cba-17f5-7d27-438dfbe9379d', 'bc9fc81c-5702-c80c-2442-438dfb88891f', '9b5b10ca-e088-dfb3-7bd6-438dfb9f4ae9', '2005-11-30 19:19:26', 0);
INSERT INTO accounts_contacts VALUES ('49f60714-6200-f8af-30bd-438dfbeb1495', '3592041a-0719-5e56-2ed2-438dfbc17944', 'cb6a9a32-58b5-580b-d07f-438dfb32eafe', '2005-11-30 19:19:27', 0);
INSERT INTO accounts_contacts VALUES ('352740c7-2b4f-5094-73d0-438dfbbd0cc5', '33e61fde-9201-5509-588e-438dfb4640a6', '1221a978-b701-cc79-29b4-438dfb27ec07', '2005-11-30 19:19:27', 0);
INSERT INTO accounts_contacts VALUES ('5ccef672-86a4-3c9b-8a0b-438dfbfe6216', '5b8a2402-a0c8-4603-9196-438dfbce88c9', '42b754c8-dfad-6eaf-cbe5-438dfb050c30', '2005-11-30 19:19:27', 0);
INSERT INTO accounts_contacts VALUES ('937539a1-1317-45b2-a2a2-438dfb55b42d', '8c7dfaf8-f0a5-b2b4-6a97-438dfbff9a61', '6aa69a70-12fe-e914-688b-438dfb971562', '2005-11-30 19:19:27', 0);
INSERT INTO accounts_contacts VALUES ('b8f36ea4-85e1-3ab8-88d4-438dfb629b9e', 'b7bd6c9a-9d1b-1d13-5e34-438dfbb2a501', 'a0e7ad4b-b177-b914-da9c-438dfbda815f', '2005-11-30 19:19:27', 0);
INSERT INTO accounts_contacts VALUES ('e440d945-63eb-a01c-1a1b-438dfb7573e1', 'e2ff38cd-d2fb-a192-2252-438dfba48023', 'c6632abb-10b1-66c3-3525-438dfb4119f5', '2005-11-30 19:19:27', 0);
INSERT INTO accounts_contacts VALUES ('1b77fdc8-0b42-40c2-e00b-438dfb19fcec', '1a3d193b-8586-6cae-5ee5-438dfbcace66', 'f1b68c60-fd88-d531-9e4c-438dfb9d470d', '2005-11-30 19:19:28', 0);
INSERT INTO accounts_contacts VALUES ('4162b82d-6fa2-3e7c-a63d-438dfb8fdd97', '4028b56e-9e0e-755a-cb68-438dfbc44138', '28f75af4-5123-7550-243f-438dfb8ddf01', '2005-11-30 19:19:28', 0);
INSERT INTO accounts_contacts VALUES ('75063ce6-47f7-5214-53ae-438dfb466627', '73c2b29a-61da-9fad-6c88-438dfb3347e7', '51066781-1ec3-3fe8-7322-438dfbd99b65', '2005-11-30 19:19:28', 0);
INSERT INTO accounts_contacts VALUES ('a087f0c0-59f0-323b-e4f4-438dfbeb11e1', '9f4c127d-9fb8-41b2-a428-438dfb262585', '827f20ff-6ccb-df5c-4492-438dfb56d80b', '2005-11-30 19:19:28', 0);
INSERT INTO accounts_contacts VALUES ('cc13e2eb-4632-d433-167b-438dfb5a93ae', 'cad3aec5-15c0-f51d-37ed-438dfbd8e36b', 'ae0caf82-6b91-edcd-ac34-438dfbcae84b', '2005-11-30 19:19:28', 0);
INSERT INTO accounts_contacts VALUES ('96cd02d2-d6c2-8196-071d-438dfb4d144b', '82de0e50-aded-2288-2380-438dfbe71fa6', 'd97a4b11-78d3-b9d3-7024-438dfbf6028a', '2005-11-30 19:19:29', 0);
INSERT INTO accounts_contacts VALUES ('3b57995d-c4ba-4870-9397-438dfb887711', '3a0ed43e-b12e-8d5e-e7b3-438dfb06a6cf', '16eb4b2a-a495-ed33-7f2c-438dfb73ede3', '2005-11-30 19:19:29', 0);
INSERT INTO accounts_contacts VALUES ('62f42d0c-1f2d-45cd-9406-438dfbc075bf', '61b3ca44-234d-0362-46fc-438dfb3875ff', '4ad0c452-7b48-f49a-70a1-438dfb731561', '2005-11-30 19:19:29', 0);
INSERT INTO accounts_contacts VALUES ('8ed1dae6-2e4d-189a-5b55-438dfb1a2e00', '8d866ec7-767d-d182-e7c4-438dfbdab705', '709024ac-3d9e-e75a-0885-438dfb820403', '2005-11-30 19:19:29', 0);
INSERT INTO accounts_contacts VALUES ('baa03a35-ee27-095c-74c8-438dfbb23b09', 'b960d4f5-54fc-3cd3-e40a-438dfb10ed57', '9c5ee206-33e1-c7be-2e44-438dfbcfc3a3', '2005-11-30 19:19:29', 0);
INSERT INTO accounts_contacts VALUES ('f356449d-be43-62e6-466e-438dfbc7937a', 'f219dbc4-a9b7-9203-a3ff-438dfb4e3c78', 'c80dea92-93bd-414c-7d12-438dfbe287a0', '2005-11-30 19:19:29', 0);
INSERT INTO accounts_contacts VALUES ('2496bbf0-53e7-9681-6da7-438dfbcad85e', '235e35cd-72a0-46ef-1100-438dfb94854b', 'cadd0934-23c0-fc21-697f-438dfbfc60c0', '2005-11-30 19:19:30', 0);
INSERT INTO accounts_contacts VALUES ('52c5f097-5aac-46e0-7a7c-438dfb07b82b', '518aec41-ced5-fed4-5c17-438dfb8e4034', '322e401c-c694-0233-da27-438dfb2436c5', '2005-11-30 19:19:30', 0);
INSERT INTO accounts_contacts VALUES ('784c3174-31ee-c5cb-3a59-438dfb97a868', '77120e6c-ce95-4c79-d5e0-438dfba2a1aa', '6052c1a5-b3da-6061-5b1a-438dfbf123ea', '2005-11-30 19:19:30', 0);
INSERT INTO accounts_contacts VALUES ('a54588f5-a2d4-3dfe-f4e8-438dfbc24c3e', 'a40d393e-7d45-49d2-a417-438dfbf6afb3', '85ee0e3f-0406-f066-bfe7-438dfb3e0803', '2005-11-30 19:19:30', 0);
INSERT INTO accounts_contacts VALUES ('cab58526-3e5d-261e-e13b-438dfbdcd83a', 'c9756760-9f79-5ae9-7c4b-438dfb9971ef', 'b2bfa84e-a0ac-6463-92be-438dfbaed94a', '2005-11-30 19:19:30', 0);
INSERT INTO accounts_contacts VALUES ('1184431b-bb54-aaca-94e2-438dfb6dfece', '1039724e-858e-a7f4-2da6-438dfb589c61', 'd84cc26b-f46c-10fd-4f62-438dfb4edfa7', '2005-11-30 19:19:31', 0);
INSERT INTO accounts_contacts VALUES ('375dd0af-ef20-e330-b132-438dfbed7dfa', '361f5e6f-269e-aa43-af97-438dfbb387ec', '1ef0046a-4960-119d-3483-438dfb613ed1', '2005-11-30 19:19:31', 0);
INSERT INTO accounts_contacts VALUES ('75a74a0f-cfc1-c5d0-28b0-438dfb3a779c', '746f64b0-e0c9-fd20-8391-438dfbb1302a', '54cfcff9-db3f-3b0d-be97-438dfbe302c0', '2005-11-30 19:19:31', 0);
INSERT INTO accounts_contacts VALUES ('a2440421-b1f3-050a-7038-438dfb7d79f1', 'a101f279-8f8e-b452-d0e7-438dfbe2ac2c', '8327ec22-ad12-cd30-c238-438dfb0571e1', '2005-11-30 19:19:31', 0);
INSERT INTO accounts_contacts VALUES ('c7d2324a-fa82-ed82-c6be-438dfbea1719', 'c68a5e6e-06dc-b478-79b3-438dfbb22351', 'afc2a69b-8290-5e45-403f-438dfbb1b556', '2005-11-30 19:19:31', 0);
INSERT INTO accounts_contacts VALUES ('eeeb0b36-f85b-6be8-2dc1-438dfb417ee3', 'dac00f21-34af-8b1c-9d49-438dfb707d61', 'd5753872-c4a2-ab13-81c2-438dfbae0c3a', '2005-11-30 19:19:32', 0);
INSERT INTO accounts_contacts VALUES ('43240998-bec1-f70c-25ae-438dfb01d914', '41ea173b-5026-f9c2-44fe-438dfb5b519d', '1c670ba7-7180-c746-7a2e-438dfb331ea2', '2005-11-30 19:19:32', 0);
INSERT INTO accounts_contacts VALUES ('6adb69df-1754-5a75-e84c-438dfb00d8f1', '69a15b9c-ba1f-0b56-c4e3-438dfb1ed3b1', '52c17774-4f45-6c9b-31b1-438dfb100ff3', '2005-11-30 19:19:32', 0);
INSERT INTO accounts_contacts VALUES ('9f952bdc-593d-3932-e33b-438dfb67226c', '9e5ad4da-bebd-4fc7-757e-438dfba96019', '78c4ec52-4f79-ce55-3a17-438dfb858894', '2005-11-30 19:19:32', 0);
INSERT INTO accounts_contacts VALUES ('ccb19150-8f84-fce9-bcbf-438dfb594c02', 'cb739056-d549-a52c-9cfb-438dfb72d3f8', 'ad155aa3-a8e4-85f8-3f49-438dfb1b1044', '2005-11-30 19:19:32', 0);
INSERT INTO accounts_contacts VALUES ('f40adf0f-1f23-f6ee-c6c3-438dfbd02e85', 'f2c006f7-68c3-8518-11ae-438dfb9f603b', 'db14c64c-910d-69f7-4363-438dfb060df3', '2005-11-30 19:19:33', 0);
INSERT INTO accounts_contacts VALUES ('365c0d5c-0276-689a-690c-438dfb159888', '3513db0c-633e-ba0e-dfb9-438dfbfc7f63', 'e0b30a6a-2d97-08a9-b773-438dfb91ae00', '2005-11-30 19:19:33', 0);
INSERT INTO accounts_contacts VALUES ('66730293-8e09-0d79-2347-438dfb248e82', '6526f511-453f-b131-636e-438dfbbf2392', '44499ff2-512d-c664-957c-438dfbce7e97', '2005-11-30 19:19:33', 0);
INSERT INTO accounts_contacts VALUES ('93c64e3e-e6c9-ffec-134e-438dfb2652d4', '928a2d9b-80a1-0ac6-a738-438dfb58f8c8', '73f7b9c1-cae3-d662-c9aa-438dfb346e05', '2005-11-30 19:19:33', 0);
INSERT INTO accounts_contacts VALUES ('c8dd3f74-a2d4-9ed2-4259-438dfbbc1fa9', 'c792c6c4-f0e2-c128-bd46-438dfbbf844a', 'a15828e0-e941-7e5e-6f3f-438dfb062b99', '2005-11-30 19:19:33', 0);
INSERT INTO accounts_contacts VALUES ('ee430067-3055-aa31-0720-438dfb3d1b02', 'ed0bb8d6-0a70-299b-bd61-438dfb09b0d5', 'd6531f8e-d33a-e2e4-7955-438dfb4d05f0', '2005-11-30 19:19:33', 0);
INSERT INTO accounts_contacts VALUES ('1fca07ca-e848-fbdd-5d1d-438dfb966b84', '1e86a0f2-7f05-0edc-1e13-438dfb97c09b', '7ade03c1-f61f-b9f9-aa17-438dfb9a7bab', '2005-11-30 19:19:34', 0);
INSERT INTO accounts_contacts VALUES ('4f62b692-0a50-e7eb-626e-438dfb4066b2', '4e29c3a9-cf5c-7614-6017-438dfb169fd4', '356ecfc0-140f-77b6-2121-438dfbc3c55d', '2005-11-30 19:19:34', 0);
INSERT INTO accounts_contacts VALUES ('75675ce2-5665-4a91-07bb-438dfb507086', '73ee799c-af53-d544-475e-438dfba140eb', '5d13a786-5be5-de7f-dd0c-438dfbf14353', '2005-11-30 19:19:34', 0);
INSERT INTO accounts_contacts VALUES ('b3686bcf-f930-c3bd-7024-438dfbe4bfa3', 'b224ca6b-0196-ec35-5827-438dfb0772ea', '82d95c21-6a10-9582-5b3d-438dfbf0a156', '2005-11-30 19:19:34', 0);
INSERT INTO accounts_contacts VALUES ('5e5303ee-f248-5884-a870-438dfbf156de', 'e868b404-9ea4-2b87-f816-438dfb8e35f1', 'c0f35cdd-896f-1ffe-f8f0-438dfb2e3c96', '2005-11-30 19:19:35', 0);
INSERT INTO accounts_contacts VALUES ('44779d3a-e48b-d9ec-f04b-438dfb80bdc4', '433a0b75-adf7-5918-651b-438dfb0f7716', '137e9f95-f313-8360-f71c-438dfb599270', '2005-11-30 19:19:35', 0);
INSERT INTO accounts_contacts VALUES ('6ca405b0-1c10-7a78-26f0-438dfb7b5961', '6b69184c-d652-c3ab-2dd9-438dfbec4dc2', '548525fc-1d16-2812-5072-438dfbaafd50', '2005-11-30 19:19:35', 0);
INSERT INTO accounts_contacts VALUES ('9aa25b5f-f2e6-1817-2dc6-438dfbb89394', '99640829-2013-718d-3c44-438dfb32f479', '7a3171f6-d717-19aa-5933-438dfbda3f5d', '2005-11-30 19:19:35', 0);
INSERT INTO accounts_contacts VALUES ('c012d12d-62a5-e915-792b-438dfb45cb12', 'bed444fa-684a-534d-65e9-438dfb258cab', 'a818e283-96a4-aa8c-37d5-438dfb366d30', '2005-11-30 19:19:35', 0);
INSERT INTO accounts_contacts VALUES ('2890038a-db63-76e8-1d64-438dfb09f2cc', '143f0702-7b65-68f0-0723-438dfb45c00f', 'cd8af16b-58ec-668e-e936-438dfb0fdf00', '2005-11-30 19:19:36', 0);
INSERT INTO accounts_contacts VALUES ('39529b0b-ac9b-03db-60aa-438dfbb7fcc6', '3815a954-8743-e120-33b0-438dfb05770f', 'ffe80125-9dcf-c8d9-f1a0-438dfbc2a96a', '2005-11-30 19:19:36', 0);
INSERT INTO accounts_contacts VALUES ('612629c3-f811-6c5e-a9fc-438dfb783083', '5fed8b57-62a4-c15c-b118-438dfb281982', '48da9622-e1a0-fbf9-fd6e-438dfb5e0199', '2005-11-30 19:19:36', 0);
INSERT INTO accounts_contacts VALUES ('86e2d37b-6193-6006-8610-438dfb78a869', '85a60f7d-9587-1656-3b83-438dfb598875', '6ea42746-6034-fd93-ae2b-438dfb7d7116', '2005-11-30 19:19:36', 0);
INSERT INTO accounts_contacts VALUES ('ad5f521a-c509-b519-4f11-438dfbc8aca0', 'ac1f04db-a85a-fb68-4025-438dfb51a395', '9460b401-d542-7d9e-8055-438dfbe5fc59', '2005-11-30 19:19:36', 0);
INSERT INTO accounts_contacts VALUES ('d37071bb-15e4-e180-e34d-438dfb4b3611', 'd2352fd3-ffeb-9558-65d1-438dfbc1f861', 'bb03cc1d-1a07-9134-d717-438dfb09a7da', '2005-11-30 19:19:36', 0);
INSERT INTO accounts_contacts VALUES ('52fe0bb1-99ff-341f-9b9d-438dfb92921d', '3eec0406-5202-44bb-4e4c-438dfbaa2a8d', 'e0f0dce7-0249-715a-aa3a-438dfbb404f3', '2005-11-30 19:19:37', 0);
INSERT INTO accounts_contacts VALUES ('2b4eb5ba-3aa1-8e88-5cb3-438dfba3541e', '2a0ccd11-a8be-92e6-cee6-438dfb21b54a', '12b61455-359d-ef18-61dc-438dfbc36256', '2005-11-30 19:19:37', 0);
INSERT INTO accounts_contacts VALUES ('52e174cc-9a9c-9b54-8840-438dfbedc0e9', '51aac716-2b45-762a-6fc7-438dfb839e11', '38e21953-c4b9-e613-7092-438dfbd0c194', '2005-11-30 19:19:37', 0);
INSERT INTO accounts_contacts VALUES ('78dea0e5-431b-2236-0b5a-438dfbb97288', '776599c7-a174-a3c2-ffe6-438dfb253633', '60684d96-aa4c-400a-3f4a-438dfbba21ee', '2005-11-30 19:19:37', 0);
INSERT INTO accounts_contacts VALUES ('9febbbcd-daae-bae3-a1b8-438dfb89cea1', '9eafaeb4-1820-798f-787b-438dfbecb32e', '86803808-fbc6-9eb8-e332-438dfbc84e4d', '2005-11-30 19:19:37', 0);
INSERT INTO accounts_contacts VALUES ('c56f3865-8f15-6e93-4309-438dfb824e74', 'c434f91a-d271-3174-6cdc-438dfbdffd48', 'ad550398-ed33-33b0-506e-438dfba55edc', '2005-11-30 19:19:37', 0);
INSERT INTO accounts_contacts VALUES ('ed80c3b8-27a9-7cf9-99e9-438dfb724f88', 'ec457caf-9418-32ba-7ce7-438dfb584e8b', 'd2f41bc7-cf41-86c8-a468-438dfbebc670', '2005-11-30 19:19:37', 0);
INSERT INTO accounts_contacts VALUES ('228d6764-9df7-69e8-7209-438dfbfc1b64', '2145cd2c-cc9e-fe19-631d-438dfb576a32', '6dbd0bad-3095-cceb-6509-438dfbcbadc8', '2005-11-30 19:19:38', 0);
INSERT INTO accounts_contacts VALUES ('4a206950-55bf-5753-28a6-438dfbd16f7f', '46e8c833-0042-a7b0-9c36-438dfb2081eb', '30074748-1f3c-ffca-1f92-438dfbcdf41b', '2005-11-30 19:19:38', 0);
INSERT INTO accounts_contacts VALUES ('71dc6848-0aa7-4405-e8aa-438dfba5cb26', '70980b53-67b8-f172-7449-438dfb415b17', '57cab759-6c7e-8167-0136-438dfb48df83', '2005-11-30 19:19:38', 0);
INSERT INTO accounts_contacts VALUES ('97582890-1ca4-8e78-4286-438dfbcf301b', '961f0b7a-2020-7514-26b3-438dfb2f0d79', '7f5e48b7-8871-f3e9-716b-438dfb8e9e06', '2005-11-30 19:19:38', 0);
INSERT INTO accounts_contacts VALUES ('bf243cea-8f1f-335d-3920-438dfb144cc3', 'bded0db1-6418-1126-bae1-438dfba93d2b', 'a4f68013-8e21-9e4d-982d-438dfb76cef9', '2005-11-30 19:19:38', 0);
INSERT INTO accounts_contacts VALUES ('e5caf1ff-eb86-568f-815d-438dfb7d5e8d', 'e48fabf1-5cae-b35d-27b0-438dfbb82d13', 'cc8c4b85-7a41-ee9c-5ae8-438dfb628795', '2005-11-30 19:19:38', 0);
INSERT INTO accounts_contacts VALUES ('17361047-5278-277f-97ac-438dfb05b73a', '15fb9c0e-95cc-f8c9-6bfd-438dfb22d26e', 'f3562fb8-e19d-3c2f-fd04-438dfb709397', '2005-11-30 19:19:39', 0);
INSERT INTO accounts_contacts VALUES ('3f7b9b34-8da3-f9b9-524c-438dfba8b8cc', '3e3e2d11-08cc-2355-8f5b-438dfbc773d6', '27473bd7-d8cf-18f8-b2a9-438dfb78c444', '2005-11-30 19:19:39', 0);
INSERT INTO accounts_contacts VALUES ('6a0e62d8-04a3-6cd5-3db6-438dfb3a4a38', '68ca340f-ab88-eb87-d292-438dfb84f9d7', '4f0dc9e4-5602-a885-ae9f-438dfb9fb925', '2005-11-30 19:19:39', 0);
INSERT INTO accounts_contacts VALUES ('918c2719-f200-5e0b-816e-438dfbbc71d0', '904c62b8-4554-279e-9f9e-438dfb66dba1', '778c9cdd-ed31-1220-9535-438dfb496070', '2005-11-30 19:19:39', 0);
INSERT INTO accounts_contacts VALUES ('b95347a0-5eeb-fb13-51f2-438dfbe2df6f', 'b81981da-4714-600d-6002-438dfb1dfc49', '9f58bfc7-c032-ea8c-7741-438dfbe5ff07', '2005-11-30 19:19:39', 0);
INSERT INTO accounts_contacts VALUES ('deb5652c-83fc-ed1a-d694-438dfbac4a26', 'dd7965df-b162-bdb6-7780-438dfbf1c4de', 'c6c2c945-7272-8204-87b6-438dfb21706e', '2005-11-30 19:19:39', 0);
INSERT INTO accounts_contacts VALUES ('11adb148-b370-0060-c167-438dfb456b8b', '107116e8-0f2f-ec75-10aa-438dfb5eaf13', 'ec3a8159-35a1-1e25-873d-438dfbd93199', '2005-11-30 19:19:40', 0);
INSERT INTO accounts_contacts VALUES ('3957742b-f2f8-c8b6-a05d-438dfbda425c', '381bfa07-f82d-703f-d6a5-438dfb23a580', '1f2fea14-abc1-3aec-e784-438dfbc6c413', '2005-11-30 19:19:40', 0);
INSERT INTO accounts_contacts VALUES ('645b4ebc-9981-3293-7c45-438dfb2de39a', '61436bda-7784-8a98-fee4-438dfb3a7de0', '46b00b5a-2979-a81d-21df-438dfb0ce21a', '2005-11-30 19:19:40', 0);
INSERT INTO accounts_contacts VALUES ('8abbcbc7-6335-46ec-eaf6-438dfb89c020', '894e7203-3f6a-59f4-a48d-438dfb6ff374', '71de7f65-fbfc-1247-48be-438dfbda2ea9', '2005-11-30 19:19:40', 0);
INSERT INTO accounts_contacts VALUES ('b60f8494-5471-180c-86f9-438dfb77324b', 'b4c69598-acef-0376-cf3c-438dfba3d6b8', '98399ae4-48ae-3a6e-a6b8-438dfbfc3d10', '2005-11-30 19:19:40', 0);
INSERT INTO accounts_contacts VALUES ('dbabf3c7-cf2c-c28c-8548-438dfb9eab9d', 'da64618a-6cae-9cd3-2878-438dfbaee8c2', 'c3a340bf-1fb0-bf23-45b4-438dfbb2bf1b', '2005-11-30 19:19:40', 0);
INSERT INTO accounts_contacts VALUES ('f44c0529-6233-053d-aea6-438dfb892a53', 'e0950eb8-d447-9c9d-ca04-438dfb3cb0dd', 'e92944ca-2169-831d-2241-438dfbe14f3f', '2005-11-30 19:19:41', 0);
INSERT INTO accounts_contacts VALUES ('3b43a33b-055a-71a4-dae8-438dfbf9d56e', '3a07392d-4625-bf03-f6b0-438dfb244959', '1cd83a84-d536-65ee-1375-438dfb2acfab', '2005-11-30 19:19:41', 0);
INSERT INTO accounts_contacts VALUES ('62de0645-1cad-a18c-109a-438dfbe57851', '61a2af81-ceac-22ca-b531-438dfb3c4b4c', '4a646280-fdc3-79e8-9a02-438dfbaa84e7', '2005-11-30 19:19:41', 0);
INSERT INTO accounts_contacts VALUES ('888cc10a-0d76-ccaa-25e7-438dfb0ec936', '874aad29-6ec5-bdf7-41f8-438dfb9dc259', '705ef7a4-43a2-08a0-db33-438dfb3485bf', '2005-11-30 19:19:41', 0);
INSERT INTO accounts_contacts VALUES ('b06c7731-0a37-0a81-9804-438dfb14f559', 'af25a1e3-5fe7-c912-63f2-438dfbe333a7', '96149ed6-290f-78d3-3cf6-438dfb61ae08', '2005-11-30 19:19:41', 0);
INSERT INTO accounts_contacts VALUES ('daac93a2-ef1c-233c-a880-438dfb6b6d9e', 'd9730e7b-9d2d-3766-6acb-438dfb438131', 'bded92e7-965b-d779-89ec-438dfb22fbcf', '2005-11-30 19:19:41', 0);
INSERT INTO accounts_contacts VALUES ('ea3f03be-efb0-0e01-94b1-438dfbc68b66', 'd5ec06b7-1260-225f-9f9d-438dfb7dbc5c', 'e84468c7-d9e4-070d-54f8-438dfb7ff11f', '2005-11-30 19:19:42', 0);
INSERT INTO accounts_contacts VALUES ('395fd485-80f1-9c97-ccd0-438dfbaec9f9', '3824122a-7f5a-420f-0279-438dfbd51aac', '2148f18f-2408-a1cc-ebc2-438dfb9238fa', '2005-11-30 19:19:42', 0);
INSERT INTO accounts_contacts VALUES ('6385c217-c505-41f6-1dd4-438dfbb4c1c1', '624dde65-1436-3cd7-3c5b-438dfb36bb74', '46efaf6b-79d7-7108-b557-438dfb599391', '2005-11-30 19:19:42', 0);
INSERT INTO accounts_contacts VALUES ('897305bd-9cd3-986b-9664-438dfbfd3397', '883417ab-65a4-1cc0-1b9f-438dfb6fbed3', '70f9bcc1-a6cd-16ca-6188-438dfbfe26e2', '2005-11-30 19:19:42', 0);
INSERT INTO accounts_contacts VALUES ('b1da6af5-0710-ab5d-f3dc-438dfbe40cd8', 'b09fed6d-6360-8fe0-0682-438dfbb64579', '970db1ca-bbc5-1bed-58bc-438dfbc02ed0', '2005-11-30 19:19:42', 0);
INSERT INTO accounts_contacts VALUES ('dfc4109c-050c-7287-07c0-438dfb6a4cde', 'de86e4f6-d95c-37a9-98fc-438dfb0413d0', 'bf504165-a219-0727-b299-438dfbe18890', '2005-11-30 19:19:42', 0);
INSERT INTO accounts_contacts VALUES ('115dde51-8777-ad54-4b34-438dfb376bb5', '101d7eb7-52f6-2373-211a-438dfb8c134c', 'ed7e2b76-7300-b676-c21c-438dfb5370f0', '2005-11-30 19:19:43', 0);
INSERT INTO accounts_contacts VALUES ('3fed9ef9-c69e-aa15-b08f-438dfb0318f5', '3ea5b45b-9d69-5220-069c-438dfb06916b', '1ee0a704-d3ac-255b-e28a-438dfb6778bf', '2005-11-30 19:19:43', 0);
INSERT INTO accounts_contacts VALUES ('675fd240-fcf4-1c7d-b5c2-438dfb7cd477', '66188334-3548-544f-dbef-438dfbf03803', '4f5a2e60-a328-2863-508c-438dfbf96b08', '2005-11-30 19:19:43', 0);
INSERT INTO accounts_contacts VALUES ('902a361c-e969-f9e7-4b86-438dfbf16d81', '8eebe63b-1a8f-dde0-fd22-438dfbdb063d', '74ea30bd-bfd6-50c7-f602-438dfbb9b15b', '2005-11-30 19:19:43', 0);
INSERT INTO accounts_contacts VALUES ('b5977008-d11c-2d97-0302-438dfb439531', 'b4581850-679b-264c-177b-438dfba8b31f', '9db6a39c-455b-fadf-14fc-438dfbc0db37', '2005-11-30 19:19:43', 0);
INSERT INTO accounts_contacts VALUES ('de6169d5-1019-f185-98cb-438dfb67833c', 'dd237fbb-dafd-7a1b-8b45-438dfbb96c9e', 'c3079592-c5b0-337e-fb81-438dfb1f4d67', '2005-11-30 19:19:43', 0);
INSERT INTO accounts_contacts VALUES ('1118490a-7806-a3f0-c379-438dfb349031', 'fd7d03bc-1a2b-e9c0-18fd-438dfb9f8af3', 'ec2865f0-7fd3-5787-0dd7-438dfb089a43', '2005-11-30 19:19:44', 0);
INSERT INTO accounts_contacts VALUES ('3ee63d46-c033-454e-cd8a-438dfbe89fb2', '3d9f1380-7c58-e597-2b2a-438dfbc62e2d', '1f0b26f0-8865-637a-d591-438dfb700fb6', '2005-11-30 19:19:44', 0);
INSERT INTO accounts_contacts VALUES ('6e78f9bc-09f5-21a4-e318-438dfb03d552', '6d36c3d5-d9d7-e707-2f79-438dfb6990c1', '4e6a1409-2212-5aed-c99a-438dfbc0fb95', '2005-11-30 19:19:44', 0);
INSERT INTO accounts_contacts VALUES ('94345b0b-cbac-3a51-1ed9-438dfb44ba34', '92f2b33d-32e0-b2fd-f252-438dfb36b86b', '7c317fbb-51fd-244f-8ff5-438dfbda1e29', '2005-11-30 19:19:44', 0);
INSERT INTO accounts_contacts VALUES ('b9b07206-3668-cb31-bb7f-438dfbdcedc2', 'b8673793-9dd1-aeb3-bb8c-438dfb10c5c8', 'a1c6dd10-a511-f5a4-587a-438dfbdf1f11', '2005-11-30 19:19:44', 0);
INSERT INTO accounts_contacts VALUES ('e2b08d62-3a67-826a-4417-438dfba77be2', 'e175255e-59e2-b3fb-7f4d-438dfb9bbedc', 'c71a05f0-4fb4-6db9-4c75-438dfbe2017c', '2005-11-30 19:19:44', 0);
INSERT INTO accounts_contacts VALUES ('17eed297-9fb0-77c9-cac0-438dfb59f0da', '16b0233a-0619-426b-f513-438dfbb67b5d', 'f042e492-e8d1-80fc-4ec4-438dfbd0ae07', '2005-11-30 19:19:45', 0);
INSERT INTO accounts_contacts VALUES ('4161afda-1e42-beb7-23aa-438dfb7b718d', '4021f92a-ea68-e799-c145-438dfb8bfb4d', '2563e2bf-1a07-5db9-d427-438dfbc75f46', '2005-11-30 19:19:45', 0);
INSERT INTO accounts_contacts VALUES ('690223ca-25cf-616e-c6f2-438dfb36d127', '67baa0d0-87d3-417b-4df4-438dfb89ba88', '50f7b948-3a23-e5b5-1e66-438dfb163203', '2005-11-30 19:19:45', 0);
INSERT INTO accounts_contacts VALUES ('959a5fde-3487-5d0f-0ebe-438dfbeefbac', '9409ad1e-0280-2f21-e383-438dfb3e7633', '76982213-4d75-c8e7-b5ca-438dfb2db90c', '2005-11-30 19:19:45', 0);
INSERT INTO accounts_contacts VALUES ('d08c98e7-a92c-3f81-f407-438dfb8a2dd4', 'cee7b966-2480-8d9c-eafc-438dfba89472', 'a7309360-0640-95cc-2e64-438dfb01fb7d', '2005-11-30 19:19:45', 0);
INSERT INTO accounts_contacts VALUES ('c8e50f93-5a8a-d0d2-bc24-438dfbf9ab6e', 'af480f28-f9c1-d8f7-012b-438dfbf8f37a', 'e1df2c79-f019-b562-ec1f-438dfb43bacd', '2005-11-30 19:19:46', 0);
INSERT INTO accounts_contacts VALUES ('3cddabd3-08ab-f29f-f329-438dfb5e0df7', '3b4761fe-3f0d-1481-d903-438dfbd585fa', '1dd34cd8-e05b-bba4-9f20-438dfb753fea', '2005-11-30 19:19:46', 0);
INSERT INTO accounts_contacts VALUES ('7abf18c1-f5c7-b2d4-768c-438dfb4efdac', '792b092a-09e4-545b-cebf-438dfb843a11', '50d94809-19f5-1791-2a4f-438dfb6fe4b3', '2005-11-30 19:19:46', 0);
INSERT INTO accounts_contacts VALUES ('bc1a346c-ab64-9f84-f570-438dfbb374da', 'ba8287c2-cb83-aeba-508b-438dfbdce549', '8c588605-d9c6-92bf-0f2a-438dfbca1c6e', '2005-11-30 19:19:46', 0);
INSERT INTO accounts_contacts VALUES ('38920eed-a3b8-fd54-902b-438dfbacf8df', '1f3c0e58-4d97-95b5-39e1-438dfbfba571', 'cd68ff34-a6d3-4cea-0c89-438dfb0002b9', '2005-11-30 19:19:47', 0);
INSERT INTO accounts_contacts VALUES ('33cdef79-562d-5e53-fe3e-438dfbd37e44', '3233fb6b-85a6-203b-9bc8-438dfb576554', '14fd4f32-ae52-11da-ea20-438dfb1a3b6f', '2005-11-30 19:19:47', 0);
INSERT INTO accounts_contacts VALUES ('6725594d-5afd-7164-61c3-438dfb92d8dd', '658350ed-52b1-4348-2909-438dfb71dff2', '45680339-ff5e-a956-fa01-438dfb131b0c', '2005-11-30 19:19:47', 0);
INSERT INTO accounts_contacts VALUES ('97f481ba-fac5-6847-f549-438dfb5ed491', '965c6a46-a880-ec46-58d0-438dfb69fa47', '789c02cf-28d5-d394-dac6-438dfb023cce', '2005-11-30 19:19:47', 0);
INSERT INTO accounts_contacts VALUES ('c7f0a626-f82b-0509-95f9-438dfb509ba9', 'c65aded3-c296-a1a1-3e36-438dfb7c317d', 'a95b68c7-137b-66ca-1967-438dfbbf8f6a', '2005-11-30 19:19:47', 0);
INSERT INTO accounts_contacts VALUES ('16aeae0b-94c6-252d-98f5-438dfb5caaae', '1506cde5-fc12-26fa-0ac1-438dfbe00db9', 'd9601cf0-443a-526d-c1af-438dfb6e61f2', '2005-11-30 19:19:48', 0);
INSERT INTO accounts_contacts VALUES ('473b5745-02b4-7ce8-c68d-438dfbb39673', '45952a1a-db7a-a5d5-652c-438dfb93cba6', '282c22f3-be7c-9755-4791-438dfbf88660', '2005-11-30 19:19:48', 0);
INSERT INTO accounts_contacts VALUES ('805610ca-16ae-def3-f589-438dfb1087fc', '7ec3346c-278b-2910-5af2-438dfbc82a14', '5b21281d-97c7-e2c9-e9bc-438dfb5d341e', '2005-11-30 19:19:48', 0);
INSERT INTO accounts_contacts VALUES ('b08fbd0b-45cf-b0dc-9beb-438dfb91f6bd', 'aef8c633-a8ac-e5f5-5bc1-438dfbfe723b', '91dfc12a-3ad7-1830-ec75-438dfbd5a084', '2005-11-30 19:19:48', 0);
INSERT INTO accounts_contacts VALUES ('e078e0bb-edc2-1c6c-55b6-438dfbb86500', 'dee2e0ef-0dea-badf-e6f5-438dfbd65277', 'c1d693f0-0e67-c6e7-1b94-438dfb1fb102', '2005-11-30 19:19:48', 0);
INSERT INTO accounts_contacts VALUES ('29cf3108-c1b1-0b1b-3e5f-438dfb29fe74', '28392168-eded-4714-1cd9-438dfb84eb47', 'f1d85360-594a-7da8-d4d5-438dfb1d0846', '2005-11-30 19:19:49', 0);
INSERT INTO accounts_contacts VALUES ('5c95f6ab-9f96-cb22-94c1-438dfb78e142', '5af7a2dd-ddd4-6e6c-6b6d-438dfb64839b', '3b4f6477-a81d-c6ed-1cac-438dfb238ccf', '2005-11-30 19:19:49', 0);
INSERT INTO accounts_contacts VALUES ('9b05a0a3-f6b4-4f74-b610-438dfba82166', '99380eaf-4801-adb5-5864-438dfb1a8485', '6e233c2a-56ac-7b5b-7651-438dfb8fcb9e', '2005-11-30 19:19:49', 0);
INSERT INTO accounts_contacts VALUES ('dfe638ef-737e-994d-4860-438dfbf3b926', 'd7638159-25a8-703e-5d6d-438dfb5312da', 'ac75ac3d-99ba-4688-6ab1-438dfbcae3c6', '2005-11-30 19:19:49', 0);
INSERT INTO accounts_contacts VALUES ('2a43475c-08a5-0df1-341a-438dfbdb7ca8', '28a0e705-de7f-aacd-086a-438dfb12fd38', 'f154f522-1cdd-fdd4-ef3d-438dfb9d46f1', '2005-11-30 19:19:50', 0);
INSERT INTO accounts_contacts VALUES ('5d754339-a985-8877-446b-438dfb026e4b', '5bb7382e-5165-c29d-00de-438dfbf7257d', '3bc87d3b-43cb-efdf-efd1-438dfbcb8a22', '2005-11-30 19:19:50', 0);
INSERT INTO accounts_contacts VALUES ('94df5493-bc69-1c50-1890-438dfbdffa0f', '934b5b38-f799-5e29-7661-438dfb9c93a5', '6ee7d92a-216a-95bc-3cbb-438dfb280b1c', '2005-11-30 19:19:50', 0);
INSERT INTO accounts_contacts VALUES ('cc1fd2c1-13a0-d151-3817-438dfb5d65b4', 'ca7e2eb3-c15f-2bfd-6061-438dfba5aba2', 'a63a0010-23ef-efac-92d7-438dfb61e338', '2005-11-30 19:19:50', 0);
INSERT INTO accounts_contacts VALUES ('f7c804bf-0d65-bec1-4978-438dfb0abd78', 'dd3109db-391f-34f1-5456-438dfb6ab9fd', 'dd602b0b-cf10-4d7b-a6dc-438dfb4b4355', '2005-11-30 19:19:51', 0);
INSERT INTO accounts_contacts VALUES ('41098c9f-96c0-a46c-6cd7-438dfb2b9e06', '3f601166-0fad-603d-1fa8-438dfbe38bd9', '2129c10e-0acb-645f-11b5-438dfb42e470', '2005-11-30 19:19:51', 0);
INSERT INTO accounts_contacts VALUES ('7b370ebc-7809-3f7c-5093-438dfb051fb8', '799e1386-522c-cf3d-4976-438dfb9241ef', '54f75fe1-4a08-d273-3e6c-438dfbebf9b1', '2005-11-30 19:19:51', 0);
INSERT INTO accounts_contacts VALUES ('b2e466d4-97c8-b860-ae6d-438dfb624df8', 'b14a7f13-a6ea-090f-939a-438dfbd41a48', '8c9213bf-2128-c0bb-fd39-438dfb6b788b', '2005-11-30 19:19:51', 0);
INSERT INTO accounts_contacts VALUES ('f219352f-63a1-d6fb-e12c-438dfb100112', 'f08902b3-d9e0-883d-4c70-438dfb751521', 'c41cc4a0-ff49-fd83-b6d0-438dfbeffe1c', '2005-11-30 19:19:51', 0);
INSERT INTO accounts_contacts VALUES ('3ddb3cfa-dad3-6eb1-1f25-438dfb78284a', '3c2e6c6e-67e7-1f93-c86f-438dfb2b6f95', 'f6870d09-d6c5-0cde-9d5c-438dfb898ff7', '2005-11-30 19:19:52', 0);
INSERT INTO accounts_contacts VALUES ('78a26457-3a85-88d3-e498-438dfb34aaeb', '7702800a-816a-e10b-1263-438dfb7ef286', '51850727-7a19-5744-1bc2-438dfbc55957', '2005-11-30 19:19:52', 0);
INSERT INTO accounts_contacts VALUES ('b17c873b-01d3-07e3-dd66-438dfb1f1786', 'afe66e53-426d-6ab8-7079-438dfb2b8fac', '89f05f1d-00d1-f9ad-ed10-438dfbfa7346', '2005-11-30 19:19:52', 0);
INSERT INTO accounts_contacts VALUES ('e190b2cd-ae2d-5390-b2f7-438dfb5a7e62', 'dffc361e-4437-407c-1a2d-438dfb014ae4', 'c2ca1db8-72b2-aab3-1671-438dfb5b7b18', '2005-11-30 19:19:52', 0);
INSERT INTO accounts_contacts VALUES ('26118457-2d1a-fe3a-cf33-438dfb76a285', '2478194e-40ab-dffa-1fe0-438dfbb13f16', 'f2d60744-2eaf-0fad-53fc-438dfb112702', '2005-11-30 19:19:53', 0);
INSERT INTO accounts_contacts VALUES ('696b4c87-3c31-c9d8-1f5a-438dfb1e6c48', '67d44395-4b5b-d818-a580-438dfb90d815', '376bf639-52df-9ade-ba53-438dfba662ea', '2005-11-30 19:19:53', 0);
INSERT INTO accounts_contacts VALUES ('99c428d0-dc6b-484b-74c0-438dfbaf76ad', '9817d918-b558-4416-e067-438dfbb00ac3', '7ad7b724-722c-afde-9e26-438dfb765b79', '2005-11-30 19:19:53', 0);
INSERT INTO accounts_contacts VALUES ('ca21b3c6-2e59-e04f-2bab-438dfbfb7be4', 'c88cf6ff-bf68-754e-c5f7-438dfbffc4d3', 'ab3f11d0-c24f-2a9c-84d1-438dfb1185e4', '2005-11-30 19:19:53', 0);
INSERT INTO accounts_contacts VALUES ('e8a80f00-e158-1a1c-fb08-438dfb58fab3', 'ce360ab5-b009-af3d-7ddf-438dfb56eeee', 'db69fc79-b660-0433-6cd8-438dfb76b979', '2005-11-30 19:19:54', 0);
INSERT INTO accounts_contacts VALUES ('5af996f9-9096-90f2-4474-438dfbd0c50c', '59581ac2-2c43-32c5-8c08-438dfbb53a75', '1fde64a0-ec9f-2527-1ea6-438dfb8a5d08', '2005-11-30 19:19:54', 0);
INSERT INTO accounts_contacts VALUES ('8b608b6b-0888-2fcf-29d5-438dfbd06f3c', '89bc281c-5b88-0a21-8bdc-438dfbbe1baa', '6c7b6081-0197-c017-49df-438dfb374396', '2005-11-30 19:19:54', 0);
INSERT INTO accounts_contacts VALUES ('c774155f-30ce-d296-a5bb-438dfbe172fc', 'c5dd824e-a607-5691-b542-438dfbafdcae', '9d57fdf9-bb75-7a8e-43a4-438dfb49fa3f', '2005-11-30 19:19:54', 0);
INSERT INTO accounts_contacts VALUES ('e1ea065d-1abd-0669-7e2b-438dfbec0a73', 'c87b0e59-5044-8cf7-d5d8-438dfbc9a6ae', 'dadf62da-b669-bdae-9db7-438dfbf0a9cf', '2005-11-30 19:19:55', 0);
INSERT INTO accounts_contacts VALUES ('3e6e65ab-6043-b4a1-1d03-438dfb40adc3', '3cdb06a0-9ad1-cea7-1959-438dfba473f6', '1f8456e5-21d4-6023-8d8b-438dfb7d19c8', '2005-11-30 19:19:55', 0);
INSERT INTO accounts_contacts VALUES ('7b57225c-a00d-7e5e-ab98-438dfbb65b0f', '7952f556-ed16-4c84-6b90-438dfb87944f', '525a01b5-ce2d-6203-5892-438dfb7d2dcd', '2005-11-30 19:19:55', 0);
INSERT INTO accounts_contacts VALUES ('acbe1ec1-ac99-7400-eca4-438dfbd1c29c', 'ab24c645-c052-67a0-62df-438dfbe6603a', '8d1a8e12-42ae-5f8b-99ed-438dfbfefb98', '2005-11-30 19:19:55', 0);
INSERT INTO accounts_contacts VALUES ('de09385c-1e7f-1b6b-4912-438dfb3459a3', 'dc63f764-1068-2c60-4430-438dfb1bf2c6', 'be84eeb2-3179-bc9f-19bb-438dfba25b6b', '2005-11-30 19:19:55', 0);
INSERT INTO accounts_contacts VALUES ('36f47d3a-08f9-28a1-1654-438dfb244ec6', '35557da2-371b-0464-603a-438dfb80dec5', 'efbc0b52-f58c-a29d-5701-438dfb69e717', '2005-11-30 19:19:56', 0);
INSERT INTO accounts_contacts VALUES ('8731545d-179d-1b8b-dd82-438dfbdcb3b8', '859225e9-1fd7-ef47-acab-438dfbfb3645', '491bb8cb-9fa3-e979-3d0e-438dfb23148f', '2005-11-30 19:19:56', 0);
INSERT INTO accounts_contacts VALUES ('b87ca7c0-1e60-4641-05cb-438dfbadc048', 'b6e1902d-d5f5-ae68-cc0a-438dfb5405b9', '98e876e2-cf6d-9fcc-6d59-438dfb12781a', '2005-11-30 19:19:56', 0);
INSERT INTO accounts_contacts VALUES ('e89f00e7-11d5-feb9-92ca-438dfb7c380b', 'e7068a6a-051f-dae4-9012-438dfbe22d8f', 'c9f9a26d-7f8a-ada3-5257-438dfbcd245e', '2005-11-30 19:19:56', 0);
INSERT INTO accounts_contacts VALUES ('37dc9487-da58-98d3-5610-438dfb176d38', '3647b747-73b1-83c3-409a-438dfb867bce', '5e3b05ab-1491-e073-63e8-438dfb5de624', '2005-11-30 19:19:57', 0);
INSERT INTO accounts_contacts VALUES ('748922d6-1bfc-69f7-7667-438dfb657d3f', '72f54a65-c53d-ffdf-5b04-438dfbe458c4', '4969f1d8-0c9d-788f-62f6-438dfb89a07c', '2005-11-30 19:19:57', 0);
INSERT INTO accounts_contacts VALUES ('aeef8307-f72a-8dae-5089-438dfb70da51', 'ad5a291e-8bdb-6bc9-fdff-438dfbcb3082', '85d65ddd-8632-09d9-f47f-438dfb6f4e9c', '2005-11-30 19:19:57', 0);
INSERT INTO accounts_contacts VALUES ('f2be1bd2-2d1f-27f6-aee2-438dfb8b5e3a', 'f11ab305-a0e2-bb96-b103-438dfb6acce1', 'c031e40c-7c5d-6e0b-1185-438dfb943437', '2005-11-30 19:19:57', 0);
INSERT INTO accounts_contacts VALUES ('44341c20-a129-c90e-bd7e-438dfb147693', '429dcaaf-dd41-8b3f-b0de-438dfbf4401d', 'fd9f0714-4cc5-16de-882f-438dfbb90a2d', '2005-11-30 19:19:58', 0);
INSERT INTO accounts_contacts VALUES ('773068d1-bfc6-7af4-6001-438dfbdd2457', '75865b5d-a4d8-c1de-ce05-438dfbfde078', '58469e50-1f41-538f-1887-438dfbf47114', '2005-11-30 19:19:58', 0);
INSERT INTO accounts_contacts VALUES ('bbf4fc0a-344d-2bcf-692a-438dfbb1c092', 'ba5c80d3-2ab7-ec3d-df9c-438dfbab724b', '88a915af-39ff-75b6-8493-438dfb8c230c', '2005-11-30 19:19:58', 0);
INSERT INTO accounts_contacts VALUES ('cb4a0a79-ecc8-27bd-e79f-438dfbb6bf65', 'b1ab0db0-fa91-ceb2-a612-438dfb77794d', 'cd6049bd-74fc-b5d1-5eb3-438dfbd81e96', '2005-11-30 19:19:59', 0);
INSERT INTO accounts_contacts VALUES ('3d1ee05c-6eb9-10d5-a7f6-438dfbfebc2c', '3b80ec5d-e897-aee2-2aba-438dfb2a858f', '1e347806-aeec-67b7-cab2-438dfb351dff', '2005-11-30 19:19:59', 0);
INSERT INTO accounts_contacts VALUES ('84d1d719-46ed-9837-33c7-438dfbbd616a', '8337e6dd-eeae-9082-11f2-438dfb18cf6b', '4e66e474-6dde-7f87-b0d7-438dfb216074', '2005-11-30 19:19:59', 0);
INSERT INTO accounts_contacts VALUES ('b4fc8fe8-9a5d-b0de-7046-438dfb98d71e', 'b368d370-262d-34c8-14a8-438dfba8fd53', '9626413b-867f-30ae-432f-438dfbf756c4', '2005-11-30 19:19:59', 0);
INSERT INTO accounts_contacts VALUES ('e5141f1f-de34-f27b-1ea7-438dfbc8bd8c', 'e3724c59-f713-cbd5-d2b6-438dfb312320', 'c64c35eb-a23d-9f87-b108-438dfb9c6d90', '2005-11-30 19:19:59', 0);
INSERT INTO accounts_contacts VALUES ('4ca29da8-9840-b15e-54e6-438dfb5bb1ff', '4afff9a4-0a4b-1890-dc76-438dfb7afaa9', '246c06f3-95cd-ae33-9d0c-438dfb0edc32', '2005-11-30 19:20:00', 0);
INSERT INTO accounts_contacts VALUES ('9537942c-9a57-397e-e0e8-438dfbbf8b90', '939c9d04-7e64-7856-b1e6-438dfb21738e', '60a548ab-9be6-abaf-60b7-438dfb019948', '2005-11-30 19:20:00', 0);
INSERT INTO accounts_contacts VALUES ('d03ca716-6db9-f2d9-372d-438dfb5fed06', 'ce98183b-4f45-b592-c216-438dfb7baa3f', 'a68c98c0-4ad9-f9d5-763e-438dfb7b0059', '2005-11-30 19:20:00', 0);
INSERT INTO accounts_contacts VALUES ('c38e0822-2807-5fa7-65d2-438dfb62fe11', 'a93508bb-da69-7a17-66bc-438dfb1f8505', 'e1980070-bbae-c220-1f68-438dfb8a1752', '2005-11-30 19:20:01', 0);
INSERT INTO accounts_contacts VALUES ('5587f7b4-abfb-cd05-4705-438dfbf4b5ce', '53e08fdb-89ad-e6b2-e5ca-438dfb06a7a1', '2895b03d-cb51-0cd3-9430-438dfb1b06da', '2005-11-30 19:20:01', 0);
INSERT INTO accounts_contacts VALUES ('9125872b-e592-5cdc-5606-438dfb33176c', '8f907340-20ea-f6c0-d04c-438dfbd68e25', '66d00a03-e597-5517-a003-438dfb44736f', '2005-11-30 19:20:01', 0);
INSERT INTO accounts_contacts VALUES ('d7f88f0f-a705-5131-633d-438dfb747243', 'd665938e-c65f-9ca0-3dbf-438dfbf1e230', 'a2776c86-3e80-10f5-2de4-438dfb23244f', '2005-11-30 19:20:01', 0);
INSERT INTO accounts_contacts VALUES ('2a712e5d-f831-636b-484e-438dfb8857f0', '28d21bb4-8c9a-7edb-c7f2-438dfba04523', 'e9530c09-f5de-20b4-af8d-438dfb19709c', '2005-11-30 19:20:02', 0);
INSERT INTO accounts_contacts VALUES ('68b54b0b-6d5b-f53c-c375-438dfb5080fc', '671e3659-a85f-0f9c-2f3a-438dfb202486', '3be5af30-4e43-3bb3-ea0e-438dfb1db842', '2005-11-30 19:20:02', 0);
INSERT INTO accounts_contacts VALUES ('b095f0f2-48a2-679f-8f8a-438dfb191cb7', 'aee92370-a454-ba50-ccf3-438dfba82658', '7a40535d-16bc-7148-7e8e-438dfbd13045', '2005-11-30 19:20:02', 0);
INSERT INTO accounts_contacts VALUES ('e09670ab-46a8-3a90-dba5-438dfb399251', 'deff0d40-c4bb-997b-32c0-438dfb09e02c', 'c1dfef1c-954e-f743-4420-438dfbf77140', '2005-11-30 19:20:02', 0);
INSERT INTO accounts_contacts VALUES ('2857d06e-5783-9f59-213c-438dfb50740c', '26c53482-e36f-662c-78bf-438dfb44428d', 'f204b148-7344-8404-effe-438dfbd36480', '2005-11-30 19:20:03', 0);
INSERT INTO accounts_contacts VALUES ('72c0b275-b04a-ce81-924e-438dfbd8d636', '71243b84-8117-d614-fa8c-438dfb6292a6', '39b65b2c-1c46-a998-60d5-438dfbbf9075', '2005-11-30 19:20:03', 0);
INSERT INTO accounts_contacts VALUES ('af584ee8-b8c0-cbeb-5a0d-438dfb6e7d1d', 'adbc8e2c-812d-4ce6-495d-438dfb20c6b1', '8464a7b2-7bd4-225d-f11c-438dfb5e239a', '2005-11-30 19:20:03', 0);
INSERT INTO accounts_contacts VALUES ('dfa4fe5c-3036-3586-4130-438dfba5e213', 'de0c469c-7a57-b426-8661-438dfba7d9b4', 'c0c97998-e5de-2fc8-e002-438dfb6708a1', '2005-11-30 19:20:03', 0);
INSERT INTO accounts_contacts VALUES ('279fcaeb-a2c2-ea9d-2321-438dfb134eac', '260790b5-55e5-5e5b-c897-438dfbca4cfb', 'f0d414d6-6382-fbfc-3b0b-438dfbb822cd', '2005-11-30 19:20:04', 0);
INSERT INTO accounts_contacts VALUES ('7f47e2bf-59a6-deb4-e295-438dfb2be705', '7da4ae64-e32c-51d9-848b-438dfbf9c1dd', '391d6e11-d566-07fe-aeda-438dfb5a9a5a', '2005-11-30 19:20:04', 0);
INSERT INTO accounts_contacts VALUES ('cbd5a2c6-6f30-e10a-4718-438dfb41ac23', 'ca3cccb0-8974-61ce-57fa-438dfb118d0b', '912be22c-c54f-1a32-4057-438dfb5574c0', '2005-11-30 19:20:04', 0);
INSERT INTO accounts_contacts VALUES ('7afa062a-e342-7235-08b0-438dfb0af2eb', '614200dd-5958-f1d5-a712-438dfb9c10c2', 'dd28e11e-db7f-ffe0-d6e7-438dfb1adce2', '2005-11-30 19:20:05', 0);
INSERT INTO accounts_contacts VALUES ('441ae2de-7ddd-68bf-9fdf-438dfb86caca', '4288be16-71d1-7371-5b29-438dfbfb44cb', '191db721-4fb7-9a81-3a97-438dfbabdcca', '2005-11-30 19:20:05', 0);
INSERT INTO accounts_contacts VALUES ('779f7b18-e8fa-d221-eb1f-438dfb7ae4fd', '760baad9-7d02-8cd3-db61-438dfbb47ee9', '58a9b8fd-972b-dd40-72fe-438dfbdd00cf', '2005-11-30 19:20:05', 0);
INSERT INTO accounts_contacts VALUES ('c066d601-3b3f-f28d-e6a0-438dfb1a0a0f', 'becf2b1a-c927-df73-a590-438dfb1ab186', '88e66abc-394e-4d0d-77c4-438dfb3b182d', '2005-11-30 19:20:05', 0);
INSERT INTO accounts_contacts VALUES ('2e7087d2-be8f-da0a-1111-438dfb135629', '2cc41cb9-f0ab-9372-396c-438dfb9b605f', 'd1bbf5c1-4c4e-b625-4cfc-438dfb623284', '2005-11-30 19:20:06', 0);
INSERT INTO accounts_contacts VALUES ('7bd3157b-b05f-5eae-e3df-438dfb469d5c', '7a322225-08f8-9553-2a50-438dfb657ed3', '412850a2-6620-056b-3a1c-438dfbaddca9', '2005-11-30 19:20:06', 0);
INSERT INTO accounts_contacts VALUES ('b8d7fcaa-3c64-903b-c63f-438dfb725911', 'b73ca237-46ae-0302-8c7e-438dfbbda9d5', '8d39787d-9fe3-5566-b19b-438dfb80bd18', '2005-11-30 19:20:06', 0);
INSERT INTO accounts_contacts VALUES ('e8ec27ae-fd73-b1ec-68ea-438dfb3bfe71', 'e7566913-22ea-dc41-b63a-438dfb2927da', 'ca3c55ee-b53c-f2b2-84e7-438dfb0c8d0c', '2005-11-30 19:20:06', 0);
INSERT INTO accounts_contacts VALUES ('31de5d00-5f78-d58b-b456-438dfb314f58', '3048de49-5d87-88d6-3e5a-438dfbee0aad', '62a10f63-f686-2144-15ac-438dfbead4e8', '2005-11-30 19:20:07', 0);
INSERT INTO accounts_contacts VALUES ('71b6d5a9-3635-f29c-f9b2-438dfb0660a2', '7020fe26-b1c3-1485-ecbe-438dfb71f32c', '43859232-da58-37c0-179b-438dfbdfa7d4', '2005-11-30 19:20:07', 0);
INSERT INTO accounts_contacts VALUES ('be22d84a-8fe4-04e2-a18d-438dfbe03be6', 'bc861a7d-e5ba-5981-32b5-438dfba17da8', '90c164b4-f97d-611f-6846-438dfbe89579', '2005-11-30 19:20:07', 0);
INSERT INTO accounts_contacts VALUES ('84260a2a-df68-d174-adbf-438dfbe23a19', '6a550819-42c2-c877-fa21-438dfb11c7fb', 'cfdf028a-db96-990d-3366-438dfb009b2b', '2005-11-30 19:20:08', 0);
INSERT INTO accounts_contacts VALUES ('47346236-f543-6def-b485-438dfbd36e93', '459644ac-311f-bae5-108e-438dfb58c3df', '1a26322a-9d2e-13b9-edbd-438dfbdfd6c3', '2005-11-30 19:20:08', 0);
INSERT INTO accounts_contacts VALUES ('961d68aa-97ae-e7fd-97fd-438dfb65f7b2', '948029e3-d23e-7fcf-1bd7-438dfb6583d7', '5b9936b0-c7c4-0429-bab3-438dfbf4127a', '2005-11-30 19:20:08', 0);
INSERT INTO accounts_contacts VALUES ('d4f1d7f5-6d31-a093-eb26-438dfbe6cbae', 'd356a82e-b005-3a82-a90b-438dfb6e92ff', 'a7df6541-fb86-851e-c556-438dfbffa507', '2005-11-30 19:20:08', 0);
INSERT INTO accounts_contacts VALUES ('2c124385-0f62-70fa-6ee3-438dfb8f12ba', '2a6bd51e-b835-7278-7eb1-438dfb1d7e1b', 'e65b04ee-2054-ba82-f056-438dfb5fe583', '2005-11-30 19:20:09', 0);
INSERT INTO accounts_contacts VALUES ('5eecb511-532d-5b8b-0978-438dfbfcc863', '5d57fece-f829-2c36-0709-438dfbe43dc3', '3d82526a-12c1-e7eb-ff5a-438dfb9a0629', '2005-11-30 19:20:09', 0);
INSERT INTO accounts_contacts VALUES ('9e541802-88a0-1981-5954-438dfb4ee9e0', '9cade42d-b856-7b89-9439-438dfbeb4b5a', '705a8f06-80bf-e78d-8582-438dfb58ec6a', '2005-11-30 19:20:09', 0);
INSERT INTO accounts_contacts VALUES ('ce33fdc2-63c6-2cfb-a9d6-438dfb79dc56', 'cc995d70-82ab-819a-536e-438dfb683aca', 'af9c9eae-cfca-0408-c4f2-438dfb55cd6b', '2005-11-30 19:20:09', 0);
INSERT INTO accounts_contacts VALUES ('25c74649-b5e5-a1e8-de36-438dfb9e254c', '2420f325-17aa-c257-30f7-438dfb7766a6', 'df919b50-360a-55f5-6f51-438dfb61a3ac', '2005-11-30 19:20:10', 0);
INSERT INTO accounts_contacts VALUES ('587133a5-8154-007e-e179-438dfb68645c', '565c8f77-d0b2-4238-993e-438dfbef8656', '37091701-70fe-f2c1-dc2c-438dfb343ec7', '2005-11-30 19:20:10', 0);
INSERT INTO accounts_contacts VALUES ('a4d4d87e-64f4-b4e6-e87d-438dfbbb9473', 'a33528f2-51ce-e82e-50d6-438dfbe4f03c', '69aeff99-9dc1-cf5e-5779-438dfb158510', '2005-11-30 19:20:10', 0);
INSERT INTO accounts_contacts VALUES ('e3564588-d3d3-a10d-9dfb-438dfbf72094', 'e1c40347-5ed4-5945-ea2d-438dfbaee8b0', 'b6263370-2b26-8342-4c87-438dfbf377b4', '2005-11-30 19:20:10', 0);
INSERT INTO accounts_contacts VALUES ('1f4ea1db-b80e-3a85-4744-438dfb920c4d', '1dbd5cc0-7e34-5fab-185a-438dfb77b676', '8740019a-9ecc-2677-dbde-438dfb926b5d', '2005-11-30 19:20:11', 0);
INSERT INTO accounts_contacts VALUES ('4f85e2b2-f473-cd72-946a-438dfb656d26', '4df7a86e-0efb-4364-0f47-438dfbdbf6fa', '307f2672-8234-c472-39de-438dfb0be0c0', '2005-11-30 19:20:11', 0);
INSERT INTO accounts_contacts VALUES ('8241cda1-8b6e-2504-c4ed-438dfb5cde89', '80948b17-513f-63c9-367e-438dfb2d41c2', '636d2d7c-fcec-c46a-5aaa-438dfb56c263', '2005-11-30 19:20:11', 0);
INSERT INTO accounts_contacts VALUES ('c110af8d-6736-5916-98eb-438dfbff54b8', 'bf809697-6fe6-f175-c00e-438dfb7f52f3', '939e5fc5-2c88-2dc4-65fa-438dfbaaebd7', '2005-11-30 19:20:11', 0);
INSERT INTO accounts_contacts VALUES ('b98609b9-1617-73ba-2912-438dfb98e009', 'a09e05bf-5a2f-6605-43fe-438dfb574b5a', 'd2700f13-40f4-fa17-c102-438dfb8eb5fb', '2005-11-30 19:20:12', 0);
INSERT INTO accounts_contacts VALUES ('3bc1957b-ef00-6fae-1821-438dfb3e5f34', '3a2bbafb-ab0b-fa02-0dbc-438dfba8b445', '1d176643-bb13-0844-e661-438dfbdeeee9', '2005-11-30 19:20:12', 0);
INSERT INTO accounts_contacts VALUES ('a9fb2501-2050-cbe1-ff9c-438dfbc94057', 'a866029d-5a45-e7f4-c14b-438dfb74e906', '4d4c92dd-bc58-f5c2-c506-438dfb7d4aa7', '2005-11-30 19:20:12', 0);
INSERT INTO accounts_contacts VALUES ('e068085a-5b0c-5283-00d9-438dfb36652d', 'deda9afb-2e60-ada8-747d-438dfb20bd11', 'c157e248-0269-e45d-ce5a-438dfbb14bbf', '2005-11-30 19:20:12', 0);
INSERT INTO accounts_contacts VALUES ('3b0c690d-1633-504a-b50a-438dfb6a144f', '397f47b3-9646-47f1-ecab-438dfb07a116', 'f19298b8-0362-dd24-7cd1-438dfb8403b7', '2005-11-30 19:20:13', 0);
INSERT INTO accounts_contacts VALUES ('8c1d3e37-ac5d-02f8-bc13-438dfb04b95f', '8a8beace-8d03-64c8-747e-438dfb9c4766', '4c92556d-a6b7-3fc2-8318-438dfbed4088', '2005-11-30 19:20:13', 0);
INSERT INTO accounts_contacts VALUES ('cb520622-b469-8424-7fe7-438dfbc73f54', 'c9c496fe-ce41-bb3b-abcc-438dfbed9d62', '9d8a587a-f26d-a658-2757-438dfb8d237a', '2005-11-30 19:20:13', 0);
INSERT INTO accounts_contacts VALUES ('16b11be2-6d3f-547d-e3ef-438dfb880533', '1526dbe7-a76a-8245-ac30-438dfb974ac1', 'dced35ed-f75f-5e3e-dedb-438dfbe4f662', '2005-11-30 19:20:14', 0);
INSERT INTO accounts_contacts VALUES ('591132e7-2364-ef5f-a82a-438dfb6429b8', '572e7abc-3990-1e1c-aae9-438dfbdec9c1', '280cf96b-2ef7-a0e2-9ab9-438dfb06bd21', '2005-11-30 19:20:14', 0);
INSERT INTO accounts_contacts VALUES ('98f426f5-6a8f-070d-bcf8-438dfb960da7', '975f39f1-a529-4129-9da4-438dfb38c6f7', '6aa8e39e-3814-a431-1d7a-438dfb051697', '2005-11-30 19:20:14', 0);
INSERT INTO accounts_contacts VALUES ('ddfeb8c8-a2ff-fcb5-dc66-438dfb2bb51e', 'dc623760-e1b8-5046-e1b7-438dfbd0ee3f', 'aa65a929-1b0f-5205-f01d-438dfbabde1f', '2005-11-30 19:20:14', 0);
INSERT INTO accounts_contacts VALUES ('392aaa32-8fad-cd35-1d1a-438dfb5c9f98', '37927bd3-2cc3-3329-45ed-438dfb6494eb', 'ef3e5cbd-082e-12a9-b6b3-438dfb549e04', '2005-11-30 19:20:15', 0);
INSERT INTO accounts_contacts VALUES ('6c02325d-e0d0-fa9c-6e64-438dfb147f97', '6a6f5623-5821-5d7b-b1fd-438dfb26aefd', '4aa6de52-213e-66a8-a9ef-438dfbe96c48', '2005-11-30 19:20:15', 0);
INSERT INTO accounts_contacts VALUES ('abff928f-3178-9351-29b2-438dfb58df56', 'aa767ccf-5545-e919-f864-438dfb0ebc90', '7d4ff985-e769-bde9-54a0-438dfbe394fc', '2005-11-30 19:20:15', 0);
INSERT INTO accounts_contacts VALUES ('ec33ad05-2980-dba1-8ed3-438dfb208e90', 'eaa68d29-9e2c-e39e-86e2-438dfb90ac8c', 'bdb03d9e-227d-740c-2453-438dfb39ede5', '2005-11-30 19:20:15', 0);
INSERT INTO accounts_contacts VALUES ('3823be6e-ec94-9d93-f799-438dfb0a383f', '36967a63-76f9-82a1-e11b-438dfb229078', '95da0641-a17b-2468-6737-438dfb77838f', '2005-11-30 19:20:16', 0);
INSERT INTO accounts_contacts VALUES ('7b1129d7-a9d1-29c0-f8ec-438dfbb33ce6', '7970ac63-a4f4-4541-0a19-438dfb36467d', '49cd8ee8-2e63-ccc6-dd57-438dfb23cf46', '2005-11-30 19:20:16', 0);
INSERT INTO accounts_contacts VALUES ('cc01930b-90d5-0fee-41e0-438dfbed4c85', 'ca16cf13-47ce-4ac7-4127-438dfbef5b58', '8c800256-b9ab-a248-e02d-438dfbd84b4d', '2005-11-30 19:20:16', 0);
INSERT INTO accounts_contacts VALUES ('1f045554-c301-f63c-da5f-438dfb6c23c2', '1d6eaba2-2ed7-9621-6b1b-438dfb96e4cb', 'e4282cb7-d56c-84e1-9a0a-438dfb324698', '2005-11-30 19:20:17', 0);
INSERT INTO accounts_contacts VALUES ('4f3c89b0-0b91-bb67-af99-438dfb683d88', '4d965dd9-1f52-72b0-2fbf-438dfbd7b74a', '30530ae1-f3c5-51c9-6bb5-438dfbf62530', '2005-11-30 19:20:17', 0);
INSERT INTO accounts_contacts VALUES ('9216d639-8a56-c322-2272-438dfb6488cc', '908a7db2-f29b-e56c-b454-438dfb130e01', '630977b0-f0a1-66db-a51c-438dfb6d313e', '2005-11-30 19:20:17', 0);
INSERT INTO accounts_contacts VALUES ('d3192a37-c802-cdab-cc22-438dfb863a1b', 'd1454d38-771d-4d2d-89a5-438dfbb5014c', 'a39a808f-5cb3-4fa1-2d14-438dfb97989f', '2005-11-30 19:20:17', 0);
INSERT INTO accounts_contacts VALUES ('f445053a-9418-870f-59c0-438dfb6c5cb2', 'da8e025c-4606-fcb3-2b66-438dfb0261d3', 'e4bb31e7-68c8-772c-5580-438dfbf622ca', '2005-11-30 19:20:18', 0);
INSERT INTO accounts_contacts VALUES ('5053087b-a0de-5803-5696-438dfb38d69d', '4ec683a4-ee2b-bd36-b5d2-438dfb625176', '20ad4cbc-4aac-69b7-27ae-438dfbaeadaa', '2005-11-30 19:20:18', 0);
INSERT INTO accounts_contacts VALUES ('82daa47b-8a15-16c0-cb00-438dfbc75684', '81477909-77a3-63e5-0e6c-438dfbb3edcc', '64502d84-68d6-ce4d-623a-438dfbb101e9', '2005-11-30 19:20:18', 0);
INSERT INTO accounts_contacts VALUES ('b336fcbe-4fb1-46d3-3948-438dfb6b95a8', 'b1a3352a-4387-fe56-a158-438dfb1fc25f', '94506f88-0bce-f500-e91b-438dfbe09d5f', '2005-11-30 19:20:18', 0);
INSERT INTO accounts_contacts VALUES ('21ccc987-472e-a79b-154d-438dfb58fd13', '2041af55-32c6-7607-0288-438dfbd1cfd7', 'c475e259-7fe9-ced2-f61e-438dfbd84283', '2005-11-30 19:20:19', 0);
INSERT INTO accounts_contacts VALUES ('51f5a060-3571-0567-b5f1-438dfbddca22', '50623487-d047-394f-60df-438dfb62ebca', '3315c5b9-9f44-b13d-4d3b-438dfbe40400', '2005-11-30 19:20:19', 0);
INSERT INTO accounts_contacts VALUES ('95aea336-a232-7f5a-118e-438dfb697179', '94109170-76c4-55f4-7a80-438dfba4c953', '65d977a9-17fe-c0fa-cc57-438dfb92ee04', '2005-11-30 19:20:19', 0);
INSERT INTO accounts_contacts VALUES ('70c500f8-bd01-7d1a-6da1-438dfbbf2d77', '56bc04f1-6bd3-b945-6ff5-438dfb351406', 'c9c19848-f085-7289-cff0-438dfb5659f1', '2005-11-30 19:20:20', 0);
INSERT INTO accounts_contacts VALUES ('49d33d8c-75b3-a022-2f54-438dfb458788', '483b75d8-1d9b-d755-47ea-438dfb120b43', '18de4a65-6937-d606-bf3e-438dfbdc97bf', '2005-11-30 19:20:20', 0);
INSERT INTO accounts_contacts VALUES ('8f085000-d277-7984-9705-438dfb88c3be', '8d5986fa-1bde-fb66-8bcd-438dfb0f5dd6', '5e1adbb5-73de-84e8-26d6-438dfbbe13ac', '2005-11-30 19:20:20', 0);
INSERT INTO accounts_contacts VALUES ('c01328a7-b1ec-874b-eee2-438dfb43acbe', 'be76b64b-2fc9-770b-1bea-438dfbeb4ecf', 'a0b1e6ca-bb6b-5303-162b-438dfb6373d7', '2005-11-30 19:20:20', 0);
INSERT INTO accounts_contacts VALUES ('203192df-39d1-e300-00bb-438dfba1dbd7', '1e9d5c97-5d8b-fe70-91d6-438dfb171e53', 'd1c8692a-5f60-1701-28b1-438dfb4a89c1', '2005-11-30 19:20:21', 0);
INSERT INTO accounts_contacts VALUES ('5112cfae-76e9-76e9-f1f0-438dfb64f282', '4f8453c0-048f-c5e5-0a78-438dfb077837', '31d5cda5-dbe3-02ac-0040-438dfb087ca2', '2005-11-30 19:20:21', 0);
INSERT INTO accounts_contacts VALUES ('83b08f94-d381-8666-a67f-438dfb0d07d5', '821cabbf-bc81-6133-e0e2-438dfb70ca83', '64f5db21-f2f2-bf69-83b7-438dfb107f3a', '2005-11-30 19:20:21', 0);
INSERT INTO accounts_contacts VALUES ('199d6a15-93a9-d1fa-15e7-438dfbeadcd9', '17f335dd-51ce-aec7-b518-438dfb5b5179', '9536b4e9-efc3-f6dc-4b08-438dfb49736d', '2005-11-30 19:20:22', 0);
INSERT INTO accounts_contacts VALUES ('703f4a98-f9b4-2f2c-b61a-438dfbfc49cc', '6e9f157c-0903-fb93-faa6-438dfbe6fde4', '2ae53d7c-3815-fef1-3da2-438dfbbcfc11', '2005-11-30 19:20:22', 0);
INSERT INTO accounts_contacts VALUES ('b38b672f-fdd2-a347-c971-438dfb60b561', 'b1fca540-b603-3c39-e78a-438dfbd14c89', '82b6361d-819d-b3df-d2f3-438dfb0fa311', '2005-11-30 19:20:22', 0);
INSERT INTO accounts_contacts VALUES ('e3ae03b0-9097-fcf1-fe53-438dfbe813bf', 'e2160452-3f5e-5abc-cfe6-438dfbfe798c', 'c4d987ed-850f-a5ef-ee3a-438dfb9f0548', '2005-11-30 19:20:22', 0);
INSERT INTO accounts_contacts VALUES ('20993e96-14fb-507f-ef43-438dfb454a01', '1eff55b0-e70f-02bc-26b5-438dfbf0eb6e', '1aae0f4c-9c38-0feb-9cb6-438dfb5fcc71', '2005-11-30 19:20:23', 0);
INSERT INTO accounts_contacts VALUES ('9c9c12ed-6e78-8a4d-1834-438dfb2e1cc2', '9afb662f-311a-24ef-7c04-438dfb006059', '31d3ed19-3822-88c6-3ac7-438dfbffa1a3', '2005-11-30 19:20:23', 0);
INSERT INTO accounts_contacts VALUES ('ccd29347-3e22-7261-d380-438dfba8812a', 'cb44a124-0e97-7083-409e-438dfb4a628f', 'ae14f6ad-94c0-eab8-56ce-438dfb978df8', '2005-11-30 19:20:23', 0);
INSERT INTO accounts_contacts VALUES ('1b1270d8-5b9b-a77d-3430-438dfb8af7bb', '1985d404-8d75-894f-8f86-438dfbe8f312', 'de18c543-c83a-7128-8ede-438dfb90ca7d', '2005-11-30 19:20:24', 0);
INSERT INTO accounts_contacts VALUES ('72ac03a1-3606-0bf5-0b57-438dfbc0b530', '7110808f-d0f9-2f6d-1e31-438dfb64e8f3', '2c6dc705-ce38-9d87-f23e-438dfbcebbbd', '2005-11-30 19:20:24', 0);
INSERT INTO accounts_contacts VALUES ('b61d7e5b-0ce0-75df-6792-438dfb442cd0', 'b4627136-7509-0d4b-e540-438dfb634ad1', '848b2f3c-fbf2-8431-09c3-438dfb544d45', '2005-11-30 19:20:24', 0);
INSERT INTO accounts_contacts VALUES ('3cc05da6-c2f5-14a4-a1c1-438dfb1ac65f', '3b234eb7-cbff-9d13-38a1-438dfbee4d99', 'c760e512-ab2c-a35d-da62-438dfbac82ea', '2005-11-30 19:20:25', 0);
INSERT INTO accounts_contacts VALUES ('9534b939-adbc-91bd-0ea2-438dfbe92a53', '939dd6d8-b462-50b6-28c7-438dfb802d2b', '4e4bde3d-2e6a-1c54-2813-438dfb4f48f4', '2005-11-30 19:20:25', 0);
INSERT INTO accounts_contacts VALUES ('d8581409-571b-c24b-50d1-438dfbb97ec3', 'd6bf0e8a-3dd4-32ed-f6be-438dfba0e76a', 'a6a62cfb-3bac-4a41-fae6-438dfb577838', '2005-11-30 19:20:25', 0);
INSERT INTO accounts_contacts VALUES ('3b05d442-3c46-7e77-def2-438dfb1c3d57', '395dd435-6781-494d-abb9-438dfb81034a', 'e9da28ed-3d11-c2aa-fa97-438dfbeea08e', '2005-11-30 19:20:26', 0);
INSERT INTO accounts_contacts VALUES ('814501df-6bad-eec8-3db8-438dfbc21ae1', '7fb7feaf-c00b-cda3-d95d-438dfbe3a9d4', '4cc8b395-11af-cd01-257d-438dfbf89cc3', '2005-11-30 19:20:26', 0);
INSERT INTO accounts_contacts VALUES ('c4a7c837-d33c-56e0-5014-438dfb720c22', 'c318fe56-13d4-7688-b3fe-438dfb495da3', '92a2d19a-54ee-f1fa-987c-438dfb0290ca', '2005-11-30 19:20:26', 0);
INSERT INTO accounts_contacts VALUES ('3a5029f1-973b-e209-3eca-438dfb74a39e', '38a9ffbd-4ce8-1f0d-3edd-438dfbf7cf43', 'd6108839-dd16-d342-237b-438dfbe20b60', '2005-11-30 19:20:27', 0);
INSERT INTO accounts_contacts VALUES ('93b255d4-0c88-4ccf-9cf2-438dfb8635e3', '9212a191-1b14-8925-1a93-438dfb04fd9d', '4bdffe67-f195-8ae3-ec7b-438dfb881f4c', '2005-11-30 19:20:27', 0);
INSERT INTO accounts_contacts VALUES ('d7e3e5df-32d0-a317-796a-438dfbe58595', 'd64c2019-e00e-3f96-fc49-438dfb6fd8c4', 'a54321d1-cbd4-e430-5d40-438dfb8d8fbe', '2005-11-30 19:20:27', 0);
INSERT INTO accounts_contacts VALUES ('143f857c-44a1-4dd3-6d4a-438dfbbb3e84', '12b341c7-6053-9b8c-d4e5-438dfbe40d3d', 'e93ec2cb-fca3-0b23-7ca7-438dfb73696d', '2005-11-30 19:20:28', 0);
INSERT INTO accounts_contacts VALUES ('445d7983-b1ce-f3aa-5755-438dfb3046f4', '42ad814c-90d7-5e97-3926-438dfbb341f2', '2584d7e2-acb7-6248-5eae-438dfb125d89', '2005-11-30 19:20:28', 0);
INSERT INTO accounts_contacts VALUES ('9ece75ff-c379-4755-cf5f-438dfbca0b19', '9d38b81a-0552-d91c-9476-438dfb3bc660', '55d98ba6-62a7-fd7f-d743-438dfb8a5931', '2005-11-30 19:20:28', 0);
INSERT INTO accounts_contacts VALUES ('e2bd5d9f-3ac2-3cd0-3bf3-438dfb0cf3b9', 'e11ffd74-f8c1-3f79-613e-438dfbe85b85', 'b019d8c4-37b1-28cc-e7ab-438dfb2fef9e', '2005-11-30 19:20:28', 0);
INSERT INTO accounts_contacts VALUES ('328068c5-cf23-2130-93ec-438dfbc08d84', '30ed5bb9-636d-3c7e-edd6-438dfb1a73c2', 'ec000cbb-56ab-f5c9-f878-438dfb94f5b0', '2005-11-30 19:20:29', 0);
INSERT INTO accounts_contacts VALUES ('793edb52-7168-4f08-ff68-438dfb3bd5eb', '77b00704-42ac-a6bb-b148-438dfb6553a7', '43f6b34a-7012-acf9-e2e2-438dfb8bbb40', '2005-11-30 19:20:29', 0);
INSERT INTO accounts_contacts VALUES ('e575d3d3-e0ba-ab23-1ae1-438dfb03febf', 'e3de2212-f369-ad79-7a07-438dfbd5aa2c', '8a83320a-d876-f677-8963-438dfb6c10c8', '2005-11-30 19:20:29', 0);
INSERT INTO accounts_contacts VALUES ('35f53e80-91c5-a7eb-e92d-438dfbf626e2', '20496a90-f0fc-6c94-a630-438dfbe002cb', '284809c7-3b5b-e686-f4e7-438dfbfa5eed', '2005-11-30 19:20:30', 0);
INSERT INTO accounts_contacts VALUES ('b9d01ac7-b8fd-5888-7b89-438dfb474755', 'b83ab636-9daf-3906-43de-438dfb3675c8', '5de035e3-561e-2abc-3a8a-438dfb857c6a', '2005-11-30 19:20:30', 0);
INSERT INTO accounts_contacts VALUES ('e9f62ab9-7968-da5f-aad0-438dfbc891bc', 'e85a617f-38a8-8410-3818-438dfbb46d3d', 'cb2da29e-414f-84e2-3742-438dfb1177a4', '2005-11-30 19:20:30', 0);
INSERT INTO accounts_contacts VALUES ('666d16be-d3a3-ab24-b19e-438dfb401a39', '4da423f5-ebd0-542c-d3b1-438dfb9fc8f0', '73890092-16e9-601a-454c-438dfbd6bb8d', '2005-11-30 19:20:31', 0);
INSERT INTO accounts_contacts VALUES ('969c4c42-30c7-963c-bc76-438dfb6c9fff', '94e3683c-caa7-d336-dd28-438dfba468ff', '77c31c1a-fc84-7181-bb1a-438dfb1947e8', '2005-11-30 19:20:31', 0);
INSERT INTO accounts_contacts VALUES ('efeab79b-a4fe-ed66-8e81-438dfb3463de', 'ee53b4c2-faef-df6e-daa6-438dfbaf601a', 'a8030d8c-eb1a-0cd0-6a78-438dfb9da2b9', '2005-11-30 19:20:31', 0);
INSERT INTO accounts_contacts VALUES ('2c2ddc3b-b071-2238-ab31-438dfb50000f', '2a9f204a-2d5a-564e-1b60-438dfb772635', 'd5990adb-7e13-c998-591a-438dfb469076', '2005-11-30 19:20:32', 0);
INSERT INTO accounts_contacts VALUES ('5ec70891-3082-e664-6461-438dfb590cad', '5d326262-133b-400a-b5e1-438dfb0d5ea9', '3d8a4e68-3a64-5257-f4e8-438dfb6e96f3', '2005-11-30 19:20:32', 0);
INSERT INTO accounts_contacts VALUES ('a52b8872-bd0c-afdc-ea74-438dfb62e3e3', 'a393cf1d-c9b5-1f70-248d-438dfbf384db', '7020cebe-a450-fe7d-c86f-438dfb1e6ee0', '2005-11-30 19:20:32', 0);
INSERT INTO accounts_contacts VALUES ('36687ae8-3372-8963-e094-438dfbd3da62', '34a0a599-9046-3a16-6cbf-438dfbde162d', 'b6e5a19f-c8e7-6e3b-ae0e-438dfb226928', '2005-11-30 19:20:33', 0);
INSERT INTO accounts_contacts VALUES ('c53260da-6ba1-49cc-beac-438dfbb73888', 'add2aa3f-b534-326b-f490-438dfb40f079', '6278c3f9-a220-9270-5af6-438dfb72491b', '2005-11-30 19:20:33', 0);
INSERT INTO accounts_contacts VALUES ('46490fe6-cde6-11db-0116-438dfbff2f9a', '2f7ddc5c-a1bc-ca85-bf4c-438dfbecdc8b', 'd9482781-428b-2a2d-fcf8-438dfb95822e', '2005-11-30 19:20:34', 0);
INSERT INTO accounts_contacts VALUES ('7a54bcbb-2043-770c-e531-438dfb5ce5c1', '78bfda9e-03db-9b04-3d3b-438dfbeae7c6', '58317a7d-2ddc-3c98-219b-438dfb5f9207', '2005-11-30 19:20:34', 0);
INSERT INTO accounts_contacts VALUES ('ebfa0d5b-fe17-6007-54bd-438dfb1ef676', 'ea61448c-4e97-e705-fb88-438dfbbf481a', '8c34dea4-f951-5167-dbd9-438dfbe8ee7a', '2005-11-30 19:20:34', 0);
INSERT INTO accounts_contacts VALUES ('6d5af5f4-2417-9280-1b38-438dfb868196', '6bbe3e62-900d-a065-3baf-438dfb896de9', '9a350d13-6edf-b916-ec0b-438dfb2a07af', '2005-11-30 19:20:35', 0);
INSERT INTO accounts_contacts VALUES ('c8db5067-8eef-3253-7644-438dfb6d7a4e', 'c748065a-74e4-249c-d075-438dfbebce00', '86de1521-2c63-1031-db6e-438dfb2ead4e', '2005-11-30 19:20:35', 0);
INSERT INTO accounts_contacts VALUES ('4806cb04-7c32-0f13-4f19-438dfbde2065', '4673b4d3-a4c9-6d04-2cf7-438dfb2d8810', 'dbdbd11a-09c0-9969-15bd-438dfbe7c1c9', '2005-11-30 19:20:36', 0);
INSERT INTO accounts_contacts VALUES ('a6c5e41d-b42c-2228-7026-438dfb784e74', 'a5139910-a624-88f4-0272-438dfb2da0a6', '59934fb2-8e1b-67b2-22ba-438dfb7f0116', '2005-11-30 19:20:36', 0);
INSERT INTO accounts_contacts VALUES ('d6b982b3-7952-483c-bc05-438dfb1751d8', 'd527c052-0074-531b-e06c-438dfb645762', 'b81a5d60-1cc1-f5d2-cc0d-438dfb7e8cf4', '2005-11-30 19:20:36', 0);
INSERT INTO accounts_contacts VALUES ('28918ddb-a294-3bd1-dee0-438dfba5b761', '270160db-2134-bce6-0748-438dfb52accc', 'e8246f0b-bbcf-612a-b608-438dfb437293', '2005-11-30 19:20:37', 0);
INSERT INTO accounts_contacts VALUES ('58efeb97-9654-82aa-4887-438dfb344358', '576379f4-dfe0-6d4c-0bbf-438dfb25f8fd', '39eccd8b-876e-5ed7-ac0e-438dfbc35d74', '2005-11-30 19:20:37', 0);
INSERT INTO accounts_contacts VALUES ('a1d3ea6c-d2e4-f6ca-b701-438dfbe82213', 'a017ef63-c5a5-5c5a-6971-438dfbf07eb7', '6ce495ca-809d-4c8c-9bec-438dfb099655', '2005-11-30 19:20:37', 0);
INSERT INTO accounts_contacts VALUES ('d2052b67-3d7a-13c1-19ae-438dfb3ce1b8', 'd06b2323-a058-7133-d1dd-438dfb312849', 'b329a1fc-7bcf-8d63-4257-438dfbf15f68', '2005-11-30 19:20:37', 0);
INSERT INTO accounts_contacts VALUES ('dce702c7-735f-6d8e-ff54-438dfb347e40', 'c3a502bb-76ac-4efc-5dd9-438dfb211ba9', 'e339f5c5-b133-c664-9d25-438dfb5a24c6', '2005-11-30 19:20:38', 0);
INSERT INTO accounts_contacts VALUES ('6df6f5f3-2712-fddc-4f15-438dfb7f2277', '6c5dae0c-a5ac-53df-aa37-438dfb5abd55', '1fed618e-f94a-e3c4-374d-438dfb59d0df', '2005-11-30 19:20:38', 0);
INSERT INTO accounts_contacts VALUES ('b474f765-4133-bc3e-8796-438dfbb8149f', 'b2de575e-a362-1697-5f49-438dfbc00c41', '7f50d6b5-430d-df28-c8a6-438dfb84bffa', '2005-11-30 19:20:38', 0);
INSERT INTO accounts_contacts VALUES ('e45a939b-a3da-6f3e-ecbb-438dfbd472cf', 'e2c4fb3c-e5b9-b597-c970-438dfb471773', 'c5bdbb77-f107-f5c8-e8b9-438dfb7acc06', '2005-11-30 19:20:38', 0);
INSERT INTO accounts_contacts VALUES ('2071c4de-ee3f-c489-0650-438dfbec7cdf', '1ede6cdb-9d18-5c76-d197-438dfb1ac5d2', '19000da7-6ebc-31b9-14ae-438dfb8689ca', '2005-11-30 19:20:39', 0);
INSERT INTO accounts_contacts VALUES ('510aa81a-8fb2-418d-dcc1-438dfb50ea42', '4f73fb72-24b9-e833-b6af-438dfbfcd574', '31f324b0-84e2-e496-0b6d-438dfb467fdd', '2005-11-30 19:20:39', 0);
INSERT INTO accounts_contacts VALUES ('83b4f8d5-78a6-4adf-8548-438dfb1b416a', '821fd25a-7638-78c2-ef1a-438dfb50efcd', '6509922d-d234-5fb0-6ac8-438dfb659f47', '2005-11-30 19:20:39', 0);
INSERT INTO accounts_contacts VALUES ('caa2748e-3ca1-4a11-e50c-438dfb7e4601', 'c91511d6-1728-fc9f-0f2e-438dfb6e2256', '95054470-16de-54b4-32e6-438dfbac2b9e', '2005-11-30 19:20:39', 0);
INSERT INTO accounts_contacts VALUES ('6a790032-ae97-3874-67c7-438dfb5a8ac4', '50f80516-1e53-5cb6-b13a-438dfbffee25', 'dc18087d-3c5a-3a97-250b-438dfbe74cbd', '2005-11-30 19:20:40', 0);
INSERT INTO accounts_contacts VALUES ('36f75c24-ef4a-6685-3eff-438dfb172a38', '355dea2d-61f9-67d7-a13b-438dfb2bee21', '17f0e87c-b18d-de19-c127-438dfb484b0e', '2005-11-30 19:20:40', 0);
INSERT INTO accounts_contacts VALUES ('69c8831e-aff7-aacf-65cc-438dfb93b259', '68385d77-223d-ac2a-3d3d-438dfb6ffe70', '4866d31a-888a-51cf-a799-438dfb30643e', '2005-11-30 19:20:40', 0);
INSERT INTO accounts_contacts VALUES ('9aa7459d-4fba-4eb2-4692-438dfb678d64', '9913b68c-6e0b-8855-1d14-438dfb81e799', '7b321c4c-7815-b632-cf04-438dfb64fe0b', '2005-11-30 19:20:40', 0);
INSERT INTO accounts_contacts VALUES ('cb758b4b-c7f3-2adf-a78f-438dfb9ec68f', 'c9cb23bc-1622-7417-6300-438dfbe6de33', 'ac3d7e95-9f69-ad88-3bc8-438dfbb70424', '2005-11-30 19:20:40', 0);
INSERT INTO accounts_contacts VALUES ('9241019c-2cfc-b0cb-c6ad-438dfb18d8f1', '794c0411-d414-0a95-1d1d-438dfb9e4887', 'ddf0b38e-97d5-ad1c-f916-438dfbd7d9e8', '2005-11-30 19:20:41', 0);
INSERT INTO accounts_contacts VALUES ('3a2dd6a5-59e8-16cc-f0c9-438dfb92f65d', '389caa67-c163-ed2f-9b7e-438dfb5bd598', '1aab927c-fd16-de4f-4b33-438dfb6f7451', '2005-11-30 19:20:41', 0);
INSERT INTO accounts_contacts VALUES ('6d5fc8e7-7270-1942-879b-438dfb39941d', '6bc20f35-387e-7e8f-2140-438dfba18d55', '4c0b8c40-4533-109f-aeda-438dfb6379ec', '2005-11-30 19:20:41', 0);
INSERT INTO accounts_contacts VALUES ('9e1963b1-c71e-6d74-89e1-438dfb2c9cfe', '9c853ab8-8d39-bfca-ddcc-438dfb40d006', '7e9f6827-6e0c-f188-75c5-438dfb8b79a9', '2005-11-30 19:20:41', 0);
INSERT INTO accounts_contacts VALUES ('d004be24-b37b-01b5-ea6a-438dfbb40b48', 'cc8d7cee-8aba-94ea-1a40-438dfbfd7d63', 'af8dce10-c2b1-ef6e-6bf1-438dfb1fe0ae', '2005-11-30 19:20:41', 0);
INSERT INTO accounts_contacts VALUES ('be6c07a5-dd7b-f509-5940-438dfb57589e', 'a47e0bed-cc14-35f3-d74c-438dfb07ee52', 'e1416852-2539-0461-eb2f-438dfb5f540b', '2005-11-30 19:20:42', 0);
INSERT INTO accounts_contacts VALUES ('3d27c002-c279-0aae-ce78-438dfb9f6e67', '3b8a32ac-9bb3-c00b-b18c-438dfbb7f47e', '1d41932b-182f-9f4d-af30-438dfb9faa94', '2005-11-30 19:20:42', 0);
INSERT INTO accounts_contacts VALUES ('7111facb-4482-b1d0-9895-438dfb632311', '6f84da37-d0ea-5e35-506f-438dfb60d95a', '4e9f154d-16b4-238c-5348-438dfb689c29', '2005-11-30 19:20:42', 0);
INSERT INTO accounts_contacts VALUES ('a4ffb12d-0809-3403-4c61-438dfb023f86', 'a21f903d-dea7-7a97-9ac2-438dfb3c908a', '8266a8e4-ad91-3ae3-cbae-438dfbb6b5c1', '2005-11-30 19:20:42', 0);
INSERT INTO accounts_contacts VALUES ('d65c5745-224d-791b-8009-438dfbbd4998', 'd4cc0a8d-2397-07d7-8e72-438dfb4d940f', 'b65cd00d-729a-34b7-35ed-438dfb9a9bc9', '2005-11-30 19:20:42', 0);
INSERT INTO accounts_contacts VALUES ('13d1e963-3e67-9c82-3d02-438dfb740830', '123444ca-ec1a-b6eb-9589-438dfb08159e', 'e7af64ad-bd00-43de-eae6-438dfba53d59', '2005-11-30 19:20:43', 0);
INSERT INTO accounts_contacts VALUES ('448916a2-6ffc-e60b-d6ed-438dfbc956d3', '42e8ad96-cf83-59a7-12dc-438dfbbf71df', '25741180-9b0a-6d59-d2a5-438dfb18643c', '2005-11-30 19:20:43', 0);
INSERT INTO accounts_contacts VALUES ('79169e37-21e9-aeb2-7d69-438dfbb5fee6', '7786b95e-3dc3-a434-a931-438dfb290713', '56062170-fdae-2ecd-1d09-438dfb6bc554', '2005-11-30 19:20:43', 0);
INSERT INTO accounts_contacts VALUES ('ab142bf8-eb8f-7465-a818-438dfbeaefd5', 'a9810142-3838-028b-6b37-438dfb6a2637', '8a826d91-bce7-285c-8ab8-438dfb3f96e0', '2005-11-30 19:20:43', 0);
INSERT INTO accounts_contacts VALUES ('dd60081a-4e1a-9985-3590-438dfb4b0dbb', 'dbc62b70-4e60-4858-8e1b-438dfbeb025f', 'bc63a675-5703-c072-d39c-438dfb5cbdbb', '2005-11-30 19:20:43', 0);
INSERT INTO accounts_contacts VALUES ('1d259254-a95c-4708-559a-438dfbc01c2f', '1b87fc73-4473-8817-31b6-438dfbde63cd', 'eec2024f-aca5-cc51-a9f0-438dfb18062e', '2005-11-30 19:20:44', 0);
INSERT INTO accounts_contacts VALUES ('4d7ff1f6-aaec-1a06-b631-438dfbd31fee', '4be7d2f3-f7d6-1fc1-146a-438dfb3f270f', '2eba6615-e135-9bb5-71b8-438dfb829629', '2005-11-30 19:20:44', 0);
INSERT INTO accounts_contacts VALUES ('845c473a-462d-ff96-6d95-438dfba2afca', '82bff714-4640-e311-2045-438dfbf4192e', '616b518a-544d-0883-cdd8-438dfbe9c092', '2005-11-30 19:20:44', 0);
INSERT INTO accounts_contacts VALUES ('b693d3a4-f0a2-66b0-0f4b-438dfb1e0432', 'b504f7ec-7ddf-3b38-ddba-438dfbac79eb', '95ab83f6-5009-5c0f-41d7-438dfb8a0468', '2005-11-30 19:20:44', 0);
INSERT INTO accounts_contacts VALUES ('e6906ad1-6b13-f2c9-6fe4-438dfb510642', 'e4fe6e81-751c-099a-d274-438dfbcc70f6', 'c7fcc12b-5997-5960-ccc8-438dfbacf96f', '2005-11-30 19:20:44', 0);
INSERT INTO accounts_contacts VALUES ('29b112d8-a07a-1b7d-c48a-438dfb2e9498', '25b08878-26ce-def8-f21e-438dfbd38c2b', '3c910d7e-5182-9ac0-8ee3-438dfb494aa7', '2005-11-30 19:20:45', 0);
INSERT INTO accounts_contacts VALUES ('59fb8c08-c73c-321d-1969-438dfbf42e42', '586bc143-a510-8350-3e9e-438dfb70c949', '3b0dc215-af7c-b404-0e73-438dfba6265a', '2005-11-30 19:20:45', 0);
INSERT INTO accounts_contacts VALUES ('993cfe82-33d5-3ad6-30b0-438dfb3ac929', '97ac765d-d208-4732-0629-438dfbc9a303', '6dd767e8-13fc-8646-d64e-438dfba52ba4', '2005-11-30 19:20:45', 0);
INSERT INTO accounts_contacts VALUES ('cbe8174e-0489-1063-8509-438dfb391d57', 'ca54dca5-834c-1024-8cc3-438dfbabdd04', 'aaade8ed-539e-25a3-a313-438dfbe29b87', '2005-11-30 19:20:45', 0);
INSERT INTO accounts_contacts VALUES ('ad300608-bf2b-ef79-c6d2-438dfb9fb3dd', '92fb01cd-9334-134b-523c-438dfb6283d5', 'dd4dfabf-5d83-b24d-63ea-438dfb8bcb28', '2005-11-30 19:20:46', 0);
INSERT INTO accounts_contacts VALUES ('3ae1dc65-cc6f-97ec-880f-438dfbff45cd', '3942b6d9-86f2-3a67-2629-438dfb68c648', '1c212a84-fd58-399f-3cbb-438dfb20ae5f', '2005-11-30 19:20:46', 0);
INSERT INTO accounts_contacts VALUES ('792c2a59-1be3-832f-5dcb-438dfbea8bc3', '778ee798-b48f-b6c5-edf7-438dfbf0b4c9', '4c8fc584-f156-c149-1e8e-438dfbbb63e7', '2005-11-30 19:20:46', 0);
INSERT INTO accounts_contacts VALUES ('ac69ab35-085d-dd10-0733-438dfba47447', 'aad2f37d-8ec0-5751-bb28-438dfbf83da1', '8a931919-f2df-13cb-44c5-438dfbd0a58a', '2005-11-30 19:20:46', 0);
INSERT INTO accounts_contacts VALUES ('dc9fe303-f438-6f2f-d89f-438dfb1f7191', 'db06b71a-4012-6b0b-3844-438dfbbc3739', 'bdc79323-8fd7-f491-7b9b-438dfb8c1b5f', '2005-11-30 19:20:46', 0);
INSERT INTO accounts_contacts VALUES ('201650b4-c61c-3683-1478-438dfb442628', '1e7e547a-2cf5-6452-8efa-438dfb50b12c', 'edf9127b-11b7-2911-1c06-438dfb43ff50', '2005-11-30 19:20:47', 0);
INSERT INTO accounts_contacts VALUES ('54fa7b8f-f268-e593-fec1-438dfbf8f07b', '53618e98-fb11-4ed6-52b7-438dfb7b29de', '323ee655-3eae-bfe1-9233-438dfbe035b6', '2005-11-30 19:20:47', 0);
INSERT INTO accounts_contacts VALUES ('8f5eb77e-62fb-1854-97fd-438dfb609706', '8dbc60b1-37db-f109-7368-438dfb18d348', '6932c080-9997-6e24-8e32-438dfbf0bc6c', '2005-11-30 19:20:47', 0);
INSERT INTO accounts_contacts VALUES ('c41014fe-7de0-7ba9-a68b-438dfbe7b5e7', 'c27346e0-8bdb-7fad-e189-438dfb0764f4', 'a11333b2-e34a-7cee-19ff-438dfb1bb3f0', '2005-11-30 19:20:47', 0);
INSERT INTO accounts_contacts VALUES ('80200124-4400-fd9a-1091-438dfbf6f702', '66c000f9-a424-c652-353f-438dfbcc8f04', 'd94554c7-4b9d-50c9-98e2-438dfbe8a5f8', '2005-11-30 19:20:48', 0);
INSERT INTO accounts_contacts VALUES ('3999a7bb-6dfa-60c1-112c-438dfb43aa09', '38032e85-5849-df1c-aaca-438dfb4909f2', '19d5e398-425e-558e-6d74-438dfbf0fe26', '2005-11-30 19:20:48', 0);
INSERT INTO accounts_contacts VALUES ('77685203-1174-90eb-e63f-438dfb9d7aba', '75c2d280-c211-8eeb-8413-438dfb3cff64', '4af89ff2-afdd-3782-61e3-438dfbb82b14', '2005-11-30 19:20:48', 0);
INSERT INTO accounts_contacts VALUES ('af50014d-bd9f-49fc-8ec1-438dfb74da68', 'ada8b73d-cb7f-1a54-2298-438dfb1d4afa', '88ac74b1-6800-3777-713b-438dfbe7d7a8', '2005-11-30 19:20:48', 0);
INSERT INTO accounts_contacts VALUES ('df6a26cc-046e-2d90-38bb-438dfbdc8aab', 'ddcaf480-fc29-dc78-4dee-438dfbceb2a1', 'c09a5ab8-54e1-6916-f816-438dfb8d3205', '2005-11-30 19:20:48', 0);
INSERT INTO accounts_contacts VALUES ('2344f334-c264-fb8a-c885-438dfb855a27', '21a2ee07-c342-f29f-8677-438dfb63eba5', 'f0c43a56-a365-6fd7-e4c6-438dfbc330f8', '2005-11-30 19:20:49', 0);
INSERT INTO accounts_contacts VALUES ('57ae75d8-d7a8-9413-88ff-438dfbdb6281', '561bdaae-1564-248e-2157-438dfb7fc0b5', '34cd4a83-471e-2d8e-17c2-438dfb89a26b', '2005-11-30 19:20:49', 0);
INSERT INTO accounts_contacts VALUES ('8e4c9dcf-39c2-b79f-285f-438dfb4ec3b8', '8cb33f29-1623-d72d-df2a-438dfb4be9fc', '6b96215c-a64e-cccb-ca71-438dfbec8fc2', '2005-11-30 19:20:49', 0);
INSERT INTO accounts_contacts VALUES ('be86a458-a95e-cf98-648d-438dfb3177f5', 'bcf0089f-2544-a601-fdf8-438dfbcf154c', '9fa1f669-d722-eea7-c612-438dfbbc06c9', '2005-11-30 19:20:49', 0);
INSERT INTO accounts_contacts VALUES ('eed2ba07-2fa8-095f-9639-438dfbf4bab0', 'ed372c10-fb20-693e-aac8-438dfbf9bc41', 'd000e617-e866-9135-c35f-438dfbda2b06', '2005-11-30 19:20:49', 0);
INSERT INTO accounts_contacts VALUES ('2aaeb92d-ca15-cb1d-5dfe-438dfb84bed3', '29206d1c-f2fa-416f-77e3-438dfbd82d37', 'bf7005c7-6394-b116-8ea2-438dfb69e18a', '2005-11-30 19:20:50', 0);
INSERT INTO accounts_contacts VALUES ('5f8dae22-60ba-80ba-0cfc-438dfb7e6603', '5df7be86-f390-7bab-dacd-438dfb1da75a', '3c4f1718-d156-88b2-4920-438dfb205760', '2005-11-30 19:20:50', 0);
INSERT INTO accounts_contacts VALUES ('91fd6c61-af24-aa90-869f-438dfbcf13b8', '906f5754-e8a6-346e-0959-438dfb82a625', '73770f6d-157a-09f1-0350-438dfbdb2bd9', '2005-11-30 19:20:50', 0);
INSERT INTO accounts_contacts VALUES ('c6ac9f65-29e4-ccaf-3cb2-438dfb2bd2b1', 'c5133eb4-da2f-21fc-d1f4-438dfb6032e3', 'a34bb829-3373-27a1-0852-438dfb57c8d1', '2005-11-30 19:20:50', 0);
INSERT INTO accounts_contacts VALUES ('1a2fe7ca-4d2f-e293-83e2-438dfb4a14c3', '1899bb4e-c29a-dd76-752b-438dfb015569', 'd7fbdc0c-ec20-226e-1b68-438dfb1700d6', '2005-11-30 19:20:51', 0);
INSERT INTO accounts_contacts VALUES ('4f97bfac-5c7d-fd96-d6af-438dfb51f93d', '4e009722-3ad2-6866-395a-438dfb77a3f3', '2b9482ec-3479-9c0a-6fb0-438dfb0980cf', '2005-11-30 19:20:51', 0);
INSERT INTO accounts_contacts VALUES ('871a6acb-62d9-69ac-198f-438dfbc75dd7', '85804bd2-5f87-30a2-8e57-438dfbcaa0e8', '60f8c2a9-16bb-3bac-e879-438dfbc87f71', '2005-11-30 19:20:51', 0);
INSERT INTO accounts_contacts VALUES ('c16edee6-dde0-aa2a-5273-438dfb9835fb', 'bfd36235-c069-ae14-8f67-438dfb03432a', '98802778-d9c9-d247-7742-438dfb5a8bc0', '2005-11-30 19:20:51', 0);
INSERT INTO accounts_contacts VALUES ('794306f9-4567-83f8-ca65-438dfb673b83', '5f130069-f38d-d378-8305-438dfb6f5dee', 'd2ba75be-3c40-9b5e-ca6b-438dfb2ef23f', '2005-11-30 19:20:52', 0);
INSERT INTO accounts_contacts VALUES ('4cdf0e8c-2a7a-d3af-4aae-438dfb8c2342', '4b0e296c-51d7-49ad-3559-438dfb2943db', '1921d5d5-eb23-46e8-25cc-438dfbe3305f', '2005-11-30 19:20:52', 0);
INSERT INTO accounts_contacts VALUES ('7fa602e0-eab0-ddca-2b51-438dfbc5c7bb', '7e131d0c-fb9b-bb99-9e2c-438dfb601c6d', '5e4affc3-fc43-dcb3-8da1-438dfb03c50e', '2005-11-30 19:20:52', 0);
INSERT INTO accounts_contacts VALUES ('afb39bd7-2f5a-4d60-1c21-438dfb3fe750', 'ae1e2c7b-9aca-778a-02fe-438dfbb40118', '90e70ca7-9327-00ec-c1b3-438dfbfecb31', '2005-11-30 19:20:52', 0);
INSERT INTO accounts_contacts VALUES ('e51a9d4a-a2bf-2885-3bee-438dfb310c0d', 'e384fba2-a16f-f412-dac2-438dfb2392d9', 'c0f2ee49-be18-e1a1-9b12-438dfb9b29aa', '2005-11-30 19:20:52', 0);
INSERT INTO accounts_contacts VALUES ('31cb3cf5-95ea-2003-546d-438dfb84ee3c', '30292165-df86-8ea8-599b-438dfb520d77', '23710ff1-e84e-783e-5daa-438dfbc1324c', '2005-11-30 19:20:53', 0);
INSERT INTO accounts_contacts VALUES ('70797e8a-f251-ea8c-31d3-438dfb18a476', '6eeafbfa-4e14-e6ae-0338-438dfbb3316b', '44024f5a-5c41-6d76-f423-438dfb832b76', '2005-11-30 19:20:53', 0);
INSERT INTO accounts_contacts VALUES ('a646f38d-0275-fa23-6c2e-438dfbb806f1', 'a4b1684a-8a82-3246-450a-438dfbfde926', '81f45e11-9a91-753e-cb49-438dfbfd7fd5', '2005-11-30 19:20:53', 0);
INSERT INTO accounts_contacts VALUES ('dc640b69-8290-cdca-9a4c-438dfbb5972c', 'dace1f4b-8214-1cec-528d-438dfbd42b68', 'b7dec629-ebe9-301f-a9fe-438dfbd70e2a', '2005-11-30 19:20:53', 0);
INSERT INTO accounts_contacts VALUES ('194ef798-f07b-cf65-7fec-438dfbb16f09', '17b0e3fa-56f6-7694-f2b7-438dfbd65ab1', 'eed243f1-48d1-3ecd-3487-438dfbc741f0', '2005-11-30 19:20:54', 0);
INSERT INTO accounts_contacts VALUES ('4f98bdc9-8148-cf4f-cd02-438dfbe39dd8', '4dda1f46-88cc-386e-63bd-438dfbb7653b', '2a91d192-9acb-1d12-fd0a-438dfb1cb462', '2005-11-30 19:20:54', 0);
INSERT INTO accounts_contacts VALUES ('88414ca6-88f1-227d-732c-438dfb11a133', '86aaf0a2-f7e4-08ca-d1f5-438dfb70585c', '60e4ebb5-c76b-436e-9306-438dfbbc3373', '2005-11-30 19:20:54', 0);
INSERT INTO accounts_contacts VALUES ('be8cda8a-df76-2549-d461-438dfbe0b267', 'bcf048c4-8d5b-2c59-543d-438dfb364efe', '9999812c-f78f-cb3a-bdfc-438dfb6a834c', '2005-11-30 19:20:54', 0);
INSERT INTO accounts_contacts VALUES ('706801da-5f4d-8140-efbf-438dfbc4cc0b', 'f347fab7-ef86-4bcd-5ffe-438dfb16fcf1', 'cfca9f5e-a1b3-1d21-df6a-438dfb36eadf', '2005-11-30 19:20:55', 0);
INSERT INTO accounts_contacts VALUES ('371384a6-851a-b736-06f7-438dfb2d376f', '3578fa51-9e8b-b2ef-f479-438dfba35441', '1864a1cc-60b1-c48b-8f71-438dfba9ba59', '2005-11-30 19:20:55', 0);
INSERT INTO accounts_contacts VALUES ('69f6f7ca-9380-09d5-4795-438dfb09f3b0', '68647185-ee73-93a2-e1d7-438dfb3f6742', '4884f8c8-1b4a-ca44-502d-438dfb71f043', '2005-11-30 19:20:55', 0);
INSERT INTO accounts_contacts VALUES ('a0ccb53f-0c0d-1d4e-b6be-438dfb43225a', '9f3b2f13-acb5-1849-aead-438dfbc6f3ef', '7b494b9c-bfe6-5125-3139-438dfb7f4b61', '2005-11-30 19:20:55', 0);
INSERT INTO accounts_contacts VALUES ('e5ce3804-4997-e9e2-e6bd-438dfbe59b97', 'e4256b33-026c-87f5-25a3-438dfba18a49', 'b26eaa78-b909-c1d6-f477-438dfb12c935', '2005-11-30 19:20:55', 0);
INSERT INTO accounts_contacts VALUES ('21edb788-7802-62f2-9a5f-438dfba9bfd9', '205a5184-19f4-b83c-0a8b-438dfbff0470', '304e07d6-fd21-1d2a-d905-438dfb7015ac', '2005-11-30 19:20:56', 0);
INSERT INTO accounts_contacts VALUES ('6031a76a-53ba-3711-1b7b-438dfb8ec7ec', '5ea03f7e-394e-3309-830c-438dfb3940f6', '3364987a-77b9-8587-0419-438dfb4161c6', '2005-11-30 19:20:56', 0);
INSERT INTO accounts_contacts VALUES ('9525e857-6b7e-470f-771b-438dfb139e44', '9389db6e-4af1-49bf-c2e5-438dfb74e7c9', '751f74c6-e766-4a2d-c618-438dfb884964', '2005-11-30 19:20:56', 0);
INSERT INTO accounts_contacts VALUES ('cf175a2a-9520-e82e-50d7-438dfb5f5367', 'cd86badb-8b40-9ffe-9da0-438dfb183a64', 'a93e924a-538b-1601-ae87-438dfb8fc4a2', '2005-11-30 19:20:56', 0);
INSERT INTO accounts_contacts VALUES ('12194fde-ee2c-c7de-ef34-438dfba36c65', '1089695d-7c35-441d-847b-438dfbc3bda6', 'e0737887-c5f3-a1a5-e608-438dfbd3315c', '2005-11-30 19:20:57', 0);
INSERT INTO accounts_contacts VALUES ('50ca60b9-4c0a-9281-b6d4-438dfb03f322', '4f0c48f3-e55d-13ef-0ccf-438dfb2f47d3', '2374b87b-5ad6-737a-8950-438dfbdc4ec4', '2005-11-30 19:20:57', 0);
INSERT INTO accounts_contacts VALUES ('8ad331a8-c81f-ad9c-c85c-438dfb685ad1', '893e8673-60cf-2811-b84f-438dfbb4c8e2', '622a9551-b8cc-1eb3-5ebb-438dfb0eab51', '2005-11-30 19:20:57', 0);
INSERT INTO accounts_contacts VALUES ('bb0a5df0-5f84-2548-ca76-438dfb217b2e', 'b97c1a0e-e67e-4473-7650-438dfb4f095b', '9c2c6aa1-824f-f9af-7ecb-438dfb6c1188', '2005-11-30 19:20:57', 0);
INSERT INTO accounts_contacts VALUES ('f2bdc8cf-edfc-b0bf-d01f-438dfb14bfef', 'f12b4626-6a15-ac46-d341-438dfbe1f68d', 'cc69d83e-11f0-f3e0-d42d-438dfb68d005', '2005-11-30 19:20:57', 0);
INSERT INTO accounts_contacts VALUES ('3dd4db5c-5779-6c5b-a37e-438dfba48d83', '3c3bcdb8-9454-817b-5fb6-438dfb473c45', 'fff9081b-2d2c-ae3f-faaa-438dfb9df93d', '2005-11-30 19:20:58', 0);
INSERT INTO accounts_contacts VALUES ('78df538a-eacc-90ed-8be1-438dfb729839', '774caf7a-3cea-5bd0-7e68-438dfbdb5d00', '4fbfef86-ea7d-b3c8-2a7a-438dfb305253', '2005-11-30 19:20:58', 0);
INSERT INTO accounts_contacts VALUES ('a93abf1f-1444-28e3-8249-438dfb69ec14', 'a79af6e9-9a0d-d708-a57b-438dfbdb6fe5', '8a43b583-3f48-a059-3087-438dfbd5f54f', '2005-11-30 19:20:58', 0);
INSERT INTO accounts_contacts VALUES ('e1324d4a-5ad0-35a2-c318-438dfb70835b', 'df946194-dae6-f6fc-f559-438dfb483e6f', 'baaaecde-dd04-9723-7b93-438dfba458e3', '2005-11-30 19:20:58', 0);
INSERT INTO accounts_contacts VALUES ('3e8f5c7b-d69a-f609-bac4-438dfb2ec2ce', '3ce94cbc-aa18-0e99-398c-438dfb0c71e5', 'f30c7cf7-c0c7-0ddb-9e80-438dfbd3a059', '2005-11-30 19:20:59', 0);
INSERT INTO accounts_contacts VALUES ('72cd3734-ae4a-caf0-86b9-438dfbca77e9', '71341df4-2c20-aab2-86e8-438dfb691cd7', '504421d1-6b83-2d46-28f1-438dfb176619', '2005-11-30 19:20:59', 0);
INSERT INTO accounts_contacts VALUES ('b4757d41-e398-4ff6-e257-438dfb603aea', 'b2b16071-b19e-3f1d-ad87-438dfb71082e', '849ff02a-a41e-a831-1c4a-438dfb9ac9c5', '2005-11-30 19:20:59', 0);
INSERT INTO accounts_contacts VALUES ('e5d857ad-733e-2de1-8a52-438dfb9281c2', 'e43341f9-5c56-e55a-1159-438dfb184800', 'c6407d2b-037b-c156-ea7a-438dfba2d249', '2005-11-30 19:20:59', 0);
INSERT INTO accounts_contacts VALUES ('3440f9d8-1e20-1f1f-d5a8-438dfb8ee6ac', '32a81608-cd1c-bfe2-d845-438dfb7f13c5', '36a40b1b-cb67-ceb4-0533-438dfb7d0963', '2005-11-30 19:21:00', 0);
INSERT INTO accounts_contacts VALUES ('6f5ef2e1-b23a-781b-3a32-438dfbb97119', '6db6de42-8f75-532e-6d8a-438dfb92b4cf', '45a5a513-0d9b-aadb-5c29-438dfb1fdc19', '2005-11-30 19:21:00', 0);
INSERT INTO accounts_contacts VALUES ('b8eb65aa-7fec-0b8d-ea4b-438dfb49627a', 'a63ea767-458b-c7c1-e1ef-438dfbbfadf0', '80a8a566-3f2a-194b-646c-438dfbc93925', '2005-11-30 19:21:00', 0);
INSERT INTO accounts_contacts VALUES ('f1abc830-7cd2-38bd-1299-438dfbdda267', 'f0168b3d-753f-90d8-4cb7-438dfb41e813', 'ca42a368-c80b-7cca-5596-438dfb51d67e', '2005-11-30 19:21:00', 0);
INSERT INTO accounts_contacts VALUES ('2d8f576d-b6d9-c916-7bdb-438dfb639ba6', '2beb16a9-12f9-e8d1-ab6d-438dfb120f06', 'ebf1026b-33e5-900d-f7b2-438dfb8a68cd', '2005-11-30 19:21:01', 0);
INSERT INTO accounts_contacts VALUES ('7220422a-a6d0-4eb9-d38e-438dfba2e3e0', '7089909f-73ee-8867-3bee-438dfbf24aa1', '3efe2b3e-0a4a-c3fe-aef8-438dfbad5ee3', '2005-11-30 19:21:01', 0);
INSERT INTO accounts_contacts VALUES ('b3fa15f4-ef63-9087-de58-438dfb796486', 'b231be8d-1714-a07f-4170-438dfb6cd84b', '838163c6-4c13-957a-1afb-438dfb2ca106', '2005-11-30 19:21:01', 0);
INSERT INTO accounts_contacts VALUES ('ecdd0046-2f34-7276-c3b7-438dfbf819b7', 'eb436fc4-abf5-2592-24fc-438dfb6d3b99', 'c5459906-c7f9-27ca-7cde-438dfb77de9a', '2005-11-30 19:21:01', 0);
INSERT INTO accounts_contacts VALUES ('4cbb3fb0-41b9-a7d4-0d74-438dfb18bb60', '4b133882-f531-8712-3870-438dfb0a38e4', 'a0b7065e-075b-3b0f-c2bc-438dfb008e30', '2005-11-30 19:21:02', 0);
INSERT INTO accounts_contacts VALUES ('88c9023d-9281-23c9-bf2d-438dfbc7c6ce', '8723405c-0551-39fc-7f72-438dfbf58033', '5e74135e-b955-5ffd-8f0c-438dfbe44b00', '2005-11-30 19:21:02', 0);
INSERT INTO accounts_contacts VALUES ('cb2a827a-fd21-f148-6c8a-438dfbe06881', 'c995d758-b175-9356-a25a-438dfb305bc4', '9a12f641-08dd-f9b2-2def-438dfb694df6', '2005-11-30 19:21:02', 0);
INSERT INTO accounts_contacts VALUES ('22a2aea5-3853-2afd-e4c9-438dfb08d883', '17bab88d-c43f-6afe-2d95-438dfbb751e8', 'dc83dcc0-d01b-8c04-b643-438dfb9f335e', '2005-11-30 19:21:03', 0);
INSERT INTO accounts_contacts VALUES ('5cc4afef-d993-6f79-52d6-438dfbea9e83', '5b2847cf-c05f-1dd8-8439-438dfbd0e5ce', '340cc499-cd7d-5941-40ff-438dfb26c7a9', '2005-11-30 19:21:03', 0);
INSERT INTO accounts_contacts VALUES ('8f672815-12bd-b654-aebe-438dfb9faa76', '8dcb98d7-1fb9-fd3b-2d03-438dfb95f3ca', '70cfedfa-30fa-5e8d-9c2e-438dfb7dccac', '2005-11-30 19:21:03', 0);
INSERT INTO accounts_contacts VALUES ('d2e1896d-abf1-2f98-40e7-438dfb579957', 'd139c716-46d7-ea5b-dd2a-438dfb1db2c9', 'a0cea6f1-a86f-cfcd-4a58-438dfbb32474', '2005-11-30 19:21:03', 0);
INSERT INTO accounts_contacts VALUES ('ec530f5e-3691-973c-d454-438dfb048839', 'd2420e1a-9306-7581-0b77-438dfb45485d', 'e42c1718-a0c6-c10a-160f-438dfbe77501', '2005-11-30 19:21:04', 0);
INSERT INTO accounts_contacts VALUES ('5c1d345a-9159-f725-f810-438dfb21b566', '5a85581d-65b8-04c9-4f49-438dfb856d68', '20292e58-c2b9-29de-299f-438dfb4dc874', '2005-11-30 19:21:04', 0);
INSERT INTO accounts_contacts VALUES ('989751ea-a58b-28d1-d668-438dfb8fa0c8', '9701defd-48ef-9b70-ba34-438dfb721f54', '70266a53-82a3-acff-f7db-438dfb24a59f', '2005-11-30 19:21:04', 0);
INSERT INTO accounts_contacts VALUES ('d2f7a8c7-539f-867a-2605-438dfb85a5d3', 'd161848f-b9b6-25da-e2ee-438dfb17d5d2', 'a9f8b729-dd46-fa62-6e96-438dfb37f4cb', '2005-11-30 19:21:04', 0);
INSERT INTO accounts_contacts VALUES ('18d43ddf-206c-105c-1e41-438dfb2e352b', '172eaa2d-9143-e2ff-9052-438dfb19c356', 'e4773e57-f838-8bf1-f04a-438dfbc86a47', '2005-11-30 19:21:05', 0);
INSERT INTO accounts_contacts VALUES ('5e0feb38-50ac-f0f1-b995-438dfb938e41', '5c2ccf04-3126-1057-aa06-438dfb5348c8', '2a41280f-1e6d-838e-c46f-438dfbb2e0d6', '2005-11-30 19:21:05', 0);
INSERT INTO accounts_contacts VALUES ('aefdeead-3978-2888-5bd5-438dfb8edf69', 'ad613575-8132-eedd-3f2b-438dfb6d3a33', '71fc22f1-cb94-037b-8b25-438dfba9f9e3', '2005-11-30 19:21:05', 0);
INSERT INTO accounts_contacts VALUES ('f3975da2-6ba3-c33e-3f8a-438dfb647e3b', 'f1fd99b3-2b8d-f15a-4528-438dfb0120c3', 'c082f0d9-9511-ddc3-a24f-438dfbe61104', '2005-11-30 19:21:05', 0);
INSERT INTO accounts_contacts VALUES ('4e6d9594-592c-7b87-4fbe-438dfbd0ec55', '385538b3-7b55-893e-4041-438dfb281c0f', '10c132e5-9074-b5c9-335c-438dfbfba202', '2005-11-30 19:21:06', 0);
INSERT INTO accounts_contacts VALUES ('8bb8da71-8eb7-555f-9391-438dfbcacbe1', '8a237a1a-0b09-b400-5cf1-438dfb006758', '6006ab36-84f7-f994-0326-438dfbce1f60', '2005-11-30 19:21:06', 0);
INSERT INTO accounts_contacts VALUES ('d0dd972c-ffcb-b6df-a235-438dfba2884b', 'cf379c78-b6ce-fd22-e566-438dfb2f287a', '9d1f300c-ec5a-6b7f-640f-438dfbca0fd9', '2005-11-30 19:21:06', 0);
INSERT INTO accounts_contacts VALUES ('d181066c-3b26-5d00-0cf0-438dfb82b770', 'b7f902b5-a01c-dcc9-668a-438dfbd1fb79', 'e25563d8-e9ae-59c1-b16d-438dfb5bac3d', '2005-11-30 19:21:07', 0);
INSERT INTO accounts_contacts VALUES ('47e19c45-b57c-9864-e8cd-438dfb79f7b6', '46446a44-3787-916c-9abf-438dfbe8f126', '1e5d7290-9444-62ce-93c4-438dfbebbee8', '2005-11-30 19:21:07', 0);
INSERT INTO accounts_contacts VALUES ('8583660d-0bc1-9e9e-c38c-438dfba8a0f9', '83f01693-d661-9ca0-a781-438dfb698921', '59596161-ecce-4e01-e4c0-438dfb4ff125', '2005-11-30 19:21:07', 0);
INSERT INTO accounts_contacts VALUES ('cb48a045-232e-db63-8ca5-438dfbf4cfd7', 'c9b10ba7-510a-e05e-0459-438dfbc0f13c', '96e57544-3ad1-9a36-ef96-438dfbec0b11', '2005-11-30 19:21:07', 0);
INSERT INTO accounts_contacts VALUES ('1d6e4db2-f165-f97f-c0a1-438dfbd5916b', '1bdd5126-1a32-6d4c-5ddf-438dfb128e73', 'dd3d85cb-9c27-8d9d-8db5-438dfb85537a', '2005-11-30 19:21:08', 0);
INSERT INTO accounts_contacts VALUES ('4d8237cd-b73f-dd0d-530e-438dfba6b59e', '4beede9e-06f5-dcb2-20e9-438dfb2b3598', '2eeaa483-0194-67e8-5bdd-438dfbb60ccb', '2005-11-30 19:21:08', 0);
INSERT INTO accounts_contacts VALUES ('8c4953fd-b0f2-5cb4-de6f-438dfb4cc6bb', '8aac0eb3-bc50-60ba-4c72-438dfb462c8f', '5f0d7f18-38a2-12a5-4db4-438dfbfbd6eb', '2005-11-30 19:21:08', 0);
INSERT INTO accounts_contacts VALUES ('d33588c0-7986-9150-ffce-438dfbfaa3ab', 'c6581ce4-2297-a509-e0cf-438dfb9da58d', '9d8bc0c6-b3c1-e81d-f394-438dfb41fcd4', '2005-11-30 19:21:08', 0);
INSERT INTO accounts_contacts VALUES ('f3cc012c-c149-d2c0-78cd-438dfbac25f6', 'd884070c-5f9c-bc6d-c5cb-438dfb632b5e', 'e488e549-954c-86df-9e80-438dfb10a6fa', '2005-11-30 19:21:09', 0);
INSERT INTO accounts_contacts VALUES ('4ad545d7-20b2-576c-61f8-438dfb59f722', '49340d14-91ff-ec1a-291f-438dfb528e7f', '20b432f7-cf4d-dd8d-0341-438dfbd532ba', '2005-11-30 19:21:09', 0);
INSERT INTO accounts_contacts VALUES ('894c8703-0694-44b0-412d-438dfb7c6def', '87b678cc-4ef6-ff21-d0e5-438dfb959a96', '5c4866c0-bccc-d7c9-6ac5-438dfbc9d570', '2005-11-30 19:21:09', 0);
INSERT INTO accounts_contacts VALUES ('b9643fca-26ec-57db-0361-438dfbca92c1', 'b7c3c106-73c1-accf-cd0d-438dfb913dec', '9aadf826-537d-c6b7-e7fe-438dfba9881c', '2005-11-30 19:21:09', 0);
INSERT INTO accounts_contacts VALUES ('c4bd018f-c7ef-1771-fe35-438dfba29b86', 'aab70ec1-bd50-d89f-5925-438dfbbe3010', 'caa4c6ab-ab71-ffb2-ac83-438dfb3457da', '2005-11-30 19:21:10', 0);
INSERT INTO accounts_contacts VALUES ('5f88a50d-89ce-09cd-1f70-438dfb482caf', '5de345fd-fbad-a03d-1e72-438dfb1f206a', '1d98d9e0-4058-aede-3d44-438dfb44af49', '2005-11-30 19:21:10', 0);
INSERT INTO accounts_contacts VALUES ('923f5fe4-4d66-dd6f-4d8d-438dfbada68f', '909103b7-02b6-2996-971a-438dfb04527d', '736eaf1d-739b-8fbe-46dc-438dfba914ad', '2005-11-30 19:21:10', 0);
INSERT INTO accounts_contacts VALUES ('ce5b493c-4ae4-ca99-8f3c-438dfb5c2fdc', 'ccc521a1-42b0-0461-1db1-438dfbfc60e8', 'a3a0858e-b3f3-2557-b597-438dfbf596b3', '2005-11-30 19:21:10', 0);
INSERT INTO accounts_contacts VALUES ('3b804dd8-313c-45f6-1634-438dfb11fd5c', '39772a90-136e-1c78-a7cf-438dfb73b6ec', 'dfcc7856-219e-f4ee-968c-438dfb5374f7', '2005-11-30 19:21:11', 0);
INSERT INTO accounts_contacts VALUES ('6fb682b5-5ff0-4606-49e7-438dfb3af92f', '6dee0a49-5de9-eebe-48ea-438dfb4a8f88', '4d4fb109-a147-164a-7078-438dfb21dc20', '2005-11-30 19:21:11', 0);
INSERT INTO accounts_contacts VALUES ('ae30a3f5-537d-abf7-76dd-438dfb15cf8f', 'ac939578-27f4-ffea-440d-438dfb6be363', '82991196-40ca-6cef-1cac-438dfb08f497', '2005-11-30 19:21:11', 0);
INSERT INTO accounts_contacts VALUES ('ebdda4ee-543f-2003-1a85-438dfbe5cbe7', 'ea478e3b-7bc7-c09e-0c50-438dfb951c3d', 'bffce1e9-399b-b344-74da-438dfb464f30', '2005-11-30 19:21:11', 0);
INSERT INTO accounts_contacts VALUES ('2915a891-bc1e-8990-1705-438dfb6725cf', '27752dc3-d98a-66c5-a10a-438dfbe6efb2', '98860e21-aa2a-ef96-d003-438dfb2d8436', '2005-11-30 19:21:12', 0);
INSERT INTO accounts_contacts VALUES ('6725b85b-20b6-bcbc-509c-438dfb874a3e', '6589d325-291f-b196-87b9-438dfbda0fb5', '3b36216f-a3db-a148-b194-438dfbe17840', '2005-11-30 19:21:12', 0);
INSERT INTO accounts_contacts VALUES ('99d55cf6-e75e-38c8-4919-438dfb169363', '9842a7d6-bca1-6145-e374-438dfbd14836', '7b28da71-732a-623c-77fa-438dfbe91aa6', '2005-11-30 19:21:12', 0);
INSERT INTO accounts_contacts VALUES ('c9fc87fa-c95c-58ce-422b-438dfbd45c20', 'c86a3792-77fc-aca7-f050-438dfb77d91f', 'ab43ac14-4019-51f9-3490-438dfb6e12de', '2005-11-30 19:21:12', 0);
INSERT INTO accounts_contacts VALUES ('1f3c8fa1-10f7-5d38-86c9-438dfb7b26b5', '1d9c4adc-2b8d-3332-93b8-438dfba0f4d5', 'db489ef6-f6ae-6e3b-3b6e-438dfb73fda3', '2005-11-30 19:21:13', 0);
INSERT INTO accounts_contacts VALUES ('5c7b7524-d520-2953-e0ea-438dfb78ac85', '5aeb3f00-a57e-bf48-947b-438dfb16af03', '30921930-dd76-d74b-03d3-438dfbf185c3', '2005-11-30 19:21:13', 0);
INSERT INTO accounts_contacts VALUES ('8fd6f93e-5c45-720d-f800-438dfbe59258', '8e4040ae-2931-7f7e-108b-438dfbd8da50', '70b79b91-4836-3308-36aa-438dfbae2531', '2005-11-30 19:21:13', 0);
INSERT INTO accounts_contacts VALUES ('c01ce75a-d289-9f89-d4c8-438dfb08b8f6', 'be88d5f9-09bd-47b7-f4fa-438dfbfe7eff', 'a1390532-2bad-f7be-a025-438dfbc3db6b', '2005-11-30 19:21:13', 0);
INSERT INTO accounts_contacts VALUES ('95b4096f-6a66-a3ac-be46-438dfb666b8e', '7c880d96-1f06-07ff-686d-438dfbddcf09', 'd18b839f-0374-3a4d-c8ae-438dfbcca296', '2005-11-30 19:21:14', 0);
INSERT INTO accounts_contacts VALUES ('61542517-6954-bbea-cfd0-438dfb14399c', '5fbaedee-b36c-731b-a260-438dfb273327', '1acbfe30-7ed3-8742-d41e-438dfb7fffd7', '2005-11-30 19:21:14', 0);
INSERT INTO accounts_contacts VALUES ('9447e079-4d12-9160-c191-438dfb5a81f5', '929ff444-d7ad-bbc3-7513-438dfb817d0d', '7536903c-aee1-3994-51db-438dfbe974a6', '2005-11-30 19:21:14', 0);
INSERT INTO accounts_contacts VALUES ('c47f1e15-d226-b6cf-9ed9-438dfbe5aeaf', 'c2df9bfe-8f5e-6f0b-4eba-438dfbb11fad', 'a586a963-8c8d-444d-ef96-438dfbb7ec6f', '2005-11-30 19:21:14', 0);
INSERT INTO accounts_contacts VALUES ('28a1b43b-d33d-2921-2362-438dfbd60921', '26f7b83f-3b76-5998-55ac-438dfbdd0571', 'd5cef91d-7579-2bf5-e1da-438dfb9c1f01', '2005-11-30 19:21:15', 0);
INSERT INTO accounts_contacts VALUES ('5910ba90-3619-dc2d-27c7-438dfb80a548', '5772ad6f-1d9e-50dc-91f4-438dfb83aea5', '3a1d8224-f228-2a6f-0875-438dfbcf8793', '2005-11-30 19:21:15', 0);
INSERT INTO accounts_contacts VALUES ('b4ddad4d-7022-65d9-cd67-438dfb9f5dee', 'b347e318-2445-864a-206b-438dfbae6f05', '6d303905-f4e0-640c-af5a-438dfb307c0f', '2005-11-30 19:21:15', 0);
INSERT INTO accounts_contacts VALUES ('c2b0012a-1949-d1dd-eede-438dfb6f2a9e', 'a8530c92-04e8-acf7-4a8e-438dfbae1cfb', 'e17a0d13-3963-7868-ca52-438dfbd6d960', '2005-11-30 19:21:16', 0);
INSERT INTO accounts_contacts VALUES ('58440e15-dd17-67a0-26e3-438dfb63ab7f', '56830100-5245-e472-bf5c-438dfb597d22', '1daf85c8-6874-a17b-17cb-438dfb55a65f', '2005-11-30 19:21:16', 0);
INSERT INTO accounts_contacts VALUES ('b4d415e6-a920-3225-62e6-438dfb7787ac', 'b3306b7a-776f-4919-3d75-438dfb06b38b', '69ac166c-2b09-54c5-e12e-438dfb58be75', '2005-11-30 19:21:16', 0);
INSERT INTO accounts_contacts VALUES ('1c94fbb6-2161-eb45-b9a0-438dfbacb2ff', '1ae33407-6a18-2e67-6c31-438dfb7e335d', 'c64ca1f4-971c-ba58-e3a6-438dfbe4e18a', '2005-11-30 19:21:17', 0);
INSERT INTO accounts_contacts VALUES ('693e7852-6d83-1cfc-1ffd-438dfbd7bb31', '67a75942-7b29-84c5-dc1b-438dfb4c6662', '2e151528-0941-acdb-9162-438dfb4fb878', '2005-11-30 19:21:17', 0);
INSERT INTO accounts_contacts VALUES ('b8aa68c3-c554-e2c9-e532-438dfbf91a5e', 'b708a38a-ddcb-e71c-0be9-438dfb6f14cb', '7d77c5de-1ccb-a31f-2fa0-438dfb56e39b', '2005-11-30 19:21:17', 0);
INSERT INTO accounts_contacts VALUES ('e8d40ddd-714a-fe2a-0193-438dfb322010', 'e73c2b75-51c1-556f-0175-438dfb3438d3', 'ca27de55-8edd-4ee9-e5ac-438dfbd89907', '2005-11-30 19:21:17', 0);
INSERT INTO accounts_contacts VALUES ('333befab-27a7-d2b9-ca50-438dfb1bd59d', '31941a18-98a5-78c3-b0f5-438dfbdea6a6', '60b70a54-714f-be7a-4b60-438dfb818721', '2005-11-30 19:21:18', 0);
INSERT INTO accounts_contacts VALUES ('63841f13-14b7-4655-44cb-438dfb5b10ec', '61de8d58-0a88-daac-786f-438dfbfabc3d', '4493f50e-b438-9309-7460-438dfbd1e55a', '2005-11-30 19:21:18', 0);
INSERT INTO accounts_contacts VALUES ('a552329c-8bd6-40f8-68bb-438dfbc985dd', 'a3b7f50f-2927-05a1-448d-438dfb9f8b70', '7785d491-20b6-5a33-d7f5-438dfbbcdfe4', '2005-11-30 19:21:18', 0);
INSERT INTO accounts_contacts VALUES ('b0d0084f-6c5c-34fc-c8ff-438dfb7f623d', 'f338e55b-c6c2-b508-aba6-438dfbe17d7f', 'b72ef6a5-a70e-7e32-7555-438dfb48175a', '2005-11-30 19:21:19', 0);
INSERT INTO accounts_contacts VALUES ('3fa26078-8c04-4058-25a2-438dfbcaa077', '3e005fd4-ee61-6319-0fba-438dfb0f0503', '1226c48a-8e8a-48fd-168f-438dfbbc24a6', '2005-11-30 19:21:19', 0);
INSERT INTO accounts_contacts VALUES ('8ff290b9-e606-1458-a9e4-438dfbacfab1', '8e557696-9cbb-d7fe-db7c-438dfb24aa6a', '51069b30-5071-f6e7-81d6-438dfbfac69a', '2005-11-30 19:21:19', 0);
INSERT INTO accounts_contacts VALUES ('c071dd83-1234-90f9-18c7-438dfb040030', 'bead48af-9252-a436-8286-438dfbe332d2', 'a169e42d-a69b-b039-6170-438dfbd9dd1b', '2005-11-30 19:21:19', 0);
INSERT INTO accounts_contacts VALUES ('f0a65948-7dca-447e-5edc-438dfb1af5c7', 'ef0b0453-13d5-e932-aa5f-438dfb6c5b87', 'd1c588fa-0835-de12-f760-438dfb25122d', '2005-11-30 19:21:19', 0);
INSERT INTO accounts_contacts VALUES ('33111f5b-69dc-62b0-27ab-438dfb2b1151', '3179bf08-aa9e-6447-9ad2-438dfbaf64bb', '1463cd37-29f8-b0f2-4514-438dfb7af5ba', '2005-11-30 19:21:20', 0);
INSERT INTO accounts_contacts VALUES ('750d3356-70be-4211-ca4c-438dfb29a0db', '7371f5a0-df4f-929e-f361-438dfbca4a1d', '4488073d-4339-fb11-e278-438dfb45d751', '2005-11-30 19:21:20', 0);
INSERT INTO accounts_contacts VALUES ('d3645d0f-b637-cf4b-f18f-438dfb163c3b', 'c2799ce6-f145-d487-d544-438dfb7e54de', '86b427e1-a1dd-4d58-d470-438dfbdd6dfd', '2005-11-30 19:21:20', 0);
INSERT INTO accounts_contacts VALUES ('1eda9fe0-31bf-e93d-4fce-438dfb65f273', '1d35f104-81c6-91b2-aa22-438dfbb8d79b', 'e4ce44fa-216f-d1c7-e9ef-438dfbb2cc13', '2005-11-30 19:21:21', 0);
INSERT INTO accounts_contacts VALUES ('5ea5f8a8-d270-e7fa-05e9-438dfb039edd', '5d0e32f9-ccbd-5884-b558-438dfbd80618', '30243b86-0c2f-4cd9-cf98-438dfb7a611e', '2005-11-30 19:21:21', 0);
INSERT INTO accounts_contacts VALUES ('a0ee1dfa-db0f-6072-4390-438dfb13e962', '9f4f9ecb-204f-86bf-51a4-438dfb908e62', '7282206d-2097-c88f-cc36-438dfb4272e6', '2005-11-30 19:21:21', 0);
INSERT INTO accounts_contacts VALUES ('f07aaf6d-19a0-b715-055c-438dfb221f76', 'cfbddcb2-d793-f7de-7ae0-438dfb13284e', 'b269cbcc-3523-84cd-76a1-438dfb8cca3e', '2005-11-30 19:21:21', 0);
INSERT INTO accounts_contacts VALUES ('417feeb9-12e7-9cf6-72d6-438dfb651526', '3fe3d218-f486-5e02-90e7-438dfb8e07c9', 'db29071d-ab61-8267-207d-438dfbd07e1f', '2005-11-30 19:21:22', 0);
INSERT INTO accounts_contacts VALUES ('74a42902-3d68-ef51-85dc-438dfb946969', '72fd3911-6a09-d547-8135-438dfbab92b6', '52e4fd3b-926a-77bb-c6ba-438dfbe5a927', '2005-11-30 19:21:22', 0);
INSERT INTO accounts_contacts VALUES ('b4e23ee9-2a0f-8d87-94fa-438dfb266be3', 'b34f3620-e06d-2204-bad6-438dfbde15d9', '861f83dc-68b6-733b-cbce-438dfb2b868a', '2005-11-30 19:21:22', 0);
INSERT INTO accounts_contacts VALUES ('f0f004f2-e5f4-0591-4a15-438dfb7c4557', 'f37ba3e7-5fba-8116-0c9f-438dfba4a4a4', 'c661b334-bf51-1dde-62bf-438dfbf2442c', '2005-11-30 19:21:23', 0);
INSERT INTO accounts_contacts VALUES ('51c163ce-f768-5f0e-3068-438dfbaf7df7', '50163f87-2578-8145-a6ba-438dfb7a64e7', '12814883-6201-bc73-1589-438dfbe68b5d', '2005-11-30 19:21:23', 0);
INSERT INTO accounts_contacts VALUES ('8f9a6387-db8a-3ff1-1305-438dfbb9aec2', '8dfbdb3c-ea21-ba42-2b4e-438dfb1ed504', '68359cf5-c82c-2694-bcf9-438dfbe295ac', '2005-11-30 19:21:23', 0);
INSERT INTO accounts_contacts VALUES ('c3cb88a1-a060-804f-0ad6-438dfbb92676', 'c2287454-16a5-ad9f-53eb-438dfb449127', 'a2f0f610-c757-4a3d-0e53-438dfb0662eb', '2005-11-30 19:21:23', 0);
INSERT INTO accounts_contacts VALUES ('317701a7-9269-7b12-bd88-438dfbb2882c', '17130dfb-8f0e-76cd-2459-438dfb9a7d26', 'd6b280a6-e776-1416-4a2f-438dfbc155a4', '2005-11-30 19:21:24', 0);
INSERT INTO accounts_contacts VALUES ('36aaa403-1655-56fc-997f-438dfb182d6b', '35018c59-161b-f18c-70fa-438dfb2e22bc', '1620dad8-2eb7-e7e0-cc51-438dfb06f565', '2005-11-30 19:21:24', 0);
INSERT INTO accounts_contacts VALUES ('81114e09-3260-3df3-4d87-438dfb9bfc9d', '7f602621-3a03-7c5b-299b-438dfbd7c79e', '4ca2c4b2-a7ad-2dd5-c8ce-438dfbacc559', '2005-11-30 19:21:24', 0);
INSERT INTO accounts_contacts VALUES ('c652feb5-8a73-7af0-e6f0-438dfbaf39d7', 'c4b41d6a-98f8-db12-4d87-438dfb17a0ee', '94a3441e-a450-ea5a-d820-438dfb458713', '2005-11-30 19:21:24', 0);
INSERT INTO accounts_contacts VALUES ('159d2d75-5efe-fe05-3199-438dfbe9ebc8', '13ead050-5430-1f24-bbba-438dfb81df4b', 'd882d439-557f-3c8a-2b84-438dfb8fb443', '2005-11-30 19:21:25', 0);
INSERT INTO accounts_contacts VALUES ('591eedf3-96ae-91f8-b470-438dfbf68628', '576814a8-5b8e-aeec-882a-438dfbc108de', '27d80dd7-5709-0d55-bc59-438dfb2ecf77', '2005-11-30 19:21:25', 0);
INSERT INTO accounts_contacts VALUES ('9f0b3cb1-481e-fb8d-3f3a-438dfba146fb', '9d5f576d-d8aa-a18d-03f6-438dfbf29aa0', '6bdb4764-4c85-d993-60a3-438dfbd78877', '2005-11-30 19:21:25', 0);
INSERT INTO accounts_contacts VALUES ('e193a6cf-41b0-c770-445b-438dfb53bfd4', 'dfe35de9-6a10-58fe-e8ac-438dfb444a89', 'b0e04bdb-7d18-6594-1161-438dfbdd2db8', '2005-11-30 19:21:25', 0);
INSERT INTO accounts_contacts VALUES ('40f81930-a363-36b1-91e3-438dfbedb8a0', '3f58df53-2d1f-14b1-99e3-438dfbf453bc', 'f36732ff-d18a-33cf-cdef-438dfb50e080', '2005-11-30 19:21:26', 0);
INSERT INTO accounts_contacts VALUES ('75094e61-884b-a866-b4ac-438dfba87bc7', '735e191f-1fc4-37f0-d279-438dfb58f8bb', '52bed83a-38fc-b11f-f87f-438dfb98b92e', '2005-11-30 19:21:26', 0);
INSERT INTO accounts_contacts VALUES ('b71e9ba6-a955-243d-9a45-438dfbdacc0e', 'b58876e3-c8b9-5cdb-9684-438dfb973b0c', '86d3263a-ebb4-fe6c-af85-438dfb92f6e9', '2005-11-30 19:21:26', 0);
INSERT INTO accounts_contacts VALUES ('26fc26e9-adcf-f292-1a98-438dfba47c80', '255ddee7-76a8-3237-e26d-438dfb4d14d1', 'c899fe71-1c72-cefa-3506-438dfbf06cbb', '2005-11-30 19:21:27', 0);
INSERT INTO accounts_contacts VALUES ('68c85032-8ee6-55d8-3b7b-438dfb4efce2', '672a9d8d-1169-77f4-3e03-438dfb1b502d', '3848e594-7629-8173-06a8-438dfbd07afa', '2005-11-30 19:21:27', 0);
INSERT INTO accounts_contacts VALUES ('9b8bdaad-aa5d-0ea3-88c8-438dfb4e55e4', '99ef86ab-70ad-c2c7-9019-438dfb9d42ea', '7cb73f6a-5de6-f957-936b-438dfb2ab8cb', '2005-11-30 19:21:27', 0);
INSERT INTO accounts_contacts VALUES ('ef2bf2da-4ca1-19b5-88c6-438dfbe5838d', 'ed983c1c-954f-ad34-cdac-438dfb13e2a3', 'ad0c8ac5-b1f9-9dcd-ca34-438dfb04c1a8', '2005-11-30 19:21:27', 0);
INSERT INTO accounts_contacts VALUES ('2b60da17-87e4-bd12-336d-438dfbd08d91', '29c5fa2b-917c-ee13-f67b-438dfb2aa822', 'c98d0766-adf0-5ff8-63d0-438dfb9a8e9e', '2005-11-30 19:21:28', 0);
INSERT INTO accounts_contacts VALUES ('5c0fbef6-a20f-3ca7-eb98-438dfb19e5fe', '5a42514a-1d12-21b5-0ef2-438dfba6baaa', '3ce7d434-1d87-d2ac-cb37-438dfb6eaebb', '2005-11-30 19:21:28', 0);
INSERT INTO accounts_contacts VALUES ('8ebfd332-e40e-03e1-1def-438dfb6813cb', '8d255020-6ab1-1629-5957-438dfb5fefd9', '6d531631-8b4e-ed30-477f-438dfb9e4024', '2005-11-30 19:21:28', 0);
INSERT INTO accounts_contacts VALUES ('197e043c-ee68-a5bb-28df-438dfb577858', 'f42253fa-4431-bf39-1eff-438dfb5ccc2b', 'b3341af8-246f-e384-a007-438dfbc474a3', '2005-11-30 19:21:29', 0);
INSERT INTO accounts_contacts VALUES ('44b16fb0-535b-7d76-48a6-438dfbf963f8', '431d4846-1657-7eeb-ccca-438dfbd906d3', '13116248-d871-2b8d-45af-438dfb8b4196', '2005-11-30 19:21:29', 0);
INSERT INTO accounts_contacts VALUES ('898d5668-207d-5f0a-983b-438dfb1806f8', '87e6cc8c-3963-ed6f-e757-438dfb9cee0f', '5602b4b8-2825-616c-26d1-438dfb0c802e', '2005-11-30 19:21:29', 0);
INSERT INTO accounts_contacts VALUES ('b9d82d83-540d-136d-a262-438dfb41454b', 'b836880a-50ee-b122-57d7-438dfb312840', '9aecd983-eb46-0d41-825d-438dfb1bcc5c', '2005-11-30 19:21:29', 0);
INSERT INTO accounts_contacts VALUES ('81580cf9-4c67-aad9-847b-438dfb482b0f', '66cb06b4-9fa8-fa44-86ee-438dfb289f41', 'cb4e19da-1b76-52ef-4756-438dfb152979', '2005-11-30 19:21:30', 0);
INSERT INTO accounts_contacts VALUES ('5d0ba24d-3daa-5029-7b4b-438dfb9f1a1b', '36ad5d3d-c5ba-46de-6588-438dfb5e50f5', '198c4b42-3db0-a532-fe75-438dfb4ed4c3', '2005-11-30 19:21:30', 0);
INSERT INTO accounts_contacts VALUES ('b5a4dddb-6908-be61-d7e3-438dfb2f6a00', 'b411d972-3692-d425-7c61-438dfba7104b', '721ccb5b-ba24-966e-5cbd-438dfb4043f6', '2005-11-30 19:21:30', 0);
INSERT INTO accounts_contacts VALUES ('e5f53df9-86df-0efa-74cb-438dfb13c68b', 'e4606022-243b-cc24-ea46-438dfbab7ef1', 'c70c9652-fb23-1d97-2bcf-438dfbb6fe01', '2005-11-30 19:21:30', 0);
INSERT INTO accounts_contacts VALUES ('22281716-991a-b83e-0f2a-438dfb3d6c16', '2089b201-3ea3-f697-2702-438dfb4d6da0', '33aa0685-459e-a142-1291-438dfba1fba4', '2005-11-30 19:21:31', 0);
INSERT INTO accounts_contacts VALUES ('8d31ac8e-aae1-bab3-c6f5-438dfbead154', '63b7cd92-1679-3792-289f-438dfbf297b2', '337bdd25-c908-7d88-d70e-438dfb6d5a65', '2005-11-30 19:21:31', 0);
INSERT INTO accounts_contacts VALUES ('d009e0a0-bd1d-9981-6dc6-438dfbb168fd', 'ce67176e-8137-83ab-eba0-438dfb7249de', '9e9d1ad7-e038-da60-b03f-438dfbb22801', '2005-11-30 19:21:31', 0);
INSERT INTO accounts_contacts VALUES ('374721a7-096b-8c33-ac25-438dfb6aecbd', '35b22091-0b1b-c7fa-21b0-438dfb70d3a3', '5b3205e4-12a6-dee0-efd5-438dfb40c431', '2005-11-30 19:21:32', 0);
INSERT INTO accounts_contacts VALUES ('7d894c48-a727-5f37-f960-438dfb7efc15', '7bf2fb4c-2bdd-2f3e-4d2e-438dfbbfbf4a', '48baf602-37b8-7988-804f-438dfb47231a', '2005-11-30 19:21:32', 0);
INSERT INTO accounts_contacts VALUES ('c0c771ca-7be4-e460-152f-438dfb645f5b', 'bf2e9820-ec17-72ef-9fe0-438dfb76c0a3', '8ef3c7cf-ee6c-1e89-f6c4-438dfb171221', '2005-11-30 19:21:32', 0);
INSERT INTO accounts_contacts VALUES ('23159ee6-5cb0-6927-3fd6-438dfb648352', '217e43e1-caa2-58c7-738a-438dfba8d9c3', 'd2373f7e-3be1-ac95-0bbd-438dfb96caeb', '2005-11-30 19:21:33', 0);
INSERT INTO accounts_contacts VALUES ('534a4fa1-ceee-16a5-a99f-438dfb5890f9', '51afb235-7282-54fb-491b-438dfb20bd02', '34777a04-8cf2-130c-c206-438dfb71857f', '2005-11-30 19:21:33', 0);
INSERT INTO accounts_contacts VALUES ('86645bca-01f7-2983-1472-438dfb719630', '84c9a387-9285-336b-da4a-438dfbccca30', '64db3226-ae3d-4e8a-5749-438dfb42ff39', '2005-11-30 19:21:33', 0);
INSERT INTO accounts_contacts VALUES ('b7a602d3-243f-33f9-7179-438dfb0de9ae', 'b607cbc4-9c0d-83ab-6177-438dfb1dedaa', '97bd6b61-bc71-d178-5a95-438dfb05fd04', '2005-11-30 19:21:33', 0);
INSERT INTO accounts_contacts VALUES ('75df0299-0bea-fb91-90f6-438dfb5421be', '5b1b0bd2-a4de-3e2e-acd7-438dfbca4f42', 'c8efe193-131a-8773-9b67-438dfbcae321', '2005-11-30 19:21:34', 0);
INSERT INTO accounts_contacts VALUES ('37837618-1132-2f10-f766-438dfb9d9178', '35ea3447-51b9-f6cd-0e2f-438dfb83b57e', '18cf8c9b-25fd-9b30-f993-438dfb879e80', '2005-11-30 19:21:34', 0);
INSERT INTO accounts_contacts VALUES ('7e066504-0173-7018-98bc-438dfb495f97', '7c5e1bd1-00e0-960a-2420-438dfb99df6a', '48f9d0d4-e10b-53cd-1a0b-438dfbb23a4d', '2005-11-30 19:21:34', 0);
INSERT INTO accounts_contacts VALUES ('d634604a-a609-842b-af25-438dfb9f630b', 'c0c047f2-f138-1c51-d11b-438dfb0e3d5f', '8f7f554f-8242-46f3-6454-438dfb8ee5fe', '2005-11-30 19:21:34', 0);
INSERT INTO accounts_contacts VALUES ('124d7abb-d78d-6867-b14f-438dfbffaba3', '10b22f2b-80f3-796f-ecf4-438dfbb42bd9', 'e7ab3484-832b-285b-9e13-438dfbc947f0', '2005-11-30 19:21:35', 0);
INSERT INTO accounts_contacts VALUES ('6b13dce3-c6fb-4bbd-b54b-438dfb4b83e1', '696faf37-710d-16d7-e9c2-438dfb1f763c', '2399516f-d014-ece7-7267-438dfb20a957', '2005-11-30 19:21:35', 0);
INSERT INTO accounts_contacts VALUES ('c6174616-6255-bb6f-5314-438dfb122a44', 'c47bf03e-0f39-d39a-e747-438dfb3f6a35', '7f281512-f478-c01d-bd68-438dfb8e94ef', '2005-11-30 19:21:35', 0);
INSERT INTO accounts_contacts VALUES ('21f30f39-293d-bb80-2617-438dfb624ce3', '8ae00f66-bca9-0e92-9425-438dfb778642', 'd7b2d1e3-13e2-0239-45f8-438dfb71d950', '2005-11-30 19:21:36', 0);
INSERT INTO accounts_contacts VALUES ('5aa83daf-ae97-d5f2-3b6c-438dfb1d7f85', '59070258-441a-dd89-ae16-438dfb0c6de5', '13732b70-8431-4e65-826e-438dfbc8b6b9', '2005-11-30 19:21:36', 0);
INSERT INTO accounts_contacts VALUES ('b623146e-2260-d623-8cc8-438dfbaf0f92', 'b48c8890-69f2-da7a-f32b-438dfb708928', '6c574e51-9fc9-902c-bb97-438dfb3d4859', '2005-11-30 19:21:36', 0);
INSERT INTO accounts_contacts VALUES ('e635a02d-4753-c484-dbc1-438dfb280538', 'e48346ac-4bd5-2f4e-355c-438dfb777c61', 'c76da14e-ad51-81c1-dc28-438dfb72b7c5', '2005-11-30 19:21:36', 0);
INSERT INTO accounts_contacts VALUES ('36b59fdc-080b-dcf4-23ff-438dfb835bef', '351bd9a4-d3b2-d68f-df5e-438dfb5f7e5f', '3644006f-4f8d-5c21-276a-438dfb9dcb96', '2005-11-30 19:21:37', 0);
INSERT INTO accounts_contacts VALUES ('92d9bfc1-ebd5-0357-a9d1-438dfb8c73f1', '91362642-c0f4-ad62-0188-438dfb137389', '4812da65-b53f-1751-8610-438dfbb4962b', '2005-11-30 19:21:37', 0);
INSERT INTO accounts_contacts VALUES ('ee6c9b19-6439-f0ae-497f-438dfbd9d417', 'ecc2db88-50e6-ba48-6ddc-438dfb68fbb7', 'a5388d7b-fcfd-a575-9e4d-438dfb967005', '2005-11-30 19:21:37', 0);
INSERT INTO accounts_contacts VALUES ('2b7887b0-4349-9250-bb06-438dfbe7fbbe', '29d5012e-68f1-aedc-30ec-438dfbaeb0ff', 'c1400045-4d2d-7fdf-4a95-438dfbbc7abf', '2005-11-30 19:21:38', 0);
INSERT INTO accounts_contacts VALUES ('5ca63bf8-94bb-9c38-01b4-438dfbbdbf10', '5afdf11d-f2fe-1e8a-9137-438dfb7b6dd7', '3d28e556-d760-cce4-1c6e-438dfb740e75', '2005-11-30 19:21:38', 0);
INSERT INTO accounts_contacts VALUES ('a5e35901-8461-100d-adb7-438dfbc4c8e2', 'a43e6d97-0c51-6907-6d68-438dfb32cdfc', '6ea925d0-f283-ae03-e457-438dfbf5c7c2', '2005-11-30 19:21:38', 0);
INSERT INTO accounts_contacts VALUES ('22949bd2-13bf-397c-b023-438dfb175dba', '20c99390-ee1a-ffe9-672d-438dfb6e71ba', 'b7f0204d-c5da-0bac-fb1f-438dfbab43a1', '2005-11-30 19:21:39', 0);
INSERT INTO accounts_contacts VALUES ('5311d755-8eb6-5fa2-2eb9-438dfbb12db9', '5166e954-0646-7926-e954-438dfb36ec3d', '34348439-2f14-69b5-9373-438dfb8feeee', '2005-11-30 19:21:39', 0);
INSERT INTO accounts_contacts VALUES ('b0491ffc-12b5-c480-7832-438dfb8303d4', 'ae9ac46e-20d6-e2e0-3213-438dfbaad8d3', '647cf0ab-fc93-d5d6-357f-438dfb507848', '2005-11-30 19:21:39', 0);
INSERT INTO accounts_contacts VALUES ('1c8e0180-a0a9-732e-1abe-438dfbc1910c', '32f00a84-2dc8-013f-12fe-438dfb3e4592', 'c1c8000d-1b0e-79b7-b29a-438dfb14fa50', '2005-11-30 19:21:40', 0);
INSERT INTO accounts_contacts VALUES ('5cf10fe8-240e-e61c-5bc6-438dfb47fc4b', '5b4c15a1-72f4-7359-7a6d-438dfb258ac3', '135ff079-16c6-0b0b-4f55-438dfbf9fbef', '2005-11-30 19:21:40', 0);
INSERT INTO accounts_contacts VALUES ('bacec183-30c6-8d57-a72c-438dfb7a9432', 'b9286664-5119-e1b7-b201-438dfbb54f64', '6e8e2660-d6e8-bb25-5cf3-438dfb4910ff', '2005-11-30 19:21:40', 0);
INSERT INTO accounts_contacts VALUES ('eb33c1cd-648a-830d-b639-438dfb4ba2fb', 'e99e69c9-59bf-5b07-e8fb-438dfb4d3227', 'cc37afac-d26c-7be4-dac5-438dfb6cf69d', '2005-11-30 19:21:40', 0);
INSERT INTO accounts_contacts VALUES ('27238c2a-2925-70ae-2eba-438dfbb50232', '2589c2fc-695b-614f-3488-438dfb19204c', '8512079f-f956-4a23-8a37-438dfbb02101', '2005-11-30 19:21:41', 0);
INSERT INTO accounts_contacts VALUES ('575ed1c1-c75a-b034-79df-438dfbcd2008', '55d4a0e8-4b62-3414-47eb-438dfb88219a', '38843ba3-2413-4dcb-c56d-438dfbb925ee', '2005-11-30 19:21:41', 0);
INSERT INTO accounts_contacts VALUES ('e1ee2861-1cf1-7402-1503-438dfb8c2b61', 'e0489c04-4362-a4aa-8b77-438dfb917639', '68dd5109-aad1-d62f-b4ac-438dfb484563', '2005-11-30 19:21:41', 0);
INSERT INTO accounts_contacts VALUES ('340114f7-62ee-09c4-f586-438dfba1fdaa', '326e0b1a-bd5b-803f-0c2a-438dfb4092bd', 'f355358b-92a4-c9c0-9890-438dfb4cbd09', '2005-11-30 19:21:42', 0);
INSERT INTO accounts_contacts VALUES ('647d01e6-fdda-a348-20c4-438dfbb5115d', '62eea08c-9c71-5c87-21c3-438dfba3d06b', '45676a3b-9212-eee8-5971-438dfb7f3881', '2005-11-30 19:21:42', 0);
INSERT INTO accounts_contacts VALUES ('d9abf83a-b5bf-30f5-c161-438dfbd05b40', 'c1cbf81a-8d02-8dd0-dfdc-438dfb13ad6a', '785db1b9-b296-52c9-900a-438dfbeaeace', '2005-11-30 19:21:42', 0);
INSERT INTO accounts_contacts VALUES ('16177a4f-1600-774d-65e7-438dfbbc372c', '14888954-203b-78a5-78d1-438dfb219a9b', 'eb362250-759c-9ba0-ae66-438dfb65e251', '2005-11-30 19:21:43', 0);
INSERT INTO accounts_contacts VALUES ('5c9f560b-1f37-5b1c-aa3c-438dfb04722f', '5b0ffecc-4804-19c4-2576-438dfbbdfecb', '27795a7a-69be-075d-3a2b-438dfb625195', '2005-11-30 19:21:43', 0);
INSERT INTO accounts_contacts VALUES ('a62e72da-96aa-eb76-e204-438dfb6f78b7', 'a4a027eb-edd5-c1a1-ec53-438dfb4a3f6b', '87412abc-b1d1-2243-4493-438dfb1387a5', '2005-11-30 19:21:43', 0);
INSERT INTO accounts_contacts VALUES ('ed8510cc-893b-b86b-30db-438dfb3d0bbd', 'ebf84d8e-0737-a4e1-ae5b-438dfba45631', 'b7a00e4f-c220-5842-62dd-438dfb9c5da2', '2005-11-30 19:21:43', 0);
INSERT INTO accounts_contacts VALUES ('29a0fe6b-77b7-e81d-4164-438dfb4dd2bf', '28108460-b8af-4e66-dd01-438dfbac92cc', 'abf606cb-985d-df3b-31d3-438dfb244337', '2005-11-30 19:21:44', 0);
INSERT INTO accounts_contacts VALUES ('89bd0cdc-5c4d-2ebc-725e-438dfb6cdac3', '881c3e57-8f17-7384-43b8-438dfbf9ccdc', '3b08a4cf-21d7-9a7b-a902-438dfb3bb829', '2005-11-30 19:21:44', 0);
INSERT INTO accounts_contacts VALUES ('ba003caa-03d4-613e-9e41-438dfb10c68d', 'b86b7017-bffd-ba61-3170-438dfb219307', '9b38016e-c8c4-fd77-e640-438dfba26384', '2005-11-30 19:21:44', 0);
INSERT INTO accounts_contacts VALUES ('ea5ad7d0-aa20-362f-3a7e-438dfb7fccc0', 'e8cf1e36-908b-5862-f8a8-438dfb8ccde5', 'cb9c933f-85ae-e605-63f7-438dfbe24a0b', '2005-11-30 19:21:44', 0);
INSERT INTO accounts_contacts VALUES ('266a70b1-f198-52e4-9abb-438dfb77c02a', '24dd8f9d-2dc1-c3e7-69a6-438dfbc1cc4b', '79380c9a-6503-7414-02f4-438dfbd217e4', '2005-11-30 19:21:45', 0);
INSERT INTO accounts_contacts VALUES ('9df665ff-a44b-209c-75a2-438dfb3e7d53', '9c61e845-eb88-7bc8-0bcd-438dfb6b524e', '37b7f271-1f25-cd1f-44bc-438dfbf47e45', '2005-11-30 19:21:45', 0);
INSERT INTO accounts_contacts VALUES ('1f9d9041-f8ae-b9aa-3bc4-438dfb1ffc5b', '1dfc723b-c827-2f2e-0900-438dfbdcaa05', 'af580786-dc85-f4b7-3643-438dfb894439', '2005-11-30 19:21:46', 0);
INSERT INTO accounts_contacts VALUES ('500225ac-5af4-44fd-0f66-438dfb4ad1c0', '4e5a42b8-683a-6576-1265-438dfbab780b', '3124580f-664b-4103-ef3e-438dfb1904b1', '2005-11-30 19:21:46', 0);
INSERT INTO accounts_contacts VALUES ('82ef0620-c060-51cc-0244-438dfbede16e', '8157d20e-3c8d-b38e-2f52-438dfb6a870f', '6196bb05-c4fe-c086-55ca-438dfbe61361', '2005-11-30 19:21:46', 0);
INSERT INTO accounts_contacts VALUES ('e1d290ae-7a6b-1d4f-10da-438dfb26fc61', 'e041ac62-855e-20d9-bb5a-438dfb9a6c93', '94482729-93a9-c5c2-ac96-438dfb62fd32', '2005-11-30 19:21:46', 0);
INSERT INTO accounts_contacts VALUES ('3548a7d8-1e4a-d8f7-6ef4-438dfb7d7af8', '33b9afff-b44a-b0a7-adce-438dfbfe2a30', 'f34f0288-6e50-49a1-3087-438dfb21818a', '2005-11-30 19:21:47', 0);
INSERT INTO accounts_contacts VALUES ('7fe5206c-254f-7e12-2957-438dfb6e1ce3', '7e513885-8410-5d59-c0c8-438dfbfdec91', '46af97b1-278e-a1b7-6f9a-438dfb57c0ec', '2005-11-30 19:21:47', 0);
INSERT INTO accounts_contacts VALUES ('c7b5e162-c3b9-b685-34a6-438dfbf5b911', 'c6275cc1-e87a-9089-5779-438dfb09a475', '91606de9-ecc7-35f6-9f44-438dfb189f7d', '2005-11-30 19:21:47', 0);
INSERT INTO accounts_contacts VALUES ('333728f9-2a01-e280-d371-438dfbfceab6', '319abfaa-8fbd-85e8-5972-438dfbf6894b', 'd95a7a99-170c-499e-428e-438dfb361dce', '2005-11-30 19:21:48', 0);
INSERT INTO accounts_contacts VALUES ('954e4c1b-6b1a-a014-9f20-438dfbd3d16b', '93c0bbca-072e-c32a-6723-438dfb087d07', '7427f840-c2c9-d834-f101-438dfb56c870', '2005-11-30 19:21:48', 0);
INSERT INTO accounts_contacts VALUES ('c5fae370-1b4f-6080-1fb0-438dfb80ec0d', 'c4645f8d-d7f3-671e-3efa-438dfb5b4711', 'a6d286c3-ebd0-936e-7eda-438dfbc6f7fe', '2005-11-30 19:21:48', 0);
INSERT INTO accounts_contacts VALUES ('1cfb06c4-370e-ce7b-e526-438dfb5d1ae1', '1b7103e9-a3b4-7edf-a46c-438dfb3f9412', 'd8298c3a-2e00-563b-0bae-438dfb77a99a', '2005-11-30 19:21:49', 0);
INSERT INTO accounts_contacts VALUES ('653991a7-7883-81ef-a79a-438dfbd4c61a', '63a23180-ac3f-e4f9-2311-438dfbaebb8c', '2e58254c-eae7-84c9-3019-438dfba6f7c4', '2005-11-30 19:21:49', 0);
INSERT INTO accounts_contacts VALUES ('b009e73d-895f-e2eb-efb3-438dfbf949de', 'ae7aa2d3-5a31-a2b8-42ce-438dfbd4bbe4', '79453030-58ba-a4c2-fb42-438dfb5babf3', '2005-11-30 19:21:49', 0);
INSERT INTO accounts_contacts VALUES ('e022c9ab-7e41-7291-e650-438dfba1142e', 'de93d2d3-1ed4-f334-7001-438dfb24b595', 'c16881fb-499b-da86-1ad4-438dfb189086', '2005-11-30 19:21:49', 0);
INSERT INTO accounts_contacts VALUES ('1c2bdf90-59dd-d464-07a4-438dfbac994e', '1a9c9fdf-b080-337c-e85f-438dfb275861', 'f18bc447-43c2-7a4c-76a4-438dfb3b6210', '2005-11-30 19:21:50', 0);
INSERT INTO accounts_contacts VALUES ('982056b3-0d4b-2ae1-ce9c-438dfbd3540f', '96733ea1-ba91-ce6f-d2e4-438dfbe4c71b', '2d6eeb58-8ed8-ffa5-00c1-438dfb302163', '2005-11-30 19:21:50', 0);
INSERT INTO accounts_contacts VALUES ('ca23566f-0b0f-d931-7801-438dfba25335', 'c88a0811-e3d1-674c-5386-438dfb3ec160', 'aa07e3e9-14d4-7ea5-0364-438dfb423b85', '2005-11-30 19:21:50', 0);
INSERT INTO accounts_contacts VALUES ('38e615f1-257a-bfdd-3ed6-438dfb0a9f94', '37549e2f-ed07-091d-4f17-438dfb8c3077', 'dc32d1a7-baa7-4ddc-ad19-438dfb2b4fd8', '2005-11-30 19:21:51', 0);
INSERT INTO accounts_contacts VALUES ('6bad1fdd-799d-c508-7ca3-438dfb41a294', '69ffb1ab-208e-4947-14ec-438dfb152a0b', '4bd4969c-6b43-e0dc-efc5-438dfbfebe9b', '2005-11-30 19:21:51', 0);
INSERT INTO accounts_contacts VALUES ('9fabae21-254c-efc8-560a-438dfb2eef89', '9e0ae308-100f-e8cf-3aeb-438dfbf747d9', '8020ee80-2bc1-61ee-2d0c-438dfb47ffc7', '2005-11-30 19:21:51', 0);
INSERT INTO accounts_contacts VALUES ('ea124983-c27b-311b-28f2-438dfbfe1d80', 'e86211ac-4d63-a5f6-998c-438dfb4d3908', 'b15df275-d23f-d4e7-5c0b-438dfb6f426e', '2005-11-30 19:21:51', 0);
INSERT INTO accounts_contacts VALUES ('3f54fe20-09a2-a1a0-32c3-438dfb54d73b', '3db177be-8fc5-658f-81e7-438dfb277687', '76fd063d-d3b5-5a36-cc8e-438dfbea1f29', '2005-11-30 19:21:52', 0);
INSERT INTO accounts_contacts VALUES ('8b6b31a8-d1fc-acf5-1cfb-438dfb5e2551', '89c63bfa-81e2-cc7d-c689-438dfb9f7b0e', '509dc2bc-855f-8229-e87d-438dfb3ee35f', '2005-11-30 19:21:52', 0);
INSERT INTO accounts_contacts VALUES ('edee8005-1ea5-f1e0-5947-438dfb775895', 'ec5947a9-4a43-f0c6-f086-438dfbd42e9d', '9cde617d-0978-99e0-4aae-438dfbc944bf', '2005-11-30 19:21:52', 0);
INSERT INTO accounts_contacts VALUES ('2a2e9a1c-433e-0973-2351-438dfb3dc093', '289d6108-eed3-9a4b-5ff3-438dfb3fc47e', 'b26006b3-c1e1-78bf-41e3-438dfbb3abc9', '2005-11-30 19:21:53', 0);
INSERT INTO accounts_contacts VALUES ('73a60058-fd52-22ba-7b7a-438dfb03df01', '7215bb16-bb2a-e729-a89f-438dfb114cb2', '3b976dba-9c67-c85c-1b46-438dfb6e2b10', '2005-11-30 19:21:53', 0);
INSERT INTO accounts_contacts VALUES ('a6751452-c598-d22a-aa98-438dfbf577e8', 'a4ddb613-e5d4-9fa9-69e9-438dfbf89032', '87997809-5094-024a-2814-438dfbaf7d3e', '2005-11-30 19:21:53', 0);
INSERT INTO accounts_contacts VALUES ('d743f6e3-40d1-6b9b-00a6-438dfb0899fd', 'd59eccaf-177a-bd0c-fabd-438dfb2f2b48', 'b7f3e4ed-f834-8e31-5f4d-438dfb359ed2', '2005-11-30 19:21:53', 0);
INSERT INTO accounts_contacts VALUES ('601ee537-69dd-0918-67c4-438dfb434b15', '5e69fa07-890b-26c1-ed45-438dfbf1ba9d', 'e8e59f02-1eed-27d0-6d7e-438dfba9d868', '2005-11-30 19:21:54', 0);
INSERT INTO accounts_contacts VALUES ('933012f9-ef9d-cddb-a795-438dfb3845f0', '9195a8f2-3f5c-c1e6-65e8-438dfbb16254', '71c71ca8-8151-f6db-5da4-438dfb255755', '2005-11-30 19:21:54', 0);
INSERT INTO accounts_contacts VALUES ('dd322d27-cf6a-606c-6117-438dfb598164', 'db94eb9c-efcb-634d-10ce-438dfbccd3cc', 'a4a3717a-c2d5-691b-c4e2-438dfbb87573', '2005-11-30 19:21:54', 0);
INSERT INTO accounts_contacts VALUES ('331ec809-ed14-31f2-c2b9-438dfb86e250', '318e815f-392a-3581-ab95-438dfb92c042', 'eeaabf09-d964-c5dc-639d-438dfbccad87', '2005-11-30 19:21:55', 0);
INSERT INTO accounts_contacts VALUES ('80186478-bcb4-eebf-d750-438dfbfd958a', '7e85945e-f5da-6266-9fba-438dfbb1f1bf', '449cf514-d107-bf13-e22d-438dfb6346c5', '2005-11-30 19:21:55', 0);
INSERT INTO accounts_contacts VALUES ('24527a15-b714-31d3-af40-438dfb37348c', '22ac87a9-328c-e321-02e5-438dfb8322c9', '9160e67c-7f47-05f8-1b62-438dfbb654a6', '2005-11-30 19:21:56', 0);
INSERT INTO accounts_contacts VALUES ('548e756c-3bfe-1e47-982c-438dfb6a7ec5', '52f6e3a3-1247-0670-fe95-438dfbf2dccc', '35b9c4e3-e670-d12b-dc94-438dfb3c3e70', '2005-11-30 19:21:56', 0);
INSERT INTO accounts_contacts VALUES ('a1993ad5-f0f7-2ed6-9412-438dfb58b850', '9ffff8c0-a470-5dd0-b5c4-438dfbd49356', '660a9106-4c87-1508-c45b-438dfb157396', '2005-11-30 19:21:56', 0);
INSERT INTO accounts_contacts VALUES ('125ebbcb-97ed-4f47-6d14-438dfbf0b9e0', '10b70f04-acf8-4a38-54c8-438dfbdff557', 'b2fe2a8c-729b-82ff-875d-438dfb786209', '2005-11-30 19:21:57', 0);
INSERT INTO accounts_contacts VALUES ('943331ea-14b2-ebec-93ec-438dfbb0b277', '928f8665-a811-875d-d688-438dfb3ce694', '23b45f1c-189f-1aff-e722-438dfbd23fb4', '2005-11-30 19:21:57', 0);
INSERT INTO accounts_contacts VALUES ('dead0535-4be4-5e57-2d2a-438dfb606b04', 'dd10ca84-2b2f-3077-3127-438dfba2a7ea', 'a594ad62-21e6-fe38-3ac1-438dfb6ab474', '2005-11-30 19:21:57', 0);
INSERT INTO accounts_contacts VALUES ('1b15a2cf-694a-44a3-62e5-438dfbfe30b2', '19775f67-6c73-87b0-abfe-438dfbe26612', 'f054b6dd-897a-65d2-95ef-438dfb80f3f6', '2005-11-30 19:21:58', 0);
INSERT INTO accounts_contacts VALUES ('4b9176d0-9def-f154-cb0d-438dfbda5991', '49f9b1be-1f45-af88-e315-438dfbedd97c', '2c8ed1d1-6cc4-05df-84d8-438dfbb6eb82', '2005-11-30 19:21:58', 0);
INSERT INTO accounts_contacts VALUES ('8432aed5-2e60-257c-9c57-438dfb15f406', '829afa58-7227-58c6-49fc-438dfb52c7b3', '60211e94-e474-918e-8c77-438dfb92d148', '2005-11-30 19:21:58', 0);
INSERT INTO accounts_contacts VALUES ('11668843-72bf-c43f-0186-438dfbf4bd74', 'fc0c0a3d-81b0-edb4-3ef1-438dfb98b640', '95939537-69ed-0569-349e-438dfb51b14d', '2005-11-30 19:21:59', 0);
INSERT INTO accounts_contacts VALUES ('41cc828b-38b7-7f28-d4ab-438dfb1737cd', '402a2a43-75ed-f69a-94df-438dfb9eb789', '22fda997-049c-6ff8-d2ac-438dfb8b8fe1', '2005-11-30 19:21:59', 0);
INSERT INTO accounts_contacts VALUES ('71d8a682-dee1-ec63-a3af-438dfb4dad2c', '703cb1c6-dc5e-ea03-e96d-438dfb6c9a07', '530cf751-bc28-78f8-9727-438dfbc5fce0', '2005-11-30 19:21:59', 0);
INSERT INTO accounts_contacts VALUES ('dacdff30-8607-3cf8-8c77-438dfb475438', 'be2b7cf1-5f71-b37a-ffda-438dfba6a272', '8606d7b7-fb12-5bc8-fcc8-438dfb8c13a6', '2005-11-30 19:21:59', 0);
INSERT INTO accounts_contacts VALUES ('32fb546f-731d-e570-c62d-438dfb683f21', '3161d160-3b14-d480-b56b-438dfbfb8e05', 'ec620ae9-1b97-e528-2707-438dfb142f20', '2005-11-30 19:22:00', 0);
INSERT INTO accounts_contacts VALUES ('9c37094e-4206-d661-2a4a-438dfb01b108', '9a9c94d7-5a1f-c63d-9ccc-438dfb4dc013', '44567144-d98c-55ff-600a-438dfb9b05e7', '2005-11-30 19:22:00', 0);
INSERT INTO accounts_contacts VALUES ('cc599533-57e1-6358-21ee-438dfb470d40', 'cac9e771-a4f6-4711-6a91-438dfb0a465b', 'ad9d4f16-4948-5b22-c2a5-438dfb42471c', '2005-11-30 19:22:00', 0);
INSERT INTO accounts_contacts VALUES ('3f8bdcca-8171-b069-e8c6-438dfbb5d910', '2270bf07-35a9-31ab-e5b8-438dfbbc1400', 'ddbbf86c-83d1-1323-7353-438dfb2cde8e', '2005-11-30 19:22:01', 0);
INSERT INTO accounts_contacts VALUES ('6fefce78-fc69-6612-d0b6-438dfb16f628', '6e5f3c74-086a-04fa-15c1-438dfbc15e98', '50f592cd-46e8-38ec-8bc4-438dfb69255a', '2005-11-30 19:22:01', 0);
INSERT INTO accounts_contacts VALUES ('be52ccc4-f71e-c951-c50c-438dfb198de6', 'bcbcfeb3-78e4-c2d2-df69-438dfb02aa8d', '83ebac8d-3061-b06e-e9c2-438dfbc1c1b7', '2005-11-30 19:22:01', 0);
INSERT INTO accounts_contacts VALUES ('ee85f241-97d3-81fb-b990-438dfbdc8d2c', 'ecf4702a-6f2e-50de-15ca-438dfb78ae0c', 'cfae570c-8617-1ed0-9552-438dfbbed9a1', '2005-11-30 19:22:01', 0);
INSERT INTO accounts_contacts VALUES ('61fee87e-df0d-78ee-426d-438dfb476f3f', '606caf60-b1bc-8ba8-2954-438dfbd67107', 'bd2e0f70-1ee0-114b-6b3f-438dfb7beaca', '2005-11-30 19:22:02', 0);
INSERT INTO accounts_contacts VALUES ('b10da5b1-1ea5-9c4f-4e5f-438dfbddaf12', 'af74599a-74d0-c570-4728-438dfb78321f', '73d068dc-4ebc-f503-320a-438dfbbe3b7e', '2005-11-30 19:22:02', 0);
INSERT INTO accounts_contacts VALUES ('929c0a69-6005-97b1-034d-438dfb092dba', '797504be-998c-71c0-3b7f-438dfb01a387', 'c25cd6b3-3646-b570-d9c9-438dfb849f55', '2005-11-30 19:22:03', 0);
INSERT INTO accounts_contacts VALUES ('39674ccc-a9c1-d0d9-fbcf-438dfb503f71', '37c53378-d432-bbdc-98de-438dfbbbe6e2', '1a933345-5bdc-a589-eb6d-438dfbf1c77c', '2005-11-30 19:22:03', 0);
INSERT INTO accounts_contacts VALUES ('8895d23a-07be-2099-2825-438dfb778941', '86e0e874-75b4-15ae-5725-438dfbadd5d3', '4ab47181-24ce-f863-8995-438dfb35ea06', '2005-11-30 19:22:03', 0);
INSERT INTO accounts_contacts VALUES ('d6a784ab-aa35-6a49-3223-438dfb03c479', 'd50db904-5e4f-d353-726b-438dfbbf6650', '9ad78299-6c72-66e4-74d1-438dfb8d9bcb', '2005-11-30 19:22:03', 0);
INSERT INTO accounts_contacts VALUES ('4d0eac92-1f7e-4dec-b2e3-438dfb2403e6', '4b6b6548-8ff0-5d0f-7fad-438dfb99072f', 'e85ffc5b-c699-2dbd-c014-438dfbaf09a1', '2005-11-30 19:22:04', 0);
INSERT INTO accounts_contacts VALUES ('9da81804-c145-9cea-ded6-438dfb258443', '9c122c61-e559-b813-4103-438dfbe4ecd7', '5f03bf7a-fd7e-e9a7-db69-438dfba8a354', '2005-11-30 19:22:04', 0);
INSERT INTO accounts_contacts VALUES ('ebd8e8ba-1763-8aa7-f12c-438dfb7370e3', 'ea2ee7ba-7dd5-959b-b577-438dfbef096e', 'af8cf563-7e1e-cbda-c837-438dfba030fb', '2005-11-30 19:22:04', 0);
INSERT INTO accounts_contacts VALUES ('458f7594-3d57-3c78-7178-438dfb43fd55', '43eeb21c-c93f-c150-2716-438dfb0289a6', '98c806a1-600c-08bb-697c-438dfbc8eb58', '2005-11-30 19:22:05', 0);
INSERT INTO accounts_contacts VALUES ('ced2b813-1b4a-2229-aa20-438dfb11139f', 'cd29045d-c4cf-6807-e70a-438dfbe5680f', '571ba74f-afdf-9159-0899-438dfb3eb14d', '2005-11-30 19:22:05', 0);
INSERT INTO accounts_contacts VALUES ('814d819c-4b21-d58c-6e03-438dfbfe4098', '7f6a8cec-2988-639d-46c3-438dfb567162', 'e0418399-719d-3607-9e7f-438dfb72fae9', '2005-11-30 19:22:06', 0);
INSERT INTO accounts_contacts VALUES ('ce440f9e-909d-78a9-821c-438dfb4ffd99', 'ccb60f42-0987-a640-093e-438dfbc36217', '92ab49c9-ee9b-e5d2-43d8-438dfb969816', '2005-11-30 19:22:06', 0);
INSERT INTO accounts_contacts VALUES ('a3cc0c0f-f135-452a-52eb-438dfbd98e21', '89df0c3b-c3d4-5963-1ad6-438dfb0873b8', 'df7de535-ff70-7af4-cb91-438dfbc9af09', '2005-11-30 19:22:07', 0);
INSERT INTO accounts_contacts VALUES ('944745c5-d01e-66f7-8063-438dfbaad629', '92b8b64b-06f2-396c-e156-438dfbb0dccb', '1bb1c78c-3ccd-b176-be2b-438dfb317c0e', '2005-11-30 19:22:07', 0);
INSERT INTO accounts_contacts VALUES ('e16c28e8-a61a-69f1-d520-438dfbaab888', 'dfdc405f-9153-50f9-44d3-438dfbf7cd6e', 'a5b8eb90-51f1-e1ff-ad22-438dfb208ceb', '2005-11-30 19:22:07', 0);
INSERT INTO accounts_contacts VALUES ('3ab49d58-b41c-d70c-0264-438dfb3a444a', '3919615a-a53b-190c-94b7-438dfb617976', 'f2df2e86-0c13-c5ba-c500-438dfb56c033', '2005-11-30 19:22:08', 0);
INSERT INTO accounts_contacts VALUES ('8abcd0c8-3962-7a42-9f84-438dfb63106c', '8927ebd4-87e9-1a4d-ff74-438dfbe89fc9', '4c13abc6-b8e1-c1ae-8ba7-438dfb9ec64a', '2005-11-30 19:22:08', 0);
INSERT INTO accounts_contacts VALUES ('bad08033-9ce4-31c0-73f6-438dfb8c7f1b', 'b9362ff7-0d55-b46e-4b08-438dfb663f12', '9c1b9f81-bfac-e57b-5ffe-438dfb441499', '2005-11-30 19:22:08', 0);
INSERT INTO accounts_contacts VALUES ('149bd420-5175-60de-a1c7-438dfba842d9', '12c375c1-be90-45bf-3bdd-438dfbf1deb3', 'cc387178-6c46-a15a-2fe6-438dfb374c74', '2005-11-30 19:22:09', 0);
INSERT INTO accounts_contacts VALUES ('8343cf78-5009-9549-b5a1-438dfbe4f624', '8166a64a-4a81-06ae-b1b0-438dfb814a57', '268fd281-bad6-2ceb-8bbc-438dfb22fc8c', '2005-11-30 19:22:09', 0);
INSERT INTO accounts_contacts VALUES ('b34f6b44-c4ff-c453-8cb2-438dfb0f717e', 'b1bf390c-6fe1-a333-237d-438dfb28671c', '94982e2e-3f66-9441-e92b-438dfbddd2e5', '2005-11-30 19:22:09', 0);
INSERT INTO accounts_contacts VALUES ('cd7503a9-6017-2a04-a666-438dfb33eff1', 'b4570356-f8fa-7915-632a-438dfb3d6edb', 'c4aedb48-1af4-dc3f-f3c7-438dfb1a48c0', '2005-11-30 19:22:10', 0);
INSERT INTO accounts_contacts VALUES ('9925558f-e1ee-ee43-0eae-438dfb2a8fb4', '97783bed-965b-277b-b690-438dfb372d6d', '1e63f0f0-a1bb-ec9b-b3b8-438dfbc720ee', '2005-11-30 19:22:10', 0);
INSERT INTO accounts_contacts VALUES ('c961e8bf-a275-a857-3be2-438dfb331126', 'c7c317ca-4a0f-64f1-b509-438dfba328c1', 'aa8b2195-f958-e7d7-9ddb-438dfb8ebf80', '2005-11-30 19:22:10', 0);
INSERT INTO accounts_contacts VALUES ('58e50043-dbab-b472-968f-438dfb94c13e', '3eef09e2-000e-be9e-84a3-438dfbeeec35', 'daaf0fbd-ade6-d9bd-38ce-438dfbb8b158', '2005-11-30 19:22:11', 0);
INSERT INTO accounts_contacts VALUES ('7222351a-7e4c-5a60-3421-438dfbe686d4', '708cfcf3-b44f-22fd-3cee-438dfbf573b7', '16ede1f8-2014-d5da-74e5-438dfba39ec3', '2005-11-30 19:22:11', 0);
INSERT INTO accounts_contacts VALUES ('b50e0fc1-010d-d9d0-6b78-438dfbef39a2', '9ab907e9-70e5-b254-b72c-438dfbd91f9e', '863ce0cb-c3b2-a2e2-3c24-438dfb60a8fd', '2005-11-30 19:22:12', 0);
INSERT INTO accounts_contacts VALUES ('3bcb7a59-73de-a840-afe3-438dfbe159f4', '3a31f343-b3a2-25aa-0aef-438dfb275b9a', '1d21fa61-f1ec-b3c3-108d-438dfbc1ba7c', '2005-11-30 19:22:12', 0);
INSERT INTO accounts_contacts VALUES ('8da971ab-95f7-f98a-37ba-438dfb0d59c3', '8c063ab3-792e-7fff-07af-438dfb362e9f', '4d1789b7-3e5c-005c-5bc6-438dfb48ed0c', '2005-11-30 19:22:12', 0);
INSERT INTO accounts_contacts VALUES ('bdb8d457-0584-dab3-8183-438dfb4c6950', 'bc19f618-92f4-0b25-6b19-438dfbf0e871', '9ef17cae-5cff-52f2-b8f6-438dfb8a9336', '2005-11-30 19:22:12', 0);
INSERT INTO accounts_contacts VALUES ('184405a7-59f3-c561-3a5f-438dfb027fa2', '16afe3ef-bc1f-03f2-f3f0-438dfb6e0815', 'cf131d8b-9fe6-7663-f52f-438dfb9b02c6', '2005-11-30 19:22:13', 0);
INSERT INTO accounts_contacts VALUES ('48432895-5ecb-bf4c-a513-438dfb95782a', '46b45f58-1096-ed96-a304-438dfb18ae25', '29836014-3a39-deac-1cd1-438dfbac8ab2', '2005-11-30 19:22:13', 0);
INSERT INTO accounts_contacts VALUES ('999f681e-8513-5ed5-3370-438dfbe6b8ab', '980111c7-e70c-063a-0af2-438dfb7c608c', '5998aee4-86a3-263e-e38c-438dfb952cd8', '2005-11-30 19:22:13', 0);
INSERT INTO accounts_contacts VALUES ('ca25be66-3ea0-3c8a-4713-438dfb9911e0', 'c88932f9-755e-1bb3-389a-438dfbd73ab7', 'ab04e4f7-4808-7a3a-9d6a-438dfb8750ef', '2005-11-30 19:22:13', 0);
INSERT INTO accounts_contacts VALUES ('45c39131-c55f-0d11-5f62-438dfb254c10', '442abb64-0987-618a-4a53-438dfb615010', 'dc9c513e-6661-d1ce-f317-438dfb5c6d58', '2005-11-30 19:22:14', 0);
INSERT INTO accounts_contacts VALUES ('7609ea3d-ddfc-08e7-1033-438dfb842080', '7463343b-f16b-e43a-a354-438dfb3db275', '571e34d2-5904-1c4e-fb8e-438dfbddf351', '2005-11-30 19:22:14', 0);
INSERT INTO accounts_contacts VALUES ('c803379b-3d69-e994-c28c-438dfb8113a1', 'c65ca740-d010-521a-49aa-438dfb244146', '8a079568-e82a-9f09-d3d4-438dfb37c239', '2005-11-30 19:22:14', 0);
INSERT INTO accounts_contacts VALUES ('3f160c95-2935-e353-5173-438dfb8b1049', '25c20011-2a71-ca47-8fb9-438dfb51c6fd', 'd94d9c49-9e7e-6f02-e077-438dfb93f40f', '2005-11-30 19:22:15', 0);
INSERT INTO accounts_contacts VALUES ('34ac0523-6f44-3b00-da27-438dfb86a8ac', '33104df4-d49d-982b-4a73-438dfb045c7d', '1567c52a-c9fa-8585-e646-438dfb66bda9', '2005-11-30 19:22:15', 0);
INSERT INTO accounts_contacts VALUES ('64c7f19c-7162-fc65-60b6-438dfbc5a248', '6326c466-c2e9-884e-edeb-438dfb8010f7', '460a8351-5516-8efa-cc7e-438dfb3ec28b', '2005-11-30 19:22:15', 0);
INSERT INTO accounts_contacts VALUES ('b707f3d3-1a8f-7491-a6e7-438dfb317a9d', 'b574b4c8-14e1-18a4-76a8-438dfb9df297', '7668abc9-efc4-f8c6-4968-438dfb4d1ecc', '2005-11-30 19:22:15', 0);
INSERT INTO accounts_contacts VALUES ('e72df3e5-6c2c-da8c-2eb4-438dfb670982', 'e593b266-01fb-266e-e2b6-438dfb280b05', 'c8788aba-6a1e-c258-caf7-438dfb46e44a', '2005-11-30 19:22:15', 0);
INSERT INTO accounts_contacts VALUES ('42e74972-bfc0-93d0-80a3-438dfb299e74', '4154083b-0c05-6ab8-b939-438dfbe58e6f', '477701eb-6645-9ccb-33d7-438dfb7ba579', '2005-11-30 19:22:16', 0);
INSERT INTO accounts_contacts VALUES ('d5160381-d62e-3061-b2e4-438dfbd0a435', 'd370e5dd-5063-f8c6-a75a-438dfb26fe34', '543e70ac-6e33-8917-5565-438dfb360fb5', '2005-11-30 19:22:16', 0);
INSERT INTO accounts_contacts VALUES ('328d1c11-61be-c3f0-fb93-438dfb45aaea', '30f41350-9956-1865-9628-438dfbedc29e', 'e75c3ecb-99f2-dadf-5d15-438dfbf076d3', '2005-11-30 19:22:17', 0);
INSERT INTO accounts_contacts VALUES ('86414e05-c31c-e8a7-6951-438dfba6c0ff', '84acd2eb-c778-68c8-99f4-438dfbde5383', '443cbfd7-d176-1227-049b-438dfb1483d1', '2005-11-30 19:22:17', 0);
INSERT INTO accounts_contacts VALUES ('d7a3cce7-f080-0a6c-0d47-438dfb701b3d', 'd6091bdc-caa6-6316-6377-438dfb95cb5a', '981fe79f-b6ca-8f21-c19c-438dfb4c4ebe', '2005-11-30 19:22:17', 0);
INSERT INTO accounts_contacts VALUES ('14e94c49-f108-02f0-30e9-438dfbe4ec11', '1340ac91-ddc2-fb82-4022-438dfba0e98e', 'e969de4c-f3b5-0f2e-b5ac-438dfbeb1d30', '2005-11-30 19:22:18', 0);
INSERT INTO accounts_contacts VALUES ('46471b34-63a9-0470-e6b9-438dfb306ab3', '44a73d5b-41d6-d55e-e52a-438dfb042ad1', '26d4ce17-e466-3006-20f2-438dfb6b462a', '2005-11-30 19:22:18', 0);
INSERT INTO accounts_contacts VALUES ('768907aa-8b34-377e-2ab5-438dfb18a25e', '74e62010-41ef-111b-9225-438dfb5ccf30', '579dad95-4140-81fe-b554-438dfb1a04c7', '2005-11-30 19:22:18', 0);
INSERT INTO accounts_contacts VALUES ('a90ed4b8-c61a-03ff-4f8e-438dfbfe83c8', 'a77ae199-7870-dda3-c992-438dfb83f576', '8a6dd188-d156-8ec3-3281-438dfba5aeaf', '2005-11-30 19:22:18', 0);
INSERT INTO accounts_contacts VALUES ('646002b5-4189-4c73-efdc-438dfbda744d', '4b520c3f-b00a-d07a-c5d4-438dfb818be4', 'ba82c3c4-e4ec-b757-fa28-438dfbd013aa', '2005-11-30 19:22:19', 0);
INSERT INTO accounts_contacts VALUES ('57d38dea-e8de-0dde-2993-438dfbcc0955', '56391242-a684-5821-0476-438dfb07b70e', '17d4f4fb-a181-0c9b-821a-438dfbffc092', '2005-11-30 19:22:19', 0);
INSERT INTO accounts_contacts VALUES ('cc44baaf-9611-5542-d144-438dfb4f384e', 'cab00ff7-dfed-24be-5782-438dfbbfcc29', '69938c8b-9b0b-4890-abe3-438dfb85413f', '2005-11-30 19:22:19', 0);
INSERT INTO accounts_contacts VALUES ('49a15ce8-76e1-e49a-9f8e-438dfb07539f', '4801d31d-31c4-2b7b-f0a2-438dfbc06eb7', 'a3e600ee-970a-cee2-8b37-438dfbca1077', '2005-11-30 19:22:20', 0);
INSERT INTO accounts_contacts VALUES ('de7ec5ea-cd38-498b-dd4b-438dfb9b53a1', 'dcda72bb-1e05-90a2-5fd3-438dfb5dd8b4', '9f11ccea-052b-e25c-6624-438dfb271b6e', '2005-11-30 19:22:20', 0);
INSERT INTO accounts_contacts VALUES ('1a8d390c-380c-bc9d-8364-438dfbcf5bef', '18f4ff09-a967-17c1-7336-438dfba49491', 'efe77bde-c437-665f-9060-438dfb780bc9', '2005-11-30 19:22:21', 0);
INSERT INTO accounts_contacts VALUES ('8f565831-0400-673d-6790-438dfb3b4dc7', '8dc56e36-e556-7985-bbe0-438dfbf14c5c', '6e0daa10-3e3b-58ad-c869-438dfbfedbd4', '2005-11-30 19:22:21', 0);
INSERT INTO accounts_contacts VALUES ('e07bf186-ad9a-33c6-d14e-438dfb8c6878', 'dee8db69-4d37-a95f-96b6-438dfbe70848', 'a0b9b02e-61de-5f22-07ed-438dfb253137', '2005-11-30 19:22:21', 0);
INSERT INTO accounts_contacts VALUES ('1c9a23c3-30fc-a4ad-0dfc-438dfb523b3a', '1b06ca73-cecc-2903-dca8-438dfbda1609', 'f1d43701-d60b-cd1a-e59e-438dfbc6cdb6', '2005-11-30 19:22:22', 0);
INSERT INTO accounts_contacts VALUES ('4c8a7570-2921-a8c5-474f-438dfb9a7a62', '4ae4ea6f-9a81-b631-313e-438dfb1617cb', '2dcaf8ac-1e3b-52e5-2f79-438dfb2abe72', '2005-11-30 19:22:22', 0);
INSERT INTO accounts_contacts VALUES ('c1c9876e-d533-dfcd-d164-438dfb4731fa', 'c02fd92a-56a7-ba19-2202-438dfbf6868e', '5df5e2e9-5db1-4193-bd90-438dfb97c738', '2005-11-30 19:22:22', 0);
INSERT INTO accounts_contacts VALUES ('f236f0e9-17d7-2c17-27d8-438dfb42634b', 'f09fdcd1-7e18-6d64-dd5b-438dfba6e8b1', 'd36355c8-e0d2-1427-3d27-438dfb8d905d', '2005-11-30 19:22:22', 0);
INSERT INTO accounts_contacts VALUES ('2e6bc788-c585-3fc2-7fd4-438dfbe3da5e', '2cd69e26-76d0-21ec-d73c-438dfb11891f', 'fa620e7e-59f5-1a0c-c09c-438dfb095eb5', '2005-11-30 19:22:23', 0);
INSERT INTO accounts_contacts VALUES ('5ec1297e-2067-090a-a9ff-438dfb1c1204', '5d2fb8ef-5010-3296-8d6b-438dfbea1cec', '3fe3554d-2b2d-aea4-8ef6-438dfb9dcb8f', '2005-11-30 19:22:23', 0);
INSERT INTO accounts_contacts VALUES ('d4d4475c-ee64-edd1-8949-438dfb3a1136', 'd3365996-38e7-fb88-1ae8-438dfbb39199', '703c1b7e-8570-46c2-7f7c-438dfbf84b5f', '2005-11-30 19:22:23', 0);
INSERT INTO accounts_contacts VALUES ('54a7942e-0aaa-4318-ccb6-438dfb01fa30', '52eb33ea-8a43-bb9d-7ac9-438dfb31378e', 'e6576172-75fb-f3d3-7b86-438dfb157db9', '2005-11-30 19:22:24', 0);
INSERT INTO accounts_contacts VALUES ('88c3d808-9cfa-7a5c-f786-438dfbf0c749', '86f027b4-2426-b87d-abb2-438dfbce9837', '66fa9906-6c40-fdf0-a2e1-438dfbfe512b', '2005-11-30 19:22:24', 0);
INSERT INTO accounts_contacts VALUES ('b97c865a-3fbf-a2cd-0705-438dfb11d714', 'b7df7728-4909-f3b5-c09f-438dfba69779', '9a1f12a5-9343-222f-e3e6-438dfb777755', '2005-11-30 19:22:24', 0);
INSERT INTO accounts_contacts VALUES ('1776ca3b-df64-4350-4e60-438dfb8e5c21', '15e38d79-df3b-68c5-44db-438dfbce45fc', 'cad99cf8-0af8-2048-a57a-438dfbdb0c2a', '2005-11-30 19:22:25', 0);
INSERT INTO accounts_contacts VALUES ('47743412-cc30-2c6e-9593-438dfb143dc7', '45e1dfdf-f9a0-fb55-ff83-438dfbec9ca1', '28db0226-8ff5-a194-6afd-438dfbd26c02', '2005-11-30 19:22:25', 0);
INSERT INTO accounts_contacts VALUES ('e0872f16-441e-d268-714e-438dfbe642be', '9aadf32e-a24b-f163-e070-438dfbc19e1d', '58e70e90-21d7-2d97-f046-438dfb7c28a5', '2005-11-30 19:22:25', 0);
INSERT INTO accounts_contacts VALUES ('3f1ab58d-f4b8-e1bb-807a-438dfbe2d343', '3d87d483-6d54-a315-b986-438dfb93ea7a', 'f1f9a52c-3d9f-93d1-3fec-438dfbc77c32', '2005-11-30 19:22:26', 0);
INSERT INTO accounts_contacts VALUES ('b6654dbe-e7c7-ed86-4e0e-438dfbfcb4d2', 'b4ce489c-c04f-0811-3a50-438dfb674f66', '508543b2-9c94-99cb-e595-438dfb2abb6d', '2005-11-30 19:22:26', 0);
INSERT INTO accounts_contacts VALUES ('e6b78825-ec55-59a3-81fb-438dfbb761df', 'e526a2da-9e25-d27c-d0a4-438dfb7ae3b9', 'c7d12a8d-0403-3ab7-a0e3-438dfb2d63d6', '2005-11-30 19:22:26', 0);
INSERT INTO accounts_contacts VALUES ('22e0008b-ee5d-ccc9-bc19-438dfb7e9ef6', '214776e5-3bcc-5374-2e09-438dfb778832', '40300bde-e741-a773-4a15-438dfbeee35a', '2005-11-30 19:22:27', 0);
INSERT INTO accounts_contacts VALUES ('be8f472e-ada8-6e28-2e49-438dfbd9459d', 'bcf4055c-e49c-3ba2-f46c-438dfbb06f47', '347267d1-c06e-b7b5-fa65-438dfb8e8dd4', '2005-11-30 19:22:27', 0);
INSERT INTO accounts_contacts VALUES ('6a74385f-4968-b349-4b72-438dfbbbb9c0', '68d4afd1-2c23-2687-4cc5-438dfbb2ab43', 'd7b82553-166f-c86f-4feb-438dfba34ec5', '2005-11-30 19:22:28', 0);
INSERT INTO accounts_contacts VALUES ('1190dae5-84b2-880c-3c4d-438dfbbb9352', 'fe0d0062-2e34-f6dc-060c-438dfb36afe3', '7be641b1-ecdd-a545-3bbf-438dfb50769a', '2005-11-30 19:22:29', 0);
INSERT INTO accounts_contacts VALUES ('6515d410-f91f-93e5-62d2-438dfb0dbde5', '6379dc29-6346-3bfa-fd15-438dfb8cb345', '22f4419a-563a-4a6f-ab54-438dfba24b49', '2005-11-30 19:22:29', 0);
INSERT INTO accounts_contacts VALUES ('bb218fa3-651f-c885-bb91-438dfb34f9a3', 'b9900f71-4f06-9c97-0369-438dfb0b6b90', '76e613b6-66dc-da59-7dc3-438dfb4fff7a', '2005-11-30 19:22:29', 0);
INSERT INTO accounts_contacts VALUES ('f0867b15-0dd4-c8de-392c-438dfb294042', 'eeee7ca9-c4f1-11d6-ae78-438dfb59a2ae', 'cc7d000d-19c9-bb48-44fe-438dfbef8917', '2005-11-30 19:22:29', 0);
INSERT INTO accounts_contacts VALUES ('74b769aa-93f0-4726-f8cb-438dfb77c732', '731379a5-71ea-d31b-c295-438dfb8b45bc', 'dcb5074e-614a-78ef-f0ab-438dfbd631ff', '2005-11-30 19:22:30', 0);
INSERT INTO accounts_contacts VALUES ('a8c5e569-1c7e-b548-7bf9-438dfbfa80f2', 'a72397ea-f813-c02a-95ca-438dfbfb91eb', '89475c72-6b72-9ca4-52f2-438dfbd736d1', '2005-11-30 19:22:30', 0);
INSERT INTO accounts_contacts VALUES ('da558667-4d60-71d2-ede6-438dfb4b0fb4', 'd8b0f146-1a91-13c0-3a72-438dfbde557f', 'baa43c5d-69de-a271-0c25-438dfb74fea8', '2005-11-30 19:22:30', 0);
INSERT INTO accounts_contacts VALUES ('a8a2e3ee-0549-4313-3771-438dfb462389', 'a6f9bf5b-0675-c0d6-e85f-438dfbdbd981', 'ec1efaef-ce0d-bb93-ebfe-438dfb73d939', '2005-11-30 19:22:31', 0);
INSERT INTO accounts_contacts VALUES ('da17155e-36a8-7986-e5e0-438dfb345f8d', 'd8767e81-c450-d545-ae63-438dfb4916ae', 'ba751781-d364-4a0d-5de6-438dfb165ad5', '2005-11-30 19:22:31', 0);
INSERT INTO accounts_contacts VALUES ('659a8a2e-616d-4bdb-316f-438dfbf2be3a', '63f58ccc-e492-8d89-0d6b-438dfba946ea', 'f1cfb3dd-1cb4-eeb4-60f4-438dfb0c1b12', '2005-11-30 19:22:32', 0);
INSERT INTO accounts_contacts VALUES ('98b5be16-9328-8ad6-9ee8-438dfb6c0d8e', '971d5ad3-a70b-db64-a717-438dfbdb260d', '77504603-324f-a0d3-a501-438dfbdf4697', '2005-11-30 19:22:32', 0);
INSERT INTO accounts_contacts VALUES ('1c99e192-1ffa-9c14-e1a0-438dfb7bebc7', '1ae50d23-8f86-8c43-1229-438dfb03f31c', 'aa1defb3-634a-3879-f66d-438dfb8513c3', '2005-11-30 19:22:33', 0);
INSERT INTO accounts_contacts VALUES ('710e1d76-6386-e05d-6a5b-438dfbecb8fb', '6f6acc46-a1ad-fe2c-b5a2-438dfb992013', '2dfe29c0-10b8-8b37-ef7c-438dfb8c33e1', '2005-11-30 19:22:33', 0);
INSERT INTO accounts_contacts VALUES ('c84c7320-1ba4-0229-ba1e-438dfbb44c6b', 'c6aabb4a-0296-4cea-df32-438dfbc0990a', '82c2ab66-d0ac-9766-3603-438dfb6fd1f5', '2005-11-30 19:22:33', 0);
INSERT INTO accounts_contacts VALUES ('288f9571-1518-dc6e-42ac-438dfbcdfa7b', '26ef8127-7d96-8b76-44c7-438dfb23530d', 'd99ac000-1591-f7d4-645b-438dfb9c52a9', '2005-11-30 19:22:34', 0);
INSERT INTO accounts_contacts VALUES ('58e5876e-dabb-d253-b557-438dfb9d2ea6', '5744b753-4a28-a8f3-28bb-438dfb2b912d', '39f27a0e-0400-fa81-07dd-438dfb57ce13', '2005-11-30 19:22:34', 0);
INSERT INTO accounts_contacts VALUES ('d527b114-d99a-9ee6-398b-438dfbb6be22', 'd379c12b-4710-241e-384e-438dfbbbd559', '6ad22ccc-c235-de00-80c7-438dfbeb8caf', '2005-11-30 19:22:34', 0);
INSERT INTO accounts_contacts VALUES ('59f0fcd8-5503-f302-b8d1-438dfb4deb68', '58542c90-1b49-7055-d17e-438dfbeada52', 'e69e09bd-23e8-b36b-3e3a-438dfbb1062d', '2005-11-30 19:22:35', 0);
INSERT INTO accounts_contacts VALUES ('b14ed1f2-fb6d-0c40-f1a8-438dfb19f653', 'afb57170-9d7e-91f2-409d-438dfbb5d79d', '6b7e6016-b265-3ba5-ff42-438dfb51a9ed', '2005-11-30 19:22:35', 0);
INSERT INTO accounts_contacts VALUES ('1209ddd7-2037-2329-930e-438dfb20a39c', '106a24d9-484d-89e5-2e8e-438dfbf3b6ef', 'c2bb3f7c-9af5-a61f-a3e2-438dfb7727a9', '2005-11-30 19:22:36', 0);
INSERT INTO accounts_contacts VALUES ('672d0ccf-bafa-99ba-ea41-438dfb111219', '65857415-903c-e84e-7a3a-438dfbb4ea4b', '239a9544-7bdd-167e-07bd-438dfb299c59', '2005-11-30 19:22:36', 0);
INSERT INTO accounts_contacts VALUES ('bf150fff-89ce-9aa5-cb3b-438dfb759a8d', 'bd7fc240-38d0-9a21-f408-438dfb78a7c8', '78ff9990-540c-dd40-27c5-438dfb183793', '2005-11-30 19:22:36', 0);
INSERT INTO accounts_contacts VALUES ('2016451f-033c-0b11-9288-438dfbb8d448', '1e8192ee-90f5-9e62-20fd-438dfbbd87c3', 'd0923769-e322-cf84-3521-438dfb84c9ca', '2005-11-30 19:22:37', 0);
INSERT INTO accounts_contacts VALUES ('756470ee-fd45-3bd9-f68d-438dfbdd32ea', '73d1ce48-38bb-fb39-125b-438dfbfcd535', '31737d1f-1289-7fcd-5d14-438dfbd580bb', '2005-11-30 19:22:37', 0);
INSERT INTO accounts_contacts VALUES ('22cb4b37-ab71-677c-d77e-438dfb34d928', '2120eaa3-e4ce-aac8-8282-438dfb13c9d5', '895cc6e7-0091-44a7-21a6-438dfb1d162e', '2005-11-30 19:22:38', 0);
INSERT INTO accounts_contacts VALUES ('ea06038b-9305-27f2-087d-438dfbc5b781', 'e85e5704-236d-95b0-c913-438dfbb27265', '343b349e-f4d2-005d-0269-438dfbc49cbb', '2005-11-30 19:22:38', 0);
INSERT INTO accounts_contacts VALUES ('27a1cc94-011c-f545-0274-438dfb6ef391', '26003f57-f147-1296-9b07-438dfbd54997', '867109fb-918b-35a3-7cfd-438dfb68d6ff', '2005-11-30 19:22:39', 0);
INSERT INTO accounts_contacts VALUES ('7e58c9fa-1243-eccd-f380-438dfb908cdc', '7cb9e579-5824-c66e-feaa-438dfbb13d76', '3931744b-5e96-d2da-5dd2-438dfb47595f', '2005-11-30 19:22:39', 0);
INSERT INTO accounts_contacts VALUES ('78c305bd-8c18-fabc-0bcc-438dfc0ead24', '5f5b0402-2333-b0a8-d5f7-438dfcd4465a', '9257041c-6deb-f667-eccd-438dfbc973ff', '2005-11-30 19:22:40', 0);
INSERT INTO accounts_contacts VALUES ('d00ed613-73b1-7fae-5216-438dfcc9f0a9', 'ce6e50fa-639b-3001-cbd2-438dfce21449', '19132155-4eaa-cd95-cb9f-438dfc5af020', '2005-11-30 19:22:40', 0);
INSERT INTO accounts_contacts VALUES ('57babd1d-72df-de19-bc64-438dfc73ff7a', '561eb0b9-9791-fb94-9699-438dfc37a65e', 'e1806030-63f9-3872-1154-438dfce4e5b8', '2005-11-30 19:22:41', 0);
INSERT INTO accounts_contacts VALUES ('8aa788d0-7c11-547a-a13a-438dfc9c2fed', '8698a308-501d-aa14-34b7-438dfcc4ff72', '692d3a91-9858-15f9-05e2-438dfc10aa6e', '2005-11-30 19:22:41', 0);
INSERT INTO accounts_contacts VALUES ('121bb197-c44f-61ac-0850-438dfc06f565', 'df089e63-a5c1-eb04-dc5f-438dfcb8b6ec', '9c4c03e1-b5b6-b2e3-ef3a-438dfc80f2ff', '2005-11-30 19:22:42', 0);
INSERT INTO accounts_contacts VALUES ('682f2985-73af-7744-2a5b-438dfc61be3f', '669c582a-f20d-5d1c-c998-438dfc1da6eb', '23c14364-2b8a-f05a-56c3-438dfc3bd2c7', '2005-11-30 19:22:42', 0);
INSERT INTO accounts_contacts VALUES ('9b594505-09d1-9921-4069-438dfcf7c020', '99c64088-3935-0880-90bb-438dfc0e4754', '79b00146-200c-599b-f545-438dfce60df3', '2005-11-30 19:22:42', 0);
INSERT INTO accounts_contacts VALUES ('f150ff81-d255-7256-6b5c-438dfc492e29', 'efbceb46-a1b9-763b-b6dd-438dfced69fe', 'aca283ec-2e56-abb8-9776-438dfc574914', '2005-11-30 19:22:42', 0);
INSERT INTO accounts_contacts VALUES ('536eff93-979d-53cc-e1d7-438dfcacd0b6', '51d9ffc7-957f-d421-09f0-438dfc17ef76', 'e8a00854-eae8-47ff-d743-438dfc6b7863', '2005-11-30 19:22:43', 0);
INSERT INTO accounts_contacts VALUES ('83b41aa8-c9eb-2f60-2e70-438dfc05aff3', '821bce65-fddd-5dae-50ee-438dfcb31428', '64c05cfe-ac02-e2d8-12bc-438dfc8b0aaf', '2005-11-30 19:22:43', 0);
INSERT INTO accounts_contacts VALUES ('ec220693-d6ff-bb76-309d-438dfc57b7e9', 'd19d0641-fb2f-daae-545c-438dfcaa1fa9', '97ac316a-488e-ce89-1fc8-438dfcaec675', '2005-11-30 19:22:44', 0);
INSERT INTO accounts_contacts VALUES ('40de6148-5320-5b40-18d4-438dfc088c76', '3f3e343b-635b-9550-19e7-438dfcab706b', '20de29e6-39cc-7c65-c97a-438dfceb2640', '2005-11-30 19:22:44', 0);
INSERT INTO accounts_contacts VALUES ('9c3f8ea2-f309-23f0-d806-438dfcb3e6cb', '9aa64d05-7734-d195-86da-438dfc1d4845', '52d5aba1-bdec-b7ce-1ae1-438dfcf4428b', '2005-11-30 19:22:44', 0);
INSERT INTO accounts_contacts VALUES ('cd64c30f-c31c-acb6-b0d5-438dfcdac315', 'cbc920fc-a60e-d22d-1e66-438dfc0bd753', 'adff7314-4992-f2b0-e2b0-438dfc5eb6ad', '2005-11-30 19:22:44', 0);
INSERT INTO accounts_contacts VALUES ('580db94f-07dc-3cad-6aef-438dfc452fd4', '5676d62d-d706-568f-2ba3-438dfc059083', 'df394a46-8924-6ce8-24e4-438dfcc0045c', '2005-11-30 19:22:45', 0);
INSERT INTO accounts_contacts VALUES ('b315d567-6b66-cd53-5649-438dfc633c8e', 'b174d27b-cb80-d100-fa5d-438dfc602b1d', '69f6e1fb-cf31-0283-314d-438dfc773540', '2005-11-30 19:22:45', 0);
INSERT INTO accounts_contacts VALUES ('3d1fdb11-c3a0-f54a-eb84-438dfcaa190f', '3b8ccf9a-b36c-02f4-5a68-438dfc09b6af', 'c4ea893c-9696-f55c-d060-438dfc022203', '2005-11-30 19:22:46', 0);
INSERT INTO accounts_contacts VALUES ('6d5144a0-049a-327a-2ca5-438dfcd3bdbc', '6bbb5b0c-1a54-d391-7c4c-438dfc4698f8', '4e7fb6cc-21c4-f851-9763-438dfcbeec1d', '2005-11-30 19:22:46', 0);
INSERT INTO accounts_contacts VALUES ('c734484c-77b7-7f27-2010-438dfc364644', 'c59fba97-8974-3bd9-3514-438dfc2c1b81', '7ed9e009-9cd7-4eac-0a05-438dfcb6bd57', '2005-11-30 19:22:46', 0);
INSERT INTO accounts_contacts VALUES ('5157b8c7-58fa-83c7-4642-438dfc7df937', '4fc59f52-627d-a23e-7665-438dfc323b58', 'd890703c-8f14-175c-2d29-438dfc486f5d', '2005-11-30 19:22:47', 0);
INSERT INTO accounts_contacts VALUES ('ab4d152a-afc4-ce72-11cc-438dfcc6a39c', 'a9aae895-be66-2cc4-4ae8-438dfcec3a85', '62ca07a3-8432-3273-b5d3-438dfc2ffcd4', '2005-11-30 19:22:47', 0);
INSERT INTO accounts_contacts VALUES ('36615d42-7459-a6c2-5ae9-438dfcf6bdc1', '34c373fd-c249-fcd8-9384-438dfc9cf6dc', 'bd1e34d7-2283-d1fb-ea70-438dfc3d837c', '2005-11-30 19:22:48', 0);
INSERT INTO accounts_contacts VALUES ('90a778dc-c097-4f07-83d6-438dfc597223', '8f0d383b-3ab1-da69-46cc-438dfc548e82', '47ce2c70-6514-da71-de9d-438dfc189dc3', '2005-11-30 19:22:48', 0);
INSERT INTO accounts_contacts VALUES ('c10eb00f-7a55-7be2-cf3e-438dfc85e814', 'bf77d5ad-79f1-3240-3d6d-438dfc463053', 'a26b4d1a-8d73-2beb-6552-438dfc7b122d', '2005-11-30 19:22:48', 0);
INSERT INTO accounts_contacts VALUES ('4c547988-3043-0a7d-63ad-438dfcccaaa4', '4abaccf1-4196-6eee-a4c2-438dfce2c50f', 'd2a10099-e3ec-17a9-b47c-438dfc811b36', '2005-11-30 19:22:49', 0);
INSERT INTO accounts_contacts VALUES ('cf110336-5ff2-4438-1d3d-438dfc887cc3', 'cd7c0a77-faa6-6826-fde4-438dfc2c1e2b', '5da2f2ef-631b-b399-81ec-438dfc34c906', '2005-11-30 19:22:49', 0);
INSERT INTO accounts_contacts VALUES ('32ed9366-ca45-5e1f-46cd-438dfcdb2e11', '3157da52-c586-c013-0e8d-438dfc26ee2b', 'e085ffea-a012-5b9a-928e-438dfca18c8b', '2005-11-30 19:22:50', 0);
INSERT INTO accounts_contacts VALUES ('8d903ba0-cc58-8479-8ef9-438dfcbf25ef', '897a9222-60a4-e635-4738-438dfc333ccf', '445d98cb-2bb6-5a5a-7e25-438dfce95daf', '2005-11-30 19:22:50', 0);
INSERT INTO accounts_contacts VALUES ('e5d1f306-4bd0-3592-1557-438dfc54865e', 'e43aa64a-b701-ec48-ae92-438dfca3769f', '9f3832b4-60be-268b-9145-438dfc8b7a6e', '2005-11-30 19:22:50', 0);
INSERT INTO accounts_contacts VALUES ('21d86b7f-9822-5803-3e68-438dfc1f7f36', '203c1477-7f18-fd09-9a1c-438dfca23fe8', '31a30751-21d5-38ab-56e8-438dfc995474', '2005-11-30 19:22:51', 0);
INSERT INTO accounts_contacts VALUES ('a501fe17-e2e4-42bb-c8f4-438dfc4afa18', 'a358c6d8-7975-44f6-f885-438dfc471e8f', '3348b98e-721d-c914-852f-438dfc65c395', '2005-11-30 19:22:51', 0);
INSERT INTO accounts_contacts VALUES ('597cec8c-87fd-59d5-6a17-438dfc8951d8', '57bdd594-31b6-6c2b-7243-438dfcbca211', 'b654628e-362d-8623-200b-438dfc160cb2', '2005-11-30 19:22:52', 0);
INSERT INTO accounts_contacts VALUES ('b4a873f5-bac1-11e8-bd90-438dfc906c67', 'b3141aa1-1c11-11ce-a07a-438dfc2ffc48', '6ae0a1e2-cece-b38d-237a-438dfc684d06', '2005-11-30 19:22:52', 0);
INSERT INTO accounts_contacts VALUES ('1939e441-8cbe-7548-d819-438dfcd704d7', '1799dd6d-f5fb-3549-0137-438dfcdb0352', 'c61b206d-2e30-b36f-eed5-438dfc73c046', '2005-11-30 19:22:53', 0);
INSERT INTO accounts_contacts VALUES ('49ac7000-0848-b53b-cfcb-438dfc9c154d', '48120ecd-216e-7546-9f30-438dfca09e12', '2ad884a9-8705-3671-3b1b-438dfcf263fa', '2005-11-30 19:22:53', 0);
INSERT INTO accounts_contacts VALUES ('a583000d-9016-1b37-a7cf-438dfcd1489a', 'a3e763e5-3a0f-d50f-659d-438dfc062025', '5b392773-b350-e644-1e5f-438dfc976788', '2005-11-30 19:22:53', 0);
INSERT INTO accounts_contacts VALUES ('a07a0524-3b9a-cdca-cafb-438dfceea7f4', '876000a6-8419-8b7d-c55f-438dfc2b233f', 'b6f3e8a1-3732-6193-0153-438dfc83d486', '2005-11-30 19:22:54', 0);
INSERT INTO accounts_contacts VALUES ('6329afb4-edf8-fc6b-395a-438dfcffec82', '6195e9bc-6e90-c7b8-fb3a-438dfc3f869e', '1ba04981-4ef6-6ed0-8e17-438dfc1eb2f6', '2005-11-30 19:22:54', 0);
INSERT INTO accounts_contacts VALUES ('1d212fd6-9c7c-7a6b-e088-438dfce7ac9f', '1b7b5699-5918-ff6d-9b37-438dfcacbde4', '7492d5ae-dfba-6e60-5f6b-438dfc9ebfe6', '2005-11-30 19:22:55', 0);
INSERT INTO accounts_contacts VALUES ('7665cab7-b60c-a854-be21-438dfcfa4152', '74d0d401-a9b0-54e5-25a3-438dfcd7778b', '2ea7c9d3-0784-d9b9-2a4b-438dfcf8c620', '2005-11-30 19:22:55', 0);
INSERT INTO accounts_contacts VALUES ('a9571eef-ba01-5eb9-d867-438dfcc763a1', 'a7c42568-08c9-6462-2604-438dfce1332e', '88142010-9a16-7fad-97d5-438dfc2da9d0', '2005-11-30 19:22:55', 0);
INSERT INTO accounts_contacts VALUES ('61161a62-2aa9-b7c6-c830-438dfcc73c75', '5f629f82-e890-a7bf-4879-438dfcaf8561', 'bad8904a-8332-da27-a94c-438dfcaefdb0', '2005-11-30 19:22:56', 0);
INSERT INTO accounts_contacts VALUES ('bd0ce117-acdd-bc79-9bb0-438dfc53d10d', 'bb7644a0-c0ab-9559-0ae5-438dfc192f84', '7285b03b-f984-af24-7766-438dfc2d4fd1', '2005-11-30 19:22:56', 0);
INSERT INTO accounts_contacts VALUES ('4c123b45-dd35-bb5a-6367-438dfc4df41c', '4a6fc8ac-7159-01c0-1880-438dfc27f881', 'ce702aea-7cc2-7743-d67d-438dfc418801', '2005-11-30 19:22:57', 0);
INSERT INTO accounts_contacts VALUES ('a879b1b9-d144-4f69-4b37-438dfc04088c', 'a6df1319-7276-f2ee-f4c4-438dfc39217b', '5d7daa65-e669-d1cc-a6fa-438dfc8de07d', '2005-11-30 19:22:57', 0);
INSERT INTO accounts_contacts VALUES ('38359b1d-8c99-14c8-05ec-438dfc7d850c', '368de2f0-1bb7-5952-441a-438dfc41684a', 'ba5dd704-982d-5927-37a6-438dfc7f3e9b', '2005-11-30 19:22:58', 0);
INSERT INTO accounts_contacts VALUES ('c01d6a25-a4a6-38e2-e0ff-438dfc9812f3', 'be7d639b-3ef6-90b0-6a37-438dfc74bca7', '4a1ee6a0-25ee-6a7a-f7a5-438dfc317653', '2005-11-30 19:22:58', 0);
INSERT INTO accounts_contacts VALUES ('f1a817b7-1cb8-73d2-29b0-438dfcdddd9f', 'f00ab81c-c579-e4a2-7721-438dfcb817f5', 'd1ddc9ee-af9d-f257-89be-438dfcdc46fc', '2005-11-30 19:22:58', 0);
INSERT INTO accounts_contacts VALUES ('2f0f08de-73c5-b309-be2d-438dfc28a844', '2d6e0847-3e3d-1e6c-cb2b-438dfc5ba94c', 'f5da0877-97a9-1cc3-c0ad-438dfca40468', '2005-11-30 19:22:59', 0);
INSERT INTO accounts_contacts VALUES ('8aaac0ab-f2ed-89cb-b5d3-438dfcb01646', '88feeb39-e56d-6d42-026e-438dfcb89b9c', '40f5032c-52e9-76ab-c376-438dfc53b0e6', '2005-11-30 19:22:59', 0);
INSERT INTO accounts_contacts VALUES ('e9856260-69c0-9f2a-c29a-438dfc8d4da0', 'e7d14997-01f3-d505-580b-438dfcac081b', '9f4db6ad-aeb6-b920-a4d0-438dfccfb949', '2005-11-30 19:22:59', 0);
INSERT INTO accounts_contacts VALUES ('551790ba-fa59-9f6e-a149-438dfc7d3fe9', '5379f594-35fb-384d-0b47-438dfc6a6f9b', '6c780887-b1a5-0c37-cb6c-438dfce0f0d3', '2005-11-30 19:23:00', 0);
INSERT INTO accounts_contacts VALUES ('df79ff32-7f10-314f-bf41-438dfc2e0296', 'dde1257e-2eb6-1403-a81f-438dfc217296', '6947c741-d69a-c50a-32c6-438dfcfba4b1', '2005-11-30 19:23:00', 0);
INSERT INTO accounts_contacts VALUES ('9cfe28c9-7a84-4437-605e-438dfc449139', '6e8b6f39-3e20-d2a9-a40b-438dfcd53838', 'f1013808-d829-d48e-3273-438dfc5b4db7', '2005-11-30 19:23:01', 0);
INSERT INTO accounts_contacts VALUES ('3afa0965-21cb-b7f6-8098-438dfc822dbc', '214d0582-1e4e-35dc-0f36-438dfced8b3f', 'ae8527b5-109f-deea-06e4-438dfcc22740', '2005-11-30 19:23:02', 0);
INSERT INTO accounts_contacts VALUES ('343857f8-11d6-0cf1-34d4-438dfccbd6ce', '329fb010-c120-3057-69da-438dfc2a66cb', '15219ad3-ea69-968a-df11-438dfcfc7a29', '2005-11-30 19:23:02', 0);
INSERT INTO accounts_contacts VALUES ('648c2399-bab6-0a3d-3d3f-438dfcde2d3b', '62ef9b95-20b3-4028-2288-438dfc421c31', '45b906e0-9cb3-4c7a-df6f-438dfc9be258', '2005-11-30 19:23:02', 0);
INSERT INTO accounts_contacts VALUES ('97671224-ab64-212b-8a4e-438dfc1b7a98', '95bff4b6-f27c-3ed1-6723-438dfc9c26b8', '75dbb3c5-710a-b367-717c-438dfcc55f67', '2005-11-30 19:23:02', 0);
INSERT INTO accounts_contacts VALUES ('c78c3418-763e-49eb-61a4-438dfc03b067', 'c5ecdbc0-540f-35d8-0eba-438dfc653e19', 'a8db442f-b908-57c2-4caf-438dfcd5c45b', '2005-11-30 19:23:02', 0);
INSERT INTO accounts_contacts VALUES ('37780b66-a79a-ff8e-60f4-438dfcec73f2', '1e180902-2ab9-86fa-6168-438dfcf136b0', 'd8fd3433-b8b5-9a6a-8f33-438dfcce7e1e', '2005-11-30 19:23:03', 0);
INSERT INTO accounts_contacts VALUES ('33a48918-1ee4-a58c-96ac-438dfc867a4e', '320a8a1e-ddfb-9b9d-d459-438dfc0ae4ce', '14c49ab1-5c89-20b7-c3cd-438dfc37065c', '2005-11-30 19:23:03', 0);
INSERT INTO accounts_contacts VALUES ('bc4f90de-9def-bb93-7258-438dfc362fd1', 'baac6caf-0177-1513-22a7-438dfcfa22d5', '4529b043-8473-f470-da4b-438dfc4ff3d2', '2005-11-30 19:23:03', 0);
INSERT INTO accounts_contacts VALUES ('4ec4a903-626e-578f-f1e0-438dfcdeec8c', '4d1f9a93-bb94-71ac-6b06-438dfc88c3c2', 'cdedf12f-00c6-96ab-ead9-438dfc45f071', '2005-11-30 19:23:04', 0);
INSERT INTO accounts_contacts VALUES ('d8c1f3bb-613b-190d-67de-438dfce5265c', 'd72df6a2-5094-fe9a-a646-438dfcf38aa1', '601fcce4-b0ac-96c8-317e-438dfccc081c', '2005-11-30 19:23:04', 0);
INSERT INTO accounts_contacts VALUES ('3fe2b7fd-21c0-d4dd-7775-438dfce1abe6', '3e47ee4f-77c1-938e-ecbb-438dfc23c0a1', 'ea0fe542-2c78-f2f9-e743-438dfc119cf8', '2005-11-30 19:23:05', 0);
INSERT INTO accounts_contacts VALUES ('ca2850d8-4155-9913-c636-438dfc663111', 'c88bfc69-0324-f0cc-ac03-438dfc14434b', '515ebf84-c673-1c9c-f5fc-438dfc99ece3', '2005-11-30 19:23:05', 0);
INSERT INTO accounts_contacts VALUES ('31b43dcf-699e-fa99-b6a6-438dfc6e164a', '301d0fe5-89d7-ef2d-4d2c-438dfc229c51', 'db95808c-1342-bf59-0da1-438dfcf16624', '2005-11-30 19:23:06', 0);
INSERT INTO accounts_contacts VALUES ('e7a31e8e-f401-4097-d15a-438dfcabf810', 'e5e8186d-d414-5646-ff2b-438dfc5fecf2', '432ef0db-2c18-bb20-548f-438dfccc8682', '2005-11-30 19:23:06', 0);
INSERT INTO accounts_contacts VALUES ('508e0291-f13a-f0f3-9f73-438dfc6b0cf2', '4ee9be09-de8f-36f6-4317-438dfcc1a6d3', '609003bf-2a08-438b-2cdc-438dfca0b6a1', '2005-11-30 19:23:07', 0);
INSERT INTO accounts_contacts VALUES ('8132acde-53a7-db73-25c2-438dfcf50b2c', '7f8ec69a-9928-c4e8-b18c-438dfc8f599e', '6204bccd-609d-2069-13ee-438dfc168e35', '2005-11-30 19:23:07', 0);
INSERT INTO accounts_contacts VALUES ('b4213560-43e6-ca48-2076-438dfc0ad350', 'b28cb776-7ddf-b167-ceee-438dfc80ed02', '94e43fe9-95af-d874-e9fc-438dfcf5d51c', '2005-11-30 19:23:07', 0);
INSERT INTO accounts_contacts VALUES ('e45e4ecb-7c81-e1f9-8246-438dfc4375cb', 'e2c86479-26de-764d-5907-438dfc2852c8', 'c594dad7-18a9-dfa1-5f69-438dfca073ba', '2005-11-30 19:23:07', 0);
INSERT INTO accounts_contacts VALUES ('20b35efc-173a-26ac-bc5d-438dfc34707f', '1f1b7f69-2d8b-fc15-96fa-438dfc4f4544', '1988011e-1fb0-7f64-6f56-438dfca9f939', '2005-11-30 19:23:08', 0);
INSERT INTO accounts_contacts VALUES ('7d22f0e1-6d05-e5bb-2a9e-438dfcca88c0', '7b8dbbb1-71c5-33ca-c454-438dfcde10a3', '32300f8e-5ff9-1d8d-0510-438dfc3e860f', '2005-11-30 19:23:08', 0);
INSERT INTO accounts_contacts VALUES ('dc397f30-d47b-6059-5993-438dfc3a137d', 'da9a0756-3d18-33ba-3858-438dfc0139b3', '8e8513ea-8926-9895-3afd-438dfcf13b88', '2005-11-30 19:23:08', 0);
INSERT INTO accounts_contacts VALUES ('183ad11d-4be5-074f-20f6-438dfc91a5e7', '1696af19-3a40-10df-ed0c-438dfcdcb73b', 'ed96efc5-56ff-f8c8-b303-438dfcf7a76b', '2005-11-30 19:23:09', 0);
INSERT INTO accounts_contacts VALUES ('bc10443b-023e-f897-c98b-438dfc44514d', 'ba6ebefa-beef-7d29-8e2d-438dfc9ec741', '4206630a-0fc2-0692-269f-438dfc3dce7a', '2005-11-30 19:23:09', 0);
INSERT INTO accounts_contacts VALUES ('7f245ca9-85ff-20d7-b083-438dfc41df1d', '7d5b0889-5a20-f982-9919-438dfcd9783e', 'cde328fd-1085-f663-68a5-438dfcfb2788', '2005-11-30 19:23:10', 0);
INSERT INTO accounts_contacts VALUES ('de8984d5-5f53-dcc4-b9be-438dfca1992b', 'dcf35b98-3242-44fa-afe9-438dfc47865c', '90a85cb5-09ae-3944-73d3-438dfc1ece40', '2005-11-30 19:23:10', 0);
INSERT INTO accounts_contacts VALUES ('472fc599-9435-88c4-f034-438dfc4b05c4', '459b0cb6-ecce-f9a5-d9ee-438dfcfe1103', 'efdf250d-2235-3922-c847-438dfc7f2648', '2005-11-30 19:23:11', 0);
INSERT INTO accounts_contacts VALUES ('3a84fcd9-dee3-9ad6-c5b0-438dfc3b5a7a', '38d640d7-74bd-1af5-c0fe-438dfc90f847', '5897fd94-0082-4b99-926d-438dfceb8b63', '2005-11-30 19:23:12', 0);
INSERT INTO accounts_contacts VALUES ('6c18f9e3-c7b1-c56b-b449-438dfc212b24', '6a7b3d13-233e-1ddb-48ab-438dfc0e3372', '4c9833d0-3c0d-cc22-667e-438dfc2cbfe0', '2005-11-30 19:23:12', 0);
INSERT INTO accounts_contacts VALUES ('cd49dba5-c335-11f5-e92e-438dfc16186f', 'cbb0200b-2b96-abf3-56ed-438dfc8f37dd', '7e29ad13-68e1-2c33-12ac-438dfcaf4ea1', '2005-11-30 19:23:12', 0);
INSERT INTO accounts_contacts VALUES ('64e4ee8b-8af2-d5ba-e7f3-438dfc69917f', '634c6604-767e-2c8b-3d5a-438dfce9ed44', 'df27c279-dd8b-4906-18d8-438dfc536de4', '2005-11-30 19:23:13', 0);
INSERT INTO accounts_contacts VALUES ('99193527-0527-d9b8-c14c-438dfc79434b', '9776763c-963c-6124-84e6-438dfce79e6b', '76d00a10-3ef0-9a5f-1f68-438dfc28d168', '2005-11-30 19:23:13', 0);
INSERT INTO accounts_contacts VALUES ('36ad0c2a-fab8-6ef7-3ebf-438dfc99a4bc', '1d150394-bf48-31c3-b17c-438dfc0efe74', 'aad102f0-6ca6-3b3a-d374-438dfc18d752', '2005-11-30 19:23:14', 0);
INSERT INTO accounts_contacts VALUES ('610564be-0750-597e-1030-438dfc9a9266', '5f6d65cb-1651-b4f0-29ff-438dfc7c908f', '14dd4d0a-360d-88c6-bed5-438dfc462ea2', '2005-11-30 19:23:14', 0);
INSERT INTO accounts_contacts VALUES ('c12939cb-f2df-f34a-ab97-438dfc5f38c1', 'bf92b248-3a6a-1f53-8ac4-438dfcd647e2', '72627cba-1687-f765-d88c-438dfc2f7978', '2005-11-30 19:23:14', 0);
INSERT INTO accounts_contacts VALUES ('59a7f16d-95a8-42f6-76f8-438dfc8342b0', '57f93287-68b7-29bf-12a8-438dfce4973c', 'd3431f37-fcc8-2405-eb66-438dfc52eb4c', '2005-11-30 19:23:15', 0);
INSERT INTO accounts_contacts VALUES ('ba05ad27-5123-a9e2-f1e6-438dfcac72e1', 'b86c26b1-b0f0-be69-9870-438dfc11f64c', '6b1fb4fa-6cb6-8534-d59c-438dfc75d9be', '2005-11-30 19:23:15', 0);
INSERT INTO accounts_contacts VALUES ('7fb02adf-a115-031f-f4d6-438dfcf0b429', '7dffefc1-1ec3-09ec-c4b1-438dfc8047cd', 'cb4e8fc7-f8f0-e1a2-d80b-438dfc2e57c1', '2005-11-30 19:23:16', 0);
INSERT INTO accounts_contacts VALUES ('e060e6d9-bb67-d768-c4e7-438dfcaa90e6', 'decb925e-3a16-aad7-7cc9-438dfc4ecf94', '914ccf1c-bf0a-f7ed-58c5-438dfca75a45', '2005-11-30 19:23:16', 0);
INSERT INTO accounts_contacts VALUES ('a9470ca9-57ff-65fb-62dd-438dfc764c0a', '48cdd3c5-88fa-0e76-c48f-438dfc6e44d7', 'f1baec4e-7c74-c96a-68a3-438dfc8cb99b', '2005-11-30 19:23:17', 0);
INSERT INTO accounts_contacts VALUES ('d98a202e-c2ff-042c-2624-438dfc834222', 'd7f19a34-abe7-9df2-5782-438dfc44f832', 'bab27711-9702-e9e0-da79-438dfcc3aa62', '2005-11-30 19:23:17', 0);
INSERT INTO accounts_contacts VALUES ('15bb3dc6-fa47-5b54-1bdf-438dfc76044f', '14200cfc-bb2d-6aa3-7e64-438dfcf514a8', 'eae78d25-3a40-ec1c-c24d-438dfc8f5eb2', '2005-11-30 19:23:18', 0);
INSERT INTO accounts_contacts VALUES ('46549a0d-092b-4d40-e7ed-438dfc5f6552', '44b4f69d-ff91-7b16-20ae-438dfc3c8eda', '2748039e-54c4-cb87-e152-438dfc2b0d6f', '2005-11-30 19:23:18', 0);
INSERT INTO accounts_contacts VALUES ('76c5409b-fd04-3c8e-4f44-438dfc3219cf', '75322c26-e53c-cdd1-5603-438dfc8be100', '57ad5a94-8201-6bc2-5ae4-438dfc415be8', '2005-11-30 19:23:18', 0);
INSERT INTO accounts_contacts VALUES ('a9c02f36-e778-5c95-ecf7-438dfcd8bb32', 'a827c287-d6f6-3510-81fe-438dfcde5269', '883c8ad1-e540-4dd6-ccb1-438dfc95b2c7', '2005-11-30 19:23:18', 0);
INSERT INTO accounts_contacts VALUES ('da7c4d47-a5d3-f611-7069-438dfc72b775', 'd8e32d7e-534b-51e7-68c1-438dfc5e8592', 'bba46bbd-e936-368b-f563-438dfc060181', '2005-11-30 19:23:18', 0);
INSERT INTO accounts_contacts VALUES ('166fd2af-f16d-9505-0c87-438dfcad531a', '14dc6d49-aeae-ec32-b97a-438dfca91d75', 'ebe2430a-1961-633a-a68d-438dfc818e50', '2005-11-30 19:23:19', 0);
INSERT INTO accounts_contacts VALUES ('47c82a79-c919-0eee-bfeb-438dfc492917', '462e406a-39be-00fc-c2f0-438dfc8b9432', '281a7cd0-fb77-6171-1a50-438dfc3c109a', '2005-11-30 19:23:19', 0);
INSERT INTO accounts_contacts VALUES ('78caf60e-c2fc-3d32-c528-438dfc6cd325', '772e9844-ef8c-f32f-dddd-438dfc7cb325', '5926592f-9977-2855-c423-438dfcd03f4c', '2005-11-30 19:23:19', 0);
INSERT INTO accounts_contacts VALUES ('adbd002e-927d-74b7-fa7e-438dfc199daf', 'ac1ea948-1a12-7d32-64e2-438dfc4339fb', '8a3f3731-8ac9-e132-840e-438dfc018323', '2005-11-30 19:23:19', 0);
INSERT INTO accounts_contacts VALUES ('e1548d8f-1482-60e7-e9c2-438dfc577b6c', 'dfb3a910-9a28-e62c-b624-438dfcccb55a', 'bf2aa340-1a5b-b67c-5244-438dfcb55652', '2005-11-30 19:23:19', 0);
INSERT INTO accounts_contacts VALUES ('1ddeafa6-f075-31d3-50c7-438dfcf16239', '1c132ac9-6b7d-ba96-e8e2-438dfc23dc1f', 'f2b6de7a-dfb9-1f15-8d7a-438dfcedbe55', '2005-11-30 19:23:20', 0);
INSERT INTO accounts_contacts VALUES ('4e1b254c-2d6d-8590-0758-438dfc7b894d', '4c87afe7-22a3-5622-225e-438dfcba92ba', '2f4ab363-a0e3-ee3e-0807-438dfcef783d', '2005-11-30 19:23:20', 0);
INSERT INTO accounts_contacts VALUES ('7f6ff24e-520d-3925-0258-438dfcfcc70f', '7ddbae1a-92b3-fe6c-7f21-438dfca13feb', '5f78a5ac-c8e4-d74e-de14-438dfc4ba53c', '2005-11-30 19:23:20', 0);
INSERT INTO accounts_contacts VALUES ('b55a51ec-6d13-94d7-f7b1-438dfc4f973b', 'b3b75151-644c-aa5f-c51b-438dfc3dc997', '90f58c4a-8556-0ec0-c999-438dfcb4680a', '2005-11-30 19:23:20', 0);
INSERT INTO accounts_contacts VALUES ('e87890ee-cdfd-d7cb-2d46-438dfcc36b3d', 'e6e58d6a-65b8-3808-d090-438dfcfd60c2', 'c6ab6a84-2c1d-6ee1-fb84-438dfc7a9b31', '2005-11-30 19:23:20', 0);
INSERT INTO accounts_contacts VALUES ('264c7f80-f618-c45c-ceb0-438dfcd204d8', '24b3d536-dfb7-5b0b-34d0-438dfc57df38', '5db004c3-0bc7-0f1f-0333-438dfc1dd327', '2005-11-30 19:23:21', 0);
INSERT INTO accounts_contacts VALUES ('5a4613ff-39e4-2a5e-ac03-438dfca9fcaa', '58a1414d-6ee9-80c0-8d67-438dfcfb5e30', '37ed14c6-a48d-5a88-32de-438dfc344b87', '2005-11-30 19:23:21', 0);
INSERT INTO accounts_contacts VALUES ('8cc6fe39-15df-ffce-eade-438dfc22d4c3', '8b2401d8-8210-0ab4-f5e0-438dfcf9751f', '6be54043-f48f-b735-139f-438dfc1c2fc2', '2005-11-30 19:23:21', 0);
INSERT INTO accounts_contacts VALUES ('bf5ce610-9699-d4fd-ae4b-438dfcf82962', 'bdbd1de9-b4a8-a8ae-027b-438dfc3ec229', 'a0bfb889-e57c-c6b1-4a16-438dfc2ce66f', '2005-11-30 19:23:21', 0);
INSERT INTO accounts_contacts VALUES ('f35eb3af-6dec-43ed-2dad-438dfcc10218', 'f1c4aa3f-8a33-6fba-3433-438dfcff5284', 'd09daf64-3366-7d89-d80e-438dfc78fd52', '2005-11-30 19:23:22', 0);
INSERT INTO accounts_contacts VALUES ('364d7480-aa9d-dd0e-d574-438dfc6e044d', '34b06f08-49b7-6445-dac6-438dfc0a4ae7', '10c85c97-4838-66f7-ca9c-438dfc62b69d', '2005-11-30 19:23:22', 0);
INSERT INTO accounts_contacts VALUES ('68b3f851-be53-3708-155f-438dfc29e35b', '67024b1f-fda1-5cbd-44ff-438dfcac42c5', '47b2de2c-877f-5ea3-3e3c-438dfc69b421', '2005-11-30 19:23:22', 0);
INSERT INTO accounts_contacts VALUES ('9b886634-9eef-5b44-1f10-438dfc9ad2ba', '99edf5ff-721a-8634-bc96-438dfccf264a', '7a0f3a9f-919d-93ac-64d4-438dfc575d2d', '2005-11-30 19:23:22', 0);
INSERT INTO accounts_contacts VALUES ('ce672550-78a1-684c-3e8a-438dfc7829c4', 'ccbfff82-f15e-0db1-9f58-438dfcc28bfe', 'ad4d52a7-b4f6-2449-85c1-438dfccbc0eb', '2005-11-30 19:23:22', 0);
INSERT INTO accounts_contacts VALUES ('cb3f0aed-74f1-6271-8301-438dfc9b61fa', 'b1a30f37-66ca-8288-06ee-438dfc84dfbe', 'dfb5d15e-4d90-008a-c4a0-438dfc1e6796', '2005-11-30 19:23:23', 0);
INSERT INTO accounts_contacts VALUES ('3faff031-dec1-2d8a-a844-438dfcd2a8d0', '3e068b71-d658-c867-3c93-438dfc9e4009', '1e2e0eaf-a436-2e2f-079a-438dfcc978c2', '2005-11-30 19:23:23', 0);
INSERT INTO accounts_contacts VALUES ('6fd51174-ab30-e1af-fb71-438dfcedc17d', '6e3ea8a2-f6b4-c5c9-632d-438dfc48a344', '511417c9-515a-5271-83cd-438dfc3602b3', '2005-11-30 19:23:23', 0);
INSERT INTO accounts_contacts VALUES ('a2de797d-b604-0386-f262-438dfcc7c8bb', 'a1437962-e606-fb39-bc2e-438dfc976904', '81739667-916f-2f70-f9b6-438dfcef40da', '2005-11-30 19:23:23', 0);
INSERT INTO accounts_contacts VALUES ('d8d89f63-0960-831a-72b7-438dfc97e71f', 'd72e3ade-78a0-3d4f-afc5-438dfc0c768d', 'b458bb25-107a-9c13-28cb-438dfce22eb8', '2005-11-30 19:23:23', 0);
INSERT INTO accounts_contacts VALUES ('1d8d6293-e0f4-2ad3-368d-438dfc659cb4', '1bebba96-76bd-15bd-9c3c-438dfcc95a6f', 'ea48fde4-32a8-c93f-deb5-438dfce647a7', '2005-11-30 19:23:24', 0);
INSERT INTO accounts_contacts VALUES ('50da6240-2c31-865d-d025-438dfc5adc04', '4f302607-abcd-5352-f2fc-438dfc00e5b3', '2f17041d-6ce9-52da-f900-438dfc42caf8', '2005-11-30 19:23:24', 0);
INSERT INTO accounts_contacts VALUES ('841e2aed-2362-9a99-535a-438dfc2d53cb', '825e2292-7252-6410-fb2d-438dfc79d20e', '62385afb-c905-f7a8-2a44-438dfca04f24', '2005-11-30 19:23:24', 0);
INSERT INTO accounts_contacts VALUES ('b9e551cb-468d-3cc1-b944-438dfc73d90b', 'b51a563d-6691-98c6-52b1-438dfc202f8b', '958696f6-dd18-293d-8b6a-438dfc8aed00', '2005-11-30 19:23:24', 0);
INSERT INTO accounts_contacts VALUES ('ea2a40c1-071a-17a1-e983-438dfcac009d', 'e888490a-77ca-2e54-e151-438dfca126ff', 'cb5c47a5-1b26-9d7e-13d6-438dfc4e1bd3', '2005-11-30 19:23:24', 0);
INSERT INTO accounts_contacts VALUES ('268a4c48-951a-ea07-590e-438dfce5ad63', '24dc684b-4aab-d9cd-10a0-438dfceaa494', '75e50a23-9265-c54c-8b4e-438dfcd2223b', '2005-11-30 19:23:25', 0);
INSERT INTO accounts_contacts VALUES ('5fa0ef31-8541-c29a-d1aa-438dfc931034', '5dece066-4bc5-24eb-07a9-438dfc8e0853', '388be0fd-b842-efd0-f18e-438dfc552b9e', '2005-11-30 19:23:25', 0);
INSERT INTO accounts_contacts VALUES ('91039ea3-1679-30df-fa91-438dfc67923a', '8f52a771-9213-2b3a-3ce1-438dfc5c71ec', '7157d805-6abe-331a-5fb9-438dfc620237', '2005-11-30 19:23:25', 0);
INSERT INTO accounts_contacts VALUES ('c4db4dab-efda-4122-1e55-438dfca14c47', 'c333815a-ebdd-ee68-ee0a-438dfcfc9006', 'a5742340-8530-36ea-0b70-438dfc49fba9', '2005-11-30 19:23:25', 0);
INSERT INTO accounts_contacts VALUES ('5d6e0e53-8029-84c8-76e2-438dfc1162f3', '42be0d14-40fa-a041-2247-438dfc08385e', 'd69a09f2-05b3-787c-3830-438dfcf05a6f', '2005-11-30 19:23:26', 0);
INSERT INTO accounts_contacts VALUES ('375d602f-e3f6-4d35-422e-438dfc3273ce', '35bb881c-7643-9d00-e558-438dfcfbdfb3', '179e125d-284a-d3b2-0038-438dfcf93aaa', '2005-11-30 19:23:26', 0);
INSERT INTO accounts_contacts VALUES ('6cc5d4f9-8948-f3b3-49f8-438dfc0309ce', '6b1aa649-4fe1-c9c0-dfa3-438dfc73315c', '495768d6-47f1-1b9f-577a-438dfc1aac48', '2005-11-30 19:23:26', 0);
INSERT INTO accounts_contacts VALUES ('a3f10639-8067-90ee-a26f-438dfc8c0655', 'a24afe1a-083c-32bb-fb1e-438dfc7459f8', '7e3eb19c-1d64-396b-5c09-438dfcb45107', '2005-11-30 19:23:26', 0);
INSERT INTO accounts_contacts VALUES ('dc5033f4-bd3f-2aae-4276-438dfc23a853', 'dab64de2-48a9-2281-5cfb-438dfc237bd0', 'b566c7ed-03b1-4b94-b3c0-438dfc90b079', '2005-11-30 19:23:26', 0);
INSERT INTO accounts_contacts VALUES ('186046fd-9d96-ce17-5fa8-438dfcb63ad6', '16ad13b9-d9f4-4e9d-603c-438dfcae225f', 'edb6480f-7a94-ab84-d7f7-438dfc6d05e7', '2005-11-30 19:23:27', 0);
INSERT INTO accounts_contacts VALUES ('525b4fba-f1ad-79e8-17a7-438dfc826a85', '50ad177c-14a3-302b-2fe0-438dfc7bd466', '2ade2bad-f421-e522-0893-438dfc6f9001', '2005-11-30 19:23:27', 0);
INSERT INTO accounts_contacts VALUES ('87438148-9cc3-7b42-544d-438dfc91e314', '85a4f5f3-8cb4-fd29-8127-438dfcd4db2e', '63ac9d63-cef0-cc86-3eb8-438dfc83a95f', '2005-11-30 19:23:27', 0);
INSERT INTO accounts_contacts VALUES ('bea5fcd7-9161-b297-80f7-438dfceb0dc7', 'bd106827-7ff4-0c95-591b-438dfc3cff42', '9b204880-a0ef-5c4d-4be0-438dfc20677e', '2005-11-30 19:23:27', 0);
INSERT INTO accounts_contacts VALUES ('eeb737ff-856a-edf8-bd80-438dfcb0cc8c', 'ed1a0558-ed09-ffae-8b62-438dfcbbd57a', 'cfe9578f-3e6b-aa60-aa17-438dfc0054b8', '2005-11-30 19:23:27', 0);
INSERT INTO accounts_contacts VALUES ('2ab2119d-ffc1-d078-a1c4-438dfcc015f9', '290bff6c-1ffd-bac9-ebc2-438dfc57fda9', 'bfe90793-7042-b281-a29b-438dfcd94a83', '2005-11-30 19:23:28', 0);
INSERT INTO accounts_contacts VALUES ('64963b2d-d292-f76e-45a5-438dfca622cc', '62f6d9a6-38db-9adb-8f64-438dfc809550', '3c5230ab-6269-a413-a1da-438dfce24849', '2005-11-30 19:23:28', 0);
INSERT INTO accounts_contacts VALUES ('94cac889-9423-30f8-566a-438dfc864d1a', '93298433-87f2-d555-c5eb-438dfc3a8e71', '75fbe8a1-0cc5-7f5f-3f5d-438dfcba3444', '2005-11-30 19:23:28', 0);
INSERT INTO accounts_contacts VALUES ('c77394d2-8c7c-124d-8a40-438dfc02fa44', 'c5cf4d41-23ac-43e6-f97f-438dfcde00bd', 'a8be972a-939a-3dca-b61a-438dfc6effc4', '2005-11-30 19:23:28', 0);
INSERT INTO accounts_contacts VALUES ('dbcd0466-7a8f-b377-e550-438dfc6a5d03', 'c0680e5a-0cfc-cd0b-ffbc-438dfcbd6185', 'd8ad2277-df7d-f46f-f387-438dfc9fc67c', '2005-11-30 19:23:29', 0);
INSERT INTO accounts_contacts VALUES ('43401f58-7ab9-270f-b45f-438dfc4d3b0a', '41a526b8-6eef-0ee4-1ad2-438dfcbeff40', '1f2068b3-8dfd-886c-701a-438dfc9c060b', '2005-11-30 19:23:29', 0);
INSERT INTO accounts_contacts VALUES ('78a30976-2bd2-6538-c40b-438dfc31b31d', '76f862b6-99a8-f259-5934-438dfc2a1e25', '54a0d864-0354-75f6-828b-438dfce8bd19', '2005-11-30 19:23:29', 0);
INSERT INTO accounts_contacts VALUES ('b64bae80-fe1b-87ee-47da-438dfcf295fd', 'b4b24cbb-da1b-5cc8-9ff1-438dfc8673bf', '94e3b641-f6ba-cc12-a786-438dfcc4dc4a', '2005-11-30 19:23:29', 0);
INSERT INTO accounts_contacts VALUES ('e72e402b-5259-bbe6-a9ba-438dfc896fb5', 'e58f9f32-8bb2-9ecf-ace8-438dfc110fd0', 'c79ec9db-7704-6f87-c385-438dfc36b819', '2005-11-30 19:23:29', 0);
INSERT INTO accounts_contacts VALUES ('2eacdb99-91b6-07c5-5821-438dfc49f2f4', '2cbea3b7-59e5-ae4c-b8e8-438dfcc0ff52', '492a0d69-45ec-0626-ad08-438dfc957527', '2005-11-30 19:23:30', 0);
INSERT INTO accounts_contacts VALUES ('5f1e0745-141f-ec69-9b88-438dfc5e5333', '5d81e5cb-c395-5a7b-9e57-438dfc6dd7d4', '405a1f89-b637-f966-5355-438dfc8e0091', '2005-11-30 19:23:30', 0);
INSERT INTO accounts_contacts VALUES ('9507a18f-4bc5-5ea0-bbcd-438dfc227ab2', '93658bae-d584-6796-831b-438dfc4cb9cd', '7072fe03-b8b5-5554-6d14-438dfc2f5a34', '2005-11-30 19:23:30', 0);
INSERT INTO accounts_contacts VALUES ('c7ae6e7e-b9fe-aee4-8542-438dfc8b4354', 'c612e074-74cd-1610-5766-438dfc40bade', 'a902c86d-af73-bb58-03d8-438dfce6da2a', '2005-11-30 19:23:30', 0);
INSERT INTO accounts_contacts VALUES ('155b2216-336d-ea6d-67d0-438dfcd50aa1', '13c74f9f-ade5-560f-01dc-438dfc1fbd8c', 'd90e7371-642f-b58a-283a-438dfcf43684', '2005-11-30 19:23:31', 0);
INSERT INTO accounts_contacts VALUES ('45d754cd-b050-30ff-803a-438dfc0dbc74', '44405f8e-84c5-ab43-50bf-438dfcc08a76', '26bc2c8a-cf99-5250-f0aa-438dfc686818', '2005-11-30 19:23:31', 0);
INSERT INTO accounts_contacts VALUES ('75f777f5-212a-f0ea-ee44-438dfc7cca1b', '74492f6f-37aa-6da9-ea40-438dfc4d6851', '573647e1-999c-69cf-2397-438dfc17623f', '2005-11-30 19:23:31', 0);
INSERT INTO accounts_contacts VALUES ('b4f8eed9-85f7-9da7-e2aa-438dfc329a47', 'b360974f-b6b3-4575-c535-438dfce3aaab', '877eb60b-134a-f479-802c-438dfc448522', '2005-11-30 19:23:31', 0);
INSERT INTO accounts_contacts VALUES ('3fd40d4a-a72b-6855-b368-438dfc1229a1', '24dc0cf7-26c8-a372-2b84-438dfc3c73c7', 'c66b15b6-1295-c446-8285-438dfc13ef91', '2005-11-30 19:23:32', 0);
INSERT INTO accounts_contacts VALUES ('40f351ec-06e3-99e8-8c4f-438dfc041924', '3f596d4d-9459-a7be-ebf2-438dfcdd06cf', '15876252-21f9-8801-edf5-438dfc514ffd', '2005-11-30 19:23:32', 0);
INSERT INTO accounts_contacts VALUES ('77c764c8-e0e8-77fe-fc6a-438dfc49485c', '762a4dbb-1b6b-8265-b777-438dfc26e6aa', '52649e63-6cbc-9626-db97-438dfcc96538', '2005-11-30 19:23:32', 0);
INSERT INTO accounts_contacts VALUES ('aa921f70-9af6-856b-c3fa-438dfc630548', 'a903c5be-615c-6482-f54e-438dfca2f9a5', '8931952d-ca9b-aaef-d3bf-438dfc559055', '2005-11-30 19:23:32', 0);
INSERT INTO accounts_contacts VALUES ('e7eb97fd-bf15-e2f7-4e07-438dfc872de9', 'e650a6d9-55c9-16d5-3e51-438dfc30eddc', 'bbf35b4f-d530-f5ec-3f2a-438dfc01924c', '2005-11-30 19:23:32', 0);
INSERT INTO accounts_contacts VALUES ('2405bd85-1996-2126-58f8-438dfc2ac547', '226de984-3890-18dc-cbcb-438dfcf33b58', '53e902c2-1531-2e88-6849-438dfcf7e277', '2005-11-30 19:23:33', 0);
INSERT INTO accounts_contacts VALUES ('54437648-ecd0-08c5-11dd-438dfcc47815', '52b0c433-2a77-d494-9333-438dfc1f2e7c', '3571dd34-b4e1-d163-6193-438dfc2a52df', '2005-11-30 19:23:33', 0);
INSERT INTO accounts_contacts VALUES ('99624a68-821b-02bd-70d3-438dfc665305', '97d37521-e05c-a093-8529-438dfc806258', '65b6ae82-e853-4b4a-907a-438dfc41e4ea', '2005-11-30 19:23:33', 0);
INSERT INTO accounts_contacts VALUES ('cc758322-dda7-2239-7a48-438dfc412ffd', 'cadcdefd-f87a-9088-c548-438dfca90e1e', 'ad7eebc8-9008-48aa-8999-438dfc2bd7db', '2005-11-30 19:23:33', 0);
INSERT INTO accounts_contacts VALUES ('895800ef-024f-171a-f83f-438dfcd36249', '6fe50e85-30cc-a7b1-9622-438dfcb84ed5', 'dddc337f-cd80-2112-6c27-438dfcd65851', '2005-11-30 19:23:34', 0);
INSERT INTO accounts_contacts VALUES ('391e7fdf-8bd4-4cf3-156f-438dfc7ca9ea', '3790812f-f865-9cdd-ec29-438dfc40797a', '19ffc069-9d38-b1b6-1dae-438dfcbadb5a', '2005-11-30 19:23:34', 0);
INSERT INTO accounts_contacts VALUES ('781ba660-571c-c803-66da-438dfcc5fc8d', '7681f4c4-95f7-f34a-0dfc-438dfcd8e527', '4abce901-f399-395c-cfc1-438dfc680d17', '2005-11-30 19:23:34', 0);
INSERT INTO accounts_contacts VALUES ('b2786cc8-67a0-aa3c-b575-438dfce720e0', 'b0eb573e-0b4c-db66-a4f5-438dfcfd7a12', '89aa25e0-abb7-8da8-5f7c-438dfcc93527', '2005-11-30 19:23:34', 0);
INSERT INTO accounts_contacts VALUES ('f1d876e9-916e-f71d-5100-438dfc02c6da', 'f046ed8f-829d-328a-41f2-438dfc79ae4c', 'c42d53c8-319a-14cb-031b-438dfc639b30', '2005-11-30 19:23:34', 0);
INSERT INTO accounts_contacts VALUES ('3eb1b565-2411-8837-96c5-438dfca1b461', '3d1b97ed-4be8-3e8f-c338-438dfc420b6f', 'f8ae0395-a072-805c-afa3-438dfc1b9db1', '2005-11-30 19:23:35', 0);
INSERT INTO accounts_contacts VALUES ('83c1e9f2-5175-4fb5-8b0b-438dfca4694a', '8231219c-88f3-08e0-4d40-438dfcc76b2d', '5597c255-2788-329c-788b-438dfc89c0d8', '2005-11-30 19:23:35', 0);
INSERT INTO accounts_contacts VALUES ('c61ea25c-4791-28e4-07c5-438dfcec98a6', 'c486945c-dfe8-7558-5dc5-438dfce54b49', '9562372a-7c6b-0f03-5180-438dfc684ff2', '2005-11-30 19:23:35', 0);
INSERT INTO accounts_contacts VALUES ('11de391e-bbc4-b401-de43-438dfc23a7c6', '10448b37-767d-49c6-7ff4-438dfc144959', 'd78273c2-d1a4-c2e1-cb4c-438dfc1d695e', '2005-11-30 19:23:36', 0);
INSERT INTO accounts_contacts VALUES ('41d40929-bbd3-826c-2c62-438dfc2b0746', '4037915b-06c2-049d-fa76-438dfc3f7bd0', '2337d344-998b-9825-9a1d-438dfc6dafc6', '2005-11-30 19:23:36', 0);
INSERT INTO accounts_contacts VALUES ('71fc5cf4-c298-e6ee-ed97-438dfc81df1a', '70618cb5-dc78-b088-3e4c-438dfc0ca172', '5377769e-2add-65c8-fae0-438dfc5634c3', '2005-11-30 19:23:36', 0);
INSERT INTO accounts_contacts VALUES ('a4c9e2c8-0c09-171a-9397-438dfcdd3d36', 'a33a94a2-f80c-9478-2b6b-438dfcf49e4f', '83588aa9-47a5-ea7e-f3fe-438dfc246337', '2005-11-30 19:23:36', 0);
INSERT INTO accounts_contacts VALUES ('dd0f063a-4434-30e0-d0dd-438dfcee5971', 'db839fdb-d806-b78e-a0a0-438dfcc61dfe', 'b625d5bb-cd93-43e5-6e8b-438dfc2936c1', '2005-11-30 19:23:36', 0);
INSERT INTO accounts_contacts VALUES ('21674be4-fcf4-011c-ee4e-438dfc29a01f', '1fd795f7-c529-0b77-a351-438dfc8087d4', 'ee8bad1c-a0dc-5296-19c3-438dfc606916', '2005-11-30 19:23:37', 0);
INSERT INTO accounts_contacts VALUES ('6807bc87-b3db-897a-4570-438dfc6d7815', '66715d79-9b0e-e339-3fbb-438dfc8694f7', '32dbd4f6-fc0a-ee15-c211-438dfc5792cf', '2005-11-30 19:23:37', 0);
INSERT INTO accounts_contacts VALUES ('a541fa05-1673-f14e-6c88-438dfc46e35c', 'a3b03acd-14fd-6b90-0a3a-438dfcb9b910', '7a09f220-a444-3557-babd-438dfc835374', '2005-11-30 19:23:37', 0);
INSERT INTO accounts_contacts VALUES ('deff8f95-d975-7ddd-4658-438dfcae86ea', 'dd62dae9-70c2-4a76-dca9-438dfc6d1749', 'b6fee153-e674-0ce9-1876-438dfcd49190', '2005-11-30 19:23:37', 0);
INSERT INTO accounts_contacts VALUES ('2d6fdc92-74c4-ba58-e56f-438dfcf623e9', '2bdbd56a-9436-05ce-ec8e-438dfc73ae4d', 'f0c98417-28e4-750f-3158-438dfc753a4a', '2005-11-30 19:23:38', 0);
INSERT INTO accounts_contacts VALUES ('5ecfccff-b5c7-6fcd-7a27-438dfc8f1bf5', '5d2e9371-d63c-13c5-efaa-438dfc6584bf', '3f3906cd-9417-2089-b784-438dfcbfcc98', '2005-11-30 19:23:38', 0);
INSERT INTO accounts_contacts VALUES ('993b8ce5-5c4d-91b7-1d18-438dfc4a481c', '9778e1cd-e7db-3aa1-58b4-438dfc618981', '70a2eb1b-e3e3-24ea-79db-438dfcfd0cac', '2005-11-30 19:23:38', 0);
INSERT INTO accounts_contacts VALUES ('d5206a55-6db9-8992-f447-438dfc1e1475', 'd38db215-b715-00b1-4a3a-438dfc87ff1d', 'ad779176-e6f2-3a2a-7988-438dfca1fc7f', '2005-11-30 19:23:38', 0);
INSERT INTO accounts_contacts VALUES ('1115f624-1b2a-e84b-71a0-438dfcf77578', 'f85f00e0-fe55-e9f1-4356-438dfce2dfe2', 'e6794b89-cc73-f353-e58d-438dfc4ade8c', '2005-11-30 19:23:39', 0);
INSERT INTO accounts_contacts VALUES ('4a9a51dc-63dd-e9e6-d5ba-438dfce61717', '4908359d-2e71-f7bf-96c3-438dfc1d5bf1', '22a32b5c-d5be-2c77-7d86-438dfc775cd6', '2005-11-30 19:23:39', 0);
INSERT INTO accounts_contacts VALUES ('932e1531-c7e9-6fe1-cf58-438dfcf2312f', '9188465f-ed5f-8c10-1fd5-438dfc14b29d', '65157916-93a9-67e5-d373-438dfc35ed6b', '2005-11-30 19:23:39', 0);
INSERT INTO accounts_contacts VALUES ('c63efb91-e644-8b36-bf92-438dfc26957b', 'c4aaa1fd-4385-0224-f0b7-438dfcb17578', 'a7b39e5d-493c-5021-3027-438dfcce30dd', '2005-11-30 19:23:39', 0);
INSERT INTO accounts_contacts VALUES ('b8e6080c-2e1f-2d00-ba77-438dfcee10eb', 'a01e02fb-5323-3b74-3b6c-438dfca7c6e8', 'd7a3fd9c-3715-e6f2-2e8b-438dfc374d45', '2005-11-30 19:23:40', 0);
INSERT INTO accounts_contacts VALUES ('58923af1-4edb-e2a7-bd93-438dfc735b73', '56cb61b8-e7dd-b6b6-658b-438dfc7604c4', '1cea29e6-0f31-0943-b9ab-438dfc45d065', '2005-11-30 19:23:40', 0);
INSERT INTO accounts_contacts VALUES ('926c9bd5-e0f4-ccd7-3363-438dfc309664', '90d0e5a4-2309-98b0-2202-438dfc2e1419', '6a0493ef-90c2-3391-e434-438dfc67e7f3', '2005-11-30 19:23:40', 0);
INSERT INTO accounts_contacts VALUES ('d8606ebf-1570-17c7-2de2-438dfc558e73', 'd6b31e1c-b1e4-dc96-721d-438dfc33a4ef', 'a672e98c-171b-2ec5-7d03-438dfc20800e', '2005-11-30 19:23:40', 0);
INSERT INTO accounts_contacts VALUES ('1e182c82-2273-dc32-8481-438dfc1f3be8', '1c8485e1-5cec-6b42-3293-438dfc135811', 'e9bbdad1-2981-a54e-4e5b-438dfc08455d', '2005-11-30 19:23:41', 0);
INSERT INTO accounts_contacts VALUES ('5838ed87-1d2e-58ae-2507-438dfcde53ec', '56af216a-d09c-9d31-e211-438dfce4d5c5', '2f921331-569e-4ebf-b85f-438dfc2a8506', '2005-11-30 19:23:41', 0);
INSERT INTO accounts_contacts VALUES ('9285b8aa-8fe8-2bd0-38a9-438dfcf6b350', '90f7ef73-4ad9-2c4c-82d0-438dfce765ff', '69c01b1b-cc6d-c6ba-7d82-438dfcb29df2', '2005-11-30 19:23:41', 0);
INSERT INTO accounts_contacts VALUES ('cf6f100a-2393-7b07-fd82-438dfc937a42', 'cde20296-3de6-fc19-d310-438dfc03c555', 'a6a6780e-665a-b236-013e-438dfcb9b481', '2005-11-30 19:23:41', 0);
INSERT INTO accounts_contacts VALUES ('b6910614-95e3-5bcc-9a9c-438dfc1271cb', '9d8c0b18-7372-69d1-6be8-438dfcd4558b', 'e0bf6505-a4cb-5da4-ff16-438dfc3160c7', '2005-11-30 19:23:42', 0);
INSERT INTO accounts_contacts VALUES ('4fc3435f-1127-3533-3d59-438dfce33e26', '4e2b4253-e78a-32ce-c712-438dfc2d314b', '1cc1c1ae-8282-a9b8-0990-438dfc21f836', '2005-11-30 19:23:42', 0);
INSERT INTO accounts_contacts VALUES ('8a18a522-4549-2581-cd5a-438dfcd951fe', '887521e0-0e20-da6e-ea58-438dfc72315e', '61281b35-9522-a961-b110-438dfc96ffd5', '2005-11-30 19:23:42', 0);
INSERT INTO accounts_contacts VALUES ('d156d41d-5444-59d3-38b3-438dfc150ae8', 'cfc38a01-3bd8-a4b7-eba3-438dfc1a85b0', '9b8d325f-2245-2777-7458-438dfcf98dff', '2005-11-30 19:23:42', 0);
INSERT INTO accounts_contacts VALUES ('d3f303b5-b9c5-4dcf-d4da-438dfc342aa9', 'bade053c-d997-8b4b-cced-438dfcac3d46', 'e2a26fcb-15b9-e3f4-5278-438dfcd05868', '2005-11-30 19:23:43', 0);
INSERT INTO accounts_contacts VALUES ('67a0ca04-80be-5b5b-4607-438dfc78a1aa', '6608318a-ac2d-35fb-1471-438dfcac1672', '1ec4e7bb-052b-c1a8-6d80-438dfc3ef908', '2005-11-30 19:23:43', 0);
INSERT INTO accounts_contacts VALUES ('a52bf71a-417e-e682-3d5e-438dfccc5fe0', 'a39bb548-db86-a9dc-d231-438dfcd858fb', '78f888c0-fbe2-aa7e-16ba-438dfceac795', '2005-11-30 19:23:43', 0);
INSERT INTO accounts_contacts VALUES ('d6f285d5-df8f-0a09-e8d9-438dfc3ff252', 'd55e8c1b-3fc8-c1be-feae-438dfcd8f770', 'b7b06c1d-d4d2-7a12-0c06-438dfc86b73a', '2005-11-30 19:23:43', 0);
INSERT INTO accounts_contacts VALUES ('2894cb35-1c1f-853f-de54-438dfcf174ae', '26f11194-b4ff-44b8-2680-438dfcd33c32', 'e85850ac-0a63-0b69-a9b1-438dfca59923', '2005-11-30 19:23:44', 0);
INSERT INTO accounts_contacts VALUES ('58dffa4a-5575-8ea8-b53d-438dfcc0f1ef', '5752ff12-6ad7-7a9e-726f-438dfc824f86', '3a070ce3-f7cd-617d-d237-438dfc16a689', '2005-11-30 19:23:44', 0);
INSERT INTO accounts_contacts VALUES ('896c3a5e-7b13-fa2e-5118-438dfcf7a530', '87b485b5-ce63-ebc4-f089-438dfcbc41da', '6a7528ab-6435-5063-cfd9-438dfce53729', '2005-11-30 19:23:44', 0);
INSERT INTO accounts_contacts VALUES ('bc4e0128-6cd8-0975-8bad-438dfc071f47', 'bab9ce10-9fe7-2fd9-b79d-438dfcae3c18', '9af11752-a9fe-aecb-fab7-438dfc778a8b', '2005-11-30 19:23:44', 0);
INSERT INTO accounts_contacts VALUES ('359306f3-aa49-f567-09e9-438dfc5d963d', '1c45010a-590b-2499-51e4-438dfcb8c868', 'cdaa34ca-831d-c9d6-c0e5-438dfc14756d', '2005-11-30 19:23:45', 0);
INSERT INTO accounts_contacts VALUES ('3eaed1a7-778b-f800-df32-438dfc4e5560', '3d20fec9-848b-db2c-6c49-438dfc9bea04', '14b514b2-e83e-11d1-1217-438dfc8c5156', '2005-11-30 19:23:45', 0);
INSERT INTO accounts_contacts VALUES ('7ac2e2ad-ef5d-c3a1-569e-438dfc06604c', '7930a630-ac9f-f2a3-ad7e-438dfc0b3028', '50293355-7599-eea7-5a72-438dfcfaa9d6', '2005-11-30 19:23:45', 0);
INSERT INTO accounts_contacts VALUES ('b90c899c-6add-b23d-375f-438dfcc4053e', 'b77f56d6-389b-6898-abf5-438dfccf3cf3', '8c41aa8f-d82c-2dd1-6752-438dfc68590b', '2005-11-30 19:23:45', 0);
INSERT INTO accounts_contacts VALUES ('bd8a0660-3c84-0004-fb15-438dfcd40ddc', 'a3990958-7a12-100a-1f3b-438dfc87c3d0', 'ca6288e8-018b-a6bb-6c4f-438dfc1d6b02', '2005-11-30 19:23:46', 0);
INSERT INTO accounts_contacts VALUES ('3c16e0f8-1fe5-96fe-6075-438dfcae3cee', '3a8535d2-5cf7-62f9-3fe1-438dfcf39bf2', '1d240a24-733d-3ab7-64c1-438dfc3357a2', '2005-11-30 19:23:46', 0);
INSERT INTO accounts_contacts VALUES ('83b9ed4e-8c67-bc32-c707-438dfc6f60a1', '822dce2c-8021-cd70-15b3-438dfcc64438', '4d633ea8-f28f-16a7-fbbd-438dfcce24b5', '2005-11-30 19:23:46', 0);
INSERT INTO accounts_contacts VALUES ('b68b9161-13f5-6719-3059-438dfc7719be', 'b4febc18-1d48-5836-2509-438dfc90072d', '954bd18b-4cad-5731-0c27-438dfc7a98e1', '2005-11-30 19:23:46', 0);
INSERT INTO accounts_contacts VALUES ('f266fadb-8dd6-0557-5a98-438dfcad96ef', 'f0cb9cb0-a291-1c1d-564b-438dfc1da78c', 'c7ee6c19-78aa-9877-288e-438dfc64ad91', '2005-11-30 19:23:46', 0);
INSERT INTO accounts_contacts VALUES ('2e859708-cd7f-fe99-8c21-438dfc74f5af', '2cf622a8-94fb-5109-fc63-438dfc4a82e9', 'fcc0072c-570b-aa7a-0a10-438dfca14c06', '2005-11-30 19:23:47', 0);
INSERT INTO accounts_contacts VALUES ('5ecd9073-c9fb-954c-de1d-438dfc67804f', '5d3eca3c-cf01-5c8c-1706-438dfc60cfda', '4002a8d9-2b45-20ad-7490-438dfcd3c7b9', '2005-11-30 19:23:47', 0);
INSERT INTO accounts_contacts VALUES ('9b468fc4-db41-a61e-39e1-438dfc42cf6b', '99a91e7c-f9c0-532f-0bfb-438dfc4a11fd', '704e62a8-3a73-3800-3d63-438dfc87d2ce', '2005-11-30 19:23:47', 0);
INSERT INTO accounts_contacts VALUES ('da0bf967-879b-fbcc-c184-438dfc95dd0b', 'd86fae36-81e4-de00-8e3f-438dfc21fc9b', 'af242932-aa0d-8446-5bea-438dfcc32b6c', '2005-11-30 19:23:47', 0);
INSERT INTO accounts_contacts VALUES ('1609f3ce-1edd-1523-c1d9-438dfca1245a', '147b2489-36dc-2f09-3903-438dfc4734b0', 'eb81ef28-ed52-2cdd-0492-438dfcb8efaf', '2005-11-30 19:23:48', 0);
INSERT INTO accounts_contacts VALUES ('77d8e430-584e-44f1-86d8-438dfc3ec87d', '7635cae4-3828-1392-4da9-438dfc87d092', '278d5dfa-a9bd-1405-8b20-438dfcf24c04', '2005-11-30 19:23:48', 0);
INSERT INTO accounts_contacts VALUES ('b71c0c16-6f6c-4e60-4e06-438dfcaacf0b', 'b58e5272-5ea4-9443-f44a-438dfce6fec9', '893518ed-1f3c-bf65-29d9-438dfc2bba65', '2005-11-30 19:23:48', 0);
INSERT INTO accounts_contacts VALUES ('f3c80fcf-0f97-74e7-4b1a-438dfc4ecf3e', 'f234e275-ffcd-557e-4d81-438dfcd1b393', 'c8881c14-f62e-59f6-9d97-438dfcd0c92a', '2005-11-30 19:23:49', 0);
INSERT INTO accounts_contacts VALUES ('2fdbde5f-c9f9-29b4-d433-438dfcd06125', '2e474380-4b0d-c596-590d-438dfc79f61d', '112a9128-7496-d4c3-c741-438dfc78433a', '2005-11-30 19:23:49', 0);
INSERT INTO accounts_contacts VALUES ('79b0a189-520f-21f5-a814-438dfc1acf7c', '77f91f9b-84a1-6bd8-dec7-438dfc3f9d24', '41489b20-3b66-0f87-0ed8-438dfcba09b7', '2005-11-30 19:23:49', 0);
INSERT INTO accounts_contacts VALUES ('bb4db9c6-7d73-22a2-657e-438dfc3f5f9f', 'b9ad170e-8067-fe08-9c79-438dfc60419c', '8c4df6e9-bf3c-6c7f-d616-438dfcdc2492', '2005-11-30 19:23:49', 0);
INSERT INTO accounts_contacts VALUES ('63f40917-a8d8-1296-9a2f-438dfcc13ac8', '494d0ac1-b017-7460-e98d-438dfc237689', 'cd076a95-a03a-8166-54fe-438dfcdae315', '2005-11-30 19:23:50', 0);
INSERT INTO accounts_contacts VALUES ('51deceee-aa9e-c545-7171-438dfc423ed1', '502d9b48-9ad9-ce38-0d0e-438dfc5d590f', '1820ef8f-c74c-624d-e2d1-438dfc773520', '2005-11-30 19:23:50', 0);
INSERT INTO accounts_contacts VALUES ('839f56bc-a67a-0200-9613-438dfc94c227', '81f6d360-9ab3-1076-e21d-438dfc184ef7', '63d3a33d-c0b8-3e5e-6424-438dfca3b887', '2005-11-30 19:23:50', 0);
INSERT INTO accounts_contacts VALUES ('d13a5eb1-48cc-c2a5-eb8d-438dfc8607a3', 'cf990eed-1885-4a81-a271-438dfcdf3872', '9563448c-792e-d962-288f-438dfc98c60f', '2005-11-30 19:23:50', 0);
INSERT INTO accounts_contacts VALUES ('1a5e0b80-72a9-b65c-53e6-438dfc884f5a', '18cba21e-71a2-ccfd-5744-438dfc146340', 'e27af1d7-4419-a694-0b12-438dfc6adf35', '2005-11-30 19:23:51', 0);
INSERT INTO accounts_contacts VALUES ('4a82cd7e-2a77-8f14-c70b-438dfcd9a21b', '48eb9490-cd12-78d8-f23a-438dfcd710f7', '2bc0a270-26fc-7ae9-9313-438dfcf04250', '2005-11-30 19:23:51', 0);
INSERT INTO accounts_contacts VALUES ('95e94848-7541-742e-22e6-438dfc53561a', '94313baf-8be7-e7d7-ebab-438dfcb269f8', '5bf631be-1622-a5e9-1a8d-438dfcff57b6', '2005-11-30 19:23:51', 0);
INSERT INTO accounts_contacts VALUES ('e3e08ed3-c49c-a4a0-54d1-438dfc041b52', 'e24cdae9-4e25-7855-aeb2-438dfc5df48e', 'aa0b180a-0efd-40d1-5435-438dfc48d2de', '2005-11-30 19:23:51', 0);
INSERT INTO accounts_contacts VALUES ('4907011a-da39-92a8-608c-438dfc268c3c', '47626928-0bb3-1ee6-2bd4-438dfc951437', '1408024c-90ca-89db-f420-438dfc69555c', '2005-11-30 19:23:52', 0);
INSERT INTO accounts_contacts VALUES ('878967ba-1425-22dc-6301-438dfcb27489', '85f66aac-803c-c86c-329b-438dfc45eea2', '5aa4340e-d0ac-4dbe-2eda-438dfc2ffaca', '2005-11-30 19:23:52', 0);
INSERT INTO accounts_contacts VALUES ('baf445e3-fc1d-d9ad-5ab1-438dfc1d9545', 'b96307dd-a8e5-0f5d-ef1e-438dfcee6329', '996773d8-7459-442b-e781-438dfc17a340', '2005-11-30 19:23:52', 0);
INSERT INTO accounts_contacts VALUES ('eb3eee56-8002-5867-f156-438dfc103ef9', 'e993d6a1-f781-3d73-8cb2-438dfc26e43c', 'cc6b9706-5113-ca5b-cb3b-438dfc78598d', '2005-11-30 19:23:52', 0);
INSERT INTO accounts_contacts VALUES ('278725d2-2e4b-033d-2071-438dfc4ffb6d', '25f2e10e-7b9c-457c-9b9d-438dfcd282c6', '88570831-b950-4b7e-6cd1-438dfc241b2e', '2005-11-30 19:23:53', 0);
INSERT INTO accounts_contacts VALUES ('660eebdb-02d1-d12f-055c-438dfcaa77e9', '647a56d9-9fb6-b221-d8e8-438dfc61c201', '390ee98e-8b3c-5965-e4fd-438dfc1c6eaa', '2005-11-30 19:23:53', 0);
INSERT INTO accounts_contacts VALUES ('a7599da9-b63b-4ea9-d68e-438dfc4d3102', 'a5817fb8-5cff-2045-7166-438dfcae3770', '778b80e7-794c-0a12-6f96-438dfc41229c', '2005-11-30 19:23:53', 0);
INSERT INTO accounts_contacts VALUES ('f4109320-87dd-67d8-eb4a-438dfc6430dc', 'f28115ac-4f46-90fe-77d1-438dfcde5811', 'b8db6e77-2347-fbbf-e50e-438dfc33ba76', '2005-11-30 19:23:53', 0);
INSERT INTO accounts_contacts VALUES ('3eaf9874-78a3-ddbd-4b93-438dfcf554a7', '3d1c3b92-4805-a939-f4ff-438dfcc42335', '118c01c7-38b6-1470-71ce-438dfc47cedc', '2005-11-30 19:23:54', 0);
INSERT INTO accounts_contacts VALUES ('7d9c5097-c016-9bcf-ae0c-438dfc6fa68e', '7bfda33b-4110-a797-4681-438dfcba3106', '501fc4d0-306b-3755-b0e4-438dfc055616', '2005-11-30 19:23:54', 0);
INSERT INTO accounts_contacts VALUES ('b105065c-4a98-74e9-d456-438dfc8835bf', 'af688ad9-d34f-83fb-13b0-438dfc4b3a44', '8f64ce1e-2846-22cf-52b1-438dfc1e4865', '2005-11-30 19:23:54', 0);
INSERT INTO accounts_contacts VALUES ('f020a84e-b4fd-d2e3-dad7-438dfc7484ab', 'ee86b41f-d0e9-f557-2c06-438dfc24766b', 'd0f6f8f3-3f8d-6ac9-07a2-438dfca4d5a3', '2005-11-30 19:23:54', 0);
INSERT INTO accounts_contacts VALUES ('3b55e1cb-6484-c75d-37c9-438dfc4aa899', '39b7d838-a700-3141-2f1b-438dfcc1f3a2', 'd844099c-3218-4a53-04fd-438dfcf7fe24', '2005-11-30 19:23:55', 0);
INSERT INTO accounts_contacts VALUES ('6bbf6a1c-0a73-d23f-ad84-438dfcadc481', '6a2ca102-d649-aea5-1962-438dfc04ba5c', '4cc59be8-6a2b-045e-fffa-438dfcb7ecd1', '2005-11-30 19:23:55', 0);
INSERT INTO accounts_contacts VALUES ('9d641a2c-8b39-a2d0-19b6-438dfc4f98a0', '9bc93c9f-3a1d-5f63-5938-438dfc8fbaa8', '7e36e18a-2a32-95e6-141d-438dfc516b2e', '2005-11-30 19:23:55', 0);
INSERT INTO accounts_contacts VALUES ('8c4e0ce1-1127-80c6-97f2-438dfcc5fc1e', 'dd5c2849-0262-cc17-9d4a-438dfc7322e9', 'b165ae47-2fc0-be05-a089-438dfc950f45', '2005-11-30 19:23:56', 0);
INSERT INTO accounts_contacts VALUES ('4807a6d6-9d58-8303-9bbf-438dfca859cc', '46791858-276c-1e43-9e1e-438dfc4edf40', '1a2b5888-e59b-c7cd-18f1-438dfc046cd4', '2005-11-30 19:23:56', 0);
INSERT INTO accounts_contacts VALUES ('96e05731-e151-a986-2dde-438dfc07c628', '9546027a-5974-0876-c34b-438dfc6fd190', '598d45b0-cf4d-be31-0b37-438dfcaf36de', '2005-11-30 19:23:56', 0);
INSERT INTO accounts_contacts VALUES ('129b35fe-8e52-004b-829a-438dfcf56ea7', '1107abcb-2592-d30f-30e1-438dfc8a936d', 'ba2d0e92-2b82-c7a0-aefc-438dfc5bbc75', '2005-11-30 19:23:57', 0);
INSERT INTO accounts_contacts VALUES ('523d4308-29b7-fce4-ed83-438dfcfb4b91', '508c682f-0b6e-e691-1610-438dfc858040', '2414a861-856d-d2e2-bf08-438dfc9407bf', '2005-11-30 19:23:57', 0);
INSERT INTO accounts_contacts VALUES ('91d8e515-9a35-6a21-8b3a-438dfc6454b1', '90410cf4-1b15-d65e-5635-438dfc4ec6f6', '638ef092-a33f-0e0c-ebc2-438dfc121ac0', '2005-11-30 19:23:57', 0);
INSERT INTO accounts_contacts VALUES ('c4993d17-c62d-9a67-a574-438dfc0c6a79', 'c3092488-9f4f-557e-4326-438dfc1f1783', 'a5efc69d-86e3-c51d-1f94-438dfc385db9', '2005-11-30 19:23:57', 0);
INSERT INTO accounts_contacts VALUES ('bfc00c14-f2c2-0897-c32f-438dfcdf3a3d', 'f351e994-0cbf-11d1-afd7-438dfcdd8663', 'd6020c11-a159-8e9a-a1d7-438dfc1b496a', '2005-11-30 19:23:58', 0);
INSERT INTO accounts_contacts VALUES ('3128077d-e90d-4f0d-7237-438dfc2e1876', '2f935a6e-0e7b-6477-4e09-438dfce0b79d', '1237d33b-03c3-419a-73ea-438dfcbee32d', '2005-11-30 19:23:58', 0);
INSERT INTO accounts_contacts VALUES ('910792f3-0ed0-a10d-9e55-438dfc8bd66d', '8f607db9-9258-4c31-cc13-438dfcece24f', '428a4aeb-d8e7-e5f8-f4d6-438dfc715771', '2005-11-30 19:23:58', 0);
INSERT INTO accounts_contacts VALUES ('c3eb0e76-7785-08de-0458-438dfcf7602a', 'c2471e28-99e0-e2a7-097c-438dfc585d31', 'a29bdad9-c920-afe4-d906-438dfcf200d1', '2005-11-30 19:23:58', 0);
INSERT INTO accounts_contacts VALUES ('24c0026d-5333-0e5a-03df-438dfc700924', 'f2a160ac-5f4d-5c07-e08f-438dfc912f56', 'd57a05ea-6231-9c57-f684-438dfc0ece79', '2005-11-30 19:23:59', 0);
INSERT INTO accounts_contacts VALUES ('309b92f2-cb5b-e7fa-3e73-438dfcfb0eed', '2f090575-2a92-fe42-f915-438dfc8dba89', '11a182e9-8983-9899-e85b-438dfcae42d2', '2005-11-30 19:23:59', 0);
INSERT INTO accounts_contacts VALUES ('91e27eee-25cc-752b-78ee-438dfc034a11', '9051dfd8-fb78-9cda-1f36-438dfc52b13d', '421d206d-afa1-4024-ff07-438dfc380941', '2005-11-30 19:23:59', 0);
INSERT INTO accounts_contacts VALUES ('c4bc6b29-e55e-0f00-3234-438dfc9e460f', 'c3264cce-5f48-1508-6376-438dfcfeb668', 'a5ff1c0f-fcab-e1db-053a-438dfc953533', '2005-11-30 19:23:59', 0);
INSERT INTO accounts_contacts VALUES ('fd0009ca-d890-6a21-bb81-438dfcada722', 'f385d7bf-e40a-3f1c-ff08-438dfc2acc16', 'd63223ae-3fcd-0bbd-c6e9-438dfc2b5132', '2005-11-30 19:24:00', 0);
INSERT INTO accounts_contacts VALUES ('42674a42-dc1a-2b36-61d1-438dfc30a850', '40b06e1d-4a37-6af0-0405-438dfcd063a4', '1291fd0e-0b21-b243-e90a-438dfcc8a6d4', '2005-11-30 19:24:00', 0);
INSERT INTO accounts_contacts VALUES ('7275d6db-1665-e983-ff19-438dfce896c3', '70e0970f-4265-1413-845d-438dfca8b65e', '53b25086-df00-b865-87bf-438dfc2e9e2a', '2005-11-30 19:24:00', 0);
INSERT INTO accounts_contacts VALUES ('c753f7c8-b04f-98d5-a8c0-438dfc390879', 'c5bfd61c-cbe7-9559-381b-438dfce18d6d', '84a158a8-9b77-8763-f48e-438dfc86a84a', '2005-11-30 19:24:00', 0);
INSERT INTO accounts_contacts VALUES ('3553ef2c-a76a-be93-fee3-438dfc40b929', '33be06d6-efe0-0f8d-0d2f-438dfcab36b9', 'd8db292d-d903-51c1-7629-438dfc04dae1', '2005-11-30 19:24:01', 0);
INSERT INTO accounts_contacts VALUES ('65a0e6f6-e0e0-df72-e425-438dfcdf229b', '640acae0-6547-32dd-61f1-438dfc8a2d39', '46c1629b-ff53-12b7-de33-438dfc79acc0', '2005-11-30 19:24:01', 0);
INSERT INTO accounts_contacts VALUES ('a9cee500-bebd-e133-0aa0-438dfc8236bf', 'a833eb1e-5efe-bd84-b225-438dfc67ffad', '7720b17b-d7d0-e845-e74d-438dfccdb560', '2005-11-30 19:24:01', 0);
INSERT INTO accounts_contacts VALUES ('eedbd97b-de86-6ea7-d789-438dfc75841d', 'eca6e398-a24e-4565-4cf5-438dfc086883', 'bcdea145-1765-f3d6-1f3f-438dfc89a81b', '2005-11-30 19:24:01', 0);
INSERT INTO accounts_contacts VALUES ('4283e4f8-fecd-8814-9528-438dfc3d6874', '40e9f23d-a97a-f85d-d6f8-438dfcc9049c', 'f8fd0b41-cad8-e5ba-85c9-438dfc45bf5c', '2005-11-30 19:24:02', 0);
INSERT INTO accounts_contacts VALUES ('853fe8c3-8697-3480-4c88-438dfc0b0f91', '8391100a-6bd7-9d7f-8123-438dfcae847a', '5478ecd4-649f-5f03-7ef5-438dfc409603', '2005-11-30 19:24:02', 0);
INSERT INTO accounts_contacts VALUES ('ecfecd59-1ebd-c741-9808-438dfc5fb229', 'eb590a8b-6816-1f0a-a6a2-438dfc249b1f', '9743fa19-2c3a-af48-3303-438dfc988c03', '2005-11-30 19:24:02', 0);
INSERT INTO accounts_contacts VALUES ('5e3154c4-14ba-7d2c-94a9-438dfc28ce62', '5c91380e-c8fa-d83b-9203-438dfc5feb75', 'aac40ead-acb0-b31d-1133-438dfc9a4799', '2005-11-30 19:24:03', 0);
INSERT INTO accounts_contacts VALUES ('8f6b46f5-7e27-5f78-b4fd-438dfc3545aa', '8dca62c5-cb1b-c41b-3f33-438dfce842fc', '6ffaba8d-eb1f-c28b-8644-438dfcbea0e4', '2005-11-30 19:24:03', 0);
INSERT INTO accounts_contacts VALUES ('e58b5588-000d-a3bc-ee5a-438dfc657abc', 'e3edeb09-fb89-e2c2-1322-438dfc7bfad9', 'a13886ab-0e56-9291-0447-438dfc4546dd', '2005-11-30 19:24:03', 0);
INSERT INTO accounts_contacts VALUES ('21ab3f07-1fdb-4a57-4a66-438dfc30ab98', '20161e89-2100-9258-9af6-438dfcdb1a49', '2ca40a4f-c1a5-8085-4cbf-438dfcd9c2a9', '2005-11-30 19:24:04', 0);
INSERT INTO accounts_contacts VALUES ('7535440f-2b35-b412-5e60-438dfc009109', '7394d6e9-539c-5db8-9a7a-438dfcbe0988', '33126c17-e9a1-4bd9-a94f-438dfc78c4ee', '2005-11-30 19:24:04', 0);
INSERT INTO accounts_contacts VALUES ('bad09846-388d-3e1b-4c62-438dfcf62c78', 'b93dac3a-e290-5d45-110a-438dfc602cdd', '86d63404-ca50-c4d2-1038-438dfc0d2ce3', '2005-11-30 19:24:04', 0);
INSERT INTO accounts_contacts VALUES ('eb08cd61-d183-95db-59f1-438dfcd255fb', 'e96ce373-5de7-3ff5-e269-438dfc55dd58', 'cc3411e6-b2f4-24e2-08cd-438dfcde2680', '2005-11-30 19:24:04', 0);
INSERT INTO accounts_contacts VALUES ('270df2b0-e974-9157-2499-438dfc7a1f95', '25710323-2c57-7caa-a4f2-438dfcfce895', '85840e37-3aaa-7bc1-b257-438dfc9b70fe', '2005-11-30 19:24:05', 0);
INSERT INTO accounts_contacts VALUES ('6958deac-45d9-77dd-8793-438dfc248515', '67aa3a74-86ba-bffd-2fe2-438dfc3521d1', '386ecec0-8eb5-ce3c-0c4d-438dfc08982a', '2005-11-30 19:24:05', 0);
INSERT INTO accounts_contacts VALUES ('d345d16f-a9e4-fbfe-88b7-438dfc63ece2', 'ad950b55-a66a-cc8a-93b1-438dfcd921bc', '7b1a3ffe-b883-9f36-d29d-438dfc6a9109', '2005-11-30 19:24:05', 0);
INSERT INTO accounts_contacts VALUES ('f8570e35-15dd-a4ab-5655-438dfc49fb2e', 'de200f07-ba11-2ae4-faf7-438dfc74839f', 'e4c2a7f1-29e7-e674-dfda-438dfccc2bc2', '2005-11-30 19:24:06', 0);
INSERT INTO accounts_contacts VALUES ('3fd7cf51-22c9-b803-ade1-438dfc24aec4', '3e3d3d92-3860-f8f4-f280-438dfc2cf2ea', '20eb8a51-b7ce-0529-75b1-438dfc371e81', '2005-11-30 19:24:06', 0);
INSERT INTO accounts_contacts VALUES ('7025086b-d2b2-c1d8-368d-438dfcc12910', '6e88151b-682d-7a0a-dd80-438dfc5478d2', '514fcdd2-d85d-1a7d-7f1d-438dfc1bfc2b', '2005-11-30 19:24:06', 0);
INSERT INTO accounts_contacts VALUES ('c8002618-2aec-9526-b896-438dfc7d773b', 'c6681a81-3939-6a60-4e07-438dfcf0e0a4', '818ba130-82a0-510e-243c-438dfcadc657', '2005-11-30 19:24:06', 0);
INSERT INTO accounts_contacts VALUES ('422e09c5-6951-552e-0a5e-438dfc41ce2f', '286e0e17-2430-a3f7-8cc6-438dfc4fa0cf', 'd967f00f-b4fb-546a-e2cd-438dfc51e139', '2005-11-30 19:24:07', 0);
INSERT INTO accounts_contacts VALUES ('59d547ed-d806-8098-8e9f-438dfc334050', '58208eee-c9c1-125e-3811-438dfc7112b9', '159db820-3506-22d0-baae-438dfc9d48c0', '2005-11-30 19:24:07', 0);
INSERT INTO accounts_contacts VALUES ('8a57f830-a969-ee99-fec9-438dfc595f0e', '88c81d27-3d12-9510-ae38-438dfcf82eab', '6b413b0a-a8f4-82f5-bdd6-438dfc03fea7', '2005-11-30 19:24:07', 0);
INSERT INTO accounts_contacts VALUES ('d0729ce4-8efa-f538-8ce6-438dfc3bc4e5', 'cedfa7cf-ea3f-a340-fcaa-438dfc12e9ce', '9c278db4-ede9-c13a-af84-438dfcd5ae49', '2005-11-30 19:24:07', 0);
INSERT INTO accounts_contacts VALUES ('324ccfee-f0be-df43-f2f6-438dfcb924fb', '30b62c36-b386-4290-0e47-438dfc4a2bf5', 'a410043f-7a9a-f5fe-d34c-438dfc51da32', '2005-11-30 19:24:08', 0);
INSERT INTO accounts_contacts VALUES ('88698ef8-5c87-255d-2310-438dfcdf6870', '86d71b11-0761-0bf5-e5d3-438dfcce0ef4', '439df1d9-a1d2-938f-fcbc-438dfcc0b382', '2005-11-30 19:24:08', 0);
INSERT INTO accounts_contacts VALUES ('1a8a0cd1-a769-de95-e665-438dfc1ea2df', 'f3000bb9-e3c0-ff62-e375-438dfca40cdf', '9a01d899-3cd3-82bc-4879-438dfc4aa427', '2005-11-30 19:24:09', 0);
INSERT INTO accounts_contacts VALUES ('334db57e-730f-197b-ee28-438dfc9941ea', '31b5c226-2e04-a196-3c19-438dfc174d3e', '13b9ce8d-5a7f-dc60-5f5d-438dfc417588', '2005-11-30 19:24:09', 0);
INSERT INTO accounts_contacts VALUES ('a0843298-2bfa-fcbe-4c8c-438dfc1b0a04', '9eeb232a-a4f1-ed2c-c143-438dfcceb376', '451eba4c-ebbc-e355-a55d-438dfc6dd0bf', '2005-11-30 19:24:09', 0);
INSERT INTO accounts_contacts VALUES ('d3a3095e-d24c-728a-001d-438dfcbe0573', 'd209c8fd-6c01-7e91-8c0e-438dfc8a1504', 'b4f569b4-c6a8-b257-fcb4-438dfcbcb5f0', '2005-11-30 19:24:09', 0);
INSERT INTO accounts_contacts VALUES ('246aa272-8407-9b36-3c0a-438dfc0de3b4', '22c8beda-adff-08ba-dbeb-438dfc13450f', 'e5ff98ed-075f-7aa5-56fa-438dfc049120', '2005-11-30 19:24:10', 0);
INSERT INTO accounts_contacts VALUES ('6898db79-f078-5831-e943-438dfcbe5efc', '66f126ef-b713-3247-7b77-438dfc658ac7', '361fafb3-51ba-58de-391b-438dfc2a0aec', '2005-11-30 19:24:10', 0);
INSERT INTO accounts_contacts VALUES ('b03614d5-3bda-7418-5e8a-438dfc8c02db', 'aea4831c-5231-61c4-7802-438dfcaf4014', '79e65b4a-b856-c71a-19a1-438dfc5344ec', '2005-11-30 19:24:10', 0);
INSERT INTO accounts_contacts VALUES ('e0bedc6f-089e-6ccf-f2c7-438dfc5fe32d', 'df213b23-496d-3620-2bbf-438dfc9f8d9a', 'c1abebb3-fd9d-f3f4-8bc6-438dfc756f30', '2005-11-30 19:24:10', 0);
INSERT INTO accounts_contacts VALUES ('5847a3ed-c8b1-cfc5-4ede-438dfce99c93', '56838ea9-aa3d-5423-9872-438dfcf63782', 'f21a7b1f-7757-acc5-7e52-438dfcb88dc0', '2005-11-30 19:24:11', 0);
INSERT INTO accounts_contacts VALUES ('88409870-7adb-b235-873c-438dfcf16c31', '86a907ed-4424-dc00-a4e4-438dfc4e9d9d', '698916c3-7e8c-21c5-1f38-438dfc3931c8', '2005-11-30 19:24:11', 0);
INSERT INTO accounts_contacts VALUES ('bb7f0195-e5ba-5659-01d1-438dfce9d4be', 'b9e4c8ef-9d50-e6a3-0e62-438dfc2643ad', '99edc13c-8d09-83c1-83b2-438dfc899358', '2005-11-30 19:24:11', 0);
INSERT INTO accounts_contacts VALUES ('1f9f4e26-b95f-da15-0817-438dfc0f753c', '1e0469ab-9117-83ae-fed5-438dfccb0bc6', 'ccda2c25-4079-1062-d2c6-438dfc514858', '2005-11-30 19:24:12', 0);
INSERT INTO accounts_contacts VALUES ('4fd7d8f7-2b40-1772-3c63-438dfc99f392', '4e3f1c21-4148-69b1-ebe1-438dfcb31413', '310c5866-e450-bfc4-afcc-438dfc5e80b4', '2005-11-30 19:24:12', 0);
INSERT INTO accounts_contacts VALUES ('8004bd7e-e762-73fc-4014-438dfc926ae0', '7e7287ae-b7d4-2a06-bedc-438dfc4fad59', '61688ffe-959a-5488-a5b9-438dfc944381', '2005-11-30 19:24:12', 0);
INSERT INTO accounts_contacts VALUES ('b344bd6d-c65d-1c73-7551-438dfc5534d3', 'b1adefbb-4bb8-b05f-048e-438dfccf6e48', '916437d4-a690-4aea-354a-438dfca40de6', '2005-11-30 19:24:12', 0);
INSERT INTO accounts_contacts VALUES ('1819ca3c-a938-67d2-1998-438dfc88fb71', '1667cb26-d3b2-6f41-a212-438dfc8a1ecb', 'c4c60cc4-e0e3-66ee-43ed-438dfc2a8f86', '2005-11-30 19:24:13', 0);
INSERT INTO accounts_contacts VALUES ('5cfc90af-fee6-6e6f-ba33-438dfc94ca8c', '5b62c09b-b0d7-b1f9-e7cb-438dfcf7080b', '2968bc75-db89-7fcb-56f8-438dfcf65bda', '2005-11-30 19:24:13', 0);
INSERT INTO accounts_contacts VALUES ('b94f97fa-864b-829d-ad1e-438dfc0489d6', 'b7af1167-99a1-a622-1342-438dfc3bb053', '6e579ced-dff1-b00e-054c-438dfcb0a2bf', '2005-11-30 19:24:13', 0);
INSERT INTO accounts_contacts VALUES ('1ecfcb0e-edb9-997d-24b6-438dfc51c48b', '1d21b0fb-22f4-2ec6-787a-438dfc998f7a', 'f3fa2d58-c633-1382-097e-438dfce35be4', '2005-11-30 19:24:14', 0);
INSERT INTO accounts_contacts VALUES ('4f219422-8498-4145-29c6-438dfc532fb3', '4d7872ae-56de-3337-d7aa-438dfc27e99c', '30363e25-8393-14c0-d0de-438dfc6cd1fe', '2005-11-30 19:24:14', 0);
INSERT INTO accounts_contacts VALUES ('abdb009a-d7df-3ab0-3405-438dfca37d1c', 'a7f84ad6-e17d-6838-af56-438dfc6045b3', '60a1fa34-84d7-e72b-2fbd-438dfc23de44', '2005-11-30 19:24:14', 0);
INSERT INTO accounts_contacts VALUES ('2a4c1fea-c8a3-e312-bd22-438dfcfdfa1c', 'dbd852b6-5847-51e5-2ca0-438dfca4c0f7', 'be2f892b-c4e9-bc8c-5209-438dfcf7aa79', '2005-11-30 19:24:15', 0);
INSERT INTO accounts_contacts VALUES ('5c3cf2be-084e-bf37-b014-438dfcc74824', '5a9d221b-2d53-70e0-7203-438dfc397e53', '3be4c4aa-56e8-3702-fcfd-438dfc276ebc', '2005-11-30 19:24:15', 0);
INSERT INTO accounts_contacts VALUES ('a32e9643-3e23-a6a0-be8f-438dfc213fd8', 'a19663de-1756-1933-f6e3-438dfc58729f', '6e20cb65-1e32-a00f-8b24-438dfc59657c', '2005-11-30 19:24:15', 0);
INSERT INTO accounts_contacts VALUES ('d7434667-33dc-3bad-a0a7-438dfcbbe0e0', 'd5a97764-c393-eaea-58bc-438dfcacb1dc', 'b7bf4834-8d96-03b7-3bbe-438dfcae3cd2', '2005-11-30 19:24:15', 0);
INSERT INTO accounts_contacts VALUES ('3f5085cf-60f5-7598-1d03-438dfc845a8e', '3d9feb84-fc2c-1a2c-c9a9-438dfc416697', 'e95db6e7-ddc6-81a1-45d6-438dfc91048c', '2005-11-30 19:24:16', 0);
INSERT INTO accounts_contacts VALUES ('b4093b0a-3e3b-00b5-a207-438dfcdbe2a3', 'b2685512-7246-0e04-8d4e-438dfc56e676', '51155650-c6fd-ca1e-6a67-438dfc197159', '2005-11-30 19:24:16', 0);
INSERT INTO accounts_contacts VALUES ('e4b31584-1808-007c-8ede-438dfcd87477', 'e31af5c5-7c04-fa01-257d-438dfcf37ba9', 'c5bfba5d-771e-4caa-ef86-438dfc5b8d25', '2005-11-30 19:24:16', 0);
INSERT INTO accounts_contacts VALUES ('76f6d86d-fa79-80d0-2bf6-438dfc612c67', '5fc05901-06d1-7fb1-128d-438dfc96ed66', '20100cbc-1024-71ea-4c44-438dfc40c76b', '2005-11-30 19:24:17', 0);
INSERT INTO accounts_contacts VALUES ('a753f620-df31-6fd0-3b95-438dfc1841cc', 'a5c0e5e2-40af-8afe-b64f-438dfc1519b9', '884c44e1-66a1-d00a-3fb0-438dfca704ba', '2005-11-30 19:24:17', 0);
INSERT INTO accounts_contacts VALUES ('2770db98-7000-23ed-c05f-438dfcca8770', '101f5693-007c-caa8-b449-438dfce62e4e', 'bb9a2963-700d-a74e-65e3-438dfccc85f8', '2005-11-30 19:24:18', 0);
INSERT INTO accounts_contacts VALUES ('57ce77ba-ab9f-bd81-046f-438dfc9e6832', '5634ef21-b974-2a6f-bc6a-438dfcc2748b', '38fcbc18-f72b-fbe8-81bb-438dfc45196a', '2005-11-30 19:24:18', 0);
INSERT INTO accounts_contacts VALUES ('881b8331-31e5-319a-93cb-438dfcea186b', '8686ff30-7b69-f3f3-c66d-438dfc3416f7', '6958a392-e1fd-f1b0-a66a-438dfc52fe10', '2005-11-30 19:24:18', 0);
INSERT INTO accounts_contacts VALUES ('1f0fb77d-e7f7-0d79-6ee4-438dfc1d824e', '1d6dce20-fd1b-58d6-7bfd-438dfc523409', '99f44c3f-87e7-9558-992e-438dfc055159', '2005-11-30 19:24:19', 0);
INSERT INTO accounts_contacts VALUES ('7b703454-fa87-2d30-f60a-438dfc4e75ca', '79d84faf-e692-3c6c-f10c-438dfc68485d', '30885088-ff80-58e7-e745-438dfcbcf297', '2005-11-30 19:24:19', 0);
INSERT INTO accounts_contacts VALUES ('af0a8cfe-0775-36c1-b9e4-438dfcef36ce', 'ad6d90cf-120f-4778-94f9-438dfcbb4b66', '8cde5ad7-4cd2-4365-1771-438dfcf53c75', '2005-11-30 19:24:19', 0);
INSERT INTO accounts_contacts VALUES ('180c854c-b70b-dc15-97de-438dfcafc80e', '16715109-d4b1-2eb3-7d82-438dfc9e1b52', 'c0a21503-5f76-f00e-48d9-438dfc082df1', '2005-11-30 19:24:20', 0);
INSERT INTO accounts_contacts VALUES ('48aef1b5-1d58-6ac0-1509-438dfc0b0f83', '47150fc9-3e20-53fa-ded0-438dfc698e87', '299f8caa-246a-2d76-cc17-438dfce96996', '2005-11-30 19:24:20', 0);
INSERT INTO accounts_contacts VALUES ('c1c5ed73-630c-ff7d-959b-438dfc417fa5', 'c01b3b25-d91f-2a22-8b48-438dfcdfec2a', '5bac5a31-8b26-551c-115a-438dfc10fa26', '2005-11-30 19:24:20', 0);
INSERT INTO accounts_contacts VALUES ('2af85c05-51e6-c8be-bfea-438dfc1e0b5c', '295fabdc-00a3-3a72-73d0-438dfc630da6', 'd3364601-0197-635a-5243-438dfc4ccd2b', '2005-11-30 19:24:21', 0);
INSERT INTO accounts_contacts VALUES ('cf6e429d-89f9-df0a-0e0e-438dfc0fcba2', 'b71edaad-1126-abe4-5b96-438dfc9c8e7b', '3c85e9b6-2a9c-6ac1-8654-438dfc6d6a4c', '2005-11-30 19:24:21', 0);


--
-- Data for Name: accounts_opportunities; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO accounts_opportunities VALUES ('ab5a52f0-f20b-755a-c238-438dfb8ed112', 'a9130d4f-4b18-75b1-a60e-438dfb3e91ab', 'a69dae1f-b2ee-1257-3895-438dfb8ea964', '2005-11-30 19:24:22', 0);
INSERT INTO accounts_opportunities VALUES ('aef8d823-4cbe-8d8a-a973-438dfb0d5767', 'acc0cd10-2955-e023-16a6-438dfb756fac', 'a69dae1f-b2ee-1257-3895-438dfb8ea964', '2005-11-30 19:24:22', 0);
INSERT INTO accounts_opportunities VALUES ('b3b1ef53-3641-a178-1219-438dfb5211ea', 'b171c0dc-1868-6f3b-cd40-438dfbd0ffac', 'a69dae1f-b2ee-1257-3895-438dfb8ea964', '2005-11-30 19:24:22', 0);
INSERT INTO accounts_opportunities VALUES ('b7415fc3-3b79-ce2f-ebd5-438dfbd0bea4', 'b508b238-98b3-b241-af76-438dfbcfe97a', 'a69dae1f-b2ee-1257-3895-438dfb8ea964', '2005-11-30 19:24:22', 0);
INSERT INTO accounts_opportunities VALUES ('bad5c379-1e14-a2a2-b498-438dfbdff4fb', 'b89ca586-f374-76c7-9bbf-438dfb7f5122', 'a69dae1f-b2ee-1257-3895-438dfb8ea964', '2005-11-30 19:24:22', 0);
INSERT INTO accounts_opportunities VALUES ('ed901e48-9f0e-e2e7-e8ce-438dfb2100fe', 'eb4c23ba-ba10-3f93-85e2-438dfb636f95', 'e908e57d-18d3-5ffa-f6f4-438dfb104441', '2005-11-30 19:24:22', 0);
INSERT INTO accounts_opportunities VALUES ('f12e9b9f-b595-423e-f821-438dfb4a3aa6', 'eeec795e-ba5f-a648-500e-438dfbdc68a0', 'e908e57d-18d3-5ffa-f6f4-438dfb104441', '2005-11-30 19:24:23', 0);
INSERT INTO accounts_opportunities VALUES ('a0a00bfd-5503-6bbe-25ae-438dfb6dc70f', 'f28d386f-f2c4-8352-389a-438dfbf326c2', 'e908e57d-18d3-5ffa-f6f4-438dfb104441', '2005-11-30 19:24:23', 0);
INSERT INTO accounts_opportunities VALUES ('44680430-162f-d4c4-2a5c-438dfb722a26', '20000e9a-664d-3ffe-b57c-438dfb9fe46c', 'e908e57d-18d3-5ffa-f6f4-438dfb104441', '2005-11-30 19:24:23', 0);
INSERT INTO accounts_opportunities VALUES ('7ea50a64-1179-9f6f-4a98-438dfbafe575', '5a480466-7328-4a1c-e7c9-438dfbd42012', 'e908e57d-18d3-5ffa-f6f4-438dfb104441', '2005-11-30 19:24:23', 0);
INSERT INTO accounts_opportunities VALUES ('1dc5958f-6c98-d179-fa8a-438dfbd2b900', '1aeeaa62-d3a2-5647-0e6e-438dfb2fbc94', '18ae2ab5-0bfd-980d-2519-438dfbda705b', '2005-11-30 19:24:23', 0);
INSERT INTO accounts_opportunities VALUES ('230f9dc7-d516-7de6-a6d1-438dfbddce17', '203816d6-65e8-3473-1d32-438dfbef4cdb', '18ae2ab5-0bfd-980d-2519-438dfbda705b', '2005-11-30 19:24:24', 0);
INSERT INTO accounts_opportunities VALUES ('27de0ca6-8104-8188-f60f-438dfb7ba748', '24721704-517e-7405-f8d2-438dfbdfa046', '18ae2ab5-0bfd-980d-2519-438dfbda705b', '2005-11-30 19:24:24', 0);
INSERT INTO accounts_opportunities VALUES ('2c2a99b5-457c-c42e-4860-438dfb6dd29d', '29574c57-f4ab-e2e9-3ba5-438dfbef747b', '18ae2ab5-0bfd-980d-2519-438dfbda705b', '2005-11-30 19:24:24', 0);
INSERT INTO accounts_opportunities VALUES ('30642a1e-03b2-7158-1883-438dfba2cf2f', '2d8c4adf-acdc-919c-0940-438dfb522c7a', '18ae2ab5-0bfd-980d-2519-438dfbda705b', '2005-11-30 19:24:24', 0);
INSERT INTO accounts_opportunities VALUES ('46d0c9f6-bfc8-c86e-dde4-438dfbdbf2f6', '43d71a67-04d7-d4db-7144-438dfba4f817', '419aa1b7-1392-c018-5c08-438dfb43dd59', '2005-11-30 19:24:24', 0);
INSERT INTO accounts_opportunities VALUES ('4b427cb4-7868-4b4c-7b3b-438dfbe0d82e', '486a05a5-d58a-3848-3cea-438dfb72e88c', '419aa1b7-1392-c018-5c08-438dfb43dd59', '2005-11-30 19:24:25', 0);
INSERT INTO accounts_opportunities VALUES ('500dc8ce-7083-b461-3ec1-438dfbfee3d9', '4d3be41a-98c1-2ccc-11eb-438dfb33a5d9', '419aa1b7-1392-c018-5c08-438dfb43dd59', '2005-11-30 19:24:25', 0);
INSERT INTO accounts_opportunities VALUES ('544e17c2-cb99-0d34-3025-438dfb834521', '516c0dd8-1648-a8f1-07b3-438dfb3c3bdf', '419aa1b7-1392-c018-5c08-438dfb43dd59', '2005-11-30 19:24:25', 0);
INSERT INTO accounts_opportunities VALUES ('58858d3c-6512-e00d-b99f-438dfb326802', '55b035af-9ea8-18b3-f2a8-438dfbbf6bca', '419aa1b7-1392-c018-5c08-438dfb43dd59', '2005-11-30 19:24:25', 0);
INSERT INTO accounts_opportunities VALUES ('6cefefe1-7658-58fb-e3e9-438dfbf57da9', '6a0f932f-6db4-4557-c31b-438dfbeb6a3d', '67c3c020-4ffe-b315-284a-438dfb4cd6d8', '2005-11-30 19:24:25', 0);
INSERT INTO accounts_opportunities VALUES ('711d6db8-12fa-aaef-c10f-438dfb10930b', '6e50a508-7d24-612a-25e8-438dfb2be60c', '67c3c020-4ffe-b315-284a-438dfb4cd6d8', '2005-11-30 19:24:26', 0);
INSERT INTO accounts_opportunities VALUES ('755123f2-854a-103f-e409-438dfb535dc1', '7277a541-4f1d-11b1-8fe8-438dfbc8bc86', '67c3c020-4ffe-b315-284a-438dfb4cd6d8', '2005-11-30 19:24:26', 0);
INSERT INTO accounts_opportunities VALUES ('798f3011-ed73-47f4-9e78-438dfb7956ee', '76bc32c0-5b68-9fda-919b-438dfbb2872f', '67c3c020-4ffe-b315-284a-438dfb4cd6d8', '2005-11-30 19:24:26', 0);
INSERT INTO accounts_opportunities VALUES ('7dba1cf5-1744-ec34-4c47-438dfb8ba8bc', '7ae44450-386c-2247-2db3-438dfbba06c7', '67c3c020-4ffe-b315-284a-438dfb4cd6d8', '2005-11-30 19:24:26', 0);
INSERT INTO accounts_opportunities VALUES ('9446f741-b617-5342-410e-438dfbfaab37', '9170671e-56a0-38f8-19e1-438dfb206eb4', '8f2b0a70-46e7-f25a-7dcc-438dfbc8112e', '2005-11-30 19:24:26', 0);
INSERT INTO accounts_opportunities VALUES ('9892a918-ce62-5676-d690-438dfb37b451', '95ac2580-18f0-fc28-3248-438dfbf51dce', '8f2b0a70-46e7-f25a-7dcc-438dfbc8112e', '2005-11-30 19:24:27', 0);
INSERT INTO accounts_opportunities VALUES ('9cd1153a-143f-4aa7-fe40-438dfbbd7804', '99f50e68-04b8-9df7-9f9a-438dfbb52769', '8f2b0a70-46e7-f25a-7dcc-438dfbc8112e', '2005-11-30 19:24:27', 0);
INSERT INTO accounts_opportunities VALUES ('a1bee0fe-3a1b-fbfc-0580-438dfbed7493', '9ef1eb6a-311a-5042-aa27-438dfbf49362', '8f2b0a70-46e7-f25a-7dcc-438dfbc8112e', '2005-11-30 19:24:27', 0);
INSERT INTO accounts_opportunities VALUES ('a5e3d2c0-8edb-779d-3a67-438dfb102a9c', 'a31e15c3-17c9-985d-4717-438dfb286df2', '8f2b0a70-46e7-f25a-7dcc-438dfbc8112e', '2005-11-30 19:24:27', 0);
INSERT INTO accounts_opportunities VALUES ('ba773325-9709-cf21-86f6-438dfb9f2e47', 'b7a13091-d708-3182-f773-438dfbf99df7', 'b560e2dc-22bd-6582-bc09-438dfb8ffc59', '2005-11-30 19:24:28', 0);
INSERT INTO accounts_opportunities VALUES ('bf7cb11d-fa64-8e79-5cfd-438dfb277ea8', 'bca6c204-1065-70b5-8bf3-438dfb2d66ae', 'b560e2dc-22bd-6582-bc09-438dfb8ffc59', '2005-11-30 19:24:28', 0);
INSERT INTO accounts_opportunities VALUES ('c3b37f1b-1303-c06d-97a1-438dfbb736f5', 'c0e36b29-feff-f1ec-90c4-438dfb968255', 'b560e2dc-22bd-6582-bc09-438dfb8ffc59', '2005-11-30 19:24:28', 0);
INSERT INTO accounts_opportunities VALUES ('c7e95c72-a511-ef2e-110f-438dfb8e8870', 'c514a192-eec2-7334-322a-438dfb27c098', 'b560e2dc-22bd-6582-bc09-438dfb8ffc59', '2005-11-30 19:24:28', 0);
INSERT INTO accounts_opportunities VALUES ('ccf7ec9e-d5df-1ef7-6d47-438dfb3b1bc9', 'ca217b49-12e1-bd3f-ec6a-438dfbb24d34', 'b560e2dc-22bd-6582-bc09-438dfb8ffc59', '2005-11-30 19:24:28', 0);
INSERT INTO accounts_opportunities VALUES ('e1465454-dca8-55ed-9b2d-438dfbdf23a5', 'de665b39-a857-dd80-84ea-438dfb8dfab5', 'dc2a7c81-a009-cace-2d18-438dfbabf3d5', '2005-11-30 19:24:29', 0);
INSERT INTO accounts_opportunities VALUES ('e593020e-aa5f-ce79-64e7-438dfbf3f8e3', 'e2b38d24-5d7f-972a-f13d-438dfb03a319', 'dc2a7c81-a009-cace-2d18-438dfbabf3d5', '2005-11-30 19:24:29', 0);
INSERT INTO accounts_opportunities VALUES ('ea9db333-6e40-59a5-1e3f-438dfb5af1ef', 'e7d0bb7a-663f-c474-b598-438dfba444f3', 'dc2a7c81-a009-cace-2d18-438dfbabf3d5', '2005-11-30 19:24:29', 0);
INSERT INTO accounts_opportunities VALUES ('eed25373-d374-8f33-81b4-438dfbd78e27', 'ec0467f2-b5ad-6a64-d2ad-438dfb9600c6', 'dc2a7c81-a009-cace-2d18-438dfbabf3d5', '2005-11-30 19:24:29', 0);
INSERT INTO accounts_opportunities VALUES ('f3071751-a105-d5de-626b-438dfb7eae26', 'f02d1234-0634-7e79-0c48-438dfb2a65a4', 'dc2a7c81-a009-cace-2d18-438dfbabf3d5', '2005-11-30 19:24:29', 0);
INSERT INTO accounts_opportunities VALUES ('1334bd65-fc75-a111-f428-438dfb05dc1a', '105c9214-bb9c-113a-99da-438dfbadd373', 'e2060a5d-c072-69b9-fea6-438dfb520511', '2005-11-30 19:24:29', 0);
INSERT INTO accounts_opportunities VALUES ('1771afc4-0ce6-f910-35ca-438dfb9f5709', '1494dd91-42fa-f017-d6c3-438dfb9d1a72', 'e2060a5d-c072-69b9-fea6-438dfb520511', '2005-11-30 19:24:30', 0);
INSERT INTO accounts_opportunities VALUES ('1ba10d0f-c2d5-3f40-c359-438dfb851433', '18ceb868-625d-80bc-c7fd-438dfb29d9b5', 'e2060a5d-c072-69b9-fea6-438dfb520511', '2005-11-30 19:24:30', 0);
INSERT INTO accounts_opportunities VALUES ('1fe28ff2-f9bd-9d09-d08e-438dfb701652', '1d044d87-32c8-abcc-ace6-438dfb7ca942', 'e2060a5d-c072-69b9-fea6-438dfb520511', '2005-11-30 19:24:30', 0);
INSERT INTO accounts_opportunities VALUES ('2413a37c-88c9-1ed6-d45b-438dfb25c63b', '214602ee-b95b-3137-3d8c-438dfb5a82c5', 'e2060a5d-c072-69b9-fea6-438dfb520511', '2005-11-30 19:24:30', 0);
INSERT INTO accounts_opportunities VALUES ('38b45ad3-cdf8-7cb5-7012-438dfba1cc07', '35d00e43-d4de-8d0b-c33b-438dfb6b2d7b', '33919037-63ff-98f9-4447-438dfb5acbdb', '2005-11-30 19:24:30', 0);
INSERT INTO accounts_opportunities VALUES ('3ea7ffde-32a1-d514-25fd-438dfb6f4ab1', '3a1df0ce-983c-0969-a957-438dfb85a6b1', '33919037-63ff-98f9-4447-438dfb5acbdb', '2005-11-30 19:24:31', 0);
INSERT INTO accounts_opportunities VALUES ('431f7dd4-5d02-a6df-4169-438dfbe7f37f', '404edcbc-2e85-0029-90b5-438dfbcdcc16', '33919037-63ff-98f9-4447-438dfb5acbdb', '2005-11-30 19:24:31', 0);
INSERT INTO accounts_opportunities VALUES ('482d502c-58cd-afc9-ff4c-438dfb68c70f', '447dd4e9-2ce3-5968-071c-438dfbe1abfb', '33919037-63ff-98f9-4447-438dfb5acbdb', '2005-11-30 19:24:31', 0);
INSERT INTO accounts_opportunities VALUES ('4d900b74-854f-db95-87c6-438dfbffcd56', '4a9f565e-e437-a1b8-16c0-438dfbf75a4c', '33919037-63ff-98f9-4447-438dfb5acbdb', '2005-11-30 19:24:31', 0);
INSERT INTO accounts_opportunities VALUES ('658c46b0-dfb1-52aa-a1a3-438dfba81610', '6289d588-12ac-2777-9b86-438dfbc0b8b7', '60413755-db82-584c-101d-438dfb6380b1', '2005-11-30 19:24:31', 0);
INSERT INTO accounts_opportunities VALUES ('69fa8479-0129-5892-a72e-438dfb06a6cf', '66f6f12f-623d-7a23-a595-438dfb0b3521', '60413755-db82-584c-101d-438dfb6380b1', '2005-11-30 19:24:31', 0);
INSERT INTO accounts_opportunities VALUES ('6e630307-5789-8afb-baae-438dfb634f89', '6b67eb06-0c2e-bcb5-a86a-438dfbf0584f', '60413755-db82-584c-101d-438dfb6380b1', '2005-11-30 19:24:31', 0);
INSERT INTO accounts_opportunities VALUES ('792350ec-6511-f8cd-4b6e-438dfb41003c', '70f9fcf3-e464-91c5-b757-438dfb259acb', '60413755-db82-584c-101d-438dfb6380b1', '2005-11-30 19:24:32', 0);
INSERT INTO accounts_opportunities VALUES ('7d47f6cc-4344-3555-adfe-438dfbd40d39', '7a7daba2-cdd6-2a09-efed-438dfb963c1b', '60413755-db82-584c-101d-438dfb6380b1', '2005-11-30 19:24:32', 0);
INSERT INTO accounts_opportunities VALUES ('91d343d0-6998-776c-3b97-438dfbd0513c', '8ee9bfa5-4147-1ccb-c605-438dfba19d04', '8c9f383e-c1b7-70f8-3208-438dfbc39940', '2005-11-30 19:24:32', 0);
INSERT INTO accounts_opportunities VALUES ('9852f8ce-2fe4-c546-ddb1-438dfb75b17e', '95735786-8211-9acf-0f8e-438dfbf9b1b9', '8c9f383e-c1b7-70f8-3208-438dfbc39940', '2005-11-30 19:24:32', 0);
INSERT INTO accounts_opportunities VALUES ('9cab0774-cb0d-097b-da4c-438dfb534aef', '99be676a-236a-a0a1-22c1-438dfb03ae81', '8c9f383e-c1b7-70f8-3208-438dfbc39940', '2005-11-30 19:24:32', 0);
INSERT INTO accounts_opportunities VALUES ('a0e09d8a-a323-b52a-a239-438dfb7d68eb', '9e089f00-5c04-a45f-c0a5-438dfb834c80', '8c9f383e-c1b7-70f8-3208-438dfbc39940', '2005-11-30 19:24:33', 0);
INSERT INTO accounts_opportunities VALUES ('a50699e4-68c5-58c2-9b0e-438dfb708cd3', 'a2371147-3751-a8db-b434-438dfbd79365', '8c9f383e-c1b7-70f8-3208-438dfbc39940', '2005-11-30 19:24:33', 0);
INSERT INTO accounts_opportunities VALUES ('bbda236a-9fb2-d8e6-7b4d-438dfbc9f504', 'b8fdd212-b271-2d57-785f-438dfb3292c9', 'b6bcb002-7146-374e-0f62-438dfb1ecc89', '2005-11-30 19:24:33', 0);
INSERT INTO accounts_opportunities VALUES ('c00dc0fa-5201-b2e4-0ecf-438dfb6da952', 'bd38bcad-f228-fbaa-4d87-438dfbe201a8', 'b6bcb002-7146-374e-0f62-438dfb1ecc89', '2005-11-30 19:24:33', 0);
INSERT INTO accounts_opportunities VALUES ('c446c427-2d21-b90f-37ce-438dfbf5e698', 'c171d6ae-5139-b31d-1dfc-438dfb8f5a3b', 'b6bcb002-7146-374e-0f62-438dfb1ecc89', '2005-11-30 19:24:33', 0);
INSERT INTO accounts_opportunities VALUES ('caf42fdf-13cf-6c08-e322-438dfbf1f98f', 'c6d9de5c-c0cd-8f81-235b-438dfbf3ce7d', 'b6bcb002-7146-374e-0f62-438dfb1ecc89', '2005-11-30 19:24:33', 0);
INSERT INTO accounts_opportunities VALUES ('cf3e4081-5038-5c7f-3abc-438dfb89add7', 'cc533b9a-0df9-c52d-0f8e-438dfbb7af3b', 'b6bcb002-7146-374e-0f62-438dfb1ecc89', '2005-11-30 19:24:34', 0);
INSERT INTO accounts_opportunities VALUES ('e3a24f3e-93e4-eeed-feed-438dfbb6744f', 'e0c60e4f-899e-90df-4897-438dfb8f32a1', 'de8788ae-186e-8976-b01a-438dfb2b8a05', '2005-11-30 19:24:34', 0);
INSERT INTO accounts_opportunities VALUES ('e7e2fa93-0a64-499b-c20e-438dfb21b174', 'e50fe650-5a42-e6da-b999-438dfb926894', 'de8788ae-186e-8976-b01a-438dfb2b8a05', '2005-11-30 19:24:34', 0);
INSERT INTO accounts_opportunities VALUES ('ec1a9d25-0744-9b53-896b-438dfb1989bd', 'e941229f-6b4a-7a2a-9c3c-438dfb5808dd', 'de8788ae-186e-8976-b01a-438dfb2b8a05', '2005-11-30 19:24:34', 0);
INSERT INTO accounts_opportunities VALUES ('f04db1c5-329d-7cbf-41c3-438dfb11aa5b', 'ed822ec6-67bd-1d16-df7f-438dfb5fcde0', 'de8788ae-186e-8976-b01a-438dfb2b8a05', '2005-11-30 19:24:34', 0);
INSERT INTO accounts_opportunities VALUES ('61d00670-1661-b4bf-6da7-438dfb0b82ea', 'f1b32bec-31a3-93d8-3b54-438dfb58d782', 'de8788ae-186e-8976-b01a-438dfb2b8a05', '2005-11-30 19:24:34', 0);
INSERT INTO accounts_opportunities VALUES ('14c3a9e0-ac88-094a-0460-438dfbc8f985', '11eca2eb-efc6-a62f-eaf4-438dfb6df46e', 'fab50378-1552-a629-0700-438dfb1e3c07', '2005-11-30 19:24:35', 0);
INSERT INTO accounts_opportunities VALUES ('192d6acb-eb2c-300b-0b5b-438dfbc162fb', '1631dc34-8d53-cf32-0ef5-438dfb36ef00', 'fab50378-1552-a629-0700-438dfb1e3c07', '2005-11-30 19:24:35', 0);
INSERT INTO accounts_opportunities VALUES ('1d6999ec-32cd-4104-ba3d-438dfb37fe01', '1a8fb7f5-9014-08bb-5ce5-438dfbcfa51d', 'fab50378-1552-a629-0700-438dfb1e3c07', '2005-11-30 19:24:35', 0);
INSERT INTO accounts_opportunities VALUES ('21af5be4-deb3-c0ec-3bb7-438dfbf6a9ef', '1ecc6128-d97f-6233-282b-438dfb85d241', 'fab50378-1552-a629-0700-438dfb1e3c07', '2005-11-30 19:24:35', 0);
INSERT INTO accounts_opportunities VALUES ('25d87a35-0e74-d22d-8da2-438dfb1fdfbd', '23098121-e6f6-eb78-833c-438dfb37a85f', 'fab50378-1552-a629-0700-438dfb1e3c07', '2005-11-30 19:24:36', 0);
INSERT INTO accounts_opportunities VALUES ('3f3449b1-eeaf-29b0-36c9-438dfb809bfe', '3a6eac63-b120-c78d-2848-438dfb8d3403', '382799fa-9f4d-a2a0-f436-438dfb2ab9e1', '2005-11-30 19:24:36', 0);
INSERT INTO accounts_opportunities VALUES ('43a172b9-36e4-28d1-db05-438dfb607e64', '40c29fa5-6ac6-bf1c-b0ec-438dfbbfdade', '382799fa-9f4d-a2a0-f436-438dfb2ab9e1', '2005-11-30 19:24:36', 0);
INSERT INTO accounts_opportunities VALUES ('47f178d8-2084-a8b0-19d1-438dfb45caa9', '44fe4098-6460-bcc6-1217-438dfbe8c8d6', '382799fa-9f4d-a2a0-f436-438dfb2ab9e1', '2005-11-30 19:24:36', 0);
INSERT INTO accounts_opportunities VALUES ('4c2efddb-63d6-f750-6094-438dfb24b24d', '496010ce-3b2e-09f9-c291-438dfb920fd7', '382799fa-9f4d-a2a0-f436-438dfb2ab9e1', '2005-11-30 19:24:36', 0);
INSERT INTO accounts_opportunities VALUES ('51d1c0dc-88b1-a3dd-9307-438dfb41ee0c', '4efde88b-54fd-197c-5c18-438dfbc2a7d7', '382799fa-9f4d-a2a0-f436-438dfb2ab9e1', '2005-11-30 19:24:37', 0);
INSERT INTO accounts_opportunities VALUES ('66320157-cf5a-4fad-dccc-438dfbc7b3d8', '635300f6-3ce1-c18f-26e7-438dfb5eb96e', '611c2870-5b76-3473-fa0e-438dfb4778a4', '2005-11-30 19:24:37', 0);
INSERT INTO accounts_opportunities VALUES ('6bf6c863-06f2-d3e8-9ca7-438dfb08807d', '6917febf-23a4-e165-3f33-438dfb1f0d7a', '611c2870-5b76-3473-fa0e-438dfb4778a4', '2005-11-30 19:24:37', 0);
INSERT INTO accounts_opportunities VALUES ('7025c1fe-c51b-bdce-31bf-438dfb039a5b', '6d551148-2345-c48e-6b48-438dfb66bbda', '611c2870-5b76-3473-fa0e-438dfb4778a4', '2005-11-30 19:24:37', 0);
INSERT INTO accounts_opportunities VALUES ('745a8068-0499-fc60-aff4-438dfb4f9fc0', '718ac3d7-3e89-c215-2642-438dfbc52fac', '611c2870-5b76-3473-fa0e-438dfb4778a4', '2005-11-30 19:24:37', 0);
INSERT INTO accounts_opportunities VALUES ('7898a259-0b83-f8b5-e6ab-438dfb345871', '75c62ad3-1e26-630b-44fa-438dfbfc20c8', '611c2870-5b76-3473-fa0e-438dfb4778a4', '2005-11-30 19:24:37', 0);
INSERT INTO accounts_opportunities VALUES ('8d1cb136-b02e-8df4-10b9-438dfb4cf87a', '8a371776-a899-09d3-cece-438dfb7f9c9a', '87f2d1aa-1a8f-51ed-b562-438dfbf8e1f7', '2005-11-30 19:24:38', 0);
INSERT INTO accounts_opportunities VALUES ('92e9391a-da15-383e-24c4-438dfbed7cc7', '900ff1da-ab7e-cae3-b44e-438dfb74b101', '87f2d1aa-1a8f-51ed-b562-438dfbf8e1f7', '2005-11-30 19:24:38', 0);
INSERT INTO accounts_opportunities VALUES ('97283868-af5d-f9cf-8f90-438dfb6c775f', '9446d2e6-884e-bf4e-f30c-438dfb167da3', '87f2d1aa-1a8f-51ed-b562-438dfbf8e1f7', '2005-11-30 19:24:38', 0);
INSERT INTO accounts_opportunities VALUES ('9b66aa31-d308-97f9-d388-438dfbf9c367', '988e857f-0c3c-2092-e6f5-438dfbc16c15', '87f2d1aa-1a8f-51ed-b562-438dfbf8e1f7', '2005-11-30 19:24:38', 0);
INSERT INTO accounts_opportunities VALUES ('9f9da10a-3ff4-1e7e-fbbc-438dfb296dbe', '9cc405d0-b8b7-0443-ddd5-438dfb27966b', '87f2d1aa-1a8f-51ed-b562-438dfbf8e1f7', '2005-11-30 19:24:39', 0);
INSERT INTO accounts_opportunities VALUES ('b3ea5df0-9901-df53-0507-438dfb47355f', 'b10e08c2-794c-f082-7b90-438dfb013dd8', 'aed2dd85-41f1-3abb-02f3-438dfbd64a1b', '2005-11-30 19:24:39', 0);
INSERT INTO accounts_opportunities VALUES ('b9c16e2d-f883-c64e-86e9-438dfb905a7f', 'b6ed0242-cadc-3043-61e1-438dfb739a47', 'aed2dd85-41f1-3abb-02f3-438dfbd64a1b', '2005-11-30 19:24:39', 0);
INSERT INTO accounts_opportunities VALUES ('bdf606d2-6441-81d3-c3a5-438dfb53b694', 'bb21d4c9-fb01-da73-ee1f-438dfb4f7d23', 'aed2dd85-41f1-3abb-02f3-438dfbd64a1b', '2005-11-30 19:24:39', 0);
INSERT INTO accounts_opportunities VALUES ('c2357ecd-2d46-080c-145f-438dfb9b518d', 'bf5252c0-a6e0-1d00-089a-438dfb6f2e8a', 'aed2dd85-41f1-3abb-02f3-438dfbd64a1b', '2005-11-30 19:24:39', 0);
INSERT INTO accounts_opportunities VALUES ('c673703e-3f2f-38cb-075a-438dfb92a387', 'c3a9a7bd-d971-bb93-200e-438dfbf7bfd4', 'aed2dd85-41f1-3abb-02f3-438dfbd64a1b', '2005-11-30 19:24:40', 0);
INSERT INTO accounts_opportunities VALUES ('dad5fed4-21e2-78d4-9f8d-438dfb8a2d42', 'd7f5cc35-596b-41a1-77b8-438dfb9ed2b4', 'd5b953e2-7668-721f-21cc-438dfbf0b385', '2005-11-30 19:24:40', 0);
INSERT INTO accounts_opportunities VALUES ('e0bf0c03-da48-db81-d65e-438dfbcc14eb', 'ddeaa47f-d849-a3d2-1d9b-438dfb704fde', 'd5b953e2-7668-721f-21cc-438dfbf0b385', '2005-11-30 19:24:40', 0);
INSERT INTO accounts_opportunities VALUES ('e4fdef8b-e2d2-624c-3d93-438dfb322965', 'e21969b7-27b5-0ffb-bb0f-438dfbc51831', 'd5b953e2-7668-721f-21cc-438dfbf0b385', '2005-11-30 19:24:40', 0);
INSERT INTO accounts_opportunities VALUES ('ec8f7fb2-0aba-3aec-08e3-438dfb1816f9', 'e9bf498f-8786-d8b3-4dd2-438dfb65ad82', 'd5b953e2-7668-721f-21cc-438dfbf0b385', '2005-11-30 19:24:40', 0);
INSERT INTO accounts_opportunities VALUES ('f0c16aec-99b9-9173-1f72-438dfbea56a1', 'edf3eaad-908c-143b-4367-438dfb9b177e', 'd5b953e2-7668-721f-21cc-438dfbf0b385', '2005-11-30 19:24:40', 0);
INSERT INTO accounts_opportunities VALUES ('111a1330-f752-cf1c-bfd0-438dfbecd2ca', 'e43d0441-1260-9ae2-8031-438dfbc64692', 'c08208ee-c631-2468-f4ef-438dfbb1f92c', '2005-11-30 19:24:41', 0);
INSERT INTO accounts_opportunities VALUES ('1704b469-35be-7f94-5f69-438dfbc2a34f', '14345cd3-280c-5c16-5828-438dfb103a04', 'c08208ee-c631-2468-f4ef-438dfbb1f92c', '2005-11-30 19:24:41', 0);
INSERT INTO accounts_opportunities VALUES ('1b42cd07-95d1-e8f6-0f55-438dfb558535', '186a5e5b-41b5-3b28-6a5c-438dfbdce751', 'c08208ee-c631-2468-f4ef-438dfbb1f92c', '2005-11-30 19:24:41', 0);
INSERT INTO accounts_opportunities VALUES ('1f95be0e-ee11-3d20-7352-438dfb0d6eb4', '1ca79b01-2912-194e-7c4f-438dfb4028f4', 'c08208ee-c631-2468-f4ef-438dfbb1f92c', '2005-11-30 19:24:41', 0);
INSERT INTO accounts_opportunities VALUES ('258a30c8-f492-7117-36ad-438dfbc99c5f', '22be683d-e9c0-cd3c-1270-438dfb89f66b', 'c08208ee-c631-2468-f4ef-438dfbb1f92c', '2005-11-30 19:24:41', 0);
INSERT INTO accounts_opportunities VALUES ('3b4fba42-0927-a5b0-28ce-438dfb98683e', '387377fb-84d9-38d3-a9af-438dfb253999', '3624c5a8-5dcf-8f66-f9a1-438dfb26f2da', '2005-11-30 19:24:42', 0);
INSERT INTO accounts_opportunities VALUES ('41864530-993c-4b73-ccaa-438dfb1ca576', '3ea62d61-48cb-40dc-e25b-438dfbd4f8b9', '3624c5a8-5dcf-8f66-f9a1-438dfb26f2da', '2005-11-30 19:24:42', 0);
INSERT INTO accounts_opportunities VALUES ('45af31ab-b0e4-7333-e09c-438dfb43cac8', '42e12bdf-efbb-d5de-2d8b-438dfba4866f', '3624c5a8-5dcf-8f66-f9a1-438dfb26f2da', '2005-11-30 19:24:42', 0);
INSERT INTO accounts_opportunities VALUES ('4a2cda61-7fa1-773a-177e-438dfb8d425e', '47357431-a183-45f1-f548-438dfbe9a4b7', '3624c5a8-5dcf-8f66-f9a1-438dfb26f2da', '2005-11-30 19:24:42', 0);
INSERT INTO accounts_opportunities VALUES ('5062a13e-ffac-d979-4f5d-438dfb101892', '4d6868f7-0a1f-a382-16d2-438dfb782672', '3624c5a8-5dcf-8f66-f9a1-438dfb26f2da', '2005-11-30 19:24:42', 0);
INSERT INTO accounts_opportunities VALUES ('64f8efae-76a2-597d-5b5c-438dfb4958db', '6223525b-54eb-05ff-793a-438dfb5aee27', '5fd3e853-98f8-6dbf-208c-438dfb9d5c69', '2005-11-30 19:24:42', 0);
INSERT INTO accounts_opportunities VALUES ('693d98ab-d28c-c97b-4170-438dfb3f7ce6', '6667fc8e-a7ab-4df6-aaf8-438dfb23692c', '5fd3e853-98f8-6dbf-208c-438dfb9d5c69', '2005-11-30 19:24:43', 0);
INSERT INTO accounts_opportunities VALUES ('6d871527-c016-bade-1516-438dfbac2f5d', '6aa4d67f-ac50-1131-8922-438dfb68dd72', '5fd3e853-98f8-6dbf-208c-438dfb9d5c69', '2005-11-30 19:24:43', 0);
INSERT INTO accounts_opportunities VALUES ('71b44375-d542-8995-c89b-438dfb1ea195', '6eea83ce-7902-9ba1-8e71-438dfbed9f13', '5fd3e853-98f8-6dbf-208c-438dfb9d5c69', '2005-11-30 19:24:43', 0);
INSERT INTO accounts_opportunities VALUES ('7ef0e601-bc5a-5647-2a16-438dfbe4ab1a', '76d1a88c-fbb7-ddda-8f0f-438dfbda8592', '5fd3e853-98f8-6dbf-208c-438dfb9d5c69', '2005-11-30 19:24:43', 0);
INSERT INTO accounts_opportunities VALUES ('936bc75a-6fe3-93a2-7013-438dfb71f9af', '909302ac-7ff3-2e03-7564-438dfb170850', '8e54f9ad-8ffe-e5ca-b871-438dfb253fb7', '2005-11-30 19:24:43', 0);
INSERT INTO accounts_opportunities VALUES ('9b906b3f-82f5-87b7-68e7-438dfb5336af', '98aebb7c-d037-424f-1c76-438dfb36b326', '8e54f9ad-8ffe-e5ca-b871-438dfb253fb7', '2005-11-30 19:24:44', 0);
INSERT INTO accounts_opportunities VALUES ('9fc1c75d-e87d-19d2-a551-438dfb5e3ad8', '9cf1c693-d709-0a02-70b9-438dfb1ad045', '8e54f9ad-8ffe-e5ca-b871-438dfb253fb7', '2005-11-30 19:24:44', 0);
INSERT INTO accounts_opportunities VALUES ('a3eec61a-1121-ccef-1691-438dfbffeae1', 'a11bd3ef-a553-7a9d-f88a-438dfbf9df66', '8e54f9ad-8ffe-e5ca-b871-438dfb253fb7', '2005-11-30 19:24:44', 0);
INSERT INTO accounts_opportunities VALUES ('a81f8a93-a41d-777b-6585-438dfb7fd229', 'a54f868a-82ea-9d07-2ce5-438dfb4973b3', '8e54f9ad-8ffe-e5ca-b871-438dfb253fb7', '2005-11-30 19:24:44', 0);
INSERT INTO accounts_opportunities VALUES ('bea0c5ed-6d01-616f-df28-438dfb8e744b', 'bbc1d9e7-5eae-54ca-759f-438dfbd95c6e', 'b97ff471-9ee3-0e12-2dd9-438dfb9b36e0', '2005-11-30 19:24:44', 0);
INSERT INTO accounts_opportunities VALUES ('c2d7a2b0-f643-46b3-dc3b-438dfb89d86c', 'bfffd7ba-b9ed-40d3-1927-438dfba0eb91', 'b97ff471-9ee3-0e12-2dd9-438dfb9b36e0', '2005-11-30 19:24:45', 0);
INSERT INTO accounts_opportunities VALUES ('c71035cf-0bc4-5f2b-90c6-438dfb2ed84a', 'c436b267-d756-178a-fd78-438dfb644921', 'b97ff471-9ee3-0e12-2dd9-438dfb9b36e0', '2005-11-30 19:24:45', 0);
INSERT INTO accounts_opportunities VALUES ('cd5a6f1d-082b-9ca9-c9c9-438dfb2abed7', 'ca75f6ab-2aa7-3cb2-e71e-438dfbcaecfe', 'b97ff471-9ee3-0e12-2dd9-438dfb9b36e0', '2005-11-30 19:24:45', 0);
INSERT INTO accounts_opportunities VALUES ('d181c4e2-e4eb-ab6a-889a-438dfb6b497c', 'ceb480e7-64a6-9afb-149d-438dfb573a37', 'b97ff471-9ee3-0e12-2dd9-438dfb9b36e0', '2005-11-30 19:24:45', 0);
INSERT INTO accounts_opportunities VALUES ('e671aa96-433f-5745-e4ef-438dfb6dbb62', 'e39766ac-9a99-a932-4f1e-438dfbbad05d', 'e153589f-133b-e390-b669-438dfb24cd9f', '2005-11-30 19:24:46', 0);
INSERT INTO accounts_opportunities VALUES ('eaa42c37-fe58-d5d9-63f5-438dfbca3c40', 'e7d709a6-b809-ca72-1a40-438dfb0d707d', 'e153589f-133b-e390-b669-438dfb24cd9f', '2005-11-30 19:24:46', 0);
INSERT INTO accounts_opportunities VALUES ('eed1fea5-529b-afc8-009a-438dfb4fc010', 'ec00f476-445b-3716-6189-438dfb0f4916', 'e153589f-133b-e390-b669-438dfb24cd9f', '2005-11-30 19:24:46', 0);
INSERT INTO accounts_opportunities VALUES ('f3103922-2500-87f9-3c2f-438dfb0187f8', 'f0310549-81f9-63c9-f827-438dfb2b3a30', 'e153589f-133b-e390-b669-438dfb24cd9f', '2005-11-30 19:24:46', 0);
INSERT INTO accounts_opportunities VALUES ('35220e00-4976-ec57-808d-438dfb48db84', '578009ee-5941-4ccc-4d1f-438dfbfbc463', 'e153589f-133b-e390-b669-438dfb24cd9f', '2005-11-30 19:24:47', 0);
INSERT INTO accounts_opportunities VALUES ('17ed6313-b0f1-845c-3748-438dfb0a3c97', '150bdc7c-b627-0aba-209e-438dfb16a02f', '12ca7ab1-220a-4af9-99ba-438dfbe5571c', '2005-11-30 19:24:47', 0);
INSERT INTO accounts_opportunities VALUES ('1c2395ec-6639-be5f-30ad-438dfbb656f1', '19512522-71ad-e96c-716b-438dfbfa6eca', '12ca7ab1-220a-4af9-99ba-438dfbe5571c', '2005-11-30 19:24:47', 0);
INSERT INTO accounts_opportunities VALUES ('2293b79e-9ae7-2185-e428-438dfb02d91b', '1fb93fad-bf04-f712-1758-438dfb14531a', '12ca7ab1-220a-4af9-99ba-438dfbe5571c', '2005-11-30 19:24:47', 0);
INSERT INTO accounts_opportunities VALUES ('26bf4912-4cb9-3b97-124b-438dfbaf486f', '23f16019-be65-d793-a7df-438dfb1c27f0', '12ca7ab1-220a-4af9-99ba-438dfbe5571c', '2005-11-30 19:24:47', 0);
INSERT INTO accounts_opportunities VALUES ('2b25a7ed-0fd3-8ef1-c668-438dfb087869', '28331219-bceb-c6c0-dac4-438dfb091445', '12ca7ab1-220a-4af9-99ba-438dfbe5571c', '2005-11-30 19:24:48', 0);
INSERT INTO accounts_opportunities VALUES ('41abe2be-9efe-070e-c112-438dfb8d230c', '3cd02b37-dbd0-4e4b-a4ae-438dfb5cd497', '3a942d15-be46-e733-9cd3-438dfbb71e24', '2005-11-30 19:24:48', 0);
INSERT INTO accounts_opportunities VALUES ('45dd461f-fec1-68ce-b91b-438dfb8bc8b1', '430926fe-e34f-d919-99a7-438dfbeb50a8', '3a942d15-be46-e733-9cd3-438dfbb71e24', '2005-11-30 19:24:48', 0);
INSERT INTO accounts_opportunities VALUES ('4c859461-d7a0-cb9e-9e84-438dfb9de03a', '49b23368-6a73-8143-5d20-438dfb0e49f0', '3a942d15-be46-e733-9cd3-438dfbb71e24', '2005-11-30 19:24:48', 0);
INSERT INTO accounts_opportunities VALUES ('50cf9ed6-809d-afd8-ed25-438dfb8d7dac', '4de6406b-7219-540c-a7b7-438dfb81098d', '3a942d15-be46-e733-9cd3-438dfbb71e24', '2005-11-30 19:24:48', 0);
INSERT INTO accounts_opportunities VALUES ('54f62394-ad45-b3cf-3941-438dfb7a9cb7', '522637d4-7e6d-8c07-0602-438dfb5fa053', '3a942d15-be46-e733-9cd3-438dfbb71e24', '2005-11-30 19:24:49', 0);
INSERT INTO accounts_opportunities VALUES ('6ddc9dd0-7ed0-b01a-c1cc-438dfb9ea8f5', '6b019c07-68dd-65a8-92c7-438dfbe4cd8e', '68b936e6-d166-104a-f3f3-438dfb9a2b2a', '2005-11-30 19:24:49', 0);
INSERT INTO accounts_opportunities VALUES ('7459b7cb-9681-5b53-7cef-438dfb79121c', '7187f732-0cfa-5216-d2f6-438dfb1a1c1c', '68b936e6-d166-104a-f3f3-438dfb9a2b2a', '2005-11-30 19:24:49', 0);
INSERT INTO accounts_opportunities VALUES ('789437ff-cb7f-12a9-2c4a-438dfb2e1a9e', '75b92b6b-cf5f-558c-25c2-438dfb17d004', '68b936e6-d166-104a-f3f3-438dfb9a2b2a', '2005-11-30 19:24:49', 0);
INSERT INTO accounts_opportunities VALUES ('7ccc3330-573a-576a-2eaf-438dfbb39a6c', '79f84bba-1213-e651-b93a-438dfb8d0b1a', '68b936e6-d166-104a-f3f3-438dfb9a2b2a', '2005-11-30 19:24:49', 0);
INSERT INTO accounts_opportunities VALUES ('83627649-a4c0-fef4-390e-438dfbb01cbb', '80786e32-e15d-8e23-97d2-438dfbca3d1a', '68b936e6-d166-104a-f3f3-438dfb9a2b2a', '2005-11-30 19:24:50', 0);
INSERT INTO accounts_opportunities VALUES ('97d2f811-32f2-a941-e33a-438dfb78f487', '94f62a43-bea9-3e7b-2c72-438dfbf9b9f9', '92b622ce-8026-54c4-bb92-438dfbea0f65', '2005-11-30 19:24:50', 0);
INSERT INTO accounts_opportunities VALUES ('9c14167a-42b5-fa49-93e0-438dfb0cd503', '993a4897-3d39-2797-cb53-438dfb31c2ff', '92b622ce-8026-54c4-bb92-438dfbea0f65', '2005-11-30 19:24:50', 0);
INSERT INTO accounts_opportunities VALUES ('a04f0238-b7c8-4a71-c429-438dfbd4ef31', '9d8129f4-36f9-f3b1-8f3e-438dfb3b5188', '92b622ce-8026-54c4-bb92-438dfbea0f65', '2005-11-30 19:24:50', 0);
INSERT INTO accounts_opportunities VALUES ('a6dd8fab-fdfb-e862-cadb-438dfb4d4d54', 'a4131561-4061-44aa-7f5c-438dfba6ee8c', '92b622ce-8026-54c4-bb92-438dfbea0f65', '2005-11-30 19:24:51', 0);
INSERT INTO accounts_opportunities VALUES ('ab171c74-0688-8078-1a31-438dfb40951f', 'a83c5fa5-edd8-1abd-f82c-438dfb9956c7', '92b622ce-8026-54c4-bb92-438dfbea0f65', '2005-11-30 19:24:51', 0);
INSERT INTO accounts_opportunities VALUES ('bf7e3b44-ff48-b837-9c8e-438dfb903e2f', 'bca8f4a0-5513-e884-b6e9-438dfb348c6a', 'ba692bd5-98cb-195e-3509-438dfb8e7448', '2005-11-30 19:24:51', 0);
INSERT INTO accounts_opportunities VALUES ('c3ba0278-5f06-a8ea-2dcc-438dfba012c9', 'c0dfeb78-4757-92f7-5bf1-438dfbe800aa', 'ba692bd5-98cb-195e-3509-438dfb8e7448', '2005-11-30 19:24:51', 0);
INSERT INTO accounts_opportunities VALUES ('c7e37b5f-3672-88ab-d443-438dfbff0566', 'c5138527-d6a9-9b85-6928-438dfb060217', 'ba692bd5-98cb-195e-3509-438dfb8e7448', '2005-11-30 19:24:51', 0);
INSERT INTO accounts_opportunities VALUES ('cc223e30-ee5c-9f6d-298f-438dfb020ca6', 'c9499db7-ebe1-420f-7f7a-438dfb514839', 'ba692bd5-98cb-195e-3509-438dfb8e7448', '2005-11-30 19:24:52', 0);
INSERT INTO accounts_opportunities VALUES ('d05b12c1-1850-d17b-3af0-438dfbe63cd8', 'cd85f5ff-72f7-5465-0f8b-438dfbed9aa7', 'ba692bd5-98cb-195e-3509-438dfb8e7448', '2005-11-30 19:24:52', 0);
INSERT INTO accounts_opportunities VALUES ('e4bcfbd0-1132-1f1c-da5e-438dfb06a2e1', 'e1e228f5-f769-aab6-a996-438dfbf36815', 'df9d2e47-e4af-a4cd-f57f-438dfb4ad6c4', '2005-11-30 19:24:52', 0);
INSERT INTO accounts_opportunities VALUES ('eb80b0cd-a020-247f-4a31-438dfb694669', 'e8a5c939-cb36-bfab-000b-438dfbd53367', 'df9d2e47-e4af-a4cd-f57f-438dfb4ad6c4', '2005-11-30 19:24:52', 0);
INSERT INTO accounts_opportunities VALUES ('efb3970c-a406-5e53-cdbe-438dfb193c6c', 'ecdc0164-7c80-d016-1e82-438dfbdba73c', 'df9d2e47-e4af-a4cd-f57f-438dfb4ad6c4', '2005-11-30 19:24:53', 0);
INSERT INTO accounts_opportunities VALUES ('f3f18184-ce88-8ffa-ba65-438dfb2a3752', 'f11b4ee2-c699-d20e-dd43-438dfbe1fbbb', 'df9d2e47-e4af-a4cd-f57f-438dfb4ad6c4', '2005-11-30 19:24:53', 0);
INSERT INTO accounts_opportunities VALUES ('67f30efd-afd2-b8b9-7904-438dfbb8ec68', '3b1203c0-8bdd-0f12-8b0d-438dfb1c4eea', 'df9d2e47-e4af-a4cd-f57f-438dfb4ad6c4', '2005-11-30 19:24:53', 0);
INSERT INTO accounts_opportunities VALUES ('1b087263-8412-0099-02d3-438dfb716821', '182ac52a-ff91-3ec0-7d36-438dfb6ec404', '15e6d611-0ff0-efa3-2a08-438dfb32d02d', '2005-11-30 19:24:53', 0);
INSERT INTO accounts_opportunities VALUES ('1f4b2224-570b-e65f-ef4d-438dfbd3ca76', '1c713530-f257-3a95-f459-438dfb51943c', '15e6d611-0ff0-efa3-2a08-438dfb32d02d', '2005-11-30 19:24:53', 0);
INSERT INTO accounts_opportunities VALUES ('239206ca-9228-6309-e5d5-438dfbd89f03', '20bb0875-18e7-2641-347c-438dfb799720', '15e6d611-0ff0-efa3-2a08-438dfb32d02d', '2005-11-30 19:24:54', 0);
INSERT INTO accounts_opportunities VALUES ('27c9929d-22f7-7a74-6f7f-438dfbf20808', '24f449d6-66c5-4b38-bc4e-438dfb90c99b', '15e6d611-0ff0-efa3-2a08-438dfb32d02d', '2005-11-30 19:24:54', 0);
INSERT INTO accounts_opportunities VALUES ('2c1583eb-1658-49e0-3110-438dfba75f97', '292e92e2-cb8f-6095-adb5-438dfb564589', '15e6d611-0ff0-efa3-2a08-438dfb32d02d', '2005-11-30 19:24:54', 0);
INSERT INTO accounts_opportunities VALUES ('4295cc13-317e-48b1-5047-438dfbdb75f7', '3fba3082-4c92-88a8-77af-438dfb8e7712', '3b8554f2-e220-4e32-b135-438dfb52f9fe', '2005-11-30 19:24:54', 0);
INSERT INTO accounts_opportunities VALUES ('46ce6559-1c15-bde4-a7d3-438dfbec864b', '43fb7e59-3f4a-86c4-c164-438dfb25a126', '3b8554f2-e220-4e32-b135-438dfb52f9fe', '2005-11-30 19:24:55', 0);
INSERT INTO accounts_opportunities VALUES ('4b1c0654-06fc-59df-1d6a-438dfb375f71', '4832529c-8844-dc73-2c1f-438dfb078eb2', '3b8554f2-e220-4e32-b135-438dfb52f9fe', '2005-11-30 19:24:55', 0);
INSERT INTO accounts_opportunities VALUES ('4f4f96aa-b595-7b04-2f45-438dfb4ec46a', '4c7e35bb-ce1f-c1ba-b806-438dfb52c3e7', '3b8554f2-e220-4e32-b135-438dfb52f9fe', '2005-11-30 19:24:55', 0);
INSERT INTO accounts_opportunities VALUES ('53ac46cd-c0de-8499-4dfd-438dfbca291b', '50b82717-9778-3940-e913-438dfb791eef', '3b8554f2-e220-4e32-b135-438dfb52f9fe', '2005-11-30 19:24:55', 0);
INSERT INTO accounts_opportunities VALUES ('67fea6c5-d1b9-a03d-ba95-438dfbc145d8', '65263bf0-191a-f025-2052-438dfb781899', '62e7c87a-db38-c12d-27c1-438dfb76bf23', '2005-11-30 19:24:55', 0);
INSERT INTO accounts_opportunities VALUES ('6eec2891-9c25-4474-7949-438dfb66cbe3', '6c1a1f59-c47d-43ce-ca24-438dfbfc730a', '62e7c87a-db38-c12d-27c1-438dfb76bf23', '2005-11-30 19:24:55', 0);
INSERT INTO accounts_opportunities VALUES ('731d45ab-dd85-7ce9-0eed-438dfb9fda0f', '704b36b0-ea76-4a1d-c125-438dfbef4b51', '62e7c87a-db38-c12d-27c1-438dfb76bf23', '2005-11-30 19:24:56', 0);
INSERT INTO accounts_opportunities VALUES ('774e204f-e697-8c1e-ca06-438dfb22e631', '74853189-6a7c-b826-97b3-438dfbabde7d', '62e7c87a-db38-c12d-27c1-438dfb76bf23', '2005-11-30 19:24:56', 0);
INSERT INTO accounts_opportunities VALUES ('7e58e5e6-e4ea-760c-b9b5-438dfbe70208', '7b787317-53cb-15e8-babb-438dfb626046', '62e7c87a-db38-c12d-27c1-438dfb76bf23', '2005-11-30 19:24:56', 0);
INSERT INTO accounts_opportunities VALUES ('999bb287-2c69-1aa2-362f-438dfbbe7d8d', '96c2720f-354b-8ce3-1a6e-438dfb16ef09', '9483cdff-0afc-bc72-342c-438dfb495915', '2005-11-30 19:24:56', 0);
INSERT INTO accounts_opportunities VALUES ('9dd0a2b3-e88c-36f5-a4d0-438dfb53934c', '9b0029ca-43b2-cc07-55ae-438dfbc8ea5d', '9483cdff-0afc-bc72-342c-438dfb495915', '2005-11-30 19:24:57', 0);
INSERT INTO accounts_opportunities VALUES ('a20b450d-4c33-da07-69ac-438dfbff6bc3', '9f335af4-b994-e4d5-8288-438dfb19a4c7', '9483cdff-0afc-bc72-342c-438dfb495915', '2005-11-30 19:24:57', 0);
INSERT INTO accounts_opportunities VALUES ('a63e0cf4-b77c-0206-33e7-438dfbb59257', 'a36d460a-3ed9-997a-567f-438dfb4c979d', '9483cdff-0afc-bc72-342c-438dfb495915', '2005-11-30 19:24:57', 0);
INSERT INTO accounts_opportunities VALUES ('aa72f849-6192-4307-de86-438dfb8a0247', 'a7a00d4e-144c-3381-22d7-438dfbb8cd2d', '9483cdff-0afc-bc72-342c-438dfb495915', '2005-11-30 19:24:57', 0);
INSERT INTO accounts_opportunities VALUES ('becb4f5e-d193-b583-8069-438dfb010db8', 'bbf053a5-1b46-703d-e67d-438dfbabea0f', 'b9b66e60-dbc2-97f8-d5b4-438dfbb7431d', '2005-11-30 19:24:58', 0);
INSERT INTO accounts_opportunities VALUES ('c5f46750-0a20-c222-4825-438dfbf04aab', 'c30e3542-7d57-c675-ab0e-438dfbe556b7', 'b9b66e60-dbc2-97f8-d5b4-438dfbb7431d', '2005-11-30 19:24:58', 0);
INSERT INTO accounts_opportunities VALUES ('ca284d87-838c-d057-eb27-438dfbf87491', 'c7556e64-0f55-a8dd-f426-438dfbb1cc27', 'b9b66e60-dbc2-97f8-d5b4-438dfbb7431d', '2005-11-30 19:24:58', 0);
INSERT INTO accounts_opportunities VALUES ('ce5cf576-980c-4e2c-4162-438dfb04c1a3', 'cb8bf22a-dcfa-a154-e2f1-438dfbfbff74', 'b9b66e60-dbc2-97f8-d5b4-438dfbb7431d', '2005-11-30 19:24:58', 0);
INSERT INTO accounts_opportunities VALUES ('d28c7738-c39d-e4b6-aba9-438dfb89d351', 'cfb559bc-38b2-4d6a-aef5-438dfbcc082c', 'b9b66e60-dbc2-97f8-d5b4-438dfbb7431d', '2005-11-30 19:24:58', 0);
INSERT INTO accounts_opportunities VALUES ('e6fa6b5c-9591-9753-7778-438dfbd9f622', 'e423ee95-bd33-3f28-6e4b-438dfbbc59c7', 'e1e7c4e5-7e25-6799-eb9a-438dfba51d7f', '2005-11-30 19:24:58', 0);
INSERT INTO accounts_opportunities VALUES ('eb335cdf-68fb-addd-82f8-438dfbf91274', 'e857acc4-1b7a-b682-31ee-438dfb10e679', 'e1e7c4e5-7e25-6799-eb9a-438dfba51d7f', '2005-11-30 19:24:59', 0);
INSERT INTO accounts_opportunities VALUES ('f2588bd3-5580-ab90-1962-438dfb78bbe9', 'ef7b8188-ae75-7d73-a3bd-438dfbd8c7a7', 'e1e7c4e5-7e25-6799-eb9a-438dfba51d7f', '2005-11-30 19:24:59', 0);
INSERT INTO accounts_opportunities VALUES ('26d40c6b-a397-d1ee-5bfe-438dfb2d1bd3', 'f3b4441f-3c57-13c7-6cd6-438dfb325180', 'e1e7c4e5-7e25-6799-eb9a-438dfba51d7f', '2005-11-30 19:24:59', 0);
INSERT INTO accounts_opportunities VALUES ('73b40f45-aed4-8f4a-3f7c-438dfb73e07f', '460506e7-d720-6153-9533-438dfbcd86ab', 'e1e7c4e5-7e25-6799-eb9a-438dfba51d7f', '2005-11-30 19:24:59', 0);
INSERT INTO accounts_opportunities VALUES ('1ef119f5-1998-c802-bed0-438dfb36ac70', '1c0f05b2-89b7-18e2-891a-438dfbc01ee0', '19c8dab9-5903-3485-5d78-438dfb4125b3', '2005-11-30 19:25:00', 0);
INSERT INTO accounts_opportunities VALUES ('232c6579-97cf-57b0-1078-438dfb9b2570', '205b2bf4-43dd-a21c-76fc-438dfba0e9a6', '19c8dab9-5903-3485-5d78-438dfb4125b3', '2005-11-30 19:25:00', 0);
INSERT INTO accounts_opportunities VALUES ('27632741-d91c-0fd6-6868-438dfb0400ac', '24842fa2-f1d0-fcd7-400f-438dfb4ea646', '19c8dab9-5903-3485-5d78-438dfb4125b3', '2005-11-30 19:25:00', 0);
INSERT INTO accounts_opportunities VALUES ('2bb0caa4-2e89-9ad4-a8fc-438dfba51e73', '28cc81f8-ea49-abeb-5ac0-438dfb987703', '19c8dab9-5903-3485-5d78-438dfb4125b3', '2005-11-30 19:25:00', 0);
INSERT INTO accounts_opportunities VALUES ('32ee61a8-92ed-f1d1-1170-438dfb530dab', '3016ac3f-2c2c-fff0-8cdd-438dfb22aee2', '19c8dab9-5903-3485-5d78-438dfb4125b3', '2005-11-30 19:25:01', 0);
INSERT INTO accounts_opportunities VALUES ('4962d33b-e9a7-0f62-3138-438dfbc915e4', '4695456f-d7cd-44c9-9432-438dfb4908a4', '44496c8b-c971-3912-ef47-438dfb05614b', '2005-11-30 19:25:01', 0);
INSERT INTO accounts_opportunities VALUES ('4db7a674-135c-9cb1-65b2-438dfb3f59aa', '4ad7d4ca-6946-8924-7f8d-438dfbe2ae9d', '44496c8b-c971-3912-ef47-438dfb05614b', '2005-11-30 19:25:01', 0);
INSERT INTO accounts_opportunities VALUES ('51e59fc3-ff30-6a78-f512-438dfb826663', '4f1a133e-69a8-8870-80ff-438dfb9482ad', '44496c8b-c971-3912-ef47-438dfb05614b', '2005-11-30 19:25:01', 0);
INSERT INTO accounts_opportunities VALUES ('564bb0be-bddb-c3f9-69ea-438dfb7c5ca2', '5346c858-7a27-e1bd-200c-438dfb83b6c5', '44496c8b-c971-3912-ef47-438dfb05614b', '2005-11-30 19:25:01', 0);
INSERT INTO accounts_opportunities VALUES ('5a77108a-2eae-2b1f-adeb-438dfb89498d', '57ac3090-3093-c852-ee7e-438dfb446e3c', '44496c8b-c971-3912-ef47-438dfb05614b', '2005-11-30 19:25:02', 0);
INSERT INTO accounts_opportunities VALUES ('6efe815b-2313-dea2-458a-438dfbfe1f08', '6c21cecc-c7ea-a8ad-c453-438dfbbe0d88', '69df481f-8899-8333-3d9c-438dfbae3e94', '2005-11-30 19:25:02', 0);
INSERT INTO accounts_opportunities VALUES ('7961483c-4e69-77b0-f0a3-438dfbe20d55', '768c10fd-dfe5-d48a-bd05-438dfbe2f963', '69df481f-8899-8333-3d9c-438dfbae3e94', '2005-11-30 19:25:02', 0);
INSERT INTO accounts_opportunities VALUES ('7da10b74-ef78-840d-d3c1-438dfb4874d1', '7ac658d9-f721-df1a-b286-438dfb5cf45a', '69df481f-8899-8333-3d9c-438dfbae3e94', '2005-11-30 19:25:02', 0);
INSERT INTO accounts_opportunities VALUES ('81d2d089-8f71-2073-516b-438dfb502a4f', '7f027dd8-9057-42e1-07f5-438dfbafaeb6', '69df481f-8899-8333-3d9c-438dfbae3e94', '2005-11-30 19:25:03', 0);
INSERT INTO accounts_opportunities VALUES ('85ffb0a9-ea61-3459-603f-438dfbf9c153', '832e6608-f1d6-77b0-177f-438dfb0b9d14', '69df481f-8899-8333-3d9c-438dfbae3e94', '2005-11-30 19:25:03', 0);
INSERT INTO accounts_opportunities VALUES ('a17a1332-2839-648a-411a-438dfbd19311', '9e802058-7610-9c18-f36d-438dfbde8cc9', '9bf12bea-3d89-2b67-a279-438dfb7f1aa9', '2005-11-30 19:25:03', 0);
INSERT INTO accounts_opportunities VALUES ('a5e31196-3bcb-33a0-0c64-438dfb14ffbd', 'a2f02b4c-f25f-21d1-1850-438dfba84ba8', '9bf12bea-3d89-2b67-a279-438dfb7f1aa9', '2005-11-30 19:25:03', 0);
INSERT INTO accounts_opportunities VALUES ('ad7edace-c124-cf1d-6b30-438dfb630ca4', 'aa7b73ec-9391-753b-56ba-438dfba9e5a2', '9bf12bea-3d89-2b67-a279-438dfb7f1aa9', '2005-11-30 19:25:04', 0);
INSERT INTO accounts_opportunities VALUES ('b1e8c601-6da8-a212-5c07-438dfbfef646', 'aeefd0cf-f728-8378-d872-438dfb02d851', '9bf12bea-3d89-2b67-a279-438dfb7f1aa9', '2005-11-30 19:25:04', 0);
INSERT INTO accounts_opportunities VALUES ('b6443b43-e7ba-eea1-b515-438dfb319359', 'b350b12d-0725-3f76-d10c-438dfb00ff78', '9bf12bea-3d89-2b67-a279-438dfb7f1aa9', '2005-11-30 19:25:04', 0);
INSERT INTO accounts_opportunities VALUES ('cb3b9762-33c7-2809-0b10-438dfb0bbe36', 'c84815e0-53af-a5cf-0711-438dfba1ef7c', 'c5fb833d-150f-99a6-9946-438dfb94f2c5', '2005-11-30 19:25:04', 0);
INSERT INTO accounts_opportunities VALUES ('cf94a4b1-6f30-42a2-f037-438dfb17362b', 'cca48775-d385-0c83-453b-438dfbcb5fe5', 'c5fb833d-150f-99a6-9946-438dfb94f2c5', '2005-11-30 19:25:05', 0);
INSERT INTO accounts_opportunities VALUES ('d4297f0a-2b77-597f-5f97-438dfb308493', 'd10a10ae-43ca-10a3-1fb1-438dfb8469cd', 'c5fb833d-150f-99a6-9946-438dfb94f2c5', '2005-11-30 19:25:05', 0);
INSERT INTO accounts_opportunities VALUES ('d8834e91-b186-b347-65b0-438dfb1500d3', 'd596fdf4-8370-e6d2-f673-438dfb4330cd', 'c5fb833d-150f-99a6-9946-438dfb94f2c5', '2005-11-30 19:25:05', 0);
INSERT INTO accounts_opportunities VALUES ('e0292f6f-c03e-a568-11a6-438dfbc0098a', 'dd34fc8c-b2a9-b42e-d359-438dfb743d70', 'c5fb833d-150f-99a6-9946-438dfb94f2c5', '2005-11-30 19:25:05', 0);
INSERT INTO accounts_opportunities VALUES ('78120de0-10c4-3cec-855f-438dfbffff85', '48cd06cd-67af-f712-26c3-438dfbdcdf28', '24360cfc-2889-5353-2998-438dfbffd419', '2005-11-30 19:25:05', 0);
INSERT INTO accounts_opportunities VALUES ('be590e98-c571-b3c3-d49f-438dfb79b5ee', '8ee90950-1f91-1b6f-ed91-438dfbc0481e', '24360cfc-2889-5353-2998-438dfbffd419', '2005-11-30 19:25:06', 0);
INSERT INTO accounts_opportunities VALUES ('10516c05-0e21-bc11-31a3-438dfb496961', 'd54700b1-0778-7657-3d25-438dfbbc19da', '24360cfc-2889-5353-2998-438dfbffd419', '2005-11-30 19:25:06', 0);
INSERT INTO accounts_opportunities VALUES ('149fb560-bbe0-7f82-77da-438dfb440877', '11b6a296-180f-8177-925b-438dfbca6232', '24360cfc-2889-5353-2998-438dfbffd419', '2005-11-30 19:25:06', 0);
INSERT INTO accounts_opportunities VALUES ('1900a188-6212-c62f-da15-438dfbccb4d9', '16040bf2-478d-1a6a-a003-438dfb6e9791', '24360cfc-2889-5353-2998-438dfbffd419', '2005-11-30 19:25:06', 0);
INSERT INTO accounts_opportunities VALUES ('2ddc46e9-2a9e-dcab-e879-438dfb0eee0a', '2afe9670-9d44-d951-77ef-438dfb25056c', '28a3374d-7edd-e1ae-8b82-438dfbb1ba4b', '2005-11-30 19:25:07', 0);
INSERT INTO accounts_opportunities VALUES ('357f9da2-5753-dade-3d25-438dfb347568', '32a8b9ed-d818-8d35-738c-438dfbb31057', '28a3374d-7edd-e1ae-8b82-438dfbb1ba4b', '2005-11-30 19:25:07', 0);
INSERT INTO accounts_opportunities VALUES ('39b44765-605b-fe00-183c-438dfb87d4f0', '36df46b8-53b1-f5ce-c029-438dfbd4485d', '28a3374d-7edd-e1ae-8b82-438dfbb1ba4b', '2005-11-30 19:25:07', 0);
INSERT INTO accounts_opportunities VALUES ('46ac6e9b-cb6d-e570-b77b-438dfb59db62', '43d23e75-16a7-d388-aa6b-438dfb65b16a', '28a3374d-7edd-e1ae-8b82-438dfbb1ba4b', '2005-11-30 19:25:07', 0);
INSERT INTO accounts_opportunities VALUES ('4af7b896-c012-5eff-58ab-438dfbea2374', '4809b1ab-0fef-57a0-9b8e-438dfbecaf87', '28a3374d-7edd-e1ae-8b82-438dfbb1ba4b', '2005-11-30 19:25:07', 0);
INSERT INTO accounts_opportunities VALUES ('5f95f18b-3ed4-f6ca-b107-438dfb0e4f8c', '5cbe08c0-cc64-7c47-de07-438dfb2098a1', '5a6c2cce-c982-432d-802f-438dfbaa1b2d', '2005-11-30 19:25:08', 0);
INSERT INTO accounts_opportunities VALUES ('63cd7c4a-e296-c180-a026-438dfb7b4ca7', '60f5f1b0-556b-759a-e107-438dfb8a43b5', '5a6c2cce-c982-432d-802f-438dfbaa1b2d', '2005-11-30 19:25:08', 0);
INSERT INTO accounts_opportunities VALUES ('680bc41f-1ac9-68a1-3ff2-438dfbe9506d', '652c68c0-a5e1-e95e-8369-438dfb04c88e', '5a6c2cce-c982-432d-802f-438dfbaa1b2d', '2005-11-30 19:25:08', 0);
INSERT INTO accounts_opportunities VALUES ('6c38e7ed-e918-6e9f-61df-438dfb2bd2a9', '6967e23e-5fdc-1a44-302a-438dfb156e1c', '5a6c2cce-c982-432d-802f-438dfbaa1b2d', '2005-11-30 19:25:08', 0);
INSERT INTO accounts_opportunities VALUES ('70692f7f-fb7c-95c7-6351-438dfb06698f', '6d93a572-12bd-6732-0350-438dfbbbdbb6', '5a6c2cce-c982-432d-802f-438dfbaa1b2d', '2005-11-30 19:25:08', 0);
INSERT INTO accounts_opportunities VALUES ('84cc820a-08e9-8468-b297-438dfbe0b7a1', '81fd942a-0587-a0bd-1b49-438dfb8419a8', '7fb9aa29-6e36-4329-96a0-438dfbe17998', '2005-11-30 19:25:09', 0);
INSERT INTO accounts_opportunities VALUES ('8918b76a-9d62-b17a-df71-438dfb1bee12', '863135ae-777f-6cf2-41c4-438dfbdae2b3', '7fb9aa29-6e36-4329-96a0-438dfbe17998', '2005-11-30 19:25:09', 0);
INSERT INTO accounts_opportunities VALUES ('8d4f681d-a787-07f8-e8ce-438dfb2b1e0e', '8a7cc37d-e797-253e-77b7-438dfb5c74b7', '7fb9aa29-6e36-4329-96a0-438dfbe17998', '2005-11-30 19:25:09', 0);
INSERT INTO accounts_opportunities VALUES ('917a6682-3b8e-1633-70dc-438dfb3ae6ec', '8eaed9e4-aab7-d228-e161-438dfb59c42e', '7fb9aa29-6e36-4329-96a0-438dfbe17998', '2005-11-30 19:25:09', 0);
INSERT INTO accounts_opportunities VALUES ('95c335f5-30c4-7407-a3a3-438dfbb22371', '92d556da-7d2e-07d8-c3c0-438dfb417180', '7fb9aa29-6e36-4329-96a0-438dfbe17998', '2005-11-30 19:25:10', 0);
INSERT INTO accounts_opportunities VALUES ('aa317a99-f33a-07cb-d5a6-438dfbc9b91b', 'a75b3567-6133-ee10-33a3-438dfb94cf35', 'a5207af5-eba0-4a11-4fec-438dfb66e63f', '2005-11-30 19:25:10', 0);
INSERT INTO accounts_opportunities VALUES ('ae79e1f2-b1d0-6491-f609-438dfb5e93bb', 'ab9f9824-b007-b4bc-ed87-438dfb168d0c', 'a5207af5-eba0-4a11-4fec-438dfb66e63f', '2005-11-30 19:25:10', 0);
INSERT INTO accounts_opportunities VALUES ('b2a788a8-a775-01e2-3622-438dfbb03188', 'afd38d5f-90f2-41d2-a703-438dfbd5c40c', 'a5207af5-eba0-4a11-4fec-438dfb66e63f', '2005-11-30 19:25:10', 0);
INSERT INTO accounts_opportunities VALUES ('b6d75638-bde6-35dd-68c1-438dfbae0f21', 'b4047471-9c36-6b26-5eff-438dfbb1b690', 'a5207af5-eba0-4a11-4fec-438dfb66e63f', '2005-11-30 19:25:10', 0);
INSERT INTO accounts_opportunities VALUES ('bb10381e-231b-caa9-64d4-438dfb5a2d71', 'b83700dd-c19d-b9f9-95c1-438dfbe35fd8', 'a5207af5-eba0-4a11-4fec-438dfb66e63f', '2005-11-30 19:25:11', 0);
INSERT INTO accounts_opportunities VALUES ('cf8f4540-4c9a-8574-40ea-438dfb953822', 'ccbb3507-f6e7-22d7-a4a8-438dfb9ce1b9', 'ca77a3a6-1980-87ca-3936-438dfbc5ed9a', '2005-11-30 19:25:11', 0);
INSERT INTO accounts_opportunities VALUES ('d3d4f14a-8726-05e6-3d31-438dfb5ee800', 'd0f4f687-9ae1-7406-552f-438dfb3f0866', 'ca77a3a6-1980-87ca-3936-438dfbc5ed9a', '2005-11-30 19:25:11', 0);
INSERT INTO accounts_opportunities VALUES ('d8083062-3535-185d-bd47-438dfbd8bf70', 'd5327c0b-b590-b9d1-dc7b-438dfb37afe8', 'ca77a3a6-1980-87ca-3936-438dfbc5ed9a', '2005-11-30 19:25:11', 0);
INSERT INTO accounts_opportunities VALUES ('dc38f367-687b-4d00-d98d-438dfbcae950', 'd96e5648-c22f-51d1-3e35-438dfb886bb7', 'ca77a3a6-1980-87ca-3936-438dfbc5ed9a', '2005-11-30 19:25:12', 0);
INSERT INTO accounts_opportunities VALUES ('e7cce2a3-4922-772b-a079-438dfbe8dda3', 'e4fafdf4-90bb-ac13-2d2e-438dfbf6150a', 'ca77a3a6-1980-87ca-3936-438dfbc5ed9a', '2005-11-30 19:25:12', 0);
INSERT INTO accounts_opportunities VALUES ('81490b71-e8e0-8ecd-e973-438dfba87293', '540109ea-5aa2-aa68-5492-438dfb11f7ca', '301d0472-13ab-06ea-b8ea-438dfbbf5d2b', '2005-11-30 19:25:12', 0);
INSERT INTO accounts_opportunities VALUES ('13c19db5-fe8c-1e48-8aad-438dfb57c4aa', '10ea6cd2-8dbf-5b30-7b5c-438dfb6f7525', '301d0472-13ab-06ea-b8ea-438dfbbf5d2b', '2005-11-30 19:25:12', 0);
INSERT INTO accounts_opportunities VALUES ('17f7c883-77aa-afbb-c25e-438dfb63f2f8', '152505bc-1ca1-621e-17cb-438dfb462f96', '301d0472-13ab-06ea-b8ea-438dfbbf5d2b', '2005-11-30 19:25:13', 0);
INSERT INTO accounts_opportunities VALUES ('1c343815-6c14-9dfb-df05-438dfbb2af9f', '1955d121-ca89-6420-09b9-438dfb0f392c', '301d0472-13ab-06ea-b8ea-438dfbbf5d2b', '2005-11-30 19:25:13', 0);
INSERT INTO accounts_opportunities VALUES ('206d9dda-da10-f3c5-9578-438dfb1219c9', '1d90efad-17df-67c0-71e3-438dfbbcb3da', '301d0472-13ab-06ea-b8ea-438dfbbf5d2b', '2005-11-30 19:25:13', 0);
INSERT INTO accounts_opportunities VALUES ('351c84fe-72bd-6459-004b-438dfb290ce7', '3230625a-2263-5c98-cdf5-438dfb631e2a', '2fe59fe0-21e0-b9aa-f06e-438dfbf94248', '2005-11-30 19:25:13', 0);
INSERT INTO accounts_opportunities VALUES ('395b6e99-7820-7562-aa38-438dfbedb994', '368a92fd-5fa6-c590-bcf2-438dfba9100f', '2fe59fe0-21e0-b9aa-f06e-438dfbf94248', '2005-11-30 19:25:14', 0);
INSERT INTO accounts_opportunities VALUES ('3d87daea-839e-e29e-32e1-438dfb663f26', '3ab5fe0b-a560-571a-ba49-438dfbd4c3aa', '2fe59fe0-21e0-b9aa-f06e-438dfbf94248', '2005-11-30 19:25:14', 0);
INSERT INTO accounts_opportunities VALUES ('479fd4bd-5797-a6ab-4cb0-438dfbd7f154', '44bfeef2-e75e-d0f3-5710-438dfbd1d93f', '2fe59fe0-21e0-b9aa-f06e-438dfbf94248', '2005-11-30 19:25:14', 0);
INSERT INTO accounts_opportunities VALUES ('4bf86e41-62a4-491b-da93-438dfb2eaa53', '4909296f-8086-c934-c01b-438dfb554457', '2fe59fe0-21e0-b9aa-f06e-438dfbf94248', '2005-11-30 19:25:14', 0);
INSERT INTO accounts_opportunities VALUES ('60e6bed0-6858-aa7c-858c-438dfb5c7005', '5e0c699a-bafb-5226-6f8e-438dfb59d973', '5bcee21d-2f47-8266-e876-438dfb7e8edd', '2005-11-30 19:25:14', 0);
INSERT INTO accounts_opportunities VALUES ('65241fa2-6382-e4a1-979b-438dfb38c314', '62470b3b-9919-b5a7-a28a-438dfbb6c77a', '5bcee21d-2f47-8266-e876-438dfb7e8edd', '2005-11-30 19:25:14', 0);
INSERT INTO accounts_opportunities VALUES ('69664889-b89e-ce83-7f2c-438dfbdf5c2c', '668e33b0-8ac7-f81a-dce1-438dfb7a2284', '5bcee21d-2f47-8266-e876-438dfb7e8edd', '2005-11-30 19:25:15', 0);
INSERT INTO accounts_opportunities VALUES ('6d9a3310-e205-3fff-90c8-438dfbf1d9cb', '6acd46b3-e02c-ce50-ddc9-438dfb2eb5d5', '5bcee21d-2f47-8266-e876-438dfb7e8edd', '2005-11-30 19:25:15', 0);
INSERT INTO accounts_opportunities VALUES ('71cb9461-e6f3-15b0-e191-438dfb818f5a', '6ef1fc8f-ebf4-879b-0677-438dfb58fac6', '5bcee21d-2f47-8266-e876-438dfb7e8edd', '2005-11-30 19:25:15', 0);
INSERT INTO accounts_opportunities VALUES ('9ec1ed33-3d26-442f-2033-438dfb30386a', '836cd18e-1bdf-596a-0bc7-438dfbd15ae9', '812f72fc-ab3e-476d-9117-438dfb874384', '2005-11-30 19:25:15', 0);
INSERT INTO accounts_opportunities VALUES ('a31126d6-5c19-e0f3-7e06-438dfb65e7f1', 'a02d903b-b8ef-afdc-ec75-438dfb486076', '812f72fc-ab3e-476d-9117-438dfb874384', '2005-11-30 19:25:16', 0);
INSERT INTO accounts_opportunities VALUES ('ab35fc0a-e34a-60b3-94ff-438dfbac5123', 'a8690d59-9766-58e8-a8d9-438dfbc8732e', '812f72fc-ab3e-476d-9117-438dfb874384', '2005-11-30 19:25:16', 0);
INSERT INTO accounts_opportunities VALUES ('af7a94ee-7ef3-c465-a9f5-438dfb7176c1', 'ac9c04fb-ccb8-cf75-22cc-438dfb87532e', '812f72fc-ab3e-476d-9117-438dfb874384', '2005-11-30 19:25:16', 0);
INSERT INTO accounts_opportunities VALUES ('b3a4fa89-7746-bb02-6960-438dfbc9ea8b', 'b0d3f2bb-bccf-df3e-19c2-438dfbc79119', '812f72fc-ab3e-476d-9117-438dfb874384', '2005-11-30 19:25:16', 0);
INSERT INTO accounts_opportunities VALUES ('c8240a72-d6a6-38ba-2954-438dfb8e9975', 'c54b3b2c-603d-5637-0a71-438dfb54df11', 'c2f7eed0-8116-30ea-954e-438dfb1eabdb', '2005-11-30 19:25:17', 0);
INSERT INTO accounts_opportunities VALUES ('cc5b0f45-4574-1003-f3c2-438dfb61ee45', 'c987fbe8-3f54-bbcc-f41b-438dfb485262', 'c2f7eed0-8116-30ea-954e-438dfb1eabdb', '2005-11-30 19:25:17', 0);
INSERT INTO accounts_opportunities VALUES ('d0929221-e4dd-48f2-5d84-438dfbb88245', 'cdbcf9f8-1a0f-884f-f635-438dfb4743ab', 'c2f7eed0-8116-30ea-954e-438dfb1eabdb', '2005-11-30 19:25:17', 0);
INSERT INTO accounts_opportunities VALUES ('d4cd2951-4454-15e4-3f1c-438dfb2b5182', 'd1fc8eec-a2e1-b3d1-37c6-438dfb738d9b', 'c2f7eed0-8116-30ea-954e-438dfb1eabdb', '2005-11-30 19:25:17', 0);
INSERT INTO accounts_opportunities VALUES ('dd391926-8d14-556a-10af-438dfb4fdf59', 'da2bd072-494d-c303-58b0-438dfb3421a1', 'c2f7eed0-8116-30ea-954e-438dfb1eabdb', '2005-11-30 19:25:17', 0);
INSERT INTO accounts_opportunities VALUES ('f19db51a-20cc-3460-cedb-438dfb590c91', 'eec4ecba-2891-4b1a-20a6-438dfbfb69f3', 'ec7d9ee2-985e-832d-246a-438dfb43d183', '2005-11-30 19:25:18', 0);
INSERT INTO accounts_opportunities VALUES ('5dae0e81-57cb-bb9a-89dd-438dfba33a13', '2ede01e6-98e4-67c9-b6b9-438dfb99735b', 'ec7d9ee2-985e-832d-246a-438dfb43d183', '2005-11-30 19:25:18', 0);
INSERT INTO accounts_opportunities VALUES ('d6090e44-a98c-1390-30ab-438dfb909d0d', 'a8ef008e-2bb6-22d2-b37f-438dfbb01a9d', 'ec7d9ee2-985e-832d-246a-438dfb43d183', '2005-11-30 19:25:18', 0);
INSERT INTO accounts_opportunities VALUES ('119d7bd9-1a46-d604-c921-438dfbacd5e3', 'ecf707cf-1b58-5aec-5b1f-438dfb47042a', 'ec7d9ee2-985e-832d-246a-438dfb43d183', '2005-11-30 19:25:18', 0);
INSERT INTO accounts_opportunities VALUES ('15ca5c8a-b0d4-c798-4072-438dfbebd2da', '12f853df-aac4-ddc1-4b2a-438dfb9daab5', 'ec7d9ee2-985e-832d-246a-438dfb43d183', '2005-11-30 19:25:19', 0);
INSERT INTO accounts_opportunities VALUES ('2ba4bd8a-4d60-783c-7958-438dfbafc1e1', '286ceec6-7be4-491d-141b-438dfba8a41a', '25d33195-1843-27b2-f5df-438dfbbd4332', '2005-11-30 19:25:19', 0);
INSERT INTO accounts_opportunities VALUES ('2fe06115-a3cd-8c6f-a1e7-438dfb8ab396', '2d05edf0-9dcb-c279-5739-438dfb34ea0e', '25d33195-1843-27b2-f5df-438dfbbd4332', '2005-11-30 19:25:19', 0);
INSERT INTO accounts_opportunities VALUES ('384e128d-fb2f-4977-c91b-438dfbf55405', '35729b8f-4767-5c11-c8b0-438dfb7dcb3a', '25d33195-1843-27b2-f5df-438dfbbd4332', '2005-11-30 19:25:19', 0);
INSERT INTO accounts_opportunities VALUES ('3c776843-56ba-5985-1037-438dfb744e65', '39acdb89-4b96-c8f2-ad99-438dfbd6394c', '25d33195-1843-27b2-f5df-438dfbbd4332', '2005-11-30 19:25:20', 0);
INSERT INTO accounts_opportunities VALUES ('42ac9586-fd41-5b29-36ae-438dfb24e32d', '3dd5e9d7-e2db-1fb2-0b01-438dfb2bdc76', '25d33195-1843-27b2-f5df-438dfbbd4332', '2005-11-30 19:25:20', 0);
INSERT INTO accounts_opportunities VALUES ('5fb92b4e-30af-70c6-9106-438dfb0d8d01', '5ce2fd89-0a70-28b3-8737-438dfb328466', '5a9ce64f-76c1-d0b3-0321-438dfb8cf7b6', '2005-11-30 19:25:20', 0);
INSERT INTO accounts_opportunities VALUES ('63ffa09e-42b2-4ab1-404f-438dfb94b91e', '611fab71-eddb-732c-6ff4-438dfb588f36', '5a9ce64f-76c1-d0b3-0321-438dfb8cf7b6', '2005-11-30 19:25:20', 0);
INSERT INTO accounts_opportunities VALUES ('68335e14-cfd5-1e53-9ad0-438dfb910a8a', '655d56c6-af3d-f369-916f-438dfbc5dcfc', '5a9ce64f-76c1-d0b3-0321-438dfb8cf7b6', '2005-11-30 19:25:20', 0);
INSERT INTO accounts_opportunities VALUES ('6c6ba9a5-00c3-833b-a243-438dfb123d46', '699b9f13-60c9-0cca-11dc-438dfb4fa505', '5a9ce64f-76c1-d0b3-0321-438dfb8cf7b6', '2005-11-30 19:25:21', 0);
INSERT INTO accounts_opportunities VALUES ('70a9e694-4d9d-f850-e0c5-438dfb23b9cb', '6dd17c14-d02a-6cf0-f931-438dfb14aa50', '5a9ce64f-76c1-d0b3-0321-438dfb8cf7b6', '2005-11-30 19:25:21', 0);
INSERT INTO accounts_opportunities VALUES ('8522215e-958b-63f9-7a84-438dfb67114d', '823d9076-38d2-f7d1-1724-438dfb1e1ad2', '7ff64e0f-4980-e147-e646-438dfb3c2560', '2005-11-30 19:25:21', 0);
INSERT INTO accounts_opportunities VALUES ('8962f24e-2a74-22b9-ff57-438dfbad8e8d', '8689497e-cfb4-70c3-0563-438dfb3fd803', '7ff64e0f-4980-e147-e646-438dfb3c2560', '2005-11-30 19:25:21', 0);
INSERT INTO accounts_opportunities VALUES ('8d952bf7-8b85-4ae2-f86d-438dfb58fcfb', '8ac5206f-40e2-d000-8e58-438dfbcd1063', '7ff64e0f-4980-e147-e646-438dfb3c2560', '2005-11-30 19:25:22', 0);
INSERT INTO accounts_opportunities VALUES ('91ca4641-76a6-e55e-f6a7-438dfb9cd808', '8ef84370-518c-ff60-7f26-438dfb2c74da', '7ff64e0f-4980-e147-e646-438dfb3c2560', '2005-11-30 19:25:22', 0);
INSERT INTO accounts_opportunities VALUES ('9605efdc-da79-a97e-241b-438dfb8d50ff', '932c74ef-56b5-f7ac-3a3f-438dfba9deb4', '7ff64e0f-4980-e147-e646-438dfb3c2560', '2005-11-30 19:25:22', 0);
INSERT INTO accounts_opportunities VALUES ('aa8d61d1-06e4-d322-dc84-438dfbc9202f', 'a7b830fb-d98e-df89-effd-438dfb27c797', 'a57a0171-598b-52c1-a44f-438dfbac3293', '2005-11-30 19:25:22', 0);
INSERT INTO accounts_opportunities VALUES ('aec0edd9-bc2e-f48f-1bea-438dfbee0035', 'abef6e7e-5c4c-50f6-dba4-438dfb8ae91e', 'a57a0171-598b-52c1-a44f-438dfbac3293', '2005-11-30 19:25:23', 0);
INSERT INTO accounts_opportunities VALUES ('b3028ed4-cf3e-ae00-4796-438dfb674103', 'b02884a3-4b6a-17b8-3410-438dfb12fc6c', 'a57a0171-598b-52c1-a44f-438dfbac3293', '2005-11-30 19:25:23', 0);
INSERT INTO accounts_opportunities VALUES ('b73272b2-6677-0f3a-f18f-438dfb0bfa31', 'b4631b05-b8a5-84b8-6aef-438dfbd6f954', 'a57a0171-598b-52c1-a44f-438dfbac3293', '2005-11-30 19:25:23', 0);
INSERT INTO accounts_opportunities VALUES ('bb768861-916c-d691-5e94-438dfbac7cc6', 'b88dba73-ee88-0b13-c3c8-438dfb69c4f7', 'a57a0171-598b-52c1-a44f-438dfbac3293', '2005-11-30 19:25:23', 0);
INSERT INTO accounts_opportunities VALUES ('cfe5cff5-3b99-e7c4-bb30-438dfb66a842', 'cd0f47a1-1706-0f64-be0a-438dfb77c092', 'cad65136-9e79-c945-107b-438dfb8b41de', '2005-11-30 19:25:24', 0);
INSERT INTO accounts_opportunities VALUES ('d4a829a5-fbc2-1f40-e99e-438dfbcdae85', 'd1affdd8-3bd0-1592-c9b5-438dfb6b617f', 'cad65136-9e79-c945-107b-438dfb8b41de', '2005-11-30 19:25:24', 0);
INSERT INTO accounts_opportunities VALUES ('d8da809e-7a11-6b68-fb0e-438dfb9f9bf4', 'd60018a8-f364-a59e-6b96-438dfbc335a6', 'cad65136-9e79-c945-107b-438dfb8b41de', '2005-11-30 19:25:24', 0);
INSERT INTO accounts_opportunities VALUES ('dd095bbf-1ecf-3e13-3060-438dfb19cbbb', 'da3b2fef-92e8-a1d7-652c-438dfb345bc3', 'cad65136-9e79-c945-107b-438dfb8b41de', '2005-11-30 19:25:24', 0);
INSERT INTO accounts_opportunities VALUES ('e1493961-fefa-d3b3-5651-438dfb463daa', 'de784407-4fda-479a-c6d5-438dfbacadcb', 'cad65136-9e79-c945-107b-438dfb8b41de', '2005-11-30 19:25:25', 0);
INSERT INTO accounts_opportunities VALUES ('19070228-8c64-e7d2-14e0-438dfb4fd2c8', 'f2d76a9c-1c91-8885-8066-438dfb64fc60', 'f09a17fa-2820-2d97-db3c-438dfbf7e7e5', '2005-11-30 19:25:25', 0);
INSERT INTO accounts_opportunities VALUES ('5df20fbb-ddc8-1b5b-9832-438dfb843044', '308e006e-bc0f-5dbd-506a-438dfb3be5c5', 'f09a17fa-2820-2d97-db3c-438dfbf7e7e5', '2005-11-30 19:25:25', 0);
INSERT INTO accounts_opportunities VALUES ('a0b00c20-3880-c0ac-1b32-438dfb20f5f6', '74040694-e95f-e762-7a98-438dfbb1b40e', 'f09a17fa-2820-2d97-db3c-438dfbf7e7e5', '2005-11-30 19:25:25', 0);
INSERT INTO accounts_opportunities VALUES ('e45106b6-cf32-8bd1-000a-438dfbca41a7', 'b6e101b8-41b4-572a-552d-438dfbd455e5', 'f09a17fa-2820-2d97-db3c-438dfbf7e7e5', '2005-11-30 19:25:26', 0);
INSERT INTO accounts_opportunities VALUES ('12b8621d-fd6f-520f-86de-438dfb3d3276', 'fe9004b6-26f2-e8e1-35fd-438dfba98219', 'f09a17fa-2820-2d97-db3c-438dfbf7e7e5', '2005-11-30 19:25:26', 0);
INSERT INTO accounts_opportunities VALUES ('273ba7bc-b4b2-d6aa-9924-438dfbc493b9', '24566344-f52b-eb3d-a74f-438dfbdc4b1e', '221acfb4-1667-5126-232f-438dfb9ae6c1', '2005-11-30 19:25:26', 0);
INSERT INTO accounts_opportunities VALUES ('2bc455d1-c0a1-9ae9-7099-438dfb508170', '28a44172-6a6a-5b9e-3146-438dfb348bdb', '221acfb4-1667-5126-232f-438dfb9ae6c1', '2005-11-30 19:25:26', 0);
INSERT INTO accounts_opportunities VALUES ('3008dae9-f404-ad0b-915e-438dfb87a78a', '2d27bbbb-5037-f8e8-15bd-438dfb20595f', '221acfb4-1667-5126-232f-438dfb9ae6c1', '2005-11-30 19:25:27', 0);
INSERT INTO accounts_opportunities VALUES ('344a74d1-b1e0-cd70-4442-438dfbfe5f69', '3174c250-728d-baf3-d023-438dfb9dfc02', '221acfb4-1667-5126-232f-438dfb9ae6c1', '2005-11-30 19:25:27', 0);
INSERT INTO accounts_opportunities VALUES ('388d0b6a-bb0d-d1e7-61a5-438dfb3ffaba', '35b2e33b-2ca7-e78f-405b-438dfb8d0f2b', '221acfb4-1667-5126-232f-438dfb9ae6c1', '2005-11-30 19:25:27', 0);
INSERT INTO accounts_opportunities VALUES ('4f27f60d-f029-f7ca-7614-438dfb1ef39d', '4c4bfa87-21e9-8f86-b6ab-438dfba5f514', '49d9b236-ff3a-4340-f619-438dfb42fdf8', '2005-11-30 19:25:27', 0);
INSERT INTO accounts_opportunities VALUES ('53d2ac4f-c171-17fe-e6d1-438dfbf8c617', '50fd2315-c8e2-6c94-95bf-438dfbe8bf01', '49d9b236-ff3a-4340-f619-438dfb42fdf8', '2005-11-30 19:25:28', 0);
INSERT INTO accounts_opportunities VALUES ('58120c81-a8e0-94f7-a6ef-438dfb78687c', '55331a92-cc7d-83ed-9f68-438dfb3742f8', '49d9b236-ff3a-4340-f619-438dfb42fdf8', '2005-11-30 19:25:28', 0);
INSERT INTO accounts_opportunities VALUES ('5c44798e-abe5-3d0c-672d-438dfb803874', '5971d75d-b9b3-0882-ca0b-438dfb5d7ff3', '49d9b236-ff3a-4340-f619-438dfb42fdf8', '2005-11-30 19:25:28', 0);
INSERT INTO accounts_opportunities VALUES ('60749d54-4389-63f9-750b-438dfb89a532', '5da7b4cf-3c16-f872-6208-438dfb8822e2', '49d9b236-ff3a-4340-f619-438dfb42fdf8', '2005-11-30 19:25:28', 0);
INSERT INTO accounts_opportunities VALUES ('74f4de82-2ce1-3e45-8bc0-438dfb083548', '721baef0-63f1-9d05-8cc0-438dfb244f63', '6fc8c6a5-7400-9855-fac4-438dfb37774c', '2005-11-30 19:25:29', 0);
INSERT INTO accounts_opportunities VALUES ('79228a39-0a65-4f59-28ef-438dfbe81672', '76542fea-a074-5072-6fe6-438dfba09c11', '6fc8c6a5-7400-9855-fac4-438dfb37774c', '2005-11-30 19:25:29', 0);
INSERT INTO accounts_opportunities VALUES ('7d651edd-0c54-050f-9071-438dfb672e17', '7a81118b-c6b0-231f-4970-438dfbc54cdf', '6fc8c6a5-7400-9855-fac4-438dfb37774c', '2005-11-30 19:25:29', 0);
INSERT INTO accounts_opportunities VALUES ('8197991a-4440-3af4-df4a-438dfbc3c401', '7ecd7ab9-a2c5-f1cf-a8ef-438dfbac3a71', '6fc8c6a5-7400-9855-fac4-438dfb37774c', '2005-11-30 19:25:29', 0);
INSERT INTO accounts_opportunities VALUES ('85bd3361-38ae-8993-bae3-438dfb04a553', '82efefb0-bffa-6d45-7863-438dfb521e06', '6fc8c6a5-7400-9855-fac4-438dfb37774c', '2005-11-30 19:25:29', 0);
INSERT INTO accounts_opportunities VALUES ('9a5d7f81-1f59-2ce9-854c-438dfb7ea383', '978389c7-3745-fd2f-1267-438dfb4169c0', '953f26e5-ef03-73a5-2912-438dfbf3e02e', '2005-11-30 19:25:29', 0);
INSERT INTO accounts_opportunities VALUES ('9e90b477-3aab-6722-6ebf-438dfb331a46', '9bbbbc4d-9298-9bbc-60ff-438dfbdd0264', '953f26e5-ef03-73a5-2912-438dfbf3e02e', '2005-11-30 19:25:30', 0);
INSERT INTO accounts_opportunities VALUES ('a2d85325-fb01-0593-af2b-438dfb787ce1', '9ffc7cc0-5d1e-68cd-240c-438dfbca51b5', '953f26e5-ef03-73a5-2912-438dfbf3e02e', '2005-11-30 19:25:30', 0);
INSERT INTO accounts_opportunities VALUES ('a70b3559-8c4e-0dd6-5696-438dfbf67538', 'a43c12bf-5037-a3fb-f853-438dfbf59ca1', '953f26e5-ef03-73a5-2912-438dfbf3e02e', '2005-11-30 19:25:30', 0);
INSERT INTO accounts_opportunities VALUES ('ab3b2c0a-759b-a95b-c955-438dfbfe78ea', 'a86652ef-8911-e502-81f6-438dfb0d3ecf', '953f26e5-ef03-73a5-2912-438dfbf3e02e', '2005-11-30 19:25:30', 0);
INSERT INTO accounts_opportunities VALUES ('bfc84253-3b5c-3eb6-bafe-438dfb3921a9', 'bce17bda-0ae3-6ba1-c12e-438dfbba303f', 'baa2d9d1-3d4d-1de9-fdf3-438dfba9a8e5', '2005-11-30 19:25:31', 0);
INSERT INTO accounts_opportunities VALUES ('c40aebf2-8331-3379-fdfd-438dfbd611d0', 'c132c0a8-3a8e-43ab-3db7-438dfb49d055', 'baa2d9d1-3d4d-1de9-fdf3-438dfba9a8e5', '2005-11-30 19:25:31', 0);
INSERT INTO accounts_opportunities VALUES ('c896c305-78f6-eb08-d953-438dfb2296f7', 'c56a320f-3d0d-0e0d-4344-438dfb969a34', 'baa2d9d1-3d4d-1de9-fdf3-438dfba9a8e5', '2005-11-30 19:25:31', 0);
INSERT INTO accounts_opportunities VALUES ('ccfaccde-8b62-ddde-a4f6-438dfb17ddca', 'c9fe25d0-ea89-15ab-14c2-438dfbc4a413', 'baa2d9d1-3d4d-1de9-fdf3-438dfba9a8e5', '2005-11-30 19:25:31', 0);
INSERT INTO accounts_opportunities VALUES ('d293a312-734e-db20-e2c6-438dfb622880', 'cfa5c5e6-c28e-969e-45a1-438dfb8dac12', 'baa2d9d1-3d4d-1de9-fdf3-438dfba9a8e5', '2005-11-30 19:25:32', 0);
INSERT INTO accounts_opportunities VALUES ('f3c75358-f62d-9292-13b7-438dfbe007e7', 'f0ef007c-c99f-5b8b-ca82-438dfbd320cc', 'eea76ad0-2d41-1f9b-c178-438dfb4344f9', '2005-11-30 19:25:32', 0);
INSERT INTO accounts_opportunities VALUES ('3e3505a0-17c4-a412-8c1f-438dfb89c76c', '10b30605-2253-34d9-ee1e-438dfbe3e652', 'eea76ad0-2d41-1f9b-c178-438dfb4344f9', '2005-11-30 19:25:32', 0);
INSERT INTO accounts_opportunities VALUES ('827103ca-8706-1627-1658-438dfbc6731a', '54890ae5-62e2-26e5-f53b-438dfb818ab4', 'eea76ad0-2d41-1f9b-c178-438dfb4344f9', '2005-11-30 19:25:32', 0);
INSERT INTO accounts_opportunities VALUES ('c5e00f8b-b83f-837f-829b-438dfb5bcfd5', '989d0111-e980-eac5-3ebc-438dfb76f7cd', 'eea76ad0-2d41-1f9b-c178-438dfb4344f9', '2005-11-30 19:25:33', 0);
INSERT INTO accounts_opportunities VALUES ('1082267e-ab48-a62a-3ab1-438dfb5ee4a8', 'db7f0563-935e-f101-48bf-438dfb7a81b6', 'eea76ad0-2d41-1f9b-c178-438dfb4344f9', '2005-11-30 19:25:33', 0);
INSERT INTO accounts_opportunities VALUES ('24f509f5-39da-f4ae-49ee-438dfb3ca70d', '221ec606-d8fd-c384-0946-438dfb3f7f35', '1fe57f85-843a-c2da-ce4a-438dfbdca0ec', '2005-11-30 19:25:33', 0);
INSERT INTO accounts_opportunities VALUES ('2a356dcf-785c-791b-af72-438dfbce04ff', '2717abf4-3924-c180-ef7a-438dfba04539', '1fe57f85-843a-c2da-ce4a-438dfbdca0ec', '2005-11-30 19:25:33', 0);
INSERT INTO accounts_opportunities VALUES ('2e831d5a-fc03-93a5-342e-438dfbeb2e69', '2b9b37eb-ef6a-8a91-9b3c-438dfbb088e9', '1fe57f85-843a-c2da-ce4a-438dfbdca0ec', '2005-11-30 19:25:34', 0);
INSERT INTO accounts_opportunities VALUES ('32b3b797-1f93-f0e3-84d2-438dfb51d692', '2fe3808a-bbec-2526-1799-438dfba5b517', '1fe57f85-843a-c2da-ce4a-438dfbdca0ec', '2005-11-30 19:25:34', 0);
INSERT INTO accounts_opportunities VALUES ('3887fd11-67ce-d347-d6dc-438dfbc27ea3', '35aceab9-10bb-4625-d3e8-438dfb50cdb3', '1fe57f85-843a-c2da-ce4a-438dfbdca0ec', '2005-11-30 19:25:34', 0);
INSERT INTO accounts_opportunities VALUES ('4fe84cdb-9cf9-b537-4299-438dfb2fc430', '4d0cb1a4-aa60-4393-3121-438dfb7119ee', '4ab5174a-cfe1-ac9d-33d7-438dfb1ba854', '2005-11-30 19:25:34', 0);
INSERT INTO accounts_opportunities VALUES ('542940ad-b2f4-4af7-5cdd-438dfb6a28a8', '5158f891-2bc7-6e5f-ad7b-438dfbd7fec1', '4ab5174a-cfe1-ac9d-33d7-438dfb1ba854', '2005-11-30 19:25:35', 0);
INSERT INTO accounts_opportunities VALUES ('587190b7-4691-3d27-6584-438dfbe0f9ae', '558852db-80d6-0fbf-397e-438dfbd84acb', '4ab5174a-cfe1-ac9d-33d7-438dfb1ba854', '2005-11-30 19:25:35', 0);
INSERT INTO accounts_opportunities VALUES ('5c9d543d-90aa-82be-58ce-438dfb37bebf', '59cdf978-7082-ff2d-0196-438dfb2138dc', '4ab5174a-cfe1-ac9d-33d7-438dfb1ba854', '2005-11-30 19:25:35', 0);
INSERT INTO accounts_opportunities VALUES ('62778b31-4556-ac2c-15c1-438dfb827a6e', '5fa49150-edbc-057c-9925-438dfbd60004', '4ab5174a-cfe1-ac9d-33d7-438dfb1ba854', '2005-11-30 19:25:35', 0);
INSERT INTO accounts_opportunities VALUES ('76eb0509-4d4a-d89a-1ffb-438dfb7adae9', '7414f9d5-20e7-95f9-5740-438dfb23ee79', '71d45061-e051-80ff-387f-438dfbcf7868', '2005-11-30 19:25:35', 0);
INSERT INTO accounts_opportunities VALUES ('7b2c60bc-ed46-479c-eac3-438dfb0e059b', '784f1c86-b8ee-85c4-3992-438dfb3240d0', '71d45061-e051-80ff-387f-438dfbcf7868', '2005-11-30 19:25:36', 0);
INSERT INTO accounts_opportunities VALUES ('7f72c014-01ef-bf31-ad05-438dfb27c7fe', '7c8a93af-a835-3443-a0df-438dfbedcb8b', '71d45061-e051-80ff-387f-438dfbcf7868', '2005-11-30 19:25:36', 0);
INSERT INTO accounts_opportunities VALUES ('8493d390-5251-1816-60c4-438dfbd589ec', '81c00099-6e60-de6b-98ee-438dfbc9c196', '71d45061-e051-80ff-387f-438dfbcf7868', '2005-11-30 19:25:36', 0);
INSERT INTO accounts_opportunities VALUES ('88b69797-3c90-07ec-acb7-438dfb5992a8', '85ed11ca-066b-f866-7152-438dfb07aa85', '71d45061-e051-80ff-387f-438dfbcf7868', '2005-11-30 19:25:37', 0);
INSERT INTO accounts_opportunities VALUES ('9d51c9db-541b-f6f9-82e5-438dfbbb44d6', '9a7b4b05-3f1b-b2d4-d053-438dfb209d69', '9831fcba-daad-6531-f7d9-438dfb452a61', '2005-11-30 19:25:37', 0);
INSERT INTO accounts_opportunities VALUES ('a18a4050-2a80-c81f-fee3-438dfb417ecd', '9eaf6fc6-3d0f-bc49-b401-438dfbc623d1', '9831fcba-daad-6531-f7d9-438dfb452a61', '2005-11-30 19:25:37', 0);
INSERT INTO accounts_opportunities VALUES ('a5c3d57d-d7be-1a62-d794-438dfb92e2b9', 'a2e9d93c-6439-3c42-ae55-438dfbf3ebb7', '9831fcba-daad-6531-f7d9-438dfb452a61', '2005-11-30 19:25:37', 0);
INSERT INTO accounts_opportunities VALUES ('a9ea2783-0f43-dce0-0acc-438dfbeb601d', 'a724f472-da75-4573-edd8-438dfb435191', '9831fcba-daad-6531-f7d9-438dfb452a61', '2005-11-30 19:25:37', 0);
INSERT INTO accounts_opportunities VALUES ('ae177dce-b2e8-7846-df61-438dfb4729e4', 'ab4263e9-3db1-55e3-6a1e-438dfb86b1f9', '9831fcba-daad-6531-f7d9-438dfb452a61', '2005-11-30 19:25:38', 0);
INSERT INTO accounts_opportunities VALUES ('c287591e-d2a0-aa40-6c55-438dfba143c6', 'bfb4d7fd-8c3f-d3b9-5320-438dfb52c870', 'bd7a6aa6-59fa-3349-782d-438dfb6a361a', '2005-11-30 19:25:38', 0);
INSERT INTO accounts_opportunities VALUES ('c6d7fa60-84b2-6cd8-7bca-438dfb76d912', 'c3ee5580-a836-eae5-3b21-438dfb609994', 'bd7a6aa6-59fa-3349-782d-438dfb6a361a', '2005-11-30 19:25:38', 0);
INSERT INTO accounts_opportunities VALUES ('cb0e6bc8-8bf8-9c41-bf86-438dfb053295', 'c832ffc3-a6a3-ee32-5f28-438dfb50ed65', 'bd7a6aa6-59fa-3349-782d-438dfb6a361a', '2005-11-30 19:25:38', 0);
INSERT INTO accounts_opportunities VALUES ('d03b9d3b-69ea-782e-f869-438dfba79347', 'cd6aefc7-050a-8b54-b1e8-438dfb8f99f1', 'bd7a6aa6-59fa-3349-782d-438dfb6a361a', '2005-11-30 19:25:39', 0);
INSERT INTO accounts_opportunities VALUES ('d480cdf1-ac76-bf49-b06d-438dfb4815ac', 'd1a37611-1fe2-986d-de75-438dfb10e559', 'bd7a6aa6-59fa-3349-782d-438dfb6a361a', '2005-11-30 19:25:39', 0);
INSERT INTO accounts_opportunities VALUES ('e8ee3dd4-1841-5756-9c1d-438dfba23971', 'e618a84c-2d47-ec23-4f6e-438dfb90dd02', 'e3d36dd6-a3ec-ca32-8f00-438dfbf01d62', '2005-11-30 19:25:39', 0);
INSERT INTO accounts_opportunities VALUES ('ed2cf4d1-7d70-db62-4a13-438dfbd13d35', 'ea4d7467-6865-29a5-085a-438dfb38ce8e', 'e3d36dd6-a3ec-ca32-8f00-438dfbf01d62', '2005-11-30 19:25:40', 0);
INSERT INTO accounts_opportunities VALUES ('f1568f74-bd96-0bd0-9f8f-438dfb81b881', 'ee866be6-f4f6-bdc0-4d86-438dfbbd5485', 'e3d36dd6-a3ec-ca32-8f00-438dfbf01d62', '2005-11-30 19:25:40', 0);
INSERT INTO accounts_opportunities VALUES ('28550431-9810-51ed-1eb4-438dfb8b873b', 'f3d91491-1ce6-240b-a8d2-438dfbb2e1cf', 'e3d36dd6-a3ec-ca32-8f00-438dfbf01d62', '2005-11-30 19:25:40', 0);
INSERT INTO accounts_opportunities VALUES ('6c050678-7c84-0ada-73f1-438dfbdb811f', '3ec301e9-6ab9-ed9e-f50f-438dfbc6c434', 'e3d36dd6-a3ec-ca32-8f00-438dfbf01d62', '2005-11-30 19:25:40', 0);
INSERT INTO accounts_opportunities VALUES ('1b50fc3c-0318-895a-2f1c-438dfb04047d', '1865d1ef-d29c-18b0-0764-438dfb423c56', '16270908-902d-5444-bdd2-438dfb677e78', '2005-11-30 19:25:41', 0);
INSERT INTO accounts_opportunities VALUES ('1f9bdeaf-ee9d-4702-f0a5-438dfb9fdfb1', '1cb35cc2-3ac7-b8ca-b12f-438dfb6518dc', '16270908-902d-5444-bdd2-438dfb677e78', '2005-11-30 19:25:41', 0);
INSERT INTO accounts_opportunities VALUES ('250980da-47cb-dc0a-8967-438dfbaa8ad7', '222bcfcd-6b48-ed6a-74b0-438dfb19eac7', '16270908-902d-5444-bdd2-438dfb677e78', '2005-11-30 19:25:41', 0);
INSERT INTO accounts_opportunities VALUES ('293fb1d7-5cbb-f5b2-b4d0-438dfb1a444f', '26661c15-859c-80ab-df4d-438dfb06044a', '16270908-902d-5444-bdd2-438dfb677e78', '2005-11-30 19:25:41', 0);
INSERT INTO accounts_opportunities VALUES ('2db2e58b-dea6-97e1-9b5f-438dfb131279', '2ac4fe6b-b06c-c024-3c0c-438dfb30385e', '16270908-902d-5444-bdd2-438dfb677e78', '2005-11-30 19:25:42', 0);
INSERT INTO accounts_opportunities VALUES ('4683493e-be89-efa7-c35b-438dfb251b03', '43ac0f8d-c18f-0df1-583e-438dfb295cf8', '3f6d17ff-3b92-d8ce-b733-438dfb08d42a', '2005-11-30 19:25:42', 0);
INSERT INTO accounts_opportunities VALUES ('4ab7e247-a400-fd19-c67f-438dfb3c58f0', '47e9ed5b-20dd-6b12-e3ac-438dfbc0d748', '3f6d17ff-3b92-d8ce-b733-438dfb08d42a', '2005-11-30 19:25:42', 0);
INSERT INTO accounts_opportunities VALUES ('4f2461fa-6161-3857-6df3-438dfb88749d', '4c1d0a24-e70c-328d-dea1-438dfb5ae983', '3f6d17ff-3b92-d8ce-b733-438dfb08d42a', '2005-11-30 19:25:42', 0);
INSERT INTO accounts_opportunities VALUES ('535a3c04-23be-be1a-1379-438dfbf3055f', '50863b92-3cd7-18f7-704a-438dfb278fc5', '3f6d17ff-3b92-d8ce-b733-438dfb08d42a', '2005-11-30 19:25:43', 0);
INSERT INTO accounts_opportunities VALUES ('57842c59-ec18-3049-090e-438dfb359216', '54b9324b-5d23-0aed-e591-438dfb300f0c', '3f6d17ff-3b92-d8ce-b733-438dfb08d42a', '2005-11-30 19:25:43', 0);
INSERT INTO accounts_opportunities VALUES ('6c4731c3-7c5c-b200-f0e5-438dfb265a4f', '69765854-582c-9e9c-c43a-438dfb1876d9', '672ce9a6-eabc-8209-5417-438dfbe5cda1', '2005-11-30 19:25:43', 0);
INSERT INTO accounts_opportunities VALUES ('707de05b-6c78-936b-0af5-438dfb1969a0', '6da7b907-a37f-5cbb-2983-438dfb1d3b97', '672ce9a6-eabc-8209-5417-438dfbe5cda1', '2005-11-30 19:25:43', 0);
INSERT INTO accounts_opportunities VALUES ('74b1a9b9-44f4-050f-42ac-438dfbbce600', '71deba86-5644-cd4a-5df8-438dfb22ecf9', '672ce9a6-eabc-8209-5417-438dfbe5cda1', '2005-11-30 19:25:43', 0);
INSERT INTO accounts_opportunities VALUES ('7a2e3eec-e094-3b71-fd36-438dfb1b8853', '775d2d24-f781-383d-f0be-438dfb393ce7', '672ce9a6-eabc-8209-5417-438dfbe5cda1', '2005-11-30 19:25:44', 0);
INSERT INTO accounts_opportunities VALUES ('7e65d032-9724-c4e3-d96a-438dfb50cd12', '7b8b7c21-666c-0fb9-39cb-438dfbde18ca', '672ce9a6-eabc-8209-5417-438dfbe5cda1', '2005-11-30 19:25:44', 0);
INSERT INTO accounts_opportunities VALUES ('92da1981-d46a-e6c7-d5ba-438dfb25cf08', '8ff9eacd-71cb-ef8d-b3ee-438dfb3e5b83', '8dbf7451-dc4a-3634-8099-438dfb762ae2', '2005-11-30 19:25:44', 0);
INSERT INTO accounts_opportunities VALUES ('97178dde-2ecc-d11f-e5a6-438dfb37ec87', '943c7b9d-b080-5f78-1b23-438dfba9b72b', '8dbf7451-dc4a-3634-8099-438dfb762ae2', '2005-11-30 19:25:44', 0);
INSERT INTO accounts_opportunities VALUES ('9b5939cd-9612-4d60-ae72-438dfb2d4175', '9887467f-8b7f-10cc-9cca-438dfb5fc025', '8dbf7451-dc4a-3634-8099-438dfb762ae2', '2005-11-30 19:25:45', 0);
INSERT INTO accounts_opportunities VALUES ('a0f16321-5b13-6b30-d378-438dfb128f84', '9e1ddab2-6f38-4bf4-cd64-438dfbb4432b', '8dbf7451-dc4a-3634-8099-438dfb762ae2', '2005-11-30 19:25:45', 0);
INSERT INTO accounts_opportunities VALUES ('a535b10d-2634-788b-6106-438dfb112bf5', 'a259e295-f213-4dff-af80-438dfb36c76a', '8dbf7451-dc4a-3634-8099-438dfb762ae2', '2005-11-30 19:25:45', 0);
INSERT INTO accounts_opportunities VALUES ('b9a5d033-afd2-8c0f-1e10-438dfba4646e', 'b6d43f88-065a-c224-9ca6-438dfbdfae49', 'b48abc38-b9e5-f7a7-1a0a-438dfb92bcf3', '2005-11-30 19:25:45', 0);
INSERT INTO accounts_opportunities VALUES ('bdee1988-ced1-c2b9-d397-438dfbe77a6d', 'bb10cd6c-07d4-62b7-627d-438dfb54e82d', 'b48abc38-b9e5-f7a7-1a0a-438dfb92bcf3', '2005-11-30 19:25:46', 0);
INSERT INTO accounts_opportunities VALUES ('c223f2cf-8996-54f9-8123-438dfb89aeeb', 'bf4eab22-6f46-559c-a8aa-438dfb4963e2', 'b48abc38-b9e5-f7a7-1a0a-438dfb92bcf3', '2005-11-30 19:25:46', 0);
INSERT INTO accounts_opportunities VALUES ('c65348cf-b18b-705f-b75f-438dfb00aff7', 'c37fc846-4e4e-92db-799d-438dfb2f2bde', 'b48abc38-b9e5-f7a7-1a0a-438dfb92bcf3', '2005-11-30 19:25:46', 0);
INSERT INTO accounts_opportunities VALUES ('ca834bd4-a486-9554-ff01-438dfb669179', 'c7af2a22-745d-5fd1-fc04-438dfbcc720b', 'b48abc38-b9e5-f7a7-1a0a-438dfb92bcf3', '2005-11-30 19:25:46', 0);
INSERT INTO accounts_opportunities VALUES ('df255667-923b-b474-b699-438dfb0fab1b', 'dc428d46-65bf-877a-1f1f-438dfba069dc', 'da0b3314-1bd1-f760-47f1-438dfba1b415', '2005-11-30 19:25:47', 0);
INSERT INTO accounts_opportunities VALUES ('e945cffe-88b7-9b90-6e75-438dfb82422b', 'e6721e98-7299-2ffb-7a12-438dfb76680c', 'da0b3314-1bd1-f760-47f1-438dfba1b415', '2005-11-30 19:25:47', 0);
INSERT INTO accounts_opportunities VALUES ('ed8bc5d2-ac94-071f-247e-438dfb0df4ef', 'eaa528d7-b6ea-11fa-ee8e-438dfb669591', 'da0b3314-1bd1-f760-47f1-438dfba1b415', '2005-11-30 19:25:47', 0);
INSERT INTO accounts_opportunities VALUES ('f1c304bb-6307-1a51-93bf-438dfbf1b418', 'eef32aa2-6357-5b53-7680-438dfb49d618', 'da0b3314-1bd1-f760-47f1-438dfba1b415', '2005-11-30 19:25:48', 0);
INSERT INTO accounts_opportunities VALUES ('1c750acc-6549-b286-c29b-438dfb985007', 'f31e70ab-7913-4c7e-8b6e-438dfb4ae881', 'da0b3314-1bd1-f760-47f1-438dfba1b415', '2005-11-30 19:25:48', 0);
INSERT INTO accounts_opportunities VALUES ('166b4c13-5c4d-aa3b-0940-438dfbbaa410', '13963c61-e2f6-56cc-4bd8-438dfb728735', '115922df-1ff1-d274-144c-438dfb73dc42', '2005-11-30 19:25:48', 0);
INSERT INTO accounts_opportunities VALUES ('1aa82084-2af6-928d-11fc-438dfbd6acaa', '17cfda23-c31c-e341-cd31-438dfb1a315b', '115922df-1ff1-d274-144c-438dfb73dc42', '2005-11-30 19:25:49', 0);
INSERT INTO accounts_opportunities VALUES ('1ef7748f-d100-c2c5-4c67-438dfb1fe925', '1c1b107a-5c4f-6480-53dc-438dfb868257', '115922df-1ff1-d274-144c-438dfb73dc42', '2005-11-30 19:25:49', 0);
INSERT INTO accounts_opportunities VALUES ('24ac136e-37e1-2fc1-1feb-438dfbb832b9', '21dba342-6e0e-9e1c-c7a9-438dfbd1e697', '115922df-1ff1-d274-144c-438dfb73dc42', '2005-11-30 19:25:49', 0);
INSERT INTO accounts_opportunities VALUES ('28e9b439-cf06-ebca-9245-438dfb379253', '260688cb-3e80-ba14-e4f6-438dfb32d178', '115922df-1ff1-d274-144c-438dfb73dc42', '2005-11-30 19:25:49', 0);
INSERT INTO accounts_opportunities VALUES ('3db2e06a-9a3e-d989-5827-438dfbb87f7b', '3ad8f646-28e9-9253-d903-438dfbbb6a75', '389b7a9d-973c-9771-632a-438dfb1fddfc', '2005-11-30 19:25:50', 0);
INSERT INTO accounts_opportunities VALUES ('45840411-8920-17b8-7659-438dfb0c9f03', '42a8d22b-2aa1-3bb0-8c1d-438dfb52120a', '389b7a9d-973c-9771-632a-438dfb1fddfc', '2005-11-30 19:25:50', 0);
INSERT INTO accounts_opportunities VALUES ('49b3794b-2027-e572-40c2-438dfbb1ca40', '46de26a3-3fae-a569-f722-438dfb78a67a', '389b7a9d-973c-9771-632a-438dfb1fddfc', '2005-11-30 19:25:50', 0);
INSERT INTO accounts_opportunities VALUES ('4e0daaad-b5fc-e85f-58d6-438dfbd606c1', '4b12703d-9b6c-2c98-ae90-438dfb06c3d2', '389b7a9d-973c-9771-632a-438dfb1fddfc', '2005-11-30 19:25:50', 0);
INSERT INTO accounts_opportunities VALUES ('524bfbcf-5a52-6c27-cf1a-438dfbd3902b', '4f7a16da-4d54-f5b8-5de5-438dfbb272bc', '389b7a9d-973c-9771-632a-438dfb1fddfc', '2005-11-30 19:25:51', 0);
INSERT INTO accounts_opportunities VALUES ('690cdd70-9f46-1be1-649f-438dfb94bc93', '6633afb9-5eb1-ca31-cf1d-438dfbdae578', '63f1f0f0-6489-f61f-9a36-438dfb750c25', '2005-11-30 19:25:51', 0);
INSERT INTO accounts_opportunities VALUES ('6d4c1377-b8ca-a7a7-971d-438dfb069728', '6a7319c7-5fb8-70e9-27dd-438dfbe09371', '63f1f0f0-6489-f61f-9a36-438dfb750c25', '2005-11-30 19:25:51', 0);
INSERT INTO accounts_opportunities VALUES ('7183cc3f-4c74-2036-1c60-438dfbd97510', '6ea99a81-d47b-853e-696d-438dfbb40f6d', '63f1f0f0-6489-f61f-9a36-438dfb750c25', '2005-11-30 19:25:51', 0);
INSERT INTO accounts_opportunities VALUES ('75b7555d-4fd4-7cea-e523-438dfb2d96b1', '72df06a1-b581-ed50-567e-438dfb22078a', '63f1f0f0-6489-f61f-9a36-438dfb750c25', '2005-11-30 19:25:52', 0);
INSERT INTO accounts_opportunities VALUES ('79e79145-838e-cc05-5918-438dfb9ec9d3', '7716d77f-040e-4169-4ab7-438dfb514331', '63f1f0f0-6489-f61f-9a36-438dfb750c25', '2005-11-30 19:25:52', 0);
INSERT INTO accounts_opportunities VALUES ('8e758be6-f41f-dc42-e071-438dfbd85b0e', '8b91706f-8a4c-bd2a-0cb1-438dfbd2936d', '8945a4f8-4927-b6da-7fbc-438dfb9c24e5', '2005-11-30 19:25:52', 0);
INSERT INTO accounts_opportunities VALUES ('9625c816-cd61-bc44-42e1-438dfb295f8e', '93439b48-5595-0fa0-c522-438dfb89df5b', '8945a4f8-4927-b6da-7fbc-438dfb9c24e5', '2005-11-30 19:25:52', 0);
INSERT INTO accounts_opportunities VALUES ('9a6c7559-4ace-a05c-efcb-438dfbd24830', '9784d86c-cde1-827f-433f-438dfb09b4b9', '8945a4f8-4927-b6da-7fbc-438dfb9c24e5', '2005-11-30 19:25:53', 0);
INSERT INTO accounts_opportunities VALUES ('9e9dd67f-69b2-b380-e8d1-438dfb63a2e0', '9bcda3fc-1320-38fc-12d1-438dfb63cee7', '8945a4f8-4927-b6da-7fbc-438dfb9c24e5', '2005-11-30 19:25:53', 0);
INSERT INTO accounts_opportunities VALUES ('a2cef876-ae43-c809-6028-438dfb57d931', '9ff98603-a842-30a4-67ea-438dfb1dc697', '8945a4f8-4927-b6da-7fbc-438dfb9c24e5', '2005-11-30 19:25:53', 0);
INSERT INTO accounts_opportunities VALUES ('b747db78-56bb-f275-e3d5-438dfb1c7de8', 'b4709fe1-3619-aadb-8ce4-438dfb58417e', 'b23360b3-d90f-0bf2-6864-438dfba63bde', '2005-11-30 19:25:54', 0);
INSERT INTO accounts_opportunities VALUES ('bd5a83c1-37d1-d35a-7b34-438dfbe3a417', 'ba7eb0fc-2b3e-a4ac-63c3-438dfb13d560', 'b23360b3-d90f-0bf2-6864-438dfba63bde', '2005-11-30 19:25:54', 0);
INSERT INTO accounts_opportunities VALUES ('c1902a1f-db8d-d8c3-b1d8-438dfb05aaac', 'bebd9998-c955-4f5a-b8bf-438dfb8c6537', 'b23360b3-d90f-0bf2-6864-438dfba63bde', '2005-11-30 19:25:54', 0);
INSERT INTO accounts_opportunities VALUES ('c5c8dfca-4612-18ec-e86d-438dfb9226d0', 'c2f80553-9c60-0334-5056-438dfb135676', 'b23360b3-d90f-0bf2-6864-438dfba63bde', '2005-11-30 19:25:54', 0);
INSERT INTO accounts_opportunities VALUES ('ca00a643-88ff-d68b-2e26-438dfb2df1f7', 'c72db0c4-c5df-17a2-7f3e-438dfbbfd930', 'b23360b3-d90f-0bf2-6864-438dfba63bde', '2005-11-30 19:25:55', 0);
INSERT INTO accounts_opportunities VALUES ('dec00c3f-367f-abdc-76e9-438dfb5653ed', 'dbafda06-f527-9955-9969-438dfb221485', 'd97458bd-138c-6ccd-14c1-438dfb875b17', '2005-11-30 19:25:55', 0);
INSERT INTO accounts_opportunities VALUES ('e305a2e0-5643-2da0-3ffc-438dfb680397', 'e0380df8-8fcb-d745-c22e-438dfba1bfac', 'd97458bd-138c-6ccd-14c1-438dfb875b17', '2005-11-30 19:25:55', 0);
INSERT INTO accounts_opportunities VALUES ('e7349e1f-6b0c-4619-5480-438dfba0ee33', 'e465492a-3cd8-0876-6dbd-438dfbfdb3a7', 'd97458bd-138c-6ccd-14c1-438dfb875b17', '2005-11-30 19:25:55', 0);
INSERT INTO accounts_opportunities VALUES ('ed4f63e1-bc77-fa07-02c7-438dfbf4c1ba', 'ea7762b3-9ff2-b92a-f893-438dfbdb59b1', 'd97458bd-138c-6ccd-14c1-438dfb875b17', '2005-11-30 19:25:56', 0);
INSERT INTO accounts_opportunities VALUES ('f18127fa-dbf4-88f4-aed6-438dfb9675b3', 'eeb0c6bd-6a41-db5a-4bcc-438dfbaded44', 'd97458bd-138c-6ccd-14c1-438dfb875b17', '2005-11-30 19:25:56', 0);
INSERT INTO accounts_opportunities VALUES ('11f86eb2-3bbf-2dd6-d017-438dfb94cedc', 'f1980f58-2e7b-adf5-3d7c-438dfbbd3ab5', 'cdb7018f-2af9-c5c5-bc5a-438dfbeabc25', '2005-11-30 19:25:56', 0);
INSERT INTO accounts_opportunities VALUES ('182713bf-36ac-7175-a5f8-438dfb8727e6', '1549a691-552a-cdea-f303-438dfbabdbab', 'cdb7018f-2af9-c5c5-bc5a-438dfbeabc25', '2005-11-30 19:25:56', 0);
INSERT INTO accounts_opportunities VALUES ('1c71c973-9a83-24b8-2d7d-438dfbb969c0', '198763e2-7cdb-79a7-4a65-438dfb0e0e86', 'cdb7018f-2af9-c5c5-bc5a-438dfbeabc25', '2005-11-30 19:25:57', 0);
INSERT INTO accounts_opportunities VALUES ('20a5e636-97af-59d4-f119-438dfbc05acb', '1dcd3d3e-b194-2799-ca85-438dfbd88573', 'cdb7018f-2af9-c5c5-bc5a-438dfbeabc25', '2005-11-30 19:25:57', 0);
INSERT INTO accounts_opportunities VALUES ('24d9bad4-7ba3-1bfe-24e6-438dfbc02e07', '220c1338-b2ce-d6ed-b9e5-438dfbde21d0', 'cdb7018f-2af9-c5c5-bc5a-438dfbeabc25', '2005-11-30 19:25:57', 0);
INSERT INTO accounts_opportunities VALUES ('39d84beb-7d16-ddd6-31e5-438dfb1473ef', '36f65839-26cd-6c11-5d87-438dfb3f16f1', '34b7fcff-4ff6-4547-cc7f-438dfb271457', '2005-11-30 19:25:58', 0);
INSERT INTO accounts_opportunities VALUES ('3e112c96-812e-6e5b-d3c9-438dfb3af9e2', '3b3824e4-b0bc-fb7b-5111-438dfb14352d', '34b7fcff-4ff6-4547-cc7f-438dfb271457', '2005-11-30 19:25:58', 0);
INSERT INTO accounts_opportunities VALUES ('463c8c61-af60-de6f-6391-438dfb9be5c7', '43624796-556a-8341-5905-438dfb0d2057', '34b7fcff-4ff6-4547-cc7f-438dfb271457', '2005-11-30 19:25:58', 0);
INSERT INTO accounts_opportunities VALUES ('4a75c041-55e0-cbc2-6ff5-438dfb687185', '479aefe0-35b1-bb42-40b9-438dfb5de14b', '34b7fcff-4ff6-4547-cc7f-438dfb271457', '2005-11-30 19:25:58', 0);
INSERT INTO accounts_opportunities VALUES ('4ec1674b-6b8b-cd34-d3c1-438dfb199765', '4bcc2ee0-b174-4bfe-9c40-438dfbfdb84b', '34b7fcff-4ff6-4547-cc7f-438dfb271457', '2005-11-30 19:25:58', 0);
INSERT INTO accounts_opportunities VALUES ('6771bb3e-9350-7cd5-0c3a-438dfb687584', '648a5b9a-500d-d0f1-a05d-438dfbfe1902', '6243d450-6220-61bb-adf6-438dfb62abb7', '2005-11-30 19:25:59', 0);
INSERT INTO accounts_opportunities VALUES ('6bb28f31-1ce5-ed57-8673-438dfb80e74f', '68d7f029-9899-df09-8671-438dfbe04ab9', '6243d450-6220-61bb-adf6-438dfb62abb7', '2005-11-30 19:25:59', 0);
INSERT INTO accounts_opportunities VALUES ('6feaf249-9d31-9e30-0e20-438dfbe893ff', '6d12fa33-68c1-b707-7d7c-438dfbbaef62', '6243d450-6220-61bb-adf6-438dfb62abb7', '2005-11-30 19:25:59', 0);
INSERT INTO accounts_opportunities VALUES ('742a47b4-4a7c-384e-cf03-438dfb2f5785', '7148a36a-1f0f-3c93-4a7f-438dfb375092', '6243d450-6220-61bb-adf6-438dfb62abb7', '2005-11-30 19:26:00', 0);
INSERT INTO accounts_opportunities VALUES ('78511437-9982-eaac-6652-438dfb1675c1', '75849dbf-60e1-d76e-b467-438dfb1fb08a', '6243d450-6220-61bb-adf6-438dfb62abb7', '2005-11-30 19:26:00', 0);
INSERT INTO accounts_opportunities VALUES ('91181b6f-8c03-49a6-8f6c-438dfb8c0ac2', '8e44ded2-6b64-dc96-9624-438dfba492df', '8bfc78c0-4447-55f8-cdcf-438dfb161815', '2005-11-30 19:26:00', 0);
INSERT INTO accounts_opportunities VALUES ('955f2413-7fd7-8da6-1cbf-438dfb1140ea', '927f7011-d601-aeb2-7956-438dfb216ef0', '8bfc78c0-4447-55f8-cdcf-438dfb161815', '2005-11-30 19:26:00', 0);
INSERT INTO accounts_opportunities VALUES ('99ab262f-b19f-546c-d1ea-438dfbcbc70c', '96c9a3eb-8eeb-168a-b28a-438dfbfb4fdb', '8bfc78c0-4447-55f8-cdcf-438dfb161815', '2005-11-30 19:26:00', 0);
INSERT INTO accounts_opportunities VALUES ('a015f352-bf89-7997-c7ad-438dfb1eda4c', '9d3804ce-a135-8eab-7a00-438dfb6dc654', '8bfc78c0-4447-55f8-cdcf-438dfb161815', '2005-11-30 19:26:01', 0);
INSERT INTO accounts_opportunities VALUES ('a44b65c7-17f3-5ba9-616c-438dfb430400', 'a1764531-eff9-9d07-5c06-438dfb7d59a6', '8bfc78c0-4447-55f8-cdcf-438dfb161815', '2005-11-30 19:26:01', 0);
INSERT INTO accounts_opportunities VALUES ('b8c249df-c120-0bf7-6c28-438dfb1802e9', 'b5e9149e-ba55-ca06-0264-438dfbceef3d', 'b3a58eda-3bc0-5d5d-8ca5-438dfbaadf87', '2005-11-30 19:26:01', 0);
INSERT INTO accounts_opportunities VALUES ('bf40b5d9-3080-1b3a-87c1-438dfba0ef63', 'bc632025-35b3-e07d-0ec9-438dfb32792d', 'b3a58eda-3bc0-5d5d-8ca5-438dfbaadf87', '2005-11-30 19:26:01', 0);
INSERT INTO accounts_opportunities VALUES ('c373984f-512a-e049-6ec9-438dfb43c8bd', 'c0a3af25-ddc5-6a37-1325-438dfb3f6cd4', 'b3a58eda-3bc0-5d5d-8ca5-438dfbaadf87', '2005-11-30 19:26:02', 0);
INSERT INTO accounts_opportunities VALUES ('c9eb6e0c-1227-b571-f22c-438dfbebd1e4', 'c70ca6a6-9f43-3095-28c4-438dfb08766c', 'b3a58eda-3bc0-5d5d-8ca5-438dfbaadf87', '2005-11-30 19:26:02', 0);
INSERT INTO accounts_opportunities VALUES ('ce1f407a-ef9f-c279-911f-438dfb8ac270', 'cb48d701-a3f4-e14d-d2eb-438dfb29e6d8', 'b3a58eda-3bc0-5d5d-8ca5-438dfbaadf87', '2005-11-30 19:26:02', 0);
INSERT INTO accounts_opportunities VALUES ('e2b3a076-fc15-12f8-ed47-438dfbe56934', 'dfd0e02d-d1bb-0692-16c8-438dfb1ac895', 'dd8ee07f-61bd-30be-d935-438dfb426550', '2005-11-30 19:26:02', 0);
INSERT INTO accounts_opportunities VALUES ('e6ed0028-2bed-0a92-2141-438dfba0825a', 'e41346f9-accd-9142-b5c7-438dfbdc3c4d', 'dd8ee07f-61bd-30be-d935-438dfb426550', '2005-11-30 19:26:03', 0);
INSERT INTO accounts_opportunities VALUES ('ed7b3510-2a83-54af-2755-438dfbb0ac6d', 'ea9513bd-12d2-0ecb-7509-438dfb02acdf', 'dd8ee07f-61bd-30be-d935-438dfb426550', '2005-11-30 19:26:03', 0);
INSERT INTO accounts_opportunities VALUES ('f1c335ae-a3aa-95c0-e2db-438dfb8ca16b', 'eedd8777-5919-1dc9-5023-438dfb40fd56', 'dd8ee07f-61bd-30be-d935-438dfb426550', '2005-11-30 19:26:03', 0);
INSERT INTO accounts_opportunities VALUES ('1cf1020f-1000-e598-f024-438dfb74c97d', 'f31d9a70-20c2-ec69-9289-438dfbbaec22', 'dd8ee07f-61bd-30be-d935-438dfb426550', '2005-11-30 19:26:04', 0);
INSERT INTO accounts_opportunities VALUES ('166220a6-38cd-e328-657d-438dfb40ba46', '138b67c6-2fcf-6902-c9be-438dfb1557cb', '114ec48e-57e4-c5c2-6507-438dfb9ef25b', '2005-11-30 19:26:04', 0);
INSERT INTO accounts_opportunities VALUES ('1aa3a9db-328e-ab94-43cb-438dfb30efac', '17c6873b-172f-dd2e-7419-438dfb148870', '114ec48e-57e4-c5c2-6507-438dfb9ef25b', '2005-11-30 19:26:04', 0);
INSERT INTO accounts_opportunities VALUES ('1efd2b20-3914-78cd-4f0b-438dfb760ce4', '1c058d66-041f-190e-7ff7-438dfb2e459a', '114ec48e-57e4-c5c2-6507-438dfb9ef25b', '2005-11-30 19:26:04', 0);
INSERT INTO accounts_opportunities VALUES ('25877ac2-29fa-455f-4ab0-438dfbc1d4a6', '22b806a6-826d-a16b-a9db-438dfbe314d4', '114ec48e-57e4-c5c2-6507-438dfb9ef25b', '2005-11-30 19:26:05', 0);
INSERT INTO accounts_opportunities VALUES ('29c0aa04-eca2-5b36-16e9-438dfb6fee4a', '26e5325b-7150-d7b4-ecaa-438dfb8a9f18', '114ec48e-57e4-c5c2-6507-438dfb9ef25b', '2005-11-30 19:26:05', 0);
INSERT INTO accounts_opportunities VALUES ('3ea04152-69f1-8140-bf03-438dfb12179c', '3bc4d899-6b6c-20ce-65ba-438dfbc9123a', '3981b1f2-08e7-abb6-7b8e-438dfb4658ac', '2005-11-30 19:26:06', 0);
INSERT INTO accounts_opportunities VALUES ('44ccce57-4427-899c-f4de-438dfbeb0cb8', '3fff1283-9ada-f40b-ccf4-438dfb6c00ca', '3981b1f2-08e7-abb6-7b8e-438dfb4658ac', '2005-11-30 19:26:06', 0);
INSERT INTO accounts_opportunities VALUES ('4b636d98-e6ce-5ff7-f3b0-438dfb82d287', '48946fc8-bea8-4844-2e3a-438dfbcb06da', '3981b1f2-08e7-abb6-7b8e-438dfb4658ac', '2005-11-30 19:26:06', 0);
INSERT INTO accounts_opportunities VALUES ('4faebdf7-eab0-6f96-0a16-438dfb91309f', '4cc270c6-b08f-0a37-f2a3-438dfb68f941', '3981b1f2-08e7-abb6-7b8e-438dfb4658ac', '2005-11-30 19:26:06', 0);
INSERT INTO accounts_opportunities VALUES ('53e746c0-81b7-5544-8854-438dfbcdc490', '5108938c-a44c-0170-dcc4-438dfb18ef50', '3981b1f2-08e7-abb6-7b8e-438dfb4658ac', '2005-11-30 19:26:07', 0);
INSERT INTO accounts_opportunities VALUES ('68a41d3c-0bc4-6890-b41e-438dfb12ba5a', '65c59776-6f0e-0023-6526-438dfbcee8bd', '63857cd3-6d3f-f409-fc9e-438dfb3001c1', '2005-11-30 19:26:07', 0);
INSERT INTO accounts_opportunities VALUES ('71d8007d-a0a1-44fe-d95c-438dfbacb631', '6ef57273-9063-a7b1-b1a1-438dfbbdbc76', '63857cd3-6d3f-f409-fc9e-438dfb3001c1', '2005-11-30 19:26:07', 0);
INSERT INTO accounts_opportunities VALUES ('760ffa23-dc48-e1b2-61f6-438dfb98344d', '7338101b-8930-639b-e563-438dfbaf2a77', '63857cd3-6d3f-f409-fc9e-438dfb3001c1', '2005-11-30 19:26:07', 0);
INSERT INTO accounts_opportunities VALUES ('7a482f0b-0da2-159f-5857-438dfb9e9f38', '7776bf7d-ce3f-e731-6727-438dfbe979b0', '63857cd3-6d3f-f409-fc9e-438dfb3001c1', '2005-11-30 19:26:08', 0);
INSERT INTO accounts_opportunities VALUES ('7e729eef-4374-1dbe-895d-438dfbd69b8c', '7ba2e8d3-e6e6-70dd-a8bd-438dfbf2157b', '63857cd3-6d3f-f409-fc9e-438dfb3001c1', '2005-11-30 19:26:08', 0);
INSERT INTO accounts_opportunities VALUES ('957b3aec-1bc4-6bd1-dfb7-438dfb84e6e7', '92a414f1-6df6-fdd0-6a35-438dfb91e7ad', '9052e8c4-579b-4c67-d96e-438dfbe34bfd', '2005-11-30 19:26:08', 0);
INSERT INTO accounts_opportunities VALUES ('9c4ee12e-9d23-1035-0164-438dfbf88469', '99737554-0226-24ed-10ae-438dfb09a671', '9052e8c4-579b-4c67-d96e-438dfbe34bfd', '2005-11-30 19:26:08', 0);
INSERT INTO accounts_opportunities VALUES ('a07dd3a0-05a4-4d80-aea3-438dfbec0ba2', '9da9b5a9-d23c-8fd9-21e6-438dfb8f403c', '9052e8c4-579b-4c67-d96e-438dfbe34bfd', '2005-11-30 19:26:09', 0);
INSERT INTO accounts_opportunities VALUES ('a4b88a00-0ce6-bce8-5494-438dfbad0a31', 'a1dd9efa-b631-55cb-9455-438dfb758ade', '9052e8c4-579b-4c67-d96e-438dfbe34bfd', '2005-11-30 19:26:09', 0);
INSERT INTO accounts_opportunities VALUES ('a8e47fab-0c6f-afa2-944a-438dfbf3b7e8', 'a6179811-5864-a8e8-b466-438dfbbe0133', '9052e8c4-579b-4c67-d96e-438dfbe34bfd', '2005-11-30 19:26:09', 0);
INSERT INTO accounts_opportunities VALUES ('bd737126-70f3-7152-2a76-438dfbf4083f', 'ba9269c5-1b41-71a4-42cb-438dfb105587', 'b852c1cb-196b-7ad1-9184-438dfbc4807b', '2005-11-30 19:26:09', 0);
INSERT INTO accounts_opportunities VALUES ('c1abe493-6ede-3277-6573-438dfb4ab113', 'bed54272-3cbe-21b2-b8ef-438dfb12e9bf', 'b852c1cb-196b-7ad1-9184-438dfbc4807b', '2005-11-30 19:26:10', 0);
INSERT INTO accounts_opportunities VALUES ('c5e711dc-1e66-92b4-163a-438dfb03f7f0', 'c30fb283-ae44-707c-94ec-438dfbe1c874', 'b852c1cb-196b-7ad1-9184-438dfbc4807b', '2005-11-30 19:26:10', 0);
INSERT INTO accounts_opportunities VALUES ('ccccae38-5f45-3846-1b9f-438dfba026b0', 'c9f898b3-2c0b-1eec-5b8f-438dfb74ada1', 'b852c1cb-196b-7ad1-9184-438dfbc4807b', '2005-11-30 19:26:10', 0);
INSERT INTO accounts_opportunities VALUES ('d10250ba-b3b0-62d1-ce4a-438dfb0dad5c', 'ce27327f-7727-1155-dc29-438dfb6fed15', 'b852c1cb-196b-7ad1-9184-438dfbc4807b', '2005-11-30 19:26:10', 0);
INSERT INTO accounts_opportunities VALUES ('e603b672-f546-0760-155b-438dfb230025', 'e321b55f-22b2-a16c-c76f-438dfb49bc79', 'e0deb83a-33bc-8a70-50a3-438dfbf1a6a6', '2005-11-30 19:26:11', 0);
INSERT INTO accounts_opportunities VALUES ('ea3bfa6b-ca64-7493-a3bd-438dfb34584d', 'e767f4f6-6895-f5a1-9b9a-438dfbeeb5ea', 'e0deb83a-33bc-8a70-50a3-438dfbf1a6a6', '2005-11-30 19:26:11', 0);
INSERT INTO accounts_opportunities VALUES ('ee777812-073c-d4b1-b138-438dfb31155d', 'eb97f66f-ddfe-86be-f1d0-438dfb1d6304', 'e0deb83a-33bc-8a70-50a3-438dfbf1a6a6', '2005-11-30 19:26:11', 0);
INSERT INTO accounts_opportunities VALUES ('f2a481d3-c68f-e629-66e6-438dfba68ebe', 'efd260a7-27a7-9518-23d2-438dfb19241d', 'e0deb83a-33bc-8a70-50a3-438dfbf1a6a6', '2005-11-30 19:26:11', 0);
INSERT INTO accounts_opportunities VALUES ('2aa001b0-b27b-ecb0-3597-438dfb0e4d17', 'f404c25e-9fb8-c46f-8402-438dfb62e718', 'e0deb83a-33bc-8a70-50a3-438dfbf1a6a6', '2005-11-30 19:26:12', 0);
INSERT INTO accounts_opportunities VALUES ('1736a9fa-b681-c3a9-c2e4-438dfb3b1637', '145e56f8-194d-2e86-9d30-438dfb5e8820', '12198b06-7362-bee7-e01a-438dfbd300d2', '2005-11-30 19:26:12', 0);
INSERT INTO accounts_opportunities VALUES ('20eec280-f9d3-1be2-28e4-438dfb85b326', '1e17e14d-3bf4-855b-6fa6-438dfb31f869', '12198b06-7362-bee7-e01a-438dfbd300d2', '2005-11-30 19:26:12', 0);
INSERT INTO accounts_opportunities VALUES ('252b9df5-4854-03ca-cde7-438dfbe87ea0', '2259d789-eb74-fe8d-59be-438dfb63a27a', '12198b06-7362-bee7-e01a-438dfbd300d2', '2005-11-30 19:26:13', 0);
INSERT INTO accounts_opportunities VALUES ('2974401c-8cd9-b725-6f34-438dfb77c756', '269aba10-cea9-739d-e09a-438dfb4804a4', '12198b06-7362-bee7-e01a-438dfbd300d2', '2005-11-30 19:26:13', 0);
INSERT INTO accounts_opportunities VALUES ('2dd2cc8c-6aef-67b3-c91d-438dfb4a409c', '2acf6702-74a9-e92c-032e-438dfbb3b016', '12198b06-7362-bee7-e01a-438dfbd300d2', '2005-11-30 19:26:13', 0);
INSERT INTO accounts_opportunities VALUES ('4453e419-f81c-fddc-d4ce-438dfb0255b6', '3f8037fd-6014-2a4c-8d92-438dfb15a0c8', '3d3f5fec-1a99-37c2-6014-438dfbb1a5c1', '2005-11-30 19:26:13', 0);
INSERT INTO accounts_opportunities VALUES ('48a24166-1c55-0546-9e9d-438dfb801ea4', '45d08410-5100-013c-afd4-438dfbee1789', '3d3f5fec-1a99-37c2-6014-438dfbb1a5c1', '2005-11-30 19:26:14', 0);
INSERT INTO accounts_opportunities VALUES ('4cda31b5-4355-9506-e433-438dfbbf4a41', '4a02eaf3-b88f-9e86-a205-438dfb9e45df', '3d3f5fec-1a99-37c2-6014-438dfbb1a5c1', '2005-11-30 19:26:14', 0);
INSERT INTO accounts_opportunities VALUES ('513e85e9-cbf9-7f44-8841-438dfbddba1f', '4e75cec5-6f0b-9037-2f89-438dfbc0d11c', '3d3f5fec-1a99-37c2-6014-438dfbb1a5c1', '2005-11-30 19:26:14', 0);
INSERT INTO accounts_opportunities VALUES ('5575bfc0-427f-750a-d7f2-438dfb8fe494', '52a99bce-97a5-1650-e6c9-438dfb5652f8', '3d3f5fec-1a99-37c2-6014-438dfbb1a5c1', '2005-11-30 19:26:14', 0);
INSERT INTO accounts_opportunities VALUES ('6a0c7391-24ba-1a9a-a641-438dfb73ff82', '672ee45a-bcaa-4ae6-5318-438dfb376d8a', '64ec2f2b-40b0-800b-58d6-438dfb65cc42', '2005-11-30 19:26:15', 0);
INSERT INTO accounts_opportunities VALUES ('6e4f53b6-1edc-622b-45c9-438dfb53db28', '6b7a6917-31d9-23a6-9c68-438dfbe35ce3', '64ec2f2b-40b0-800b-58d6-438dfb65cc42', '2005-11-30 19:26:15', 0);
INSERT INTO accounts_opportunities VALUES ('728c3c9b-e805-8c4c-032f-438dfbb1efb2', '6fafb8d9-0a6c-4f4c-fb4f-438dfbbb193f', '64ec2f2b-40b0-800b-58d6-438dfb65cc42', '2005-11-30 19:26:15', 0);
INSERT INTO accounts_opportunities VALUES ('7f6431e4-ef26-9cfd-b75b-438dfbf0691b', '7c8a0229-1eec-ed8f-9d8b-438dfbab6fd6', '64ec2f2b-40b0-800b-58d6-438dfb65cc42', '2005-11-30 19:26:15', 0);
INSERT INTO accounts_opportunities VALUES ('8394fbd0-fec4-0b4f-f04a-438dfb6f5b3a', '80c4e38b-7df3-854d-177b-438dfb870a45', '64ec2f2b-40b0-800b-58d6-438dfb65cc42', '2005-11-30 19:26:16', 0);
INSERT INTO accounts_opportunities VALUES ('981de170-6b87-2954-75bd-438dfb8b7917', '9537ffce-aa3c-9a37-3873-438dfbfdc640', '92f1a02c-7979-d266-3394-438dfbc063ae', '2005-11-30 19:26:16', 0);
INSERT INTO accounts_opportunities VALUES ('9c5a1fe8-b439-4983-3f4a-438dfba417b9', '997b8264-a127-8889-63b9-438dfba0b2ca', '92f1a02c-7979-d266-3394-438dfbc063ae', '2005-11-30 19:26:16', 0);
INSERT INTO accounts_opportunities VALUES ('a3827a5c-c23d-ae0a-b003-438dfbbbb70a', 'a0ab9849-4fd6-59e9-8fc1-438dfb6043e7', '92f1a02c-7979-d266-3394-438dfbc063ae', '2005-11-30 19:26:17', 0);
INSERT INTO accounts_opportunities VALUES ('a7c3c45c-efa2-5487-9a9d-438dfb2e4d60', 'a4eac9ea-c622-327d-1d92-438dfb422d8f', '92f1a02c-7979-d266-3394-438dfbc063ae', '2005-11-30 19:26:17', 0);
INSERT INTO accounts_opportunities VALUES ('abef9434-9f2d-03b7-c49b-438dfb152f6b', 'a924370d-995f-d287-8c01-438dfb5de9aa', '92f1a02c-7979-d266-3394-438dfbc063ae', '2005-11-30 19:26:17', 0);
INSERT INTO accounts_opportunities VALUES ('c38a365f-1ad3-c958-5fbb-438dfb0c9e66', 'c0b09e04-72ed-437d-75e3-438dfbb6506f', 'be69c39d-736a-d99a-4197-438dfb894cfb', '2005-11-30 19:26:18', 0);
INSERT INTO accounts_opportunities VALUES ('c7c5f934-b47c-5753-9d66-438dfb5ec058', 'c4e89875-31e6-c362-4822-438dfb0f8aa3', 'be69c39d-736a-d99a-4197-438dfb894cfb', '2005-11-30 19:26:18', 0);
INSERT INTO accounts_opportunities VALUES ('cf09ac3f-7da4-c0d9-0d9d-438dfb74a03e', 'cc2f18f3-a69a-8bdf-3946-438dfb0571f5', 'be69c39d-736a-d99a-4197-438dfb894cfb', '2005-11-30 19:26:18', 0);
INSERT INTO accounts_opportunities VALUES ('d32f982a-1ad5-2dbb-d6e1-438dfb6af9c1', 'd065ae81-0201-bf87-5826-438dfbecb4f0', 'be69c39d-736a-d99a-4197-438dfb894cfb', '2005-11-30 19:26:19', 0);
INSERT INTO accounts_opportunities VALUES ('d766a286-35e4-570b-ea48-438dfb90d788', 'd49a88d9-7337-c06f-d731-438dfbc58749', 'be69c39d-736a-d99a-4197-438dfb894cfb', '2005-11-30 19:26:19', 0);
INSERT INTO accounts_opportunities VALUES ('ebdbd4d0-f630-6179-b6cf-438dfb5aaf18', 'e9030076-26ed-8a56-d9a4-438dfbd692ea', 'e6c97f92-50da-b9e5-7b28-438dfb52a851', '2005-11-30 19:26:19', 0);
INSERT INTO accounts_opportunities VALUES ('f3399798-1a87-bd1f-463d-438dfb9c31ea', 'f067bd7b-5a1f-592f-879d-438dfb1f6c03', 'e6c97f92-50da-b9e5-7b28-438dfb52a851', '2005-11-30 19:26:19', 0);
INSERT INTO accounts_opportunities VALUES ('35a304c8-046f-7ae0-5b14-438dfb0c2ec2', '747008c1-b6b6-5854-48e5-438dfbe84dab', 'e6c97f92-50da-b9e5-7b28-438dfb52a851', '2005-11-30 19:26:20', 0);
INSERT INTO accounts_opportunities VALUES ('abf60e10-6804-3f01-7c49-438dfbdf9b49', '7e4c096e-9627-5e9b-2bfd-438dfbf3f1f1', 'e6c97f92-50da-b9e5-7b28-438dfb52a851', '2005-11-30 19:26:20', 0);
INSERT INTO accounts_opportunities VALUES ('eeea0f84-220d-a701-fb51-438dfbe4bf90', 'c1f90645-bb02-bc53-d656-438dfb9dad85', 'e6c97f92-50da-b9e5-7b28-438dfb52a851', '2005-11-30 19:26:20', 0);
INSERT INTO accounts_opportunities VALUES ('2371f2d7-26b9-7928-201b-438dfb899c8c', '2090aeff-2f15-5984-c619-438dfbe24e3d', '1e493e94-354d-d36a-f996-438dfb1616f5', '2005-11-30 19:26:20', 0);
INSERT INTO accounts_opportunities VALUES ('27a760a2-d034-fcaf-86f7-438dfbcafbd4', '24d83f95-61fe-e899-5e17-438dfb6ac2ba', '1e493e94-354d-d36a-f996-438dfb1616f5', '2005-11-30 19:26:21', 0);
INSERT INTO accounts_opportunities VALUES ('2f474c31-c65d-9d7c-c4ce-438dfb60c3a8', '2c55c9ff-7937-7f67-da4a-438dfbb073a2', '1e493e94-354d-d36a-f996-438dfb1616f5', '2005-11-30 19:26:21', 0);
INSERT INTO accounts_opportunities VALUES ('3382a95c-16e4-e301-6ba5-438dfba54860', '30acb910-af66-5802-4e3e-438dfb7ee64f', '1e493e94-354d-d36a-f996-438dfb1616f5', '2005-11-30 19:26:22', 0);
INSERT INTO accounts_opportunities VALUES ('37b3d139-552f-991b-ba4b-438dfb0ec481', '34ddd3fc-d036-5a63-4cc7-438dfb9d266a', '1e493e94-354d-d36a-f996-438dfb1616f5', '2005-11-30 19:26:22', 0);
INSERT INTO accounts_opportunities VALUES ('4e438de0-5253-8cf0-4b55-438dfbda4223', '4b5905c0-390a-7b1d-7c24-438dfb3c1d15', '491c4d19-fbdd-d1dd-89a2-438dfb782d21', '2005-11-30 19:26:22', 0);
INSERT INTO accounts_opportunities VALUES ('528ac011-867b-5576-ea14-438dfbc79fa6', '4fad1fa3-bc32-1f2d-b8ed-438dfb8fe483', '491c4d19-fbdd-d1dd-89a2-438dfb782d21', '2005-11-30 19:26:22', 0);
INSERT INTO accounts_opportunities VALUES ('56cbe304-b442-434e-d6c1-438dfb425458', '53fe5561-9501-6f33-e689-438dfb6d680e', '491c4d19-fbdd-d1dd-89a2-438dfb782d21', '2005-11-30 19:26:23', 0);
INSERT INTO accounts_opportunities VALUES ('5b00fa26-5347-2b5f-ae22-438dfba0b410', '58287758-19b5-9329-2af3-438dfb843f8f', '491c4d19-fbdd-d1dd-89a2-438dfb782d21', '2005-11-30 19:26:23', 0);
INSERT INTO accounts_opportunities VALUES ('65c564ab-cc94-1db2-e2b3-438dfbc3075c', '62e9291f-23e4-617f-b651-438dfbe6c867', '491c4d19-fbdd-d1dd-89a2-438dfb782d21', '2005-11-30 19:26:23', 0);
INSERT INTO accounts_opportunities VALUES ('7b19d2f0-a004-e66c-d2d4-438dfb6a7e3d', '78427c6a-2b21-ea78-6e3e-438dfbf53b9b', '75f3c5be-eb04-4dcb-14ce-438dfb5a878c', '2005-11-30 19:26:23', 0);
INSERT INTO accounts_opportunities VALUES ('7f688552-c372-c7d9-75cd-438dfb6a13d8', '7c809971-e891-1a53-66f3-438dfb244d0c', '75f3c5be-eb04-4dcb-14ce-438dfb5a878c', '2005-11-30 19:26:24', 0);
INSERT INTO accounts_opportunities VALUES ('839d219e-b6fa-38e6-3926-438dfb35b30d', '80c4ea7f-9484-9a04-0401-438dfb068ed3', '75f3c5be-eb04-4dcb-14ce-438dfb5a878c', '2005-11-30 19:26:24', 0);
INSERT INTO accounts_opportunities VALUES ('87ce15e6-7db9-3579-5a3b-438dfbb299f8', '84fd7069-b660-3552-22dc-438dfb7b6397', '75f3c5be-eb04-4dcb-14ce-438dfb5a878c', '2005-11-30 19:26:25', 0);
INSERT INTO accounts_opportunities VALUES ('8c0f4c82-80a6-436c-79f5-438dfb35b741', '89315cc5-c6db-a2c5-f193-438dfbf721b8', '75f3c5be-eb04-4dcb-14ce-438dfb5a878c', '2005-11-30 19:26:25', 0);
INSERT INTO accounts_opportunities VALUES ('a09adfbf-7f3a-cac2-aef6-438dfb6ea708', '9dbbaa9a-54f6-0a4a-fdcf-438dfb009d7e', '9b726ecd-688f-c61a-a444-438dfb218fd1', '2005-11-30 19:26:25', 0);
INSERT INTO accounts_opportunities VALUES ('a4dfe5d7-436c-355c-2c7b-438dfb0f0d62', 'a2060126-e28c-61f1-cc84-438dfb008f39', '9b726ecd-688f-c61a-a444-438dfb218fd1', '2005-11-30 19:26:25', 0);
INSERT INTO accounts_opportunities VALUES ('aff0c5ea-ddcc-9e59-d4ce-438dfb2af66b', 'aceeea8f-eb15-ce3b-9bb0-438dfbe0208f', '9b726ecd-688f-c61a-a444-438dfb218fd1', '2005-11-30 19:26:26', 0);
INSERT INTO accounts_opportunities VALUES ('b450afcb-5bab-00fe-a067-438dfb52a038', 'b15742bf-2599-8843-c5f0-438dfb0effbb', '9b726ecd-688f-c61a-a444-438dfb218fd1', '2005-11-30 19:26:26', 0);
INSERT INTO accounts_opportunities VALUES ('b8db95dc-d820-a57a-c1da-438dfbd99b19', 'b5bbf9a4-a512-f7da-d7a7-438dfb7b1000', '9b726ecd-688f-c61a-a444-438dfb218fd1', '2005-11-30 19:26:26', 0);
INSERT INTO accounts_opportunities VALUES ('cdfe31e8-5bf4-afaf-9d8e-438dfb2ec02d', 'caff3ffb-d27d-a3c7-c8bd-438dfbf415f1', 'c8bc538e-0714-e8c1-94bb-438dfb137c7a', '2005-11-30 19:26:26', 0);
INSERT INTO accounts_opportunities VALUES ('d5dc7dbd-c275-ca19-76b9-438dfba1fcd3', 'd2da8520-053a-bd3f-7d35-438dfb9798b0', 'c8bc538e-0714-e8c1-94bb-438dfb137c7a', '2005-11-30 19:26:27', 0);
INSERT INTO accounts_opportunities VALUES ('da419d70-c7a6-342f-ea83-438dfb55d472', 'd74bd47c-48b9-b13e-78a9-438dfb6f28f3', 'c8bc538e-0714-e8c1-94bb-438dfb137c7a', '2005-11-30 19:26:27', 0);
INSERT INTO accounts_opportunities VALUES ('de9ae30e-4f3b-b7ad-27cd-438dfbd66f16', 'dbafe273-60b3-af7c-caf1-438dfb7077db', 'c8bc538e-0714-e8c1-94bb-438dfb137c7a', '2005-11-30 19:26:27', 0);
INSERT INTO accounts_opportunities VALUES ('e2f4ac4d-6a06-2998-2573-438dfbc52676', 'e0031819-e462-c087-0a13-438dfb5ba396', 'c8bc538e-0714-e8c1-94bb-438dfb137c7a', '2005-11-30 19:26:27', 0);
INSERT INTO accounts_opportunities VALUES ('ade708d4-8a8a-99e5-7116-438dfb92e4fe', '7e990dfa-e363-975f-ef25-438dfbc89aac', '59fb0e8f-dc34-a05a-0f81-438dfba3c7a8', '2005-11-30 19:26:28', 0);
INSERT INTO accounts_opportunities VALUES ('f3b50dbf-7eee-a893-7518-438dfb2ff259', 'c4bb047a-f701-d286-c01c-438dfb5d0139', '59fb0e8f-dc34-a05a-0f81-438dfba3c7a8', '2005-11-30 19:26:28', 0);
INSERT INTO accounts_opportunities VALUES ('13b36aff-f90f-41e3-dca5-438dfb596e76', '10b07eb7-ae4d-c5e3-eda2-438dfb20a1ea', '59fb0e8f-dc34-a05a-0f81-438dfba3c7a8', '2005-11-30 19:26:28', 0);
INSERT INTO accounts_opportunities VALUES ('1f2056a2-4b4c-030a-c9e8-438dfb7559f5', '1c10ab57-c4af-fe70-9f0d-438dfb3c909a', '59fb0e8f-dc34-a05a-0f81-438dfba3c7a8', '2005-11-30 19:26:29', 0);
INSERT INTO accounts_opportunities VALUES ('237e5f1c-d196-c0e6-5aac-438dfb1f3e23', '20902312-4c33-be73-da10-438dfb73c88f', '59fb0e8f-dc34-a05a-0f81-438dfba3c7a8', '2005-11-30 19:26:29', 0);
INSERT INTO accounts_opportunities VALUES ('38e2e4c6-738f-560f-fe94-438dfbf1c3a1', '35d75c87-cad9-2879-d6df-438dfbd4c06e', '3389b370-a721-0e58-e2b2-438dfbcbdd37', '2005-11-30 19:26:29', 0);
INSERT INTO accounts_opportunities VALUES ('3d2bb770-427d-dba9-1557-438dfb94ddb7', '3a47d83e-066a-2024-17db-438dfb647d4c', '3389b370-a721-0e58-e2b2-438dfbcbdd37', '2005-11-30 19:26:29', 0);
INSERT INTO accounts_opportunities VALUES ('41735353-3c93-3247-d246-438dfbe15754', '3e8991d6-5c5f-06f9-ad89-438dfbb539ed', '3389b370-a721-0e58-e2b2-438dfbcbdd37', '2005-11-30 19:26:30', 0);
INSERT INTO accounts_opportunities VALUES ('47b46dab-6fc0-24a0-9e6c-438dfb51525d', '44da1ef3-6ad4-c9f3-21fe-438dfbc505b7', '3389b370-a721-0e58-e2b2-438dfbcbdd37', '2005-11-30 19:26:30', 0);
INSERT INTO accounts_opportunities VALUES ('4be232cc-ee81-26b9-3cf4-438dfb438bae', '490ed671-1e92-2ef4-774b-438dfb6abfa5', '3389b370-a721-0e58-e2b2-438dfbcbdd37', '2005-11-30 19:26:30', 0);
INSERT INTO accounts_opportunities VALUES ('60d75e86-0381-dae9-05aa-438dfbeb9317', '5dc787e0-aaf6-a39a-17ce-438dfbcf5eae', '5b65bb26-ee94-0741-e6d7-438dfb27d784', '2005-11-30 19:26:31', 0);
INSERT INTO accounts_opportunities VALUES ('6551824e-edea-63da-13ca-438dfb79a41c', '624fadd3-ac8d-622c-e5fe-438dfb2bf65f', '5b65bb26-ee94-0741-e6d7-438dfb27d784', '2005-11-30 19:26:31', 0);
INSERT INTO accounts_opportunities VALUES ('6d420bdb-c262-5968-7dc6-438dfbb9f1bb', '6a658ebf-322b-8ce7-b93b-438dfb425893', '5b65bb26-ee94-0741-e6d7-438dfb27d784', '2005-11-30 19:26:31', 0);
INSERT INTO accounts_opportunities VALUES ('71726bae-8dde-d43f-6c93-438dfb9a9613', '6ea2612a-16ed-4fc3-14b2-438dfbb10c02', '5b65bb26-ee94-0741-e6d7-438dfb27d784', '2005-11-30 19:26:32', 0);
INSERT INTO accounts_opportunities VALUES ('75ab85dd-6bf0-ba06-d106-438dfb431db2', '72d12f00-c4bb-a061-b173-438dfb1c8cdd', '5b65bb26-ee94-0741-e6d7-438dfb27d784', '2005-11-30 19:26:32', 0);
INSERT INTO accounts_opportunities VALUES ('917e51ec-9099-5d1b-bac1-438dfb27e990', '8ea1985a-c2c9-8a1a-d31e-438dfb691d50', '8c5d0a27-943d-83f0-15a5-438dfba33bc3', '2005-11-30 19:26:32', 0);
INSERT INTO accounts_opportunities VALUES ('95b715f7-6371-1122-a3ab-438dfb4be26f', '92e4154d-2dc1-0323-dc42-438dfb8d2e00', '8c5d0a27-943d-83f0-15a5-438dfba33bc3', '2005-11-30 19:26:32', 0);
INSERT INTO accounts_opportunities VALUES ('9a00911a-1b88-5f40-a7a0-438dfb030b97', '971921ce-1dea-594f-033d-438dfbfe6e3a', '8c5d0a27-943d-83f0-15a5-438dfba33bc3', '2005-11-30 19:26:32', 0);
INSERT INTO accounts_opportunities VALUES ('9e404901-dd67-d97f-8806-438dfbc6406c', '9b64e5b2-f074-9153-2bba-438dfbb6c673', '8c5d0a27-943d-83f0-15a5-438dfba33bc3', '2005-11-30 19:26:33', 0);
INSERT INTO accounts_opportunities VALUES ('a9e986c7-c2f1-7740-507c-438dfb8ec67c', 'a7093417-d8b0-f099-cbcd-438dfb014e9e', '8c5d0a27-943d-83f0-15a5-438dfba33bc3', '2005-11-30 19:26:33', 0);
INSERT INTO accounts_opportunities VALUES ('be769281-98a4-bd1d-9686-438dfbb17281', 'bb949a9b-5a27-947d-b3cb-438dfb933ae4', 'b9492cd8-4a97-892c-c9c3-438dfb201fab', '2005-11-30 19:26:33', 0);
INSERT INTO accounts_opportunities VALUES ('c2bc3744-7658-16b0-742b-438dfb10942b', 'bfdffec6-a125-da5f-37f2-438dfba632d8', 'b9492cd8-4a97-892c-c9c3-438dfb201fab', '2005-11-30 19:26:33', 0);
INSERT INTO accounts_opportunities VALUES ('c70123ce-df36-2d8a-5411-438dfb0ffe82', 'c41a555b-82ca-cd1e-2641-438dfb9ccece', 'b9492cd8-4a97-892c-c9c3-438dfb201fab', '2005-11-30 19:26:34', 0);
INSERT INTO accounts_opportunities VALUES ('cb3ad4e6-232a-7092-f30c-438dfb31623d', 'c869ce0c-12ce-c2f8-a303-438dfbda262a', 'b9492cd8-4a97-892c-c9c3-438dfb201fab', '2005-11-30 19:26:34', 0);
INSERT INTO accounts_opportunities VALUES ('cf6a2a6a-57a6-4243-9bc9-438dfb4e8a25', 'cc96c3a8-eecd-cf4a-ada2-438dfb4108c3', 'b9492cd8-4a97-892c-c9c3-438dfb201fab', '2005-11-30 19:26:34', 0);
INSERT INTO accounts_opportunities VALUES ('e431dc71-fc15-4a36-76b2-438dfb645a11', 'e157c879-d6bd-d3a1-da04-438dfb675fb6', 'df0f0986-f65e-d456-1351-438dfb44de21', '2005-11-30 19:26:35', 0);
INSERT INTO accounts_opportunities VALUES ('e87bc4e0-54ee-e618-04bc-438dfb8edd5e', 'e5900282-b57d-9478-cceb-438dfb03cd05', 'df0f0986-f65e-d456-1351-438dfb44de21', '2005-11-30 19:26:35', 0);
INSERT INTO accounts_opportunities VALUES ('f08db021-bb3a-0a37-b443-438dfb72ec40', 'edb8d87e-ef34-3490-7bc0-438dfbbffe07', 'df0f0986-f65e-d456-1351-438dfb44de21', '2005-11-30 19:26:35', 0);
INSERT INTO accounts_opportunities VALUES ('97400d79-fcbf-5bff-535c-438dfbaab2ab', 'f1ec2145-de33-8642-6ad4-438dfb442b7a', 'df0f0986-f65e-d456-1351-438dfb44de21', '2005-11-30 19:26:35', 0);
INSERT INTO accounts_opportunities VALUES ('4cd50763-1965-05ec-ff9b-438dfb5f31e2', '1f420c23-09b9-baa7-362d-438dfbaef3c0', 'df0f0986-f65e-d456-1351-438dfb44de21', '2005-11-30 19:26:36', 0);
INSERT INTO accounts_opportunities VALUES ('1978f193-8849-3b90-695e-438dfb4ad982', '16983a31-f693-4ae8-1aeb-438dfb485805', '145df113-5365-45fa-ebe7-438dfbbd5844', '2005-11-30 19:26:36', 0);
INSERT INTO accounts_opportunities VALUES ('219f9a49-8f21-5977-2807-438dfb388785', '1eca74ba-f424-df5f-32ef-438dfbe0230d', '145df113-5365-45fa-ebe7-438dfbbd5844', '2005-11-30 19:26:36', 0);
INSERT INTO accounts_opportunities VALUES ('25dc8b01-469d-c75b-62c8-438dfb4e59bb', '230cc084-a4c8-b6b6-7da9-438dfb0340a4', '145df113-5365-45fa-ebe7-438dfbbd5844', '2005-11-30 19:26:37', 0);
INSERT INTO accounts_opportunities VALUES ('2a1aec26-19fd-e0b5-a458-438dfb5da782', '27392099-c1b1-23e7-98af-438dfb71a600', '145df113-5365-45fa-ebe7-438dfbbd5844', '2005-11-30 19:26:37', 0);
INSERT INTO accounts_opportunities VALUES ('2e69d0d6-e12c-e5ac-a366-438dfb4d8ac0', '2b746e10-b8ac-f115-1436-438dfbd666ea', '145df113-5365-45fa-ebe7-438dfbbd5844', '2005-11-30 19:26:37', 0);
INSERT INTO accounts_opportunities VALUES ('4d036d4f-f32c-f312-1d03-438dfba1ed3d', '4a30b038-3fc1-67f7-aa18-438dfb38fe3f', '47f16a6f-0237-ee14-c676-438dfb83235d', '2005-11-30 19:26:37', 0);
INSERT INTO accounts_opportunities VALUES ('555ea2a2-76bb-ac5f-0838-438dfb78f651', '52886ef8-3772-2acf-d8e9-438dfbcf4f4f', '47f16a6f-0237-ee14-c676-438dfb83235d', '2005-11-30 19:26:38', 0);
INSERT INTO accounts_opportunities VALUES ('5993b31d-687d-fac7-9202-438dfb6b78e6', '56c47419-e600-4016-d908-438dfba45565', '47f16a6f-0237-ee14-c676-438dfb83235d', '2005-11-30 19:26:38', 0);
INSERT INTO accounts_opportunities VALUES ('5dcfb6a6-ced4-a1d4-c8c8-438dfb2ac311', '5af7e03e-5d3f-3807-457d-438dfb878813', '47f16a6f-0237-ee14-c676-438dfb83235d', '2005-11-30 19:26:38', 0);
INSERT INTO accounts_opportunities VALUES ('6609c7ef-e6d2-1a20-897d-438dfb8ec8cb', '632a93de-7ff0-983c-9042-438dfb96b2f7', '47f16a6f-0237-ee14-c676-438dfb83235d', '2005-11-30 19:26:38', 0);
INSERT INTO accounts_opportunities VALUES ('7a87a253-9778-7fde-cc05-438dfb30067c', '77ad54b0-1401-a954-87b8-438dfbac2203', '756fbb6a-6aa6-3de0-15da-438dfbe81403', '2005-11-30 19:26:39', 0);
INSERT INTO accounts_opportunities VALUES ('82d2a254-ae4d-61d8-5f82-438dfb493d24', '7ffb1fc1-2d41-2af9-a7ab-438dfbba3fc0', '756fbb6a-6aa6-3de0-15da-438dfbe81403', '2005-11-30 19:26:39', 0);
INSERT INTO accounts_opportunities VALUES ('870885ba-a468-cef7-6368-438dfb0e3120', '84334a64-3b00-1cc9-5076-438dfb7bf830', '756fbb6a-6aa6-3de0-15da-438dfbe81403', '2005-11-30 19:26:39', 0);
INSERT INTO accounts_opportunities VALUES ('8f5a095f-9c9b-f3e3-1959-438dfbd756d8', '8c808bbe-bdb9-1af2-9a20-438dfb603cb2', '756fbb6a-6aa6-3de0-15da-438dfbe81403', '2005-11-30 19:26:39', 0);
INSERT INTO accounts_opportunities VALUES ('938fcafc-ee04-a2be-8f59-438dfb990d69', '90ba7c88-844a-8446-e0ba-438dfb8b8c6f', '756fbb6a-6aa6-3de0-15da-438dfbe81403', '2005-11-30 19:26:40', 0);
INSERT INTO accounts_opportunities VALUES ('a8280c61-74dd-c8fa-4a7e-438dfbed26b2', 'a54c0912-64fe-61ba-ae25-438dfba930c6', 'a306a41f-d08d-9f88-7e78-438dfbb3dbf4', '2005-11-30 19:26:40', 0);
INSERT INTO accounts_opportunities VALUES ('ac671f19-43f8-3cbb-e1d7-438dfb621c05', 'a991f6ee-e75a-6ed0-d492-438dfb8ccc14', 'a306a41f-d08d-9f88-7e78-438dfbb3dbf4', '2005-11-30 19:26:40', 0);
INSERT INTO accounts_opportunities VALUES ('b0a28b45-3093-f728-9c38-438dfb0012c4', 'adc73e6a-792b-12aa-4987-438dfbfc2c89', 'a306a41f-d08d-9f88-7e78-438dfbb3dbf4', '2005-11-30 19:26:40', 0);
INSERT INTO accounts_opportunities VALUES ('b4d45dab-19cd-4cbb-6a2c-438dfbcacb7d', 'b200e742-94d2-8846-6a15-438dfb819d10', 'a306a41f-d08d-9f88-7e78-438dfbb3dbf4', '2005-11-30 19:26:41', 0);
INSERT INTO accounts_opportunities VALUES ('b9028ba6-ced8-6e97-5761-438dfb2fbc60', 'b634b6da-d50e-6992-e6fd-438dfb3eb746', 'a306a41f-d08d-9f88-7e78-438dfbb3dbf4', '2005-11-30 19:26:41', 0);
INSERT INTO accounts_opportunities VALUES ('d5bf8355-cf27-cfcb-1923-438dfb9ed0c1', 'd2e322ab-dd30-67a3-b887-438dfb4dcfad', 'd0aa1c58-ab79-3669-d1e3-438dfb7eb918', '2005-11-30 19:26:41', 0);
INSERT INTO accounts_opportunities VALUES ('d9fc32fd-4b73-399e-13a2-438dfbeae8f0', 'd725f003-0457-199f-47b0-438dfb4161c4', 'd0aa1c58-ab79-3669-d1e3-438dfb7eb918', '2005-11-30 19:26:42', 0);
INSERT INTO accounts_opportunities VALUES ('e27c7f2e-a08a-7a51-fbe0-438dfbc58c26', 'df8cebd3-81a5-1c35-c92d-438dfbb29e7a', 'd0aa1c58-ab79-3669-d1e3-438dfb7eb918', '2005-11-30 19:26:42', 0);
INSERT INTO accounts_opportunities VALUES ('e6b4fa22-e4c8-9f4b-b9df-438dfbc09fd3', 'e3e2dc8b-b0f2-b477-ef41-438dfb897da3', 'd0aa1c58-ab79-3669-d1e3-438dfb7eb918', '2005-11-30 19:26:42', 0);
INSERT INTO accounts_opportunities VALUES ('eadc2f0c-d652-f65d-fabe-438dfb5bf6e6', 'e80d0d65-993c-e9ec-0b9b-438dfb8b2665', 'd0aa1c58-ab79-3669-d1e3-438dfb7eb918', '2005-11-30 19:26:43', 0);
INSERT INTO accounts_opportunities VALUES ('b35a04fe-1326-b9a6-ef4b-438dfbcc926f', '85b7073f-5d49-94a7-d32e-438dfb990d95', '61c904f0-7a9d-bd79-1c3c-438dfb588f82', '2005-11-30 19:26:43', 0);
INSERT INTO accounts_opportunities VALUES ('f8b00954-536a-77af-29df-438dfbc40998', 'c97a03b7-b151-ffde-3d5a-438dfb1f2bc5', '61c904f0-7a9d-bd79-1c3c-438dfb588f82', '2005-11-30 19:26:43', 0);
INSERT INTO accounts_opportunities VALUES ('13c1ad88-f652-6798-40d0-438dfb99478d', '10e94720-af23-ff91-9b0c-438dfb2f9a1c', '61c904f0-7a9d-bd79-1c3c-438dfb588f82', '2005-11-30 19:26:43', 0);
INSERT INTO accounts_opportunities VALUES ('17ecb62f-1404-51fe-e314-438dfb907759', '151ff51a-4382-71ff-8d79-438dfbd3c5ae', '61c904f0-7a9d-bd79-1c3c-438dfb588f82', '2005-11-30 19:26:44', 0);
INSERT INTO accounts_opportunities VALUES ('1c2a4f14-3657-5033-abaa-438dfb0efa4d', '194acc7b-3ef9-73a3-e61d-438dfb07f363', '61c904f0-7a9d-bd79-1c3c-438dfb588f82', '2005-11-30 19:26:44', 0);
INSERT INTO accounts_opportunities VALUES ('30d62eab-de21-a3be-f9e8-438dfb5be828', '2ddcb1be-aba3-e88f-eb38-438dfbe213e4', '2b9828bf-e533-2198-b512-438dfb8d5bce', '2005-11-30 19:26:44', 0);
INSERT INTO accounts_opportunities VALUES ('351e8c98-a41d-f0b2-2aed-438dfbe1b936', '324154a0-ab21-4b3d-4cae-438dfbfdf929', '2b9828bf-e533-2198-b512-438dfb8d5bce', '2005-11-30 19:26:45', 0);
INSERT INTO accounts_opportunities VALUES ('3967f066-45d6-3618-74e4-438dfb7a4340', '367e2c9d-47bc-36e0-c68f-438dfb856d07', '2b9828bf-e533-2198-b512-438dfb8d5bce', '2005-11-30 19:26:45', 0);
INSERT INTO accounts_opportunities VALUES ('3da1e3f0-c961-25df-c331-438dfb70334c', '3ac8c155-8df1-74d7-bf9d-438dfbfa3b1c', '2b9828bf-e533-2198-b512-438dfb8d5bce', '2005-11-30 19:26:45', 0);
INSERT INTO accounts_opportunities VALUES ('41cb9d61-36f4-0989-6b30-438dfbc1edb1', '3efeb5c8-f930-cf6d-da20-438dfb308ced', '2b9828bf-e533-2198-b512-438dfb8d5bce', '2005-11-30 19:26:46', 0);
INSERT INTO accounts_opportunities VALUES ('5872c305-77e3-e9d6-cb50-438dfbd4c303', '559e49f3-0d7e-17d1-da5e-438dfbe13fe7', '5348b563-0622-42d3-71ba-438dfb807b3f', '2005-11-30 19:26:46', 0);
INSERT INTO accounts_opportunities VALUES ('658062ac-b0db-27a2-4bad-438dfb677c0a', '62920fe7-b9ef-7547-ce35-438dfb26d3a5', '5348b563-0622-42d3-71ba-438dfb807b3f', '2005-11-30 19:26:46', 0);
INSERT INTO accounts_opportunities VALUES ('69c32353-63d3-97c4-8412-438dfb698c76', '66dc304d-c32a-418f-af97-438dfbcf5e42', '5348b563-0622-42d3-71ba-438dfb807b3f', '2005-11-30 19:26:46', 0);
INSERT INTO accounts_opportunities VALUES ('6dfd6131-210f-5f1b-968a-438dfbc9d448', '6b21cd36-548d-7ed3-dede-438dfba83131', '5348b563-0622-42d3-71ba-438dfb807b3f', '2005-11-30 19:26:47', 0);
INSERT INTO accounts_opportunities VALUES ('76a3e43b-2ec9-d401-88c5-438dfbf22e5d', '73cc107d-706c-df86-8f55-438dfbe5eea6', '5348b563-0622-42d3-71ba-438dfb807b3f', '2005-11-30 19:26:47', 0);
INSERT INTO accounts_opportunities VALUES ('8b196913-58ca-5aa6-7a61-438dfb1d1752', '883fb7f2-6a81-bfd0-6e16-438dfb4e8ec1', '860964ee-8fd8-a620-ec96-438dfbf111c3', '2005-11-30 19:26:47', 0);
INSERT INTO accounts_opportunities VALUES ('8f6cd17d-87c6-da0c-ab79-438dfba60ed1', '8c8970a9-19d5-6926-0993-438dfb578e9a', '860964ee-8fd8-a620-ec96-438dfbf111c3', '2005-11-30 19:26:48', 0);
INSERT INTO accounts_opportunities VALUES ('93a2171c-3b25-213e-064b-438dfb6ef3a6', '90c7ad40-9a9e-a613-0d27-438dfb7be18f', '860964ee-8fd8-a620-ec96-438dfbf111c3', '2005-11-30 19:26:48', 0);
INSERT INTO accounts_opportunities VALUES ('97cdc2ae-86ab-2c49-54e7-438dfb353298', '95005ab9-8c6b-4bfe-5255-438dfbd0ff41', '860964ee-8fd8-a620-ec96-438dfbf111c3', '2005-11-30 19:26:48', 0);
INSERT INTO accounts_opportunities VALUES ('9c04d04e-8aca-0092-122b-438dfbc2de05', '9935df64-5fc4-3797-2b25-438dfbed4246', '860964ee-8fd8-a620-ec96-438dfbf111c3', '2005-11-30 19:26:49', 0);
INSERT INTO accounts_opportunities VALUES ('b06350f1-aa92-2e32-132a-438dfbe550f8', 'ad8925b0-7ad8-ebe7-7383-438dfbe22d7b', 'ab505e26-a5cc-8535-2e96-438dfb5e4452', '2005-11-30 19:26:49', 0);
INSERT INTO accounts_opportunities VALUES ('b4a0d331-8fc0-d633-2ca2-438dfb9bd28d', 'b1d194c4-9ae1-4116-fa30-438dfb84f252', 'ab505e26-a5cc-8535-2e96-438dfb5e4452', '2005-11-30 19:26:49', 0);
INSERT INTO accounts_opportunities VALUES ('b8d7d04e-b17c-42a0-93a7-438dfbd6a82d', 'b603bc4c-b352-c356-933b-438dfb389341', 'ab505e26-a5cc-8535-2e96-438dfb5e4452', '2005-11-30 19:26:50', 0);
INSERT INTO accounts_opportunities VALUES ('bd1d3cb6-88ed-5102-309f-438dfb61eaa3', 'ba37ce6b-fd84-60ea-4c3c-438dfb4b43cf', 'ab505e26-a5cc-8535-2e96-438dfb5e4452', '2005-11-30 19:26:50', 0);
INSERT INTO accounts_opportunities VALUES ('c5e181c4-417e-3b56-afda-438dfbf3a54c', 'c3043af9-ce12-668f-249c-438dfbe5ce98', 'ab505e26-a5cc-8535-2e96-438dfb5e4452', '2005-11-30 19:26:50', 0);
INSERT INTO accounts_opportunities VALUES ('da605416-fd76-cce8-37bc-438dfb4af021', 'd78b7563-3000-a788-0d50-438dfb42241f', 'd53a7082-2cca-4184-26df-438dfb8a9e29', '2005-11-30 19:26:50', 0);
INSERT INTO accounts_opportunities VALUES ('de928343-50f5-01e0-e1c9-438dfb24b299', 'dbc1cb05-b7b1-d2e1-62ea-438dfbc46332', 'd53a7082-2cca-4184-26df-438dfb8a9e29', '2005-11-30 19:26:51', 0);
INSERT INTO accounts_opportunities VALUES ('e2cf2f19-9b23-cad2-14ef-438dfbd04bbe', 'dff4b8c4-5b60-abf3-8476-438dfb76e55f', 'd53a7082-2cca-4184-26df-438dfb8a9e29', '2005-11-30 19:26:51', 0);
INSERT INTO accounts_opportunities VALUES ('e706e8fd-9939-4a8a-8fb2-438dfb9c376c', 'e4320657-60d6-69be-3554-438dfb574e48', 'd53a7082-2cca-4184-26df-438dfb8a9e29', '2005-11-30 19:26:51', 0);
INSERT INTO accounts_opportunities VALUES ('eb33fe70-8001-ab64-6d45-438dfb93ed26', 'e8625c80-d485-0d02-b7a7-438dfb0b6c79', 'd53a7082-2cca-4184-26df-438dfb8a9e29', '2005-11-30 19:26:51', 0);
INSERT INTO accounts_opportunities VALUES ('b9ff0c90-d093-a5a5-183a-438dfb6cae31', '8be10f15-fb8d-ee50-a48f-438dfb8c9d0d', '683501c7-529b-869a-5687-438dfb04ab8b', '2005-11-30 19:26:52', 0);
INSERT INTO accounts_opportunities VALUES ('1004d721-4a22-5547-65fc-438dfb1aa132', 'd0080e19-042b-b0b4-090e-438dfb3db19e', '683501c7-529b-869a-5687-438dfb04ab8b', '2005-11-30 19:26:52', 0);
INSERT INTO accounts_opportunities VALUES ('14541445-b064-bcaf-1c1c-438dfb765d13', '116dee12-4b7f-aaaa-fc28-438dfb4090f4', '683501c7-529b-869a-5687-438dfb04ab8b', '2005-11-30 19:26:52', 0);
INSERT INTO accounts_opportunities VALUES ('18901ea2-44e9-3a57-2016-438dfbba4d71', '15b59a2c-9348-139e-64c4-438dfb15d11f', '683501c7-529b-869a-5687-438dfb04ab8b', '2005-11-30 19:26:53', 0);
INSERT INTO accounts_opportunities VALUES ('1cd0435c-bd48-4e2d-7822-438dfb22a5e3', '19ee9ca5-f922-6d35-a2db-438dfb793ca4', '683501c7-529b-869a-5687-438dfb04ab8b', '2005-11-30 19:26:53', 0);
INSERT INTO accounts_opportunities VALUES ('31853c6f-6c2f-c324-8441-438dfb761eb8', '2e9f1dda-6638-f005-2f3d-438dfb0337ec', '2c46c77e-e5a7-5cc1-6df7-438dfb2e201c', '2005-11-30 19:26:53', 0);
INSERT INTO accounts_opportunities VALUES ('35bff2cf-a3ab-b142-0f06-438dfb1db8f1', '32ebc39a-a94d-45e1-2ee3-438dfb3dc141', '2c46c77e-e5a7-5cc1-6df7-438dfb2e201c', '2005-11-30 19:26:53', 0);
INSERT INTO accounts_opportunities VALUES ('39f866b9-b3da-85ab-eff5-438dfb7d34e8', '3728bc6d-48fd-7a12-d603-438dfbd4c6a0', '2c46c77e-e5a7-5cc1-6df7-438dfb2e201c', '2005-11-30 19:26:54', 0);
INSERT INTO accounts_opportunities VALUES ('3e2c40ba-23c7-a0ab-9fbf-438dfb9955ce', '3b572c03-ee48-6796-6e83-438dfb000ea7', '2c46c77e-e5a7-5cc1-6df7-438dfb2e201c', '2005-11-30 19:26:54', 0);
INSERT INTO accounts_opportunities VALUES ('4914fcb5-e0bb-3f4c-425d-438dfb584a07', '463e9425-35be-14a6-6e28-438dfb058094', '2c46c77e-e5a7-5cc1-6df7-438dfb2e201c', '2005-11-30 19:26:54', 0);
INSERT INTO accounts_opportunities VALUES ('5dc35291-27ff-83aa-ebb6-438dfb72f86c', '5ae5b971-242b-4b4c-4fda-438dfbb7ad9d', '589ab56c-b842-1e39-fa69-438dfb3c55d5', '2005-11-30 19:26:54', 0);
INSERT INTO accounts_opportunities VALUES ('61fd5726-2564-5371-cd47-438dfb47d555', '5f2ece0f-ad78-cac4-1dc5-438dfb9db884', '589ab56c-b842-1e39-fa69-438dfb3c55d5', '2005-11-30 19:26:54', 0);
INSERT INTO accounts_opportunities VALUES ('665bed3b-6587-0b44-d71a-438dfb0b5f8d', '635d98c3-5709-7856-e50d-438dfbd0068f', '589ab56c-b842-1e39-fa69-438dfb3c55d5', '2005-11-30 19:26:55', 0);
INSERT INTO accounts_opportunities VALUES ('6abb7b2b-4584-4a1a-e6e0-438dfba2c89f', '67da3973-3fab-ac76-b4ec-438dfbe8552f', '589ab56c-b842-1e39-fa69-438dfb3c55d5', '2005-11-30 19:26:55', 0);
INSERT INTO accounts_opportunities VALUES ('6eec0431-7718-91ad-b399-438dfb02ed63', '6c147625-8adb-dc36-dda5-438dfb9681e1', '589ab56c-b842-1e39-fa69-438dfb3c55d5', '2005-11-30 19:26:55', 0);
INSERT INTO accounts_opportunities VALUES ('8366859d-95fd-1bc9-6ef9-438dfbaa2199', '8094559f-76bd-bdfe-9f6c-438dfb6bc8e8', '7e48a579-8198-83c2-3e93-438dfbb37fa2', '2005-11-30 19:26:55', 0);
INSERT INTO accounts_opportunities VALUES ('87a8f8f3-d12d-c13d-4170-438dfbe976ef', '84ca7802-8c9f-fbd7-271a-438dfbff07ce', '7e48a579-8198-83c2-3e93-438dfbb37fa2', '2005-11-30 19:26:56', 0);
INSERT INTO accounts_opportunities VALUES ('8bd9c3fe-f629-8c78-7a9a-438dfbc54e26', '890a1ede-52c0-6075-9da6-438dfb606a61', '7e48a579-8198-83c2-3e93-438dfbb37fa2', '2005-11-30 19:26:56', 0);
INSERT INTO accounts_opportunities VALUES ('9025be8b-37d9-39e0-99cc-438dfb873c46', '8d4b592f-d576-bce1-63b8-438dfbc24e6a', '7e48a579-8198-83c2-3e93-438dfbb37fa2', '2005-11-30 19:26:56', 0);
INSERT INTO accounts_opportunities VALUES ('945d7bc0-09e4-6768-f1e2-438dfb8e6aaa', '918a9330-9886-9598-2beb-438dfb470585', '7e48a579-8198-83c2-3e93-438dfbb37fa2', '2005-11-30 19:26:56', 0);
INSERT INTO accounts_opportunities VALUES ('a8da3ceb-3376-fd78-57a6-438dfb57c543', 'a5fc201b-0922-cb89-b69e-438dfb874637', 'a3ae5ce7-97f3-0767-2c32-438dfb67ba2f', '2005-11-30 19:26:57', 0);
INSERT INTO accounts_opportunities VALUES ('ad1fef74-fc3c-cc98-7771-438dfb2563cb', 'aa4ef9c8-c8de-d101-a522-438dfb014bcc', 'a3ae5ce7-97f3-0767-2c32-438dfb67ba2f', '2005-11-30 19:26:57', 0);
INSERT INTO accounts_opportunities VALUES ('b15ed89e-63c9-085f-c23e-438dfb434923', 'ae8455da-78f7-f7ab-eef8-438dfbcdd836', 'a3ae5ce7-97f3-0767-2c32-438dfb67ba2f', '2005-11-30 19:26:57', 0);
INSERT INTO accounts_opportunities VALUES ('b5a08956-89a7-f3cd-a5ff-438dfb78a491', 'b2c0777c-488e-896c-8771-438dfb1f08f9', 'a3ae5ce7-97f3-0767-2c32-438dfb67ba2f', '2005-11-30 19:26:58', 0);
INSERT INTO accounts_opportunities VALUES ('b9d37dcc-dd90-24a7-2821-438dfbbe1f8e', 'b7054450-f1aa-8eea-aade-438dfb2a360a', 'a3ae5ce7-97f3-0767-2c32-438dfb67ba2f', '2005-11-30 19:26:58', 0);
INSERT INTO accounts_opportunities VALUES ('d86ccbf5-82ef-290d-0928-438dfb5333d7', 'd57d42ee-918d-8c1b-7eed-438dfbefa31a', 'd3341561-6269-a089-3222-438dfbd74426', '2005-11-30 19:26:58', 0);
INSERT INTO accounts_opportunities VALUES ('dc9f6705-7224-ab08-4b7f-438dfb3c33ec', 'd9ced5f6-4138-2674-0124-438dfbedf127', 'd3341561-6269-a089-3222-438dfbd74426', '2005-11-30 19:26:58', 0);
INSERT INTO accounts_opportunities VALUES ('e0d567af-c8bd-c4c5-9a55-438dfbd1b0f0', 'ddff3852-09c6-35a5-7d83-438dfb6960d8', 'd3341561-6269-a089-3222-438dfbd74426', '2005-11-30 19:26:59', 0);
INSERT INTO accounts_opportunities VALUES ('ea1b75b0-d78e-b41b-7769-438dfb2206f1', 'e74a4943-3618-0f9b-d817-438dfb2d033f', 'd3341561-6269-a089-3222-438dfbd74426', '2005-11-30 19:26:59', 0);
INSERT INTO accounts_opportunities VALUES ('ee5b796e-81ae-fbe8-0bbe-438dfb2346df', 'eb803792-4876-f35e-d0dd-438dfbcd83c7', 'd3341561-6269-a089-3222-438dfbd74426', '2005-11-30 19:26:59', 0);
INSERT INTO accounts_opportunities VALUES ('ebd40dc5-5f51-3ada-20ae-438dfb43c680', 'bdae0409-bb9d-e659-ecea-438dfba8e2b3', '99540248-a633-5eab-e014-438dfbbb6d0d', '2005-11-30 19:27:00', 0);
INSERT INTO accounts_opportunities VALUES ('12fa64de-0d25-fa6d-399a-438dfbe0d080', '10212b17-7006-a66f-fba3-438dfbf19b63', '99540248-a633-5eab-e014-438dfbbb6d0d', '2005-11-30 19:27:00', 0);
INSERT INTO accounts_opportunities VALUES ('17477a0e-f061-6367-aded-438dfb49b7ec', '146e9f0d-c2c4-dbbb-2de8-438dfb32052a', '99540248-a633-5eab-e014-438dfbbb6d0d', '2005-11-30 19:27:00', 0);
INSERT INTO accounts_opportunities VALUES ('2aa79fdd-35ae-2927-afb1-438dfb28f9e4', '22c50d2a-473a-a1f4-eab5-438dfbb6cd72', '99540248-a633-5eab-e014-438dfbbb6d0d', '2005-11-30 19:27:01', 0);
INSERT INTO accounts_opportunities VALUES ('2f00bff7-34b2-d781-7ba1-438dfb4c31e3', '2c08c49b-01d4-7474-900d-438dfb9e0610', '99540248-a633-5eab-e014-438dfbbb6d0d', '2005-11-30 19:27:01', 0);
INSERT INTO accounts_opportunities VALUES ('45870b73-3f53-80d8-ff11-438dfb3247b5', '40c7826f-9cf1-bbea-6f45-438dfb6aebe5', '3e8c7862-6b2a-0824-ec19-438dfb18f048', '2005-11-30 19:27:01', 0);
INSERT INTO accounts_opportunities VALUES ('4f2b9acd-35e2-128c-19e4-438dfbcefde7', '4c4ac3bd-9c44-7f1f-f846-438dfb8322c9', '3e8c7862-6b2a-0824-ec19-438dfb18f048', '2005-11-30 19:27:02', 0);
INSERT INTO accounts_opportunities VALUES ('539d6899-343b-c2eb-3eab-438dfb7d9add', '50c13ebf-f548-5b82-d637-438dfb8a313f', '3e8c7862-6b2a-0824-ec19-438dfb18f048', '2005-11-30 19:27:02', 0);
INSERT INTO accounts_opportunities VALUES ('57d5a397-2152-0096-d629-438dfb463527', '5505f9f1-e73c-3c48-35d5-438dfb0a6443', '3e8c7862-6b2a-0824-ec19-438dfb18f048', '2005-11-30 19:27:02', 0);
INSERT INTO accounts_opportunities VALUES ('5c0f5ee6-61d4-2537-6dcd-438dfb5f3f09', '59384075-9285-83ca-09ed-438dfbac0596', '3e8c7862-6b2a-0824-ec19-438dfb18f048', '2005-11-30 19:27:02', 0);
INSERT INTO accounts_opportunities VALUES ('70947066-b7c1-5817-8cb9-438dfb1c5ef5', '6db7a400-d922-ac65-77b6-438dfbbf193b', '6b74ee4d-f2e1-c581-dd78-438dfb730c7e', '2005-11-30 19:27:03', 0);
INSERT INTO accounts_opportunities VALUES ('7a07eaad-4fed-3bf5-0bf4-438dfbc3e526', '7732933a-b90a-52d8-bdae-438dfb089a60', '6b74ee4d-f2e1-c581-dd78-438dfb730c7e', '2005-11-30 19:27:03', 0);
INSERT INTO accounts_opportunities VALUES ('7e36abe7-df75-cc97-aae2-438dfb7d58b6', '7b650e73-9a2b-8bed-2dba-438dfb5b018c', '6b74ee4d-f2e1-c581-dd78-438dfb730c7e', '2005-11-30 19:27:03', 0);
INSERT INTO accounts_opportunities VALUES ('8273921f-d96c-2eb4-e3b0-438dfbbbbaa5', '7f976157-5179-d191-6fc5-438dfbb1a129', '6b74ee4d-f2e1-c581-dd78-438dfb730c7e', '2005-11-30 19:27:04', 0);
INSERT INTO accounts_opportunities VALUES ('8bde9766-d824-c318-070c-438dfb2a4fd9', '890a2153-039a-a45c-3dcd-438dfb5d2aed', '6b74ee4d-f2e1-c581-dd78-438dfb730c7e', '2005-11-30 19:27:04', 0);
INSERT INTO accounts_opportunities VALUES ('a07f0b06-42a0-7e13-81ea-438dfbebe915', '9d95dea6-57a3-0722-6de6-438dfbf6b976', '9b5b10ca-e088-dfb3-7bd6-438dfb9f4ae9', '2005-11-30 19:27:05', 0);
INSERT INTO accounts_opportunities VALUES ('aa09de99-bcb7-e36e-3f6a-438dfbe5e0df', 'a72ad3af-06c3-e481-bdbd-438dfb4e651a', '9b5b10ca-e088-dfb3-7bd6-438dfb9f4ae9', '2005-11-30 19:27:05', 0);
INSERT INTO accounts_opportunities VALUES ('ae41c425-64b6-3eb9-595b-438dfb644f35', 'ab670332-6325-3099-b236-438dfb62cdcd', '9b5b10ca-e088-dfb3-7bd6-438dfb9f4ae9', '2005-11-30 19:27:05', 0);
INSERT INTO accounts_opportunities VALUES ('b27be49b-4d60-740d-ec01-438dfbef843a', 'afa8579d-2cd4-2676-d84a-438dfb3d6ef9', '9b5b10ca-e088-dfb3-7bd6-438dfb9f4ae9', '2005-11-30 19:27:06', 0);
INSERT INTO accounts_opportunities VALUES ('b6a9e1af-1d5f-9a5e-ad2a-438dfb7ccff4', 'b3d8c5be-8642-2877-a658-438dfbe7b4ae', '9b5b10ca-e088-dfb3-7bd6-438dfb9f4ae9', '2005-11-30 19:27:06', 0);
INSERT INTO accounts_opportunities VALUES ('d0885d58-e3d1-95bb-2e59-438dfb3a70f9', 'cdacae53-7c56-cb8b-79b7-438dfb2d99f4', 'cb6a9a32-58b5-580b-d07f-438dfb32eafe', '2005-11-30 19:27:06', 0);
INSERT INTO accounts_opportunities VALUES ('d4c8c6af-0273-3a7d-66ef-438dfb53a509', 'd1ebb0ca-2a26-8a6e-91f3-438dfb2ffd32', 'cb6a9a32-58b5-580b-d07f-438dfb32eafe', '2005-11-30 19:27:07', 0);
INSERT INTO accounts_opportunities VALUES ('e3b58d17-d7ff-6566-cdeb-438dfbc7a312', 'e0cf4366-77d7-dabc-2fff-438dfb7f2c7f', 'cb6a9a32-58b5-580b-d07f-438dfb32eafe', '2005-11-30 19:27:07', 0);
INSERT INTO accounts_opportunities VALUES ('e7f2f7aa-1aa0-3032-7a3f-438dfb8a48a7', 'e5184f86-3eef-062f-7229-438dfb2b8cbf', 'cb6a9a32-58b5-580b-d07f-438dfb32eafe', '2005-11-30 19:27:08', 0);
INSERT INTO accounts_opportunities VALUES ('ec29cbb2-64b0-f55a-b3c0-438dfb02fdf9', 'e95010b7-8ab1-8322-9d57-438dfbfc8c2b', 'cb6a9a32-58b5-580b-d07f-438dfb32eafe', '2005-11-30 19:27:08', 0);
INSERT INTO accounts_opportunities VALUES ('174c4da6-db03-d77a-a80b-438dfb5f94ed', '146fc035-c3e6-c18a-e922-438dfbf3eb4c', '1221a978-b701-cc79-29b4-438dfb27ec07', '2005-11-30 19:27:08', 0);
INSERT INTO accounts_opportunities VALUES ('26568db9-6432-bedf-8691-438dfbbb56cb', '236ec107-94fc-2db5-bbb1-438dfbbef1db', '1221a978-b701-cc79-29b4-438dfb27ec07', '2005-11-30 19:27:09', 0);
INSERT INTO accounts_opportunities VALUES ('2a8a958f-ec22-394d-903c-438dfb01d755', '27b4f656-4874-8c4f-06f7-438dfb22eb7c', '1221a978-b701-cc79-29b4-438dfb27ec07', '2005-11-30 19:27:09', 0);
INSERT INTO accounts_opportunities VALUES ('2ef2211c-8841-c39e-494f-438dfb015412', '2bfc6252-2142-d403-33df-438dfbeea20b', '1221a978-b701-cc79-29b4-438dfb27ec07', '2005-11-30 19:27:09', 0);
INSERT INTO accounts_opportunities VALUES ('33367d2c-9de7-c7c5-4487-438dfb9989ce', '3064e92a-b006-b4c3-1ffb-438dfb94414e', '1221a978-b701-cc79-29b4-438dfb27ec07', '2005-11-30 19:27:09', 0);
INSERT INTO accounts_opportunities VALUES ('49c2ef59-323e-5775-8696-438dfbd4d161', '46eb8fb2-6073-9950-c786-438dfbdc0065', '42b754c8-dfad-6eaf-cbe5-438dfb050c30', '2005-11-30 19:27:10', 0);
INSERT INTO accounts_opportunities VALUES ('4e10664b-f899-2986-f825-438dfb4b9812', '4b295f69-6c78-3e94-4819-438dfbb430e0', '42b754c8-dfad-6eaf-cbe5-438dfb050c30', '2005-11-30 19:27:10', 0);
INSERT INTO accounts_opportunities VALUES ('526d65e5-ce4f-c791-a61b-438dfb71d374', '4f71103e-6250-03b4-20ae-438dfb874930', '42b754c8-dfad-6eaf-cbe5-438dfb050c30', '2005-11-30 19:27:10', 0);
INSERT INTO accounts_opportunities VALUES ('56a9142c-d4ee-5487-3d97-438dfb2a6783', '53cbd060-8d04-fec9-5016-438dfbe2aad4', '42b754c8-dfad-6eaf-cbe5-438dfb050c30', '2005-11-30 19:27:11', 0);
INSERT INTO accounts_opportunities VALUES ('5adb53f5-fb59-db4a-be38-438dfb661335', '580aac24-30cf-f60c-fbdf-438dfb87bdfa', '42b754c8-dfad-6eaf-cbe5-438dfb050c30', '2005-11-30 19:27:11', 0);
INSERT INTO accounts_opportunities VALUES ('6fc6f4db-9958-35e9-3698-438dfb265890', '6ce5a5e6-8dca-4e48-8ba3-438dfb09a754', '6aa69a70-12fe-e914-688b-438dfb971562', '2005-11-30 19:27:11', 0);
INSERT INTO accounts_opportunities VALUES ('799546a7-5eb1-07dd-e0eb-438dfbc2681f', '76b6a658-c595-b7dd-fdc8-438dfbf06a2b', '6aa69a70-12fe-e914-688b-438dfb971562', '2005-11-30 19:27:12', 0);
INSERT INTO accounts_opportunities VALUES ('7dc5b7b8-83b4-ee98-61f4-438dfbacaa8b', '7af34577-836e-ed93-1944-438dfb30ff8f', '6aa69a70-12fe-e914-688b-438dfb971562', '2005-11-30 19:27:12', 0);
INSERT INTO accounts_opportunities VALUES ('8206baf2-ae30-b364-09f1-438dfb2a34c6', '7f267a84-90ac-3941-3b14-438dfbd2b3c0', '6aa69a70-12fe-e914-688b-438dfb971562', '2005-11-30 19:27:12', 0);
INSERT INTO accounts_opportunities VALUES ('8647f966-510a-f9fb-dafb-438dfbe11647', '836a57e2-7ed8-68aa-69c5-438dfb5c9c23', '6aa69a70-12fe-e914-688b-438dfb971562', '2005-11-30 19:27:13', 0);
INSERT INTO accounts_opportunities VALUES ('a61a15a2-3c28-b7df-de24-438dfbd5f945', 'a3296f34-1542-5e46-d742-438dfb42ba38', 'a0e7ad4b-b177-b914-da9c-438dfbda815f', '2005-11-30 19:27:13', 0);
INSERT INTO accounts_opportunities VALUES ('aa4dad2c-5b52-f16c-bf6e-438dfb541575', 'a77bfcc3-e464-dfd9-a75d-438dfb83ceb7', 'a0e7ad4b-b177-b914-da9c-438dfbda815f', '2005-11-30 19:27:13', 0);
INSERT INTO accounts_opportunities VALUES ('ae938ccc-6327-e591-a5c3-438dfb4cdde5', 'abb02ce3-b754-f54d-5223-438dfbdbb6be', 'a0e7ad4b-b177-b914-da9c-438dfbda815f', '2005-11-30 19:27:14', 0);
INSERT INTO accounts_opportunities VALUES ('b2ddba48-0a14-fdc5-a0a5-438dfb39ba40', 'aff687a8-2189-3ae2-46c7-438dfbc7c960', 'a0e7ad4b-b177-b914-da9c-438dfbda815f', '2005-11-30 19:27:14', 0);
INSERT INTO accounts_opportunities VALUES ('b709c0d9-9b44-7f9d-6215-438dfbeebaf2', 'b43ae0e9-390e-17f4-3b8d-438dfb410789', 'a0e7ad4b-b177-b914-da9c-438dfbda815f', '2005-11-30 19:27:14', 0);
INSERT INTO accounts_opportunities VALUES ('cb889c3e-79b1-4dca-db9b-438dfb3928df', 'c8a980bc-58cf-6208-cdce-438dfb6175f8', 'c6632abb-10b1-66c3-3525-438dfb4119f5', '2005-11-30 19:27:15', 0);
INSERT INTO accounts_opportunities VALUES ('cfc971d9-6989-a1ca-c408-438dfb6d8876', 'ccf268f6-a910-75bd-baa7-438dfb4ace86', 'c6632abb-10b1-66c3-3525-438dfb4119f5', '2005-11-30 19:27:16', 0);
INSERT INTO accounts_opportunities VALUES ('d40196df-b015-5615-6df0-438dfba8f712', 'd1258da7-c07d-834d-9f79-438dfb37b668', 'c6632abb-10b1-66c3-3525-438dfb4119f5', '2005-11-30 19:27:16', 0);
INSERT INTO accounts_opportunities VALUES ('d83c75ff-8b07-57a6-9326-438dfb5b6ec8', 'd560b932-0602-ec84-fe9f-438dfb4d3ef7', 'c6632abb-10b1-66c3-3525-438dfb4119f5', '2005-11-30 19:27:16', 0);
INSERT INTO accounts_opportunities VALUES ('e23b77bc-20ca-73e6-b285-438dfbaabf5a', 'df43c520-8ff4-88e6-f00c-438dfb26e93d', 'c6632abb-10b1-66c3-3525-438dfb4119f5', '2005-11-30 19:27:17', 0);
INSERT INTO accounts_opportunities VALUES ('2adb0b45-5f9d-f7f7-0e6f-438dfbb663c8', 'f3fa8e2e-2969-a6b5-9416-438dfb4eb4db', 'f1b68c60-fd88-d531-9e4c-438dfb9d470d', '2005-11-30 19:27:17', 0);
INSERT INTO accounts_opportunities VALUES ('711a0c83-09b9-5549-d831-438dfbde3e52', '4113017f-002e-7070-014a-438dfbd53f12', 'f1b68c60-fd88-d531-9e4c-438dfb9d470d', '2005-11-30 19:27:17', 0);
INSERT INTO accounts_opportunities VALUES ('b4890f00-d1b2-1c4d-5843-438dfb63cf88', '86ea007f-20ef-192a-2dbe-438dfbed768d', 'f1b68c60-fd88-d531-9e4c-438dfb9d470d', '2005-11-30 19:27:18', 0);
INSERT INTO accounts_opportunities VALUES ('154e1f1b-a2c2-4120-2a8c-438dfb417dd3', '1273738e-ce8e-abdd-e80c-438dfba3c6d1', 'f1b68c60-fd88-d531-9e4c-438dfb9d470d', '2005-11-30 19:27:18', 0);
INSERT INTO accounts_opportunities VALUES ('198c24c1-2eb8-b8c5-14fb-438dfba8034f', '16ab62bd-2640-3519-afe0-438dfb493505', 'f1b68c60-fd88-d531-9e4c-438dfb9d470d', '2005-11-30 19:27:18', 0);
INSERT INTO accounts_opportunities VALUES ('2e3bdd99-a334-4de5-c24d-438dfb7b9ce9', '2b34545c-d8b3-fa09-f9a0-438dfbd100a6', '28f75af4-5123-7550-243f-438dfb8ddf01', '2005-11-30 19:27:19', 0);
INSERT INTO accounts_opportunities VALUES ('32aa4091-ef2e-dd1f-37f9-438dfb02e751', '2fbf52e9-d2cc-69bd-dfdf-438dfb1a416b', '28f75af4-5123-7550-243f-438dfb8ddf01', '2005-11-30 19:27:19', 0);
INSERT INTO accounts_opportunities VALUES ('36da815d-c7cb-89c9-0e6c-438dfba26721', '34075651-7dcb-ae6a-c0e7-438dfbafdb15', '28f75af4-5123-7550-243f-438dfb8ddf01', '2005-11-30 19:27:19', 0);
INSERT INTO accounts_opportunities VALUES ('3b367fcc-1718-c866-f233-438dfb7baf81', '384f66bb-aff3-aae2-0657-438dfb56cfdd', '28f75af4-5123-7550-243f-438dfb8ddf01', '2005-11-30 19:27:20', 0);
INSERT INTO accounts_opportunities VALUES ('3f7578a7-7b8e-5f0f-3522-438dfb212d72', '3c96ab27-75af-d000-3a7d-438dfbec15aa', '28f75af4-5123-7550-243f-438dfb8ddf01', '2005-11-30 19:27:20', 0);
INSERT INTO accounts_opportunities VALUES ('56279b93-9293-ca83-ad13-438dfbe82d28', '534388eb-8479-ab07-5d3b-438dfbd9133a', '51066781-1ec3-3fe8-7322-438dfbd99b65', '2005-11-30 19:27:20', 0);
INSERT INTO accounts_opportunities VALUES ('6044eca0-2e42-8a24-e023-438dfbfc725a', '5d71b9e7-ea02-312e-a6e8-438dfbaff1fa', '51066781-1ec3-3fe8-7322-438dfbd99b65', '2005-11-30 19:27:20', 0);
INSERT INTO accounts_opportunities VALUES ('647ed2f6-97a5-b85d-b21e-438dfb49f980', '61a8b77f-6e5f-faf9-f84d-438dfb175e1f', '51066781-1ec3-3fe8-7322-438dfbd99b65', '2005-11-30 19:27:21', 0);
INSERT INTO accounts_opportunities VALUES ('68c88f9a-8fff-58fe-882b-438dfb8e91f2', '65de9067-0f8b-88c7-a811-438dfbc66761', '51066781-1ec3-3fe8-7322-438dfbd99b65', '2005-11-30 19:27:21', 0);
INSERT INTO accounts_opportunities VALUES ('7312cb99-6844-c428-69ea-438dfb37b711', '703a8f8a-9a1c-c0f1-92cf-438dfb3207a8', '51066781-1ec3-3fe8-7322-438dfbd99b65', '2005-11-30 19:27:22', 0);
INSERT INTO accounts_opportunities VALUES ('87966127-c0e3-c0b9-4bae-438dfb19b0eb', '84bb8c4f-0104-54c6-13d3-438dfb8c5dbd', '827f20ff-6ccb-df5c-4492-438dfb56d80b', '2005-11-30 19:27:22', 0);
INSERT INTO accounts_opportunities VALUES ('8bdf6571-9d59-cd81-f984-438dfb0a30f8', '89078279-fb89-af45-d613-438dfb0e2ab9', '827f20ff-6ccb-df5c-4492-438dfb56d80b', '2005-11-30 19:27:22', 0);
INSERT INTO accounts_opportunities VALUES ('90304e4a-abbd-4463-ef8b-438dfb8edf8e', '8d480f58-da10-445e-b312-438dfbe21f66', '827f20ff-6ccb-df5c-4492-438dfb56d80b', '2005-11-30 19:27:23', 0);
INSERT INTO accounts_opportunities VALUES ('9a647f13-e638-ea09-0d15-438dfb895d6e', '978a9565-bd89-38a1-2760-438dfbea6857', '827f20ff-6ccb-df5c-4492-438dfb56d80b', '2005-11-30 19:27:23', 0);
INSERT INTO accounts_opportunities VALUES ('9e982cb7-a846-8a16-fbe0-438dfb2673e5', '9bc5f1b5-edf3-3dd2-9dd6-438dfba60fef', '827f20ff-6ccb-df5c-4492-438dfb56d80b', '2005-11-30 19:27:23', 0);
INSERT INTO accounts_opportunities VALUES ('b32ae4b4-8e67-dc67-ca18-438dfb4cd6db', 'b04f32ec-23d5-8bea-e7a6-438dfbdd6bf8', 'ae0caf82-6b91-edcd-ac34-438dfbcae84b', '2005-11-30 19:27:24', 0);
INSERT INTO accounts_opportunities VALUES ('b76633cf-13b9-253c-54e2-438dfb45d4be', 'b48c8521-5e73-869e-70de-438dfbaa240d', 'ae0caf82-6b91-edcd-ac34-438dfbcae84b', '2005-11-30 19:27:24', 0);
INSERT INTO accounts_opportunities VALUES ('bb959a42-1783-bb83-45f7-438dfb9466dc', 'b8c208ba-14e8-888e-c906-438dfb711e68', 'ae0caf82-6b91-edcd-ac34-438dfbcae84b', '2005-11-30 19:27:24', 0);
INSERT INTO accounts_opportunities VALUES ('c5e0606a-f810-5421-038f-438dfb63a314', 'c3053415-2ae2-9a14-1cdb-438dfb97ad1a', 'ae0caf82-6b91-edcd-ac34-438dfbcae84b', '2005-11-30 19:27:24', 0);
INSERT INTO accounts_opportunities VALUES ('ca1a82b0-9e27-ce7e-ff1b-438dfbb8cd79', 'c74eb9f2-90c9-8e80-ed56-438dfb121375', 'ae0caf82-6b91-edcd-ac34-438dfbcae84b', '2005-11-30 19:27:25', 0);
INSERT INTO accounts_opportunities VALUES ('de93a136-8237-7ba6-d346-438dfb6b6f96', 'dbb5721b-b4c6-7135-51bb-438dfbf37156', 'd97a4b11-78d3-b9d3-7024-438dfbf6028a', '2005-11-30 19:27:25', 0);
INSERT INTO accounts_opportunities VALUES ('e8eddaeb-4848-4703-f41e-438dfbe51153', 'e60cf0a2-27d4-39b0-d4ef-438dfb9e583b', 'd97a4b11-78d3-b9d3-7024-438dfbf6028a', '2005-11-30 19:27:25', 0);
INSERT INTO accounts_opportunities VALUES ('ed1e7ae8-2565-e169-8219-438dfb93fa0a', 'ea4fd146-af02-fc25-0b02-438dfb1c4721', 'd97a4b11-78d3-b9d3-7024-438dfbf6028a', '2005-11-30 19:27:26', 0);
INSERT INTO accounts_opportunities VALUES ('f15aa629-2fe6-7a3b-e142-438dfb81facc', 'ee7faa51-a58c-53cf-2f03-438dfb34ab36', 'd97a4b11-78d3-b9d3-7024-438dfbf6028a', '2005-11-30 19:27:26', 0);
INSERT INTO accounts_opportunities VALUES ('15e10520-d08e-ddd9-358f-438dfba2eef4', 'f2b3db06-1c75-31fb-3713-438dfb062fe2', 'd97a4b11-78d3-b9d3-7024-438dfbf6028a', '2005-11-30 19:27:27', 0);
INSERT INTO accounts_opportunities VALUES ('1c09b328-208a-8292-e994-438dfbfb5abb', '192cbc9c-4401-a10a-c70d-438dfb99f6ca', '16eb4b2a-a495-ed33-7f2c-438dfb73ede3', '2005-11-30 19:27:27', 0);
INSERT INTO accounts_opportunities VALUES ('2051d3ad-c8b3-3fdb-33ae-438dfbb5ce0a', '1d6f5ee0-1c71-c665-842e-438dfbbd6e90', '16eb4b2a-a495-ed33-7f2c-438dfb73ede3', '2005-11-30 19:27:27', 0);
INSERT INTO accounts_opportunities VALUES ('247eba0d-2418-89ad-076e-438dfb1ef8d3', '21ade252-80cd-12bb-cf0e-438dfb733a0c', '16eb4b2a-a495-ed33-7f2c-438dfb73ede3', '2005-11-30 19:27:28', 0);
INSERT INTO accounts_opportunities VALUES ('28bf5a8b-b4b1-c17d-cdca-438dfb1ec7fb', '25e6c53f-9a68-f92a-3d62-438dfbed064e', '16eb4b2a-a495-ed33-7f2c-438dfb73ede3', '2005-11-30 19:27:28', 0);
INSERT INTO accounts_opportunities VALUES ('2cfff4ce-6a64-8acb-8109-438dfb3cde83', '2a241ebf-dd71-e803-f672-438dfb9b1863', '16eb4b2a-a495-ed33-7f2c-438dfb73ede3', '2005-11-30 19:27:28', 0);
INSERT INTO accounts_opportunities VALUES ('4ff06463-e852-ac95-a9db-438dfb1fb3d3', '4d174fa5-28ab-d8eb-cc8a-438dfb3e89b0', '4ad0c452-7b48-f49a-70a1-438dfb731561', '2005-11-30 19:27:29', 0);
INSERT INTO accounts_opportunities VALUES ('54516d15-dec3-56f3-5970-438dfbe9d73c', '517ef946-9cef-4863-0f1b-438dfb2f7316', '4ad0c452-7b48-f49a-70a1-438dfb731561', '2005-11-30 19:27:29', 0);
INSERT INTO accounts_opportunities VALUES ('588b6c31-c2c8-339b-1199-438dfb89240b', '55b543af-7dc9-9e13-2774-438dfb5db3d3', '4ad0c452-7b48-f49a-70a1-438dfb731561', '2005-11-30 19:27:29', 0);
INSERT INTO accounts_opportunities VALUES ('5cbd3c60-f360-4cc6-fd44-438dfba56757', '59e936dc-ebb9-7441-b297-438dfb315ea5', '4ad0c452-7b48-f49a-70a1-438dfb731561', '2005-11-30 19:27:30', 0);
INSERT INTO accounts_opportunities VALUES ('61007aa0-dfbc-4351-98d8-438dfbec671b', '5e271456-3389-cfc5-d17e-438dfb8850bf', '4ad0c452-7b48-f49a-70a1-438dfb731561', '2005-11-30 19:27:30', 0);
INSERT INTO accounts_opportunities VALUES ('75a65bc0-3852-950c-1e1b-438dfb0a91db', '72cd591b-9d91-c8df-0240-438dfb69fe6e', '709024ac-3d9e-e75a-0885-438dfb820403', '2005-11-30 19:27:30', 0);
INSERT INTO accounts_opportunities VALUES ('79e99e61-9869-2ee1-5d74-438dfbe327ac', '770dca0a-93da-bcba-b8dc-438dfba29446', '709024ac-3d9e-e75a-0885-438dfb820403', '2005-11-30 19:27:30', 0);
INSERT INTO accounts_opportunities VALUES ('8474c35e-bdd7-621a-164b-438dfb96ca61', '8193ed88-6ab6-2b4b-c970-438dfbce940a', '709024ac-3d9e-e75a-0885-438dfb820403', '2005-11-30 19:27:31', 0);
INSERT INTO accounts_opportunities VALUES ('88a5a97c-888b-afa4-41ed-438dfbe45644', '85d51640-ee60-f4ac-e7f3-438dfba2d894', '709024ac-3d9e-e75a-0885-438dfb820403', '2005-11-30 19:27:31', 0);
INSERT INTO accounts_opportunities VALUES ('8cd5b912-c33a-443b-c252-438dfbd07365', '8a042b29-15eb-8c26-a301-438dfb48fe25', '709024ac-3d9e-e75a-0885-438dfb820403', '2005-11-30 19:27:31', 0);
INSERT INTO accounts_opportunities VALUES ('a1719b92-98be-7334-070c-438dfbd090c3', '9e960041-e526-8f23-d4bd-438dfb8950da', '9c5ee206-33e1-c7be-2e44-438dfbcfc3a3', '2005-11-30 19:27:32', 0);
INSERT INTO accounts_opportunities VALUES ('ac0f0717-6a16-d1e0-ab0d-438dfb93a875', 'a931fc94-6526-7c90-cc65-438dfb82de60', '9c5ee206-33e1-c7be-2e44-438dfbcfc3a3', '2005-11-30 19:27:32', 0);
INSERT INTO accounts_opportunities VALUES ('b047a434-0318-12ff-8b4d-438dfb08f759', 'ad6c8d0c-5628-7cbe-f255-438dfbd9f0b9', '9c5ee206-33e1-c7be-2e44-438dfbcfc3a3', '2005-11-30 19:27:32', 0);
INSERT INTO accounts_opportunities VALUES ('b4760163-0386-7877-9862-438dfb1812f9', 'b1a260ac-782c-0c1f-2f29-438dfbe8ad96', '9c5ee206-33e1-c7be-2e44-438dfbcfc3a3', '2005-11-30 19:27:32', 0);
INSERT INTO accounts_opportunities VALUES ('b8a55df2-dad5-72cb-af94-438dfb8f31b0', 'b5d6233a-7792-81d6-1167-438dfb47ebd7', '9c5ee206-33e1-c7be-2e44-438dfbcfc3a3', '2005-11-30 19:27:33', 0);
INSERT INTO accounts_opportunities VALUES ('cd2ce22a-367e-8b48-653b-438dfbae0495', 'ca478b8c-144a-6a8e-793a-438dfbc12544', 'c80dea92-93bd-414c-7d12-438dfbe287a0', '2005-11-30 19:27:33', 0);
INSERT INTO accounts_opportunities VALUES ('de3cef92-bab0-5037-6f78-438dfb14a2c5', 'db5f248b-3e39-d438-b0b4-438dfb58299b', 'c80dea92-93bd-414c-7d12-438dfbe287a0', '2005-11-30 19:27:33', 0);
INSERT INTO accounts_opportunities VALUES ('e272d25b-d968-0493-6030-438dfbce1f6d', 'df9e65f1-4684-1fa8-0e1b-438dfb25fd35', 'c80dea92-93bd-414c-7d12-438dfbe287a0', '2005-11-30 19:27:34', 0);
INSERT INTO accounts_opportunities VALUES ('e6c37a6f-aa09-b237-6aa9-438dfbac07ae', 'e3e267f1-141e-3a5f-a5dd-438dfbd5d9e5', 'c80dea92-93bd-414c-7d12-438dfbe287a0', '2005-11-30 19:27:34', 0);
INSERT INTO accounts_opportunities VALUES ('f15a5cd8-aae4-9afb-6919-438dfb19d170', 'ee8f1d83-b2f0-8311-bafc-438dfb50da8a', 'c80dea92-93bd-414c-7d12-438dfbe287a0', '2005-11-30 19:27:34', 0);
INSERT INTO accounts_opportunities VALUES ('11c35eb8-2783-9bd8-f030-438dfbdf4275', 'eee803c3-2c99-df69-eb89-438dfbc499a3', 'cadd0934-23c0-fc21-697f-438dfbfc60c0', '2005-11-30 19:27:35', 0);
INSERT INTO accounts_opportunities VALUES ('15f74541-157c-566d-e182-438dfbc5a584', '13223e67-27b8-70ea-125c-438dfb02d1c0', 'cadd0934-23c0-fc21-697f-438dfbfc60c0', '2005-11-30 19:27:35', 0);
INSERT INTO accounts_opportunities VALUES ('1a3e0803-ed21-3fcf-373f-438dfb0be38c', '17617ae3-7522-5b97-b517-438dfb28c8e8', 'cadd0934-23c0-fc21-697f-438dfbfc60c0', '2005-11-30 19:27:35', 0);
INSERT INTO accounts_opportunities VALUES ('1e74f5a7-3c3a-1a75-18dc-438dfb66f149', '1b9f3718-7790-2f3a-1383-438dfb179b7b', 'cadd0934-23c0-fc21-697f-438dfbfc60c0', '2005-11-30 19:27:36', 0);
INSERT INTO accounts_opportunities VALUES ('22abcdc2-7a37-39c6-684f-438dfb38dd96', '1fcf13c5-7959-f4df-a9c1-438dfbfc98dd', 'cadd0934-23c0-fc21-697f-438dfbfc60c0', '2005-11-30 19:27:36', 0);
INSERT INTO accounts_opportunities VALUES ('374d6350-a602-bd7c-4c44-438dfbd37a4e', '346fbf56-89f6-4729-e8aa-438dfb8c99b4', '322e401c-c694-0233-da27-438dfb2436c5', '2005-11-30 19:27:37', 0);
INSERT INTO accounts_opportunities VALUES ('3ba1d8fd-4d52-8480-8e9d-438dfb9d3725', '38b8f391-5b5c-3bdc-3867-438dfb3984e7', '322e401c-c694-0233-da27-438dfb2436c5', '2005-11-30 19:27:37', 0);
INSERT INTO accounts_opportunities VALUES ('3fd6aacf-5e28-a179-c312-438dfb4ac731', '3cfccbb1-7758-ceed-0c56-438dfbd66999', '322e401c-c694-0233-da27-438dfb2436c5', '2005-11-30 19:27:37', 0);
INSERT INTO accounts_opportunities VALUES ('440c15e7-8791-2922-4d97-438dfb402b20', '41355cbd-f46c-8487-b7fa-438dfbdf5d76', '322e401c-c694-0233-da27-438dfb2436c5', '2005-11-30 19:27:37', 0);
INSERT INTO accounts_opportunities VALUES ('50d10de4-ba0f-0f20-1639-438dfb4bd819', '4df89589-7dd3-6651-27f0-438dfbd8fb7d', '322e401c-c694-0233-da27-438dfb2436c5', '2005-11-30 19:27:38', 0);
INSERT INTO accounts_opportunities VALUES ('656ef377-397e-a29e-0ba8-438dfbac45dd', '628d2e56-ad54-c60e-3313-438dfb3eeac5', '6052c1a5-b3da-6061-5b1a-438dfbf123ea', '2005-11-30 19:27:38', 0);
INSERT INTO accounts_opportunities VALUES ('69ad119f-3853-1ba6-bf23-438dfbbc9ed8', '66db5351-8df2-b7a9-f0d9-438dfbf2cafc', '6052c1a5-b3da-6061-5b1a-438dfbf123ea', '2005-11-30 19:27:39', 0);
INSERT INTO accounts_opportunities VALUES ('6de626ad-bee9-eb59-48f2-438dfbfda890', '6b076c53-63b2-90d3-db10-438dfb196081', '6052c1a5-b3da-6061-5b1a-438dfbf123ea', '2005-11-30 19:27:39', 0);
INSERT INTO accounts_opportunities VALUES ('72308d33-8256-094a-0fb2-438dfb8382af', '6f56b608-9d80-e897-5ff0-438dfb9321d0', '6052c1a5-b3da-6061-5b1a-438dfbf123ea', '2005-11-30 19:27:39', 0);
INSERT INTO accounts_opportunities VALUES ('765f0fb9-7f50-8fde-b54e-438dfb312e18', '73943c55-420c-6bf6-338b-438dfbca86e1', '6052c1a5-b3da-6061-5b1a-438dfbf123ea', '2005-11-30 19:27:40', 0);
INSERT INTO accounts_opportunities VALUES ('8b9f9cfa-ff68-82d5-09cc-438dfb9022d1', '88cce231-e672-f824-c168-438dfb98b324', '85ee0e3f-0406-f066-bfe7-438dfb3e0803', '2005-11-30 19:27:40', 0);
INSERT INTO accounts_opportunities VALUES ('8fe783ef-9013-59b7-ed74-438dfb88e315', '8d026449-3c59-6836-b5f1-438dfb644eb3', '85ee0e3f-0406-f066-bfe7-438dfb3e0803', '2005-11-30 19:27:40', 0);
INSERT INTO accounts_opportunities VALUES ('943b9981-e214-4875-71c8-438dfb6eb685', '915370e1-e958-c1eb-6fe1-438dfb855298', '85ee0e3f-0406-f066-bfe7-438dfb3e0803', '2005-11-30 19:27:40', 0);
INSERT INTO accounts_opportunities VALUES ('9871ab0b-45b2-854b-544f-438dfb85c7eb', '95a0dbf8-6e4f-10f8-a7b4-438dfb54c9f9', '85ee0e3f-0406-f066-bfe7-438dfb3e0803', '2005-11-30 19:27:41', 0);
INSERT INTO accounts_opportunities VALUES ('a3598a5f-1b77-5163-1aba-438dfb46b106', 'a08435fe-4e57-6aa8-f367-438dfbbd5bab', '85ee0e3f-0406-f066-bfe7-438dfb3e0803', '2005-11-30 19:27:41', 0);
INSERT INTO accounts_opportunities VALUES ('b7ddf25a-bd0d-70b2-38a5-438dfbcb09da', 'b4fa3117-853c-7fca-71e5-438dfbc9c25d', 'b2bfa84e-a0ac-6463-92be-438dfbaed94a', '2005-11-30 19:27:41', 0);
INSERT INTO accounts_opportunities VALUES ('bc0f9b5f-483f-8422-6031-438dfb8d24aa', 'b93f550e-91ba-1083-6c9a-438dfbde9e52', 'b2bfa84e-a0ac-6463-92be-438dfbaed94a', '2005-11-30 19:27:42', 0);
INSERT INTO accounts_opportunities VALUES ('c052b0c5-5bd6-582f-57cd-438dfb5c469b', 'bd79bbfc-4ee4-2598-01e4-438dfb916374', 'b2bfa84e-a0ac-6463-92be-438dfbaed94a', '2005-11-30 19:27:42', 0);
INSERT INTO accounts_opportunities VALUES ('c492b3c8-ef65-9ffb-3a1e-438dfb6d3f5f', 'c1bba82c-7836-4c7a-b91b-438dfb72b369', 'b2bfa84e-a0ac-6463-92be-438dfbaed94a', '2005-11-30 19:27:42', 0);
INSERT INTO accounts_opportunities VALUES ('c8c346b5-dec5-f118-cca8-438dfbebae02', 'c5ed4400-85f3-69e4-c757-438dfb7540ce', 'b2bfa84e-a0ac-6463-92be-438dfbaed94a', '2005-11-30 19:27:43', 0);
INSERT INTO accounts_opportunities VALUES ('dd9305fd-44c9-2b16-764a-438dfb2522d6', 'da9c2e71-89d1-6bc1-b2cf-438dfbda5fd8', 'd84cc26b-f46c-10fd-4f62-438dfb4edfa7', '2005-11-30 19:27:43', 0);
INSERT INTO accounts_opportunities VALUES ('efaa1d2c-815e-ff41-6fc8-438dfb8705ea', 'ecb46404-fb52-68a2-6148-438dfb435999', 'd84cc26b-f46c-10fd-4f62-438dfb4edfa7', '2005-11-30 19:27:43', 0);
INSERT INTO accounts_opportunities VALUES ('f3e74820-7f67-3722-2ada-438dfb942244', 'f108e674-6996-c5fa-a48a-438dfb69affa', 'd84cc26b-f46c-10fd-4f62-438dfb4edfa7', '2005-11-30 19:27:43', 0);
INSERT INTO accounts_opportunities VALUES ('4072045b-f64f-3007-8c91-438dfb5fd0e4', '122a0ebb-d20c-f684-a603-438dfb04c76b', 'd84cc26b-f46c-10fd-4f62-438dfb4edfa7', '2005-11-30 19:27:44', 0);
INSERT INTO accounts_opportunities VALUES ('85f40358-c497-fc07-fc67-438dfbda393f', '577f0e5a-8ed1-e3ea-82d6-438dfbfb55fb', 'd84cc26b-f46c-10fd-4f62-438dfb4edfa7', '2005-11-30 19:27:44', 0);
INSERT INTO accounts_opportunities VALUES ('243cd36b-1a91-b7c4-c2a6-438dfbeb5d55', '213d4769-4ae5-6b0c-dd74-438dfb896d23', '1ef0046a-4960-119d-3483-438dfb613ed1', '2005-11-30 19:27:44', 0);
INSERT INTO accounts_opportunities VALUES ('289750e9-5707-5e92-7921-438dfbdb5244', '25ae7137-4075-1787-af84-438dfb92b8e9', '1ef0046a-4960-119d-3483-438dfb613ed1', '2005-11-30 19:27:45', 0);
INSERT INTO accounts_opportunities VALUES ('2cd3427d-9449-1473-d015-438dfb2c4735', '29f4aaa6-b1a0-e4b5-517e-438dfb9d3e73', '1ef0046a-4960-119d-3483-438dfb613ed1', '2005-11-30 19:27:45', 0);
INSERT INTO accounts_opportunities VALUES ('31228925-8946-975a-dae2-438dfbb153cb', '2e37dec5-d6e6-534b-d496-438dfbf93c40', '1ef0046a-4960-119d-3483-438dfb613ed1', '2005-11-30 19:27:45', 0);
INSERT INTO accounts_opportunities VALUES ('356eae98-0fdd-f097-25b2-438dfb1104d1', '3295f9eb-c9f4-070d-6d36-438dfbd6a953', '1ef0046a-4960-119d-3483-438dfb613ed1', '2005-11-30 19:27:46', 0);
INSERT INTO accounts_opportunities VALUES ('59f4450e-4f86-b369-5ad8-438dfbd9ac00', '571573f5-bb22-be5f-68be-438dfbd317b6', '54cfcff9-db3f-3b0d-be97-438dfbe302c0', '2005-11-30 19:27:46', 0);
INSERT INTO accounts_opportunities VALUES ('5fadd800-0c2e-7236-9de3-438dfb52b9e4', '5cd61a59-8417-d484-5b3e-438dfb25988d', '54cfcff9-db3f-3b0d-be97-438dfbe302c0', '2005-11-30 19:27:46', 0);
INSERT INTO accounts_opportunities VALUES ('63fb5ce8-21f9-f78e-6e45-438dfb127630', '611b173e-ca9b-cd7a-7681-438dfb2f7ae1', '54cfcff9-db3f-3b0d-be97-438dfbe302c0', '2005-11-30 19:27:47', 0);
INSERT INTO accounts_opportunities VALUES ('684892ad-1412-5f7d-aac0-438dfb9da1e0', '6569e6cf-a0d6-6f77-5ffc-438dfb81fbe5', '54cfcff9-db3f-3b0d-be97-438dfbe302c0', '2005-11-30 19:27:47', 0);
INSERT INTO accounts_opportunities VALUES ('73b668a5-d372-3509-d26a-438dfb146e20', '70da632e-7e63-ca8b-df22-438dfb9eab49', '54cfcff9-db3f-3b0d-be97-438dfbe302c0', '2005-11-30 19:27:47', 0);
INSERT INTO accounts_opportunities VALUES ('88455f31-6b0c-b6ed-5733-438dfb576dbe', '8566bd97-0afd-10d4-137a-438dfb95871e', '8327ec22-ad12-cd30-c238-438dfb0571e1', '2005-11-30 19:27:48', 0);
INSERT INTO accounts_opportunities VALUES ('93a47ef3-f009-f254-a55b-438dfb64b99a', '90bd3ef4-fcdd-5d26-8edc-438dfb428c36', '8327ec22-ad12-cd30-c238-438dfb0571e1', '2005-11-30 19:27:48', 0);
INSERT INTO accounts_opportunities VALUES ('97e54d0b-294e-bffc-024f-438dfb1aa6ae', '9505024a-a881-82d5-0208-438dfb4f8466', '8327ec22-ad12-cd30-c238-438dfb0571e1', '2005-11-30 19:27:48', 0);
INSERT INTO accounts_opportunities VALUES ('9c1ed8c9-d889-aed1-9802-438dfb773cf4', '9949ce7a-0319-fce7-9662-438dfb010c80', '8327ec22-ad12-cd30-c238-438dfb0571e1', '2005-11-30 19:27:48', 0);
INSERT INTO accounts_opportunities VALUES ('a051272e-5734-5cc3-63c2-438dfb336e6d', '9d81d5ef-e868-acc4-0043-438dfb69c7ee', '8327ec22-ad12-cd30-c238-438dfb0571e1', '2005-11-30 19:27:49', 0);
INSERT INTO accounts_opportunities VALUES ('b4e007f1-be00-ad14-3c57-438dfbf74497', 'b2048354-d7a0-786d-f01e-438dfb64c787', 'afc2a69b-8290-5e45-403f-438dfbb1b556', '2005-11-30 19:27:49', 0);
INSERT INTO accounts_opportunities VALUES ('b91ea239-834e-c2d0-120c-438dfbb7007b', 'b6445915-5efc-aa47-7c3a-438dfb8d8c9a', 'afc2a69b-8290-5e45-403f-438dfbb1b556', '2005-11-30 19:27:49', 0);
INSERT INTO accounts_opportunities VALUES ('bd66a9d1-4760-4927-df8c-438dfbff33fd', 'ba875b99-6770-be1c-0aa2-438dfb006643', 'afc2a69b-8290-5e45-403f-438dfbb1b556', '2005-11-30 19:27:50', 0);
INSERT INTO accounts_opportunities VALUES ('c1990bfa-3f15-2ca0-d73c-438dfbb5eaf8', 'bec7e542-9d4f-a077-21bf-438dfbbed6c4', 'afc2a69b-8290-5e45-403f-438dfbb1b556', '2005-11-30 19:27:50', 0);
INSERT INTO accounts_opportunities VALUES ('c5d82012-748a-26a0-5d56-438dfb676af5', 'c2fe2096-242f-a076-7a7e-438dfb7f3db6', 'afc2a69b-8290-5e45-403f-438dfbb1b556', '2005-11-30 19:27:51', 0);
INSERT INTO accounts_opportunities VALUES ('da971383-a58d-8412-087f-438dfb3658e1', 'd7b33ecc-3de7-d1d4-4eb0-438dfbe61e29', 'd5753872-c4a2-ab13-81c2-438dfbae0c3a', '2005-11-30 19:27:51', 0);
INSERT INTO accounts_opportunities VALUES ('e603ec29-3338-72b6-c2dc-438dfbdd1c2a', 'e31d5b01-c7a8-1785-8296-438dfbe6e019', 'd5753872-c4a2-ab13-81c2-438dfbae0c3a', '2005-11-30 19:27:51', 0);
INSERT INTO accounts_opportunities VALUES ('ea419d56-fd0f-4e46-7c39-438dfb236ccc', 'e765ca6d-c930-5939-106d-438dfb2e06da', 'd5753872-c4a2-ab13-81c2-438dfbae0c3a', '2005-11-30 19:27:52', 0);
INSERT INTO accounts_opportunities VALUES ('ee7ba34f-43d7-568d-6de8-438dfb33936b', 'ebad2471-81d2-b023-4b05-438dfb4ace2e', 'd5753872-c4a2-ab13-81c2-438dfbae0c3a', '2005-11-30 19:27:52', 0);
INSERT INTO accounts_opportunities VALUES ('ceea0d88-c9d4-550e-54bc-438dfbad77b9', 'a168079e-0368-a0b9-c046-438dfbdb939c', 'd5753872-c4a2-ab13-81c2-438dfbae0c3a', '2005-11-30 19:27:52', 0);
INSERT INTO accounts_opportunities VALUES ('2185e542-15c1-7919-5280-438dfbdc8a2d', '1eb1d0fa-e2d9-2a21-683d-438dfbf8930f', '1c670ba7-7180-c746-7a2e-438dfb331ea2', '2005-11-30 19:27:53', 0);
INSERT INTO accounts_opportunities VALUES ('25ccdbf2-1b8e-1b93-6c3c-438dfbb0a068', '22ed67d4-8a82-7b3d-c30a-438dfbb83942', '1c670ba7-7180-c746-7a2e-438dfb331ea2', '2005-11-30 19:27:54', 0);
INSERT INTO accounts_opportunities VALUES ('2a18a4ab-5445-d5fc-7f6a-438dfba6e214', '272eb885-4746-d21f-671c-438dfba58c40', '1c670ba7-7180-c746-7a2e-438dfb331ea2', '2005-11-30 19:27:54', 0);
INSERT INTO accounts_opportunities VALUES ('3cf1028d-6dbe-8a76-a89f-438dfbbde7c1', '3a18ba6d-41fe-ea45-6205-438dfb202737', '1c670ba7-7180-c746-7a2e-438dfb331ea2', '2005-11-30 19:27:54', 0);
INSERT INTO accounts_opportunities VALUES ('4136bf42-a195-a2df-5162-438dfb638163', '3e4fc033-e47d-1f51-aba9-438dfb62877e', '1c670ba7-7180-c746-7a2e-438dfb331ea2', '2005-11-30 19:27:55', 0);
INSERT INTO accounts_opportunities VALUES ('57ef8ee5-7207-3412-f8ac-438dfbc5f44b', '550cc408-4a40-ee64-af1d-438dfba940e8', '52c17774-4f45-6c9b-31b1-438dfb100ff3', '2005-11-30 19:27:55', 0);
INSERT INTO accounts_opportunities VALUES ('5c2c47db-3669-3e4c-f23a-438dfbdf7cc1', '595b9005-e616-1158-514f-438dfb13981c', '52c17774-4f45-6c9b-31b1-438dfb100ff3', '2005-11-30 19:27:56', 0);
INSERT INTO accounts_opportunities VALUES ('607c33e0-eb99-8218-12e8-438dfbb43286', '5d88850a-909d-811d-1d3b-438dfbb5c652', '52c17774-4f45-6c9b-31b1-438dfb100ff3', '2005-11-30 19:27:56', 0);
INSERT INTO accounts_opportunities VALUES ('64b6d5f2-a1a4-1415-aae9-438dfba248bd', '61e498ea-eb48-3a4f-8cfb-438dfb253513', '52c17774-4f45-6c9b-31b1-438dfb100ff3', '2005-11-30 19:27:57', 0);
INSERT INTO accounts_opportunities VALUES ('68f0828e-d0e1-247d-3bbf-438dfb488605', '661ea93e-fc38-9f45-8b42-438dfbdbf357', '52c17774-4f45-6c9b-31b1-438dfb100ff3', '2005-11-30 19:27:57', 0);
INSERT INTO accounts_opportunities VALUES ('7decf1f0-a04c-d0b7-245d-438dfb0426d3', '7b0c1d4c-9d5a-635a-27c9-438dfbe0234c', '78c4ec52-4f79-ce55-3a17-438dfb858894', '2005-11-30 19:27:57', 0);
INSERT INTO accounts_opportunities VALUES ('8985c92c-ca96-002b-00cb-438dfbb92bcd', '86a66a07-a503-0b86-d6e4-438dfb220930', '78c4ec52-4f79-ce55-3a17-438dfb858894', '2005-11-30 19:27:58', 0);
INSERT INTO accounts_opportunities VALUES ('8dc0f8fa-eb43-4f22-b88f-438dfbb590f2', '8af4601a-005f-ad52-95a4-438dfb2a50b3', '78c4ec52-4f79-ce55-3a17-438dfb858894', '2005-11-30 19:27:58', 0);
INSERT INTO accounts_opportunities VALUES ('91fb714e-67d5-e8b6-2487-438dfb883235', '8f2239d0-4ac2-618e-e810-438dfbe8faf0', '78c4ec52-4f79-ce55-3a17-438dfb858894', '2005-11-30 19:27:59', 0);
INSERT INTO accounts_opportunities VALUES ('9da56442-7262-fdd4-8646-438dfba9680d', '9ac2da09-6d69-cd38-9683-438dfb34ac64', '78c4ec52-4f79-ce55-3a17-438dfb858894', '2005-11-30 19:27:59', 0);
INSERT INTO accounts_opportunities VALUES ('b23242f7-abc7-0368-f831-438dfb588d2b', 'af57ac54-60f9-7084-3ba1-438dfb2e7849', 'ad155aa3-a8e4-85f8-3f49-438dfb1b1044', '2005-11-30 19:27:59', 0);
INSERT INTO accounts_opportunities VALUES ('b66eb1c8-4086-4b57-c641-438dfb7d6f8c', 'b39babda-d601-6436-84a3-438dfb10e1dc', 'ad155aa3-a8e4-85f8-3f49-438dfb1b1044', '2005-11-30 19:28:00', 0);
INSERT INTO accounts_opportunities VALUES ('baa3b096-6d90-366f-d48b-438dfb3ca979', 'b7d0ed2a-bad5-d4aa-eff9-438dfb51f2d2', 'ad155aa3-a8e4-85f8-3f49-438dfb1b1044', '2005-11-30 19:28:00', 0);
INSERT INTO accounts_opportunities VALUES ('bee0093f-5069-e074-78cf-438dfb57cc7c', 'bc0865a7-ba44-6b90-1638-438dfb2c8a38', 'ad155aa3-a8e4-85f8-3f49-438dfb1b1044', '2005-11-30 19:28:00', 0);
INSERT INTO accounts_opportunities VALUES ('cabc6b17-0941-f979-3004-438dfbe6925e', 'c7c58226-0f3e-5b37-d7c6-438dfbf15b92', 'ad155aa3-a8e4-85f8-3f49-438dfb1b1044', '2005-11-30 19:28:01', 0);
INSERT INTO accounts_opportunities VALUES ('e05f1a83-c9ed-da36-f9dd-438dfb2f715a', 'dd5e2f7d-02b9-3af4-e430-438dfb3971b8', 'db14c64c-910d-69f7-4363-438dfb060df3', '2005-11-30 19:28:01', 0);
INSERT INTO accounts_opportunities VALUES ('e4ea5a9d-7a97-b7bd-f41f-438dfbf3be05', 'e1c6c996-f162-8f10-9534-438dfb312ea3', 'db14c64c-910d-69f7-4363-438dfb060df3', '2005-11-30 19:28:02', 0);
INSERT INTO accounts_opportunities VALUES ('e943edd4-7bc8-e54d-72a1-438dfba9f8ff', 'e652e707-a2ea-7efe-e290-438dfbdcac15', 'db14c64c-910d-69f7-4363-438dfb060df3', '2005-11-30 19:28:02', 0);
INSERT INTO accounts_opportunities VALUES ('eda1dd98-eae4-0521-6f3b-438dfb89813a', 'eab1b37a-1e82-a5d7-3ccf-438dfbada238', 'db14c64c-910d-69f7-4363-438dfb060df3', '2005-11-30 19:28:02', 0);
INSERT INTO accounts_opportunities VALUES ('f207856f-facc-5eff-83c5-438dfbb52ac4', 'ef12ed9c-ed58-7558-c957-438dfbfab0de', 'db14c64c-910d-69f7-4363-438dfb060df3', '2005-11-30 19:28:03', 0);
INSERT INTO accounts_opportunities VALUES ('1359dbc5-251e-6776-6f40-438dfbdf298e', '10637bce-6c07-f91b-b1da-438dfbdc343a', 'e0b30a6a-2d97-08a9-b773-438dfb91ae00', '2005-11-30 19:28:03', 0);
INSERT INTO accounts_opportunities VALUES ('17d2741e-0594-4405-de0b-438dfbe20986', '14d16117-5adb-d52a-fac0-438dfb166825', 'e0b30a6a-2d97-08a9-b773-438dfb91ae00', '2005-11-30 19:28:03', 0);
INSERT INTO accounts_opportunities VALUES ('1c475057-2a98-e39f-6e06-438dfbe239d5', '19430bd1-e580-ec44-4db7-438dfb249a5c', 'e0b30a6a-2d97-08a9-b773-438dfb91ae00', '2005-11-30 19:28:03', 0);
INSERT INTO accounts_opportunities VALUES ('2feae558-4f24-39b8-ae53-438dfb88482c', '2cd67c9d-cbfe-1931-ab55-438dfbf5a4ac', 'e0b30a6a-2d97-08a9-b773-438dfb91ae00', '2005-11-30 19:28:04', 0);
INSERT INTO accounts_opportunities VALUES ('34590ab8-4aad-1cd5-8b1a-438dfbd66e96', '3153925b-f2f3-3731-1453-438dfbfe0f79', 'e0b30a6a-2d97-08a9-b773-438dfb91ae00', '2005-11-30 19:28:04', 0);
INSERT INTO accounts_opportunities VALUES ('4bb114e3-0b59-e7f5-ac70-438dfb38661f', '48c4ec5f-f2ff-1b7a-c8ca-438dfbaf49a2', '44499ff2-512d-c664-957c-438dfbce7e97', '2005-11-30 19:28:04', 0);
INSERT INTO accounts_opportunities VALUES ('4ff95939-ea49-9733-492b-438dfb1dc1db', '4d1650b4-1dc9-1d91-8193-438dfbbb855f', '44499ff2-512d-c664-957c-438dfbce7e97', '2005-11-30 19:28:05', 0);
INSERT INTO accounts_opportunities VALUES ('5446393f-8db8-5d0e-d54e-438dfb226f69', '515caf48-7b97-6ff7-e01e-438dfb58c978', '44499ff2-512d-c664-957c-438dfbce7e97', '2005-11-30 19:28:05', 0);
INSERT INTO accounts_opportunities VALUES ('6044055e-e161-0c2f-45d2-438dfbfeaf6f', '5d57572c-0744-c122-94d3-438dfb16113a', '44499ff2-512d-c664-957c-438dfbce7e97', '2005-11-30 19:28:05', 0);
INSERT INTO accounts_opportunities VALUES ('64763296-400e-1c78-350d-438dfb49b828', '61a80aa3-d0a9-40f5-e34b-438dfb8ff36c', '44499ff2-512d-c664-957c-438dfbce7e97', '2005-11-30 19:28:06', 0);
INSERT INTO accounts_opportunities VALUES ('7926c6a7-5492-6a2f-30b9-438dfbe86f60', '76484450-6d56-96c9-90af-438dfb71b846', '73f7b9c1-cae3-d662-c9aa-438dfb346e05', '2005-11-30 19:28:06', 0);
INSERT INTO accounts_opportunities VALUES ('852192e3-5cde-8c3e-6e1d-438dfb665cea', '8243b2d6-369e-4b57-f419-438dfb94af1b', '73f7b9c1-cae3-d662-c9aa-438dfb346e05', '2005-11-30 19:28:06', 0);
INSERT INTO accounts_opportunities VALUES ('896c6a00-2ea3-8c1f-7383-438dfb9627f4', '868c90de-e07b-1f90-5a97-438dfb45ee73', '73f7b9c1-cae3-d662-c9aa-438dfb346e05', '2005-11-30 19:28:06', 0);
INSERT INTO accounts_opportunities VALUES ('8da57b4a-87d3-db73-d421-438dfbb9b4b4', '8aceed1c-5c76-59ec-f3f1-438dfbf2dc7d', '73f7b9c1-cae3-d662-c9aa-438dfb346e05', '2005-11-30 19:28:07', 0);
INSERT INTO accounts_opportunities VALUES ('91d91b60-bc95-8876-5d22-438dfb1a78a1', '8efe4ddf-f965-205a-8705-438dfbcdc3a5', '73f7b9c1-cae3-d662-c9aa-438dfb346e05', '2005-11-30 19:28:07', 0);
INSERT INTO accounts_opportunities VALUES ('a6729468-b692-2537-2a8e-438dfb77c932', 'a397c231-b0cf-47c9-0c2d-438dfb5e25a0', 'a15828e0-e941-7e5e-6f3f-438dfb062b99', '2005-11-30 19:28:08', 0);
INSERT INTO accounts_opportunities VALUES ('aab29392-b1f7-cdb2-f451-438dfbad04fb', 'a7d87ec7-ba06-e130-534b-438dfb84f806', 'a15828e0-e941-7e5e-6f3f-438dfb062b99', '2005-11-30 19:28:08', 0);
INSERT INTO accounts_opportunities VALUES ('b6b384ab-b97a-16dc-4445-438dfb389884', 'b3dd2bcd-e859-aed4-7495-438dfb4fdbf4', 'a15828e0-e941-7e5e-6f3f-438dfb062b99', '2005-11-30 19:28:09', 0);
INSERT INTO accounts_opportunities VALUES ('bae65ac7-4f72-fc86-2736-438dfb8c3c4f', 'b812d15b-14e3-3eda-ba5a-438dfb8ab7b6', 'a15828e0-e941-7e5e-6f3f-438dfb062b99', '2005-11-30 19:28:09', 0);
INSERT INTO accounts_opportunities VALUES ('bf1d5579-ed6d-6824-17c6-438dfbdb3096', 'bc49fb0c-dcdc-10f4-cefc-438dfbcd49e8', 'a15828e0-e941-7e5e-6f3f-438dfb062b99', '2005-11-30 19:28:09', 0);
INSERT INTO accounts_opportunities VALUES ('db77bd98-61e7-28e9-10be-438dfb6a3b1e', 'd88f4492-2540-a615-43ad-438dfb1846af', 'd6531f8e-d33a-e2e4-7955-438dfb4d05f0', '2005-11-30 19:28:10', 0);
INSERT INTO accounts_opportunities VALUES ('dfae5ab2-0a07-6143-ee3e-438dfb2a70aa', 'dcd97378-88e1-2a71-312a-438dfb24d4e5', 'd6531f8e-d33a-e2e4-7955-438dfb4d05f0', '2005-11-30 19:28:10', 0);
INSERT INTO accounts_opportunities VALUES ('e3f54d7b-4524-b666-83fc-438dfbbae744', 'e113136a-967f-bf05-0ab6-438dfb72f78b', 'd6531f8e-d33a-e2e4-7955-438dfb4d05f0', '2005-11-30 19:28:10', 0);
INSERT INTO accounts_opportunities VALUES ('e82f8ca7-81a8-7e95-8de0-438dfb053750', 'e5578bdb-54bf-b68c-d40f-438dfb7becd4', 'd6531f8e-d33a-e2e4-7955-438dfb4d05f0', '2005-11-30 19:28:11', 0);
INSERT INTO accounts_opportunities VALUES ('ec5b162b-f1e1-5d87-cf9a-438dfbc80570', 'e98df231-21c8-60dd-c14e-438dfb36d151', 'd6531f8e-d33a-e2e4-7955-438dfb4d05f0', '2005-11-30 19:28:11', 0);
INSERT INTO accounts_opportunities VALUES ('cc760cac-e898-1efb-cf7b-438dfbb60eac', '9f320ae9-6cbb-cde9-adec-438dfbaf5bd9', '7ade03c1-f61f-b9f9-aa17-438dfb9a7bab', '2005-11-30 19:28:11', 0);
INSERT INTO accounts_opportunities VALUES ('10fe4561-5059-4105-a3c6-438dfb01af71', 'e2b40127-485e-77d4-c940-438dfb8ae303', '7ade03c1-f61f-b9f9-aa17-438dfb9a7bab', '2005-11-30 19:28:12', 0);
INSERT INTO accounts_opportunities VALUES ('153f31d4-e9c5-991c-e6e5-438dfb510a96', '125dfe58-e0a8-b81b-97d1-438dfb996e12', '7ade03c1-f61f-b9f9-aa17-438dfb9a7bab', '2005-11-30 19:28:12', 0);
INSERT INTO accounts_opportunities VALUES ('1998ac4b-bfeb-7ebd-9a9e-438dfbed75bc', '16a0f284-e1bc-4270-0983-438dfb6db234', '7ade03c1-f61f-b9f9-aa17-438dfb9a7bab', '2005-11-30 19:28:13', 0);
INSERT INTO accounts_opportunities VALUES ('1dce565b-c9b6-584a-2b7d-438dfbbc6a8d', '1af83e11-1eb3-9d23-6f26-438dfbd8cfb5', '7ade03c1-f61f-b9f9-aa17-438dfb9a7bab', '2005-11-30 19:28:13', 0);
INSERT INTO accounts_opportunities VALUES ('3a86abed-faf3-e89e-2e63-438dfbb218aa', '37b0aca8-c215-53e7-ad67-438dfb16fdf0', '356ecfc0-140f-77b6-2121-438dfbc3c55d', '2005-11-30 19:28:13', 0);
INSERT INTO accounts_opportunities VALUES ('3ecad0f4-0cc4-9884-5be8-438dfbcfd12f', '3be7034f-ee34-3dcb-6b5d-438dfb011f4b', '356ecfc0-140f-77b6-2121-438dfbc3c55d', '2005-11-30 19:28:13', 0);
INSERT INTO accounts_opportunities VALUES ('43025df2-b04a-9ddf-3fa8-438dfb51e8f1', '40303f9e-dd84-4763-918f-438dfb919c34', '356ecfc0-140f-77b6-2121-438dfbc3c55d', '2005-11-30 19:28:14', 0);
INSERT INTO accounts_opportunities VALUES ('491ac4b8-9214-ab8c-380c-438dfbebc881', '446aadde-e03e-8b82-365d-438dfba4166c', '356ecfc0-140f-77b6-2121-438dfbc3c55d', '2005-11-30 19:28:14', 0);
INSERT INTO accounts_opportunities VALUES ('4d793993-d991-ab42-b838-438dfbc6193d', '4aa8d8c0-1cb5-e654-80a9-438dfb781c68', '356ecfc0-140f-77b6-2121-438dfbc3c55d', '2005-11-30 19:28:15', 0);
INSERT INTO accounts_opportunities VALUES ('6244c6e1-2bd0-6b2b-c177-438dfbe1855a', '5f57f37b-197f-b947-f7e4-438dfbc942bb', '5d13a786-5be5-de7f-dd0c-438dfbf14353', '2005-11-30 19:28:15', 0);
INSERT INTO accounts_opportunities VALUES ('667e9bac-5d8b-91a1-4213-438dfb638a45', '63a80a86-61bd-504c-cf3e-438dfb09bab9', '5d13a786-5be5-de7f-dd0c-438dfbf14353', '2005-11-30 19:28:15', 0);
INSERT INTO accounts_opportunities VALUES ('6ad18620-58f3-4227-80c6-438dfbedd495', '67daf1de-ba73-c12d-db71-438dfbeadccc', '5d13a786-5be5-de7f-dd0c-438dfbf14353', '2005-11-30 19:28:16', 0);
INSERT INTO accounts_opportunities VALUES ('6f0f3df9-2bde-14a2-d1e2-438dfbe4a316', '6c40d279-e6de-8de4-c1bd-438dfb3faa02', '5d13a786-5be5-de7f-dd0c-438dfbf14353', '2005-11-30 19:28:16', 0);
INSERT INTO accounts_opportunities VALUES ('733d4eaa-9383-cfde-f213-438dfb1983ba', '70715c59-45a9-c8db-f3db-438dfbce08f7', '5d13a786-5be5-de7f-dd0c-438dfbf14353', '2005-11-30 19:28:16', 0);
INSERT INTO accounts_opportunities VALUES ('87eea3e7-90b4-2b2b-dbc8-438dfbbf9b34', '851abc1d-ce24-f9e1-24c3-438dfb9f3493', '82d95c21-6a10-9582-5b3d-438dfbf0a156', '2005-11-30 19:28:17', 0);
INSERT INTO accounts_opportunities VALUES ('945c29a5-0c23-407c-bbe2-438dfb2820c8', '916d8e6d-1812-48c4-473b-438dfb12b35a', '82d95c21-6a10-9582-5b3d-438dfbf0a156', '2005-11-30 19:28:17', 0);
INSERT INTO accounts_opportunities VALUES ('9897c645-46a3-c95e-e288-438dfbf4a88f', '95bd0b3a-00a3-72c2-b2d9-438dfbc0907d', '82d95c21-6a10-9582-5b3d-438dfbf0a156', '2005-11-30 19:28:17', 0);
INSERT INTO accounts_opportunities VALUES ('9cd281f4-6d1e-c019-305c-438dfb15a82c', '9a05b175-92de-de44-e752-438dfb8c0083', '82d95c21-6a10-9582-5b3d-438dfbf0a156', '2005-11-30 19:28:18', 0);
INSERT INTO accounts_opportunities VALUES ('a0fd30fb-8841-43fd-4a92-438dfb59a3d8', '9e2d479d-bdbb-bf96-605a-438dfb5377d0', '82d95c21-6a10-9582-5b3d-438dfbf0a156', '2005-11-30 19:28:18', 0);
INSERT INTO accounts_opportunities VALUES ('c60b10f3-39be-fdb0-b8de-438dfb08afa6', 'c3367856-a755-f9b4-9799-438dfbb3a65a', 'c0f35cdd-896f-1ffe-f8f0-438dfb2e3c96', '2005-11-30 19:28:19', 0);
INSERT INTO accounts_opportunities VALUES ('d2798ec8-dd5d-69b7-738c-438dfbd9b1fe', 'cf97df3e-3866-2533-7859-438dfbae62d4', 'c0f35cdd-896f-1ffe-f8f0-438dfb2e3c96', '2005-11-30 19:28:19', 0);
INSERT INTO accounts_opportunities VALUES ('d6f53719-01f0-dece-8d88-438dfbc8f04f', 'd41a8b3b-67a4-dca0-5459-438dfb0b289f', 'c0f35cdd-896f-1ffe-f8f0-438dfb2e3c96', '2005-11-30 19:28:20', 0);
INSERT INTO accounts_opportunities VALUES ('db3082a7-f5b6-ba40-89bd-438dfbbd1bf1', 'd85b5609-57d5-37a4-b04f-438dfbd52e19', 'c0f35cdd-896f-1ffe-f8f0-438dfb2e3c96', '2005-11-30 19:28:20', 0);
INSERT INTO accounts_opportunities VALUES ('e7b257bb-79f2-57e1-b615-438dfb1c2fd7', 'dc97eee9-dd63-92ec-1ff4-438dfbd1fdf0', 'c0f35cdd-896f-1ffe-f8f0-438dfb2e3c96', '2005-11-30 19:28:21', 0);
INSERT INTO accounts_opportunities VALUES ('18bf44ec-0d5f-1c1c-71a8-438dfb5d9d3e', '15b9c39f-be49-4d50-f94f-438dfb9df55e', '137e9f95-f313-8360-f71c-438dfb599270', '2005-11-30 19:28:21', 0);
INSERT INTO accounts_opportunities VALUES ('1cf676df-3bfa-9b46-bcfc-438dfb6a372f', '1a211c97-838a-513a-f9c7-438dfb65c2f5', '137e9f95-f313-8360-f71c-438dfb599270', '2005-11-30 19:28:21', 0);
INSERT INTO accounts_opportunities VALUES ('212f9619-be04-7042-aa5d-438dfbee0470', '1e54c3f3-fe2b-5314-1db0-438dfb255e86', '137e9f95-f313-8360-f71c-438dfb599270', '2005-11-30 19:28:22', 0);
INSERT INTO accounts_opportunities VALUES ('361b89a8-5c4b-cd4e-c8e5-438dfbfcb9a8', '3338589f-d5bc-1771-06c3-438dfb321b14', '137e9f95-f313-8360-f71c-438dfb599270', '2005-11-30 19:28:22', 0);
INSERT INTO accounts_opportunities VALUES ('42893057-48ef-b692-f8da-438dfbd9f457', '3fb6701d-d759-65fa-ab31-438dfbc14aee', '137e9f95-f313-8360-f71c-438dfb599270', '2005-11-30 19:28:22', 0);
INSERT INTO accounts_opportunities VALUES ('59c1f6da-00d9-e4e2-8987-438dfb6fbd6e', '56e43da4-2a63-8c22-8da4-438dfb1dc8c0', '548525fc-1d16-2812-5072-438dfbaafd50', '2005-11-30 19:28:22', 0);
INSERT INTO accounts_opportunities VALUES ('5e01baf7-3d5d-ffb6-bd68-438dfbf0691b', '5b2924ee-e1c6-ccce-9f93-438dfba687f5', '548525fc-1d16-2812-5072-438dfbaafd50', '2005-11-30 19:28:23', 0);
INSERT INTO accounts_opportunities VALUES ('624543ea-2703-f993-9fbe-438dfb9d2082', '5f687294-9a27-c353-e829-438dfbdc1d78', '548525fc-1d16-2812-5072-438dfbaafd50', '2005-11-30 19:28:23', 0);
INSERT INTO accounts_opportunities VALUES ('66875c36-2f66-1903-6d22-438dfbe8ff49', '63a1b897-e890-7eb4-5b17-438dfb9b07c0', '548525fc-1d16-2812-5072-438dfbaafd50', '2005-11-30 19:28:23', 0);
INSERT INTO accounts_opportunities VALUES ('6ab483b0-e912-3ade-9993-438dfbbb9f2b', '67e3e2b9-3823-c240-ad44-438dfb865204', '548525fc-1d16-2812-5072-438dfbaafd50', '2005-11-30 19:28:24', 0);
INSERT INTO accounts_opportunities VALUES ('7f57f427-f1ba-04c0-6563-438dfb6944dd', '7c7b94ca-070b-e28b-7671-438dfbf5c05e', '7a3171f6-d717-19aa-5933-438dfbda3f5d', '2005-11-30 19:28:24', 0);
INSERT INTO accounts_opportunities VALUES ('8bf7b195-768a-84af-0251-438dfb8862ff', '891fa6b6-8978-58a6-0f2e-438dfbf1be05', '7a3171f6-d717-19aa-5933-438dfbda3f5d', '2005-11-30 19:28:24', 0);
INSERT INTO accounts_opportunities VALUES ('902849d0-1a4d-3af4-be40-438dfb872e2b', '8d5763ca-4b51-07e5-3283-438dfb7c38b1', '7a3171f6-d717-19aa-5933-438dfbda3f5d', '2005-11-30 19:28:25', 0);
INSERT INTO accounts_opportunities VALUES ('94750f40-eb54-9348-fa9b-438dfb1f5e8c', '91930181-de5d-8857-1263-438dfb6de21f', '7a3171f6-d717-19aa-5933-438dfbda3f5d', '2005-11-30 19:28:25', 0);
INSERT INTO accounts_opportunities VALUES ('98b33997-9645-7921-8976-438dfb4c4725', '95de709b-2a03-1f96-10b0-438dfba72e13', '7a3171f6-d717-19aa-5933-438dfbda3f5d', '2005-11-30 19:28:25', 0);
INSERT INTO accounts_opportunities VALUES ('ad4b89c0-91fa-2e0f-ac88-438dfb016992', 'aa64b4b0-1d