/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.war.cascade;

import java.util.List;
import com.jaspersoft.jasperserver.war.cascade.cache.*;

/**
 * ControlLogic
 * @author jwhang
 * @version $Id: ControlLogic.java 19932 2010-12-11 15:24:29Z tmatyashovsky $
 * Interface implemented for use by anyone creating custom business rules.
 */

public interface ControlLogic {

    /**
     * Initialize is called when the parameter input page first loads.
     * @param reportUri  the fully qualified repository URI of the report being invoked.
     * @param envelopes  a list containing the current state of the input controls.
     * @param cache  generic caching functionality passed in by the delegator.
     * @return  a list of envelopes describing the new state of the input controls.
     */
    public List<EventEnvelope> initialize(String reportUri, List<EventEnvelope> envelopes, SessionCache cache);


    /**
     * HandleEvents is called when an end user modifies a selection on the input control page.
     * @param reportUri  the fully qualified repository URI of the report being invoked.
     * @param envelopes  a list containing the current state of the input controls.
     * @param cache  generic caching functionality passed in by the delegator.
     * @return  a list of envelopes describing the new state of the input controls.
     */
    public List<EventEnvelope> handleEvents(String reportUri, List<EventEnvelope> envelopes, SessionCache cache);


    /**
     * Called when a state change needs to be effected on the input screen not following conventional
     * user modification case.  Example: changing the saved options selection.
     * @param reportUri  the fully qualified repository URI of the report being invoked.
     * @param envelopes  a list containing the current state of the input controls.
     * @param lookupKey  an abstract token indicating where to look for the change information.
     * @param cache  generic caching functionality passed in by the delegator.
     * @return  a list of envelopes describing the new state of the input controls.
     */
    public List<EventEnvelope> autoPopulate(String reportUri, List<EventEnvelope> envelopes, String lookupKey, SessionCache cache);

}
