/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * @author swood
 *
 */
public class MetadataImplTestSuite extends TestSuite {

    static public void main(String[] args) {
    	junit.textui.TestRunner.run(suite());
    }

    /**
     * Creates a TestSuite to run all the tests in the right order. Methods with the
     * signature <code>public static Test suite()</code> are recognized
     * automatically by JUnit test-harnesses; see {@link TestSuite}.
     */
    public static Test suite() {

        TestSuite suite = new TestSuite();

        suite.addTestSuite(HibernateAccessTest.class);
        suite.addTestSuite(HibernateRepositoryTest.class);
		suite.addTestSuite(ContentRepositoryTest.class);
        suite.addTestSuite(UserAuthorityServiceTest.class);
		suite.addTestSuite(ObjectPermissionServiceTest.class);
        suite.addTestSuite(ProfileAttributeTest.class);
        suite.addTestSuite(RepositoryMoveAndCopyTests.class);
        return suite;
    }
}
