/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileBufferedDataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.util.test.BaseJasperServerTest;

public class ContentRepositoryTest extends BaseJasperServerTest
{
	public ContentRepositoryTest(String name) {
		super(name);
		setAutowireMode(AUTOWIRE_BY_NAME);
	}
	
	public void testFolder()
	{
		Folder dsFolder = new FolderImpl();
		dsFolder.setName("ContentFiles");
		dsFolder.setLabel("Content files");
		dsFolder.setDescription("Content files generated by reports");
		getUnsecureRepositoryService().saveFolder(null, dsFolder);

		Folder newFolder = new FolderImpl();
		newFolder.setParentFolder(dsFolder);
		newFolder.setName("html");
		newFolder.setLabel("html");
		getUnsecureRepositoryService().saveFolder(null, newFolder);

		newFolder = new FolderImpl();
		newFolder.setParentFolder(dsFolder);
		newFolder.setName("pdf");
		newFolder.setLabel("pdf");
		getUnsecureRepositoryService().saveFolder(null, newFolder);

		newFolder = new FolderImpl();
		newFolder.setParentFolder(dsFolder);
		newFolder.setName("xls");
		newFolder.setLabel("xls");
		getUnsecureRepositoryService().saveFolder(null, newFolder);

	}

	public void testFiles() throws Exception
	{
		ContentResource fileResource = (ContentResource) getUnsecureRepositoryService().newResource(null, ContentResource.class);
		fileResource.setName("PdfTestFile");
		fileResource.setLabel("Pdf test file");
		fileResource.setParentFolder("/ContentFiles/pdf");
		InputStream file  = getClass().getResourceAsStream("/FontsReport.pdf");

        // Test the dataContainer used by scheduling - There was a problem with this under DB2
        // This is a small file, so it will fit all in mempory

         fileResource.setDataContainer(createFileDataContainer(file));
		//fileResource.readData(file);

		fileResource.setFileType(ContentResource.TYPE_PDF);
		getUnsecureRepositoryService().saveResource(null, fileResource);


		ContentResource htmlFile = (ContentResource) getUnsecureRepositoryService().newResource(null, ContentResource.class);;
		htmlFile.setName("HtmlTestFile");
		htmlFile.setLabel("HTML test file with images");
		htmlFile.setParentFolder("/ContentFiles/html");
		file  = getClass().getResourceAsStream("/FirstJasper.html");

        // This is a large file, so it will be in both memory and on the file system

        htmlFile.setDataContainer(createFileDataContainer(file));
		//htmlFile.readData(file);
		htmlFile.setFileType(ContentResource.TYPE_HTML);

		ArrayList images = new ArrayList();

		ContentResource image = (ContentResource) getUnsecureRepositoryService().newResource(null, ContentResource.class);;
		image.setName("img_0_0_1");
		image.setLabel("img_0_0_1");
		file  = getClass().getResourceAsStream("/FirstJasper.html_files/img_0_0_1");

		// ContentResource.readData stores the data only in memory

		image.readData(file);
		image.setFileType(ContentResource.TYPE_HTML);
		images.add(image);

		image = (ContentResource) getUnsecureRepositoryService().newResource(null, ContentResource.class);
		image.setName("img_0_7_125");
		image.setLabel("img_0_7_125");
		file  = getClass().getResourceAsStream("/FirstJasper.html_files/img_0_7_125");
		image.readData(file);
		image.setFileType(ContentResource.TYPE_HTML);
		images.add(image);

		image = (ContentResource) getUnsecureRepositoryService().newResource(null, ContentResource.class);;
		image.setName("px");
		image.setLabel("px");
		file  = getClass().getResourceAsStream("/FirstJasper.html_files/px");
		image.readData(file);
		image.setFileType(ContentResource.TYPE_HTML);
		images.add(image);

		htmlFile.setResources(images);
		getUnsecureRepositoryService().saveResource(null, htmlFile);


		htmlFile = (ContentResource) getUnsecureRepositoryService().newResource(null, ContentResource.class);;
		htmlFile.setName("Test");
		htmlFile.setLabel("HTML test file with one image");
		htmlFile.setParentFolder("/ContentFiles/html");
		file  = getClass().getResourceAsStream("/Test.html");
		htmlFile.readData(file);
		htmlFile.setFileType(ContentResource.TYPE_HTML);

		image = (ContentResource) getUnsecureRepositoryService().newResource(null, ContentResource.class);;
		image.setName("image0");
		image.setLabel("image0");
		file  = getClass().getResourceAsStream("/Test.html_files/image0");
		image.readData(file);
		image.setFileType(ContentResource.TYPE_HTML);
		images = new ArrayList();
		images.add(image);

		htmlFile.setResources(images);
		getUnsecureRepositoryService().saveResource(null, htmlFile);
	}

	private DataContainer createFileDataContainer(InputStream file) throws Exception {
		DataContainer dataContainer = new FileBufferedDataContainer();
		OutputStream os = dataContainer.getOutputStream();

		byte[] buf = new byte[4000];
		try {
			for (;;) {
				int dataSize = file.read(buf);

				if (dataSize == -1) {
					break;
				}
				os.write(buf, 0, dataSize);
			}
		} finally {
			if (file != null) {
				try {
					file.close();
					os.close();
				} catch (IOException ex) {
				}
			}
		}

		return dataContainer;
	}
}
