/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.spi.ThreadRunner;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: JSSchedulerFactoryBean.java 19922 2010-12-11 14:59:51Z tmatyashovsky $
 */
public class JSSchedulerFactoryBean extends SchedulerFactoryBean {

	private static final Log log = LogFactory.getLog(JSSchedulerFactoryBean.class);
	
	private ThreadRunner threadRunner;
	
	public JSSchedulerFactoryBean() {
		setSchedulerFactoryClass(JSSchedulerFactory.class);
	}
	
	protected Scheduler createScheduler(SchedulerFactory schedulerFactory, 
			String schedulerName)
			throws SchedulerException {
		try {
			if (threadRunner != null) {
				if (!(schedulerFactory instanceof JSSchedulerFactory)) {
					throw new RuntimeException(
							"A JSSchedulerFactory scheduler factory is required");
				}
				
				LocalThreadRunner.setLocalThreadRunner(threadRunner);
				
				JSSchedulerFactory factory = (JSSchedulerFactory) schedulerFactory;
				factory.getInitProps().setProperty(StdSchedulerFactory.PROP_THREAD_RUNNER_CLASS, 
						LocalThreadRunner.class.getName());
				factory.reinit();
			}
			
			return super.createScheduler(schedulerFactory, schedulerName);
		} finally {
			if (threadRunner != null) {
				LocalThreadRunner.setLocalThreadRunner(null);
			}
		}
	}

	public ThreadRunner getThreadRunner() {
		return threadRunner;
	}

	public void setThreadRunner(ThreadRunner threadRunner) {
		if (threadRunner instanceof NullThreadRunner) {
			threadRunner = null;
		}
			
		this.threadRunner = threadRunner;
	}

	public void setTaskExecutor(TaskExecutor taskExecutor) {
		if (taskExecutor instanceof NullTaskExecutor) {
			taskExecutor = null;
		}
		
		super.setTaskExecutor(taskExecutor);
	}

}
