/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.metadata;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.olap4j.OlapException;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Level
extends MetadataElement {
    public int getDepth();

    public Hierarchy getHierarchy();

    public Dimension getDimension();

    public Type getLevelType();

    public NamedList<Property> getProperties();

    public List<Member> getMembers() throws OlapException;

    public int getCardinality();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        Regular(0),
        TimeYears(1),
        TimeQuarters(2),
        TimeMonths(3),
        TimeWeeks(4),
        TimeDays(5),
        Null(6),
        GEO_CONTINENT(8193),
        GEO_REGION(8194),
        GEO_COUNTRY(8195),
        GEO_STATE_OR_PROVINCE(8196),
        GEO_COUNTY(8197),
        GEO_CITY(8198),
        GEO_POSTALCODE(8199),
        GEO_POINT(8200),
        ORG_UNIT(4113),
        BOM_RESOURCE(4114),
        QUANTITATIVE(4115),
        ACCOUNT(4116),
        CUSTOMER(4129),
        CUSTOMER_GROUP(4130),
        CUSTOMER_HOUSEHOLD(4131),
        PRODUCT(4145),
        PRODUCT_GROUP(4146),
        SCENARIO(4117),
        UTILITY(4118),
        PERSON(4161),
        COMPANY(4162),
        CURRENCY_SOURCE(4177),
        CURRENCY_DESTINATION(4178),
        CHANNEL(4193),
        REPRESENTATIVE(4194),
        PROMOTION(4209);

        private final int xmlaOrdinal;
        private static final Map<Integer, Type> xmlaMap;

        private Type(int code) {
            this.xmlaOrdinal = code;
        }

        public int xmlaOrdinal() {
            return this.xmlaOrdinal;
        }

        public static Type forXmlaOrdinal(int xmlaOrdinal) {
            return xmlaMap.get(xmlaOrdinal);
        }

        public boolean isTime() {
            switch (this) {
                case TimeYears: 
                case TimeQuarters: 
                case TimeMonths: 
                case TimeWeeks: 
                case TimeDays: {
                    return true;
                }
            }
            return false;
        }

        static {
            xmlaMap = new HashMap<Integer, Type>();
            for (Type type : Type.values()) {
                xmlaMap.put(type.xmlaOrdinal, type);
            }
        }
    }
}

