/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import org.springframework.core.io.Resource;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowArtifactException;
import org.springframework.webflow.builder.FlowArtifactFactory;
import org.springframework.webflow.builder.FlowAssembler;
import org.springframework.webflow.builder.FlowBuilder;
import org.springframework.webflow.registry.ExternalizedFlowDefinition;
import org.springframework.webflow.test.AbstractFlowExecutionTests;
import org.springframework.webflow.test.MockFlowArtifactFactory;

public abstract class AbstractExternalizedFlowExecutionTests
extends AbstractFlowExecutionTests {
    private static Flow cachedFlowDefinition;
    private boolean cacheFlowDefinition;

    public boolean isCacheFlowDefinition() {
        return this.cacheFlowDefinition;
    }

    public void setCacheFlowDefinition(boolean cacheFlowDefinition) {
        this.cacheFlowDefinition = cacheFlowDefinition;
    }

    protected Flow getFlow() throws FlowArtifactException {
        if (this.isCacheFlowDefinition() && cachedFlowDefinition != null) {
            return cachedFlowDefinition;
        }
        FlowArtifactFactory flowArtifactFactory = this.createFlowArtifactFactory();
        ExternalizedFlowDefinition flowDefinition = this.getFlowDefinition();
        FlowBuilder builder = this.createFlowBuilder(flowDefinition.getLocation(), flowArtifactFactory);
        new FlowAssembler(flowDefinition, builder).assembleFlow();
        Flow flow = builder.getResult();
        if (this.isCacheFlowDefinition()) {
            cachedFlowDefinition = flow;
        }
        return flow;
    }

    protected FlowArtifactFactory createFlowArtifactFactory() {
        return new MockFlowArtifactFactory();
    }

    protected abstract FlowBuilder createFlowBuilder(Resource var1, FlowArtifactFactory var2);

    protected abstract ExternalizedFlowDefinition getFlowDefinition();
}

