/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.core.JdkVersion;
import org.springframework.core.NestedRuntimeException;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.FlowExecutionControlContext;
import org.springframework.webflow.State;
import org.springframework.webflow.StateException;
import org.springframework.webflow.StateExceptionHandler;
import org.springframework.webflow.Transition;
import org.springframework.webflow.TransitionableState;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.support.StaticTargetStateResolver;

public class TransitionExecutingStateExceptionHandler
implements StateExceptionHandler {
    public static final String HANDLED_STATE_EXCEPTION_ATTRIBUTE = "handledStateException";
    private Map exceptionTargetStateIdMapping = new HashMap();

    public TransitionExecutingStateExceptionHandler add(Class exceptionClass, String targetStateId) {
        Assert.notNull((Object)exceptionClass, (String)"The exception class is required");
        Assert.hasText((String)targetStateId, (String)"The target state id is required");
        this.exceptionTargetStateIdMapping.put(exceptionClass, targetStateId);
        return this;
    }

    public void addAll(Map mappings) {
        Iterator entries = mappings.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            this.add((Class)entry.getKey(), (String)entry.getValue());
        }
    }

    public boolean handles(StateException e) {
        return this.getTargetStateId(e) != null;
    }

    public ViewSelection handle(StateException e, FlowExecutionControlContext context) {
        State sourceState = context.getCurrentState();
        if (!(sourceState instanceof TransitionableState)) {
            throw new IllegalStateException("The source state '" + sourceState.getId() + "' to transition from must be transitionable!");
        }
        StaticTargetStateResolver targetStateResolver = new StaticTargetStateResolver(this.getTargetStateId(e));
        context.getRequestScope().put(HANDLED_STATE_EXCEPTION_ATTRIBUTE, (Object)e);
        return new Transition(targetStateResolver).execute((TransitionableState)sourceState, context);
    }

    protected String getTargetStateId(StateException e) {
        if (JdkVersion.getMajorJavaVersion() == 0) {
            return this.getTargetStateId13(e);
        }
        return this.getTargetStateId14((Throwable)((Object)e));
    }

    private String getTargetStateId13(NestedRuntimeException e) {
        if (this.exceptionTargetStateIdMapping.containsKey(e.getClass())) {
            return (String)this.exceptionTargetStateIdMapping.get(e.getClass());
        }
        Throwable throwable = e.getCause();
        if (throwable != null && throwable instanceof NestedRuntimeException) {
            return this.getTargetStateId13((NestedRuntimeException)throwable);
        }
        if (this.exceptionTargetStateIdMapping.containsKey(throwable.getClass())) {
            return (String)this.exceptionTargetStateIdMapping.get(throwable.getClass());
        }
        return null;
    }

    private String getTargetStateId14(Throwable t) {
        if (this.exceptionTargetStateIdMapping.containsKey(t.getClass())) {
            return (String)this.exceptionTargetStateIdMapping.get(t.getClass());
        }
        if (t.getCause() != null) {
            return this.getTargetStateId14(t.getCause());
        }
        return null;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("exceptionStateMap", (Object)this.exceptionTargetStateIdMapping).toString();
    }
}

