/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.AnnotatedAction;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.TransitionCriteria;
import org.springframework.webflow.support.ActionTransitionCriteria;

public class TransitionCriteriaChain
implements TransitionCriteria {
    private LinkedList criteriaChain = new LinkedList();

    public TransitionCriteriaChain() {
    }

    public TransitionCriteriaChain(TransitionCriteria[] criteria) {
        this.criteriaChain.addAll(Arrays.asList(criteria));
    }

    public TransitionCriteriaChain add(TransitionCriteria criteria) {
        this.criteriaChain.add(criteria);
        return this;
    }

    public boolean test(RequestContext context) {
        Iterator it = this.criteriaChain.iterator();
        while (it.hasNext()) {
            TransitionCriteria criteria = (TransitionCriteria)it.next();
            if (criteria.test(context)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("criteriaChain", (Object)this.criteriaChain).toString();
    }

    public static TransitionCriteria criteriaChainFor(AnnotatedAction[] actions) {
        TransitionCriteriaChain chain = new TransitionCriteriaChain();
        for (int i = 0; i < actions.length; ++i) {
            chain.add(new ActionTransitionCriteria(actions[i]));
        }
        return chain;
    }
}

