/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import org.springframework.webflow.AttributeCollection;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.Event;

public class EventFactorySupport {
    public static final String SUCCESS_EVENT_ID = "success";
    public static final String ERROR_EVENT_ID = "error";
    public static final String YES_EVENT_ID = "yes";
    public static final String NO_EVENT_ID = "no";
    public static final String EXCEPTION_PARAMETER = "exception";
    public static final String RESULT_PARAMETER = "result";

    protected Event error() {
        return this.result(ERROR_EVENT_ID);
    }

    protected Event error(Exception e) {
        return this.result(ERROR_EVENT_ID, EXCEPTION_PARAMETER, e);
    }

    protected Event success() {
        return this.result(SUCCESS_EVENT_ID);
    }

    protected Event success(Object result) {
        return this.result(SUCCESS_EVENT_ID, RESULT_PARAMETER, result);
    }

    protected Event success(String resultParameterName, Object result) {
        return this.result(SUCCESS_EVENT_ID, resultParameterName, result);
    }

    protected Event yes() {
        return this.result(YES_EVENT_ID);
    }

    protected Event no() {
        return this.result(NO_EVENT_ID);
    }

    protected Event yesOrNo(boolean booleanResult) {
        if (booleanResult) {
            return this.yes();
        }
        return this.no();
    }

    protected Event result(String eventId) {
        return new Event(this, eventId);
    }

    protected Event result(String eventId, AttributeCollection attributes) {
        return new Event(this, eventId, attributes);
    }

    protected Event result(String eventId, String attributeName, Object attributeValue) {
        AttributeMap attributes = new AttributeMap(1, 1);
        attributes.put(attributeName, attributeValue);
        return new Event(this, eventId, attributes);
    }
}

