/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.continuation;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionByteArray;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuation;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuationFactory;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionSerializationException;
import org.springframework.webflow.execution.repository.continuation.SerializedFlowExecutionContinuation;

public class SerializedFlowExecutionContinuationFactory
implements FlowExecutionContinuationFactory {
    private boolean compress = false;

    public boolean getCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public FlowExecutionContinuation createContinuation(Serializable continuationId, FlowExecution flowExecution) {
        try {
            return new SerializedFlowExecutionContinuation(continuationId, new FlowExecutionByteArray(flowExecution, this.getCompress()));
        }
        catch (NotSerializableException e) {
            throw new FlowExecutionSerializationException(continuationId, flowExecution, "Could not serialize flow execution; make sure all objects stored in flow scope are serializable", e);
        }
        catch (IOException e) {
            throw new FlowExecutionSerializationException(continuationId, flowExecution, "IOException thrown serializing flow execution -- this should not happen!", e);
        }
    }
}

