/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.continuation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.springframework.core.NestedRuntimeException;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionByteArray;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuation;

public class SerializedFlowExecutionContinuation
extends FlowExecutionContinuation {
    private static final long serialVersionUID = 1026250005686020025L;
    private FlowExecutionByteArray byteArray;

    public SerializedFlowExecutionContinuation(Serializable id, FlowExecutionByteArray byteArray) {
        super(id);
        Assert.notNull((Object)byteArray, (String)"The flow execution byte array is required");
        this.byteArray = byteArray;
    }

    public FlowExecution getFlowExecution() {
        try {
            return this.byteArray.deserializeFlowExecution();
        }
        catch (IOException e) {
            throw new FlowExecutionDeserializationException(this.getId(), "IOException thrown deserializing the flow execution stored in this continuation -- this should not happen!", e);
        }
        catch (ClassNotFoundException e) {
            throw new FlowExecutionDeserializationException(this.getId(), "ClassNotFoundException thrown deserializing the flow execution stored in this continuation -- This should not happen! Make sure there are no classloader issues.For example, perhaps the Web Flow system is being loaded by a classloader that is a parent of the classloader loading application classes?", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.byteArray.getData().length + 128);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(this);
                oos.flush();
            }
            finally {
                oos.close();
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    protected static class FlowExecutionDeserializationException
    extends NestedRuntimeException {
        private Serializable continuationId;

        public FlowExecutionDeserializationException(Serializable continuationId, String message, Throwable cause) {
            super(message, cause);
            this.continuationId = continuationId;
        }

        public Serializable getContinuationId() {
            return this.continuationId;
        }
    }
}

