/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.Event;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowArtifactException;
import org.springframework.webflow.FlowExecutionControlContext;
import org.springframework.webflow.FlowSession;
import org.springframework.webflow.FlowSessionStatus;
import org.springframework.webflow.State;
import org.springframework.webflow.StateException;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.FlowExecutionListenerLoader;
import org.springframework.webflow.execution.FlowLocator;
import org.springframework.webflow.execution.impl.FlowExecutionControlContextImpl;
import org.springframework.webflow.execution.impl.FlowExecutionListeners;
import org.springframework.webflow.execution.impl.FlowSessionImpl;

public class FlowExecutionImpl
implements FlowExecution,
Externalizable {
    private static final long serialVersionUID = -898397026261844347L;
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$execution$impl$FlowExecutionImpl == null ? (class$org$springframework$webflow$execution$impl$FlowExecutionImpl = FlowExecutionImpl.class$("org.springframework.webflow.execution.impl.FlowExecutionImpl")) : class$org$springframework$webflow$execution$impl$FlowExecutionImpl));
    private transient Flow flow;
    private AttributeMap scope = new AttributeMap();
    private LinkedList flowSessions = new LinkedList();
    private transient FlowExecutionListeners listeners;
    private String flowId;
    static /* synthetic */ Class class$org$springframework$webflow$execution$impl$FlowExecutionImpl;

    public FlowExecutionImpl() {
    }

    public FlowExecutionImpl(Flow flow) {
        this(flow, new FlowExecutionListener[0]);
    }

    public FlowExecutionImpl(Flow flow, FlowExecutionListener[] listeners) {
        Assert.notNull((Object)flow, (String)"The root flow definition is required");
        this.flow = flow;
        this.listeners = new FlowExecutionListeners(listeners);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created new execution of flow '" + flow.getId() + "'"));
        }
    }

    public String getCaption() {
        return "FlowExecution:flow=[" + (this.getFlow() != null ? this.getFlow().getId() : this.flowId) + "]";
    }

    public boolean isActive() {
        return !this.flowSessions.isEmpty();
    }

    public Flow getFlow() {
        return this.flow;
    }

    public FlowSession getActiveSession() {
        return this.getActiveSessionInternal();
    }

    public AttributeMap getScope() {
        this.assertActive();
        return this.scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewSelection start(ExternalContext externalContext) throws StateException {
        Assert.state((!this.isActive() ? 1 : 0) != 0, (String)"This flow is already executing -- you cannot call 'start(ExternalContext)' more than once");
        FlowExecutionControlContext context = this.createControlContext(externalContext);
        this.getListeners().fireRequestSubmitted(context);
        try {
            ViewSelection selectedView = context.start(this.getFlow(), this.getFlow().getStartState(), null);
            ViewSelection viewSelection = this.pause(context, selectedView);
            return viewSelection;
        }
        catch (StateException e) {
            ViewSelection viewSelection = this.pause(context, this.handleException(e, context));
            return viewSelection;
        }
        finally {
            this.getListeners().fireRequestProcessed(context);
        }
    }

    protected ViewSelection handleException(StateException exception, FlowExecutionControlContext context) throws StateException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempting to handle exception [" + (Object)((Object)exception) + "]"));
        }
        if (exception.getState() != null) {
            try {
                ViewSelection selectedView = exception.getState().handleException(exception, context);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("State '" + exception.getState().getId() + "' handled exception"));
                }
                return selectedView;
            }
            catch (StateException e) {
                // empty catch block
            }
        }
        try {
            ViewSelection selectedView = exception.getFlow().handleException(exception, context);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Flow '" + exception.getFlow().getId() + "' handled exception"));
            }
            return selectedView;
        }
        catch (StateException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Rethrowing unhandled state exception");
            }
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewSelection signalEvent(String eventId, ExternalContext externalContext) throws StateException {
        this.assertActive();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resuming this execution on user event '" + eventId + "'"));
        }
        FlowExecutionControlContext context = this.createControlContext(externalContext);
        this.getListeners().fireRequestSubmitted(context);
        try {
            this.resume(context);
            ViewSelection selectedView = context.signalEvent(new Event(externalContext, eventId));
            ViewSelection viewSelection = this.pause(context, selectedView);
            return viewSelection;
        }
        catch (StateException e) {
            ViewSelection viewSelection = this.pause(context, this.handleException(e, context));
            return viewSelection;
        }
        finally {
            this.getListeners().fireRequestProcessed(context);
        }
    }

    protected void resume(FlowExecutionControlContext context) {
        this.getActiveSessionInternal().setStatus(FlowSessionStatus.ACTIVE);
        this.getListeners().fireResumed(context);
    }

    protected ViewSelection pause(FlowExecutionControlContext context, ViewSelection selectedView) {
        if (!this.isActive()) {
            return selectedView;
        }
        this.getActiveSessionInternal().setStatus(FlowSessionStatus.PAUSED);
        this.getListeners().firePaused(context, selectedView);
        if (logger.isDebugEnabled()) {
            if (selectedView != null) {
                logger.debug((Object)("Paused to render " + selectedView + " and wait for user input"));
            } else {
                logger.debug((Object)"Paused to wait for user input");
            }
        }
        return selectedView;
    }

    public FlowExecutionListeners getListeners() {
        return this.listeners;
    }

    protected FlowExecutionControlContext createControlContext(ExternalContext externalContext) {
        return new FlowExecutionControlContextImpl(this, externalContext);
    }

    protected FlowSessionImpl getActiveSessionInternal() throws IllegalStateException {
        this.assertActive();
        return (FlowSessionImpl)this.flowSessions.getLast();
    }

    protected FlowSession getParentSession() throws IllegalArgumentException {
        this.assertActive();
        Assert.state((!this.getActiveSession().isRoot() ? 1 : 0) != 0, (String)"There is no parent flow session for the currently active flow session");
        return (FlowSession)this.flowSessions.get(this.flowSessions.size() - 2);
    }

    protected FlowSession getRootSession() throws IllegalStateException {
        this.assertActive();
        return (FlowSession)this.flowSessions.getFirst();
    }

    protected void assertActive() throws IllegalStateException {
        if (!this.isActive()) {
            throw new IllegalStateException("This flow execution is not active, it has either ended or has never been started.");
        }
    }

    public void setScope(AttributeMap scope) {
        this.scope = scope;
    }

    protected void setCurrentState(State newState) {
        this.getActiveSessionInternal().setState(newState);
    }

    public FlowSession activateSession(Flow flow, AttributeMap input) {
        FlowSessionImpl session;
        if (!this.flowSessions.isEmpty()) {
            FlowSessionImpl parent = this.getActiveSessionInternal();
            parent.setStatus(FlowSessionStatus.SUSPENDED);
            session = this.createFlowSession(flow, input, parent);
        } else {
            session = this.createFlowSession(flow, input, null);
        }
        this.flowSessions.add(session);
        session.setStatus(FlowSessionStatus.STARTING);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting " + session));
        }
        return session;
    }

    protected FlowSessionImpl createFlowSession(Flow flow, AttributeMap input, FlowSessionImpl parent) {
        return new FlowSessionImpl(flow, input, parent);
    }

    public FlowSession endActiveFlowSession() {
        FlowSessionImpl endingSession = (FlowSessionImpl)this.flowSessions.removeLast();
        endingSession.setStatus(FlowSessionStatus.ENDED);
        if (!this.flowSessions.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resuming session '" + this.getActiveSessionInternal().getFlow().getId() + "' in state '" + this.getActiveSessionInternal().getState().getId() + "'"));
            }
            this.getActiveSessionInternal().setStatus(FlowSessionStatus.ACTIVE);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"[Ended] - this execution is now inactive");
        }
        return endingSession;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.flowId = (String)in.readObject();
        this.scope = (AttributeMap)in.readObject();
        this.flowSessions = (LinkedList)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.getFlow() != null) {
            out.writeObject(this.getFlow().getId());
        } else {
            out.writeObject(this.flowId);
        }
        out.writeObject(this.scope);
        out.writeObject(this.flowSessions);
    }

    public synchronized void rehydrate(FlowLocator flowLocator, FlowExecutionListenerLoader listenerLoader) {
        if (this.isHydrated()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Rehydrating");
        }
        Assert.notNull((Object)flowLocator, (String)"The flow locator is required");
        Assert.notNull((Object)this.flowId, (String)"The root flow id was not set during deserialization: was this flow execution deserialized properly?");
        this.flow = flowLocator.getFlow(this.flowId);
        this.flowId = null;
        Iterator it = this.flowSessions.iterator();
        while (it.hasNext()) {
            FlowSessionImpl session = (FlowSessionImpl)it.next();
            session.rehydrate(new FlowSessionFlowLocator(this.flow, flowLocator));
        }
        if (this.isActive()) {
            Assert.isTrue((this.getFlow() == this.getRootSession().getFlow() ? 1 : 0) != 0, (String)"The root flow of the execution should be the same as the flow in the root flow session");
        }
        this.listeners = listenerLoader != null ? new FlowExecutionListeners(listenerLoader.getListeners(this.flow)) : new FlowExecutionListeners();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Rehydrated");
        }
    }

    protected boolean isHydrated() {
        return this.flow != null;
    }

    public String toString() {
        if (!this.isActive()) {
            return "[Inactive " + this.getCaption() + "]";
        }
        if (this.isHydrated()) {
            return new ToStringCreator((Object)this).append("flow", (Object)this.getFlow().getId()).append("activeFlow", (Object)this.getActiveSession().getFlow().getId()).append("currentState", (Object)this.getActiveSession().getState().getId()).append("flowSessions", (Object)this.flowSessions).toString();
        }
        return "[Unhydrated " + this.getCaption() + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FlowSessionFlowLocator
    implements FlowLocator {
        private FlowLocator flowLocator;
        private Flow rootFlow;

        public FlowSessionFlowLocator(Flow rootFlow, FlowLocator flowLocator) {
            this.rootFlow = rootFlow;
            this.flowLocator = flowLocator;
        }

        public Flow getFlow(String id) throws FlowArtifactException {
            if (this.rootFlow.getId().equals(id)) {
                return this.rootFlow;
            }
            if (this.rootFlow.containsInlineFlow(id)) {
                return this.rootFlow.getInlineFlow(id);
            }
            return this.flowLocator.getFlow(id);
        }
    }
}

