/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.builder;

import org.springframework.binding.mapping.MappingBuilder;
import org.springframework.binding.method.MethodSignature;
import org.springframework.webflow.Action;
import org.springframework.webflow.ActionState;
import org.springframework.webflow.AnnotatedAction;
import org.springframework.webflow.AttributeCollection;
import org.springframework.webflow.DecisionState;
import org.springframework.webflow.EndState;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowArtifactException;
import org.springframework.webflow.FlowAttributeMapper;
import org.springframework.webflow.SubflowState;
import org.springframework.webflow.TargetStateResolver;
import org.springframework.webflow.Transition;
import org.springframework.webflow.TransitionCriteria;
import org.springframework.webflow.ViewSelector;
import org.springframework.webflow.ViewState;
import org.springframework.webflow.builder.BaseFlowBuilder;
import org.springframework.webflow.builder.FlowArtifactFactory;
import org.springframework.webflow.builder.FlowArtifactParameters;
import org.springframework.webflow.builder.FlowBuilderException;
import org.springframework.webflow.support.ActionTransitionCriteria;

public abstract class AbstractFlowBuilder
extends BaseFlowBuilder {
    static /* synthetic */ Class class$org$springframework$webflow$ViewSelector;
    static /* synthetic */ Class class$org$springframework$binding$method$MethodSignature;
    static /* synthetic */ Class class$org$springframework$webflow$TransitionCriteria;
    static /* synthetic */ Class class$org$springframework$webflow$TargetStateResolver;

    protected AbstractFlowBuilder() {
    }

    protected AbstractFlowBuilder(FlowArtifactFactory flowArtifactFactory) {
        super(flowArtifactFactory);
    }

    public void init(FlowArtifactParameters flowParameters) throws FlowBuilderException {
        this.setFlow(this.getFlowArtifactFactory().createFlow(flowParameters.putAll(this.flowAttributes())));
    }

    protected MappingBuilder mapping() {
        MappingBuilder mapping = new MappingBuilder(this.getFlowArtifactFactory().getExpressionParser());
        mapping.setConversionService(this.getFlowArtifactFactory().getConversionService());
        return mapping;
    }

    protected AttributeCollection flowAttributes() {
        return null;
    }

    public abstract void buildStates();

    public void buildExceptionHandlers() {
    }

    protected ViewState addViewState(String stateId, Transition transition) throws IllegalArgumentException {
        return this.addViewState(stateId, (String)null, transition);
    }

    protected ViewState addViewState(String stateId, Transition[] transitions) throws IllegalArgumentException {
        return this.addViewState(stateId, (String)null, transitions);
    }

    protected ViewState addViewState(String stateId, Transition[] transitions, AttributeCollection attributes) throws IllegalArgumentException {
        return this.addViewState(stateId, (String)null, transitions, attributes);
    }

    protected ViewState addViewState(String stateId, String viewName, Transition transition) throws IllegalArgumentException {
        return this.addViewState(stateId, this.viewSelector(viewName), new Transition[]{transition}, null);
    }

    protected ViewState addViewState(String stateId, String viewName, Transition[] transitions) throws IllegalArgumentException {
        return this.addViewState(stateId, this.viewSelector(viewName), transitions, null);
    }

    protected ViewState addViewState(String stateId, String viewName, Transition[] transitions, AttributeCollection attributes) throws IllegalArgumentException {
        return this.addViewState(stateId, this.viewSelector(viewName), transitions, attributes);
    }

    protected ViewState addViewState(String stateId, ViewSelector viewSelector, Transition[] transitions) throws IllegalArgumentException {
        return this.addViewState(stateId, viewSelector, transitions, null);
    }

    protected ViewState addViewState(String stateId, ViewSelector viewSelector, Transition[] transitions, AttributeCollection attributes) throws IllegalArgumentException {
        ViewState state = new ViewState(this.getFlow(), stateId);
        state.setViewSelector(viewSelector);
        state.getTransitionSet().addAll(transitions);
        state.getAttributeMap().putAll(attributes);
        return state;
    }

    protected ViewSelector viewSelector(String viewName) {
        return (ViewSelector)this.fromStringTo(class$org$springframework$webflow$ViewSelector == null ? (class$org$springframework$webflow$ViewSelector = AbstractFlowBuilder.class$("org.springframework.webflow.ViewSelector")) : class$org$springframework$webflow$ViewSelector).execute((Object)viewName);
    }

    protected ActionState addActionState(String stateId, Action action, Transition transition) throws IllegalArgumentException {
        return this.addActionState(stateId, new Action[]{action}, new Transition[]{transition}, null);
    }

    protected ActionState addActionState(String stateId, Action action, Transition[] transitions) throws IllegalArgumentException {
        return this.addActionState(stateId, new Action[]{action}, transitions, null);
    }

    protected ActionState addActionState(String stateId, Action action, Transition[] transitions, AttributeCollection attributes) throws IllegalArgumentException {
        return this.addActionState(stateId, new Action[]{action}, transitions, attributes);
    }

    protected ActionState addActionState(String stateId, Action[] actions, Transition[] transitions) throws IllegalArgumentException {
        return this.addActionState(stateId, actions, transitions, null);
    }

    protected ActionState addActionState(String stateId, Action[] actions, Transition[] transitions, AttributeCollection attributes) throws IllegalArgumentException {
        ActionState state = new ActionState(this.getFlow(), stateId);
        state.getTransitionSet().addAll(transitions);
        state.getActionList().addAll(actions);
        state.getAttributeMap().putAll(attributes);
        return state;
    }

    protected Action action(String id) throws FlowArtifactException {
        return this.getFlowArtifactFactory().getAction(new FlowArtifactParameters(id));
    }

    protected AnnotatedAction method(String encodedMethodKey, Action action) {
        MethodSignature method = (MethodSignature)this.fromStringTo(class$org$springframework$binding$method$MethodSignature == null ? (class$org$springframework$binding$method$MethodSignature = AbstractFlowBuilder.class$("org.springframework.binding.method.MethodSignature")) : class$org$springframework$binding$method$MethodSignature).execute((Object)encodedMethodKey);
        AnnotatedAction annotatedAction = new AnnotatedAction(action);
        annotatedAction.setMethod(method);
        return annotatedAction;
    }

    protected SubflowState addSubflowState(String stateId, Flow subFlow, Transition transition) {
        return this.addSubflowState(stateId, subFlow, null, new Transition[]{transition}, null);
    }

    protected SubflowState addSubflowState(String stateId, Flow subFlow, Transition[] transitions) {
        return this.addSubflowState(stateId, subFlow, null, transitions, null);
    }

    protected SubflowState addSubflowState(String stateId, Flow subFlow, Transition[] transitions, AttributeCollection attributes) {
        return this.addSubflowState(stateId, subFlow, null, transitions, attributes);
    }

    protected SubflowState addSubflowState(String stateId, Flow subFlow, FlowAttributeMapper attributeMapper, Transition transition) {
        return this.addSubflowState(stateId, subFlow, attributeMapper, new Transition[]{transition}, null);
    }

    protected SubflowState addSubflowState(String stateId, Flow subFlow, FlowAttributeMapper attributeMapper, Transition[] transitions) {
        return this.addSubflowState(stateId, subFlow, attributeMapper, transitions, null);
    }

    protected SubflowState addSubflowState(String stateId, Flow subFlow, FlowAttributeMapper attributeMapper, Transition[] transitions, AttributeCollection attributes) {
        SubflowState state = new SubflowState(this.getFlow(), stateId, subFlow);
        state.getTransitionSet().addAll(transitions);
        state.setAttributeMapper(attributeMapper);
        state.getAttributeMap().putAll(attributes);
        return state;
    }

    protected FlowAttributeMapper attributeMapper(String id) throws FlowArtifactException {
        return this.getFlowArtifactFactory().getAttributeMapper(id);
    }

    protected Flow flow(String id) throws FlowArtifactException {
        return this.getFlowArtifactFactory().getSubflow(id);
    }

    protected DecisionState addDecisionState(String stateId, TransitionCriteria matchingCriteria, String ifTrueStateId, String ifFalseStateId) throws IllegalArgumentException {
        return this.addDecisionState(stateId, matchingCriteria, ifTrueStateId, ifFalseStateId, null);
    }

    protected DecisionState addDecisionState(String stateId, TransitionCriteria matchingCriteria, String ifTrueStateId, String ifFalseStateId, AttributeCollection attributes) throws IllegalArgumentException {
        Transition[] transitions = new Transition[2];
        transitions[0] = new Transition(this.to(ifTrueStateId));
        transitions[0].setMatchingCriteria(matchingCriteria);
        transitions[1] = new Transition(this.to(ifFalseStateId));
        return this.addDecisionState(stateId, transitions, attributes);
    }

    protected DecisionState addDecisionState(String stateId, Transition[] transitions) throws IllegalArgumentException {
        return this.addDecisionState(stateId, transitions, null);
    }

    protected DecisionState addDecisionState(String stateId, Transition[] transitions, AttributeCollection attributes) throws IllegalArgumentException {
        DecisionState state = new DecisionState(this.getFlow(), stateId);
        state.getTransitionSet().addAll(transitions);
        state.getAttributeMap().putAll(attributes);
        return state;
    }

    protected EndState addEndState(String stateId) throws IllegalArgumentException {
        return this.addEndState(stateId, (String)null);
    }

    protected EndState addEndState(String stateId, String viewName) throws IllegalArgumentException {
        return this.addEndState(stateId, this.viewSelector(viewName), null, null);
    }

    protected EndState addEndState(String stateId, String[] outputAttributeNames) throws IllegalArgumentException {
        return this.addEndState(stateId, this.viewSelector(null), outputAttributeNames, null);
    }

    protected EndState addEndState(String stateId, String viewName, String[] outputAttributeNames) throws IllegalArgumentException {
        return this.addEndState(stateId, this.viewSelector(viewName), outputAttributeNames, null);
    }

    protected EndState addEndState(String stateId, ViewSelector viewSelector) throws IllegalArgumentException {
        return this.addEndState(stateId, viewSelector, null, null);
    }

    protected EndState addEndState(String stateId, ViewSelector viewSelector, String[] outputAttributeNames) throws IllegalArgumentException {
        return this.addEndState(stateId, viewSelector, outputAttributeNames, null);
    }

    protected EndState addEndState(String stateId, ViewSelector viewSelector, String[] outputAttributeNames, AttributeCollection attributes) throws IllegalArgumentException {
        EndState state = new EndState(this.getFlow(), stateId);
        state.setViewSelector(viewSelector);
        state.addOutputAttributeNames(outputAttributeNames);
        state.getAttributeMap().putAll(attributes);
        return state;
    }

    protected TransitionCriteria on(String transitionCriteriaExpression) {
        return (TransitionCriteria)this.fromStringTo(class$org$springframework$webflow$TransitionCriteria == null ? (class$org$springframework$webflow$TransitionCriteria = AbstractFlowBuilder.class$("org.springframework.webflow.TransitionCriteria")) : class$org$springframework$webflow$TransitionCriteria).execute((Object)transitionCriteriaExpression);
    }

    protected TargetStateResolver to(String targetStateExpression) {
        return (TargetStateResolver)this.fromStringTo(class$org$springframework$webflow$TargetStateResolver == null ? (class$org$springframework$webflow$TargetStateResolver = AbstractFlowBuilder.class$("org.springframework.webflow.TargetStateResolver")) : class$org$springframework$webflow$TargetStateResolver).execute((Object)targetStateExpression);
    }

    protected Transition transition(TransitionCriteria criteria, TargetStateResolver targetStateResolver) {
        Transition transition = new Transition(targetStateResolver);
        transition.setMatchingCriteria(criteria);
        return transition;
    }

    protected Transition transition(TransitionCriteria criteria, TargetStateResolver targetStateResolver, TransitionCriteria executionCriteria) {
        Transition transition = this.transition(criteria, targetStateResolver);
        transition.setExecutionCriteria(executionCriteria);
        return transition;
    }

    protected TransitionCriteria ifSuccessful(Action action) {
        return new ActionTransitionCriteria(action);
    }

    protected String success() {
        return "success";
    }

    protected String error() {
        return "error";
    }

    protected String submit() {
        return "submit";
    }

    protected String back() {
        return "back";
    }

    protected String cancel() {
        return "cancel";
    }

    protected String finish() {
        return "finish";
    }

    protected String select() {
        return "select";
    }

    protected String edit() {
        return "edit";
    }

    protected String add() {
        return "add";
    }

    protected String delete() {
        return "delete";
    }

    protected String yes() {
        return "yes";
    }

    protected String no() {
        return "no";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

