/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.webflow.Action;
import org.springframework.webflow.Event;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.action.AbstractAction;

public class StatefulActionProxy
extends AbstractAction
implements BeanFactoryAware {
    public static final String ACTION_ID_PROPERTY = "actionId";
    public static final String ACTION_ATTRIBUTE_PROPERTY = "actionAttribute";
    private String actionId;
    private String actionAttribute;
    private BeanFactory beanFactory;
    static /* synthetic */ Class class$org$springframework$webflow$Action;

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String statefulActionId) {
        this.actionId = statefulActionId;
    }

    public String getActionAttribute() {
        return this.actionAttribute;
    }

    public void setActionAttribute(String actionAttributeName) {
        this.actionAttribute = actionAttributeName;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected Event doExecute(RequestContext context) throws Exception {
        return this.getAction(context).execute(context);
    }

    protected Action getAction(RequestContext context) {
        String actionId = this.getActionId(context);
        Assert.hasText((String)actionId, (String)"You must specify the id of the stateful action to invoke using the 'actionId' property");
        String actionAttribute = this.getActionAttribute(context, actionId);
        Assert.hasText((String)actionAttribute, (String)"You must specify the attribute name of the stateful action in flow scope using the 'actionAttribute' property");
        if (!context.getFlowScope().contains(actionAttribute)) {
            context.getFlowScope().put(actionAttribute, this.lookupAction(actionId));
        }
        return (Action)context.getFlowScope().get(actionAttribute, class$org$springframework$webflow$Action == null ? (class$org$springframework$webflow$Action = StatefulActionProxy.class$("org.springframework.webflow.Action")) : class$org$springframework$webflow$Action);
    }

    protected Action lookupAction(String actionId) {
        Assert.isTrue((!this.beanFactory.isSingleton(actionId) ? 1 : 0) != 0, (String)("The stateful Action bean definition with id '" + actionId + "' must be marked as a prototype in the bean factory"));
        return (Action)this.beanFactory.getBean(actionId, class$org$springframework$webflow$Action == null ? (class$org$springframework$webflow$Action = StatefulActionProxy.class$("org.springframework.webflow.Action")) : class$org$springframework$webflow$Action);
    }

    protected String getActionId(RequestContext context) {
        return context.getAttributes().getString(ACTION_ID_PROPERTY, this.getActionId());
    }

    protected String getActionAttribute(RequestContext context, String actionId) {
        String result = context.getAttributes().getString(ACTION_ATTRIBUTE_PROPERTY);
        if (result != null) {
            return result;
        }
        return StringUtils.hasText((String)this.getActionAttribute()) ? this.getActionAttribute() : actionId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

