/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import java.util.ArrayList;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.Action;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.Event;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.action.AbstractAction;

public class CompositeAction
extends AbstractAction {
    private Action[] actions;
    private String successEventId = "success";
    private String errorEventId = "error";
    private boolean stopOnError;

    public CompositeAction(Action[] actions) {
        Assert.notEmpty((Object[])actions, (String)"At least one action is required");
        this.actions = actions;
    }

    protected Action[] getActions() {
        return this.actions;
    }

    public String getSuccessEventId() {
        return this.successEventId;
    }

    public void setSuccessEventId(String successEventId) {
        this.successEventId = successEventId;
    }

    public String getErrorEventId() {
        return this.errorEventId;
    }

    public void setErrorEventId(String errorEventId) {
        this.errorEventId = errorEventId;
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public Event doExecute(RequestContext context) throws Exception {
        Action[] actions = this.getActions();
        String eventId = this.getSuccessEventId();
        AttributeMap eventAttributes = new AttributeMap();
        ArrayList<Event> actionResults = new ArrayList<Event>(actions.length);
        for (int i = 0; i < actions.length; ++i) {
            Event result = actions[i].execute(context);
            if (result == null) continue;
            actionResults.add(result);
            if (!this.isStopOnError() || result == null || !result.getId().equals(this.getErrorEventId())) continue;
            eventId = this.getErrorEventId();
            break;
        }
        eventAttributes.put("actionResults", actionResults);
        return new Event(this, eventId, eventAttributes);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("actions", (Object)this.getActions()).append("stopOnError", this.isStopOnError()).append("successEventId", (Object)this.getSuccessEventId()).append("errorEventId", (Object)this.getErrorEventId()).toString();
    }
}

