/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.util.Assert;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.action.AbstractBeanInvokingAction;

public class BeanFactoryBeanInvokingAction
extends AbstractBeanInvokingAction
implements BeanFactoryAware {
    public static final String BEAN_PROPERTY = "bean";
    private String targetBeanName;
    private BeanFactory beanFactory;

    public BeanFactoryBeanInvokingAction() {
    }

    public BeanFactoryBeanInvokingAction(String targetBeanName) {
        this.setTargetBeanName(targetBeanName);
    }

    public BeanFactoryBeanInvokingAction(String targetBeanName, BeanFactory beanFactory) {
        this.setTargetBeanName(targetBeanName);
        this.setBeanFactory(beanFactory);
    }

    public String getTargetBeanName() {
        return this.targetBeanName;
    }

    public void setTargetBeanName(String targetBeanName) {
        Assert.hasText((String)targetBeanName, (String)"The name of the target bean to invoke cannot be null or blank -- it is required");
        this.targetBeanName = targetBeanName;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected Object getBean(RequestContext context) {
        String beanName = context.getAttributes().getString(BEAN_PROPERTY, this.getTargetBeanName());
        Assert.hasText((String)beanName, (String)"The bean name to invoke was not specified: set the bean property");
        return this.getBeanFactory().getBean(beanName);
    }
}

