/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.method.MethodInvoker;
import org.springframework.binding.method.MethodSignature;
import org.springframework.core.enums.LabeledEnum;
import org.springframework.webflow.DecisionState;
import org.springframework.webflow.Event;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.ScopeType;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.BeanStatePersister;
import org.springframework.webflow.support.EventFactory;
import org.springframework.webflow.support.EventFactorySupport;

public abstract class AbstractBeanInvokingAction
extends AbstractAction {
    private MethodInvoker methodInvoker = new MethodInvoker();
    private BeanStatePersister statePersister = new NoOpBeanStatePersister();
    private EventFactory eventFactory = new DefaultBeanReturnValueEventFactory();
    static /* synthetic */ Class class$org$springframework$binding$method$MethodSignature;

    protected BeanStatePersister getStatePersister() {
        return this.statePersister;
    }

    public void setConversionService(ConversionService conversionService) {
        this.methodInvoker.setConversionService(conversionService);
    }

    public void setStatePersister(BeanStatePersister statePersister) {
        this.statePersister = statePersister;
    }

    protected EventFactory getEventFactory() {
        return this.eventFactory;
    }

    public void setEventFactory(EventFactory eventFactory) {
        this.eventFactory = eventFactory;
    }

    protected MethodInvoker getMethodInvoker() {
        return this.methodInvoker;
    }

    protected Event doExecute(RequestContext context) throws Exception {
        Object bean = this.getBean(context);
        this.getStatePersister().restoreState(bean, context);
        MethodSignature methodKey = (MethodSignature)context.getAttributes().getRequired("method", class$org$springframework$binding$method$MethodSignature == null ? (class$org$springframework$binding$method$MethodSignature = AbstractBeanInvokingAction.class$("org.springframework.binding.method.MethodSignature")) : class$org$springframework$binding$method$MethodSignature);
        Object returnValue = this.getMethodInvoker().invoke(methodKey, bean, (Object)context);
        this.processMethodReturnValue(returnValue, context);
        Event resultEvent = this.getEventFactory().createEvent(returnValue, context);
        this.getStatePersister().saveState(bean, context);
        return resultEvent;
    }

    protected abstract Object getBean(RequestContext var1);

    protected void processMethodReturnValue(Object returnValue, RequestContext context) {
        String resultName = context.getAttributes().getString("resultName", null);
        if (resultName != null) {
            ScopeType scopeType = (ScopeType)((Object)context.getAttributes().get("resultScope", (Object)ScopeType.REQUEST));
            scopeType.getScope(context).put(resultName, returnValue);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DefaultBeanReturnValueEventFactory
    extends EventFactorySupport
    implements EventFactory {
        private static final String NULL_EVENT_ID = "null";
        private static final String JAVA_LANG_ENUM_CLASSNAME = "java.lang.Enum";
        private static Class java5EnumClass;
        private static Method java5EnumNameMethod;

        public Event createEvent(Object resultObject, RequestContext context) {
            if (resultObject instanceof Event) {
                return (Event)resultObject;
            }
            if (context.getCurrentState() instanceof DecisionState) {
                return this.toDecisionStateEvent(resultObject, context);
            }
            String resultParameterName = context.getAttributes().getString("result", "result");
            return this.success(resultParameterName, resultObject);
        }

        protected Event toDecisionStateEvent(Object resultObject, RequestContext context) {
            if (resultObject == null) {
                return this.result(NULL_EVENT_ID, "result", null);
            }
            if (resultObject instanceof Boolean) {
                return this.yesOrNo((Boolean)resultObject);
            }
            if (java5EnumClass != null && java5EnumClass.equals(resultObject.getClass())) {
                return this.jdk5EnumResult(resultObject);
            }
            if (resultObject instanceof LabeledEnum) {
                String resultId = ((LabeledEnum)resultObject).getLabel();
                return this.result(resultId, "result", resultObject);
            }
            return this.result(String.valueOf(resultObject), "result", resultObject);
        }

        protected Event jdk5EnumResult(Object returnEnumValue) {
            try {
                String resultEventId = (String)java5EnumNameMethod.invoke(returnEnumValue, null);
                return this.result(resultEventId, "result", returnEnumValue);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Should not happen on JDK 1.5");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Should not happen on JDK 1.5");
            }
        }

        static {
            try {
                java5EnumClass = Class.forName(JAVA_LANG_ENUM_CLASSNAME);
                try {
                    java5EnumNameMethod = java5EnumClass.getMethod("name", null);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Should not happen on JDK 1.5");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public static class NoOpBeanStatePersister
    implements BeanStatePersister {
        public void restoreState(Object bean, RequestContext context) throws Exception {
        }

        public void saveState(Object bean, RequestContext context) throws Exception {
        }
    }
}

