/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import org.springframework.core.style.StylerUtils;
import org.springframework.webflow.Event;
import org.springframework.webflow.StateException;
import org.springframework.webflow.TransitionableState;

public class NoMatchingTransitionException
extends StateException {
    private Event event;

    public NoMatchingTransitionException(TransitionableState state, Event event) {
        this(state, event, (Throwable)null);
    }

    public NoMatchingTransitionException(TransitionableState state, Event event, Throwable cause) {
        super(state, "No transition found on occurence of event '" + event.getId() + "' in state '" + state.getId() + "' of flow '" + state.getFlow().getId() + "' -- valid transitional criteria are " + StylerUtils.style((Object)state.getTransitionSet().getTransitionCriterias()) + " -- likely programmer error, check the set of TransitionCriteria for this state", cause);
        this.event = event;
    }

    public NoMatchingTransitionException(TransitionableState state, Event event, String message) {
        this(state, event, message, null);
    }

    public NoMatchingTransitionException(TransitionableState state, Event event, String message, Throwable cause) {
        super(state, message, cause);
        this.event = event;
    }

    public TransitionableState getTransitionableState() {
        return (TransitionableState)this.getState();
    }

    public Event getEvent() {
        return this.event;
    }
}

