/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.BufferedClob;
import com.ingres.gcf.util.CharBuffer;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.SqlNChar;
import com.ingres.gcf.util.SqlNVarChar;
import com.ingres.gcf.util.SqlStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;

public class SqlLongNCharCache
extends SqlData {
    private CharBuffer buffer = null;
    private int segSize = 8192;

    public SqlLongNCharCache() {
        super(true);
    }

    public SqlLongNCharCache(int n) {
        super(true);
        this.segSize = n;
    }

    public void setNull() {
        super.setNull();
        this.buffer = null;
    }

    public String toString() {
        return "SqlCache: " + (this.buffer == null ? "NULL" : this.buffer.toString());
    }

    public void set(Reader reader) throws SqlEx {
        if (reader == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.buffer = new CharBuffer(this.segSize, reader);
        }
    }

    public void set(SqlNChar sqlNChar) throws SqlEx {
        if (sqlNChar == null || sqlNChar.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            sqlNChar.extend();
            this.buffer = new CharBuffer(this.segSize, sqlNChar.value, 0, sqlNChar.length);
        }
    }

    public void set(SqlNVarChar sqlNVarChar) throws SqlEx {
        if (sqlNVarChar == null || sqlNVarChar.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.buffer = new CharBuffer(this.segSize, sqlNVarChar.value, 0, sqlNVarChar.length);
        }
    }

    public Reader get() throws SqlEx {
        return this.buffer.getRdr();
    }

    public void get(Writer writer) throws SqlEx {
        this.buffer.read(writer);
    }

    public void setBoolean(boolean bl) throws SqlEx {
        this.setString(Boolean.toString(bl));
    }

    public void setByte(byte by) throws SqlEx {
        this.setString(Byte.toString(by));
    }

    public void setShort(short s) throws SqlEx {
        this.setString(Short.toString(s));
    }

    public void setInt(int n) throws SqlEx {
        this.setString(Integer.toString(n));
    }

    public void setLong(long l) throws SqlEx {
        this.setString(Long.toString(l));
    }

    public void setFloat(float f) throws SqlEx {
        this.setString(Float.toString(f));
    }

    public void setDouble(double d) throws SqlEx {
        this.setString(Double.toString(d));
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SqlEx {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.setString(bigDecimal.toString());
        }
    }

    public void setString(String string) throws SqlEx {
        if (string == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.buffer = new CharBuffer(this.segSize, string, 0, string.length());
        }
    }

    public void setDate(Date date, TimeZone timeZone) throws SqlEx {
        if (date == null) {
            this.setNull();
        } else if (timeZone != null) {
            this.setString(SqlDates.formatDate((java.util.Date)date, timeZone));
        } else {
            this.setString(SqlDates.formatDate((java.util.Date)date, false));
        }
    }

    public void setTime(Time time, TimeZone timeZone) throws SqlEx {
        if (time == null) {
            this.setNull();
        } else if (timeZone != null) {
            this.setString(SqlDates.formatTime((java.util.Date)time, timeZone));
        } else {
            this.setString(SqlDates.formatTime((java.util.Date)time, false));
        }
    }

    public void setTimestamp(Timestamp timestamp, TimeZone timeZone) throws SqlEx {
        if (timestamp == null) {
            this.setNull();
        } else if (timeZone != null) {
            this.setString(SqlDates.formatTimestamp((java.util.Date)timestamp, timeZone));
        } else {
            this.setString(SqlDates.formatTimestamp((java.util.Date)timestamp, false));
        }
    }

    public void setAsciiStream(InputStream inputStream) throws SqlEx {
        if (inputStream == null) {
            this.setNull();
        } else {
            this.setCharacterStream(SqlLongNCharCache.cnvtAscii(inputStream));
        }
    }

    public void setUnicodeStream(InputStream inputStream) throws SqlEx {
        if (inputStream == null) {
            this.setNull();
        } else {
            this.setCharacterStream(SqlLongNCharCache.cnvtUnicode(inputStream));
        }
    }

    public void setCharacterStream(Reader reader) throws SqlEx {
        if (reader == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.buffer = new CharBuffer(this.segSize, reader);
        }
    }

    public boolean getBoolean() throws SqlEx {
        String string = this.getString().trim();
        return string.equals("1") ? true : Boolean.valueOf(string);
    }

    public byte getByte() throws SqlEx {
        byte by;
        try {
            by = Byte.parseByte(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return by;
    }

    public short getShort() throws SqlEx {
        short s;
        try {
            s = Short.parseShort(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return s;
    }

    public int getInt() throws SqlEx {
        int n;
        try {
            n = Integer.parseInt(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return n;
    }

    public long getLong() throws SqlEx {
        long l;
        try {
            l = Long.parseLong(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return l;
    }

    public float getFloat() throws SqlEx {
        float f;
        try {
            f = Float.parseFloat(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return f;
    }

    public double getDouble() throws SqlEx {
        double d;
        try {
            d = Double.parseDouble(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return d;
    }

    public BigDecimal getBigDecimal() throws SqlEx {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return bigDecimal;
    }

    public String getString() throws SqlEx {
        return this.getString(Integer.MAX_VALUE);
    }

    public String getString(int n) throws SqlEx {
        n = (int)Math.min((long)n, this.buffer.length());
        char[] cArray = new char[n];
        this.buffer.read(0L, cArray, 0, n);
        return new String(cArray);
    }

    public Date getDate(TimeZone timeZone) throws SqlEx {
        String string = this.getString().trim();
        return timeZone == null ? SqlDates.parseDate(string, false) : SqlDates.parseDate(string, timeZone);
    }

    public Time getTime(TimeZone timeZone) throws SqlEx {
        String string = this.getString().trim();
        return timeZone == null ? SqlDates.parseTime(string, false) : SqlDates.parseTime(string, timeZone);
    }

    public Timestamp getTimestamp(TimeZone timeZone) throws SqlEx {
        String string = this.getString().trim();
        return timeZone == null ? SqlDates.parseTimestamp(string, false) : SqlDates.parseTimestamp(string, timeZone);
    }

    public InputStream getAsciiStream() throws SqlEx {
        return SqlStream.getAsciiIS(this.buffer.getRdr());
    }

    public InputStream getUnicodeStream() throws SqlEx {
        return SqlStream.getUnicodeIS(this.buffer.getRdr());
    }

    public Reader getCharacterStream() throws SqlEx {
        return this.buffer.getRdr();
    }

    public Clob getClob() throws SqlEx {
        return new BufferedClob(this.buffer);
    }

    public Object getObject() throws SqlEx {
        return this.getString();
    }

    public Object getObject(int n) throws SqlEx {
        return this.getString(n);
    }
}

