/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDriverPropertyInfo;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.Util;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SQLServerDriver
implements Driver {
    static final String PRODUCT_NAME = "Microsoft SQL Server JDBC Driver 2.0";
    static final String DEFAULT_APP_NAME = "Microsoft SQL Server JDBC Driver";
    private static final String[] TRUE_FALSE = new String[]{"true", "false"};
    private static final SQLServerDriverPropertyInfo[] DRIVER_PROPERTIES = new SQLServerDriverPropertyInfo[]{new SQLServerDriverPropertyInfo("applicationName", "Microsoft SQL Server JDBC Driver", false, null), new SQLServerDriverPropertyInfo("databaseName", "", false, null), new SQLServerDriverPropertyInfo("disableStatementPooling", "true", false, new String[]{"true"}), new SQLServerDriverPropertyInfo("encrypt", "false", false, TRUE_FALSE), new SQLServerDriverPropertyInfo("failoverPartner", "", false, null), new SQLServerDriverPropertyInfo("hostNameInCertificate", "", false, null), new SQLServerDriverPropertyInfo("instanceName", "", false, null), new SQLServerDriverPropertyInfo("integratedSecurity", "false", false, TRUE_FALSE), new SQLServerDriverPropertyInfo("lastUpdateCount", "true", false, TRUE_FALSE), new SQLServerDriverPropertyInfo("lockTimeout", "-1", false, null), new SQLServerDriverPropertyInfo("loginTimeout", "15", false, null), new SQLServerDriverPropertyInfo("packetSize", String.valueOf(8000), false, null), new SQLServerDriverPropertyInfo("password", "", true, null), new SQLServerDriverPropertyInfo("portNumber", "1433", false, null), new SQLServerDriverPropertyInfo("responseBuffering", "adaptive", false, new String[]{"adaptive", "full"}), new SQLServerDriverPropertyInfo("selectMethod", "direct", false, new String[]{"direct", "cursor"}), new SQLServerDriverPropertyInfo("sendStringParametersAsUnicode", "true", false, TRUE_FALSE), new SQLServerDriverPropertyInfo("serverName", "", false, null), new SQLServerDriverPropertyInfo("trustServerCertificate", "false", false, TRUE_FALSE), new SQLServerDriverPropertyInfo("trustStore", "", false, null), new SQLServerDriverPropertyInfo("trustStorePassword", "", false, null), new SQLServerDriverPropertyInfo("user", "", true, null), new SQLServerDriverPropertyInfo("workstationID", "", false, null), new SQLServerDriverPropertyInfo("xopenStates", "false", false, TRUE_FALSE)};
    private static final String[][] driverPropertiesSynonyms = new String[][]{{"database", "databaseName"}, {"userName", "user"}, {"server", "serverName"}, {"port", "portNumber"}};
    private static int baseID = 0;
    private final int instanceID = SQLServerDriver.nextInstanceID();
    private final String traceID = "SQLServerDriver:" + this.instanceID;
    private static final Logger loggerExternal = Logger.getLogger("com.microsoft.sqlserver.jdbc.Driver");
    private final String loggingClassName = "com.microsoft.sqlserver.jdbc.SQLServerDriver:" + this.instanceID;
    private static final Logger drLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerDriver");

    private static synchronized int nextInstanceID() {
        return ++baseID;
    }

    public final String toString() {
        return this.traceID;
    }

    String getClassNameLogging() {
        return this.loggingClassName;
    }

    static Properties fixupProperties(Properties properties) throws SQLServerException {
        Properties properties2 = new Properties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = SQLServerDriver.getNormalizedPropertyName(string, drLogger);
            if (null == string2) continue;
            String string3 = properties.getProperty(string);
            if (null != string3) {
                properties2.setProperty(string2, string3);
                continue;
            }
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidpropertyValue"));
            Object[] objectArray = new Object[]{string};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        return properties2;
    }

    static Properties mergeURLAndSuppliedProperties(Properties properties, Properties properties2) throws SQLServerException {
        if (null == properties2) {
            return properties;
        }
        if (properties2.isEmpty()) {
            return properties;
        }
        Properties properties3 = SQLServerDriver.fixupProperties(properties2);
        for (int i = 0; i < DRIVER_PROPERTIES.length; ++i) {
            String string = DRIVER_PROPERTIES[i].getName();
            String string2 = properties3.getProperty(string);
            if (null == string2) continue;
            properties.put(string, string2);
        }
        return properties;
    }

    static String getNormalizedPropertyName(String string, Logger logger) {
        int n;
        if (null == string) {
            return string;
        }
        for (n = 0; n < driverPropertiesSynonyms.length; ++n) {
            if (!driverPropertiesSynonyms[n][0].equalsIgnoreCase(string)) continue;
            return driverPropertiesSynonyms[n][1];
        }
        for (n = 0; n < DRIVER_PROPERTIES.length; ++n) {
            if (!DRIVER_PROPERTIES[n].getName().equalsIgnoreCase(string)) continue;
            return DRIVER_PROPERTIES[n].getName();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Unknown property" + string);
        }
        return null;
    }

    public Connection connect(String string, Properties properties) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "connect", "Arguments not traced.");
        SQLServerConnection sQLServerConnection = null;
        Properties properties2 = this.parseAndMergeProperties(string, properties);
        if (properties2 != null) {
            sQLServerConnection = new SQLServerConnection(this.toString());
            sQLServerConnection.connect(properties2, null);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "connect", sQLServerConnection);
        return sQLServerConnection;
    }

    private final Properties parseAndMergeProperties(String string, Properties properties) throws SQLServerException {
        if (string == null) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_nullConnection"), null, 0, false);
        }
        Properties properties2 = Util.parseUrl(string, drLogger);
        if (properties2 == null) {
            return null;
        }
        int n = DriverManager.getLoginTimeout();
        if (n > 0) {
            properties2.put("loginTimeout", new Integer(n).toString());
        }
        properties2 = SQLServerDriver.mergeURLAndSuppliedProperties(properties2, properties);
        return properties2;
    }

    public boolean acceptsURL(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "acceptsURL", "Arguments not traced.");
        boolean bl = false;
        try {
            bl = Util.parseUrl(string, drLogger) != null;
        }
        catch (SQLServerException sQLServerException) {
            bl = false;
        }
        loggerExternal.exiting(this.getClassNameLogging(), "acceptsURL", bl);
        return bl;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getPropertyInfo", "Arguments not traced.");
        Properties properties2 = this.parseAndMergeProperties(string, properties);
        if (null == properties2) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_invalidConnection"), null, 0, false);
        }
        DriverPropertyInfo[] driverPropertyInfoArray = SQLServerDriver.getPropertyInfoFromProperties(properties2);
        loggerExternal.exiting(this.getClassNameLogging(), "getPropertyInfo");
        return driverPropertyInfoArray;
    }

    static final DriverPropertyInfo[] getPropertyInfoFromProperties(Properties properties) {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[DRIVER_PROPERTIES.length];
        for (int i = 0; i < DRIVER_PROPERTIES.length; ++i) {
            driverPropertyInfoArray[i] = DRIVER_PROPERTIES[i].build(properties);
        }
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        loggerExternal.entering(this.getClassNameLogging(), "getMajorVersion");
        loggerExternal.exiting(this.getClassNameLogging(), "getMajorVersion", new Integer(2));
        return 2;
    }

    public int getMinorVersion() {
        loggerExternal.entering(this.getClassNameLogging(), "getMinorVersion");
        loggerExternal.exiting(this.getClassNameLogging(), "getMinorVersion", new Integer(0));
        return 0;
    }

    public boolean jdbcCompliant() {
        loggerExternal.entering(this.getClassNameLogging(), "jdbcCompliant");
        loggerExternal.exiting(this.getClassNameLogging(), "jdbcCompliant", true);
        return true;
    }

    static {
        try {
            DriverManager.registerDriver(new SQLServerDriver());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

