/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPooledConnection;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLServerDataSource
implements DataSource,
Referenceable,
Serializable {
    static final Logger dsLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerDataSource");
    static final Logger loggerExternal = Logger.getLogger("com.microsoft.sqlserver.jdbc.DataSource");
    private final String loggingClassName;
    private Properties connectionProps = new Properties();
    private String dataSourceURL;
    private String dataSourceDescription;
    private static int baseDataSourceID = 0;
    private final String traceID;
    private PrintWriter logWriter;

    public SQLServerDataSource() {
        int n = SQLServerDataSource.nextDataSourceID();
        String string = this.getClass().getName();
        this.traceID = string.substring(1 + string.lastIndexOf(46)) + ":" + n;
        this.loggingClassName = "com.microsoft.sqlserver.jdbc." + string.substring(1 + string.lastIndexOf(46)) + ":" + n;
    }

    String getClassNameLogging() {
        return this.loggingClassName;
    }

    public String toString() {
        return this.traceID;
    }

    @Override
    public Connection getConnection() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getConnection");
        SQLServerConnection sQLServerConnection = this.getConnectionInternal(null, null, null);
        loggerExternal.exiting(this.getClassNameLogging(), "getConnection", sQLServerConnection);
        return sQLServerConnection;
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getConnection", new Object[]{string, "Password not traced"});
        }
        SQLServerConnection sQLServerConnection = this.getConnectionInternal(string, string2, null);
        loggerExternal.exiting(this.getClassNameLogging(), "getConnection", sQLServerConnection);
        return sQLServerConnection;
    }

    @Override
    public void setLoginTimeout(int n) {
        this.setIntProperty(this.connectionProps, "loginTimeout", n);
    }

    @Override
    public int getLoginTimeout() {
        int n = this.getIntProperty(this.connectionProps, "loginTimeout", 15);
        return n == 0 ? 15 : n;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        loggerExternal.entering(this.getClassNameLogging(), "setLogWriter", printWriter);
        this.logWriter = printWriter;
        loggerExternal.exiting(this.getClassNameLogging(), "setLogWriter");
    }

    @Override
    public PrintWriter getLogWriter() {
        loggerExternal.entering(this.getClassNameLogging(), "getLogWriter");
        loggerExternal.exiting(this.getClassNameLogging(), "getLogWriter", this.logWriter);
        return this.logWriter;
    }

    public void setApplicationName(String string) {
        this.setStringProperty(this.connectionProps, "applicationName", string);
    }

    public String getApplicationName() {
        return this.getStringProperty(this.connectionProps, "applicationName", "Microsoft SQL Server JDBC Driver");
    }

    public void setDatabaseName(String string) {
        this.setStringProperty(this.connectionProps, "databaseName", string);
    }

    public String getDatabaseName() {
        return this.getStringProperty(this.connectionProps, "databaseName", null);
    }

    public void setInstanceName(String string) {
        this.setStringProperty(this.connectionProps, "instanceName", string);
    }

    public String getInstanceName() {
        return this.getStringProperty(this.connectionProps, "instanceName", null);
    }

    public void setIntegratedSecurity(boolean bl) {
        this.setBooleanProperty(this.connectionProps, "integratedSecurity", bl);
    }

    public void setLastUpdateCount(boolean bl) {
        this.setBooleanProperty(this.connectionProps, "lastUpdateCount", bl);
    }

    public boolean getLastUpdateCount() {
        return this.getBooleanProperty(this.connectionProps, "lastUpdateCount", true);
    }

    public void setEncrypt(boolean bl) {
        this.setBooleanProperty(this.connectionProps, "encrypt", bl);
    }

    public boolean getEncrypt() {
        return this.getBooleanProperty(this.connectionProps, "encrypt", false);
    }

    public void setTrustServerCertificate(boolean bl) {
        this.setBooleanProperty(this.connectionProps, "trustServerCertificate", bl);
    }

    public boolean getTrustServerCertificate() {
        return this.getBooleanProperty(this.connectionProps, "trustServerCertificate", false);
    }

    public void setTrustStore(String string) {
        this.setStringProperty(this.connectionProps, "trustStore", string);
    }

    public String getTrustStore() {
        return this.getStringProperty(this.connectionProps, "trustStore", null);
    }

    public void setTrustStorePassword(String string) {
        this.setStringProperty(this.connectionProps, "trustStorePassword", string);
    }

    public void setHostNameInCertificate(String string) {
        this.setStringProperty(this.connectionProps, "hostNameInCertificate", string);
    }

    public String getHostNameInCertificate() {
        return this.getStringProperty(this.connectionProps, "hostNameInCertificate", null);
    }

    public void setLockTimeout(int n) {
        this.setIntProperty(this.connectionProps, "lockTimeout", n);
    }

    public int getLockTimeout() {
        return this.getIntProperty(this.connectionProps, "lockTimeout", -1);
    }

    public void setPassword(String string) {
        this.setStringProperty(this.connectionProps, "password", string);
    }

    String getPassword() {
        return this.getStringProperty(this.connectionProps, "password", null);
    }

    public void setPortNumber(int n) {
        this.setIntProperty(this.connectionProps, "portNumber", n);
    }

    public int getPortNumber() {
        return this.getIntProperty(this.connectionProps, "portNumber", 1433);
    }

    public void setSelectMethod(String string) {
        this.setStringProperty(this.connectionProps, "selectMethod", string);
    }

    public String getSelectMethod() {
        return this.getStringProperty(this.connectionProps, "selectMethod", "direct");
    }

    public void setResponseBuffering(String string) {
        this.setStringProperty(this.connectionProps, "responseBuffering", string);
    }

    public String getResponseBuffering() {
        return this.getStringProperty(this.connectionProps, "responseBuffering", "adaptive");
    }

    public void setSendStringParametersAsUnicode(boolean bl) {
        this.setBooleanProperty(this.connectionProps, "sendStringParametersAsUnicode", bl);
    }

    public boolean getSendStringParametersAsUnicode() {
        return this.getBooleanProperty(this.connectionProps, "sendStringParametersAsUnicode", true);
    }

    public void setServerName(String string) {
        this.setStringProperty(this.connectionProps, "serverName", string);
    }

    public String getServerName() {
        return this.getStringProperty(this.connectionProps, "serverName", null);
    }

    public void setFailoverPartner(String string) {
        this.setStringProperty(this.connectionProps, "failoverPartner", string);
    }

    public String getFailoverPartner() {
        return this.getStringProperty(this.connectionProps, "failoverPartner", null);
    }

    public void setUser(String string) {
        this.setStringProperty(this.connectionProps, "user", string);
    }

    public String getUser() {
        return this.getStringProperty(this.connectionProps, "user", null);
    }

    public void setWorkstationID(String string) {
        this.setStringProperty(this.connectionProps, "workstationID", string);
    }

    public String getWorkstationID() {
        String string;
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getWorkstationID");
        }
        if (null == (string = this.connectionProps.getProperty("workstationID"))) {
            string = Util.lookupHostName();
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getWorkstationID", string);
        return string;
    }

    public void setXopenStates(boolean bl) {
        this.setBooleanProperty(this.connectionProps, "xopenStates", bl);
    }

    public boolean getXopenStates() {
        return this.getBooleanProperty(this.connectionProps, "xopenStates", false);
    }

    public void setURL(String string) {
        loggerExternal.entering(this.getClassNameLogging(), "setURL", string);
        this.dataSourceURL = string;
        loggerExternal.exiting(this.getClassNameLogging(), "setURL");
    }

    public String getURL() {
        String string = this.dataSourceURL;
        loggerExternal.entering(this.getClassNameLogging(), "getURL");
        if (null == this.dataSourceURL) {
            string = "jdbc:sqlserver://";
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getURL", string);
        return string;
    }

    public void setDescription(String string) {
        loggerExternal.entering(this.getClassNameLogging(), "setDescription", string);
        this.dataSourceDescription = string;
        loggerExternal.exiting(this.getClassNameLogging(), "setDescription");
    }

    public String getDescription() {
        loggerExternal.entering(this.getClassNameLogging(), "getDescription");
        loggerExternal.exiting(this.getClassNameLogging(), "getDescription", this.dataSourceDescription);
        return this.dataSourceDescription;
    }

    public void setPacketSize(int n) {
        this.setIntProperty(this.connectionProps, "packetSize", n);
    }

    public int getPacketSize() {
        return this.getIntProperty(this.connectionProps, "packetSize", 8000);
    }

    private void setStringProperty(Properties properties, String string, String string2) {
        if (loggerExternal.isLoggable(Level.FINER) && !string.contains("password") && !string.contains("Password")) {
            loggerExternal.entering(this.getClassNameLogging(), "set" + string, string2);
        } else {
            loggerExternal.entering(this.getClassNameLogging(), "set" + string);
        }
        if (null != string2) {
            properties.setProperty(string, string2);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "set" + string);
    }

    private String getStringProperty(Properties properties, String string, String string2) {
        String string3;
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "get" + string);
        }
        if (null == (string3 = properties.getProperty(string))) {
            string3 = string2;
        }
        if (loggerExternal.isLoggable(Level.FINER) && !string.contains("password") && !string.contains("Password")) {
            loggerExternal.exiting(this.getClassNameLogging(), "get" + string, string3);
        }
        return string3;
    }

    private void setIntProperty(Properties properties, String string, int n) {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "set" + string, new Integer(n));
        }
        properties.setProperty(string, new Integer(n).toString());
        loggerExternal.exiting(this.getClassNameLogging(), "set" + string);
    }

    private int getIntProperty(Properties properties, String string, int n) {
        int n2;
        block5: {
            if (loggerExternal.isLoggable(Level.FINER)) {
                loggerExternal.entering(this.getClassNameLogging(), "get" + string);
            }
            String string2 = properties.getProperty(string);
            n2 = n;
            if (null != string2) {
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)("Bad portNumber:-" + string2));
                }
            }
        }
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.exiting(this.getClassNameLogging(), "get" + string, new Integer(n2));
        }
        return n2;
    }

    private void setBooleanProperty(Properties properties, String string, boolean bl) {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "set" + string, bl);
        }
        properties.setProperty(string, bl ? "true" : "false");
        loggerExternal.exiting(this.getClassNameLogging(), "set" + string);
    }

    private boolean getBooleanProperty(Properties properties, String string, boolean bl) {
        String string2;
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "get" + string);
        }
        if (null == (string2 = properties.getProperty(string))) {
            return bl;
        }
        Boolean bl2 = Boolean.valueOf(string2);
        loggerExternal.exiting(this.getClassNameLogging(), "get" + string, bl2);
        return bl2;
    }

    SQLServerConnection getConnectionInternal(String string, String string2, SQLServerPooledConnection sQLServerPooledConnection) throws SQLServerException {
        Serializable serializable;
        Properties properties = null;
        Properties properties2 = null;
        if (null != string || null != string2) {
            properties = (Properties)this.connectionProps.clone();
            properties.remove("user");
            properties.remove("password");
            if (null != string) {
                properties.put("user", string);
            }
            if (null != string2) {
                properties.put("password", string2);
            }
        } else {
            properties = this.connectionProps;
        }
        if (null != this.dataSourceURL) {
            serializable = Util.parseUrl(this.dataSourceURL, dsLogger);
            if (null == serializable) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
            }
            properties2 = SQLServerDriver.mergeURLAndSuppliedProperties((Properties)serializable, properties);
        } else {
            properties2 = properties;
        }
        if (dsLogger.isLoggable(Level.FINER)) {
            dsLogger.finer(this.toString() + " Begin create new connection.");
        }
        serializable = new SQLServerConnection(this.toString());
        ((SQLServerConnection)serializable).connect(properties2, sQLServerPooledConnection);
        if (dsLogger.isLoggable(Level.FINER)) {
            dsLogger.finer(this.toString() + " End create new connection " + ((SQLServerConnection)serializable).toString());
        }
        return serializable;
    }

    @Override
    public Reference getReference() {
        loggerExternal.entering(this.getClassNameLogging(), "getReference");
        Reference reference = this.getReferenceInternal("com.microsoft.sqlserver.jdbc.SQLServerDataSource");
        loggerExternal.exiting(this.getClassNameLogging(), "getReference", reference);
        return reference;
    }

    Reference getReferenceInternal(String string) {
        if (dsLogger.isLoggable(Level.FINER)) {
            dsLogger.finer(this.toString() + " creating reference for " + string + ".");
        }
        Reference reference = new Reference(this.getClass().getName(), "com.microsoft.sqlserver.jdbc.SQLServerDataSourceObjectFactory", null);
        reference.add(new StringRefAddr("class", string));
        Enumeration<Object> enumeration = this.connectionProps.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            reference.add(new StringRefAddr(string2, this.connectionProps.getProperty(string2)));
        }
        if (null != this.dataSourceURL) {
            reference.add(new StringRefAddr("dataSourceURL", this.dataSourceURL));
        }
        if (null != this.dataSourceDescription) {
            reference.add(new StringRefAddr("dataSourceDescription", this.dataSourceDescription));
        }
        return reference;
    }

    void initializeFromReference(Reference reference) {
        Enumeration<RefAddr> enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            StringRefAddr stringRefAddr = (StringRefAddr)enumeration.nextElement();
            String string = stringRefAddr.getType();
            String string2 = (String)stringRefAddr.getContent();
            if (string.equals("dataSourceURL")) {
                this.dataSourceURL = string2;
                continue;
            }
            if (string.equals("dataSourceDescription")) {
                this.dataSourceDescription = string2;
                continue;
            }
            if (string.equals("class")) continue;
            this.connectionProps.setProperty(string, string2);
        }
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "isWrapperFor", clazz);
        DriverJDBCVersion.checkSupportsJDBC4();
        boolean bl = clazz.isInstance(this);
        loggerExternal.exiting(this.getClassNameLogging(), "isWrapperFor", bl);
        return bl;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        T t;
        loggerExternal.entering(this.getClassNameLogging(), "unwrap", clazz);
        DriverJDBCVersion.checkSupportsJDBC4();
        try {
            t = clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw new SQLException(classCastException.getMessage());
        }
        loggerExternal.exiting(this.getClassNameLogging(), "unwrap", t);
        return t;
    }

    private static synchronized int nextDataSourceID() {
        return ++baseDataSourceID;
    }
}

