/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.NClob;
import com.microsoft.sqlserver.jdbc.SQLServerSQLXML;
import com.microsoft.sqlserver.jdbc.SSType;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum JavaType {
    INTEGER(Integer.class, JDBCType.INTEGER),
    STRING(String.class, JDBCType.CHAR),
    DATE(Date.class, JDBCType.DATE),
    TIME(Time.class, JDBCType.TIME),
    TIMESTAMP(Timestamp.class, JDBCType.TIMESTAMP),
    BOOLEAN(Boolean.class, JDBCType.BIT),
    BIGDECIMAL(BigDecimal.class, JDBCType.DECIMAL),
    DOUBLE(Double.class, JDBCType.DOUBLE),
    FLOAT(Float.class, JDBCType.REAL),
    SHORT(Short.class, JDBCType.SMALLINT),
    LONG(Long.class, JDBCType.BIGINT),
    BYTE(Byte.class, JDBCType.TINYINT),
    BYTEARRAY(byte[].class, JDBCType.BINARY),
    NCLOB(NClob.class, JDBCType.NCLOB),
    CLOB(Clob.class, JDBCType.CLOB),
    BLOB(Blob.class, JDBCType.BLOB),
    INPUTSTREAM(InputStream.class, JDBCType.UNKNOWN){

        JDBCType getJDBCType(SSType sSType, JDBCType jDBCType) {
            JDBCType jDBCType2;
            if (SSType.UNKNOWN != sSType) {
                switch (sSType) {
                    case CHAR: 
                    case VARCHAR: 
                    case VARCHARMAX: 
                    case TEXT: 
                    case NCHAR: 
                    case NVARCHAR: 
                    case NVARCHARMAX: 
                    case NTEXT: {
                        jDBCType2 = JDBCType.LONGVARCHAR;
                        break;
                    }
                    default: {
                        jDBCType2 = JDBCType.LONGVARBINARY;
                        break;
                    }
                }
            } else {
                JDBCType jDBCType3 = jDBCType2 = jDBCType.isTextual() ? JDBCType.LONGVARCHAR : JDBCType.LONGVARBINARY;
            }
            assert (null != jDBCType2);
            return jDBCType2;
        }
    }
    ,
    READER(Reader.class, JDBCType.LONGVARCHAR),
    SQLXML(SQLServerSQLXML.class, JDBCType.SQLXML),
    OBJECT(Object.class, JDBCType.UNKNOWN);

    private final Class javaClass;
    private final JDBCType jdbcTypeFromJavaType;

    private JavaType(Class clazz, JDBCType jDBCType) {
        this.javaClass = clazz;
        this.jdbcTypeFromJavaType = jDBCType;
    }

    static JavaType of(Object object) {
        if (null != object) {
            for (JavaType javaType : JavaType.values()) {
                if (!javaType.javaClass.isInstance(object)) continue;
                return javaType;
            }
        }
        return OBJECT;
    }

    JDBCType getJDBCType(SSType sSType, JDBCType jDBCType) {
        return this.jdbcTypeFromJavaType;
    }
}

