/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.BaseInputStream;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;

final class AsciiFilteredInputStream
extends InputStream {
    private final InputStream containedStream;
    private static final byte[] ASCII_FILTER;

    AsciiFilteredInputStream(BaseInputStream baseInputStream) throws SQLServerException {
        if (BaseInputStream.logger.isLoggable(Level.FINER)) {
            BaseInputStream.logger.finer(baseInputStream.toString() + " wrapping in AsciiFilteredInputStream");
        }
        this.containedStream = baseInputStream;
    }

    public void close() throws IOException {
        this.containedStream.close();
    }

    public long skip(long l) throws IOException {
        return this.containedStream.skip(l);
    }

    public int available() throws IOException {
        return this.containedStream.available();
    }

    public int read() throws IOException {
        int n = this.containedStream.read();
        if (n >= 0 && n <= 255) {
            return ASCII_FILTER[n];
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.containedStream.read(byArray);
        if (n > 0) {
            assert (n <= byArray.length);
            for (int i = 0; i < n; ++i) {
                byArray[i] = ASCII_FILTER[byArray[i] & 0xFF];
            }
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.containedStream.read(byArray, n, n2);
        if (n3 > 0) {
            assert (n + n3 <= byArray.length);
            for (int i = 0; i < n3; ++i) {
                byArray[n + i] = ASCII_FILTER[byArray[n + i] & 0xFF];
            }
        }
        return n3;
    }

    public boolean markSupported() {
        return this.containedStream.markSupported();
    }

    public void mark(int n) {
        this.containedStream.mark(n);
    }

    public void reset() throws IOException {
        this.containedStream.reset();
    }

    static {
        int n;
        ASCII_FILTER = new byte[256];
        for (n = 0; n < 128; ++n) {
            AsciiFilteredInputStream.ASCII_FILTER[n] = (byte)n;
        }
        for (n = 128; n < 256; ++n) {
            AsciiFilteredInputStream.ASCII_FILTER[n] = 63;
        }
    }
}

