/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util.property;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Properties;
import org.eigenbase.util.property.Trigger;
import org.eigenbase.util.property.TriggerableProperties;

public abstract class Property {
    protected final Properties properties;
    private final String path;
    private final String defaultValue;
    private final TriggerList triggerList = new TriggerList();

    protected Property(Properties properties, String path, String defaultValue) {
        this.properties = properties;
        this.path = path;
        this.defaultValue = defaultValue;
        if (properties instanceof TriggerableProperties) {
            ((TriggerableProperties)properties).register(this);
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    protected String getInternal(String defaultValue, boolean required) {
        String value = this.properties.getProperty(this.path, defaultValue);
        if (value != null) {
            return value;
        }
        if (defaultValue == null && (value = this.getDefaultValue()) != null) {
            return value;
        }
        if (required) {
            throw new RuntimeException("Property " + this.path + " must be set");
        }
        return value;
    }

    public void addTrigger(Trigger trigger) {
        this.triggerList.add(trigger);
    }

    public void removeTrigger(Trigger trigger) {
        this.triggerList.remove(trigger);
    }

    public void onChange(String oldValue, String value) {
        if (TriggerableProperties.equals(oldValue, value)) {
            return;
        }
        this.triggerList.execute(this, value);
    }

    public Object setString(String value) {
        return this.properties.setProperty(this.path, value);
    }

    public boolean isSet() {
        return this.properties.get(this.path) != null;
    }

    public String getString() {
        return this.properties.getProperty(this.path, this.defaultValue);
    }

    public boolean booleanValue() {
        String value = this.getInternal(null, false);
        if (value == null) {
            return false;
        }
        return Property.toBoolean(value);
    }

    protected static boolean toBoolean(String value) {
        return value.equalsIgnoreCase("1") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
    }

    public String stringValue() {
        return this.getInternal(null, false);
    }

    private static class TriggerList
    extends ArrayList {
        private TriggerList() {
        }

        void add(Trigger trigger) {
            Object o = trigger.isPersistent() ? trigger : new WeakReference<Trigger>(trigger);
            ListIterator<Object> it = this.listIterator();
            while (it.hasNext()) {
                Trigger t = this.convert(it.next());
                if (t == null) {
                    it.remove();
                    continue;
                }
                if (trigger.phase() < t.phase()) {
                    it.hasPrevious();
                    it.add(o);
                    return;
                }
                if (trigger.phase() != t.phase()) continue;
                it.add(o);
                return;
            }
            super.add(o);
        }

        void remove(Trigger trigger) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Trigger t = this.convert(it.next());
                if (t == null) {
                    it.remove();
                    continue;
                }
                if (!t.equals(trigger)) continue;
                it.remove();
            }
        }

        void execute(Property property, String value) throws Trigger.VetoRT {
            Trigger t;
            ArrayList<Trigger> l = new ArrayList<Trigger>();
            Iterator it = this.iterator();
            while (it.hasNext()) {
                t = this.convert(it.next());
                if (t == null) {
                    it.remove();
                    continue;
                }
                l.add(t);
            }
            it = l.iterator();
            while (it.hasNext()) {
                t = (Trigger)it.next();
                t.execute(property, value);
            }
        }

        private Trigger convert(Object o) {
            if (o instanceof WeakReference) {
                o = ((WeakReference)o).get();
            }
            return (Trigger)o;
        }
    }
}

