/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui.validate;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import mondrian.gui.I18n;
import mondrian.gui.MondrianGuiDef;
import mondrian.gui.ParentInPath;
import mondrian.gui.SchemaExplorer;
import mondrian.gui.validate.JdbcValidator;
import org.apache.log4j.Logger;
import org.eigenbase.xom.ElementDef;

public class ValidationUtils {
    private static final Logger LOGGER = Logger.getLogger(ValidationUtils.class);
    static String[] DEF_LEVEL = new String[]{"column", "nameColumn", "parentColumn", "ordinalColumn", "captionColumn"};

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String invalid(I18n messages, JdbcValidator jdbcValidator, TreeModel treeModel, TreePath tpath, Object value, boolean isSchemaRequired) {
        MondrianGuiDef.Cube cube;
        block127: {
            void var18_66;
            int n;
            ElementDef[] arr$;
            HashMap<String, Integer> columns;
            block158: {
                int len$;
                ElementDef[] arr$2;
                boolean foundRole;
                MondrianGuiDef.RoleUsage roleUsage;
                block156: {
                    void var17_53;
                    MondrianGuiDef.Dimension foundDimension;
                    MondrianGuiDef.CubeDimension[] dimensionsToCheck;
                    MondrianGuiDef.VirtualCubeDimension vcd;
                    block138: {
                        void var18_61;
                        int n2;
                        MondrianGuiDef.Cube[] arr$3;
                        MondrianGuiDef.Cube foundCube;
                        block137: {
                            boolean notfound;
                            String sourcename;
                            MondrianGuiDef.Dimension[] ds;
                            block134: {
                                block159: {
                                    String nameMustBeSet;
                                    block157: {
                                        void var18_64;
                                        block155: {
                                            MondrianGuiDef.Schema schema;
                                            block154: {
                                                block153: {
                                                    block152: {
                                                        block151: {
                                                            block150: {
                                                                block149: {
                                                                    block148: {
                                                                        block147: {
                                                                            block146: {
                                                                                block145: {
                                                                                    block144: {
                                                                                        block143: {
                                                                                            block142: {
                                                                                                MondrianGuiDef.Level[] levels;
                                                                                                MondrianGuiDef.Dimension parentDimension;
                                                                                                block141: {
                                                                                                    block139: {
                                                                                                        String table;
                                                                                                        String column;
                                                                                                        block140: {
                                                                                                            MondrianGuiDef.Level parentLevel;
                                                                                                            MondrianGuiDef.Hierarchy parentHierarchy;
                                                                                                            block132: {
                                                                                                                block136: {
                                                                                                                    block135: {
                                                                                                                        block133: {
                                                                                                                            MondrianGuiDef.Schema s;
                                                                                                                            block131: {
                                                                                                                                block130: {
                                                                                                                                    block129: {
                                                                                                                                        block128: {
                                                                                                                                            schema = null;
                                                                                                                                            cube = null;
                                                                                                                                            parentDimension = null;
                                                                                                                                            parentHierarchy = null;
                                                                                                                                            parentLevel = null;
                                                                                                                                            nameMustBeSet = messages.getString("schemaTreeCellRenderer.nameMustBeSet.alert", "Name must be set");
                                                                                                                                            if (tpath != null) {
                                                                                                                                                ParentInPath aParent = ParentInPath.getParentInPath(tpath, MondrianGuiDef.Schema.class);
                                                                                                                                                schema = (MondrianGuiDef.Schema)((Object)aParent.parent);
                                                                                                                                                aParent = ParentInPath.getParentInPath(tpath, MondrianGuiDef.Cube.class);
                                                                                                                                                cube = (MondrianGuiDef.Cube)((Object)aParent.parent);
                                                                                                                                                aParent = ParentInPath.getParentInPath(tpath, MondrianGuiDef.Dimension.class);
                                                                                                                                                parentDimension = (MondrianGuiDef.Dimension)((Object)aParent.parent);
                                                                                                                                                aParent = ParentInPath.getParentInPath(tpath, MondrianGuiDef.Hierarchy.class);
                                                                                                                                                parentHierarchy = (MondrianGuiDef.Hierarchy)((Object)aParent.parent);
                                                                                                                                                aParent = ParentInPath.getParentInPath(tpath, MondrianGuiDef.Level.class);
                                                                                                                                                parentLevel = (MondrianGuiDef.Level)((Object)aParent.parent);
                                                                                                                                            }
                                                                                                                                            if (!(value instanceof MondrianGuiDef.Schema)) break block128;
                                                                                                                                            s = (MondrianGuiDef.Schema)((Object)value);
                                                                                                                                            if (ValidationUtils.isEmpty(s.name)) {
                                                                                                                                                return nameMustBeSet;
                                                                                                                                            }
                                                                                                                                            if (s.cubes == null) return messages.getString("schemaTreeCellRenderer.schemaMustHaveCubes.alert", "Schema must contain cubes");
                                                                                                                                            if (s.cubes.length == 0) {
                                                                                                                                                return messages.getString("schemaTreeCellRenderer.schemaMustHaveCubes.alert", "Schema must contain cubes");
                                                                                                                                            }
                                                                                                                                            break block127;
                                                                                                                                        }
                                                                                                                                        if (!(value instanceof MondrianGuiDef.VirtualCube)) break block129;
                                                                                                                                        MondrianGuiDef.VirtualCube virtCube = (MondrianGuiDef.VirtualCube)((Object)value);
                                                                                                                                        if (ValidationUtils.isEmpty(virtCube.name)) {
                                                                                                                                            return nameMustBeSet;
                                                                                                                                        }
                                                                                                                                        if (ValidationUtils.isEmpty((Object[])virtCube.dimensions)) {
                                                                                                                                            return messages.getString("schemaTreeCellRenderer.cubeMustHaveDimensions.alert", "Cube must contain dimensions");
                                                                                                                                        }
                                                                                                                                        if (ValidationUtils.isEmpty((Object[])virtCube.measures)) {
                                                                                                                                            return messages.getString("schemaTreeCellRenderer.cubeMustHaveMeasures.alert", "Cube must contain measures");
                                                                                                                                        }
                                                                                                                                        break block127;
                                                                                                                                    }
                                                                                                                                    if (!(value instanceof MondrianGuiDef.VirtualCubeMeasure)) break block130;
                                                                                                                                    if (ValidationUtils.isEmpty(((MondrianGuiDef.VirtualCubeMeasure)((Object)value)).name)) {
                                                                                                                                        return nameMustBeSet;
                                                                                                                                    }
                                                                                                                                    break block127;
                                                                                                                                }
                                                                                                                                if (!(value instanceof MondrianGuiDef.Cube)) break block131;
                                                                                                                                MondrianGuiDef.Cube cubeVal = (MondrianGuiDef.Cube)((Object)value);
                                                                                                                                if (ValidationUtils.isEmpty(cubeVal.name)) {
                                                                                                                                    return nameMustBeSet;
                                                                                                                                }
                                                                                                                                if (cubeVal.fact == null) {
                                                                                                                                    return messages.getString("schemaTreeCellRenderer.factMustBeSet.alert", "Fact must be set: Table, View or InlineTable");
                                                                                                                                }
                                                                                                                                if (cubeVal.fact instanceof MondrianGuiDef.Table) {
                                                                                                                                    if (ValidationUtils.isEmpty(((MondrianGuiDef.Table)cubeVal.fact).name)) return messages.getString("schemaTreeCellRenderer.factNameMustBeSet.alert", "Fact name must be set");
                                                                                                                                }
                                                                                                                                if (cubeVal.fact instanceof MondrianGuiDef.View) {
                                                                                                                                    if (ValidationUtils.isEmpty(((MondrianGuiDef.View)cubeVal.fact).alias)) return messages.getString("schemaTreeCellRenderer.factNameMustBeSet.alert", "Fact name must be set");
                                                                                                                                }
                                                                                                                                if (cubeVal.fact instanceof MondrianGuiDef.InlineTable && ValidationUtils.isEmpty(((MondrianGuiDef.InlineTable)cubeVal.fact).alias)) {
                                                                                                                                    return messages.getString("schemaTreeCellRenderer.factNameMustBeSet.alert", "Fact name must be set");
                                                                                                                                }
                                                                                                                                if (ValidationUtils.isEmpty((Object[])cubeVal.dimensions)) {
                                                                                                                                    return messages.getString("schemaTreeCellRenderer.cubeMustHaveDimensions.alert", "Cube must contain dimensions");
                                                                                                                                }
                                                                                                                                if (ValidationUtils.isEmpty((Object[])cubeVal.measures)) {
                                                                                                                                    return messages.getString("schemaTreeCellRenderer.cubeMustHaveMeasures.alert", "Cube must contain measures");
                                                                                                                                }
                                                                                                                                if (jdbcValidator.isInitialized() && ((MondrianGuiDef.Cube)((Object)value)).fact instanceof MondrianGuiDef.Table) {
                                                                                                                                    MondrianGuiDef.Table table2 = (MondrianGuiDef.Table)cubeVal.fact;
                                                                                                                                    String schemaName = table2.schema;
                                                                                                                                    String factTable = table2.name;
                                                                                                                                    if (!jdbcValidator.isTableExists(schemaName, factTable)) {
                                                                                                                                        return messages.getFormattedString("schemaTreeCellRenderer.factTableDoesNotExist.alert", "Fact table {0} does not exist in database {1}", factTable, schemaName == null || schemaName.equals("") ? "." : "schema " + schemaName);
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                break block127;
                                                                                                                            }
                                                                                                                            if (!(value instanceof MondrianGuiDef.CubeDimension)) break block132;
                                                                                                                            if (ValidationUtils.isEmpty(((MondrianGuiDef.CubeDimension)((Object)value)).name)) {
                                                                                                                                return nameMustBeSet;
                                                                                                                            }
                                                                                                                            if (!(value instanceof MondrianGuiDef.DimensionUsage)) break block133;
                                                                                                                            if (ValidationUtils.isEmpty(((MondrianGuiDef.DimensionUsage)((Object)value)).source)) {
                                                                                                                                return messages.getString("schemaTreeCellRenderer.sourceMustBeSet.alert", "Source must be set");
                                                                                                                            }
                                                                                                                            s = (MondrianGuiDef.Schema)((Object)treeModel.getRoot());
                                                                                                                            ds = s.dimensions;
                                                                                                                            sourcename = ((MondrianGuiDef.DimensionUsage)((Object)value)).source;
                                                                                                                            notfound = true;
                                                                                                                            break block134;
                                                                                                                        }
                                                                                                                        if (!(value instanceof MondrianGuiDef.Dimension) || cube == null) break block135;
                                                                                                                        if (!ValidationUtils.isEmpty(((MondrianGuiDef.Dimension)((Object)value)).foreignKey) && jdbcValidator.isInitialized() && cube.fact instanceof MondrianGuiDef.Table) {
                                                                                                                            MondrianGuiDef.Table factTable = (MondrianGuiDef.Table)cube.fact;
                                                                                                                            String foreignKey = ((MondrianGuiDef.Dimension)((Object)value)).foreignKey;
                                                                                                                            if (!jdbcValidator.isColExists(factTable.schema, factTable.name, foreignKey)) {
                                                                                                                                return messages.getFormattedString("schemaTreeCellRenderer.foreignKeyDoesNotExist.alert", "foreignKey {0} does not exist in fact table", foreignKey);
                                                                                                                            }
                                                                                                                        }
                                                                                                                        break block127;
                                                                                                                    }
                                                                                                                    if (!(value instanceof MondrianGuiDef.VirtualCubeDimension)) break block127;
                                                                                                                    vcd = (MondrianGuiDef.VirtualCubeDimension)((Object)value);
                                                                                                                    dimensionsToCheck = null;
                                                                                                                    foundDimension = null;
                                                                                                                    if (schema == null) break block127;
                                                                                                                    if (ValidationUtils.isEmpty(vcd.cubeName)) break block136;
                                                                                                                    foundCube = null;
                                                                                                                    arr$3 = schema.cubes;
                                                                                                                    n2 = arr$3.length;
                                                                                                                    boolean bl = false;
                                                                                                                    break block137;
                                                                                                                }
                                                                                                                dimensionsToCheck = schema.dimensions;
                                                                                                                break block138;
                                                                                                            }
                                                                                                            if (value instanceof MondrianGuiDef.Level) {
                                                                                                                String column2;
                                                                                                                MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)value);
                                                                                                                if (!ValidationUtils.isEmpty(level.levelType) && parentDimension != null) {
                                                                                                                    if ((ValidationUtils.isEmpty(parentDimension.type) || parentDimension.type.equals("StandardDimension")) && !ValidationUtils.isEmpty(level.levelType) && !level.levelType.equals(MondrianGuiDef.Level._levelType_values[0])) {
                                                                                                                        return messages.getFormattedString("schemaTreeCellRenderer.levelUsedOnlyInTimeDimension.alert", "levelType {0} can only be used with a TimeDimension", level.levelType);
                                                                                                                    }
                                                                                                                    if (!ValidationUtils.isEmpty(parentDimension.type) && parentDimension.type.equals("TimeDimension") && !ValidationUtils.isEmpty(level.levelType) && level.levelType.equals(MondrianGuiDef.Level._levelType_values[0])) {
                                                                                                                        return messages.getFormattedString("schemaTreeCellRenderer.levelUsedOnlyInStandardDimension.alert", "levelType {0} can only be used with a StandardDimension", level.levelType);
                                                                                                                    }
                                                                                                                }
                                                                                                                if (ValidationUtils.isEmpty(column2 = level.column)) {
                                                                                                                    if (level.properties == null) return messages.getString("schemaTreeCellRenderer.columnMustBeSet.alert", "Column must be set");
                                                                                                                    if (level.properties.length == 0) {
                                                                                                                        return messages.getString("schemaTreeCellRenderer.columnMustBeSet.alert", "Column must be set");
                                                                                                                    }
                                                                                                                    break block127;
                                                                                                                } else {
                                                                                                                    String theMessage = null;
                                                                                                                    try {
                                                                                                                        int i = 0;
                                                                                                                        while (i < DEF_LEVEL.length) {
                                                                                                                            Field theField = ((Object)((Object)level)).getClass().getDeclaredField(DEF_LEVEL[i]);
                                                                                                                            column2 = (String)theField.get((Object)level);
                                                                                                                            theMessage = ValidationUtils.validateColumn(column2, DEF_LEVEL[i], messages, level, jdbcValidator, cube, parentHierarchy);
                                                                                                                            if (theMessage != null) {
                                                                                                                                return theMessage;
                                                                                                                            }
                                                                                                                            ++i;
                                                                                                                        }
                                                                                                                        return theMessage;
                                                                                                                    }
                                                                                                                    catch (Exception ex) {
                                                                                                                        LOGGER.error((Object)"ValidationUtils", (Throwable)ex);
                                                                                                                    }
                                                                                                                    return theMessage;
                                                                                                                }
                                                                                                            }
                                                                                                            if (!(value instanceof MondrianGuiDef.Property)) break block139;
                                                                                                            MondrianGuiDef.Property p = (MondrianGuiDef.Property)((Object)value);
                                                                                                            column = p.column;
                                                                                                            if (ValidationUtils.isEmpty(column)) {
                                                                                                                return messages.getString("schemaTreeCellRenderer.columnMustBeSet.alert", "Column must be set");
                                                                                                            }
                                                                                                            if (!jdbcValidator.isInitialized()) break block127;
                                                                                                            table = null;
                                                                                                            if (parentLevel != null) {
                                                                                                                table = parentLevel.table;
                                                                                                            }
                                                                                                            if (!ValidationUtils.isEmpty(table)) break block140;
                                                                                                            if (parentHierarchy != null) {
                                                                                                                if (parentHierarchy.relation == null && cube != null && cube.fact instanceof MondrianGuiDef.Table) {
                                                                                                                    MondrianGuiDef.Table factTable = (MondrianGuiDef.Table)cube.fact;
                                                                                                                    if (!jdbcValidator.isColExists(factTable.schema, factTable.name, column)) {
                                                                                                                        return messages.getFormattedString("schemaTreeCellRenderer.degenDimensionColumnDoesNotExist.alert", "Degenerate dimension validation check - Column {0} does not exist in fact table", column);
                                                                                                                    }
                                                                                                                    break block127;
                                                                                                                } else if (parentHierarchy.relation instanceof MondrianGuiDef.Table) {
                                                                                                                    MondrianGuiDef.Table parentTable = (MondrianGuiDef.Table)parentHierarchy.relation;
                                                                                                                    if (!jdbcValidator.isColExists(parentTable.schema, parentTable.name, column)) {
                                                                                                                        return messages.getFormattedString("schemaTreeCellRenderer.columnInDimensionDoesNotExist.alert", "Column {0} does not exist in Dimension table", parentTable.name);
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                            break block127;
                                                                                                        }
                                                                                                        if (!jdbcValidator.isColExists(null, table, column)) {
                                                                                                            return messages.getFormattedString("schemaTreeCellRenderer.columnInDimensionDoesNotExist.alert", "Column {0} does not exist in Level table {1}", column, table);
                                                                                                        }
                                                                                                        break block127;
                                                                                                    }
                                                                                                    if (!(value instanceof MondrianGuiDef.Measure)) break block141;
                                                                                                    MondrianGuiDef.Measure measure = (MondrianGuiDef.Measure)((Object)value);
                                                                                                    if (ValidationUtils.isEmpty(measure.name)) {
                                                                                                        return nameMustBeSet;
                                                                                                    }
                                                                                                    if (ValidationUtils.isEmpty(measure.aggregator)) {
                                                                                                        return messages.getString("schemaTreeCellRenderer.aggregatorMustBeSet.alert", "Aggregator must be set");
                                                                                                    }
                                                                                                    if (measure.measureExp == null) {
                                                                                                        if (ValidationUtils.isEmpty(measure.column)) {
                                                                                                            return messages.getString("schemaTreeCellRenderer.columnMustBeSet.alert", "Column must be set");
                                                                                                        }
                                                                                                        if (cube != null && cube.fact != null && cube.fact instanceof MondrianGuiDef.Table && jdbcValidator.isInitialized()) {
                                                                                                            MondrianGuiDef.Table factTable = (MondrianGuiDef.Table)cube.fact;
                                                                                                            String column = measure.column;
                                                                                                            if (jdbcValidator.isColExists(factTable.schema, factTable.name, column)) {
                                                                                                                boolean numericAggregatorRequired;
                                                                                                                int colType = Math.abs(jdbcValidator.getColumnDataType(factTable.schema, factTable.name, measure.column));
                                                                                                                boolean bl = numericAggregatorRequired = "sum".equals(measure.aggregator) || "avg".equals(measure.aggregator);
                                                                                                                if (numericAggregatorRequired && (colType < 2 || colType > 8)) {
                                                                                                                    return messages.getFormattedString("schemaTreeCellRenderer.numericColumnRequiredForAggregator.alert", "Data type of the column {0} must be numeric for Aggregator {1}", measure.column, measure.aggregator);
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                    break block127;
                                                                                                }
                                                                                                if (!(value instanceof MondrianGuiDef.Hierarchy)) break block142;
                                                                                                MondrianGuiDef.Hierarchy hierarchy = (MondrianGuiDef.Hierarchy)((Object)value);
                                                                                                if (hierarchy.relation == null && parentDimension != null && cube == null) {
                                                                                                    return messages.getString("schemaTreeCellRenderer.hierarchyRelationMustBeSet.alert", "Table, Join, View or InlineTable must be set for Hierarchy");
                                                                                                }
                                                                                                if (hierarchy.relation instanceof MondrianGuiDef.Join) {
                                                                                                    if (ValidationUtils.isEmpty(hierarchy.primaryKeyTable)) {
                                                                                                        if (!ValidationUtils.isEmpty(hierarchy.primaryKey)) return messages.getString("schemaTreeCellRenderer.primaryKeyTableMustBeSet.alert", "PrimaryKeyTable must be set for Join");
                                                                                                        return messages.getString("schemaTreeCellRenderer.primaryKeyTableAndPrimaryKeyMustBeSet.alert", "PrimaryKeyTable and PrimaryKey must be set for Join");
                                                                                                    }
                                                                                                    if (ValidationUtils.isEmpty(hierarchy.primaryKey)) {
                                                                                                        return messages.getString("schemaTreeCellRenderer.primaryKeyMustBeSet.alert", "PrimaryKey must be set for Join");
                                                                                                    }
                                                                                                }
                                                                                                if ((levels = hierarchy.levels) == null) return messages.getString("schemaTreeCellRenderer.atLeastOneLevelForHierarchy.alert", "At least one Level must be set for Hierarchy");
                                                                                                if (levels.length == 0) {
                                                                                                    return messages.getString("schemaTreeCellRenderer.atLeastOneLevelForHierarchy.alert", "At least one Level must be set for Hierarchy");
                                                                                                }
                                                                                                if (hierarchy.relation instanceof MondrianGuiDef.Table && !ValidationUtils.isEmpty(hierarchy.primaryKeyTable)) {
                                                                                                    return messages.getString("schemaTreeCellRenderer.fieldMustBeEmpty.alert", "Table field must be empty");
                                                                                                }
                                                                                                String primaryKeyTable = hierarchy.primaryKeyTable;
                                                                                                if (!ValidationUtils.isEmpty(primaryKeyTable) && hierarchy.relation instanceof MondrianGuiDef.Join) {
                                                                                                    TreeSet<String> joinTables = new TreeSet<String>();
                                                                                                    SchemaExplorer.getTableNamesForJoin(hierarchy.relation, joinTables);
                                                                                                    if (!joinTables.contains(primaryKeyTable)) {
                                                                                                        return messages.getString("schemaTreeCellRenderer.wrongTableValue.alert", "Table value does not correspond to any join");
                                                                                                    }
                                                                                                }
                                                                                                if (!ValidationUtils.isEmpty(primaryKeyTable) && hierarchy.relation instanceof MondrianGuiDef.Table) {
                                                                                                    String compareTo;
                                                                                                    MondrianGuiDef.Table theTable = (MondrianGuiDef.Table)hierarchy.relation;
                                                                                                    String string = compareTo = theTable.alias != null && theTable.alias.trim().length() > 0 ? theTable.alias : theTable.name;
                                                                                                    if (!primaryKeyTable.equals(compareTo)) {
                                                                                                        return messages.getString("schemaTreeCellRenderer.tableDoesNotMatch.alert", "Table value does not correspond to Hierarchy Relation");
                                                                                                    }
                                                                                                }
                                                                                                String dbSchema = null;
                                                                                                String pkTable = null;
                                                                                                if (hierarchy.relation instanceof MondrianGuiDef.Join) {
                                                                                                    if (ValidationUtils.isEmpty(hierarchy.primaryKey)) {
                                                                                                        return messages.getString("schemaTreeCellRenderer.noPrimaryKeyForJoin.alert", "Primary key not set for Join");
                                                                                                    }
                                                                                                    String[] stringArray = SchemaExplorer.getTableNameForAlias(hierarchy.relation, hierarchy.primaryKeyTable);
                                                                                                    dbSchema = stringArray[0];
                                                                                                    pkTable = stringArray[1];
                                                                                                } else if (hierarchy.relation instanceof MondrianGuiDef.Table) {
                                                                                                    if (ValidationUtils.isEmpty(hierarchy.primaryKey)) {
                                                                                                        return messages.getString("schemaTreeCellRenderer.noPrimaryKeyForTable.alert", "Primary key not set for Table");
                                                                                                    }
                                                                                                    pkTable = ((MondrianGuiDef.Table)hierarchy.relation).name;
                                                                                                    dbSchema = ((MondrianGuiDef.Table)hierarchy.relation).schema;
                                                                                                }
                                                                                                if (pkTable != null && !jdbcValidator.isColExists(dbSchema, pkTable, hierarchy.primaryKey)) {
                                                                                                    return messages.getFormattedString("schemaTreeCellRenderer.columnInTableDoesNotExist.alert", "Column {0} defined in field {1} does not exist in table {2}", ValidationUtils.isEmpty(hierarchy.primaryKey.trim()) ? "' '" : hierarchy.primaryKey, "primaryKey", pkTable);
                                                                                                }
                                                                                                break block127;
                                                                                            }
                                                                                            if (!(value instanceof MondrianGuiDef.NamedSet)) break block143;
                                                                                            MondrianGuiDef.NamedSet namedSet = (MondrianGuiDef.NamedSet)((Object)value);
                                                                                            if (ValidationUtils.isEmpty(namedSet.name)) {
                                                                                                return nameMustBeSet;
                                                                                            }
                                                                                            if (ValidationUtils.isEmpty(namedSet.formula) && namedSet.formulaElement == null) {
                                                                                                return messages.getString("schemaTreeCellRenderer.formulaMustBeSet.alert", "Formula must be set");
                                                                                            }
                                                                                            break block127;
                                                                                        }
                                                                                        if (!(value instanceof MondrianGuiDef.Formula)) break block144;
                                                                                        MondrianGuiDef.Formula formula = (MondrianGuiDef.Formula)((Object)value);
                                                                                        if (ValidationUtils.isEmpty(formula.cdata)) {
                                                                                            return messages.getString("schemaTreeCellRenderer.formulaMustBeSet.alert", "Formula must be set");
                                                                                        }
                                                                                        break block127;
                                                                                    }
                                                                                    if (!(value instanceof MondrianGuiDef.UserDefinedFunction)) break block145;
                                                                                    MondrianGuiDef.UserDefinedFunction udf = (MondrianGuiDef.UserDefinedFunction)((Object)value);
                                                                                    if (ValidationUtils.isEmpty(udf.name)) {
                                                                                        return nameMustBeSet;
                                                                                    }
                                                                                    if (ValidationUtils.isEmpty(udf.className)) {
                                                                                        return messages.getString("schemaTreeCellRenderer.classNameMustBeSet.alert", "Class name must be set");
                                                                                    }
                                                                                    break block127;
                                                                                }
                                                                                if (!(value instanceof MondrianGuiDef.CalculatedMember)) break block146;
                                                                                MondrianGuiDef.CalculatedMember calculatedMember = (MondrianGuiDef.CalculatedMember)((Object)value);
                                                                                if (ValidationUtils.isEmpty(calculatedMember.name)) {
                                                                                    return nameMustBeSet;
                                                                                }
                                                                                if (ValidationUtils.isEmpty(calculatedMember.dimension)) {
                                                                                    return messages.getString("schemaTreeCellRenderer.dimensionMustBeSet.alert", "Dimension must be set");
                                                                                }
                                                                                if (ValidationUtils.isEmpty(calculatedMember.formula) && calculatedMember.formulaElement == null) {
                                                                                    return messages.getString("schemaTreeCellRenderer.formulaMustBeSet.alert", "Formula must be set");
                                                                                }
                                                                                break block127;
                                                                            }
                                                                            if (!(value instanceof MondrianGuiDef.Join)) break block147;
                                                                            MondrianGuiDef.Join join = (MondrianGuiDef.Join)((Object)value);
                                                                            if (join.left == null) {
                                                                                return messages.getString("schemaTreeCellRenderer.leftJoinMustBeSet.alert", "Left Join must be set");
                                                                            }
                                                                            if (ValidationUtils.isEmpty(join.leftAlias) && join.left instanceof MondrianGuiDef.Join) {
                                                                                return messages.getString("schemaTreeCellRenderer.leftAliasMustBeSet.alert", "Left alias must be set");
                                                                            }
                                                                            if (ValidationUtils.isEmpty(join.leftKey)) {
                                                                                return messages.getString("schemaTreeCellRenderer.leftKeyMustBeSet.alert", "Left key must be set");
                                                                            }
                                                                            if (join.right == null) {
                                                                                return messages.getString("schemaTreeCellRenderer.rightJoinMustBeSet.alert", "Right Join must be set");
                                                                            }
                                                                            if (ValidationUtils.isEmpty(join.rightAlias) && join.right instanceof MondrianGuiDef.Join) {
                                                                                return messages.getString("schemaTreeCellRenderer.rightAliasMustBeSet.alert", "Right alias must be set");
                                                                            }
                                                                            if (ValidationUtils.isEmpty(join.rightKey)) {
                                                                                return messages.getString("schemaTreeCellRenderer.rightKeyMustBeSet.alert", "Right key must be set");
                                                                            }
                                                                            break block127;
                                                                        }
                                                                        if (!(value instanceof MondrianGuiDef.Table)) break block148;
                                                                        MondrianGuiDef.Table table = (MondrianGuiDef.Table)((Object)value);
                                                                        String tableName = table.name;
                                                                        if (!jdbcValidator.isTableExists(null, tableName)) {
                                                                            return messages.getFormattedString("schemaTreeCellRenderer.tableDoesNotExist.alert", "Table {0} does not exist in database", tableName);
                                                                        }
                                                                        String theSchema = table.schema;
                                                                        if (!ValidationUtils.isEmpty(theSchema) && !jdbcValidator.isSchemaExists(theSchema)) {
                                                                            return messages.getFormattedString("schemaTreeCellRenderer.schemaDoesNotExist.alert", "Schema {0} does not exist", theSchema);
                                                                        }
                                                                        if (ValidationUtils.isEmpty(theSchema) && isSchemaRequired) {
                                                                            return messages.getString("schemaTreeCellRenderer.schemaMustBeSet.alert", "Schema must be set");
                                                                        }
                                                                        break block127;
                                                                    }
                                                                    if (!(value instanceof MondrianGuiDef.InlineTable)) break block149;
                                                                    MondrianGuiDef.InlineTable inlineTable = (MondrianGuiDef.InlineTable)((Object)value);
                                                                    if (ValidationUtils.isEmpty(inlineTable.alias)) {
                                                                        return messages.getString("schemaTreeCellRenderer.inlineAliasNotSet.alert", "Alias must be set");
                                                                    }
                                                                    if (inlineTable.columnDefs == null) {
                                                                        return messages.getString("schemaTreeCellRenderer.inlineColumnDefsNotSet.alert", "Column Definitions must be set");
                                                                    }
                                                                    if (inlineTable.rows == null) {
                                                                        return messages.getString("schemaTreeCellRenderer.inlineRowsNotSet.alert", "Rows must be set");
                                                                    }
                                                                    break block127;
                                                                }
                                                                if (!(value instanceof MondrianGuiDef.ColumnDefs)) break block150;
                                                                MondrianGuiDef.ColumnDefs columnDefs = (MondrianGuiDef.ColumnDefs)((Object)value);
                                                                if (columnDefs.array == null) return messages.getString("schemaTreeCellRenderer.inlineColumnDefsNotSet.alert", "Column Definitions must be set");
                                                                if (columnDefs.array.length == 0) {
                                                                    return messages.getString("schemaTreeCellRenderer.inlineColumnDefsNotSet.alert", "Column Definitions must be set");
                                                                }
                                                                HashSet<String> columnNames = new HashSet<String>();
                                                                for (MondrianGuiDef.ColumnDef columnDef : columnDefs.array) {
                                                                    columnNames.add(columnDef.name);
                                                                }
                                                                if (columnNames.size() != columnDefs.array.length) {
                                                                    return messages.getString("schemaTreeCellRenderer.inlineColumnDefsNamesNotUnique.alert", "Column names are not unique");
                                                                }
                                                                break block127;
                                                            }
                                                            if (!(value instanceof MondrianGuiDef.Rows)) break block151;
                                                            MondrianGuiDef.Rows rows = (MondrianGuiDef.Rows)((Object)value);
                                                            if (rows.array == null) return messages.getString("schemaTreeCellRenderer.inlineRowsNotSet.alert", "Rows must be set");
                                                            if (rows.array.length == 0) {
                                                                return messages.getString("schemaTreeCellRenderer.inlineRowsNotSet.alert", "Rows must be set");
                                                            }
                                                            break block127;
                                                        }
                                                        if (!(value instanceof MondrianGuiDef.ColumnDef)) break block152;
                                                        MondrianGuiDef.ColumnDef columnDef = (MondrianGuiDef.ColumnDef)((Object)value);
                                                        if (ValidationUtils.isEmpty(columnDef.name)) {
                                                            return nameMustBeSet;
                                                        }
                                                        if (ValidationUtils.isEmpty(columnDef.type)) {
                                                            return messages.getString("schemaTreeCellRenderer.inlineColumnDefTypeNotSet.alert", "Type must be set");
                                                        }
                                                        break block127;
                                                    }
                                                    if (!(value instanceof MondrianGuiDef.Role)) break block153;
                                                    MondrianGuiDef.Role role = (MondrianGuiDef.Role)((Object)value);
                                                    if (ValidationUtils.isEmpty(role.name)) {
                                                        return nameMustBeSet;
                                                    }
                                                    if ((role.schemaGrants == null || role.schemaGrants.length == 0) && role.union == null) {
                                                        return messages.getString("schemaTreeCellRenderer.schemaGrantsOrUnionNotSet.alert", "Schema grants or Union must be set");
                                                    }
                                                    break block127;
                                                }
                                                if (!(value instanceof MondrianGuiDef.Union)) break block154;
                                                MondrianGuiDef.Union union = (MondrianGuiDef.Union)((Object)value);
                                                if (union.roleUsages == null) return messages.getString("schemaTreeCellRenderer.roleUsagesNotSet.alert", "Role usages must be set");
                                                if (union.roleUsages.length == 0) {
                                                    return messages.getString("schemaTreeCellRenderer.roleUsagesNotSet.alert", "Role usages must be set");
                                                }
                                                break block127;
                                            }
                                            if (!(value instanceof MondrianGuiDef.RoleUsage)) break block155;
                                            roleUsage = (MondrianGuiDef.RoleUsage)((Object)value);
                                            if (ValidationUtils.isEmpty(roleUsage.roleName)) {
                                                return nameMustBeSet;
                                            }
                                            if (schema == null) break block127;
                                            foundRole = false;
                                            arr$2 = schema.roles;
                                            len$ = arr$2.length;
                                            break block156;
                                        }
                                        if (!(value instanceof MondrianGuiDef.Row)) break block157;
                                        MondrianGuiDef.Row row = (MondrianGuiDef.Row)((Object)value);
                                        if (tpath == null) break block127;
                                        ParentInPath aParent = ParentInPath.getParentInPath(tpath, MondrianGuiDef.InlineTable.class);
                                        MondrianGuiDef.InlineTable inlineTable = (MondrianGuiDef.InlineTable)((Object)aParent.parent);
                                        if (inlineTable == null) {
                                            return null;
                                        }
                                        if (inlineTable.columnDefs == null) return messages.getString("schemaTreeCellRenderer.inlineRowColumnDefsNotSet.alert", "Row entered but no Column Definitions set");
                                        if (inlineTable.columnDefs.array == null) return messages.getString("schemaTreeCellRenderer.inlineRowColumnDefsNotSet.alert", "Row entered but no Column Definitions set");
                                        if (inlineTable.columnDefs.array.length == 0) {
                                            return messages.getString("schemaTreeCellRenderer.inlineRowColumnDefsNotSet.alert", "Row entered but no Column Definitions set");
                                        }
                                        columns = new HashMap<String, Integer>();
                                        arr$ = inlineTable.columnDefs.array;
                                        int n3 = arr$.length;
                                        boolean bl = false;
                                        while (var18_64 < n3) {
                                            MondrianGuiDef.ColumnDef columnDef = arr$[var18_64];
                                            columns.put(columnDef.name, new Integer(0));
                                            ++var18_64;
                                        }
                                        if (columns.size() != row.values.length) {
                                            return messages.getString("schemaTreeCellRenderer.inlineRowValuesNotMatchNumberColumns.alert", "Row column do not match the number of Column definitions");
                                        }
                                        arr$ = row.values;
                                        n = arr$.length;
                                        boolean bl2 = false;
                                        break block158;
                                    }
                                    if (!(value instanceof MondrianGuiDef.Annotation)) break block159;
                                    MondrianGuiDef.Annotation a = (MondrianGuiDef.Annotation)((Object)value);
                                    if (ValidationUtils.isEmpty(a.name)) {
                                        return nameMustBeSet;
                                    }
                                    if (ValidationUtils.isEmpty(a.cdata)) {
                                        return messages.getString("schemaTreeCellRenderer.cdataMustBeSet.alert", "CData details must be set");
                                    }
                                    break block127;
                                }
                                if (value instanceof MondrianGuiDef.Hint) {
                                    MondrianGuiDef.Hint h = (MondrianGuiDef.Hint)((Object)value);
                                    if (ValidationUtils.isEmpty(h.type)) {
                                        return messages.getString("schemaTreeCellRenderer.hintTypeMustBeSet.alert", "Type must be set");
                                    }
                                    if (ValidationUtils.isEmpty(h.cdata)) {
                                        return messages.getString("schemaTreeCellRenderer.cdataMustBeSet.alert", "CData details must be set");
                                    }
                                    break block127;
                                } else if (value instanceof MondrianGuiDef.SQL) {
                                    MondrianGuiDef.SQL sql = (MondrianGuiDef.SQL)((Object)value);
                                    if (ValidationUtils.isEmpty(sql.dialect)) {
                                        return messages.getString("schemaTreeCellRenderer.sqlDialectMustBeSet.alert", "Dialect must be set");
                                    }
                                    if (ValidationUtils.isEmpty(sql.cdata)) {
                                        return messages.getString("schemaTreeCellRenderer.cdataMustBeSet.alert", "CData details must be set");
                                    }
                                }
                                break block127;
                            }
                            for (int j = 0; j < ds.length; ++j) {
                                if (!ds[j].name.equalsIgnoreCase(sourcename)) continue;
                                notfound = false;
                                break;
                            }
                            if (notfound) {
                                return messages.getFormattedString("schemaTreeCellRenderer.sourceInSharedDimensionDoesNotExist.alert", "Source {0} does not exist as Shared Dimension of Schema", sourcename);
                            }
                            break block127;
                        }
                        while (var18_61 < n2) {
                            MondrianGuiDef.Cube cube2 = arr$3[var18_61];
                            if (vcd.cubeName.equals(cube2.name)) {
                                foundCube = cube2;
                                break;
                            }
                            ++var18_61;
                        }
                        if (foundCube == null) {
                            return messages.getString("schemaTreeCellRenderer.virtualCubeDimensionCubeMissing.alert", "Cube (by name) does not exist");
                        }
                        dimensionsToCheck = foundCube.dimensions;
                    }
                    MondrianGuiDef.Dimension[] arr$4 = dimensionsToCheck;
                    int len$2 = arr$4.length;
                    boolean bl = false;
                    while (var17_53 < len$2) {
                        MondrianGuiDef.Dimension dimension = arr$4[var17_53];
                        if (!ValidationUtils.isEmpty(dimension.name) && vcd.name.equals(dimension.name)) {
                            foundDimension = dimension;
                            break;
                        }
                        ++var17_53;
                    }
                    if (foundDimension == null) {
                        if (ValidationUtils.isEmpty(vcd.cubeName)) return messages.getString("schemaTreeCellRenderer.virtualCubeDimensionDimInSchemaMissing.alert", "Dimension in schema does not exist");
                        return messages.getString("schemaTreeCellRenderer.virtualCubeDimensionDimInCubeMissing.alert", "Dimension in Cube does not exist");
                    }
                    break block127;
                }
                for (int i$ = 0; i$ < len$; ++i$) {
                    ElementDef elementDef = arr$2[i$];
                    if (!roleUsage.roleName.equals(elementDef.name)) continue;
                    foundRole = true;
                    break;
                }
                if (!foundRole) {
                    return messages.getString("schemaTreeCellRenderer.roleUsageInvalidRole.alert", "Role does not exist");
                }
                break block127;
            }
            while (var18_66 < n) {
                ElementDef elementDef = arr$[var18_66];
                Integer seen = (Integer)columns.get(elementDef.column);
                if (seen == null) {
                    columns.put(elementDef.column, new Integer(-1));
                } else if (seen >= 0) {
                    columns.put(elementDef.column, new Integer(seen + 1));
                }
                ++var18_66;
            }
            for (Map.Entry entry : columns.entrySet()) {
                if ((Integer)entry.getValue() == 0) {
                    return messages.getFormattedString("schemaTreeCellRenderer.inlineRowValueMissingColumn.alert", "No value for column: '{0}'", entry.getKey());
                }
                if ((Integer)entry.getValue() > 1) {
                    return messages.getFormattedString("schemaTreeCellRenderer.inlineRowValueDuplicateColumn.alert", "Duplication for column: '{0}'", entry.getKey());
                }
                if ((Integer)entry.getValue() >= 0) continue;
                return messages.getFormattedString("schemaTreeCellRenderer.inlineRowValueInvalidColumn.alert", "Invalid column: '{0}'", entry.getKey());
            }
        }
        int childCnt = treeModel.getChildCount(value);
        int i = 0;
        while (i < childCnt) {
            Object child = treeModel.getChild(value, i);
            String childErrMsg = null;
            if (child instanceof MondrianGuiDef.Hierarchy && value instanceof MondrianGuiDef.Dimension && cube != null && ((MondrianGuiDef.Hierarchy)((Object)child)).relation != null && ValidationUtils.isEmpty(((MondrianGuiDef.Dimension)((Object)value)).foreignKey)) {
                return messages.getString("schemaTreeCellRenderer.foreignKeyMustBeSet.alert", "Foreign key must be set");
            }
            childErrMsg = ValidationUtils.invalid(messages, jdbcValidator, treeModel, tpath, child, isSchemaRequired);
            if (childErrMsg != null) {
                String[] classAndName = ValidationUtils.getClassAndName(child);
                if (classAndName.length == 2) {
                    return messages.getFormattedString("schemaTreeCellRenderer.childErrorMessageWithName.alert", "{0} {1} is invalid", classAndName[0], classAndName[1]);
                }
                return messages.getFormattedString("schemaTreeCellRenderer.childErrorExceptionMessage.alert", "{0} is invalid", classAndName[0]);
            }
            ++i;
        }
        return null;
    }

    private static String[] getClassAndName(Object o) {
        String childClassName = o.getClass().getName();
        String[] simpleName = childClassName.split("[$.]", 0);
        try {
            Field f = o.getClass().getField("name");
            String childName = (String)f.get(o);
            if (childName == null) {
                childName = "";
            }
            return new String[]{simpleName[simpleName.length - 1], childName};
        }
        catch (Exception ex) {
            return new String[]{simpleName[simpleName.length - 1]};
        }
    }

    public static boolean isEmpty(String v) {
        return v == null || v.equals("");
    }

    public static boolean isEmpty(Object[] arr) {
        return arr == null || arr.length == 0;
    }

    private static String validateColumn(String column, String fieldName, I18n messages, MondrianGuiDef.Level level, JdbcValidator jdbcValidator, MondrianGuiDef.Cube cube, MondrianGuiDef.Hierarchy parentHierarchy) {
        if (!ValidationUtils.isEmpty(column) && jdbcValidator.isInitialized()) {
            MondrianGuiDef.Table parentTable;
            String table = level.table;
            if (!ValidationUtils.isEmpty(table) && parentHierarchy != null && parentHierarchy.relation instanceof MondrianGuiDef.Join) {
                TreeSet<String> joinTables = new TreeSet<String>();
                SchemaExplorer.getTableNamesForJoin(parentHierarchy.relation, joinTables);
                if (!joinTables.contains(table)) {
                    return messages.getString("schemaTreeCellRenderer.wrongTableValue", "Table value does not correspond to any join");
                }
            }
            if (!ValidationUtils.isEmpty(table) && parentHierarchy != null && parentHierarchy.relation instanceof MondrianGuiDef.Table) {
                String compareTo;
                MondrianGuiDef.Table theTable = parentTable = (MondrianGuiDef.Table)parentHierarchy.relation;
                String string = compareTo = theTable.alias != null && theTable.alias.trim().length() > 0 ? theTable.alias : theTable.name;
                if (!table.equals(compareTo)) {
                    return messages.getString("schemaTreeCellRenderer.tableDoesNotMatch", "Table value does not correspond to Hierarchy Relation");
                }
            }
            if (!ValidationUtils.isEmpty(table) && parentHierarchy != null && parentHierarchy.relation instanceof MondrianGuiDef.View) {
                return messages.getString("schemaTreeCellRenderer.noTableForView", "Table for column cannot be set in View");
            }
            if (ValidationUtils.isEmpty(table)) {
                if (parentHierarchy != null) {
                    if (parentHierarchy.relation == null && cube != null) {
                        if (cube.fact instanceof MondrianGuiDef.Table && !jdbcValidator.isColExists(((MondrianGuiDef.Table)cube.fact).schema, ((MondrianGuiDef.Table)cube.fact).name, column)) {
                            return messages.getFormattedString("schemaTreeCellRenderer.degenDimensionColumnDoesNotExist.alert", "Degenerate dimension validation check - Column {0} does not exist in fact table", column);
                        }
                    } else if (parentHierarchy.relation instanceof MondrianGuiDef.Table) {
                        parentTable = (MondrianGuiDef.Table)parentHierarchy.relation;
                        if (!jdbcValidator.isColExists(parentTable.schema, parentTable.name, column)) {
                            return messages.getFormattedString("schemaTreeCellRenderer.columnInTableDoesNotExist.alert", "Column {0} defined in field {1} does not exist in table {2}", ValidationUtils.isEmpty(column.trim()) ? "' '" : column, fieldName, parentTable.name);
                        }
                    } else if (parentHierarchy.relation instanceof MondrianGuiDef.Join) {
                        return messages.getString("schemaTreeCellRenderer.tableMustBeSet.alert", "Table must be set");
                    }
                }
            } else {
                String schema = null;
                if (parentHierarchy != null && parentHierarchy.relation instanceof MondrianGuiDef.Join) {
                    String[] schemaAndTable = SchemaExplorer.getTableNameForAlias(parentHierarchy.relation, table);
                    schema = schemaAndTable[0];
                    table = schemaAndTable[1];
                }
                if (!jdbcValidator.isColExists(schema, table, column)) {
                    return messages.getFormattedString("schemaTreeCellRenderer.columnInTableDoesNotExist.alert", "Column {0} defined in field {1} does not exist in table {2}", ValidationUtils.isEmpty(column.trim()) ? "' '" : column, fieldName, table);
                }
            }
        }
        return null;
    }
}

