/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import mondrian.gui.MondrianGuiDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaTreeModel
extends DefaultTreeModel {
    MondrianGuiDef.Schema schema;

    public SchemaTreeModel() {
        super(null);
    }

    public SchemaTreeModel(MondrianGuiDef.Schema s) {
        super(new DefaultMutableTreeNode(s.name));
        this.schema = s;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return this.getChildList(parent).get(index);
    }

    private List<Object> getChildList(Object parent) {
        if (parent instanceof MondrianGuiDef.Cube) {
            MondrianGuiDef.Cube c = (MondrianGuiDef.Cube)((Object)parent);
            return new CompoundList<Object>(this.ifList(c.fact), this.arrayList(c.dimensions), this.arrayList(c.measures), this.arrayList(c.calculatedMembers), this.arrayList(c.namedSets), this.ifList(c.annotations));
        }
        if (parent instanceof MondrianGuiDef.Dimension) {
            MondrianGuiDef.Dimension d = (MondrianGuiDef.Dimension)((Object)parent);
            return new CompoundList<Object>(Arrays.asList((Object[])d.hierarchies), this.ifList(d.annotations));
        }
        if (parent instanceof MondrianGuiDef.ExpressionView) {
            MondrianGuiDef.ExpressionView ev = (MondrianGuiDef.ExpressionView)((Object)parent);
            return this.arrayList((Object[])ev.expressions);
        }
        if (parent instanceof MondrianGuiDef.Hierarchy) {
            MondrianGuiDef.Hierarchy h = (MondrianGuiDef.Hierarchy)((Object)parent);
            return new CompoundList<Object>(Arrays.asList(h.levels), Arrays.asList(h.memberReaderParameters), this.ifList(h.relation), this.ifList(h.annotations));
        }
        if (parent instanceof MondrianGuiDef.Join) {
            MondrianGuiDef.Join j = (MondrianGuiDef.Join)((Object)parent);
            return new CompoundList<Object>(this.ifList(j.left), this.ifList(j.right));
        }
        if (parent instanceof MondrianGuiDef.Level) {
            MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)parent);
            return new CompoundList<Object>(Arrays.asList(level.properties), this.ifList(level.keyExp), this.ifList(level.nameExp), this.ifList(level.ordinalExp), this.ifList(level.parentExp), this.ifList(level.closure), this.ifList(level.annotations));
        }
        if (parent instanceof MondrianGuiDef.CalculatedMember) {
            MondrianGuiDef.CalculatedMember c = (MondrianGuiDef.CalculatedMember)((Object)parent);
            return new CompoundList<Object>(this.ifList(c.formulaElement), this.arrayList(c.memberProperties), this.ifList(c.annotations));
        }
        if (parent instanceof MondrianGuiDef.Measure) {
            MondrianGuiDef.Measure m = (MondrianGuiDef.Measure)((Object)parent);
            return new CompoundList<Object>(this.ifList(m.measureExp), this.arrayList(m.memberProperties), this.ifList(m.annotations));
        }
        if (parent instanceof MondrianGuiDef.NamedSet) {
            MondrianGuiDef.NamedSet m = (MondrianGuiDef.NamedSet)((Object)parent);
            return new CompoundList<Object>(this.ifList(m.formulaElement), this.ifList(m.annotations));
        }
        if (parent instanceof MondrianGuiDef.Schema) {
            MondrianGuiDef.Schema s = (MondrianGuiDef.Schema)((Object)parent);
            return new CompoundList<Object>(this.arrayList(s.cubes), this.arrayList(s.dimensions), this.arrayList(s.namedSets), this.arrayList(s.userDefinedFunctions), this.arrayList(s.virtualCubes), this.arrayList(s.roles), this.arrayList(s.parameters), this.ifList(s.annotations));
        }
        if (parent instanceof MondrianGuiDef.Table) {
            MondrianGuiDef.Table t = (MondrianGuiDef.Table)((Object)parent);
            return new CompoundList<Object>(this.arrayList(t.aggTables), this.arrayList(t.aggExcludes), this.ifList(t.filter), this.arrayList(t.tableHints));
        }
        if (parent instanceof MondrianGuiDef.InlineTable) {
            MondrianGuiDef.InlineTable it = (MondrianGuiDef.InlineTable)((Object)parent);
            return new CompoundList<Object>(this.ifList(it.columnDefs), this.ifList(it.rows));
        }
        if (parent instanceof MondrianGuiDef.ColumnDefs) {
            MondrianGuiDef.ColumnDefs colDefs = (MondrianGuiDef.ColumnDefs)((Object)parent);
            return Arrays.asList((Object[])colDefs.array);
        }
        if (parent instanceof MondrianGuiDef.Rows) {
            MondrianGuiDef.Rows rows = (MondrianGuiDef.Rows)((Object)parent);
            return Arrays.asList((Object[])rows.array);
        }
        if (parent instanceof MondrianGuiDef.Row) {
            MondrianGuiDef.Row row = (MondrianGuiDef.Row)((Object)parent);
            return Arrays.asList((Object[])row.values);
        }
        if (parent instanceof MondrianGuiDef.AggTable) {
            MondrianGuiDef.AggTable t = (MondrianGuiDef.AggTable)((Object)parent);
            return new CompoundList<Object>(this.ifList(t.factcount), this.arrayList(t.ignoreColumns), this.arrayList(t.foreignKeys), this.arrayList(t.measures), this.arrayList(t.levels), t instanceof MondrianGuiDef.AggPattern ? this.arrayList(((MondrianGuiDef.AggPattern)t).excludes) : Collections.emptyList());
        }
        if (parent instanceof MondrianGuiDef.View) {
            MondrianGuiDef.View v = (MondrianGuiDef.View)((Object)parent);
            return Arrays.asList((Object[])v.selects);
        }
        if (parent instanceof MondrianGuiDef.VirtualCube) {
            MondrianGuiDef.VirtualCube c = (MondrianGuiDef.VirtualCube)((Object)parent);
            return new CompoundList<Object>(this.arrayList(c.dimensions), this.arrayList(c.measures), this.arrayList(c.calculatedMembers), this.ifList(c.annotations));
        }
        if (parent instanceof MondrianGuiDef.VirtualCubeDimension) {
            MondrianGuiDef.VirtualCubeDimension d = (MondrianGuiDef.VirtualCubeDimension)((Object)parent);
            return this.ifList(d.annotations);
        }
        if (parent instanceof MondrianGuiDef.VirtualCubeMeasure) {
            MondrianGuiDef.VirtualCubeMeasure m = (MondrianGuiDef.VirtualCubeMeasure)((Object)parent);
            return this.ifList(m.annotations);
        }
        if (parent instanceof MondrianGuiDef.Role) {
            MondrianGuiDef.Role c = (MondrianGuiDef.Role)((Object)parent);
            return new CompoundList<Object>(this.arrayList(c.schemaGrants), this.ifList(c.union), this.ifList(c.annotations));
        }
        if (parent instanceof MondrianGuiDef.Union) {
            MondrianGuiDef.Union c = (MondrianGuiDef.Union)((Object)parent);
            return new CompoundList<Object>(this.arrayList(c.roleUsages));
        }
        if (parent instanceof MondrianGuiDef.SchemaGrant) {
            MondrianGuiDef.SchemaGrant c = (MondrianGuiDef.SchemaGrant)((Object)parent);
            return Arrays.asList((Object[])c.cubeGrants);
        }
        if (parent instanceof MondrianGuiDef.CubeGrant) {
            MondrianGuiDef.CubeGrant c = (MondrianGuiDef.CubeGrant)((Object)parent);
            return new CompoundList<Object>(this.arrayList(c.dimensionGrants), this.arrayList(c.hierarchyGrants));
        }
        if (parent instanceof MondrianGuiDef.HierarchyGrant) {
            MondrianGuiDef.HierarchyGrant c = (MondrianGuiDef.HierarchyGrant)((Object)parent);
            return Arrays.asList((Object[])c.memberGrants);
        }
        if (parent instanceof MondrianGuiDef.Closure) {
            MondrianGuiDef.Closure c = (MondrianGuiDef.Closure)((Object)parent);
            return this.ifList(c.table);
        }
        if (parent instanceof MondrianGuiDef.Annotations) {
            MondrianGuiDef.Annotations annotations = (MondrianGuiDef.Annotations)((Object)parent);
            return Arrays.asList((Object[])annotations.array);
        }
        return Collections.emptyList();
    }

    private <T> List<T> ifList(T e) {
        return e == null ? Collections.emptyList() : Collections.singletonList(e);
    }

    private <T> List<T> arrayList(T ... e) {
        return e == null || e.length == 0 ? Collections.emptyList() : (e.length == 1 ? Collections.singletonList(e[0]) : Arrays.asList(e));
    }

    @Override
    public int getChildCount(Object parent) {
        return this.getChildList(parent).size();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null) {
            return -1;
        }
        List<Object> list = this.getChildList(parent);
        int i = 0;
        for (Object o : list) {
            if (this.equal(o, child)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean equal(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o1 instanceof MondrianGuiDef.Hierarchy || o1 instanceof MondrianGuiDef.SQL) {
            return o1 == o2;
        }
        return o1.equals(o2);
    }

    @Override
    public Object getRoot() {
        return this.schema;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompoundList<T>
    extends AbstractList<T> {
        private final List<? extends T>[] lists;

        CompoundList(List<? extends T> ... lists) {
            this.lists = lists;
        }

        @Override
        public T get(int index) {
            int n = 0;
            for (List<T> list : this.lists) {
                int next = n + list.size();
                if (index < next) {
                    return list.get(index - n);
                }
                n = next;
            }
            throw new IndexOutOfBoundsException("index" + index + " out of bounds in list of size " + n);
        }

        @Override
        public int size() {
            int n = 0;
            for (List<T> list : this.lists) {
                n += list.size();
            }
            return n;
        }
    }
}

