/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DefaultEditorKit;
import javax.swing.tree.TreePath;
import mondrian.gui.I18n;
import mondrian.gui.JTreeUpdater;
import mondrian.gui.JdbcMetaData;
import mondrian.gui.MondrianGuiDef;
import mondrian.gui.ParentInPath;
import mondrian.gui.PreferencesDialog;
import mondrian.gui.PropertyTableModel;
import mondrian.gui.SchemaPropertyCellEditor;
import mondrian.gui.SchemaPropertyCellRenderer;
import mondrian.gui.SchemaTreeCellRenderer;
import mondrian.gui.SchemaTreeModel;
import mondrian.gui.Workbench;
import mondrian.olap.MondrianProperties;
import org.apache.log4j.Logger;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XMLOutput;
import org.eigenbase.xom.XOMUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaExplorer
extends JPanel
implements TreeSelectionListener,
CellEditorListener {
    private static final Logger LOGGER = Logger.getLogger(SchemaExplorer.class);
    private final Workbench workbench;
    private MondrianGuiDef.Schema schema;
    private String jdbcConnectionName;
    private SchemaTreeModel model;
    private SchemaTreeCellRenderer renderer;
    private File schemaFile;
    private JTreeUpdater updater;
    private final ClassLoader myClassLoader;
    private boolean newFile;
    private boolean dirty = false;
    private JInternalFrame parentIFrame;
    private JdbcMetaData jdbcMetaData;
    private boolean editModeXML = false;
    private String errMsg = null;
    public Object lastSelected;
    static final String[] DEF_DEFAULT = new String[0];
    static final String[] DEF_VIRTUAL_CUBE = new String[]{"name", "caption", "enabled", "description"};
    static final String[] DEF_VIRTUAL_CUBE_MEASURE = new String[]{"name", "cubeName", "visible"};
    static final String[] DEF_VIRTUAL_CUBE_DIMENSION = new String[]{"name", "cubeName", "caption", "description", "foreignKey", "highCardinality"};
    static final String[] DEF_VIEW = new String[]{"alias"};
    static final String[] DEF_INLINE_TABLE = new String[]{"alias"};
    static final String[] DEF_INLINE_TABLE_COLUMN_DEF = new String[]{"name", "type"};
    static final String[] DEF_INLINE_TABLE_ROW_VALUE = new String[]{"column", "cdata"};
    static final String[] DEF_TABLE = new String[]{"schema", "name", "alias"};
    static final String[] DEF_HINT = new String[]{"type", "cdata"};
    static final String[] DEF_AGG_FACT_COUNT = new String[]{"column"};
    static final String[] DEF_AGG_NAME = new String[]{"name", "ignorecase"};
    static final String[] DEF_AGG_PATTERN = new String[]{"pattern", "ignorecase"};
    static final String[] DEF_AGG_EXCLUDE = new String[]{"pattern", "name", "ignorecase"};
    static final String[] DEF_AGG_IGNORE_COLUMN = new String[]{"column"};
    static final String[] DEF_AGG_FOREIGN_KEY = new String[]{"factColumn", "aggColumn"};
    static final String[] DEF_AGG_MEASURE = new String[]{"column", "name"};
    static final String[] DEF_AGG_LEVEL = new String[]{"column", "name"};
    static final String[] DEF_CLOSURE = new String[]{"parentColumn", "childColumn"};
    static final String[] DEF_RELATION = new String[]{"name"};
    static final String[] DEF_SQL = new String[]{"cdata", "dialect"};
    static final String[] DEF_SCHEMA = new String[]{"name", "measuresCaption", "defaultRole", "description"};
    static final String[] DEF_PROPERTY = new String[]{"name", "column", "type", "formatter", "caption", "description"};
    static final String[] DEF_PARAMETER_SCHEMA = new String[]{"name", "description", "type", "modifiable", "defaultValue"};
    static final String[] DEF_PARAMETER = new String[]{"name", "value"};
    static final String[] DEF_MEASURE = new String[]{"name", "aggregator", "column", "formatString", "visible", "datatype", "formatter", "caption", "description"};
    static final String[] DEF_CALCULATED_MEMBER = new String[]{"name", "caption", "dimension", "visible", "formula | formulaElement.cdata", "formatString", "description"};
    static final String[] DEF_FORMULA = new String[]{"cdata"};
    static final String[] DEF_CALCULATED_MEMBER_PROPERTY = new String[]{"name", "caption", "expression", "value", "description"};
    static final String[] DEF_NAMED_SET = new String[]{"name", "formula", "description", "caption"};
    static final String[] DEF_USER_DEFINED_FUNCTION = new String[]{"name", "className"};
    static final String[] DEF_LEVEL = new String[]{"name", "table", "column", "nameColumn", "parentColumn", "nullParentValue", "ordinalColumn", "type", "uniqueMembers", "levelType", "hideMemberIf", "approxRowCount", "caption", "captionColumn", "formatter", "description"};
    static final String[] DEF_JOIN = new String[]{"leftAlias", "leftKey", "rightAlias", "rightKey"};
    static final String[] DEF_HIERARCHY = new String[]{"name", "hasAll", "allMemberName", "allMemberCaption", "allLevelName", "defaultMember", "memberReaderClass", "primaryKeyTable", "primaryKey", "caption", "description"};
    static final String[] DEF_EXPRESSION_VIEW = new String[0];
    static final String[] DEF_DIMENSION_USAGE = new String[]{"name", "foreignKey", "source", "level", "usagePrefix", "caption", "description", "highCardinality"};
    static final String[] DEF_DIMENSION = new String[]{"name", "foreignKey", "type", "usagePrefix", "caption", "description", "highCardinality"};
    static final String[] DEF_CUBE = new String[]{"name", "caption", "cache", "enabled", "description"};
    static final String[] DEF_ROLE = new String[]{"name"};
    static final String[] DEF_UNION = new String[0];
    static final String[] DEF_ROLE_USAGE = new String[]{"roleName"};
    static final String[] DEF_SCHEMA_GRANT = new String[]{"access"};
    static final String[] DEF_CUBE_GRANT = new String[]{"access", "cube"};
    static final String[] DEF_DIMENSION_GRANT = new String[]{"access", "dimension"};
    static final String[] DEF_HIERARCHY_GRANT = new String[]{"access", "hierarchy", "topLevel", "bottomLevel", "rollupPolicy"};
    static final String[] DEF_MEMBER_GRANT = new String[]{"access", "member"};
    static final String[] DEF_COLUMN = new String[]{"name", "table"};
    static final String[] DEF_ANNOTATIONS = new String[0];
    static final String[] DEF_ANNOTATION = new String[]{"name", "cdata"};
    private static final String LBL_COLUMN = "Column";
    private static final String LBL_CUBE = "Cube";
    private static final String LBL_ROLE = "Role";
    private static final String LBL_UNION = "Union";
    private static final String LBL_ROLE_USAGE = "Role Usage";
    private static final String LBL_SCHEMA_GRANT = "Schema Grant";
    private static final String LBL_CUBE_GRANT = "Cube Grant";
    private static final String LBL_DIMENSION_GRANT = "Dimension Grant";
    private static final String LBL_HIERARCHY_GRANT = "Hierarchy Grant";
    private static final String LBL_MEMBER_GRANT = "Member Grant";
    private static final String LBL_DIMENSION = "Dimension";
    private static final String LBL_DIMENSION_USAGE = "Dimension Usage";
    private static final String LBL_EXPRESSION_VIEW = "Expression View";
    private static final String LBL_KEY_EXPRESSION = "Key Expression";
    private static final String LBL_NAME_EXPRESSION = "Name Expression";
    private static final String LBL_ORDINAL_EXPRESSION = "Ordinal Expression";
    private static final String LBL_PARENT_EXPRESSION = "Parent Expression";
    private static final String LBL_MEASURE_EXPRESSION = "Measure Expression";
    private static final String LBL_HIERARCHY = "Hierarchy";
    private static final String LBL_JOIN = "Join";
    private static final String LBL_LEVEL = "Level";
    private static final String LBL_MEASURE = "Measure";
    private static final String LBL_CALCULATED_MEMBER = "Calculated Member";
    private static final String LBL_CALCULATED_MEMBER_PROPERTY = "Calculated Member Property";
    private static final String LBL_NAMED_SET = "Named Set";
    private static final String LBL_USER_DEFINED_FUNCTION = "User Defined Function";
    private static final String LBL_PARAMETER = "Parameter";
    private static final String LBL_PARAMETER_SCHEMA = "Schema Parameter";
    private static final String LBL_PROPERTY = "Property";
    private static final String LBL_SCHEMA = "Schema";
    private static final String LBL_SQL = "SQL";
    private static final String LBL_TABLE = "Table";
    private static final String LBL_FILTER = "Filter";
    private static final String LBL_CLOSURE = "Closure";
    private static final String LBL_AGG_NAME = "Aggregate Name";
    private static final String LBL_AGG_IGNORE_COLUMN = "Aggregate Ignore Column";
    private static final String LBL_AGG_FOREIGN_KEY = "Aggregate Foreign Key";
    private static final String LBL_AGG_MEASURE = "Aggregate Measure";
    private static final String LBL_AGG_LEVEL = "Aggregate Level";
    private static final String LBL_AGG_PATTERN = "Aggregate Pattern";
    private static final String LBL_AGG_EXCLUDE = "Aggregate Exclude";
    private static final String LBL_AGG_FACT_COUNT = "Aggregate Fact Count";
    private static final String LBL_VIEW = "View";
    private static final String LBL_INLINE_TABLE = "Inline Table";
    private static final String LBL_INLINE_TABLE_COLUMN_DEFS = "Column Definitions";
    private static final String LBL_INLINE_TABLE_COLUMN_DEF = "Column Definition";
    private static final String LBL_INLINE_TABLE_ROW = "Row";
    private static final String LBL_INLINE_TABLE_ROWS = "Rows";
    private static final String LBL_INLINE_TABLE_ROW_VALUE = "Row Value";
    private static final String LBL_VIRTUAL_CUBE = "Virtual Cube";
    private static final String LBL_VIRTUAL_CUBE_DIMENSION = "Virtual Cube Dimension";
    private static final String LBL_VIRTUAL_CUBE_MEASURE = "Virtual Cube Measure";
    private static final String LBL_ANNOTATION = "Annotation";
    private static final String LBL_ANNOTATIONS = "Annotations";
    private static final String LBL_UNKNOWN_TYPE = "Unknown Type";
    private static String alert = "Alert";
    private AbstractAction arrowButtonUpAction;
    private AbstractAction arrowButtonDownAction;
    private AbstractAction addCube;
    private AbstractAction addRole;
    private AbstractAction addUnion;
    private AbstractAction addRoleUsage;
    private AbstractAction addParameter;
    private AbstractAction addSchemaGrant;
    private AbstractAction addCubeGrant;
    private AbstractAction addDimensionGrant;
    private AbstractAction addHierarchyGrant;
    private AbstractAction addMemberGrant;
    private AbstractAction addDimension;
    private AbstractAction addDimensionUsage;
    private AbstractAction addHierarchy;
    private AbstractAction addNamedSet;
    private AbstractAction addUserDefinedFunction;
    private AbstractAction addCalculatedMember;
    private AbstractAction addCalculatedMemberProperty;
    private AbstractAction addMeasure;
    private AbstractAction addMeasureExp;
    private AbstractAction addFormula;
    private AbstractAction addLevel;
    private AbstractAction addSQL;
    private AbstractAction addKeyExp;
    private AbstractAction addNameExp;
    private AbstractAction addOrdinalExp;
    private AbstractAction addParentExp;
    private AbstractAction addTable;
    private AbstractAction addJoin;
    private AbstractAction addView;
    private AbstractAction addInlineTable;
    private AbstractAction addColumnDef;
    private AbstractAction addRow;
    private AbstractAction addRowValue;
    private AbstractAction addProperty;
    private AbstractAction addClosure;
    private AbstractAction addFilter;
    private AbstractAction addHint;
    private AbstractAction addAggName;
    private AbstractAction addAggIgnoreColumn;
    private AbstractAction addAggForeignKey;
    private AbstractAction addAggMeasure;
    private AbstractAction addAggLevel;
    private AbstractAction addAggPattern;
    private AbstractAction addAggExclude;
    private AbstractAction addAggFactCount;
    private AbstractAction addVirtualCube;
    private AbstractAction addVirtualCubeDimension;
    private AbstractAction addVirtualCubeMeasure;
    private AbstractAction addAnnotation;
    private AbstractAction delete;
    private AbstractAction editMode;
    private JTable propertyTable;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JButton addLevelButton;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane1;
    private JButton addPropertyButton;
    private JButton pasteButton;
    private JLabel targetLabel;
    private JLabel validStatusLabel;
    private JLabel targetLabel2;
    private JLabel validStatusLabel2;
    private JTree tree;
    private JSplitPane jSplitPane1;
    private JButton addDimensionButton;
    private JButton addDimensionUsageButton;
    private JButton addHierarchyButton;
    private JButton addNamedSetButton;
    private JButton addUserDefinedFunctionButton;
    private JButton addCalculatedMemberButton;
    private JButton cutButton;
    private JButton addMeasureButton;
    private JButton addCubeButton;
    private JButton addRoleButton;
    private JButton addVirtualCubeButton;
    private JButton addVirtualCubeDimensionButton;
    private JButton addVirtualCubeMeasureButton;
    private JButton mdxQueryButton;
    private JButton saveButton;
    private JButton saveAsButton;
    private JMenuItem dimensionDegenerateMenuItem;
    private JButton deleteButton;
    private JToggleButton editModeButton;
    private JButton copyButton;
    private JToolBar jToolBar1;
    private JPopupMenu jPopupMenu;
    private JMenu jRightMenu;
    private JMenu jLeftMenu;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JPanel footer;
    private JButton testSchemaButton;
    private JLabel databaseLabel;
    private JLabel connectedLabel;
    private JComboBox conNameList;
    private JPanel jPanelXML;
    private JScrollPane jScrollPaneXML;
    private JEditorPane jEditorPaneXML;

    public SchemaExplorer(Workbench workbench) {
        this.workbench = workbench;
        this.myClassLoader = this.getClass().getClassLoader();
        this.initComponents();
    }

    public SchemaExplorer(Workbench workbench, File f, JdbcMetaData jdbcMetaData, String jdbcConnectionName, boolean newFile, JInternalFrame parentIFrame) {
        this(workbench);
        this.jdbcConnectionName = jdbcConnectionName;
        alert = this.getResourceConverter().getString("schemaExplorer.alert.title", "Alert");
        try {
            this.jEditorPaneXML = new JEditorPane();
        }
        catch (Exception ex) {
            LOGGER.error((Object)"SchemaExplorer-JEditorPane", (Throwable)ex);
        }
        this.jEditorPaneXML.setLayout(new BorderLayout());
        this.jEditorPaneXML.setEditable(false);
        this.jScrollPaneXML = new JScrollPane(this.jEditorPaneXML);
        this.jPanelXML.setLayout(new BorderLayout());
        this.jPanelXML.add((Component)this.jScrollPaneXML, "Center");
        this.jPanelXML.add((Component)this.targetLabel2, "North");
        this.jPanelXML.add((Component)this.validStatusLabel2, "South");
        this.jPanelXML.setMaximumSize(this.jPanel1.getMaximumSize());
        this.jPanelXML.setPreferredSize(this.jPanel1.getPreferredSize());
        this.databaseLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.database.text", "Database - {0} ({1})", SchemaExplorer.nvl(jdbcMetaData.getDbCatalogName()), jdbcMetaData.getDatabaseProductName()));
        this.updateDatabaseLabel(jdbcMetaData);
        this.updateConNameList(workbench.getConnectionDetailsMap(), jdbcConnectionName);
        final JInternalFrame parentIf = parentIFrame;
        this.conNameList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SchemaExplorer.this.conNameListActionPerformed(evt, parentIf);
            }
        });
        try {
            this.schemaFile = f;
            this.setNewFile(newFile);
            this.parentIFrame = parentIFrame;
            this.jdbcMetaData = jdbcMetaData;
            if (newFile) {
                this.schema = this.getEmptySchema();
                String sname = this.schemaFile.getName();
                int ext = sname.indexOf(".");
                if (ext != -1) {
                    this.schema.name = "New " + sname.substring(0, ext);
                }
            } else {
                this.schema = this.loadSchemaFile(this.schemaFile);
            }
            this.setTitle();
            this.renderer = new SchemaTreeCellRenderer(workbench, jdbcMetaData);
            this.model = new SchemaTreeModel(this.schema);
            this.tree.setModel(this.model);
            this.tree.setCellRenderer(this.renderer);
            this.tree.addTreeSelectionListener(this);
            this.tree.setEditable(false);
            SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(workbench, jdbcMetaData);
            spce.addCellEditorListener(this);
            this.propertyTable.setDefaultEditor(Object.class, spce);
            SchemaPropertyCellRenderer.attributeBackground = this.jScrollPane2.getBackground();
            SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(workbench);
            this.propertyTable.setDefaultRenderer(Object.class, spcr);
            this.tree.setSelectionRow(0);
            this.refreshTree(this.tree.getSelectionPath());
            this.setDirty(false);
            this.setTitle();
            this.setTableCellFocus(0);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"SchemaExplorer init error", (Throwable)ex);
        }
    }

    private static String nvl(String s) {
        return s == null ? "" : s;
    }

    public MondrianGuiDef.Schema loadSchemaFile(File aSchemaFile) {
        try {
            Parser xmlParser = XOMUtil.createDefaultParser();
            return new MondrianGuiDef.Schema(xmlParser.parse(aSchemaFile.toURL()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOGGER.error((Object)("Exception  : Schema file parsing failed." + ex.getMessage()), (Throwable)ex);
            this.setErrMsg(this.getResourceConverter().getFormattedString("schemaExplorer.parsing.error", "Parsing Error: Could not open file {0}\n{1}", this.schemaFile.toString(), ex.getLocalizedMessage()));
            return this.getEmptySchema();
        }
    }

    public MondrianGuiDef.Schema getEmptySchema() {
        MondrianGuiDef.Schema emptySchema = new MondrianGuiDef.Schema();
        emptySchema.parameters = new MondrianGuiDef.Parameter[0];
        emptySchema.cubes = new MondrianGuiDef.Cube[0];
        emptySchema.dimensions = new MondrianGuiDef.Dimension[0];
        emptySchema.namedSets = new MondrianGuiDef.NamedSet[0];
        emptySchema.roles = new MondrianGuiDef.Role[0];
        emptySchema.userDefinedFunctions = new MondrianGuiDef.UserDefinedFunction[0];
        emptySchema.virtualCubes = new MondrianGuiDef.VirtualCube[0];
        return emptySchema;
    }

    private void initComponents() {
        this.jPanelXML = new JPanel();
        this.jScrollPaneXML = new JScrollPane();
        this.footer = new JPanel();
        this.connectedLabel = new JLabel();
        this.databaseLabel = new JLabel();
        this.databaseLabel.setPreferredSize(null);
        this.conNameList = new JComboBox();
        this.conNameList.setPreferredSize(null);
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.propertyTable = new JTable(){

            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                KeyEvent ke;
                int kcode;
                AWTEvent currentEvent;
                if (columnIndex == 0 && (currentEvent = EventQueue.getCurrentEvent()) instanceof KeyEvent && (kcode = (ke = (KeyEvent)currentEvent).getKeyCode()) == 9) {
                    if ((ke.getModifiersEx() & 0x40) == 64 && --rowIndex < 0) {
                        rowIndex = SchemaExplorer.this.propertyTable.getRowCount() - 1;
                    }
                    SchemaExplorer.this.setTableCellFocus(rowIndex);
                    return;
                }
                super.changeSelection(rowIndex, columnIndex, toggle, extend);
            }

            public void processKeyEvent(KeyEvent e) {
                int kcode = e.getKeyCode();
                if (kcode == 38 || kcode == 40) {
                    int row = SchemaExplorer.this.propertyTable.getSelectedRow();
                    SchemaExplorer.this.setTableCellFocus(row);
                    return;
                }
                super.processKeyEvent(e);
            }
        };
        this.targetLabel = new JLabel();
        this.validStatusLabel = new JLabel();
        this.targetLabel2 = new JLabel();
        this.validStatusLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree();
        this.tree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.jToolBar1 = new JToolBar();
        this.addCubeButton = new JButton();
        this.addDimensionButton = new JButton();
        this.addDimensionUsageButton = new JButton();
        this.addHierarchyButton = new JButton();
        this.addNamedSetButton = new JButton();
        this.addUserDefinedFunctionButton = new JButton();
        this.addRoleButton = new JButton();
        this.addMeasureButton = new JButton();
        this.addCalculatedMemberButton = new JButton();
        this.addLevelButton = new JButton();
        this.addPropertyButton = new JButton();
        this.addVirtualCubeButton = new JButton();
        this.addVirtualCubeDimensionButton = new JButton();
        this.addVirtualCubeMeasureButton = new JButton();
        this.cutButton = new JButton(new DefaultEditorKit.CutAction());
        this.copyButton = new JButton(new DefaultEditorKit.CopyAction());
        this.pasteButton = new JButton(new DefaultEditorKit.PasteAction());
        this.deleteButton = new JButton();
        this.editModeButton = new JToggleButton();
        this.mdxQueryButton = new JButton();
        this.testSchemaButton = new JButton();
        this.saveButton = new JButton();
        this.saveAsButton = new JButton();
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(200);
        this.jPanel1.setLayout(new BorderLayout());
        this.propertyTable.setModel(new DefaultTableModel(new Object[0][], new String[]{this.getResourceConverter().getString("schemaExplorer.propertyTable.attribute", "Attribute"), this.getResourceConverter().getString("schemaExplorer.propertyTable.value", "Value")}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Object.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.propertyTable.getTableHeader().setFont(new Font("Dialog", 1, 12));
        this.jScrollPane2.setViewportView(this.propertyTable);
        this.jPanel1.add((Component)this.jScrollPane2, "Center");
        this.targetLabel.setFont(new Font("Dialog", 1, 14));
        this.targetLabel.setForeground((Color)UIManager.getDefaults().get("CheckBoxMenuItem.acceleratorForeground"));
        this.targetLabel.setHorizontalAlignment(0);
        this.targetLabel.setText(this.getResourceConverter().getString("schemaExplorer.targetLabel.title", LBL_SCHEMA));
        this.targetLabel.setBorder(new EtchedBorder());
        this.jPanel3 = new JPanel();
        this.jPanel3.setLayout(new BorderLayout());
        BasicArrowButton arrowButtonUp = new BasicArrowButton(1);
        BasicArrowButton arrowButtonDown = new BasicArrowButton(5);
        arrowButtonUp.setToolTipText(this.getResourceConverter().getString("schemaExplorer.arrowButtonUp.toolTip", "move to parent element"));
        arrowButtonDown.setToolTipText(this.getResourceConverter().getString("schemaExplorer.arrowButtonDown.toolTip", "move to child element"));
        this.arrowButtonUpAction = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.arrowButtonUp.title", "Arrow button up")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.arrowButtonUpAction(e);
            }
        };
        this.arrowButtonDownAction = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.arrowButtonDown.title", "Arrow button down")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.arrowButtonDownAction(e);
            }
        };
        arrowButtonUp.addActionListener(this.arrowButtonUpAction);
        arrowButtonDown.addActionListener(this.arrowButtonDownAction);
        this.jPanel3.add((Component)arrowButtonDown, "East");
        this.jPanel3.add((Component)arrowButtonUp, "West");
        this.jPanel3.add((Component)this.targetLabel, "Center");
        this.jPanel1.add((Component)this.jPanel3, "North");
        this.validStatusLabel.setFont(new Font("Dialog", 0, 12));
        this.validStatusLabel.setForeground(Color.RED);
        this.validStatusLabel.setHorizontalAlignment(0);
        this.jPanel1.add((Component)this.validStatusLabel, "South");
        this.targetLabel2.setFont(new Font("Dialog", 1, 14));
        this.targetLabel2.setForeground((Color)UIManager.getDefaults().get("CheckBoxMenuItem.acceleratorForeground"));
        this.targetLabel2.setHorizontalAlignment(0);
        this.targetLabel2.setText(this.getResourceConverter().getString("schemaExplorer.targetLabel.title", LBL_SCHEMA));
        this.targetLabel2.setBorder(new EtchedBorder());
        this.validStatusLabel2.setFont(new Font("Dialog", 0, 12));
        this.validStatusLabel2.setForeground(Color.RED);
        this.validStatusLabel2.setHorizontalAlignment(0);
        this.jSplitPane1.setRightComponent(this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.tree);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        this.addCube = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addCube.title", "Add Cube")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addCube(e);
            }
        };
        this.addParameter = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addParameter.title", "Add Parameter")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addParameter(e);
            }
        };
        this.addDimension = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addDimension.title", "Add Dimension")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addDimension(e);
            }
        };
        this.addDimensionUsage = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addDimensionUsage.title", "Add Dimension Usage")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addDimensionUsage(e);
            }
        };
        this.addHierarchy = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addHierarchy.title", "Add Hierarchy")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addHierarchy(e);
            }
        };
        this.addNamedSet = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addNamedSet.title", "Add Named Set")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addNamedSet(e);
            }
        };
        this.addMeasure = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addMeasure.title", "Add Measure")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addMeasure(e);
            }
        };
        this.addCalculatedMember = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addCalculatedMember.title", "Add Calculated Member")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addCalculatedMember(e);
            }
        };
        this.addUserDefinedFunction = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addUserDefinedFunction.title", "Add User Defined Function")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addUserDefinedFunction(e);
            }
        };
        this.addRole = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addRole.title", "Add Role")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addRole(e);
            }
        };
        this.addSchemaGrant = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addSchemaGrant.title", "Add Schema Grant")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addSchemaGrant(e);
            }
        };
        this.addUnion = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addUnion.title", "Add Union")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addUnion(e);
            }
        };
        this.addRoleUsage = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addRoleUsage.title", "Add Role Usgae")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addRoleUsage(e);
            }
        };
        this.addCubeGrant = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addCubeGrant.title", "Add Cube Grant")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addCubeGrant(e);
            }
        };
        this.addDimensionGrant = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addDimensionGrant.title", "Add Dimension Grant")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addDimensionGrant(e);
            }
        };
        this.addHierarchyGrant = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addHierarchyGrant.title", "Add Hierarchy Grant")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addHierarchyGrant(e);
            }
        };
        this.addMemberGrant = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addMemberGrant.title", "Add Member Grant")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addMemberGrant(e);
            }
        };
        this.addAnnotation = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAnnotation.title", "Add Annotation")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAnnotation(e);
            }
        };
        this.addLevel = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addLevel.title", "Add Level")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addLevel(e);
            }
        };
        this.addClosure = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addClosure.title", "Add Closure")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addClosure(e);
            }
        };
        this.addKeyExp = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addKeyExpression.title", "Add Key Expression")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addKeyExp(e);
            }
        };
        this.addNameExp = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addNameExpression.title", "Add Name Expression")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addNameExp(e);
            }
        };
        this.addOrdinalExp = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addOrdinalExpression.title", "Add Ordinal Expression")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addOrdinalExp(e);
            }
        };
        this.addParentExp = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addParentExpression.title", "Add Parent Expression")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addParentExp(e);
            }
        };
        this.addMeasureExp = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addMeasureExpression.title", "Add Measure Expression")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addMeasureExp(e);
            }
        };
        this.addFormula = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addFormula.title", "Add Formula")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addFormula(e);
            }
        };
        this.addSQL = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addSQL.title", "Add SQL")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addSQL(e);
            }
        };
        this.addTable = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addTable.title", "Add Table")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addTable(e);
            }
        };
        this.addJoin = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addJoin.title", "Add Join")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addJoin(e);
            }
        };
        this.addView = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addView.title", "Add View")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addView(e);
            }
        };
        this.addInlineTable = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addInlineTable.title", "Add Inline Table")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addInlineTable(e);
            }
        };
        this.addProperty = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addProperty.title", "Add Property")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addProperty(e);
            }
        };
        this.addCalculatedMemberProperty = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addCalculatedMemberProperty.title", "Add Calculated Member Property")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addCalculatedMemberProperty(e);
            }
        };
        this.addColumnDef = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addColumnDef.title", "Add Column Definition")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addColumnDef(e);
            }
        };
        this.addRow = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addRow.title", "Add Row")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addRow(e);
            }
        };
        this.addRowValue = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addRowValue.title", "Add Row Value")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addRowValue(e);
            }
        };
        this.addProperty = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addProperty.title", "Add Property")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addProperty(e);
            }
        };
        this.addVirtualCube = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addVirtualCube.title", "Add Virtual Cube")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addVirtualCube(e);
            }
        };
        this.addVirtualCubeDimension = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addVirtualCubeDimension.title", "Add Virtual Cube Dimension")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addVirtualCubeDimension(e);
            }
        };
        this.addVirtualCubeMeasure = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addVirtualCubeMeasure.title", "Add Virtual Cube Measure")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addVirtualCubeMeasure(e);
            }
        };
        this.addFilter = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addFilter.title", "Add Filter")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addFilter(e);
            }
        };
        this.addHint = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addHint.title", "Add Table Hint")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addHint(e);
            }
        };
        this.addAggPattern = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAggregatePattern.title", "Add Aggregate Pattern")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggPattern(e);
            }
        };
        this.addAggExclude = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAggregateExcludeTable.title", "Add Aggregate Exclude Table")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggExclude(e);
            }
        };
        this.addAggName = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAggregateName.title", "Add Aggregate Name")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggName(e);
            }
        };
        this.addAggIgnoreColumn = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAggregateIgnoreColumn.title", "Add Aggregate Ignore Column")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggIgnoreColumn(e);
            }
        };
        this.addAggForeignKey = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAggregateForeignKey.title", "Add Aggregate Foreign Key")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggForeignKey(e);
            }
        };
        this.addAggMeasure = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAggregateMeasure.title", "Add Aggregate Measure")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggMeasure(e);
            }
        };
        this.addAggLevel = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAggregateLevel.title", "Add Aggregate Level")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggLevel(e);
            }
        };
        this.addAggFactCount = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAggregateFactCount.title", "Add Aggregate Fact Count")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggFactCount(e);
            }
        };
        this.addAnnotation = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAnnotation.title", "Add Annotation")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAnnotation(e);
            }
        };
        this.delete = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.actionDelete.title", "Delete")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.delete(e);
            }
        };
        this.editMode = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.actionEdit.title", "EditMode")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.editMode(e);
            }
        };
        this.mdxQueryButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("mdxQuery"))));
        this.mdxQueryButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.mdxQuery.title", "MDX Query"));
        this.mdxQueryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SchemaExplorer.this.workbench.newQueryMenuItemActionPerformed(evt, SchemaExplorer.this);
            }
        });
        this.testSchemaButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("testSchema"))));
        this.testSchemaButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.testSchema.title", "Test Schema"));
        this.testSchemaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SchemaExplorer.this.testSchemaButtonActionPerformed(evt);
            }
        });
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("save"))));
        this.saveButton.setToolTipText(this.getResourceConverter().getString("workbench.toolbar.save", "Save"));
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SchemaExplorer.this.saveButtonActionPerformed(evt);
            }
        });
        this.saveAsButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("saveAs"))));
        this.saveAsButton.setToolTipText(this.getResourceConverter().getString("workbench.toolbar.saveAs", "Save As..."));
        this.saveAsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SchemaExplorer.this.saveAsButtonActionPerformed(evt);
            }
        });
        this.addCubeButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addCube"))));
        this.addCubeButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addCube.title", "Add cube"));
        this.addCubeButton.addActionListener(this.addCube);
        this.addDimensionButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addDimension"))));
        this.addDimensionButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addDimension.title", "Add Dimension"));
        this.addDimensionButton.addActionListener(this.addDimension);
        this.addDimensionUsageButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addDimensionUsage"))));
        this.addDimensionUsageButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addDimensionUsage.title", "Add Dimension Usage"));
        this.addDimensionUsageButton.addActionListener(this.addDimensionUsage);
        this.addHierarchyButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addHierarchy"))));
        this.addHierarchyButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addHierarchy.title", "Add Hierarchy"));
        this.addHierarchyButton.addActionListener(this.addHierarchy);
        this.addNamedSetButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addNamedSet"))));
        this.addNamedSetButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addNamedSet.title", "Add Named Set"));
        this.addNamedSetButton.addActionListener(this.addNamedSet);
        this.addUserDefinedFunctionButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addUserDefinedFunction"))));
        this.addUserDefinedFunctionButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addUserDefinedFunction.title", "Add User defined Function"));
        this.addUserDefinedFunctionButton.addActionListener(this.addUserDefinedFunction);
        this.addCalculatedMemberButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addCalculatedMember"))));
        this.addCalculatedMemberButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addCalculatedMember.title", "Add Calculated Member"));
        this.addCalculatedMemberButton.addActionListener(this.addCalculatedMember);
        this.addMeasureButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addMeasure"))));
        this.addMeasureButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addMeasure.title", "Add Measure"));
        this.addMeasureButton.addActionListener(this.addMeasure);
        this.addLevelButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addLevel"))));
        this.addLevelButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addLevel.title", "Add Level"));
        this.addLevelButton.addActionListener(this.addLevel);
        this.addPropertyButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addProperty"))));
        this.addPropertyButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addProperty.title", "Add Property"));
        this.addPropertyButton.addActionListener(this.addProperty);
        this.addVirtualCubeButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addVirtualCube"))));
        this.addVirtualCubeButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addVirtualCube.title", "Add Virtual Cube"));
        this.addVirtualCubeButton.addActionListener(this.addVirtualCube);
        this.addVirtualCubeDimensionButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addVirtualCubeDimension"))));
        this.addVirtualCubeDimensionButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addVirtualCubeDimension.title", "Add Virtual Dimension"));
        this.addVirtualCubeDimensionButton.addActionListener(this.addVirtualCubeDimension);
        this.addVirtualCubeMeasureButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addVirtualCubeMeasure"))));
        this.addVirtualCubeMeasureButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addVirtualCubeMeasure.title", "Add Virtual Measure"));
        this.addVirtualCubeMeasureButton.addActionListener(this.addVirtualCubeMeasure);
        this.addRoleButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addRole"))));
        this.addRoleButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addRole.title", "Add Role"));
        this.addRoleButton.addActionListener(this.addRole);
        this.cutButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("cut"))));
        this.cutButton.setText("");
        this.cutButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.actionCut.title", "Cut"));
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("copy"))));
        this.copyButton.setText("");
        this.copyButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.actionCopy.title", "Copy"));
        this.pasteButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("paste"))));
        this.pasteButton.setText("");
        this.pasteButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.actionPaste.title", "Paste"));
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("delete"))));
        this.deleteButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.actionDelete.title", "Delete"));
        this.deleteButton.addActionListener(this.delete);
        this.editModeButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("edit"))));
        if (this.isEditModeXML()) {
            this.editModeButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.actionEdit.title", "Edit Mode"));
        } else {
            this.editModeButton.setToolTipText(this.getResourceConverter().getString("workbench.menu.viewXML", "View XML"));
        }
        this.editModeButton.addActionListener(this.editMode);
        this.databaseLabel.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("database"))));
        this.connectedLabel.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("database"))));
        this.connectedLabel.setText("Connected To: ");
        this.connectedLabel.setIconTextGap(0);
        this.jToolBar1.add(this.addCubeButton);
        this.jToolBar1.add(this.addDimensionButton);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.addVirtualCubeButton);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.addRoleButton);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.deleteButton);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.testSchemaButton);
        this.jToolBar1.add(this.mdxQueryButton);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.saveButton);
        this.jToolBar1.add(this.saveAsButton);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.editModeButton);
        this.jPopupMenu = new JPopupMenu();
        this.jLeftMenu = new JMenu();
        this.jRightMenu = new JMenu();
        this.tree.addMouseListener(new PopupTrigger());
        this.tree.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int kcode = e.getKeyCode();
                if (kcode == 127 || kcode == 110) {
                    SchemaExplorer.this.delete(e);
                }
            }
        });
        this.footer.setLayout(new FlowLayout(0, 0, 0));
        this.footer.add(this.connectedLabel);
        this.footer.add(this.conNameList);
        this.footer.add(this.databaseLabel);
        this.add((Component)this.jSplitPane1, "Center");
        this.add((Component)this.jToolBar1, "North");
        this.add((Component)this.footer, "South");
        this.updater = new JTreeUpdater(this.tree);
    }

    public String isValidSchema() {
        return this.renderer.invalid(this.tree, this.tree.getPathForRow(0), this.tree.getModel().getRoot());
    }

    public File createTempSchemaFile() {
        File sfile = null;
        Object tempSchema = null;
        try {
            String isValid = this.isValidSchema();
            if (isValid != null && isValid.trim().length() > 0) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.schemaNotValidToTest.alert", "Current Schema is not valid. Cannot test."), this.getResourceConverter().getString("common.errorDialog.title", "Error"), 0);
                return null;
            }
            sfile = File.createTempFile("testSchema", ".xml");
            sfile.deleteOnExit();
            return this.saveSchemaToFile(sfile, true);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Exception: " + ex.getMessage()), (Throwable)ex);
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("schemaExplorer.unsuccessfulTempFileException.alert", "Temporary schema file could not be created for - {0}\n{1}", tempSchema.name, ex.getMessage()), this.getResourceConverter().getString("common.errorDialog.title", "Error"), 0);
            return null;
        }
    }

    public void saveButtonActionPerformed(ActionEvent evt) {
        this.workbench.saveMenuItemActionPerformed(evt, this);
    }

    public void saveAsButtonActionPerformed(ActionEvent evt) {
        this.workbench.saveAsMenuItemActionPerformed(evt, this);
    }

    public File saveSchemaToFile(File aSchemaFile, boolean tempFile) {
        MondrianProperties.instance();
        try {
            XMLOutput out = new XMLOutput((Writer)new FileWriter(aSchemaFile));
            out.setAlwaysQuoteCData(true);
            out.setIndentString("  ");
            this.schema.displayXML(out);
            if (!tempFile) {
                this.setDirty(false);
                this.setNewFile(false);
                this.setTitle();
            }
            return aSchemaFile;
        }
        catch (Exception ex) {
            LOGGER.error((Object)"saveCurrentSchemaFile", (Throwable)ex);
            return null;
        }
    }

    public File saveCurrentSchemaFile() {
        if (this.isNewFile()) {
            return this.saveNewSchemaFile();
        }
        return this.saveSchemaToFile(this.schemaFile, false);
    }

    public File saveNewSchemaFile() {
        File oldSchemaFile = this.schemaFile;
        File suggSchemaFile = new File(this.schemaFile == null ? this.schema.name.trim() + ".xml" : this.schemaFile.getName());
        JFileChooser jfc = new JFileChooser();
        jfc.setSelectedFile(suggSchemaFile);
        if (jfc.showSaveDialog(this) != 0) {
            return null;
        }
        try {
            int answer;
            File newSchemaFile = jfc.getSelectedFile();
            if (!oldSchemaFile.equals(newSchemaFile) && newSchemaFile.exists() && (answer = JOptionPane.showConfirmDialog(null, this.getResourceConverter().getFormattedString("workbench.saveAs.schema.confirm", "{0} schema file already exists. Do you want to replace it?", newSchemaFile.getAbsolutePath()), this.getResourceConverter().getString("workbench.saveAs.schema.confirm.title", "Save As"), 0)) == 1) {
                this.schemaFile = oldSchemaFile;
                return null;
            }
            if (this.isNewFile() && !oldSchemaFile.equals(newSchemaFile)) {
                oldSchemaFile.delete();
            }
            this.saveSchemaToFile(newSchemaFile, false);
            this.schemaFile = newSchemaFile;
            return this.schemaFile;
        }
        catch (Exception ex) {
            LOGGER.error((Object)"saveNewSchemaFile", (Throwable)ex);
            return null;
        }
    }

    public void testSchemaButtonActionPerformed(ActionEvent evt) {
        block7: {
            File sfile = null;
            Workbench.OlapConnectionHolder con = null;
            try {
                sfile = this.createTempSchemaFile();
                if (sfile == null) {
                    return;
                }
                con = this.workbench.checkSchemaFile(sfile, this.workbench.getConnectionDetailsMap().get(this.getJdbcConnectionName()));
                if (con != null && con.exception == null) {
                    JOptionPane.showMessageDialog(this, "Test Mondrian connection successful.", this.getResourceConverter().getString("common.informationDialog.title", "Information"), 1);
                    con.close();
                    con = null;
                } else {
                    JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("schemaExplorer.unsuccessfulTest.alert", "Test Mondrian connection could not be done for - {0}\n{1}", this.schema.name, con.exception == null ? "null connection" : con.exception.getLocalizedMessage()), this.getResourceConverter().getString("common.errorDialog.title", "Error"), 0);
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Exception: " + ex.getMessage()), (Throwable)ex);
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("schemaExplorer.unsuccessfulTestException.alert", "Test Mondrian connection could not be done for - {0}\n{1}", this.schema.name, ex.getMessage()), this.getResourceConverter().getString("common.errorDialog.title", "Error"), 0);
                if (con == null) break block7;
                try {
                    con.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                con = null;
            }
        }
    }

    protected void arrowButtonUpAction(ActionEvent evt) {
        TreePath parentpath;
        TreePath tpath = this.tree.getSelectionPath();
        if (tpath != null && (parentpath = tpath.getParentPath()) != null) {
            this.tree.setSelectionPath(parentpath);
            this.refreshTree(parentpath);
        }
    }

    protected void arrowButtonDownAction(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        if (tpath != null) {
            Object current = tpath.getLastPathComponent();
            Object child = this.tree.getModel().getChild(current, 0);
            if (child != null) {
                Object[] treeObjs = new Object[30];
                treeObjs[0] = child;
                treeObjs[1] = current;
                int objCnt = 2;
                for (TreePath parentpath = tpath.getParentPath(); parentpath != null; parentpath = parentpath.getParentPath()) {
                    Object po;
                    treeObjs[objCnt] = po = parentpath.getLastPathComponent();
                    ++objCnt;
                }
                Object[] nodes = new Object[objCnt];
                int loopCnt = objCnt - 1;
                for (int j = 0; j < objCnt; ++j) {
                    nodes[j] = treeObjs[loopCnt];
                    --loopCnt;
                }
                TreePath childPath = new TreePath(nodes);
                this.tree.setSelectionPath(childPath);
                this.refreshTree(childPath);
            }
        }
    }

    protected void setTableCellFocus(int row) {
        this.propertyTable.editCellAt(row, 1);
        TableCellEditor editor = this.propertyTable.getCellEditor(row, 1);
        editor.getTableCellEditorComponent(this.propertyTable, this.propertyTable.getValueAt(row, 1), true, row, 1);
    }

    protected void addCube(ActionEvent evt) {
        MondrianGuiDef.Schema currentSchema = (MondrianGuiDef.Schema)((Object)this.tree.getModel().getRoot());
        MondrianGuiDef.Cube cube = new MondrianGuiDef.Cube();
        cube.name = "";
        cube.dimensions = new MondrianGuiDef.Dimension[0];
        cube.measures = new MondrianGuiDef.Measure[0];
        cube.calculatedMembers = new MondrianGuiDef.CalculatedMember[0];
        cube.namedSets = new MondrianGuiDef.NamedSet[0];
        cube.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newCube.title", "New Cube"), (Object[])currentSchema.cubes);
        cube.cache = Boolean.TRUE;
        cube.enabled = Boolean.TRUE;
        MondrianGuiDef.Cube[] temp = currentSchema.cubes;
        currentSchema.cubes = new MondrianGuiDef.Cube[temp.length + 1];
        for (int _i = 0; _i < temp.length; ++_i) {
            currentSchema.cubes[_i] = temp[_i];
        }
        currentSchema.cubes[currentSchema.cubes.length - 1] = cube;
        this.tree.setSelectionPath(new TreePath(this.model.getRoot()).pathByAddingChild((Object)cube));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addParameter(ActionEvent evt) {
        MondrianGuiDef.Schema currentSchema = (MondrianGuiDef.Schema)((Object)this.tree.getModel().getRoot());
        MondrianGuiDef.Parameter parameter = new MondrianGuiDef.Parameter();
        parameter.name = "";
        parameter.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newParameter.title", "New Parameter"), (Object[])currentSchema.parameters);
        parameter.type = "String";
        parameter.modifiable = Boolean.TRUE;
        MondrianGuiDef.Parameter[] temp = currentSchema.parameters;
        currentSchema.parameters = new MondrianGuiDef.Parameter[temp.length + 1];
        for (int _i = 0; _i < temp.length; ++_i) {
            currentSchema.parameters[_i] = temp[_i];
        }
        currentSchema.parameters[currentSchema.parameters.length - 1] = parameter;
        this.tree.setSelectionPath(new TreePath(this.model.getRoot()).pathByAddingChild((Object)parameter));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addRole(ActionEvent evt) {
        MondrianGuiDef.Schema currentSchema = (MondrianGuiDef.Schema)((Object)this.tree.getModel().getRoot());
        MondrianGuiDef.Role role = new MondrianGuiDef.Role();
        role.name = "";
        role.schemaGrants = new MondrianGuiDef.SchemaGrant[0];
        role.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newRole.title", "New Role"), (Object[])currentSchema.roles);
        MondrianGuiDef.Role[] temp = currentSchema.roles;
        currentSchema.roles = new MondrianGuiDef.Role[temp.length + 1];
        for (int _i = 0; _i < temp.length; ++_i) {
            currentSchema.roles[_i] = temp[_i];
        }
        currentSchema.roles[currentSchema.roles.length - 1] = role;
        this.tree.setSelectionPath(new TreePath(this.model.getRoot()).pathByAddingChild((Object)role));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addVirtualCube(ActionEvent evt) {
        MondrianGuiDef.Schema currentSchema = (MondrianGuiDef.Schema)((Object)this.tree.getModel().getRoot());
        MondrianGuiDef.VirtualCube cube = new MondrianGuiDef.VirtualCube();
        cube.name = "";
        cube.dimensions = new MondrianGuiDef.VirtualCubeDimension[0];
        cube.measures = new MondrianGuiDef.VirtualCubeMeasure[0];
        cube.calculatedMembers = new MondrianGuiDef.CalculatedMember[0];
        cube.enabled = Boolean.TRUE;
        cube.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newVirtualCube.title", "New Virtual Cube"), (Object[])currentSchema.virtualCubes);
        MondrianGuiDef.VirtualCube[] temp = currentSchema.virtualCubes;
        currentSchema.virtualCubes = new MondrianGuiDef.VirtualCube[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            currentSchema.virtualCubes[i] = temp[i];
        }
        currentSchema.virtualCubes[currentSchema.virtualCubes.length - 1] = cube;
        this.tree.setSelectionPath(new TreePath(this.model.getRoot()).pathByAddingChild((Object)cube));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addUserDefinedFunction(ActionEvent evt) {
        MondrianGuiDef.Schema currentSchema = (MondrianGuiDef.Schema)((Object)this.tree.getModel().getRoot());
        MondrianGuiDef.UserDefinedFunction udf = new MondrianGuiDef.UserDefinedFunction();
        udf.name = "";
        udf.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newUserDefinedFunction.title", "New User defined Function"), (Object[])currentSchema.userDefinedFunctions);
        MondrianGuiDef.UserDefinedFunction[] temp = currentSchema.userDefinedFunctions;
        currentSchema.userDefinedFunctions = new MondrianGuiDef.UserDefinedFunction[temp.length + 1];
        for (int _i = 0; _i < temp.length; ++_i) {
            currentSchema.userDefinedFunctions[_i] = temp[_i];
        }
        currentSchema.userDefinedFunctions[currentSchema.userDefinedFunctions.length - 1] = udf;
        this.tree.setSelectionPath(new TreePath(this.model.getRoot()).pathByAddingChild((Object)udf));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    private void refreshTree(TreePath path) {
        this.setDirty(true);
        this.setTitle();
        this.refreshTree(path, true);
    }

    private void refreshTree(TreePath path, boolean ignoreDirty) {
        this.updater.update();
        this.tree.scrollPathToVisible(path);
    }

    protected void addMeasure(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Cube.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.Cube)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cubeNotSelected.alert", "Cube not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Cube cube = (MondrianGuiDef.Cube)((Object)pathReference.parent);
        MondrianGuiDef.Measure measure = new MondrianGuiDef.Measure();
        measure.name = "";
        measure.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newMeasure.title", "New Measure"), (Object[])cube.measures);
        measure.visible = Boolean.TRUE;
        measure.aggregator = "sum";
        MondrianGuiDef.Measure[] temp = cube.measures;
        cube.measures = new MondrianGuiDef.Measure[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cube.measures[i] = temp[i];
        }
        cube.measures[cube.measures.length - 1] = measure;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)measure));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addHint(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Table.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.Table)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.tableNotSelectedForHint.alert", "Table not selected for hint."), alert, 2);
            return;
        }
        MondrianGuiDef.Table table = (MondrianGuiDef.Table)((Object)pathReference.parent);
        MondrianGuiDef.Hint hint = new MondrianGuiDef.Hint();
        hint.type = "";
        hint.cdata = "";
        MondrianGuiDef.Hint[] temp = table.tableHints;
        if (temp == null) {
            temp = new MondrianGuiDef.Hint[]{};
        }
        table.tableHints = new MondrianGuiDef.Hint[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            table.tableHints[i] = temp[i];
        }
        table.tableHints[table.tableHints.length - 1] = hint;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)hint));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggPattern(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Table.class, MondrianGuiDef.Cube.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.Table)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cubeFactTableNotSelected.alert", "Cube Fact Table not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Table factTable = (MondrianGuiDef.Table)((Object)pathReference.parent);
        MondrianGuiDef.AggPattern aggname = new MondrianGuiDef.AggPattern();
        aggname.pattern = "";
        aggname.ignorecase = Boolean.TRUE;
        aggname.factcount = null;
        aggname.ignoreColumns = new MondrianGuiDef.AggIgnoreColumn[0];
        aggname.foreignKeys = new MondrianGuiDef.AggForeignKey[0];
        aggname.measures = new MondrianGuiDef.AggMeasure[0];
        aggname.levels = new MondrianGuiDef.AggLevel[0];
        aggname.excludes = new MondrianGuiDef.AggExclude[0];
        MondrianGuiDef.AggTable[] temp = factTable.aggTables;
        factTable.aggTables = new MondrianGuiDef.AggTable[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            factTable.aggTables[i] = temp[i];
        }
        factTable.aggTables[factTable.aggTables.length - 1] = aggname;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)aggname));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggName(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Table.class, MondrianGuiDef.Cube.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.Table)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.tableNotSelected.alert", "Table not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Table factTable = (MondrianGuiDef.Table)((Object)pathReference.parent);
        MondrianGuiDef.AggName aggname = new MondrianGuiDef.AggName();
        aggname.name = "";
        aggname.ignorecase = Boolean.TRUE;
        aggname.factcount = null;
        aggname.ignoreColumns = new MondrianGuiDef.AggIgnoreColumn[0];
        aggname.foreignKeys = new MondrianGuiDef.AggForeignKey[0];
        aggname.measures = new MondrianGuiDef.AggMeasure[0];
        aggname.levels = new MondrianGuiDef.AggLevel[0];
        MondrianGuiDef.AggTable[] temp = factTable.aggTables;
        if (temp == null) {
            factTable.aggTables = new MondrianGuiDef.AggTable[1];
        } else {
            factTable.aggTables = new MondrianGuiDef.AggTable[temp.length + 1];
            for (int i = 0; i < temp.length; ++i) {
                factTable.aggTables[i] = temp[i];
            }
        }
        factTable.aggTables[factTable.aggTables.length - 1] = aggname;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)aggname));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggExclude(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.AggPattern.class);
        if (pathReference.parent == null) {
            pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Table.class, MondrianGuiDef.Cube.class);
        }
        if (!(pathReference.parent instanceof MondrianGuiDef.Table) && !(pathReference.parent instanceof MondrianGuiDef.AggPattern)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cubeFactTableOrAggPatternNotSelected.alert", "Cube Fact Table or Aggregate Pattern not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.AggExclude aggexclude = new MondrianGuiDef.AggExclude();
        aggexclude.pattern = "";
        aggexclude.ignorecase = Boolean.TRUE;
        if (pathReference.parent instanceof MondrianGuiDef.Table) {
            MondrianGuiDef.Table parent = (MondrianGuiDef.Table)((Object)pathReference.parent);
            MondrianGuiDef.AggExclude[] temp = parent.aggExcludes;
            if (temp == null) {
                parent.aggExcludes = new MondrianGuiDef.AggExclude[1];
            } else {
                parent.aggExcludes = new MondrianGuiDef.AggExclude[temp.length + 1];
                for (int i = 0; i < temp.length; ++i) {
                    parent.aggExcludes[i] = temp[i];
                }
            }
            parent.aggExcludes[parent.aggExcludes.length - 1] = aggexclude;
        } else {
            MondrianGuiDef.AggPattern parent = (MondrianGuiDef.AggPattern)((Object)pathReference.parent);
            MondrianGuiDef.AggExclude[] temp = parent.excludes;
            if (temp == null) {
                parent.excludes = new MondrianGuiDef.AggExclude[1];
            } else {
                parent.excludes = new MondrianGuiDef.AggExclude[temp.length + 1];
                for (int i = 0; i < temp.length; ++i) {
                    parent.excludes[i] = temp[i];
                }
            }
            parent.excludes[parent.excludes.length - 1] = aggexclude;
        }
        this.tree.setSelectionPath(this.tree.getSelectionPath().pathByAddingChild((Object)aggexclude));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggIgnoreColumn(ActionEvent evt) {
        Object current = this.tree.getSelectionPath().getLastPathComponent();
        if (!(current instanceof MondrianGuiDef.AggTable)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.aggregateTableOrAggPatternNotSelected.alert", "Aggregate Table or Aggregate Pattern not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.AggTable aggTable = (MondrianGuiDef.AggTable)((Object)current);
        MondrianGuiDef.AggIgnoreColumn aggicol = new MondrianGuiDef.AggIgnoreColumn();
        aggicol.column = "";
        MondrianGuiDef.AggIgnoreColumn[] temp = aggTable.ignoreColumns;
        if (temp == null) {
            aggTable.ignoreColumns = new MondrianGuiDef.AggIgnoreColumn[1];
        } else {
            aggTable.ignoreColumns = new MondrianGuiDef.AggIgnoreColumn[temp.length + 1];
            for (int i = 0; i < temp.length; ++i) {
                aggTable.ignoreColumns[i] = temp[i];
            }
        }
        aggTable.ignoreColumns[aggTable.ignoreColumns.length - 1] = aggicol;
        this.tree.setSelectionPath(this.tree.getSelectionPath().pathByAddingChild((Object)aggicol));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggForeignKey(ActionEvent evt) {
        Object current = this.tree.getSelectionPath().getLastPathComponent();
        if (!(current instanceof MondrianGuiDef.AggTable)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.aggregateTableOrAggPatternNotSelected.alert", "Aggregate Table or Aggregate Pattern not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.AggTable aggTable = (MondrianGuiDef.AggTable)((Object)current);
        MondrianGuiDef.AggForeignKey aggfkey = new MondrianGuiDef.AggForeignKey();
        MondrianGuiDef.AggForeignKey[] temp = aggTable.foreignKeys;
        if (temp == null) {
            aggTable.foreignKeys = new MondrianGuiDef.AggForeignKey[1];
        } else {
            aggTable.foreignKeys = new MondrianGuiDef.AggForeignKey[temp.length + 1];
            for (int i = 0; i < temp.length; ++i) {
                aggTable.foreignKeys[i] = temp[i];
            }
        }
        aggTable.foreignKeys[aggTable.foreignKeys.length - 1] = aggfkey;
        this.tree.setSelectionPath(this.tree.getSelectionPath().pathByAddingChild((Object)aggfkey));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggMeasure(ActionEvent evt) {
        Object current = this.tree.getSelectionPath().getLastPathComponent();
        if (!(current instanceof MondrianGuiDef.AggTable)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.aggregateTableOrAggPatternNotSelected.alert", "Aggregate Table or Aggregate Pattern not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.AggTable aggTable = (MondrianGuiDef.AggTable)((Object)current);
        MondrianGuiDef.AggMeasure aggmeasure = new MondrianGuiDef.AggMeasure();
        MondrianGuiDef.AggMeasure[] temp = aggTable.measures;
        if (temp == null) {
            aggTable.measures = new MondrianGuiDef.AggMeasure[1];
        } else {
            aggTable.measures = new MondrianGuiDef.AggMeasure[temp.length + 1];
            for (int i = 0; i < temp.length; ++i) {
                aggTable.measures[i] = temp[i];
            }
        }
        aggTable.measures[aggTable.measures.length - 1] = aggmeasure;
        this.tree.setSelectionPath(this.tree.getSelectionPath().pathByAddingChild((Object)aggmeasure));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggLevel(ActionEvent evt) {
        Object current = this.tree.getSelectionPath().getLastPathComponent();
        if (!(current instanceof MondrianGuiDef.AggTable)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.aggregateTableOrAggPatternNotSelected.alert", "Aggregate Table or Aggregate Pattern not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.AggTable aggTable = (MondrianGuiDef.AggTable)((Object)current);
        MondrianGuiDef.AggLevel agglevel = new MondrianGuiDef.AggLevel();
        MondrianGuiDef.AggLevel[] temp = aggTable.levels;
        if (temp == null) {
            aggTable.levels = new MondrianGuiDef.AggLevel[1];
        } else {
            aggTable.levels = new MondrianGuiDef.AggLevel[temp.length + 1];
            for (int i = 0; i < temp.length; ++i) {
                aggTable.levels[i] = temp[i];
            }
        }
        aggTable.levels[aggTable.levels.length - 1] = agglevel;
        this.tree.setSelectionPath(this.tree.getSelectionPath().pathByAddingChild((Object)agglevel));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggFactCount(ActionEvent evt) {
        Object current = this.tree.getSelectionPath().getLastPathComponent();
        if (!(current instanceof MondrianGuiDef.AggTable)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.aggregateTableOrAggPatternNotSelected.alert", "Aggregate Table or Aggregate Pattern not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.AggFactCount aggFactCount = new MondrianGuiDef.AggFactCount();
        MondrianGuiDef.AggName aggName = null;
        MondrianGuiDef.AggPattern aggPattern = null;
        if (current instanceof MondrianGuiDef.AggName) {
            aggName = (MondrianGuiDef.AggName)((Object)current);
            aggName.factcount = new MondrianGuiDef.AggFactCount();
        } else {
            aggPattern = (MondrianGuiDef.AggPattern)((Object)current);
            aggPattern.factcount = new MondrianGuiDef.AggFactCount();
        }
        this.tree.setSelectionPath(this.tree.getSelectionPath().pathByAddingChild((Object)aggFactCount));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addVirtualCubeMeasure(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.VirtualCube.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.VirtualCube)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.virtualCubeNotSelected.alert", "Virtual Cube not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.VirtualCube cube = (MondrianGuiDef.VirtualCube)((Object)pathReference.parent);
        MondrianGuiDef.VirtualCubeMeasure measure = new MondrianGuiDef.VirtualCubeMeasure();
        measure.name = "";
        measure.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newVirtualMeasure.title", "New Virtual Measure"), (Object[])cube.measures);
        measure.visible = Boolean.TRUE;
        MondrianGuiDef.VirtualCubeMeasure[] temp = cube.measures;
        cube.measures = new MondrianGuiDef.VirtualCubeMeasure[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cube.measures[i] = temp[i];
        }
        cube.measures[cube.measures.length - 1] = measure;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)measure));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addCalculatedMember(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Cube.class);
        if (pathReference.parent == null) {
            pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.VirtualCube.class);
        }
        if (!(pathReference.parent instanceof MondrianGuiDef.Cube) && !(pathReference.parent instanceof MondrianGuiDef.VirtualCube)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cubeOrVirtualCubeNotSelected.alert", "Cube or Virtual Cube not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Cube cube = null;
        MondrianGuiDef.VirtualCube vcube = null;
        if (pathReference.parent instanceof MondrianGuiDef.Cube) {
            cube = (MondrianGuiDef.Cube)((Object)pathReference.parent);
        } else {
            vcube = (MondrianGuiDef.VirtualCube)((Object)pathReference.parent);
        }
        MondrianGuiDef.CalculatedMember calcmember = new MondrianGuiDef.CalculatedMember();
        calcmember.name = "";
        calcmember.dimension = "Measures";
        calcmember.visible = Boolean.TRUE;
        calcmember.formatString = "";
        calcmember.formula = null;
        calcmember.formulaElement = null;
        calcmember.memberProperties = new MondrianGuiDef.CalculatedMemberProperty[0];
        if (cube != null) {
            calcmember.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newCalculatedMember.title", "New Calculated Member"), (Object[])cube.calculatedMembers);
            MondrianGuiDef.CalculatedMember[] temp = cube.calculatedMembers;
            cube.calculatedMembers = new MondrianGuiDef.CalculatedMember[temp.length + 1];
            for (int i = 0; i < temp.length; ++i) {
                cube.calculatedMembers[i] = temp[i];
            }
            cube.calculatedMembers[cube.calculatedMembers.length - 1] = calcmember;
        } else {
            calcmember.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newCalculatedMember.title", "New Calculated Member"), (Object[])vcube.calculatedMembers);
            MondrianGuiDef.CalculatedMember[] temp = vcube.calculatedMembers;
            vcube.calculatedMembers = new MondrianGuiDef.CalculatedMember[temp.length + 1];
            for (int i = 0; i < temp.length; ++i) {
                vcube.calculatedMembers[i] = temp[i];
            }
            vcube.calculatedMembers[vcube.calculatedMembers.length - 1] = calcmember;
        }
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)calcmember));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected boolean editMode(EventObject evt) {
        this.editModeXML = !this.isEditModeXML();
        this.editModeButton.setSelected(this.isEditModeXML());
        if (this.isEditModeXML()) {
            this.editModeButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.actionEdit.title", "Edit Mode"));
            this.jSplitPane1.setRightComponent(this.jPanelXML);
        } else {
            this.editModeButton.setToolTipText(this.getResourceConverter().getString("workbench.menu.viewXML", "View XML"));
            this.jSplitPane1.setRightComponent(this.jPanel1);
        }
        for (Container o = this.parentIFrame.getDesktopPane().getParent(); o != null; o = o.getParent()) {
            if (o.getClass() != Workbench.class) continue;
            ((Workbench)o).getViewXmlMenuItem().setSelected(this.editModeXML);
            break;
        }
        return this.isEditModeXML();
    }

    protected void delete(EventObject evt) {
        TreePath tpath = this.tree.getSelectionPath();
        if (tpath == null) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.objectToDeleteNotSelected.alert", "Object to delete in Schema not selected."), alert, 2);
            return;
        }
        Object child = tpath.getLastPathComponent();
        Object nextSibling = null;
        Object prevSibling = null;
        Object parent = null;
        Object grandparent = null;
        boolean grandparentAsSibling = false;
        int i = tpath.getPathCount() - 1 - 1;
        if (i >= 0) {
            parent = tpath.getPathComponent(i);
            if (tpath.getPathCount() - 3 > 0) {
                grandparent = tpath.getPathComponent(i - 1);
            }
        }
        if (parent == null) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cantDeleteObject.alert", "Schema object cannot be deleted."), alert, 2);
            return;
        }
        boolean tofind = true;
        Field[] fs = parent.getClass().getFields();
        for (int i2 = 0; i2 < fs.length; ++i2) {
            if (fs[i2].getType().isArray() && fs[i2].getType().getComponentType().isInstance(child)) {
                try {
                    Object parentArr = fs[i2].get(parent);
                    int parentArrLen = Array.getLength(parentArr);
                    Object newArr = Array.newInstance(fs[i2].getType().getComponentType(), parentArrLen - 1);
                    tofind = true;
                    int m = 0;
                    for (int k = 0; k < parentArrLen; ++k) {
                        Object match = Array.get(parentArr, k);
                        if (tofind && match.equals(child)) {
                            if (child instanceof MondrianGuiDef.CubeDimension) {
                                MondrianGuiDef.CubeDimension matchDim = (MondrianGuiDef.CubeDimension)((Object)match);
                                MondrianGuiDef.CubeDimension childDim = (MondrianGuiDef.CubeDimension)((Object)child);
                                if (this.eq(matchDim.name, childDim.name) && this.eq(matchDim.caption, childDim.caption) && this.eq(matchDim.foreignKey, childDim.foreignKey)) {
                                    tofind = false;
                                    if (k + 1 < parentArrLen) {
                                        nextSibling = Array.get(parentArr, k + 1);
                                    }
                                    if (k - 1 < 0) continue;
                                    prevSibling = Array.get(parentArr, k - 1);
                                    continue;
                                }
                            } else {
                                tofind = false;
                                if (k + 1 < parentArrLen) {
                                    nextSibling = Array.get(parentArr, k + 1);
                                }
                                if (k - 1 < 0) continue;
                                prevSibling = Array.get(parentArr, k - 1);
                                continue;
                            }
                        }
                        Array.set(newArr, m++, match);
                    }
                    if (child instanceof MondrianGuiDef.SQL && parent instanceof MondrianGuiDef.ExpressionView && Array.getLength(newArr) < 1) {
                        if (parent instanceof MondrianGuiDef.KeyExpression) {
                            ((MondrianGuiDef.Level)((Object)grandparent)).keyExp = null;
                        } else if (parent instanceof MondrianGuiDef.NameExpression) {
                            ((MondrianGuiDef.Level)((Object)grandparent)).nameExp = null;
                        } else if (parent instanceof MondrianGuiDef.OrdinalExpression) {
                            ((MondrianGuiDef.Level)((Object)grandparent)).ordinalExp = null;
                        } else if (parent instanceof MondrianGuiDef.ParentExpression) {
                            ((MondrianGuiDef.Level)((Object)grandparent)).parentExp = null;
                        } else if (parent instanceof MondrianGuiDef.MeasureExpression) {
                            ((MondrianGuiDef.Measure)((Object)grandparent)).measureExp = null;
                        }
                        grandparentAsSibling = true;
                        break;
                    }
                    fs[i2].set(parent, newArr);
                }
                catch (Exception ex) {
                    LOGGER.error((Object)"delete", (Throwable)ex);
                }
                break;
            }
            if (!fs[i2].getType().isInstance(child)) continue;
            try {
                if (fs[i2].get(parent) != child) continue;
                fs[i2].set(parent, null);
                break;
            }
            catch (Exception ex) {
                LOGGER.error((Object)"delete", (Throwable)ex);
            }
        }
        TreeExpansionEvent e = null;
        e = new TreeExpansionEvent(this.tree, tpath);
        this.updater.treeCollapsed(e);
        if (nextSibling != null) {
            this.tree.setSelectionPath(tpath.getParentPath().pathByAddingChild(nextSibling));
        } else if (prevSibling != null) {
            this.tree.setSelectionPath(tpath.getParentPath().pathByAddingChild(prevSibling));
        } else if (grandparentAsSibling) {
            this.tree.setSelectionPath(tpath.getParentPath().getParentPath());
        } else {
            this.tree.setSelectionPath(tpath.getParentPath());
        }
        this.refreshTree(this.tree.getSelectionPath());
    }

    private boolean eq(String o1, String o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    protected void addDimension(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Cube.class);
        if (pathReference.parent == null) {
            pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Schema.class);
        }
        if (!(pathReference.parent instanceof MondrianGuiDef.Cube) && !(pathReference.parent instanceof MondrianGuiDef.Schema)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cubeOrSchemaNotSelected.alert", "Cube or Schema not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Cube cube = null;
        MondrianGuiDef.Schema aSchema = null;
        if (pathReference.parent instanceof MondrianGuiDef.Cube) {
            cube = (MondrianGuiDef.Cube)((Object)pathReference.parent);
        } else {
            aSchema = (MondrianGuiDef.Schema)((Object)pathReference.parent);
        }
        MondrianGuiDef.Dimension dimension = new MondrianGuiDef.Dimension();
        dimension.name = "";
        dimension.type = "StandardDimension";
        dimension.hierarchies = new MondrianGuiDef.Hierarchy[1];
        dimension.hierarchies[0] = new MondrianGuiDef.Hierarchy();
        dimension.hierarchies[0].name = "";
        dimension.hierarchies[0].hasAll = true;
        dimension.hierarchies[0].levels = new MondrianGuiDef.Level[0];
        dimension.hierarchies[0].memberReaderParameters = new MondrianGuiDef.MemberReaderParameter[0];
        dimension.hierarchies[0].relation = null;
        if (cube != null) {
            dimension.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newDimension.title", "New Dimension"), (Object[])cube.dimensions);
            MondrianGuiDef.CubeDimension[] temp = cube.dimensions;
            cube.dimensions = new MondrianGuiDef.CubeDimension[temp.length + 1];
            for (int i = 0; i < temp.length; ++i) {
                cube.dimensions[i] = temp[i];
            }
            cube.dimensions[cube.dimensions.length - 1] = dimension;
        } else {
            dimension.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newDimension.title", "New Dimension"), (Object[])aSchema.dimensions);
            MondrianGuiDef.Dimension[] temp = aSchema.dimensions;
            aSchema.dimensions = new MondrianGuiDef.Dimension[temp.length + 1];
            for (int i = 0; i < temp.length; ++i) {
                aSchema.dimensions[i] = temp[i];
            }
            aSchema.dimensions[this.schema.dimensions.length - 1] = dimension;
        }
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)dimension));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addVirtualCubeDimension(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.VirtualCube.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.VirtualCube)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.virtualCubeNotSelected.alert", "Virtual Cube not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.VirtualCube cube = (MondrianGuiDef.VirtualCube)((Object)pathReference.parent);
        MondrianGuiDef.VirtualCubeDimension dimension = new MondrianGuiDef.VirtualCubeDimension();
        dimension.name = "";
        dimension.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newVirtualDimension.title", "New Virtual Dimension"), (Object[])cube.dimensions);
        MondrianGuiDef.VirtualCubeDimension[] temp = cube.dimensions;
        cube.dimensions = new MondrianGuiDef.VirtualCubeDimension[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cube.dimensions[i] = temp[i];
        }
        cube.dimensions[cube.dimensions.length - 1] = dimension;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)dimension));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    private String getNewName(String preName, Object[] objs) {
        String newName = "";
        String workName = preName.trim() + " ";
        if (objs != null) {
            int objNo = objs.length;
            try {
                boolean exists;
                Field f = objs.getClass().getComponentType().getField("name");
                while (exists = SchemaExplorer.existsWithFieldValue(objs, newName = workName + objNo++, f)) {
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)"getNewName", (Throwable)ex);
            }
        } else {
            newName = workName + 0;
        }
        return newName;
    }

    private static boolean existsWithFieldValue(Object[] objs, String seek, Field f) throws IllegalAccessException {
        for (int i = 0; i < objs.length; ++i) {
            String value = (String)f.get(objs[i]);
            if (!seek.equals(value)) continue;
            return true;
        }
        return false;
    }

    protected void addNamedSet(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Cube.class);
        if (pathReference.parent == null) {
            pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Schema.class);
        }
        if (!(pathReference.parent instanceof MondrianGuiDef.Cube) && !(pathReference.parent instanceof MondrianGuiDef.Schema)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cubeOrSchemaNotSelected.alert", "Cube or Schema not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Cube cube = null;
        MondrianGuiDef.Schema aSchema = null;
        if (pathReference.parent instanceof MondrianGuiDef.Cube) {
            cube = (MondrianGuiDef.Cube)((Object)pathReference.parent);
        } else {
            aSchema = (MondrianGuiDef.Schema)((Object)pathReference.parent);
        }
        MondrianGuiDef.NamedSet namedset = new MondrianGuiDef.NamedSet();
        namedset.name = "";
        namedset.formula = "";
        namedset.formulaElement = null;
        if (cube != null) {
            namedset.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newNamedSet.title", "New Named Set"), (Object[])cube.namedSets);
            MondrianGuiDef.NamedSet[] temp = cube.namedSets;
            cube.namedSets = new MondrianGuiDef.NamedSet[temp.length + 1];
            for (int i = 0; i < temp.length; ++i) {
                cube.namedSets[i] = temp[i];
            }
            cube.namedSets[cube.namedSets.length - 1] = namedset;
        } else {
            namedset.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newNamedSet.title", "New Named Set"), (Object[])aSchema.namedSets);
            MondrianGuiDef.NamedSet[] temp = aSchema.namedSets;
            aSchema.namedSets = new MondrianGuiDef.NamedSet[temp.length + 1];
            for (int i = 0; i < temp.length; ++i) {
                aSchema.namedSets[i] = temp[i];
            }
            aSchema.namedSets[aSchema.namedSets.length - 1] = namedset;
        }
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)namedset));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addDimensionUsage(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Cube.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.Cube)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cubeNotSelected.alert", "Cube not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Cube cube = (MondrianGuiDef.Cube)((Object)pathReference.parent);
        MondrianGuiDef.DimensionUsage dimension = new MondrianGuiDef.DimensionUsage();
        dimension.name = "";
        dimension.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newDimensionUsage.title", "New Dimension Usage"), (Object[])cube.dimensions);
        MondrianGuiDef.CubeDimension[] temp = cube.dimensions;
        cube.dimensions = new MondrianGuiDef.CubeDimension[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cube.dimensions[i] = temp[i];
        }
        cube.dimensions[cube.dimensions.length - 1] = dimension;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)dimension));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addSchemaGrant(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Role.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.Role)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.roleNotSelected.alert", "Role not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Role role = (MondrianGuiDef.Role)((Object)pathReference.parent);
        MondrianGuiDef.SchemaGrant schemaGrant = new MondrianGuiDef.SchemaGrant();
        schemaGrant.access = "";
        schemaGrant.cubeGrants = new MondrianGuiDef.CubeGrant[0];
        MondrianGuiDef.SchemaGrant[] temp = role.schemaGrants;
        role.schemaGrants = new MondrianGuiDef.SchemaGrant[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            role.schemaGrants[i] = temp[i];
        }
        role.schemaGrants[role.schemaGrants.length - 1] = schemaGrant;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)schemaGrant));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addUnion(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Role.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.Role)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.roleNotSelected.alert", "Role not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Role role = (MondrianGuiDef.Role)((Object)pathReference.parent);
        MondrianGuiDef.Union union = new MondrianGuiDef.Union();
        union.roleUsages = new MondrianGuiDef.RoleUsage[1];
        union.roleUsages[0] = new MondrianGuiDef.RoleUsage();
        union.roleUsages[0].roleName = "";
        role.union = union;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)union.roleUsages[0]));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addRoleUsage(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Union.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.Union)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.unionNotSelected.alert", "Union not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Union union = (MondrianGuiDef.Union)((Object)pathReference.parent);
        MondrianGuiDef.RoleUsage roleUsage = new MondrianGuiDef.RoleUsage();
        roleUsage.roleName = "";
        MondrianGuiDef.RoleUsage[] temp = union.roleUsages;
        union.roleUsages = new MondrianGuiDef.RoleUsage[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            union.roleUsages[i] = temp[i];
        }
        union.roleUsages[union.roleUsages.length - 1] = roleUsage;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)roleUsage));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addCubeGrant(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.SchemaGrant.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.SchemaGrant)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.schemaGrantNotSelected.alert", "Schema Grant not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.SchemaGrant schemaGrant = (MondrianGuiDef.SchemaGrant)((Object)pathReference.parent);
        MondrianGuiDef.CubeGrant cubeGrant = new MondrianGuiDef.CubeGrant();
        cubeGrant.access = "";
        cubeGrant.dimensionGrants = new MondrianGuiDef.DimensionGrant[0];
        cubeGrant.hierarchyGrants = new MondrianGuiDef.HierarchyGrant[0];
        MondrianGuiDef.CubeGrant[] temp = schemaGrant.cubeGrants;
        schemaGrant.cubeGrants = new MondrianGuiDef.CubeGrant[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            schemaGrant.cubeGrants[i] = temp[i];
        }
        schemaGrant.cubeGrants[schemaGrant.cubeGrants.length - 1] = cubeGrant;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)cubeGrant));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addDimensionGrant(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.CubeGrant.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.CubeGrant)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cubeGrantNotSelected.alert", "Cube Grant not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.CubeGrant cubeGrant = (MondrianGuiDef.CubeGrant)((Object)pathReference.parent);
        MondrianGuiDef.DimensionGrant dimeGrant = new MondrianGuiDef.DimensionGrant();
        dimeGrant.access = "";
        MondrianGuiDef.DimensionGrant[] temp = cubeGrant.dimensionGrants;
        cubeGrant.dimensionGrants = new MondrianGuiDef.DimensionGrant[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cubeGrant.dimensionGrants[i] = temp[i];
        }
        cubeGrant.dimensionGrants[cubeGrant.dimensionGrants.length - 1] = dimeGrant;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)dimeGrant));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addHierarchyGrant(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.CubeGrant.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.CubeGrant)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cubeGrantNotSelected.alert", "Cube Grant not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.CubeGrant cubeGrant = (MondrianGuiDef.CubeGrant)((Object)pathReference.parent);
        MondrianGuiDef.HierarchyGrant hieGrant = new MondrianGuiDef.HierarchyGrant();
        hieGrant.access = "";
        hieGrant.memberGrants = new MondrianGuiDef.MemberGrant[0];
        MondrianGuiDef.HierarchyGrant[] temp = cubeGrant.hierarchyGrants;
        cubeGrant.hierarchyGrants = new MondrianGuiDef.HierarchyGrant[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cubeGrant.hierarchyGrants[i] = temp[i];
        }
        cubeGrant.hierarchyGrants[cubeGrant.hierarchyGrants.length - 1] = hieGrant;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)hieGrant));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addMemberGrant(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.HierarchyGrant.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.HierarchyGrant)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.hierarchyGrantNotSelected.alert", "Hierarchy Grant not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.HierarchyGrant hieGrant = (MondrianGuiDef.HierarchyGrant)((Object)pathReference.parent);
        MondrianGuiDef.MemberGrant memberGrant = new MondrianGuiDef.MemberGrant();
        memberGrant.access = "";
        MondrianGuiDef.MemberGrant[] temp = hieGrant.memberGrants;
        hieGrant.memberGrants = new MondrianGuiDef.MemberGrant[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            hieGrant.memberGrants[i] = temp[i];
        }
        hieGrant.memberGrants[hieGrant.memberGrants.length - 1] = memberGrant;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)memberGrant));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAnnotation(ActionEvent evt) {
        Object parent = this.tree.getSelectionPath().getLastPathComponent();
        if (!(parent instanceof MondrianGuiDef.Cube || parent instanceof MondrianGuiDef.Schema || parent instanceof MondrianGuiDef.CubeDimension || parent instanceof MondrianGuiDef.VirtualCube || parent instanceof MondrianGuiDef.Hierarchy || parent instanceof MondrianGuiDef.Level || parent instanceof MondrianGuiDef.Measure || parent instanceof MondrianGuiDef.CalculatedMember || parent instanceof MondrianGuiDef.CalculatedMemberProperty || parent instanceof MondrianGuiDef.NamedSet || parent instanceof MondrianGuiDef.Role || parent instanceof MondrianGuiDef.Annotations)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.annotationTargetNotSelected.alert", "Selected item cannot be annotated."), alert, 2);
            return;
        }
        MondrianGuiDef.Annotations annotations = null;
        if (parent instanceof MondrianGuiDef.Annotations) {
            annotations = (MondrianGuiDef.Annotations)((Object)parent);
        } else {
            try {
                Class<?> parentClass = parent.getClass();
                Field annotationsField = parentClass.getField("annotations");
                annotations = (MondrianGuiDef.Annotations)((Object)annotationsField.get(parent));
                if (annotations == null) {
                    annotations = new MondrianGuiDef.Annotations();
                    annotations.array = new MondrianGuiDef.Annotation[0];
                    annotationsField.set(parent, (Object)annotations);
                }
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException("Internal error adding annotation to class: " + parent.getClass(), ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Internal error adding annotation to class: " + parent.getClass(), ex);
            }
            catch (NoSuchFieldException ex) {
                throw new RuntimeException("Internal error adding annotation to class: " + parent.getClass(), ex);
            }
            catch (SecurityException ex) {
                throw new RuntimeException("Internal error adding annotation to class: " + parent.getClass(), ex);
            }
        }
        MondrianGuiDef.Annotation annotation = new MondrianGuiDef.Annotation();
        annotation.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newAnnotation.title", "New Annotation"), (Object[])annotations.array);
        annotation.cdata = "";
        MondrianGuiDef.Annotation[] temp = annotations.array;
        annotations.array = new MondrianGuiDef.Annotation[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            annotations.array[i] = temp[i];
        }
        annotations.array[annotations.array.length - 1] = annotation;
        this.tree.setSelectionPath(this.tree.getSelectionPath().pathByAddingChild((Object)annotation));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addLevel(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Hierarchy.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.Hierarchy)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.hierarchyNotSelected.alert", "Hierarchy not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Hierarchy hierarchy = (MondrianGuiDef.Hierarchy)((Object)pathReference.parent);
        MondrianGuiDef.Level level = new MondrianGuiDef.Level();
        level.uniqueMembers = false;
        level.name = "";
        level.properties = new MondrianGuiDef.Property[0];
        level.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newLevel.title", "New Level"), (Object[])hierarchy.levels);
        MondrianGuiDef.Level[] temp = hierarchy.levels;
        hierarchy.levels = new MondrianGuiDef.Level[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            hierarchy.levels[i] = temp[i];
        }
        hierarchy.levels[hierarchy.levels.length - 1] = level;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)level));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addSQL(ActionEvent evt) {
        Object current = this.tree.getSelectionPath().getLastPathComponent();
        if (!(current instanceof MondrianGuiDef.ExpressionView) && !(current instanceof MondrianGuiDef.View)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.sqlExpressionNotSelected.alert", "Expression or View for SQL not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.SQL sql = new MondrianGuiDef.SQL();
        sql.dialect = "generic";
        if (current instanceof MondrianGuiDef.ExpressionView) {
            MondrianGuiDef.ExpressionView expview = (MondrianGuiDef.ExpressionView)((Object)current);
            MondrianGuiDef.SQL[] temp = expview.expressions;
            expview.expressions = new MondrianGuiDef.SQL[temp.length + 1];
            for (int i = 0; i < temp.length; ++i) {
                expview.expressions[i] = temp[i];
            }
            expview.expressions[expview.expressions.length - 1] = sql;
        } else {
            MondrianGuiDef.View view = (MondrianGuiDef.View)((Object)current);
            MondrianGuiDef.SQL[] temp = view.selects;
            view.selects = new MondrianGuiDef.SQL[temp.length + 1];
            for (int i = 0; i < temp.length; ++i) {
                view.selects[i] = temp[i];
            }
            view.selects[view.selects.length - 1] = sql;
        }
        this.tree.setSelectionPath(this.tree.getSelectionPath().pathByAddingChild((Object)sql));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addFilter(ActionEvent evt) {
        Object current = this.tree.getSelectionPath().getLastPathComponent();
        if (!(current instanceof MondrianGuiDef.Table)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.tableNotSelectedFor SQL.alert", "Table not selected for Filter SQL."), alert, 2);
            return;
        }
        MondrianGuiDef.SQL sql = new MondrianGuiDef.SQL();
        sql.dialect = "generic";
        MondrianGuiDef.Table table = (MondrianGuiDef.Table)((Object)current);
        table.filter = sql;
        this.tree.setSelectionPath(this.tree.getSelectionPath().pathByAddingChild((Object)sql));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addKeyExp(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Level.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.Level)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.levelNotSelected.alert", "Level not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)pathReference.parent);
        MondrianGuiDef.KeyExpression keyExp = new MondrianGuiDef.KeyExpression();
        keyExp.expressions = new MondrianGuiDef.SQL[1];
        keyExp.expressions[0] = new MondrianGuiDef.SQL();
        keyExp.expressions[0].dialect = "generic";
        keyExp.expressions[0].cdata = "";
        level.keyExp = keyExp;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)keyExp));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addNameExp(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Level.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.Level)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.levelNotSelected.alert", "Level not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)pathReference.parent);
        MondrianGuiDef.NameExpression nameExp = new MondrianGuiDef.NameExpression();
        nameExp.expressions = new MondrianGuiDef.SQL[1];
        nameExp.expressions[0] = new MondrianGuiDef.SQL();
        nameExp.expressions[0].dialect = "generic";
        nameExp.expressions[0].cdata = "";
        level.nameExp = nameExp;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)nameExp));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addOrdinalExp(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Level.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.Level)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.levelNotSelected.alert", "Level not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)pathReference.parent);
        MondrianGuiDef.OrdinalExpression ordinalExp = new MondrianGuiDef.OrdinalExpression();
        ordinalExp.expressions = new MondrianGuiDef.SQL[1];
        ordinalExp.expressions[0] = new MondrianGuiDef.SQL();
        ordinalExp.expressions[0].dialect = "generic";
        ordinalExp.expressions[0].cdata = "";
        level.ordinalExp = ordinalExp;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)ordinalExp));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addParentExp(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Level.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.Level)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.levelNotSelected.alert", "Level not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)pathReference.parent);
        MondrianGuiDef.ParentExpression parentExp = new MondrianGuiDef.ParentExpression();
        parentExp.expressions = new MondrianGuiDef.SQL[1];
        parentExp.expressions[0] = new MondrianGuiDef.SQL();
        parentExp.expressions[0].dialect = "generic";
        parentExp.expressions[0].cdata = "";
        level.parentExp = parentExp;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)parentExp));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addMeasureExp(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Measure.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.Measure)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.measureNotSelected.alert", "Measure not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Measure measure = (MondrianGuiDef.Measure)((Object)pathReference.parent);
        MondrianGuiDef.MeasureExpression measureExp = new MondrianGuiDef.MeasureExpression();
        measureExp.expressions = new MondrianGuiDef.SQL[1];
        measureExp.expressions[0] = new MondrianGuiDef.SQL();
        measureExp.expressions[0].dialect = "generic";
        measureExp.expressions[0].cdata = "";
        measure.measureExp = measureExp;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)measureExp));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addFormula(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.NamedSet.class);
        if (pathReference.parent == null) {
            pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.CalculatedMember.class);
        }
        if (!(pathReference.parent instanceof MondrianGuiDef.NamedSet) && !(pathReference.parent instanceof MondrianGuiDef.CalculatedMember)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.namedsetOrCalcMemberNotSelected.alert", "Named Set or Calculated Member not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Formula formulaElement = new MondrianGuiDef.Formula();
        formulaElement.cdata = "";
        if (pathReference.parent instanceof MondrianGuiDef.NamedSet) {
            MondrianGuiDef.NamedSet ns = (MondrianGuiDef.NamedSet)((Object)pathReference.parent);
            ns.formulaElement = formulaElement;
            if (ns.formula != null && ns.formula.trim().length() != 0) {
                ns.formulaElement.cdata = ns.formula;
                ns.formula = null;
            }
        } else if (pathReference.parent instanceof MondrianGuiDef.CalculatedMember) {
            MondrianGuiDef.CalculatedMember cm = (MondrianGuiDef.CalculatedMember)((Object)pathReference.parent);
            cm.formulaElement = formulaElement;
            if (cm.formula != null && cm.formula.trim().length() != 0) {
                cm.formulaElement.cdata = cm.formula;
                cm.formula = null;
            }
        }
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)formulaElement));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addCalculatedMemberProperty(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Measure.class);
        if (pathReference.parent == null) {
            pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.CalculatedMember.class);
        }
        if (pathReference.parent instanceof MondrianGuiDef.CalculatedMember) {
            this.addCalculatedMemberProperty((MondrianGuiDef.CalculatedMember)((Object)pathReference.parent), pathReference);
        } else if (pathReference.parent instanceof MondrianGuiDef.Measure) {
            this.addCalculatedMemberProperty((MondrianGuiDef.Measure)((Object)pathReference.parent), pathReference);
        } else {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.calculatedMemberNotSelected.alert", "Calculated Member or Measure not selected."), alert, 2);
        }
    }

    protected void addCalculatedMemberProperty(MondrianGuiDef.CalculatedMember calculatedMember, ParentInPath pathReference) {
        MondrianGuiDef.CalculatedMemberProperty property = new MondrianGuiDef.CalculatedMemberProperty();
        property.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newProperty.title", "New Property"), (Object[])calculatedMember.memberProperties);
        property.expression = "";
        property.value = "";
        property.caption = "";
        MondrianGuiDef.CalculatedMemberProperty[] temp = calculatedMember.memberProperties;
        calculatedMember.memberProperties = new MondrianGuiDef.CalculatedMemberProperty[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            calculatedMember.memberProperties[i] = temp[i];
        }
        calculatedMember.memberProperties[calculatedMember.memberProperties.length - 1] = property;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)property));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addCalculatedMemberProperty(MondrianGuiDef.Measure measure, ParentInPath pathReference) {
        MondrianGuiDef.CalculatedMemberProperty property = new MondrianGuiDef.CalculatedMemberProperty();
        property.name = "";
        if (measure.memberProperties == null) {
            measure.memberProperties = new MondrianGuiDef.CalculatedMemberProperty[0];
        }
        property.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newProperty.title", "New Property"), (Object[])measure.memberProperties);
        property.expression = "";
        property.value = "";
        property.caption = "";
        MondrianGuiDef.CalculatedMemberProperty[] temp = measure.memberProperties;
        measure.memberProperties = new MondrianGuiDef.CalculatedMemberProperty[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            measure.memberProperties[i] = temp[i];
        }
        measure.memberProperties[measure.memberProperties.length - 1] = property;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)property));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addTable(ActionEvent evt) {
        MondrianGuiDef.Table relation = new MondrianGuiDef.Table("", LBL_TABLE, "", null);
        this.addRelation(evt, relation);
    }

    protected void addTable(ActionEvent evt, MondrianGuiDef.Join join, boolean rightHandElement) {
        MondrianGuiDef.Table relation = new MondrianGuiDef.Table("", LBL_TABLE, "", null);
        this.addRelation(evt, relation, join, rightHandElement);
    }

    protected void addJoin(ActionEvent evt) {
        this.addRelation(evt, new MondrianGuiDef.Join());
    }

    protected void addJoin(ActionEvent evt, MondrianGuiDef.Join join, boolean rightHandElement) {
        this.addRelation(evt, new MondrianGuiDef.Join(), join, rightHandElement);
    }

    protected void addView(ActionEvent evt) {
        MondrianGuiDef.View view = new MondrianGuiDef.View();
        view.alias = "";
        view.selects = new MondrianGuiDef.SQL[1];
        view.selects[0] = new MondrianGuiDef.SQL();
        view.selects[0].dialect = "generic";
        view.selects[0].cdata = "";
        this.addRelation(evt, view);
    }

    protected void addView(ActionEvent evt, MondrianGuiDef.Join join, boolean rightHandElement) {
        MondrianGuiDef.View view = new MondrianGuiDef.View();
        view.alias = "";
        view.selects = new MondrianGuiDef.SQL[1];
        view.selects[0] = new MondrianGuiDef.SQL();
        view.selects[0].dialect = "generic";
        view.selects[0].cdata = "";
        this.addRelation(evt, view, join, rightHandElement);
    }

    protected void addInlineTable(ActionEvent evt) {
        MondrianGuiDef.InlineTable inlineTable = new MondrianGuiDef.InlineTable();
        inlineTable.alias = "";
        inlineTable.columnDefs = new MondrianGuiDef.ColumnDefs();
        inlineTable.columnDefs.array = new MondrianGuiDef.ColumnDef[0];
        inlineTable.rows = new MondrianGuiDef.Rows();
        inlineTable.rows.array = new MondrianGuiDef.Row[0];
        this.addRelation(evt, inlineTable);
    }

    protected void addInlineTable(ActionEvent evt, MondrianGuiDef.Join join, boolean rightHandElement) {
        MondrianGuiDef.InlineTable inlineTable = new MondrianGuiDef.InlineTable();
        inlineTable.alias = "";
        inlineTable.columnDefs = new MondrianGuiDef.ColumnDefs();
        inlineTable.columnDefs.array = new MondrianGuiDef.ColumnDef[0];
        inlineTable.rows = new MondrianGuiDef.Rows();
        inlineTable.rows.array = new MondrianGuiDef.Row[0];
        this.addRelation(evt, inlineTable, join, rightHandElement);
    }

    protected void addRelation(ActionEvent evt, MondrianGuiDef.RelationOrJoin relation) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Hierarchy.class);
        if (pathReference.parent == null) {
            pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Cube.class);
        }
        if (pathReference.parent instanceof MondrianGuiDef.Hierarchy) {
            MondrianGuiDef.Hierarchy h = (MondrianGuiDef.Hierarchy)((Object)pathReference.parent);
            h.relation = relation;
        } else if (pathReference.parent instanceof MondrianGuiDef.Cube) {
            if (!(relation instanceof MondrianGuiDef.Relation)) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.relationOrJoinNotRelation.alert", "Can't add a Join."), alert, 2);
                return;
            }
            MondrianGuiDef.Cube cube = (MondrianGuiDef.Cube)((Object)pathReference.parent);
            cube.fact = (MondrianGuiDef.Relation)relation;
        } else {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.hierarchyOrCubeNotSelected.alert", "Hierarchy or Cube not selected."), alert, 2);
            return;
        }
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)relation));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addRelation(ActionEvent evt, MondrianGuiDef.RelationOrJoin relation, MondrianGuiDef.Join join, boolean rightHandElement) {
        if (rightHandElement) {
            join.right = relation;
        } else {
            join.left = relation;
        }
        TreePath tpath = this.tree.getSelectionPath();
        this.tree.setSelectionPath(tpath.pathByAddingChild((Object)relation));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addHierarchy(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Dimension.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.Dimension)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.dimensionNotSelected.alert", "Dimension not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Dimension dimension = (MondrianGuiDef.Dimension)((Object)pathReference.parent);
        MondrianGuiDef.Hierarchy hierarchy = new MondrianGuiDef.Hierarchy();
        hierarchy.name = "";
        hierarchy.hasAll = Boolean.TRUE;
        hierarchy.levels = new MondrianGuiDef.Level[0];
        hierarchy.memberReaderParameters = new MondrianGuiDef.MemberReaderParameter[0];
        hierarchy.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newHierarchy.title", "New Hierarchy"), (Object[])dimension.hierarchies);
        MondrianGuiDef.Hierarchy[] temp = dimension.hierarchies;
        dimension.hierarchies = new MondrianGuiDef.Hierarchy[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            dimension.hierarchies[i] = temp[i];
        }
        dimension.hierarchies[dimension.hierarchies.length - 1] = hierarchy;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)hierarchy));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addProperty(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Level.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.Level)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.levelNotSelected.alert", "Level not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)pathReference.parent);
        MondrianGuiDef.Property property = new MondrianGuiDef.Property();
        property.name = "";
        if (level.properties == null) {
            level.properties = new MondrianGuiDef.Property[0];
        }
        property.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newProperty.title", "New Property"), (Object[])level.properties);
        MondrianGuiDef.Property[] temp = level.properties;
        level.properties = new MondrianGuiDef.Property[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            level.properties[i] = temp[i];
        }
        level.properties[level.properties.length - 1] = property;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)property));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addColumnDef(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.ColumnDefs.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.ColumnDefs)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.inlineTableColumnDefsNotSelected.alert", "Inline table column definitions not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.ColumnDefs columnDefs = (MondrianGuiDef.ColumnDefs)((Object)pathReference.parent);
        if (columnDefs.array == null) {
            columnDefs.array = new MondrianGuiDef.ColumnDef[0];
        }
        MondrianGuiDef.ColumnDef columnDef = new MondrianGuiDef.ColumnDef();
        columnDef.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newColumnDef.title", "New Column Definition"), (Object[])columnDefs.array);
        columnDef.type = "String";
        MondrianGuiDef.ColumnDef[] temp = columnDefs.array;
        columnDefs.array = new MondrianGuiDef.ColumnDef[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            columnDefs.array[i] = temp[i];
        }
        columnDefs.array[columnDefs.array.length - 1] = columnDef;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)columnDef));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addRow(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Rows.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.Rows)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.inlineTableRowsNotSelected.alert", "Inline table rows not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Rows rows = (MondrianGuiDef.Rows)((Object)pathReference.parent);
        if (rows.array == null) {
            rows.array = new MondrianGuiDef.Row[0];
        }
        MondrianGuiDef.Row row = new MondrianGuiDef.Row();
        row.values = new MondrianGuiDef.Value[0];
        MondrianGuiDef.Row[] temp = rows.array;
        rows.array = new MondrianGuiDef.Row[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            rows.array[i] = temp[i];
        }
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addRowValue(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Row.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.Row)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.rowNotSelected.alert", "Row not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Row row = (MondrianGuiDef.Row)((Object)pathReference.parent);
        if (row.values == null) {
            row.values = new MondrianGuiDef.Value[0];
        }
        MondrianGuiDef.Value value = new MondrianGuiDef.Value();
        value.column = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newValueColumn.title", "New Value Column Name"), (Object[])row.values);
        value.cdata = "";
        MondrianGuiDef.Value[] temp = row.values;
        row.values = new MondrianGuiDef.Value[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            row.values[i] = temp[i];
        }
        row.values[row.values.length - 1] = value;
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)value));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addClosure(ActionEvent evt) {
        ParentInPath pathReference = ParentInPath.getParentOfSelection(this.tree, MondrianGuiDef.Level.class);
        if (!(pathReference.parent instanceof MondrianGuiDef.Level)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.levelNotSelected.alert", "Level not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)pathReference.parent);
        MondrianGuiDef.Closure closure = new MondrianGuiDef.Closure();
        closure.parentColumn = "";
        closure.childColumn = "";
        closure.table = new MondrianGuiDef.Table("", LBL_TABLE, "", null);
        if (level.closure == null) {
            level.closure = closure;
        }
        this.tree.setSelectionPath(SchemaExplorer.getParentPath(this.tree.getSelectionPath(), pathReference.pathIndex).pathByAddingChild((Object)closure));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    public static TreePath getParentPath(TreePath treePath, int parentIndex) {
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = treePath.getPathComponent(i);
        }
        return new TreePath(parentPathObjs);
    }

    public MondrianGuiDef.Schema getSchema() {
        return this.schema;
    }

    public MondrianGuiDef.Schema getSchemaCopy() {
        MondrianGuiDef.Schema s = null;
        StringWriter result = new StringWriter();
        XMLOutput out = new XMLOutput((Writer)result);
        out.setAlwaysQuoteCData(true);
        out.setIndentString("  ");
        this.getSchema().displayXML(out);
        try {
            Parser xmlParser = XOMUtil.createDefaultParser();
            s = new MondrianGuiDef.Schema(xmlParser.parse(out.toString()));
            return s;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOGGER.error((Object)("Exception  : Schema copy failed." + ex.getMessage()), (Throwable)ex);
            this.setErrMsg(this.getResourceConverter().getFormattedString("schemaExplorer.copy.error", "Copy Error: {0}", ex.getLocalizedMessage()));
            return this.getEmptySchema();
        }
    }

    public File getSchemaFile() {
        return this.schemaFile;
    }

    public void setSchemaFile(File f) {
        this.schemaFile = f;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        SchemaPropertyCellEditor sce;
        if (this.propertyTable.isEditing() && this.lastSelected != e.getPath().getLastPathComponent() && (sce = (SchemaPropertyCellEditor)this.propertyTable.getCellEditor()) != null) {
            TreeSelectionEvent e2 = e;
            sce.stopCellEditing();
            e = e2;
        }
        this.lastSelected = e.getPath().getLastPathComponent();
        String selectedFactTable = null;
        String selectedFactTableSchema = null;
        for (int i = e.getPath().getPathCount() - 1; i >= 0; --i) {
            Object comp = e.getPath().getPathComponent(i);
            if (!(comp instanceof MondrianGuiDef.Cube)) continue;
            MondrianGuiDef.Cube cube = (MondrianGuiDef.Cube)((Object)comp);
            if (!(cube.fact instanceof MondrianGuiDef.Table)) continue;
            MondrianGuiDef.Table table = (MondrianGuiDef.Table)cube.fact;
            selectedFactTable = table.name;
            selectedFactTableSchema = table.schema;
        }
        TreePath tpath = e.getPath();
        Object o = tpath.getLastPathComponent();
        Object po = null;
        TreePath parentTpath = tpath.getParentPath();
        Class<?> parentClass = null;
        String parentName = "";
        String elementName = "";
        if (parentTpath != null) {
            po = parentTpath.getLastPathComponent();
            parentClass = po.getClass();
            try {
                Field nameField = po.getClass().getField("name");
                elementName = (String)nameField.get(po);
                elementName = elementName == null ? "" : "'" + elementName + "'";
            }
            catch (Exception ex) {
                elementName = "";
            }
            int pos = parentClass.toString().lastIndexOf("$");
            if (pos > 0) {
                parentName = parentClass.toString().substring(pos + 1);
            }
        }
        StringWriter sxml = new StringWriter();
        XMLOutput pxml = new XMLOutput((Writer)sxml);
        pxml.setIndentString("    ");
        pxml.setAlwaysQuoteCData(true);
        String[] pNames = DEF_DEFAULT;
        this.validStatusLabel.setText(this.renderer.invalid(this.tree, e.getPath(), o));
        this.validStatusLabel2.setText(this.validStatusLabel.getText());
        if (o instanceof MondrianGuiDef.Column) {
            pNames = DEF_COLUMN;
            this.targetLabel.setText(this.getResourceConverter().getString("common.column.title", LBL_COLUMN));
        } else if (o instanceof MondrianGuiDef.Cube) {
            pNames = DEF_CUBE;
            this.targetLabel.setText(this.getResourceConverter().getString("common.cube.title", LBL_CUBE));
            ((MondrianGuiDef.Cube)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Dimension) {
            pNames = DEF_DIMENSION;
            if (po instanceof MondrianGuiDef.Schema) {
                this.targetLabel.setText(this.getResourceConverter().getString("common.sharedDimension.title", "Shared Dimension"));
            } else {
                this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.dimensionElementParent.title", "Dimension for {0} {1}", elementName, parentName));
            }
            ((MondrianGuiDef.Dimension)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.DimensionUsage) {
            pNames = DEF_DIMENSION_USAGE;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.dimensionUsageForElement.title", "Dimension Usage for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.DimensionUsage)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.KeyExpression) {
            pNames = DEF_DEFAULT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.keyExpression.title", LBL_KEY_EXPRESSION));
            ((MondrianGuiDef.ExpressionView)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.NameExpression) {
            pNames = DEF_DEFAULT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.nameExpression.title", LBL_NAME_EXPRESSION));
            ((MondrianGuiDef.ExpressionView)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.OrdinalExpression) {
            pNames = DEF_DEFAULT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.ordinalExpression.title", LBL_ORDINAL_EXPRESSION));
            ((MondrianGuiDef.ExpressionView)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.ParentExpression) {
            pNames = DEF_DEFAULT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.parentExpression.title", LBL_PARENT_EXPRESSION));
            ((MondrianGuiDef.ExpressionView)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.ExpressionView) {
            pNames = DEF_EXPRESSION_VIEW;
            this.targetLabel.setText(this.getResourceConverter().getString("common.expressionView.title", LBL_EXPRESSION_VIEW));
            ((MondrianGuiDef.ExpressionView)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.MeasureExpression) {
            pNames = DEF_DEFAULT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.measureExpression.title", LBL_MEASURE_EXPRESSION));
            ((MondrianGuiDef.ExpressionView)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Hierarchy) {
            pNames = DEF_HIERARCHY;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.hierarchyElementParent.title", "Hierarchy for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.Hierarchy)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Join) {
            pNames = DEF_JOIN;
            if (po instanceof MondrianGuiDef.Join) {
                MondrianGuiDef.Join parentJoin = (MondrianGuiDef.Join)((Object)parentTpath.getLastPathComponent());
                if (parentJoin.left != null && parentJoin.left == o) {
                    this.targetLabel.setText(this.getResourceConverter().getString("common.leftJoin.title", "Left : Join"));
                } else {
                    this.targetLabel.setText(this.getResourceConverter().getString("common.rightJoin.title", "Right : Join"));
                }
            } else {
                this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.generalJoinForElement.title", "Join for {0} {1}", elementName, parentName));
            }
            ((MondrianGuiDef.Join)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Level) {
            pNames = DEF_LEVEL;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.levelForElement.title", "Level for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.Level)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Measure) {
            pNames = DEF_MEASURE;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.measureForElement.title", "Measure for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.Measure)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.CalculatedMember) {
            pNames = DEF_CALCULATED_MEMBER;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.calculatedMemberForElement.title", "Calculated Member for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.CalculatedMember)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.CalculatedMemberProperty) {
            pNames = DEF_CALCULATED_MEMBER_PROPERTY;
            this.targetLabel.setText(this.getResourceConverter().getString("common.calculatedMemberProperty.title", LBL_CALCULATED_MEMBER_PROPERTY));
            ((MondrianGuiDef.CalculatedMemberProperty)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.NamedSet) {
            pNames = DEF_NAMED_SET;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.namedSetForElement.title", "Named Set for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.NamedSet)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Formula) {
            pNames = DEF_FORMULA;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.formulaForElement.title", "Formula for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.Formula)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.UserDefinedFunction) {
            pNames = DEF_USER_DEFINED_FUNCTION;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.userDefinedFunctionForElement.title", "User Defined Function for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.UserDefinedFunction)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.MemberReaderParameter) {
            pNames = DEF_PARAMETER;
            this.targetLabel.setText(this.getResourceConverter().getString("common.parameter.title", LBL_PARAMETER));
        } else if (o instanceof MondrianGuiDef.Property) {
            pNames = DEF_PROPERTY;
            this.targetLabel.setText(this.getResourceConverter().getString("common.property.title", LBL_PROPERTY));
            ((MondrianGuiDef.Property)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Closure) {
            pNames = DEF_CLOSURE;
            this.targetLabel.setText(this.getResourceConverter().getString("common.closure.title", LBL_CLOSURE));
            ((MondrianGuiDef.Closure)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Schema) {
            pNames = DEF_SCHEMA;
            this.targetLabel.setText(this.getResourceConverter().getString("common.schema.title", LBL_SCHEMA));
            ((MondrianGuiDef.Schema)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.SQL) {
            pNames = DEF_SQL;
            if (po instanceof MondrianGuiDef.Table) {
                this.targetLabel.setText(this.getResourceConverter().getString("common.filter.title", LBL_FILTER));
            } else {
                this.targetLabel.setText(this.getResourceConverter().getString("common.sql.title", LBL_SQL));
            }
            ((MondrianGuiDef.SQL)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Table) {
            pNames = DEF_TABLE;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.tableForElement.title", "Table for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.Table)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Hint) {
            pNames = DEF_HINT;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.tableHintForElement.title", "Table Hint for {0}", elementName));
            ((MondrianGuiDef.Hint)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.InlineTable) {
            pNames = DEF_INLINE_TABLE;
            this.targetLabel.setText(this.getResourceConverter().getString("common.inline.table.title", LBL_INLINE_TABLE));
            ((MondrianGuiDef.InlineTable)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.ColumnDef) {
            pNames = DEF_INLINE_TABLE_COLUMN_DEF;
            this.targetLabel.setText(this.getResourceConverter().getString("common.inline.table.columnDef.title", LBL_INLINE_TABLE_COLUMN_DEF));
            ((MondrianGuiDef.ColumnDef)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.ColumnDefs) {
            this.targetLabel.setText(this.getResourceConverter().getString("common.inline.table.columnDefs.title", LBL_INLINE_TABLE_COLUMN_DEFS));
            ((MondrianGuiDef.ColumnDefs)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Row) {
            this.targetLabel.setText(this.getResourceConverter().getString("common.inline.table.row.title", LBL_INLINE_TABLE_ROW));
            ((MondrianGuiDef.Row)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Rows) {
            this.targetLabel.setText(this.getResourceConverter().getString("common.inline.table.rows.title", LBL_INLINE_TABLE_ROWS));
            ((MondrianGuiDef.Rows)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Value) {
            pNames = DEF_INLINE_TABLE_ROW_VALUE;
            this.targetLabel.setText(this.getResourceConverter().getString("common.inline.table.row.value.title", LBL_INLINE_TABLE_ROW_VALUE));
            ((MondrianGuiDef.Value)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggName) {
            pNames = DEF_AGG_NAME;
            this.targetLabel.setText(this.getResourceConverter().getString("common.aggName.title", LBL_AGG_NAME));
            ((MondrianGuiDef.AggName)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggIgnoreColumn) {
            pNames = DEF_AGG_IGNORE_COLUMN;
            this.targetLabel.setText(this.getResourceConverter().getString("common.aggIgnoreColumn.title", LBL_AGG_IGNORE_COLUMN));
            ((MondrianGuiDef.AggIgnoreColumn)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggForeignKey) {
            pNames = DEF_AGG_FOREIGN_KEY;
            this.targetLabel.setText(this.getResourceConverter().getString("common.aggForeignKey.title", LBL_AGG_FOREIGN_KEY));
            ((MondrianGuiDef.AggForeignKey)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggMeasure) {
            pNames = DEF_AGG_MEASURE;
            this.targetLabel.setText(this.getResourceConverter().getString("common.aggMeasure.title", LBL_AGG_MEASURE));
            ((MondrianGuiDef.AggMeasure)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggLevel) {
            pNames = DEF_AGG_LEVEL;
            this.targetLabel.setText(this.getResourceConverter().getString("common.aggLevel.title", LBL_AGG_LEVEL));
            ((MondrianGuiDef.AggLevel)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggExclude) {
            pNames = DEF_AGG_EXCLUDE;
            this.targetLabel.setText(this.getResourceConverter().getString("common.aggExclude.title", LBL_AGG_EXCLUDE));
            ((MondrianGuiDef.AggExclude)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggPattern) {
            pNames = DEF_AGG_PATTERN;
            this.targetLabel.setText(this.getResourceConverter().getString("common.aggPattern.title", LBL_AGG_PATTERN));
            ((MondrianGuiDef.AggPattern)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggFactCount) {
            pNames = DEF_AGG_FACT_COUNT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.aggFactCount.title", LBL_AGG_FACT_COUNT));
            ((MondrianGuiDef.AggFactCount)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.View) {
            pNames = DEF_VIEW;
            this.targetLabel.setText(this.getResourceConverter().getString("common.view.title", LBL_VIEW));
            ((MondrianGuiDef.View)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Role) {
            pNames = DEF_ROLE;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.roleElementParent.title", "Role for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.Role)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Parameter) {
            pNames = DEF_PARAMETER_SCHEMA;
            this.targetLabel.setText(this.getResourceConverter().getString("common.schemaParameter.title", LBL_PARAMETER_SCHEMA));
            ((MondrianGuiDef.Parameter)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.SchemaGrant) {
            pNames = DEF_SCHEMA_GRANT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.schemaGrant.title", LBL_SCHEMA_GRANT));
            ((MondrianGuiDef.SchemaGrant)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.CubeGrant) {
            pNames = DEF_CUBE_GRANT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.cubeGrant.title", LBL_CUBE_GRANT));
            ((MondrianGuiDef.CubeGrant)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.DimensionGrant) {
            pNames = DEF_DIMENSION_GRANT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.dimensionGrant.title", LBL_DIMENSION_GRANT));
            ((MondrianGuiDef.DimensionGrant)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.HierarchyGrant) {
            pNames = DEF_HIERARCHY_GRANT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.hierarchyGrant.title", LBL_HIERARCHY_GRANT));
            ((MondrianGuiDef.HierarchyGrant)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.MemberGrant) {
            pNames = DEF_MEMBER_GRANT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.memberGrant.title", LBL_MEMBER_GRANT));
            ((MondrianGuiDef.MemberGrant)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Union) {
            pNames = DEF_UNION;
            this.targetLabel.setText(this.getResourceConverter().getString("common.union.title", LBL_UNION));
            ((MondrianGuiDef.Union)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.RoleUsage) {
            pNames = DEF_ROLE_USAGE;
            MondrianGuiDef.RoleUsage usage = (MondrianGuiDef.RoleUsage)((Object)o);
            if (usage.roleName == null || usage.roleName.trim().length() == 0) {
                this.targetLabel.setText(this.getResourceConverter().getString("common.roleUsage.title", LBL_ROLE_USAGE));
            } else {
                this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.roleUsage.title", "Role Usage: {0}", usage.roleName));
            }
            usage.displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.VirtualCube) {
            pNames = DEF_VIRTUAL_CUBE;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.virtualCubeElementParent.title", "Virtual Cube for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.VirtualCube)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.VirtualCubeDimension) {
            pNames = DEF_VIRTUAL_CUBE_DIMENSION;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.virtualCubeDimensionElementParent.title", "Virtual Cube Dimension for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.VirtualCubeDimension)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.VirtualCubeMeasure) {
            pNames = DEF_VIRTUAL_CUBE_MEASURE;
            this.targetLabel.setText(this.getResourceConverter().getString("common.virtualCubeMeasure.title", LBL_VIRTUAL_CUBE_MEASURE));
            ((MondrianGuiDef.VirtualCubeMeasure)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Annotations) {
            pNames = DEF_ANNOTATIONS;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.annotations.title", "Annotations for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.Annotations)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Annotation) {
            pNames = DEF_ANNOTATION;
            this.targetLabel.setText(this.getResourceConverter().getString("common.annotation.title", LBL_ANNOTATION));
            ((MondrianGuiDef.Annotation)((Object)o)).displayXML(pxml, 0);
        } else {
            this.targetLabel.setText(this.getResourceConverter().getString("common.unknownType.title", LBL_UNKNOWN_TYPE));
        }
        try {
            this.jEditorPaneXML.read(new StringReader(sxml.toString()), null);
            this.jEditorPaneXML.getDocument().putProperty("tabSize", new Integer(2));
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.targetLabel2.setText(this.targetLabel.getText());
        PropertyTableModel ptm = new PropertyTableModel(this.workbench, o, tpath, pNames);
        ptm.setFactTable(selectedFactTable);
        ptm.setFactTableSchema(selectedFactTableSchema);
        Object parent = null;
        int i = e.getPath().getPathCount() - 1 - 1;
        if (i >= 0) {
            parent = e.getPath().getPathComponent(i);
        }
        if (parent != null) {
            Field[] fs = parent.getClass().getFields();
            ArrayList<String> names = new ArrayList<String>();
            for (int i2 = 0; i2 < fs.length; ++i2) {
                if (!fs[i2].getType().isArray() || !fs[i2].getType().getComponentType().isInstance(o)) continue;
                try {
                    Field fname = fs[i2].getType().getComponentType().getField("name");
                    Object objs = fs[i2].get(parent);
                    for (int j = 0; j < Array.getLength(objs); ++j) {
                        Object child = Array.get(objs, j);
                        String vname = (String)fname.get(child);
                        names.add(vname);
                    }
                    ptm.setNames(names);
                }
                catch (Exception ex) {}
                break;
            }
        }
        this.propertyTable.setModel(ptm);
        this.propertyTable.getColumnModel().getColumn(0).setMaxWidth(150);
        this.propertyTable.getColumnModel().getColumn(0).setMinWidth(150);
        for (i = 0; i < this.propertyTable.getRowCount(); ++i) {
            TableCellRenderer tcRenderer = this.propertyTable.getCellRenderer(i, 1);
            Component comp = tcRenderer.getTableCellRendererComponent(this.propertyTable, this.propertyTable.getValueAt(i, 1), false, false, i, 1);
            try {
                int height = comp.getMaximumSize().height;
                this.propertyTable.setRowHeight(i, height);
                continue;
            }
            catch (Exception ea) {
                // empty catch block
            }
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.updater.update();
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        this.setDirty(true);
        this.setTitle();
        String emsg = ((PropertyTableModel)this.propertyTable.getModel()).getErrorMsg();
        if (emsg != null) {
            JOptionPane.showMessageDialog(this, emsg, "Error", 0);
            ((PropertyTableModel)this.propertyTable.getModel()).setErrorMsg(null);
        }
        this.updater.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void conNameListActionPerformed(ActionEvent evt, Object parentIf) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (evt.getActionCommand().equals("comboBoxChanged")) {
                JComboBox cb = (JComboBox)evt.getSource();
                String conName = PreferencesDialog.getConnectionNameFromListName((String)cb.getSelectedItem());
                if (conName == null) {
                    return;
                }
                Workbench.ConnectionDetails conDetails = this.workbench.getConnectionDetailsMap().get(conName);
                if (conDetails != null) {
                    this.jdbcMetaData = new JdbcMetaData(this.workbench, conDetails);
                    this.renderer.setJdbcMetaData(this.jdbcMetaData);
                    ((SchemaPropertyCellEditor)this.propertyTable.getDefaultEditor(Object.class)).setJdbcMetaData(this.jdbcMetaData);
                    this.refreshTree(this.tree.getSelectionPath(), true);
                    if (this.jdbcMetaData.getErrMsg() != null && ((JInternalFrame)parentIf).isSelected()) {
                        JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("workbench.open.schema.jdbc.error", "Database connection could not be done.\n{0}\nAll validations related to database will be ignored.", this.jdbcMetaData.getErrMsg()), this.getResourceConverter().getString("workbench.open.schema.jdbc.error.title", "Alert"), 2);
                    }
                    this.updateDatabaseLabel(this.jdbcMetaData);
                    this.jdbcConnectionName = conName;
                }
            }
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public JInternalFrame getParentIFrame() {
        return this.parentIFrame;
    }

    public boolean isNewFile() {
        return this.newFile;
    }

    public void setNewFile(boolean newFile) {
        this.newFile = newFile;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setRelationOrJoinMenu(JMenu pm, MondrianGuiDef.Join join, boolean rightHandElement, boolean enabled) {
        pm.add(this.addTableAction(join, rightHandElement, enabled));
        pm.add(this.addJoinAction(join, rightHandElement, enabled));
    }

    private AbstractAction addTableAction(MondrianGuiDef.Join join, boolean rightHandElement, boolean enabled) {
        final MondrianGuiDef.Join fJoin = join;
        final boolean fRightHandElement = rightHandElement;
        AbstractAction action = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addTable.title", "Add Table")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addTable(e, fJoin, fRightHandElement);
            }
        };
        if (!enabled) {
            action.setEnabled(false);
        }
        return action;
    }

    private AbstractAction addJoinAction(MondrianGuiDef.Join join, boolean rightHandElement, boolean enabled) {
        final MondrianGuiDef.Join fJoin = join;
        final boolean fRightHandElement = rightHandElement;
        AbstractAction action = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addJoin.title", "Add Join")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addJoin(e, fJoin, fRightHandElement);
            }
        };
        if (!enabled) {
            action.setEnabled(false);
        }
        return action;
    }

    private AbstractAction addViewAction(final MondrianGuiDef.Join join, final boolean rightHandElement, boolean enabled) {
        AbstractAction action = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addView.title", "Add View")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addView(e, join, rightHandElement);
            }
        };
        if (!enabled) {
            action.setEnabled(false);
        }
        return action;
    }

    private AbstractAction addInlineTableAction(final MondrianGuiDef.Join join, final boolean rightHandElement, boolean enabled) {
        AbstractAction action = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addInlineTable.title", "Add Inline Table")){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addInlineTable(e, join, rightHandElement);
            }
        };
        if (!enabled) {
            action.setEnabled(false);
        }
        return action;
    }

    public void setTitle() {
        this.parentIFrame.setTitle(this.getResourceConverter().getFormattedString("schemaExplorer.frame.title", "Schema - {0} ({1}){2}", this.schema.name, this.schemaFile.getName(), this.isDirty() ? "*" : ""));
        this.parentIFrame.setToolTipText(this.schemaFile.toString());
    }

    public Object getParentObject() {
        TreePath tPath = this.tree.getSelectionPath();
        if (tPath != null && tPath.getParentPath() != null) {
            return tPath.getParentPath().getLastPathComponent();
        }
        return null;
    }

    public Object getCurrentObject() {
        TreePath tPath = this.tree.getSelectionPath();
        if (tPath != null) {
            return tPath.getLastPathComponent();
        }
        return null;
    }

    public TreePath getCurrentPath() {
        return this.tree.getSelectionPath();
    }

    public String getJdbcConnectionUrl() {
        return this.jdbcMetaData.jdbcConnectionUrl;
    }

    public String getJdbcUsername() {
        return this.jdbcMetaData.jdbcUsername;
    }

    public String getJdbcPassword() {
        return this.jdbcMetaData.jdbcPassword;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String msg) {
        this.errMsg = msg;
    }

    public boolean isEditModeXML() {
        return this.editModeXML;
    }

    public I18n getResourceConverter() {
        return this.workbench.getResourceConverter();
    }

    public void updateConNameList(Map<String, Workbench.ConnectionDetails> conDetailsMap, String selectName) {
        PreferencesDialog.regenerateConnectionNames(conDetailsMap, this.conNameList, selectName, -1);
    }

    public String getJdbcConnectionName() {
        return this.jdbcConnectionName;
    }

    private void updateDatabaseLabel(JdbcMetaData jdbcMetaData) {
        if (jdbcMetaData.getDbCatalogName() == null) {
            this.databaseLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.database.text", "Database: <u>{0}</u>  ", jdbcMetaData.getDatabaseProductName()));
        } else {
            this.databaseLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.databaseUrl.text", "Database: <u>{0}</u>  Url: {1}", jdbcMetaData.getDatabaseProductName(), jdbcMetaData.getJdbcConnectionUrl()));
        }
    }

    public static void getTableNamesForJoin(MondrianGuiDef.RelationOrJoin aRelOrJoin, Set<String> aTableNames) {
        if (aRelOrJoin instanceof MondrianGuiDef.Join) {
            MondrianGuiDef.RelationOrJoin theRelOrJoin_L = ((MondrianGuiDef.Join)aRelOrJoin).left;
            MondrianGuiDef.RelationOrJoin theRelOrJoin_R = ((MondrianGuiDef.Join)aRelOrJoin).right;
            for (int i = 0; i < 2; ++i) {
                MondrianGuiDef.RelationOrJoin theCurrentRelOrJoin;
                MondrianGuiDef.RelationOrJoin relationOrJoin = theCurrentRelOrJoin = i == 0 ? theRelOrJoin_L : theRelOrJoin_R;
                if (theCurrentRelOrJoin == null) {
                    return;
                }
                if (theCurrentRelOrJoin instanceof MondrianGuiDef.Table) {
                    MondrianGuiDef.Table theTable = (MondrianGuiDef.Table)theCurrentRelOrJoin;
                    String theTableName = theTable.alias != null && theTable.alias.trim().length() > 0 ? theTable.alias : theTable.name;
                    aTableNames.add(theTableName);
                    continue;
                }
                SchemaExplorer.getTableNamesForJoin(theCurrentRelOrJoin, aTableNames);
            }
        }
    }

    public static String[] getTableNameForAlias(MondrianGuiDef.RelationOrJoin aRelOrJoin, String anAlias) {
        String theTableName = anAlias;
        String schemaName = null;
        if (aRelOrJoin instanceof MondrianGuiDef.Join) {
            MondrianGuiDef.RelationOrJoin theRelOrJoin_L = ((MondrianGuiDef.Join)aRelOrJoin).left;
            MondrianGuiDef.RelationOrJoin theRelOrJoin_R = ((MondrianGuiDef.Join)aRelOrJoin).right;
            for (int i = 0; i < 2; ++i) {
                MondrianGuiDef.RelationOrJoin theCurrentRelOrJoin;
                MondrianGuiDef.RelationOrJoin relationOrJoin = theCurrentRelOrJoin = i == 0 ? theRelOrJoin_L : theRelOrJoin_R;
                if (theCurrentRelOrJoin instanceof MondrianGuiDef.Table) {
                    MondrianGuiDef.Table theTable = (MondrianGuiDef.Table)theCurrentRelOrJoin;
                    if ((theTable.alias == null || !theTable.alias.equals(anAlias)) && (theTable.name == null || !theTable.name.equals(anAlias))) continue;
                    theTableName = theTable.name;
                    schemaName = theTable.schema;
                    continue;
                }
                String[] result = SchemaExplorer.getTableNameForAlias(theCurrentRelOrJoin, anAlias);
                schemaName = result[0];
                theTableName = result[1];
            }
        }
        return new String[]{schemaName, theTableName};
    }

    public void resetJdbcMetaData(JdbcMetaData aMetaData) {
        this.jdbcMetaData = aMetaData;
        String theLabel = this.getResourceConverter().getFormattedString("schemaExplorer.database.text", "Database - {0} ({1})", this.jdbcMetaData.getDbCatalogName(), this.jdbcMetaData.getDatabaseProductName());
        this.databaseLabel.setText(theLabel);
        this.renderer.setJdbcMetaData(aMetaData);
        TableCellEditor theTableCellEditor = this.propertyTable.getDefaultEditor(Object.class);
        if (theTableCellEditor instanceof SchemaPropertyCellEditor) {
            ((SchemaPropertyCellEditor)theTableCellEditor).setJdbcMetaData(aMetaData);
        }
    }

    public JTreeUpdater getTreeUpdater() {
        return this.updater;
    }

    class PopupTrigger
    extends MouseAdapter {
        PopupTrigger() {
        }

        public void mousePressed(MouseEvent e) {
            this.showMenu(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.showMenu(e);
        }

        public void showMenu(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int x = e.getX();
                int y = e.getY();
                TreePath path = SchemaExplorer.this.tree.getPathForLocation(x, y);
                SchemaExplorer.this.tree.setSelectionPath(path);
                if (path != null) {
                    SchemaExplorer.this.jPopupMenu.removeAll();
                    Object pathSelected = path.getLastPathComponent();
                    if (pathSelected instanceof MondrianGuiDef.Schema) {
                        MondrianGuiDef.Schema s = (MondrianGuiDef.Schema)((Object)pathSelected);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addCube);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addDimension);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addNamedSet);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addUserDefinedFunction);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addVirtualCube);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addRole);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addParameter);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotation);
                    } else if (pathSelected instanceof MondrianGuiDef.Cube) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addDimension);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addDimensionUsage);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addMeasure);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addCalculatedMember);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addNamedSet);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addTable);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addView);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addInlineTable);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator2);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotation);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator3);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                        if (((MondrianGuiDef.Cube)((Object)pathSelected)).fact == null) {
                            SchemaExplorer.this.addMeasure.setEnabled(false);
                            SchemaExplorer.this.addCalculatedMember.setEnabled(false);
                            SchemaExplorer.this.addTable.setEnabled(true);
                            SchemaExplorer.this.addView.setEnabled(true);
                            SchemaExplorer.this.addInlineTable.setEnabled(true);
                        } else {
                            SchemaExplorer.this.addMeasure.setEnabled(true);
                            SchemaExplorer.this.addCalculatedMember.setEnabled(true);
                            SchemaExplorer.this.addTable.setEnabled(false);
                            SchemaExplorer.this.addView.setEnabled(false);
                            SchemaExplorer.this.addInlineTable.setEnabled(false);
                        }
                    } else if (pathSelected instanceof MondrianGuiDef.Dimension) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addHierarchy);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotation);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.Hierarchy) {
                        MondrianGuiDef.RelationOrJoin relation = ((MondrianGuiDef.Hierarchy)((Object)pathSelected)).relation;
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addLevel);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addTable);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addJoin);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addView);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addInlineTable);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator2);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotation);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator3);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                        if (relation == null) {
                            ParentInPath pathReference = ParentInPath.getParentOfSelection(SchemaExplorer.this.tree, MondrianGuiDef.Cube.class);
                            if (pathReference.parent != null) {
                                SchemaExplorer.this.addLevel.setEnabled(true);
                            } else {
                                SchemaExplorer.this.addLevel.setEnabled(false);
                            }
                            SchemaExplorer.this.addTable.setEnabled(true);
                            SchemaExplorer.this.addJoin.setEnabled(true);
                            SchemaExplorer.this.addView.setEnabled(true);
                            SchemaExplorer.this.addInlineTable.setEnabled(true);
                        } else {
                            SchemaExplorer.this.addLevel.setEnabled(true);
                            SchemaExplorer.this.addTable.setEnabled(false);
                            SchemaExplorer.this.addJoin.setEnabled(false);
                            SchemaExplorer.this.addView.setEnabled(false);
                            SchemaExplorer.this.addInlineTable.setEnabled(false);
                        }
                    } else if (pathSelected instanceof MondrianGuiDef.Level) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addProperty);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addKeyExp);
                        MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)pathSelected);
                        if (level.keyExp == null) {
                            SchemaExplorer.this.addKeyExp.setEnabled(true);
                        } else {
                            SchemaExplorer.this.addKeyExp.setEnabled(false);
                        }
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addNameExp);
                        if (level.nameExp == null) {
                            SchemaExplorer.this.addNameExp.setEnabled(true);
                        } else {
                            SchemaExplorer.this.addNameExp.setEnabled(false);
                        }
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addOrdinalExp);
                        if (level.ordinalExp == null) {
                            SchemaExplorer.this.addOrdinalExp.setEnabled(true);
                        } else {
                            SchemaExplorer.this.addOrdinalExp.setEnabled(false);
                        }
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addParentExp);
                        if (level.parentExp == null) {
                            SchemaExplorer.this.addParentExp.setEnabled(true);
                        } else {
                            SchemaExplorer.this.addParentExp.setEnabled(false);
                        }
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addClosure);
                        if (level.closure == null) {
                            SchemaExplorer.this.addClosure.setEnabled(true);
                        } else {
                            SchemaExplorer.this.addClosure.setEnabled(false);
                        }
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotation);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator2);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.KeyExpression || pathSelected instanceof MondrianGuiDef.NameExpression || pathSelected instanceof MondrianGuiDef.OrdinalExpression || pathSelected instanceof MondrianGuiDef.ParentExpression || pathSelected instanceof MondrianGuiDef.ExpressionView || pathSelected instanceof MondrianGuiDef.View) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addSQL);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.Join) {
                        MondrianGuiDef.Join join = (MondrianGuiDef.Join)((Object)pathSelected);
                        SchemaExplorer.this.jLeftMenu.removeAll();
                        SchemaExplorer.this.jRightMenu.removeAll();
                        SchemaExplorer.this.jLeftMenu.setText(SchemaExplorer.this.getResourceConverter().getString("common.left.title", "Left"));
                        SchemaExplorer.this.setRelationOrJoinMenu(SchemaExplorer.this.jLeftMenu, join, false, join.left == null);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jLeftMenu);
                        SchemaExplorer.this.jRightMenu.setText(SchemaExplorer.this.getResourceConverter().getString("common.right.title", "Right"));
                        SchemaExplorer.this.setRelationOrJoinMenu(SchemaExplorer.this.jRightMenu, join, true, join.right == null);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jRightMenu);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.InlineTable) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.RelationOrJoin) {
                        Object po = path.getParentPath().getLastPathComponent();
                        if (!(po instanceof MondrianGuiDef.Closure) && po instanceof MondrianGuiDef.Cube) {
                            SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggName);
                            SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggPattern);
                            SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggExclude);
                            SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        }
                        if (pathSelected instanceof MondrianGuiDef.Table) {
                            if (((MondrianGuiDef.Table)((Object)pathSelected)).filter == null) {
                                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addFilter);
                            }
                            SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addHint);
                            SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator2);
                        }
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.Measure) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addMeasureExp);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addCalculatedMemberProperty);
                        if (((MondrianGuiDef.Measure)((Object)pathSelected)).measureExp == null) {
                            SchemaExplorer.this.addMeasureExp.setEnabled(true);
                        } else {
                            SchemaExplorer.this.addMeasureExp.setEnabled(false);
                        }
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotation);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator2);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.NamedSet) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addFormula);
                        if (((MondrianGuiDef.NamedSet)((Object)pathSelected)).formulaElement == null) {
                            SchemaExplorer.this.addFormula.setEnabled(true);
                        } else {
                            SchemaExplorer.this.addFormula.setEnabled(false);
                        }
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotation);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator2);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.CalculatedMember) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addFormula);
                        if (((MondrianGuiDef.CalculatedMember)((Object)pathSelected)).formulaElement == null) {
                            SchemaExplorer.this.addFormula.setEnabled(true);
                        } else {
                            SchemaExplorer.this.addFormula.setEnabled(false);
                        }
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addCalculatedMemberProperty);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotation);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator2);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.MeasureExpression) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addSQL);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotation);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator2);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.Closure) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.AggName || pathSelected instanceof MondrianGuiDef.AggPattern) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggFactCount);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggIgnoreColumn);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggForeignKey);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggMeasure);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggLevel);
                        if (pathSelected instanceof MondrianGuiDef.AggPattern) {
                            SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggExclude);
                            if (((MondrianGuiDef.AggPattern)((Object)pathSelected)).factcount == null) {
                                SchemaExplorer.this.addAggFactCount.setEnabled(true);
                            } else {
                                SchemaExplorer.this.addAggFactCount.setEnabled(false);
                            }
                        } else if (((MondrianGuiDef.AggName)((Object)pathSelected)).factcount == null) {
                            SchemaExplorer.this.addAggFactCount.setEnabled(true);
                        } else {
                            SchemaExplorer.this.addAggFactCount.setEnabled(false);
                        }
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.VirtualCube) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addVirtualCubeDimension);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addVirtualCubeMeasure);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addCalculatedMember);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotation);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.VirtualCubeMeasure) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotation);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.Role) {
                        MondrianGuiDef.Role r = (MondrianGuiDef.Role)((Object)pathSelected);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addSchemaGrant);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotation);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator2);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.Union) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addRoleUsage);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.RoleUsage) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.SchemaGrant) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addCubeGrant);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.CubeGrant) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addDimensionGrant);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addHierarchyGrant);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.VirtualCubeMeasure) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotation);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.HierarchyGrant) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addMemberGrant);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.ColumnDefs) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addColumnDef);
                    } else if (pathSelected instanceof MondrianGuiDef.Row) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addRowValue);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else if (pathSelected instanceof MondrianGuiDef.Rows) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addRow);
                    } else if (pathSelected instanceof MondrianGuiDef.SQL) {
                        Object po = path.getParentPath().getLastPathComponent();
                        boolean allowDelete = false;
                        if (po instanceof MondrianGuiDef.ExpressionView) {
                            MondrianGuiDef.ExpressionView exp = (MondrianGuiDef.ExpressionView)((Object)po);
                            allowDelete = exp.expressions.length > 1;
                        } else if (po instanceof MondrianGuiDef.View) {
                            MondrianGuiDef.View view = (MondrianGuiDef.View)((Object)po);
                            allowDelete = view.selects.length > 1;
                        } else if (po instanceof MondrianGuiDef.Table) {
                            allowDelete = true;
                        }
                        if (allowDelete) {
                            SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                        }
                    } else if (pathSelected instanceof MondrianGuiDef.Annotation) {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotation);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    } else {
                        SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                    }
                    SchemaExplorer.this.jPopupMenu.show(SchemaExplorer.this.tree, x, y);
                }
            }
        }
    }
}

