/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import mondrian.gui.I18n;
import mondrian.gui.JdbcMetaData;
import mondrian.gui.PreferencesDialog;
import mondrian.gui.Workbench;

public class PreferencesSchemasDialog
extends JDialog {
    PreferencesDialog preferences = null;
    JdbcMetaData jdbcMetadata = null;
    String selectedSchemaString = null;
    boolean accepted = false;
    private JButton cancelButton;
    private JButton okButton;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public PreferencesSchemasDialog() {
        this.initComponents();
    }

    public PreferencesSchemasDialog(PreferencesDialog preferences, JdbcMetaData jdbcMetadata) {
        this.preferences = preferences;
        this.jdbcMetadata = jdbcMetadata;
        this.initComponents();
        this.setVisible(true);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PreferencesSchemasDialog.this.closeDialog(evt);
            }
        });
        this.jTable1.setModel(this.getSchemaTableModel());
        this.jTable1.setRowSelectionAllowed(false);
        TableColumn col = this.jTable1.getColumnModel().getColumn(0);
        col.setPreferredWidth(15);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.add((Component)this.jScrollPane1, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.cancelButton.setText(this.getResourceConverter().getString("preferences.cancelButton.title", "Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesSchemasDialog.this.closeDialog(evt);
            }
        });
        buttonPanel.add(this.cancelButton);
        this.okButton.setText(this.getResourceConverter().getString("preferences.okButton.title", "OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesSchemasDialog.this.acceptButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(this.okButton);
        this.add((Component)buttonPanel, "South");
        Workbench.setPreferredSizeMaxXY(this.okButton, this.cancelButton);
        this.setSize(300, 300);
        this.setLocationRelativeTo(this.preferences);
        this.setModal(true);
    }

    private void acceptButtonActionPerformed(ActionEvent evt) {
        TableModel tm = this.jTable1.getModel();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tm.getRowCount(); ++i) {
            Boolean selected = (Boolean)tm.getValueAt(i, 0);
            if (!selected.booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append((String)tm.getValueAt(i, 1));
        }
        this.selectedSchemaString = sb.toString();
        this.accepted = true;
        this.closeDialog();
    }

    private void closeDialog(WindowEvent evt) {
        this.closeDialog();
    }

    private void closeDialog(ActionEvent evt) {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public TableModel getSchemaTableModel() {
        int i;
        List<String> allSchemaNames = this.jdbcMetadata.listAllSchemas();
        String currentSchemas = this.preferences.getDatabaseSchema();
        boolean[] selectedSchemas = new boolean[allSchemaNames.size()];
        Arrays.fill(selectedSchemas, false);
        if (currentSchemas != null && currentSchemas.trim().length() > 0) {
            String[] schemasArray = currentSchemas.trim().split("[,;]");
            block0: for (i = 0; i < schemasArray.length; ++i) {
                String enteredSchemaName = schemasArray[i].trim();
                if (enteredSchemaName.length() <= 0) continue;
                for (int j = 0; j < allSchemaNames.size(); ++j) {
                    String actualSchemaName = allSchemaNames.get(j);
                    if (!actualSchemaName.equalsIgnoreCase(enteredSchemaName)) continue;
                    selectedSchemas[j] = true;
                    continue block0;
                }
            }
        }
        Object[][] table = new Object[allSchemaNames.size()][2];
        for (i = 0; i < allSchemaNames.size(); ++i) {
            table[i][0] = new Boolean(selectedSchemas[i]);
            table[i][1] = allSchemaNames.get(i);
        }
        return new DefaultTableModel(table, new String[]{this.getResourceConverter().getString("preferences.select.title", "Select"), this.getResourceConverter().getString("preferences.aSchema.title", "Schema")}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Boolean.class, String.class};
                this.canEdit = new boolean[]{true, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        };
    }

    public I18n getResourceConverter() {
        return this.preferences.getResourceConverter();
    }
}

